<?php 
/*Plugin Name: WPTutsPlus Advanced use of attachments in WordPress Part 1 - Taxonomies
Plugin URI: http://rachelmccollin.co.uk
Description: This plugin supports the tutorial in wptutsplus. It creates two taxomomies for attachments.
Version: 1.0
Author: Rachel McCollin
Author URI: http://rachelmccollin.com
License: GPLv2
*/


/******************************************************************************
Register the taxonomies
******************************************************************************/

function wptp_register_attachments_tax() {

	/* register the document catgeories taxonomy */
	register_taxonomy( 'document-category', 'attachment',
		array(
			'labels' =>  array(
				'name'              => 'Document Categories',
				'singular_name'     => 'Document Category',
				'search_items'      => 'Search Document Categories',
				'all_items'         => 'All Document Categories',
				'edit_item'         => 'Edit Document Categories',
				'update_item'       => 'Update Document Category',
				'add_new_item'      => 'Add New Document Category',
				'new_item_name'     => 'New Document Category Name',
				'menu_name'         => 'Document Category',
			),
			'hierarchical' => true,
			'sort' => true,
			'show_admin_column' => true
		)
	);
	
	/* register the gallery categories taxonomy */
	register_taxonomy( 'gallery-category', 'attachment',
		array(
			'labels' =>  array(
				'name'              => 'Gallery Categories',
				'singular_name'     => 'Gallery Category',
				'search_items'      => 'Search Gallery Categories',
				'all_items'         => 'All Gallery Categories',
				'edit_item'         => 'Edit Gallery Categories',
				'update_item'       => 'Update Gallery Category',
				'add_new_item'      => 'Add New Gallery Category',
				'new_item_name'     => 'New Gallery Category Name',
				'menu_name'         => 'Gallery Category',
			),
			'hierarchical' => true,
			'sort' => true,
			'show_admin_column' => true
		)
	);

}

/* hook our taxonomies into wordpress */
add_action( 'init', 'wptp_register_attachments_tax', 0 );
?>