<?php
/*********************************************************************
Advanced use of attachments in WordPress
Functions for theme to display attachments in custom templates
*******************************************************************/

// add attachments to the main query using parse_query
function wptutsplus_add_attachments_to_tax_query() {

    global $wp_query;

    // When inside a custom taxonomy archive include attachments
    if ( is_tax( array( 'document-category', 'gallery-category' ) ) ) {
        $wp_query->query_vars['post_type'] =  array( 'attachment' );
        $wp_query->query_vars['post_status'] =  array( null );

        return $wp_query;
    }

}
add_action('parse_query', 'wptutsplus_add_attachments_to_tax_query');

?>