<?php
/*
WpTutsPlus tutorial for creating archive to display posts by mutiple taxonomy terms
Archive template for habitat taxonomy
*/
?>

<?php get_header(); ?>

<?php
// get the currently queried taxonomy term, for use later in the template file
$habitat = get_queried_object();
?>

	<div id="main-content" class="main-content">

	<div id="primary" class="content-area">
		<div id="content" class="site-content" role="main">

<header class="archive-header">
	<h1 class="archive-title">
		Habitat - <?php echo $habitat->name; ?>
	</h1>
</header><!-- .archive-header -->

<?php //start by fetching the terms for the animal_cat taxonomy
$terms = get_terms( 'animal_cat', array(
	'hide_empty' => 0
) );
?>

<?php
// now run a query for each animal family
foreach( $terms as $term ) {

	// Define the query
	$args = array(
		'post_type' => 'animal',
		'animal_cat' => $term->slug,
		'habitat' => $habitat->slug
	);
	$query = new WP_Query( $args );
	
	if( $query->have_posts() ) {
		
		// output the term name in a heading tag				
		echo'<h2>' . $term->name . ' family</h2>';
		
		// output the post titles in a list
		echo '<ul>';
		
			// Start the Loop
			while ( $query->have_posts() ) : $query->the_post(); ?>
	
			<li class="animal-listing" id="post-<?php the_ID(); ?>">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</li>
			
			<?php endwhile;
		
		echo '</ul>';
	}
			
	
	
	// use reset postdata to restore orginal query
	wp_reset_postdata();

} ?>
			
		</div><!-- #content -->
	</div><!-- #primary -->
	<?php get_sidebar( 'content' ); ?>
</div><!-- #main-content -->

<?php
get_sidebar();
get_footer();