<?php
/*
code to accompany wptutsplus tutorial on creating an custom taxonomy archive in WordPress
the code in this functions file registers a custom post type and taxonomy which will be used for the tutorial.
It's good practice to create a plugin to register post types as then your post type isn't lost if the user changes themes 
- here it's in the functions file so it can be included with the tutorial's code bundle more easily.
*/

// register a custom post type called 'animals'
function wptp_create_post_type() {
	$labels = array( 
		'name' => __( 'Animals' ),
		'singular_name' => __( 'animal' ),
		'add_new' => __( 'New animal' ),
		'add_new_item' => __( 'Add New animal' ),
		'edit_item' => __( 'Edit animal' ),
		'new_item' => __( 'New animal' ),
		'view_item' => __( 'View animal' ),
		'search_items' => __( 'Search animals' ),
		'not_found' =>  __( 'No animals Found' ),
		'not_found_in_trash' => __( 'No animals found in Trash' ),
	);
	$args = array(
		'labels' => $labels,
		'has_archive' => true,
		'public' => true,
		'hierarchical' => false,
		'supports' => array(
			'title', 
			'editor', 
			'excerpt', 
			'custom-fields', 
			'thumbnail',
			'page-attributes'
		),
		'taxonomies' => array( 'post_tag', 'category'), 
	);
	register_post_type( 'animal', $args );
} 
add_action( 'init', 'wptp_create_post_type' );

// register taxonomies
function wptp_register_taxonomies() {
	
	// register a taxonomy called 'Animal Family'
	register_taxonomy( 'animal_cat', 'animal',
		array(
			'labels' => array(
				'name'              => 'Animal Families',
				'singular_name'     => 'Animal Family',
				'search_items'      => 'Search Animal Families',
				'all_items'         => 'All Animal Families',
				'edit_item'         => 'Edit Animal Families',
				'update_item'       => 'Update Animal Family',
				'add_new_item'      => 'Add New Animal Family',
				'new_item_name'     => 'New Animal Family Name',
				'menu_name'         => 'Animal Family',
			),
			'hierarchical' => true,
			'sort' => true,
			'args' => array( 'orderby' => 'term_order' ),
			'rewrite' => array( 'slug' => 'animal-family' ),
			'show_admin_column' => true
		)
	);
	
	// register a taxonomy called 'Habitat'
	register_taxonomy( 'habitat', 'animal',
		array(
			'labels' => array(
				'name'              => 'Habitats',
				'singular_name'     => 'Habitat',
				'search_items'      => 'Search Habitats',
				'all_items'         => 'All Habitats',
				'edit_item'         => 'Edit Habitat',
				'update_item'       => 'Update Habitat',
				'add_new_item'      => 'Add New Habitat',
				'new_item_name'     => 'New Habitat Name',
				'menu_name'         => 'Habitat',
			),
			'hierarchical' => true,
			'sort' => true,
			'args' => array( 'orderby' => 'term_order' ),
			'show_admin_column' => true
		)
	);
}
add_action( 'init', 'wptp_register_taxonomies' );
?>
