<?php
/*
  Plugin Name: Tuts+ Social Profile Widget
  Plugin URI: http://code.tutsplus.com
  Description: Social widget that links to various social media profiles
  Author: Agbonghama Collins
  Author URI: http://tech4sky.com
 */

/**
 * Adds Tutsplus_Social_Profile widget.
 */
class Tutsplus_Social_Profile extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct(
                'Tutsplus_Social_Profile', __('Social Networks Profiles', 'translation_domain'), // Name
                array('description' => __('Links to Author social media profile', 'translation_domain'),)
        );
    }

    public function twitter_count( $username ) {
        require_once 'TwitterAPIExchange.php';
		
        /** Set access tokens here - see: https://dev.twitter.com/apps/ * */
        $settings = array(
            'oauth_access_token' => "211978035-fedllb5xEQhnoHxAsK3259VIOhsFrLuRUyR4Atvr",
            'oauth_access_token_secret' => "7Nev2EyOxoHAVgb8Y5VHPRYuKbKomFqe3kf1ouOHtmHVs",
            'consumer_key' => "MsHrMc5B9dZyP8mgqV0m2JGsq",
            'consumer_secret' => "YhIdWozaAb9cvKcjKqamEcN2GgSBrzqfWZpIvKSeYVvCQsb8LL"
        );

        $url = 'https://api.twitter.com/1.1/users/show.json';
        $getfield = '?screen_name=' . $username;
        $request_method = 'GET';
        $twitter_instance = new TwitterAPIExchange( $settings );
        $follow_count = $twitter_instance->setGetfield( $getfield )
                ->buildOauth($url, $request_method)
                ->performRequest();
        $count = json_decode( $follow_count, true );
        return $count['followers_count'];
    }

    public function facebook_count( $username ) {
        $facebook_count = file_get_contents( 'http://graph.facebook.com/' . $username );
        return json_decode( $facebook_count )->likes;
    }

    public function googleplus_count( $username, $apikey = 'AIzaSyBHm7J9qLupabYWaxLg_9_UZPbxWdso2vY' ) {
        $google = file_get_contents('https://www.googleapis.com/plus/v1/people/' . $username . '?key=' . $apikey );
        return json_decode($google)->circledByCount;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {

        $title = apply_filters('widget_title', $instance['title']);
        $facebook = $instance['facebook'];
        $twitter = $instance['twitter'];
        $google = $instance['google'];

        // social profile link
        $social_widget = '
        <ul class="diverz">
			<li class="diverz facebookz">
			<a href="https://www.facebook.com/' . $facebook . '">
				<div class="main-diverz">
				<i class="facebookz fa fa-facebook"></i>
				<br/>
					<big class="spanz facebookz">facebook</big>
				</div>
				</a>
				<div class="sub-diverz">
				<strong>' .
                $this->facebook_count( $facebook ) . '</strong>
                <br/>fans
				</div>
				</li>
				
				<li class="diverz twitterz">
			<a href="https://www.twitter.com/' . $twitter . '">
				<div class="main-diverz">
				<i class="twitterz fa fa-twitter"></i><br/>
					<big class="spanz twitterz">twitter</big>
				</div></a>
				<div class="sub-diverz"><strong>' .
                $this->twitter_count('tech4sky') . '</strong><br/>fans
				</div>
				</li>
				
				<li class="diverz googlez">
			<a href="https://plus.google.com/u/0/' . $google . '">
				<div class="main-diverz">
				<i class="googlez fa fa-google-plus"></i><br/>
					<big class="spanz googlez">google+</big>
				</div></a>
				<div class="sub-diverz"><strong>' .
                $this->googleplus_count( $google ) . '</strong><br/>fans
				</div>
				</li>
		</ul>';
		
        echo $args['before_widget'];

        if ( !empty($title) ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        echo $social_widget;
		
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        isset( $instance['title'] ) ? $title = $instance['title'] : null;
        empty ($instance['title'] ) ? $title = 'My Social Profile' : null;

        isset( $instance['facebook'] ) ? $facebook = $instance['facebook'] : null;
        isset( $instance['twitter'] ) ? $twitter = $instance['twitter'] : null;
        isset( $instance['google'] ) ? $google = $instance['google'] : null;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('facebook'); ?>"><?php _e('Facebook Page Username:'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('facebook'); ?>" type="text" value="<?php echo esc_attr($facebook); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('twitter'); ?>"><?php _e('Twitter Username:'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('twitter'); ?>" name="<?php echo $this->get_field_name('twitter'); ?>" type="text" value="<?php echo esc_attr($twitter); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('google'); ?>"><?php _e('Google+ Username or ID:'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('google'); ?>" name="<?php echo $this->get_field_name('google'); ?>" type="text" value="<?php echo esc_attr($google); ?>">
        </p>

    <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( !empty($new_instance['title']) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['facebook'] = ( !empty($new_instance['facebook']) ) ? strip_tags( $new_instance['facebook'] ) : '';
        $instance['twitter'] = ( !empty($new_instance['twitter']) ) ? strip_tags( $new_instance['twitter'] ) : '';
        $instance['google'] = ( !empty($new_instance['google']) ) ? strip_tags( $new_instance['google'] ) : '';
        $instance['linkedin'] = ( !empty($new_instance['linkedin']) ) ? strip_tags( $new_instance['linkedin'] ) : '';

        return $instance;
    }

}

// register Tutsplus_Social_Profile widget
function register_tutsplus_social_profile() {
    register_widget('Tutsplus_Social_Profile');
}

add_action('widgets_init', 'register_tutsplus_social_profile');

// enqueue css stylesheet
function tutsplus_social_profile_widget_css() {
    wp_enqueue_style( 'social-profile-widget', plugins_url('tutsplus-social-profile-widget.css', __FILE__) );
}

add_action('wp_enqueue_scripts', 'tutsplus_social_profile_widget_css');
