<?php
/*
Plugin Name: Buy Now Plugin
Plugin URI: http://www.samberson.com/
Description: Simple PayPal Buy Now plugin
Version: 1.0
Author: Sam Berson
Author URI: http://www.samberson.com/
Text Domain: buynow-plugin
*/

function buynow($atts) {
$buynow_options = get_option('buynow_plugin_options');

	$atts = shortcode_atts(array(
							'amount'   => '50',
							'currency' => 'USD',
							'size'	   => 'LG'

						   ), $atts);

	extract($atts);


	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
    			<div class="paypal-donations">
			        <input type="hidden" name="cmd" value="_xclick">
			        <input type="hidden" name="business" value="'.$buynow_options['paypal_user_id'].'">
			        <input type="hidden" name="amount" value="'.$amount.'">
			        <input type="hidden" name="rm" value="0">
			        <input type="hidden" name="currency_code" value="'.$currency.'">
			        <input type="image" src="https://www.paypal.com/en_US/i/btn/btn_buynow_'.$size.'.gif" name="submit" alt="' . __('PayPal - The safer, easier way to pay online.', 'buynow-plugin') . '">
			        <img alt="" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
			    </div>
			</form>';
}
add_shortcode('buy_now', 'buynow');

function buynow_cb() {

}


function paypal_user_id_html() {
	$buynow_options = get_option('buynow_plugin_options');
	echo "<input name='buynow_plugin_options[paypal_user_id]' type='email' value='{$buynow_options['paypal_user_id']}'/>";
}



function register_settings_fields() {

	register_setting('buynow_plugin_options', 'buynow_plugin_options');

	add_settings_section( 'buynow_plugin_main_section', __('Main Settings', 'buynow-plugin'), 'buynow_cb', __FILE__ );

	add_settings_field('paypal_user_id', __('PayPal ID', 'buynow-plugin'),'paypal_user_id_html', __FILE__, 'buynow_plugin_main_section');
}

add_action('admin_init', 'register_settings_fields');




// Generate HTML of main options page
function options_page_html() {

	?>
		<div class="wrap">
			<h2>Plugin Options</h2>
			<form method="post" action="options.php" enctype="multipart/form-data">
			<?php 
				// $option_group
				settings_fields( 'buynow_plugin_options' );

				// $page 
				do_settings_sections( __FILE__ );
			?>	
			<p class="submit">
				<input type="submit" class="button-primary" name="submit" value="<?php _e('Save Changes', 'buynow-plugin'); ?>">
			</p>
			</form>
		</div>
	<?php
}



// Admin Menu Action Hook
function options_init() {

	// page_title,  menu_title, capability, menu_slug, function
	add_options_page(__('Buy Now Plugin Options', 'buynow-plugin'), __('Buy Now Plugin Options', 'buynow-plugin'), 'administrator', __FILE__, 'options_page_html');
}
add_action('admin_menu', 'options_init');



// Activation Hook. Check if settings exists, if not register defaults.
function buynow_activate() {
	$defaults = array(
					'amount' => '50',
					'currency' => 'USD',
					'size' => 'SM'
				);	

  if(get_option('buynow_plugin_options')) return;

  add_option( 'buynow_plugin_options', $defaults );
}

register_activation_hook( __FILE__, 'buynow_activate' );