/*
 * Copyright (c) 2011-2017 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

/*
 * This file contains CFG functions for processing host messages.
 */
#include "cds_api.h"
#include "ani_global.h"
#include "cfg_priv.h"
#include "wma_types.h"
#include "lim_trace.h"

cgstatic cfg_static[CFG_PARAM_MAX_NUM] = {
	{WNI_CFG_STA_ID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RELOAD,
	0, 255, 1},
	{WNI_CFG_CFP_PERIOD,
	CFG_CTL_VALID  | CFG_CTL_RE | CFG_CTL_INT,
	WNI_CFG_CFP_PERIOD_STAMIN,
	WNI_CFG_CFP_PERIOD_STAMAX,
	WNI_CFG_CFP_PERIOD_STADEF},
	{WNI_CFG_CFP_MAX_DURATION,
	CFG_CTL_VALID  | CFG_CTL_RE | CFG_CTL_INT,
	WNI_CFG_CFP_MAX_DURATION_STAMIN,
	WNI_CFG_CFP_MAX_DURATION_STAMAX,
	WNI_CFG_CFP_MAX_DURATION_STADEF},
	{WNI_CFG_SSID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 255, 6},
	{WNI_CFG_BEACON_INTERVAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_SCH,
	WNI_CFG_BEACON_INTERVAL_STAMIN,
	WNI_CFG_BEACON_INTERVAL_STAMAX,
	WNI_CFG_BEACON_INTERVAL_STADEF},
	{WNI_CFG_DTIM_PERIOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT,
	WNI_CFG_DTIM_PERIOD_STAMIN,
	WNI_CFG_DTIM_PERIOD_STAMAX,
	WNI_CFG_DTIM_PERIOD_STADEF},
	{WNI_CFG_WEP_KEY_LENGTH,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_WEP_KEY_LENGTH_STAMIN,
	WNI_CFG_WEP_KEY_LENGTH_STAMAX,
	WNI_CFG_WEP_KEY_LENGTH_STADEF},
	{WNI_CFG_WEP_DEFAULT_KEY_1,
	CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 65535, 0},
	{WNI_CFG_WEP_DEFAULT_KEY_2,
	CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART,
	1, 1, 1},
	{WNI_CFG_WEP_DEFAULT_KEY_3,
	CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 5, 5},
	{WNI_CFG_WEP_DEFAULT_KEY_4,
	CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 1, 0},
	{WNI_CFG_WEP_DEFAULT_KEYID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WEP_DEFAULT_KEYID_STAMIN,
	WNI_CFG_WEP_DEFAULT_KEYID_STAMAX,
	WNI_CFG_WEP_DEFAULT_KEYID_STADEF},
	{WNI_CFG_EXCLUDE_UNENCRYPTED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_EXCLUDE_UNENCRYPTED_STAMIN,
	WNI_CFG_EXCLUDE_UNENCRYPTED_STAMAX,
	WNI_CFG_EXCLUDE_UNENCRYPTED_STADEF},
	{WNI_CFG_RTS_THRESHOLD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_TARGET,
	WNI_CFG_RTS_THRESHOLD_STAMIN,
	WNI_CFG_RTS_THRESHOLD_STAMAX,
	WNI_CFG_RTS_THRESHOLD_STADEF},
	{WNI_CFG_SHORT_RETRY_LIMIT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_SHORT_RETRY_LIMIT_STAMIN,
	WNI_CFG_SHORT_RETRY_LIMIT_STAMAX,
	WNI_CFG_SHORT_RETRY_LIMIT_STADEF},
	{WNI_CFG_LONG_RETRY_LIMIT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_LONG_RETRY_LIMIT_STAMIN,
	WNI_CFG_LONG_RETRY_LIMIT_STAMAX,
	WNI_CFG_LONG_RETRY_LIMIT_STADEF},
	{WNI_CFG_FRAGMENTATION_THRESHOLD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_TARGET,
	WNI_CFG_FRAGMENTATION_THRESHOLD_STAMIN,
	WNI_CFG_FRAGMENTATION_THRESHOLD_STAMAX,
	WNI_CFG_FRAGMENTATION_THRESHOLD_STADEF},
	{WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMIN,
	WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMAX,
	WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STADEF},
	{WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMIN,
	WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMAX,
	WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STADEF},
	{WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMIN,
	WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMAX,
	WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STADEF},
	{WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMIN,
	WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMAX,
	WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STADEF},
	{WNI_CFG_JOIN_FAILURE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMIN,
	WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMAX,
	WNI_CFG_JOIN_FAILURE_TIMEOUT_STADEF},
	{WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMIN,
	WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMAX,
	WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STADEF},
	{WNI_CFG_AUTHENTICATE_RSP_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMIN,
	WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMAX,
	WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STADEF},
	{WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMIN,
	WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMAX,
	WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STADEF},
	{WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMIN,
	WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMAX,
	WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STADEF},
	{WNI_CFG_PS_ENABLE_BCN_FILTER,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_ENABLE_BCN_FILTER_STAMIN,
	WNI_CFG_PS_ENABLE_BCN_FILTER_STAMAX,
	WNI_CFG_PS_ENABLE_BCN_FILTER_STADEF},
	{WNI_CFG_PS_ENABLE_HEART_BEAT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_ENABLE_HEART_BEAT_STAMIN,
	WNI_CFG_PS_ENABLE_HEART_BEAT_STAMAX,
	WNI_CFG_PS_ENABLE_HEART_BEAT_STADEF},
	{WNI_CFG_PS_ENABLE_RSSI_MONITOR,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMIN,
	WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMAX,
	WNI_CFG_PS_ENABLE_RSSI_MONITOR_STADEF},
	{WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMIN,
	WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMAX,
	WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STADEF},
	{WNI_CFG_RF_SETTLING_TIME_CLK,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RF_SETTLING_TIME_CLK_STAMIN,
	WNI_CFG_RF_SETTLING_TIME_CLK_STAMAX,
	WNI_CFG_RF_SETTLING_TIME_CLK_STADEF},
	{WNI_CFG_SUPPORTED_RATES_11B,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 3, 1},
	{WNI_CFG_SUPPORTED_RATES_11A, CFG_CTL_VALID | CFG_CTL_RE,
	0, 255, 15},
	{WNI_CFG_PHY_MODE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_PHY_MODE_STAMIN,
	WNI_CFG_PHY_MODE_STAMAX,
	WNI_CFG_PHY_MODE_STADEF},
	{WNI_CFG_DOT11_MODE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART |
	CFG_CTL_NTF_LIM,
	WNI_CFG_DOT11_MODE_STAMIN,
	WNI_CFG_DOT11_MODE_STAMAX,
	WNI_CFG_DOT11_MODE_STADEF},
	{WNI_CFG_OPERATIONAL_RATE_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 1, 1},
	{WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 65535, 65534},
	{WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_LISTEN_INTERVAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_LISTEN_INTERVAL_STAMIN,
	WNI_CFG_LISTEN_INTERVAL_STAMAX,
	WNI_CFG_LISTEN_INTERVAL_STADEF},
	{WNI_CFG_VALID_CHANNEL_LIST,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART |
	CFG_CTL_NTF_LIM,
	0, 1, 1},
	{WNI_CFG_CURRENT_CHANNEL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT,
	WNI_CFG_CURRENT_CHANNEL_STAMIN,
	WNI_CFG_CURRENT_CHANNEL_STAMAX,
	WNI_CFG_CURRENT_CHANNEL_STADEF},
	{WNI_CFG_DEFAULT_RATE_INDEX_24GHZ,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMIN,
	WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMAX,
	WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STADEF},
	{WNI_CFG_FIXED_RATE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_FIXED_RATE_STAMIN,
	WNI_CFG_FIXED_RATE_STAMAX,
	WNI_CFG_FIXED_RATE_STADEF},
	{WNI_CFG_APSD_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_APSD_ENABLED_STAMIN,
	WNI_CFG_APSD_ENABLED_STAMAX,
	WNI_CFG_APSD_ENABLED_STADEF},
	{WNI_CFG_SHARED_KEY_AUTH_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMIN,
	WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMAX,
	WNI_CFG_SHARED_KEY_AUTH_ENABLE_STADEF},
	{WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMIN,
	WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMAX,
	WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STADEF},
	{WNI_CFG_AUTHENTICATION_TYPE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_AUTHENTICATION_TYPE_STAMIN,
	WNI_CFG_AUTHENTICATION_TYPE_STAMAX,
	WNI_CFG_AUTHENTICATION_TYPE_STADEF},
	{WNI_CFG_PRIVACY_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_PRIVACY_ENABLED_STAMIN,
	WNI_CFG_PRIVACY_ENABLED_STAMAX,
	WNI_CFG_PRIVACY_ENABLED_STADEF},
	{WNI_CFG_SHORT_PREAMBLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_SHORT_PREAMBLE_STAMIN,
	WNI_CFG_SHORT_PREAMBLE_STAMAX,
	WNI_CFG_SHORT_PREAMBLE_STADEF},
	{WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMIN,
	WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMAX,
	WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STADEF},
	{WNI_CFG_QOS_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_QOS_ENABLED_STAMIN,
	WNI_CFG_QOS_ENABLED_STAMAX,
	WNI_CFG_QOS_ENABLED_STADEF},
	{WNI_CFG_HCF_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_HCF_ENABLED_STAMIN,
	WNI_CFG_HCF_ENABLED_STAMAX,
	WNI_CFG_HCF_ENABLED_STADEF},
	{WNI_CFG_RSN_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_RSN_ENABLED_STAMIN,
	WNI_CFG_RSN_ENABLED_STAMAX,
	WNI_CFG_RSN_ENABLED_STADEF},
	{WNI_CFG_MAX_NUM_PRE_AUTH,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_MAX_NUM_PRE_AUTH_STAMIN,
	WNI_CFG_MAX_NUM_PRE_AUTH_STAMAX,
	WNI_CFG_MAX_NUM_PRE_AUTH_STADEF},
	{WNI_CFG_HEART_BEAT_THRESHOLD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_HEART_BEAT_THRESHOLD_STAMIN,
	WNI_CFG_HEART_BEAT_THRESHOLD_STAMAX,
	WNI_CFG_HEART_BEAT_THRESHOLD_STADEF},
	{WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE |
	CFG_CTL_INT,
	WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMIN,
	WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMAX,
	WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STADEF},
	{WNI_CFG_MANUFACTURER_NAME,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 0, 0},
	{WNI_CFG_MODEL_NUMBER,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 0, 0},
	{WNI_CFG_MODEL_NAME,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 0, 0},
	{WNI_CFG_MANUFACTURER_PRODUCT_NAME,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 0, 0},
	{WNI_CFG_MANUFACTURER_PRODUCT_VERSION,
	CFG_CTL_VALID | CFG_CTL_RE,
	0, 0, 0},
	{WNI_CFG_11D_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_11D_ENABLED_STAMIN,
	WNI_CFG_11D_ENABLED_STAMAX,
	WNI_CFG_11D_ENABLED_STADEF},
	{WNI_CFG_MAX_TX_POWER_2_4,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE,
	0, 0, 0},
	{WNI_CFG_MAX_TX_POWER_5,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE,
	0, 0, 0},
	{WNI_CFG_CURRENT_TX_POWER_LEVEL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMIN,
	WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMAX,
	WNI_CFG_CURRENT_TX_POWER_LEVEL_STADEF},
	{WNI_CFG_NEW_BSS_FOUND_IND,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_NEW_BSS_FOUND_IND_STAMIN,
	WNI_CFG_NEW_BSS_FOUND_IND_STAMAX,
	WNI_CFG_NEW_BSS_FOUND_IND_STADEF},
	{WNI_CFG_COUNTRY_CODE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE,
	0, 0, 0},
	{WNI_CFG_11H_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_11H_ENABLED_STAMIN,
	WNI_CFG_11H_ENABLED_STAMAX,
	WNI_CFG_11H_ENABLED_STADEF},
	{WNI_CFG_WT_CNF_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WT_CNF_TIMEOUT_STAMIN,
	WNI_CFG_WT_CNF_TIMEOUT_STAMAX,
	WNI_CFG_WT_CNF_TIMEOUT_STADEF},
	{WNI_CFG_OLBC_DETECT_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_OLBC_DETECT_TIMEOUT_STAMIN,
	WNI_CFG_OLBC_DETECT_TIMEOUT_STAMAX,
	WNI_CFG_OLBC_DETECT_TIMEOUT_STADEF},
	{WNI_CFG_PROTECTION_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_PROTECTION_ENABLED_STAMIN,
	WNI_CFG_PROTECTION_ENABLED_STAMAX,
	WNI_CFG_PROTECTION_ENABLED_STADEF},
	{WNI_CFG_11G_PROTECTION_ALWAYS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_11G_PROTECTION_ALWAYS_STAMIN,
	WNI_CFG_11G_PROTECTION_ALWAYS_STAMAX,
	WNI_CFG_11G_PROTECTION_ALWAYS_STADEF},
	{WNI_CFG_FORCE_POLICY_PROTECTION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_FORCE_POLICY_PROTECTION_STAMIN,
	WNI_CFG_FORCE_POLICY_PROTECTION_STAMAX,
	WNI_CFG_FORCE_POLICY_PROTECTION_STADEF},
	{WNI_CFG_11G_SHORT_PREAMBLE_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMIN,
	WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMAX,
	WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STADEF},
	{WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMIN,
	WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMAX,
	WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STADEF},
	{WNI_CFG_11G_ONLY_POLICY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_11G_ONLY_POLICY_STAMIN,
	WNI_CFG_11G_ONLY_POLICY_STAMAX,
	WNI_CFG_11G_ONLY_POLICY_STADEF},
	{WNI_CFG_WME_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_WME_ENABLED_STAMIN,
	WNI_CFG_WME_ENABLED_STAMAX,
	WNI_CFG_WME_ENABLED_STADEF},
	{WNI_CFG_ADDTS_RSP_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ADDTS_RSP_TIMEOUT_STAMIN,
	WNI_CFG_ADDTS_RSP_TIMEOUT_STAMAX,
	WNI_CFG_ADDTS_RSP_TIMEOUT_STADEF},
	{WNI_CFG_MAX_SP_LENGTH,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_MAX_SP_LENGTH_STAMIN,
	WNI_CFG_MAX_SP_LENGTH_STAMAX,
	WNI_CFG_MAX_SP_LENGTH_STADEF},
	{WNI_CFG_WSM_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WSM_ENABLED_STAMIN,
	WNI_CFG_WSM_ENABLED_STAMAX,
	WNI_CFG_WSM_ENABLED_STADEF},
	{WNI_CFG_EDCA_PROFILE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_SCH,
	WNI_CFG_EDCA_PROFILE_STAMIN,
	WNI_CFG_EDCA_PROFILE_STAMAX,
	WNI_CFG_EDCA_PROFILE_STADEF},
	{WNI_CFG_EDCA_ANI_ACBK_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACBE_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACVI_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACVO_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACBK,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACBE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACVI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_ANI_ACVO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACBK_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACBE_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACVI_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACVO_LOCAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACBK,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACBE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACVI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_EDCA_WME_ACVO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART,
	0, 0, 0},
	{WNI_CFG_LOCAL_POWER_CONSTRAINT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMIN,
	WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMAX,
	WNI_CFG_LOCAL_POWER_CONSTRAINT_STADEF},
	{WNI_CFG_ADMIT_POLICY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_ADMIT_POLICY_STAMIN,
	WNI_CFG_ADMIT_POLICY_STAMAX,
	WNI_CFG_ADMIT_POLICY_STADEF},
	{WNI_CFG_ADMIT_BWFACTOR,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_ADMIT_BWFACTOR_STAMIN,
	WNI_CFG_ADMIT_BWFACTOR_STAMAX,
	WNI_CFG_ADMIT_BWFACTOR_STADEF},
	{WNI_CFG_CHANNEL_BONDING_MODE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_CHANNEL_BONDING_MODE_STAMIN,
	WNI_CFG_CHANNEL_BONDING_MODE_STAMAX,
	WNI_CFG_CHANNEL_BONDING_MODE_STADEF},
	{WNI_CFG_DYNAMIC_THRESHOLD_ZERO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMIN,
	WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMAX,
	WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STADEF},
	{WNI_CFG_DYNAMIC_THRESHOLD_ONE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMIN,
	WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMAX,
	WNI_CFG_DYNAMIC_THRESHOLD_ONE_STADEF},
	{WNI_CFG_DYNAMIC_THRESHOLD_TWO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMIN,
	WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMAX,
	WNI_CFG_DYNAMIC_THRESHOLD_TWO_STADEF},
	{WNI_CFG_SCAN_CONTROL_LIST,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART |
	CFG_CTL_NTF_LIM,
	0, 0, 0},
	{WNI_CFG_BLOCK_ACK_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_BLOCK_ACK_ENABLED_STAMIN,
	WNI_CFG_BLOCK_ACK_ENABLED_STAMAX,
	WNI_CFG_BLOCK_ACK_ENABLED_STADEF},
	{WNI_CFG_HT_CAP_INFO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_HT_CAP_INFO_STAMIN,
	WNI_CFG_HT_CAP_INFO_STAMAX,
	WNI_CFG_HT_CAP_INFO_STADEF},
	{WNI_CFG_HT_AMPDU_PARAMS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_HT_AMPDU_PARAMS_STAMIN,
	WNI_CFG_HT_AMPDU_PARAMS_STAMAX,
	WNI_CFG_HT_AMPDU_PARAMS_STADEF},
	{WNI_CFG_SUPPORTED_MCS_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	0, 0, 0},
	{WNI_CFG_EXT_HT_CAP_INFO,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_EXT_HT_CAP_INFO_STAMIN,
	WNI_CFG_EXT_HT_CAP_INFO_STAMAX,
	WNI_CFG_EXT_HT_CAP_INFO_STADEF},
	{WNI_CFG_TX_BF_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT | CFG_CTL_RESTART |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TX_BF_CAP_STAMIN,
	4294967295u,
	WNI_CFG_TX_BF_CAP_STADEF},
	{WNI_CFG_AS_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_AS_CAP_STAMIN,
	WNI_CFG_AS_CAP_STAMAX,
	WNI_CFG_AS_CAP_STADEF},
	{WNI_CFG_HT_INFO_FIELD1,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_HT_INFO_FIELD1_STAMIN,
	WNI_CFG_HT_INFO_FIELD1_STAMAX,
	WNI_CFG_HT_INFO_FIELD1_STADEF},
	{WNI_CFG_HT_INFO_FIELD2,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE |
	CFG_CTL_NTF_LIM,
	WNI_CFG_HT_INFO_FIELD2_STAMIN,
	WNI_CFG_HT_INFO_FIELD2_STAMAX,
	WNI_CFG_HT_INFO_FIELD2_STADEF},
	{WNI_CFG_HT_INFO_FIELD3,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE |
	CFG_CTL_NTF_LIM,
	WNI_CFG_HT_INFO_FIELD3_STAMIN,
	WNI_CFG_HT_INFO_FIELD3_STAMAX,
	WNI_CFG_HT_INFO_FIELD3_STADEF},
	{WNI_CFG_BASIC_MCS_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	0, 0, 0},
	{WNI_CFG_CURRENT_MCS_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	0, 0, 0},
	{WNI_CFG_VHT_MAX_MPDU_LENGTH,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMIN,
	WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMAX,
	WNI_CFG_VHT_MAX_MPDU_LENGTH_STADEF},
	{WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMIN,
	WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMAX,
	WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STADEF},
	{WNI_CFG_VHT_LDPC_CODING_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_LDPC_CODING_CAP_STAMIN,
	WNI_CFG_VHT_LDPC_CODING_CAP_STAMAX,
	WNI_CFG_VHT_LDPC_CODING_CAP_STADEF},
	{WNI_CFG_VHT_SHORT_GI_80MHZ,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SHORT_GI_80MHZ_STAMIN,
	WNI_CFG_VHT_SHORT_GI_80MHZ_STAMAX,
	WNI_CFG_VHT_SHORT_GI_80MHZ_STADEF},
	{WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMIN,
	WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMAX,
	WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STADEF},
	{WNI_CFG_VHT_TXSTBC,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_TXSTBC_STAMIN,
	WNI_CFG_VHT_TXSTBC_STAMAX,
	WNI_CFG_VHT_TXSTBC_STADEF},
	{WNI_CFG_VHT_RXSTBC,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_RXSTBC_STAMIN,
	WNI_CFG_VHT_RXSTBC_STAMAX,
	WNI_CFG_VHT_RXSTBC_STADEF},
	{WNI_CFG_VHT_SU_BEAMFORMER_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMIN,
	WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMAX,
	WNI_CFG_VHT_SU_BEAMFORMER_CAP_STADEF},
	{WNI_CFG_VHT_SU_BEAMFORMEE_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMIN,
	WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMAX,
	WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STADEF},
	{WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMIN,
	WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMAX,
	WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STADEF},
	{WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMIN,
	WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMAX,
	WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STADEF},
	{WNI_CFG_VHT_MU_BEAMFORMER_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMIN,
	WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMAX,
	WNI_CFG_VHT_MU_BEAMFORMER_CAP_STADEF},
	{WNI_CFG_VHT_MU_BEAMFORMEE_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMIN,
	WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMAX,
	WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STADEF},
	{WNI_CFG_VHT_TXOP_PS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_TXOP_PS_STAMIN,
	WNI_CFG_VHT_TXOP_PS_STAMAX,
	WNI_CFG_VHT_TXOP_PS_STADEF},
	{WNI_CFG_VHT_HTC_VHTC_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_HTC_VHTC_CAP_STAMIN,
	WNI_CFG_VHT_HTC_VHTC_CAP_STAMAX,
	WNI_CFG_VHT_HTC_VHTC_CAP_STADEF},
	{WNI_CFG_VHT_AMPDU_LEN_EXPONENT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMIN,
	WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMAX,
	WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STADEF},
	{WNI_CFG_VHT_LINK_ADAPTATION_CAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMIN,
	WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMAX,
	WNI_CFG_VHT_LINK_ADAPTATION_CAP_STADEF},
	{WNI_CFG_VHT_RX_ANT_PATTERN,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_RX_ANT_PATTERN_STAMIN,
	WNI_CFG_VHT_RX_ANT_PATTERN_STAMAX,
	WNI_CFG_VHT_RX_ANT_PATTERN_STADEF},
	{WNI_CFG_VHT_TX_ANT_PATTERN,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_TX_ANT_PATTERN_STAMIN,
	WNI_CFG_VHT_TX_ANT_PATTERN_STAMAX,
	WNI_CFG_VHT_TX_ANT_PATTERN_STADEF},
	{WNI_CFG_VHT_RX_MCS_MAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_RX_MCS_MAP_STAMIN,
	WNI_CFG_VHT_RX_MCS_MAP_STAMAX,
	WNI_CFG_VHT_RX_MCS_MAP_STADEF},
	{WNI_CFG_VHT_TX_MCS_MAP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_TX_MCS_MAP_STAMIN,
	WNI_CFG_VHT_TX_MCS_MAP_STAMAX,
	WNI_CFG_VHT_TX_MCS_MAP_STADEF},
	{WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN,
	WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX,
	WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STADEF},
	{WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN,
	WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX,
	WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STADEF},
	{WNI_CFG_VHT_BASIC_MCS_SET,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_BASIC_MCS_SET_STAMIN,
	WNI_CFG_VHT_BASIC_MCS_SET_STAMAX,
	WNI_CFG_VHT_BASIC_MCS_SET_STADEF},
	{WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMIN,
	WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMAX,
	WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STADEF},
	{WNI_CFG_VHT_SS_UNDER_UTIL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_SS_UNDER_UTIL_STAMIN,
	WNI_CFG_VHT_SS_UNDER_UTIL_STAMAX,
	WNI_CFG_VHT_SS_UNDER_UTIL_STADEF},
	{WNI_CFG_VHT_40MHZ_UTILIZATION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_40MHZ_UTILIZATION_STAMIN,
	WNI_CFG_VHT_40MHZ_UTILIZATION_STAMAX,
	WNI_CFG_VHT_40MHZ_UTILIZATION_STADEF},
	{WNI_CFG_VHT_80MHZ_UTILIZATION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_80MHZ_UTILIZATION_STAMIN,
	WNI_CFG_VHT_80MHZ_UTILIZATION_STAMAX,
	WNI_CFG_VHT_80MHZ_UTILIZATION_STADEF},
	{WNI_CFG_VHT_160MHZ_UTILIZATION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_VHT_80MHZ_UTILIZATION_STADEF,
	WNI_CFG_VHT_160MHZ_UTILIZATION_STAMAX,
	WNI_CFG_VHT_160MHZ_UTILIZATION_STADEF},
	{WNI_CFG_MPDU_DENSITY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_MPDU_DENSITY_STAMIN,
	WNI_CFG_MPDU_DENSITY_STAMAX,
	WNI_CFG_MPDU_DENSITY_STADEF},
	{WNI_CFG_MAX_RX_AMPDU_FACTOR,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART | CFG_CTL_NTF_LIM,
	WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMIN,
	WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMAX,
	WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMAX},
	{WNI_CFG_MAX_PS_POLL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_MAX_PS_POLL_STAMIN,
	WNI_CFG_MAX_PS_POLL_STAMAX,
	WNI_CFG_MAX_PS_POLL_STADEF},
	{WNI_CFG_RSSI_FILTER_PERIOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_RSSI_FILTER_PERIOD_STAMIN,
	WNI_CFG_RSSI_FILTER_PERIOD_STAMAX,
	WNI_CFG_RSSI_FILTER_PERIOD_STADEF},
	{WNI_CFG_SCAN_IN_POWERSAVE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_SCAN_IN_POWERSAVE_STAMIN,
	WNI_CFG_SCAN_IN_POWERSAVE_STAMAX,
	WNI_CFG_SCAN_IN_POWERSAVE_STADEF},
	{WNI_CFG_IGNORE_DTIM,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_IGNORE_DTIM_STAMIN,
	WNI_CFG_IGNORE_DTIM_STAMAX,
	WNI_CFG_IGNORE_DTIM_STADEF},
	{WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMIN,
	WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMAX,
	WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STADEF},
	{WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMIN,
	WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMAX,
	WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STADEF},
	{WNI_CFG_WOWLAN_DEAUTH_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMIN,
	WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMAX,
	WNI_CFG_WOWLAN_DEAUTH_ENABLE_STADEF},
	{WNI_CFG_WOWLAN_DISASSOC_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMIN,
	WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMAX,
	WNI_CFG_WOWLAN_DISASSOC_ENABLE_STADEF},
	{WNI_CFG_WOWLAN_MAX_MISSED_BEACON,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMIN,
	WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMAX,
	WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STADEF},
	{WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMIN,
	WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMAX,
	WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STADEF},
	{WNI_CFG_MAX_MEDIUM_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_MAX_MEDIUM_TIME_STAMIN,
	WNI_CFG_MAX_MEDIUM_TIME_STAMAX,
	WNI_CFG_MAX_MEDIUM_TIME_STADEF},
	{WNI_CFG_IBSS_AUTO_BSSID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_IBSS_AUTO_BSSID_STAMIN,
	WNI_CFG_IBSS_AUTO_BSSID_STAMAX,
	WNI_CFG_IBSS_AUTO_BSSID_STADEF},
	{WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMIN,
	WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMAX,
	WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STADEF},
	{WNI_CFG_WPS_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_ENABLE_STAMIN,
	WNI_CFG_WPS_ENABLE_STAMAX,
	WNI_CFG_WPS_ENABLE_STADEF},
	{WNI_CFG_WPS_STATE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_STATE_STAMIN,
	WNI_CFG_WPS_STATE_STAMAX,
	WNI_CFG_WPS_STATE_STADEF},
	{WNI_CFG_WPS_VERSION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_VERSION_STAMIN,
	WNI_CFG_WPS_VERSION_STAMAX,
	WNI_CFG_WPS_VERSION_STADEF},
	{WNI_CFG_WPS_CFG_METHOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_CFG_METHOD_STAMIN,
	4294967295u,
	WNI_CFG_WPS_CFG_METHOD_STADEF},
	{WNI_CFG_WPS_UUID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_NTF_LIM,
	0, 0, 0},
	{WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMIN,
	WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMAX,
	WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STADEF},
	{WNI_CFG_WPS_PIMARY_DEVICE_OUI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_PIMARY_DEVICE_OUI_STAMIN,
	4294967295u,
	WNI_CFG_WPS_PIMARY_DEVICE_OUI_STADEF},
	{WNI_CFG_WPS_DEVICE_SUB_CATEGORY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMIN,
	WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMAX,
	WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STADEF},
	{WNI_CFG_WPS_DEVICE_PASSWORD_ID,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_WPS_DEVICE_PASSWORD_ID_STAMIN,
	4294967295u,
	WNI_CFG_WPS_DEVICE_PASSWORD_ID_STADEF},
	{WNI_CFG_LOW_GAIN_OVERRIDE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_LOW_GAIN_OVERRIDE_STAMIN,
	WNI_CFG_LOW_GAIN_OVERRIDE_STAMAX,
	WNI_CFG_LOW_GAIN_OVERRIDE_STADEF},
	{WNI_CFG_SINGLE_TID_RC,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_SINGLE_TID_RC_STAMIN,
	WNI_CFG_SINGLE_TID_RC_STAMAX,
	WNI_CFG_SINGLE_TID_RC_STADEF},
	{WNI_CFG_DYNAMIC_PS_POLL_VALUE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMIN,
	WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMAX,
	WNI_CFG_DYNAMIC_PS_POLL_VALUE_STADEF},
	{WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMIN,
	WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMAX,
	WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STADEF},
	{WNI_CFG_TELE_BCN_WAKEUP_EN,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TELE_BCN_WAKEUP_EN_STAMIN,
	WNI_CFG_TELE_BCN_WAKEUP_EN_STAMAX,
	WNI_CFG_TELE_BCN_WAKEUP_EN_STADEF},
	{WNI_CFG_TELE_BCN_TRANS_LI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TELE_BCN_TRANS_LI_STAMIN,
	WNI_CFG_TELE_BCN_TRANS_LI_STAMAX,
	WNI_CFG_TELE_BCN_TRANS_LI_STADEF},
	{WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMIN,
	WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMAX,
	WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STADEF},
	{WNI_CFG_TELE_BCN_MAX_LI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TELE_BCN_MAX_LI_STAMIN,
	WNI_CFG_TELE_BCN_MAX_LI_STAMAX,
	WNI_CFG_TELE_BCN_MAX_LI_STADEF},
	{WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMIN,
	WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMAX,
	WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STADEF},
	{WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMIN,
	WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMAX,
	WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STADEF},
	{WNI_CFG_ASSOC_STA_LIMIT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_ASSOC_STA_LIMIT_STAMIN,
	WNI_CFG_ASSOC_STA_LIMIT_STAMAX,
	WNI_CFG_ASSOC_STA_LIMIT_STADEF},
	{WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMIN,
	WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMAX,
	WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STADEF},
	{WNI_CFG_ENABLE_LTE_COEX,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ENABLE_LTE_COEX_STAMIN,
	WNI_CFG_ENABLE_LTE_COEX_STAMAX,
	WNI_CFG_ENABLE_LTE_COEX_STADEF},
	{WNI_CFG_AP_KEEP_ALIVE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMIN,
	WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMAX,
	WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STADEF},
	{WNI_CFG_GO_KEEP_ALIVE_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMIN,
	WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMAX,
	WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STADEF},
	{WNI_CFG_ENABLE_MC_ADDR_LIST,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ENABLE_MC_ADDR_LIST_STAMIN,
	WNI_CFG_ENABLE_MC_ADDR_LIST_STAMAX,
	WNI_CFG_ENABLE_MC_ADDR_LIST_STADEF},
	{WNI_CFG_ENABLE_LPWR_IMG_TRANSITION,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMIN,
	WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMAX,
	WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STADEF},
	{WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMIN,
	WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMAX,
	WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STADEF},
	{WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMIN,
	WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMAX,
	WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STADEF},
	{WNI_CFG_AP_LINK_MONITOR_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMIN,
	WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMAX,
	WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STADEF},
	{WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMIN,
	WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMAX,
	WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STADEF},
	{WNI_CFG_TDLS_BUF_STA_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_BUF_STA_ENABLED_STAMIN,
	WNI_CFG_TDLS_BUF_STA_ENABLED_STAMAX,
	WNI_CFG_TDLS_BUF_STA_ENABLED_STADEF},
	{WNI_CFG_TDLS_PUAPSD_INACT_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMIN,
	WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMAX,
	WNI_CFG_TDLS_PUAPSD_INACT_TIME_STADEF},
	{WNI_CFG_TDLS_RX_FRAME_THRESHOLD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMIN,
	WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMAX,
	WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STADEF},
	{WNI_CFG_PMF_SA_QUERY_MAX_RETRIES,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMIN,
	WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMAX,
	WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STADEF},
	{WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_RESTART,
	WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMIN,
	WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMAX,
	WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STADEF},
	{WNI_CFG_ENABLE_ADAPT_RX_DRAIN,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMIN,
	WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMAX,
	WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STADEF},
	{WNI_CFG_ANTENNA_DIVESITY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_ANTENNA_DIVESITY_STAMIN,
	WNI_CFG_ANTENNA_DIVESITY_STAMAX,
	WNI_CFG_ANTENNA_DIVESITY_STADEF},
	{WNI_CFG_GO_LINK_MONITOR_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMIN,
	WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMAX,
	WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STADEF},
	{WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STAMIN,
	WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STAMAX,
	WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STADEF},
	{WNI_CFG_CURRENT_RSSI,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_CURRENT_RSSI_STAMIN,
	WNI_CFG_CURRENT_RSSI_STAMAX,
	WNI_CFG_CURRENT_RSSI_STADEF},
	{WNI_CFG_RTT3_ENABLE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RTT3_ENABLE_STAMIN,
	WNI_CFG_RTT3_ENABLE_STAMAX,
	WNI_CFG_RTT3_ENABLE_STADEF},
	{WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMIN,
	WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMAX,
	WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STADEF},
	{WNI_CFG_TDLS_OFF_CHANNEL_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMIN,
	WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMAX,
	WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STADEF},
	{WNI_CFG_IBSS_ATIM_WIN_SIZE,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_IBSS_ATIM_WIN_SIZE_STAMIN,
	WNI_CFG_IBSS_ATIM_WIN_SIZE_STAMAX,
	WNI_CFG_IBSS_ATIM_WIN_SIZE_STADEF},
	{WNI_CFG_DFS_MASTER_ENABLED,
	CFG_CTL_VALID |  CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DFS_MASTER_ENABLED_STAMIN,
	WNI_CFG_DFS_MASTER_ENABLED_STAMAX,
	WNI_CFG_DFS_MASTER_ENABLED_STADEF},
	{WNI_CFG_VHT_ENABLE_TXBF_20MHZ,
	CFG_CTL_VALID |  CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STAMIN,
	WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STAMAX,
	WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STADEF},
	{WNI_CFG_TDLS_WMM_MODE_ENABLED,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMIN,
	WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMAX,
	WNI_CFG_TDLS_WMM_MODE_ENABLED_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STADEF},
	{WNI_CFG_OBSS_HT40_WIDTH_CH_TRANSITION_DELAY,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_WIDTH_CH_TRANSITION_DELAY_STAMIN,
	WNI_CFG_OBSS_HT40_WIDTH_CH_TRANSITION_DELAY_STAMAX,
	WNI_CFG_OBSS_HT40_WIDTH_CH_TRANSITION_DELAY_STADEF},
	{WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT |
	CFG_CTL_NTF_LIM,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STAMIN,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STAMAX,
	WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STADEF},
	{WNI_CFG_TGT_GTX_USR_CFG,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_TGT_GTX_USR_CFG_STAMIN,
	WNI_CFG_TGT_GTX_USR_CFG_STAMAX,
	WNI_CFG_TGT_GTX_USR_CFG_STADEF},
	{WNI_CFG_MAX_HT_MCS_TX_DATA,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_MAX_HT_MCS_TX_DATA_STAMIN,
	WNI_CFG_MAX_HT_MCS_TX_DATA_STAMAX,
	WNI_CFG_MAX_HT_MCS_TX_DATA_STADEF},
	{WNI_CFG_DISABLE_ABG_RATE_FOR_TX_DATA,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_DISABLE_ABG_RATE_FOR_TX_DATA_STAMIN,
	WNI_CFG_DISABLE_ABG_RATE_FOR_TX_DATA_STAMAX,
	WNI_CFG_DISABLE_ABG_RATE_FOR_TX_DATA_STADEF},
	{WNI_CFG_RATE_FOR_TX_MGMT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RATE_FOR_TX_MGMT_STAMIN,
	WNI_CFG_RATE_FOR_TX_MGMT_STAMAX,
	WNI_CFG_RATE_FOR_TX_MGMT_STADEF},
	{WNI_CFG_SAP_MAX_MCS_DATA,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_SAP_MAX_MCS_DATA_STAMIN,
	WNI_CFG_SAP_MAX_MCS_DATA_STAMAX,
	WNI_CFG_SAP_MAX_MCS_DATA_STADEF},
	{WNI_CFG_PS_WOW_DATA_INACTIVITY_TIMEOUT,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_PS_WOW_DATA_INACTIVITY_TIMEOUT_STAMIN,
	WNI_CFG_PS_WOW_DATA_INACTIVITY_TIMEOUT_STAMAX,
	WNI_CFG_PS_WOW_DATA_INACTIVITY_TIMEOUT_STADEF},
	{WNI_CFG_RATE_FOR_TX_MGMT_2G,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RATE_FOR_TX_MGMT_2G_STAMIN,
	WNI_CFG_RATE_FOR_TX_MGMT_2G_STAMAX,
	WNI_CFG_RATE_FOR_TX_MGMT_2G_STADEF},
	{WNI_CFG_RATE_FOR_TX_MGMT_5G,
	CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT,
	WNI_CFG_RATE_FOR_TX_MGMT_5G_STAMIN,
	WNI_CFG_RATE_FOR_TX_MGMT_5G_STAMAX,
	WNI_CFG_RATE_FOR_TX_MGMT_5G_STADEF},
};


cfgstatic_string cfg_static_string[CFG_MAX_STATIC_STRING] = {

	{WNI_CFG_STA_ID,
	WNI_CFG_STA_ID_LEN,
	6,
	{0x22, 0x22, 0x44, 0x44, 0x33, 0x33} },
	{WNI_CFG_SSID,
	WNI_CFG_SSID_LEN,
	10,
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0} },
	{WNI_CFG_WEP_DEFAULT_KEY_1,
	WNI_CFG_WEP_DEFAULT_KEY_1_LEN,
	0,
	{0} },
	{WNI_CFG_WEP_DEFAULT_KEY_2,
	WNI_CFG_WEP_DEFAULT_KEY_2_LEN,
	0,
	{0} },
	{WNI_CFG_WEP_DEFAULT_KEY_3,
	WNI_CFG_WEP_DEFAULT_KEY_3_LEN,
	0,
	{0} },
	{WNI_CFG_WEP_DEFAULT_KEY_4,
	WNI_CFG_WEP_DEFAULT_KEY_4_LEN,
	0,
	{0} },
	{WNI_CFG_SUPPORTED_RATES_11B,
	WNI_CFG_SUPPORTED_RATES_11B_LEN,
	4,
	{2, 4, 11, 22} },
	{WNI_CFG_SUPPORTED_RATES_11A,
	WNI_CFG_SUPPORTED_RATES_11A_LEN,
	8,
	{12, 18, 24, 36, 48, 72, 96, 108} },
	{WNI_CFG_OPERATIONAL_RATE_SET,
	WNI_CFG_OPERATIONAL_RATE_SET_LEN,
	0,
	{0} },
	{WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET,
	WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET_LEN,
	0,
	{0} },
	{WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET,
	WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET_LEN,
	4,
	{1, 3, 5, 7} },
	{WNI_CFG_VALID_CHANNEL_LIST,
	WNI_CFG_VALID_CHANNEL_LIST_LEN,
	55,
	{36, 40, 44, 48, 52, 56, 60, 64, 1, 6, 11, 34, 38, 42, 46, 2, 3, 4,
	 5, 7, 8, 9, 10, 12, 13, 14, 100, 104, 108, 112, 116, 120, 124, 128,
	 132, 136, 140, 149, 151, 153, 155, 157, 159, 161, 50, 54, 58, 62, 240,
	 242, 244, 246, 248, 250, 252} },

	{WNI_CFG_MANUFACTURER_NAME,
	WNI_CFG_MANUFACTURER_NAME_LEN,
	8,
	{0x51, 0x75, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x6d} },
	{WNI_CFG_MODEL_NUMBER,
	WNI_CFG_MODEL_NUMBER_LEN,
	6,
	{0x4d, 0x4e, 0x31, 0x32, 0x33, 0x34} },
	{WNI_CFG_MODEL_NAME,
	WNI_CFG_MODEL_NAME_LEN,
	7,
	{0x57, 0x46, 0x52, 0x34, 0x30, 0x33, 0x31} },
	{WNI_CFG_MANUFACTURER_PRODUCT_NAME,
	WNI_CFG_MANUFACTURER_PRODUCT_NAME_LEN,
	6,
	{0x31, 0x31, 0x6e, 0x2d, 0x41, 0x50} },
	{WNI_CFG_MANUFACTURER_PRODUCT_VERSION,
	WNI_CFG_MANUFACTURER_PRODUCT_VERSION_LEN,
	6,
	{0x53, 0x4e, 0x31, 0x32, 0x33, 0x34} },
	{WNI_CFG_MAX_TX_POWER_2_4,
	WNI_CFG_MAX_TX_POWER_2_4_LEN,
	3,
	{0x1, 0xe, 0x14} },
	{WNI_CFG_MAX_TX_POWER_5,
	WNI_CFG_MAX_TX_POWER_5_LEN,
	3,
	{0x24, 0x7e, 0x14} },
	{WNI_CFG_COUNTRY_CODE,
	WNI_CFG_COUNTRY_CODE_LEN,
	0,
	{0} },
	{WNI_CFG_EDCA_ANI_ACBK_LOCAL,
	WNI_CFG_EDCA_ANI_ACBK_LOCAL_LEN,
	17,
	{0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff, 0x0, 0x0,
	 0xf, 0x3, 0xff, 0x0} },
	{WNI_CFG_EDCA_ANI_ACBE_LOCAL,
	WNI_CFG_EDCA_ANI_ACBE_LOCAL_LEN,
	17,
	{0x0, 0x2, 0x0, 0xf, 0x3, 0xff, 0x64, 0x0, 0x1f, 0x3, 0xff, 0x64, 0x0,
	 0xf, 0x3, 0xff, 0x64} },
	{WNI_CFG_EDCA_ANI_ACVI_LOCAL,
	WNI_CFG_EDCA_ANI_ACVI_LOCAL_LEN,
	17,
	{0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0xc8, 0x0, 0xf, 0x0, 0x1f, 0xbc, 0x0,
	 0x7, 0x0, 0xf, 0xc8} },
	{WNI_CFG_EDCA_ANI_ACVO_LOCAL,
	WNI_CFG_EDCA_ANI_ACVO_LOCAL_LEN,
	17,
	{0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x64, 0x0, 0x7, 0x0, 0xf, 0x66, 0x0,
	 0x3, 0x0, 0x7, 0x64} },
	{WNI_CFG_EDCA_ANI_ACBK,
	WNI_CFG_EDCA_ANI_ACBK_LEN,
	17,
	{0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff, 0x0, 0x0,
	 0xf, 0x3, 0xff, 0x0} },
	{WNI_CFG_EDCA_ANI_ACBE,
	WNI_CFG_EDCA_ANI_ACBE_LEN,
	17,
	{0x0, 0x2, 0x0, 0xf, 0x3, 0xff, 0x64, 0x0, 0x1f, 0x3, 0xff, 0x64, 0x0,
	 0xf, 0x3, 0xff, 0x64} },
	{WNI_CFG_EDCA_ANI_ACVI,
	WNI_CFG_EDCA_ANI_ACVI_LEN,
	17, {0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0xc8, 0x0, 0xf, 0x0, 0x1f,
	0xbc, 0x0, 0x7, 0x0, 0xf, 0xc8} },
	{WNI_CFG_EDCA_ANI_ACVO,
	WNI_CFG_EDCA_ANI_ACVO_LEN,
	17,
	{0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x64, 0x0, 0x7, 0x0, 0xf, 0x66, 0x0, 0x3,
	 0x0, 0x7, 0x64} },
	{WNI_CFG_EDCA_WME_ACBK_LOCAL,
	WNI_CFG_EDCA_WME_ACBK_LOCAL_LEN,
	17, {0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff,
	0x0, 0x0, 0xf, 0x3, 0xff, 0x0} },
	{WNI_CFG_EDCA_WME_ACBE_LOCAL,
	WNI_CFG_EDCA_WME_ACBE_LOCAL_LEN,
	17, {0x0, 0x3, 0x0, 0xf, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x3, 0xff,
	0x0, 0x0, 0xf, 0x0, 0x3f, 0x0} },
	{WNI_CFG_EDCA_WME_ACVI_LOCAL,
	WNI_CFG_EDCA_WME_ACVI_LOCAL_LEN,
	17,
	{0x0, 0x1, 0x0, 0x7, 0x0, 0xf, 0x5e, 0x0, 0x7, 0x0, 0xf, 0xbc, 0x0, 0x7,
	 0x0, 0xf, 0x5e} },
	{WNI_CFG_EDCA_WME_ACVO_LOCAL,
	WNI_CFG_EDCA_WME_ACVO_LOCAL_LEN,
	17,
	{0x0, 0x1, 0x0, 0x3, 0x0, 0x7, 0x2f, 0x0, 0x3, 0x0, 0x7, 0x66, 0x0, 0x3,
	 0x0, 0x7, 0x2f} },
	{WNI_CFG_EDCA_WME_ACBK,
	WNI_CFG_EDCA_WME_ACBK_LEN,
	17,
	{0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf,
	 0x3, 0xff, 0x0} },
	{WNI_CFG_EDCA_WME_ACBE,
	WNI_CFG_EDCA_WME_ACBE_LEN,
	17,
	{0x0, 0x3, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf,
	 0x3, 0xff, 0x0} },
	{WNI_CFG_EDCA_WME_ACVI,
	WNI_CFG_EDCA_WME_ACVI_LEN,
	17,
	{0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0x5e, 0x0, 0x7, 0x0, 0xf, 0xbc, 0x0, 0x7,
	 0x0, 0xf, 0x5e} },
	{WNI_CFG_EDCA_WME_ACVO,
	WNI_CFG_EDCA_WME_ACVO_LEN,
	17,
	{0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x2f, 0x0, 0x3, 0x0, 0x7, 0x66, 0x0, 0x3,
	 0x0, 0x7, 0x2f} },
	{WNI_CFG_SCAN_CONTROL_LIST,
	WNI_CFG_SCAN_CONTROL_LIST_LEN,
	114,
	{0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x4, 0x1, 0x5, 0x1, 0x6, 0x1, 0x7, 0x1,
	 0x8, 0x1, 0x9, 0x1, 0xa, 0x1, 0xb, 0x1, 0xc, 0x1, 0xd, 0x1, 0xe, 0x1,
	 0x22, 0x1, 0x24, 0x1, 0x26, 0x1, 0x28, 0x1, 0x2a, 0x1, 0x2c, 0x1, 0x2e,
	 0x1, 0x30, 0x1, 0x32, 0x1, 0x34, 0x0, 0x36, 0x0, 0x38, 0x0, 0x3a, 0x0,
	 0x3c, 0x0, 0x3e, 0x0, 0x40, 0x0, 0x64, 0x0, 0x68, 0x0, 0x6c, 0x0, 0x70,
	 0x0, 0x74, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x80, 0x0, 0x84, 0x0, 0x88, 0x0,
	 0x8c, 0x0, 0x90, 0x0, 0x95, 0x1, 0x97, 0x1, 0x99, 0x1, 0x9b, 0x1, 0x9d,
	 0x1, 0x9f, 0x1, 0xa1, 0x1, 0xa5, 0x1, 0xf0, 0x1, 0xf2, 0x1, 0xf4, 0x1,
	 0xf6, 0x1, 0xf8, 0x1, 0xfa, 0x1, 0xfc, 0x1} },
	{WNI_CFG_SUPPORTED_MCS_SET,
	WNI_CFG_SUPPORTED_MCS_SET_LEN,
	16,
	{0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	 0x0, 0x0} },
	{WNI_CFG_BASIC_MCS_SET,
	WNI_CFG_BASIC_MCS_SET_LEN,
	16,
	{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	 0x0, 0x0} },
	{WNI_CFG_CURRENT_MCS_SET,
	WNI_CFG_CURRENT_MCS_SET_LEN,
	16,
	{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	 0x0, 0x0} },
	{WNI_CFG_WPS_UUID,
	WNI_CFG_WPS_UUID_LEN,
	6,
	{0xa, 0xb, 0xc, 0xd, 0xe, 0xf} }
};

/*--------------------------------------------------------------------*/
/* Static function prototypes                                         */
/*--------------------------------------------------------------------*/
static void proc_dnld_rsp(tpAniSirGlobal, uint16_t, uint32_t *);
static void proc_get_req(tpAniSirGlobal, uint16_t, uint32_t *);

static uint8_t check_param(tpAniSirGlobal, uint16_t, uint32_t, uint32_t,
			   uint32_t *);
/*--------------------------------------------------------------------*/
/* Module global variables                                            */
/*--------------------------------------------------------------------*/

/* CFG function table */
void (*g_cfg_func[])(tpAniSirGlobal, uint16_t, uint32_t *) = {
	proc_dnld_rsp, proc_get_req
};

/**---------------------------------------------------------------------
 * cfg_process_mb_msg()
 *
 ***FUNCTION:
 * CFG mailbox message processing function.
 *
 ***LOGIC:
 *
 ***ASSUMPTIONS:
 * None.
 *
 ***NOTE:
 *
 * @param pMsg    Message pointer
 *
 * @return None.
 *
 */
void cfg_process_mb_msg(tpAniSirGlobal pMac, tSirMbMsg *pMsg)
{
	uint16_t index;
	uint16_t len;
	uint32_t *pParam;

	/* Use type[7:0] as index to function table */
	index = CFG_GET_FUNC_INDX(pMsg->type);

	if (index >= QDF_ARRAY_SIZE(g_cfg_func)) {
		qdf_mem_free(pMsg);
		return;
	}
	len = pMsg->msgLen - WNI_CFG_MB_HDR_LEN;
	pParam = ((uint32_t *) pMsg) + 1;

	/* Call processing function */
	g_cfg_func[index] (pMac, len, pParam);

	/* Free up buffer */
	qdf_mem_free(pMsg);

} /*** end cfg_process_mb_msg() ***/

/**---------------------------------------------------------------------
 * proc_dnld_rsp()
 *
 * FUNCTION:
 * This function processes CFG_DNLD_RSP message from host.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 *
 * @param length:  message length
 * @param pParam:  parameter list pointer
 *
 * @return None
 *
 */
static void proc_dnld_rsp(tpAniSirGlobal pMac, uint16_t length, uint32_t *pParam)
{
	int32_t i;

	uint32_t expLen, retVal, bufStart, bufEnd;
	uint32_t *pSrc, *pDst, *pDstEnd;
	uint32_t strSize, j;
	uint8_t pStr[CFG_MAX_STR_LEN];
	tpCfgBinHdr pHdr;
	tSirMsgQ mmhMsg;

	/* First Dword must contain the AP or STA magic dword */
	pe_debug("CFG size: %d bytes MAGIC dword is: 0x%x",
		       length, sir_read_u32_n((uint8_t *) pParam));

	/* if the string is not correct, return failure */
	if (*pParam == CFG_STA_MAGIC_DWORD) {
	}

	else {
		pe_warn("Invalid magic dword: 0x%x",
			       sir_read_u32_n((uint8_t *) pParam));
		retVal = WNI_CFG_INVALID_LEN;
		goto end;
	}

	pParam++;
	length -= 4;

	/* Parse the Cfg header */
	pHdr = (tpCfgBinHdr) pParam;
	pParam += (sizeof(tCfgBinHdr) >> 2);
	pe_debug("CFG hdr totParams: %d intParams: %d strBufSize: %d/%d",
		       pHdr->controlSize, pHdr->iBufSize, pHdr->sBufSize,
		       pMac->cfg.gCfgMaxSBufSize);

	expLen =
		((CFG_PARAM_MAX_NUM + 3 * pMac->cfg.gCfgMaxIBufSize) << 2) +
		pHdr->sBufSize + sizeof(tCfgBinHdr);

	if (length != expLen) {
		pe_warn("<CFG> DNLD_RSP invalid length: %d (exp: %d)", length,
			       expLen);
		retVal = WNI_CFG_INVALID_LEN;
		goto end;
	}

	if (pHdr->controlSize != CFG_PARAM_MAX_NUM) {
		pe_warn("<CFG> Total parameter count mismatch");
		retVal = WNI_CFG_INVALID_LEN;
		goto end;
	}

	if (pHdr->iBufSize != pMac->cfg.gCfgMaxIBufSize) {
		pe_warn("<CFG> Integer parameter count mismatch");
		retVal = WNI_CFG_INVALID_LEN;
		goto end;
	}
	/* Copy control array */
	pDst = (uint32_t *) pMac->cfg.gCfgEntry;
	pDstEnd = pDst + CFG_PARAM_MAX_NUM;
	pSrc = pParam;
	while (pDst < pDstEnd) {
		*pDst++ = *pSrc++;
	}
	/* Copy default values */
	pDst = pMac->cfg.gCfgIBuf;
	pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
	while (pDst < pDstEnd) {
		*pDst++ = *pSrc++;
	}

	/* Copy min values */
	pDst = pMac->cfg.gCfgIBufMin;
	pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
	while (pDst < pDstEnd) {
		*pDst++ = *pSrc++;
	}

	/* Copy max values */
	pDst = pMac->cfg.gCfgIBufMax;
	pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
	while (pDst < pDstEnd) {
		*pDst++ = *pSrc++;
	}

	for (i = 0; i < pMac->cfg.gCfgMaxIBufSize; i++)
		if (pMac->cfg.gCfgIBuf[i] < pMac->cfg.gCfgIBufMin[i] ||
		    pMac->cfg.gCfgIBuf[i] > pMac->cfg.gCfgIBufMax[i]) {
			pe_debug("cfg id: %d Invalid def value: %d min: %d max: %d",
					i, pMac->cfg.gCfgIBuf[i],
				       pMac->cfg.gCfgIBufMin[i],
				       pMac->cfg.gCfgIBufMax[i]);
		}
	/* Calculate max string buffer lengths for all string parameters */
	bufEnd = pMac->cfg.gCfgMaxSBufSize;
	for (i = CFG_PARAM_MAX_NUM - 1; i >= 0; i--) {
		if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0)
			continue;

		if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
			continue;

		bufStart = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;
		pMac->cfg.gCfgSBuf[bufStart] =
			(uint8_t) (bufEnd - bufStart - 2);

		pe_debug("id: %d max: %d bufStart: %d bufEnd: %d", i,
			       pMac->cfg.gCfgSBuf[bufStart], bufStart, bufEnd);
		bufEnd = bufStart;
	}

	/* Initialize string defaults */
	strSize = pHdr->sBufSize;
	while (strSize) {
		uint32_t paramId, paramLen, paramLenCeil4;

		if (strSize < 4) {
			pe_warn("parsing str defaults, rem: %d bytes",
				       strSize);
			retVal = WNI_CFG_INVALID_LEN;
			goto end;
		}
		paramId = *pSrc >> 16;
		paramLen = *pSrc & 0xff;
		pSrc++;
		strSize -= 4;

		paramLenCeil4 = ((paramLen + 3) >> 2);
		if (strSize < paramLenCeil4 << 2) {
			pe_warn("parsing str defaults, rem: %d bytes",
				       strSize);
			pe_warn("param id: %d len: %d bytes",
					paramId, paramLen);
			retVal = WNI_CFG_INVALID_LEN;
			goto end;
		}
		for (j = 0; j < paramLenCeil4; j++) {
			pStr[4 * j] = (uint8_t) (*pSrc >> 24) & 0xff;
			pStr[4 * j + 1] = (uint8_t) (*pSrc >> 16) & 0xff;
			pStr[4 * j + 2] = (uint8_t) (*pSrc >> 8) & 0xff;
			pStr[4 * j + 3] = (uint8_t) (*pSrc) & 0xff;

			pSrc++;
			strSize -= 4;
		}

		pe_debug("set str id: %d len: %d", paramId, paramLen);

		if (cfg_set_str(pMac, (uint16_t) paramId, pStr, paramLen) !=
		    eSIR_SUCCESS) {
			pe_warn("setting str default param %d len %d",
				       paramId, paramLen);
			retVal = WNI_CFG_INVALID_LEN;
			goto end;
		}
	}

	/* Set status to READY */
	pMac->cfg.gCfgStatus = CFG_SUCCESS;
	retVal = WNI_CFG_SUCCESS;
	pe_debug("<CFG> Completed successfully");

end:

	if (retVal != WNI_CFG_SUCCESS)
		pMac->cfg.gCfgStatus = CFG_FAILURE;

	/* Send response message to host */
	pMac->cfg.gParamList[WNI_CFG_DNLD_CNF_RES] = retVal;
	cfg_send_host_msg(pMac, WNI_CFG_DNLD_CNF, WNI_CFG_DNLD_CNF_LEN,
			  WNI_CFG_DNLD_CNF_NUM, pMac->cfg.gParamList, 0, 0);

	/* notify WMA that the config has downloaded */
	mmhMsg.type = SIR_CFG_DOWNLOAD_COMPLETE_IND;
	mmhMsg.bodyptr = NULL;
	mmhMsg.bodyval = 0;

	MTRACE(mac_trace_msg_tx(pMac, NO_SESSION, mmhMsg.type));
	if (wma_post_ctrl_msg(pMac, &mmhMsg) != eSIR_SUCCESS) {
		pe_err("WMAPostMsgApi failed!");
	}

} /*** end procDnldRsp() ***/

/**---------------------------------------------------------------------
 * proc_get_req()
 *
 * FUNCTION:
 * This function processes CFG_GET_REQ message from host.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 * For every parameter ID specified on the list, CFG will send a separate
 * CFG_GET_RSP back to host.
 *
 * @param length:  message length
 * @param pParam:  parameter list pointer
 *
 * @return None
 *
 */
static void proc_get_req(tpAniSirGlobal pMac, uint16_t length, uint32_t *pParam)
{
	uint16_t cfgId, i;
	uint32_t value, valueLen, result;
	uint32_t *pValue;

	pe_debug("Rcvd cfg get request %d bytes", length);
	for (i = 0; i < length / 4; i++)
		pe_debug("[%2d] 0x%08x", i, pParam[i]);

		if (!pMac->cfg.gCfgStatus) {
			cfgId = (uint16_t) sir_read_u32_n((uint8_t *) pParam);
			pe_debug("CFG not ready, param %d", cfgId);
			pMac->cfg.gParamList[WNI_CFG_GET_RSP_RES] =
				WNI_CFG_NOT_READY;
			pMac->cfg.gParamList[WNI_CFG_GET_RSP_PID] = cfgId;
			pMac->cfg.gParamList[WNI_CFG_GET_RSP_PLEN] = 0;
			cfg_send_host_msg(pMac, WNI_CFG_GET_RSP,
					  WNI_CFG_GET_RSP_PARTIAL_LEN, WNI_CFG_GET_RSP_NUM,
					  pMac->cfg.gParamList, 0, 0);
		} else {
			/* Process all parameter ID's on the list */
			while (length >= sizeof(uint32_t)) {
				cfgId = (uint16_t) *pParam++;
				pValue = 0;
				valueLen = 0;

				pe_debug("Cfg get param %d", cfgId);
				/* Check for valid parameter ID, etc... */
				if (check_param
					    (pMac, cfgId, CFG_CTL_RE, WNI_CFG_WO_PARAM,
					    &result)) {
					if ((pMac->cfg.gCfgEntry[cfgId].
					     control & CFG_CTL_INT) != 0) {
						/* Get integer parameter */
						result =
							(wlan_cfg_get_int(pMac, cfgId, &value)
							 ==
							 eSIR_SUCCESS ? WNI_CFG_SUCCESS :
							 WNI_CFG_OTHER_ERROR);
						pValue = &value;
						valueLen = sizeof(uint32_t);
					} else {
						/* Get string parameter */
						valueLen = sizeof(pMac->cfg.gSBuffer);
						result =
							(wlan_cfg_get_str
								 (pMac, cfgId, pMac->cfg.gSBuffer,
								 &valueLen)
							 == eSIR_SUCCESS ? WNI_CFG_SUCCESS :
							 WNI_CFG_OTHER_ERROR);
						pValue =
							(uint32_t *) pMac->cfg.gSBuffer;
					}
				} else {
					pe_warn("Check param failed, param %d",
						       cfgId);
					result = WNI_CFG_INVALID_LEN;
				}

				/* Send response message to host */
				pMac->cfg.gParamList[WNI_CFG_GET_RSP_RES] = result;
				pMac->cfg.gParamList[WNI_CFG_GET_RSP_PID] = cfgId;
				pMac->cfg.gParamList[WNI_CFG_GET_RSP_PLEN] = valueLen;

				/* We need to round up buffer length to word-increment */
				valueLen = (((valueLen + 3) >> 2) << 2);
				cfg_send_host_msg(pMac, WNI_CFG_GET_RSP,
						  WNI_CFG_GET_RSP_PARTIAL_LEN + valueLen,
						  WNI_CFG_GET_RSP_NUM,
						  pMac->cfg.gParamList, valueLen, pValue);

				/* Decrement length */
				length -= sizeof(uint32_t);
			}
		}

} /*** end procGetReq() ***/

/**---------------------------------------------------------------------
 * check_param()
 *
 * FUNCTION:
 * This function is called to perform various check on a parameter.
 *
 * LOGIC:
 * -  If cfgId is out of bound or parameter is not valid, result
 *    WNI_CFG_INVALID_PID is returned at address specified in pResult.
 *
 * -  If specified 'flag' is not set in the parameter control entry,
 *    'failedResult' is returned at address specified in pResult.
 *
 * ASSUMPTIONS:
 * Since this function is used internally, 'pResult' is always valid.
 *
 * NOTE:
 *
 * @param None
 *
 * @return true:   Parameter is valid and matches checked condition \n
 * @return false:  Parameter either is not valid or does not match
 *                 checked condition.
 *
 */
static uint8_t
check_param(tpAniSirGlobal pMac, uint16_t cfgId, uint32_t flag,
	    uint32_t failedResult, uint32_t *pResult)
{
	/* Check if parameter ID is out of bound */
	if (cfgId >= CFG_PARAM_MAX_NUM) {
		pe_warn("Invalid param id: %d", cfgId);
		*pResult = WNI_CFG_INVALID_PID;
	} else {
		/* Check if parameter is valid */
		if ((pMac->cfg.gCfgEntry[cfgId].control & CFG_CTL_VALID) == 0) {
			pe_warn("Param id: %d not valid", cfgId);
			*pResult = WNI_CFG_INVALID_PID;
		} else {
			/* Check control field against flag */
			if ((pMac->cfg.gCfgEntry[cfgId].control & flag) == 0) {
				pe_debug("Param id: %d wrong permissions: %x",
					       cfgId,
					       pMac->cfg.gCfgEntry[cfgId].control);
				*pResult = failedResult;
			} else
				return true;
		}
	}
	return false;

} /*** cfgParamCheck() ***/

/**---------------------------------------------------------------------
 * process_cfg_download_req()
 *
 * FUNCTION: This function does the Cfg Download and is invoked
 *           only in the case of Prima or the Integrated SOC
 *           solutions. Not applicable to Volans or Libra
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 *
 * @param pMac: Pointer to Mac Structure
 *
 * @return None
 *
 */

void
process_cfg_download_req(tpAniSirGlobal pMac)
{
	int32_t i;
	uint32_t    index;
	uint8_t    *pDstTest, *pSrcTest;
	uint8_t     len;
	cfgstatic_string * pStrCfg;
	uint32_t    bufStart, bufEnd;
	uint32_t    retVal;
	uint32_t    iCount = 0;
	uint32_t    sCount = 0;

	for (i = 0; i < CFG_PARAM_MAX_NUM ; i++) {
		if ((cfg_static[i].control & CFG_CTL_VALID) != 0) {
			if (!(cfg_static[i].control & CFG_CTL_INT)) {
				pStrCfg = (cfgstatic_string*)cfg_static[i].
								pStrData;
				if (pStrCfg == NULL) {
					pe_err("pStrCfg is NULL for CfigID : %d",
					  i);
					continue;
				}
				index = sCount & CFG_BUF_INDX_MASK;
				sCount += pStrCfg->maxLen + 1 + 1;
			} else {
				index = iCount & CFG_BUF_INDX_MASK;
				iCount++;
			}
		} else {
			index = 0;
		}
		pMac->cfg.gCfgEntry[i].control = cfg_static[i].control | index;
	}

	/*Fill the SBUF wih maxLength*/
	bufEnd = pMac->cfg.gCfgMaxSBufSize;
	for (i = CFG_PARAM_MAX_NUM - 1; i >= 0; i--) {
		if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0)
			continue;

		if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
			continue;

		bufStart = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;
		pMac->cfg.gCfgSBuf[bufStart] = (uint8_t)(bufEnd - bufStart - 2);

		pe_debug("id: %d max: %d bufStart: %d bufEnd: %d",
					i, pMac->cfg.gCfgSBuf[bufStart],
						bufStart, bufEnd);
			bufEnd = bufStart;
	}

	for (i = 0; i < CFG_PARAM_MAX_NUM ; i++) {
		index = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;

		if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0) {
			pMac->cfg.gCfgIBufMin[index] = cfg_static[i].cfgIMin;
			pMac->cfg.gCfgIBufMax[index] = cfg_static[i].cfgIMax;
			pMac->cfg.gCfgIBuf[index]    = cfg_static[i].cfgIVal;
		} else {
			uint8_t maxSavedLen;

			if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
				continue;
			if (index >= pMac->cfg.gCfgMaxSBufSize)
				continue;

			pDstTest = &pMac->cfg.gCfgSBuf[index];
			pStrCfg = (cfgstatic_string*)cfg_static[i].pStrData;
			pSrcTest = pStrCfg->data;
			if ((pDstTest == NULL) || (pStrCfg == NULL) ||
							(pSrcTest == NULL))
				continue;
			maxSavedLen = *pDstTest;
			len = pStrCfg->length;
			if (len > maxSavedLen)
				continue;
			*pDstTest++ = pStrCfg->maxLen;
			*pDstTest++ = len;
			while (len) {
				*pDstTest++ = *pSrcTest++;
				len--;
			}
		}
	}

	/* Set status to READY */
	pMac->cfg.gCfgStatus = CFG_SUCCESS;
	retVal = WNI_CFG_SUCCESS;
	pe_debug("<CFG> Completed successfully");

	pMac->cfg.gParamList[WNI_CFG_DNLD_CNF_RES] = retVal;

} /*** end ProcessDownloadReq() ***/
