/*
 * Copyright (c) 2012-2017 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

/*
 * \file dot11f.c
 *
 * \brief Structures, functions & definitions for
 * working with 802.11 Frames
 *
 *
 * This file was automatically generated by 'framesc'
 * Wed Dec 13 20:23:59 2017 from the following file(s):
 *
 * dot11f.frms
 *
 * PLEASE DON'T EDIT THIS FILE BY HAND!
 *
 */

#if !defined  ANI_OS_TYPE_OSX && !defined ANI_OS_TYPE_LINUX && !defined ANI_OS_TYPE_ANDROID
#include <memory.h> /* For memcpy */
#include <stdio.h>  /* For _vsnprintf */
#include <stddef.h> /* For offsetof */
#endif

#include <ani_global.h>
#include <utils_api.h>
#include "dot11fdefs.h"
#include "dot11f.h"

#if defined(_MSC_VER)
#pragma warning (disable:4244)
#pragma warning (disable:4505)
#pragma warning (disable:4702)
#pragma warning (disable:4996)/* ... was declared deprecated */
#endif /* Microsoft C/C++ */

typedef unsigned char tFRAMES_BOOL;
typedef void (*pfnGeneric_t)(void);

typedef struct sFFDefn {
	const char  *name;
	uint32_t offset;
	uint16_t sig;
	uint8_t  size;
} tFFDefn;

typedef struct sIEDefn {
	uint32_t  offset;
	uint32_t  presenceOffset;
	uint32_t  countOffset;
	const char   *name;
	uint16_t  arraybound;
	uint16_t  minSize;
	uint16_t  maxSize;
	uint16_t  sig;
	unsigned char oui[5];
	unsigned char noui;
	uint8_t   eid;
	uint8_t   extn_eid;
	tFRAMES_BOOL  fMandatory;
} tIEDefn;

#if !defined(countof)
#define countof(x) (sizeof((x)) / sizeof((x)[0]))
#endif

#if !defined(DOT11F_MEMCPY)
#define DOT11F_MEMCPY(ctx, dst, src, len) \
	memcpy((dst), (src), (len))
#endif

#if !defined(DOT11F_MEMCMP)
#define DOT11F_MEMCMP(ctx, lhs, rhs, len) \
	memcmp((lhs), (rhs), (len))
#endif

#ifndef DOT11F_HAVE_LOG_SEVERITIES
#define FRLOG_OFF (0)
#define FRLOGP    (1)
#define FRLOGE    (2)
#define FRLOGW    (3)
#define FRLOG1    (4)
#define FRLOG2    (5)
#define FRLOG3    (6)
#define FRLOG4    (7)
#endif

#define FRFL(x) x

#define FRAMES_LOG0(ctx, sev, fmt)
#define FRAMES_LOG1(ctx, sev, fmt, p1)
#define FRAMES_LOG2(ctx, sev, fmt, p1, p2)
#define FRAMES_LOG3(ctx, sev, fmt, p1, p2, p3)
#define FRAMES_LOG4(ctx, sev, fmt, p1, p2, p3, p4)
#define FRAMES_DUMP(ctx, sev, p, n)
#ifndef FRAMES_SEV_FOR_FRAME
#define FRAMES_SEV_FOR_FRAME(ctx, sig) FRLOG3
#endif

#if defined(DOT11F_ENABLE_DBG_BREAK) && defined (WIN32)
#define FRAMES_DBG_BREAK() { _asm int 3 }
#else
#define FRAMES_DBG_BREAK()
#endif

#if !defined(DOT11F_PARAMETER_CHECK)
#if defined (DOT11F_HAVE_WIN32_API)

#define DOT11F_PARAMETER_CHECK(pBuf, nBuf, pFrm, nFrm) \
	if (!pBuf || IsBadReadPtr(pBuf, nBuf))\
		return DOT11F_BAD_INPUT_BUFFER; \
	if (!pFrm || IsBadWritePtr(pFrm, nFrm))\
		return DOT11F_BAD_OUTPUT_BUFFER \

#define DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed) \
	if (!pSrc || IsBadReadPtr(pSrc, 4))\
		eturn DOT11F_BAD_INPUT_BUFFER; \
	if (!pBuf || IsBadWritePtr(pBuf, nBuf))\
		return DOT11F_BAD_OUTPUT_BUFFER; \
	if (!nBuf)\
		return DOT11F_BAD_OUTPUT_BUFFER; \
	if (IsBadWritePtr(pnConsumed, 4))\
		return DOT11F_BAD_OUTPUT_BUFFER \

#else

#define DOT11F_PARAMETER_CHECK(pBuf, nBuf, pFrm, nFrm) \
	if (!pBuf)\
		return DOT11F_BAD_INPUT_BUFFER; \
	if (!pFrm)\
		return DOT11F_BAD_OUTPUT_BUFFER \

#define DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed) \
	if (!pSrc)\
		return DOT11F_BAD_INPUT_BUFFER; \
	if (!pBuf)\
		return DOT11F_BAD_OUTPUT_BUFFER; \
	if (!nBuf)\
		return DOT11F_BAD_OUTPUT_BUFFER; \
	if (!pnConsumed)\
		return DOT11F_BAD_OUTPUT_BUFFER \

#endif
#endif

static void framesntohs(tpAniSirGlobal    pCtx,
			uint16_t *pOut,
			uint8_t  *pIn,
			tFRAMES_BOOL  fMsb)
{
	(void)pCtx;
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	if (!fMsb)
		DOT11F_MEMCPY(pCtx, (uint16_t *)pOut, pIn, 2);
	else
		*pOut = (uint16_t)(*pIn << 8) | *(pIn + 1);
#else
	if (!fMsb)
		*pOut = (uint16_t)(*pIn | (*(pIn + 1) << 8));
	else
		DOT11F_MEMCPY(pCtx, (uint16_t *)pOut, pIn, 2);
#endif
}

static void framesntohl(tpAniSirGlobal    pCtx,
			uint32_t *pOut,
			uint8_t  *pIn,
			tFRAMES_BOOL  fMsb)
{
	(void)pCtx;
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	if (!fMsb)
		DOT11F_MEMCPY(pCtx, (uint32_t *)pOut, pIn, 4);
	else
		*pOut = (uint32_t)(*pIn << 24) |
			(*(pIn + 1) << 16) |
			(*(pIn + 2) <<  8) |
			(*(pIn + 3));
#else
	if (!fMsb)
		*pOut = (uint32_t)(*(pIn + 3) << 24) |
			(*(pIn + 2) << 16) |
			(*(pIn + 1) <<  8) |
			(*(pIn));
else
		*pOut = *(uint32_t *)pIn;
#endif
}

static void framesntohq(tpAniSirGlobal    pCtx,
			tDOT11F_U64 *pOut,
			uint8_t  *pIn,
			tFRAMES_BOOL  fMsb)
{
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	framesntohl(pCtx, &((*pOut)[0]), pIn, fMsb);
	framesntohl(pCtx, &((*pOut)[1]), pIn + 4, fMsb);
#else
	framesntohl(pCtx, &((*pOut)[1]), pIn, fMsb);
	framesntohl(pCtx, &((*pOut)[0]), pIn + 4, fMsb);
#endif
}

static void frameshtons(tpAniSirGlobal    pCtx,
			uint8_t  *pOut,
			uint16_t  pIn,
			tFRAMES_BOOL  fMsb)
{
	(void)pCtx;
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	if (!fMsb) {
		DOT11F_MEMCPY(pCtx, pOut, &pIn, 2);
	} else {
		*pOut       = (pIn & 0xff00) >> 8;
		*(pOut + 1) = pIn & 0xff;
	}
#else
	if (!fMsb) {
		*pOut       = pIn & 0xff;
		*(pOut + 1) = (pIn & 0xff00) >> 8;
	} else {
		DOT11F_MEMCPY(pCtx, pOut, &pIn, 2);
	}
#endif
}

static void frameshtonl(tpAniSirGlobal    pCtx,
			uint8_t  *pOut,
			uint32_t  pIn,
			tFRAMES_BOOL  fMsb)
{
	(void)pCtx;
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	if (!fMsb) {
		DOT11F_MEMCPY(pCtx, pOut, &pIn, 4);
	} else {
		*pOut       = (pIn & 0xff000000) >> 24;
		*(pOut + 1) = (pIn & 0x00ff0000) >> 16;
		*(pOut + 2) = (pIn & 0x0000ff00) >>  8;
		*(pOut + 3) = (pIn & 0x000000ff);
	}
#else
	if (!fMsb) {
		*pOut       = (pIn & 0x000000ff);
		*(pOut + 1) = (pIn & 0x0000ff00) >>  8;
		*(pOut + 2) = (pIn & 0x00ff0000) >> 16;
		*(pOut + 3) = (pIn & 0xff000000) >> 24;
	} else {
		DOT11F_MEMCPY(pCtx, pOut, &pIn, 4);
	}
#endif
}

static void frameshtonq(tpAniSirGlobal    pCtx,
			uint8_t  *pOut,
			tDOT11F_U64  pIn,
			tFRAMES_BOOL  fMsb)
{
#if defined (DOT11F_LITTLE_ENDIAN_HOST)
	frameshtonl(pCtx, pOut, pIn[0], fMsb);
	frameshtonl(pCtx, pOut + 4, pIn[1], fMsb);
#else
	frameshtonl(pCtx, pOut + 4, pIn[1], fMsb);
	frameshtonl(pCtx, pOut, pIn[0], fMsb);
#endif
}

static const tIEDefn *find_ie_defn(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   const tIEDefn  IEs[])
{
	const tIEDefn *pIe;
	(void)pCtx;

	pIe = &(IEs[0]);
	while (0xff != pIe->eid || pIe->extn_eid) {
		if (*pBuf == pIe->eid) {
			if (pIe->eid == 0xff) {
				if ((*(pBuf + 2)) == pIe->extn_eid)
					return pIe;
			} else {
				if (0 == pIe->noui)
					return pIe;

				if ((nBuf > (uint32_t)(pIe->noui + 2)) &&
				    (!DOT11F_MEMCMP(pCtx, pBuf + 2, pIe->oui,
						      pIe->noui)))
					return pIe;
			}
		}

		++pIe;
	}

	return NULL;
}

static uint32_t get_container_ies_len(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint32_t  nBuf,
				      uint8_t *pnConsumed,
				      const tIEDefn  IEs[])
{
	const tIEDefn *pIe, *pIeFirst;
	uint8_t *pBufRemaining = pBuf;
	uint32_t len = 0;
	(void)pCtx;

	pIeFirst = &(IEs[0]);

	if (*pBufRemaining != pIeFirst->eid)
		return DOT11F_INTERNAL_ERROR;
	len += *(pBufRemaining+1);
	pBufRemaining += len + 2;
	len += 2;
	while (len < nBuf) {
		pIe = find_ie_defn(pCtx, pBufRemaining, nBuf - len, IEs);
		if (NULL == pIe)
			break;
		if (pIe->eid == pIeFirst->eid)
			break;
		len += *(pBufRemaining + 1) + 2;
		pBufRemaining += *(pBufRemaining + 1) + 2;
	}

	if ((len > 0xFF) || (len > nBuf))
		return DOT11F_INTERNAL_ERROR;
	*pnConsumed = len;
	return DOT11F_PARSE_SUCCESS;

}


static uint32_t unpack_core(tpAniSirGlobal pCtx,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    const tFFDefn  FFs[],
			    const tIEDefn  IEs[],
			    uint8_t *pFrm,
			    size_t nFrm,
			    bool append_ie);
static uint32_t pack_core(tpAniSirGlobal pCtx,
			  uint8_t *pSrc,
			  uint8_t *pBuf,
			  uint32_t  nBuf,
			  uint32_t *pnConsumed,
			  const tFFDefn  FFs[],
			  const tIEDefn  IEs[]);
static uint32_t get_packed_size_core(tpAniSirGlobal pCtx,
				     uint8_t *pFrm,
				     uint32_t *pnNeeded,
				     const tIEDefn  IEs[]);

static uint32_t dot11f_unpack_tlv_common_func(tpAniSirGlobal pCtx,
			 uint8_t *pBuf, uint16_t tlvlen,
			 uint8_t *pDstPresent, uint8_t *pDstField)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)tlvlen; /* Shutup the compiler */

	*pDstPresent = 1;
	*pDstField = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_common_func. */

static uint32_t dot11f_unpack_tlv_common_func2(tpAniSirGlobal  pCtx,
			 uint8_t *pBuf, uint16_t tlvlen,
			 uint8_t *pDstPresent, uint16_t *pDstState)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)tlvlen; /* Shutup the compiler */

	*pDstPresent = 1;
	framesntohs(pCtx, pDstState, pBuf, 1);
	(void)pCtx;
	return status;

} /* End dot11f_unpack_tlv_common_func2. */

static void dot11f_unpack_ff_common_func(tpAniSirGlobal pCtx,
				  uint8_t *pBuf, uint16_t *pDstField)
{
	framesntohs(pCtx, pDstField, pBuf, 0);
	(void)pCtx;
} /* End dot11f_unpack_ff_common_func. */

static uint32_t dot11f_unpack_ie_common_func(tpAniSirGlobal pCtx, uint8_t *pBuf,
				      uint8_t ielen, uint8_t *pDstPresent ,
				      uint8_t *pDstField)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)ielen;
	(void)pBuf;
	if ((*pDstPresent))
		status = DOT11F_DUPLICATE_IE;
	*pDstPresent = 1;
	*pDstField = *pBuf;
	(void)pCtx;

	return status;
} /* End dot11f_unpack_ie_common_func */

typedef struct sTLVDefn {
	uint32_t   offset;
	uint32_t   presenceOffset;
	const char     *name;
	uint16_t   sig;
	uint32_t   id;
	uint32_t   pec;
	uint32_t   minSize;
	uint32_t   maxSize;
	uint8_t    fMandatory;
	uint8_t    sType;
	uint8_t    sLen;
	uint8_t    fMsb;
} tTLVDefn;

static const tTLVDefn *find_tlv_defn(tpAniSirGlobal    pCtx,
				     uint8_t  *pBuf,
				     uint32_t  nBuf,
				     const tTLVDefn      TLVs[])
{
	const tTLVDefn *pTlv;
	uint32_t   pec;
	uint16_t   id;

	pTlv = &(TLVs[0]);
	(void)pCtx;
	if (pTlv->sType == 2)
		framesntohs(pCtx, &id, pBuf, 1);
	else
		id = *pBuf;

	while (0xffff != pTlv->id) {
		if (id == pTlv->id) {
			if (0 == pTlv->pec)
				return pTlv;

			if (nBuf > 5) {
				pec = ((*(pBuf + 4)) << 16) |
				      ((*(pBuf + 5)) <<  8) |
				      *(pBuf + 6);
				if (pec == pTlv->pec)
					return pTlv;
			}
		}

		++pTlv;
	}

	return NULL;
}

static uint32_t unpack_tlv_core(tpAniSirGlobal   pCtx,
			uint8_t *pBuf,
			uint32_t nBuf,
			const tTLVDefn TLVs[],
			uint8_t *pFrm,
			size_t nFrm);
static uint32_t pack_tlv_core(tpAniSirGlobal pCtx,
			      uint8_t *pSrc,
			      uint8_t *pBuf,
			      uint32_t  nBuf,
			      uint32_t *pnConsumed,
			      const tTLVDefn  TLVs[],
			      uint32_t *pidx);
static uint32_t get_packed_size_tlv_core(tpAniSirGlobal pCtx,
					 uint8_t *pFrm,
					 uint32_t *pnNeeded,
					 const tTLVDefn  TLVs[]);

#define SigFfAID (0x0001)

void dot11f_unpack_ff_action(tpAniSirGlobal pCtx,
			     uint8_t *pBuf,
			     tDot11fFfAction *pDst)
{
	pDst->action = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_action. */

#define SigFfAction (0x0002)

#define SigFfAuthAlgo (0x0003)

#define SigFfAuthSeqNo (0x0004)

#define SigFfBeaconInterval (0x0005)

void dot11f_unpack_ff_capabilities(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   tDot11fFfCapabilities *pDst)
{
	uint16_t tmp0__;
	framesntohs(pCtx, &tmp0__, pBuf, 0);
	pDst->ess = tmp0__ >> 0 & 0x1;
	pDst->ibss = tmp0__ >> 1 & 0x1;
	pDst->cfPollable = tmp0__ >> 2 & 0x1;
	pDst->cfPollReq = tmp0__ >> 3 & 0x1;
	pDst->privacy = tmp0__ >> 4 & 0x1;
	pDst->shortPreamble = tmp0__ >> 5 & 0x1;
	pDst->pbcc = tmp0__ >> 6 & 0x1;
	pDst->channelAgility = tmp0__ >> 7 & 0x1;
	pDst->spectrumMgt = tmp0__ >> 8 & 0x1;
	pDst->qos = tmp0__ >> 9 & 0x1;
	pDst->shortSlotTime = tmp0__ >> 10 & 0x1;
	pDst->apsd = tmp0__ >> 11 & 0x1;
	pDst->rrm = tmp0__ >> 12 & 0x1;
	pDst->dsssOfdm = tmp0__ >> 13 & 0x1;
	pDst->delayedBA = tmp0__ >> 14 & 0x1;
	pDst->immediateBA = tmp0__ >> 15 & 0x1;
	(void)pCtx;
} /* End dot11f_unpack_ff_capabilities. */

#define SigFfCapabilities (0x0006)

void dot11f_unpack_ff_category(tpAniSirGlobal pCtx,
			       uint8_t *pBuf,
			       tDot11fFfCategory *pDst)
{
	pDst->category = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_category. */

#define SigFfCategory (0x0007)

void dot11f_unpack_ff_current_ap_address(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       tDot11fFfCurrentAPAddress *pDst)
{
	DOT11F_MEMCPY(pCtx, pDst->mac, pBuf, 6);
	(void)pCtx;
} /* End dot11f_unpack_ff_current_ap_address. */

#define SigFfCurrentAPAddress (0x0008)

void dot11f_unpack_ff_dialog_token(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  tDot11fFfDialogToken *pDst)
{
	pDst->token = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_dialog_token. */

#define SigFfDialogToken (0x0009)

void dot11f_unpack_ff_link_margin(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 tDot11fFfLinkMargin *pDst)
{
	pDst->linkMargin = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_link_margin. */

#define SigFfLinkMargin (0x000a)

#define SigFfListenInterval (0x000b)

void dot11f_unpack_ff_max_tx_power(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 tDot11fFfMaxTxPower *pDst)
{
	pDst->maxTxPower = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_max_tx_power. */

#define SigFfMaxTxPower (0x000c)

void dot11f_unpack_ff_num_of_repetitions(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       tDot11fFfNumOfRepetitions *pDst)
{
	framesntohs(pCtx, &pDst->repetitions, pBuf, 0);
	(void)pCtx;
} /* End dot11f_unpack_ff_num_of_repetitions. */

#define SigFfNumOfRepetitions (0x000d)

void dot11f_unpack_ff_operating_mode(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    tDot11fFfOperatingMode *pDst)
{
	uint8_t tmp1__;
	tmp1__ = *pBuf;
	pDst->chanWidth = tmp1__ >> 0 & 0x3;
	pDst->reserved = tmp1__ >> 2 & 0x3;
	pDst->rxNSS = tmp1__ >> 4 & 0x7;
	pDst->rxNSSType = tmp1__ >> 7 & 0x1;
	(void)pCtx;
} /* End dot11f_unpack_ff_operating_mode. */

#define SigFfOperatingMode (0x000e)

void dot11f_unpack_ff_rcpi(tpAniSirGlobal pCtx,
			   uint8_t *pBuf,
			   tDot11fFfRCPI *pDst)
{
	pDst->rcpi = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_rcpi. */

#define SigFfRCPI (0x000f)

void dot11f_unpack_ff_rsni(tpAniSirGlobal pCtx,
			   uint8_t *pBuf,
			   tDot11fFfRSNI *pDst)
{
	pDst->rsni = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_rsni. */

#define SigFfRSNI (0x0010)

#define SigFfReason (0x0011)

void dot11f_unpack_ff_rx_antenna_id(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  tDot11fFfRxAntennaId *pDst)
{
	pDst->antennaId = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_rx_antenna_id. */

#define SigFfRxAntennaId (0x0012)

void dot11f_unpack_ff_sm_power_mode_set(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     tDot11fFfSMPowerModeSet *pDst)
{
	uint8_t tmp2__;
	tmp2__ = *pBuf;
	pDst->PowerSave_En = tmp2__ >> 0 & 0x1;
	pDst->Mode = tmp2__ >> 1 & 0x1;
	pDst->reserved = tmp2__ >> 2 & 0x3f;
	(void)pCtx;
} /* End dot11f_unpack_ff_sm_power_mode_set. */

#define SigFfSMPowerModeSet (0x0013)

#define SigFfStatus (0x0014)

void dot11f_unpack_ff_status_code(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 tDot11fFfStatusCode *pDst)
{
	pDst->statusCode = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_status_code. */

#define SigFfStatusCode (0x0015)

void dot11f_unpack_ff_tpc_ele_id(tpAniSirGlobal pCtx,
			       uint8_t *pBuf,
			       tDot11fFfTPCEleID *pDst)
{
	pDst->TPCId = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_tpc_ele_id. */

#define SigFfTPCEleID (0x0016)

void dot11f_unpack_ff_tpc_ele_len(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 tDot11fFfTPCEleLen *pDst)
{
	pDst->TPCLen = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_tpc_ele_len. */

#define SigFfTPCEleLen (0x0017)

void dot11f_unpack_ff_ts_info(tpAniSirGlobal pCtx,
			     uint8_t *pBuf,
			     tDot11fFfTSInfo *pDst)
{
	uint32_t tmp3__;
	framesntohl(pCtx, &tmp3__, pBuf, 0);
	pDst->traffic_type = tmp3__ >> 0 & 0x1;
	pDst->tsid = tmp3__ >> 1 & 0xf;
	pDst->direction = tmp3__ >> 5 & 0x3;
	pDst->access_policy = tmp3__ >> 7 & 0x3;
	pDst->aggregation = tmp3__ >> 9 & 0x1;
	pDst->psb = tmp3__ >> 10 & 0x1;
	pDst->user_priority = tmp3__ >> 11 & 0x7;
	pDst->tsinfo_ack_pol = tmp3__ >> 14 & 0x3;
	pDst->schedule = tmp3__ >> 16 & 0x1;
	pDst->unused = tmp3__ >> 17 & 0x7fff;
	(void)pCtx;
} /* End dot11f_unpack_ff_ts_info. */

#define SigFfTSInfo (0x0018)

void dot11f_unpack_ff_time_stamp(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 tDot11fFfTimeStamp *pDst)
{
	framesntohq(pCtx, &pDst->timestamp, pBuf, 0);
	(void)pCtx;
} /* End dot11f_unpack_ff_time_stamp. */

#define SigFfTimeStamp (0x0019)

void dot11f_unpack_ff_transaction_id(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    tDot11fFfTransactionId *pDst)
{
	DOT11F_MEMCPY(pCtx, pDst->transId, pBuf, 2);
	(void)pCtx;
} /* End dot11f_unpack_ff_transaction_id. */

#define SigFfTransactionId (0x001a)

void dot11f_unpack_ff_tx_antenna_id(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  tDot11fFfTxAntennaId *pDst)
{
	pDst->antennaId = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_tx_antenna_id. */

#define SigFfTxAntennaId (0x001b)

void dot11f_unpack_ff_tx_power(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      tDot11fFfTxPower *pDst)
{
	pDst->txPower = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_tx_power. */

#define SigFfTxPower (0x001c)

void dot11f_unpack_ff_vht_membership_status_array(tpAniSirGlobal pCtx,
					       uint8_t *pBuf,
					       tDot11fFfVhtMembershipStatusArray *pDst)
{
	DOT11F_MEMCPY(pCtx, pDst->membershipStatusArray, pBuf, 8);
	(void)pCtx;
} /* End dot11f_unpack_ff_vht_membership_status_array. */

#define SigFfVhtMembershipStatusArray (0x001d)

void dot11f_unpack_ff_vht_user_position_array(tpAniSirGlobal pCtx,
					   uint8_t *pBuf,
					   tDot11fFfVhtUserPositionArray *pDst)
{
	DOT11F_MEMCPY(pCtx, pDst->userPositionArray, pBuf, 16);
	(void)pCtx;
} /* End dot11f_unpack_ff_vht_user_position_array. */

#define SigFfVhtUserPositionArray (0x001e)

void dot11f_unpack_ff_ext_chan_switch_ann_action(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 tDot11fFfext_chan_switch_ann_action *pDst)
{
	uint32_t tmp4__;
	framesntohl(pCtx, &tmp4__, pBuf, 0);
	pDst->switch_mode = tmp4__ >> 0 & 0xff;
	pDst->op_class = tmp4__ >> 8 & 0xff;
	pDst->new_channel = tmp4__ >> 16 & 0xff;
	pDst->switch_count = tmp4__ >> 24 & 0xff;
	(void)pCtx;
} /* End dot11f_unpack_ff_ext_chan_switch_ann_action. */

#define SigFfext_chan_switch_ann_action (0x001f)

void dot11f_unpack_ff_p2p_action_oui(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     tDot11fFfp2p_action_oui *pDst)
{
	DOT11F_MEMCPY(pCtx, pDst->oui_data, pBuf, 4);
	(void)pCtx;
} /* End dot11f_unpack_ff_p2p_action_oui. */

#define SigFfp2p_action_oui (0x0020)

void dot11f_unpack_ff_p2p_action_subtype(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 tDot11fFfp2p_action_subtype *pDst)
{
	pDst->subtype = *pBuf;
	(void)pCtx;
} /* End dot11f_unpack_ff_p2p_action_subtype. */

#define SigFfp2p_action_subtype (0x0021)

uint32_t dot11f_unpack_tlv_authorized_ma_cs(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint16_t tlvlen,
					  tDot11fTLVAuthorizedMACs *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->mac, pBuf, 6);
	pBuf += 6;
	tlvlen -= (uint8_t)6;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_authorized_ma_cs. */

#define SigTlvAuthorizedMACs (0x0001)


#define SigTlvRequestToEnroll (0x0002)


uint32_t dot11f_unpack_tlv_version2(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint16_t tlvlen,
				    tDot11fTLVVersion2 *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp5__;
	pDst->present = 1;
	tmp5__ = *pBuf;
	pBuf += 1;
	tlvlen -= 1;
	pDst->minor = tmp5__ >> 0 & 0xf;
	pDst->major = tmp5__ >> 4 & 0xf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_version2. */

#define SigTlvVersion2 (0x0003)


#define SigTlvAPSetupLocked (0x0004)


#define SigTlvAssociationState (0x0005)


#define SigTlvConfigMethods (0x0006)


#define SigTlvConfigurationError (0x0007)


uint32_t dot11f_unpack_tlv_device_name(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint16_t tlvlen,
				      tDot11fTLVDeviceName *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_text = (uint8_t)(tlvlen);
	if (tlvlen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->text, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_device_name. */

#define SigTlvDeviceName (0x0008)


#define SigTlvDevicePasswordID (0x0009)


uint32_t dot11f_unpack_tlv_extended_listen_timing(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint16_t tlvlen,
						 tDot11fTLVExtendedListenTiming *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->availibilityPeriod, pBuf, 0);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->availibilityInterval, pBuf, 0);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_extended_listen_timing. */

#define SigTlvExtendedListenTiming (0x000a)


uint32_t dot11f_unpack_tlv_listen_channel(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVListenChannel *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->countryString, pBuf, 3);
	pBuf += 3;
	tlvlen -= (uint8_t)3;
	pDst->regulatoryClass = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->channel = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_listen_channel. */

#define SigTlvListenChannel (0x000b)


uint32_t dot11f_unpack_tlv_manufacturer(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVManufacturer *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_name = (uint8_t)(tlvlen);
	if (tlvlen > 64) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->name, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_manufacturer. */

#define SigTlvManufacturer (0x000c)


#define SigTlvMinorReasonCode (0x000d)


uint32_t dot11f_unpack_tlv_model_name(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint16_t tlvlen,
				     tDot11fTLVModelName *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_text = (uint8_t)(tlvlen);
	if (tlvlen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->text, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_model_name. */

#define SigTlvModelName (0x000e)


uint32_t dot11f_unpack_tlv_model_number(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint16_t tlvlen,
				       tDot11fTLVModelNumber *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_text = (uint8_t)(tlvlen);
	if (tlvlen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->text, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_model_number. */

#define SigTlvModelNumber (0x000f)


uint32_t dot11f_unpack_tlv_notice_of_absence(tpAniSirGlobal pCtx,
					   uint8_t *pBuf,
					   uint16_t tlvlen,
					   tDot11fTLVNoticeOfAbsence *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->index = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->CTSWindowOppPS = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->num_NoADesc = (uint8_t)(tlvlen);
	if (tlvlen > 36) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->NoADesc, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_notice_of_absence. */

#define SigTlvNoticeOfAbsence (0x0010)


uint32_t dot11f_unpack_tlv_operating_channel(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint16_t tlvlen,
					    tDot11fTLVOperatingChannel *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->countryString, pBuf, 3);
	pBuf += 3;
	tlvlen -= (uint8_t)3;
	pDst->regulatoryClass = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->channel = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_operating_channel. */

#define SigTlvOperatingChannel (0x0011)


uint32_t dot11f_unpack_tlv_p2_p_capability(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVP2PCapability *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->deviceCapability = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->groupCapability = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_p2_p_capability. */

#define SigTlvP2PCapability (0x0012)


uint32_t dot11f_unpack_tlv_p2_p_device_id(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint16_t tlvlen,
				       tDot11fTLVP2PDeviceId *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
	pBuf += 6;
	tlvlen -= (uint8_t)6;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_p2_p_device_id. */

#define SigTlvP2PDeviceId (0x0013)


static const tTLVDefn TLVS_P2PDeviceInfo[] = {
	{ offsetof(tDot11fTLVP2PDeviceInfo, DeviceName),
	offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName,
	DOT11F_TLV_DEVICENAME, 0, 4, 36, 1, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_tlv_p2_p_device_info(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVP2PDeviceInfo *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
	pBuf += 6;
	tlvlen -= (uint8_t)6;
	framesntohs(pCtx, &pDst->configMethod, pBuf, 0);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	DOT11F_MEMCPY(pCtx, pDst->primaryDeviceType, pBuf, 8);
	pBuf += 8;
	tlvlen -= (uint8_t)8;
	(void)pCtx;
	status |= unpack_tlv_core(pCtx,
				  pBuf,
				  tlvlen,
				  TLVS_P2PDeviceInfo,
				  (uint8_t *)pDst,
				  sizeof(*pDst));
	return status;
} /* End dot11f_unpack_tlv_p2_p_device_info. */

#define SigTlvP2PDeviceInfo (0x0014)


uint32_t dot11f_unpack_tlv_p2_p_group_info(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVP2PGroupInfo *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_P2PClientInfoDesc = (uint8_t)(tlvlen);
	DOT11F_MEMCPY(pCtx, pDst->P2PClientInfoDesc, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_p2_p_group_info. */

#define SigTlvP2PGroupInfo (0x0015)


#define SigTlvP2PStatus (0x0016)


uint32_t dot11f_unpack_tlv_primary_device_type(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint16_t tlvlen,
					     tDot11fTLVPrimaryDeviceType *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)tlvlen; /* Shutup the compiler */
	pDst->present = 1;
	framesntohs(pCtx, &pDst->primary_category, pBuf, 1);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	DOT11F_MEMCPY(pCtx, pDst->oui, pBuf, 4);
	pBuf += 4;
	tlvlen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->sub_category, pBuf, 1);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_primary_device_type. */

#define SigTlvPrimaryDeviceType (0x0017)


#define SigTlvRFBands (0x0018)


uint32_t dot11f_unpack_tlv_request_device_type(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint16_t tlvlen,
					     tDot11fTLVRequestDeviceType *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->primary_category, pBuf, 1);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	DOT11F_MEMCPY(pCtx, pDst->oui, pBuf, 4);
	pBuf += 4;
	tlvlen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->sub_category, pBuf, 1);
	pBuf += 2;
	tlvlen -= (uint8_t)2;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_request_device_type. */

#define SigTlvRequestDeviceType (0x0019)


#define SigTlvRequestType (0x001a)


#define SigTlvResponseType (0x001b)


#define SigTlvSelectedRegistrar (0x001c)


#define SigTlvSelectedRegistrarConfigMethods (0x001d)


uint32_t dot11f_unpack_tlv_serial_number(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVSerialNumber *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->num_text = (uint8_t)(tlvlen);
	if (tlvlen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->text, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_serial_number. */

#define SigTlvSerialNumber (0x001e)


uint32_t dot11f_unpack_tlv_uuid_e(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint16_t tlvlen,
				  tDot11fTLVUUID_E *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->uuid, pBuf, 16);
	pBuf += 16;
	tlvlen -= (uint8_t)16;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_uuid_e. */

#define SigTlvUUID_E (0x001f)


uint32_t dot11f_unpack_tlv_uuid_r(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint16_t tlvlen,
				  tDot11fTLVUUID_R *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->uuid, pBuf, 16);
	pBuf += 16;
	tlvlen -= (uint8_t)16;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_uuid_r. */

#define SigTlvUUID_R (0x0020)


static const tTLVDefn TLVS_VendorExtension[] = {
	{ offsetof(tDot11fTLVVendorExtension, Version2),
	offsetof(tDot11fTLVVersion2, present), "Version2", SigTlvVersion2,
	DOT11F_TLV_VERSION2, 0, 3, 3, 0, 1, 1, 1, },
	{ offsetof(tDot11fTLVVendorExtension, AuthorizedMACs),
	offsetof(tDot11fTLVAuthorizedMACs, present), "AuthorizedMACs",
	SigTlvAuthorizedMACs, DOT11F_TLV_AUTHORIZEDMACS, 0, 8, 8, 0, 1, 1, 1, },
	{ offsetof(tDot11fTLVVendorExtension, RequestToEnroll),
	offsetof(tDot11fTLVRequestToEnroll, present), "RequestToEnroll",
	SigTlvRequestToEnroll, DOT11F_TLV_REQUESTTOENROLL,
	0, 3, 3, 0, 1, 1, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_tlv_vendor_extension(tpAniSirGlobal pCtx,
					   uint8_t *pBuf,
					   uint16_t tlvlen,
					   tDot11fTLVVendorExtension *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->vendorId, pBuf, 3);
	pBuf += 3;
	tlvlen -= (uint8_t)3;
	(void)pCtx;
	status |= unpack_tlv_core(pCtx,
				  pBuf,
				  tlvlen,
				  TLVS_VendorExtension,
				  (uint8_t *)pDst,
				  sizeof(*pDst));
	return status;
} /* End dot11f_unpack_tlv_vendor_extension. */

#define SigTlvVendorExtension (0x0021)


uint32_t dot11f_unpack_tlv_version(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint16_t tlvlen,
				   tDot11fTLVVersion *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp6__;
	pDst->present = 1;
	tmp6__ = *pBuf;
	pBuf += 1;
	tlvlen -= 1;
	pDst->minor = tmp6__ >> 0 & 0xf;
	pDst->major = tmp6__ >> 4 & 0xf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_version. */

#define SigTlvVersion (0x0022)


#define SigTlvWPSState (0x0023)


#define SigTlvassoc_disallowed (0x0024)


#define SigTlvassoc_retry_delay (0x0025)


#define SigTlvcellular_data_cap (0x0026)


#define SigTlvcellular_data_con_pref (0x0027)


#define SigTlvmbo_ap_cap (0x0028)


uint32_t dot11f_unpack_tlv_non_prefferd_chan_rep(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint16_t tlvlen,
						 tDot11fTLVnon_prefferd_chan_rep *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->oper_class = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->num_channel_report = (uint8_t)(tlvlen);
	if (tlvlen > 254) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->channel_report, pBuf, (tlvlen));
	pBuf += (tlvlen);
	tlvlen -= (tlvlen);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_non_prefferd_chan_rep. */

#define SigTlvnon_prefferd_chan_rep (0x0029)


uint32_t dot11f_unpack_tlv_oce_cap(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint16_t tlvlen,
				   tDot11fTLVoce_cap *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp7__;
	pDst->present = 1;
	tmp7__ = *pBuf;
	pBuf += 1;
	tlvlen -= 1;
	pDst->oce_release = tmp7__ >> 0 & 0x7;
	pDst->is_sta_cfon = tmp7__ >> 3 & 0x1;
	pDst->non_oce_ap_present = tmp7__ >> 4 & 0x1;
	pDst->reserved = tmp7__ >> 5 & 0x7;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_oce_cap. */

#define SigTlvoce_cap (0x002a)


uint32_t dot11f_unpack_tlv_reduced_wan_metrics(tpAniSirGlobal pCtx,
					       uint8_t *pBuf,
					       uint16_t tlvlen,
					       tDot11fTLVreduced_wan_metrics *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp8__;
	pDst->present = 1;
	tmp8__ = *pBuf;
	pBuf += 1;
	tlvlen -= 1;
	pDst->downlink_av_cap = tmp8__ >> 0 & 0xf;
	pDst->uplink_av_cap = tmp8__ >> 4 & 0xf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_reduced_wan_metrics. */

#define SigTlvreduced_wan_metrics (0x002b)


uint32_t dot11f_unpack_tlv_rssi_assoc_rej(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint16_t tlvlen,
					  tDot11fTLVrssi_assoc_rej *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	pDst->delta_rssi = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	pDst->retry_delay = *pBuf;
	pBuf += 1;
	tlvlen -= (uint8_t)1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_rssi_assoc_rej. */

#define SigTlvrssi_assoc_rej (0x002c)


#define SigTlvtransition_reason (0x002d)


#define SigTlvtransition_reject_reason (0x002e)


uint32_t dot11f_unpack_tlv_p2_p_interface(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint16_t tlvlen,
					 tDot11fTLVP2PInterface *pDst)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
	pBuf += 6;
	tlvlen -= (uint8_t)6;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_tlv_p2_p_interface. */

#define SigTlvP2PInterface (0x002f)


#define SigTlvP2PManageability (0x0030)


uint32_t dot11f_unpack_ie_gtk(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIEGTK *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp9__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp9__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->keyId = tmp9__ >> 0 & 0x3;
	pDst->reserved = tmp9__ >> 2 & 0x3feb;
	pDst->keyLength = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	DOT11F_MEMCPY(pCtx, pDst->RSC, pBuf, 8);
	pBuf += 8;
	ielen -= (uint8_t)8;
	pDst->num_key = (uint8_t)(ielen);
	if (ielen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->key, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_gtk. */

#define SigIeGTK (0x0001)


uint32_t dot11f_unpack_ie_igtk(tpAniSirGlobal pCtx,
			       uint8_t *pBuf,
			       uint8_t ielen,
			       tDot11fIEIGTK *pDst,
			       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->keyID, pBuf, 2);
	pBuf += 2;
	ielen -= (uint8_t)2;
	DOT11F_MEMCPY(pCtx, pDst->IPN, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	pDst->keyLength = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	DOT11F_MEMCPY(pCtx, pDst->key, pBuf, 24);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_igtk. */

#define SigIeIGTK (0x0002)


uint32_t dot11f_unpack_ie_r0_kh_id(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIER0KH_ID *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_PMK_R0_ID = (uint8_t)(ielen);
	if (ielen > 48) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->PMK_R0_ID, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_r0_kh_id. */

#define SigIeR0KH_ID (0x0003)


uint32_t dot11f_unpack_ie_r1_kh_id(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIER1KH_ID *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->PMK_R1_ID, pBuf, 6);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_r1_kh_id. */

#define SigIeR1KH_ID (0x0004)


uint32_t dot11f_unpack_ie_ap_channel_report(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIEAPChannelReport *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->regulatoryClass = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_channelList = (uint8_t)(ielen);
	if (ielen > 50) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->channelList, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ap_channel_report. */

#define SigIeAPChannelReport (0x0005)


uint32_t dot11f_unpack_ie_bcn_reporting_detail(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint8_t ielen,
					     tDot11fIEBcnReportingDetail *pDst,
					     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->reportingDetail = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_bcn_reporting_detail. */

#define SigIeBcnReportingDetail (0x0006)


uint32_t dot11f_unpack_ie_beacon_report_frm_body(tpAniSirGlobal pCtx,
					      uint8_t *pBuf,
					      uint8_t ielen,
					      tDot11fIEBeaconReportFrmBody *pDst,
					      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_reportedFields = (uint8_t)(ielen);
	if (ielen > 224) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->reportedFields, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_beacon_report_frm_body. */

#define SigIeBeaconReportFrmBody (0x0007)


uint32_t dot11f_unpack_ie_beacon_reporting(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIEBeaconReporting *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->reportingCondition = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->threshold = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_beacon_reporting. */

#define SigIeBeaconReporting (0x0008)


uint32_t dot11f_unpack_ie_condensed_country_str(tpAniSirGlobal pCtx,
					      uint8_t *pBuf,
					      uint8_t ielen,
					      tDot11fIECondensedCountryStr *pDst,
					      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->countryStr, pBuf, 2);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_condensed_country_str. */

#define SigIeCondensedCountryStr (0x0009)


uint32_t dot11f_unpack_ie_measurement_pilot(tpAniSirGlobal pCtx,
					   uint8_t *pBuf,
					   uint8_t ielen,
					   tDot11fIEMeasurementPilot *pDst,
					   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->measurementPilot = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_vendorSpecific = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->vendorSpecific, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_measurement_pilot. */

#define SigIeMeasurementPilot (0x000a)


uint32_t dot11f_unpack_ie_multi_bssid(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEMultiBssid *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->maxBSSIDIndicator = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_vendorSpecific = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->vendorSpecific, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_multi_bssid. */

#define SigIeMultiBssid (0x000b)


uint32_t dot11f_unpack_ie_ric_data(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIERICData *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->Identifier = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->resourceDescCount = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->statusCode, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ric_data. */

#define SigIeRICData (0x000c)


uint32_t dot11f_unpack_ie_ric_descriptor(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIERICDescriptor *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->resourceType = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_variableData = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->variableData, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ric_descriptor. */

#define SigIeRICDescriptor (0x000d)


uint32_t dot11f_unpack_ie_rrm_enabled_cap(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIERRMEnabledCap *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp10__;
	uint8_t tmp11__;
	uint8_t tmp12__;
	uint8_t tmp13__;
	uint8_t tmp14__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp10__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->LinkMeasurement = tmp10__ >> 0 & 0x1;
	pDst->NeighborRpt = tmp10__ >> 1 & 0x1;
	pDst->parallel = tmp10__ >> 2 & 0x1;
	pDst->repeated = tmp10__ >> 3 & 0x1;
	pDst->BeaconPassive = tmp10__ >> 4 & 0x1;
	pDst->BeaconActive = tmp10__ >> 5 & 0x1;
	pDst->BeaconTable = tmp10__ >> 6 & 0x1;
	pDst->BeaconRepCond = tmp10__ >> 7 & 0x1;
	tmp11__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->FrameMeasurement = tmp11__ >> 0 & 0x1;
	pDst->ChannelLoad = tmp11__ >> 1 & 0x1;
	pDst->NoiseHistogram = tmp11__ >> 2 & 0x1;
	pDst->statistics = tmp11__ >> 3 & 0x1;
	pDst->LCIMeasurement = tmp11__ >> 4 & 0x1;
	pDst->LCIAzimuth = tmp11__ >> 5 & 0x1;
	pDst->TCMCapability = tmp11__ >> 6 & 0x1;
	pDst->triggeredTCM = tmp11__ >> 7 & 0x1;
	tmp12__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->APChanReport = tmp12__ >> 0 & 0x1;
	pDst->RRMMIBEnabled = tmp12__ >> 1 & 0x1;
	pDst->operatingChanMax = tmp12__ >> 2 & 0x7;
	pDst->nonOperatinChanMax = tmp12__ >> 5 & 0x7;
	tmp13__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->MeasurementPilot = tmp13__ >> 0 & 0x7;
	pDst->MeasurementPilotEnabled = tmp13__ >> 3 & 0x1;
	pDst->NeighborTSFOffset = tmp13__ >> 4 & 0x1;
	pDst->RCPIMeasurement = tmp13__ >> 5 & 0x1;
	pDst->RSNIMeasurement = tmp13__ >> 6 & 0x1;
	pDst->BssAvgAccessDelay = tmp13__ >> 7 & 0x1;
	tmp14__ = *pBuf;
	pDst->BSSAvailAdmission = tmp14__ >> 0 & 0x1;
	pDst->AntennaInformation = tmp14__ >> 1 & 0x1;
	pDst->fine_time_meas_rpt = tmp14__ >> 2 & 0x1;
	pDst->lci_capability = tmp14__ >> 3 & 0x1;
	pDst->reserved = tmp14__ >> 4 & 0xf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_rrm_enabled_cap. */

#define SigIeRRMEnabledCap (0x000e)


uint32_t dot11f_unpack_ie_requested_info(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIERequestedInfo *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_requested_eids = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->requested_eids, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_requested_info. */

#define SigIeRequestedInfo (0x000f)


uint32_t dot11f_unpack_ie_ssid(tpAniSirGlobal pCtx,
			       uint8_t *pBuf,
			       uint8_t ielen,
			       tDot11fIESSID *pDst,
			       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present) {
		status = DOT11F_DUPLICATE_IE;
		return status;
	}
	pDst->present = 1;
	pDst->num_ssid = (uint8_t)(ielen);
	if (ielen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->ssid, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ssid. */

#define SigIeSSID (0x0010)


uint32_t dot11f_unpack_ie_schedule(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIESchedule *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp15__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp15__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->aggregation = tmp15__ >> 0 & 0x1;
	pDst->tsid = tmp15__ >> 1 & 0xf;
	pDst->direction = tmp15__ >> 5 & 0x3;
	pDst->reserved = tmp15__ >> 7 & 0x1ff;
	framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->service_interval, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->max_service_dur, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->spec_interval, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_schedule. */

#define SigIeSchedule (0x0011)


uint32_t dot11f_unpack_ie_tclas(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIETCLAS *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->user_priority = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->classifier_type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->classifier_mask = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	switch (pDst->classifier_type) {
	case 0:
		DOT11F_MEMCPY(pCtx, pDst->info.EthParams.source, pBuf, 6);
		pBuf += 6;
		ielen -= (uint8_t)6;
		DOT11F_MEMCPY(pCtx, pDst->info.EthParams.dest, pBuf, 6);
		pBuf += 6;
		ielen -= (uint8_t)6;
		framesntohs(pCtx, &pDst->info.EthParams.type, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	case 1:
		pDst->info.IpParams.version = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		switch (pDst->info.IpParams.version) {
		case 4:
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.source, pBuf, 4);
			pBuf += 4;
			ielen -= (uint8_t)4;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.dest, pBuf, 4);
			pBuf += 4;
			ielen -= (uint8_t)4;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.src_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.dest_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			pDst->info.IpParams.params.IpV4Params.DSCP = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->info.IpParams.params.IpV4Params.proto = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->info.IpParams.params.IpV4Params.reserved = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			break;
		case 6:
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.source, pBuf, 16);
			pBuf += 16;
			ielen -= (uint8_t)16;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.dest, pBuf, 16);
			pBuf += 16;
			ielen -= (uint8_t)16;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.src_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.dest_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.flow_label, pBuf, 3);
			pBuf += 3;
			ielen -= (uint8_t)3;
			break;
		}
		break;
	case 2:
		framesntohs(pCtx, &pDst->info.Params8021dq.tag_type, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tclas. */

#define SigIeTCLAS (0x0012)


#define SigIeTCLASSPROC (0x0013)


uint32_t dot11f_unpack_ie_ts_delay(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIETSDelay *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohl(pCtx, &pDst->delay, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ts_delay. */

#define SigIeTSDelay (0x0014)


uint32_t dot11f_unpack_ie_tsf_info(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIETSFInfo *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->TsfOffset, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->BeaconIntvl, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tsf_info. */

#define SigIeTSFInfo (0x0015)


uint32_t dot11f_unpack_ie_tspec(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIETSPEC *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp16__;
	uint8_t tmp17__;
	uint16_t tmp18__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp16__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->traffic_type = tmp16__ >> 0 & 0x1;
	pDst->tsid = tmp16__ >> 1 & 0xf;
	pDst->direction = tmp16__ >> 5 & 0x3;
	pDst->access_policy = tmp16__ >> 7 & 0x3;
	pDst->aggregation = tmp16__ >> 9 & 0x1;
	pDst->psb = tmp16__ >> 10 & 0x1;
	pDst->user_priority = tmp16__ >> 11 & 0x7;
	pDst->tsinfo_ack_pol = tmp16__ >> 14 & 0x3;
	tmp17__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->schedule = tmp17__ >> 0 & 0x1;
	pDst->unused = tmp17__ >> 1 & 0x7f;
	framesntohs(pCtx, &tmp18__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->size = tmp18__ >> 0 & 0x7fff;
	pDst->fixed = tmp18__ >> 15 & 0x1;
	framesntohs(pCtx, &pDst->max_msdu_size, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohl(pCtx, &pDst->min_service_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->max_service_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->inactivity_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->suspension_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->min_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->mean_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->peak_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->burst_size, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->delay_bound, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->min_phy_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->surplus_bw_allowance, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->medium_time, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tspec. */

#define SigIeTSPEC (0x0016)


uint32_t dot11f_unpack_ie_vht_caps(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIEVHTCaps *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t tmp19__;
	uint16_t tmp20__;
	uint16_t tmp21__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohl(pCtx, &tmp19__, pBuf, 0);
	pBuf += 4;
	ielen -= 4;
	pDst->maxMPDULen = tmp19__ >> 0 & 0x3;
	pDst->supportedChannelWidthSet = tmp19__ >> 2 & 0x3;
	pDst->ldpcCodingCap = tmp19__ >> 4 & 0x1;
	pDst->shortGI80MHz = tmp19__ >> 5 & 0x1;
	pDst->shortGI160and80plus80MHz = tmp19__ >> 6 & 0x1;
	pDst->txSTBC = tmp19__ >> 7 & 0x1;
	pDst->rxSTBC = tmp19__ >> 8 & 0x7;
	pDst->suBeamFormerCap = tmp19__ >> 11 & 0x1;
	pDst->suBeamformeeCap = tmp19__ >> 12 & 0x1;
	pDst->csnofBeamformerAntSup = tmp19__ >> 13 & 0x7;
	pDst->numSoundingDim = tmp19__ >> 16 & 0x7;
	pDst->muBeamformerCap = tmp19__ >> 19 & 0x1;
	pDst->muBeamformeeCap = tmp19__ >> 20 & 0x1;
	pDst->vhtTXOPPS = tmp19__ >> 21 & 0x1;
	pDst->htcVHTCap = tmp19__ >> 22 & 0x1;
	pDst->maxAMPDULenExp = tmp19__ >> 23 & 0x7;
	pDst->vhtLinkAdaptCap = tmp19__ >> 26 & 0x3;
	pDst->rxAntPattern = tmp19__ >> 28 & 0x1;
	pDst->txAntPattern = tmp19__ >> 29 & 0x1;
	pDst->reserved1 = tmp19__ >> 30 & 0x3;
	framesntohs(pCtx, &pDst->rxMCSMap, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &tmp20__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->rxHighSupDataRate = tmp20__ >> 0 & 0x1fff;
	pDst->reserved2 = tmp20__ >> 13 & 0x7;
	framesntohs(pCtx, &pDst->txMCSMap, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &tmp21__, pBuf, 0);
	pDst->txSupDataRate = tmp21__ >> 0 & 0x1fff;
	pDst->reserved3 = tmp21__ >> 13 & 0x7;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vht_caps. */

#define SigIeVHTCaps (0x0017)


uint32_t dot11f_unpack_ie_vht_operation(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEVHTOperation *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->chanWidth = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->chanCenterFreqSeg1 = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->chanCenterFreqSeg2 = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->basicMCSSet, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vht_operation. */

#define SigIeVHTOperation (0x0018)


uint32_t dot11f_unpack_ie_wmm_schedule(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWMMSchedule *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp22__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	framesntohs(pCtx, &tmp22__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->aggregation = tmp22__ >> 0 & 0x1;
	pDst->tsid = tmp22__ >> 1 & 0xf;
	pDst->direction = tmp22__ >> 5 & 0x3;
	pDst->reserved = tmp22__ >> 7 & 0x1ff;
	framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->service_interval, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->max_service_dur, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->spec_interval, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmm_schedule. */

#define SigIeWMMSchedule (0x0019)


uint32_t dot11f_unpack_ie_wmmtclas(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIEWMMTCLAS *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	pDst->user_priority = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->classifier_type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->classifier_mask = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	switch (pDst->classifier_type) {
	case 0:
		DOT11F_MEMCPY(pCtx, pDst->info.EthParams.source, pBuf, 6);
		pBuf += 6;
		ielen -= (uint8_t)6;
		DOT11F_MEMCPY(pCtx, pDst->info.EthParams.dest, pBuf, 6);
		pBuf += 6;
		ielen -= (uint8_t)6;
		framesntohs(pCtx, &pDst->info.EthParams.type, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	case 1:
		pDst->info.IpParams.version = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		switch (pDst->info.IpParams.version) {
		case 4:
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.source, pBuf, 4);
			pBuf += 4;
			ielen -= (uint8_t)4;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.dest, pBuf, 4);
			pBuf += 4;
			ielen -= (uint8_t)4;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.src_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.dest_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			pDst->info.IpParams.params.IpV4Params.DSCP = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->info.IpParams.params.IpV4Params.proto = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->info.IpParams.params.IpV4Params.reserved = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			break;
		case 6:
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.source, pBuf, 16);
			pBuf += 16;
			ielen -= (uint8_t)16;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.dest, pBuf, 16);
			pBuf += 16;
			ielen -= (uint8_t)16;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.src_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.dest_port, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.flow_label, pBuf, 3);
			pBuf += 3;
			ielen -= (uint8_t)3;
			break;
		}
		break;
	case 2:
		framesntohs(pCtx, &pDst->info.Params8021dq.tag_type, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmmtclas. */

#define SigIeWMMTCLAS (0x001a)


uint32_t dot11f_unpack_ie_wmmtclasproc(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEWMMTCLASPROC *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	pDst->processing = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmmtclasproc. */

#define SigIeWMMTCLASPROC (0x001b)


uint32_t dot11f_unpack_ie_wmmts_delay(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEWMMTSDelay *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	framesntohl(pCtx, &pDst->delay, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmmts_delay. */

#define SigIeWMMTSDelay (0x001c)


uint32_t dot11f_unpack_ie_wmmtspec(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIEWMMTSPEC *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp23__;
	uint8_t tmp24__;
	uint16_t tmp25__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	framesntohs(pCtx, &tmp23__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->traffic_type = tmp23__ >> 0 & 0x1;
	pDst->tsid = tmp23__ >> 1 & 0xf;
	pDst->direction = tmp23__ >> 5 & 0x3;
	pDst->access_policy = tmp23__ >> 7 & 0x3;
	pDst->aggregation = tmp23__ >> 9 & 0x1;
	pDst->psb = tmp23__ >> 10 & 0x1;
	pDst->user_priority = tmp23__ >> 11 & 0x7;
	pDst->tsinfo_ack_pol = tmp23__ >> 14 & 0x3;
	tmp24__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->tsinfo_rsvd = tmp24__ >> 0 & 0x7f;
	pDst->burst_size_defn = tmp24__ >> 7 & 0x1;
	framesntohs(pCtx, &tmp25__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->size = tmp25__ >> 0 & 0x7fff;
	pDst->fixed = tmp25__ >> 15 & 0x1;
	framesntohs(pCtx, &pDst->max_msdu_size, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohl(pCtx, &pDst->min_service_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->max_service_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->inactivity_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->suspension_int, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->min_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->mean_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->peak_data_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->burst_size, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->delay_bound, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohl(pCtx, &pDst->min_phy_rate, pBuf, 0);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohs(pCtx, &pDst->surplus_bw_allowance, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->medium_time, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmmtspec. */

#define SigIeWMMTSPEC (0x001d)


uint32_t dot11f_unpack_ie_wider_bw_chan_switch_ann(tpAniSirGlobal pCtx,
					       uint8_t *pBuf,
					       uint8_t ielen,
					       tDot11fIEWiderBWChanSwitchAnn *pDst,
					       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->newChanWidth = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->newCenterChanFreq0 = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->newCenterChanFreq1 = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wider_bw_chan_switch_ann. */

#define SigIeWiderBWChanSwitchAnn (0x001e)


uint32_t dot11f_unpack_ie_azimuth_req(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEazimuth_req *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->request = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_azimuth_req. */

#define SigIeazimuth_req (0x001f)


uint32_t dot11f_unpack_ie_max_age(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIEmax_age *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->max_age, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_max_age. */

#define SigIemax_age (0x0020)


static const tFFDefn FFS_neighbor_rpt[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_neighbor_rpt[] = {
	{ offsetof(tDot11fIEneighbor_rpt, TSFInfo), offsetof(tDot11fIETSFInfo,
	present), 0, "TSFInfo", 0, 6, 6, SigIeTSFInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSFINFO, 0, 0, },
	{ offsetof(tDot11fIEneighbor_rpt, CondensedCountryStr),
	offsetof(tDot11fIECondensedCountryStr, present), 0, "CondensedCountryStr",
	0, 4, 4, SigIeCondensedCountryStr, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CONDENSEDCOUNTRYSTR, 0, 0, },
	{ offsetof(tDot11fIEneighbor_rpt, MeasurementPilot),
	offsetof(tDot11fIEMeasurementPilot, present), 0, "MeasurementPilot",
	0, 3, 258, SigIeMeasurementPilot, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTPILOT, 0, 0, },
	{ offsetof(tDot11fIEneighbor_rpt, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fIEneighbor_rpt, MultiBssid),
	offsetof(tDot11fIEMultiBssid, present), 0, "MultiBssid",
	0, 3, 258, SigIeMultiBssid, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MULTIBSSID, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_neighbor_rpt(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEneighbor_rpt *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp26__;
	uint8_t tmp27__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->bssid, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	tmp26__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->APReachability = tmp26__ >> 0 & 0x3;
	pDst->Security = tmp26__ >> 2 & 0x1;
	pDst->KeyScope = tmp26__ >> 3 & 0x1;
	pDst->SpecMgmtCap = tmp26__ >> 4 & 0x1;
	pDst->QosCap = tmp26__ >> 5 & 0x1;
	pDst->apsd = tmp26__ >> 6 & 0x1;
	pDst->rrm = tmp26__ >> 7 & 0x1;
	tmp27__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->DelayedBA = tmp27__ >> 0 & 0x1;
	pDst->ImmBA = tmp27__ >> 1 & 0x1;
	pDst->MobilityDomain = tmp27__ >> 2 & 0x1;
	pDst->reserved = tmp27__ >> 3 & 0x1f;
	framesntohs(pCtx, &pDst->reserved1, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	pDst->regulatoryClass = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->channel = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->PhyType = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_neighbor_rpt,
				IES_neighbor_rpt,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_neighbor_rpt. */

#define SigIeneighbor_rpt (0x0021)


uint32_t dot11f_unpack_ie_req_mac_addr(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEreq_mac_addr *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->addr, pBuf, 6);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_req_mac_addr. */

#define SigIereq_mac_addr (0x0022)


uint32_t dot11f_unpack_ie_tgt_mac_addr(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEtgt_mac_addr *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->addr, pBuf, 6);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tgt_mac_addr. */

#define SigIetgt_mac_addr (0x0023)


uint32_t dot11f_unpack_ie_vht_transmit_power_env(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint8_t ielen,
						 tDot11fIEvht_transmit_power_env *pDst,
						 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_bytes = (uint8_t)(ielen);
	if (ielen > 5) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->bytes, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vht_transmit_power_env. */

#define SigIevht_transmit_power_env (0x0024)


uint32_t dot11f_unpack_ie_aid(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIEAID *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->assocId, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_aid. */

#define SigIeAID (0x0025)


uint32_t dot11f_unpack_ie_cf_params(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIECFParams *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->cfp_count = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->cfp_period = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->cfp_maxduration, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->cfp_durremaining, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_cf_params. */

#define SigIeCFParams (0x0026)


uint32_t dot11f_unpack_ie_challenge_text(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEChallengeText *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_text = (uint8_t)(ielen);
	if (ielen > 253) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->text, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_challenge_text. */

#define SigIeChallengeText (0x0027)


uint32_t dot11f_unpack_ie_chan_switch_ann(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEChanSwitchAnn *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->switchMode = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->newChannel = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->switchCount = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_chan_switch_ann. */

#define SigIeChanSwitchAnn (0x0028)


static const tFFDefn FFS_ChannelSwitchWrapper[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ChannelSwitchWrapper[] = {
	{ offsetof(tDot11fIEChannelSwitchWrapper, WiderBWChanSwitchAnn),
	offsetof(tDot11fIEWiderBWChanSwitchAnn, present), 0,
	"WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fIEChannelSwitchWrapper, vht_transmit_power_env),
	offsetof(tDot11fIEvht_transmit_power_env, present), 0,
	"vht_transmit_power_env", 0, 4, 7, SigIevht_transmit_power_env,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_VHT_TRANSMIT_POWER_ENV, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_channel_switch_wrapper(tpAniSirGlobal pCtx,
					       uint8_t *pBuf,
					       uint8_t ielen,
					       tDot11fIEChannelSwitchWrapper *pDst,
					       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_ChannelSwitchWrapper,
				IES_ChannelSwitchWrapper,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_channel_switch_wrapper. */

#define SigIeChannelSwitchWrapper (0x0029)


uint32_t dot11f_unpack_ie_country(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIECountry *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->country, pBuf, 3);
	pBuf += 3;
	ielen -= (uint8_t)3;
	if (!ielen) {
		pDst->num_triplets = 0U;
		return 0U;
	} else {
		pDst->num_triplets = (uint8_t)(ielen / 3);
		if (ielen > 84 * 3) {
				pDst->present = 0;
				return DOT11F_SKIPPED_BAD_IE;
		}

		DOT11F_MEMCPY(pCtx, pDst->triplets, pBuf, (ielen));
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_country. */

#define SigIeCountry (0x002a)


#define SigIeDSParams (0x002b)


uint32_t dot11f_unpack_ie_edca_param_set(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEEDCAParamSet *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp28__;
	uint8_t tmp29__;
	uint8_t tmp30__;
	uint8_t tmp31__;
	uint8_t tmp32__;
	uint8_t tmp33__;
	uint8_t tmp34__;
	uint8_t tmp35__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->qos = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->reserved = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp28__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbe_aifsn = tmp28__ >> 0 & 0xf;
	pDst->acbe_acm = tmp28__ >> 4 & 0x1;
	pDst->acbe_aci = tmp28__ >> 5 & 0x3;
	pDst->unused1 = tmp28__ >> 7 & 0x1;
	tmp29__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbe_acwmin = tmp29__ >> 0 & 0xf;
	pDst->acbe_acwmax = tmp29__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acbe_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp30__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbk_aifsn = tmp30__ >> 0 & 0xf;
	pDst->acbk_acm = tmp30__ >> 4 & 0x1;
	pDst->acbk_aci = tmp30__ >> 5 & 0x3;
	pDst->unused2 = tmp30__ >> 7 & 0x1;
	tmp31__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbk_acwmin = tmp31__ >> 0 & 0xf;
	pDst->acbk_acwmax = tmp31__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acbk_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp32__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvi_aifsn = tmp32__ >> 0 & 0xf;
	pDst->acvi_acm = tmp32__ >> 4 & 0x1;
	pDst->acvi_aci = tmp32__ >> 5 & 0x3;
	pDst->unused3 = tmp32__ >> 7 & 0x1;
	tmp33__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvi_acwmin = tmp33__ >> 0 & 0xf;
	pDst->acvi_acwmax = tmp33__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acvi_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp34__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvo_aifsn = tmp34__ >> 0 & 0xf;
	pDst->acvo_acm = tmp34__ >> 4 & 0x1;
	pDst->acvo_aci = tmp34__ >> 5 & 0x3;
	pDst->unused4 = tmp34__ >> 7 & 0x1;
	tmp35__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvo_acwmin = tmp35__ >> 0 & 0xf;
	pDst->acvo_acwmax = tmp35__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acvo_txoplimit, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_edca_param_set. */

#define SigIeEDCAParamSet (0x002c)


uint32_t dot11f_unpack_ie_erp_info(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIEERPInfo *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp36__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp36__ = *pBuf;
	pDst->non_erp_present = tmp36__ >> 0 & 0x1;
	pDst->use_prot = tmp36__ >> 1 & 0x1;
	pDst->barker_preamble = tmp36__ >> 2 & 0x1;
	pDst->unused = tmp36__ >> 3 & 0x1f;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_erp_info. */

#define SigIeERPInfo (0x002d)


uint32_t dot11f_unpack_ie_ese_cckm_opaque(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEESECckmOpaque *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 20) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_cckm_opaque. */

#define SigIeESECckmOpaque (0x002e)


uint32_t dot11f_unpack_ie_ese_rad_mgmt_cap(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEESERadMgmtCap *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp37__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->mgmt_state = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp37__ = *pBuf;
	pDst->mbssid_mask = tmp37__ >> 0 & 0x7;
	pDst->reserved = tmp37__ >> 3 & 0x1f;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_rad_mgmt_cap. */

#define SigIeESERadMgmtCap (0x002f)


uint32_t dot11f_unpack_ie_ese_traf_strm_met(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEESETrafStrmMet *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->tsid = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->state = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->msmt_interval, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_traf_strm_met. */

#define SigIeESETrafStrmMet (0x0030)


uint32_t dot11f_unpack_ie_ese_traf_strm_rate_set(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint8_t ielen,
					     tDot11fIEESETrafStrmRateSet *pDst,
					     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->tsid = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_tsrates = (uint8_t)(ielen);
	if (ielen > 8) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->tsrates, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_traf_strm_rate_set. */

#define SigIeESETrafStrmRateSet (0x0031)


uint32_t dot11f_unpack_ie_ese_txmit_power(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEESETxmitPower *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->power_limit = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->reserved = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_txmit_power. */

#define SigIeESETxmitPower (0x0032)


uint32_t dot11f_unpack_ie_ese_version(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEESEVersion *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ese_version. */

#define SigIeESEVersion (0x0033)


uint32_t dot11f_unpack_ie_ESP_information(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIEESP_information *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_variable_data = (uint8_t)(ielen);
	if (ielen > 96) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->variable_data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ESP_information. */

#define SigIeESP_information (0x0034)


uint32_t dot11f_unpack_ie_ext_cap(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEExtCap *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;

	if (!ielen) /* Check to ensure copying of ielen bytes */
		goto endUnpackIeExtCap;
	pDst->num_bytes = (uint8_t)(ielen);
	if (ielen > 15) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->bytes, pBuf, (ielen));

endUnpackIeExtCap:
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ext_cap. */

#define SigIeExtCap (0x0035)


uint32_t dot11f_unpack_ie_ext_supp_rates(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEExtSuppRates *pDst,
				       bool append_ie)
{
	uint8_t i;
	uint8_t rate_indx = 0;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	for (i = 0; i < ielen; i++) {
		if ((DOT11F_IS_BG_RATE(pBuf[i] & 0x7F)) &&
			(rate_indx < 12)) {
			pDst->rates[rate_indx++] = pBuf[i];
		}
	}

	if (rate_indx == 0) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	pDst->num_rates = rate_indx;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ext_supp_rates. */

#define SigIeExtSuppRates (0x0036)


uint32_t dot11f_unpack_ie_fh_param_set(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEFHParamSet *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->dwell_time, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	pDst->hop_set = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->hop_pattern = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->hop_index = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fh_param_set. */

#define SigIeFHParamSet (0x0037)


uint32_t dot11f_unpack_ie_fh_params(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIEFHParams *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->radix = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->nchannels = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fh_params. */

#define SigIeFHParams (0x0038)


uint32_t dot11f_unpack_ie_fh_patt_table(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEFHPattTable *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->flag = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->nsets = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->modulus = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->offset = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_randtable = (uint8_t)(ielen);
	if (ielen > 251) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->randtable, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fh_patt_table. */

#define SigIeFHPattTable (0x0039)


static const tFFDefn FFS_FTInfo[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_FTInfo[] = {
	{ offsetof(tDot11fIEFTInfo, R1KH_ID), offsetof(tDot11fIER1KH_ID, present),
	0, "R1KH_ID", 0, 8, 8, SigIeR1KH_ID, {0, 0, 0, 0, 0},
	0, DOT11F_EID_R1KH_ID, 0, 0, },
	{ offsetof(tDot11fIEFTInfo, GTK), offsetof(tDot11fIEGTK, present), 0, "GTK",
	0, 18, 45, SigIeGTK, {0, 0, 0, 0, 0}, 0, DOT11F_EID_GTK, 0, 0, },
	{ offsetof(tDot11fIEFTInfo, R0KH_ID), offsetof(tDot11fIER0KH_ID, present),
	0, "R0KH_ID", 0, 3, 50, SigIeR0KH_ID, {0, 0, 0, 0, 0},
	0, DOT11F_EID_R0KH_ID, 0, 0, },
	{ offsetof(tDot11fIEFTInfo, IGTK), offsetof(tDot11fIEIGTK, present), 0,
	"IGTK", 0, 35, 35, SigIeIGTK, {0, 0, 0, 0, 0},
	0, DOT11F_EID_IGTK, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_ft_info(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEFTInfo *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp38__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp38__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->reserved = tmp38__ >> 0 & 0xff;
	pDst->IECount = tmp38__ >> 8 & 0xff;
	DOT11F_MEMCPY(pCtx, pDst->MIC, pBuf, 16);
	pBuf += 16;
	ielen -= (uint8_t)16;
	DOT11F_MEMCPY(pCtx, pDst->Anonce, pBuf, 32);
	pBuf += 32;
	ielen -= (uint8_t)32;
	DOT11F_MEMCPY(pCtx, pDst->Snonce, pBuf, 32);
	pBuf += 32;
	ielen -= (uint8_t)32;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_FTInfo,
				IES_FTInfo,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_ft_info. */

#define SigIeFTInfo (0x003a)


uint32_t dot11f_unpack_ie_ht_caps(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEHTCaps *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp39__;
	uint8_t tmp40__;
	uint16_t tmp41__;
	uint32_t tmp42__;
	uint8_t tmp43__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp39__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->advCodingCap = tmp39__ >> 0 & 0x1;
	pDst->supportedChannelWidthSet = tmp39__ >> 1 & 0x1;
	pDst->mimoPowerSave = tmp39__ >> 2 & 0x3;
	pDst->greenField = tmp39__ >> 4 & 0x1;
	pDst->shortGI20MHz = tmp39__ >> 5 & 0x1;
	pDst->shortGI40MHz = tmp39__ >> 6 & 0x1;
	pDst->txSTBC = tmp39__ >> 7 & 0x1;
	pDst->rxSTBC = tmp39__ >> 8 & 0x3;
	pDst->delayedBA = tmp39__ >> 10 & 0x1;
	pDst->maximalAMSDUsize = tmp39__ >> 11 & 0x1;
	pDst->dsssCckMode40MHz = tmp39__ >> 12 & 0x1;
	pDst->psmp = tmp39__ >> 13 & 0x1;
	pDst->stbcControlFrame = tmp39__ >> 14 & 0x1;
	pDst->lsigTXOPProtection = tmp39__ >> 15 & 0x1;
	tmp40__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->maxRxAMPDUFactor = tmp40__ >> 0 & 0x3;
	pDst->mpduDensity = tmp40__ >> 2 & 0x7;
	pDst->reserved1 = tmp40__ >> 5 & 0x7;
	DOT11F_MEMCPY(pCtx, pDst->supportedMCSSet, pBuf, 16);
	pBuf += 16;
	ielen -= (uint8_t)16;
	framesntohs(pCtx, &tmp41__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->pco = tmp41__ >> 0 & 0x1;
	pDst->transitionTime = tmp41__ >> 1 & 0x3;
	pDst->reserved2 = tmp41__ >> 3 & 0x1f;
	pDst->mcsFeedback = tmp41__ >> 8 & 0x3;
	pDst->reserved3 = tmp41__ >> 10 & 0x3f;
	framesntohl(pCtx, &tmp42__, pBuf, 0);
	pBuf += 4;
	ielen -= 4;
	pDst->txBF = tmp42__ >> 0 & 0x1;
	pDst->rxStaggeredSounding = tmp42__ >> 1 & 0x1;
	pDst->txStaggeredSounding = tmp42__ >> 2 & 0x1;
	pDst->rxZLF = tmp42__ >> 3 & 0x1;
	pDst->txZLF = tmp42__ >> 4 & 0x1;
	pDst->implicitTxBF = tmp42__ >> 5 & 0x1;
	pDst->calibration = tmp42__ >> 6 & 0x3;
	pDst->explicitCSITxBF = tmp42__ >> 8 & 0x1;
	pDst->explicitUncompressedSteeringMatrix = tmp42__ >> 9 & 0x1;
	pDst->explicitBFCSIFeedback = tmp42__ >> 10 & 0x7;
	pDst->explicitUncompressedSteeringMatrixFeedback = tmp42__ >> 13 & 0x7;
	pDst->explicitCompressedSteeringMatrixFeedback = tmp42__ >> 16 & 0x7;
	pDst->csiNumBFAntennae = tmp42__ >> 19 & 0x3;
	pDst->uncompressedSteeringMatrixBFAntennae = tmp42__ >> 21 & 0x3;
	pDst->compressedSteeringMatrixBFAntennae = tmp42__ >> 23 & 0x3;
	pDst->reserved4 = tmp42__ >> 25 & 0x7f;
	tmp43__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->antennaSelection = tmp43__ >> 0 & 0x1;
	pDst->explicitCSIFeedbackTx = tmp43__ >> 1 & 0x1;
	pDst->antennaIndicesFeedbackTx = tmp43__ >> 2 & 0x1;
	pDst->explicitCSIFeedback = tmp43__ >> 3 & 0x1;
	pDst->antennaIndicesFeedback = tmp43__ >> 4 & 0x1;
	pDst->rxAS = tmp43__ >> 5 & 0x1;
	pDst->txSoundingPPDUs = tmp43__ >> 6 & 0x1;
	pDst->reserved5 = tmp43__ >> 7 & 0x1;
	pDst->num_rsvd = (uint8_t)(ielen);
	if (ielen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->rsvd, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ht_caps. */

#define SigIeHTCaps (0x003b)


uint32_t dot11f_unpack_ie_ht_info(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEHTInfo *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp44__;
	uint16_t tmp45__;
	uint16_t tmp46__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->primaryChannel = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp44__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->secondaryChannelOffset = tmp44__ >> 0 & 0x3;
	pDst->recommendedTxWidthSet = tmp44__ >> 2 & 0x1;
	pDst->rifsMode = tmp44__ >> 3 & 0x1;
	pDst->controlledAccessOnly = tmp44__ >> 4 & 0x1;
	pDst->serviceIntervalGranularity = tmp44__ >> 5 & 0x7;
	framesntohs(pCtx, &tmp45__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->opMode = tmp45__ >> 0 & 0x3;
	pDst->nonGFDevicesPresent = tmp45__ >> 2 & 0x1;
	pDst->transmitBurstLimit = tmp45__ >> 3 & 0x1;
	pDst->obssNonHTStaPresent = tmp45__ >> 4 & 0x1;
	pDst->reserved = tmp45__ >> 5 & 0x7ff;
	framesntohs(pCtx, &tmp46__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->basicSTBCMCS = tmp46__ >> 0 & 0x7f;
	pDst->dualCTSProtection = tmp46__ >> 7 & 0x1;
	pDst->secondaryBeacon = tmp46__ >> 8 & 0x1;
	pDst->lsigTXOPProtectionFullSupport = tmp46__ >> 9 & 0x1;
	pDst->pcoActive = tmp46__ >> 10 & 0x1;
	pDst->pcoPhase = tmp46__ >> 11 & 0x1;
	pDst->reserved2 = tmp46__ >> 12 & 0xf;
	DOT11F_MEMCPY(pCtx, pDst->basicMCSSet, pBuf, 16);
	pBuf += 16;
	ielen -= (uint8_t)16;
	pDst->num_rsvd = (uint8_t)(ielen);
	if (ielen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->rsvd, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ht_info. */

#define SigIeHTInfo (0x003c)


uint32_t dot11f_unpack_ie_ibss_params(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEIBSSParams *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->atim, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ibss_params. */

#define SigIeIBSSParams (0x003d)


uint32_t dot11f_unpack_ie_link_identifier(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIELinkIdentifier *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->bssid, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	DOT11F_MEMCPY(pCtx, pDst->InitStaAddr, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	DOT11F_MEMCPY(pCtx, pDst->RespStaAddr, pBuf, 6);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_link_identifier. */

#define SigIeLinkIdentifier (0x003e)


static const tTLVDefn TLVS_MBO_IE[] = {
	{ offsetof(tDot11fIEMBO_IE, mbo_ap_cap), offsetof(tDot11fTLVmbo_ap_cap,
	present), "mbo_ap_cap", SigTlvmbo_ap_cap, DOT11F_TLV_MBO_AP_CAP,
	0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, non_prefferd_chan_rep),
	offsetof(tDot11fTLVnon_prefferd_chan_rep, present),
	"non_prefferd_chan_rep", SigTlvnon_prefferd_chan_rep,
	DOT11F_TLV_NON_PREFFERD_CHAN_REP, 0, 6, 257, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, cellular_data_cap),
	offsetof(tDot11fTLVcellular_data_cap, present), "cellular_data_cap",
	SigTlvcellular_data_cap, DOT11F_TLV_CELLULAR_DATA_CAP,
	0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, assoc_disallowed),
	offsetof(tDot11fTLVassoc_disallowed, present), "assoc_disallowed",
	SigTlvassoc_disallowed, DOT11F_TLV_ASSOC_DISALLOWED,
	0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, cellular_data_con_pref),
	offsetof(tDot11fTLVcellular_data_con_pref, present),
	"cellular_data_con_pref", SigTlvcellular_data_con_pref,
	DOT11F_TLV_CELLULAR_DATA_CON_PREF, 0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, transition_reason),
	offsetof(tDot11fTLVtransition_reason, present), "transition_reason",
	SigTlvtransition_reason, DOT11F_TLV_TRANSITION_REASON,
	0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, transition_reject_reason),
	offsetof(tDot11fTLVtransition_reject_reason, present),
	"transition_reject_reason", SigTlvtransition_reject_reason,
	DOT11F_TLV_TRANSITION_REJECT_REASON, 0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, assoc_retry_delay),
	offsetof(tDot11fTLVassoc_retry_delay, present), "assoc_retry_delay",
	SigTlvassoc_retry_delay, DOT11F_TLV_ASSOC_RETRY_DELAY,
	0, 4, 4, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, oce_cap), offsetof(tDot11fTLVoce_cap,
	present), "oce_cap", SigTlvoce_cap, DOT11F_TLV_OCE_CAP,
	0, 3, 3, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, rssi_assoc_rej),
	offsetof(tDot11fTLVrssi_assoc_rej, present), "rssi_assoc_rej",
	SigTlvrssi_assoc_rej, DOT11F_TLV_RSSI_ASSOC_REJ, 0, 4, 4, 0, 1, 1, 0, },
	{ offsetof(tDot11fIEMBO_IE, reduced_wan_metrics),
	offsetof(tDot11fTLVreduced_wan_metrics, present), "reduced_wan_metrics",
	SigTlvreduced_wan_metrics, DOT11F_TLV_REDUCED_WAN_METRICS,
	0, 3, 3, 0, 1, 1, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_MBO_IE(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEMBO_IE *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_MBO_IE,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_MBO_IE. */

#define SigIeMBO_IE (0x003f)


static const tFFDefn FFS_reportBeacon[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_reportBeacon[] = {
	{ offsetof(tDot11fIEMeasurementReport,
	report.Beacon.BeaconReportFrmBody),
	offsetof(tDot11fIEBeaconReportFrmBody, present), 0, "BeaconReportFrmBody",
	0, 2, 226, SigIeBeaconReportFrmBody, {0, 0, 0, 0, 0},
	0, DOT11F_EID_BEACONREPORTFRMBODY, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_measurement_report(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint8_t ielen,
					    tDot11fIEMeasurementReport *pDst,
					    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp47__;
	uint8_t tmp48__;
	uint8_t tmp49__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->token = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp47__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->late = tmp47__ >> 0 & 0x1;
	pDst->incapable = tmp47__ >> 1 & 0x1;
	pDst->refused = tmp47__ >> 2 & 0x1;
	pDst->unused = tmp47__ >> 3 & 0x1f;
	pDst->type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (!ielen) {
		return 0U;
	} else {
		switch (pDst->type) {
		case 0:
			pDst->report.Basic.channel = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			framesntohq(pCtx, &pDst->report.Basic.meas_start_time, pBuf, 0);
			pBuf += 8;
			ielen -= (uint8_t)8;
			framesntohs(pCtx, &pDst->report.Basic.meas_duration, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			tmp48__ = *pBuf;
			pBuf += 1;
			ielen -= 1;
			pDst->report.Basic.bss = tmp48__ >> 0 & 0x1;
			pDst->report.Basic.ofdm_preamble = tmp48__ >> 1 & 0x1;
			pDst->report.Basic.unid_signal = tmp48__ >> 2 & 0x1;
			pDst->report.Basic.rader = tmp48__ >> 3 & 0x1;
			pDst->report.Basic.unmeasured = tmp48__ >> 4 & 0x1;
			pDst->report.Basic.unused = tmp48__ >> 5 & 0x7;
			break;
		case 1:
			pDst->report.CCA.channel = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			framesntohq(pCtx, &pDst->report.CCA.meas_start_time, pBuf, 0);
			pBuf += 8;
			ielen -= (uint8_t)8;
			framesntohs(pCtx, &pDst->report.CCA.meas_duration, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			pDst->report.CCA.cca_busy_fraction = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			break;
		case 2:
			pDst->report.RPIHistogram.channel = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			framesntohq(pCtx, &pDst->report.RPIHistogram.meas_start_time, pBuf, 0);
			pBuf += 8;
			ielen -= (uint8_t)8;
			framesntohs(pCtx, &pDst->report.RPIHistogram.meas_duration, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			pDst->report.RPIHistogram.rpi0_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi1_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi2_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi3_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi4_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi5_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi6_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.RPIHistogram.rpi7_density = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			break;
		case 5:
			pDst->report.Beacon.regClass = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.Beacon.channel = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			framesntohq(pCtx, &pDst->report.Beacon.meas_start_time, pBuf, 0);
			pBuf += 8;
			ielen -= (uint8_t)8;
			framesntohs(pCtx, &pDst->report.Beacon.meas_duration, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			tmp49__ = *pBuf;
			pBuf += 1;
			ielen -= 1;
			pDst->report.Beacon.condensed_PHY = tmp49__ >> 0 & 0x7f;
			pDst->report.Beacon.reported_frame_type = tmp49__ >> 7 & 0x1;
			pDst->report.Beacon.RCPI = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			pDst->report.Beacon.RSNI = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			DOT11F_MEMCPY(pCtx, pDst->report.Beacon.BSSID, pBuf, 6);
			pBuf += 6;
			ielen -= (uint8_t)6;
			pDst->report.Beacon.antenna_id = *pBuf;
			pBuf += 1;
			ielen -= (uint8_t)1;
			framesntohl(pCtx, &pDst->report.Beacon.parent_TSF, pBuf, 0);
			pBuf += 4;
			ielen -= (uint8_t)4;
			status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_reportBeacon,
				IES_reportBeacon,
				(uint8_t *)pDst,
				sizeof(*pDst), append_ie);
			break;
		}
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_measurement_report. */

#define SigIeMeasurementReport (0x0040)


static const tFFDefn FFS_measurement_requestBeacon[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_measurement_requestBeacon[] = {
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.Beacon.SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.Beacon.BeaconReporting),
	offsetof(tDot11fIEBeaconReporting, present), 0, "BeaconReporting",
	0, 4, 4, SigIeBeaconReporting, {0, 0, 0, 0, 0},
	0, DOT11F_EID_BEACONREPORTING, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.Beacon.BcnReportingDetail),
	offsetof(tDot11fIEBcnReportingDetail, present), 0, "BcnReportingDetail",
	0, 3, 3, SigIeBcnReportingDetail, {0, 0, 0, 0, 0},
	0, DOT11F_EID_BCNREPORTINGDETAIL, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.Beacon.RequestedInfo),
	offsetof(tDot11fIERequestedInfo, present), 0, "RequestedInfo",
	0, 2, 257, SigIeRequestedInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_REQUESTEDINFO, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.Beacon.APChannelReport),
	offsetof(tDot11fIEAPChannelReport, present),
	offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.num_APChannelReport), "APChannelReport", 2, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

static const tFFDefn FFS_measurement_requestlci[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_measurement_requestlci[] = {
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.lci.azimuth_req), offsetof(tDot11fIEazimuth_req,
	present), 0, "azimuth_req", 0, 3, 3, SigIeazimuth_req, {0, 0, 0, 0, 0},
	0, DOT11F_EID_AZIMUTH_REQ, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.lci.req_mac_addr), offsetof(tDot11fIEreq_mac_addr,
	present), 0, "req_mac_addr", 0, 8, 8, SigIereq_mac_addr, {0, 0, 0, 0, 0},
	0, DOT11F_EID_REQ_MAC_ADDR, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.lci.tgt_mac_addr), offsetof(tDot11fIEtgt_mac_addr,
	present), 0, "tgt_mac_addr", 0, 8, 8, SigIetgt_mac_addr, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TGT_MAC_ADDR, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.lci.max_age), offsetof(tDot11fIEmax_age, present), 0,
	"max_age", 0, 4, 4, SigIemax_age, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MAX_AGE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

static const tFFDefn FFS_measurement_requestftmrr[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_measurement_requestftmrr[] = {
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.ftmrr.neighbor_rpt), offsetof(tDot11fIEneighbor_rpt,
	present), 0, "neighbor_rpt", 0, 15, 548, SigIeneighbor_rpt,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_NEIGHBOR_RPT, 0, 0, },
	{ offsetof(tDot11fIEMeasurementRequest,
	measurement_request.ftmrr.max_age), offsetof(tDot11fIEmax_age, present),
	0, "max_age", 0, 4, 4, SigIemax_age, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MAX_AGE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_measurement_request(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint8_t ielen,
					     tDot11fIEMeasurementRequest *pDst,
					     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp50__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->measurement_token = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp50__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->parallel = tmp50__ >> 0 & 0x1;
	pDst->enable = tmp50__ >> 1 & 0x1;
	pDst->request = tmp50__ >> 2 & 0x1;
	pDst->report = tmp50__ >> 3 & 0x1;
	pDst->durationMandatory = tmp50__ >> 4 & 0x1;
	pDst->unused = tmp50__ >> 5 & 0x7;
	pDst->measurement_type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	switch (pDst->measurement_type) {
	case 0:
		pDst->measurement_request.Basic.channel_no = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		DOT11F_MEMCPY(pCtx, pDst->measurement_request.Basic.meas_start_time, pBuf, 8);
		pBuf += 8;
		ielen -= (uint8_t)8;
		framesntohs(pCtx, &pDst->measurement_request.Basic.meas_duration, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	case 1:
		pDst->measurement_request.CCA.channel_no = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		DOT11F_MEMCPY(pCtx, pDst->measurement_request.CCA.meas_start_time, pBuf, 8);
		pBuf += 8;
		ielen -= (uint8_t)8;
		framesntohs(pCtx, &pDst->measurement_request.CCA.meas_duration, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	case 2:
		pDst->measurement_request.RPIHistogram.channel_no = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		DOT11F_MEMCPY(pCtx, pDst->measurement_request.RPIHistogram.meas_start_time, pBuf, 8);
		pBuf += 8;
		ielen -= (uint8_t)8;
		framesntohs(pCtx, &pDst->measurement_request.RPIHistogram.meas_duration, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		break;
	case 5:
		pDst->measurement_request.Beacon.regClass = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		pDst->measurement_request.Beacon.channel = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		framesntohs(pCtx, &pDst->measurement_request.Beacon.randomization, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		framesntohs(pCtx, &pDst->measurement_request.Beacon.meas_duration, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		pDst->measurement_request.Beacon.meas_mode = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		DOT11F_MEMCPY(pCtx, pDst->measurement_request.Beacon.BSSID, pBuf, 6);
		pBuf += 6;
		ielen -= (uint8_t)6;
		status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_measurement_requestBeacon,
				IES_measurement_requestBeacon,
				(uint8_t *)pDst,
				sizeof(*pDst), append_ie);
		break;
	case 8:
		pDst->measurement_request.lci.loc_subject = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_measurement_requestlci,
				IES_measurement_requestlci,
				(uint8_t *)pDst,
				sizeof(*pDst), append_ie);
		break;
	case 16:
		framesntohs(pCtx, &pDst->measurement_request.ftmrr.random_interval, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
		pDst->measurement_request.ftmrr.min_ap_count = *pBuf;
		pBuf += 1;
		ielen -= (uint8_t)1;
		status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_measurement_requestftmrr,
				IES_measurement_requestftmrr,
				(uint8_t *)pDst,
				sizeof(*pDst), append_ie);
		break;
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_measurement_request. */

#define SigIeMeasurementRequest (0x0041)


uint32_t dot11f_unpack_ie_mobility_domain(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEMobilityDomain *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp51__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->MDID, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp51__ = *pBuf;
	pDst->overDSCap = tmp51__ >> 0 & 0x1;
	pDst->resourceReqCap = tmp51__ >> 1 & 0x1;
	pDst->reserved = tmp51__ >> 2 & 0x3f;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_mobility_domain. */

#define SigIeMobilityDomain (0x0042)


static const tFFDefn FFS_NeighborReport[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_NeighborReport[] = {
	{ offsetof(tDot11fIENeighborReport, TSFInfo), offsetof(tDot11fIETSFInfo,
	present), 0, "TSFInfo", 0, 6, 6, SigIeTSFInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSFINFO, 0, 0, },
	{ offsetof(tDot11fIENeighborReport, CondensedCountryStr),
	offsetof(tDot11fIECondensedCountryStr, present), 0, "CondensedCountryStr",
	0, 4, 4, SigIeCondensedCountryStr, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CONDENSEDCOUNTRYSTR, 0, 0, },
	{ offsetof(tDot11fIENeighborReport, MeasurementPilot),
	offsetof(tDot11fIEMeasurementPilot, present), 0, "MeasurementPilot",
	0, 3, 258, SigIeMeasurementPilot, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTPILOT, 0, 0, },
	{ offsetof(tDot11fIENeighborReport, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fIENeighborReport, MultiBssid),
	offsetof(tDot11fIEMultiBssid, present), 0, "MultiBssid",
	0, 3, 258, SigIeMultiBssid, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MULTIBSSID, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_neighbor_report(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIENeighborReport *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp52__;
	uint8_t tmp53__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->bssid, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	tmp52__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->APReachability = tmp52__ >> 0 & 0x3;
	pDst->Security = tmp52__ >> 2 & 0x1;
	pDst->KeyScope = tmp52__ >> 3 & 0x1;
	pDst->SpecMgmtCap = tmp52__ >> 4 & 0x1;
	pDst->QosCap = tmp52__ >> 5 & 0x1;
	pDst->apsd = tmp52__ >> 6 & 0x1;
	pDst->rrm = tmp52__ >> 7 & 0x1;
	tmp53__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->DelayedBA = tmp53__ >> 0 & 0x1;
	pDst->ImmBA = tmp53__ >> 1 & 0x1;
	pDst->MobilityDomain = tmp53__ >> 2 & 0x1;
	pDst->reserved = tmp53__ >> 3 & 0x1f;
	framesntohs(pCtx, &pDst->reserved1, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	pDst->regulatoryClass = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->channel = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->PhyType = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_NeighborReport,
				IES_NeighborReport,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_neighbor_report. */

#define SigIeNeighborReport (0x0043)


uint32_t dot11f_unpack_ie_obss_scan_parameters(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint8_t ielen,
					     tDot11fIEOBSSScanParameters *pDst,
					     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->obssScanPassiveDwell, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->obssScanActiveDwell, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->bssChannelWidthTriggerScanInterval, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->obssScanPassiveTotalPerChannel, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->obssScanActiveTotalPerChannel, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->bssWidthChannelTransitionDelayFactor, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->obssScanActivityThreshold, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_obss_scan_parameters. */

#define SigIeOBSSScanParameters (0x0044)


uint32_t dot11f_unpack_ie_operating_mode(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEOperatingMode *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp54__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp54__ = *pBuf;
	pDst->chanWidth = tmp54__ >> 0 & 0x3;
	pDst->reserved = tmp54__ >> 2 & 0x3;
	pDst->rxNSS = tmp54__ >> 4 & 0x7;
	pDst->rxNSSType = tmp54__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_operating_mode. */

#define SigIeOperatingMode (0x0045)


static const tTLVDefn TLVS_P2PAssocReq[] = {
	{ offsetof(tDot11fIEP2PAssocReq, P2PCapability),
	offsetof(tDot11fTLVP2PCapability, present), "P2PCapability",
	SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PAssocReq, ExtendedListenTiming),
	offsetof(tDot11fTLVExtendedListenTiming, present),
	"ExtendedListenTiming", SigTlvExtendedListenTiming,
	DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PAssocReq, P2PDeviceInfo),
	offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo",
	SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_assoc_req(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PAssocReq *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PAssocReq,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_assoc_req. */

#define SigIeP2PAssocReq (0x0046)


static const tTLVDefn TLVS_P2PAssocRes[] = {
	{ offsetof(tDot11fIEP2PAssocRes, P2PStatus),
	offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus,
	DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PAssocRes, ExtendedListenTiming),
	offsetof(tDot11fTLVExtendedListenTiming, present),
	"ExtendedListenTiming", SigTlvExtendedListenTiming,
	DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_assoc_res(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PAssocRes *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PAssocRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_assoc_res. */

#define SigIeP2PAssocRes (0x0047)


static const tTLVDefn TLVS_P2PBeacon[] = {
	{ offsetof(tDot11fIEP2PBeacon, P2PCapability),
	offsetof(tDot11fTLVP2PCapability, present), "P2PCapability",
	SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeacon, P2PDeviceId),
	offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId",
	SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeacon, NoticeOfAbsence),
	offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence",
	SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE,
	0, 5, 41, 0, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_beacon(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEP2PBeacon *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PBeacon,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_beacon. */

#define SigIeP2PBeacon (0x0048)


static const tTLVDefn TLVS_P2PBeaconProbeRes[] = {
	{ offsetof(tDot11fIEP2PBeaconProbeRes, P2PCapability),
	offsetof(tDot11fTLVP2PCapability, present), "P2PCapability",
	SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeaconProbeRes, P2PDeviceId),
	offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId",
	SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeaconProbeRes, ExtendedListenTiming),
	offsetof(tDot11fTLVExtendedListenTiming, present),
	"ExtendedListenTiming", SigTlvExtendedListenTiming,
	DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeaconProbeRes, NoticeOfAbsence),
	offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence",
	SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE,
	0, 5, 41, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeaconProbeRes, P2PDeviceInfo),
	offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo",
	SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PBeaconProbeRes, P2PGroupInfo),
	offsetof(tDot11fTLVP2PGroupInfo, present), "P2PGroupInfo",
	SigTlvP2PGroupInfo, DOT11F_TLV_P2PGROUPINFO, 0, 3, 1027, 0, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_beacon_probe_res(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint8_t ielen,
					    tDot11fIEP2PBeaconProbeRes *pDst,
					    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PBeaconProbeRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_beacon_probe_res. */

#define SigIeP2PBeaconProbeRes (0x0049)


static const tTLVDefn TLVS_P2PDeAuth[] = {
	{ offsetof(tDot11fIEP2PDeAuth, MinorReasonCode),
	offsetof(tDot11fTLVMinorReasonCode, present), "MinorReasonCode",
	SigTlvMinorReasonCode, DOT11F_TLV_MINORREASONCODE,
	0, 4, 4, 1, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_de_auth(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEP2PDeAuth *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PDeAuth,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_de_auth. */

#define SigIeP2PDeAuth (0x004a)


static const tTLVDefn TLVS_P2PDisAssoc[] = {
	{ offsetof(tDot11fIEP2PDisAssoc, MinorReasonCode),
	offsetof(tDot11fTLVMinorReasonCode, present), "MinorReasonCode",
	SigTlvMinorReasonCode, DOT11F_TLV_MINORREASONCODE,
	0, 4, 4, 1, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_dis_assoc(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PDisAssoc *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PDisAssoc,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_dis_assoc. */

#define SigIeP2PDisAssoc (0x004b)


uint32_t dot11f_unpack_ie_p2_pie_opaque(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PIEOpaque *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 249) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_p2_pie_opaque. */

#define SigIeP2PIEOpaque (0x004c)


static const tTLVDefn TLVS_P2PProbeReq[] = {
	{ offsetof(tDot11fIEP2PProbeReq, P2PCapability),
	offsetof(tDot11fTLVP2PCapability, present), "P2PCapability",
	SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeReq, P2PDeviceId),
	offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId",
	SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeReq, ListenChannel),
	offsetof(tDot11fTLVListenChannel, present), "ListenChannel",
	SigTlvListenChannel, DOT11F_TLV_LISTENCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeReq, ExtendedListenTiming),
	offsetof(tDot11fTLVExtendedListenTiming, present),
	"ExtendedListenTiming", SigTlvExtendedListenTiming,
	DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeReq, OperatingChannel),
	offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel",
	SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL,
	0, 8, 8, 0, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_probe_req(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PProbeReq *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PProbeReq,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_probe_req. */

#define SigIeP2PProbeReq (0x004d)


static const tTLVDefn TLVS_P2PProbeRes[] = {
	{ offsetof(tDot11fIEP2PProbeRes, P2PCapability),
	offsetof(tDot11fTLVP2PCapability, present), "P2PCapability",
	SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeRes, ExtendedListenTiming),
	offsetof(tDot11fTLVExtendedListenTiming, present),
	"ExtendedListenTiming", SigTlvExtendedListenTiming,
	DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeRes, NoticeOfAbsence),
	offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence",
	SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE,
	0, 5, 41, 0, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeRes, P2PDeviceInfo),
	offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo",
	SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
	{ offsetof(tDot11fIEP2PProbeRes, P2PGroupInfo),
	offsetof(tDot11fTLVP2PGroupInfo, present), "P2PGroupInfo",
	SigTlvP2PGroupInfo, DOT11F_TLV_P2PGROUPINFO, 0, 3, 1027, 0, 1, 2, 0, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_p2_p_probe_res(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEP2PProbeRes *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_P2PProbeRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_p2_p_probe_res. */

#define SigIeP2PProbeRes (0x004e)


uint32_t dot11f_unpack_ie_pti_control(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEPTIControl *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->tid = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->sequence_control, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_pti_control. */

#define SigIePTIControl (0x004f)


uint32_t dot11f_unpack_ie_pu_buffer_status(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEPUBufferStatus *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp55__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp55__ = *pBuf;
	pDst->ac_bk_traffic_aval = tmp55__ >> 0 & 0x1;
	pDst->ac_be_traffic_aval = tmp55__ >> 1 & 0x1;
	pDst->ac_vi_traffic_aval = tmp55__ >> 2 & 0x1;
	pDst->ac_vo_traffic_aval = tmp55__ >> 3 & 0x1;
	pDst->reserved = tmp55__ >> 4 & 0xf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_pu_buffer_status. */

#define SigIePUBufferStatus (0x0050)


uint32_t dot11f_unpack_ie_power_caps(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEPowerCaps *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->minTxPower = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->maxTxPower = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_power_caps. */

#define SigIePowerCaps (0x0051)


uint32_t dot11f_unpack_ie_power_constraints(tpAniSirGlobal pCtx,
					   uint8_t *pBuf,
					   uint8_t ielen,
					   tDot11fIEPowerConstraints *pDst,
					   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->localPowerConstraints = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_power_constraints. */

#define SigIePowerConstraints (0x0052)


uint32_t dot11f_unpack_ie_qbss_load(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIEQBSSLoad *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->stacount, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	pDst->chautil = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->avail, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_qbss_load. */

#define SigIeQBSSLoad (0x0053)


uint32_t dot11f_unpack_ie_QCN_IE(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEQCN_IE *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->version, pBuf, 4);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_QCN_IE. */

#define SigIeQCN_IE (0x0054)


uint32_t dot11f_unpack_ie_QComVendorIE(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEQComVendorIE *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->channel = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_QComVendorIE. */

#define SigIeQComVendorIE (0x0055)


uint32_t dot11f_unpack_ie_qos_caps_ap(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEQOSCapsAp *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp56__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp56__ = *pBuf;
	pDst->count = tmp56__ >> 0 & 0xf;
	pDst->qack = tmp56__ >> 4 & 0x1;
	pDst->qreq = tmp56__ >> 5 & 0x1;
	pDst->txopreq = tmp56__ >> 6 & 0x1;
	pDst->reserved = tmp56__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_qos_caps_ap. */

#define SigIeQOSCapsAp (0x0056)


uint32_t dot11f_unpack_ie_qos_caps_station(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEQOSCapsStation *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp57__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp57__ = *pBuf;
	pDst->acvo_uapsd = tmp57__ >> 0 & 0x1;
	pDst->acvi_uapsd = tmp57__ >> 1 & 0x1;
	pDst->acbk_uapsd = tmp57__ >> 2 & 0x1;
	pDst->acbe_uapsd = tmp57__ >> 3 & 0x1;
	pDst->qack = tmp57__ >> 4 & 0x1;
	pDst->max_sp_length = tmp57__ >> 5 & 0x3;
	pDst->more_data_ack = tmp57__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_qos_caps_station. */

#define SigIeQOSCapsStation (0x0057)


uint32_t dot11f_unpack_ie_qos_map_set(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEQosMapSet *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_dscp_exceptions = (uint8_t)(ielen);
	if (ielen > 60) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->dscp_exceptions, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_qos_map_set. */

#define SigIeQosMapSet (0x0058)


uint32_t dot11f_unpack_ie_quiet(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEQuiet *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->count = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->period = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohs(pCtx, &pDst->duration, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	framesntohs(pCtx, &pDst->offset, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_quiet. */

#define SigIeQuiet (0x0059)


uint32_t dot11f_unpack_ie_rcpiie(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIERCPIIE *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->rcpi = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_rcpiie. */

#define SigIeRCPIIE (0x005a)


static const tFFDefn FFS_RICDataDesc[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_RICDataDesc[] = {
	{ offsetof(tDot11fIERICDataDesc, RICData), offsetof(tDot11fIERICData,
	present), 0, "RICData", 0, 6, 6, SigIeRICData, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATA, 0, 1, },
	{ offsetof(tDot11fIERICDataDesc, RICDescriptor),
	offsetof(tDot11fIERICDescriptor, present), 0, "RICDescriptor",
	0, 3, 258, SigIeRICDescriptor, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDESCRIPTOR, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, TSPEC), offsetof(tDot11fIETSPEC,
	present), 0, "TSPEC", 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSPEC, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, TCLAS), offsetof(tDot11fIETCLAS,
	present), offsetof(tDot11fIERICDataDesc, num_TCLAS), "TCLAS",
	2, 7, 45, SigIeTCLAS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, TCLASSPROC),
	offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC",
	0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TCLASSPROC, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, TSDelay), offsetof(tDot11fIETSDelay,
	present), 0, "TSDelay", 0, 6, 6, SigIeTSDelay, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSDELAY, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, Schedule), offsetof(tDot11fIESchedule,
	present), 0, "Schedule", 0, 16, 16, SigIeSchedule, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SCHEDULE, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), 0, "WMMTSPEC", 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS,
	present), offsetof(tDot11fIERICDataDesc, num_WMMTCLAS), "WMMTCLAS",
	2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6},
	5, DOT11F_EID_WMMTCLAS, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, WMMTCLASPROC),
	offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC",
	0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7},
	5, DOT11F_EID_WMMTCLASPROC, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, WMMTSDelay),
	offsetof(tDot11fIEWMMTSDelay, present), 0, "WMMTSDelay",
	0, 12, 12, SigIeWMMTSDelay, {0, 80, 242, 2, 8},
	5, DOT11F_EID_WMMTSDELAY, 0, 0, },
	{ offsetof(tDot11fIERICDataDesc, WMMSchedule),
	offsetof(tDot11fIEWMMSchedule, present), 0, "WMMSchedule",
	0, 22, 22, SigIeWMMSchedule, {0, 80, 242, 2, 9},
	5, DOT11F_EID_WMMSCHEDULE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_ric_data_desc(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIERICDataDesc *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_RICDataDesc,
				IES_RICDataDesc,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_ric_data_desc. */

#define SigIeRICDataDesc (0x005b)


uint32_t dot11f_unpack_ie_rsn(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIERSN *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->version, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	DOT11F_MEMCPY(pCtx, pDst->gp_cipher_suite, pBuf, 4);
	pBuf += 4;
	ielen -= (uint8_t)4;
	if (!ielen) {
		pDst->pwise_cipher_suite_count = 0U;
		pDst->akm_suite_count = 0U;
		pDst->pmkid_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->pwise_cipher_suite_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->pwise_cipher_suite_count > 6) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->pwise_cipher_suites, pBuf, (pDst->pwise_cipher_suite_count * 4));
	pBuf += (pDst->pwise_cipher_suite_count * 4);
	ielen -= (pDst->pwise_cipher_suite_count * 4);
	if (!ielen) {
		pDst->akm_suite_count = 0U;
		pDst->pmkid_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->akm_suite_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->akm_suite_count > 6) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->akm_suites, pBuf, (pDst->akm_suite_count * 4));
	pBuf += (pDst->akm_suite_count * 4);
	ielen -= (pDst->akm_suite_count * 4);
	if (!ielen) {
		pDst->pmkid_count = 0U;
		return 0U;
	} else {
		DOT11F_MEMCPY(pCtx, pDst->RSN_Cap, pBuf, 2);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (!ielen) {
		pDst->pmkid_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->pmkid_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->pmkid_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->pmkid, pBuf, (pDst->pmkid_count * 16));
	pBuf += (pDst->pmkid_count * 16);
	ielen -= (pDst->pmkid_count * 16);
	if (!ielen) {
		return 0U;
	} else {
		DOT11F_MEMCPY(pCtx, pDst->gp_mgmt_cipher_suite, pBuf, 4);
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_rsn. */

#define SigIeRSN (0x005c)


uint32_t dot11f_unpack_ie_rsniie(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIERSNIIE *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->rsni = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_rsniie. */

#define SigIeRSNIIE (0x005d)


uint32_t dot11f_unpack_ie_rsn_opaque(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIERSNOpaque *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 253) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_rsn_opaque. */

#define SigIeRSNOpaque (0x005e)


uint32_t dot11f_unpack_ie_supp_channels(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIESuppChannels *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_bands = (uint8_t)(ielen / 2);
	if (ielen > 48 * 2) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->bands, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_supp_channels. */

#define SigIeSuppChannels (0x005f)


uint32_t dot11f_unpack_ie_supp_operating_classes(tpAniSirGlobal pCtx,
					       uint8_t *pBuf,
					       uint8_t ielen,
					       tDot11fIESuppOperatingClasses *pDst,
					       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_classes = (uint8_t)(ielen);
	if (ielen > 32) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->classes, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_supp_operating_classes. */

#define SigIeSuppOperatingClasses (0x0060)


uint32_t dot11f_unpack_ie_supp_rates(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIESuppRates *pDst,
				    bool append_ie)
{
	uint8_t i;
	uint8_t rate_indx = 0;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	for (i = 0; i < ielen; i++) {
		if ((DOT11F_IS_BG_RATE(pBuf[i] & 0x7F)) &&
			(rate_indx < 12)) {
			pDst->rates[rate_indx++] = pBuf[i];
		}
	}

	if (rate_indx == 0) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	pDst->num_rates = rate_indx;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_supp_rates. */

#define SigIeSuppRates (0x0061)


uint32_t dot11f_unpack_ie_tim(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIETIM *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->dtim_count = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->dtim_period = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->bmpctl = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_vbmp = (uint8_t)(ielen);
	if (ielen > 251) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->vbmp, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tim. */

#define SigIeTIM (0x0062)


uint32_t dot11f_unpack_ie_tpc_report(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIETPCReport *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->tx_power = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->link_margin = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tpc_report. */

#define SigIeTPCReport (0x0063)


uint32_t dot11f_unpack_ie_tpc_request(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIETPCRequest *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_tpc_request. */

#define SigIeTPCRequest (0x0064)


uint32_t dot11f_unpack_ie_time_advertisement(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint8_t ielen,
					    tDot11fIETimeAdvertisement *pDst,
					    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->timing_capabilities = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	DOT11F_MEMCPY(pCtx, pDst->time_value, pBuf, 10);
	pBuf += 10;
	ielen -= (uint8_t)10;
	DOT11F_MEMCPY(pCtx, pDst->time_error, pBuf, 5);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_time_advertisement. */

#define SigIeTimeAdvertisement (0x0065)


uint32_t dot11f_unpack_ie_timeout_interval(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIETimeoutInterval *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->timeoutType = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	framesntohl(pCtx, &pDst->timeoutValue, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_timeout_interval. */

#define SigIeTimeoutInterval (0x0066)


uint32_t dot11f_unpack_ie_vht_ext_bss_load(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEVHTExtBssLoad *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->muMIMOCapStaCount = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->ssUnderUtil = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->FortyMHzUtil = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->EightyMHzUtil = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->OneSixtyMHzUtil = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vht_ext_bss_load. */

#define SigIeVHTExtBssLoad (0x0067)


uint32_t dot11f_unpack_ie_vendor1_ie(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEVendor1IE *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vendor1_ie. */

#define SigIeVendor1IE (0x0068)


uint32_t dot11f_unpack_ie_vendor3_ie(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEVendor3IE *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_vendor3_ie. */

#define SigIeVendor3IE (0x0069)


uint32_t dot11f_unpack_ie_wapi(tpAniSirGlobal pCtx,
			       uint8_t *pBuf,
			       uint8_t ielen,
			       tDot11fIEWAPI *pDst,
			       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp58__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->version, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	framesntohs(pCtx, &pDst->akm_suite_count, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	if (pDst->akm_suite_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->akm_suites, pBuf, (pDst->akm_suite_count * 4));
	pBuf += (pDst->akm_suite_count * 4);
	ielen -= (pDst->akm_suite_count * 4);
	framesntohs(pCtx, &pDst->unicast_cipher_suite_count, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	if (pDst->unicast_cipher_suite_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->unicast_cipher_suites, pBuf, (pDst->unicast_cipher_suite_count * 4));
	pBuf += (pDst->unicast_cipher_suite_count * 4);
	ielen -= (pDst->unicast_cipher_suite_count * 4);
	DOT11F_MEMCPY(pCtx, pDst->multicast_cipher_suite, pBuf, 4);
	pBuf += 4;
	ielen -= (uint8_t)4;
	framesntohs(pCtx, &tmp58__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->preauth = tmp58__ >> 0 & 0x1;
	pDst->reserved = tmp58__ >> 1 & 0x7fff;
	if (!ielen) {
		pDst->bkid_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->bkid_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->bkid_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->bkid, pBuf, (pDst->bkid_count * 16));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wapi. */

#define SigIeWAPI (0x006a)


uint32_t dot11f_unpack_ie_wapi_opaque(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEWAPIOpaque *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 253) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wapi_opaque. */

#define SigIeWAPIOpaque (0x006b)


uint32_t dot11f_unpack_ie_wfatpc(tpAniSirGlobal pCtx,
				 uint8_t *pBuf,
				 uint8_t ielen,
				 tDot11fIEWFATPC *pDst,
				 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->txPower = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->linkMargin = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wfatpc. */

#define SigIeWFATPC (0x006c)


uint32_t dot11f_unpack_ie_wfdie_opaque(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWFDIEOpaque *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 249) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wfdie_opaque. */

#define SigIeWFDIEOpaque (0x006d)


uint32_t dot11f_unpack_ie_wmm_caps(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIEWMMCaps *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp59__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	tmp59__ = *pBuf;
	pDst->reserved = tmp59__ >> 0 & 0xf;
	pDst->qack = tmp59__ >> 4 & 0x1;
	pDst->queue_request = tmp59__ >> 5 & 0x1;
	pDst->txop_request = tmp59__ >> 6 & 0x1;
	pDst->more_ack = tmp59__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmm_caps. */

#define SigIeWMMCaps (0x006e)


uint32_t dot11f_unpack_ie_wmm_info_ap(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEWMMInfoAp *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp60__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp60__ = *pBuf;
	pDst->param_set_count = tmp60__ >> 0 & 0xf;
	pDst->reserved = tmp60__ >> 4 & 0x7;
	pDst->uapsd = tmp60__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmm_info_ap. */

#define SigIeWMMInfoAp (0x006f)


uint32_t dot11f_unpack_ie_wmm_info_station(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEWMMInfoStation *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp61__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp61__ = *pBuf;
	pDst->acvo_uapsd = tmp61__ >> 0 & 0x1;
	pDst->acvi_uapsd = tmp61__ >> 1 & 0x1;
	pDst->acbk_uapsd = tmp61__ >> 2 & 0x1;
	pDst->acbe_uapsd = tmp61__ >> 3 & 0x1;
	pDst->reserved1 = tmp61__ >> 4 & 0x1;
	pDst->max_sp_length = tmp61__ >> 5 & 0x3;
	pDst->reserved2 = tmp61__ >> 7 & 0x1;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmm_info_station. */

#define SigIeWMMInfoStation (0x0070)


uint32_t dot11f_unpack_ie_wmm_params(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEWMMParams *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp62__;
	uint8_t tmp63__;
	uint8_t tmp64__;
	uint8_t tmp65__;
	uint8_t tmp66__;
	uint8_t tmp67__;
	uint8_t tmp68__;
	uint8_t tmp69__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->version = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	pDst->qosInfo = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->reserved2 = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	tmp62__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbe_aifsn = tmp62__ >> 0 & 0xf;
	pDst->acbe_acm = tmp62__ >> 4 & 0x1;
	pDst->acbe_aci = tmp62__ >> 5 & 0x3;
	pDst->unused1 = tmp62__ >> 7 & 0x1;
	tmp63__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbe_acwmin = tmp63__ >> 0 & 0xf;
	pDst->acbe_acwmax = tmp63__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acbe_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp64__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbk_aifsn = tmp64__ >> 0 & 0xf;
	pDst->acbk_acm = tmp64__ >> 4 & 0x1;
	pDst->acbk_aci = tmp64__ >> 5 & 0x3;
	pDst->unused2 = tmp64__ >> 7 & 0x1;
	tmp65__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acbk_acwmin = tmp65__ >> 0 & 0xf;
	pDst->acbk_acwmax = tmp65__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acbk_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp66__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvi_aifsn = tmp66__ >> 0 & 0xf;
	pDst->acvi_acm = tmp66__ >> 4 & 0x1;
	pDst->acvi_aci = tmp66__ >> 5 & 0x3;
	pDst->unused3 = tmp66__ >> 7 & 0x1;
	tmp67__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvi_acwmin = tmp67__ >> 0 & 0xf;
	pDst->acvi_acwmax = tmp67__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acvi_txoplimit, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	tmp68__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvo_aifsn = tmp68__ >> 0 & 0xf;
	pDst->acvo_acm = tmp68__ >> 4 & 0x1;
	pDst->acvo_aci = tmp68__ >> 5 & 0x3;
	pDst->unused4 = tmp68__ >> 7 & 0x1;
	tmp69__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->acvo_acwmin = tmp69__ >> 0 & 0xf;
	pDst->acvo_acwmax = tmp69__ >> 4 & 0xf;
	framesntohs(pCtx, &pDst->acvo_txoplimit, pBuf, 0);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wmm_params. */

#define SigIeWMMParams (0x0071)


uint32_t dot11f_unpack_ie_wpa(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIEWPA *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &pDst->version, pBuf, 0);
	pBuf += 2;
	ielen -= (uint8_t)2;
	if (pDst->version != 0x1) {
		pDst->present = 0;
		return status | DOT11F_BAD_FIXED_VALUE;
	}
	if (!ielen) {
		pDst->multicast_cipher_present = 0U;
		pDst->unicast_cipher_count = 0U;
		pDst->auth_suite_count = 0U;
		return 0U;
	} else {
		pDst->multicast_cipher_present = 1U;
		DOT11F_MEMCPY(pCtx, pDst->multicast_cipher, pBuf, 4);
		pBuf += 4;
		ielen -= (uint8_t)4;
	}
	if (!ielen) {
		pDst->unicast_cipher_count = 0U;
		pDst->auth_suite_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->unicast_cipher_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->unicast_cipher_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->unicast_ciphers, pBuf, (pDst->unicast_cipher_count * 4));
	pBuf += (pDst->unicast_cipher_count * 4);
	ielen -= (pDst->unicast_cipher_count * 4);
	if (!ielen) {
		pDst->auth_suite_count = 0U;
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->auth_suite_count, pBuf, 0);
		pBuf += 2;
		ielen -= (uint8_t)2;
	}
	if (pDst->auth_suite_count > 4) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->auth_suites, pBuf, (pDst->auth_suite_count * 4));
	pBuf += (pDst->auth_suite_count * 4);
	ielen -= (pDst->auth_suite_count * 4);
	if (!ielen) {
		return 0U;
	} else {
		framesntohs(pCtx, &pDst->caps, pBuf, 0);
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wpa. */

#define SigIeWPA (0x0072)


uint32_t dot11f_unpack_ie_wpa_opaque(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEWPAOpaque *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 249) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wpa_opaque. */

#define SigIeWPAOpaque (0x0073)


static const tTLVDefn TLVS_WSC[] = {
	{ offsetof(tDot11fIEWSC, Version), offsetof(tDot11fTLVVersion, present),
	"Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, WPSState), offsetof(tDot11fTLVWPSState, present),
	"WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, APSetupLocked),
	offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked",
	SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, SelectedRegistrarConfigMethods),
	offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present),
	"SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods,
	DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, UUID_E), offsetof(tDot11fTLVUUID_E, present),
	"UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, UUID_R), offsetof(tDot11fTLVUUID_R, present),
	"UUID_R", SigTlvUUID_R, DOT11F_TLV_UUID_R, 0, 20, 20, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, RFBands), offsetof(tDot11fTLVRFBands, present),
	"RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, SelectedRegistrar),
	offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar",
	SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, ConfigMethods),
	offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods",
	SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, AssociationState),
	offsetof(tDot11fTLVAssociationState, present), "AssociationState",
	SigTlvAssociationState, DOT11F_TLV_ASSOCIATIONSTATE,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, ConfigurationError),
	offsetof(tDot11fTLVConfigurationError, present), "ConfigurationError",
	SigTlvConfigurationError, DOT11F_TLV_CONFIGURATIONERROR,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, Manufacturer), offsetof(tDot11fTLVManufacturer,
	present), "Manufacturer", SigTlvManufacturer, DOT11F_TLV_MANUFACTURER,
	0, 4, 68, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, ModelName), offsetof(tDot11fTLVModelName,
	present), "ModelName", SigTlvModelName, DOT11F_TLV_MODELNAME,
	0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, ModelNumber), offsetof(tDot11fTLVModelNumber,
	present), "ModelNumber", SigTlvModelNumber, DOT11F_TLV_MODELNUMBER,
	0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, SerialNumber), offsetof(tDot11fTLVSerialNumber,
	present), "SerialNumber", SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER,
	0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, DeviceName), offsetof(tDot11fTLVDeviceName,
	present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME,
	0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, DevicePasswordID),
	offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID",
	SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, PrimaryDeviceType),
	offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType",
	SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE,
	0, 12, 12, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, RequestType), offsetof(tDot11fTLVRequestType,
	present), "RequestType", SigTlvRequestType, DOT11F_TLV_REQUESTTYPE,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, ResponseType), offsetof(tDot11fTLVResponseType,
	present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWSC, RequestDeviceType),
	offsetof(tDot11fTLVRequestDeviceType, present), "RequestDeviceType",
	SigTlvRequestDeviceType, DOT11F_TLV_REQUESTDEVICETYPE,
	0, 12, 12, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc(tpAniSirGlobal pCtx,
			      uint8_t *pBuf,
			      uint8_t ielen,
			      tDot11fIEWSC *pDst,
			      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WSC,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc. */

#define SigIeWSC (0x0074)


static const tTLVDefn TLVS_WscAssocReq[] = {
	{ offsetof(tDot11fIEWscAssocReq, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscAssocReq, RequestType),
	offsetof(tDot11fTLVRequestType, present), "RequestType",
	SigTlvRequestType, DOT11F_TLV_REQUESTTYPE, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscAssocReq, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_assoc_req(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWscAssocReq *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscAssocReq,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_assoc_req. */

#define SigIeWscAssocReq (0x0075)


static const tTLVDefn TLVS_WscAssocRes[] = {
	{ offsetof(tDot11fIEWscAssocRes, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscAssocRes, ResponseType),
	offsetof(tDot11fTLVResponseType, present), "ResponseType",
	SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscAssocRes, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_assoc_res(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWscAssocRes *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscAssocRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_assoc_res. */

#define SigIeWscAssocRes (0x0076)


static const tTLVDefn TLVS_WscBeacon[] = {
	{ offsetof(tDot11fIEWscBeacon, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, WPSState), offsetof(tDot11fTLVWPSState,
	present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, APSetupLocked),
	offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked",
	SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, SelectedRegistrar),
	offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar",
	SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, DevicePasswordID),
	offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID",
	SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, SelectedRegistrarConfigMethods),
	offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present),
	"SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods,
	DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, UUID_E), offsetof(tDot11fTLVUUID_E,
	present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E,
	0, 20, 20, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, RFBands), offsetof(tDot11fTLVRFBands,
	present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeacon, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_beacon(tpAniSirGlobal pCtx,
				    uint8_t *pBuf,
				    uint8_t ielen,
				    tDot11fIEWscBeacon *pDst,
				    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscBeacon,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_beacon. */

#define SigIeWscBeacon (0x0077)


static const tTLVDefn TLVS_WscBeaconProbeRes[] = {
	{ offsetof(tDot11fIEWscBeaconProbeRes, Version),
	offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion,
	DOT11F_TLV_VERSION, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, WPSState),
	offsetof(tDot11fTLVWPSState, present), "WPSState", SigTlvWPSState,
	DOT11F_TLV_WPSSTATE, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, APSetupLocked),
	offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked",
	SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, SelectedRegistrar),
	offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar",
	SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, DevicePasswordID),
	offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID",
	SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, SelectedRegistrarConfigMethods),
	offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present),
	"SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods,
	DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, ResponseType),
	offsetof(tDot11fTLVResponseType, present), "ResponseType",
	SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, UUID_E),
	offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E,
	DOT11F_TLV_UUID_E, 0, 20, 20, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, Manufacturer),
	offsetof(tDot11fTLVManufacturer, present), "Manufacturer",
	SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, ModelName),
	offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName,
	DOT11F_TLV_MODELNAME, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, ModelNumber),
	offsetof(tDot11fTLVModelNumber, present), "ModelNumber",
	SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, SerialNumber),
	offsetof(tDot11fTLVSerialNumber, present), "SerialNumber",
	SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, PrimaryDeviceType),
	offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType",
	SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE,
	0, 12, 12, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, DeviceName),
	offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName,
	DOT11F_TLV_DEVICENAME, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, ConfigMethods),
	offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods",
	SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, RFBands),
	offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands,
	DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscBeaconProbeRes, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_beacon_probe_res(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint8_t ielen,
					    tDot11fIEWscBeaconProbeRes *pDst,
					    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscBeaconProbeRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_beacon_probe_res. */

#define SigIeWscBeaconProbeRes (0x0078)


uint32_t dot11f_unpack_ie_wsc_ie_opaque(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWscIEOpaque *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	if (ielen > 249) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_wsc_ie_opaque. */

#define SigIeWscIEOpaque (0x0079)


static const tTLVDefn TLVS_WscProbeReq[] = {
	{ offsetof(tDot11fIEWscProbeReq, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, RequestType),
	offsetof(tDot11fTLVRequestType, present), "RequestType",
	SigTlvRequestType, DOT11F_TLV_REQUESTTYPE, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, ConfigMethods),
	offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods",
	SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, UUID_E), offsetof(tDot11fTLVUUID_E,
	present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E,
	0, 20, 20, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, PrimaryDeviceType),
	offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType",
	SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE,
	0, 12, 12, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, RFBands), offsetof(tDot11fTLVRFBands,
	present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, AssociationState),
	offsetof(tDot11fTLVAssociationState, present), "AssociationState",
	SigTlvAssociationState, DOT11F_TLV_ASSOCIATIONSTATE,
	0, 6, 6, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, ConfigurationError),
	offsetof(tDot11fTLVConfigurationError, present), "ConfigurationError",
	SigTlvConfigurationError, DOT11F_TLV_CONFIGURATIONERROR,
	0, 6, 6, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, DevicePasswordID),
	offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID",
	SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID,
	0, 6, 6, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, Manufacturer),
	offsetof(tDot11fTLVManufacturer, present), "Manufacturer",
	SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, ModelName),
	offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName,
	DOT11F_TLV_MODELNAME, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, ModelNumber),
	offsetof(tDot11fTLVModelNumber, present), "ModelNumber",
	SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, DeviceName),
	offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName,
	DOT11F_TLV_DEVICENAME, 0, 4, 36, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeReq, RequestDeviceType),
	offsetof(tDot11fTLVRequestDeviceType, present), "RequestDeviceType",
	SigTlvRequestDeviceType, DOT11F_TLV_REQUESTDEVICETYPE,
	0, 12, 12, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_probe_req(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWscProbeReq *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscProbeReq,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_probe_req. */

#define SigIeWscProbeReq (0x007a)


static const tTLVDefn TLVS_WscProbeRes[] = {
	{ offsetof(tDot11fIEWscProbeRes, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, WPSState), offsetof(tDot11fTLVWPSState,
	present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, APSetupLocked),
	offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked",
	SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, SelectedRegistrar),
	offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar",
	SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, DevicePasswordID),
	offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID",
	SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID,
	0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, SelectedRegistrarConfigMethods),
	offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present),
	"SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods,
	DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, ResponseType),
	offsetof(tDot11fTLVResponseType, present), "ResponseType",
	SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, UUID_E), offsetof(tDot11fTLVUUID_E,
	present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E,
	0, 20, 20, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, Manufacturer),
	offsetof(tDot11fTLVManufacturer, present), "Manufacturer",
	SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, ModelName),
	offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName,
	DOT11F_TLV_MODELNAME, 0, 4, 36, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, ModelNumber),
	offsetof(tDot11fTLVModelNumber, present), "ModelNumber",
	SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, SerialNumber),
	offsetof(tDot11fTLVSerialNumber, present), "SerialNumber",
	SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER, 0, 4, 36, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, PrimaryDeviceType),
	offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType",
	SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE,
	0, 12, 12, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, DeviceName),
	offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName,
	DOT11F_TLV_DEVICENAME, 0, 4, 36, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, ConfigMethods),
	offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods",
	SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, RFBands), offsetof(tDot11fTLVRFBands,
	present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS,
	0, 5, 5, 0, 2, 2, 1, },
	{ offsetof(tDot11fIEWscProbeRes, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_probe_res(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEWscProbeRes *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscProbeRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_probe_res. */

#define SigIeWscProbeRes (0x007b)


static const tTLVDefn TLVS_WscReassocRes[] = {
	{ offsetof(tDot11fIEWscReassocRes, Version), offsetof(tDot11fTLVVersion,
	present), "Version", SigTlvVersion, DOT11F_TLV_VERSION,
	0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscReassocRes, ResponseType),
	offsetof(tDot11fTLVResponseType, present), "ResponseType",
	SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
	{ offsetof(tDot11fIEWscReassocRes, VendorExtension),
	offsetof(tDot11fTLVVendorExtension, present), "VendorExtension",
	SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION,
	0, 7, 21, 0, 2, 2, 1, },
	{0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
};

uint32_t dot11f_unpack_ie_wsc_reassoc_res(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEWscReassocRes *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pBuf; (void)ielen; /* Shutup the compiler */
	pDst->present = 1;
	status = unpack_tlv_core(pCtx, pBuf, ielen,
			TLVS_WscReassocRes,
			(uint8_t *)pDst, sizeof(*pDst));
	return status;
} /* End dot11f_unpack_ie_wsc_reassoc_res. */

#define SigIeWscReassocRes (0x007c)


uint32_t dot11f_unpack_ie_ext_chan_switch_ann(tpAniSirGlobal pCtx,
					      uint8_t *pBuf,
					      uint8_t ielen,
					      tDot11fIEext_chan_switch_ann *pDst,
					      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->switch_mode = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->new_reg_class = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->new_channel = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->switch_count = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ext_chan_switch_ann. */

#define SigIeext_chan_switch_ann (0x007d)


uint32_t dot11f_unpack_ie_fils_assoc_delay_info(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint8_t ielen,
						 tDot11fIEfils_assoc_delay_info *pDst,
						 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->assoc_delay_info = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_assoc_delay_info. */

#define SigIefils_assoc_delay_info (0x007e)


uint32_t dot11f_unpack_ie_fils_hlp_container(tpAniSirGlobal pCtx,
					     uint8_t *pBuf,
					     uint8_t ielen,
					     tDot11fIEfils_hlp_container *pDst,
					     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->dest_mac, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	DOT11F_MEMCPY(pCtx, pDst->src_mac, pBuf, 6);
	pBuf += 6;
	ielen -= (uint8_t)6;
	pDst->num_hlp_packet = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->hlp_packet, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_hlp_container. */

#define SigIefils_hlp_container (0x007f)


uint32_t dot11f_unpack_ie_fils_indication(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIEfils_indication *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint16_t tmp70__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	framesntohs(pCtx, &tmp70__, pBuf, 0);
	pBuf += 2;
	ielen -= 2;
	pDst->public_key_identifiers_cnt = tmp70__ >> 0 & 0x7;
	pDst->realm_identifiers_cnt = tmp70__ >> 3 & 0x7;
	pDst->is_ip_config_supported = tmp70__ >> 6 & 0x1;
	pDst->is_cache_id_present = tmp70__ >> 7 & 0x1;
	pDst->is_hessid_present = tmp70__ >> 8 & 0x1;
	pDst->is_fils_sk_auth_supported = tmp70__ >> 9 & 0x1;
	pDst->is_fils_sk_auth_pfs_supported = tmp70__ >> 10 & 0x1;
	pDst->is_pk_auth_supported = tmp70__ >> 11 & 0x1;
	pDst->reserved = tmp70__ >> 12 & 0xf;
	pDst->num_variable_data = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->variable_data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_indication. */

#define SigIefils_indication (0x0080)


uint32_t dot11f_unpack_ie_fils_kde(tpAniSirGlobal pCtx,
				   uint8_t *pBuf,
				   uint8_t ielen,
				   tDot11fIEfils_kde *pDst,
				   bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->key_rsc, pBuf, 8);
	pBuf += 8;
	ielen -= (uint8_t)8;
	pDst->num_kde_list = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->kde_list, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_kde. */

#define SigIefils_kde (0x0081)


uint32_t dot11f_unpack_ie_fils_key_confirmation(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint8_t ielen,
						 tDot11fIEfils_key_confirmation *pDst,
						 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_key_auth = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->key_auth, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_key_confirmation. */

#define SigIefils_key_confirmation (0x0082)


uint32_t dot11f_unpack_ie_fils_nonce(tpAniSirGlobal pCtx,
				     uint8_t *pBuf,
				     uint8_t ielen,
				     tDot11fIEfils_nonce *pDst,
				     bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->nonce, pBuf, 16);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_nonce. */

#define SigIefils_nonce (0x0083)


uint32_t dot11f_unpack_ie_fils_public_key(tpAniSirGlobal pCtx,
					  uint8_t *pBuf,
					  uint8_t ielen,
					  tDot11fIEfils_public_key *pDst,
					  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->key_type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_public_key = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->public_key, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_public_key. */

#define SigIefils_public_key (0x0084)


uint32_t dot11f_unpack_ie_fils_session(tpAniSirGlobal pCtx,
				       uint8_t *pBuf,
				       uint8_t ielen,
				       tDot11fIEfils_session *pDst,
				       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	DOT11F_MEMCPY(pCtx, pDst->session, pBuf, 8);
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_session. */

#define SigIefils_session (0x0085)


uint32_t dot11f_unpack_ie_fils_wrapped_data(tpAniSirGlobal pCtx,
					    uint8_t *pBuf,
					    uint8_t ielen,
					    tDot11fIEfils_wrapped_data *pDst,
					    bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_wrapped_data = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->wrapped_data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fils_wrapped_data. */

#define SigIefils_wrapped_data (0x0086)


uint32_t dot11f_unpack_ie_fragment_ie(tpAniSirGlobal pCtx,
				      uint8_t *pBuf,
				      uint8_t ielen,
				      tDot11fIEfragment_ie *pDst,
				      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_fragment_ie. */

#define SigIefragment_ie (0x0087)


uint32_t dot11f_unpack_ie_hs20vendor_ie(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEhs20vendor_ie *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp71__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp71__ = *pBuf;
	pBuf += 1;
	ielen -= 1;
	pDst->dgaf_dis = tmp71__ >> 0 & 0x1;
	pDst->hs_id_present = tmp71__ >> 1 & 0x3;
	pDst->reserved = tmp71__ >> 3 & 0x1;
	pDst->release_num = tmp71__ >> 4 & 0xf;
	if (!ielen) {
		return 0U;
	} else {
		switch (pDst->hs_id_present) {
		case 1:
			framesntohs(pCtx, &pDst->hs_id.pps_mo.pps_mo_id, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			break;
		case 2:
			framesntohs(pCtx, &pDst->hs_id.anqp_domain.anqp_domain_id, pBuf, 0);
			pBuf += 2;
			ielen -= (uint8_t)2;
			break;
		}
	}
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_hs20vendor_ie. */

#define SigIehs20vendor_ie (0x0088)


uint32_t dot11f_unpack_ie_ht2040_bss_coexistence(tpAniSirGlobal pCtx,
						 uint8_t *pBuf,
						 uint8_t ielen,
						 tDot11fIEht2040_bss_coexistence *pDst,
						 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint8_t tmp72__;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	tmp72__ = *pBuf;
	pDst->info_request = tmp72__ >> 0 & 0x1;
	pDst->forty_mhz_intolerant = tmp72__ >> 1 & 0x1;
	pDst->twenty_mhz_bsswidth_req = tmp72__ >> 2 & 0x1;
	pDst->obss_scan_exemption_req = tmp72__ >> 3 & 0x1;
	pDst->obss_scan_exemption_grant = tmp72__ >> 4 & 0x1;
	pDst->unused = tmp72__ >> 5 & 0x7;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ht2040_bss_coexistence. */

#define SigIeht2040_bss_coexistence (0x0089)


uint32_t dot11f_unpack_ie_ht2040_bss_intolerant_report(tpAniSirGlobal pCtx,
						       uint8_t *pBuf,
						       uint8_t ielen,
						       tDot11fIEht2040_bss_intolerant_report *pDst,
						       bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->operating_class = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	pDst->num_channel_list = (uint8_t)(ielen);
	if (ielen > 50) {
		pDst->present = 0;
		return DOT11F_SKIPPED_BAD_IE;
	}

	DOT11F_MEMCPY(pCtx, pDst->channel_list, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_ht2040_bss_intolerant_report. */

#define SigIeht2040_bss_intolerant_report (0x008a)


uint32_t dot11f_unpack_ie_osen_ie(tpAniSirGlobal pCtx,
				  uint8_t *pBuf,
				  uint8_t ielen,
				  tDot11fIEosen_ie *pDst,
				  bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->num_data = (uint8_t)(ielen);
	DOT11F_MEMCPY(pCtx, pDst->data, pBuf, (ielen));
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_osen_ie. */

#define SigIeosen_ie (0x008b)


uint32_t dot11f_unpack_ie_sec_chan_offset_ele(tpAniSirGlobal pCtx,
					      uint8_t *pBuf,
					      uint8_t ielen,
					      tDot11fIEsec_chan_offset_ele *pDst,
					      bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->secondaryChannelOffset = *pBuf;
	(void)pCtx;
	return status;
} /* End dot11f_unpack_ie_sec_chan_offset_ele. */

#define SigIesec_chan_offset_ele (0x008c)


static const tFFDefn FFS_vendor_vht_ie[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_vendor_vht_ie[] = {
	{ offsetof(tDot11fIEvendor_vht_ie, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fIEvendor_vht_ie, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

uint32_t dot11f_unpack_ie_vendor_vht_ie(tpAniSirGlobal pCtx,
					 uint8_t *pBuf,
					 uint8_t ielen,
					 tDot11fIEvendor_vht_ie *pDst,
					 bool append_ie)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void) pBuf; (void)ielen; /* Shutup the compiler */
	if (pDst->present)
		status = DOT11F_DUPLICATE_IE;
	pDst->present = 1;
	pDst->sub_type = *pBuf;
	pBuf += 1;
	ielen -= (uint8_t)1;
	(void)pCtx;
	status |= unpack_core(pCtx,
				pBuf,
				ielen,
				FFS_vendor_vht_ie,
				IES_vendor_vht_ie,
				(uint8_t *)pDst,
				sizeof(*pDst),
				append_ie);
	return status;
} /* End dot11f_unpack_ie_vendor_vht_ie. */

#define SigIevendor_vht_ie (0x008d)


static const tFFDefn FFS_AddTSRequest[] = {
	{ "Category", offsetof(tDot11fAddTSRequest, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fAddTSRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fAddTSRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_AddTSRequest[] = {
	{ offsetof(tDot11fAddTSRequest, TSPEC), offsetof(tDot11fIETSPEC, present),
	0, "TSPEC", 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSPEC, 0, 1, },
	{ offsetof(tDot11fAddTSRequest, TCLAS), offsetof(tDot11fIETCLAS, present),
	offsetof(tDot11fAddTSRequest, num_TCLAS), "TCLAS", 2, 7, 45, SigIeTCLAS,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, 0, },
	{ offsetof(tDot11fAddTSRequest, TCLASSPROC),
	offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC",
	0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TCLASSPROC, 0, 0, },
	{ offsetof(tDot11fAddTSRequest, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), 0, "WMMTSPEC", 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fAddTSRequest, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS,
	present), offsetof(tDot11fAddTSRequest, num_WMMTCLAS), "WMMTCLAS",
	2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6},
	5, DOT11F_EID_WMMTCLAS, 0, 0, },
	{ offsetof(tDot11fAddTSRequest, WMMTCLASPROC),
	offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC",
	0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7},
	5, DOT11F_EID_WMMTCLASPROC, 0, 0, },
	{ offsetof(tDot11fAddTSRequest, ESETrafStrmRateSet),
	offsetof(tDot11fIEESETrafStrmRateSet, present), 0, "ESETrafStrmRateSet",
	0, 7, 15, SigIeESETrafStrmRateSet, {0, 64, 150, 8, 0},
	4, DOT11F_EID_ESETRAFSTRMRATESET, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_add_ts_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fAddTSRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_AddTSRequest, IES_AddTSRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_add_ts_request. */

static const tFFDefn FFS_AddTSResponse[] = {
	{ "Category", offsetof(tDot11fAddTSResponse, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fAddTSResponse, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fAddTSResponse, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "Status", offsetof(tDot11fAddTSResponse, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_AddTSResponse[] = {
	{ offsetof(tDot11fAddTSResponse, TSDelay), offsetof(tDot11fIETSDelay,
	present), 0, "TSDelay", 0, 6, 6, SigIeTSDelay, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSDELAY, 0, 1, },
	{ offsetof(tDot11fAddTSResponse, TSPEC), offsetof(tDot11fIETSPEC,
	present), 0, "TSPEC", 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TSPEC, 0, 1, },
	{ offsetof(tDot11fAddTSResponse, TCLAS), offsetof(tDot11fIETCLAS,
	present), offsetof(tDot11fAddTSResponse, num_TCLAS), "TCLAS",
	2, 7, 45, SigIeTCLAS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, TCLASSPROC),
	offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC",
	0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TCLASSPROC, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, Schedule), offsetof(tDot11fIESchedule,
	present), 0, "Schedule", 0, 16, 16, SigIeSchedule, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SCHEDULE, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, WMMTSDelay),
	offsetof(tDot11fIEWMMTSDelay, present), 0, "WMMTSDelay",
	0, 12, 12, SigIeWMMTSDelay, {0, 80, 242, 2, 8},
	5, DOT11F_EID_WMMTSDELAY, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, WMMSchedule),
	offsetof(tDot11fIEWMMSchedule, present), 0, "WMMSchedule",
	0, 22, 22, SigIeWMMSchedule, {0, 80, 242, 2, 9},
	5, DOT11F_EID_WMMSCHEDULE, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), 0, "WMMTSPEC", 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS,
	present), offsetof(tDot11fAddTSResponse, num_WMMTCLAS), "WMMTCLAS",
	2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6},
	5, DOT11F_EID_WMMTCLAS, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, WMMTCLASPROC),
	offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC",
	0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7},
	5, DOT11F_EID_WMMTCLASPROC, 0, 0, },
	{ offsetof(tDot11fAddTSResponse, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_add_ts_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fAddTSResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_AddTSResponse, IES_AddTSResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_add_ts_response. */

static const tFFDefn FFS_AssocRequest[] = {
	{ "Capabilities", offsetof(tDot11fAssocRequest, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ "ListenInterval", offsetof(tDot11fAssocRequest, ListenInterval),
	SigFfListenInterval, DOT11F_FF_LISTENINTERVAL_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_AssocRequest[] = {
	{ offsetof(tDot11fAssocRequest, SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fAssocRequest, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fAssocRequest, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, PowerCaps), offsetof(tDot11fIEPowerCaps,
	present), 0, "PowerCaps", 0, 4, 4, SigIePowerCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCAPS, 0, 0, },
	{ offsetof(tDot11fAssocRequest, SuppChannels),
	offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels",
	0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPCHANNELS, 0, 0, },
	{ offsetof(tDot11fAssocRequest, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fAssocRequest, QOSCapsStation),
	offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation",
	0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSSTATION, 0, 0, },
	{ offsetof(tDot11fAssocRequest, RSNOpaque), offsetof(tDot11fIERSNOpaque,
	present), 0, "RSNOpaque", 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fAssocRequest, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fAssocRequest, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WAPIOpaque),
	offsetof(tDot11fIEWAPIOpaque, present), 0, "WAPIOpaque",
	0, 8, 255, SigIeWAPIOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPIOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WAPI), offsetof(tDot11fIEWAPI, present), 0,
	"WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fAssocRequest, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fAssocRequest, QosMapSet), offsetof(tDot11fIEQosMapSet,
	present), 0, "QosMapSet", 0, 2, 62, SigIeQosMapSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSMAPSET, 0, 0, },
	{ offsetof(tDot11fAssocRequest, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fAssocRequest, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fAssocRequest, fils_session),
	offsetof(tDot11fIEfils_session, present), 0, "fils_session",
	0, 10, 10, SigIefils_session, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_SESSION, 4, 0, },
	{ offsetof(tDot11fAssocRequest, fils_public_key),
	offsetof(tDot11fIEfils_public_key, present), 0, "fils_public_key",
	0, 3, 258, SigIefils_public_key, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_PUBLIC_KEY, 12, 0, },
	{ offsetof(tDot11fAssocRequest, fils_key_confirmation),
	offsetof(tDot11fIEfils_key_confirmation, present), 0,
	"fils_key_confirmation", 0, 2, 257, SigIefils_key_confirmation,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_FILS_KEY_CONFIRMATION, 3, 0, },
	{ offsetof(tDot11fAssocRequest, fils_hlp_container),
	offsetof(tDot11fIEfils_hlp_container, present), 0, "fils_hlp_container",
	0, 14, 269, SigIefils_hlp_container, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_HLP_CONTAINER, 5, 0, },
	{ offsetof(tDot11fAssocRequest, fragment_ie),
	offsetof(tDot11fIEfragment_ie, present), 0, "fragment_ie",
	0, 2, 257, SigIefragment_ie, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FRAGMENT_IE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WPAOpaque), offsetof(tDot11fIEWPAOpaque,
	present), 0, "WPAOpaque", 0, 8, 255, SigIeWPAOpaque, {0, 80, 242, 1, 0},
	4, DOT11F_EID_WPAOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WMMCaps), offsetof(tDot11fIEWMMCaps,
	present), 0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WMMInfoStation),
	offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation",
	0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOSTATION, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WscIEOpaque),
	offsetof(tDot11fIEWscIEOpaque, present), 0, "WscIEOpaque",
	0, 8, 255, SigIeWscIEOpaque, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fAssocRequest, ESEVersion),
	offsetof(tDot11fIEESEVersion, present), 0, "ESEVersion",
	0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fAssocRequest, P2PIEOpaque),
	offsetof(tDot11fIEP2PIEOpaque, present), 0, "P2PIEOpaque",
	0, 8, 255, SigIeP2PIEOpaque, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, WFDIEOpaque),
	offsetof(tDot11fIEWFDIEOpaque, present), 0, "WFDIEOpaque",
	0, 8, 255, SigIeWFDIEOpaque, {80, 111, 154, 10, 0},
	4, DOT11F_EID_WFDIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, MBO_IE), offsetof(tDot11fIEMBO_IE,
	present), 0, "MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, QCN_IE), offsetof(tDot11fIEQCN_IE,
	present), 0, "QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{ offsetof(tDot11fAssocRequest, osen_ie), offsetof(tDot11fIEosen_ie,
	present), 0, "osen_ie", 0, 6, 261, SigIeosen_ie, {80, 111, 154, 18, 0},
	4, DOT11F_EID_OSEN_IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_assoc_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fAssocRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_AssocRequest, IES_AssocRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_assoc_request. */

static const tFFDefn FFS_AssocResponse[] = {
	{ "Capabilities", offsetof(tDot11fAssocResponse, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ "Status", offsetof(tDot11fAssocResponse, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ "AID", offsetof(tDot11fAssocResponse, AID), SigFfAID,
	DOT11F_FF_AID_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_AssocResponse[] = {
	{ offsetof(tDot11fAssocResponse, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fAssocResponse, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fAssocResponse, EDCAParamSet),
	offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet",
	0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fAssocResponse, RCPIIE), offsetof(tDot11fIERCPIIE,
	present), 0, "RCPIIE", 0, 3, 3, SigIeRCPIIE, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RCPIIE, 0, 0, },
	{ offsetof(tDot11fAssocResponse, RSNIIE), offsetof(tDot11fIERSNIIE,
	present), 0, "RSNIIE", 0, 3, 3, SigIeRSNIIE, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNIIE, 0, 0, },
	{ offsetof(tDot11fAssocResponse, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fAssocResponse, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fAssocResponse, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fAssocResponse, RICDataDesc),
	offsetof(tDot11fIERICDataDesc, present),
	offsetof(tDot11fAssocResponse, num_RICDataDesc), "RICDataDesc",
	2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATADESC, 0, 0, },
	{ offsetof(tDot11fAssocResponse, WPA), offsetof(tDot11fIEWPA, present), 0,
	"WPA", 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fAssocResponse, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fAssocResponse, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fAssocResponse, HTInfo), offsetof(tDot11fIEHTInfo,
	present), 0, "HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fAssocResponse, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fAssocResponse, WMMCaps), offsetof(tDot11fIEWMMCaps,
	present), 0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fAssocResponse, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fAssocResponse, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fAssocResponse, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fAssocResponse, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), offsetof(tDot11fAssocResponse, num_WMMTSPEC), "WMMTSPEC",
	4, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fAssocResponse, WscAssocRes),
	offsetof(tDot11fIEWscAssocRes, present), 0, "WscAssocRes",
	0, 6, 37, SigIeWscAssocRes, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCASSOCRES, 0, 0, },
	{ offsetof(tDot11fAssocResponse, P2PAssocRes),
	offsetof(tDot11fIEP2PAssocRes, present), 0, "P2PAssocRes",
	0, 6, 17, SigIeP2PAssocRes, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PASSOCRES, 0, 0, },
	{ offsetof(tDot11fAssocResponse, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fAssocResponse, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fAssocResponse, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fAssocResponse, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fAssocResponse, QosMapSet), offsetof(tDot11fIEQosMapSet,
	present), 0, "QosMapSet", 0, 2, 62, SigIeQosMapSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSMAPSET, 0, 0, },
	{ offsetof(tDot11fAssocResponse, fils_session),
	offsetof(tDot11fIEfils_session, present), 0, "fils_session",
	0, 10, 10, SigIefils_session, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_SESSION, 4, 0, },
	{ offsetof(tDot11fAssocResponse, fils_public_key),
	offsetof(tDot11fIEfils_public_key, present), 0, "fils_public_key",
	0, 3, 258, SigIefils_public_key, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_PUBLIC_KEY, 12, 0, },
	{ offsetof(tDot11fAssocResponse, fils_key_confirmation),
	offsetof(tDot11fIEfils_key_confirmation, present), 0,
	"fils_key_confirmation", 0, 2, 257, SigIefils_key_confirmation,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_FILS_KEY_CONFIRMATION, 3, 0, },
	{ offsetof(tDot11fAssocResponse, fils_hlp_container),
	offsetof(tDot11fIEfils_hlp_container, present), 0, "fils_hlp_container",
	0, 14, 269, SigIefils_hlp_container, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_HLP_CONTAINER, 5, 0, },
	{ offsetof(tDot11fAssocResponse, fragment_ie),
	offsetof(tDot11fIEfragment_ie, present), 0, "fragment_ie",
	0, 2, 257, SigIefragment_ie, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FRAGMENT_IE, 0, 0, },
	{ offsetof(tDot11fAssocResponse, fils_kde), offsetof(tDot11fIEfils_kde,
	present), 0, "fils_kde", 0, 10, 265, SigIefils_kde, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_KDE, 7, 0, },
	{ offsetof(tDot11fAssocResponse, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fAssocResponse, MBO_IE), offsetof(tDot11fIEMBO_IE,
	present), 0, "MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{ offsetof(tDot11fAssocResponse, QCN_IE), offsetof(tDot11fIEQCN_IE,
	present), 0, "QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_assoc_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fAssocResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_AssocResponse, IES_AssocResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_assoc_response. */

static const tFFDefn FFS_Authentication[] = {
	{ "AuthAlgo", offsetof(tDot11fAuthentication, AuthAlgo), SigFfAuthAlgo,
	DOT11F_FF_AUTHALGO_LEN, },
	{ "AuthSeqNo", offsetof(tDot11fAuthentication, AuthSeqNo), SigFfAuthSeqNo,
	DOT11F_FF_AUTHSEQNO_LEN, },
	{ "Status", offsetof(tDot11fAuthentication, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_Authentication[] = {
	{ offsetof(tDot11fAuthentication, ChallengeText),
	offsetof(tDot11fIEChallengeText, present), 0, "ChallengeText",
	0, 3, 255, SigIeChallengeText, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHALLENGETEXT, 0, 0, },
	{ offsetof(tDot11fAuthentication, RSNOpaque),
	offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque",
	0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fAuthentication, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fAuthentication, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fAuthentication, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fAuthentication, RICDataDesc),
	offsetof(tDot11fIERICDataDesc, present),
	offsetof(tDot11fAuthentication, num_RICDataDesc), "RICDataDesc",
	2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATADESC, 0, 0, },
	{ offsetof(tDot11fAuthentication, fils_nonce),
	offsetof(tDot11fIEfils_nonce, present), 0, "fils_nonce",
	0, 18, 18, SigIefils_nonce, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_NONCE, 13, 0, },
	{ offsetof(tDot11fAuthentication, fils_session),
	offsetof(tDot11fIEfils_session, present), 0, "fils_session",
	0, 10, 10, SigIefils_session, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_SESSION, 4, 0, },
	{ offsetof(tDot11fAuthentication, fils_wrapped_data),
	offsetof(tDot11fIEfils_wrapped_data, present), 0, "fils_wrapped_data",
	0, 2, 257, SigIefils_wrapped_data, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_WRAPPED_DATA, 8, 0, },
	{ offsetof(tDot11fAuthentication, fils_assoc_delay_info),
	offsetof(tDot11fIEfils_assoc_delay_info, present), 0,
	"fils_assoc_delay_info", 0, 3, 3, SigIefils_assoc_delay_info,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_FILS_ASSOC_DELAY_INFO, 1, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_authentication(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fAuthentication *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_Authentication, IES_Authentication,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_authentication. */

static const tFFDefn FFS_Beacon[] = {
	{ "TimeStamp", offsetof(tDot11fBeacon, TimeStamp), SigFfTimeStamp,
	DOT11F_FF_TIMESTAMP_LEN, },
	{ "BeaconInterval", offsetof(tDot11fBeacon, BeaconInterval),
	SigFfBeaconInterval, DOT11F_FF_BEACONINTERVAL_LEN, },
	{ "Capabilities", offsetof(tDot11fBeacon, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_Beacon[] = {
	{ offsetof(tDot11fBeacon, SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fBeacon, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fBeacon, FHParamSet), offsetof(tDot11fIEFHParamSet,
	present), 0, "FHParamSet", 0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMSET, 0, 0, },
	{ offsetof(tDot11fBeacon, DSParams), offsetof(tDot11fIEDSParams, present),
	0, "DSParams", 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_DSPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon, CFParams), offsetof(tDot11fIECFParams, present),
	0, "CFParams", 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CFPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon, IBSSParams), offsetof(tDot11fIEIBSSParams,
	present), 0, "IBSSParams", 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_IBSSPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon, TIM), offsetof(tDot11fIETIM, present), 0, "TIM",
	0, 6, 256, SigIeTIM, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TIM, 0, 0, },
	{ offsetof(tDot11fBeacon, Country), offsetof(tDot11fIECountry, present), 0,
	"Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fBeacon, FHParams), offsetof(tDot11fIEFHParams, present),
	0, "FHParams", 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon, FHPattTable), offsetof(tDot11fIEFHPattTable,
	present), 0, "FHPattTable", 0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPATTTABLE, 0, 0, },
	{ offsetof(tDot11fBeacon, PowerConstraints),
	offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints",
	0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCONSTRAINTS, 0, 0, },
	{ offsetof(tDot11fBeacon, ChanSwitchAnn),
	offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn",
	0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeacon, ext_chan_switch_ann),
	offsetof(tDot11fIEext_chan_switch_ann, present), 0, "ext_chan_switch_ann",
	0, 6, 6, SigIeext_chan_switch_ann, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXT_CHAN_SWITCH_ANN, 0, 0, },
	{ offsetof(tDot11fBeacon, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fBeacon, Quiet), offsetof(tDot11fIEQuiet, present), 0,
	"Quiet", 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QUIET, 0, 0, },
	{ offsetof(tDot11fBeacon, TPCReport), offsetof(tDot11fIETPCReport,
	present), 0, "TPCReport", 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREPORT, 0, 0, },
	{ offsetof(tDot11fBeacon, ERPInfo), offsetof(tDot11fIEERPInfo, present), 0,
	"ERPInfo", 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ERPINFO, 0, 0, },
	{ offsetof(tDot11fBeacon, ExtSuppRates), offsetof(tDot11fIEExtSuppRates,
	present), 0, "ExtSuppRates", 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fBeacon, RSN), offsetof(tDot11fIERSN, present), 0, "RSN",
	0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fBeacon, QBSSLoad), offsetof(tDot11fIEQBSSLoad, present),
	0, "QBSSLoad", 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QBSSLOAD, 0, 0, },
	{ offsetof(tDot11fBeacon, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet,
	present), 0, "EDCAParamSet", 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fBeacon, QOSCapsAp), offsetof(tDot11fIEQOSCapsAp,
	present), 0, "QOSCapsAp", 0, 3, 3, SigIeQOSCapsAp, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSAP, 0, 0, },
	{ offsetof(tDot11fBeacon, APChannelReport),
	offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport",
	0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_APCHANNELREPORT, 0, 0, },
	{ offsetof(tDot11fBeacon, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fBeacon, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fBeacon, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA",
	0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fBeacon, HTCaps), offsetof(tDot11fIEHTCaps, present), 0,
	"HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon, HTInfo), offsetof(tDot11fIEHTInfo, present), 0,
	"HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fBeacon, sec_chan_offset_ele),
	offsetof(tDot11fIEsec_chan_offset_ele, present), 0, "sec_chan_offset_ele",
	0, 3, 3, SigIesec_chan_offset_ele, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SEC_CHAN_OFFSET_ELE, 0, 0, },
	{ offsetof(tDot11fBeacon, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp,
	present), 0, "WMMInfoAp", 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOAP, 0, 0, },
	{ offsetof(tDot11fBeacon, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0,
	"WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon, WAPI), offsetof(tDot11fIEWAPI, present), 0,
	"WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fBeacon, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fBeacon, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fBeacon, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fBeacon, WscBeacon), offsetof(tDot11fIEWscBeacon,
	present), 0, "WscBeacon", 0, 6, 84, SigIeWscBeacon, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCBEACON, 0, 0, },
	{ offsetof(tDot11fBeacon, P2PBeacon), offsetof(tDot11fIEP2PBeacon,
	present), 0, "P2PBeacon", 0, 6, 61, SigIeP2PBeacon, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PBEACON, 0, 0, },
	{ offsetof(tDot11fBeacon, VHTCaps), offsetof(tDot11fIEVHTCaps, present), 0,
	"VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon, VHTOperation), offsetof(tDot11fIEVHTOperation,
	present), 0, "VHTOperation", 0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fBeacon, VHTExtBssLoad),
	offsetof(tDot11fIEVHTExtBssLoad, present), 0, "VHTExtBssLoad",
	0, 7, 7, SigIeVHTExtBssLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTEXTBSSLOAD, 0, 0, },
	{ offsetof(tDot11fBeacon, ExtCap), offsetof(tDot11fIEExtCap, present), 0,
	"ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fBeacon, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{ offsetof(tDot11fBeacon, WiderBWChanSwitchAnn),
	offsetof(tDot11fIEWiderBWChanSwitchAnn, present), 0,
	"WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeacon, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fBeacon, fils_indication),
	offsetof(tDot11fIEfils_indication, present), 0, "fils_indication",
	0, 7, 259, SigIefils_indication, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_INDICATION, 0, 0, },
	{ offsetof(tDot11fBeacon, Vendor1IE), offsetof(tDot11fIEVendor1IE,
	present), 0, "Vendor1IE", 0, 5, 5, SigIeVendor1IE, {0, 16, 24, 0, 0},
	3, DOT11F_EID_VENDOR1IE, 0, 0, },
	{ offsetof(tDot11fBeacon, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fBeacon, Vendor3IE), offsetof(tDot11fIEVendor3IE,
	present), 0, "Vendor3IE", 0, 5, 5, SigIeVendor3IE, {0, 22, 50, 0, 0},
	3, DOT11F_EID_VENDOR3IE, 0, 0, },
	{ offsetof(tDot11fBeacon, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{ offsetof(tDot11fBeacon, ChannelSwitchWrapper),
	offsetof(tDot11fIEChannelSwitchWrapper, present), 0,
	"ChannelSwitchWrapper", 0, 2, 14, SigIeChannelSwitchWrapper,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANNELSWITCHWRAPPER, 0, 0, },
	{ offsetof(tDot11fBeacon, QComVendorIE), offsetof(tDot11fIEQComVendorIE,
	present), 0, "QComVendorIE", 0, 7, 7, SigIeQComVendorIE,
	{0, 160, 198, 0, 0}, 3, DOT11F_EID_QCOMVENDORIE, 0, 0, },
	{ offsetof(tDot11fBeacon, ESEVersion), offsetof(tDot11fIEESEVersion,
	present), 0, "ESEVersion", 0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fBeacon, MBO_IE), offsetof(tDot11fIEMBO_IE, present), 0,
	"MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{ offsetof(tDot11fBeacon, QCN_IE), offsetof(tDot11fIEQCN_IE, present), 0,
	"QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{ offsetof(tDot11fBeacon, ESP_information),
	offsetof(tDot11fIEESP_information, present), 0, "ESP_information",
	0, 2, 98, SigIeESP_information, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ESP_INFORMATION, 11, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_beacon(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fBeacon *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_Beacon, IES_Beacon,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_beacon. */

static const tFFDefn FFS_Beacon1[] = {
	{ "TimeStamp", offsetof(tDot11fBeacon1, TimeStamp), SigFfTimeStamp,
	DOT11F_FF_TIMESTAMP_LEN, },
	{ "BeaconInterval", offsetof(tDot11fBeacon1, BeaconInterval),
	SigFfBeaconInterval, DOT11F_FF_BEACONINTERVAL_LEN, },
	{ "Capabilities", offsetof(tDot11fBeacon1, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_Beacon1[] = {
	{ offsetof(tDot11fBeacon1, SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fBeacon1, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fBeacon1, DSParams), offsetof(tDot11fIEDSParams,
	present), 0, "DSParams", 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_DSPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon1, IBSSParams), offsetof(tDot11fIEIBSSParams,
	present), 0, "IBSSParams", 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_IBSSPARAMS, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_beacon1(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fBeacon1 *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_Beacon1, IES_Beacon1,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_beacon1. */

static const tFFDefn FFS_Beacon2[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_Beacon2[] = {
	{ offsetof(tDot11fBeacon2, Country), offsetof(tDot11fIECountry, present),
	0, "Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fBeacon2, PowerConstraints),
	offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints",
	0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCONSTRAINTS, 0, 0, },
	{ offsetof(tDot11fBeacon2, ChanSwitchAnn),
	offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn",
	0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeacon2, ext_chan_switch_ann),
	offsetof(tDot11fIEext_chan_switch_ann, present), 0, "ext_chan_switch_ann",
	0, 6, 6, SigIeext_chan_switch_ann, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXT_CHAN_SWITCH_ANN, 0, 0, },
	{ offsetof(tDot11fBeacon2, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fBeacon2, Quiet), offsetof(tDot11fIEQuiet, present), 0,
	"Quiet", 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QUIET, 0, 0, },
	{ offsetof(tDot11fBeacon2, TPCReport), offsetof(tDot11fIETPCReport,
	present), 0, "TPCReport", 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREPORT, 0, 0, },
	{ offsetof(tDot11fBeacon2, ERPInfo), offsetof(tDot11fIEERPInfo, present),
	0, "ERPInfo", 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ERPINFO, 0, 0, },
	{ offsetof(tDot11fBeacon2, ExtSuppRates), offsetof(tDot11fIEExtSuppRates,
	present), 0, "ExtSuppRates", 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fBeacon2, RSNOpaque), offsetof(tDot11fIERSNOpaque,
	present), 0, "RSNOpaque", 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fBeacon2, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet,
	present), 0, "EDCAParamSet", 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fBeacon2, APChannelReport),
	offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport",
	0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_APCHANNELREPORT, 0, 0, },
	{ offsetof(tDot11fBeacon2, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fBeacon2, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fBeacon2, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA",
	0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fBeacon2, HTCaps), offsetof(tDot11fIEHTCaps, present), 0,
	"HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon2, HTInfo), offsetof(tDot11fIEHTInfo, present), 0,
	"HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fBeacon2, sec_chan_offset_ele),
	offsetof(tDot11fIEsec_chan_offset_ele, present), 0, "sec_chan_offset_ele",
	0, 3, 3, SigIesec_chan_offset_ele, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SEC_CHAN_OFFSET_ELE, 0, 0, },
	{ offsetof(tDot11fBeacon2, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp,
	present), 0, "WMMInfoAp", 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOAP, 0, 0, },
	{ offsetof(tDot11fBeacon2, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fBeacon2, WMMCaps), offsetof(tDot11fIEWMMCaps, present),
	0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon2, WscBeacon), offsetof(tDot11fIEWscBeacon,
	present), 0, "WscBeacon", 0, 6, 84, SigIeWscBeacon, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCBEACON, 0, 0, },
	{ offsetof(tDot11fBeacon2, WAPI), offsetof(tDot11fIEWAPI, present), 0,
	"WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fBeacon2, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fBeacon2, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fBeacon2, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fBeacon2, P2PBeacon), offsetof(tDot11fIEP2PBeacon,
	present), 0, "P2PBeacon", 0, 6, 61, SigIeP2PBeacon, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PBEACON, 0, 0, },
	{ offsetof(tDot11fBeacon2, VHTCaps), offsetof(tDot11fIEVHTCaps, present),
	0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fBeacon2, VHTOperation), offsetof(tDot11fIEVHTOperation,
	present), 0, "VHTOperation", 0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fBeacon2, VHTExtBssLoad),
	offsetof(tDot11fIEVHTExtBssLoad, present), 0, "VHTExtBssLoad",
	0, 7, 7, SigIeVHTExtBssLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTEXTBSSLOAD, 0, 0, },
	{ offsetof(tDot11fBeacon2, ExtCap), offsetof(tDot11fIEExtCap, present), 0,
	"ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fBeacon2, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{ offsetof(tDot11fBeacon2, WiderBWChanSwitchAnn),
	offsetof(tDot11fIEWiderBWChanSwitchAnn, present), 0,
	"WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeacon2, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fBeacon2, fils_indication),
	offsetof(tDot11fIEfils_indication, present), 0, "fils_indication",
	0, 7, 259, SigIefils_indication, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_INDICATION, 0, 0, },
	{ offsetof(tDot11fBeacon2, Vendor1IE), offsetof(tDot11fIEVendor1IE,
	present), 0, "Vendor1IE", 0, 5, 5, SigIeVendor1IE, {0, 16, 24, 0, 0},
	3, DOT11F_EID_VENDOR1IE, 0, 0, },
	{ offsetof(tDot11fBeacon2, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fBeacon2, Vendor3IE), offsetof(tDot11fIEVendor3IE,
	present), 0, "Vendor3IE", 0, 5, 5, SigIeVendor3IE, {0, 22, 50, 0, 0},
	3, DOT11F_EID_VENDOR3IE, 0, 0, },
	{ offsetof(tDot11fBeacon2, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{ offsetof(tDot11fBeacon2, ChannelSwitchWrapper),
	offsetof(tDot11fIEChannelSwitchWrapper, present), 0,
	"ChannelSwitchWrapper", 0, 2, 14, SigIeChannelSwitchWrapper,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANNELSWITCHWRAPPER, 0, 0, },
	{ offsetof(tDot11fBeacon2, QComVendorIE), offsetof(tDot11fIEQComVendorIE,
	present), 0, "QComVendorIE", 0, 7, 7, SigIeQComVendorIE,
	{0, 160, 198, 0, 0}, 3, DOT11F_EID_QCOMVENDORIE, 0, 0, },
	{ offsetof(tDot11fBeacon2, ESEVersion), offsetof(tDot11fIEESEVersion,
	present), 0, "ESEVersion", 0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fBeacon2, QCN_IE), offsetof(tDot11fIEQCN_IE, present), 0,
	"QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{ offsetof(tDot11fBeacon2, ESP_information),
	offsetof(tDot11fIEESP_information, present), 0, "ESP_information",
	0, 2, 98, SigIeESP_information, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ESP_INFORMATION, 11, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_beacon2(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fBeacon2 *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_Beacon2, IES_Beacon2,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_beacon2. */

static const tFFDefn FFS_BeaconIEs[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_BeaconIEs[] = {
	{ offsetof(tDot11fBeaconIEs, SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fBeaconIEs, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fBeaconIEs, FHParamSet), offsetof(tDot11fIEFHParamSet,
	present), 0, "FHParamSet", 0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMSET, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, DSParams), offsetof(tDot11fIEDSParams,
	present), 0, "DSParams", 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_DSPARAMS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, CFParams), offsetof(tDot11fIECFParams,
	present), 0, "CFParams", 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CFPARAMS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, IBSSParams), offsetof(tDot11fIEIBSSParams,
	present), 0, "IBSSParams", 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_IBSSPARAMS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, TIM), offsetof(tDot11fIETIM, present), 0,
	"TIM", 0, 6, 256, SigIeTIM, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TIM, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, Country), offsetof(tDot11fIECountry,
	present), 0, "Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, FHParams), offsetof(tDot11fIEFHParams,
	present), 0, "FHParams", 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, FHPattTable), offsetof(tDot11fIEFHPattTable,
	present), 0, "FHPattTable", 0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPATTTABLE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, PowerConstraints),
	offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints",
	0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCONSTRAINTS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ChanSwitchAnn),
	offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn",
	0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ext_chan_switch_ann),
	offsetof(tDot11fIEext_chan_switch_ann, present), 0, "ext_chan_switch_ann",
	0, 6, 6, SigIeext_chan_switch_ann, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXT_CHAN_SWITCH_ANN, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, Quiet), offsetof(tDot11fIEQuiet, present), 0,
	"Quiet", 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QUIET, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, TPCReport), offsetof(tDot11fIETPCReport,
	present), 0, "TPCReport", 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREPORT, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ERPInfo), offsetof(tDot11fIEERPInfo,
	present), 0, "ERPInfo", 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ERPINFO, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, RSN), offsetof(tDot11fIERSN, present), 0,
	"RSN", 0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, QBSSLoad), offsetof(tDot11fIEQBSSLoad,
	present), 0, "QBSSLoad", 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QBSSLOAD, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, EDCAParamSet),
	offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet",
	0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, QOSCapsAp), offsetof(tDot11fIEQOSCapsAp,
	present), 0, "QOSCapsAp", 0, 3, 3, SigIeQOSCapsAp, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSAP, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, APChannelReport),
	offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport",
	0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_APCHANNELREPORT, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WPA), offsetof(tDot11fIEWPA, present), 0,
	"WPA", 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, HTCaps), offsetof(tDot11fIEHTCaps, present),
	0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, HTInfo), offsetof(tDot11fIEHTInfo, present),
	0, "HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, sec_chan_offset_ele),
	offsetof(tDot11fIEsec_chan_offset_ele, present), 0, "sec_chan_offset_ele",
	0, 3, 3, SigIesec_chan_offset_ele, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SEC_CHAN_OFFSET_ELE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp,
	present), 0, "WMMInfoAp", 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOAP, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WMMCaps), offsetof(tDot11fIEWMMCaps,
	present), 0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WAPI), offsetof(tDot11fIEWAPI, present), 0,
	"WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ESEVersion), offsetof(tDot11fIEESEVersion,
	present), 0, "ESEVersion", 0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WscBeaconProbeRes),
	offsetof(tDot11fIEWscBeaconProbeRes, present), 0, "WscBeaconProbeRes",
	0, 6, 319, SigIeWscBeaconProbeRes, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCBEACONPROBERES, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, P2PBeaconProbeRes),
	offsetof(tDot11fIEP2PBeaconProbeRes, present), 0, "P2PBeaconProbeRes",
	0, 6, 1150, SigIeP2PBeaconProbeRes, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PBEACONPROBERES, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, VHTExtBssLoad),
	offsetof(tDot11fIEVHTExtBssLoad, present), 0, "VHTExtBssLoad",
	0, 7, 7, SigIeVHTExtBssLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTEXTBSSLOAD, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ExtCap), offsetof(tDot11fIEExtCap, present),
	0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, WiderBWChanSwitchAnn),
	offsetof(tDot11fIEWiderBWChanSwitchAnn, present), 0,
	"WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, fils_indication),
	offsetof(tDot11fIEfils_indication, present), 0, "fils_indication",
	0, 7, 259, SigIefils_indication, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_INDICATION, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, Vendor1IE), offsetof(tDot11fIEVendor1IE,
	present), 0, "Vendor1IE", 0, 5, 5, SigIeVendor1IE, {0, 16, 24, 0, 0},
	3, DOT11F_EID_VENDOR1IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, Vendor3IE), offsetof(tDot11fIEVendor3IE,
	present), 0, "Vendor3IE", 0, 5, 5, SigIeVendor3IE, {0, 22, 50, 0, 0},
	3, DOT11F_EID_VENDOR3IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ChannelSwitchWrapper),
	offsetof(tDot11fIEChannelSwitchWrapper, present), 0,
	"ChannelSwitchWrapper", 0, 2, 14, SigIeChannelSwitchWrapper,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANNELSWITCHWRAPPER, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, QComVendorIE),
	offsetof(tDot11fIEQComVendorIE, present), 0, "QComVendorIE",
	0, 7, 7, SigIeQComVendorIE, {0, 160, 198, 0, 0},
	3, DOT11F_EID_QCOMVENDORIE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, MBO_IE), offsetof(tDot11fIEMBO_IE, present),
	0, "MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, QCN_IE), offsetof(tDot11fIEQCN_IE, present),
	0, "QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{ offsetof(tDot11fBeaconIEs, ESP_information),
	offsetof(tDot11fIEESP_information, present), 0, "ESP_information",
	0, 2, 98, SigIeESP_information, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ESP_INFORMATION, 11, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_beacon_i_es(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fBeaconIEs *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_BeaconIEs, IES_BeaconIEs,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_beacon_i_es. */

static const tFFDefn FFS_ChannelSwitch[] = {
	{ "Category", offsetof(tDot11fChannelSwitch, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fChannelSwitch, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ChannelSwitch[] = {
	{ offsetof(tDot11fChannelSwitch, ChanSwitchAnn),
	offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn",
	0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHANSWITCHANN, 0, 1, },
	{ offsetof(tDot11fChannelSwitch, sec_chan_offset_ele),
	offsetof(tDot11fIEsec_chan_offset_ele, present), 0, "sec_chan_offset_ele",
	0, 3, 3, SigIesec_chan_offset_ele, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SEC_CHAN_OFFSET_ELE, 0, 0, },
	{ offsetof(tDot11fChannelSwitch, WiderBWChanSwitchAnn),
	offsetof(tDot11fIEWiderBWChanSwitchAnn, present), 0,
	"WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_channel_switch(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fChannelSwitch *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ChannelSwitch, IES_ChannelSwitch,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_channel_switch. */

static const tFFDefn FFS_DeAuth[] = {
	{ "Reason", offsetof(tDot11fDeAuth, Reason), SigFfReason,
	DOT11F_FF_REASON_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_DeAuth[] = {
	{ offsetof(tDot11fDeAuth, P2PDeAuth), offsetof(tDot11fIEP2PDeAuth,
	present), 0, "P2PDeAuth", 0, 6, 10, SigIeP2PDeAuth, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PDEAUTH, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_de_auth(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fDeAuth *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_DeAuth, IES_DeAuth,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_de_auth. */

static const tFFDefn FFS_DelTS[] = {
	{ "Category", offsetof(tDot11fDelTS, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fDelTS, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "TSInfo", offsetof(tDot11fDelTS, TSInfo), SigFfTSInfo,
	DOT11F_FF_TSINFO_LEN, },
	{ "Reason", offsetof(tDot11fDelTS, Reason), SigFfReason,
	DOT11F_FF_REASON_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_DelTS[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_del_ts(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fDelTS *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_DelTS, IES_DelTS,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_del_ts. */

static const tFFDefn FFS_Disassociation[] = {
	{ "Reason", offsetof(tDot11fDisassociation, Reason), SigFfReason,
	DOT11F_FF_REASON_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_Disassociation[] = {
	{ offsetof(tDot11fDisassociation, P2PDisAssoc),
	offsetof(tDot11fIEP2PDisAssoc, present), 0, "P2PDisAssoc",
	0, 6, 10, SigIeP2PDisAssoc, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PDISASSOC, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_disassociation(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fDisassociation *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_Disassociation, IES_Disassociation,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_disassociation. */

static const tFFDefn FFS_LinkMeasurementReport[] = {
	{ "Category", offsetof(tDot11fLinkMeasurementReport, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fLinkMeasurementReport, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fLinkMeasurementReport, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "TPCEleID", offsetof(tDot11fLinkMeasurementReport, TPCEleID),
	SigFfTPCEleID, DOT11F_FF_TPCELEID_LEN, },
	{ "TPCEleLen", offsetof(tDot11fLinkMeasurementReport, TPCEleLen),
	SigFfTPCEleLen, DOT11F_FF_TPCELELEN_LEN, },
	{ "TxPower", offsetof(tDot11fLinkMeasurementReport, TxPower),
	SigFfTxPower, DOT11F_FF_TXPOWER_LEN, },
	{ "LinkMargin", offsetof(tDot11fLinkMeasurementReport, LinkMargin),
	SigFfLinkMargin, DOT11F_FF_LINKMARGIN_LEN, },
	{ "RxAntennaId", offsetof(tDot11fLinkMeasurementReport, RxAntennaId),
	SigFfRxAntennaId, DOT11F_FF_RXANTENNAID_LEN, },
	{ "TxAntennaId", offsetof(tDot11fLinkMeasurementReport, TxAntennaId),
	SigFfTxAntennaId, DOT11F_FF_TXANTENNAID_LEN, },
	{ "RCPI", offsetof(tDot11fLinkMeasurementReport, RCPI), SigFfRCPI,
	DOT11F_FF_RCPI_LEN, },
	{ "RSNI", offsetof(tDot11fLinkMeasurementReport, RSNI), SigFfRSNI,
	DOT11F_FF_RSNI_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_LinkMeasurementReport[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_link_measurement_report(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fLinkMeasurementReport *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_LinkMeasurementReport, IES_LinkMeasurementReport,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_link_measurement_report. */

static const tFFDefn FFS_LinkMeasurementRequest[] = {
	{ "Category", offsetof(tDot11fLinkMeasurementRequest, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fLinkMeasurementRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fLinkMeasurementRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "TxPower", offsetof(tDot11fLinkMeasurementRequest, TxPower),
	SigFfTxPower, DOT11F_FF_TXPOWER_LEN, },
	{ "MaxTxPower", offsetof(tDot11fLinkMeasurementRequest, MaxTxPower),
	SigFfMaxTxPower, DOT11F_FF_MAXTXPOWER_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_LinkMeasurementRequest[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_link_measurement_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fLinkMeasurementRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_LinkMeasurementRequest, IES_LinkMeasurementRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_link_measurement_request. */

static const tFFDefn FFS_MeasurementReport[] = {
	{ "Category", offsetof(tDot11fMeasurementReport, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fMeasurementReport, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fMeasurementReport, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_MeasurementReport[] = {
	{ offsetof(tDot11fMeasurementReport, MeasurementReport),
	offsetof(tDot11fIEMeasurementReport, present), 0, "MeasurementReport",
	0, 5, 31, SigIeMeasurementReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTREPORT, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_measurement_report(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fMeasurementReport *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_MeasurementReport, IES_MeasurementReport,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_measurement_report. */

static const tFFDefn FFS_MeasurementRequest[] = {
	{ "Category", offsetof(tDot11fMeasurementRequest, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fMeasurementRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fMeasurementRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_MeasurementRequest[] = {
	{ offsetof(tDot11fMeasurementRequest, MeasurementRequest),
	offsetof(tDot11fIEMeasurementRequest, present),
	offsetof(tDot11fMeasurementRequest, num_MeasurementRequest),
	"MeasurementRequest", 4, 6, 18, SigIeMeasurementRequest, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTREQUEST, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_measurement_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fMeasurementRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_MeasurementRequest, IES_MeasurementRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_measurement_request. */

static const tFFDefn FFS_NeighborReportRequest[] = {
	{ "Category", offsetof(tDot11fNeighborReportRequest, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fNeighborReportRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fNeighborReportRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_NeighborReportRequest[] = {
	{ offsetof(tDot11fNeighborReportRequest, SSID), offsetof(tDot11fIESSID,
	present), 0, "SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SSID, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_neighbor_report_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fNeighborReportRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_NeighborReportRequest, IES_NeighborReportRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_neighbor_report_request. */

static const tFFDefn FFS_NeighborReportResponse[] = {
	{ "Category", offsetof(tDot11fNeighborReportResponse, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fNeighborReportResponse, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fNeighborReportResponse, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_NeighborReportResponse[] = {
	{ offsetof(tDot11fNeighborReportResponse, NeighborReport),
	offsetof(tDot11fIENeighborReport, present),
	offsetof(tDot11fNeighborReportResponse, num_NeighborReport),
	"NeighborReport", 15, 15, 548, SigIeNeighborReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_NEIGHBORREPORT, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_neighbor_report_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fNeighborReportResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_NeighborReportResponse, IES_NeighborReportResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_neighbor_report_response. */

static const tFFDefn FFS_OperatingMode[] = {
	{ "Category", offsetof(tDot11fOperatingMode, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fOperatingMode, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "OperatingMode", offsetof(tDot11fOperatingMode, OperatingMode),
	SigFfOperatingMode, DOT11F_FF_OPERATINGMODE_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_OperatingMode[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_operating_mode(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fOperatingMode *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_OperatingMode, IES_OperatingMode,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_operating_mode. */

static const tFFDefn FFS_ProbeRequest[] = {
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ProbeRequest[] = {
	{ offsetof(tDot11fProbeRequest, SSID), offsetof(tDot11fIESSID, present), 0,
	"SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fProbeRequest, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fProbeRequest, RequestedInfo),
	offsetof(tDot11fIERequestedInfo, present), 0, "RequestedInfo",
	0, 2, 257, SigIeRequestedInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_REQUESTEDINFO, 0, 0, },
	{ offsetof(tDot11fProbeRequest, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fProbeRequest, DSParams), offsetof(tDot11fIEDSParams,
	present), 0, "DSParams", 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_DSPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeRequest, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fProbeRequest, WscProbeReq),
	offsetof(tDot11fIEWscProbeReq, present), 0, "WscProbeReq",
	0, 6, 286, SigIeWscProbeReq, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCPROBEREQ, 0, 0, },
	{ offsetof(tDot11fProbeRequest, WFATPC), offsetof(tDot11fIEWFATPC,
	present), 0, "WFATPC", 0, 9, 9, SigIeWFATPC, {0, 80, 242, 8, 0},
	5, DOT11F_EID_WFATPC, 0, 0, },
	{ offsetof(tDot11fProbeRequest, P2PProbeReq),
	offsetof(tDot11fIEP2PProbeReq, present), 0, "P2PProbeReq",
	0, 6, 43, SigIeP2PProbeReq, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PPROBEREQ, 0, 0, },
	{ offsetof(tDot11fProbeRequest, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fProbeRequest, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fProbeRequest, QCN_IE), offsetof(tDot11fIEQCN_IE,
	present), 0, "QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_probe_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fProbeRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ProbeRequest, IES_ProbeRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_probe_request. */

static const tFFDefn FFS_ProbeResponse[] = {
	{ "TimeStamp", offsetof(tDot11fProbeResponse, TimeStamp), SigFfTimeStamp,
	DOT11F_FF_TIMESTAMP_LEN, },
	{ "BeaconInterval", offsetof(tDot11fProbeResponse, BeaconInterval),
	SigFfBeaconInterval, DOT11F_FF_BEACONINTERVAL_LEN, },
	{ "Capabilities", offsetof(tDot11fProbeResponse, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ProbeResponse[] = {
	{ offsetof(tDot11fProbeResponse, SSID), offsetof(tDot11fIESSID, present),
	0, "SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fProbeResponse, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fProbeResponse, FHParamSet),
	offsetof(tDot11fIEFHParamSet, present), 0, "FHParamSet",
	0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMSET, 0, 0, },
	{ offsetof(tDot11fProbeResponse, DSParams), offsetof(tDot11fIEDSParams,
	present), 0, "DSParams", 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_DSPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, CFParams), offsetof(tDot11fIECFParams,
	present), 0, "CFParams", 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CFPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, IBSSParams),
	offsetof(tDot11fIEIBSSParams, present), 0, "IBSSParams",
	0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_IBSSPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, Country), offsetof(tDot11fIECountry,
	present), 0, "Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fProbeResponse, FHParams), offsetof(tDot11fIEFHParams,
	present), 0, "FHParams", 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, FHPattTable),
	offsetof(tDot11fIEFHPattTable, present), 0, "FHPattTable",
	0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FHPATTTABLE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, PowerConstraints),
	offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints",
	0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCONSTRAINTS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ChanSwitchAnn),
	offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn",
	0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0},
	0, DOT11F_EID_CHANSWITCHANN, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ext_chan_switch_ann),
	offsetof(tDot11fIEext_chan_switch_ann, present), 0, "ext_chan_switch_ann",
	0, 6, 6, SigIeext_chan_switch_ann, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXT_CHAN_SWITCH_ANN, 0, 0, },
	{ offsetof(tDot11fProbeResponse, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fProbeResponse, Quiet), offsetof(tDot11fIEQuiet,
	present), 0, "Quiet", 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QUIET, 0, 0, },
	{ offsetof(tDot11fProbeResponse, TPCReport), offsetof(tDot11fIETPCReport,
	present), 0, "TPCReport", 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREPORT, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ERPInfo), offsetof(tDot11fIEERPInfo,
	present), 0, "ERPInfo", 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ERPINFO, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fProbeResponse, RSNOpaque), offsetof(tDot11fIERSNOpaque,
	present), 0, "RSNOpaque", 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, QBSSLoad), offsetof(tDot11fIEQBSSLoad,
	present), 0, "QBSSLoad", 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QBSSLOAD, 0, 0, },
	{ offsetof(tDot11fProbeResponse, EDCAParamSet),
	offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet",
	0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fProbeResponse, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fProbeResponse, APChannelReport),
	offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport",
	0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_APCHANNELREPORT, 0, 0, },
	{ offsetof(tDot11fProbeResponse, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WPA), offsetof(tDot11fIEWPA, present), 0,
	"WPA", 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fProbeResponse, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, HTInfo), offsetof(tDot11fIEHTInfo,
	present), 0, "HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fProbeResponse, sec_chan_offset_ele),
	offsetof(tDot11fIEsec_chan_offset_ele, present), 0, "sec_chan_offset_ele",
	0, 3, 3, SigIesec_chan_offset_ele, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SEC_CHAN_OFFSET_ELE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp,
	present), 0, "WMMInfoAp", 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOAP, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WMMCaps), offsetof(tDot11fIEWMMCaps,
	present), 0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WAPI), offsetof(tDot11fIEWAPI, present),
	0, "WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fProbeResponse, WscProbeRes),
	offsetof(tDot11fIEWscProbeRes, present), 0, "WscProbeRes",
	0, 6, 319, SigIeWscProbeRes, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCPROBERES, 0, 0, },
	{ offsetof(tDot11fProbeResponse, P2PProbeRes),
	offsetof(tDot11fIEP2PProbeRes, present), 0, "P2PProbeRes",
	0, 6, 1141, SigIeP2PProbeRes, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PPROBERES, 0, 0, },
	{ offsetof(tDot11fProbeResponse, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fProbeResponse, VHTExtBssLoad),
	offsetof(tDot11fIEVHTExtBssLoad, present), 0, "VHTExtBssLoad",
	0, 7, 7, SigIeVHTExtBssLoad, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTEXTBSSLOAD, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fProbeResponse, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fProbeResponse, fils_indication),
	offsetof(tDot11fIEfils_indication, present), 0, "fils_indication",
	0, 7, 259, SigIefils_indication, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FILS_INDICATION, 0, 0, },
	{ offsetof(tDot11fProbeResponse, Vendor1IE), offsetof(tDot11fIEVendor1IE,
	present), 0, "Vendor1IE", 0, 5, 5, SigIeVendor1IE, {0, 16, 24, 0, 0},
	3, DOT11F_EID_VENDOR1IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, Vendor3IE), offsetof(tDot11fIEVendor3IE,
	present), 0, "Vendor3IE", 0, 5, 5, SigIeVendor3IE, {0, 22, 50, 0, 0},
	3, DOT11F_EID_VENDOR3IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ChannelSwitchWrapper),
	offsetof(tDot11fIEChannelSwitchWrapper, present), 0,
	"ChannelSwitchWrapper", 0, 2, 14, SigIeChannelSwitchWrapper,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANNELSWITCHWRAPPER, 0, 0, },
	{ offsetof(tDot11fProbeResponse, QComVendorIE),
	offsetof(tDot11fIEQComVendorIE, present), 0, "QComVendorIE",
	0, 7, 7, SigIeQComVendorIE, {0, 160, 198, 0, 0},
	3, DOT11F_EID_QCOMVENDORIE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ESEVersion),
	offsetof(tDot11fIEESEVersion, present), 0, "ESEVersion",
	0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fProbeResponse, MBO_IE), offsetof(tDot11fIEMBO_IE,
	present), 0, "MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, QCN_IE), offsetof(tDot11fIEQCN_IE,
	present), 0, "QCN_IE", 0, 10, 10, SigIeQCN_IE, {140, 253, 240, 1, 0},
	4, DOT11F_EID_QCN_IE, 0, 0, },
	{ offsetof(tDot11fProbeResponse, ESP_information),
	offsetof(tDot11fIEESP_information, present), 0, "ESP_information",
	0, 2, 98, SigIeESP_information, {0, 0, 0, 0, 0},
	0, DOT11F_EID_ESP_INFORMATION, 11, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_probe_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fProbeResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ProbeResponse, IES_ProbeResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_probe_response. */

static const tFFDefn FFS_QosMapConfigure[] = {
	{ "Category", offsetof(tDot11fQosMapConfigure, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fQosMapConfigure, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_QosMapConfigure[] = {
	{ offsetof(tDot11fQosMapConfigure, QosMapSet),
	offsetof(tDot11fIEQosMapSet, present), 0, "QosMapSet",
	0, 2, 62, SigIeQosMapSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSMAPSET, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_qos_map_configure(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fQosMapConfigure *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_QosMapConfigure, IES_QosMapConfigure,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_qos_map_configure. */

static const tFFDefn FFS_RadioMeasurementReport[] = {
	{ "Category", offsetof(tDot11fRadioMeasurementReport, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fRadioMeasurementReport, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fRadioMeasurementReport, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_RadioMeasurementReport[] = {
	{ offsetof(tDot11fRadioMeasurementReport, MeasurementReport),
	offsetof(tDot11fIEMeasurementReport, present),
	offsetof(tDot11fRadioMeasurementReport, num_MeasurementReport),
	"MeasurementReport", 4, 5, 31, SigIeMeasurementReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTREPORT, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_radio_measurement_report(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fRadioMeasurementReport *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_RadioMeasurementReport, IES_RadioMeasurementReport,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_radio_measurement_report. */

static const tFFDefn FFS_RadioMeasurementRequest[] = {
	{ "Category", offsetof(tDot11fRadioMeasurementRequest, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fRadioMeasurementRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fRadioMeasurementRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "NumOfRepetitions", offsetof(tDot11fRadioMeasurementRequest,
	NumOfRepetitions), SigFfNumOfRepetitions,
	DOT11F_FF_NUMOFREPETITIONS_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_RadioMeasurementRequest[] = {
	{ offsetof(tDot11fRadioMeasurementRequest, MeasurementRequest),
	offsetof(tDot11fIEMeasurementRequest, present),
	offsetof(tDot11fRadioMeasurementRequest, num_MeasurementRequest),
	"MeasurementRequest", 2, 6, 18, SigIeMeasurementRequest, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MEASUREMENTREQUEST, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_radio_measurement_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fRadioMeasurementRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_RadioMeasurementRequest, IES_RadioMeasurementRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_radio_measurement_request. */

static const tFFDefn FFS_ReAssocRequest[] = {
	{ "Capabilities", offsetof(tDot11fReAssocRequest, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ "ListenInterval", offsetof(tDot11fReAssocRequest, ListenInterval),
	SigFfListenInterval, DOT11F_FF_LISTENINTERVAL_LEN, },
	{ "CurrentAPAddress", offsetof(tDot11fReAssocRequest, CurrentAPAddress),
	SigFfCurrentAPAddress, DOT11F_FF_CURRENTAPADDRESS_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ReAssocRequest[] = {
	{ offsetof(tDot11fReAssocRequest, SSID), offsetof(tDot11fIESSID, present),
	0, "SSID", 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SSID, 0, 1, },
	{ offsetof(tDot11fReAssocRequest, SuppRates),
	offsetof(tDot11fIESuppRates, present), 0, "SuppRates",
	0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fReAssocRequest, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, PowerCaps),
	offsetof(tDot11fIEPowerCaps, present), 0, "PowerCaps",
	0, 4, 4, SigIePowerCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, SuppChannels),
	offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels",
	0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPCHANNELS, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, RSNOpaque),
	offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque",
	0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, QOSCapsStation),
	offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation",
	0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSSTATION, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, RICDataDesc),
	offsetof(tDot11fIERICDataDesc, present),
	offsetof(tDot11fReAssocRequest, num_RICDataDesc), "RICDataDesc",
	2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATADESC, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WPAOpaque),
	offsetof(tDot11fIEWPAOpaque, present), 0, "WPAOpaque",
	0, 8, 255, SigIeWPAOpaque, {0, 80, 242, 1, 0},
	4, DOT11F_EID_WPAOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WMMCaps), offsetof(tDot11fIEWMMCaps,
	present), 0, "WMMCaps", 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5},
	5, DOT11F_EID_WMMCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WMMInfoStation),
	offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation",
	0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOSTATION, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WscIEOpaque),
	offsetof(tDot11fIEWscIEOpaque, present), 0, "WscIEOpaque",
	0, 8, 255, SigIeWscIEOpaque, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WAPIOpaque),
	offsetof(tDot11fIEWAPIOpaque, present), 0, "WAPIOpaque",
	0, 8, 255, SigIeWAPIOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPIOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WAPI), offsetof(tDot11fIEWAPI, present),
	0, "WAPI", 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0},
	0, DOT11F_EID_WAPI, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, ESEVersion),
	offsetof(tDot11fIEESEVersion, present), 0, "ESEVersion",
	0, 7, 7, SigIeESEVersion, {0, 64, 150, 3, 0},
	4, DOT11F_EID_ESEVERSION, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, ESECckmOpaque),
	offsetof(tDot11fIEESECckmOpaque, present), 0, "ESECckmOpaque",
	0, 12, 26, SigIeESECckmOpaque, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESECCKMOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), offsetof(tDot11fReAssocRequest, num_WMMTSPEC), "WMMTSPEC",
	4, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, ESETrafStrmRateSet),
	offsetof(tDot11fIEESETrafStrmRateSet, present), 0, "ESETrafStrmRateSet",
	0, 7, 15, SigIeESETrafStrmRateSet, {0, 64, 150, 8, 0},
	4, DOT11F_EID_ESETRAFSTRMRATESET, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, P2PIEOpaque),
	offsetof(tDot11fIEP2PIEOpaque, present), 0, "P2PIEOpaque",
	0, 8, 255, SigIeP2PIEOpaque, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, WFDIEOpaque),
	offsetof(tDot11fIEWFDIEOpaque, present), 0, "WFDIEOpaque",
	0, 8, 255, SigIeWFDIEOpaque, {80, 111, 154, 10, 0},
	4, DOT11F_EID_WFDIEOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, QosMapSet),
	offsetof(tDot11fIEQosMapSet, present), 0, "QosMapSet",
	0, 2, 62, SigIeQosMapSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSMAPSET, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fReAssocRequest, hs20vendor_ie),
	offsetof(tDot11fIEhs20vendor_ie, present), 0, "hs20vendor_ie",
	0, 7, 9, SigIehs20vendor_ie, {80, 111, 154, 16, 0},
	4, DOT11F_EID_HS20VENDOR_IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_re_assoc_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fReAssocRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ReAssocRequest, IES_ReAssocRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_re_assoc_request. */

static const tFFDefn FFS_ReAssocResponse[] = {
	{ "Capabilities", offsetof(tDot11fReAssocResponse, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ "Status", offsetof(tDot11fReAssocResponse, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ "AID", offsetof(tDot11fReAssocResponse, AID), SigFfAID,
	DOT11F_FF_AID_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ReAssocResponse[] = {
	{ offsetof(tDot11fReAssocResponse, SuppRates),
	offsetof(tDot11fIESuppRates, present), 0, "SuppRates",
	0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fReAssocResponse, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, EDCAParamSet),
	offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet",
	0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, RCPIIE), offsetof(tDot11fIERCPIIE,
	present), 0, "RCPIIE", 0, 3, 3, SigIeRCPIIE, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RCPIIE, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, RSNIIE), offsetof(tDot11fIERSNIIE,
	present), 0, "RSNIIE", 0, 3, 3, SigIeRSNIIE, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNIIE, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, RRMEnabledCap),
	offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap",
	0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RRMENABLEDCAP, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, RSNOpaque),
	offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque",
	0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RSNOPAQUE, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, MobilityDomain),
	offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain",
	0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0},
	0, DOT11F_EID_MOBILITYDOMAIN, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, RICDataDesc),
	offsetof(tDot11fIERICDataDesc, present),
	offsetof(tDot11fReAssocResponse, num_RICDataDesc), "RICDataDesc",
	2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATADESC, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, WPA), offsetof(tDot11fIEWPA, present),
	0, "WPA", 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0},
	4, DOT11F_EID_WPA, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, HTInfo), offsetof(tDot11fIEHTInfo,
	present), 0, "HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, WMMParams),
	offsetof(tDot11fIEWMMParams, present), 0, "WMMParams",
	0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, ESERadMgmtCap),
	offsetof(tDot11fIEESERadMgmtCap, present), 0, "ESERadMgmtCap",
	0, 8, 8, SigIeESERadMgmtCap, {0, 64, 150, 1, 0},
	4, DOT11F_EID_ESERADMGMTCAP, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, ESETxmitPower),
	offsetof(tDot11fIEESETxmitPower, present), 0, "ESETxmitPower",
	0, 8, 8, SigIeESETxmitPower, {0, 64, 150, 0, 0},
	4, DOT11F_EID_ESETXMITPOWER, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), offsetof(tDot11fReAssocResponse, num_WMMTSPEC), "WMMTSPEC",
	4, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, ESETrafStrmRateSet),
	offsetof(tDot11fIEESETrafStrmRateSet, present), 0, "ESETrafStrmRateSet",
	0, 7, 15, SigIeESETrafStrmRateSet, {0, 64, 150, 8, 0},
	4, DOT11F_EID_ESETRAFSTRMRATESET, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, WscReassocRes),
	offsetof(tDot11fIEWscReassocRes, present), 0, "WscReassocRes",
	0, 6, 37, SigIeWscReassocRes, {0, 80, 242, 4, 0},
	4, DOT11F_EID_WSCREASSOCRES, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, P2PAssocRes),
	offsetof(tDot11fIEP2PAssocRes, present), 0, "P2PAssocRes",
	0, 6, 17, SigIeP2PAssocRes, {80, 111, 154, 9, 0},
	4, DOT11F_EID_P2PASSOCRES, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, OBSSScanParameters),
	offsetof(tDot11fIEOBSSScanParameters, present), 0, "OBSSScanParameters",
	0, 16, 16, SigIeOBSSScanParameters, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OBSSSCANPARAMETERS, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, QosMapSet),
	offsetof(tDot11fIEQosMapSet, present), 0, "QosMapSet",
	0, 2, 62, SigIeQosMapSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSMAPSET, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, vendor_vht_ie),
	offsetof(tDot11fIEvendor_vht_ie, present), 0, "vendor_vht_ie",
	0, 7, 28, SigIevendor_vht_ie, {0, 144, 76, 4, 0},
	4, DOT11F_EID_VENDOR_VHT_IE, 0, 0, },
	{ offsetof(tDot11fReAssocResponse, MBO_IE), offsetof(tDot11fIEMBO_IE,
	present), 0, "MBO_IE", 0, 6, 295, SigIeMBO_IE, {80, 111, 154, 22, 0},
	4, DOT11F_EID_MBO_IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_re_assoc_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fReAssocResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ReAssocResponse, IES_ReAssocResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_re_assoc_response. */

static const tFFDefn FFS_SMPowerSave[] = {
	{ "Category", offsetof(tDot11fSMPowerSave, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fSMPowerSave, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "SMPowerModeSet", offsetof(tDot11fSMPowerSave, SMPowerModeSet),
	SigFfSMPowerModeSet, DOT11F_FF_SMPOWERMODESET_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_SMPowerSave[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_sm_power_save(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fSMPowerSave *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_SMPowerSave, IES_SMPowerSave,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_sm_power_save. */

static const tFFDefn FFS_SaQueryReq[] = {
	{ "Category", offsetof(tDot11fSaQueryReq, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fSaQueryReq, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "TransactionId", offsetof(tDot11fSaQueryReq, TransactionId),
	SigFfTransactionId, DOT11F_FF_TRANSACTIONID_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_SaQueryReq[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_sa_query_req(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fSaQueryReq *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_SaQueryReq, IES_SaQueryReq,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_sa_query_req. */

static const tFFDefn FFS_SaQueryRsp[] = {
	{ "Category", offsetof(tDot11fSaQueryRsp, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fSaQueryRsp, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "TransactionId", offsetof(tDot11fSaQueryRsp, TransactionId),
	SigFfTransactionId, DOT11F_FF_TRANSACTIONID_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_SaQueryRsp[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_sa_query_rsp(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fSaQueryRsp *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_SaQueryRsp, IES_SaQueryRsp,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_sa_query_rsp. */

static const tFFDefn FFS_TDLSDisReq[] = {
	{ "Category", offsetof(tDot11fTDLSDisReq, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSDisReq, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSDisReq, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSDisReq[] = {
	{ offsetof(tDot11fTDLSDisReq, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_dis_req(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSDisReq *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSDisReq, IES_TDLSDisReq,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_dis_req. */

static const tFFDefn FFS_TDLSDisRsp[] = {
	{ "Category", offsetof(tDot11fTDLSDisRsp, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSDisRsp, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSDisRsp, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "Capabilities", offsetof(tDot11fTDLSDisRsp, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSDisRsp[] = {
	{ offsetof(tDot11fTDLSDisRsp, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fTDLSDisRsp, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, SuppChannels),
	offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels",
	0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPCHANNELS, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, RSN), offsetof(tDot11fIERSN, present), 0,
	"RSN", 0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, ExtCap), offsetof(tDot11fIEExtCap, present),
	0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, FTInfo), offsetof(tDot11fIEFTInfo, present),
	0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, RICData), offsetof(tDot11fIERICData,
	present), 0, "RICData", 0, 6, 6, SigIeRICData, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATA, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, HTCaps), offsetof(tDot11fIEHTCaps, present),
	0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, ht2040_bss_coexistence),
	offsetof(tDot11fIEht2040_bss_coexistence, present), 0,
	"ht2040_bss_coexistence", 0, 3, 3, SigIeht2040_bss_coexistence,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_HT2040_BSS_COEXISTENCE, 0, 0, },
	{ offsetof(tDot11fTDLSDisRsp, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{ offsetof(tDot11fTDLSDisRsp, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_dis_rsp(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSDisRsp *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSDisRsp, IES_TDLSDisRsp,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_dis_rsp. */

static const tFFDefn FFS_TDLSPeerTrafficInd[] = {
	{ "Category", offsetof(tDot11fTDLSPeerTrafficInd, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSPeerTrafficInd, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSPeerTrafficInd, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSPeerTrafficInd[] = {
	{ offsetof(tDot11fTDLSPeerTrafficInd, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{ offsetof(tDot11fTDLSPeerTrafficInd, PTIControl),
	offsetof(tDot11fIEPTIControl, present), 0, "PTIControl",
	0, 5, 5, SigIePTIControl, {0, 0, 0, 0, 0},
	0, DOT11F_EID_PTICONTROL, 0, 0, },
	{ offsetof(tDot11fTDLSPeerTrafficInd, PUBufferStatus),
	offsetof(tDot11fIEPUBufferStatus, present), 0, "PUBufferStatus",
	0, 3, 3, SigIePUBufferStatus, {0, 0, 0, 0, 0},
	0, DOT11F_EID_PUBUFFERSTATUS, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_peer_traffic_ind(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSPeerTrafficInd *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSPeerTrafficInd, IES_TDLSPeerTrafficInd,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_peer_traffic_ind. */

static const tFFDefn FFS_TDLSPeerTrafficRsp[] = {
	{ "Category", offsetof(tDot11fTDLSPeerTrafficRsp, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSPeerTrafficRsp, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSPeerTrafficRsp, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSPeerTrafficRsp[] = {
	{ offsetof(tDot11fTDLSPeerTrafficRsp, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_peer_traffic_rsp(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSPeerTrafficRsp *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSPeerTrafficRsp, IES_TDLSPeerTrafficRsp,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_peer_traffic_rsp. */

static const tFFDefn FFS_TDLSSetupCnf[] = {
	{ "Category", offsetof(tDot11fTDLSSetupCnf, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSSetupCnf, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "Status", offsetof(tDot11fTDLSSetupCnf, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSSetupCnf, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSSetupCnf[] = {
	{ offsetof(tDot11fTDLSSetupCnf, RSN), offsetof(tDot11fIERSN, present), 0,
	"RSN", 0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, EDCAParamSet),
	offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet",
	0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EDCAPARAMSET, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, HTInfo), offsetof(tDot11fIEHTInfo,
	present), 0, "HTInfo", 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, WMMParams), offsetof(tDot11fIEWMMParams,
	present), 0, "WMMParams", 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1},
	5, DOT11F_EID_WMMPARAMS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, VHTOperation),
	offsetof(tDot11fIEVHTOperation, present), 0, "VHTOperation",
	0, 7, 7, SigIeVHTOperation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTOPERATION, 0, 0, },
	{ offsetof(tDot11fTDLSSetupCnf, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_setup_cnf(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSSetupCnf *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSSetupCnf, IES_TDLSSetupCnf,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_setup_cnf. */

static const tFFDefn FFS_TDLSSetupReq[] = {
	{ "Category", offsetof(tDot11fTDLSSetupReq, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSSetupReq, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSSetupReq, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "Capabilities", offsetof(tDot11fTDLSSetupReq, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSSetupReq[] = {
	{ offsetof(tDot11fTDLSSetupReq, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 1, },
	{ offsetof(tDot11fTDLSSetupReq, Country), offsetof(tDot11fIECountry,
	present), 0, "Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, SuppChannels),
	offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels",
	0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPCHANNELS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, RSN), offsetof(tDot11fIERSN, present), 0,
	"RSN", 0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, QOSCapsStation),
	offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation",
	0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSSTATION, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, RICData), offsetof(tDot11fIERICData,
	present), 0, "RICData", 0, 6, 6, SigIeRICData, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATA, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, ht2040_bss_coexistence),
	offsetof(tDot11fIEht2040_bss_coexistence, present), 0,
	"ht2040_bss_coexistence", 0, 3, 3, SigIeht2040_bss_coexistence,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_HT2040_BSS_COEXISTENCE, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{ offsetof(tDot11fTDLSSetupReq, WMMInfoStation),
	offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation",
	0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOSTATION, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, AID), offsetof(tDot11fIEAID, present), 0,
	"AID", 0, 4, 4, SigIeAID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_AID, 0, 0, },
	{ offsetof(tDot11fTDLSSetupReq, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_setup_req(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSSetupReq *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSSetupReq, IES_TDLSSetupReq,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_setup_req. */

static const tFFDefn FFS_TDLSSetupRsp[] = {
	{ "Category", offsetof(tDot11fTDLSSetupRsp, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSSetupRsp, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "Status", offsetof(tDot11fTDLSSetupRsp, Status), SigFfStatus,
	DOT11F_FF_STATUS_LEN, },
	{ "DialogToken", offsetof(tDot11fTDLSSetupRsp, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "Capabilities", offsetof(tDot11fTDLSSetupRsp, Capabilities),
	SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSSetupRsp[] = {
	{ offsetof(tDot11fTDLSSetupRsp, SuppRates), offsetof(tDot11fIESuppRates,
	present), 0, "SuppRates", 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPRATES, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, Country), offsetof(tDot11fIECountry,
	present), 0, "Country", 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0},
	0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, ExtSuppRates),
	offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates",
	0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTSUPPRATES, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, SuppChannels),
	offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels",
	0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0},
	0, DOT11F_EID_SUPPCHANNELS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, RSN), offsetof(tDot11fIERSN, present), 0,
	"RSN", 0, 8, 132, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, ExtCap), offsetof(tDot11fIEExtCap,
	present), 0, "ExtCap", 0, 3, 17, SigIeExtCap, {0, 0, 0, 0, 0},
	0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, SuppOperatingClasses),
	offsetof(tDot11fIESuppOperatingClasses, present), 0,
	"SuppOperatingClasses", 0, 3, 34, SigIeSuppOperatingClasses,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPOPERATINGCLASSES, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, QOSCapsStation),
	offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation",
	0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0},
	0, DOT11F_EID_QOSCAPSSTATION, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, TimeoutInterval),
	offsetof(tDot11fIETimeoutInterval, present), 0, "TimeoutInterval",
	0, 7, 7, SigIeTimeoutInterval, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEOUTINTERVAL, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, RICData), offsetof(tDot11fIERICData,
	present), 0, "RICData", 0, 6, 6, SigIeRICData, {0, 0, 0, 0, 0},
	0, DOT11F_EID_RICDATA, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, HTCaps), offsetof(tDot11fIEHTCaps,
	present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, ht2040_bss_coexistence),
	offsetof(tDot11fIEht2040_bss_coexistence, present), 0,
	"ht2040_bss_coexistence", 0, 3, 3, SigIeht2040_bss_coexistence,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_HT2040_BSS_COEXISTENCE, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, WMMInfoStation),
	offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation",
	0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0},
	5, DOT11F_EID_WMMINFOSTATION, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, AID), offsetof(tDot11fIEAID, present), 0,
	"AID", 0, 4, 4, SigIeAID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_AID, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, VHTCaps), offsetof(tDot11fIEVHTCaps,
	present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps, {0, 0, 0, 0, 0},
	0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fTDLSSetupRsp, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_setup_rsp(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSSetupRsp *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSSetupRsp, IES_TDLSSetupRsp,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_setup_rsp. */

static const tFFDefn FFS_TDLSTeardown[] = {
	{ "Category", offsetof(tDot11fTDLSTeardown, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTDLSTeardown, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "Reason", offsetof(tDot11fTDLSTeardown, Reason), SigFfReason,
	DOT11F_FF_REASON_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TDLSTeardown[] = {
	{ offsetof(tDot11fTDLSTeardown, FTInfo), offsetof(tDot11fIEFTInfo,
	present), 0, "FTInfo", 0, 84, 222, SigIeFTInfo, {0, 0, 0, 0, 0},
	0, DOT11F_EID_FTINFO, 0, 0, },
	{ offsetof(tDot11fTDLSTeardown, LinkIdentifier),
	offsetof(tDot11fIELinkIdentifier, present), 0, "LinkIdentifier",
	0, 20, 20, SigIeLinkIdentifier, {0, 0, 0, 0, 0},
	0, DOT11F_EID_LINKIDENTIFIER, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tdls_teardown(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTDLSTeardown *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TDLSTeardown, IES_TDLSTeardown,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tdls_teardown. */

static const tFFDefn FFS_TPCReport[] = {
	{ "Category", offsetof(tDot11fTPCReport, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTPCReport, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTPCReport, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TPCReport[] = {
	{ offsetof(tDot11fTPCReport, TPCReport), offsetof(tDot11fIETPCReport,
	present), 0, "TPCReport", 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREPORT, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tpc_report(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTPCReport *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TPCReport, IES_TPCReport,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tpc_report. */

static const tFFDefn FFS_TPCRequest[] = {
	{ "Category", offsetof(tDot11fTPCRequest, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fTPCRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fTPCRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TPCRequest[] = {
	{ offsetof(tDot11fTPCRequest, TPCRequest), offsetof(tDot11fIETPCRequest,
	present), 0, "TPCRequest", 0, 2, 2, SigIeTPCRequest, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TPCREQUEST, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_tpc_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTPCRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TPCRequest, IES_TPCRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_tpc_request. */

static const tFFDefn FFS_TimingAdvertisementFrame[] = {
	{ "TimeStamp", offsetof(tDot11fTimingAdvertisementFrame, TimeStamp),
	SigFfTimeStamp, DOT11F_FF_TIMESTAMP_LEN, },
	{ "Capabilities", offsetof(tDot11fTimingAdvertisementFrame,
	Capabilities), SigFfCapabilities, DOT11F_FF_CAPABILITIES_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_TimingAdvertisementFrame[] = {
	{ offsetof(tDot11fTimingAdvertisementFrame, Country),
	offsetof(tDot11fIECountry, present), 0, "Country", 0, 5, 257, SigIeCountry,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_COUNTRY, 0, 0, },
	{ offsetof(tDot11fTimingAdvertisementFrame, PowerConstraints),
	offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints",
	0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0},
	0, DOT11F_EID_POWERCONSTRAINTS, 0, 0, },
	{ offsetof(tDot11fTimingAdvertisementFrame, TimeAdvertisement),
	offsetof(tDot11fIETimeAdvertisement, present), 0, "TimeAdvertisement",
	0, 18, 18, SigIeTimeAdvertisement, {0, 0, 0, 0, 0},
	0, DOT11F_EID_TIMEADVERTISEMENT, 0, 0, },
	{ offsetof(tDot11fTimingAdvertisementFrame, ExtCap),
	offsetof(tDot11fIEExtCap, present), 0, "ExtCap", 0, 3, 17, SigIeExtCap,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCAP, 0, 0, },
	{ offsetof(tDot11fTimingAdvertisementFrame, Vendor1IE),
	offsetof(tDot11fIEVendor1IE, present), 0, "Vendor1IE",
	0, 5, 5, SigIeVendor1IE, {0, 16, 24, 0, 0},
	3, DOT11F_EID_VENDOR1IE, 0, 0, },
	{ offsetof(tDot11fTimingAdvertisementFrame, Vendor3IE),
	offsetof(tDot11fIEVendor3IE, present), 0, "Vendor3IE",
	0, 5, 5, SigIeVendor3IE, {0, 22, 50, 0, 0},
	3, DOT11F_EID_VENDOR3IE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_timing_advertisement_frame(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fTimingAdvertisementFrame *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_TimingAdvertisementFrame, IES_TimingAdvertisementFrame,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_timing_advertisement_frame. */

static const tFFDefn FFS_VHTGidManagementActionFrame[] = {
	{ "Category", offsetof(tDot11fVHTGidManagementActionFrame, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fVHTGidManagementActionFrame, Action),
	SigFfAction, DOT11F_FF_ACTION_LEN, },
	{ "VhtMembershipStatusArray",
	offsetof(tDot11fVHTGidManagementActionFrame, VhtMembershipStatusArray),
	SigFfVhtMembershipStatusArray,
	DOT11F_FF_VHTMEMBERSHIPSTATUSARRAY_LEN, },
	{ "VhtUserPositionArray", offsetof(tDot11fVHTGidManagementActionFrame,
	VhtUserPositionArray), SigFfVhtUserPositionArray,
	DOT11F_FF_VHTUSERPOSITIONARRAY_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_VHTGidManagementActionFrame[] = {
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_vht_gid_management_action_frame(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fVHTGidManagementActionFrame *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_VHTGidManagementActionFrame, IES_VHTGidManagementActionFrame,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_vht_gid_management_action_frame. */

static const tFFDefn FFS_WMMAddTSRequest[] = {
	{ "Category", offsetof(tDot11fWMMAddTSRequest, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fWMMAddTSRequest, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fWMMAddTSRequest, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "StatusCode", offsetof(tDot11fWMMAddTSRequest, StatusCode),
	SigFfStatusCode, DOT11F_FF_STATUSCODE_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_WMMAddTSRequest[] = {
	{ offsetof(tDot11fWMMAddTSRequest, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), 0, "WMMTSPEC", 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 1, },
	{ offsetof(tDot11fWMMAddTSRequest, ESETrafStrmRateSet),
	offsetof(tDot11fIEESETrafStrmRateSet, present), 0, "ESETrafStrmRateSet",
	0, 7, 15, SigIeESETrafStrmRateSet, {0, 64, 150, 8, 0},
	4, DOT11F_EID_ESETRAFSTRMRATESET, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_wmm_add_ts_request(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fWMMAddTSRequest *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_WMMAddTSRequest, IES_WMMAddTSRequest,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_wmm_add_ts_request. */

static const tFFDefn FFS_WMMAddTSResponse[] = {
	{ "Category", offsetof(tDot11fWMMAddTSResponse, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fWMMAddTSResponse, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fWMMAddTSResponse, DialogToken),
	SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "StatusCode", offsetof(tDot11fWMMAddTSResponse, StatusCode),
	SigFfStatusCode, DOT11F_FF_STATUSCODE_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_WMMAddTSResponse[] = {
	{ offsetof(tDot11fWMMAddTSResponse, WMMTSPEC),
	offsetof(tDot11fIEWMMTSPEC, present), 0, "WMMTSPEC",
	0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 0, },
	{ offsetof(tDot11fWMMAddTSResponse, ESETrafStrmMet),
	offsetof(tDot11fIEESETrafStrmMet, present), 0, "ESETrafStrmMet",
	0, 10, 10, SigIeESETrafStrmMet, {0, 64, 150, 7, 0},
	4, DOT11F_EID_ESETRAFSTRMMET, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_wmm_add_ts_response(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fWMMAddTSResponse *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_WMMAddTSResponse, IES_WMMAddTSResponse,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_wmm_add_ts_response. */

static const tFFDefn FFS_WMMDelTS[] = {
	{ "Category", offsetof(tDot11fWMMDelTS, Category), SigFfCategory,
	DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fWMMDelTS, Action), SigFfAction,
	DOT11F_FF_ACTION_LEN, },
	{ "DialogToken", offsetof(tDot11fWMMDelTS, DialogToken), SigFfDialogToken,
	DOT11F_FF_DIALOGTOKEN_LEN, },
	{ "StatusCode", offsetof(tDot11fWMMDelTS, StatusCode), SigFfStatusCode,
	DOT11F_FF_STATUSCODE_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_WMMDelTS[] = {
	{ offsetof(tDot11fWMMDelTS, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC,
	present), 0, "WMMTSPEC", 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2},
	5, DOT11F_EID_WMMTSPEC, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_wmm_del_ts(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fWMMDelTS *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_WMMDelTS, IES_WMMDelTS,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_wmm_del_ts. */

static const tFFDefn FFS_ext_channel_switch_action_frame[] = {
	{ "Category", offsetof(tDot11fext_channel_switch_action_frame, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fext_channel_switch_action_frame, Action),
	SigFfAction, DOT11F_FF_ACTION_LEN, },
	{ "ext_chan_switch_ann_action",
	offsetof(tDot11fext_channel_switch_action_frame,
	ext_chan_switch_ann_action), SigFfext_chan_switch_ann_action,
	DOT11F_FF_EXT_CHAN_SWITCH_ANN_ACTION_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ext_channel_switch_action_frame[] = {
	{ offsetof(tDot11fext_channel_switch_action_frame,
	WiderBWChanSwitchAnn), offsetof(tDot11fIEWiderBWChanSwitchAnn, present),
	0, "WiderBWChanSwitchAnn", 0, 5, 5, SigIeWiderBWChanSwitchAnn,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_WIDERBWCHANSWITCHANN, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_ext_channel_switch_action_frame(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fext_channel_switch_action_frame *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ext_channel_switch_action_frame, IES_ext_channel_switch_action_frame,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_ext_channel_switch_action_frame. */

static const tFFDefn FFS_ht2040_bss_coexistence_mgmt_action_frame[] = {
	{ "Category", offsetof(tDot11fht2040_bss_coexistence_mgmt_action_frame,
	Category), SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "Action", offsetof(tDot11fht2040_bss_coexistence_mgmt_action_frame,
	Action), SigFfAction, DOT11F_FF_ACTION_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_ht2040_bss_coexistence_mgmt_action_frame[] = {
	{ offsetof(tDot11fht2040_bss_coexistence_mgmt_action_frame,
	ht2040_bss_coexistence), offsetof(tDot11fIEht2040_bss_coexistence,
	present), 0, "ht2040_bss_coexistence",
	0, 3, 3, SigIeht2040_bss_coexistence, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HT2040_BSS_COEXISTENCE, 0, 1, },
	{ offsetof(tDot11fht2040_bss_coexistence_mgmt_action_frame,
	ht2040_bss_intolerant_report),
	offsetof(tDot11fIEht2040_bss_intolerant_report, present), 0,
	"ht2040_bss_intolerant_report",
	0, 3, 53, SigIeht2040_bss_intolerant_report, {0, 0, 0, 0, 0},
	0, DOT11F_EID_HT2040_BSS_INTOLERANT_REPORT, 0, 1, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_ht2040_bss_coexistence_mgmt_action_frame(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fht2040_bss_coexistence_mgmt_action_frame *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_ht2040_bss_coexistence_mgmt_action_frame, IES_ht2040_bss_coexistence_mgmt_action_frame,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_ht2040_bss_coexistence_mgmt_action_frame. */

static const tFFDefn FFS_p2p_oper_chan_change_confirm[] = {
	{ "Category", offsetof(tDot11fp2p_oper_chan_change_confirm, Category),
	SigFfCategory, DOT11F_FF_CATEGORY_LEN, },
	{ "p2p_action_oui", offsetof(tDot11fp2p_oper_chan_change_confirm,
	p2p_action_oui), SigFfp2p_action_oui, DOT11F_FF_P2P_ACTION_OUI_LEN, },
	{ "p2p_action_subtype", offsetof(tDot11fp2p_oper_chan_change_confirm,
	p2p_action_subtype), SigFfp2p_action_subtype,
	DOT11F_FF_P2P_ACTION_SUBTYPE_LEN, },
	{ "DialogToken", offsetof(tDot11fp2p_oper_chan_change_confirm,
	DialogToken), SigFfDialogToken, DOT11F_FF_DIALOGTOKEN_LEN, },
	{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_p2p_oper_chan_change_confirm[] = {
	{ offsetof(tDot11fp2p_oper_chan_change_confirm, HTCaps),
	offsetof(tDot11fIEHTCaps, present), 0, "HTCaps", 0, 28, 60, SigIeHTCaps,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, 0, },
	{ offsetof(tDot11fp2p_oper_chan_change_confirm, VHTCaps),
	offsetof(tDot11fIEVHTCaps, present), 0, "VHTCaps", 0, 14, 14, SigIeVHTCaps,
	{0, 0, 0, 0, 0}, 0, DOT11F_EID_VHTCAPS, 0, 0, },
	{ offsetof(tDot11fp2p_oper_chan_change_confirm, OperatingMode),
	offsetof(tDot11fIEOperatingMode, present), 0, "OperatingMode",
	0, 3, 3, SigIeOperatingMode, {0, 0, 0, 0, 0},
	0, DOT11F_EID_OPERATINGMODE, 0, 0, },
	{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },};

uint32_t dot11f_unpack_p2p_oper_chan_change_confirm(tpAniSirGlobal pCtx,
		uint8_t *pBuf, uint32_t nBuf,
		tDot11fp2p_oper_chan_change_confirm *pFrm, bool append_ie)
{
	uint32_t i = 0;
	uint32_t status = 0;
	status = unpack_core(pCtx, pBuf, nBuf,
		      FFS_p2p_oper_chan_change_confirm, IES_p2p_oper_chan_change_confirm,
		      (uint8_t *)pFrm, sizeof(*pFrm), append_ie);

	(void)i;
	return status;

} /* End dot11f_unpack_p2p_oper_chan_change_confirm. */

/**
 * Note: If @append_ie is set TRUE, pFrm will not be reset to zero,
 * but parsed IE's would be populated to pFrm with already
 * populated IE's in pFrm
 */
static uint32_t unpack_core(tpAniSirGlobal pCtx,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    const tFFDefn  FFs[],
			    const tIEDefn  IEs[],
			    uint8_t *pFrm,
			    size_t nFrm,
			    bool append_ie)
{
	const tFFDefn *pFf;
	const tIEDefn *pIe;
	uint8_t   *pBufRemaining;
	uint32_t  nBufRemaining, status;
	uint8_t   eid, len, extn_eid;
	tFRAMES_BOOL  *pfFound;
	uint32_t  countOffset = 0;

	DOT11F_PARAMETER_CHECK(pBuf, nBuf, pFrm, nFrm);
	(void)nFrm;

	(void)pCtx;
	status = DOT11F_PARSE_SUCCESS;
	pBufRemaining = pBuf;
	nBufRemaining = nBuf;

	pIe = &IEs[0];
	while (!append_ie && (0xff != pIe->eid || pIe->extn_eid)) {
		pfFound = (tFRAMES_BOOL *)(pFrm + pIe->offset +
				   pIe->presenceOffset);
		*pfFound = 0U;
		if (pIe->countOffset)
			*(uint16_t *)(pFrm + pIe->countOffset) = 0U;
		++pIe;
	}

	pFf = &FFs[0];
	while (!append_ie && pFf->size) {
		if (pFf->size > nBufRemaining) {
			FRAMES_LOG3(pCtx, FRLOGE, FRFL("Fixed field %s is %d"
					  "bytes in size, but there are only %d bytes left i"
					  "n this frame.\n"), pFf->name, pFf->size,
					  nBufRemaining);
			FRAMES_DBG_BREAK();
			return DOT11F_MISSING_FIXED_FIELD;
		}

		switch (pFf->sig) {

		case SigFfAID:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfAID *)
			    (pFrm + pFf->offset))->associd));
			break;
		case SigFfAction:
			dot11f_unpack_ff_action(pCtx,
			    pBufRemaining, (tDot11fFfAction *)
			    (pFrm + pFf->offset));
			break;
		case SigFfAuthAlgo:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfAuthAlgo *)
			    (pFrm + pFf->offset))->algo));
			break;
		case SigFfAuthSeqNo:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfAuthSeqNo *)
			    (pFrm + pFf->offset))->no));
			break;
		case SigFfBeaconInterval:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfBeaconInterval *)
			    (pFrm + pFf->offset))->interval));
			break;
		case SigFfCapabilities:
			dot11f_unpack_ff_capabilities(pCtx,
			    pBufRemaining, (tDot11fFfCapabilities *)
			    (pFrm + pFf->offset));
			break;
		case SigFfCategory:
			dot11f_unpack_ff_category(pCtx,
			    pBufRemaining, (tDot11fFfCategory *)
			    (pFrm + pFf->offset));
			break;
		case SigFfCurrentAPAddress:
			dot11f_unpack_ff_current_ap_address(pCtx,
			    pBufRemaining, (tDot11fFfCurrentAPAddress *)
			    (pFrm + pFf->offset));
			break;
		case SigFfDialogToken:
			dot11f_unpack_ff_dialog_token(pCtx,
			    pBufRemaining, (tDot11fFfDialogToken *)
			    (pFrm + pFf->offset));
			break;
		case SigFfLinkMargin:
			dot11f_unpack_ff_link_margin(pCtx,
			    pBufRemaining, (tDot11fFfLinkMargin *)
			    (pFrm + pFf->offset));
			break;
		case SigFfListenInterval:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfListenInterval *)
			    (pFrm + pFf->offset))->interval));
			break;
		case SigFfMaxTxPower:
			dot11f_unpack_ff_max_tx_power(pCtx,
			    pBufRemaining, (tDot11fFfMaxTxPower *)
			    (pFrm + pFf->offset));
			break;
		case SigFfNumOfRepetitions:
			dot11f_unpack_ff_num_of_repetitions(pCtx,
			    pBufRemaining, (tDot11fFfNumOfRepetitions *)
			    (pFrm + pFf->offset));
			break;
		case SigFfOperatingMode:
			dot11f_unpack_ff_operating_mode(pCtx,
			    pBufRemaining, (tDot11fFfOperatingMode *)
			    (pFrm + pFf->offset));
			break;
		case SigFfRCPI:
			dot11f_unpack_ff_rcpi(pCtx,
			    pBufRemaining, (tDot11fFfRCPI *)
			    (pFrm + pFf->offset));
			break;
		case SigFfRSNI:
			dot11f_unpack_ff_rsni(pCtx,
			    pBufRemaining, (tDot11fFfRSNI *)
			    (pFrm + pFf->offset));
			break;
		case SigFfReason:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfReason *)
			    (pFrm + pFf->offset))->code));
			break;
		case SigFfRxAntennaId:
			dot11f_unpack_ff_rx_antenna_id(pCtx,
			    pBufRemaining, (tDot11fFfRxAntennaId *)
			    (pFrm + pFf->offset));
			break;
		case SigFfSMPowerModeSet:
			dot11f_unpack_ff_sm_power_mode_set(pCtx,
			    pBufRemaining, (tDot11fFfSMPowerModeSet *)
			    (pFrm + pFf->offset));
			break;
		case SigFfStatus:
			dot11f_unpack_ff_common_func(pCtx,
			    pBufRemaining, (uint16_t *)&(((tDot11fFfStatus *)
			    (pFrm + pFf->offset))->status));
			break;
		case SigFfStatusCode:
			dot11f_unpack_ff_status_code(pCtx,
			    pBufRemaining, (tDot11fFfStatusCode *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTPCEleID:
			dot11f_unpack_ff_tpc_ele_id(pCtx,
			    pBufRemaining, (tDot11fFfTPCEleID *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTPCEleLen:
			dot11f_unpack_ff_tpc_ele_len(pCtx,
			    pBufRemaining, (tDot11fFfTPCEleLen *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTSInfo:
			dot11f_unpack_ff_ts_info(pCtx,
			    pBufRemaining, (tDot11fFfTSInfo *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTimeStamp:
			dot11f_unpack_ff_time_stamp(pCtx,
			    pBufRemaining, (tDot11fFfTimeStamp *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTransactionId:
			dot11f_unpack_ff_transaction_id(pCtx,
			    pBufRemaining, (tDot11fFfTransactionId *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTxAntennaId:
			dot11f_unpack_ff_tx_antenna_id(pCtx,
			    pBufRemaining, (tDot11fFfTxAntennaId *)
			    (pFrm + pFf->offset));
			break;
		case SigFfTxPower:
			dot11f_unpack_ff_tx_power(pCtx,
			    pBufRemaining, (tDot11fFfTxPower *)
			    (pFrm + pFf->offset));
			break;
		case SigFfVhtMembershipStatusArray:
			dot11f_unpack_ff_vht_membership_status_array(pCtx,
			    pBufRemaining, (tDot11fFfVhtMembershipStatusArray *)
			    (pFrm + pFf->offset));
			break;
		case SigFfVhtUserPositionArray:
			dot11f_unpack_ff_vht_user_position_array(pCtx,
			    pBufRemaining, (tDot11fFfVhtUserPositionArray *)
			    (pFrm + pFf->offset));
			break;
		case SigFfext_chan_switch_ann_action:
			dot11f_unpack_ff_ext_chan_switch_ann_action(pCtx,
			    pBufRemaining, (tDot11fFfext_chan_switch_ann_action *)
			    (pFrm + pFf->offset));
			break;
		case SigFfp2p_action_oui:
			dot11f_unpack_ff_p2p_action_oui(pCtx,
			    pBufRemaining, (tDot11fFfp2p_action_oui *)
			    (pFrm + pFf->offset));
			break;
		case SigFfp2p_action_subtype:
			dot11f_unpack_ff_p2p_action_subtype(pCtx,
			    pBufRemaining, (tDot11fFfp2p_action_subtype *)
			    (pFrm + pFf->offset));
			break;
		default:
			FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR: I don'"
				   "t know about the FF signature %d-- this is most "
				   "likely a 'framesc' bug.\n"), pFf->sig);
			return DOT11F_INTERNAL_ERROR;
		}

		pBufRemaining += pFf->size;
		nBufRemaining -= pFf->size;
		++pFf;
	}

	while (nBufRemaining) {
		if (1 == nBufRemaining) {
			FRAMES_LOG0(pCtx, FRLOGE, FRFL("This frame reports "
				    "only one byte remaining after it's fixed fields.\n"));
			status |= DOT11F_INCOMPLETE_IE;
			FRAMES_DBG_BREAK();
			goto MandatoryCheck;
		}

		pIe = find_ie_defn(pCtx, pBufRemaining, nBufRemaining, IEs);

		eid = *pBufRemaining++; --nBufRemaining;
		len = *pBufRemaining++; --nBufRemaining;
		if (pIe && pIe->extn_eid) {
			extn_eid = *pBufRemaining++; --nBufRemaining;
			len--;
		}

		if (pIe && pIe->noui) {
			if (pIe->noui > nBufRemaining) {
				FRAMES_LOG4(pCtx, FRLOGW, FRFL("IE %d extn id %d reports "
					"length %d, but it has an OUI of %d bytes.\n"),
					eid, extn_eid, len, pIe->noui);
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				FRAMES_LOG2(pCtx, FRLOG1, FRFL("We've parsed %d by"
					"tes of this buffer, and show %d left.\n"),
					pBufRemaining - pBuf, nBufRemaining);
				status |= DOT11F_INCOMPLETE_IE;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			}
			pBufRemaining += pIe->noui;
			nBufRemaining -= pIe->noui;
			len           -= pIe->noui;
		}

		if (len > nBufRemaining) {
			FRAMES_LOG4(pCtx, FRLOGW, FRFL("IE %d extn id %d reports length %"
				"d, but there are only %d bytes remaining in this"
				" frame.\n"), eid, extn_eid, len, nBufRemaining);
			FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
			FRAMES_LOG2(pCtx, FRLOG1, FRFL("We've parsed %d by"
				"tes of this buffer, and show %d left.\n"),
				pBufRemaining - pBuf, nBufRemaining);
			status |= DOT11F_INCOMPLETE_IE;
			FRAMES_DBG_BREAK();
			goto MandatoryCheck;
		}

		if (pIe) {
			if ((nBufRemaining < pIe->minSize - pIe->noui - 2U) ||
			    (len < pIe->minSize - pIe->noui - 2U)) {
				FRAMES_LOG4(pCtx, FRLOGW, FRFL("The IE %s must "
					"be at least %d bytes in size, but "
					"there are only %d bytes remaining in "
					"this frame or the IE reports a size "
					"of %d bytes.\n"),
					pIe->name, pIe->minSize, nBufRemaining,
					(len + pIe->noui + 2U));
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				status |= DOT11F_INCOMPLETE_IE;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			} else {
				if (len > pIe->maxSize - pIe->noui - 2U) {
				FRAMES_LOG1(pCtx, FRLOGW, FRFL("The IE %s reports "
					"an unexpectedly large size; it is presumably "
					"more up-to-date than this parser, but this wa"
					"rning may also indicate a corrupt frame.\n"),
					pIe->name);
					FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				}

				countOffset = ((0 != pIe->arraybound) *
						(*(uint16_t *)(pFrm + pIe->countOffset)));
				if (0 != pIe->arraybound && countOffset >= pIe->arraybound) {
					status |= DOT11F_DUPLICATE_IE;
					goto skip_dup_ie;
				}
				switch (pIe->sig) {
				case SigIeGTK:
					status |=
						dot11f_unpack_ie_gtk(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEGTK *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEGTK) *
						    countOffset),
						    append_ie);
					break;
				case SigIeIGTK:
					status |=
						dot11f_unpack_ie_igtk(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEIGTK *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEIGTK) *
						    countOffset),
						    append_ie);
					break;
				case SigIeR0KH_ID:
					status |=
						dot11f_unpack_ie_r0_kh_id(
						    pCtx, pBufRemaining, len,
						    (tDot11fIER0KH_ID *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIER0KH_ID) *
						    countOffset),
						    append_ie);
					break;
				case SigIeR1KH_ID:
					status |=
						dot11f_unpack_ie_r1_kh_id(
						    pCtx, pBufRemaining, len,
						    (tDot11fIER1KH_ID *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIER1KH_ID) *
						    countOffset),
						    append_ie);
					break;
				case SigIeAPChannelReport:
					status |=
						dot11f_unpack_ie_ap_channel_report(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEAPChannelReport *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEAPChannelReport) *
						    countOffset),
						    append_ie);
					break;
				case SigIeBcnReportingDetail:
					status |=
						dot11f_unpack_ie_bcn_reporting_detail(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEBcnReportingDetail *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEBcnReportingDetail) *
						    countOffset),
						    append_ie);
					break;
				case SigIeBeaconReportFrmBody:
					status |=
						dot11f_unpack_ie_beacon_report_frm_body(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEBeaconReportFrmBody *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEBeaconReportFrmBody) *
						    countOffset),
						    append_ie);
					break;
				case SigIeBeaconReporting:
					status |=
						dot11f_unpack_ie_beacon_reporting(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEBeaconReporting *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEBeaconReporting) *
						    countOffset),
						    append_ie);
					break;
				case SigIeCondensedCountryStr:
					status |=
						dot11f_unpack_ie_condensed_country_str(
						    pCtx, pBufRemaining, len,
						    (tDot11fIECondensedCountryStr *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIECondensedCountryStr) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMeasurementPilot:
					status |=
						dot11f_unpack_ie_measurement_pilot(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMeasurementPilot *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMeasurementPilot) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMultiBssid:
					status |=
						dot11f_unpack_ie_multi_bssid(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMultiBssid *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMultiBssid) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRICData:
					status |=
						dot11f_unpack_ie_ric_data(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERICData *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERICData) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRICDescriptor:
					status |=
						dot11f_unpack_ie_ric_descriptor(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERICDescriptor *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERICDescriptor) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRRMEnabledCap:
					status |=
						dot11f_unpack_ie_rrm_enabled_cap(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERRMEnabledCap *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERRMEnabledCap) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRequestedInfo:
					status |=
						dot11f_unpack_ie_requested_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERequestedInfo *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERequestedInfo) *
						    countOffset),
						    append_ie);
					break;
				case SigIeSSID:
					status |=
						dot11f_unpack_ie_ssid(
						    pCtx, pBufRemaining, len,
						    (tDot11fIESSID *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIESSID) *
						    countOffset),
						    append_ie);
					break;
				case SigIeSchedule:
					status |=
						dot11f_unpack_ie_schedule(
						    pCtx, pBufRemaining, len,
						    (tDot11fIESchedule *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIESchedule) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTCLAS:
					status |=
						dot11f_unpack_ie_tclas(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETCLAS *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETCLAS) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTCLASSPROC:
					status |= dot11f_unpack_ie_common_func(pCtx, pBufRemaining, len,
										(uint8_t *) &(((tDot11fIETCLASSPROC *)(pFrm + pIe->offset + sizeof(tDot11fIETCLASSPROC)*countOffset))->present),
										(uint8_t *) &(((tDot11fIETCLASSPROC *)(pFrm + pIe->offset + sizeof(tDot11fIETCLASSPROC)*countOffset))->processing));
					break;
				case SigIeTSDelay:
					status |=
						dot11f_unpack_ie_ts_delay(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETSDelay *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETSDelay) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTSFInfo:
					status |=
						dot11f_unpack_ie_tsf_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETSFInfo *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETSFInfo) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTSPEC:
					status |=
						dot11f_unpack_ie_tspec(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETSPEC *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETSPEC) *
						    countOffset),
						    append_ie);
					break;
				case SigIeVHTCaps:
					status |=
						dot11f_unpack_ie_vht_caps(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEVHTCaps *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEVHTCaps) *
						    countOffset),
						    append_ie);
					break;
				case SigIeVHTOperation:
					status |=
						dot11f_unpack_ie_vht_operation(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEVHTOperation *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEVHTOperation) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMSchedule:
					status |=
						dot11f_unpack_ie_wmm_schedule(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMSchedule *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMSchedule) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMTCLAS:
					status |=
						dot11f_unpack_ie_wmmtclas(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMTCLAS *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMTCLAS) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMTCLASPROC:
					status |=
						dot11f_unpack_ie_wmmtclasproc(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMTCLASPROC *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMTCLASPROC) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMTSDelay:
					status |=
						dot11f_unpack_ie_wmmts_delay(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMTSDelay *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMTSDelay) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMTSPEC:
					status |=
						dot11f_unpack_ie_wmmtspec(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMTSPEC *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMTSPEC) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWiderBWChanSwitchAnn:
					status |=
						dot11f_unpack_ie_wider_bw_chan_switch_ann(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWiderBWChanSwitchAnn *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWiderBWChanSwitchAnn) *
						    countOffset),
						    append_ie);
					break;
				case SigIeazimuth_req:
					status |=
						dot11f_unpack_ie_azimuth_req(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEazimuth_req *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEazimuth_req) *
						    countOffset),
						    append_ie);
					break;
				case SigIemax_age:
					status |=
						dot11f_unpack_ie_max_age(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEmax_age *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEmax_age) *
						    countOffset),
						    append_ie);
					break;
				case SigIeneighbor_rpt:
					status |=
						dot11f_unpack_ie_neighbor_rpt(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEneighbor_rpt *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEneighbor_rpt) *
						    countOffset),
						    append_ie);
					break;
				case SigIereq_mac_addr:
					status |=
						dot11f_unpack_ie_req_mac_addr(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEreq_mac_addr *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEreq_mac_addr) *
						    countOffset),
						    append_ie);
					break;
				case SigIetgt_mac_addr:
					status |=
						dot11f_unpack_ie_tgt_mac_addr(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEtgt_mac_addr *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEtgt_mac_addr) *
						    countOffset),
						    append_ie);
					break;
				case SigIevht_transmit_power_env:
					status |=
						dot11f_unpack_ie_vht_transmit_power_env(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEvht_transmit_power_env *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEvht_transmit_power_env) *
						    countOffset),
						    append_ie);
					break;
				case SigIeAID:
					status |=
						dot11f_unpack_ie_aid(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEAID *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEAID) *
						    countOffset),
						    append_ie);
					break;
				case SigIeCFParams:
					status |=
						dot11f_unpack_ie_cf_params(
						    pCtx, pBufRemaining, len,
						    (tDot11fIECFParams *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIECFParams) *
						    countOffset),
						    append_ie);
					break;
				case SigIeChallengeText:
					status |=
						dot11f_unpack_ie_challenge_text(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEChallengeText *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEChallengeText) *
						    countOffset),
						    append_ie);
					break;
				case SigIeChanSwitchAnn:
					status |=
						dot11f_unpack_ie_chan_switch_ann(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEChanSwitchAnn *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEChanSwitchAnn) *
						    countOffset),
						    append_ie);
					break;
				case SigIeChannelSwitchWrapper:
					status |=
						dot11f_unpack_ie_channel_switch_wrapper(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEChannelSwitchWrapper *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEChannelSwitchWrapper) *
						    countOffset),
						    append_ie);
					break;
				case SigIeCountry:
					status |=
						dot11f_unpack_ie_country(
						    pCtx, pBufRemaining, len,
						    (tDot11fIECountry *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIECountry) *
						    countOffset),
						    append_ie);
					break;
				case SigIeDSParams:
					status |= dot11f_unpack_ie_common_func(pCtx, pBufRemaining, len,
										(uint8_t *) &(((tDot11fIEDSParams *)(pFrm + pIe->offset + sizeof(tDot11fIEDSParams)*countOffset))->present),
										(uint8_t *) &(((tDot11fIEDSParams *)(pFrm + pIe->offset + sizeof(tDot11fIEDSParams)*countOffset))->curr_channel));
					break;
				case SigIeEDCAParamSet:
					status |=
						dot11f_unpack_ie_edca_param_set(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEEDCAParamSet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEEDCAParamSet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeERPInfo:
					status |=
						dot11f_unpack_ie_erp_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEERPInfo *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEERPInfo) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESECckmOpaque:
					status |=
						dot11f_unpack_ie_ese_cckm_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESECckmOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESECckmOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESERadMgmtCap:
					status |=
						dot11f_unpack_ie_ese_rad_mgmt_cap(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESERadMgmtCap *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESERadMgmtCap) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESETrafStrmMet:
					status |=
						dot11f_unpack_ie_ese_traf_strm_met(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESETrafStrmMet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESETrafStrmMet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESETrafStrmRateSet:
					status |=
						dot11f_unpack_ie_ese_traf_strm_rate_set(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESETrafStrmRateSet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESETrafStrmRateSet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESETxmitPower:
					status |=
						dot11f_unpack_ie_ese_txmit_power(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESETxmitPower *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESETxmitPower) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESEVersion:
					status |=
						dot11f_unpack_ie_ese_version(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESEVersion *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESEVersion) *
						    countOffset),
						    append_ie);
					break;
				case SigIeESP_information:
					status |=
						dot11f_unpack_ie_ESP_information(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEESP_information *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEESP_information) *
						    countOffset),
						    append_ie);
					break;
				case SigIeExtCap:
					status |=
						dot11f_unpack_ie_ext_cap(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEExtCap *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEExtCap) *
						    countOffset),
						    append_ie);
					break;
				case SigIeExtSuppRates:
					status |=
						dot11f_unpack_ie_ext_supp_rates(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEExtSuppRates *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEExtSuppRates) *
						    countOffset),
						    append_ie);
					break;
				case SigIeFHParamSet:
					status |=
						dot11f_unpack_ie_fh_param_set(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEFHParamSet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEFHParamSet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeFHParams:
					status |=
						dot11f_unpack_ie_fh_params(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEFHParams *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEFHParams) *
						    countOffset),
						    append_ie);
					break;
				case SigIeFHPattTable:
					status |=
						dot11f_unpack_ie_fh_patt_table(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEFHPattTable *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEFHPattTable) *
						    countOffset),
						    append_ie);
					break;
				case SigIeFTInfo:
					status |=
						dot11f_unpack_ie_ft_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEFTInfo *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEFTInfo) *
						    countOffset),
						    append_ie);
					break;
				case SigIeHTCaps:
					status |=
						dot11f_unpack_ie_ht_caps(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEHTCaps *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEHTCaps) *
						    countOffset),
						    append_ie);
					break;
				case SigIeHTInfo:
					status |=
						dot11f_unpack_ie_ht_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEHTInfo *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEHTInfo) *
						    countOffset),
						    append_ie);
					break;
				case SigIeIBSSParams:
					status |=
						dot11f_unpack_ie_ibss_params(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEIBSSParams *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEIBSSParams) *
						    countOffset),
						    append_ie);
					break;
				case SigIeLinkIdentifier:
					status |=
						dot11f_unpack_ie_link_identifier(
						    pCtx, pBufRemaining, len,
						    (tDot11fIELinkIdentifier *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIELinkIdentifier) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMBO_IE:
					status |=
						dot11f_unpack_ie_MBO_IE(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMBO_IE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMBO_IE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMeasurementReport:
					status |=
						dot11f_unpack_ie_measurement_report(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMeasurementReport *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMeasurementReport) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMeasurementRequest:
					status |=
						dot11f_unpack_ie_measurement_request(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMeasurementRequest *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMeasurementRequest) *
						    countOffset),
						    append_ie);
					break;
				case SigIeMobilityDomain:
					status |=
						dot11f_unpack_ie_mobility_domain(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEMobilityDomain *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEMobilityDomain) *
						    countOffset),
						    append_ie);
					break;
				case SigIeNeighborReport:
					status |=
						dot11f_unpack_ie_neighbor_report(
						    pCtx, pBufRemaining, len,
						    (tDot11fIENeighborReport *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIENeighborReport) *
						    countOffset),
						    append_ie);
					break;
				case SigIeOBSSScanParameters:
					status |=
						dot11f_unpack_ie_obss_scan_parameters(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEOBSSScanParameters *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEOBSSScanParameters) *
						    countOffset),
						    append_ie);
					break;
				case SigIeOperatingMode:
					status |=
						dot11f_unpack_ie_operating_mode(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEOperatingMode *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEOperatingMode) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PAssocReq:
					status |=
						dot11f_unpack_ie_p2_p_assoc_req(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PAssocReq *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PAssocReq) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PAssocRes:
					status |=
						dot11f_unpack_ie_p2_p_assoc_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PAssocRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PAssocRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PBeacon:
					status |=
						dot11f_unpack_ie_p2_p_beacon(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PBeacon *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PBeacon) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PBeaconProbeRes:
					status |=
						dot11f_unpack_ie_p2_p_beacon_probe_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PBeaconProbeRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PBeaconProbeRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PDeAuth:
					status |=
						dot11f_unpack_ie_p2_p_de_auth(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PDeAuth *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PDeAuth) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PDisAssoc:
					status |=
						dot11f_unpack_ie_p2_p_dis_assoc(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PDisAssoc *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PDisAssoc) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PIEOpaque:
					status |=
						dot11f_unpack_ie_p2_pie_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PIEOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PIEOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PProbeReq:
					status |=
						dot11f_unpack_ie_p2_p_probe_req(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PProbeReq *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PProbeReq) *
						    countOffset),
						    append_ie);
					break;
				case SigIeP2PProbeRes:
					status |=
						dot11f_unpack_ie_p2_p_probe_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEP2PProbeRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEP2PProbeRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIePTIControl:
					status |=
						dot11f_unpack_ie_pti_control(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEPTIControl *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEPTIControl) *
						    countOffset),
						    append_ie);
					break;
				case SigIePUBufferStatus:
					status |=
						dot11f_unpack_ie_pu_buffer_status(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEPUBufferStatus *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEPUBufferStatus) *
						    countOffset),
						    append_ie);
					break;
				case SigIePowerCaps:
					status |=
						dot11f_unpack_ie_power_caps(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEPowerCaps *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEPowerCaps) *
						    countOffset),
						    append_ie);
					break;
				case SigIePowerConstraints:
					status |=
						dot11f_unpack_ie_power_constraints(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEPowerConstraints *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEPowerConstraints) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQBSSLoad:
					status |=
						dot11f_unpack_ie_qbss_load(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQBSSLoad *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQBSSLoad) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQCN_IE:
					status |=
						dot11f_unpack_ie_QCN_IE(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQCN_IE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQCN_IE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQComVendorIE:
					status |=
						dot11f_unpack_ie_QComVendorIE(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQComVendorIE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQComVendorIE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQOSCapsAp:
					status |=
						dot11f_unpack_ie_qos_caps_ap(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQOSCapsAp *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQOSCapsAp) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQOSCapsStation:
					status |=
						dot11f_unpack_ie_qos_caps_station(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQOSCapsStation *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQOSCapsStation) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQosMapSet:
					status |=
						dot11f_unpack_ie_qos_map_set(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQosMapSet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQosMapSet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeQuiet:
					status |=
						dot11f_unpack_ie_quiet(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEQuiet *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEQuiet) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRCPIIE:
					status |=
						dot11f_unpack_ie_rcpiie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERCPIIE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERCPIIE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRICDataDesc:
					/* reset the pointers back since this is a container IE and it doesnt have its own EID and Len. */
					pBufRemaining -= 2;
					nBufRemaining += 2;
					if (pIe && pIe->noui) {
						pBufRemaining -= pIe->noui;
						nBufRemaining += pIe->noui;
						len += pIe->noui;
					}
					status |= get_container_ies_len(pCtx, pBufRemaining, nBufRemaining, &len, IES_RICDataDesc);
					if (status != DOT11F_PARSE_SUCCESS && status != DOT11F_UNKNOWN_IES)
						 break;
					status |=
						dot11f_unpack_ie_ric_data_desc(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERICDataDesc *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERICDataDesc) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRSN:
					status |=
						dot11f_unpack_ie_rsn(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERSN *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERSN) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRSNIIE:
					status |=
						dot11f_unpack_ie_rsniie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERSNIIE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERSNIIE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeRSNOpaque:
					status |=
						dot11f_unpack_ie_rsn_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIERSNOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIERSNOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeSuppChannels:
					status |=
						dot11f_unpack_ie_supp_channels(
						    pCtx, pBufRemaining, len,
						    (tDot11fIESuppChannels *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIESuppChannels) *
						    countOffset),
						    append_ie);
					break;
				case SigIeSuppOperatingClasses:
					status |=
						dot11f_unpack_ie_supp_operating_classes(
						    pCtx, pBufRemaining, len,
						    (tDot11fIESuppOperatingClasses *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIESuppOperatingClasses) *
						    countOffset),
						    append_ie);
					break;
				case SigIeSuppRates:
					status |=
						dot11f_unpack_ie_supp_rates(
						    pCtx, pBufRemaining, len,
						    (tDot11fIESuppRates *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIESuppRates) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTIM:
					status |=
						dot11f_unpack_ie_tim(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETIM *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETIM) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTPCReport:
					status |=
						dot11f_unpack_ie_tpc_report(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETPCReport *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETPCReport) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTPCRequest:
					status |=
						dot11f_unpack_ie_tpc_request(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETPCRequest *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETPCRequest) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTimeAdvertisement:
					status |=
						dot11f_unpack_ie_time_advertisement(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETimeAdvertisement *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETimeAdvertisement) *
						    countOffset),
						    append_ie);
					break;
				case SigIeTimeoutInterval:
					status |=
						dot11f_unpack_ie_timeout_interval(
						    pCtx, pBufRemaining, len,
						    (tDot11fIETimeoutInterval *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIETimeoutInterval) *
						    countOffset),
						    append_ie);
					break;
				case SigIeVHTExtBssLoad:
					status |=
						dot11f_unpack_ie_vht_ext_bss_load(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEVHTExtBssLoad *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEVHTExtBssLoad) *
						    countOffset),
						    append_ie);
					break;
				case SigIeVendor1IE:
					status |=
						dot11f_unpack_ie_vendor1_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEVendor1IE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEVendor1IE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeVendor3IE:
					status |=
						dot11f_unpack_ie_vendor3_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEVendor3IE *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEVendor3IE) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWAPI:
					status |=
						dot11f_unpack_ie_wapi(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWAPI *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWAPI) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWAPIOpaque:
					status |=
						dot11f_unpack_ie_wapi_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWAPIOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWAPIOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWFATPC:
					status |=
						dot11f_unpack_ie_wfatpc(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWFATPC *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWFATPC) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWFDIEOpaque:
					status |=
						dot11f_unpack_ie_wfdie_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWFDIEOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWFDIEOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMCaps:
					status |=
						dot11f_unpack_ie_wmm_caps(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMCaps *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMCaps) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMInfoAp:
					status |=
						dot11f_unpack_ie_wmm_info_ap(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMInfoAp *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMInfoAp) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMInfoStation:
					status |=
						dot11f_unpack_ie_wmm_info_station(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMInfoStation *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMInfoStation) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWMMParams:
					status |=
						dot11f_unpack_ie_wmm_params(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWMMParams *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWMMParams) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWPA:
					status |=
						dot11f_unpack_ie_wpa(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWPA *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWPA) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWPAOpaque:
					status |=
						dot11f_unpack_ie_wpa_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWPAOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWPAOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWSC:
					status |=
						dot11f_unpack_ie_wsc(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWSC *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWSC) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscAssocReq:
					status |=
						dot11f_unpack_ie_wsc_assoc_req(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscAssocReq *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscAssocReq) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscAssocRes:
					status |=
						dot11f_unpack_ie_wsc_assoc_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscAssocRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscAssocRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscBeacon:
					status |=
						dot11f_unpack_ie_wsc_beacon(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscBeacon *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscBeacon) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscBeaconProbeRes:
					status |=
						dot11f_unpack_ie_wsc_beacon_probe_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscBeaconProbeRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscBeaconProbeRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscIEOpaque:
					status |=
						dot11f_unpack_ie_wsc_ie_opaque(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscIEOpaque *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscIEOpaque) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscProbeReq:
					status |=
						dot11f_unpack_ie_wsc_probe_req(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscProbeReq *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscProbeReq) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscProbeRes:
					status |=
						dot11f_unpack_ie_wsc_probe_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscProbeRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscProbeRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeWscReassocRes:
					status |=
						dot11f_unpack_ie_wsc_reassoc_res(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEWscReassocRes *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEWscReassocRes) *
						    countOffset),
						    append_ie);
					break;
				case SigIeext_chan_switch_ann:
					status |=
						dot11f_unpack_ie_ext_chan_switch_ann(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEext_chan_switch_ann *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEext_chan_switch_ann) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_assoc_delay_info:
					status |=
						dot11f_unpack_ie_fils_assoc_delay_info(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_assoc_delay_info *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_assoc_delay_info) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_hlp_container:
					status |=
						dot11f_unpack_ie_fils_hlp_container(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_hlp_container *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_hlp_container) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_indication:
					status |=
						dot11f_unpack_ie_fils_indication(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_indication *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_indication) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_kde:
					status |=
						dot11f_unpack_ie_fils_kde(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_kde *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_kde) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_key_confirmation:
					status |=
						dot11f_unpack_ie_fils_key_confirmation(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_key_confirmation *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_key_confirmation) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_nonce:
					status |=
						dot11f_unpack_ie_fils_nonce(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_nonce *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_nonce) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_public_key:
					status |=
						dot11f_unpack_ie_fils_public_key(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_public_key *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_public_key) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_session:
					status |=
						dot11f_unpack_ie_fils_session(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_session *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_session) *
						    countOffset),
						    append_ie);
					break;
				case SigIefils_wrapped_data:
					status |=
						dot11f_unpack_ie_fils_wrapped_data(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfils_wrapped_data *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfils_wrapped_data) *
						    countOffset),
						    append_ie);
					break;
				case SigIefragment_ie:
					status |=
						dot11f_unpack_ie_fragment_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEfragment_ie *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEfragment_ie) *
						    countOffset),
						    append_ie);
					break;
				case SigIehs20vendor_ie:
					status |=
						dot11f_unpack_ie_hs20vendor_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEhs20vendor_ie *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEhs20vendor_ie) *
						    countOffset),
						    append_ie);
					break;
				case SigIeht2040_bss_coexistence:
					status |=
						dot11f_unpack_ie_ht2040_bss_coexistence(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEht2040_bss_coexistence *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEht2040_bss_coexistence) *
						    countOffset),
						    append_ie);
					break;
				case SigIeht2040_bss_intolerant_report:
					status |=
						dot11f_unpack_ie_ht2040_bss_intolerant_report(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEht2040_bss_intolerant_report *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEht2040_bss_intolerant_report) *
						    countOffset),
						    append_ie);
					break;
				case SigIeosen_ie:
					status |=
						dot11f_unpack_ie_osen_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEosen_ie *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEosen_ie) *
						    countOffset),
						    append_ie);
					break;
				case SigIesec_chan_offset_ele:
					status |=
						dot11f_unpack_ie_sec_chan_offset_ele(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEsec_chan_offset_ele *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEsec_chan_offset_ele) *
						    countOffset),
						    append_ie);
					break;
				case SigIevendor_vht_ie:
					status |=
						dot11f_unpack_ie_vendor_vht_ie(
						    pCtx, pBufRemaining, len,
						    (tDot11fIEvendor_vht_ie *)
						    (pFrm + pIe->offset +
						    sizeof(tDot11fIEvendor_vht_ie) *
						    countOffset),
						    append_ie);
					break;
				default:
					FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR"
						     ": I don't know about the IE signature %d"
						     "-- this is most likely a 'framesc' bug.\n"),
						     pIe->sig);
					FRAMES_DBG_BREAK();
					return DOT11F_INTERNAL_ERROR;
				}
				if (pIe->arraybound)
					(++(*(uint16_t *)(pFrm + pIe->countOffset)));
			}
		} else {
			FRAMES_LOG3(pCtx, FRLOG3, FRFL("Skipping unknown IE %d extn ID %d"
				     " (length %d)\n"), eid, extn_eid, len);
			FRAMES_DUMP(pCtx, FRLOG3, pBufRemaining - 2, len);
			status |= DOT11F_UNKNOWN_IES;
		}

skip_dup_ie:
		pBufRemaining += len;

		if (len > nBufRemaining) {
			FRAMES_LOG0(pCtx, FRLOGW, FRFL("This IE extends past "
				     "the buffer as it was defined to us.  This could"
				     "mean a corrupt frame, or just an incorrect leng"
				     "th parameter.\n"));
			FRAMES_DBG_BREAK();
			status |= DOT11F_LAST_IE_TOO_LONG;
			goto MandatoryCheck;
		}

		nBufRemaining -= len;

	}

MandatoryCheck:
	pIe = &IEs[0];
	while (0xff != pIe->eid || pIe->extn_eid) {
		if (pIe->fMandatory) {
			pfFound = (tFRAMES_BOOL *)(pFrm + pIe->offset +
						     pIe->presenceOffset);
			if (!*pfFound) {
				FRAMES_LOG1(pCtx, FRLOGW, FRFL("ERROR: The mandato"
					     "ry IE %s wasn't seen.\n"),
					     pIe->name);
				FRAMES_DBG_BREAK();
				status |= DOT11F_MANDATORY_IE_MISSING;
			}
		}
		++pIe;
	}

	return status;
} /* End unpack_core. */

static uint32_t unpack_tlv_core(tpAniSirGlobal   pCtx,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  const tTLVDefn TLVs[],
				  uint8_t *pFrm,
				  size_t nFrm)
{
	const tTLVDefn *pTlv;
	uint32_t      nBufRemaining, status, npec;
	uint16_t      id, len;
	uint8_t      *pBufRemaining, *pfFound;

	(void)pCtx;                 /* Shutup the compiler */
	(void)nFrm;
	status = DOT11F_PARSE_SUCCESS;
	pBufRemaining = pBuf;
	nBufRemaining = nBuf;

	/* While we have data... */
	while (nBufRemaining) {
		if (3 > nBufRemaining) {
			FRAMES_LOG0(pCtx, FRLOGE, FRFL("This frame reports "
				     "fewer three byte(s) remaining.\n"));
			status |= DOT11F_INCOMPLETE_TLV;
			FRAMES_DBG_BREAK();
			goto MandatoryCheck;
		}

		npec = 0U;

		/* Look for a matching TLV definition, */
		pTlv = find_tlv_defn(pCtx, pBufRemaining, nBufRemaining, TLVs);
		/* consume the type, */
		if (pTlv) {
			if (pTlv->sType == 2) {
				framesntohs(pCtx, &id, pBufRemaining, pTlv->fMsb);
				pBufRemaining += 2;
				nBufRemaining -= 2;
			} else {
				id = *pBufRemaining;
				pBufRemaining += 1;
				nBufRemaining -= 1;
			}
			/* & length, */
			if (pTlv->sLen == 2) {
				framesntohs(pCtx, &len, pBufRemaining, pTlv->fMsb);
				if (2 > nBufRemaining) {
					FRAMES_LOG0(pCtx, FRLOGE, FRFL("This frame reports "
							"fewer two byte(s) remaining.\n"));
					status |= DOT11F_INCOMPLETE_TLV;
					FRAMES_DBG_BREAK();
					goto MandatoryCheck;
			}
			pBufRemaining += 2;
			nBufRemaining -= 2;
			} else {
				len = *pBufRemaining;
				pBufRemaining += 1;
				nBufRemaining -= 1;
			}
		} else {
			pBufRemaining += TLVs[0].sType;
			nBufRemaining -= TLVs[0].sType;
			framesntohs(pCtx, &len, pBufRemaining, (TLVs[0].sType == 2));
			if (2 > nBufRemaining) {
				FRAMES_LOG0(pCtx, FRLOGE, FRFL("This frame reports "
					     "fewer two byte(s) remaining.\n"));
				status |= DOT11F_INCOMPLETE_TLV;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			}
			pBufRemaining += 2;
			nBufRemaining -= 2;
		}

		if (pTlv && pTlv->pec) {
		npec = 3U;
			if (3 > nBufRemaining) {
				FRAMES_LOG2(pCtx, FRLOGW, FRFL("TLV %d reports length"
				    "%d, but it has a Private Enterprise Code (3 byte"
				    "s.\n"), id, len);
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				FRAMES_LOG2(pCtx, FRLOG1, FRFL("We've parsed %d bytes"
				    "of this buffer, and show %d left.\n"),
				pBufRemaining - pBuf, nBufRemaining);
				status |= DOT11F_INCOMPLETE_TLV;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			}
		pBufRemaining += 3;
		nBufRemaining -= 3;
		len           -= 3;
		}

		/* Whether we found a hit or not, we can validate the reported */
		/* length of this TLV: */
		if (len > nBufRemaining) {
			FRAMES_LOG3(pCtx, FRLOGW, FRFL("TLV %d reports length %"
			    "d, but there are only %d bytes remaining in this f"
			    "rame.\n"), id, len, nBufRemaining);
			FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
			FRAMES_LOG2(pCtx, FRLOG1, FRFL("We've parsed %d bytes"
			    " of this buffer, and show %d left.\n"),
			    pBufRemaining - pBuf, nBufRemaining);
			status |= DOT11F_INCOMPLETE_TLV;
			FRAMES_DBG_BREAK();
			goto MandatoryCheck;
		}

		/* Now, *if* we found a hit... */
		if (pTlv) {
			if (len + (pTlv->sType + pTlv->sLen) < pTlv->minSize - npec) {
				FRAMES_LOG3(pCtx, FRLOGW, FRFL("The IE %s must be "
				    "at least %d bytes in size, but the size is only "
				    "%d bytes.\n"),
				     pTlv->name, pTlv->minSize, len);
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				status |= DOT11F_INCOMPLETE_TLV;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			}
			if (nBufRemaining < pTlv->minSize - npec - (pTlv->sType + pTlv->sLen)) {
				FRAMES_LOG3(pCtx, FRLOGW, FRFL("The IE %s must be "
				    "at least %d bytes in size, but there are only "
				    "%d bytes remaining in this frame.\n"),
				     pTlv->name, pTlv->minSize, nBufRemaining);
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				status |= DOT11F_INCOMPLETE_TLV;
				FRAMES_DBG_BREAK();
				goto MandatoryCheck;
			} else if (len > pTlv->maxSize - npec - (pTlv->sType + pTlv->sLen)) {
				FRAMES_LOG1(pCtx, FRLOGW, FRFL("The TLV %s reports "
				    "an illegally large size; this TLV is presumably"
				    "corrupt or otherwise invalid & will be skipped "
				    "ipped.\n"), pTlv->name);
				FRAMES_DUMP(pCtx, FRLOG1, pBuf, nBuf);
				FRAMES_LOG2(pCtx, FRLOG1, FRFL("We've parsed %d by"
				    "tes of this buffer, and show %d left.\n"),
				    pBufRemaining - pBuf, nBufRemaining);
				FRAMES_DBG_BREAK();
				status |= DOT11F_SKIPPED_BAD_TLV;
			} else {
				switch (pTlv->sig) {
				case SigTlvAuthorizedMACs:
					status |=
						dot11f_unpack_tlv_authorized_ma_cs(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVAuthorizedMACs *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvRequestToEnroll:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVRequestToEnroll *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVRequestToEnroll *)
						  (pFrm + pTlv->offset))->req));
					break;
				case SigTlvVersion2:
					status |=
						dot11f_unpack_tlv_version2(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVVersion2 *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvAPSetupLocked:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVAPSetupLocked *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVAPSetupLocked *)
						  (pFrm + pTlv->offset))->fLocked));
					break;
				case SigTlvAssociationState:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVAssociationState *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVAssociationState *)
						  (pFrm + pTlv->offset))->state));
					break;
				case SigTlvConfigMethods:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVConfigMethods *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVConfigMethods *)
						  (pFrm + pTlv->offset))->methods));
					break;
				case SigTlvConfigurationError:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVConfigurationError *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVConfigurationError *)
						  (pFrm + pTlv->offset))->error));
					break;
				case SigTlvDeviceName:
					status |=
						dot11f_unpack_tlv_device_name(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVDeviceName *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvDevicePasswordID:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVDevicePasswordID *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVDevicePasswordID *)
						  (pFrm + pTlv->offset))->id));
					break;
				case SigTlvExtendedListenTiming:
					status |=
						dot11f_unpack_tlv_extended_listen_timing(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVExtendedListenTiming *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvListenChannel:
					status |=
						dot11f_unpack_tlv_listen_channel(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVListenChannel *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvManufacturer:
					status |=
						dot11f_unpack_tlv_manufacturer(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVManufacturer *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvMinorReasonCode:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVMinorReasonCode *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVMinorReasonCode *)
						  (pFrm + pTlv->offset))->minorReasonCode));
					break;
				case SigTlvModelName:
					status |=
						dot11f_unpack_tlv_model_name(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVModelName *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvModelNumber:
					status |=
						dot11f_unpack_tlv_model_number(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVModelNumber *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvNoticeOfAbsence:
					status |=
						dot11f_unpack_tlv_notice_of_absence(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVNoticeOfAbsence *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvOperatingChannel:
					status |=
						dot11f_unpack_tlv_operating_channel(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVOperatingChannel *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PCapability:
					status |=
						dot11f_unpack_tlv_p2_p_capability(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVP2PCapability *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PDeviceId:
					status |=
						dot11f_unpack_tlv_p2_p_device_id(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVP2PDeviceId *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PDeviceInfo:
					status |=
						dot11f_unpack_tlv_p2_p_device_info(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVP2PDeviceInfo *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PGroupInfo:
					status |=
						dot11f_unpack_tlv_p2_p_group_info(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVP2PGroupInfo *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PStatus:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVP2PStatus *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVP2PStatus *)
						  (pFrm + pTlv->offset))->status));
					break;
				case SigTlvPrimaryDeviceType:
					status |=
						dot11f_unpack_tlv_primary_device_type(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVPrimaryDeviceType *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvRFBands:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVRFBands *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVRFBands *)
						  (pFrm + pTlv->offset))->bands));
					break;
				case SigTlvRequestDeviceType:
					status |=
						dot11f_unpack_tlv_request_device_type(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVRequestDeviceType *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvRequestType:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVRequestType *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVRequestType *)
						  (pFrm + pTlv->offset))->reqType));
					break;
				case SigTlvResponseType:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVResponseType *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVResponseType *)
						  (pFrm + pTlv->offset))->resType));
					break;
				case SigTlvSelectedRegistrar:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVSelectedRegistrar *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVSelectedRegistrar *)
						  (pFrm + pTlv->offset))->selected));
					break;
				case SigTlvSelectedRegistrarConfigMethods:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVSelectedRegistrarConfigMethods *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVSelectedRegistrarConfigMethods *)
						  (pFrm + pTlv->offset))->methods));
					break;
				case SigTlvSerialNumber:
					status |=
						dot11f_unpack_tlv_serial_number(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVSerialNumber *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvUUID_E:
					status |=
						dot11f_unpack_tlv_uuid_e(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVUUID_E *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvUUID_R:
					status |=
						dot11f_unpack_tlv_uuid_r(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVUUID_R *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvVendorExtension:
					status |=
						dot11f_unpack_tlv_vendor_extension(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVVendorExtension *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvVersion:
					status |=
						dot11f_unpack_tlv_version(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVVersion *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvWPSState:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVWPSState *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVWPSState *)
						  (pFrm + pTlv->offset))->state));
					break;
				case SigTlvassoc_disallowed:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVassoc_disallowed *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVassoc_disallowed *)
						  (pFrm + pTlv->offset))->reason_code));
					break;
				case SigTlvassoc_retry_delay:
					status |=
						dot11f_unpack_tlv_common_func2(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVassoc_retry_delay *)
						  (pFrm + pTlv->offset))->present),
						  (uint16_t *)&(((tDot11fTLVassoc_retry_delay *)
						  (pFrm + pTlv->offset))->delay));
					break;
				case SigTlvcellular_data_cap:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVcellular_data_cap *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVcellular_data_cap *)
						  (pFrm + pTlv->offset))->cellular_connectivity));
					break;
				case SigTlvcellular_data_con_pref:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVcellular_data_con_pref *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVcellular_data_con_pref *)
						  (pFrm + pTlv->offset))->cellular_preference));
					break;
				case SigTlvmbo_ap_cap:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVmbo_ap_cap *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVmbo_ap_cap *)
						  (pFrm + pTlv->offset))->mbo_cap_ind));
					break;
				case SigTlvnon_prefferd_chan_rep:
					status |=
						dot11f_unpack_tlv_non_prefferd_chan_rep(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVnon_prefferd_chan_rep *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvoce_cap:
					status |=
						dot11f_unpack_tlv_oce_cap(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVoce_cap *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvreduced_wan_metrics:
					status |=
						dot11f_unpack_tlv_reduced_wan_metrics(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVreduced_wan_metrics *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvrssi_assoc_rej:
					status |=
						dot11f_unpack_tlv_rssi_assoc_rej(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVrssi_assoc_rej *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvtransition_reason:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVtransition_reason *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVtransition_reason *)
						  (pFrm + pTlv->offset))->transition_reason_code));
					break;
				case SigTlvtransition_reject_reason:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVtransition_reject_reason *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVtransition_reject_reason *)
						  (pFrm + pTlv->offset))->transition_reject_code));
					break;
				case SigTlvP2PInterface:
					status |=
						dot11f_unpack_tlv_p2_p_interface(pCtx,
						  pBufRemaining, len,
						  (tDot11fTLVP2PInterface *)
						  (pFrm + pTlv->offset));
					break;
				case SigTlvP2PManageability:
					status |=
						dot11f_unpack_tlv_common_func(pCtx,
						  pBufRemaining, len,
						  (uint8_t *)&(((tDot11fTLVP2PManageability *)
						  (pFrm + pTlv->offset))->present),
						  (uint8_t *)&(((tDot11fTLVP2PManageability *)
						  (pFrm + pTlv->offset))->manageability));
					break;
				default:
					FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR: I"
					    " don't know about the TLV signature %d-- thi"
					    "s is most likely a 'framesc' bug.\n"),
					    pTlv->sig);
					FRAMES_DBG_BREAK();
					return DOT11F_INTERNAL_ERROR;
				} /* End switch on sig. */
			} /* End if on length check. */

		} else {
			FRAMES_LOG2(pCtx, FRLOG3, FRFL("Skipping unknown TLV %d ("
			    "length %d)\n"), id, len);
			FRAMES_DUMP(pCtx, FRLOG3, pBufRemaining - (pTlv->sType + pTlv->sLen), len);
			status |= DOT11F_UNKNOWN_TLVS;
		}

		/* Advance to the next TLV */
		pBufRemaining += len;

		if (len > nBufRemaining) {
			FRAMES_LOG0(pCtx, FRLOGW, FRFL("This TLV extends past th"
			    "e buffer as it was defined to us.  This could mean "
			    "a corrupt frame, or just an incorrect length parame"
			    "ter.\n"));
			FRAMES_DBG_BREAK();
			status |= DOT11F_LAST_TLV_TOO_LONG;
			goto MandatoryCheck;
		}

		nBufRemaining -= len;

	} /* End iteration over TLVs.*/

MandatoryCheck:
	pTlv = &TLVs[0];
	while (0xffff != pTlv->id) {
		if (pTlv->fMandatory) {
			pfFound = (uint8_t *)(pFrm + pTlv->offset +
					     pTlv->presenceOffset);
			if (!*pfFound) {
				FRAMES_LOG1(pCtx, FRLOGW, FRFL("ERROR: The mandatory "
				    "TLV %s wasn't seen.\n"),
				    pTlv->name);
				FRAMES_DBG_BREAK();
				status |= DOT11F_MANDATORY_TLV_MISSING;
			}

		}
		++pTlv;
	}

	return status;
} /* End UnpacTlvkCore. */
uint32_t dot11f_get_packed_ietclas(tpAniSirGlobal pCtx,
	tDot11fIETCLAS *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		switch (pIe->classifier_type) {
		case 0:
			*pnNeeded += 6;
			*pnNeeded += 6;
			*pnNeeded += 2;
			break;
		case 1:
			*pnNeeded += 1;
			switch (pIe->info.IpParams.version) {
			case 4:
				*pnNeeded += 4;
				*pnNeeded += 4;
				*pnNeeded += 2;
				*pnNeeded += 2;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				break;
			case 6:
				*pnNeeded += 16;
				*pnNeeded += 16;
				*pnNeeded += 2;
				*pnNeeded += 2;
				*pnNeeded += 3;
				break;
			}
			break;
		case 2:
			*pnNeeded += 2;
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_ietclas. */

uint32_t dot11f_get_packed_iewmmtclas(tpAniSirGlobal pCtx,
	tDot11fIEWMMTCLAS *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		switch (pIe->classifier_type) {
		case 0:
			*pnNeeded += 6;
			*pnNeeded += 6;
			*pnNeeded += 2;
			break;
		case 1:
			*pnNeeded += 1;
			switch (pIe->info.IpParams.version) {
			case 4:
				*pnNeeded += 4;
				*pnNeeded += 4;
				*pnNeeded += 2;
				*pnNeeded += 2;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				break;
			case 6:
				*pnNeeded += 16;
				*pnNeeded += 16;
				*pnNeeded += 2;
				*pnNeeded += 2;
				*pnNeeded += 3;
				break;
			}
			break;
		case 2:
			*pnNeeded += 2;
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_iewmmtclas. */

uint32_t dot11f_get_packed_ie_neighbor_rpt(tpAniSirGlobal pCtx,
	tDot11fIEneighbor_rpt *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 6;
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 2;
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_neighbor_rpt);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_neighbor_rpt. */

uint32_t dot11f_get_packed_ie_channel_switch_wrapper(tpAniSirGlobal pCtx,
	tDot11fIEChannelSwitchWrapper *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_ChannelSwitchWrapper);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_channel_switch_wrapper. */

uint32_t dot11f_get_packed_ie_country(tpAniSirGlobal pCtx,
	tDot11fIECountry *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 3;
		if (pIe->num_triplets) {
			*pnNeeded += (pIe->num_triplets * 3);
		} else {
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_country. */

uint32_t dot11f_get_packed_ieft_info(tpAniSirGlobal pCtx,
	tDot11fIEFTInfo *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 2;
		*pnNeeded += 16;
		*pnNeeded += 32;
		*pnNeeded += 32;
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_FTInfo);
		break;
	}
	return status;
} /* End dot11f_get_packed_ieft_info. */

uint32_t dot11f_get_packed_ie_MBO_IE(tpAniSirGlobal pCtx,
	tDot11fIEMBO_IE *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_MBO_IE);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_MBO_IE. */

uint32_t dot11f_get_packed_ie_measurement_report(tpAniSirGlobal pCtx,
	tDot11fIEMeasurementReport *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		if (pIe->type) {
			switch (pIe->type) {
			case 0:
				*pnNeeded += 1;
				*pnNeeded += 8;
				*pnNeeded += 2;
				*pnNeeded += 1;
				break;
			case 1:
				*pnNeeded += 1;
				*pnNeeded += 8;
				*pnNeeded += 2;
				*pnNeeded += 1;
				break;
			case 2:
				*pnNeeded += 1;
				*pnNeeded += 8;
				*pnNeeded += 2;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				break;
			case 5:
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 8;
				*pnNeeded += 2;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 1;
				*pnNeeded += 6;
				*pnNeeded += 1;
				*pnNeeded += 4;
				status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded, IES_reportBeacon);
				break;
			}
		} else {
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_measurement_report. */

uint32_t dot11f_get_packed_ie_measurement_request(tpAniSirGlobal pCtx,
	tDot11fIEMeasurementRequest *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		switch (pIe->measurement_type) {
		case 0:
			*pnNeeded += 1;
			*pnNeeded += 8;
			*pnNeeded += 2;
			break;
		case 1:
			*pnNeeded += 1;
			*pnNeeded += 8;
			*pnNeeded += 2;
			break;
		case 2:
			*pnNeeded += 1;
			*pnNeeded += 8;
			*pnNeeded += 2;
			break;
		case 5:
			*pnNeeded += 1;
			*pnNeeded += 1;
			*pnNeeded += 2;
			*pnNeeded += 2;
			*pnNeeded += 1;
			*pnNeeded += 6;
			status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded, IES_measurement_requestBeacon);
			break;
		case 8:
			*pnNeeded += 1;
			status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded, IES_measurement_requestlci);
			break;
		case 16:
			*pnNeeded += 2;
			*pnNeeded += 1;
			status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded, IES_measurement_requestftmrr);
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_measurement_request. */

uint32_t dot11f_get_packed_ie_neighbor_report(tpAniSirGlobal pCtx,
	tDot11fIENeighborReport *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 6;
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 2;
		*pnNeeded += 1;
		*pnNeeded += 1;
		*pnNeeded += 1;
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_NeighborReport);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_neighbor_report. */

uint32_t dot11f_get_packed_iep2_p_assoc_req(tpAniSirGlobal pCtx,
	tDot11fIEP2PAssocReq *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PAssocReq);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_assoc_req. */

uint32_t dot11f_get_packed_iep2_p_assoc_res(tpAniSirGlobal pCtx,
	tDot11fIEP2PAssocRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PAssocRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_assoc_res. */

uint32_t dot11f_get_packed_iep2_p_beacon(tpAniSirGlobal pCtx,
	tDot11fIEP2PBeacon *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PBeacon);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_beacon. */

uint32_t dot11f_get_packed_iep2_p_beacon_probe_res(tpAniSirGlobal pCtx,
	tDot11fIEP2PBeaconProbeRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PBeaconProbeRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_beacon_probe_res. */

uint32_t dot11f_get_packed_iep2_p_de_auth(tpAniSirGlobal pCtx,
	tDot11fIEP2PDeAuth *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PDeAuth);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_de_auth. */

uint32_t dot11f_get_packed_iep2_p_dis_assoc(tpAniSirGlobal pCtx,
	tDot11fIEP2PDisAssoc *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PDisAssoc);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_dis_assoc. */

uint32_t dot11f_get_packed_iep2_p_probe_req(tpAniSirGlobal pCtx,
	tDot11fIEP2PProbeReq *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PProbeReq);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_probe_req. */

uint32_t dot11f_get_packed_iep2_p_probe_res(tpAniSirGlobal pCtx,
	tDot11fIEP2PProbeRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_P2PProbeRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_iep2_p_probe_res. */

uint32_t dot11f_get_packed_ieric_data_desc(tpAniSirGlobal pCtx,
	tDot11fIERICDataDesc *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_RICDataDesc);
		break;
	}
	return status;
} /* End dot11f_get_packed_ieric_data_desc. */

uint32_t dot11f_get_packed_iersn(tpAniSirGlobal pCtx,
	tDot11fIERSN *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 2;
		*pnNeeded += 4;
		if (pIe->pwise_cipher_suite_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->pwise_cipher_suite_count * 4);
		if (pIe->akm_suite_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->akm_suite_count * 4);
		if (pIe->RSN_Cap) {
			*pnNeeded += 2;
		} else {
			break;
		}
		if (pIe->pmkid_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->pmkid_count * 16);
		if (pIe->gp_mgmt_cipher_suite) {
			*pnNeeded += 4;
		} else {
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_iersn. */

uint32_t dot11f_get_packed_iewapi(tpAniSirGlobal pCtx,
	tDot11fIEWAPI *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 2;
		*pnNeeded += 2;
		*pnNeeded += (pIe->akm_suite_count * 4);
		*pnNeeded += 2;
		*pnNeeded += (pIe->unicast_cipher_suite_count * 4);
		*pnNeeded += 4;
		*pnNeeded += 2;
		if (pIe->bkid_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->bkid_count * 16);
		break;
	}
	return status;
} /* End dot11f_get_packed_iewapi. */

uint32_t dot11f_get_packed_iewpa(tpAniSirGlobal pCtx,
	tDot11fIEWPA *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 2;
		if (pIe->multicast_cipher_present) {

			*pnNeeded += 4;
		} else {
			break;
		}
		if (pIe->unicast_cipher_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->unicast_cipher_count * 4);
		if (pIe->auth_suite_count) {
			*pnNeeded += 2;
		} else {
			break;
		}
		*pnNeeded += (pIe->auth_suite_count * 4);
		if (pIe->caps) {
			*pnNeeded += 2;
		} else {
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_iewpa. */

uint32_t dot11f_get_packed_iewsc(tpAniSirGlobal pCtx,
	tDot11fIEWSC *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WSC);
		break;
	}
	return status;
} /* End dot11f_get_packed_iewsc. */

uint32_t dot11f_get_packed_ie_wsc_assoc_req(tpAniSirGlobal pCtx,
	tDot11fIEWscAssocReq *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscAssocReq);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_assoc_req. */

uint32_t dot11f_get_packed_ie_wsc_assoc_res(tpAniSirGlobal pCtx,
	tDot11fIEWscAssocRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscAssocRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_assoc_res. */

uint32_t dot11f_get_packed_ie_wsc_beacon(tpAniSirGlobal pCtx,
	tDot11fIEWscBeacon *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscBeacon);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_beacon. */

uint32_t dot11f_get_packed_ie_wsc_beacon_probe_res(tpAniSirGlobal pCtx,
	tDot11fIEWscBeaconProbeRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscBeaconProbeRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_beacon_probe_res. */

uint32_t dot11f_get_packed_ie_wsc_probe_req(tpAniSirGlobal pCtx,
	tDot11fIEWscProbeReq *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscProbeReq);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_probe_req. */

uint32_t dot11f_get_packed_ie_wsc_probe_res(tpAniSirGlobal pCtx,
	tDot11fIEWscProbeRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscProbeRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_probe_res. */

uint32_t dot11f_get_packed_ie_wsc_reassoc_res(tpAniSirGlobal pCtx,
	tDot11fIEWscReassocRes *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pIe, pnNeeded,
				TLVS_WscReassocRes);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_wsc_reassoc_res. */

uint32_t dot11f_get_packed_ie_hs20vendor_ie(tpAniSirGlobal pCtx,
	tDot11fIEhs20vendor_ie *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		if (pIe->hs_id_present) {
			switch (pIe->hs_id_present) {
			case 1:
				*pnNeeded += 2;
				break;
			case 2:
				*pnNeeded += 2;
				break;
			}
		} else {
			break;
		}
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_hs20vendor_ie. */

uint32_t dot11f_get_packed_ie_vendor_vht_ie(tpAniSirGlobal pCtx,
	tDot11fIEvendor_vht_ie *pIe, uint32_t *pnNeeded)
{
	uint32_t status = DOT11F_PARSE_SUCCESS;
	(void)pCtx;
	while (pIe->present) {
		*pnNeeded += 1;
		status = get_packed_size_core(pCtx, (uint8_t *)pIe, pnNeeded,
				IES_vendor_vht_ie);
		break;
	}
	return status;
} /* End dot11f_get_packed_ie_vendor_vht_ie. */

uint32_t dot11f_get_packed_add_ts_request_size(tpAniSirGlobal pCtx,
	tDot11fAddTSRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_AddTSRequest);
	return status;
} /* End dot11f_get_packed_add_ts_request_size. */

uint32_t dot11f_get_packed_add_ts_response_size(tpAniSirGlobal pCtx,
	tDot11fAddTSResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_AddTSResponse);
	return status;
} /* End dot11f_get_packed_add_ts_response_size. */

uint32_t dot11f_get_packed_assoc_request_size(tpAniSirGlobal pCtx,
	tDot11fAssocRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_AssocRequest);
	return status;
} /* End dot11f_get_packed_assoc_request_size. */

uint32_t dot11f_get_packed_assoc_response_size(tpAniSirGlobal pCtx,
	tDot11fAssocResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 6;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_AssocResponse);
	return status;
} /* End dot11f_get_packed_assoc_response_size. */

uint32_t dot11f_get_packed_authentication_size(tpAniSirGlobal pCtx,
	tDot11fAuthentication *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 6;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_Authentication);
	return status;
} /* End dot11f_get_packed_authentication_size. */

uint32_t dot11f_get_packed_beacon_size(tpAniSirGlobal pCtx,
	tDot11fBeacon *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 12;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_Beacon);
	return status;
} /* End dot11f_get_packed_beacon_size. */

uint32_t dot11f_get_packed_beacon1_size(tpAniSirGlobal pCtx,
	tDot11fBeacon1 *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 12;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_Beacon1);
	return status;
} /* End dot11f_get_packed_beacon1_size. */

uint32_t dot11f_get_packed_beacon2_size(tpAniSirGlobal pCtx,
	tDot11fBeacon2 *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 0;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_Beacon2);
	return status;
} /* End dot11f_get_packed_beacon2_size. */

uint32_t dot11f_get_packed_beacon_i_es_size(tpAniSirGlobal pCtx,
	tDot11fBeaconIEs *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 0;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_BeaconIEs);
	return status;
} /* End dot11f_get_packed_beacon_i_es_size. */

uint32_t dot11f_get_packed_channel_switch_size(tpAniSirGlobal pCtx,
	tDot11fChannelSwitch *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 2;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ChannelSwitch);
	return status;
} /* End dot11f_get_packed_channel_switch_size. */

uint32_t dot11f_get_packed_de_auth_size(tpAniSirGlobal pCtx,
	tDot11fDeAuth *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 2;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_DeAuth);
	return status;
} /* End dot11f_get_packed_de_auth_size. */

uint32_t dot11f_get_packed_del_ts_size(tpAniSirGlobal pCtx,
	tDot11fDelTS *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 7;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_DelTS);
	return status;
} /* End dot11f_get_packed_del_ts_size. */

uint32_t dot11f_get_packed_disassociation_size(tpAniSirGlobal pCtx,
	tDot11fDisassociation *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 2;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_Disassociation);
	return status;
} /* End dot11f_get_packed_disassociation_size. */

uint32_t dot11f_get_packed_link_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementReport *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 11;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_LinkMeasurementReport);
	return status;
} /* End dot11f_get_packed_link_measurement_report_size. */

uint32_t dot11f_get_packed_link_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_LinkMeasurementRequest);
	return status;
} /* End dot11f_get_packed_link_measurement_request_size. */

uint32_t dot11f_get_packed_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fMeasurementReport *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_MeasurementReport);
	return status;
} /* End dot11f_get_packed_measurement_report_size. */

uint32_t dot11f_get_packed_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fMeasurementRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_MeasurementRequest);
	return status;
} /* End dot11f_get_packed_measurement_request_size. */

uint32_t dot11f_get_packed_neighbor_report_request_size(tpAniSirGlobal pCtx,
	tDot11fNeighborReportRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_NeighborReportRequest);
	return status;
} /* End dot11f_get_packed_neighbor_report_request_size. */

uint32_t dot11f_get_packed_neighbor_report_response_size(tpAniSirGlobal pCtx,
	tDot11fNeighborReportResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_NeighborReportResponse);
	return status;
} /* End dot11f_get_packed_neighbor_report_response_size. */

uint32_t dot11f_get_packed_operating_mode_size(tpAniSirGlobal pCtx,
	tDot11fOperatingMode *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_OperatingMode);
	return status;
} /* End dot11f_get_packed_operating_mode_size. */

uint32_t dot11f_get_packed_probe_request_size(tpAniSirGlobal pCtx,
	tDot11fProbeRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 0;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ProbeRequest);
	return status;
} /* End dot11f_get_packed_probe_request_size. */

uint32_t dot11f_get_packed_probe_response_size(tpAniSirGlobal pCtx,
	tDot11fProbeResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 12;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ProbeResponse);
	return status;
} /* End dot11f_get_packed_probe_response_size. */

uint32_t dot11f_get_packed_qos_map_configure_size(tpAniSirGlobal pCtx,
	tDot11fQosMapConfigure *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 2;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_QosMapConfigure);
	return status;
} /* End dot11f_get_packed_qos_map_configure_size. */

uint32_t dot11f_get_packed_radio_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementReport *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_RadioMeasurementReport);
	return status;
} /* End dot11f_get_packed_radio_measurement_report_size. */

uint32_t dot11f_get_packed_radio_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_RadioMeasurementRequest);
	return status;
} /* End dot11f_get_packed_radio_measurement_request_size. */

uint32_t dot11f_get_packed_re_assoc_request_size(tpAniSirGlobal pCtx,
	tDot11fReAssocRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 10;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ReAssocRequest);
	return status;
} /* End dot11f_get_packed_re_assoc_request_size. */

uint32_t dot11f_get_packed_re_assoc_response_size(tpAniSirGlobal pCtx,
	tDot11fReAssocResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 6;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ReAssocResponse);
	return status;
} /* End dot11f_get_packed_re_assoc_response_size. */

uint32_t dot11f_get_packed_sm_power_save_size(tpAniSirGlobal pCtx,
	tDot11fSMPowerSave *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_SMPowerSave);
	return status;
} /* End dot11f_get_packed_sm_power_save_size. */

uint32_t dot11f_get_packed_sa_query_req_size(tpAniSirGlobal pCtx,
	tDot11fSaQueryReq *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_SaQueryReq);
	return status;
} /* End dot11f_get_packed_sa_query_req_size. */

uint32_t dot11f_get_packed_sa_query_rsp_size(tpAniSirGlobal pCtx,
	tDot11fSaQueryRsp *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_SaQueryRsp);
	return status;
} /* End dot11f_get_packed_sa_query_rsp_size. */

uint32_t dot11f_get_packed_tdls_dis_req_size(tpAniSirGlobal pCtx,
	tDot11fTDLSDisReq *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSDisReq);
	return status;
} /* End dot11f_get_packed_tdls_dis_req_size. */

uint32_t dot11f_get_packed_tdls_dis_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSDisRsp *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSDisRsp);
	return status;
} /* End dot11f_get_packed_tdls_dis_rsp_size. */

uint32_t dot11f_get_packed_tdls_peer_traffic_ind_size(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficInd *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSPeerTrafficInd);
	return status;
} /* End dot11f_get_packed_tdls_peer_traffic_ind_size. */

uint32_t dot11f_get_packed_tdls_peer_traffic_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficRsp *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSPeerTrafficRsp);
	return status;
} /* End dot11f_get_packed_tdls_peer_traffic_rsp_size. */

uint32_t dot11f_get_packed_tdls_setup_cnf_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupCnf *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSSetupCnf);
	return status;
} /* End dot11f_get_packed_tdls_setup_cnf_size. */

uint32_t dot11f_get_packed_tdls_setup_req_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupReq *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 5;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSSetupReq);
	return status;
} /* End dot11f_get_packed_tdls_setup_req_size. */

uint32_t dot11f_get_packed_tdls_setup_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupRsp *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 7;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSSetupRsp);
	return status;
} /* End dot11f_get_packed_tdls_setup_rsp_size. */

uint32_t dot11f_get_packed_tdls_teardown_size(tpAniSirGlobal pCtx,
	tDot11fTDLSTeardown *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TDLSTeardown);
	return status;
} /* End dot11f_get_packed_tdls_teardown_size. */

uint32_t dot11f_get_packed_tpc_report_size(tpAniSirGlobal pCtx,
	tDot11fTPCReport *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TPCReport);
	return status;
} /* End dot11f_get_packed_tpc_report_size. */

uint32_t dot11f_get_packed_tpc_request_size(tpAniSirGlobal pCtx,
	tDot11fTPCRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 3;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TPCRequest);
	return status;
} /* End dot11f_get_packed_tpc_request_size. */

uint32_t dot11f_get_packed_timing_advertisement_frame_size(tpAniSirGlobal pCtx,
	tDot11fTimingAdvertisementFrame *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 10;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_TimingAdvertisementFrame);
	return status;
} /* End dot11f_get_packed_timing_advertisement_frame_size. */

uint32_t dot11f_get_packed_vht_gid_management_action_frame_size(tpAniSirGlobal pCtx,
	tDot11fVHTGidManagementActionFrame *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 26;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_VHTGidManagementActionFrame);
	return status;
} /* End dot11f_get_packed_vht_gid_management_action_frame_size. */

uint32_t dot11f_get_packed_wmm_add_ts_request_size(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSRequest *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_WMMAddTSRequest);
	return status;
} /* End dot11f_get_packed_wmm_add_ts_request_size. */

uint32_t dot11f_get_packed_wmm_add_ts_response_size(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSResponse *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_WMMAddTSResponse);
	return status;
} /* End dot11f_get_packed_wmm_add_ts_response_size. */

uint32_t dot11f_get_packed_wmm_del_ts_size(tpAniSirGlobal pCtx,
	tDot11fWMMDelTS *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 4;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_WMMDelTS);
	return status;
} /* End dot11f_get_packed_wmm_del_ts_size. */

uint32_t dot11f_get_packed_ext_channel_switch_action_frame_size(tpAniSirGlobal pCtx,
	tDot11fext_channel_switch_action_frame *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 6;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ext_channel_switch_action_frame);
	return status;
} /* End dot11f_get_packed_ext_channel_switch_action_frame_size. */

uint32_t dot11f_get_packed_ht2040_bss_coexistence_mgmt_action_frameSize(tpAniSirGlobal pCtx,
	tDot11fht2040_bss_coexistence_mgmt_action_frame *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 2;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_ht2040_bss_coexistence_mgmt_action_frame);
	return status;
} /* End dot11f_get_packed_ht2040_bss_coexistence_mgmt_action_frameSize. */

uint32_t dot11f_get_packed_p2p_oper_chan_change_confirmSize(tpAniSirGlobal pCtx,
	tDot11fp2p_oper_chan_change_confirm *pFrm, uint32_t *pnNeeded)
{
	uint32_t status = 0;
	*pnNeeded = 7;
	status = get_packed_size_core(pCtx, (uint8_t *)pFrm, pnNeeded,
				      IES_p2p_oper_chan_change_confirm);
	return status;
} /* End dot11f_get_packed_p2p_oper_chan_change_confirmSize. */

static uint32_t get_packed_size_core(tpAniSirGlobal pCtx,
				      uint8_t *pFrm,
				      uint32_t *pnNeeded,
				      const tIEDefn  IEs[])
{
	const tIEDefn *pIe;
	uint16_t  i, n;
	uint32_t  status;
	tFRAMES_BOOL *pfFound;
	uint32_t countOffset = 0;
	uint32_t byteCount = 0;
	uint8_t  pIePresent = 0;
	uint32_t offset = 0;

	status = DOT11F_PARSE_SUCCESS;

	(void)pCtx; /* Shutup the compiler if we have no FFs nor IEs... */
	i = 0;
	n = 0;
	pIe = &(IEs[0]);
	while (0xff != pIe->eid || pIe->extn_eid) {
		pfFound = (tFRAMES_BOOL *)(pFrm + pIe->offset +
					  pIe->presenceOffset);
		if (*pfFound) {
			countOffset = ((0 == pIe->arraybound) ? 1 : (*(uint16_t *)(pFrm + pIe->countOffset)));
			for (i = 0U; i < countOffset; ++i) {
				*pnNeeded += 2U + pIe->noui;
				if (pIe->extn_eid)
						(*pnNeeded)++;
				byteCount = 0;
				switch (pIe->sig) {
				case SigIeGTK:
					offset = sizeof(tDot11fIEGTK);
					byteCount = ((tDot11fIEGTK *)
					  (pFrm + pIe->offset + offset * i))->
					  num_key + 11;
					pIePresent = ((tDot11fIEGTK *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeIGTK:
					offset = sizeof(tDot11fIEIGTK);
					byteCount = 33;
					pIePresent = ((tDot11fIEIGTK *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeR0KH_ID:
					offset = sizeof(tDot11fIER0KH_ID);
					byteCount = ((tDot11fIER0KH_ID *)
					  (pFrm + pIe->offset + offset * i))->
					  num_PMK_R0_ID;
					pIePresent = ((tDot11fIER0KH_ID *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeR1KH_ID:
					offset = sizeof(tDot11fIER1KH_ID);
					byteCount = 6;
					pIePresent = ((tDot11fIER1KH_ID *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeAPChannelReport:
					offset = sizeof(tDot11fIEAPChannelReport);
					byteCount = ((tDot11fIEAPChannelReport *)
					  (pFrm + pIe->offset + offset * i))->
					  num_channelList + 1;
					pIePresent = ((tDot11fIEAPChannelReport *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeBcnReportingDetail:
					offset = sizeof(tDot11fIEBcnReportingDetail);
					byteCount = 1;
					pIePresent = ((tDot11fIEBcnReportingDetail *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeBeaconReportFrmBody:
					offset = sizeof(tDot11fIEBeaconReportFrmBody);
					byteCount = ((tDot11fIEBeaconReportFrmBody *)
					  (pFrm + pIe->offset + offset * i))->
					  num_reportedFields;
					pIePresent = ((tDot11fIEBeaconReportFrmBody *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeBeaconReporting:
					offset = sizeof(tDot11fIEBeaconReporting);
					byteCount = 2;
					pIePresent = ((tDot11fIEBeaconReporting *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeCondensedCountryStr:
					offset = sizeof(tDot11fIECondensedCountryStr);
					byteCount = 2;
					pIePresent = ((tDot11fIECondensedCountryStr *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeMeasurementPilot:
					offset = sizeof(tDot11fIEMeasurementPilot);
					byteCount = ((tDot11fIEMeasurementPilot *)
					  (pFrm + pIe->offset + offset * i))->
					  num_vendorSpecific + 1;
					pIePresent = ((tDot11fIEMeasurementPilot *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeMultiBssid:
					offset = sizeof(tDot11fIEMultiBssid);
					byteCount = ((tDot11fIEMultiBssid *)
					  (pFrm + pIe->offset + offset * i))->
					  num_vendorSpecific + 1;
					pIePresent = ((tDot11fIEMultiBssid *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRICData:
					offset = sizeof(tDot11fIERICData);
					byteCount = 4;
					pIePresent = ((tDot11fIERICData *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRICDescriptor:
					offset = sizeof(tDot11fIERICDescriptor);
					byteCount = ((tDot11fIERICDescriptor *)
					  (pFrm + pIe->offset + offset * i))->
					  num_variableData + 1;
					pIePresent = ((tDot11fIERICDescriptor *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRRMEnabledCap:
					offset = sizeof(tDot11fIERRMEnabledCap);
					byteCount = 5;
					pIePresent = ((tDot11fIERRMEnabledCap *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRequestedInfo:
					offset = sizeof(tDot11fIERequestedInfo);
					byteCount = ((tDot11fIERequestedInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  num_requested_eids;
					pIePresent = ((tDot11fIERequestedInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeSSID:
					offset = sizeof(tDot11fIESSID);
					byteCount = ((tDot11fIESSID *)
					  (pFrm + pIe->offset + offset * i))->
					  num_ssid;
					pIePresent = ((tDot11fIESSID *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeSchedule:
					offset = sizeof(tDot11fIESchedule);
					byteCount = 14;
					pIePresent = ((tDot11fIESchedule *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTCLAS:
					offset = sizeof(tDot11fIETCLAS);
					status |=
						dot11f_get_packed_ietclas(
						pCtx, (tDot11fIETCLAS *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeTCLASSPROC:
					offset = sizeof(tDot11fIETCLASSPROC);
					byteCount = 1;
					pIePresent = ((tDot11fIETCLASSPROC *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTSDelay:
					offset = sizeof(tDot11fIETSDelay);
					byteCount = 4;
					pIePresent = ((tDot11fIETSDelay *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTSFInfo:
					offset = sizeof(tDot11fIETSFInfo);
					byteCount = 4;
					pIePresent = ((tDot11fIETSFInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTSPEC:
					offset = sizeof(tDot11fIETSPEC);
					byteCount = 55;
					pIePresent = ((tDot11fIETSPEC *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeVHTCaps:
					offset = sizeof(tDot11fIEVHTCaps);
					byteCount = 12;
					pIePresent = ((tDot11fIEVHTCaps *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeVHTOperation:
					offset = sizeof(tDot11fIEVHTOperation);
					byteCount = 5;
					pIePresent = ((tDot11fIEVHTOperation *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMSchedule:
					offset = sizeof(tDot11fIEWMMSchedule);
					byteCount = 15;
					pIePresent = ((tDot11fIEWMMSchedule *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMTCLAS:
					offset = sizeof(tDot11fIEWMMTCLAS);
					status |=
						dot11f_get_packed_iewmmtclas(
						pCtx, (tDot11fIEWMMTCLAS *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWMMTCLASPROC:
					offset = sizeof(tDot11fIEWMMTCLASPROC);
					byteCount = 2;
					pIePresent = ((tDot11fIEWMMTCLASPROC *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMTSDelay:
					offset = sizeof(tDot11fIEWMMTSDelay);
					byteCount = 5;
					pIePresent = ((tDot11fIEWMMTSDelay *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMTSPEC:
					offset = sizeof(tDot11fIEWMMTSPEC);
					byteCount = 56;
					pIePresent = ((tDot11fIEWMMTSPEC *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWiderBWChanSwitchAnn:
					offset = sizeof(tDot11fIEWiderBWChanSwitchAnn);
					byteCount = 3;
					pIePresent = ((tDot11fIEWiderBWChanSwitchAnn *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeazimuth_req:
					offset = sizeof(tDot11fIEazimuth_req);
					byteCount = 1;
					pIePresent = ((tDot11fIEazimuth_req *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIemax_age:
					offset = sizeof(tDot11fIEmax_age);
					byteCount = 2;
					pIePresent = ((tDot11fIEmax_age *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeneighbor_rpt:
					offset = sizeof(tDot11fIEneighbor_rpt);
					status |=
						dot11f_get_packed_ie_neighbor_rpt(
						pCtx, (tDot11fIEneighbor_rpt *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIereq_mac_addr:
					offset = sizeof(tDot11fIEreq_mac_addr);
					byteCount = 6;
					pIePresent = ((tDot11fIEreq_mac_addr *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIetgt_mac_addr:
					offset = sizeof(tDot11fIEtgt_mac_addr);
					byteCount = 6;
					pIePresent = ((tDot11fIEtgt_mac_addr *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIevht_transmit_power_env:
					offset = sizeof(tDot11fIEvht_transmit_power_env);
					byteCount = ((tDot11fIEvht_transmit_power_env *)
					  (pFrm + pIe->offset + offset * i))->
					  num_bytes;
					pIePresent = ((tDot11fIEvht_transmit_power_env *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeAID:
					offset = sizeof(tDot11fIEAID);
					byteCount = 2;
					pIePresent = ((tDot11fIEAID *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeCFParams:
					offset = sizeof(tDot11fIECFParams);
					byteCount = 6;
					pIePresent = ((tDot11fIECFParams *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeChallengeText:
					offset = sizeof(tDot11fIEChallengeText);
					byteCount = ((tDot11fIEChallengeText *)
					  (pFrm + pIe->offset + offset * i))->
					  num_text;
					pIePresent = ((tDot11fIEChallengeText *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeChanSwitchAnn:
					offset = sizeof(tDot11fIEChanSwitchAnn);
					byteCount = 3;
					pIePresent = ((tDot11fIEChanSwitchAnn *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeChannelSwitchWrapper:
					offset = sizeof(tDot11fIEChannelSwitchWrapper);
					status |=
						dot11f_get_packed_ie_channel_switch_wrapper(
						pCtx, (tDot11fIEChannelSwitchWrapper *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeCountry:
					offset = sizeof(tDot11fIECountry);
					status |=
						dot11f_get_packed_ie_country(
						pCtx, (tDot11fIECountry *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeDSParams:
					offset = sizeof(tDot11fIEDSParams);
					byteCount = 1;
					pIePresent = ((tDot11fIEDSParams *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeEDCAParamSet:
					offset = sizeof(tDot11fIEEDCAParamSet);
					byteCount = 18;
					pIePresent = ((tDot11fIEEDCAParamSet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeERPInfo:
					offset = sizeof(tDot11fIEERPInfo);
					byteCount = 1;
					pIePresent = ((tDot11fIEERPInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESECckmOpaque:
					offset = sizeof(tDot11fIEESECckmOpaque);
					byteCount = ((tDot11fIEESECckmOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEESECckmOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESERadMgmtCap:
					offset = sizeof(tDot11fIEESERadMgmtCap);
					byteCount = 2;
					pIePresent = ((tDot11fIEESERadMgmtCap *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESETrafStrmMet:
					offset = sizeof(tDot11fIEESETrafStrmMet);
					byteCount = 4;
					pIePresent = ((tDot11fIEESETrafStrmMet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESETrafStrmRateSet:
					offset = sizeof(tDot11fIEESETrafStrmRateSet);
					byteCount = ((tDot11fIEESETrafStrmRateSet *)
					  (pFrm + pIe->offset + offset * i))->
					  num_tsrates + 1;
					pIePresent = ((tDot11fIEESETrafStrmRateSet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESETxmitPower:
					offset = sizeof(tDot11fIEESETxmitPower);
					byteCount = 2;
					pIePresent = ((tDot11fIEESETxmitPower *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESEVersion:
					offset = sizeof(tDot11fIEESEVersion);
					byteCount = 1;
					pIePresent = ((tDot11fIEESEVersion *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeESP_information:
					offset = sizeof(tDot11fIEESP_information);
					byteCount = ((tDot11fIEESP_information *)
					  (pFrm + pIe->offset + offset * i))->
					  num_variable_data;
					pIePresent = ((tDot11fIEESP_information *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeExtCap:
					offset = sizeof(tDot11fIEExtCap);
					byteCount = ((tDot11fIEExtCap *)
					  (pFrm + pIe->offset + offset * i))->
					  num_bytes;
					pIePresent = ((tDot11fIEExtCap *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeExtSuppRates:
					offset = sizeof(tDot11fIEExtSuppRates);
					byteCount = ((tDot11fIEExtSuppRates *)
					  (pFrm + pIe->offset + offset * i))->
					  num_rates;
					pIePresent = ((tDot11fIEExtSuppRates *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeFHParamSet:
					offset = sizeof(tDot11fIEFHParamSet);
					byteCount = 5;
					pIePresent = ((tDot11fIEFHParamSet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeFHParams:
					offset = sizeof(tDot11fIEFHParams);
					byteCount = 2;
					pIePresent = ((tDot11fIEFHParams *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeFHPattTable:
					offset = sizeof(tDot11fIEFHPattTable);
					byteCount = ((tDot11fIEFHPattTable *)
					  (pFrm + pIe->offset + offset * i))->
					  num_randtable + 4;
					pIePresent = ((tDot11fIEFHPattTable *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeFTInfo:
					offset = sizeof(tDot11fIEFTInfo);
					status |=
						dot11f_get_packed_ieft_info(
						pCtx, (tDot11fIEFTInfo *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeHTCaps:
					offset = sizeof(tDot11fIEHTCaps);
					byteCount = ((tDot11fIEHTCaps *)
					  (pFrm + pIe->offset + offset * i))->
					  num_rsvd + 26;
					pIePresent = ((tDot11fIEHTCaps *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeHTInfo:
					offset = sizeof(tDot11fIEHTInfo);
					byteCount = ((tDot11fIEHTInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  num_rsvd + 22;
					pIePresent = ((tDot11fIEHTInfo *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeIBSSParams:
					offset = sizeof(tDot11fIEIBSSParams);
					byteCount = 2;
					pIePresent = ((tDot11fIEIBSSParams *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeLinkIdentifier:
					offset = sizeof(tDot11fIELinkIdentifier);
					byteCount = 18;
					pIePresent = ((tDot11fIELinkIdentifier *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeMBO_IE:
					offset = sizeof(tDot11fIEMBO_IE);
					status |=
						dot11f_get_packed_ie_MBO_IE(
						pCtx, (tDot11fIEMBO_IE *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeMeasurementReport:
					offset = sizeof(tDot11fIEMeasurementReport);
					status |=
						dot11f_get_packed_ie_measurement_report(
						pCtx, (tDot11fIEMeasurementReport *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeMeasurementRequest:
					offset = sizeof(tDot11fIEMeasurementRequest);
					status |=
						dot11f_get_packed_ie_measurement_request(
						pCtx, (tDot11fIEMeasurementRequest *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeMobilityDomain:
					offset = sizeof(tDot11fIEMobilityDomain);
					byteCount = 3;
					pIePresent = ((tDot11fIEMobilityDomain *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeNeighborReport:
					offset = sizeof(tDot11fIENeighborReport);
					status |=
						dot11f_get_packed_ie_neighbor_report(
						pCtx, (tDot11fIENeighborReport *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeOBSSScanParameters:
					offset = sizeof(tDot11fIEOBSSScanParameters);
					byteCount = 14;
					pIePresent = ((tDot11fIEOBSSScanParameters *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeOperatingMode:
					offset = sizeof(tDot11fIEOperatingMode);
					byteCount = 1;
					pIePresent = ((tDot11fIEOperatingMode *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeP2PAssocReq:
					offset = sizeof(tDot11fIEP2PAssocReq);
					status |=
						dot11f_get_packed_iep2_p_assoc_req(
						pCtx, (tDot11fIEP2PAssocReq *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PAssocRes:
					offset = sizeof(tDot11fIEP2PAssocRes);
					status |=
						dot11f_get_packed_iep2_p_assoc_res(
						pCtx, (tDot11fIEP2PAssocRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PBeacon:
					offset = sizeof(tDot11fIEP2PBeacon);
					status |=
						dot11f_get_packed_iep2_p_beacon(
						pCtx, (tDot11fIEP2PBeacon *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PBeaconProbeRes:
					offset = sizeof(tDot11fIEP2PBeaconProbeRes);
					status |=
						dot11f_get_packed_iep2_p_beacon_probe_res(
						pCtx, (tDot11fIEP2PBeaconProbeRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PDeAuth:
					offset = sizeof(tDot11fIEP2PDeAuth);
					status |=
						dot11f_get_packed_iep2_p_de_auth(
						pCtx, (tDot11fIEP2PDeAuth *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PDisAssoc:
					offset = sizeof(tDot11fIEP2PDisAssoc);
					status |=
						dot11f_get_packed_iep2_p_dis_assoc(
						pCtx, (tDot11fIEP2PDisAssoc *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PIEOpaque:
					offset = sizeof(tDot11fIEP2PIEOpaque);
					byteCount = ((tDot11fIEP2PIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEP2PIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeP2PProbeReq:
					offset = sizeof(tDot11fIEP2PProbeReq);
					status |=
						dot11f_get_packed_iep2_p_probe_req(
						pCtx, (tDot11fIEP2PProbeReq *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeP2PProbeRes:
					offset = sizeof(tDot11fIEP2PProbeRes);
					status |=
						dot11f_get_packed_iep2_p_probe_res(
						pCtx, (tDot11fIEP2PProbeRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIePTIControl:
					offset = sizeof(tDot11fIEPTIControl);
					byteCount = 3;
					pIePresent = ((tDot11fIEPTIControl *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIePUBufferStatus:
					offset = sizeof(tDot11fIEPUBufferStatus);
					byteCount = 1;
					pIePresent = ((tDot11fIEPUBufferStatus *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIePowerCaps:
					offset = sizeof(tDot11fIEPowerCaps);
					byteCount = 2;
					pIePresent = ((tDot11fIEPowerCaps *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIePowerConstraints:
					offset = sizeof(tDot11fIEPowerConstraints);
					byteCount = 1;
					pIePresent = ((tDot11fIEPowerConstraints *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQBSSLoad:
					offset = sizeof(tDot11fIEQBSSLoad);
					byteCount = 5;
					pIePresent = ((tDot11fIEQBSSLoad *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQCN_IE:
					offset = sizeof(tDot11fIEQCN_IE);
					byteCount = 4;
					pIePresent = ((tDot11fIEQCN_IE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQComVendorIE:
					offset = sizeof(tDot11fIEQComVendorIE);
					byteCount = 2;
					pIePresent = ((tDot11fIEQComVendorIE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQOSCapsAp:
					offset = sizeof(tDot11fIEQOSCapsAp);
					byteCount = 1;
					pIePresent = ((tDot11fIEQOSCapsAp *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQOSCapsStation:
					offset = sizeof(tDot11fIEQOSCapsStation);
					byteCount = 1;
					pIePresent = ((tDot11fIEQOSCapsStation *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQosMapSet:
					offset = sizeof(tDot11fIEQosMapSet);
					byteCount = ((tDot11fIEQosMapSet *)
					  (pFrm + pIe->offset + offset * i))->
					  num_dscp_exceptions;
					pIePresent = ((tDot11fIEQosMapSet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeQuiet:
					offset = sizeof(tDot11fIEQuiet);
					byteCount = 6;
					pIePresent = ((tDot11fIEQuiet *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRCPIIE:
					offset = sizeof(tDot11fIERCPIIE);
					byteCount = 1;
					pIePresent = ((tDot11fIERCPIIE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRICDataDesc:
					offset = sizeof(tDot11fIERICDataDesc);
					pnNeeded -= 2  ; /* Subtract the length and Oui as this is our container IE to group Ies and it doesnt have its own length and OUI. */
					status |=
						dot11f_get_packed_ieric_data_desc(
						pCtx, (tDot11fIERICDataDesc *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeRSN:
					offset = sizeof(tDot11fIERSN);
					status |=
						dot11f_get_packed_iersn(
						pCtx, (tDot11fIERSN *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeRSNIIE:
					offset = sizeof(tDot11fIERSNIIE);
					byteCount = 1;
					pIePresent = ((tDot11fIERSNIIE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeRSNOpaque:
					offset = sizeof(tDot11fIERSNOpaque);
					byteCount = ((tDot11fIERSNOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIERSNOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeSuppChannels:
					offset = sizeof(tDot11fIESuppChannels);
					byteCount = ((tDot11fIESuppChannels *)
					  (pFrm + pIe->offset + offset * i))->
					  num_bands * 2;
					pIePresent = ((tDot11fIESuppChannels *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeSuppOperatingClasses:
					offset = sizeof(tDot11fIESuppOperatingClasses);
					byteCount = ((tDot11fIESuppOperatingClasses *)
					  (pFrm + pIe->offset + offset * i))->
					  num_classes;
					pIePresent = ((tDot11fIESuppOperatingClasses *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeSuppRates:
					offset = sizeof(tDot11fIESuppRates);
					byteCount = ((tDot11fIESuppRates *)
					  (pFrm + pIe->offset + offset * i))->
					  num_rates;
					pIePresent = ((tDot11fIESuppRates *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTIM:
					offset = sizeof(tDot11fIETIM);
					byteCount = ((tDot11fIETIM *)
					  (pFrm + pIe->offset + offset * i))->
					  num_vbmp + 3;
					pIePresent = ((tDot11fIETIM *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTPCReport:
					offset = sizeof(tDot11fIETPCReport);
					byteCount = 2;
					pIePresent = ((tDot11fIETPCReport *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTPCRequest:
					offset = sizeof(tDot11fIETPCRequest);
					byteCount = 0;
					pIePresent = ((tDot11fIETPCRequest *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTimeAdvertisement:
					offset = sizeof(tDot11fIETimeAdvertisement);
					byteCount = 16;
					pIePresent = ((tDot11fIETimeAdvertisement *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeTimeoutInterval:
					offset = sizeof(tDot11fIETimeoutInterval);
					byteCount = 5;
					pIePresent = ((tDot11fIETimeoutInterval *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeVHTExtBssLoad:
					offset = sizeof(tDot11fIEVHTExtBssLoad);
					byteCount = 5;
					pIePresent = ((tDot11fIEVHTExtBssLoad *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeVendor1IE:
					offset = sizeof(tDot11fIEVendor1IE);
					byteCount = 0;
					pIePresent = ((tDot11fIEVendor1IE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeVendor3IE:
					offset = sizeof(tDot11fIEVendor3IE);
					byteCount = 0;
					pIePresent = ((tDot11fIEVendor3IE *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWAPI:
					offset = sizeof(tDot11fIEWAPI);
					status |=
						dot11f_get_packed_iewapi(
						pCtx, (tDot11fIEWAPI *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWAPIOpaque:
					offset = sizeof(tDot11fIEWAPIOpaque);
					byteCount = ((tDot11fIEWAPIOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEWAPIOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWFATPC:
					offset = sizeof(tDot11fIEWFATPC);
					byteCount = 2;
					pIePresent = ((tDot11fIEWFATPC *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWFDIEOpaque:
					offset = sizeof(tDot11fIEWFDIEOpaque);
					byteCount = ((tDot11fIEWFDIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEWFDIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMCaps:
					offset = sizeof(tDot11fIEWMMCaps);
					byteCount = 2;
					pIePresent = ((tDot11fIEWMMCaps *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMInfoAp:
					offset = sizeof(tDot11fIEWMMInfoAp);
					byteCount = 2;
					pIePresent = ((tDot11fIEWMMInfoAp *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMInfoStation:
					offset = sizeof(tDot11fIEWMMInfoStation);
					byteCount = 2;
					pIePresent = ((tDot11fIEWMMInfoStation *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWMMParams:
					offset = sizeof(tDot11fIEWMMParams);
					byteCount = 19;
					pIePresent = ((tDot11fIEWMMParams *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWPA:
					offset = sizeof(tDot11fIEWPA);
					status |=
						dot11f_get_packed_iewpa(
						pCtx, (tDot11fIEWPA *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWPAOpaque:
					offset = sizeof(tDot11fIEWPAOpaque);
					byteCount = ((tDot11fIEWPAOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEWPAOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWSC:
					offset = sizeof(tDot11fIEWSC);
					status |=
						dot11f_get_packed_iewsc(
						pCtx, (tDot11fIEWSC *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscAssocReq:
					offset = sizeof(tDot11fIEWscAssocReq);
					status |=
						dot11f_get_packed_ie_wsc_assoc_req(
						pCtx, (tDot11fIEWscAssocReq *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscAssocRes:
					offset = sizeof(tDot11fIEWscAssocRes);
					status |=
						dot11f_get_packed_ie_wsc_assoc_res(
						pCtx, (tDot11fIEWscAssocRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscBeacon:
					offset = sizeof(tDot11fIEWscBeacon);
					status |=
						dot11f_get_packed_ie_wsc_beacon(
						pCtx, (tDot11fIEWscBeacon *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscBeaconProbeRes:
					offset = sizeof(tDot11fIEWscBeaconProbeRes);
					status |=
						dot11f_get_packed_ie_wsc_beacon_probe_res(
						pCtx, (tDot11fIEWscBeaconProbeRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscIEOpaque:
					offset = sizeof(tDot11fIEWscIEOpaque);
					byteCount = ((tDot11fIEWscIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEWscIEOpaque *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeWscProbeReq:
					offset = sizeof(tDot11fIEWscProbeReq);
					status |=
						dot11f_get_packed_ie_wsc_probe_req(
						pCtx, (tDot11fIEWscProbeReq *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscProbeRes:
					offset = sizeof(tDot11fIEWscProbeRes);
					status |=
						dot11f_get_packed_ie_wsc_probe_res(
						pCtx, (tDot11fIEWscProbeRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeWscReassocRes:
					offset = sizeof(tDot11fIEWscReassocRes);
					status |=
						dot11f_get_packed_ie_wsc_reassoc_res(
						pCtx, (tDot11fIEWscReassocRes *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeext_chan_switch_ann:
					offset = sizeof(tDot11fIEext_chan_switch_ann);
					byteCount = 4;
					pIePresent = ((tDot11fIEext_chan_switch_ann *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_assoc_delay_info:
					offset = sizeof(tDot11fIEfils_assoc_delay_info);
					byteCount = 1;
					pIePresent = ((tDot11fIEfils_assoc_delay_info *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_hlp_container:
					offset = sizeof(tDot11fIEfils_hlp_container);
					byteCount = ((tDot11fIEfils_hlp_container *)
					  (pFrm + pIe->offset + offset * i))->
					  num_hlp_packet + 12;
					pIePresent = ((tDot11fIEfils_hlp_container *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_indication:
					offset = sizeof(tDot11fIEfils_indication);
					byteCount = ((tDot11fIEfils_indication *)
					  (pFrm + pIe->offset + offset * i))->
					  num_variable_data + 2;
					pIePresent = ((tDot11fIEfils_indication *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_kde:
					offset = sizeof(tDot11fIEfils_kde);
					byteCount = ((tDot11fIEfils_kde *)
					  (pFrm + pIe->offset + offset * i))->
					  num_kde_list + 8;
					pIePresent = ((tDot11fIEfils_kde *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_key_confirmation:
					offset = sizeof(tDot11fIEfils_key_confirmation);
					byteCount = ((tDot11fIEfils_key_confirmation *)
					  (pFrm + pIe->offset + offset * i))->
					  num_key_auth;
					pIePresent = ((tDot11fIEfils_key_confirmation *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_nonce:
					offset = sizeof(tDot11fIEfils_nonce);
					byteCount = 16;
					pIePresent = ((tDot11fIEfils_nonce *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_public_key:
					offset = sizeof(tDot11fIEfils_public_key);
					byteCount = ((tDot11fIEfils_public_key *)
					  (pFrm + pIe->offset + offset * i))->
					  num_public_key + 1;
					pIePresent = ((tDot11fIEfils_public_key *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_session:
					offset = sizeof(tDot11fIEfils_session);
					byteCount = 8;
					pIePresent = ((tDot11fIEfils_session *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefils_wrapped_data:
					offset = sizeof(tDot11fIEfils_wrapped_data);
					byteCount = ((tDot11fIEfils_wrapped_data *)
					  (pFrm + pIe->offset + offset * i))->
					  num_wrapped_data;
					pIePresent = ((tDot11fIEfils_wrapped_data *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIefragment_ie:
					offset = sizeof(tDot11fIEfragment_ie);
					byteCount = ((tDot11fIEfragment_ie *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEfragment_ie *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIehs20vendor_ie:
					offset = sizeof(tDot11fIEhs20vendor_ie);
					status |=
						dot11f_get_packed_ie_hs20vendor_ie(
						pCtx, (tDot11fIEhs20vendor_ie *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				case SigIeht2040_bss_coexistence:
					offset = sizeof(tDot11fIEht2040_bss_coexistence);
					byteCount = 1;
					pIePresent = ((tDot11fIEht2040_bss_coexistence *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeht2040_bss_intolerant_report:
					offset = sizeof(tDot11fIEht2040_bss_intolerant_report);
					byteCount = ((tDot11fIEht2040_bss_intolerant_report *)
					  (pFrm + pIe->offset + offset * i))->
					  num_channel_list + 1;
					pIePresent = ((tDot11fIEht2040_bss_intolerant_report *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIeosen_ie:
					offset = sizeof(tDot11fIEosen_ie);
					byteCount = ((tDot11fIEosen_ie *)
					  (pFrm + pIe->offset + offset * i))->
					  num_data;
					pIePresent = ((tDot11fIEosen_ie *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIesec_chan_offset_ele:
					offset = sizeof(tDot11fIEsec_chan_offset_ele);
					byteCount = 1;
					pIePresent = ((tDot11fIEsec_chan_offset_ele *)
					  (pFrm + pIe->offset + offset * i))->
					  present;
					break;
				case SigIevendor_vht_ie:
					offset = sizeof(tDot11fIEvendor_vht_ie);
					status |=
						dot11f_get_packed_ie_vendor_vht_ie(
						pCtx, (tDot11fIEvendor_vht_ie *)
						(pFrm + pIe->offset + offset * i),
						pnNeeded);
					break;
				default:
					FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR-- I don"
						"'t know about the IE signature %d; this is most l"
						"ikely a bug in 'framesc'.\n"), pIe->sig);
					return DOT11F_INTERNAL_ERROR;
				} /*End of switch Case*/

				if (byteCount && pIePresent)
					*pnNeeded += byteCount;
			} /*End of for loop*/
		}
		++pIe;
	}
	return status;

}

static uint32_t get_packed_size_tlv_core(tpAniSirGlobal pCtx,
				uint8_t *pFrm,
				uint32_t *pnNeeded,
				const tTLVDefn  TLVs[])
{
	const tTLVDefn *pTlv;
	uint32_t   status;
	tFRAMES_BOOL   *pfFound;
	uint32_t   byteCount = 0;
	uint8_t    pTlvPresent = 0;

	status = DOT11F_PARSE_SUCCESS;

	pTlv = &(TLVs[0]);
	while (0xffff != pTlv->id) {
		pfFound = (tFRAMES_BOOL *)(pFrm + pTlv->offset +
				pTlv->presenceOffset);
		if (*pfFound) {
			*pnNeeded += (pTlv->sType + pTlv->sLen);
			if (pTlv->pec)
				*pnNeeded += 3U;
			switch (pTlv->sig) {
			case SigTlvAuthorizedMACs:
				byteCount = 6;
				pTlvPresent = ((tDot11fTLVAuthorizedMACs *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvRequestToEnroll:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVRequestToEnroll *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvVersion2:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVVersion2 *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvAPSetupLocked:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVAPSetupLocked *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvAssociationState:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVAssociationState *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvConfigMethods:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVConfigMethods *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvConfigurationError:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVConfigurationError *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvDeviceName:
				byteCount = ((tDot11fTLVDeviceName *)(pFrm + pTlv->offset))->num_text;
				pTlvPresent = ((tDot11fTLVDeviceName *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvDevicePasswordID:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVDevicePasswordID *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvExtendedListenTiming:
				byteCount = 4;
				pTlvPresent = ((tDot11fTLVExtendedListenTiming *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvListenChannel:
				byteCount = 5;
				pTlvPresent = ((tDot11fTLVListenChannel *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvManufacturer:
				byteCount = ((tDot11fTLVManufacturer *)(pFrm + pTlv->offset))->num_name;
				pTlvPresent = ((tDot11fTLVManufacturer *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvMinorReasonCode:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVMinorReasonCode *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvModelName:
				byteCount = ((tDot11fTLVModelName *)(pFrm + pTlv->offset))->num_text;
				pTlvPresent = ((tDot11fTLVModelName *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvModelNumber:
				byteCount = ((tDot11fTLVModelNumber *)(pFrm + pTlv->offset))->num_text;
				pTlvPresent = ((tDot11fTLVModelNumber *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvNoticeOfAbsence:
				byteCount = ((tDot11fTLVNoticeOfAbsence *)(pFrm + pTlv->offset))->num_NoADesc+2;
				pTlvPresent = ((tDot11fTLVNoticeOfAbsence *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvOperatingChannel:
				byteCount = 5;
				pTlvPresent = ((tDot11fTLVOperatingChannel *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PCapability:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVP2PCapability *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PDeviceId:
				byteCount = 6;
				pTlvPresent = ((tDot11fTLVP2PDeviceId *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PDeviceInfo:
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pFrm + pTlv->offset, pnNeeded, TLVS_P2PDeviceInfo);
				byteCount = 16;
				pTlvPresent = ((tDot11fTLVP2PDeviceInfo *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PGroupInfo:
				byteCount = ((tDot11fTLVP2PGroupInfo *)(pFrm + pTlv->offset))->num_P2PClientInfoDesc;
				pTlvPresent = ((tDot11fTLVP2PGroupInfo *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PStatus:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVP2PStatus *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvPrimaryDeviceType:
				byteCount = 8;
				pTlvPresent = ((tDot11fTLVPrimaryDeviceType *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvRFBands:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVRFBands *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvRequestDeviceType:
				byteCount = 8;
				pTlvPresent = ((tDot11fTLVRequestDeviceType *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvRequestType:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVRequestType *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvResponseType:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVResponseType *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvSelectedRegistrar:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVSelectedRegistrar *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvSelectedRegistrarConfigMethods:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVSelectedRegistrarConfigMethods *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvSerialNumber:
				byteCount = ((tDot11fTLVSerialNumber *)(pFrm + pTlv->offset))->num_text;
				pTlvPresent = ((tDot11fTLVSerialNumber *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvUUID_E:
				byteCount = 16;
				pTlvPresent = ((tDot11fTLVUUID_E *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvUUID_R:
				byteCount = 16;
				pTlvPresent = ((tDot11fTLVUUID_R *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvVendorExtension:
		status = get_packed_size_tlv_core(pCtx, (uint8_t *)pFrm + pTlv->offset, pnNeeded, TLVS_VendorExtension);
				byteCount = 3;
				pTlvPresent = ((tDot11fTLVVendorExtension *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvVersion:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVVersion *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvWPSState:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVWPSState *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvassoc_disallowed:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVassoc_disallowed *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvassoc_retry_delay:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVassoc_retry_delay *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvcellular_data_cap:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVcellular_data_cap *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvcellular_data_con_pref:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVcellular_data_con_pref *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvmbo_ap_cap:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVmbo_ap_cap *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvnon_prefferd_chan_rep:
				byteCount = ((tDot11fTLVnon_prefferd_chan_rep *)(pFrm + pTlv->offset))->num_channel_report+1;
				pTlvPresent = ((tDot11fTLVnon_prefferd_chan_rep *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvoce_cap:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVoce_cap *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvreduced_wan_metrics:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVreduced_wan_metrics *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvrssi_assoc_rej:
				byteCount = 2;
				pTlvPresent = ((tDot11fTLVrssi_assoc_rej *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvtransition_reason:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVtransition_reason *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvtransition_reject_reason:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVtransition_reject_reason *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PInterface:
				byteCount = 6;
				pTlvPresent = ((tDot11fTLVP2PInterface *)
					      (pFrm + pTlv->offset))->present;
				break;
			case SigTlvP2PManageability:
				byteCount = 1;
				pTlvPresent = ((tDot11fTLVP2PManageability *)
					      (pFrm + pTlv->offset))->present;
				break;
			default:
				FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR-- I don"
				    "'t know about the TLV signature %d; this is most l"
				    "ikely a bug in 'framesc'.\n"), pTlv->sig);
				return DOT11F_INTERNAL_ERROR;
			}
			if (pTlvPresent) {
				*pnNeeded += byteCount;
			}
		}
		++pTlv;
	}
	return status;
}
void dot11f_pack_ff_aid(tpAniSirGlobal pCtx,
			tDot11fFfAID *pSrc,
			uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->associd, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_aid. */

void dot11f_pack_ff_action(tpAniSirGlobal pCtx,
			   tDot11fFfAction *pSrc,
			   uint8_t *pBuf)
{
	*pBuf = pSrc->action;
	(void)pCtx;
} /* End dot11f_pack_ff_action. */

void dot11f_pack_ff_auth_algo(tpAniSirGlobal pCtx,
			     tDot11fFfAuthAlgo *pSrc,
			     uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->algo, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_auth_algo. */

void dot11f_pack_ff_auth_seq_no(tpAniSirGlobal pCtx,
			      tDot11fFfAuthSeqNo *pSrc,
			      uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->no, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_auth_seq_no. */

void dot11f_pack_ff_beacon_interval(tpAniSirGlobal pCtx,
				   tDot11fFfBeaconInterval *pSrc,
				   uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->interval, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_beacon_interval. */

void dot11f_pack_ff_capabilities(tpAniSirGlobal pCtx,
				 tDot11fFfCapabilities *pSrc,
				 uint8_t *pBuf)
{
	uint16_t tmp73__;
	tmp73__ = 0U;
	tmp73__ |= (pSrc->ess << 0);
	tmp73__ |= (pSrc->ibss << 1);
	tmp73__ |= (pSrc->cfPollable << 2);
	tmp73__ |= (pSrc->cfPollReq << 3);
	tmp73__ |= (pSrc->privacy << 4);
	tmp73__ |= (pSrc->shortPreamble << 5);
	tmp73__ |= (pSrc->pbcc << 6);
	tmp73__ |= (pSrc->channelAgility << 7);
	tmp73__ |= (pSrc->spectrumMgt << 8);
	tmp73__ |= (pSrc->qos << 9);
	tmp73__ |= (pSrc->shortSlotTime << 10);
	tmp73__ |= (pSrc->apsd << 11);
	tmp73__ |= (pSrc->rrm << 12);
	tmp73__ |= (pSrc->dsssOfdm << 13);
	tmp73__ |= (pSrc->delayedBA << 14);
	tmp73__ |= (pSrc->immediateBA << 15);
	frameshtons(pCtx, pBuf, tmp73__, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_capabilities. */

void dot11f_pack_ff_category(tpAniSirGlobal pCtx,
			     tDot11fFfCategory *pSrc,
			     uint8_t *pBuf)
{
	*pBuf = pSrc->category;
	(void)pCtx;
} /* End dot11f_pack_ff_category. */

void dot11f_pack_ff_current_ap_address(tpAniSirGlobal pCtx,
				     tDot11fFfCurrentAPAddress *pSrc,
				     uint8_t *pBuf)
{
	DOT11F_MEMCPY(pCtx, pBuf, pSrc->mac, 6);
	(void)pCtx;
} /* End dot11f_pack_ff_current_ap_address. */

void dot11f_pack_ff_dialog_token(tpAniSirGlobal pCtx,
				tDot11fFfDialogToken *pSrc,
				uint8_t *pBuf)
{
	*pBuf = pSrc->token;
	(void)pCtx;
} /* End dot11f_pack_ff_dialog_token. */

void dot11f_pack_ff_link_margin(tpAniSirGlobal pCtx,
			       tDot11fFfLinkMargin *pSrc,
			       uint8_t *pBuf)
{
	*pBuf = pSrc->linkMargin;
	(void)pCtx;
} /* End dot11f_pack_ff_link_margin. */

void dot11f_pack_ff_listen_interval(tpAniSirGlobal pCtx,
				   tDot11fFfListenInterval *pSrc,
				   uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->interval, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_listen_interval. */

void dot11f_pack_ff_max_tx_power(tpAniSirGlobal pCtx,
			       tDot11fFfMaxTxPower *pSrc,
			       uint8_t *pBuf)
{
	*pBuf = pSrc->maxTxPower;
	(void)pCtx;
} /* End dot11f_pack_ff_max_tx_power. */

void dot11f_pack_ff_num_of_repetitions(tpAniSirGlobal pCtx,
				     tDot11fFfNumOfRepetitions *pSrc,
				     uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->repetitions, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_num_of_repetitions. */

void dot11f_pack_ff_operating_mode(tpAniSirGlobal pCtx,
				  tDot11fFfOperatingMode *pSrc,
				  uint8_t *pBuf)
{
	uint8_t tmp74__;
	tmp74__ = 0U;
	tmp74__ |= (pSrc->chanWidth << 0);
	tmp74__ |= (pSrc->reserved << 2);
	tmp74__ |= (pSrc->rxNSS << 4);
	tmp74__ |= (pSrc->rxNSSType << 7);
	*pBuf = tmp74__;
	(void)pCtx;
} /* End dot11f_pack_ff_operating_mode. */

void dot11f_pack_ff_rcpi(tpAniSirGlobal pCtx,
			 tDot11fFfRCPI *pSrc,
			 uint8_t *pBuf)
{
	*pBuf = pSrc->rcpi;
	(void)pCtx;
} /* End dot11f_pack_ff_rcpi. */

void dot11f_pack_ff_rsni(tpAniSirGlobal pCtx,
			 tDot11fFfRSNI *pSrc,
			 uint8_t *pBuf)
{
	*pBuf = pSrc->rsni;
	(void)pCtx;
} /* End dot11f_pack_ff_rsni. */

void dot11f_pack_ff_reason(tpAniSirGlobal pCtx,
			   tDot11fFfReason *pSrc,
			   uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->code, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_reason. */

void dot11f_pack_ff_rx_antenna_id(tpAniSirGlobal pCtx,
				tDot11fFfRxAntennaId *pSrc,
				uint8_t *pBuf)
{
	*pBuf = pSrc->antennaId;
	(void)pCtx;
} /* End dot11f_pack_ff_rx_antenna_id. */

void dot11f_pack_ff_sm_power_mode_set(tpAniSirGlobal pCtx,
				   tDot11fFfSMPowerModeSet *pSrc,
				   uint8_t *pBuf)
{
	uint8_t tmp75__;
	tmp75__ = 0U;
	tmp75__ |= (pSrc->PowerSave_En << 0);
	tmp75__ |= (pSrc->Mode << 1);
	tmp75__ |= (pSrc->reserved << 2);
	*pBuf = tmp75__;
	(void)pCtx;
} /* End dot11f_pack_ff_sm_power_mode_set. */

void dot11f_pack_ff_status(tpAniSirGlobal pCtx,
			   tDot11fFfStatus *pSrc,
			   uint8_t *pBuf)
{
	frameshtons(pCtx, pBuf, pSrc->status, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_status. */

void dot11f_pack_ff_status_code(tpAniSirGlobal pCtx,
			       tDot11fFfStatusCode *pSrc,
			       uint8_t *pBuf)
{
	*pBuf = pSrc->statusCode;
	(void)pCtx;
} /* End dot11f_pack_ff_status_code. */

void dot11f_pack_ff_tpc_ele_id(tpAniSirGlobal pCtx,
			     tDot11fFfTPCEleID *pSrc,
			     uint8_t *pBuf)
{
	*pBuf = pSrc->TPCId;
	(void)pCtx;
} /* End dot11f_pack_ff_tpc_ele_id. */

void dot11f_pack_ff_tpc_ele_len(tpAniSirGlobal pCtx,
			      tDot11fFfTPCEleLen *pSrc,
			      uint8_t *pBuf)
{
	*pBuf = pSrc->TPCLen;
	(void)pCtx;
} /* End dot11f_pack_ff_tpc_ele_len. */

void dot11f_pack_ff_ts_info(tpAniSirGlobal pCtx,
			   tDot11fFfTSInfo *pSrc,
			   uint8_t *pBuf)
{
	uint32_t tmp76__;
	tmp76__ = 0U;
	tmp76__ |= (pSrc->traffic_type << 0);
	tmp76__ |= (pSrc->tsid << 1);
	tmp76__ |= (pSrc->direction << 5);
	tmp76__ |= (pSrc->access_policy << 7);
	tmp76__ |= (pSrc->aggregation << 9);
	tmp76__ |= (pSrc->psb << 10);
	tmp76__ |= (pSrc->user_priority << 11);
	tmp76__ |= (pSrc->tsinfo_ack_pol << 14);
	tmp76__ |= (pSrc->schedule << 16);
	tmp76__ |= (pSrc->unused << 17);
	frameshtonl(pCtx, pBuf, tmp76__, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_ts_info. */

void dot11f_pack_ff_time_stamp(tpAniSirGlobal pCtx,
			      tDot11fFfTimeStamp *pSrc,
			      uint8_t *pBuf)
{
	frameshtonq(pCtx, pBuf, pSrc->timestamp, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_time_stamp. */

void dot11f_pack_ff_transaction_id(tpAniSirGlobal pCtx,
				  tDot11fFfTransactionId *pSrc,
				  uint8_t *pBuf)
{
	DOT11F_MEMCPY(pCtx, pBuf, pSrc->transId, 2);
	(void)pCtx;
} /* End dot11f_pack_ff_transaction_id. */

void dot11f_pack_ff_tx_antenna_id(tpAniSirGlobal pCtx,
				tDot11fFfTxAntennaId *pSrc,
				uint8_t *pBuf)
{
	*pBuf = pSrc->antennaId;
	(void)pCtx;
} /* End dot11f_pack_ff_tx_antenna_id. */

void dot11f_pack_ff_tx_power(tpAniSirGlobal pCtx,
			    tDot11fFfTxPower *pSrc,
			    uint8_t *pBuf)
{
	*pBuf = pSrc->txPower;
	(void)pCtx;
} /* End dot11f_pack_ff_tx_power. */

void dot11f_pack_ff_vht_membership_status_array(tpAniSirGlobal pCtx,
					     tDot11fFfVhtMembershipStatusArray *pSrc,
					     uint8_t *pBuf)
{
	DOT11F_MEMCPY(pCtx, pBuf, pSrc->membershipStatusArray, 8);
	(void)pCtx;
} /* End dot11f_pack_ff_vht_membership_status_array. */

void dot11f_pack_ff_vht_user_position_array(tpAniSirGlobal pCtx,
					 tDot11fFfVhtUserPositionArray *pSrc,
					 uint8_t *pBuf)
{
	DOT11F_MEMCPY(pCtx, pBuf, pSrc->userPositionArray, 16);
	(void)pCtx;
} /* End dot11f_pack_ff_vht_user_position_array. */

void dot11f_pack_ff_ext_chan_switch_ann_action(tpAniSirGlobal pCtx,
					       tDot11fFfext_chan_switch_ann_action *pSrc,
					       uint8_t *pBuf)
{
	uint32_t tmp77__;
	tmp77__ = 0U;
	tmp77__ |= (pSrc->switch_mode << 0);
	tmp77__ |= (pSrc->op_class << 8);
	tmp77__ |= (pSrc->new_channel << 16);
	tmp77__ |= (pSrc->switch_count << 24);
	frameshtonl(pCtx, pBuf, tmp77__, 0);
	(void)pCtx;
} /* End dot11f_pack_ff_ext_chan_switch_ann_action. */

void dot11f_pack_ff_p2p_action_oui(tpAniSirGlobal pCtx,
				   tDot11fFfp2p_action_oui *pSrc,
				   uint8_t *pBuf)
{
	DOT11F_MEMCPY(pCtx, pBuf, pSrc->oui_data, 4);
	(void)pCtx;
} /* End dot11f_pack_ff_p2p_action_oui. */

void dot11f_pack_ff_p2p_action_subtype(tpAniSirGlobal pCtx,
				       tDot11fFfp2p_action_subtype *pSrc,
				       uint8_t *pBuf)
{
	*pBuf = pSrc->subtype;
	(void)pCtx;
} /* End dot11f_pack_ff_p2p_action_subtype. */

uint32_t dot11f_pack_tlv_authorized_ma_cs(tpAniSirGlobal pCtx,
					tDot11fTLVAuthorizedMACs *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 8;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 1;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->mac, 6);
		*pnConsumed += 6;
		pBuf += 6;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_authorized_ma_cs. */

uint32_t dot11f_pack_tlv_request_to_enroll(tpAniSirGlobal pCtx,
					 tDot11fTLVRequestToEnroll *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 3;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->req;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_request_to_enroll. */

uint32_t dot11f_pack_tlv_version2(tpAniSirGlobal pCtx,
				  tDot11fTLVVersion2 *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp78__;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 0;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		tmp78__ = 0U;
		tmp78__ |= (pSrc->minor << 0);
		tmp78__ |= (pSrc->major << 4);
		*pBuf = tmp78__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_version2. */

uint32_t dot11f_pack_tlv_ap_setup_locked(tpAniSirGlobal pCtx,
				       tDot11fTLVAPSetupLocked *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4183, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->fLocked;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_ap_setup_locked. */

uint32_t dot11f_pack_tlv_association_state(tpAniSirGlobal pCtx,
					  tDot11fTLVAssociationState *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 6;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4098, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->state, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_association_state. */

uint32_t dot11f_pack_tlv_config_methods(tpAniSirGlobal pCtx,
				       tDot11fTLVConfigMethods *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 6;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4104, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->methods, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_config_methods. */

uint32_t dot11f_pack_tlv_configuration_error(tpAniSirGlobal pCtx,
					    tDot11fTLVConfigurationError *pSrc,
					    uint8_t *pBuf,
					    uint32_t nBuf,
					    uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 6;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4105, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->error, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_configuration_error. */

uint32_t dot11f_pack_tlv_device_name(tpAniSirGlobal pCtx,
				    tDot11fTLVDeviceName *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_text + 4) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4113, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->text), pSrc->num_text);
		*pnConsumed += pSrc->num_text;
		pBuf += pSrc->num_text;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_device_name. */

uint32_t dot11f_pack_tlv_device_password_id(tpAniSirGlobal pCtx,
					  tDot11fTLVDevicePasswordID *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 6;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4114, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->id, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_device_password_id. */

uint32_t dot11f_pack_tlv_extended_listen_timing(tpAniSirGlobal pCtx,
					      tDot11fTLVExtendedListenTiming *pSrc,
					      uint8_t *pBuf,
					      uint32_t nBuf,
					      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 7;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 8;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->availibilityPeriod, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->availibilityInterval, 0);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_extended_listen_timing. */

uint32_t dot11f_pack_tlv_listen_channel(tpAniSirGlobal pCtx,
				       tDot11fTLVListenChannel *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 8;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 6;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->countryString, 3);
		*pnConsumed += 3;
		pBuf += 3;
		*pBuf = pSrc->regulatoryClass;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->channel;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_listen_channel. */

uint32_t dot11f_pack_tlv_manufacturer(tpAniSirGlobal pCtx,
				      tDot11fTLVManufacturer *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_name + 4) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4129, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->name), pSrc->num_name);
		*pnConsumed += pSrc->num_name;
		pBuf += pSrc->num_name;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_manufacturer. */

uint32_t dot11f_pack_tlv_minor_reason_code(tpAniSirGlobal pCtx,
					 tDot11fTLVMinorReasonCode *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 4;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 1;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->minorReasonCode;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_minor_reason_code. */

uint32_t dot11f_pack_tlv_model_name(tpAniSirGlobal pCtx,
				   tDot11fTLVModelName *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_text + 4) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4131, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->text), pSrc->num_text);
		*pnConsumed += pSrc->num_text;
		pBuf += pSrc->num_text;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_model_name. */

uint32_t dot11f_pack_tlv_model_number(tpAniSirGlobal pCtx,
				     tDot11fTLVModelNumber *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_text + 4) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4132, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->text), pSrc->num_text);
		*pnConsumed += pSrc->num_text;
		pBuf += pSrc->num_text;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_model_number. */

uint32_t dot11f_pack_tlv_notice_of_absence(tpAniSirGlobal pCtx,
					 tDot11fTLVNoticeOfAbsence *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_NoADesc + 5) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 12;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->index;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->CTSWindowOppPS;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->NoADesc), pSrc->num_NoADesc);
		*pnConsumed += pSrc->num_NoADesc;
		pBuf += pSrc->num_NoADesc;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_notice_of_absence. */

uint32_t dot11f_pack_tlv_operating_channel(tpAniSirGlobal pCtx,
					  tDot11fTLVOperatingChannel *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 8;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 17;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->countryString, 3);
		*pnConsumed += 3;
		pBuf += 3;
		*pBuf = pSrc->regulatoryClass;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->channel;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_operating_channel. */

uint32_t dot11f_pack_tlv_p2_p_capability(tpAniSirGlobal pCtx,
				       tDot11fTLVP2PCapability *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 2;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->deviceCapability;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->groupCapability;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_capability. */

uint32_t dot11f_pack_tlv_p2_p_device_id(tpAniSirGlobal pCtx,
				     tDot11fTLVP2PDeviceId *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 9;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 3;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->P2PDeviceAddress, 6);
		*pnConsumed += 6;
		pBuf += 6;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_device_id. */

uint32_t dot11f_pack_tlv_p2_p_device_info(tpAniSirGlobal pCtx,
				       tDot11fTLVP2PDeviceInfo *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	uint32_t idx = 0;
	nNeeded += 19;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 13;
		pBuf += 1; nBuf -= 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; nBuf -= 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->P2PDeviceAddress, 6);
		*pnConsumed += 6;
		pBuf += 6;
		frameshtons(pCtx, pBuf, pSrc->configMethod, 1);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->primaryDeviceType, 8);
		*pnConsumed += 8;
		pBuf += 8;
		status |= pack_tlv_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				TLVS_P2PDeviceInfo, &idx);
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return status;
} /* End dot11f_pack_tlv_p2_p_device_info. */

uint32_t dot11f_pack_tlv_p2_p_group_info(tpAniSirGlobal pCtx,
				      tDot11fTLVP2PGroupInfo *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_P2PClientInfoDesc + 3) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 14;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->P2PClientInfoDesc), pSrc->num_P2PClientInfoDesc);
		*pnConsumed += pSrc->num_P2PClientInfoDesc;
		pBuf += pSrc->num_P2PClientInfoDesc;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_group_info. */

uint32_t dot11f_pack_tlv_p2_p_status(tpAniSirGlobal pCtx,
				   tDot11fTLVP2PStatus *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 4;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 0;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->status;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_status. */

uint32_t dot11f_pack_tlv_primary_device_type(tpAniSirGlobal pCtx,
					   tDot11fTLVPrimaryDeviceType *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 12;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4180, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->primary_category, 1);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->oui, 4);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->sub_category, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_primary_device_type. */

uint32_t dot11f_pack_tlv_rf_bands(tpAniSirGlobal pCtx,
				 tDot11fTLVRFBands *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4156, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->bands;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_rf_bands. */

uint32_t dot11f_pack_tlv_request_device_type(tpAniSirGlobal pCtx,
					   tDot11fTLVRequestDeviceType *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 12;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4202, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->primary_category, 1);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->oui, 4);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->sub_category, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_request_device_type. */

uint32_t dot11f_pack_tlv_request_type(tpAniSirGlobal pCtx,
				     tDot11fTLVRequestType *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4154, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->reqType;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_request_type. */

uint32_t dot11f_pack_tlv_response_type(tpAniSirGlobal pCtx,
				      tDot11fTLVResponseType *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4155, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->resType;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_response_type. */

uint32_t dot11f_pack_tlv_selected_registrar(tpAniSirGlobal pCtx,
					   tDot11fTLVSelectedRegistrar *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4161, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->selected;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_selected_registrar. */

uint32_t dot11f_pack_tlv_selected_registrar_config_methods(tpAniSirGlobal pCtx,
							tDot11fTLVSelectedRegistrarConfigMethods *pSrc,
							uint8_t *pBuf,
							uint32_t nBuf,
							uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 6;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4179, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		frameshtons(pCtx, pBuf, pSrc->methods, 1);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_selected_registrar_config_methods. */

uint32_t dot11f_pack_tlv_serial_number(tpAniSirGlobal pCtx,
				      tDot11fTLVSerialNumber *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_text + 4) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4162, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->text), pSrc->num_text);
		*pnConsumed += pSrc->num_text;
		pBuf += pSrc->num_text;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_serial_number. */

uint32_t dot11f_pack_tlv_uuid_e(tpAniSirGlobal pCtx,
				tDot11fTLVUUID_E *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 20;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4167, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->uuid, 16);
		*pnConsumed += 16;
		pBuf += 16;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_uuid_e. */

uint32_t dot11f_pack_tlv_uuid_r(tpAniSirGlobal pCtx,
				tDot11fTLVUUID_R *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 20;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4168, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->uuid, 16);
		*pnConsumed += 16;
		pBuf += 16;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_uuid_r. */

uint32_t dot11f_pack_tlv_vendor_extension(tpAniSirGlobal pCtx,
					 tDot11fTLVVendorExtension *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	uint32_t idx = 0;
	nNeeded += 7;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4169, 1);
		pBuf += 2; nBuf -= 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; nBuf -= 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->vendorId, 3);
		*pnConsumed += 3;
		pBuf += 3;
		status |= pack_tlv_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				TLVS_VendorExtension, &idx);
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return status;
} /* End dot11f_pack_tlv_vendor_extension. */

uint32_t dot11f_pack_tlv_version(tpAniSirGlobal pCtx,
				 tDot11fTLVVersion *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp79__;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4170, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		tmp79__ = 0U;
		tmp79__ |= (pSrc->minor << 0);
		tmp79__ |= (pSrc->major << 4);
		*pBuf = tmp79__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_version. */

uint32_t dot11f_pack_tlv_wps_state(tpAniSirGlobal pCtx,
				  tDot11fTLVWPSState *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 5;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		frameshtons(pCtx, pBuf, 4164, 1);
		pBuf += 2; *pnConsumed += 2;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->state;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 4, 1);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_wps_state. */

uint32_t dot11f_pack_tlv_assoc_disallowed(tpAniSirGlobal pCtx,
					  tDot11fTLVassoc_disallowed *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 4;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->reason_code;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_assoc_disallowed. */

uint32_t dot11f_pack_tlv_assoc_retry_delay(tpAniSirGlobal pCtx,
					   tDot11fTLVassoc_retry_delay *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 4;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 8;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		frameshtons(pCtx, pBuf, pSrc->delay, 0);
		*pnConsumed += 2;
		pBuf += 2;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_assoc_retry_delay. */

uint32_t dot11f_pack_tlv_cellular_data_cap(tpAniSirGlobal pCtx,
					   tDot11fTLVcellular_data_cap *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 3;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->cellular_connectivity;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_cellular_data_cap. */

uint32_t dot11f_pack_tlv_cellular_data_con_pref(tpAniSirGlobal pCtx,
						tDot11fTLVcellular_data_con_pref *pSrc,
						uint8_t *pBuf,
						uint32_t nBuf,
						uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 5;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->cellular_preference;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_cellular_data_con_pref. */

uint32_t dot11f_pack_tlv_mbo_ap_cap(tpAniSirGlobal pCtx,
				    tDot11fTLVmbo_ap_cap *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 1;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->mbo_cap_ind;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_mbo_ap_cap. */

uint32_t dot11f_pack_tlv_non_prefferd_chan_rep(tpAniSirGlobal pCtx,
					       tDot11fTLVnon_prefferd_chan_rep *pSrc,
					       uint8_t *pBuf,
					       uint32_t nBuf,
					       uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += (pSrc->num_channel_report + 3) ;

	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 2;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->oper_class;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->channel_report), pSrc->num_channel_report);
		*pnConsumed += pSrc->num_channel_report;
		pBuf += pSrc->num_channel_report;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_non_prefferd_chan_rep. */

uint32_t dot11f_pack_tlv_oce_cap(tpAniSirGlobal pCtx,
				 tDot11fTLVoce_cap *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp80__;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 101;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		tmp80__ = 0U;
		tmp80__ |= (pSrc->oce_release << 0);
		tmp80__ |= (pSrc->is_sta_cfon << 3);
		tmp80__ |= (pSrc->non_oce_ap_present << 4);
		tmp80__ |= (pSrc->reserved << 5);
		*pBuf = tmp80__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_oce_cap. */

uint32_t dot11f_pack_tlv_reduced_wan_metrics(tpAniSirGlobal pCtx,
					     tDot11fTLVreduced_wan_metrics *pSrc,
					     uint8_t *pBuf,
					     uint32_t nBuf,
					     uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp81__;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 103;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		tmp81__ = 0U;
		tmp81__ |= (pSrc->downlink_av_cap << 0);
		tmp81__ |= (pSrc->uplink_av_cap << 4);
		*pBuf = tmp81__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_reduced_wan_metrics. */

uint32_t dot11f_pack_tlv_rssi_assoc_rej(tpAniSirGlobal pCtx,
					tDot11fTLVrssi_assoc_rej *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 4;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 102;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->delta_rssi;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->retry_delay;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_rssi_assoc_rej. */

uint32_t dot11f_pack_tlv_transition_reason(tpAniSirGlobal pCtx,
					   tDot11fTLVtransition_reason *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 6;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->transition_reason_code;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_transition_reason. */

uint32_t dot11f_pack_tlv_transition_reject_reason(tpAniSirGlobal pCtx,
						  tDot11fTLVtransition_reject_reason *pSrc,
						  uint8_t *pBuf,
						  uint32_t nBuf,
						  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 3;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 7;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 1; *pnConsumed += 1;
		*pBuf = pSrc->transition_reject_code;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		*pTlvLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_transition_reject_reason. */

uint32_t dot11f_pack_tlv_p2_p_interface(tpAniSirGlobal pCtx,
				      tDot11fTLVP2PInterface *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 9;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 16;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->P2PDeviceAddress, 6);
		*pnConsumed += 6;
		pBuf += 6;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_interface. */

uint32_t dot11f_pack_tlv_p2_p_manageability(tpAniSirGlobal pCtx,
					  tDot11fTLVP2PManageability *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pTlvLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded += 4;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	while (pSrc->present) {
		*pBuf = 10;
		pBuf += 1; *pnConsumed += 1;
		pTlvLen = pBuf;
		pBuf += 2; *pnConsumed += 2;
		*pBuf = pSrc->manageability;
		*pnConsumed += 1;
		pBuf += 1;
		break;
	}
	(void)pCtx;
	if (pTlvLen) {
		frameshtons(pCtx, pTlvLen, *pnConsumed - nConsumedOnEntry - 3, 0);
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_tlv_p2_p_manageability. */

uint32_t dot11f_pack_ie_gtk(tpAniSirGlobal pCtx,
			    tDot11fIEGTK *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp82__;
	nNeeded  +=  (pSrc->num_key + 11);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 2;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp82__ = 0U;
		tmp82__ |= (pSrc->keyId << 0);
		tmp82__ |= (pSrc->reserved << 2);
		frameshtons(pCtx, pBuf, tmp82__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		*pBuf = pSrc->keyLength;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->RSC, 8);
		*pnConsumed += 8;
		pBuf += 8;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->key), pSrc->num_key);
		*pnConsumed += pSrc->num_key;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_gtk. */

uint32_t dot11f_pack_ie_igtk(tpAniSirGlobal pCtx,
			     tDot11fIEIGTK *pSrc,
			     uint8_t *pBuf,
			     uint32_t nBuf,
			     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 33;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 4;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->keyID, 2);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->IPN, 6);
		*pnConsumed += 6;
		pBuf += 6;
		*pBuf = pSrc->keyLength;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->key, 24);
		*pnConsumed += 24;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_igtk. */

uint32_t dot11f_pack_ie_r0_kh_id(tpAniSirGlobal pCtx,
				tDot11fIER0KH_ID *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_PMK_R0_ID;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 3;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->PMK_R0_ID), pSrc->num_PMK_R0_ID);
		*pnConsumed += pSrc->num_PMK_R0_ID;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_r0_kh_id. */

uint32_t dot11f_pack_ie_r1_kh_id(tpAniSirGlobal pCtx,
				tDot11fIER1KH_ID *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 6;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->PMK_R1_ID, 6);
		*pnConsumed += 6;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_r1_kh_id. */

uint32_t dot11f_pack_ie_ap_channel_report(tpAniSirGlobal pCtx,
					tDot11fIEAPChannelReport *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_channelList + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 51;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->regulatoryClass;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->channelList), pSrc->num_channelList);
		*pnConsumed += pSrc->num_channelList;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ap_channel_report. */

uint32_t dot11f_pack_ie_bcn_reporting_detail(tpAniSirGlobal pCtx,
					   tDot11fIEBcnReportingDetail *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 2;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->reportingDetail;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_bcn_reporting_detail. */

uint32_t dot11f_pack_ie_beacon_report_frm_body(tpAniSirGlobal pCtx,
					    tDot11fIEBeaconReportFrmBody *pSrc,
					    uint8_t *pBuf,
					    uint32_t nBuf,
					    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_reportedFields;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->reportedFields), pSrc->num_reportedFields);
		*pnConsumed += pSrc->num_reportedFields;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_beacon_report_frm_body. */

uint32_t dot11f_pack_ie_beacon_reporting(tpAniSirGlobal pCtx,
					tDot11fIEBeaconReporting *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->reportingCondition;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->threshold;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_beacon_reporting. */

uint32_t dot11f_pack_ie_condensed_country_str(tpAniSirGlobal pCtx,
					    tDot11fIECondensedCountryStr *pSrc,
					    uint8_t *pBuf,
					    uint32_t nBuf,
					    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 2;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->countryStr, 2);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_condensed_country_str. */

uint32_t dot11f_pack_ie_measurement_pilot(tpAniSirGlobal pCtx,
					 tDot11fIEMeasurementPilot *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_vendorSpecific + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 66;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->measurementPilot;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->vendorSpecific), pSrc->num_vendorSpecific);
		*pnConsumed += pSrc->num_vendorSpecific;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_measurement_pilot. */

uint32_t dot11f_pack_ie_multi_bssid(tpAniSirGlobal pCtx,
				   tDot11fIEMultiBssid *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_vendorSpecific + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 71;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->maxBSSIDIndicator;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->vendorSpecific), pSrc->num_vendorSpecific);
		*pnConsumed += pSrc->num_vendorSpecific;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_multi_bssid. */

uint32_t dot11f_pack_ie_ric_data(tpAniSirGlobal pCtx,
				tDot11fIERICData *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 57;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->Identifier;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->resourceDescCount;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->statusCode, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ric_data. */

uint32_t dot11f_pack_ie_ric_descriptor(tpAniSirGlobal pCtx,
				      tDot11fIERICDescriptor *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_variableData + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 75;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->resourceType;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->variableData), pSrc->num_variableData);
		*pnConsumed += pSrc->num_variableData;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ric_descriptor. */

uint32_t dot11f_pack_ie_rrm_enabled_cap(tpAniSirGlobal pCtx,
				      tDot11fIERRMEnabledCap *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp83__;
	uint8_t tmp84__;
	uint8_t tmp85__;
	uint8_t tmp86__;
	uint8_t tmp87__;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 70;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp83__ = 0U;
		tmp83__ |= (pSrc->LinkMeasurement << 0);
		tmp83__ |= (pSrc->NeighborRpt << 1);
		tmp83__ |= (pSrc->parallel << 2);
		tmp83__ |= (pSrc->repeated << 3);
		tmp83__ |= (pSrc->BeaconPassive << 4);
		tmp83__ |= (pSrc->BeaconActive << 5);
		tmp83__ |= (pSrc->BeaconTable << 6);
		tmp83__ |= (pSrc->BeaconRepCond << 7);
		*pBuf = tmp83__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp84__ = 0U;
		tmp84__ |= (pSrc->FrameMeasurement << 0);
		tmp84__ |= (pSrc->ChannelLoad << 1);
		tmp84__ |= (pSrc->NoiseHistogram << 2);
		tmp84__ |= (pSrc->statistics << 3);
		tmp84__ |= (pSrc->LCIMeasurement << 4);
		tmp84__ |= (pSrc->LCIAzimuth << 5);
		tmp84__ |= (pSrc->TCMCapability << 6);
		tmp84__ |= (pSrc->triggeredTCM << 7);
		*pBuf = tmp84__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp85__ = 0U;
		tmp85__ |= (pSrc->APChanReport << 0);
		tmp85__ |= (pSrc->RRMMIBEnabled << 1);
		tmp85__ |= (pSrc->operatingChanMax << 2);
		tmp85__ |= (pSrc->nonOperatinChanMax << 5);
		*pBuf = tmp85__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp86__ = 0U;
		tmp86__ |= (pSrc->MeasurementPilot << 0);
		tmp86__ |= (pSrc->MeasurementPilotEnabled << 3);
		tmp86__ |= (pSrc->NeighborTSFOffset << 4);
		tmp86__ |= (pSrc->RCPIMeasurement << 5);
		tmp86__ |= (pSrc->RSNIMeasurement << 6);
		tmp86__ |= (pSrc->BssAvgAccessDelay << 7);
		*pBuf = tmp86__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp87__ = 0U;
		tmp87__ |= (pSrc->BSSAvailAdmission << 0);
		tmp87__ |= (pSrc->AntennaInformation << 1);
		tmp87__ |= (pSrc->fine_time_meas_rpt << 2);
		tmp87__ |= (pSrc->lci_capability << 3);
		tmp87__ |= (pSrc->reserved << 4);
		*pBuf = tmp87__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_rrm_enabled_cap. */

uint32_t dot11f_pack_ie_requested_info(tpAniSirGlobal pCtx,
				      tDot11fIERequestedInfo *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_requested_eids;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 10;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->requested_eids), pSrc->num_requested_eids);
		*pnConsumed += pSrc->num_requested_eids;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_requested_info. */

uint32_t dot11f_pack_ie_ssid(tpAniSirGlobal pCtx,
			     tDot11fIESSID *pSrc,
			     uint8_t *pBuf,
			     uint32_t nBuf,
			     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_ssid;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 0;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->ssid), pSrc->num_ssid);
		*pnConsumed += pSrc->num_ssid;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ssid. */

uint32_t dot11f_pack_ie_schedule(tpAniSirGlobal pCtx,
				 tDot11fIESchedule *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp88__;
	nNeeded  += 14;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 15;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp88__ = 0U;
		tmp88__ |= (pSrc->aggregation << 0);
		tmp88__ |= (pSrc->tsid << 1);
		tmp88__ |= (pSrc->direction << 5);
		tmp88__ |= (pSrc->reserved << 7);
		frameshtons(pCtx, pBuf, tmp88__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		frameshtonl(pCtx, pBuf, pSrc->service_start_time, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->service_interval, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->max_service_dur, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->spec_interval, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_schedule. */

uint32_t dot11f_pack_ie_tclas(tpAniSirGlobal pCtx,
			      tDot11fIETCLAS *pSrc,
			      uint8_t *pBuf,
			      uint32_t nBuf,
			      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ietclas(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 14;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->user_priority;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->classifier_type;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->classifier_mask;
		*pnConsumed += 1;
		pBuf += 1;
		switch (pSrc->classifier_type) {
		case 0:
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.EthParams.source, 6);
			*pnConsumed += 6;
			pBuf += 6;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.EthParams.dest, 6);
			*pnConsumed += 6;
			pBuf += 6;
			frameshtons(pCtx, pBuf, pSrc->info.EthParams.type, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		case 1:
			*pBuf = pSrc->info.IpParams.version;
			*pnConsumed += 1;
			pBuf += 1;
			switch (pSrc->info.IpParams.version) {
			case 4:
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.source, 4);
				*pnConsumed += 4;
				pBuf += 4;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.dest, 4);
				*pnConsumed += 4;
				pBuf += 4;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.src_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.dest_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.DSCP;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.proto;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.reserved;
				*pnConsumed += 1;
				/* fieldsEndFlag = 1 */
				break;
			case 6:
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.source, 16);
				*pnConsumed += 16;
				pBuf += 16;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.dest, 16);
				*pnConsumed += 16;
				pBuf += 16;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.src_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.dest_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.flow_label, 3);
				*pnConsumed += 3;
				/* fieldsEndFlag = 1 */
				break;
			}
			break;
		case 2:
			frameshtons(pCtx, pBuf, pSrc->info.Params8021dq.tag_type, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_tclas. */

uint32_t dot11f_pack_ie_tclassproc(tpAniSirGlobal pCtx,
				   tDot11fIETCLASSPROC *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 44;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->processing;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tclassproc. */

uint32_t dot11f_pack_ie_ts_delay(tpAniSirGlobal pCtx,
				tDot11fIETSDelay *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 43;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtonl(pCtx, pBuf, pSrc->delay, 0);
		*pnConsumed += 4;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ts_delay. */

uint32_t dot11f_pack_ie_tsf_info(tpAniSirGlobal pCtx,
				tDot11fIETSFInfo *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->TsfOffset, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->BeaconIntvl, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tsf_info. */

uint32_t dot11f_pack_ie_tspec(tpAniSirGlobal pCtx,
			      tDot11fIETSPEC *pSrc,
			      uint8_t *pBuf,
			      uint32_t nBuf,
			      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp89__;
	uint8_t tmp90__;
	uint16_t tmp91__;
	nNeeded  += 55;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 13;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp89__ = 0U;
		tmp89__ |= (pSrc->traffic_type << 0);
		tmp89__ |= (pSrc->tsid << 1);
		tmp89__ |= (pSrc->direction << 5);
		tmp89__ |= (pSrc->access_policy << 7);
		tmp89__ |= (pSrc->aggregation << 9);
		tmp89__ |= (pSrc->psb << 10);
		tmp89__ |= (pSrc->user_priority << 11);
		tmp89__ |= (pSrc->tsinfo_ack_pol << 14);
		frameshtons(pCtx, pBuf, tmp89__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		tmp90__ = 0U;
		tmp90__ |= (pSrc->schedule << 0);
		tmp90__ |= (pSrc->unused << 1);
		*pBuf = tmp90__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp91__ = 0U;
		tmp91__ |= (pSrc->size << 0);
		tmp91__ |= (pSrc->fixed << 15);
		frameshtons(pCtx, pBuf, tmp91__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		frameshtons(pCtx, pBuf, pSrc->max_msdu_size, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtonl(pCtx, pBuf, pSrc->min_service_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->max_service_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->inactivity_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->suspension_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->service_start_time, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->min_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->mean_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->peak_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->burst_size, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->delay_bound, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->min_phy_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->surplus_bw_allowance, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->medium_time, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tspec. */

uint32_t dot11f_pack_ie_vht_caps(tpAniSirGlobal pCtx,
				tDot11fIEVHTCaps *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t tmp92__;
	uint16_t tmp93__;
	uint16_t tmp94__;
	nNeeded  += 12;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 191;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp92__ = 0U;
		tmp92__ |= (pSrc->maxMPDULen << 0);
		tmp92__ |= (pSrc->supportedChannelWidthSet << 2);
		tmp92__ |= (pSrc->ldpcCodingCap << 4);
		tmp92__ |= (pSrc->shortGI80MHz << 5);
		tmp92__ |= (pSrc->shortGI160and80plus80MHz << 6);
		tmp92__ |= (pSrc->txSTBC << 7);
		tmp92__ |= (pSrc->rxSTBC << 8);
		tmp92__ |= (pSrc->suBeamFormerCap << 11);
		tmp92__ |= (pSrc->suBeamformeeCap << 12);
		tmp92__ |= (pSrc->csnofBeamformerAntSup << 13);
		tmp92__ |= (pSrc->numSoundingDim << 16);
		tmp92__ |= (pSrc->muBeamformerCap << 19);
		tmp92__ |= (pSrc->muBeamformeeCap << 20);
		tmp92__ |= (pSrc->vhtTXOPPS << 21);
		tmp92__ |= (pSrc->htcVHTCap << 22);
		tmp92__ |= (pSrc->maxAMPDULenExp << 23);
		tmp92__ |= (pSrc->vhtLinkAdaptCap << 26);
		tmp92__ |= (pSrc->rxAntPattern << 28);
		tmp92__ |= (pSrc->txAntPattern << 29);
		tmp92__ |= (pSrc->reserved1 << 30);
		frameshtonl(pCtx, pBuf, tmp92__, 0);
		*pnConsumed += 4;
		pBuf += 4;
		nBuf -=  4 ;
		frameshtons(pCtx, pBuf, pSrc->rxMCSMap, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp93__ = 0U;
		tmp93__ |= (pSrc->rxHighSupDataRate << 0);
		tmp93__ |= (pSrc->reserved2 << 13);
		frameshtons(pCtx, pBuf, tmp93__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		frameshtons(pCtx, pBuf, pSrc->txMCSMap, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp94__ = 0U;
		tmp94__ |= (pSrc->txSupDataRate << 0);
		tmp94__ |= (pSrc->reserved3 << 13);
		frameshtons(pCtx, pBuf, tmp94__, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag  = 1 */
		nBuf -=  2 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vht_caps. */

uint32_t dot11f_pack_ie_vht_operation(tpAniSirGlobal pCtx,
				     tDot11fIEVHTOperation *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 192;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->chanWidth;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->chanCenterFreqSeg1;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->chanCenterFreqSeg2;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->basicMCSSet, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vht_operation. */

uint32_t dot11f_pack_ie_wmm_schedule(tpAniSirGlobal pCtx,
				    tDot11fIEWMMSchedule *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp95__;
	nNeeded  += 15;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		tmp95__ = 0U;
		tmp95__ |= (pSrc->aggregation << 0);
		tmp95__ |= (pSrc->tsid << 1);
		tmp95__ |= (pSrc->direction << 5);
		tmp95__ |= (pSrc->reserved << 7);
		frameshtons(pCtx, pBuf, tmp95__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		frameshtonl(pCtx, pBuf, pSrc->service_start_time, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->service_interval, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->max_service_dur, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->spec_interval, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmm_schedule. */

uint32_t dot11f_pack_ie_wmmtclas(tpAniSirGlobal pCtx,
				 tDot11fIEWMMTCLAS *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_iewmmtclas(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x6;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->user_priority;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->classifier_type;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->classifier_mask;
		*pnConsumed += 1;
		pBuf += 1;
		switch (pSrc->classifier_type) {
		case 0:
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.EthParams.source, 6);
			*pnConsumed += 6;
			pBuf += 6;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.EthParams.dest, 6);
			*pnConsumed += 6;
			pBuf += 6;
			frameshtons(pCtx, pBuf, pSrc->info.EthParams.type, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		case 1:
			*pBuf = pSrc->info.IpParams.version;
			*pnConsumed += 1;
			pBuf += 1;
			switch (pSrc->info.IpParams.version) {
			case 4:
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.source, 4);
				*pnConsumed += 4;
				pBuf += 4;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.dest, 4);
				*pnConsumed += 4;
				pBuf += 4;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.src_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV4Params.dest_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.DSCP;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.proto;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->info.IpParams.params.IpV4Params.reserved;
				*pnConsumed += 1;
				/* fieldsEndFlag = 1 */
				break;
			case 6:
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.source, 10);
				*pnConsumed += 10;
				pBuf += 10;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.dest, 10);
				*pnConsumed += 10;
				pBuf += 10;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.src_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				frameshtons(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.dest_port, 0);
				*pnConsumed += 2;
				pBuf += 2;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->info.IpParams.params.IpV6Params.flow_label, 3);
				*pnConsumed += 3;
				/* fieldsEndFlag = 1 */
				break;
			}
			break;
		case 2:
			frameshtons(pCtx, pBuf, pSrc->info.Params8021dq.tag_type, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_wmmtclas. */

uint32_t dot11f_pack_ie_wmmtclasproc(tpAniSirGlobal pCtx,
				     tDot11fIEWMMTCLASPROC *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x7;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->processing;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmmtclasproc. */

uint32_t dot11f_pack_ie_wmmts_delay(tpAniSirGlobal pCtx,
				   tDot11fIEWMMTSDelay *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x8;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtonl(pCtx, pBuf, pSrc->delay, 0);
		*pnConsumed += 4;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmmts_delay. */

uint32_t dot11f_pack_ie_wmmtspec(tpAniSirGlobal pCtx,
				 tDot11fIEWMMTSPEC *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp96__;
	uint8_t tmp97__;
	uint16_t tmp98__;
	nNeeded  += 38;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		tmp96__ = 0U;
		tmp96__ |= (pSrc->traffic_type << 0);
		tmp96__ |= (pSrc->tsid << 1);
		tmp96__ |= (pSrc->direction << 5);
		tmp96__ |= (pSrc->access_policy << 7);
		tmp96__ |= (pSrc->aggregation << 9);
		tmp96__ |= (pSrc->psb << 10);
		tmp96__ |= (pSrc->user_priority << 11);
		tmp96__ |= (pSrc->tsinfo_ack_pol << 14);
		frameshtons(pCtx, pBuf, tmp96__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		tmp97__ = 0U;
		tmp97__ |= (pSrc->tsinfo_rsvd << 0);
		tmp97__ |= (pSrc->burst_size_defn << 7);
		*pBuf = tmp97__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp98__ = 0U;
		tmp98__ |= (pSrc->size << 0);
		tmp98__ |= (pSrc->fixed << 15);
		frameshtons(pCtx, pBuf, tmp98__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		frameshtons(pCtx, pBuf, pSrc->max_msdu_size, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtonl(pCtx, pBuf, pSrc->min_service_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->max_service_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->inactivity_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->suspension_int, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->service_start_time, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->min_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->mean_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->peak_data_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->burst_size, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->delay_bound, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtonl(pCtx, pBuf, pSrc->min_phy_rate, 0);
		*pnConsumed += 4;
		pBuf += 4;
		frameshtons(pCtx, pBuf, pSrc->surplus_bw_allowance, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->medium_time, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmmtspec. */

uint32_t dot11f_pack_ie_wider_bw_chan_switch_ann(tpAniSirGlobal pCtx,
					     tDot11fIEWiderBWChanSwitchAnn *pSrc,
					     uint8_t *pBuf,
					     uint32_t nBuf,
					     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 3;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 194;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->newChanWidth;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->newCenterChanFreq0;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->newCenterChanFreq1;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wider_bw_chan_switch_ann. */

uint32_t dot11f_pack_ie_azimuth_req(tpAniSirGlobal pCtx,
				    tDot11fIEazimuth_req *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->request;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_azimuth_req. */

uint32_t dot11f_pack_ie_max_age(tpAniSirGlobal pCtx,
				tDot11fIEmax_age *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 4;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->max_age, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_max_age. */

uint32_t dot11f_pack_ie_neighbor_rpt(tpAniSirGlobal pCtx,
				     tDot11fIEneighbor_rpt *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp99__;
	uint8_t tmp100__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_neighbor_rpt(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 52;
		++pBuf; --nBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; --nBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->bssid, 6);
		*pnConsumed += 6;
		pBuf += 6;
		tmp99__ = 0U;
		tmp99__ |= (pSrc->APReachability << 0);
		tmp99__ |= (pSrc->Security << 2);
		tmp99__ |= (pSrc->KeyScope << 3);
		tmp99__ |= (pSrc->SpecMgmtCap << 4);
		tmp99__ |= (pSrc->QosCap << 5);
		tmp99__ |= (pSrc->apsd << 6);
		tmp99__ |= (pSrc->rrm << 7);
		*pBuf = tmp99__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp100__ = 0U;
		tmp100__ |= (pSrc->DelayedBA << 0);
		tmp100__ |= (pSrc->ImmBA << 1);
		tmp100__ |= (pSrc->MobilityDomain << 2);
		tmp100__ |= (pSrc->reserved << 3);
		*pBuf = tmp100__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->reserved1, 0);
		*pnConsumed += 2;
		pBuf += 2;
		*pBuf = pSrc->regulatoryClass;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->channel;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->PhyType;
		*pnConsumed += 1;
		pBuf += 1;
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_neighbor_rpt,
				IES_neighbor_rpt);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_neighbor_rpt. */

uint32_t dot11f_pack_ie_req_mac_addr(tpAniSirGlobal pCtx,
				     tDot11fIEreq_mac_addr *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 6;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 2;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->addr, 6);
		*pnConsumed += 6;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_req_mac_addr. */

uint32_t dot11f_pack_ie_tgt_mac_addr(tpAniSirGlobal pCtx,
				     tDot11fIEtgt_mac_addr *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 6;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 3;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->addr, 6);
		*pnConsumed += 6;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tgt_mac_addr. */

uint32_t dot11f_pack_ie_vht_transmit_power_env(tpAniSirGlobal pCtx,
					       tDot11fIEvht_transmit_power_env *pSrc,
					       uint8_t *pBuf,
					       uint32_t nBuf,
					       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_bytes;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 195;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->bytes), pSrc->num_bytes);
		*pnConsumed += pSrc->num_bytes;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vht_transmit_power_env. */

uint32_t dot11f_pack_ie_aid(tpAniSirGlobal pCtx,
			    tDot11fIEAID *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 197;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->assocId, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_aid. */

uint32_t dot11f_pack_ie_cf_params(tpAniSirGlobal pCtx,
				 tDot11fIECFParams *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 6;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 4;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->cfp_count;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->cfp_period;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->cfp_maxduration, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->cfp_durremaining, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_cf_params. */

uint32_t dot11f_pack_ie_challenge_text(tpAniSirGlobal pCtx,
				      tDot11fIEChallengeText *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_text;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 16;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->text), pSrc->num_text);
		*pnConsumed += pSrc->num_text;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_challenge_text. */

uint32_t dot11f_pack_ie_chan_switch_ann(tpAniSirGlobal pCtx,
				      tDot11fIEChanSwitchAnn *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 3;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 37;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->switchMode;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->newChannel;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->switchCount;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_chan_switch_ann. */

uint32_t dot11f_pack_ie_channel_switch_wrapper(tpAniSirGlobal pCtx,
					     tDot11fIEChannelSwitchWrapper *pSrc,
					     uint8_t *pBuf,
					     uint32_t nBuf,
					     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_channel_switch_wrapper(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 196;
		++pBuf; --nBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; --nBuf; ++(*pnConsumed);
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_ChannelSwitchWrapper,
				IES_ChannelSwitchWrapper);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_channel_switch_wrapper. */

uint32_t dot11f_pack_ie_country(tpAniSirGlobal pCtx,
				tDot11fIECountry *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_country(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 7;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->country, 3);
		*pnConsumed += 3;
		pBuf += 3;
		if (pSrc->num_triplets) {
			DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->triplets), (pSrc->num_triplets * 3));
			*pnConsumed += (pSrc->num_triplets * 3);
			/* fieldsEndFlag = 1 */
		} else {
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_country. */

uint32_t dot11f_pack_ie_ds_params(tpAniSirGlobal pCtx,
				 tDot11fIEDSParams *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 3;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->curr_channel;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ds_params. */

uint32_t dot11f_pack_ie_edca_param_set(tpAniSirGlobal pCtx,
				     tDot11fIEEDCAParamSet *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp101__;
	uint8_t tmp102__;
	uint8_t tmp103__;
	uint8_t tmp104__;
	uint8_t tmp105__;
	uint8_t tmp106__;
	uint8_t tmp107__;
	uint8_t tmp108__;
	nNeeded  += 18;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 12;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->qos;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->reserved;
		*pnConsumed += 1;
		pBuf += 1;
		tmp101__ = 0U;
		tmp101__ |= (pSrc->acbe_aifsn << 0);
		tmp101__ |= (pSrc->acbe_acm << 4);
		tmp101__ |= (pSrc->acbe_aci << 5);
		tmp101__ |= (pSrc->unused1 << 7);
		*pBuf = tmp101__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp102__ = 0U;
		tmp102__ |= (pSrc->acbe_acwmin << 0);
		tmp102__ |= (pSrc->acbe_acwmax << 4);
		*pBuf = tmp102__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acbe_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp103__ = 0U;
		tmp103__ |= (pSrc->acbk_aifsn << 0);
		tmp103__ |= (pSrc->acbk_acm << 4);
		tmp103__ |= (pSrc->acbk_aci << 5);
		tmp103__ |= (pSrc->unused2 << 7);
		*pBuf = tmp103__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp104__ = 0U;
		tmp104__ |= (pSrc->acbk_acwmin << 0);
		tmp104__ |= (pSrc->acbk_acwmax << 4);
		*pBuf = tmp104__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acbk_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp105__ = 0U;
		tmp105__ |= (pSrc->acvi_aifsn << 0);
		tmp105__ |= (pSrc->acvi_acm << 4);
		tmp105__ |= (pSrc->acvi_aci << 5);
		tmp105__ |= (pSrc->unused3 << 7);
		*pBuf = tmp105__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp106__ = 0U;
		tmp106__ |= (pSrc->acvi_acwmin << 0);
		tmp106__ |= (pSrc->acvi_acwmax << 4);
		*pBuf = tmp106__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acvi_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp107__ = 0U;
		tmp107__ |= (pSrc->acvo_aifsn << 0);
		tmp107__ |= (pSrc->acvo_acm << 4);
		tmp107__ |= (pSrc->acvo_aci << 5);
		tmp107__ |= (pSrc->unused4 << 7);
		*pBuf = tmp107__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp108__ = 0U;
		tmp108__ |= (pSrc->acvo_acwmin << 0);
		tmp108__ |= (pSrc->acvo_acwmax << 4);
		*pBuf = tmp108__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acvo_txoplimit, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_edca_param_set. */

uint32_t dot11f_pack_ie_erp_info(tpAniSirGlobal pCtx,
				tDot11fIEERPInfo *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp109__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 42;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp109__ = 0U;
		tmp109__ |= (pSrc->non_erp_present << 0);
		tmp109__ |= (pSrc->use_prot << 1);
		tmp109__ |= (pSrc->barker_preamble << 2);
		tmp109__ |= (pSrc->unused << 3);
		*pBuf = tmp109__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_erp_info. */

uint32_t dot11f_pack_ie_ese_cckm_opaque(tpAniSirGlobal pCtx,
				      tDot11fIEESECckmOpaque *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 156;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_cckm_opaque. */

uint32_t dot11f_pack_ie_ese_rad_mgmt_cap(tpAniSirGlobal pCtx,
				      tDot11fIEESERadMgmtCap *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp110__;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x1;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->mgmt_state;
		*pnConsumed += 1;
		pBuf += 1;
		tmp110__ = 0U;
		tmp110__ |= (pSrc->mbssid_mask << 0);
		tmp110__ |= (pSrc->reserved << 3);
		*pBuf = tmp110__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_rad_mgmt_cap. */

uint32_t dot11f_pack_ie_ese_traf_strm_met(tpAniSirGlobal pCtx,
				       tDot11fIEESETrafStrmMet *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x7;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->tsid;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->state;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->msmt_interval, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_traf_strm_met. */

uint32_t dot11f_pack_ie_ese_traf_strm_rate_set(tpAniSirGlobal pCtx,
					   tDot11fIEESETrafStrmRateSet *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_tsrates + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x8;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->tsid;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->tsrates), pSrc->num_tsrates);
		*pnConsumed += pSrc->num_tsrates;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_traf_strm_rate_set. */

uint32_t dot11f_pack_ie_ese_txmit_power(tpAniSirGlobal pCtx,
				      tDot11fIEESETxmitPower *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 150;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->power_limit;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->reserved;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_txmit_power. */

uint32_t dot11f_pack_ie_ese_version(tpAniSirGlobal pCtx,
				   tDot11fIEESEVersion *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x40;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x96;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x3;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ese_version. */

uint32_t dot11f_pack_ie_ESP_information(tpAniSirGlobal pCtx,
					tDot11fIEESP_information *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_variable_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 11;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->variable_data), pSrc->num_variable_data);
		*pnConsumed += pSrc->num_variable_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ESP_information. */

uint32_t dot11f_pack_ie_ext_cap(tpAniSirGlobal pCtx,
			       tDot11fIEExtCap *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_bytes;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 127;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->bytes), pSrc->num_bytes);
		*pnConsumed += pSrc->num_bytes;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ext_cap. */

uint32_t dot11f_pack_ie_ext_supp_rates(tpAniSirGlobal pCtx,
				     tDot11fIEExtSuppRates *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_rates;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 50;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->rates), pSrc->num_rates);
		*pnConsumed += pSrc->num_rates;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ext_supp_rates. */

uint32_t dot11f_pack_ie_fh_param_set(tpAniSirGlobal pCtx,
				   tDot11fIEFHParamSet *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 2;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->dwell_time, 0);
		*pnConsumed += 2;
		pBuf += 2;
		*pBuf = pSrc->hop_set;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->hop_pattern;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->hop_index;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fh_param_set. */

uint32_t dot11f_pack_ie_fh_params(tpAniSirGlobal pCtx,
				 tDot11fIEFHParams *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 8;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->radix;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->nchannels;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fh_params. */

uint32_t dot11f_pack_ie_fh_patt_table(tpAniSirGlobal pCtx,
				    tDot11fIEFHPattTable *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_randtable + 4);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 9;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->flag;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->nsets;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->modulus;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->offset;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->randtable), pSrc->num_randtable);
		*pnConsumed += pSrc->num_randtable;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fh_patt_table. */

uint32_t dot11f_pack_ie_ft_info(tpAniSirGlobal pCtx,
			       tDot11fIEFTInfo *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp111__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ieft_info(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 55;
		++pBuf; --nBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; --nBuf; ++(*pnConsumed);
		tmp111__ = 0U;
		tmp111__ |= (pSrc->reserved << 0);
		tmp111__ |= (pSrc->IECount << 8);
		frameshtons(pCtx, pBuf, tmp111__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->MIC, 16);
		*pnConsumed += 16;
		pBuf += 16;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->Anonce, 32);
		*pnConsumed += 32;
		pBuf += 32;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->Snonce, 32);
		*pnConsumed += 32;
		pBuf += 32;
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_FTInfo,
				IES_FTInfo);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_ft_info. */

uint32_t dot11f_pack_ie_ht_caps(tpAniSirGlobal pCtx,
			       tDot11fIEHTCaps *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp112__;
	uint8_t tmp113__;
	uint16_t tmp114__;
	uint32_t tmp115__;
	uint8_t tmp116__;
	nNeeded  +=  (pSrc->num_rsvd + 26);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 45;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp112__ = 0U;
		tmp112__ |= (pSrc->advCodingCap << 0);
		tmp112__ |= (pSrc->supportedChannelWidthSet << 1);
		tmp112__ |= (pSrc->mimoPowerSave << 2);
		tmp112__ |= (pSrc->greenField << 4);
		tmp112__ |= (pSrc->shortGI20MHz << 5);
		tmp112__ |= (pSrc->shortGI40MHz << 6);
		tmp112__ |= (pSrc->txSTBC << 7);
		tmp112__ |= (pSrc->rxSTBC << 8);
		tmp112__ |= (pSrc->delayedBA << 10);
		tmp112__ |= (pSrc->maximalAMSDUsize << 11);
		tmp112__ |= (pSrc->dsssCckMode40MHz << 12);
		tmp112__ |= (pSrc->psmp << 13);
		tmp112__ |= (pSrc->stbcControlFrame << 14);
		tmp112__ |= (pSrc->lsigTXOPProtection << 15);
		frameshtons(pCtx, pBuf, tmp112__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		tmp113__ = 0U;
		tmp113__ |= (pSrc->maxRxAMPDUFactor << 0);
		tmp113__ |= (pSrc->mpduDensity << 2);
		tmp113__ |= (pSrc->reserved1 << 5);
		*pBuf = tmp113__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->supportedMCSSet, 16);
		*pnConsumed += 16;
		pBuf += 16;
		tmp114__ = 0U;
		tmp114__ |= (pSrc->pco << 0);
		tmp114__ |= (pSrc->transitionTime << 1);
		tmp114__ |= (pSrc->reserved2 << 3);
		tmp114__ |= (pSrc->mcsFeedback << 8);
		tmp114__ |= (pSrc->reserved3 << 10);
		frameshtons(pCtx, pBuf, tmp114__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		tmp115__ = 0U;
		tmp115__ |= (pSrc->txBF << 0);
		tmp115__ |= (pSrc->rxStaggeredSounding << 1);
		tmp115__ |= (pSrc->txStaggeredSounding << 2);
		tmp115__ |= (pSrc->rxZLF << 3);
		tmp115__ |= (pSrc->txZLF << 4);
		tmp115__ |= (pSrc->implicitTxBF << 5);
		tmp115__ |= (pSrc->calibration << 6);
		tmp115__ |= (pSrc->explicitCSITxBF << 8);
		tmp115__ |= (pSrc->explicitUncompressedSteeringMatrix << 9);
		tmp115__ |= (pSrc->explicitBFCSIFeedback << 10);
		tmp115__ |= (pSrc->explicitUncompressedSteeringMatrixFeedback << 13);
		tmp115__ |= (pSrc->explicitCompressedSteeringMatrixFeedback << 16);
		tmp115__ |= (pSrc->csiNumBFAntennae << 19);
		tmp115__ |= (pSrc->uncompressedSteeringMatrixBFAntennae << 21);
		tmp115__ |= (pSrc->compressedSteeringMatrixBFAntennae << 23);
		tmp115__ |= (pSrc->reserved4 << 25);
		frameshtonl(pCtx, pBuf, tmp115__, 0);
		*pnConsumed += 4;
		pBuf += 4;
		nBuf -=  4 ;
		tmp116__ = 0U;
		tmp116__ |= (pSrc->antennaSelection << 0);
		tmp116__ |= (pSrc->explicitCSIFeedbackTx << 1);
		tmp116__ |= (pSrc->antennaIndicesFeedbackTx << 2);
		tmp116__ |= (pSrc->explicitCSIFeedback << 3);
		tmp116__ |= (pSrc->antennaIndicesFeedback << 4);
		tmp116__ |= (pSrc->rxAS << 5);
		tmp116__ |= (pSrc->txSoundingPPDUs << 6);
		tmp116__ |= (pSrc->reserved5 << 7);
		*pBuf = tmp116__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->rsvd), pSrc->num_rsvd);
		*pnConsumed += pSrc->num_rsvd;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ht_caps. */

uint32_t dot11f_pack_ie_ht_info(tpAniSirGlobal pCtx,
			       tDot11fIEHTInfo *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp117__;
	uint16_t tmp118__;
	uint16_t tmp119__;
	nNeeded  +=  (pSrc->num_rsvd + 22);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 61;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->primaryChannel;
		*pnConsumed += 1;
		pBuf += 1;
		tmp117__ = 0U;
		tmp117__ |= (pSrc->secondaryChannelOffset << 0);
		tmp117__ |= (pSrc->recommendedTxWidthSet << 2);
		tmp117__ |= (pSrc->rifsMode << 3);
		tmp117__ |= (pSrc->controlledAccessOnly << 4);
		tmp117__ |= (pSrc->serviceIntervalGranularity << 5);
		*pBuf = tmp117__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp118__ = 0U;
		tmp118__ |= (pSrc->opMode << 0);
		tmp118__ |= (pSrc->nonGFDevicesPresent << 2);
		tmp118__ |= (pSrc->transmitBurstLimit << 3);
		tmp118__ |= (pSrc->obssNonHTStaPresent << 4);
		tmp118__ |= (pSrc->reserved << 5);
		frameshtons(pCtx, pBuf, tmp118__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		tmp119__ = 0U;
		tmp119__ |= (pSrc->basicSTBCMCS << 0);
		tmp119__ |= (pSrc->dualCTSProtection << 7);
		tmp119__ |= (pSrc->secondaryBeacon << 8);
		tmp119__ |= (pSrc->lsigTXOPProtectionFullSupport << 9);
		tmp119__ |= (pSrc->pcoActive << 10);
		tmp119__ |= (pSrc->pcoPhase << 11);
		tmp119__ |= (pSrc->reserved2 << 12);
		frameshtons(pCtx, pBuf, tmp119__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->basicMCSSet, 16);
		*pnConsumed += 16;
		pBuf += 16;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->rsvd), pSrc->num_rsvd);
		*pnConsumed += pSrc->num_rsvd;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ht_info. */

uint32_t dot11f_pack_ie_ibss_params(tpAniSirGlobal pCtx,
				   tDot11fIEIBSSParams *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 6;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->atim, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ibss_params. */

uint32_t dot11f_pack_ie_link_identifier(tpAniSirGlobal pCtx,
				       tDot11fIELinkIdentifier *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 18;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 101;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->bssid, 6);
		*pnConsumed += 6;
		pBuf += 6;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->InitStaAddr, 6);
		*pnConsumed += 6;
		pBuf += 6;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->RespStaAddr, 6);
		*pnConsumed += 6;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_link_identifier. */

uint32_t dot11f_pack_ie_MBO_IE(tpAniSirGlobal pCtx,
			       tDot11fIEMBO_IE *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_MBO_IE(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x16;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_MBO_IE +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_MBO_IE. */

uint32_t dot11f_pack_ie_measurement_report(tpAniSirGlobal pCtx,
					  tDot11fIEMeasurementReport *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp120__;
	uint8_t tmp121__;
	uint8_t tmp122__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_measurement_report(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 39;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->token;
		*pnConsumed += 1;
		pBuf += 1;
		tmp120__ = 0U;
		tmp120__ |= (pSrc->late << 0);
		tmp120__ |= (pSrc->incapable << 1);
		tmp120__ |= (pSrc->refused << 2);
		tmp120__ |= (pSrc->unused << 3);
		*pBuf = tmp120__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		*pBuf = pSrc->type;
		*pnConsumed += 1;
		pBuf += 1;
		if (pSrc->type) {
			switch (pSrc->type) {
			case 0:
				*pBuf = pSrc->report.Basic.channel;
				*pnConsumed += 1;
				pBuf += 1;
				frameshtonq(pCtx, pBuf, pSrc->report.Basic.meas_start_time, 0);
				*pnConsumed += 8;
				pBuf += 8;
				frameshtons(pCtx, pBuf, pSrc->report.Basic.meas_duration, 0);
				*pnConsumed += 2;
				pBuf += 2;
				tmp121__ = 0U;
				tmp121__ |= (pSrc->report.Basic.bss << 0);
				tmp121__ |= (pSrc->report.Basic.ofdm_preamble << 1);
				tmp121__ |= (pSrc->report.Basic.unid_signal << 2);
				tmp121__ |= (pSrc->report.Basic.rader << 3);
				tmp121__ |= (pSrc->report.Basic.unmeasured << 4);
				tmp121__ |= (pSrc->report.Basic.unused << 5);
				*pBuf = tmp121__;
				*pnConsumed += 1;
				/* fieldsEndFlag  = 1 */
				nBuf -=  1 ;
				break;
			case 1:
				*pBuf = pSrc->report.CCA.channel;
				*pnConsumed += 1;
				pBuf += 1;
				frameshtonq(pCtx, pBuf, pSrc->report.CCA.meas_start_time, 0);
				*pnConsumed += 8;
				pBuf += 8;
				frameshtons(pCtx, pBuf, pSrc->report.CCA.meas_duration, 0);
				*pnConsumed += 2;
				pBuf += 2;
				*pBuf = pSrc->report.CCA.cca_busy_fraction;
				*pnConsumed += 1;
				/* fieldsEndFlag = 1 */
				break;
			case 2:
				*pBuf = pSrc->report.RPIHistogram.channel;
				*pnConsumed += 1;
				pBuf += 1;
				frameshtonq(pCtx, pBuf, pSrc->report.RPIHistogram.meas_start_time, 0);
				*pnConsumed += 8;
				pBuf += 8;
				frameshtons(pCtx, pBuf, pSrc->report.RPIHistogram.meas_duration, 0);
				*pnConsumed += 2;
				pBuf += 2;
				*pBuf = pSrc->report.RPIHistogram.rpi0_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi1_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi2_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi3_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi4_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi5_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi6_density;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.RPIHistogram.rpi7_density;
				*pnConsumed += 1;
				/* fieldsEndFlag = 1 */
				break;
			case 5:
				*pBuf = pSrc->report.Beacon.regClass;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.Beacon.channel;
				*pnConsumed += 1;
				pBuf += 1;
				frameshtonq(pCtx, pBuf, pSrc->report.Beacon.meas_start_time, 0);
				*pnConsumed += 8;
				pBuf += 8;
				frameshtons(pCtx, pBuf, pSrc->report.Beacon.meas_duration, 0);
				*pnConsumed += 2;
				pBuf += 2;
				tmp122__ = 0U;
				tmp122__ |= (pSrc->report.Beacon.condensed_PHY << 0);
				tmp122__ |= (pSrc->report.Beacon.reported_frame_type << 7);
				*pBuf = tmp122__;
				*pnConsumed += 1;
				pBuf += 1;
				nBuf -=  1 ;
				*pBuf = pSrc->report.Beacon.RCPI;
				*pnConsumed += 1;
				pBuf += 1;
				*pBuf = pSrc->report.Beacon.RSNI;
				*pnConsumed += 1;
				pBuf += 1;
				DOT11F_MEMCPY(pCtx, pBuf, pSrc->report.Beacon.BSSID, 6);
				*pnConsumed += 6;
				pBuf += 6;
				*pBuf = pSrc->report.Beacon.antenna_id;
				*pnConsumed += 1;
				pBuf += 1;
				frameshtonl(pCtx, pBuf, pSrc->report.Beacon.parent_TSF, 0);
				*pnConsumed += 4;
				pBuf += 4;
				status = pack_core(pCtx,
					 (uint8_t *)pSrc,
					 pBuf,
					 nBuf,
					 pnConsumed,
					 FFS_reportBeacon,
					 IES_reportBeacon);
				break;
			}
		} else {
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_measurement_report. */

uint32_t dot11f_pack_ie_measurement_request(tpAniSirGlobal pCtx,
					   tDot11fIEMeasurementRequest *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp123__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_measurement_request(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 38;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->measurement_token;
		*pnConsumed += 1;
		pBuf += 1;
		tmp123__ = 0U;
		tmp123__ |= (pSrc->parallel << 0);
		tmp123__ |= (pSrc->enable << 1);
		tmp123__ |= (pSrc->request << 2);
		tmp123__ |= (pSrc->report << 3);
		tmp123__ |= (pSrc->durationMandatory << 4);
		tmp123__ |= (pSrc->unused << 5);
		*pBuf = tmp123__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		*pBuf = pSrc->measurement_type;
		*pnConsumed += 1;
		pBuf += 1;
		switch (pSrc->measurement_type) {
		case 0:
			*pBuf = pSrc->measurement_request.Basic.channel_no;
			*pnConsumed += 1;
			pBuf += 1;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->measurement_request.Basic.meas_start_time, 8);
			*pnConsumed += 8;
			pBuf += 8;
			frameshtons(pCtx, pBuf, pSrc->measurement_request.Basic.meas_duration, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		case 1:
			*pBuf = pSrc->measurement_request.CCA.channel_no;
			*pnConsumed += 1;
			pBuf += 1;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->measurement_request.CCA.meas_start_time, 8);
			*pnConsumed += 8;
			pBuf += 8;
			frameshtons(pCtx, pBuf, pSrc->measurement_request.CCA.meas_duration, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		case 2:
			*pBuf = pSrc->measurement_request.RPIHistogram.channel_no;
			*pnConsumed += 1;
			pBuf += 1;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->measurement_request.RPIHistogram.meas_start_time, 8);
			*pnConsumed += 8;
			pBuf += 8;
			frameshtons(pCtx, pBuf, pSrc->measurement_request.RPIHistogram.meas_duration, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
			break;
		case 5:
			*pBuf = pSrc->measurement_request.Beacon.regClass;
			*pnConsumed += 1;
			pBuf += 1;
			*pBuf = pSrc->measurement_request.Beacon.channel;
			*pnConsumed += 1;
			pBuf += 1;
			frameshtons(pCtx, pBuf, pSrc->measurement_request.Beacon.randomization, 0);
			*pnConsumed += 2;
			pBuf += 2;
			frameshtons(pCtx, pBuf, pSrc->measurement_request.Beacon.meas_duration, 0);
			*pnConsumed += 2;
			pBuf += 2;
			*pBuf = pSrc->measurement_request.Beacon.meas_mode;
			*pnConsumed += 1;
			pBuf += 1;
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->measurement_request.Beacon.BSSID, 6);
			*pnConsumed += 6;
			pBuf += 6;
			status = pack_core(pCtx,
				 (uint8_t *)pSrc,
				 pBuf,
				 nBuf,
				 pnConsumed,
				 FFS_measurement_requestBeacon,
				 IES_measurement_requestBeacon);
			break;
		case 8:
			*pBuf = pSrc->measurement_request.lci.loc_subject;
			*pnConsumed += 1;
			pBuf += 1;
			status = pack_core(pCtx,
				 (uint8_t *)pSrc,
				 pBuf,
				 nBuf,
				 pnConsumed,
				 FFS_measurement_requestlci,
				 IES_measurement_requestlci);
			break;
		case 16:
			frameshtons(pCtx, pBuf, pSrc->measurement_request.ftmrr.random_interval, 0);
			*pnConsumed += 2;
			pBuf += 2;
			*pBuf = pSrc->measurement_request.ftmrr.min_ap_count;
			*pnConsumed += 1;
			pBuf += 1;
			status = pack_core(pCtx,
				 (uint8_t *)pSrc,
				 pBuf,
				 nBuf,
				 pnConsumed,
				 FFS_measurement_requestftmrr,
				 IES_measurement_requestftmrr);
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_measurement_request. */

uint32_t dot11f_pack_ie_mobility_domain(tpAniSirGlobal pCtx,
				       tDot11fIEMobilityDomain *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp124__;
	nNeeded  += 3;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 54;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->MDID, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp124__ = 0U;
		tmp124__ |= (pSrc->overDSCap << 0);
		tmp124__ |= (pSrc->resourceReqCap << 1);
		tmp124__ |= (pSrc->reserved << 2);
		*pBuf = tmp124__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_mobility_domain. */

uint32_t dot11f_pack_ie_neighbor_report(tpAniSirGlobal pCtx,
				       tDot11fIENeighborReport *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp125__;
	uint8_t tmp126__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_neighbor_report(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 52;
		++pBuf; --nBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; --nBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->bssid, 6);
		*pnConsumed += 6;
		pBuf += 6;
		tmp125__ = 0U;
		tmp125__ |= (pSrc->APReachability << 0);
		tmp125__ |= (pSrc->Security << 2);
		tmp125__ |= (pSrc->KeyScope << 3);
		tmp125__ |= (pSrc->SpecMgmtCap << 4);
		tmp125__ |= (pSrc->QosCap << 5);
		tmp125__ |= (pSrc->apsd << 6);
		tmp125__ |= (pSrc->rrm << 7);
		*pBuf = tmp125__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp126__ = 0U;
		tmp126__ |= (pSrc->DelayedBA << 0);
		tmp126__ |= (pSrc->ImmBA << 1);
		tmp126__ |= (pSrc->MobilityDomain << 2);
		tmp126__ |= (pSrc->reserved << 3);
		*pBuf = tmp126__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->reserved1, 0);
		*pnConsumed += 2;
		pBuf += 2;
		*pBuf = pSrc->regulatoryClass;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->channel;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->PhyType;
		*pnConsumed += 1;
		pBuf += 1;
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_NeighborReport,
				IES_NeighborReport);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_neighbor_report. */

uint32_t dot11f_pack_ie_obss_scan_parameters(tpAniSirGlobal pCtx,
					   tDot11fIEOBSSScanParameters *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 14;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 74;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->obssScanPassiveDwell, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->obssScanActiveDwell, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->bssChannelWidthTriggerScanInterval, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->obssScanPassiveTotalPerChannel, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->obssScanActiveTotalPerChannel, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->bssWidthChannelTransitionDelayFactor, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->obssScanActivityThreshold, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_obss_scan_parameters. */

uint32_t dot11f_pack_ie_operating_mode(tpAniSirGlobal pCtx,
				      tDot11fIEOperatingMode *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp127__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 199;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp127__ = 0U;
		tmp127__ |= (pSrc->chanWidth << 0);
		tmp127__ |= (pSrc->reserved << 2);
		tmp127__ |= (pSrc->rxNSS << 4);
		tmp127__ |= (pSrc->rxNSSType << 7);
		*pBuf = tmp127__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_operating_mode. */

uint32_t dot11f_pack_ie_p2_p_assoc_req(tpAniSirGlobal pCtx,
				    tDot11fIEP2PAssocReq *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_assoc_req(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PAssocReq +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_assoc_req. */

uint32_t dot11f_pack_ie_p2_p_assoc_res(tpAniSirGlobal pCtx,
				    tDot11fIEP2PAssocRes *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_assoc_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PAssocRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_assoc_res. */

uint32_t dot11f_pack_ie_p2_p_beacon(tpAniSirGlobal pCtx,
				  tDot11fIEP2PBeacon *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_beacon(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PBeacon +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_beacon. */

uint32_t dot11f_pack_ie_p2_p_beacon_probe_res(tpAniSirGlobal pCtx,
					  tDot11fIEP2PBeaconProbeRes *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_beacon_probe_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PBeaconProbeRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_beacon_probe_res. */

uint32_t dot11f_pack_ie_p2_p_de_auth(tpAniSirGlobal pCtx,
				  tDot11fIEP2PDeAuth *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_de_auth(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PDeAuth +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_de_auth. */

uint32_t dot11f_pack_ie_p2_p_dis_assoc(tpAniSirGlobal pCtx,
				    tDot11fIEP2PDisAssoc *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_dis_assoc(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PDisAssoc +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_dis_assoc. */

uint32_t dot11f_pack_ie_p2_pie_opaque(tpAniSirGlobal pCtx,
				    tDot11fIEP2PIEOpaque *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x6f;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9a;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_p2_pie_opaque. */

uint32_t dot11f_pack_ie_p2_p_probe_req(tpAniSirGlobal pCtx,
				    tDot11fIEP2PProbeReq *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_probe_req(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PProbeReq +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_probe_req. */

uint32_t dot11f_pack_ie_p2_p_probe_res(tpAniSirGlobal pCtx,
				    tDot11fIEP2PProbeRes *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iep2_p_probe_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x6f;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9a;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x9;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_P2PProbeRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_p2_p_probe_res. */

uint32_t dot11f_pack_ie_pti_control(tpAniSirGlobal pCtx,
				   tDot11fIEPTIControl *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 3;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 105;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->tid;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->sequence_control, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_pti_control. */

uint32_t dot11f_pack_ie_pu_buffer_status(tpAniSirGlobal pCtx,
				       tDot11fIEPUBufferStatus *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp128__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 106;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp128__ = 0U;
		tmp128__ |= (pSrc->ac_bk_traffic_aval << 0);
		tmp128__ |= (pSrc->ac_be_traffic_aval << 1);
		tmp128__ |= (pSrc->ac_vi_traffic_aval << 2);
		tmp128__ |= (pSrc->ac_vo_traffic_aval << 3);
		tmp128__ |= (pSrc->reserved << 4);
		*pBuf = tmp128__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_pu_buffer_status. */

uint32_t dot11f_pack_ie_power_caps(tpAniSirGlobal pCtx,
				  tDot11fIEPowerCaps *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 33;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->minTxPower;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->maxTxPower;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_power_caps. */

uint32_t dot11f_pack_ie_power_constraints(tpAniSirGlobal pCtx,
					 tDot11fIEPowerConstraints *pSrc,
					 uint8_t *pBuf,
					 uint32_t nBuf,
					 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 32;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->localPowerConstraints;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_power_constraints. */

uint32_t dot11f_pack_ie_qbss_load(tpAniSirGlobal pCtx,
				 tDot11fIEQBSSLoad *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 11;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->stacount, 0);
		*pnConsumed += 2;
		pBuf += 2;
		*pBuf = pSrc->chautil;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->avail, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_qbss_load. */

uint32_t dot11f_pack_ie_QCN_IE(tpAniSirGlobal pCtx,
			       tDot11fIEQCN_IE *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x8c;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xfd;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x1;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->version, 4);
		*pnConsumed += 4;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_QCN_IE. */

uint32_t dot11f_pack_ie_QComVendorIE(tpAniSirGlobal pCtx,
				     tDot11fIEQComVendorIE *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xa0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xc6;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->type;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->channel;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_QComVendorIE. */

uint32_t dot11f_pack_ie_qos_caps_ap(tpAniSirGlobal pCtx,
				  tDot11fIEQOSCapsAp *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp129__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 46;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp129__ = 0U;
		tmp129__ |= (pSrc->count << 0);
		tmp129__ |= (pSrc->qack << 4);
		tmp129__ |= (pSrc->qreq << 5);
		tmp129__ |= (pSrc->txopreq << 6);
		tmp129__ |= (pSrc->reserved << 7);
		*pBuf = tmp129__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_qos_caps_ap. */

uint32_t dot11f_pack_ie_qos_caps_station(tpAniSirGlobal pCtx,
				       tDot11fIEQOSCapsStation *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp130__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 46;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp130__ = 0U;
		tmp130__ |= (pSrc->acvo_uapsd << 0);
		tmp130__ |= (pSrc->acvi_uapsd << 1);
		tmp130__ |= (pSrc->acbk_uapsd << 2);
		tmp130__ |= (pSrc->acbe_uapsd << 3);
		tmp130__ |= (pSrc->qack << 4);
		tmp130__ |= (pSrc->max_sp_length << 5);
		tmp130__ |= (pSrc->more_data_ack << 7);
		*pBuf = tmp130__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_qos_caps_station. */

uint32_t dot11f_pack_ie_qos_map_set(tpAniSirGlobal pCtx,
				  tDot11fIEQosMapSet *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_dscp_exceptions;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 110;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->dscp_exceptions), pSrc->num_dscp_exceptions);
		*pnConsumed += pSrc->num_dscp_exceptions;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_qos_map_set. */

uint32_t dot11f_pack_ie_quiet(tpAniSirGlobal pCtx,
			      tDot11fIEQuiet *pSrc,
			      uint8_t *pBuf,
			      uint32_t nBuf,
			      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 6;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 40;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->count;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->period;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtons(pCtx, pBuf, pSrc->duration, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->offset, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_quiet. */

uint32_t dot11f_pack_ie_rcpiie(tpAniSirGlobal pCtx,
			       tDot11fIERCPIIE *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 53;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->rcpi;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_rcpiie. */

uint32_t dot11f_pack_ie_ric_data_desc(tpAniSirGlobal pCtx,
				    tDot11fIERICDataDesc *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ieric_data_desc(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_RICDataDesc,
				IES_RICDataDesc);
		break;
	}
	(void)pCtx;
	return status;
} /* End dot11f_pack_ie_ric_data_desc. */

uint32_t dot11f_pack_ie_rsn(tpAniSirGlobal pCtx,
			    tDot11fIERSN *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_iersn(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 48;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->version, 0);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->gp_cipher_suite, 4);
		*pnConsumed += 4;
		pBuf += 4;
		if (pSrc->pwise_cipher_suite_count) {
			frameshtons(pCtx, pBuf, pSrc->pwise_cipher_suite_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->pwise_cipher_suites), (pSrc->pwise_cipher_suite_count * 4));
		*pnConsumed += (pSrc->pwise_cipher_suite_count * 4);
		pBuf += (pSrc->pwise_cipher_suite_count * 4);
		if (pSrc->akm_suite_count) {
			frameshtons(pCtx, pBuf, pSrc->akm_suite_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->akm_suites), (pSrc->akm_suite_count * 4));
		*pnConsumed += (pSrc->akm_suite_count * 4);
		pBuf += (pSrc->akm_suite_count * 4);
		if (pSrc->RSN_Cap) {
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->RSN_Cap, 2);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		if (pSrc->pmkid_count) {
			frameshtons(pCtx, pBuf, pSrc->pmkid_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->pmkid), (pSrc->pmkid_count * 16));
		*pnConsumed += (pSrc->pmkid_count * 16);
		pBuf += (pSrc->pmkid_count * 16);
		if (pSrc->gp_mgmt_cipher_suite) {
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->gp_mgmt_cipher_suite, 4);
			*pnConsumed += 4;
			/* fieldsEndFlag = 1 */
		} else {
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_rsn. */

uint32_t dot11f_pack_ie_rsniie(tpAniSirGlobal pCtx,
			       tDot11fIERSNIIE *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 65;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->rsni;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_rsniie. */

uint32_t dot11f_pack_ie_rsn_opaque(tpAniSirGlobal pCtx,
				  tDot11fIERSNOpaque *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 48;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_rsn_opaque. */

uint32_t dot11f_pack_ie_supp_channels(tpAniSirGlobal pCtx,
				     tDot11fIESuppChannels *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_bands * 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 36;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->bands), (pSrc->num_bands * 2));
		*pnConsumed += (pSrc->num_bands * 2);
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_supp_channels. */

uint32_t dot11f_pack_ie_supp_operating_classes(tpAniSirGlobal pCtx,
					     tDot11fIESuppOperatingClasses *pSrc,
					     uint8_t *pBuf,
					     uint32_t nBuf,
					     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_classes;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 59;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->classes), pSrc->num_classes);
		*pnConsumed += pSrc->num_classes;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_supp_operating_classes. */

uint32_t dot11f_pack_ie_supp_rates(tpAniSirGlobal pCtx,
				  tDot11fIESuppRates *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_rates;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->rates), pSrc->num_rates);
		*pnConsumed += pSrc->num_rates;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_supp_rates. */

uint32_t dot11f_pack_ie_tim(tpAniSirGlobal pCtx,
			    tDot11fIETIM *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_vbmp + 3);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 5;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->dtim_count;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->dtim_period;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->bmpctl;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->vbmp), pSrc->num_vbmp);
		*pnConsumed += pSrc->num_vbmp;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tim. */

uint32_t dot11f_pack_ie_tpc_report(tpAniSirGlobal pCtx,
				  tDot11fIETPCReport *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 35;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->tx_power;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->link_margin;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tpc_report. */

uint32_t dot11f_pack_ie_tpc_request(tpAniSirGlobal pCtx,
				   tDot11fIETPCRequest *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 0;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 34;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_tpc_request. */

uint32_t dot11f_pack_ie_time_advertisement(tpAniSirGlobal pCtx,
					  tDot11fIETimeAdvertisement *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 16;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 69;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->timing_capabilities;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->time_value, 10);
		*pnConsumed += 10;
		pBuf += 10;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->time_error, 5);
		*pnConsumed += 5;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_time_advertisement. */

uint32_t dot11f_pack_ie_timeout_interval(tpAniSirGlobal pCtx,
					tDot11fIETimeoutInterval *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 56;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->timeoutType;
		*pnConsumed += 1;
		pBuf += 1;
		frameshtonl(pCtx, pBuf, pSrc->timeoutValue, 0);
		*pnConsumed += 4;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_timeout_interval. */

uint32_t dot11f_pack_ie_vht_ext_bss_load(tpAniSirGlobal pCtx,
				      tDot11fIEVHTExtBssLoad *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 5;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 193;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->muMIMOCapStaCount;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->ssUnderUtil;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->FortyMHzUtil;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->EightyMHzUtil;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->OneSixtyMHzUtil;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vht_ext_bss_load. */

uint32_t dot11f_pack_ie_vendor1_ie(tpAniSirGlobal pCtx,
				  tDot11fIEVendor1IE *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 0;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x10;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x18;
		++pBuf; ++(*pnConsumed);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vendor1_ie. */

uint32_t dot11f_pack_ie_vendor3_ie(tpAniSirGlobal pCtx,
				  tDot11fIEVendor3IE *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 0;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x16;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x32;
		++pBuf; ++(*pnConsumed);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_vendor3_ie. */

uint32_t dot11f_pack_ie_wapi(tpAniSirGlobal pCtx,
			     tDot11fIEWAPI *pSrc,
			     uint8_t *pBuf,
			     uint32_t nBuf,
			     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp131__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_iewapi(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 68;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->version, 0);
		*pnConsumed += 2;
		pBuf += 2;
		frameshtons(pCtx, pBuf, pSrc->akm_suite_count, 0);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->akm_suites), (pSrc->akm_suite_count * 4));
		*pnConsumed += (pSrc->akm_suite_count * 4);
		pBuf += (pSrc->akm_suite_count * 4);
		frameshtons(pCtx, pBuf, pSrc->unicast_cipher_suite_count, 0);
		*pnConsumed += 2;
		pBuf += 2;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->unicast_cipher_suites), (pSrc->unicast_cipher_suite_count * 4));
		*pnConsumed += (pSrc->unicast_cipher_suite_count * 4);
		pBuf += (pSrc->unicast_cipher_suite_count * 4);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->multicast_cipher_suite, 4);
		*pnConsumed += 4;
		pBuf += 4;
		tmp131__ = 0U;
		tmp131__ |= (pSrc->preauth << 0);
		tmp131__ |= (pSrc->reserved << 1);
		frameshtons(pCtx, pBuf, tmp131__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		if (pSrc->bkid_count) {
			frameshtons(pCtx, pBuf, pSrc->bkid_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->bkid), (pSrc->bkid_count * 16));
		*pnConsumed += (pSrc->bkid_count * 16);
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_wapi. */

uint32_t dot11f_pack_ie_wapi_opaque(tpAniSirGlobal pCtx,
				   tDot11fIEWAPIOpaque *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 68;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wapi_opaque. */

uint32_t dot11f_pack_ie_wfatpc(tpAniSirGlobal pCtx,
			       tDot11fIEWFATPC *pSrc,
			       uint8_t *pBuf,
			       uint32_t nBuf,
			       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x8;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->txPower;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->linkMargin;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wfatpc. */

uint32_t dot11f_pack_ie_wfdie_opaque(tpAniSirGlobal pCtx,
				    tDot11fIEWFDIEOpaque *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x6f;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9a;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xa;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wfdie_opaque. */

uint32_t dot11f_pack_ie_wmm_caps(tpAniSirGlobal pCtx,
				tDot11fIEWMMCaps *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp132__;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x5;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		tmp132__ = 0U;
		tmp132__ |= (pSrc->reserved << 0);
		tmp132__ |= (pSrc->qack << 4);
		tmp132__ |= (pSrc->queue_request << 5);
		tmp132__ |= (pSrc->txop_request << 6);
		tmp132__ |= (pSrc->more_ack << 7);
		*pBuf = tmp132__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmm_caps. */

uint32_t dot11f_pack_ie_wmm_info_ap(tpAniSirGlobal pCtx,
				  tDot11fIEWMMInfoAp *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp133__;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		tmp133__ = 0U;
		tmp133__ |= (pSrc->param_set_count << 0);
		tmp133__ |= (pSrc->reserved << 4);
		tmp133__ |= (pSrc->uapsd << 7);
		*pBuf = tmp133__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmm_info_ap. */

uint32_t dot11f_pack_ie_wmm_info_station(tpAniSirGlobal pCtx,
				       tDot11fIEWMMInfoStation *pSrc,
				       uint8_t *pBuf,
				       uint32_t nBuf,
				       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp134__;
	nNeeded  += 2;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		tmp134__ = 0U;
		tmp134__ |= (pSrc->acvo_uapsd << 0);
		tmp134__ |= (pSrc->acvi_uapsd << 1);
		tmp134__ |= (pSrc->acbk_uapsd << 2);
		tmp134__ |= (pSrc->acbe_uapsd << 3);
		tmp134__ |= (pSrc->reserved1 << 4);
		tmp134__ |= (pSrc->max_sp_length << 5);
		tmp134__ |= (pSrc->reserved2 << 7);
		*pBuf = tmp134__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmm_info_station. */

uint32_t dot11f_pack_ie_wmm_params(tpAniSirGlobal pCtx,
				  tDot11fIEWMMParams *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp135__;
	uint8_t tmp136__;
	uint8_t tmp137__;
	uint8_t tmp138__;
	uint8_t tmp139__;
	uint8_t tmp140__;
	uint8_t tmp141__;
	uint8_t tmp142__;
	nNeeded  += 19;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x1;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->version;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->qosInfo;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->reserved2;
		*pnConsumed += 1;
		pBuf += 1;
		tmp135__ = 0U;
		tmp135__ |= (pSrc->acbe_aifsn << 0);
		tmp135__ |= (pSrc->acbe_acm << 4);
		tmp135__ |= (pSrc->acbe_aci << 5);
		tmp135__ |= (pSrc->unused1 << 7);
		*pBuf = tmp135__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp136__ = 0U;
		tmp136__ |= (pSrc->acbe_acwmin << 0);
		tmp136__ |= (pSrc->acbe_acwmax << 4);
		*pBuf = tmp136__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acbe_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp137__ = 0U;
		tmp137__ |= (pSrc->acbk_aifsn << 0);
		tmp137__ |= (pSrc->acbk_acm << 4);
		tmp137__ |= (pSrc->acbk_aci << 5);
		tmp137__ |= (pSrc->unused2 << 7);
		*pBuf = tmp137__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp138__ = 0U;
		tmp138__ |= (pSrc->acbk_acwmin << 0);
		tmp138__ |= (pSrc->acbk_acwmax << 4);
		*pBuf = tmp138__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acbk_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp139__ = 0U;
		tmp139__ |= (pSrc->acvi_aifsn << 0);
		tmp139__ |= (pSrc->acvi_acm << 4);
		tmp139__ |= (pSrc->acvi_aci << 5);
		tmp139__ |= (pSrc->unused3 << 7);
		*pBuf = tmp139__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp140__ = 0U;
		tmp140__ |= (pSrc->acvi_acwmin << 0);
		tmp140__ |= (pSrc->acvi_acwmax << 4);
		*pBuf = tmp140__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acvi_txoplimit, 0);
		*pnConsumed += 2;
		pBuf += 2;
		tmp141__ = 0U;
		tmp141__ |= (pSrc->acvo_aifsn << 0);
		tmp141__ |= (pSrc->acvo_acm << 4);
		tmp141__ |= (pSrc->acvo_aci << 5);
		tmp141__ |= (pSrc->unused4 << 7);
		*pBuf = tmp141__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		tmp142__ = 0U;
		tmp142__ |= (pSrc->acvo_acwmin << 0);
		tmp142__ |= (pSrc->acvo_acwmax << 4);
		*pBuf = tmp142__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		frameshtons(pCtx, pBuf, pSrc->acvo_txoplimit, 0);
		*pnConsumed += 2;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wmm_params. */

uint32_t dot11f_pack_ie_wpa(tpAniSirGlobal pCtx,
			    tDot11fIEWPA *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_iewpa(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x1;
		++pBuf; ++(*pnConsumed);
		frameshtons(pCtx, pBuf, pSrc->version, 0);
		*pnConsumed += 2;
		pBuf += 2;
		if (pSrc->multicast_cipher_present) {
			DOT11F_MEMCPY(pCtx, pBuf, pSrc->multicast_cipher, 4);
			*pnConsumed += 4;
			pBuf += 4;
		} else {
			break;
		}
		if (pSrc->unicast_cipher_count) {
			frameshtons(pCtx, pBuf, pSrc->unicast_cipher_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->unicast_ciphers), (pSrc->unicast_cipher_count * 4));
		*pnConsumed += (pSrc->unicast_cipher_count * 4);
		pBuf += (pSrc->unicast_cipher_count * 4);
		if (pSrc->auth_suite_count) {
			frameshtons(pCtx, pBuf, pSrc->auth_suite_count, 0);
			*pnConsumed += 2;
			pBuf += 2;
		} else {
			break;
		}
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->auth_suites), (pSrc->auth_suite_count * 4));
		*pnConsumed += (pSrc->auth_suite_count * 4);
		pBuf += (pSrc->auth_suite_count * 4);
		if (pSrc->caps) {
			frameshtons(pCtx, pBuf, pSrc->caps, 0);
			*pnConsumed += 2;
			/* fieldsEndFlag = 1 */
		} else {
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_wpa. */

uint32_t dot11f_pack_ie_wpa_opaque(tpAniSirGlobal pCtx,
				  tDot11fIEWPAOpaque *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x1;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wpa_opaque. */

uint32_t dot11f_pack_ie_wsc(tpAniSirGlobal pCtx,
			    tDot11fIEWSC *pSrc,
			    uint8_t *pBuf,
			    uint32_t nBuf,
			    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_iewsc(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WSC +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc. */

uint32_t dot11f_pack_ie_wsc_assoc_req(tpAniSirGlobal pCtx,
				    tDot11fIEWscAssocReq *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_assoc_req(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscAssocReq +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_assoc_req. */

uint32_t dot11f_pack_ie_wsc_assoc_res(tpAniSirGlobal pCtx,
				    tDot11fIEWscAssocRes *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_assoc_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscAssocRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_assoc_res. */

uint32_t dot11f_pack_ie_wsc_beacon(tpAniSirGlobal pCtx,
				  tDot11fIEWscBeacon *pSrc,
				  uint8_t *pBuf,
				  uint32_t nBuf,
				  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_beacon(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscBeacon +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_beacon. */

uint32_t dot11f_pack_ie_wsc_beacon_probe_res(tpAniSirGlobal pCtx,
					  tDot11fIEWscBeaconProbeRes *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_beacon_probe_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscBeaconProbeRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_beacon_probe_res. */

uint32_t dot11f_pack_ie_wsc_ie_opaque(tpAniSirGlobal pCtx,
				    tDot11fIEWscIEOpaque *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0xf2;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x4;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_wsc_ie_opaque. */

uint32_t dot11f_pack_ie_wsc_probe_req(tpAniSirGlobal pCtx,
				    tDot11fIEWscProbeReq *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_probe_req(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscProbeReq +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_probe_req. */

uint32_t dot11f_pack_ie_wsc_probe_res(tpAniSirGlobal pCtx,
				    tDot11fIEWscProbeRes *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_probe_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscProbeRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_probe_res. */

uint32_t dot11f_pack_ie_wsc_reassoc_res(tpAniSirGlobal pCtx,
				      tDot11fIEWscReassocRes *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t n, idx = 0, idxlast;
	uint32_t nConsumedSoFar, nConsumedNow;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	uint32_t nNeeded = 0U;
	status = dot11f_get_packed_ie_wsc_reassoc_res(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	if (nNeeded > nBuf)
		return DOT11F_BUFFER_OVERFLOW;
	(void)pCtx;
	if (pSrc->present) {
		do {
			nConsumedSoFar = *pnConsumed;
			*pBuf = 221;
			++pBuf; --nBuf; ++(*pnConsumed);
			pIeLen = pBuf;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x0;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x50;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0xf2;
			++pBuf; --nBuf; ++(*pnConsumed);
			*pBuf = 0x4;
			++pBuf; --nBuf; ++(*pnConsumed);
			n = (255 - 4) < nBuf ? (255 - 4) : nBuf;
			nConsumedNow = *pnConsumed;
			idxlast = idx;
			status = pack_tlv_core(pCtx, (uint8_t *)pSrc, pBuf, n,
					       pnConsumed,
					       TLVS_WscReassocRes +
					       idx, &idx);
			nConsumedNow = *pnConsumed - nConsumedNow;
			*pIeLen = *pnConsumed - nConsumedSoFar - 2;
			pBuf += nConsumedNow;
			nBuf -= nConsumedNow;
		} while (DOT11F_BUFFER_OVERFLOW == status && idxlast != idx);
	}
	return status;
} /* End dot11f_pack_ie_wsc_reassoc_res. */

uint32_t dot11f_pack_ie_ext_chan_switch_ann(tpAniSirGlobal pCtx,
					    tDot11fIEext_chan_switch_ann *pSrc,
					    uint8_t *pBuf,
					    uint32_t nBuf,
					    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 4;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 60;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->switch_mode;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->new_reg_class;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->new_channel;
		*pnConsumed += 1;
		pBuf += 1;
		*pBuf = pSrc->switch_count;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ext_chan_switch_ann. */

uint32_t dot11f_pack_ie_fils_assoc_delay_info(tpAniSirGlobal pCtx,
					      tDot11fIEfils_assoc_delay_info *pSrc,
					      uint8_t *pBuf,
					      uint32_t nBuf,
					      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 1;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->assoc_delay_info;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_assoc_delay_info. */

uint32_t dot11f_pack_ie_fils_hlp_container(tpAniSirGlobal pCtx,
					   tDot11fIEfils_hlp_container *pSrc,
					   uint8_t *pBuf,
					   uint32_t nBuf,
					   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_hlp_packet + 12);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 5;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->dest_mac, 6);
		*pnConsumed += 6;
		pBuf += 6;
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->src_mac, 6);
		*pnConsumed += 6;
		pBuf += 6;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->hlp_packet), pSrc->num_hlp_packet);
		*pnConsumed += pSrc->num_hlp_packet;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_hlp_container. */

uint32_t dot11f_pack_ie_fils_indication(tpAniSirGlobal pCtx,
					tDot11fIEfils_indication *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint16_t tmp143__;
	nNeeded  +=  (pSrc->num_variable_data + 2);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 240;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp143__ = 0U;
		tmp143__ |= (pSrc->public_key_identifiers_cnt << 0);
		tmp143__ |= (pSrc->realm_identifiers_cnt << 3);
		tmp143__ |= (pSrc->is_ip_config_supported << 6);
		tmp143__ |= (pSrc->is_cache_id_present << 7);
		tmp143__ |= (pSrc->is_hessid_present << 8);
		tmp143__ |= (pSrc->is_fils_sk_auth_supported << 9);
		tmp143__ |= (pSrc->is_fils_sk_auth_pfs_supported << 10);
		tmp143__ |= (pSrc->is_pk_auth_supported << 11);
		tmp143__ |= (pSrc->reserved << 12);
		frameshtons(pCtx, pBuf, tmp143__, 0);
		*pnConsumed += 2;
		pBuf += 2;
		nBuf -=  2 ;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->variable_data), pSrc->num_variable_data);
		*pnConsumed += pSrc->num_variable_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_indication. */

uint32_t dot11f_pack_ie_fils_kde(tpAniSirGlobal pCtx,
				 tDot11fIEfils_kde *pSrc,
				 uint8_t *pBuf,
				 uint32_t nBuf,
				 uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_kde_list + 8);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 7;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->key_rsc, 8);
		*pnConsumed += 8;
		pBuf += 8;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->kde_list), pSrc->num_kde_list);
		*pnConsumed += pSrc->num_kde_list;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_kde. */

uint32_t dot11f_pack_ie_fils_key_confirmation(tpAniSirGlobal pCtx,
					      tDot11fIEfils_key_confirmation *pSrc,
					      uint8_t *pBuf,
					      uint32_t nBuf,
					      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_key_auth;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 3;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->key_auth), pSrc->num_key_auth);
		*pnConsumed += pSrc->num_key_auth;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_key_confirmation. */

uint32_t dot11f_pack_ie_fils_nonce(tpAniSirGlobal pCtx,
				   tDot11fIEfils_nonce *pSrc,
				   uint8_t *pBuf,
				   uint32_t nBuf,
				   uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 16;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 13;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->nonce, 16);
		*pnConsumed += 16;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_nonce. */

uint32_t dot11f_pack_ie_fils_public_key(tpAniSirGlobal pCtx,
					tDot11fIEfils_public_key *pSrc,
					uint8_t *pBuf,
					uint32_t nBuf,
					uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_public_key + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 12;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->key_type;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->public_key), pSrc->num_public_key);
		*pnConsumed += pSrc->num_public_key;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_public_key. */

uint32_t dot11f_pack_ie_fils_session(tpAniSirGlobal pCtx,
				     tDot11fIEfils_session *pSrc,
				     uint8_t *pBuf,
				     uint32_t nBuf,
				     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 8;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 4;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, pSrc->session, 8);
		*pnConsumed += 8;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_session. */

uint32_t dot11f_pack_ie_fils_wrapped_data(tpAniSirGlobal pCtx,
					  tDot11fIEfils_wrapped_data *pSrc,
					  uint8_t *pBuf,
					  uint32_t nBuf,
					  uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_wrapped_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 255;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 8;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->wrapped_data), pSrc->num_wrapped_data);
		*pnConsumed += pSrc->num_wrapped_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fils_wrapped_data. */

uint32_t dot11f_pack_ie_fragment_ie(tpAniSirGlobal pCtx,
				    tDot11fIEfragment_ie *pSrc,
				    uint8_t *pBuf,
				    uint32_t nBuf,
				    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 242;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_fragment_ie. */

uint32_t dot11f_pack_ie_hs20vendor_ie(tpAniSirGlobal pCtx,
				      tDot11fIEhs20vendor_ie *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp144__;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_hs20vendor_ie(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x6f;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9a;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x10;
		++pBuf; ++(*pnConsumed);
		tmp144__ = 0U;
		tmp144__ |= (pSrc->dgaf_dis << 0);
		tmp144__ |= (pSrc->hs_id_present << 1);
		tmp144__ |= (pSrc->reserved << 3);
		tmp144__ |= (pSrc->release_num << 4);
		*pBuf = tmp144__;
		*pnConsumed += 1;
		pBuf += 1;
		nBuf -=  1 ;
		if (pSrc->hs_id_present) {
			switch (pSrc->hs_id_present) {
			case 1:
				frameshtons(pCtx, pBuf, pSrc->hs_id.pps_mo.pps_mo_id, 0);
				*pnConsumed += 2;
				/* fieldsEndFlag = 1 */
				break;
			case 2:
				frameshtons(pCtx, pBuf, pSrc->hs_id.anqp_domain.anqp_domain_id, 0);
				*pnConsumed += 2;
				/* fieldsEndFlag = 1 */
				break;
			}
		} else {
			break;
		}
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_hs20vendor_ie. */

uint32_t dot11f_pack_ie_ht2040_bss_coexistence(tpAniSirGlobal pCtx,
					       tDot11fIEht2040_bss_coexistence *pSrc,
					       uint8_t *pBuf,
					       uint32_t nBuf,
					       uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint8_t tmp145__;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 72;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		tmp145__ = 0U;
		tmp145__ |= (pSrc->info_request << 0);
		tmp145__ |= (pSrc->forty_mhz_intolerant << 1);
		tmp145__ |= (pSrc->twenty_mhz_bsswidth_req << 2);
		tmp145__ |= (pSrc->obss_scan_exemption_req << 3);
		tmp145__ |= (pSrc->obss_scan_exemption_grant << 4);
		tmp145__ |= (pSrc->unused << 5);
		*pBuf = tmp145__;
		*pnConsumed += 1;
		/* fieldsEndFlag  = 1 */
		nBuf -=  1 ;
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ht2040_bss_coexistence. */

uint32_t dot11f_pack_ie_ht2040_bss_intolerant_report(tpAniSirGlobal pCtx,
						     tDot11fIEht2040_bss_intolerant_report *pSrc,
						     uint8_t *pBuf,
						     uint32_t nBuf,
						     uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  (pSrc->num_channel_list + 1);
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 73;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->operating_class;
		*pnConsumed += 1;
		pBuf += 1;
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->channel_list), pSrc->num_channel_list);
		*pnConsumed += pSrc->num_channel_list;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_ht2040_bss_intolerant_report. */

uint32_t dot11f_pack_ie_osen_ie(tpAniSirGlobal pCtx,
				tDot11fIEosen_ie *pSrc,
				uint8_t *pBuf,
				uint32_t nBuf,
				uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  +=  pSrc->num_data;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x50;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x6f;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x9a;
		++pBuf; ++(*pnConsumed);
		*pBuf = 0x12;
		++pBuf; ++(*pnConsumed);
		DOT11F_MEMCPY(pCtx, pBuf, &(pSrc->data), pSrc->num_data);
		*pnConsumed += pSrc->num_data;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_osen_ie. */

uint32_t dot11f_pack_ie_sec_chan_offset_ele(tpAniSirGlobal pCtx,
					    tDot11fIEsec_chan_offset_ele *pSrc,
					    uint8_t *pBuf,
					    uint32_t nBuf,
					    uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	nNeeded  += 1;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 62;
		++pBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; ++(*pnConsumed);
		*pBuf = pSrc->secondaryChannelOffset;
		*pnConsumed += 1;
		/* fieldsEndFlag = 1 */
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return DOT11F_PARSE_SUCCESS;
} /* End dot11f_pack_ie_sec_chan_offset_ele. */

uint32_t dot11f_pack_ie_vendor_vht_ie(tpAniSirGlobal pCtx,
				      tDot11fIEvendor_vht_ie *pSrc,
				      uint8_t *pBuf,
				      uint32_t nBuf,
				      uint32_t *pnConsumed)
{
	uint8_t *pIeLen = 0;
	uint32_t nConsumedOnEntry = *pnConsumed;
	uint32_t nNeeded = 0U;
	uint32_t status = DOT11F_PARSE_SUCCESS;
	status = dot11f_get_packed_ie_vendor_vht_ie(pCtx, pSrc, &nNeeded);
	if (!DOT11F_SUCCEEDED(status))
		return status;
	while (pSrc->present) {
		if (nNeeded > nBuf)
			return DOT11F_BUFFER_OVERFLOW;
		*pBuf = 221;
		++pBuf; --nBuf; ++(*pnConsumed);
		pIeLen = pBuf;
		++pBuf; --nBuf; ++(*pnConsumed);
		*pBuf = 0x0;
		++pBuf; --nBuf; ++(*pnConsumed);
		*pBuf = 0x90;
		++pBuf; --nBuf; ++(*pnConsumed);
		*pBuf = 0x4c;
		++pBuf; --nBuf; ++(*pnConsumed);
		*pBuf = 0x4;
		++pBuf; --nBuf; ++(*pnConsumed);
		*pBuf = pSrc->sub_type;
		*pnConsumed += 1;
		pBuf += 1;
		status = pack_core(pCtx,
				(uint8_t *)pSrc,
				pBuf,
				nBuf,
				pnConsumed,
				FFS_vendor_vht_ie,
				IES_vendor_vht_ie);
		break;
	}
	(void)pCtx;
	if (pIeLen) {
		*pIeLen = *pnConsumed - nConsumedOnEntry - 2;
	}
	return status;
} /* End dot11f_pack_ie_vendor_vht_ie. */

uint32_t dot11f_pack_add_ts_request(tpAniSirGlobal pCtx,
	tDot11fAddTSRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_AddTSRequest, IES_AddTSRequest);

	return status;

} /* End dot11f_unpack_add_ts_request. */

uint32_t dot11f_pack_add_ts_response(tpAniSirGlobal pCtx,
	tDot11fAddTSResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_AddTSResponse, IES_AddTSResponse);

	return status;

} /* End dot11f_unpack_add_ts_response. */

uint32_t dot11f_pack_assoc_request(tpAniSirGlobal pCtx,
	tDot11fAssocRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_AssocRequest, IES_AssocRequest);

	return status;

} /* End dot11f_unpack_assoc_request. */

uint32_t dot11f_pack_assoc_response(tpAniSirGlobal pCtx,
	tDot11fAssocResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_AssocResponse, IES_AssocResponse);

	return status;

} /* End dot11f_unpack_assoc_response. */

uint32_t dot11f_pack_authentication(tpAniSirGlobal pCtx,
	tDot11fAuthentication *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_Authentication, IES_Authentication);

	return status;

} /* End dot11f_unpack_authentication. */

uint32_t dot11f_pack_beacon(tpAniSirGlobal pCtx,
	tDot11fBeacon *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_Beacon, IES_Beacon);

	return status;

} /* End dot11f_unpack_beacon. */

uint32_t dot11f_pack_beacon1(tpAniSirGlobal pCtx,
	tDot11fBeacon1 *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_Beacon1, IES_Beacon1);

	return status;

} /* End dot11f_unpack_beacon1. */

uint32_t dot11f_pack_beacon2(tpAniSirGlobal pCtx,
	tDot11fBeacon2 *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_Beacon2, IES_Beacon2);

	return status;

} /* End dot11f_unpack_beacon2. */

uint32_t dot11f_pack_beacon_i_es(tpAniSirGlobal pCtx,
	tDot11fBeaconIEs *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_BeaconIEs, IES_BeaconIEs);

	return status;

} /* End dot11f_unpack_beacon_i_es. */

uint32_t dot11f_pack_channel_switch(tpAniSirGlobal pCtx,
	tDot11fChannelSwitch *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ChannelSwitch, IES_ChannelSwitch);

	return status;

} /* End dot11f_unpack_channel_switch. */

uint32_t dot11f_pack_de_auth(tpAniSirGlobal pCtx,
	tDot11fDeAuth *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_DeAuth, IES_DeAuth);

	return status;

} /* End dot11f_unpack_de_auth. */

uint32_t dot11f_pack_del_ts(tpAniSirGlobal pCtx,
	tDot11fDelTS *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_DelTS, IES_DelTS);

	return status;

} /* End dot11f_unpack_del_ts. */

uint32_t dot11f_pack_disassociation(tpAniSirGlobal pCtx,
	tDot11fDisassociation *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_Disassociation, IES_Disassociation);

	return status;

} /* End dot11f_unpack_disassociation. */

uint32_t dot11f_pack_link_measurement_report(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementReport *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_LinkMeasurementReport, IES_LinkMeasurementReport);

	return status;

} /* End dot11f_unpack_link_measurement_report. */

uint32_t dot11f_pack_link_measurement_request(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_LinkMeasurementRequest, IES_LinkMeasurementRequest);

	return status;

} /* End dot11f_unpack_link_measurement_request. */

uint32_t dot11f_pack_measurement_report(tpAniSirGlobal pCtx,
	tDot11fMeasurementReport *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_MeasurementReport, IES_MeasurementReport);

	return status;

} /* End dot11f_unpack_measurement_report. */

uint32_t dot11f_pack_measurement_request(tpAniSirGlobal pCtx,
	tDot11fMeasurementRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_MeasurementRequest, IES_MeasurementRequest);

	return status;

} /* End dot11f_unpack_measurement_request. */

uint32_t dot11f_pack_neighbor_report_request(tpAniSirGlobal pCtx,
	tDot11fNeighborReportRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_NeighborReportRequest, IES_NeighborReportRequest);

	return status;

} /* End dot11f_unpack_neighbor_report_request. */

uint32_t dot11f_pack_neighbor_report_response(tpAniSirGlobal pCtx,
	tDot11fNeighborReportResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_NeighborReportResponse, IES_NeighborReportResponse);

	return status;

} /* End dot11f_unpack_neighbor_report_response. */

uint32_t dot11f_pack_operating_mode(tpAniSirGlobal pCtx,
	tDot11fOperatingMode *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_OperatingMode, IES_OperatingMode);

	return status;

} /* End dot11f_unpack_operating_mode. */

uint32_t dot11f_pack_probe_request(tpAniSirGlobal pCtx,
	tDot11fProbeRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ProbeRequest, IES_ProbeRequest);

	return status;

} /* End dot11f_unpack_probe_request. */

uint32_t dot11f_pack_probe_response(tpAniSirGlobal pCtx,
	tDot11fProbeResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ProbeResponse, IES_ProbeResponse);

	return status;

} /* End dot11f_unpack_probe_response. */

uint32_t dot11f_pack_qos_map_configure(tpAniSirGlobal pCtx,
	tDot11fQosMapConfigure *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_QosMapConfigure, IES_QosMapConfigure);

	return status;

} /* End dot11f_unpack_qos_map_configure. */

uint32_t dot11f_pack_radio_measurement_report(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementReport *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_RadioMeasurementReport, IES_RadioMeasurementReport);

	return status;

} /* End dot11f_unpack_radio_measurement_report. */

uint32_t dot11f_pack_radio_measurement_request(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_RadioMeasurementRequest, IES_RadioMeasurementRequest);

	return status;

} /* End dot11f_unpack_radio_measurement_request. */

uint32_t dot11f_pack_re_assoc_request(tpAniSirGlobal pCtx,
	tDot11fReAssocRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ReAssocRequest, IES_ReAssocRequest);

	return status;

} /* End dot11f_unpack_re_assoc_request. */

uint32_t dot11f_pack_re_assoc_response(tpAniSirGlobal pCtx,
	tDot11fReAssocResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ReAssocResponse, IES_ReAssocResponse);

	return status;

} /* End dot11f_unpack_re_assoc_response. */

uint32_t dot11f_pack_sm_power_save(tpAniSirGlobal pCtx,
	tDot11fSMPowerSave *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_SMPowerSave, IES_SMPowerSave);

	return status;

} /* End dot11f_unpack_sm_power_save. */

uint32_t dot11f_pack_sa_query_req(tpAniSirGlobal pCtx,
	tDot11fSaQueryReq *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_SaQueryReq, IES_SaQueryReq);

	return status;

} /* End dot11f_unpack_sa_query_req. */

uint32_t dot11f_pack_sa_query_rsp(tpAniSirGlobal pCtx,
	tDot11fSaQueryRsp *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_SaQueryRsp, IES_SaQueryRsp);

	return status;

} /* End dot11f_unpack_sa_query_rsp. */

uint32_t dot11f_pack_tdls_dis_req(tpAniSirGlobal pCtx,
	tDot11fTDLSDisReq *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSDisReq, IES_TDLSDisReq);

	return status;

} /* End dot11f_unpack_tdls_dis_req. */

uint32_t dot11f_pack_tdls_dis_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSDisRsp *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSDisRsp, IES_TDLSDisRsp);

	return status;

} /* End dot11f_unpack_tdls_dis_rsp. */

uint32_t dot11f_pack_tdls_peer_traffic_ind(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficInd *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSPeerTrafficInd, IES_TDLSPeerTrafficInd);

	return status;

} /* End dot11f_unpack_tdls_peer_traffic_ind. */

uint32_t dot11f_pack_tdls_peer_traffic_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficRsp *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSPeerTrafficRsp, IES_TDLSPeerTrafficRsp);

	return status;

} /* End dot11f_unpack_tdls_peer_traffic_rsp. */

uint32_t dot11f_pack_tdls_setup_cnf(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupCnf *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSSetupCnf, IES_TDLSSetupCnf);

	return status;

} /* End dot11f_unpack_tdls_setup_cnf. */

uint32_t dot11f_pack_tdls_setup_req(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupReq *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSSetupReq, IES_TDLSSetupReq);

	return status;

} /* End dot11f_unpack_tdls_setup_req. */

uint32_t dot11f_pack_tdls_setup_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupRsp *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSSetupRsp, IES_TDLSSetupRsp);

	return status;

} /* End dot11f_unpack_tdls_setup_rsp. */

uint32_t dot11f_pack_tdls_teardown(tpAniSirGlobal pCtx,
	tDot11fTDLSTeardown *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TDLSTeardown, IES_TDLSTeardown);

	return status;

} /* End dot11f_unpack_tdls_teardown. */

uint32_t dot11f_pack_tpc_report(tpAniSirGlobal pCtx,
	tDot11fTPCReport *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TPCReport, IES_TPCReport);

	return status;

} /* End dot11f_unpack_tpc_report. */

uint32_t dot11f_pack_tpc_request(tpAniSirGlobal pCtx,
	tDot11fTPCRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TPCRequest, IES_TPCRequest);

	return status;

} /* End dot11f_unpack_tpc_request. */

uint32_t dot11f_pack_timing_advertisement_frame(tpAniSirGlobal pCtx,
	tDot11fTimingAdvertisementFrame *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_TimingAdvertisementFrame, IES_TimingAdvertisementFrame);

	return status;

} /* End dot11f_unpack_timing_advertisement_frame. */

uint32_t dot11f_pack_vht_gid_management_action_frame(tpAniSirGlobal pCtx,
	tDot11fVHTGidManagementActionFrame *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_VHTGidManagementActionFrame, IES_VHTGidManagementActionFrame);

	return status;

} /* End dot11f_unpack_vht_gid_management_action_frame. */

uint32_t dot11f_pack_wmm_add_ts_request(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSRequest *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_WMMAddTSRequest, IES_WMMAddTSRequest);

	return status;

} /* End dot11f_unpack_wmm_add_ts_request. */

uint32_t dot11f_pack_wmm_add_ts_response(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSResponse *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_WMMAddTSResponse, IES_WMMAddTSResponse);

	return status;

} /* End dot11f_unpack_wmm_add_ts_response. */

uint32_t dot11f_pack_wmm_del_ts(tpAniSirGlobal pCtx,
	tDot11fWMMDelTS *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_WMMDelTS, IES_WMMDelTS);

	return status;

} /* End dot11f_unpack_wmm_del_ts. */

uint32_t dot11f_pack_ext_channel_switch_action_frame(tpAniSirGlobal pCtx,
	tDot11fext_channel_switch_action_frame *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ext_channel_switch_action_frame, IES_ext_channel_switch_action_frame);

	return status;

} /* End dot11f_unpack_ext_channel_switch_action_frame. */

uint32_t dot11f_pack_ht2040_bss_coexistence_mgmt_action_frame(tpAniSirGlobal pCtx,
	tDot11fht2040_bss_coexistence_mgmt_action_frame *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_ht2040_bss_coexistence_mgmt_action_frame, IES_ht2040_bss_coexistence_mgmt_action_frame);

	return status;

} /* End dot11f_unpack_ht2040_bss_coexistence_mgmt_action_frame. */

uint32_t dot11f_pack_p2p_oper_chan_change_confirm(tpAniSirGlobal pCtx,
	tDot11fp2p_oper_chan_change_confirm *pFrm,
	uint8_t *pBuf, uint32_t nBuf, uint32_t *pnConsumed)
{
	uint32_t i = 0;
	uint32_t status = 0;
	(void)i;
	*pnConsumed = 0U;
	status = pack_core(pCtx, (uint8_t *)pFrm, pBuf, nBuf, pnConsumed,
			   FFS_p2p_oper_chan_change_confirm, IES_p2p_oper_chan_change_confirm);

	return status;

} /* End dot11f_unpack_p2p_oper_chan_change_confirm. */

static uint32_t pack_core(tpAniSirGlobal pCtx,
			   uint8_t *pSrc,
			   uint8_t *pBuf,
			   uint32_t  nBuf,
			   uint32_t *pnConsumed,
			   const tFFDefn  FFs[],
			   const tIEDefn  IEs[])
{
	const tFFDefn *pFf;
	const tIEDefn *pIe;
	tFRAMES_BOOL  *pfFound;
	uint8_t   *pBufRemaining;
	uint16_t  i;
	uint32_t  nBufRemaining, status, len;
	uint32_t  countOffset = 0;

	(void)pCtx; /* Shutup the compiler if we have no FFs nor IEs... */
	i = 0;

	DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed);

	status = DOT11F_PARSE_SUCCESS;
	pBufRemaining = pBuf;
	nBufRemaining = nBuf;

	pFf = &(FFs[0]);
	while (pFf->size) {
		if (pFf->size > nBufRemaining) {
			FRAMES_LOG3(pCtx, FRLOGE, FRFL("The Fixed Field %s req"
				"uires %d bytes, but there are only %d remaining.\n"),
				pFf->name, pFf->size, nBufRemaining);
			return DOT11F_BUFFER_OVERFLOW;
		}

		switch (pFf->sig) {
		case SigFfAID:
			dot11f_pack_ff_aid(
				pCtx, (tDot11fFfAID *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfAction:
			dot11f_pack_ff_action(
				pCtx, (tDot11fFfAction *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfAuthAlgo:
			dot11f_pack_ff_auth_algo(
				pCtx, (tDot11fFfAuthAlgo *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfAuthSeqNo:
			dot11f_pack_ff_auth_seq_no(
				pCtx, (tDot11fFfAuthSeqNo *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfBeaconInterval:
			dot11f_pack_ff_beacon_interval(
				pCtx, (tDot11fFfBeaconInterval *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfCapabilities:
			dot11f_pack_ff_capabilities(
				pCtx, (tDot11fFfCapabilities *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfCategory:
			dot11f_pack_ff_category(
				pCtx, (tDot11fFfCategory *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfCurrentAPAddress:
			dot11f_pack_ff_current_ap_address(
				pCtx, (tDot11fFfCurrentAPAddress *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfDialogToken:
			dot11f_pack_ff_dialog_token(
				pCtx, (tDot11fFfDialogToken *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfLinkMargin:
			dot11f_pack_ff_link_margin(
				pCtx, (tDot11fFfLinkMargin *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfListenInterval:
			dot11f_pack_ff_listen_interval(
				pCtx, (tDot11fFfListenInterval *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfMaxTxPower:
			dot11f_pack_ff_max_tx_power(
				pCtx, (tDot11fFfMaxTxPower *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfNumOfRepetitions:
			dot11f_pack_ff_num_of_repetitions(
				pCtx, (tDot11fFfNumOfRepetitions *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfOperatingMode:
			dot11f_pack_ff_operating_mode(
				pCtx, (tDot11fFfOperatingMode *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfRCPI:
			dot11f_pack_ff_rcpi(
				pCtx, (tDot11fFfRCPI *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfRSNI:
			dot11f_pack_ff_rsni(
				pCtx, (tDot11fFfRSNI *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfReason:
			dot11f_pack_ff_reason(
				pCtx, (tDot11fFfReason *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfRxAntennaId:
			dot11f_pack_ff_rx_antenna_id(
				pCtx, (tDot11fFfRxAntennaId *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfSMPowerModeSet:
			dot11f_pack_ff_sm_power_mode_set(
				pCtx, (tDot11fFfSMPowerModeSet *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfStatus:
			dot11f_pack_ff_status(
				pCtx, (tDot11fFfStatus *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfStatusCode:
			dot11f_pack_ff_status_code(
				pCtx, (tDot11fFfStatusCode *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTPCEleID:
			dot11f_pack_ff_tpc_ele_id(
				pCtx, (tDot11fFfTPCEleID *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTPCEleLen:
			dot11f_pack_ff_tpc_ele_len(
				pCtx, (tDot11fFfTPCEleLen *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTSInfo:
			dot11f_pack_ff_ts_info(
				pCtx, (tDot11fFfTSInfo *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTimeStamp:
			dot11f_pack_ff_time_stamp(
				pCtx, (tDot11fFfTimeStamp *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTransactionId:
			dot11f_pack_ff_transaction_id(
				pCtx, (tDot11fFfTransactionId *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTxAntennaId:
			dot11f_pack_ff_tx_antenna_id(
				pCtx, (tDot11fFfTxAntennaId *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfTxPower:
			dot11f_pack_ff_tx_power(
				pCtx, (tDot11fFfTxPower *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfVhtMembershipStatusArray:
			dot11f_pack_ff_vht_membership_status_array(
				pCtx, (tDot11fFfVhtMembershipStatusArray *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfVhtUserPositionArray:
			dot11f_pack_ff_vht_user_position_array(
				pCtx, (tDot11fFfVhtUserPositionArray *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfext_chan_switch_ann_action:
			dot11f_pack_ff_ext_chan_switch_ann_action(
				pCtx, (tDot11fFfext_chan_switch_ann_action *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfp2p_action_oui:
			dot11f_pack_ff_p2p_action_oui(
				pCtx, (tDot11fFfp2p_action_oui *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		case SigFfp2p_action_subtype:
			dot11f_pack_ff_p2p_action_subtype(
				pCtx, (tDot11fFfp2p_action_subtype *)
				(pSrc + pFf->offset), pBufRemaining);
			break;
		default:
			FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR-- I don"
				"'t know about the Fixed Field %d; this is most l"
				"ikely a bug in 'framesg'.\n"), pFf->sig);
			return DOT11F_INTERNAL_ERROR;
		}

		pBufRemaining += pFf->size;
		nBufRemaining -= pFf->size;
		*pnConsumed   += pFf->size;
		++pFf;

	}

	pIe = &(IEs[0]);
	while (0xff != pIe->eid || pIe->extn_eid) {
		pfFound = (tFRAMES_BOOL *)(pSrc + pIe->offset +
				pIe->presenceOffset);
		if (*pfFound && pIe->minSize > nBufRemaining) {
			FRAMES_LOG3(pCtx, FRLOGE, FRFL("The IE %s takes at le"
				"ast %d bytes, but there are only %d left in the b"
				"uffer.\n"), pIe->name, pIe->minSize, nBufRemaining);
			return DOT11F_BUFFER_OVERFLOW;
		}


		countOffset = ((0 == pIe->arraybound) ?  1 : *(uint16_t *)(pSrc + pIe->countOffset));
		for (i = 0; i < countOffset; ++i) {
			len = 0U;
			switch (pIe->sig) {
			case SigIeGTK:
			status |=
				dot11f_pack_ie_gtk(
				pCtx, (tDot11fIEGTK *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEGTK) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeIGTK:
			status |=
				dot11f_pack_ie_igtk(
				pCtx, (tDot11fIEIGTK *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEIGTK) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeR0KH_ID:
			status |=
				dot11f_pack_ie_r0_kh_id(
				pCtx, (tDot11fIER0KH_ID *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIER0KH_ID) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeR1KH_ID:
			status |=
				dot11f_pack_ie_r1_kh_id(
				pCtx, (tDot11fIER1KH_ID *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIER1KH_ID) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeAPChannelReport:
			status |=
				dot11f_pack_ie_ap_channel_report(
				pCtx, (tDot11fIEAPChannelReport *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEAPChannelReport) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeBcnReportingDetail:
			status |=
				dot11f_pack_ie_bcn_reporting_detail(
				pCtx, (tDot11fIEBcnReportingDetail *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEBcnReportingDetail) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeBeaconReportFrmBody:
			status |=
				dot11f_pack_ie_beacon_report_frm_body(
				pCtx, (tDot11fIEBeaconReportFrmBody *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEBeaconReportFrmBody) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeBeaconReporting:
			status |=
				dot11f_pack_ie_beacon_reporting(
				pCtx, (tDot11fIEBeaconReporting *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEBeaconReporting) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeCondensedCountryStr:
			status |=
				dot11f_pack_ie_condensed_country_str(
				pCtx, (tDot11fIECondensedCountryStr *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIECondensedCountryStr) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMeasurementPilot:
			status |=
				dot11f_pack_ie_measurement_pilot(
				pCtx, (tDot11fIEMeasurementPilot *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMeasurementPilot) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMultiBssid:
			status |=
				dot11f_pack_ie_multi_bssid(
				pCtx, (tDot11fIEMultiBssid *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMultiBssid) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRICData:
			status |=
				dot11f_pack_ie_ric_data(
				pCtx, (tDot11fIERICData *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERICData) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRICDescriptor:
			status |=
				dot11f_pack_ie_ric_descriptor(
				pCtx, (tDot11fIERICDescriptor *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERICDescriptor) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRRMEnabledCap:
			status |=
				dot11f_pack_ie_rrm_enabled_cap(
				pCtx, (tDot11fIERRMEnabledCap *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERRMEnabledCap) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRequestedInfo:
			status |=
				dot11f_pack_ie_requested_info(
				pCtx, (tDot11fIERequestedInfo *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERequestedInfo) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeSSID:
			status |=
				dot11f_pack_ie_ssid(
				pCtx, (tDot11fIESSID *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIESSID) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeSchedule:
			status |=
				dot11f_pack_ie_schedule(
				pCtx, (tDot11fIESchedule *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIESchedule) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTCLAS:
			status |=
				dot11f_pack_ie_tclas(
				pCtx, (tDot11fIETCLAS *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETCLAS) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTCLASSPROC:
			status |=
				dot11f_pack_ie_tclassproc(
				pCtx, (tDot11fIETCLASSPROC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETCLASSPROC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTSDelay:
			status |=
				dot11f_pack_ie_ts_delay(
				pCtx, (tDot11fIETSDelay *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETSDelay) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTSFInfo:
			status |=
				dot11f_pack_ie_tsf_info(
				pCtx, (tDot11fIETSFInfo *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETSFInfo) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTSPEC:
			status |=
				dot11f_pack_ie_tspec(
				pCtx, (tDot11fIETSPEC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETSPEC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeVHTCaps:
			status |=
				dot11f_pack_ie_vht_caps(
				pCtx, (tDot11fIEVHTCaps *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEVHTCaps) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeVHTOperation:
			status |=
				dot11f_pack_ie_vht_operation(
				pCtx, (tDot11fIEVHTOperation *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEVHTOperation) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMSchedule:
			status |=
				dot11f_pack_ie_wmm_schedule(
				pCtx, (tDot11fIEWMMSchedule *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMSchedule) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMTCLAS:
			status |=
				dot11f_pack_ie_wmmtclas(
				pCtx, (tDot11fIEWMMTCLAS *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMTCLAS) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMTCLASPROC:
			status |=
				dot11f_pack_ie_wmmtclasproc(
				pCtx, (tDot11fIEWMMTCLASPROC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMTCLASPROC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMTSDelay:
			status |=
				dot11f_pack_ie_wmmts_delay(
				pCtx, (tDot11fIEWMMTSDelay *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMTSDelay) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMTSPEC:
			status |=
				dot11f_pack_ie_wmmtspec(
				pCtx, (tDot11fIEWMMTSPEC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMTSPEC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWiderBWChanSwitchAnn:
			status |=
				dot11f_pack_ie_wider_bw_chan_switch_ann(
				pCtx, (tDot11fIEWiderBWChanSwitchAnn *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWiderBWChanSwitchAnn) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeazimuth_req:
			status |=
				dot11f_pack_ie_azimuth_req(
				pCtx, (tDot11fIEazimuth_req *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEazimuth_req) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIemax_age:
			status |=
				dot11f_pack_ie_max_age(
				pCtx, (tDot11fIEmax_age *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEmax_age) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeneighbor_rpt:
			status |=
				dot11f_pack_ie_neighbor_rpt(
				pCtx, (tDot11fIEneighbor_rpt *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEneighbor_rpt) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIereq_mac_addr:
			status |=
				dot11f_pack_ie_req_mac_addr(
				pCtx, (tDot11fIEreq_mac_addr *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEreq_mac_addr) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIetgt_mac_addr:
			status |=
				dot11f_pack_ie_tgt_mac_addr(
				pCtx, (tDot11fIEtgt_mac_addr *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEtgt_mac_addr) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIevht_transmit_power_env:
			status |=
				dot11f_pack_ie_vht_transmit_power_env(
				pCtx, (tDot11fIEvht_transmit_power_env *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEvht_transmit_power_env) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeAID:
			status |=
				dot11f_pack_ie_aid(
				pCtx, (tDot11fIEAID *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEAID) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeCFParams:
			status |=
				dot11f_pack_ie_cf_params(
				pCtx, (tDot11fIECFParams *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIECFParams) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeChallengeText:
			status |=
				dot11f_pack_ie_challenge_text(
				pCtx, (tDot11fIEChallengeText *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEChallengeText) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeChanSwitchAnn:
			status |=
				dot11f_pack_ie_chan_switch_ann(
				pCtx, (tDot11fIEChanSwitchAnn *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEChanSwitchAnn) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeChannelSwitchWrapper:
			status |=
				dot11f_pack_ie_channel_switch_wrapper(
				pCtx, (tDot11fIEChannelSwitchWrapper *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEChannelSwitchWrapper) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeCountry:
			status |=
				dot11f_pack_ie_country(
				pCtx, (tDot11fIECountry *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIECountry) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeDSParams:
			status |=
				dot11f_pack_ie_ds_params(
				pCtx, (tDot11fIEDSParams *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEDSParams) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeEDCAParamSet:
			status |=
				dot11f_pack_ie_edca_param_set(
				pCtx, (tDot11fIEEDCAParamSet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEEDCAParamSet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeERPInfo:
			status |=
				dot11f_pack_ie_erp_info(
				pCtx, (tDot11fIEERPInfo *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEERPInfo) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESECckmOpaque:
			status |=
				dot11f_pack_ie_ese_cckm_opaque(
				pCtx, (tDot11fIEESECckmOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESECckmOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESERadMgmtCap:
			status |=
				dot11f_pack_ie_ese_rad_mgmt_cap(
				pCtx, (tDot11fIEESERadMgmtCap *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESERadMgmtCap) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESETrafStrmMet:
			status |=
				dot11f_pack_ie_ese_traf_strm_met(
				pCtx, (tDot11fIEESETrafStrmMet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESETrafStrmMet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESETrafStrmRateSet:
			status |=
				dot11f_pack_ie_ese_traf_strm_rate_set(
				pCtx, (tDot11fIEESETrafStrmRateSet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESETrafStrmRateSet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESETxmitPower:
			status |=
				dot11f_pack_ie_ese_txmit_power(
				pCtx, (tDot11fIEESETxmitPower *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESETxmitPower) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESEVersion:
			status |=
				dot11f_pack_ie_ese_version(
				pCtx, (tDot11fIEESEVersion *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESEVersion) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeESP_information:
			status |=
				dot11f_pack_ie_ESP_information(
				pCtx, (tDot11fIEESP_information *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEESP_information) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeExtCap:
			status |=
				dot11f_pack_ie_ext_cap(
				pCtx, (tDot11fIEExtCap *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEExtCap) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeExtSuppRates:
			status |=
				dot11f_pack_ie_ext_supp_rates(
				pCtx, (tDot11fIEExtSuppRates *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEExtSuppRates) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeFHParamSet:
			status |=
				dot11f_pack_ie_fh_param_set(
				pCtx, (tDot11fIEFHParamSet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEFHParamSet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeFHParams:
			status |=
				dot11f_pack_ie_fh_params(
				pCtx, (tDot11fIEFHParams *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEFHParams) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeFHPattTable:
			status |=
				dot11f_pack_ie_fh_patt_table(
				pCtx, (tDot11fIEFHPattTable *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEFHPattTable) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeFTInfo:
			status |=
				dot11f_pack_ie_ft_info(
				pCtx, (tDot11fIEFTInfo *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEFTInfo) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeHTCaps:
			status |=
				dot11f_pack_ie_ht_caps(
				pCtx, (tDot11fIEHTCaps *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEHTCaps) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeHTInfo:
			status |=
				dot11f_pack_ie_ht_info(
				pCtx, (tDot11fIEHTInfo *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEHTInfo) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeIBSSParams:
			status |=
				dot11f_pack_ie_ibss_params(
				pCtx, (tDot11fIEIBSSParams *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEIBSSParams) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeLinkIdentifier:
			status |=
				dot11f_pack_ie_link_identifier(
				pCtx, (tDot11fIELinkIdentifier *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIELinkIdentifier) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMBO_IE:
			status |=
				dot11f_pack_ie_MBO_IE(
				pCtx, (tDot11fIEMBO_IE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMBO_IE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMeasurementReport:
			status |=
				dot11f_pack_ie_measurement_report(
				pCtx, (tDot11fIEMeasurementReport *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMeasurementReport) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMeasurementRequest:
			status |=
				dot11f_pack_ie_measurement_request(
				pCtx, (tDot11fIEMeasurementRequest *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMeasurementRequest) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeMobilityDomain:
			status |=
				dot11f_pack_ie_mobility_domain(
				pCtx, (tDot11fIEMobilityDomain *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEMobilityDomain) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeNeighborReport:
			status |=
				dot11f_pack_ie_neighbor_report(
				pCtx, (tDot11fIENeighborReport *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIENeighborReport) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeOBSSScanParameters:
			status |=
				dot11f_pack_ie_obss_scan_parameters(
				pCtx, (tDot11fIEOBSSScanParameters *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEOBSSScanParameters) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeOperatingMode:
			status |=
				dot11f_pack_ie_operating_mode(
				pCtx, (tDot11fIEOperatingMode *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEOperatingMode) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PAssocReq:
			status |=
				dot11f_pack_ie_p2_p_assoc_req(
				pCtx, (tDot11fIEP2PAssocReq *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PAssocReq) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PAssocRes:
			status |=
				dot11f_pack_ie_p2_p_assoc_res(
				pCtx, (tDot11fIEP2PAssocRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PAssocRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PBeacon:
			status |=
				dot11f_pack_ie_p2_p_beacon(
				pCtx, (tDot11fIEP2PBeacon *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PBeacon) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PBeaconProbeRes:
			status |=
				dot11f_pack_ie_p2_p_beacon_probe_res(
				pCtx, (tDot11fIEP2PBeaconProbeRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PBeaconProbeRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PDeAuth:
			status |=
				dot11f_pack_ie_p2_p_de_auth(
				pCtx, (tDot11fIEP2PDeAuth *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PDeAuth) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PDisAssoc:
			status |=
				dot11f_pack_ie_p2_p_dis_assoc(
				pCtx, (tDot11fIEP2PDisAssoc *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PDisAssoc) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PIEOpaque:
			status |=
				dot11f_pack_ie_p2_pie_opaque(
				pCtx, (tDot11fIEP2PIEOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PIEOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PProbeReq:
			status |=
				dot11f_pack_ie_p2_p_probe_req(
				pCtx, (tDot11fIEP2PProbeReq *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PProbeReq) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeP2PProbeRes:
			status |=
				dot11f_pack_ie_p2_p_probe_res(
				pCtx, (tDot11fIEP2PProbeRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEP2PProbeRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIePTIControl:
			status |=
				dot11f_pack_ie_pti_control(
				pCtx, (tDot11fIEPTIControl *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEPTIControl) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIePUBufferStatus:
			status |=
				dot11f_pack_ie_pu_buffer_status(
				pCtx, (tDot11fIEPUBufferStatus *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEPUBufferStatus) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIePowerCaps:
			status |=
				dot11f_pack_ie_power_caps(
				pCtx, (tDot11fIEPowerCaps *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEPowerCaps) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIePowerConstraints:
			status |=
				dot11f_pack_ie_power_constraints(
				pCtx, (tDot11fIEPowerConstraints *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEPowerConstraints) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQBSSLoad:
			status |=
				dot11f_pack_ie_qbss_load(
				pCtx, (tDot11fIEQBSSLoad *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQBSSLoad) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQCN_IE:
			status |=
				dot11f_pack_ie_QCN_IE(
				pCtx, (tDot11fIEQCN_IE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQCN_IE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQComVendorIE:
			status |=
				dot11f_pack_ie_QComVendorIE(
				pCtx, (tDot11fIEQComVendorIE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQComVendorIE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQOSCapsAp:
			status |=
				dot11f_pack_ie_qos_caps_ap(
				pCtx, (tDot11fIEQOSCapsAp *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQOSCapsAp) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQOSCapsStation:
			status |=
				dot11f_pack_ie_qos_caps_station(
				pCtx, (tDot11fIEQOSCapsStation *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQOSCapsStation) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQosMapSet:
			status |=
				dot11f_pack_ie_qos_map_set(
				pCtx, (tDot11fIEQosMapSet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQosMapSet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeQuiet:
			status |=
				dot11f_pack_ie_quiet(
				pCtx, (tDot11fIEQuiet *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEQuiet) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRCPIIE:
			status |=
				dot11f_pack_ie_rcpiie(
				pCtx, (tDot11fIERCPIIE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERCPIIE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRICDataDesc:
			status |=
				dot11f_pack_ie_ric_data_desc(
				pCtx, (tDot11fIERICDataDesc *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERICDataDesc) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRSN:
			status |=
				dot11f_pack_ie_rsn(
				pCtx, (tDot11fIERSN *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERSN) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRSNIIE:
			status |=
				dot11f_pack_ie_rsniie(
				pCtx, (tDot11fIERSNIIE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERSNIIE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeRSNOpaque:
			status |=
				dot11f_pack_ie_rsn_opaque(
				pCtx, (tDot11fIERSNOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIERSNOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeSuppChannels:
			status |=
				dot11f_pack_ie_supp_channels(
				pCtx, (tDot11fIESuppChannels *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIESuppChannels) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeSuppOperatingClasses:
			status |=
				dot11f_pack_ie_supp_operating_classes(
				pCtx, (tDot11fIESuppOperatingClasses *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIESuppOperatingClasses) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeSuppRates:
			status |=
				dot11f_pack_ie_supp_rates(
				pCtx, (tDot11fIESuppRates *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIESuppRates) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTIM:
			status |=
				dot11f_pack_ie_tim(
				pCtx, (tDot11fIETIM *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETIM) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTPCReport:
			status |=
				dot11f_pack_ie_tpc_report(
				pCtx, (tDot11fIETPCReport *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETPCReport) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTPCRequest:
			status |=
				dot11f_pack_ie_tpc_request(
				pCtx, (tDot11fIETPCRequest *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETPCRequest) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTimeAdvertisement:
			status |=
				dot11f_pack_ie_time_advertisement(
				pCtx, (tDot11fIETimeAdvertisement *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETimeAdvertisement) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeTimeoutInterval:
			status |=
				dot11f_pack_ie_timeout_interval(
				pCtx, (tDot11fIETimeoutInterval *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIETimeoutInterval) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeVHTExtBssLoad:
			status |=
				dot11f_pack_ie_vht_ext_bss_load(
				pCtx, (tDot11fIEVHTExtBssLoad *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEVHTExtBssLoad) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeVendor1IE:
			status |=
				dot11f_pack_ie_vendor1_ie(
				pCtx, (tDot11fIEVendor1IE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEVendor1IE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeVendor3IE:
			status |=
				dot11f_pack_ie_vendor3_ie(
				pCtx, (tDot11fIEVendor3IE *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEVendor3IE) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWAPI:
			status |=
				dot11f_pack_ie_wapi(
				pCtx, (tDot11fIEWAPI *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWAPI) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWAPIOpaque:
			status |=
				dot11f_pack_ie_wapi_opaque(
				pCtx, (tDot11fIEWAPIOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWAPIOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWFATPC:
			status |=
				dot11f_pack_ie_wfatpc(
				pCtx, (tDot11fIEWFATPC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWFATPC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWFDIEOpaque:
			status |=
				dot11f_pack_ie_wfdie_opaque(
				pCtx, (tDot11fIEWFDIEOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWFDIEOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMCaps:
			status |=
				dot11f_pack_ie_wmm_caps(
				pCtx, (tDot11fIEWMMCaps *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMCaps) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMInfoAp:
			status |=
				dot11f_pack_ie_wmm_info_ap(
				pCtx, (tDot11fIEWMMInfoAp *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMInfoAp) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMInfoStation:
			status |=
				dot11f_pack_ie_wmm_info_station(
				pCtx, (tDot11fIEWMMInfoStation *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMInfoStation) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWMMParams:
			status |=
				dot11f_pack_ie_wmm_params(
				pCtx, (tDot11fIEWMMParams *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWMMParams) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWPA:
			status |=
				dot11f_pack_ie_wpa(
				pCtx, (tDot11fIEWPA *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWPA) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWPAOpaque:
			status |=
				dot11f_pack_ie_wpa_opaque(
				pCtx, (tDot11fIEWPAOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWPAOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWSC:
			status |=
				dot11f_pack_ie_wsc(
				pCtx, (tDot11fIEWSC *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWSC) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscAssocReq:
			status |=
				dot11f_pack_ie_wsc_assoc_req(
				pCtx, (tDot11fIEWscAssocReq *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscAssocReq) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscAssocRes:
			status |=
				dot11f_pack_ie_wsc_assoc_res(
				pCtx, (tDot11fIEWscAssocRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscAssocRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscBeacon:
			status |=
				dot11f_pack_ie_wsc_beacon(
				pCtx, (tDot11fIEWscBeacon *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscBeacon) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscBeaconProbeRes:
			status |=
				dot11f_pack_ie_wsc_beacon_probe_res(
				pCtx, (tDot11fIEWscBeaconProbeRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscBeaconProbeRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscIEOpaque:
			status |=
				dot11f_pack_ie_wsc_ie_opaque(
				pCtx, (tDot11fIEWscIEOpaque *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscIEOpaque) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscProbeReq:
			status |=
				dot11f_pack_ie_wsc_probe_req(
				pCtx, (tDot11fIEWscProbeReq *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscProbeReq) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscProbeRes:
			status |=
				dot11f_pack_ie_wsc_probe_res(
				pCtx, (tDot11fIEWscProbeRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscProbeRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeWscReassocRes:
			status |=
				dot11f_pack_ie_wsc_reassoc_res(
				pCtx, (tDot11fIEWscReassocRes *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEWscReassocRes) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeext_chan_switch_ann:
			status |=
				dot11f_pack_ie_ext_chan_switch_ann(
				pCtx, (tDot11fIEext_chan_switch_ann *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEext_chan_switch_ann) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_assoc_delay_info:
			status |=
				dot11f_pack_ie_fils_assoc_delay_info(
				pCtx, (tDot11fIEfils_assoc_delay_info *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_assoc_delay_info) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_hlp_container:
			status |=
				dot11f_pack_ie_fils_hlp_container(
				pCtx, (tDot11fIEfils_hlp_container *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_hlp_container) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_indication:
			status |=
				dot11f_pack_ie_fils_indication(
				pCtx, (tDot11fIEfils_indication *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_indication) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_kde:
			status |=
				dot11f_pack_ie_fils_kde(
				pCtx, (tDot11fIEfils_kde *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_kde) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_key_confirmation:
			status |=
				dot11f_pack_ie_fils_key_confirmation(
				pCtx, (tDot11fIEfils_key_confirmation *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_key_confirmation) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_nonce:
			status |=
				dot11f_pack_ie_fils_nonce(
				pCtx, (tDot11fIEfils_nonce *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_nonce) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_public_key:
			status |=
				dot11f_pack_ie_fils_public_key(
				pCtx, (tDot11fIEfils_public_key *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_public_key) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_session:
			status |=
				dot11f_pack_ie_fils_session(
				pCtx, (tDot11fIEfils_session *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_session) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefils_wrapped_data:
			status |=
				dot11f_pack_ie_fils_wrapped_data(
				pCtx, (tDot11fIEfils_wrapped_data *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfils_wrapped_data) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIefragment_ie:
			status |=
				dot11f_pack_ie_fragment_ie(
				pCtx, (tDot11fIEfragment_ie *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEfragment_ie) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIehs20vendor_ie:
			status |=
				dot11f_pack_ie_hs20vendor_ie(
				pCtx, (tDot11fIEhs20vendor_ie *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEhs20vendor_ie) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeht2040_bss_coexistence:
			status |=
				dot11f_pack_ie_ht2040_bss_coexistence(
				pCtx, (tDot11fIEht2040_bss_coexistence *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEht2040_bss_coexistence) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeht2040_bss_intolerant_report:
			status |=
				dot11f_pack_ie_ht2040_bss_intolerant_report(
				pCtx, (tDot11fIEht2040_bss_intolerant_report *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEht2040_bss_intolerant_report) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIeosen_ie:
			status |=
				dot11f_pack_ie_osen_ie(
				pCtx, (tDot11fIEosen_ie *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEosen_ie) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIesec_chan_offset_ele:
			status |=
				dot11f_pack_ie_sec_chan_offset_ele(
				pCtx, (tDot11fIEsec_chan_offset_ele *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEsec_chan_offset_ele) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			case SigIevendor_vht_ie:
			status |=
				dot11f_pack_ie_vendor_vht_ie(
				pCtx, (tDot11fIEvendor_vht_ie *)
				(pSrc + pIe->offset +
				sizeof(tDot11fIEvendor_vht_ie) * i),
				pBufRemaining, nBufRemaining, &len);
			break;
			default:
				FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR-- I don"
				"'t know about the IE %d; this is most likely a b"
				"ug in 'framesc'.\n"), pFf->sig);
				return DOT11F_INTERNAL_ERROR;
			}

			pBufRemaining += len;
			nBufRemaining -= len;
			*pnConsumed   += len;
		}

		++pIe;

	}

	return status;

}

static uint32_t pack_tlv_core(tpAniSirGlobal pCtx,
				uint8_t *pSrc,
				uint8_t *pBuf,
				uint32_t  nBuf,
				uint32_t *pnConsumed,
				const tTLVDefn  TLVs[],
				uint32_t *pidx)
{
	const tTLVDefn *pTlv;
	tFRAMES_BOOL   *pfFound;
	uint8_t    *pBufRemaining;
	uint32_t   nBufRemaining, status, len;

	DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed);

	(void)pCtx;
	status = DOT11F_PARSE_SUCCESS;
	pBufRemaining = pBuf;
	nBufRemaining = nBuf;

	pTlv = &(TLVs[0]);
	while (0xffff != pTlv->id) {
		pfFound = (tFRAMES_BOOL *)(pSrc + pTlv->offset +
					pTlv->presenceOffset);
		if (*pfFound && pTlv->minSize > nBufRemaining) {
			FRAMES_LOG3(pCtx, FRLOGE, FRFL("The TLV %s takes at least"
			    " %d bytes, but there are only %d left in the buffer."
			    "\n"), pTlv->name, pTlv->minSize, nBufRemaining);
			return DOT11F_BUFFER_OVERFLOW;
		}

		len = 0U;

		if (*pfFound) {
			switch (pTlv->sig) {
			case SigTlvAuthorizedMACs:
				status |=
					dot11f_pack_tlv_authorized_ma_cs(
					pCtx, (tDot11fTLVAuthorizedMACs *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvRequestToEnroll:
				status |=
					dot11f_pack_tlv_request_to_enroll(
					pCtx, (tDot11fTLVRequestToEnroll *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvVersion2:
				status |=
					dot11f_pack_tlv_version2(
					pCtx, (tDot11fTLVVersion2 *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvAPSetupLocked:
				status |=
					dot11f_pack_tlv_ap_setup_locked(
					pCtx, (tDot11fTLVAPSetupLocked *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvAssociationState:
				status |=
					dot11f_pack_tlv_association_state(
					pCtx, (tDot11fTLVAssociationState *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvConfigMethods:
				status |=
					dot11f_pack_tlv_config_methods(
					pCtx, (tDot11fTLVConfigMethods *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvConfigurationError:
				status |=
					dot11f_pack_tlv_configuration_error(
					pCtx, (tDot11fTLVConfigurationError *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvDeviceName:
				status |=
					dot11f_pack_tlv_device_name(
					pCtx, (tDot11fTLVDeviceName *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvDevicePasswordID:
				status |=
					dot11f_pack_tlv_device_password_id(
					pCtx, (tDot11fTLVDevicePasswordID *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvExtendedListenTiming:
				status |=
					dot11f_pack_tlv_extended_listen_timing(
					pCtx, (tDot11fTLVExtendedListenTiming *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvListenChannel:
				status |=
					dot11f_pack_tlv_listen_channel(
					pCtx, (tDot11fTLVListenChannel *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvManufacturer:
				status |=
					dot11f_pack_tlv_manufacturer(
					pCtx, (tDot11fTLVManufacturer *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvMinorReasonCode:
				status |=
					dot11f_pack_tlv_minor_reason_code(
					pCtx, (tDot11fTLVMinorReasonCode *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvModelName:
				status |=
					dot11f_pack_tlv_model_name(
					pCtx, (tDot11fTLVModelName *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvModelNumber:
				status |=
					dot11f_pack_tlv_model_number(
					pCtx, (tDot11fTLVModelNumber *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvNoticeOfAbsence:
				status |=
					dot11f_pack_tlv_notice_of_absence(
					pCtx, (tDot11fTLVNoticeOfAbsence *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvOperatingChannel:
				status |=
					dot11f_pack_tlv_operating_channel(
					pCtx, (tDot11fTLVOperatingChannel *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PCapability:
				status |=
					dot11f_pack_tlv_p2_p_capability(
					pCtx, (tDot11fTLVP2PCapability *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PDeviceId:
				status |=
					dot11f_pack_tlv_p2_p_device_id(
					pCtx, (tDot11fTLVP2PDeviceId *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PDeviceInfo:
				status |=
					dot11f_pack_tlv_p2_p_device_info(
					pCtx, (tDot11fTLVP2PDeviceInfo *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PGroupInfo:
				status |=
					dot11f_pack_tlv_p2_p_group_info(
					pCtx, (tDot11fTLVP2PGroupInfo *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PStatus:
				status |=
					dot11f_pack_tlv_p2_p_status(
					pCtx, (tDot11fTLVP2PStatus *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvPrimaryDeviceType:
				status |=
					dot11f_pack_tlv_primary_device_type(
					pCtx, (tDot11fTLVPrimaryDeviceType *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvRFBands:
				status |=
					dot11f_pack_tlv_rf_bands(
					pCtx, (tDot11fTLVRFBands *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvRequestDeviceType:
				status |=
					dot11f_pack_tlv_request_device_type(
					pCtx, (tDot11fTLVRequestDeviceType *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvRequestType:
				status |=
					dot11f_pack_tlv_request_type(
					pCtx, (tDot11fTLVRequestType *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvResponseType:
				status |=
					dot11f_pack_tlv_response_type(
					pCtx, (tDot11fTLVResponseType *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvSelectedRegistrar:
				status |=
					dot11f_pack_tlv_selected_registrar(
					pCtx, (tDot11fTLVSelectedRegistrar *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvSelectedRegistrarConfigMethods:
				status |=
					dot11f_pack_tlv_selected_registrar_config_methods(
					pCtx, (tDot11fTLVSelectedRegistrarConfigMethods *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvSerialNumber:
				status |=
					dot11f_pack_tlv_serial_number(
					pCtx, (tDot11fTLVSerialNumber *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvUUID_E:
				status |=
					dot11f_pack_tlv_uuid_e(
					pCtx, (tDot11fTLVUUID_E *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvUUID_R:
				status |=
					dot11f_pack_tlv_uuid_r(
					pCtx, (tDot11fTLVUUID_R *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvVendorExtension:
				status |=
					dot11f_pack_tlv_vendor_extension(
					pCtx, (tDot11fTLVVendorExtension *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvVersion:
				status |=
					dot11f_pack_tlv_version(
					pCtx, (tDot11fTLVVersion *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvWPSState:
				status |=
					dot11f_pack_tlv_wps_state(
					pCtx, (tDot11fTLVWPSState *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvassoc_disallowed:
				status |=
					dot11f_pack_tlv_assoc_disallowed(
					pCtx, (tDot11fTLVassoc_disallowed *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvassoc_retry_delay:
				status |=
					dot11f_pack_tlv_assoc_retry_delay(
					pCtx, (tDot11fTLVassoc_retry_delay *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvcellular_data_cap:
				status |=
					dot11f_pack_tlv_cellular_data_cap(
					pCtx, (tDot11fTLVcellular_data_cap *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvcellular_data_con_pref:
				status |=
					dot11f_pack_tlv_cellular_data_con_pref(
					pCtx, (tDot11fTLVcellular_data_con_pref *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvmbo_ap_cap:
				status |=
					dot11f_pack_tlv_mbo_ap_cap(
					pCtx, (tDot11fTLVmbo_ap_cap *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvnon_prefferd_chan_rep:
				status |=
					dot11f_pack_tlv_non_prefferd_chan_rep(
					pCtx, (tDot11fTLVnon_prefferd_chan_rep *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvoce_cap:
				status |=
					dot11f_pack_tlv_oce_cap(
					pCtx, (tDot11fTLVoce_cap *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvreduced_wan_metrics:
				status |=
					dot11f_pack_tlv_reduced_wan_metrics(
					pCtx, (tDot11fTLVreduced_wan_metrics *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvrssi_assoc_rej:
				status |=
					dot11f_pack_tlv_rssi_assoc_rej(
					pCtx, (tDot11fTLVrssi_assoc_rej *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvtransition_reason:
				status |=
					dot11f_pack_tlv_transition_reason(
					pCtx, (tDot11fTLVtransition_reason *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvtransition_reject_reason:
				status |=
					dot11f_pack_tlv_transition_reject_reason(
					pCtx, (tDot11fTLVtransition_reject_reason *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PInterface:
				status |=
					dot11f_pack_tlv_p2_p_interface(
					pCtx, (tDot11fTLVP2PInterface *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			case SigTlvP2PManageability:
				status |=
					dot11f_pack_tlv_p2_p_manageability(
					pCtx, (tDot11fTLVP2PManageability *)
					(pSrc + pTlv->offset), pBufRemaining,
					nBufRemaining, &len);
				break;
			default:
				FRAMES_LOG1(pCtx, FRLOGE, FRFL("INTERNAL ERROR-- I don't "
				    "know about the TLV %d; this is most likely a bug in "
				    "'framesc'.\n"), pTlv->sig);
				return DOT11F_INTERNAL_ERROR;
			}

		} /* End if on *pfFound */
		pBufRemaining += len;
		nBufRemaining -= len;
		*pnConsumed   += len;
		++pTlv;
		if (len)
			++*pidx;
	}

	return status;

}
