/*
 * Copyright (c) 2012-2017 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

#ifndef DOT11F_H
#define DOT11F_H
/*
 * \file dot11f.h
 *
 * \brief Structures, function prototypes & definitions
 * for working with 802.11 Frames
 *
 *
 * This file was automatically generated by 'framesc'
 * Wed Dec 13 20:23:59 2017 from the following file(s):
 *
 * dot11f.frms
 *
 * PLEASE DON'T EDIT THIS FILE BY HAND!
 *
 * Instead, please update the input files & re-run
 * 'framesc'  For more information on 'framesc' & the
 * frames language,  run 'framesc --help'.
 *
 */

typedef uint32_t tDOT11F_U64[2];

#if defined (_MSC_VER)
#pragma warning (disable:4214)	/* nonstandard extension used */
#endif /* Microsoft C/C++             bit field types other than int */

/*
 * Frames Return Codes:
 *
 * Success is indicated by a return value of zero.  Failure is indicated
 * by the presence of the high bit.  Warnings encountered in the course
 * of a successful parse are indicated by various bits in the lower 31
 * being turned on.
 *
 * For instance, a return value of 0x0000000a would indicate that the
 * parse succeeded, but that a mandatory IE wasn't present, and some IE
 * was found to be corrupt.
 *
 *
 */

#define DOT11F_PARSE_SUCCESS         (0x00000000)
#define DOT11F_UNKNOWN_IES           (0x00000001)
#define DOT11F_MANDATORY_IE_MISSING  (0x00000002)
#define DOT11F_INCOMPLETE_IE         (0x00000004)
#define DOT11F_SKIPPED_BAD_IE        (0x00000008)
#define DOT11F_LAST_IE_TOO_LONG      (0x00000010)
#define DOT11F_DUPLICATE_IE          (0x00000020)
#define DOT11F_BAD_FIXED_VALUE       (0x00000040)
#define DOT11F_INCOMPLETE_TLV        (0x00000080)
#define DOT11F_INVALID_TLV_LENGTH    (0x00000100)
#define DOT11F_SKIPPED_BAD_TLV       (0x00000200)
#define DOT11F_UNKNOWN_TLVS          (0x00000400)
#define DOT11F_LAST_TLV_TOO_LONG     (0x00000800)
#define DOT11F_INTERNAL_ERROR        (0x10000001)
#define DOT11F_MISSING_FIXED_FIELD   (0x10000002)
#define DOT11F_BAD_INPUT_BUFFER      (0x10000003)
#define DOT11F_BAD_OUTPUT_BUFFER     (0x10000004)
#define DOT11F_BUFFER_OVERFLOW       (0x10000005)
#define DOT11F_MANDATORY_TLV_MISSING (0x00001000)
#define DOT11F_FAILED(code)          ((code) & 0x10000000)
#define DOT11F_SUCCEEDED(code)       ((code) == 0)
#define DOT11F_WARNED(code)          (!DOT11F_SUCCEEDED(code) && !DOT11F_FAILED(code))

/*********************************************************************
 * Fixed Fields                                                      *
 ********************************************************************/

typedef struct sDot11fFfAID {
	uint16_t associd;
} tDot11fFfAID;

#define DOT11F_FF_AID_LEN (2)

void dot11f_unpack_ff_AID(tpAniSirGlobal, uint8_t *, tDot11fFfAID *);

void dot11f_pack_ff_aid(tpAniSirGlobal, tDot11fFfAID *, uint8_t *);

typedef struct sDot11fFfAction {
	uint8_t action;
} tDot11fFfAction;

#define DOT11F_FF_ACTION_LEN (1)

void dot11f_unpack_ff_action(tpAniSirGlobal, uint8_t *, tDot11fFfAction *);

void dot11f_pack_ff_action(tpAniSirGlobal, tDot11fFfAction *, uint8_t *);

typedef struct sDot11fFfAuthAlgo {
	uint16_t algo;
} tDot11fFfAuthAlgo;

#define DOT11F_FF_AUTHALGO_LEN (2)

void dot11f_unpack_ff_AuthAlgo(tpAniSirGlobal, uint8_t *,
			       tDot11fFfAuthAlgo *);

void dot11f_pack_ff_auth_algo(tpAniSirGlobal, tDot11fFfAuthAlgo *, uint8_t *);

typedef struct sDot11fFfAuthSeqNo {
	uint16_t no;
} tDot11fFfAuthSeqNo;

#define DOT11F_FF_AUTHSEQNO_LEN (2)

void dot11f_unpack_ff_AuthSeqNo(tpAniSirGlobal, uint8_t *,
				tDot11fFfAuthSeqNo *);

void dot11f_pack_ff_auth_seq_no(tpAniSirGlobal, tDot11fFfAuthSeqNo *,
			      uint8_t *);

typedef struct sDot11fFfBeaconInterval {
	uint16_t interval;
} tDot11fFfBeaconInterval;

#define DOT11F_FF_BEACONINTERVAL_LEN (2)

void dot11f_unpack_ff_BeaconInterval(tpAniSirGlobal, uint8_t *,
				     tDot11fFfBeaconInterval *);

void dot11f_pack_ff_beacon_interval(tpAniSirGlobal, tDot11fFfBeaconInterval *,
				   uint8_t *);

typedef struct sDot11fFfCapabilities {
	uint16_t             ess:1;
	uint16_t            ibss:1;
	uint16_t      cfPollable:1;
	uint16_t       cfPollReq:1;
	uint16_t         privacy:1;
	uint16_t   shortPreamble:1;
	uint16_t            pbcc:1;
	uint16_t  channelAgility:1;
	uint16_t     spectrumMgt:1;
	uint16_t             qos:1;
	uint16_t   shortSlotTime:1;
	uint16_t            apsd:1;
	uint16_t             rrm:1;
	uint16_t        dsssOfdm:1;
	uint16_t       delayedBA:1;
	uint16_t     immediateBA:1;
} tDot11fFfCapabilities;

#define DOT11F_FF_CAPABILITIES_LEN (2)

void dot11f_unpack_ff_capabilities(tpAniSirGlobal, uint8_t *,
				   tDot11fFfCapabilities *);

void dot11f_pack_ff_capabilities(tpAniSirGlobal, tDot11fFfCapabilities *,
				 uint8_t *);

#define CAPABILITIES_ESS_OFFSET            0
#define CAPABILITIES_ESS_WIDTH             1
#define CAPABILITIES_IBSS_OFFSET           1
#define CAPABILITIES_IBSS_WIDTH            1
#define CAPABILITIES_CFPOLLABLE_OFFSET     2
#define CAPABILITIES_CFPOLLABLE_WIDTH      1
#define CAPABILITIES_CFPOLLREQ_OFFSET      3
#define CAPABILITIES_CFPOLLREQ_WIDTH       1
#define CAPABILITIES_PRIVACY_OFFSET        4
#define CAPABILITIES_PRIVACY_WIDTH         1
#define CAPABILITIES_SHORTPREAMBLE_OFFSET  5
#define CAPABILITIES_SHORTPREAMBLE_WIDTH   1
#define CAPABILITIES_PBCC_OFFSET           6
#define CAPABILITIES_PBCC_WIDTH            1
#define CAPABILITIES_CHANNELAGILITY_OFFSET 7
#define CAPABILITIES_CHANNELAGILITY_WIDTH  1
#define CAPABILITIES_SPECTRUMMGT_OFFSET    8
#define CAPABILITIES_SPECTRUMMGT_WIDTH     1
#define CAPABILITIES_QOS_OFFSET            9
#define CAPABILITIES_QOS_WIDTH             1
#define CAPABILITIES_SHORTSLOTTIME_OFFSET  10
#define CAPABILITIES_SHORTSLOTTIME_WIDTH   1
#define CAPABILITIES_APSD_OFFSET           11
#define CAPABILITIES_APSD_WIDTH            1
#define CAPABILITIES_RRM_OFFSET            12
#define CAPABILITIES_RRM_WIDTH             1
#define CAPABILITIES_DSSSOFDM_OFFSET       13
#define CAPABILITIES_DSSSOFDM_WIDTH        1
#define CAPABILITIES_DELAYEDBA_OFFSET      14
#define CAPABILITIES_DELAYEDBA_WIDTH       1
#define CAPABILITIES_IMMEDIATEBA_OFFSET    15
#define CAPABILITIES_IMMEDIATEBA_WIDTH     1

typedef struct sDot11fFfCategory {
	uint8_t category;
} tDot11fFfCategory;

#define DOT11F_FF_CATEGORY_LEN (1)

void dot11f_unpack_ff_category(tpAniSirGlobal, uint8_t *,
			       tDot11fFfCategory *);

void dot11f_pack_ff_category(tpAniSirGlobal, tDot11fFfCategory *, uint8_t *);

typedef struct sDot11fFfCurrentAPAddress {
	uint8_t mac[6];
} tDot11fFfCurrentAPAddress;

#define DOT11F_FF_CURRENTAPADDRESS_LEN (6)

void dot11f_unpack_ff_current_ap_address(tpAniSirGlobal, uint8_t *,
				       tDot11fFfCurrentAPAddress *);

void dot11f_pack_ff_current_ap_address(tpAniSirGlobal,
				     tDot11fFfCurrentAPAddress *,
				     uint8_t *);


typedef struct sDot11fFfDialogToken {
	uint8_t token;
} tDot11fFfDialogToken;

#define DOT11F_FF_DIALOGTOKEN_LEN (1)

void dot11f_unpack_ff_dialog_token(tpAniSirGlobal, uint8_t *,
				  tDot11fFfDialogToken *);

void dot11f_pack_ff_dialog_token(tpAniSirGlobal, tDot11fFfDialogToken *,
				uint8_t *);

typedef struct sDot11fFfLinkMargin {
	uint8_t linkMargin;
} tDot11fFfLinkMargin;

#define DOT11F_FF_LINKMARGIN_LEN (1)

void dot11f_unpack_ff_link_margin(tpAniSirGlobal, uint8_t *,
				 tDot11fFfLinkMargin *);

void dot11f_pack_ff_link_margin(tpAniSirGlobal, tDot11fFfLinkMargin *,
			       uint8_t *);

typedef struct sDot11fFfListenInterval {
	uint16_t interval;
} tDot11fFfListenInterval;

#define DOT11F_FF_LISTENINTERVAL_LEN (2)

void dot11f_unpack_ff_ListenInterval(tpAniSirGlobal, uint8_t *,
				     tDot11fFfListenInterval *);

void dot11f_pack_ff_listen_interval(tpAniSirGlobal, tDot11fFfListenInterval *,
				   uint8_t *);

typedef struct sDot11fFfMaxTxPower {
	uint8_t maxTxPower;
} tDot11fFfMaxTxPower;

#define DOT11F_FF_MAXTXPOWER_LEN (1)

void dot11f_unpack_ff_max_tx_power(tpAniSirGlobal, uint8_t *,
				 tDot11fFfMaxTxPower *);

void dot11f_pack_ff_max_tx_power(tpAniSirGlobal, tDot11fFfMaxTxPower *,
			       uint8_t *);

typedef struct sDot11fFfNumOfRepetitions {
	uint16_t repetitions;
} tDot11fFfNumOfRepetitions;

#define DOT11F_FF_NUMOFREPETITIONS_LEN (2)

void dot11f_unpack_ff_num_of_repetitions(tpAniSirGlobal, uint8_t *,
				       tDot11fFfNumOfRepetitions *);

void dot11f_pack_ff_num_of_repetitions(tpAniSirGlobal,
				     tDot11fFfNumOfRepetitions *,
				     uint8_t *);


typedef struct sDot11fFfOperatingMode {
	uint8_t  chanWidth:2;
	uint8_t   reserved:2;
	uint8_t      rxNSS:3;
	uint8_t  rxNSSType:1;
} tDot11fFfOperatingMode;

#define DOT11F_FF_OPERATINGMODE_LEN (1)

void dot11f_unpack_ff_operating_mode(tpAniSirGlobal, uint8_t *,
				    tDot11fFfOperatingMode *);

void dot11f_pack_ff_operating_mode(tpAniSirGlobal, tDot11fFfOperatingMode *,
				  uint8_t *);

#define OPERATINGMODE_CHANWIDTH_OFFSET 0
#define OPERATINGMODE_CHANWIDTH_WIDTH  2
#define OPERATINGMODE_RESERVED_OFFSET  2
#define OPERATINGMODE_RESERVED_WIDTH   2
#define OPERATINGMODE_RXNSS_OFFSET     4
#define OPERATINGMODE_RXNSS_WIDTH      3
#define OPERATINGMODE_RXNSSTYPE_OFFSET 7
#define OPERATINGMODE_RXNSSTYPE_WIDTH  1

typedef struct sDot11fFfRCPI {
	uint8_t rcpi;
} tDot11fFfRCPI;

#define DOT11F_FF_RCPI_LEN (1)

void dot11f_unpack_ff_rcpi(tpAniSirGlobal, uint8_t *, tDot11fFfRCPI *);

void dot11f_pack_ff_rcpi(tpAniSirGlobal, tDot11fFfRCPI *, uint8_t *);

typedef struct sDot11fFfRSNI {
	uint8_t rsni;
} tDot11fFfRSNI;

#define DOT11F_FF_RSNI_LEN (1)

void dot11f_unpack_ff_rsni(tpAniSirGlobal, uint8_t *, tDot11fFfRSNI *);

void dot11f_pack_ff_rsni(tpAniSirGlobal, tDot11fFfRSNI *, uint8_t *);

typedef struct sDot11fFfReason {
	uint16_t code;
} tDot11fFfReason;

#define DOT11F_FF_REASON_LEN (2)

void dot11f_unpack_ff_Reason(tpAniSirGlobal, uint8_t *, tDot11fFfReason *);

void dot11f_pack_ff_reason(tpAniSirGlobal, tDot11fFfReason *, uint8_t *);

typedef struct sDot11fFfRxAntennaId {
	uint8_t antennaId;
} tDot11fFfRxAntennaId;

#define DOT11F_FF_RXANTENNAID_LEN (1)

void dot11f_unpack_ff_rx_antenna_id(tpAniSirGlobal, uint8_t *,
				  tDot11fFfRxAntennaId *);

void dot11f_pack_ff_rx_antenna_id(tpAniSirGlobal, tDot11fFfRxAntennaId *,
				uint8_t *);

typedef struct sDot11fFfSMPowerModeSet {
	uint8_t  PowerSave_En:1;
	uint8_t          Mode:1;
	uint8_t      reserved:6;
} tDot11fFfSMPowerModeSet;

#define DOT11F_FF_SMPOWERMODESET_LEN (1)

void dot11f_unpack_ff_sm_power_mode_set(tpAniSirGlobal, uint8_t *,
				     tDot11fFfSMPowerModeSet *);

void dot11f_pack_ff_sm_power_mode_set(tpAniSirGlobal, tDot11fFfSMPowerModeSet *,
				   uint8_t *);

#define SMPOWERMODESET_POWERSAVE_EN_OFFSET 0
#define SMPOWERMODESET_POWERSAVE_EN_WIDTH  1
#define SMPOWERMODESET_MODE_OFFSET         1
#define SMPOWERMODESET_MODE_WIDTH          1
#define SMPOWERMODESET_RESERVED_OFFSET     2
#define SMPOWERMODESET_RESERVED_WIDTH      6

typedef struct sDot11fFfStatus {
	uint16_t status;
} tDot11fFfStatus;

#define DOT11F_FF_STATUS_LEN (2)

void dot11f_unpack_ff_Status(tpAniSirGlobal, uint8_t *, tDot11fFfStatus *);

void dot11f_pack_ff_status(tpAniSirGlobal, tDot11fFfStatus *, uint8_t *);

typedef struct sDot11fFfStatusCode {
	uint8_t statusCode;
} tDot11fFfStatusCode;

#define DOT11F_FF_STATUSCODE_LEN (1)

void dot11f_unpack_ff_status_code(tpAniSirGlobal, uint8_t *,
				 tDot11fFfStatusCode *);

void dot11f_pack_ff_status_code(tpAniSirGlobal, tDot11fFfStatusCode *,
			       uint8_t *);

typedef struct sDot11fFfTPCEleID {
	uint8_t TPCId;
} tDot11fFfTPCEleID;

#define DOT11F_FF_TPCELEID_LEN (1)

void dot11f_unpack_ff_tpc_ele_id(tpAniSirGlobal, uint8_t *,
			       tDot11fFfTPCEleID *);

void dot11f_pack_ff_tpc_ele_id(tpAniSirGlobal, tDot11fFfTPCEleID *, uint8_t *);

typedef struct sDot11fFfTPCEleLen {
	uint8_t TPCLen;
} tDot11fFfTPCEleLen;

#define DOT11F_FF_TPCELELEN_LEN (1)

void dot11f_unpack_ff_tpc_ele_len(tpAniSirGlobal, uint8_t *,
				tDot11fFfTPCEleLen *);

void dot11f_pack_ff_tpc_ele_len(tpAniSirGlobal, tDot11fFfTPCEleLen *,
			      uint8_t *);

typedef struct sDot11fFfTSInfo {
	uint32_t    traffic_type:1;
	uint32_t            tsid:4;
	uint32_t       direction:2;
	uint32_t   access_policy:2;
	uint32_t     aggregation:1;
	uint32_t             psb:1;
	uint32_t   user_priority:3;
	uint32_t  tsinfo_ack_pol:2;
	uint32_t        schedule:1;
	uint32_t          unused:15;
} tDot11fFfTSInfo;

#define DOT11F_FF_TSINFO_LEN (3)

void dot11f_unpack_ff_ts_info(tpAniSirGlobal, uint8_t *, tDot11fFfTSInfo *);

void dot11f_pack_ff_ts_info(tpAniSirGlobal, tDot11fFfTSInfo *, uint8_t *);

#define TSINFO_TRAFFIC_TYPE_OFFSET   0
#define TSINFO_TRAFFIC_TYPE_WIDTH    1
#define TSINFO_TSID_OFFSET           1
#define TSINFO_TSID_WIDTH            4
#define TSINFO_DIRECTION_OFFSET      5
#define TSINFO_DIRECTION_WIDTH       2
#define TSINFO_ACCESS_POLICY_OFFSET  7
#define TSINFO_ACCESS_POLICY_WIDTH   2
#define TSINFO_AGGREGATION_OFFSET    9
#define TSINFO_AGGREGATION_WIDTH     1
#define TSINFO_PSB_OFFSET            10
#define TSINFO_PSB_WIDTH             1
#define TSINFO_USER_PRIORITY_OFFSET  11
#define TSINFO_USER_PRIORITY_WIDTH   3
#define TSINFO_TSINFO_ACK_POL_OFFSET 14
#define TSINFO_TSINFO_ACK_POL_WIDTH  2
#define TSINFO_SCHEDULE_OFFSET       16
#define TSINFO_SCHEDULE_WIDTH        1
#define TSINFO_UNUSED_OFFSET         17
#define TSINFO_UNUSED_WIDTH          15

typedef struct sDot11fFfTimeStamp {
	tDOT11F_U64 timestamp;
} tDot11fFfTimeStamp;

#define DOT11F_FF_TIMESTAMP_LEN (8)

void dot11f_unpack_ff_time_stamp(tpAniSirGlobal, uint8_t *,
				tDot11fFfTimeStamp *);

void dot11f_pack_ff_time_stamp(tpAniSirGlobal, tDot11fFfTimeStamp *,
			      uint8_t *);

typedef struct sDot11fFfTransactionId {
	uint8_t transId[2];
} tDot11fFfTransactionId;

#define DOT11F_FF_TRANSACTIONID_LEN (2)

void dot11f_unpack_ff_transaction_id(tpAniSirGlobal, uint8_t *,
				    tDot11fFfTransactionId *);

void dot11f_pack_ff_transaction_id(tpAniSirGlobal, tDot11fFfTransactionId *,
				  uint8_t *);

typedef struct sDot11fFfTxAntennaId {
	uint8_t antennaId;
} tDot11fFfTxAntennaId;

#define DOT11F_FF_TXANTENNAID_LEN (1)

void dot11f_unpack_ff_tx_antenna_id(tpAniSirGlobal, uint8_t *,
				  tDot11fFfTxAntennaId *);

void dot11f_pack_ff_tx_antenna_id(tpAniSirGlobal, tDot11fFfTxAntennaId *,
				uint8_t *);

typedef struct sDot11fFfTxPower {
	uint8_t txPower;
} tDot11fFfTxPower;

#define DOT11F_FF_TXPOWER_LEN (1)

void dot11f_unpack_ff_tx_power(tpAniSirGlobal, uint8_t *,
			      tDot11fFfTxPower *);

void dot11f_pack_ff_tx_power(tpAniSirGlobal, tDot11fFfTxPower *, uint8_t *);

typedef struct sDot11fFfVhtMembershipStatusArray {
	uint8_t membershipStatusArray[8];
} tDot11fFfVhtMembershipStatusArray;

#define DOT11F_FF_VHTMEMBERSHIPSTATUSARRAY_LEN (8)

void dot11f_unpack_ff_vht_membership_status_array(tpAniSirGlobal, uint8_t *,
					       tDot11fFfVhtMembershipStatusArray *);

void dot11f_pack_ff_vht_membership_status_array(tpAniSirGlobal,
					     tDot11fFfVhtMembershipStatusArray *,
					     uint8_t *);


typedef struct sDot11fFfVhtUserPositionArray {
	uint8_t userPositionArray[16];
} tDot11fFfVhtUserPositionArray;

#define DOT11F_FF_VHTUSERPOSITIONARRAY_LEN (16)

void dot11f_unpack_ff_vht_user_position_array(tpAniSirGlobal, uint8_t *,
					   tDot11fFfVhtUserPositionArray *);

void dot11f_pack_ff_vht_user_position_array(tpAniSirGlobal,
					 tDot11fFfVhtUserPositionArray *,
					 uint8_t *);


typedef struct sDot11fFfext_chan_switch_ann_action {
	uint32_t   switch_mode:8;
	uint32_t      op_class:8;
	uint32_t   new_channel:8;
	uint32_t  switch_count:8;
} tDot11fFfext_chan_switch_ann_action;

#define DOT11F_FF_EXT_CHAN_SWITCH_ANN_ACTION_LEN (4)

void dot11f_unpack_ff_ext_chan_switch_ann_action(tpAniSirGlobal, uint8_t *,
						 tDot11fFfext_chan_switch_ann_action *);

void dot11f_pack_ff_ext_chan_switch_ann_action(tpAniSirGlobal,
					       tDot11fFfext_chan_switch_ann_action *,
					       uint8_t *);


#define EXT_CHAN_SWITCH_ANN_ACTION_SWITCH_MODE_OFFSET  0
#define EXT_CHAN_SWITCH_ANN_ACTION_SWITCH_MODE_WIDTH   8
#define EXT_CHAN_SWITCH_ANN_ACTION_OP_CLASS_OFFSET     8
#define EXT_CHAN_SWITCH_ANN_ACTION_OP_CLASS_WIDTH      8
#define EXT_CHAN_SWITCH_ANN_ACTION_NEW_CHANNEL_OFFSET  16
#define EXT_CHAN_SWITCH_ANN_ACTION_NEW_CHANNEL_WIDTH   8
#define EXT_CHAN_SWITCH_ANN_ACTION_SWITCH_COUNT_OFFSET 24
#define EXT_CHAN_SWITCH_ANN_ACTION_SWITCH_COUNT_WIDTH  8

typedef struct sDot11fFfp2p_action_oui {
	uint8_t oui_data[4];
} tDot11fFfp2p_action_oui;

#define DOT11F_FF_P2P_ACTION_OUI_LEN (4)

void dot11f_unpack_ff_p2p_action_oui(tpAniSirGlobal, uint8_t *,
				     tDot11fFfp2p_action_oui *);

void dot11f_pack_ff_p2p_action_oui(tpAniSirGlobal, tDot11fFfp2p_action_oui *,
				   uint8_t *);

typedef struct sDot11fFfp2p_action_subtype {
	uint8_t subtype;
} tDot11fFfp2p_action_subtype;

#define DOT11F_FF_P2P_ACTION_SUBTYPE_LEN (1)

void dot11f_unpack_ff_p2p_action_subtype(tpAniSirGlobal, uint8_t *,
					 tDot11fFfp2p_action_subtype *);

void dot11f_pack_ff_p2p_action_subtype(tpAniSirGlobal,
				       tDot11fFfp2p_action_subtype *,
				       uint8_t *);


/*********************************************************************
 * TLVs                                                              *
 ********************************************************************/


/* ID 1 (0x0001) */
typedef struct sDot11fTLVAuthorizedMACs {
	uint8_t             present;
	uint8_t             mac[6];
} tDot11fTLVAuthorizedMACs;

#define DOT11F_TLV_AUTHORIZEDMACS (1)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_AUTHORIZEDMACS_MIN_LEN (6)

#define DOT11F_TLV_AUTHORIZEDMACS_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_authorized_ma_cs(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVAuthorizedMACs*);

uint32_t dot11f_pack_tlv_authorized_ma_cs(
	tpAniSirGlobal,
	tDot11fTLVAuthorizedMACs *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_AuthorizedMACs(
	tpAniSirGlobal,
	tDot11fTLVAuthorizedMACs *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 3 (0x0003) */
typedef struct sDot11fTLVRequestToEnroll {
	uint8_t             present;
	uint8_t             req;
} tDot11fTLVRequestToEnroll;

#define DOT11F_TLV_REQUESTTOENROLL (3)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_REQUESTTOENROLL_MIN_LEN (1)

#define DOT11F_TLV_REQUESTTOENROLL_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_RequestToEnroll(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVRequestToEnroll*);

uint32_t dot11f_pack_tlv_request_to_enroll(
	tpAniSirGlobal,
	tDot11fTLVRequestToEnroll *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_RequestToEnroll(
	tpAniSirGlobal,
	tDot11fTLVRequestToEnroll *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 0 (0x0000) */
typedef struct sDot11fTLVVersion2 {
	uint8_t             present;
	uint8_t                minor:4;
	uint8_t                major:4;
} tDot11fTLVVersion2;

#define DOT11F_TLV_VERSION2 (0)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_VERSION2_MIN_LEN (1)

#define DOT11F_TLV_VERSION2_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_version2(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVVersion2*);

uint32_t dot11f_pack_tlv_version2(
	tpAniSirGlobal,
	tDot11fTLVVersion2 *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_Version2(
	tpAniSirGlobal,
	tDot11fTLVVersion2 *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4183 (0x1057) */
typedef struct sDot11fTLVAPSetupLocked {
	uint8_t             present;
	uint8_t             fLocked;
} tDot11fTLVAPSetupLocked;

#define DOT11F_TLV_APSETUPLOCKED (4183)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_APSETUPLOCKED_MIN_LEN (3)

#define DOT11F_TLV_APSETUPLOCKED_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_APSetupLocked(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVAPSetupLocked*);

uint32_t dot11f_pack_tlv_ap_setup_locked(
	tpAniSirGlobal,
	tDot11fTLVAPSetupLocked *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_APSetupLocked(
	tpAniSirGlobal,
	tDot11fTLVAPSetupLocked *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4098 (0x1002) */
typedef struct sDot11fTLVAssociationState {
	uint8_t             present;
	uint16_t            state;
} tDot11fTLVAssociationState;

#define DOT11F_TLV_ASSOCIATIONSTATE (4098)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_ASSOCIATIONSTATE_MIN_LEN (4)

#define DOT11F_TLV_ASSOCIATIONSTATE_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_AssociationState(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVAssociationState*);

uint32_t dot11f_pack_tlv_association_state(
	tpAniSirGlobal,
	tDot11fTLVAssociationState *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_AssociationState(
	tpAniSirGlobal,
	tDot11fTLVAssociationState *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4104 (0x1008) */
typedef struct sDot11fTLVConfigMethods {
	uint8_t             present;
	uint16_t            methods;
} tDot11fTLVConfigMethods;

#define DOT11F_TLV_CONFIGMETHODS (4104)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_CONFIGMETHODS_MIN_LEN (4)

#define DOT11F_TLV_CONFIGMETHODS_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_ConfigMethods(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVConfigMethods*);

uint32_t dot11f_pack_tlv_config_methods(
	tpAniSirGlobal,
	tDot11fTLVConfigMethods *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ConfigMethods(
	tpAniSirGlobal,
	tDot11fTLVConfigMethods *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4105 (0x1009) */
typedef struct sDot11fTLVConfigurationError {
	uint8_t             present;
	uint16_t            error;
} tDot11fTLVConfigurationError;

#define DOT11F_TLV_CONFIGURATIONERROR (4105)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_CONFIGURATIONERROR_MIN_LEN (4)

#define DOT11F_TLV_CONFIGURATIONERROR_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_ConfigurationError(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVConfigurationError*);

uint32_t dot11f_pack_tlv_configuration_error(
	tpAniSirGlobal,
	tDot11fTLVConfigurationError *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ConfigurationError(
	tpAniSirGlobal,
	tDot11fTLVConfigurationError *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4113 (0x1011) */
typedef struct sDot11fTLVDeviceName {
	uint8_t             present;
	uint8_t             num_text;
	uint8_t             text[32];
} tDot11fTLVDeviceName;

#define DOT11F_TLV_DEVICENAME (4113)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_DEVICENAME_MIN_LEN (2)

#define DOT11F_TLV_DEVICENAME_MAX_LEN (34)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_device_name(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVDeviceName*);

uint32_t dot11f_pack_tlv_device_name(
	tpAniSirGlobal,
	tDot11fTLVDeviceName *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_DeviceName(
	tpAniSirGlobal,
	tDot11fTLVDeviceName *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4114 (0x1012) */
typedef struct sDot11fTLVDevicePasswordID {
	uint8_t             present;
	uint16_t            id;
} tDot11fTLVDevicePasswordID;

#define DOT11F_TLV_DEVICEPASSWORDID (4114)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_DEVICEPASSWORDID_MIN_LEN (4)

#define DOT11F_TLV_DEVICEPASSWORDID_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_DevicePasswordID(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVDevicePasswordID*);

uint32_t dot11f_pack_tlv_device_password_id(
	tpAniSirGlobal,
	tDot11fTLVDevicePasswordID *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_DevicePasswordID(
	tpAniSirGlobal,
	tDot11fTLVDevicePasswordID *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 8 (0x0008) */
typedef struct sDot11fTLVExtendedListenTiming {
	uint8_t             present;
	uint16_t            availibilityPeriod;
	uint16_t            availibilityInterval;
} tDot11fTLVExtendedListenTiming;

#define DOT11F_TLV_EXTENDEDLISTENTIMING (8)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_EXTENDEDLISTENTIMING_MIN_LEN (5)

#define DOT11F_TLV_EXTENDEDLISTENTIMING_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_extended_listen_timing(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVExtendedListenTiming*);

uint32_t dot11f_pack_tlv_extended_listen_timing(
	tpAniSirGlobal,
	tDot11fTLVExtendedListenTiming *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ExtendedListenTiming(
	tpAniSirGlobal,
	tDot11fTLVExtendedListenTiming *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 6 (0x0006) */
typedef struct sDot11fTLVListenChannel {
	uint8_t             present;
	uint8_t             countryString[3];
	uint8_t             regulatoryClass;
	uint8_t             channel;
} tDot11fTLVListenChannel;

#define DOT11F_TLV_LISTENCHANNEL (6)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_LISTENCHANNEL_MIN_LEN (6)

#define DOT11F_TLV_LISTENCHANNEL_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_listen_channel(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVListenChannel*);

uint32_t dot11f_pack_tlv_listen_channel(
	tpAniSirGlobal,
	tDot11fTLVListenChannel *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ListenChannel(
	tpAniSirGlobal,
	tDot11fTLVListenChannel *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4129 (0x1021) */
typedef struct sDot11fTLVManufacturer {
	uint8_t             present;
	uint8_t             num_name;
	uint8_t             name[64];
} tDot11fTLVManufacturer;

#define DOT11F_TLV_MANUFACTURER (4129)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_MANUFACTURER_MIN_LEN (2)

#define DOT11F_TLV_MANUFACTURER_MAX_LEN (66)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_manufacturer(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVManufacturer*);

uint32_t dot11f_pack_tlv_manufacturer(
	tpAniSirGlobal,
	tDot11fTLVManufacturer *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_Manufacturer(
	tpAniSirGlobal,
	tDot11fTLVManufacturer *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 1 (0x0001) */
typedef struct sDot11fTLVMinorReasonCode {
	uint8_t             present;
	uint8_t             minorReasonCode;
} tDot11fTLVMinorReasonCode;

#define DOT11F_TLV_MINORREASONCODE (1)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_MINORREASONCODE_MIN_LEN (2)

#define DOT11F_TLV_MINORREASONCODE_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_MinorReasonCode(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVMinorReasonCode*);

uint32_t dot11f_pack_tlv_minor_reason_code(
	tpAniSirGlobal,
	tDot11fTLVMinorReasonCode *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_MinorReasonCode(
	tpAniSirGlobal,
	tDot11fTLVMinorReasonCode *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4131 (0x1023) */
typedef struct sDot11fTLVModelName {
	uint8_t             present;
	uint8_t             num_text;
	uint8_t             text[32];
} tDot11fTLVModelName;

#define DOT11F_TLV_MODELNAME (4131)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_MODELNAME_MIN_LEN (2)

#define DOT11F_TLV_MODELNAME_MAX_LEN (34)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_model_name(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVModelName*);

uint32_t dot11f_pack_tlv_model_name(
	tpAniSirGlobal,
	tDot11fTLVModelName *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ModelName(
	tpAniSirGlobal,
	tDot11fTLVModelName *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4132 (0x1024) */
typedef struct sDot11fTLVModelNumber {
	uint8_t             present;
	uint8_t             num_text;
	uint8_t             text[32];
} tDot11fTLVModelNumber;

#define DOT11F_TLV_MODELNUMBER (4132)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_MODELNUMBER_MIN_LEN (2)

#define DOT11F_TLV_MODELNUMBER_MAX_LEN (34)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_model_number(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVModelNumber*);

uint32_t dot11f_pack_tlv_model_number(
	tpAniSirGlobal,
	tDot11fTLVModelNumber *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ModelNumber(
	tpAniSirGlobal,
	tDot11fTLVModelNumber *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 12 (0x000c) */
typedef struct sDot11fTLVNoticeOfAbsence {
	uint8_t             present;
	uint8_t             index;
	uint8_t             CTSWindowOppPS;
	uint8_t             num_NoADesc;
	uint8_t             NoADesc[36];
} tDot11fTLVNoticeOfAbsence;

#define DOT11F_TLV_NOTICEOFABSENCE (12)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_NOTICEOFABSENCE_MIN_LEN (3)

#define DOT11F_TLV_NOTICEOFABSENCE_MAX_LEN (39)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_notice_of_absence(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVNoticeOfAbsence*);

uint32_t dot11f_pack_tlv_notice_of_absence(
	tpAniSirGlobal,
	tDot11fTLVNoticeOfAbsence *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_NoticeOfAbsence(
	tpAniSirGlobal,
	tDot11fTLVNoticeOfAbsence *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 17 (0x0011) */
typedef struct sDot11fTLVOperatingChannel {
	uint8_t             present;
	uint8_t             countryString[3];
	uint8_t             regulatoryClass;
	uint8_t             channel;
} tDot11fTLVOperatingChannel;

#define DOT11F_TLV_OPERATINGCHANNEL (17)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_OPERATINGCHANNEL_MIN_LEN (6)

#define DOT11F_TLV_OPERATINGCHANNEL_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_operating_channel(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVOperatingChannel*);

uint32_t dot11f_pack_tlv_operating_channel(
	tpAniSirGlobal,
	tDot11fTLVOperatingChannel *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_OperatingChannel(
	tpAniSirGlobal,
	tDot11fTLVOperatingChannel *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 2 (0x0002) */
typedef struct sDot11fTLVP2PCapability {
	uint8_t             present;
	uint8_t             deviceCapability;
	uint8_t             groupCapability;
} tDot11fTLVP2PCapability;

#define DOT11F_TLV_P2PCAPABILITY (2)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PCAPABILITY_MIN_LEN (3)

#define DOT11F_TLV_P2PCAPABILITY_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_p2_p_capability(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PCapability*);

uint32_t dot11f_pack_tlv_p2_p_capability(
	tpAniSirGlobal,
	tDot11fTLVP2PCapability *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PCapability(
	tpAniSirGlobal,
	tDot11fTLVP2PCapability *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 3 (0x0003) */
typedef struct sDot11fTLVP2PDeviceId {
	uint8_t             present;
	uint8_t             P2PDeviceAddress[6];
} tDot11fTLVP2PDeviceId;

#define DOT11F_TLV_P2PDEVICEID (3)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PDEVICEID_MIN_LEN (7)

#define DOT11F_TLV_P2PDEVICEID_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_p2_p_device_id(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PDeviceId*);

uint32_t dot11f_pack_tlv_p2_p_device_id(
	tpAniSirGlobal,
	tDot11fTLVP2PDeviceId *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PDeviceId(
	tpAniSirGlobal,
	tDot11fTLVP2PDeviceId *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 13 (0x000d) */
typedef struct sDot11fTLVP2PDeviceInfo {
	uint8_t                     present;
	uint8_t                     P2PDeviceAddress[6];
	uint16_t                    configMethod;
	uint8_t                     primaryDeviceType[8];
	tDot11fTLVDeviceName        DeviceName;
} tDot11fTLVP2PDeviceInfo;

#define DOT11F_TLV_P2PDEVICEINFO (13)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PDEVICEINFO_MIN_LEN (17)

#define DOT11F_TLV_P2PDEVICEINFO_MAX_LEN (53)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_p2_p_device_info(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PDeviceInfo*);

uint32_t dot11f_pack_tlv_p2_p_device_info(
	tpAniSirGlobal,
	tDot11fTLVP2PDeviceInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PDeviceInfo(
	tpAniSirGlobal,
	tDot11fTLVP2PDeviceInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 14 (0x000e) */
typedef struct sDot11fTLVP2PGroupInfo {
	uint8_t             present;
	uint8_t             num_P2PClientInfoDesc;
	uint8_t             P2PClientInfoDesc[1024];
} tDot11fTLVP2PGroupInfo;

#define DOT11F_TLV_P2PGROUPINFO (14)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PGROUPINFO_MIN_LEN (1)

#define DOT11F_TLV_P2PGROUPINFO_MAX_LEN (1025)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_p2_p_group_info(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PGroupInfo*);

uint32_t dot11f_pack_tlv_p2_p_group_info(
	tpAniSirGlobal,
	tDot11fTLVP2PGroupInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PGroupInfo(
	tpAniSirGlobal,
	tDot11fTLVP2PGroupInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 0 (0x0000) */
typedef struct sDot11fTLVP2PStatus {
	uint8_t             present;
	uint8_t             status;
} tDot11fTLVP2PStatus;

#define DOT11F_TLV_P2PSTATUS (0)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PSTATUS_MIN_LEN (2)

#define DOT11F_TLV_P2PSTATUS_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_P2PStatus(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PStatus*);

uint32_t dot11f_pack_tlv_p2_p_status(
	tpAniSirGlobal,
	tDot11fTLVP2PStatus *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PStatus(
	tpAniSirGlobal,
	tDot11fTLVP2PStatus *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4180 (0x1054) */
typedef struct sDot11fTLVPrimaryDeviceType {
	uint8_t             present;
	uint16_t            primary_category;
	uint8_t             oui[4];
	uint16_t            sub_category;
} tDot11fTLVPrimaryDeviceType;

#define DOT11F_TLV_PRIMARYDEVICETYPE (4180)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_PRIMARYDEVICETYPE_MIN_LEN (10)

#define DOT11F_TLV_PRIMARYDEVICETYPE_MAX_LEN (10)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_primary_device_type(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVPrimaryDeviceType*);

uint32_t dot11f_pack_tlv_primary_device_type(
	tpAniSirGlobal,
	tDot11fTLVPrimaryDeviceType *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_PrimaryDeviceType(
	tpAniSirGlobal,
	tDot11fTLVPrimaryDeviceType *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4156 (0x103c) */
typedef struct sDot11fTLVRFBands {
	uint8_t             present;
	uint8_t             bands;
} tDot11fTLVRFBands;

#define DOT11F_TLV_RFBANDS (4156)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_RFBANDS_MIN_LEN (3)

#define DOT11F_TLV_RFBANDS_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_RFBands(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVRFBands*);

uint32_t dot11f_pack_tlv_rf_bands(
	tpAniSirGlobal,
	tDot11fTLVRFBands *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_RFBands(
	tpAniSirGlobal,
	tDot11fTLVRFBands *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4202 (0x106a) */
typedef struct sDot11fTLVRequestDeviceType {
	uint8_t             present;
	uint16_t            primary_category;
	uint8_t             oui[4];
	uint16_t            sub_category;
} tDot11fTLVRequestDeviceType;

#define DOT11F_TLV_REQUESTDEVICETYPE (4202)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_REQUESTDEVICETYPE_MIN_LEN (10)

#define DOT11F_TLV_REQUESTDEVICETYPE_MAX_LEN (10)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_request_device_type(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVRequestDeviceType*);

uint32_t dot11f_pack_tlv_request_device_type(
	tpAniSirGlobal,
	tDot11fTLVRequestDeviceType *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_RequestDeviceType(
	tpAniSirGlobal,
	tDot11fTLVRequestDeviceType *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4154 (0x103a) */
typedef struct sDot11fTLVRequestType {
	uint8_t             present;
	uint8_t             reqType;
} tDot11fTLVRequestType;

#define DOT11F_TLV_REQUESTTYPE (4154)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_REQUESTTYPE_MIN_LEN (3)

#define DOT11F_TLV_REQUESTTYPE_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_RequestType(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVRequestType*);

uint32_t dot11f_pack_tlv_request_type(
	tpAniSirGlobal,
	tDot11fTLVRequestType *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_RequestType(
	tpAniSirGlobal,
	tDot11fTLVRequestType *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4155 (0x103b) */
typedef struct sDot11fTLVResponseType {
	uint8_t             present;
	uint8_t             resType;
} tDot11fTLVResponseType;

#define DOT11F_TLV_RESPONSETYPE (4155)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_RESPONSETYPE_MIN_LEN (3)

#define DOT11F_TLV_RESPONSETYPE_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_ResponseType(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVResponseType*);

uint32_t dot11f_pack_tlv_response_type(
	tpAniSirGlobal,
	tDot11fTLVResponseType *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_ResponseType(
	tpAniSirGlobal,
	tDot11fTLVResponseType *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4161 (0x1041) */
typedef struct sDot11fTLVSelectedRegistrar {
	uint8_t             present;
	uint8_t             selected;
} tDot11fTLVSelectedRegistrar;

#define DOT11F_TLV_SELECTEDREGISTRAR (4161)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_SELECTEDREGISTRAR_MIN_LEN (3)

#define DOT11F_TLV_SELECTEDREGISTRAR_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_SelectedRegistrar(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVSelectedRegistrar*);

uint32_t dot11f_pack_tlv_selected_registrar(
	tpAniSirGlobal,
	tDot11fTLVSelectedRegistrar *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_SelectedRegistrar(
	tpAniSirGlobal,
	tDot11fTLVSelectedRegistrar *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4179 (0x1053) */
typedef struct sDot11fTLVSelectedRegistrarConfigMethods {
	uint8_t             present;
	uint16_t            methods;
} tDot11fTLVSelectedRegistrarConfigMethods;

#define DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS (4179)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS_MIN_LEN (4)

#define DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_SelectedRegistrarConfigMethods(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVSelectedRegistrarConfigMethods*);

uint32_t dot11f_pack_tlv_selected_registrar_config_methods(
	tpAniSirGlobal,
	tDot11fTLVSelectedRegistrarConfigMethods *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_SelectedRegistrarConfigMethods(
	tpAniSirGlobal,
	tDot11fTLVSelectedRegistrarConfigMethods *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4162 (0x1042) */
typedef struct sDot11fTLVSerialNumber {
	uint8_t             present;
	uint8_t             num_text;
	uint8_t             text[32];
} tDot11fTLVSerialNumber;

#define DOT11F_TLV_SERIALNUMBER (4162)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_SERIALNUMBER_MIN_LEN (2)

#define DOT11F_TLV_SERIALNUMBER_MAX_LEN (34)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_serial_number(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVSerialNumber*);

uint32_t dot11f_pack_tlv_serial_number(
	tpAniSirGlobal,
	tDot11fTLVSerialNumber *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_SerialNumber(
	tpAniSirGlobal,
	tDot11fTLVSerialNumber *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4167 (0x1047) */
typedef struct sDot11fTLVUUID_E {
	uint8_t             present;
	uint8_t             uuid[16];
} tDot11fTLVUUID_E;

#define DOT11F_TLV_UUID_E (4167)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_UUID_E_MIN_LEN (18)

#define DOT11F_TLV_UUID_E_MAX_LEN (18)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_uuid_e(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVUUID_E*);

uint32_t dot11f_pack_tlv_uuid_e(
	tpAniSirGlobal,
	tDot11fTLVUUID_E *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_UUID_E(
	tpAniSirGlobal,
	tDot11fTLVUUID_E *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4168 (0x1048) */
typedef struct sDot11fTLVUUID_R {
	uint8_t             present;
	uint8_t             uuid[16];
} tDot11fTLVUUID_R;

#define DOT11F_TLV_UUID_R (4168)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_UUID_R_MIN_LEN (18)

#define DOT11F_TLV_UUID_R_MAX_LEN (18)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_uuid_r(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVUUID_R*);

uint32_t dot11f_pack_tlv_uuid_r(
	tpAniSirGlobal,
	tDot11fTLVUUID_R *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_UUID_R(
	tpAniSirGlobal,
	tDot11fTLVUUID_R *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4169 (0x1049) */
typedef struct sDot11fTLVVendorExtension {
	uint8_t                          present;
	uint8_t                          vendorId[3];
	tDot11fTLVVersion2               Version2;
	tDot11fTLVAuthorizedMACs         AuthorizedMACs;
	tDot11fTLVRequestToEnroll        RequestToEnroll;
} tDot11fTLVVendorExtension;

#define DOT11F_TLV_VENDOREXTENSION (4169)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_VENDOREXTENSION_MIN_LEN (5)

#define DOT11F_TLV_VENDOREXTENSION_MAX_LEN (19)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_vendor_extension(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVVendorExtension*);

uint32_t dot11f_pack_tlv_vendor_extension(
	tpAniSirGlobal,
	tDot11fTLVVendorExtension *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_VendorExtension(
	tpAniSirGlobal,
	tDot11fTLVVendorExtension *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4170 (0x104a) */
typedef struct sDot11fTLVVersion {
	uint8_t             present;
	uint8_t                minor:4;
	uint8_t                major:4;
} tDot11fTLVVersion;

#define DOT11F_TLV_VERSION (4170)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_VERSION_MIN_LEN (3)

#define DOT11F_TLV_VERSION_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_version(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVVersion*);

uint32_t dot11f_pack_tlv_version(
	tpAniSirGlobal,
	tDot11fTLVVersion *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_Version(
	tpAniSirGlobal,
	tDot11fTLVVersion *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4164 (0x1044) */
typedef struct sDot11fTLVWPSState {
	uint8_t             present;
	uint8_t             state;
} tDot11fTLVWPSState;

#define DOT11F_TLV_WPSSTATE (4164)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_WPSSTATE_MIN_LEN (3)

#define DOT11F_TLV_WPSSTATE_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_WPSState(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVWPSState*);

uint32_t dot11f_pack_tlv_wps_state(
	tpAniSirGlobal,
	tDot11fTLVWPSState *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_WPSState(
	tpAniSirGlobal,
	tDot11fTLVWPSState *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 4 (0x0004) */
typedef struct sDot11fTLVassoc_disallowed {
	uint8_t             present;
	uint8_t             reason_code;
} tDot11fTLVassoc_disallowed;

#define DOT11F_TLV_ASSOC_DISALLOWED (4)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_ASSOC_DISALLOWED_MIN_LEN (1)

#define DOT11F_TLV_ASSOC_DISALLOWED_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_assoc_disallowed(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVassoc_disallowed*);

uint32_t dot11f_pack_tlv_assoc_disallowed(
	tpAniSirGlobal,
	tDot11fTLVassoc_disallowed *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_assoc_disallowed(
	tpAniSirGlobal,
	tDot11fTLVassoc_disallowed *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 8 (0x0008) */
typedef struct sDot11fTLVassoc_retry_delay {
	uint8_t             present;
	uint16_t            delay;
} tDot11fTLVassoc_retry_delay;

#define DOT11F_TLV_ASSOC_RETRY_DELAY (8)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_ASSOC_RETRY_DELAY_MIN_LEN (2)

#define DOT11F_TLV_ASSOC_RETRY_DELAY_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_assoc_retry_delay(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVassoc_retry_delay*);

uint32_t dot11f_pack_tlv_assoc_retry_delay(
	tpAniSirGlobal,
	tDot11fTLVassoc_retry_delay *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_assoc_retry_delay(
	tpAniSirGlobal,
	tDot11fTLVassoc_retry_delay *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 3 (0x0003) */
typedef struct sDot11fTLVcellular_data_cap {
	uint8_t             present;
	uint8_t             cellular_connectivity;
} tDot11fTLVcellular_data_cap;

#define DOT11F_TLV_CELLULAR_DATA_CAP (3)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_CELLULAR_DATA_CAP_MIN_LEN (1)

#define DOT11F_TLV_CELLULAR_DATA_CAP_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_cellular_data_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVcellular_data_cap*);

uint32_t dot11f_pack_tlv_cellular_data_cap(
	tpAniSirGlobal,
	tDot11fTLVcellular_data_cap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_cellular_data_cap(
	tpAniSirGlobal,
	tDot11fTLVcellular_data_cap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 5 (0x0005) */
typedef struct sDot11fTLVcellular_data_con_pref {
	uint8_t             present;
	uint8_t             cellular_preference;
} tDot11fTLVcellular_data_con_pref;

#define DOT11F_TLV_CELLULAR_DATA_CON_PREF (5)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_CELLULAR_DATA_CON_PREF_MIN_LEN (1)

#define DOT11F_TLV_CELLULAR_DATA_CON_PREF_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_cellular_data_con_pref(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVcellular_data_con_pref*);

uint32_t dot11f_pack_tlv_cellular_data_con_pref(
	tpAniSirGlobal,
	tDot11fTLVcellular_data_con_pref *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_cellular_data_con_pref(
	tpAniSirGlobal,
	tDot11fTLVcellular_data_con_pref *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 1 (0x0001) */
typedef struct sDot11fTLVmbo_ap_cap {
	uint8_t             present;
	uint8_t             mbo_cap_ind;
} tDot11fTLVmbo_ap_cap;

#define DOT11F_TLV_MBO_AP_CAP (1)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_MBO_AP_CAP_MIN_LEN (1)

#define DOT11F_TLV_MBO_AP_CAP_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_mbo_ap_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVmbo_ap_cap*);

uint32_t dot11f_pack_tlv_mbo_ap_cap(
	tpAniSirGlobal,
	tDot11fTLVmbo_ap_cap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_mbo_ap_cap(
	tpAniSirGlobal,
	tDot11fTLVmbo_ap_cap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 2 (0x0002) */
typedef struct sDot11fTLVnon_prefferd_chan_rep {
	uint8_t             present;
	uint8_t             oper_class;
	uint8_t             num_channel_report;
	uint8_t             channel_report[254];
} tDot11fTLVnon_prefferd_chan_rep;

#define DOT11F_TLV_NON_PREFFERD_CHAN_REP (2)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_NON_PREFFERD_CHAN_REP_MIN_LEN (4)

#define DOT11F_TLV_NON_PREFFERD_CHAN_REP_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_non_prefferd_chan_rep(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVnon_prefferd_chan_rep*);

uint32_t dot11f_pack_tlv_non_prefferd_chan_rep(
	tpAniSirGlobal,
	tDot11fTLVnon_prefferd_chan_rep *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_non_prefferd_chan_rep(
	tpAniSirGlobal,
	tDot11fTLVnon_prefferd_chan_rep *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 101 (0x0065) */
typedef struct sDot11fTLVoce_cap {
	uint8_t             present;
	uint8_t          oce_release:3;
	uint8_t          is_sta_cfon:1;
	uint8_t   non_oce_ap_present:1;
	uint8_t             reserved:3;
} tDot11fTLVoce_cap;

#define DOT11F_TLV_OCE_CAP (101)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_OCE_CAP_MIN_LEN (1)

#define DOT11F_TLV_OCE_CAP_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_oce_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVoce_cap*);

uint32_t dot11f_pack_tlv_oce_cap(
	tpAniSirGlobal,
	tDot11fTLVoce_cap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_oce_cap(
	tpAniSirGlobal,
	tDot11fTLVoce_cap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 103 (0x0067) */
typedef struct sDot11fTLVreduced_wan_metrics {
	uint8_t             present;
	uint8_t      downlink_av_cap:4;
	uint8_t        uplink_av_cap:4;
} tDot11fTLVreduced_wan_metrics;

#define DOT11F_TLV_REDUCED_WAN_METRICS (103)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_REDUCED_WAN_METRICS_MIN_LEN (1)

#define DOT11F_TLV_REDUCED_WAN_METRICS_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_reduced_wan_metrics(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVreduced_wan_metrics*);

uint32_t dot11f_pack_tlv_reduced_wan_metrics(
	tpAniSirGlobal,
	tDot11fTLVreduced_wan_metrics *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_reduced_wan_metrics(
	tpAniSirGlobal,
	tDot11fTLVreduced_wan_metrics *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 102 (0x0066) */
typedef struct sDot11fTLVrssi_assoc_rej {
	uint8_t             present;
	uint8_t             delta_rssi;
	uint8_t             retry_delay;
} tDot11fTLVrssi_assoc_rej;

#define DOT11F_TLV_RSSI_ASSOC_REJ (102)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_RSSI_ASSOC_REJ_MIN_LEN (2)

#define DOT11F_TLV_RSSI_ASSOC_REJ_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_rssi_assoc_rej(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVrssi_assoc_rej*);

uint32_t dot11f_pack_tlv_rssi_assoc_rej(
	tpAniSirGlobal,
	tDot11fTLVrssi_assoc_rej *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_rssi_assoc_rej(
	tpAniSirGlobal,
	tDot11fTLVrssi_assoc_rej *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 6 (0x0006) */
typedef struct sDot11fTLVtransition_reason {
	uint8_t             present;
	uint8_t             transition_reason_code;
} tDot11fTLVtransition_reason;

#define DOT11F_TLV_TRANSITION_REASON (6)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_TRANSITION_REASON_MIN_LEN (1)

#define DOT11F_TLV_TRANSITION_REASON_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_transition_reason(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVtransition_reason*);

uint32_t dot11f_pack_tlv_transition_reason(
	tpAniSirGlobal,
	tDot11fTLVtransition_reason *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_transition_reason(
	tpAniSirGlobal,
	tDot11fTLVtransition_reason *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 7 (0x0007) */
typedef struct sDot11fTLVtransition_reject_reason {
	uint8_t             present;
	uint8_t             transition_reject_code;
} tDot11fTLVtransition_reject_reason;

#define DOT11F_TLV_TRANSITION_REJECT_REASON (7)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_TRANSITION_REJECT_REASON_MIN_LEN (1)

#define DOT11F_TLV_TRANSITION_REJECT_REASON_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_transition_reject_reason(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVtransition_reject_reason*);

uint32_t dot11f_pack_tlv_transition_reject_reason(
	tpAniSirGlobal,
	tDot11fTLVtransition_reject_reason *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_transition_reject_reason(
	tpAniSirGlobal,
	tDot11fTLVtransition_reject_reason *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 16 (0x0010) */
typedef struct sDot11fTLVP2PInterface {
	uint8_t             present;
	uint8_t             P2PDeviceAddress[6];
} tDot11fTLVP2PInterface;

#define DOT11F_TLV_P2PINTERFACE (16)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PINTERFACE_MIN_LEN (7)

#define DOT11F_TLV_P2PINTERFACE_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_p2_p_interface(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PInterface*);

uint32_t dot11f_pack_tlv_p2_p_interface(
	tpAniSirGlobal,
	tDot11fTLVP2PInterface *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PInterface(
	tpAniSirGlobal,
	tDot11fTLVP2PInterface *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* ID 10 (0x000a) */
typedef struct sDot11fTLVP2PManageability {
	uint8_t             present;
	uint8_t             manageability;
} tDot11fTLVP2PManageability;

#define DOT11F_TLV_P2PMANAGEABILITY (10)

/* N.B. These #defines do *not* include the ID & length */
#define DOT11F_TLV_P2PMANAGEABILITY_MIN_LEN (2)

#define DOT11F_TLV_P2PMANAGEABILITY_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_tlv_P2PManageability(
	tpAniSirGlobal,
	uint8_t *,
	uint16_t,
	tDot11fTLVP2PManageability*);

uint32_t dot11f_pack_tlv_p2_p_manageability(
	tpAniSirGlobal,
	tDot11fTLVP2PManageability *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_tlv_P2PManageability(
	tpAniSirGlobal,
	tDot11fTLVP2PManageability *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */
/*********************************************************************
 * Information Elements                                              *
 ********************************************************************/


/* EID 2 (0x02) */
typedef struct sDot11fIEGTK {
	uint8_t             present;
	uint16_t                keyId:2;
	uint16_t             reserved:14;
	uint8_t             keyLength;
	uint8_t             RSC[8];
	uint8_t             num_key;
	uint8_t             key[32];
} tDot11fIEGTK;

#define DOT11F_EID_GTK (2)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_GTK_MIN_LEN (16)

#define DOT11F_IE_GTK_MAX_LEN (43)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_gtk(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEGTK*,
	bool);

uint32_t dot11f_pack_ie_gtk(
	tpAniSirGlobal,
	tDot11fIEGTK *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_GTK(
	tpAniSirGlobal,
	tDot11fIEGTK *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 4 (0x04) */
typedef struct sDot11fIEIGTK {
	uint8_t             present;
	uint8_t             keyID[2];
	uint8_t             IPN[6];
	uint8_t             keyLength;
	uint8_t             key[24];
} tDot11fIEIGTK;

#define DOT11F_EID_IGTK (4)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_IGTK_MIN_LEN (33)

#define DOT11F_IE_IGTK_MAX_LEN (33)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_igtk(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEIGTK*,
	bool);

uint32_t dot11f_pack_ie_igtk(
	tpAniSirGlobal,
	tDot11fIEIGTK *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_IGTK(
	tpAniSirGlobal,
	tDot11fIEIGTK *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 3 (0x03) */
typedef struct sDot11fIER0KH_ID {
	uint8_t             present;
	uint8_t             num_PMK_R0_ID;
	uint8_t             PMK_R0_ID[48];
} tDot11fIER0KH_ID;

#define DOT11F_EID_R0KH_ID (3)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_R0KH_ID_MIN_LEN (1)

#define DOT11F_IE_R0KH_ID_MAX_LEN (48)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_r0_kh_id(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIER0KH_ID*,
	bool);

uint32_t dot11f_pack_ie_r0_kh_id(
	tpAniSirGlobal,
	tDot11fIER0KH_ID *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_R0KH_ID(
	tpAniSirGlobal,
	tDot11fIER0KH_ID *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIER1KH_ID {
	uint8_t             present;
	uint8_t             PMK_R1_ID[6];
} tDot11fIER1KH_ID;

#define DOT11F_EID_R1KH_ID (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_R1KH_ID_MIN_LEN (6)

#define DOT11F_IE_R1KH_ID_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_r1_kh_id(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIER1KH_ID*,
	bool);

uint32_t dot11f_pack_ie_r1_kh_id(
	tpAniSirGlobal,
	tDot11fIER1KH_ID *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_R1KH_ID(
	tpAniSirGlobal,
	tDot11fIER1KH_ID *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 51 (0x33) */
typedef struct sDot11fIEAPChannelReport {
	uint8_t             present;
	uint8_t             regulatoryClass;
	uint8_t             num_channelList;
	uint8_t             channelList[50];
} tDot11fIEAPChannelReport;

#define DOT11F_EID_APCHANNELREPORT (51)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_APCHANNELREPORT_MIN_LEN (1)

#define DOT11F_IE_APCHANNELREPORT_MAX_LEN (51)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ap_channel_report(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEAPChannelReport*,
	bool);

uint32_t dot11f_pack_ie_ap_channel_report(
	tpAniSirGlobal,
	tDot11fIEAPChannelReport *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_APChannelReport(
	tpAniSirGlobal,
	tDot11fIEAPChannelReport *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 2 (0x02) */
typedef struct sDot11fIEBcnReportingDetail {
	uint8_t             present;
	uint8_t             reportingDetail;
} tDot11fIEBcnReportingDetail;

#define DOT11F_EID_BCNREPORTINGDETAIL (2)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_BCNREPORTINGDETAIL_MIN_LEN (1)

#define DOT11F_IE_BCNREPORTINGDETAIL_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_bcn_reporting_detail(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEBcnReportingDetail*,
	bool);

uint32_t dot11f_pack_ie_bcn_reporting_detail(
	tpAniSirGlobal,
	tDot11fIEBcnReportingDetail *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_BcnReportingDetail(
	tpAniSirGlobal,
	tDot11fIEBcnReportingDetail *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIEBeaconReportFrmBody {
	uint8_t             present;
	uint8_t             num_reportedFields;
	uint8_t             reportedFields[224];
} tDot11fIEBeaconReportFrmBody;

#define DOT11F_EID_BEACONREPORTFRMBODY (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_BEACONREPORTFRMBODY_MIN_LEN (0)

#define DOT11F_IE_BEACONREPORTFRMBODY_MAX_LEN (224)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_beacon_report_frm_body(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEBeaconReportFrmBody*,
	bool);

uint32_t dot11f_pack_ie_beacon_report_frm_body(
	tpAniSirGlobal,
	tDot11fIEBeaconReportFrmBody *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_BeaconReportFrmBody(
	tpAniSirGlobal,
	tDot11fIEBeaconReportFrmBody *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIEBeaconReporting {
	uint8_t             present;
	uint8_t             reportingCondition;
	uint8_t             threshold;
} tDot11fIEBeaconReporting;

#define DOT11F_EID_BEACONREPORTING (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_BEACONREPORTING_MIN_LEN (2)

#define DOT11F_IE_BEACONREPORTING_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_beacon_reporting(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEBeaconReporting*,
	bool);

uint32_t dot11f_pack_ie_beacon_reporting(
	tpAniSirGlobal,
	tDot11fIEBeaconReporting *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_BeaconReporting(
	tpAniSirGlobal,
	tDot11fIEBeaconReporting *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 2 (0x02) */
typedef struct sDot11fIECondensedCountryStr {
	uint8_t             present;
	uint8_t             countryStr[2];
} tDot11fIECondensedCountryStr;

#define DOT11F_EID_CONDENSEDCOUNTRYSTR (2)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_CONDENSEDCOUNTRYSTR_MIN_LEN (2)

#define DOT11F_IE_CONDENSEDCOUNTRYSTR_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_condensed_country_str(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIECondensedCountryStr*,
	bool);

uint32_t dot11f_pack_ie_condensed_country_str(
	tpAniSirGlobal,
	tDot11fIECondensedCountryStr *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_CondensedCountryStr(
	tpAniSirGlobal,
	tDot11fIECondensedCountryStr *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 66 (0x42) */
typedef struct sDot11fIEMeasurementPilot {
	uint8_t             present;
	uint8_t             measurementPilot;
	uint8_t             num_vendorSpecific;
	uint8_t             vendorSpecific[255];
} tDot11fIEMeasurementPilot;

#define DOT11F_EID_MEASUREMENTPILOT (66)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MEASUREMENTPILOT_MIN_LEN (1)

#define DOT11F_IE_MEASUREMENTPILOT_MAX_LEN (256)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_measurement_pilot(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMeasurementPilot*,
	bool);

uint32_t dot11f_pack_ie_measurement_pilot(
	tpAniSirGlobal,
	tDot11fIEMeasurementPilot *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_MeasurementPilot(
	tpAniSirGlobal,
	tDot11fIEMeasurementPilot *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 71 (0x47) */
typedef struct sDot11fIEMultiBssid {
	uint8_t             present;
	uint8_t             maxBSSIDIndicator;
	uint8_t             num_vendorSpecific;
	uint8_t             vendorSpecific[255];
} tDot11fIEMultiBssid;

#define DOT11F_EID_MULTIBSSID (71)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MULTIBSSID_MIN_LEN (1)

#define DOT11F_IE_MULTIBSSID_MAX_LEN (256)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_multi_bssid(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMultiBssid*,
	bool);

uint32_t dot11f_pack_ie_multi_bssid(
	tpAniSirGlobal,
	tDot11fIEMultiBssid *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_MultiBssid(
	tpAniSirGlobal,
	tDot11fIEMultiBssid *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 57 (0x39) */
typedef struct sDot11fIERICData {
	uint8_t             present;
	uint8_t             Identifier;
	uint8_t             resourceDescCount;
	uint16_t            statusCode;
} tDot11fIERICData;

#define DOT11F_EID_RICDATA (57)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RICDATA_MIN_LEN (4)

#define DOT11F_IE_RICDATA_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ric_data(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERICData*,
	bool);

uint32_t dot11f_pack_ie_ric_data(
	tpAniSirGlobal,
	tDot11fIERICData *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_RICData(
	tpAniSirGlobal,
	tDot11fIERICData *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 75 (0x4b) */
typedef struct sDot11fIERICDescriptor {
	uint8_t             present;
	uint8_t             resourceType;
	uint8_t             num_variableData;
	uint8_t             variableData[255];
} tDot11fIERICDescriptor;

#define DOT11F_EID_RICDESCRIPTOR (75)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RICDESCRIPTOR_MIN_LEN (1)

#define DOT11F_IE_RICDESCRIPTOR_MAX_LEN (256)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ric_descriptor(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERICDescriptor*,
	bool);

uint32_t dot11f_pack_ie_ric_descriptor(
	tpAniSirGlobal,
	tDot11fIERICDescriptor *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_RICDescriptor(
	tpAniSirGlobal,
	tDot11fIERICDescriptor *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 70 (0x46) */
typedef struct sDot11fIERRMEnabledCap {
	uint8_t             present;
	uint8_t      LinkMeasurement:1;
	uint8_t          NeighborRpt:1;
	uint8_t             parallel:1;
	uint8_t             repeated:1;
	uint8_t        BeaconPassive:1;
	uint8_t         BeaconActive:1;
	uint8_t          BeaconTable:1;
	uint8_t        BeaconRepCond:1;
	uint8_t     FrameMeasurement:1;
	uint8_t          ChannelLoad:1;
	uint8_t       NoiseHistogram:1;
	uint8_t           statistics:1;
	uint8_t       LCIMeasurement:1;
	uint8_t           LCIAzimuth:1;
	uint8_t        TCMCapability:1;
	uint8_t         triggeredTCM:1;
	uint8_t         APChanReport:1;
	uint8_t        RRMMIBEnabled:1;
	uint8_t     operatingChanMax:3;
	uint8_t   nonOperatinChanMax:3;
	uint8_t     MeasurementPilot:3;
	uint8_t MeasurementPilotEnabled:1;
	uint8_t    NeighborTSFOffset:1;
	uint8_t      RCPIMeasurement:1;
	uint8_t      RSNIMeasurement:1;
	uint8_t    BssAvgAccessDelay:1;
	uint8_t    BSSAvailAdmission:1;
	uint8_t   AntennaInformation:1;
	uint8_t   fine_time_meas_rpt:1;
	uint8_t       lci_capability:1;
	uint8_t             reserved:4;
} tDot11fIERRMEnabledCap;

#define DOT11F_EID_RRMENABLEDCAP (70)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RRMENABLEDCAP_MIN_LEN (5)

#define DOT11F_IE_RRMENABLEDCAP_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_rrm_enabled_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERRMEnabledCap*,
	bool);

uint32_t dot11f_pack_ie_rrm_enabled_cap(
	tpAniSirGlobal,
	tDot11fIERRMEnabledCap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_RRMEnabledCap(
	tpAniSirGlobal,
	tDot11fIERRMEnabledCap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 10 (0x0a) */
typedef struct sDot11fIERequestedInfo {
	uint8_t             present;
	uint8_t             num_requested_eids;
	uint8_t             requested_eids[255];
} tDot11fIERequestedInfo;

#define DOT11F_EID_REQUESTEDINFO (10)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_REQUESTEDINFO_MIN_LEN (0)

#define DOT11F_IE_REQUESTEDINFO_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_requested_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERequestedInfo*,
	bool);

uint32_t dot11f_pack_ie_requested_info(
	tpAniSirGlobal,
	tDot11fIERequestedInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_RequestedInfo(
	tpAniSirGlobal,
	tDot11fIERequestedInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 0 (0x00) */
typedef struct sDot11fIESSID {
	uint8_t             present;
	uint8_t             num_ssid;
	uint8_t             ssid[32];
} tDot11fIESSID;

#define DOT11F_EID_SSID (0)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SSID_MIN_LEN (0)

#define DOT11F_IE_SSID_MAX_LEN (32)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ssid(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIESSID*,
	bool);

uint32_t dot11f_pack_ie_ssid(
	tpAniSirGlobal,
	tDot11fIESSID *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_SSID(
	tpAniSirGlobal,
	tDot11fIESSID *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 15 (0x0f) */
typedef struct sDot11fIESchedule {
	uint8_t             present;
	uint16_t          aggregation:1;
	uint16_t                 tsid:4;
	uint16_t            direction:2;
	uint16_t             reserved:9;
	uint32_t            service_start_time;
	uint32_t            service_interval;
	uint16_t            max_service_dur;
	uint16_t            spec_interval;
} tDot11fIESchedule;

#define DOT11F_EID_SCHEDULE (15)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SCHEDULE_MIN_LEN (14)

#define DOT11F_IE_SCHEDULE_MAX_LEN (14)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_schedule(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIESchedule*,
	bool);

uint32_t dot11f_pack_ie_schedule(
	tpAniSirGlobal,
	tDot11fIESchedule *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_Schedule(
	tpAniSirGlobal,
	tDot11fIESchedule *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 14 (0x0e) */
typedef struct sDot11fIETCLAS {
	uint8_t             present;
	uint8_t             user_priority;
	uint8_t             classifier_type;
	uint8_t             classifier_mask;
	union {
		struct {
			uint8_t source[6];
			uint8_t dest[6];
			uint16_t type;
		} EthParams; /* classifier_type = 0 */
		struct {
			uint8_t version;
			union {
				struct {
					uint8_t source[4];
					uint8_t dest[4];
					uint16_t src_port;
					uint16_t dest_port;
					uint8_t DSCP;
					uint8_t proto;
					uint8_t reserved;
				} IpV4Params; /* version = 4 */
				struct {
					uint8_t source[16];
					uint8_t dest[16];
					uint16_t src_port;
					uint16_t dest_port;
					uint8_t flow_label[3];
				} IpV6Params; /* version = 6 */
			} params;
		} IpParams; /* classifier_type = 1 */
		struct {
			uint16_t tag_type;
		} Params8021dq; /* classifier_type = 2 */
	} info;
} tDot11fIETCLAS;

#define DOT11F_EID_TCLAS (14)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TCLAS_MIN_LEN (5)

#define DOT11F_IE_TCLAS_MAX_LEN (43)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tclas(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETCLAS*,
	bool);

uint32_t dot11f_pack_ie_tclas(
	tpAniSirGlobal,
	tDot11fIETCLAS *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ietclas(
	tpAniSirGlobal,
	tDot11fIETCLAS *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 44 (0x2c) */
typedef struct sDot11fIETCLASSPROC {
	uint8_t             present;
	uint8_t             processing;
} tDot11fIETCLASSPROC;

#define DOT11F_EID_TCLASSPROC (44)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TCLASSPROC_MIN_LEN (1)

#define DOT11F_IE_TCLASSPROC_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tclasSPROC(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETCLASSPROC*,
	bool);

uint32_t dot11f_pack_ie_tclassproc(
	tpAniSirGlobal,
	tDot11fIETCLASSPROC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ietclasSPROC(
	tpAniSirGlobal,
	tDot11fIETCLASSPROC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 43 (0x2b) */
typedef struct sDot11fIETSDelay {
	uint8_t             present;
	uint32_t            delay;
} tDot11fIETSDelay;

#define DOT11F_EID_TSDELAY (43)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TSDELAY_MIN_LEN (4)

#define DOT11F_IE_TSDELAY_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ts_delay(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETSDelay*,
	bool);

uint32_t dot11f_pack_ie_ts_delay(
	tpAniSirGlobal,
	tDot11fIETSDelay *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TSDelay(
	tpAniSirGlobal,
	tDot11fIETSDelay *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIETSFInfo {
	uint8_t             present;
	uint16_t            TsfOffset;
	uint16_t            BeaconIntvl;
} tDot11fIETSFInfo;

#define DOT11F_EID_TSFINFO (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TSFINFO_MIN_LEN (4)

#define DOT11F_IE_TSFINFO_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tsf_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETSFInfo*,
	bool);

uint32_t dot11f_pack_ie_tsf_info(
	tpAniSirGlobal,
	tDot11fIETSFInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TSFInfo(
	tpAniSirGlobal,
	tDot11fIETSFInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 13 (0x0d) */
typedef struct sDot11fIETSPEC {
	uint8_t             present;
	uint16_t         traffic_type:1;
	uint16_t                 tsid:4;
	uint16_t            direction:2;
	uint16_t        access_policy:2;
	uint16_t          aggregation:1;
	uint16_t                  psb:1;
	uint16_t        user_priority:3;
	uint16_t       tsinfo_ack_pol:2;
	uint8_t             schedule:1;
	uint8_t               unused:7;
	uint16_t                 size:15;
	uint16_t                fixed:1;
	uint16_t            max_msdu_size;
	uint32_t            min_service_int;
	uint32_t            max_service_int;
	uint32_t            inactivity_int;
	uint32_t            suspension_int;
	uint32_t            service_start_time;
	uint32_t            min_data_rate;
	uint32_t            mean_data_rate;
	uint32_t            peak_data_rate;
	uint32_t            burst_size;
	uint32_t            delay_bound;
	uint32_t            min_phy_rate;
	uint16_t            surplus_bw_allowance;
	uint16_t            medium_time;
} tDot11fIETSPEC;

#define DOT11F_EID_TSPEC (13)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TSPEC_MIN_LEN (55)

#define DOT11F_IE_TSPEC_MAX_LEN (55)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tspec(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETSPEC*,
	bool);

uint32_t dot11f_pack_ie_tspec(
	tpAniSirGlobal,
	tDot11fIETSPEC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TSPEC(
	tpAniSirGlobal,
	tDot11fIETSPEC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 191 (0xbf) */
typedef struct sDot11fIEVHTCaps {
	uint8_t             present;
	uint32_t           maxMPDULen:2;
	uint32_t supportedChannelWidthSet:2;
	uint32_t        ldpcCodingCap:1;
	uint32_t         shortGI80MHz:1;
	uint32_t shortGI160and80plus80MHz:1;
	uint32_t               txSTBC:1;
	uint32_t               rxSTBC:3;
	uint32_t      suBeamFormerCap:1;
	uint32_t      suBeamformeeCap:1;
	uint32_t csnofBeamformerAntSup:3;
	uint32_t       numSoundingDim:3;
	uint32_t      muBeamformerCap:1;
	uint32_t      muBeamformeeCap:1;
	uint32_t            vhtTXOPPS:1;
	uint32_t            htcVHTCap:1;
	uint32_t       maxAMPDULenExp:3;
	uint32_t      vhtLinkAdaptCap:2;
	uint32_t         rxAntPattern:1;
	uint32_t         txAntPattern:1;
	uint32_t            reserved1:2;
	uint16_t            rxMCSMap;
	uint16_t    rxHighSupDataRate:13;
	uint16_t            reserved2:3;
	uint16_t            txMCSMap;
	uint16_t        txSupDataRate:13;
	uint16_t            reserved3:3;
} tDot11fIEVHTCaps;

#define DOT11F_EID_VHTCAPS (191)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VHTCAPS_MIN_LEN (12)

#define DOT11F_IE_VHTCAPS_MAX_LEN (12)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vht_caps(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEVHTCaps*,
	bool);

uint32_t dot11f_pack_ie_vht_caps(
	tpAniSirGlobal,
	tDot11fIEVHTCaps *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_VHTCaps(
	tpAniSirGlobal,
	tDot11fIEVHTCaps *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 192 (0xc0) */
typedef struct sDot11fIEVHTOperation {
	uint8_t             present;
	uint8_t             chanWidth;
	uint8_t             chanCenterFreqSeg1;
	uint8_t             chanCenterFreqSeg2;
	uint16_t            basicMCSSet;
} tDot11fIEVHTOperation;

#define DOT11F_EID_VHTOPERATION (192)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VHTOPERATION_MIN_LEN (5)

#define DOT11F_IE_VHTOPERATION_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vht_operation(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEVHTOperation*,
	bool);

uint32_t dot11f_pack_ie_vht_operation(
	tpAniSirGlobal,
	tDot11fIEVHTOperation *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_VHTOperation(
	tpAniSirGlobal,
	tDot11fIEVHTOperation *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x09} */
typedef struct sDot11fIEWMMSchedule {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint16_t          aggregation:1;
	uint16_t                 tsid:4;
	uint16_t            direction:2;
	uint16_t             reserved:9;
	uint32_t            service_start_time;
	uint32_t            service_interval;
	uint16_t            max_service_dur;
	uint16_t            spec_interval;
} tDot11fIEWMMSchedule;

#define DOT11F_EID_WMMSCHEDULE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMSCHEDULE_MIN_LEN (20)

#define DOT11F_IE_WMMSCHEDULE_MAX_LEN (20)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmm_schedule(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMSchedule*,
	bool);

uint32_t dot11f_pack_ie_wmm_schedule(
	tpAniSirGlobal,
	tDot11fIEWMMSchedule *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMSchedule(
	tpAniSirGlobal,
	tDot11fIEWMMSchedule *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x06} */
typedef struct sDot11fIEWMMTCLAS {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint8_t             user_priority;
	uint8_t             classifier_type;
	uint8_t             classifier_mask;
	union {
		struct {
			uint8_t source[6];
			uint8_t dest[6];
			uint16_t type;
		} EthParams; /* classifier_type = 0 */
		struct {
			uint8_t version;
			union {
				struct {
					uint8_t source[4];
					uint8_t dest[4];
					uint16_t src_port;
					uint16_t dest_port;
					uint8_t DSCP;
					uint8_t proto;
					uint8_t reserved;
				} IpV4Params; /* version = 4 */
				struct {
					uint8_t source[16];
					uint8_t dest[16];
					uint16_t src_port;
					uint16_t dest_port;
					uint8_t flow_label[3];
				} IpV6Params; /* version = 6 */
			} params;
		} IpParams; /* classifier_type = 1 */
		struct {
			uint16_t tag_type;
		} Params8021dq; /* classifier_type = 2 */
	} info;
} tDot11fIEWMMTCLAS;

#define DOT11F_EID_WMMTCLAS (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMTCLAS_MIN_LEN (11)

#define DOT11F_IE_WMMTCLAS_MAX_LEN (49)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmmtclas(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMTCLAS*,
	bool);

uint32_t dot11f_pack_ie_wmmtclas(
	tpAniSirGlobal,
	tDot11fIEWMMTCLAS *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewmmtclas(
	tpAniSirGlobal,
	tDot11fIEWMMTCLAS *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x07} */
typedef struct sDot11fIEWMMTCLASPROC {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint8_t             processing;
} tDot11fIEWMMTCLASPROC;

#define DOT11F_EID_WMMTCLASPROC (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMTCLASPROC_MIN_LEN (7)

#define DOT11F_IE_WMMTCLASPROC_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmmtclasproc(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMTCLASPROC*,
	bool);

uint32_t dot11f_pack_ie_wmmtclasproc(
	tpAniSirGlobal,
	tDot11fIEWMMTCLASPROC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewmmtclasPROC(
	tpAniSirGlobal,
	tDot11fIEWMMTCLASPROC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x08} */
typedef struct sDot11fIEWMMTSDelay {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint32_t            delay;
} tDot11fIEWMMTSDelay;

#define DOT11F_EID_WMMTSDELAY (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMTSDELAY_MIN_LEN (10)

#define DOT11F_IE_WMMTSDELAY_MAX_LEN (10)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmmts_delay(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMTSDelay*,
	bool);

uint32_t dot11f_pack_ie_wmmts_delay(
	tpAniSirGlobal,
	tDot11fIEWMMTSDelay *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMTSDelay(
	tpAniSirGlobal,
	tDot11fIEWMMTSDelay *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x02} */
typedef struct sDot11fIEWMMTSPEC {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint16_t         traffic_type:1;
	uint16_t                 tsid:4;
	uint16_t            direction:2;
	uint16_t        access_policy:2;
	uint16_t          aggregation:1;
	uint16_t                  psb:1;
	uint16_t        user_priority:3;
	uint16_t       tsinfo_ack_pol:2;
	uint8_t          tsinfo_rsvd:7;
	uint8_t      burst_size_defn:1;
	uint16_t                 size:15;
	uint16_t                fixed:1;
	uint16_t            max_msdu_size;
	uint32_t            min_service_int;
	uint32_t            max_service_int;
	uint32_t            inactivity_int;
	uint32_t            suspension_int;
	uint32_t            service_start_time;
	uint32_t            min_data_rate;
	uint32_t            mean_data_rate;
	uint32_t            peak_data_rate;
	uint32_t            burst_size;
	uint32_t            delay_bound;
	uint32_t            min_phy_rate;
	uint16_t            surplus_bw_allowance;
	uint16_t            medium_time;
} tDot11fIEWMMTSPEC;

#define DOT11F_EID_WMMTSPEC (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMTSPEC_MIN_LEN (61)

#define DOT11F_IE_WMMTSPEC_MAX_LEN (61)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmmtspec(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMTSPEC*,
	bool);

uint32_t dot11f_pack_ie_wmmtspec(
	tpAniSirGlobal,
	tDot11fIEWMMTSPEC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMTSPEC(
	tpAniSirGlobal,
	tDot11fIEWMMTSPEC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 194 (0xc2) */
typedef struct sDot11fIEWiderBWChanSwitchAnn {
	uint8_t             present;
	uint8_t             newChanWidth;
	uint8_t             newCenterChanFreq0;
	uint8_t             newCenterChanFreq1;
} tDot11fIEWiderBWChanSwitchAnn;

#define DOT11F_EID_WIDERBWCHANSWITCHANN (194)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WIDERBWCHANSWITCHANN_MIN_LEN (3)

#define DOT11F_IE_WIDERBWCHANSWITCHANN_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wider_bw_chan_switch_ann(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWiderBWChanSwitchAnn*,
	bool);

uint32_t dot11f_pack_ie_wider_bw_chan_switch_ann(
	tpAniSirGlobal,
	tDot11fIEWiderBWChanSwitchAnn *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WiderBWChanSwitchAnn(
	tpAniSirGlobal,
	tDot11fIEWiderBWChanSwitchAnn *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIEazimuth_req {
	uint8_t             present;
	uint8_t             request;
} tDot11fIEazimuth_req;

#define DOT11F_EID_AZIMUTH_REQ (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_AZIMUTH_REQ_MIN_LEN (1)

#define DOT11F_IE_AZIMUTH_REQ_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_azimuth_req(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEazimuth_req*,
	bool);

uint32_t dot11f_pack_ie_azimuth_req(
	tpAniSirGlobal,
	tDot11fIEazimuth_req *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_azimuth_req(
	tpAniSirGlobal,
	tDot11fIEazimuth_req *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 4 (0x04) */
typedef struct sDot11fIEmax_age {
	uint8_t             present;
	uint16_t            max_age;
} tDot11fIEmax_age;

#define DOT11F_EID_MAX_AGE (4)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MAX_AGE_MIN_LEN (2)

#define DOT11F_IE_MAX_AGE_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_max_age(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEmax_age*,
	bool);

uint32_t dot11f_pack_ie_max_age(
	tpAniSirGlobal,
	tDot11fIEmax_age *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_max_age(
	tpAniSirGlobal,
	tDot11fIEmax_age *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 52 (0x34) */
typedef struct sDot11fIEneighbor_rpt {
	uint8_t                             present;
	uint8_t                             bssid[6];
	uint8_t                       APReachability:2;
	uint8_t                             Security:1;
	uint8_t                             KeyScope:1;
	uint8_t                          SpecMgmtCap:1;
	uint8_t                               QosCap:1;
	uint8_t                                 apsd:1;
	uint8_t                                  rrm:1;
	uint8_t                            DelayedBA:1;
	uint8_t                                ImmBA:1;
	uint8_t                       MobilityDomain:1;
	uint8_t                             reserved:5;
	uint16_t                            reserved1;
	uint8_t                             regulatoryClass;
	uint8_t                             channel;
	uint8_t                             PhyType;
	tDot11fIETSFInfo                    TSFInfo;
	tDot11fIECondensedCountryStr        CondensedCountryStr;
	tDot11fIEMeasurementPilot           MeasurementPilot;
	tDot11fIERRMEnabledCap              RRMEnabledCap;
	tDot11fIEMultiBssid                 MultiBssid;
} tDot11fIEneighbor_rpt;

#define DOT11F_EID_NEIGHBOR_RPT (52)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_NEIGHBOR_RPT_MIN_LEN (13)

#define DOT11F_IE_NEIGHBOR_RPT_MAX_LEN (546)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_neighbor_rpt(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEneighbor_rpt*,
	bool);

uint32_t dot11f_pack_ie_neighbor_rpt(
	tpAniSirGlobal,
	tDot11fIEneighbor_rpt *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_neighbor_rpt(
	tpAniSirGlobal,
	tDot11fIEneighbor_rpt *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 2 (0x02) */
typedef struct sDot11fIEreq_mac_addr {
	uint8_t             present;
	uint8_t             addr[6];
} tDot11fIEreq_mac_addr;

#define DOT11F_EID_REQ_MAC_ADDR (2)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_REQ_MAC_ADDR_MIN_LEN (6)

#define DOT11F_IE_REQ_MAC_ADDR_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_req_mac_addr(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEreq_mac_addr*,
	bool);

uint32_t dot11f_pack_ie_req_mac_addr(
	tpAniSirGlobal,
	tDot11fIEreq_mac_addr *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_req_mac_addr(
	tpAniSirGlobal,
	tDot11fIEreq_mac_addr *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 3 (0x03) */
typedef struct sDot11fIEtgt_mac_addr {
	uint8_t             present;
	uint8_t             addr[6];
} tDot11fIEtgt_mac_addr;

#define DOT11F_EID_TGT_MAC_ADDR (3)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TGT_MAC_ADDR_MIN_LEN (6)

#define DOT11F_IE_TGT_MAC_ADDR_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tgt_mac_addr(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEtgt_mac_addr*,
	bool);

uint32_t dot11f_pack_ie_tgt_mac_addr(
	tpAniSirGlobal,
	tDot11fIEtgt_mac_addr *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_tgt_mac_addr(
	tpAniSirGlobal,
	tDot11fIEtgt_mac_addr *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 195 (0xc3) */
typedef struct sDot11fIEvht_transmit_power_env {
	uint8_t             present;
	uint8_t             num_bytes;
	uint8_t             bytes[5];
} tDot11fIEvht_transmit_power_env;

#define DOT11F_EID_VHT_TRANSMIT_POWER_ENV (195)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VHT_TRANSMIT_POWER_ENV_MIN_LEN (2)

#define DOT11F_IE_VHT_TRANSMIT_POWER_ENV_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vht_transmit_power_env(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEvht_transmit_power_env*,
	bool);

uint32_t dot11f_pack_ie_vht_transmit_power_env(
	tpAniSirGlobal,
	tDot11fIEvht_transmit_power_env *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_vht_transmit_power_env(
	tpAniSirGlobal,
	tDot11fIEvht_transmit_power_env *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 197 (0xc5) */
typedef struct sDot11fIEAID {
	uint8_t             present;
	uint16_t            assocId;
} tDot11fIEAID;

#define DOT11F_EID_AID (197)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_AID_MIN_LEN (2)

#define DOT11F_IE_AID_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_aid(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEAID*,
	bool);

uint32_t dot11f_pack_ie_aid(
	tpAniSirGlobal,
	tDot11fIEAID *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_AID(
	tpAniSirGlobal,
	tDot11fIEAID *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 4 (0x04) */
typedef struct sDot11fIECFParams {
	uint8_t             present;
	uint8_t             cfp_count;
	uint8_t             cfp_period;
	uint16_t            cfp_maxduration;
	uint16_t            cfp_durremaining;
} tDot11fIECFParams;

#define DOT11F_EID_CFPARAMS (4)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_CFPARAMS_MIN_LEN (6)

#define DOT11F_IE_CFPARAMS_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_cf_params(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIECFParams*,
	bool);

uint32_t dot11f_pack_ie_cf_params(
	tpAniSirGlobal,
	tDot11fIECFParams *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_CFParams(
	tpAniSirGlobal,
	tDot11fIECFParams *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 16 (0x10) */
typedef struct sDot11fIEChallengeText {
	uint8_t             present;
	uint8_t             num_text;
	uint8_t             text[253];
} tDot11fIEChallengeText;

#define DOT11F_EID_CHALLENGETEXT (16)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_CHALLENGETEXT_MIN_LEN (1)

#define DOT11F_IE_CHALLENGETEXT_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_challenge_text(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEChallengeText*,
	bool);

uint32_t dot11f_pack_ie_challenge_text(
	tpAniSirGlobal,
	tDot11fIEChallengeText *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ChallengeText(
	tpAniSirGlobal,
	tDot11fIEChallengeText *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 37 (0x25) */
typedef struct sDot11fIEChanSwitchAnn {
	uint8_t             present;
	uint8_t             switchMode;
	uint8_t             newChannel;
	uint8_t             switchCount;
} tDot11fIEChanSwitchAnn;

#define DOT11F_EID_CHANSWITCHANN (37)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_CHANSWITCHANN_MIN_LEN (3)

#define DOT11F_IE_CHANSWITCHANN_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_chan_switch_ann(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEChanSwitchAnn*,
	bool);

uint32_t dot11f_pack_ie_chan_switch_ann(
	tpAniSirGlobal,
	tDot11fIEChanSwitchAnn *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ChanSwitchAnn(
	tpAniSirGlobal,
	tDot11fIEChanSwitchAnn *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 196 (0xc4) */
typedef struct sDot11fIEChannelSwitchWrapper {
	uint8_t                                present;
	tDot11fIEWiderBWChanSwitchAnn          WiderBWChanSwitchAnn;
	tDot11fIEvht_transmit_power_env        vht_transmit_power_env;
} tDot11fIEChannelSwitchWrapper;

#define DOT11F_EID_CHANNELSWITCHWRAPPER (196)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_CHANNELSWITCHWRAPPER_MIN_LEN (0)

#define DOT11F_IE_CHANNELSWITCHWRAPPER_MAX_LEN (12)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_channel_switch_wrapper(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEChannelSwitchWrapper*,
	bool);

uint32_t dot11f_pack_ie_channel_switch_wrapper(
	tpAniSirGlobal,
	tDot11fIEChannelSwitchWrapper *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_channel_switch_wrapper(
	tpAniSirGlobal,
	tDot11fIEChannelSwitchWrapper *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 7 (0x07) */
typedef struct sDot11fIECountry {
	uint8_t             present;
	uint8_t             country[3];
	uint8_t             num_triplets;
	uint8_t             triplets[84][3];
} tDot11fIECountry;

#define DOT11F_EID_COUNTRY (7)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_COUNTRY_MIN_LEN (3)

#define DOT11F_IE_COUNTRY_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_country(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIECountry*,
	bool);

uint32_t dot11f_pack_ie_country(
	tpAniSirGlobal,
	tDot11fIECountry *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_country(
	tpAniSirGlobal,
	tDot11fIECountry *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 3 (0x03) */
typedef struct sDot11fIEDSParams {
	uint8_t             present;
	uint8_t             curr_channel;
} tDot11fIEDSParams;

#define DOT11F_EID_DSPARAMS (3)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_DSPARAMS_MIN_LEN (1)

#define DOT11F_IE_DSPARAMS_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_DSParams(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEDSParams*,
	bool);

uint32_t dot11f_pack_ie_ds_params(
	tpAniSirGlobal,
	tDot11fIEDSParams *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_DSParams(
	tpAniSirGlobal,
	tDot11fIEDSParams *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 12 (0x0c) */
typedef struct sDot11fIEEDCAParamSet {
	uint8_t             present;
	uint8_t             qos;
	uint8_t             reserved;
	uint8_t           acbe_aifsn:4;
	uint8_t             acbe_acm:1;
	uint8_t             acbe_aci:2;
	uint8_t              unused1:1;
	uint8_t          acbe_acwmin:4;
	uint8_t          acbe_acwmax:4;
	uint16_t            acbe_txoplimit;
	uint8_t           acbk_aifsn:4;
	uint8_t             acbk_acm:1;
	uint8_t             acbk_aci:2;
	uint8_t              unused2:1;
	uint8_t          acbk_acwmin:4;
	uint8_t          acbk_acwmax:4;
	uint16_t            acbk_txoplimit;
	uint8_t           acvi_aifsn:4;
	uint8_t             acvi_acm:1;
	uint8_t             acvi_aci:2;
	uint8_t              unused3:1;
	uint8_t          acvi_acwmin:4;
	uint8_t          acvi_acwmax:4;
	uint16_t            acvi_txoplimit;
	uint8_t           acvo_aifsn:4;
	uint8_t             acvo_acm:1;
	uint8_t             acvo_aci:2;
	uint8_t              unused4:1;
	uint8_t          acvo_acwmin:4;
	uint8_t          acvo_acwmax:4;
	uint16_t            acvo_txoplimit;
} tDot11fIEEDCAParamSet;

#define DOT11F_EID_EDCAPARAMSET (12)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_EDCAPARAMSET_MIN_LEN (18)

#define DOT11F_IE_EDCAPARAMSET_MAX_LEN (18)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_edca_param_set(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEEDCAParamSet*,
	bool);

uint32_t dot11f_pack_ie_edca_param_set(
	tpAniSirGlobal,
	tDot11fIEEDCAParamSet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_EDCAParamSet(
	tpAniSirGlobal,
	tDot11fIEEDCAParamSet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 42 (0x2a) */
typedef struct sDot11fIEERPInfo {
	uint8_t             present;
	uint8_t      non_erp_present:1;
	uint8_t             use_prot:1;
	uint8_t      barker_preamble:1;
	uint8_t               unused:5;
} tDot11fIEERPInfo;

#define DOT11F_EID_ERPINFO (42)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ERPINFO_MIN_LEN (1)

#define DOT11F_IE_ERPINFO_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_erp_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEERPInfo*,
	bool);

uint32_t dot11f_pack_ie_erp_info(
	tpAniSirGlobal,
	tDot11fIEERPInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ERPInfo(
	tpAniSirGlobal,
	tDot11fIEERPInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 156 (0x9c) {OUI 0x00, 0x40, 0x96, 0x00} */
typedef struct sDot11fIEESECckmOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[20];
} tDot11fIEESECckmOpaque;

#define DOT11F_EID_ESECCKMOPAQUE (156)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESECCKMOPAQUE_MIN_LEN (10)

#define DOT11F_IE_ESECCKMOPAQUE_MAX_LEN (24)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_cckm_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESECckmOpaque*,
	bool);

uint32_t dot11f_pack_ie_ese_cckm_opaque(
	tpAniSirGlobal,
	tDot11fIEESECckmOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESECckmOpaque(
	tpAniSirGlobal,
	tDot11fIEESECckmOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x40, 0x96, 0x01} */
typedef struct sDot11fIEESERadMgmtCap {
	uint8_t             present;
	uint8_t             mgmt_state;
	uint8_t          mbssid_mask:3;
	uint8_t             reserved:5;
} tDot11fIEESERadMgmtCap;

#define DOT11F_EID_ESERADMGMTCAP (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESERADMGMTCAP_MIN_LEN (6)

#define DOT11F_IE_ESERADMGMTCAP_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_rad_mgmt_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESERadMgmtCap*,
	bool);

uint32_t dot11f_pack_ie_ese_rad_mgmt_cap(
	tpAniSirGlobal,
	tDot11fIEESERadMgmtCap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESERadMgmtCap(
	tpAniSirGlobal,
	tDot11fIEESERadMgmtCap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x40, 0x96, 0x07} */
typedef struct sDot11fIEESETrafStrmMet {
	uint8_t             present;
	uint8_t             tsid;
	uint8_t             state;
	uint16_t            msmt_interval;
} tDot11fIEESETrafStrmMet;

#define DOT11F_EID_ESETRAFSTRMMET (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESETRAFSTRMMET_MIN_LEN (8)

#define DOT11F_IE_ESETRAFSTRMMET_MAX_LEN (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_traf_strm_met(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESETrafStrmMet*,
	bool);

uint32_t dot11f_pack_ie_ese_traf_strm_met(
	tpAniSirGlobal,
	tDot11fIEESETrafStrmMet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESETrafStrmMet(
	tpAniSirGlobal,
	tDot11fIEESETrafStrmMet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x40, 0x96, 0x08} */
typedef struct sDot11fIEESETrafStrmRateSet {
	uint8_t             present;
	uint8_t             tsid;
	uint8_t             num_tsrates;
	uint8_t             tsrates[8];
} tDot11fIEESETrafStrmRateSet;

#define DOT11F_EID_ESETRAFSTRMRATESET (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESETRAFSTRMRATESET_MIN_LEN (5)

#define DOT11F_IE_ESETRAFSTRMRATESET_MAX_LEN (13)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_traf_strm_rate_set(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESETrafStrmRateSet*,
	bool);

uint32_t dot11f_pack_ie_ese_traf_strm_rate_set(
	tpAniSirGlobal,
	tDot11fIEESETrafStrmRateSet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESETrafStrmRateSet(
	tpAniSirGlobal,
	tDot11fIEESETrafStrmRateSet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 150 (0x96) {OUI 0x00, 0x40, 0x96, 0x00} */
typedef struct sDot11fIEESETxmitPower {
	uint8_t             present;
	uint8_t             power_limit;
	uint8_t             reserved;
} tDot11fIEESETxmitPower;

#define DOT11F_EID_ESETXMITPOWER (150)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESETXMITPOWER_MIN_LEN (6)

#define DOT11F_IE_ESETXMITPOWER_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_txmit_power(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESETxmitPower*,
	bool);

uint32_t dot11f_pack_ie_ese_txmit_power(
	tpAniSirGlobal,
	tDot11fIEESETxmitPower *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESETxmitPower(
	tpAniSirGlobal,
	tDot11fIEESETxmitPower *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x40, 0x96, 0x03} */
typedef struct sDot11fIEESEVersion {
	uint8_t             present;
	uint8_t             version;
} tDot11fIEESEVersion;

#define DOT11F_EID_ESEVERSION (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESEVERSION_MIN_LEN (5)

#define DOT11F_IE_ESEVERSION_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ese_version(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESEVersion*,
	bool);

uint32_t dot11f_pack_ie_ese_version(
	tpAniSirGlobal,
	tDot11fIEESEVersion *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESEVersion(
	tpAniSirGlobal,
	tDot11fIEESEVersion *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 11 (0x0b) */
typedef struct sDot11fIEESP_information {
	uint8_t             present;
	uint8_t             num_variable_data;
	uint8_t             variable_data[96];
} tDot11fIEESP_information;

#define DOT11F_EID_ESP_INFORMATION (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_ESP_INFORMATION_MIN_LEN (0)

#define DOT11F_IE_ESP_INFORMATION_MAX_LEN (96)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ESP_information(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEESP_information*,
	bool);

uint32_t dot11f_pack_ie_ESP_information(
	tpAniSirGlobal,
	tDot11fIEESP_information *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ESP_information(
	tpAniSirGlobal,
	tDot11fIEESP_information *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 127 (0x7f) */
typedef struct sDot11fIEExtCap {
	uint8_t             present;
	uint8_t             num_bytes;
	uint8_t             bytes[15];
} tDot11fIEExtCap;

#define DOT11F_EID_EXTCAP (127)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_EXTCAP_MIN_LEN (1)

#define DOT11F_IE_EXTCAP_MAX_LEN (15)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ext_cap(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEExtCap*,
	bool);

uint32_t dot11f_pack_ie_ext_cap(
	tpAniSirGlobal,
	tDot11fIEExtCap *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ExtCap(
	tpAniSirGlobal,
	tDot11fIEExtCap *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 50 (0x32) */
typedef struct sDot11fIEExtSuppRates {
	uint8_t             present;
	uint8_t             num_rates;
	uint8_t             rates[12];
} tDot11fIEExtSuppRates;

#define DOT11F_EID_EXTSUPPRATES (50)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_EXTSUPPRATES_MIN_LEN (1)

#define DOT11F_IE_EXTSUPPRATES_MAX_LEN (12)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ext_supp_rates(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEExtSuppRates*,
	bool);

uint32_t dot11f_pack_ie_ext_supp_rates(
	tpAniSirGlobal,
	tDot11fIEExtSuppRates *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ExtSuppRates(
	tpAniSirGlobal,
	tDot11fIEExtSuppRates *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 2 (0x02) */
typedef struct sDot11fIEFHParamSet {
	uint8_t             present;
	uint16_t            dwell_time;
	uint8_t             hop_set;
	uint8_t             hop_pattern;
	uint8_t             hop_index;
} tDot11fIEFHParamSet;

#define DOT11F_EID_FHPARAMSET (2)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FHPARAMSET_MIN_LEN (5)

#define DOT11F_IE_FHPARAMSET_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fh_param_set(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEFHParamSet*,
	bool);

uint32_t dot11f_pack_ie_fh_param_set(
	tpAniSirGlobal,
	tDot11fIEFHParamSet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_FHParamSet(
	tpAniSirGlobal,
	tDot11fIEFHParamSet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 8 (0x08) */
typedef struct sDot11fIEFHParams {
	uint8_t             present;
	uint8_t             radix;
	uint8_t             nchannels;
} tDot11fIEFHParams;

#define DOT11F_EID_FHPARAMS (8)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FHPARAMS_MIN_LEN (2)

#define DOT11F_IE_FHPARAMS_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fh_params(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEFHParams*,
	bool);

uint32_t dot11f_pack_ie_fh_params(
	tpAniSirGlobal,
	tDot11fIEFHParams *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_FHParams(
	tpAniSirGlobal,
	tDot11fIEFHParams *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 9 (0x09) */
typedef struct sDot11fIEFHPattTable {
	uint8_t             present;
	uint8_t             flag;
	uint8_t             nsets;
	uint8_t             modulus;
	uint8_t             offset;
	uint8_t             num_randtable;
	uint8_t             randtable[251];
} tDot11fIEFHPattTable;

#define DOT11F_EID_FHPATTTABLE (9)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FHPATTTABLE_MIN_LEN (4)

#define DOT11F_IE_FHPATTTABLE_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fh_patt_table(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEFHPattTable*,
	bool);

uint32_t dot11f_pack_ie_fh_patt_table(
	tpAniSirGlobal,
	tDot11fIEFHPattTable *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_FHPattTable(
	tpAniSirGlobal,
	tDot11fIEFHPattTable *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 55 (0x37) */
typedef struct sDot11fIEFTInfo {
	uint8_t                 present;
	uint16_t                 reserved:8;
	uint16_t                  IECount:8;
	uint8_t                 MIC[16];
	uint8_t                 Anonce[32];
	uint8_t                 Snonce[32];
	tDot11fIER1KH_ID        R1KH_ID;
	tDot11fIEGTK            GTK;
	tDot11fIER0KH_ID        R0KH_ID;
	tDot11fIEIGTK           IGTK;
} tDot11fIEFTInfo;

#define DOT11F_EID_FTINFO (55)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FTINFO_MIN_LEN (82)

#define DOT11F_IE_FTINFO_MAX_LEN (220)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ft_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEFTInfo*,
	bool);

uint32_t dot11f_pack_ie_ft_info(
	tpAniSirGlobal,
	tDot11fIEFTInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ieft_info(
	tpAniSirGlobal,
	tDot11fIEFTInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 45 (0x2d) */
typedef struct sDot11fIEHTCaps {
	uint8_t             present;
	uint16_t         advCodingCap:1;
	uint16_t supportedChannelWidthSet:1;
	uint16_t        mimoPowerSave:2;
	uint16_t           greenField:1;
	uint16_t         shortGI20MHz:1;
	uint16_t         shortGI40MHz:1;
	uint16_t               txSTBC:1;
	uint16_t               rxSTBC:2;
	uint16_t            delayedBA:1;
	uint16_t     maximalAMSDUsize:1;
	uint16_t     dsssCckMode40MHz:1;
	uint16_t                 psmp:1;
	uint16_t     stbcControlFrame:1;
	uint16_t   lsigTXOPProtection:1;
	uint8_t     maxRxAMPDUFactor:2;
	uint8_t          mpduDensity:3;
	uint8_t            reserved1:3;
	uint8_t             supportedMCSSet[16];
	uint16_t                  pco:1;
	uint16_t       transitionTime:2;
	uint16_t            reserved2:5;
	uint16_t          mcsFeedback:2;
	uint16_t            reserved3:6;
	uint32_t                 txBF:1;
	uint32_t  rxStaggeredSounding:1;
	uint32_t  txStaggeredSounding:1;
	uint32_t                rxZLF:1;
	uint32_t                txZLF:1;
	uint32_t         implicitTxBF:1;
	uint32_t          calibration:2;
	uint32_t      explicitCSITxBF:1;
	uint32_t explicitUncompressedSteeringMatrix:1;
	uint32_t explicitBFCSIFeedback:3;
	uint32_t explicitUncompressedSteeringMatrixFeedback:3;
	uint32_t explicitCompressedSteeringMatrixFeedback:3;
	uint32_t     csiNumBFAntennae:2;
	uint32_t uncompressedSteeringMatrixBFAntennae:2;
	uint32_t compressedSteeringMatrixBFAntennae:2;
	uint32_t            reserved4:7;
	uint8_t     antennaSelection:1;
	uint8_t explicitCSIFeedbackTx:1;
	uint8_t antennaIndicesFeedbackTx:1;
	uint8_t  explicitCSIFeedback:1;
	uint8_t antennaIndicesFeedback:1;
	uint8_t                 rxAS:1;
	uint8_t      txSoundingPPDUs:1;
	uint8_t            reserved5:1;
	uint8_t             num_rsvd;
	uint8_t             rsvd[32];
} tDot11fIEHTCaps;

#define DOT11F_EID_HTCAPS (45)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_HTCAPS_MIN_LEN (26)

#define DOT11F_IE_HTCAPS_MAX_LEN (58)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ht_caps(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEHTCaps*,
	bool);

uint32_t dot11f_pack_ie_ht_caps(
	tpAniSirGlobal,
	tDot11fIEHTCaps *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_HTCaps(
	tpAniSirGlobal,
	tDot11fIEHTCaps *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 61 (0x3d) */
typedef struct sDot11fIEHTInfo {
	uint8_t             present;
	uint8_t             primaryChannel;
	uint8_t secondaryChannelOffset:2;
	uint8_t recommendedTxWidthSet:1;
	uint8_t             rifsMode:1;
	uint8_t controlledAccessOnly:1;
	uint8_t serviceIntervalGranularity:3;
	uint16_t               opMode:2;
	uint16_t  nonGFDevicesPresent:1;
	uint16_t   transmitBurstLimit:1;
	uint16_t  obssNonHTStaPresent:1;
	uint16_t             reserved:11;
	uint16_t         basicSTBCMCS:7;
	uint16_t    dualCTSProtection:1;
	uint16_t      secondaryBeacon:1;
	uint16_t lsigTXOPProtectionFullSupport:1;
	uint16_t            pcoActive:1;
	uint16_t             pcoPhase:1;
	uint16_t            reserved2:4;
	uint8_t             basicMCSSet[16];
	uint8_t             num_rsvd;
	uint8_t             rsvd[32];
} tDot11fIEHTInfo;

#define DOT11F_EID_HTINFO (61)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_HTINFO_MIN_LEN (22)

#define DOT11F_IE_HTINFO_MAX_LEN (54)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ht_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEHTInfo*,
	bool);

uint32_t dot11f_pack_ie_ht_info(
	tpAniSirGlobal,
	tDot11fIEHTInfo *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_HTInfo(
	tpAniSirGlobal,
	tDot11fIEHTInfo *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 6 (0x06) */
typedef struct sDot11fIEIBSSParams {
	uint8_t             present;
	uint16_t            atim;
} tDot11fIEIBSSParams;

#define DOT11F_EID_IBSSPARAMS (6)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_IBSSPARAMS_MIN_LEN (2)

#define DOT11F_IE_IBSSPARAMS_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ibss_params(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEIBSSParams*,
	bool);

uint32_t dot11f_pack_ie_ibss_params(
	tpAniSirGlobal,
	tDot11fIEIBSSParams *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_IBSSParams(
	tpAniSirGlobal,
	tDot11fIEIBSSParams *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 101 (0x65) */
typedef struct sDot11fIELinkIdentifier {
	uint8_t             present;
	uint8_t             bssid[6];
	uint8_t             InitStaAddr[6];
	uint8_t             RespStaAddr[6];
} tDot11fIELinkIdentifier;

#define DOT11F_EID_LINKIDENTIFIER (101)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_LINKIDENTIFIER_MIN_LEN (18)

#define DOT11F_IE_LINKIDENTIFIER_MAX_LEN (18)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_link_identifier(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIELinkIdentifier*,
	bool);

uint32_t dot11f_pack_ie_link_identifier(
	tpAniSirGlobal,
	tDot11fIELinkIdentifier *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_LinkIdentifier(
	tpAniSirGlobal,
	tDot11fIELinkIdentifier *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x16} (Multi-IE) */
typedef struct sDot11fIEMBO_IE {
	uint8_t             present;
	tDot11fTLVmbo_ap_cap mbo_ap_cap;
	tDot11fTLVnon_prefferd_chan_rep non_prefferd_chan_rep;
	tDot11fTLVcellular_data_cap cellular_data_cap;
	tDot11fTLVassoc_disallowed assoc_disallowed;
	tDot11fTLVcellular_data_con_pref cellular_data_con_pref;
	tDot11fTLVtransition_reason transition_reason;
	tDot11fTLVtransition_reject_reason transition_reject_reason;
	tDot11fTLVassoc_retry_delay assoc_retry_delay;
	tDot11fTLVoce_cap   oce_cap;
	tDot11fTLVrssi_assoc_rej rssi_assoc_rej;
	tDot11fTLVreduced_wan_metrics reduced_wan_metrics;
} tDot11fIEMBO_IE;

#define DOT11F_EID_MBO_IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MBO_IE_MIN_LEN (4)

#define DOT11F_IE_MBO_IE_MAX_LEN (293)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_MBO_IE(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMBO_IE*,
	bool);

uint32_t dot11f_pack_ie_MBO_IE(
	tpAniSirGlobal,
	tDot11fIEMBO_IE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_MBO_IE(
	tpAniSirGlobal,
	tDot11fIEMBO_IE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 39 (0x27) */
typedef struct sDot11fIEMeasurementReport {
	uint8_t             present;
	uint8_t             token;
	uint8_t                 late:1;
	uint8_t            incapable:1;
	uint8_t              refused:1;
	uint8_t               unused:5;
	uint8_t             type;
	union {
		struct {
			uint8_t channel;
			tDOT11F_U64 meas_start_time;
			uint16_t meas_duration;
			uint8_t            bss:1;
			uint8_t  ofdm_preamble:1;
			uint8_t    unid_signal:1;
			uint8_t          rader:1;
			uint8_t     unmeasured:1;
			uint8_t         unused:3;
		} Basic; /* type = 0 */
		struct {
			uint8_t channel;
			tDOT11F_U64 meas_start_time;
			uint16_t meas_duration;
			uint8_t cca_busy_fraction;
		} CCA; /* type = 1 */
		struct {
			uint8_t channel;
			tDOT11F_U64 meas_start_time;
			uint16_t meas_duration;
			uint8_t rpi0_density;
			uint8_t rpi1_density;
			uint8_t rpi2_density;
			uint8_t rpi3_density;
			uint8_t rpi4_density;
			uint8_t rpi5_density;
			uint8_t rpi6_density;
			uint8_t rpi7_density;
		} RPIHistogram; /* type = 2 */
		struct {
			uint8_t regClass;
			uint8_t channel;
			tDOT11F_U64 meas_start_time;
			uint16_t meas_duration;
			uint8_t        condensed_PHY:7;
			uint8_t  reported_frame_type:1;
			uint8_t RCPI;
			uint8_t RSNI;
			uint8_t BSSID[6];
			uint8_t antenna_id;
			uint32_t parent_TSF;
	tDot11fIEBeaconReportFrmBody BeaconReportFrmBody;
		} Beacon; /* type = 5 */
	} report;
} tDot11fIEMeasurementReport;

#define DOT11F_EID_MEASUREMENTREPORT (39)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MEASUREMENTREPORT_MIN_LEN (3)

#define DOT11F_IE_MEASUREMENTREPORT_MAX_LEN (29)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_measurement_report(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMeasurementReport*,
	bool);

uint32_t dot11f_pack_ie_measurement_report(
	tpAniSirGlobal,
	tDot11fIEMeasurementReport *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_measurement_report(
	tpAniSirGlobal,
	tDot11fIEMeasurementReport *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 38 (0x26) */
typedef struct sDot11fIEMeasurementRequest {
	uint8_t             present;
	uint8_t             measurement_token;
	uint8_t             parallel:1;
	uint8_t               enable:1;
	uint8_t              request:1;
	uint8_t               report:1;
	uint8_t    durationMandatory:1;
	uint8_t               unused:3;
	uint8_t             measurement_type;
	union {
		struct {
			uint8_t channel_no;
			uint8_t meas_start_time[8];
			uint16_t meas_duration;
		} Basic; /* measurement_type = 0 */
		struct {
			uint8_t channel_no;
			uint8_t meas_start_time[8];
			uint16_t meas_duration;
		} CCA; /* measurement_type = 1 */
		struct {
			uint8_t channel_no;
			uint8_t meas_start_time[8];
			uint16_t meas_duration;
		} RPIHistogram; /* measurement_type = 2 */
		struct {
			uint8_t regClass;
			uint8_t channel;
			uint16_t randomization;
			uint16_t meas_duration;
			uint8_t meas_mode;
			uint8_t BSSID[6];
	tDot11fIESSID SSID;
	tDot11fIEBeaconReporting BeaconReporting;
	tDot11fIEBcnReportingDetail BcnReportingDetail;
	tDot11fIERequestedInfo RequestedInfo;
	uint16_t num_APChannelReport;
	tDot11fIEAPChannelReport APChannelReport[2];
		} Beacon; /* measurement_type = 5 */
		struct {
			uint8_t loc_subject;
	tDot11fIEazimuth_req azimuth_req;
	tDot11fIEreq_mac_addr req_mac_addr;
	tDot11fIEtgt_mac_addr tgt_mac_addr;
	tDot11fIEmax_age max_age;
		} lci; /* measurement_type = 8 */
		struct {
			uint16_t random_interval;
			uint8_t min_ap_count;
	tDot11fIEneighbor_rpt neighbor_rpt;
	tDot11fIEmax_age max_age;
		} ftmrr; /* measurement_type = 16 */
	} measurement_request;
} tDot11fIEMeasurementRequest;

#define DOT11F_EID_MEASUREMENTREQUEST (38)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MEASUREMENTREQUEST_MIN_LEN (4)

#define DOT11F_IE_MEASUREMENTREQUEST_MAX_LEN (16)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_measurement_request(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMeasurementRequest*,
	bool);

uint32_t dot11f_pack_ie_measurement_request(
	tpAniSirGlobal,
	tDot11fIEMeasurementRequest *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_measurement_request(
	tpAniSirGlobal,
	tDot11fIEMeasurementRequest *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 54 (0x36) */
typedef struct sDot11fIEMobilityDomain {
	uint8_t             present;
	uint16_t            MDID;
	uint8_t            overDSCap:1;
	uint8_t       resourceReqCap:1;
	uint8_t             reserved:6;
} tDot11fIEMobilityDomain;

#define DOT11F_EID_MOBILITYDOMAIN (54)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_MOBILITYDOMAIN_MIN_LEN (3)

#define DOT11F_IE_MOBILITYDOMAIN_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_mobility_domain(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEMobilityDomain*,
	bool);

uint32_t dot11f_pack_ie_mobility_domain(
	tpAniSirGlobal,
	tDot11fIEMobilityDomain *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_MobilityDomain(
	tpAniSirGlobal,
	tDot11fIEMobilityDomain *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 52 (0x34) */
typedef struct sDot11fIENeighborReport {
	uint8_t                             present;
	uint8_t                             bssid[6];
	uint8_t                       APReachability:2;
	uint8_t                             Security:1;
	uint8_t                             KeyScope:1;
	uint8_t                          SpecMgmtCap:1;
	uint8_t                               QosCap:1;
	uint8_t                                 apsd:1;
	uint8_t                                  rrm:1;
	uint8_t                            DelayedBA:1;
	uint8_t                                ImmBA:1;
	uint8_t                       MobilityDomain:1;
	uint8_t                             reserved:5;
	uint16_t                            reserved1;
	uint8_t                             regulatoryClass;
	uint8_t                             channel;
	uint8_t                             PhyType;
	tDot11fIETSFInfo                    TSFInfo;
	tDot11fIECondensedCountryStr        CondensedCountryStr;
	tDot11fIEMeasurementPilot           MeasurementPilot;
	tDot11fIERRMEnabledCap              RRMEnabledCap;
	tDot11fIEMultiBssid                 MultiBssid;
} tDot11fIENeighborReport;

#define DOT11F_EID_NEIGHBORREPORT (52)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_NEIGHBORREPORT_MIN_LEN (13)

#define DOT11F_IE_NEIGHBORREPORT_MAX_LEN (546)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_neighbor_report(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIENeighborReport*,
	bool);

uint32_t dot11f_pack_ie_neighbor_report(
	tpAniSirGlobal,
	tDot11fIENeighborReport *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_neighbor_report(
	tpAniSirGlobal,
	tDot11fIENeighborReport *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 74 (0x4a) */
typedef struct sDot11fIEOBSSScanParameters {
	uint8_t             present;
	uint16_t            obssScanPassiveDwell;
	uint16_t            obssScanActiveDwell;
	uint16_t            bssChannelWidthTriggerScanInterval;
	uint16_t            obssScanPassiveTotalPerChannel;
	uint16_t            obssScanActiveTotalPerChannel;
	uint16_t            bssWidthChannelTransitionDelayFactor;
	uint16_t            obssScanActivityThreshold;
} tDot11fIEOBSSScanParameters;

#define DOT11F_EID_OBSSSCANPARAMETERS (74)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_OBSSSCANPARAMETERS_MIN_LEN (14)

#define DOT11F_IE_OBSSSCANPARAMETERS_MAX_LEN (14)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_obss_scan_parameters(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEOBSSScanParameters*,
	bool);

uint32_t dot11f_pack_ie_obss_scan_parameters(
	tpAniSirGlobal,
	tDot11fIEOBSSScanParameters *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_OBSSScanParameters(
	tpAniSirGlobal,
	tDot11fIEOBSSScanParameters *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 199 (0xc7) */
typedef struct sDot11fIEOperatingMode {
	uint8_t             present;
	uint8_t            chanWidth:2;
	uint8_t             reserved:2;
	uint8_t                rxNSS:3;
	uint8_t            rxNSSType:1;
} tDot11fIEOperatingMode;

#define DOT11F_EID_OPERATINGMODE (199)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_OPERATINGMODE_MIN_LEN (1)

#define DOT11F_IE_OPERATINGMODE_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_operating_mode(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEOperatingMode*,
	bool);

uint32_t dot11f_pack_ie_operating_mode(
	tpAniSirGlobal,
	tDot11fIEOperatingMode *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_OperatingMode(
	tpAniSirGlobal,
	tDot11fIEOperatingMode *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PAssocReq {
	uint8_t             present;
	tDot11fTLVP2PCapability P2PCapability;
	tDot11fTLVExtendedListenTiming ExtendedListenTiming;
	tDot11fTLVP2PDeviceInfo P2PDeviceInfo;
} tDot11fIEP2PAssocReq;

#define DOT11F_EID_P2PASSOCREQ (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PASSOCREQ_MIN_LEN (4)

#define DOT11F_IE_P2PASSOCREQ_MAX_LEN (71)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_assoc_req(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PAssocReq*,
	bool);

uint32_t dot11f_pack_ie_p2_p_assoc_req(
	tpAniSirGlobal,
	tDot11fIEP2PAssocReq *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_assoc_req(
	tpAniSirGlobal,
	tDot11fIEP2PAssocReq *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PAssocRes {
	uint8_t             present;
	tDot11fTLVP2PStatus P2PStatus;
	tDot11fTLVExtendedListenTiming ExtendedListenTiming;
} tDot11fIEP2PAssocRes;

#define DOT11F_EID_P2PASSOCRES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PASSOCRES_MIN_LEN (4)

#define DOT11F_IE_P2PASSOCRES_MAX_LEN (15)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_assoc_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PAssocRes*,
	bool);

uint32_t dot11f_pack_ie_p2_p_assoc_res(
	tpAniSirGlobal,
	tDot11fIEP2PAssocRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_assoc_res(
	tpAniSirGlobal,
	tDot11fIEP2PAssocRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PBeacon {
	uint8_t             present;
	tDot11fTLVP2PCapability P2PCapability;
	tDot11fTLVP2PDeviceId P2PDeviceId;
	tDot11fTLVNoticeOfAbsence NoticeOfAbsence;
} tDot11fIEP2PBeacon;

#define DOT11F_EID_P2PBEACON (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PBEACON_MIN_LEN (4)

#define DOT11F_IE_P2PBEACON_MAX_LEN (59)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_beacon(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PBeacon*,
	bool);

uint32_t dot11f_pack_ie_p2_p_beacon(
	tpAniSirGlobal,
	tDot11fIEP2PBeacon *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_beacon(
	tpAniSirGlobal,
	tDot11fIEP2PBeacon *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PBeaconProbeRes {
	uint8_t             present;
	tDot11fTLVP2PCapability P2PCapability;
	tDot11fTLVP2PDeviceId P2PDeviceId;
	tDot11fTLVExtendedListenTiming ExtendedListenTiming;
	tDot11fTLVNoticeOfAbsence NoticeOfAbsence;
	tDot11fTLVP2PDeviceInfo P2PDeviceInfo;
	tDot11fTLVP2PGroupInfo P2PGroupInfo;
} tDot11fIEP2PBeaconProbeRes;

#define DOT11F_EID_P2PBEACONPROBERES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PBEACONPROBERES_MIN_LEN (4)

#define DOT11F_IE_P2PBEACONPROBERES_MAX_LEN (1148)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_beacon_probe_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PBeaconProbeRes*,
	bool);

uint32_t dot11f_pack_ie_p2_p_beacon_probe_res(
	tpAniSirGlobal,
	tDot11fIEP2PBeaconProbeRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_beacon_probe_res(
	tpAniSirGlobal,
	tDot11fIEP2PBeaconProbeRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PDeAuth {
	uint8_t             present;
	tDot11fTLVMinorReasonCode MinorReasonCode;
} tDot11fIEP2PDeAuth;

#define DOT11F_EID_P2PDEAUTH (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PDEAUTH_MIN_LEN (4)

#define DOT11F_IE_P2PDEAUTH_MAX_LEN (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_de_auth(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PDeAuth*,
	bool);

uint32_t dot11f_pack_ie_p2_p_de_auth(
	tpAniSirGlobal,
	tDot11fIEP2PDeAuth *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_de_auth(
	tpAniSirGlobal,
	tDot11fIEP2PDeAuth *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PDisAssoc {
	uint8_t             present;
	tDot11fTLVMinorReasonCode MinorReasonCode;
} tDot11fIEP2PDisAssoc;

#define DOT11F_EID_P2PDISASSOC (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PDISASSOC_MIN_LEN (4)

#define DOT11F_IE_P2PDISASSOC_MAX_LEN (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_dis_assoc(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PDisAssoc*,
	bool);

uint32_t dot11f_pack_ie_p2_p_dis_assoc(
	tpAniSirGlobal,
	tDot11fIEP2PDisAssoc *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_dis_assoc(
	tpAniSirGlobal,
	tDot11fIEP2PDisAssoc *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} */
typedef struct sDot11fIEP2PIEOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[249];
} tDot11fIEP2PIEOpaque;

#define DOT11F_EID_P2PIEOPAQUE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PIEOPAQUE_MIN_LEN (6)

#define DOT11F_IE_P2PIEOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_pie_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PIEOpaque*,
	bool);

uint32_t dot11f_pack_ie_p2_pie_opaque(
	tpAniSirGlobal,
	tDot11fIEP2PIEOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_P2PIEOpaque(
	tpAniSirGlobal,
	tDot11fIEP2PIEOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PProbeReq {
	uint8_t             present;
	tDot11fTLVP2PCapability P2PCapability;
	tDot11fTLVP2PDeviceId P2PDeviceId;
	tDot11fTLVListenChannel ListenChannel;
	tDot11fTLVExtendedListenTiming ExtendedListenTiming;
	tDot11fTLVOperatingChannel OperatingChannel;
} tDot11fIEP2PProbeReq;

#define DOT11F_EID_P2PPROBEREQ (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PPROBEREQ_MIN_LEN (4)

#define DOT11F_IE_P2PPROBEREQ_MAX_LEN (41)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_probe_req(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PProbeReq*,
	bool);

uint32_t dot11f_pack_ie_p2_p_probe_req(
	tpAniSirGlobal,
	tDot11fIEP2PProbeReq *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_probe_req(
	tpAniSirGlobal,
	tDot11fIEP2PProbeReq *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x09} (Multi-IE) */
typedef struct sDot11fIEP2PProbeRes {
	uint8_t             present;
	tDot11fTLVP2PCapability P2PCapability;
	tDot11fTLVExtendedListenTiming ExtendedListenTiming;
	tDot11fTLVNoticeOfAbsence NoticeOfAbsence;
	tDot11fTLVP2PDeviceInfo P2PDeviceInfo;
	tDot11fTLVP2PGroupInfo P2PGroupInfo;
} tDot11fIEP2PProbeRes;

#define DOT11F_EID_P2PPROBERES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_P2PPROBERES_MIN_LEN (4)

#define DOT11F_IE_P2PPROBERES_MAX_LEN (1139)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_p2_p_probe_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEP2PProbeRes*,
	bool);

uint32_t dot11f_pack_ie_p2_p_probe_res(
	tpAniSirGlobal,
	tDot11fIEP2PProbeRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iep2_p_probe_res(
	tpAniSirGlobal,
	tDot11fIEP2PProbeRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 105 (0x69) */
typedef struct sDot11fIEPTIControl {
	uint8_t             present;
	uint8_t             tid;
	uint16_t            sequence_control;
} tDot11fIEPTIControl;

#define DOT11F_EID_PTICONTROL (105)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_PTICONTROL_MIN_LEN (3)

#define DOT11F_IE_PTICONTROL_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_pti_control(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEPTIControl*,
	bool);

uint32_t dot11f_pack_ie_pti_control(
	tpAniSirGlobal,
	tDot11fIEPTIControl *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_PTIControl(
	tpAniSirGlobal,
	tDot11fIEPTIControl *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 106 (0x6a) */
typedef struct sDot11fIEPUBufferStatus {
	uint8_t             present;
	uint8_t   ac_bk_traffic_aval:1;
	uint8_t   ac_be_traffic_aval:1;
	uint8_t   ac_vi_traffic_aval:1;
	uint8_t   ac_vo_traffic_aval:1;
	uint8_t             reserved:4;
} tDot11fIEPUBufferStatus;

#define DOT11F_EID_PUBUFFERSTATUS (106)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_PUBUFFERSTATUS_MIN_LEN (1)

#define DOT11F_IE_PUBUFFERSTATUS_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_pu_buffer_status(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEPUBufferStatus*,
	bool);

uint32_t dot11f_pack_ie_pu_buffer_status(
	tpAniSirGlobal,
	tDot11fIEPUBufferStatus *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_PUBufferStatus(
	tpAniSirGlobal,
	tDot11fIEPUBufferStatus *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 33 (0x21) */
typedef struct sDot11fIEPowerCaps {
	uint8_t             present;
	uint8_t             minTxPower;
	uint8_t             maxTxPower;
} tDot11fIEPowerCaps;

#define DOT11F_EID_POWERCAPS (33)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_POWERCAPS_MIN_LEN (2)

#define DOT11F_IE_POWERCAPS_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_power_caps(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEPowerCaps*,
	bool);

uint32_t dot11f_pack_ie_power_caps(
	tpAniSirGlobal,
	tDot11fIEPowerCaps *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_PowerCaps(
	tpAniSirGlobal,
	tDot11fIEPowerCaps *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 32 (0x20) */
typedef struct sDot11fIEPowerConstraints {
	uint8_t             present;
	uint8_t             localPowerConstraints;
} tDot11fIEPowerConstraints;

#define DOT11F_EID_POWERCONSTRAINTS (32)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_POWERCONSTRAINTS_MIN_LEN (1)

#define DOT11F_IE_POWERCONSTRAINTS_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_power_constraints(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEPowerConstraints*,
	bool);

uint32_t dot11f_pack_ie_power_constraints(
	tpAniSirGlobal,
	tDot11fIEPowerConstraints *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_PowerConstraints(
	tpAniSirGlobal,
	tDot11fIEPowerConstraints *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 11 (0x0b) */
typedef struct sDot11fIEQBSSLoad {
	uint8_t             present;
	uint16_t            stacount;
	uint8_t             chautil;
	uint16_t            avail;
} tDot11fIEQBSSLoad;

#define DOT11F_EID_QBSSLOAD (11)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QBSSLOAD_MIN_LEN (5)

#define DOT11F_IE_QBSSLOAD_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_qbss_load(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQBSSLoad*,
	bool);

uint32_t dot11f_pack_ie_qbss_load(
	tpAniSirGlobal,
	tDot11fIEQBSSLoad *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QBSSLoad(
	tpAniSirGlobal,
	tDot11fIEQBSSLoad *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x8c, 0xfd, 0xf0, 0x01} */
typedef struct sDot11fIEQCN_IE {
	uint8_t             present;
	uint8_t             version[4];
} tDot11fIEQCN_IE;

#define DOT11F_EID_QCN_IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QCN_IE_MIN_LEN (8)

#define DOT11F_IE_QCN_IE_MAX_LEN (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_QCN_IE(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQCN_IE*,
	bool);

uint32_t dot11f_pack_ie_QCN_IE(
	tpAniSirGlobal,
	tDot11fIEQCN_IE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QCN_IE(
	tpAniSirGlobal,
	tDot11fIEQCN_IE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0xa0, 0xc6} */
typedef struct sDot11fIEQComVendorIE {
	uint8_t             present;
	uint8_t             type;
	uint8_t             channel;
} tDot11fIEQComVendorIE;

#define DOT11F_EID_QCOMVENDORIE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QCOMVENDORIE_MIN_LEN (5)

#define DOT11F_IE_QCOMVENDORIE_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_QComVendorIE(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQComVendorIE*,
	bool);

uint32_t dot11f_pack_ie_QComVendorIE(
	tpAniSirGlobal,
	tDot11fIEQComVendorIE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QComVendorIE(
	tpAniSirGlobal,
	tDot11fIEQComVendorIE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 46 (0x2e) */
typedef struct sDot11fIEQOSCapsAp {
	uint8_t             present;
	uint8_t                count:4;
	uint8_t                 qack:1;
	uint8_t                 qreq:1;
	uint8_t              txopreq:1;
	uint8_t             reserved:1;
} tDot11fIEQOSCapsAp;

#define DOT11F_EID_QOSCAPSAP (46)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QOSCAPSAP_MIN_LEN (1)

#define DOT11F_IE_QOSCAPSAP_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_qos_caps_ap(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQOSCapsAp*,
	bool);

uint32_t dot11f_pack_ie_qos_caps_ap(
	tpAniSirGlobal,
	tDot11fIEQOSCapsAp *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QOSCapsAp(
	tpAniSirGlobal,
	tDot11fIEQOSCapsAp *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 46 (0x2e) */
typedef struct sDot11fIEQOSCapsStation {
	uint8_t             present;
	uint8_t           acvo_uapsd:1;
	uint8_t           acvi_uapsd:1;
	uint8_t           acbk_uapsd:1;
	uint8_t           acbe_uapsd:1;
	uint8_t                 qack:1;
	uint8_t        max_sp_length:2;
	uint8_t        more_data_ack:1;
} tDot11fIEQOSCapsStation;

#define DOT11F_EID_QOSCAPSSTATION (46)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QOSCAPSSTATION_MIN_LEN (1)

#define DOT11F_IE_QOSCAPSSTATION_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_qos_caps_station(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQOSCapsStation*,
	bool);

uint32_t dot11f_pack_ie_qos_caps_station(
	tpAniSirGlobal,
	tDot11fIEQOSCapsStation *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QOSCapsStation(
	tpAniSirGlobal,
	tDot11fIEQOSCapsStation *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 110 (0x6e) */
typedef struct sDot11fIEQosMapSet {
	uint8_t             present;
	uint8_t             num_dscp_exceptions;
	uint8_t             dscp_exceptions[60];
} tDot11fIEQosMapSet;

#define DOT11F_EID_QOSMAPSET (110)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QOSMAPSET_MIN_LEN (0)

#define DOT11F_IE_QOSMAPSET_MAX_LEN (60)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_qos_map_set(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQosMapSet*,
	bool);

uint32_t dot11f_pack_ie_qos_map_set(
	tpAniSirGlobal,
	tDot11fIEQosMapSet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_QosMapSet(
	tpAniSirGlobal,
	tDot11fIEQosMapSet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 40 (0x28) */
typedef struct sDot11fIEQuiet {
	uint8_t             present;
	uint8_t             count;
	uint8_t             period;
	uint16_t            duration;
	uint16_t            offset;
} tDot11fIEQuiet;

#define DOT11F_EID_QUIET (40)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_QUIET_MIN_LEN (6)

#define DOT11F_IE_QUIET_MAX_LEN (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_quiet(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEQuiet*,
	bool);

uint32_t dot11f_pack_ie_quiet(
	tpAniSirGlobal,
	tDot11fIEQuiet *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_Quiet(
	tpAniSirGlobal,
	tDot11fIEQuiet *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 53 (0x35) */
typedef struct sDot11fIERCPIIE {
	uint8_t             present;
	uint8_t             rcpi;
} tDot11fIERCPIIE;

#define DOT11F_EID_RCPIIE (53)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RCPIIE_MIN_LEN (1)

#define DOT11F_IE_RCPIIE_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_rcpiie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERCPIIE*,
	bool);

uint32_t dot11f_pack_ie_rcpiie(
	tpAniSirGlobal,
	tDot11fIERCPIIE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_RCPIIE(
	tpAniSirGlobal,
	tDot11fIERCPIIE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 57 (0x39) */
typedef struct sDot11fIERICDataDesc {
	uint8_t                       present;
	tDot11fIERICData              RICData;
	tDot11fIERICDescriptor        RICDescriptor;
	tDot11fIETSPEC                TSPEC;
	uint16_t                      num_TCLAS;
	tDot11fIETCLAS                TCLAS[2];
	tDot11fIETCLASSPROC           TCLASSPROC;
	tDot11fIETSDelay              TSDelay;
	tDot11fIESchedule             Schedule;
	tDot11fIEWMMTSPEC             WMMTSPEC;
	uint16_t                      num_WMMTCLAS;
	tDot11fIEWMMTCLAS             WMMTCLAS[2];
	tDot11fIEWMMTCLASPROC         WMMTCLASPROC;
	tDot11fIEWMMTSDelay           WMMTSDelay;
	tDot11fIEWMMSchedule          WMMSchedule;
} tDot11fIERICDataDesc;

#define DOT11F_EID_RICDATADESC (57)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RICDATADESC_MIN_LEN (0)

#define DOT11F_IE_RICDATADESC_MAX_LEN (548)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ric_data_desc(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERICDataDesc*,
	bool);

uint32_t dot11f_pack_ie_ric_data_desc(
	tpAniSirGlobal,
	tDot11fIERICDataDesc *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ieric_data_desc(
	tpAniSirGlobal,
	tDot11fIERICDataDesc *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 48 (0x30) */
typedef struct sDot11fIERSN {
	uint8_t             present;
	uint16_t            version /* Must be 1! */;
	uint8_t             gp_cipher_suite[4];
	uint16_t            pwise_cipher_suite_count;
	uint8_t             pwise_cipher_suites[6][4];
	uint16_t            akm_suite_count;
	uint8_t             akm_suites[6][4];
	uint8_t             RSN_Cap[2];
	uint16_t            pmkid_count;
	uint8_t             pmkid[4][16];
	uint8_t             gp_mgmt_cipher_suite[4];
} tDot11fIERSN;

#define DOT11F_EID_RSN (48)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RSN_MIN_LEN (6)

#define DOT11F_IE_RSN_MAX_LEN (130)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_rsn(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERSN*,
	bool);

uint32_t dot11f_pack_ie_rsn(
	tpAniSirGlobal,
	tDot11fIERSN *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iersn(
	tpAniSirGlobal,
	tDot11fIERSN *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 65 (0x41) */
typedef struct sDot11fIERSNIIE {
	uint8_t             present;
	uint8_t             rsni;
} tDot11fIERSNIIE;

#define DOT11F_EID_RSNIIE (65)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RSNIIE_MIN_LEN (1)

#define DOT11F_IE_RSNIIE_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_rsniie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERSNIIE*,
	bool);

uint32_t dot11f_pack_ie_rsniie(
	tpAniSirGlobal,
	tDot11fIERSNIIE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iersnIIE(
	tpAniSirGlobal,
	tDot11fIERSNIIE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 48 (0x30) */
typedef struct sDot11fIERSNOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[253];
} tDot11fIERSNOpaque;

#define DOT11F_EID_RSNOPAQUE (48)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_RSNOPAQUE_MIN_LEN (6)

#define DOT11F_IE_RSNOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_rsn_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIERSNOpaque*,
	bool);

uint32_t dot11f_pack_ie_rsn_opaque(
	tpAniSirGlobal,
	tDot11fIERSNOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iersnOpaque(
	tpAniSirGlobal,
	tDot11fIERSNOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 36 (0x24) */
typedef struct sDot11fIESuppChannels {
	uint8_t             present;
	uint8_t             num_bands;
	uint8_t             bands[48][2];
} tDot11fIESuppChannels;

#define DOT11F_EID_SUPPCHANNELS (36)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SUPPCHANNELS_MIN_LEN (2)

#define DOT11F_IE_SUPPCHANNELS_MAX_LEN (96)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_supp_channels(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIESuppChannels*,
	bool);

uint32_t dot11f_pack_ie_supp_channels(
	tpAniSirGlobal,
	tDot11fIESuppChannels *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_SuppChannels(
	tpAniSirGlobal,
	tDot11fIESuppChannels *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 59 (0x3b) */
typedef struct sDot11fIESuppOperatingClasses {
	uint8_t             present;
	uint8_t             num_classes;
	uint8_t             classes[32];
} tDot11fIESuppOperatingClasses;

#define DOT11F_EID_SUPPOPERATINGCLASSES (59)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SUPPOPERATINGCLASSES_MIN_LEN (1)

#define DOT11F_IE_SUPPOPERATINGCLASSES_MAX_LEN (32)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_supp_operating_classes(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIESuppOperatingClasses*,
	bool);

uint32_t dot11f_pack_ie_supp_operating_classes(
	tpAniSirGlobal,
	tDot11fIESuppOperatingClasses *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_SuppOperatingClasses(
	tpAniSirGlobal,
	tDot11fIESuppOperatingClasses *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 1 (0x01) */
typedef struct sDot11fIESuppRates {
	uint8_t             present;
	uint8_t             num_rates;
	uint8_t             rates[12];
} tDot11fIESuppRates;

#define DOT11F_EID_SUPPRATES (1)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SUPPRATES_MIN_LEN (0)

#define DOT11F_IE_SUPPRATES_MAX_LEN (12)

#define DOT11F_IS_BG_RATE(_x)  (((_x) == 02) || \
				((_x) == 04) || \
				((_x) == 11) || \
				((_x) == 22) || \
				((_x) == 12) || \
				((_x) == 18) || \
				((_x) == 24) || \
				((_x) == 36) || \
				((_x) == 48) || \
				((_x) == 72) || \
				((_x) == 96) || \
				((_x) == 108))

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_supp_rates(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIESuppRates*,
	bool);

uint32_t dot11f_pack_ie_supp_rates(
	tpAniSirGlobal,
	tDot11fIESuppRates *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_SuppRates(
	tpAniSirGlobal,
	tDot11fIESuppRates *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 5 (0x05) */
typedef struct sDot11fIETIM {
	uint8_t             present;
	uint8_t             dtim_count;
	uint8_t             dtim_period;
	uint8_t             bmpctl;
	uint8_t             num_vbmp;
	uint8_t             vbmp[251];
} tDot11fIETIM;

#define DOT11F_EID_TIM (5)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TIM_MIN_LEN (4)

#define DOT11F_IE_TIM_MAX_LEN (254)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tim(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETIM*,
	bool);

uint32_t dot11f_pack_ie_tim(
	tpAniSirGlobal,
	tDot11fIETIM *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TIM(
	tpAniSirGlobal,
	tDot11fIETIM *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 35 (0x23) */
typedef struct sDot11fIETPCReport {
	uint8_t             present;
	uint8_t             tx_power;
	uint8_t             link_margin;
} tDot11fIETPCReport;

#define DOT11F_EID_TPCREPORT (35)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TPCREPORT_MIN_LEN (2)

#define DOT11F_IE_TPCREPORT_MAX_LEN (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tpc_report(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETPCReport*,
	bool);

uint32_t dot11f_pack_ie_tpc_report(
	tpAniSirGlobal,
	tDot11fIETPCReport *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TPCReport(
	tpAniSirGlobal,
	tDot11fIETPCReport *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 34 (0x22) */
typedef struct sDot11fIETPCRequest {
	uint8_t             present;
} tDot11fIETPCRequest;

#define DOT11F_EID_TPCREQUEST (34)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TPCREQUEST_MIN_LEN (0)

#define DOT11F_IE_TPCREQUEST_MAX_LEN (0)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_tpc_request(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETPCRequest*,
	bool);

uint32_t dot11f_pack_ie_tpc_request(
	tpAniSirGlobal,
	tDot11fIETPCRequest *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TPCRequest(
	tpAniSirGlobal,
	tDot11fIETPCRequest *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 69 (0x45) */
typedef struct sDot11fIETimeAdvertisement {
	uint8_t             present;
	uint8_t             timing_capabilities;
	uint8_t             time_value[10];
	uint8_t             time_error[5];
} tDot11fIETimeAdvertisement;

#define DOT11F_EID_TIMEADVERTISEMENT (69)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TIMEADVERTISEMENT_MIN_LEN (16)

#define DOT11F_IE_TIMEADVERTISEMENT_MAX_LEN (16)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_time_advertisement(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETimeAdvertisement*,
	bool);

uint32_t dot11f_pack_ie_time_advertisement(
	tpAniSirGlobal,
	tDot11fIETimeAdvertisement *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_time_advertisement(
	tpAniSirGlobal,
	tDot11fIETimeAdvertisement *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 56 (0x38) */
typedef struct sDot11fIETimeoutInterval {
	uint8_t             present;
	uint8_t             timeoutType;
	uint32_t            timeoutValue;
} tDot11fIETimeoutInterval;

#define DOT11F_EID_TIMEOUTINTERVAL (56)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_TIMEOUTINTERVAL_MIN_LEN (5)

#define DOT11F_IE_TIMEOUTINTERVAL_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_timeout_interval(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIETimeoutInterval*,
	bool);

uint32_t dot11f_pack_ie_timeout_interval(
	tpAniSirGlobal,
	tDot11fIETimeoutInterval *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_TimeoutInterval(
	tpAniSirGlobal,
	tDot11fIETimeoutInterval *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 193 (0xc1) */
typedef struct sDot11fIEVHTExtBssLoad {
	uint8_t             present;
	uint8_t             muMIMOCapStaCount;
	uint8_t             ssUnderUtil;
	uint8_t             FortyMHzUtil;
	uint8_t             EightyMHzUtil;
	uint8_t             OneSixtyMHzUtil;
} tDot11fIEVHTExtBssLoad;

#define DOT11F_EID_VHTEXTBSSLOAD (193)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VHTEXTBSSLOAD_MIN_LEN (5)

#define DOT11F_IE_VHTEXTBSSLOAD_MAX_LEN (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vht_ext_bss_load(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEVHTExtBssLoad*,
	bool);

uint32_t dot11f_pack_ie_vht_ext_bss_load(
	tpAniSirGlobal,
	tDot11fIEVHTExtBssLoad *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_VHTExtBssLoad(
	tpAniSirGlobal,
	tDot11fIEVHTExtBssLoad *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x10, 0x18} */
typedef struct sDot11fIEVendor1IE {
	uint8_t             present;
} tDot11fIEVendor1IE;

#define DOT11F_EID_VENDOR1IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VENDOR1IE_MIN_LEN (3)

#define DOT11F_IE_VENDOR1IE_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vendor1_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEVendor1IE*,
	bool);

uint32_t dot11f_pack_ie_vendor1_ie(
	tpAniSirGlobal,
	tDot11fIEVendor1IE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_Vendor1IE(
	tpAniSirGlobal,
	tDot11fIEVendor1IE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x16, 0x32} */
typedef struct sDot11fIEVendor3IE {
	uint8_t             present;
} tDot11fIEVendor3IE;

#define DOT11F_EID_VENDOR3IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VENDOR3IE_MIN_LEN (3)

#define DOT11F_IE_VENDOR3IE_MAX_LEN (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vendor3_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEVendor3IE*,
	bool);

uint32_t dot11f_pack_ie_vendor3_ie(
	tpAniSirGlobal,
	tDot11fIEVendor3IE *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_Vendor3IE(
	tpAniSirGlobal,
	tDot11fIEVendor3IE *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 68 (0x44) */
typedef struct sDot11fIEWAPI {
	uint8_t             present;
	uint16_t            version /* Must be 1! */;
	uint16_t            akm_suite_count;
	uint8_t             akm_suites[4][4];
	uint16_t            unicast_cipher_suite_count;
	uint8_t             unicast_cipher_suites[4][4];
	uint8_t             multicast_cipher_suite[4];
	uint16_t              preauth:1;
	uint16_t             reserved:15;
	uint16_t            bkid_count;
	uint8_t             bkid[4][16];
} tDot11fIEWAPI;

#define DOT11F_EID_WAPI (68)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WAPI_MIN_LEN (12)

#define DOT11F_IE_WAPI_MAX_LEN (110)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wapi(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWAPI*,
	bool);

uint32_t dot11f_pack_ie_wapi(
	tpAniSirGlobal,
	tDot11fIEWAPI *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewapi(
	tpAniSirGlobal,
	tDot11fIEWAPI *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 68 (0x44) */
typedef struct sDot11fIEWAPIOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[253];
} tDot11fIEWAPIOpaque;

#define DOT11F_EID_WAPIOPAQUE (68)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WAPIOPAQUE_MIN_LEN (6)

#define DOT11F_IE_WAPIOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wapi_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWAPIOpaque*,
	bool);

uint32_t dot11f_pack_ie_wapi_opaque(
	tpAniSirGlobal,
	tDot11fIEWAPIOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewapiOpaque(
	tpAniSirGlobal,
	tDot11fIEWAPIOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x08, 0x00} */
typedef struct sDot11fIEWFATPC {
	uint8_t             present;
	uint8_t             txPower;
	uint8_t             linkMargin;
} tDot11fIEWFATPC;

#define DOT11F_EID_WFATPC (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WFATPC_MIN_LEN (7)

#define DOT11F_IE_WFATPC_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wfatpc(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWFATPC*,
	bool);

uint32_t dot11f_pack_ie_wfatpc(
	tpAniSirGlobal,
	tDot11fIEWFATPC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WFATPC(
	tpAniSirGlobal,
	tDot11fIEWFATPC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x0a} */
typedef struct sDot11fIEWFDIEOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[249];
} tDot11fIEWFDIEOpaque;

#define DOT11F_EID_WFDIEOPAQUE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WFDIEOPAQUE_MIN_LEN (6)

#define DOT11F_IE_WFDIEOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wfdie_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWFDIEOpaque*,
	bool);

uint32_t dot11f_pack_ie_wfdie_opaque(
	tpAniSirGlobal,
	tDot11fIEWFDIEOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WFDIEOpaque(
	tpAniSirGlobal,
	tDot11fIEWFDIEOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x05} */
typedef struct sDot11fIEWMMCaps {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint8_t             reserved:4;
	uint8_t                 qack:1;
	uint8_t        queue_request:1;
	uint8_t         txop_request:1;
	uint8_t             more_ack:1;
} tDot11fIEWMMCaps;

#define DOT11F_EID_WMMCAPS (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMCAPS_MIN_LEN (7)

#define DOT11F_IE_WMMCAPS_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmm_caps(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMCaps*,
	bool);

uint32_t dot11f_pack_ie_wmm_caps(
	tpAniSirGlobal,
	tDot11fIEWMMCaps *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMCaps(
	tpAniSirGlobal,
	tDot11fIEWMMCaps *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x00} */
typedef struct sDot11fIEWMMInfoAp {
	uint8_t             present;
	uint8_t             version;
	uint8_t      param_set_count:4;
	uint8_t             reserved:3;
	uint8_t                uapsd:1;
} tDot11fIEWMMInfoAp;

#define DOT11F_EID_WMMINFOAP (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMINFOAP_MIN_LEN (7)

#define DOT11F_IE_WMMINFOAP_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmm_info_ap(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMInfoAp*,
	bool);

uint32_t dot11f_pack_ie_wmm_info_ap(
	tpAniSirGlobal,
	tDot11fIEWMMInfoAp *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMInfoAp(
	tpAniSirGlobal,
	tDot11fIEWMMInfoAp *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x00} */
typedef struct sDot11fIEWMMInfoStation {
	uint8_t             present;
	uint8_t             version;
	uint8_t           acvo_uapsd:1;
	uint8_t           acvi_uapsd:1;
	uint8_t           acbk_uapsd:1;
	uint8_t           acbe_uapsd:1;
	uint8_t            reserved1:1;
	uint8_t        max_sp_length:2;
	uint8_t            reserved2:1;
} tDot11fIEWMMInfoStation;

#define DOT11F_EID_WMMINFOSTATION (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMINFOSTATION_MIN_LEN (7)

#define DOT11F_IE_WMMINFOSTATION_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmm_info_station(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMInfoStation*,
	bool);

uint32_t dot11f_pack_ie_wmm_info_station(
	tpAniSirGlobal,
	tDot11fIEWMMInfoStation *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMInfoStation(
	tpAniSirGlobal,
	tDot11fIEWMMInfoStation *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x02, 0x01} */
typedef struct sDot11fIEWMMParams {
	uint8_t             present;
	uint8_t             version /* Must be 1! */;
	uint8_t             qosInfo;
	uint8_t             reserved2;
	uint8_t           acbe_aifsn:4;
	uint8_t             acbe_acm:1;
	uint8_t             acbe_aci:2;
	uint8_t              unused1:1;
	uint8_t          acbe_acwmin:4;
	uint8_t          acbe_acwmax:4;
	uint16_t            acbe_txoplimit;
	uint8_t           acbk_aifsn:4;
	uint8_t             acbk_acm:1;
	uint8_t             acbk_aci:2;
	uint8_t              unused2:1;
	uint8_t          acbk_acwmin:4;
	uint8_t          acbk_acwmax:4;
	uint16_t            acbk_txoplimit;
	uint8_t           acvi_aifsn:4;
	uint8_t             acvi_acm:1;
	uint8_t             acvi_aci:2;
	uint8_t              unused3:1;
	uint8_t          acvi_acwmin:4;
	uint8_t          acvi_acwmax:4;
	uint16_t            acvi_txoplimit;
	uint8_t           acvo_aifsn:4;
	uint8_t             acvo_acm:1;
	uint8_t             acvo_aci:2;
	uint8_t              unused4:1;
	uint8_t          acvo_acwmin:4;
	uint8_t          acvo_acwmax:4;
	uint16_t            acvo_txoplimit;
} tDot11fIEWMMParams;

#define DOT11F_EID_WMMPARAMS (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WMMPARAMS_MIN_LEN (24)

#define DOT11F_IE_WMMPARAMS_MAX_LEN (24)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wmm_params(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWMMParams*,
	bool);

uint32_t dot11f_pack_ie_wmm_params(
	tpAniSirGlobal,
	tDot11fIEWMMParams *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WMMParams(
	tpAniSirGlobal,
	tDot11fIEWMMParams *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x01} */
typedef struct sDot11fIEWPA {
	uint8_t             present;
	uint16_t            version /* Must be 1! */;
	/* field added to fix the bug in dot11fPackIEWPA */
	uint8_t             multicast_cipher_present;
	uint8_t             multicast_cipher[4];
	uint16_t            unicast_cipher_count;
	uint8_t             unicast_ciphers[4][4];
	uint16_t            auth_suite_count;
	uint8_t             auth_suites[4][4];
	uint16_t            caps;
} tDot11fIEWPA;

#define DOT11F_EID_WPA (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WPA_MIN_LEN (6)

#define DOT11F_IE_WPA_MAX_LEN (48)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wpa(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWPA*,
	bool);

uint32_t dot11f_pack_ie_wpa(
	tpAniSirGlobal,
	tDot11fIEWPA *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewpa(
	tpAniSirGlobal,
	tDot11fIEWPA *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x01} */
typedef struct sDot11fIEWPAOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[249];
} tDot11fIEWPAOpaque;

#define DOT11F_EID_WPAOPAQUE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WPAOPAQUE_MIN_LEN (6)

#define DOT11F_IE_WPAOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wpa_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWPAOpaque*,
	bool);

uint32_t dot11f_pack_ie_wpa_opaque(
	tpAniSirGlobal,
	tDot11fIEWPAOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewpaOpaque(
	tpAniSirGlobal,
	tDot11fIEWPAOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWSC {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVWPSState  WPSState;
	tDot11fTLVAPSetupLocked APSetupLocked;
	tDot11fTLVSelectedRegistrarConfigMethods SelectedRegistrarConfigMethods;
	tDot11fTLVUUID_E    UUID_E;
	tDot11fTLVUUID_R    UUID_R;
	tDot11fTLVRFBands   RFBands;
	tDot11fTLVSelectedRegistrar SelectedRegistrar;
	tDot11fTLVConfigMethods ConfigMethods;
	tDot11fTLVAssociationState AssociationState;
	tDot11fTLVConfigurationError ConfigurationError;
	tDot11fTLVManufacturer Manufacturer;
	tDot11fTLVModelName ModelName;
	tDot11fTLVModelNumber ModelNumber;
	tDot11fTLVSerialNumber SerialNumber;
	tDot11fTLVDeviceName DeviceName;
	tDot11fTLVDevicePasswordID DevicePasswordID;
	tDot11fTLVPrimaryDeviceType PrimaryDeviceType;
	tDot11fTLVRequestType RequestType;
	tDot11fTLVResponseType ResponseType;
	tDot11fTLVVendorExtension VendorExtension;
	tDot11fTLVRequestDeviceType RequestDeviceType;
} tDot11fIEWSC;

#define DOT11F_EID_WSC (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSC_MIN_LEN (4)

#define DOT11F_IE_WSC_MAX_LEN (366)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWSC*,
	bool);

uint32_t dot11f_pack_ie_wsc(
	tpAniSirGlobal,
	tDot11fIEWSC *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_iewsc(
	tpAniSirGlobal,
	tDot11fIEWSC *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscAssocReq {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVRequestType RequestType;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscAssocReq;

#define DOT11F_EID_WSCASSOCREQ (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCASSOCREQ_MIN_LEN (4)

#define DOT11F_IE_WSCASSOCREQ_MAX_LEN (35)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_assoc_req(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscAssocReq*,
	bool);

uint32_t dot11f_pack_ie_wsc_assoc_req(
	tpAniSirGlobal,
	tDot11fIEWscAssocReq *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_assoc_req(
	tpAniSirGlobal,
	tDot11fIEWscAssocReq *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscAssocRes {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVResponseType ResponseType;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscAssocRes;

#define DOT11F_EID_WSCASSOCRES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCASSOCRES_MIN_LEN (4)

#define DOT11F_IE_WSCASSOCRES_MAX_LEN (35)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_assoc_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscAssocRes*,
	bool);

uint32_t dot11f_pack_ie_wsc_assoc_res(
	tpAniSirGlobal,
	tDot11fIEWscAssocRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_assoc_res(
	tpAniSirGlobal,
	tDot11fIEWscAssocRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscBeacon {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVWPSState  WPSState;
	tDot11fTLVAPSetupLocked APSetupLocked;
	tDot11fTLVSelectedRegistrar SelectedRegistrar;
	tDot11fTLVDevicePasswordID DevicePasswordID;
	tDot11fTLVSelectedRegistrarConfigMethods SelectedRegistrarConfigMethods;
	tDot11fTLVUUID_E    UUID_E;
	tDot11fTLVRFBands   RFBands;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscBeacon;

#define DOT11F_EID_WSCBEACON (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCBEACON_MIN_LEN (4)

#define DOT11F_IE_WSCBEACON_MAX_LEN (82)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_beacon(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscBeacon*,
	bool);

uint32_t dot11f_pack_ie_wsc_beacon(
	tpAniSirGlobal,
	tDot11fIEWscBeacon *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_beacon(
	tpAniSirGlobal,
	tDot11fIEWscBeacon *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscBeaconProbeRes {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVWPSState  WPSState;
	tDot11fTLVAPSetupLocked APSetupLocked;
	tDot11fTLVSelectedRegistrar SelectedRegistrar;
	tDot11fTLVDevicePasswordID DevicePasswordID;
	tDot11fTLVSelectedRegistrarConfigMethods SelectedRegistrarConfigMethods;
	tDot11fTLVResponseType ResponseType;
	tDot11fTLVUUID_E    UUID_E;
	tDot11fTLVManufacturer Manufacturer;
	tDot11fTLVModelName ModelName;
	tDot11fTLVModelNumber ModelNumber;
	tDot11fTLVSerialNumber SerialNumber;
	tDot11fTLVPrimaryDeviceType PrimaryDeviceType;
	tDot11fTLVDeviceName DeviceName;
	tDot11fTLVConfigMethods ConfigMethods;
	tDot11fTLVRFBands   RFBands;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscBeaconProbeRes;

#define DOT11F_EID_WSCBEACONPROBERES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCBEACONPROBERES_MIN_LEN (4)

#define DOT11F_IE_WSCBEACONPROBERES_MAX_LEN (317)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_beacon_probe_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscBeaconProbeRes*,
	bool);

uint32_t dot11f_pack_ie_wsc_beacon_probe_res(
	tpAniSirGlobal,
	tDot11fIEWscBeaconProbeRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_beacon_probe_res(
	tpAniSirGlobal,
	tDot11fIEWscBeaconProbeRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} */
typedef struct sDot11fIEWscIEOpaque {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[249];
} tDot11fIEWscIEOpaque;

#define DOT11F_EID_WSCIEOPAQUE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCIEOPAQUE_MIN_LEN (6)

#define DOT11F_IE_WSCIEOPAQUE_MAX_LEN (253)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_ie_opaque(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscIEOpaque*,
	bool);

uint32_t dot11f_pack_ie_wsc_ie_opaque(
	tpAniSirGlobal,
	tDot11fIEWscIEOpaque *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_WscIEOpaque(
	tpAniSirGlobal,
	tDot11fIEWscIEOpaque *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscProbeReq {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVRequestType RequestType;
	tDot11fTLVConfigMethods ConfigMethods;
	tDot11fTLVUUID_E    UUID_E;
	tDot11fTLVPrimaryDeviceType PrimaryDeviceType;
	tDot11fTLVRFBands   RFBands;
	tDot11fTLVAssociationState AssociationState;
	tDot11fTLVConfigurationError ConfigurationError;
	tDot11fTLVDevicePasswordID DevicePasswordID;
	tDot11fTLVManufacturer Manufacturer;
	tDot11fTLVModelName ModelName;
	tDot11fTLVModelNumber ModelNumber;
	tDot11fTLVDeviceName DeviceName;
	tDot11fTLVVendorExtension VendorExtension;
	tDot11fTLVRequestDeviceType RequestDeviceType;
} tDot11fIEWscProbeReq;

#define DOT11F_EID_WSCPROBEREQ (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCPROBEREQ_MIN_LEN (4)

#define DOT11F_IE_WSCPROBEREQ_MAX_LEN (284)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_probe_req(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscProbeReq*,
	bool);

uint32_t dot11f_pack_ie_wsc_probe_req(
	tpAniSirGlobal,
	tDot11fIEWscProbeReq *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_probe_req(
	tpAniSirGlobal,
	tDot11fIEWscProbeReq *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscProbeRes {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVWPSState  WPSState;
	tDot11fTLVAPSetupLocked APSetupLocked;
	tDot11fTLVSelectedRegistrar SelectedRegistrar;
	tDot11fTLVDevicePasswordID DevicePasswordID;
	tDot11fTLVSelectedRegistrarConfigMethods SelectedRegistrarConfigMethods;
	tDot11fTLVResponseType ResponseType;
	tDot11fTLVUUID_E    UUID_E;
	tDot11fTLVManufacturer Manufacturer;
	tDot11fTLVModelName ModelName;
	tDot11fTLVModelNumber ModelNumber;
	tDot11fTLVSerialNumber SerialNumber;
	tDot11fTLVPrimaryDeviceType PrimaryDeviceType;
	tDot11fTLVDeviceName DeviceName;
	tDot11fTLVConfigMethods ConfigMethods;
	tDot11fTLVRFBands   RFBands;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscProbeRes;

#define DOT11F_EID_WSCPROBERES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCPROBERES_MIN_LEN (4)

#define DOT11F_IE_WSCPROBERES_MAX_LEN (317)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_probe_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscProbeRes*,
	bool);

uint32_t dot11f_pack_ie_wsc_probe_res(
	tpAniSirGlobal,
	tDot11fIEWscProbeRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_probe_res(
	tpAniSirGlobal,
	tDot11fIEWscProbeRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x50, 0xf2, 0x04} (Multi-IE) */
typedef struct sDot11fIEWscReassocRes {
	uint8_t             present;
	tDot11fTLVVersion   Version;
	tDot11fTLVResponseType ResponseType;
	tDot11fTLVVendorExtension VendorExtension;
} tDot11fIEWscReassocRes;

#define DOT11F_EID_WSCREASSOCRES (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_WSCREASSOCRES_MIN_LEN (4)

#define DOT11F_IE_WSCREASSOCRES_MAX_LEN (35)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_wsc_reassoc_res(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEWscReassocRes*,
	bool);

uint32_t dot11f_pack_ie_wsc_reassoc_res(
	tpAniSirGlobal,
	tDot11fIEWscReassocRes *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_wsc_reassoc_res(
	tpAniSirGlobal,
	tDot11fIEWscReassocRes *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 60 (0x3c) */
typedef struct sDot11fIEext_chan_switch_ann {
	uint8_t             present;
	uint8_t             switch_mode;
	uint8_t             new_reg_class;
	uint8_t             new_channel;
	uint8_t             switch_count;
} tDot11fIEext_chan_switch_ann;

#define DOT11F_EID_EXT_CHAN_SWITCH_ANN (60)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_EXT_CHAN_SWITCH_ANN_MIN_LEN (4)

#define DOT11F_IE_EXT_CHAN_SWITCH_ANN_MAX_LEN (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ext_chan_switch_ann(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEext_chan_switch_ann*,
	bool);

uint32_t dot11f_pack_ie_ext_chan_switch_ann(
	tpAniSirGlobal,
	tDot11fIEext_chan_switch_ann *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ext_chan_switch_ann(
	tpAniSirGlobal,
	tDot11fIEext_chan_switch_ann *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 1 (0x01) */
typedef struct sDot11fIEfils_assoc_delay_info {
	uint8_t             present;
	uint8_t             assoc_delay_info;
} tDot11fIEfils_assoc_delay_info;

#define DOT11F_EID_FILS_ASSOC_DELAY_INFO (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_ASSOC_DELAY_INFO_MIN_LEN (1)

#define DOT11F_IE_FILS_ASSOC_DELAY_INFO_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_assoc_delay_info(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_assoc_delay_info*,
	bool);

uint32_t dot11f_pack_ie_fils_assoc_delay_info(
	tpAniSirGlobal,
	tDot11fIEfils_assoc_delay_info *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_assoc_delay_info(
	tpAniSirGlobal,
	tDot11fIEfils_assoc_delay_info *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 5 (0x05) */
typedef struct sDot11fIEfils_hlp_container {
	uint8_t             present;
	uint8_t             dest_mac[6];
	uint8_t             src_mac[6];
	uint8_t             num_hlp_packet;
	uint8_t             hlp_packet[255];
} tDot11fIEfils_hlp_container;

#define DOT11F_EID_FILS_HLP_CONTAINER (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_HLP_CONTAINER_MIN_LEN (12)

#define DOT11F_IE_FILS_HLP_CONTAINER_MAX_LEN (267)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_hlp_container(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_hlp_container*,
	bool);

uint32_t dot11f_pack_ie_fils_hlp_container(
	tpAniSirGlobal,
	tDot11fIEfils_hlp_container *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_hlp_container(
	tpAniSirGlobal,
	tDot11fIEfils_hlp_container *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 240 (0xf0) */
typedef struct sDot11fIEfils_indication {
	uint8_t             present;
	uint16_t public_key_identifiers_cnt:3;
	uint16_t realm_identifiers_cnt:3;
	uint16_t is_ip_config_supported:1;
	uint16_t  is_cache_id_present:1;
	uint16_t    is_hessid_present:1;
	uint16_t is_fils_sk_auth_supported:1;
	uint16_t is_fils_sk_auth_pfs_supported:1;
	uint16_t is_pk_auth_supported:1;
	uint16_t             reserved:4;
	uint8_t             num_variable_data;
	uint8_t             variable_data[255];
} tDot11fIEfils_indication;

#define DOT11F_EID_FILS_INDICATION (240)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_INDICATION_MIN_LEN (5)

#define DOT11F_IE_FILS_INDICATION_MAX_LEN (257)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_indication(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_indication*,
	bool);

uint32_t dot11f_pack_ie_fils_indication(
	tpAniSirGlobal,
	tDot11fIEfils_indication *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_indication(
	tpAniSirGlobal,
	tDot11fIEfils_indication *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 7 (0x07) */
typedef struct sDot11fIEfils_kde {
	uint8_t             present;
	uint8_t             key_rsc[8];
	uint8_t             num_kde_list;
	uint8_t             kde_list[255];
} tDot11fIEfils_kde;

#define DOT11F_EID_FILS_KDE (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_KDE_MIN_LEN (8)

#define DOT11F_IE_FILS_KDE_MAX_LEN (263)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_kde(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_kde*,
	bool);

uint32_t dot11f_pack_ie_fils_kde(
	tpAniSirGlobal,
	tDot11fIEfils_kde *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_kde(
	tpAniSirGlobal,
	tDot11fIEfils_kde *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 3 (0x03) */
typedef struct sDot11fIEfils_key_confirmation {
	uint8_t             present;
	uint8_t             num_key_auth;
	uint8_t             key_auth[255];
} tDot11fIEfils_key_confirmation;

#define DOT11F_EID_FILS_KEY_CONFIRMATION (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_KEY_CONFIRMATION_MIN_LEN (0)

#define DOT11F_IE_FILS_KEY_CONFIRMATION_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_key_confirmation(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_key_confirmation*,
	bool);

uint32_t dot11f_pack_ie_fils_key_confirmation(
	tpAniSirGlobal,
	tDot11fIEfils_key_confirmation *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_key_confirmation(
	tpAniSirGlobal,
	tDot11fIEfils_key_confirmation *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 13 (0x0d) */
typedef struct sDot11fIEfils_nonce {
	uint8_t             present;
	uint8_t             nonce[16];
} tDot11fIEfils_nonce;

#define DOT11F_EID_FILS_NONCE (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_NONCE_MIN_LEN (16)

#define DOT11F_IE_FILS_NONCE_MAX_LEN (16)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_nonce(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_nonce*,
	bool);

uint32_t dot11f_pack_ie_fils_nonce(
	tpAniSirGlobal,
	tDot11fIEfils_nonce *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_nonce(
	tpAniSirGlobal,
	tDot11fIEfils_nonce *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 12 (0x0c) */
typedef struct sDot11fIEfils_public_key {
	uint8_t             present;
	uint8_t             key_type;
	uint8_t             num_public_key;
	uint8_t             public_key[255];
} tDot11fIEfils_public_key;

#define DOT11F_EID_FILS_PUBLIC_KEY (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_PUBLIC_KEY_MIN_LEN (1)

#define DOT11F_IE_FILS_PUBLIC_KEY_MAX_LEN (256)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_public_key(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_public_key*,
	bool);

uint32_t dot11f_pack_ie_fils_public_key(
	tpAniSirGlobal,
	tDot11fIEfils_public_key *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_public_key(
	tpAniSirGlobal,
	tDot11fIEfils_public_key *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 4 (0x04) */
typedef struct sDot11fIEfils_session {
	uint8_t             present;
	uint8_t             session[8];
} tDot11fIEfils_session;

#define DOT11F_EID_FILS_SESSION (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_SESSION_MIN_LEN (8)

#define DOT11F_IE_FILS_SESSION_MAX_LEN (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_session(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_session*,
	bool);

uint32_t dot11f_pack_ie_fils_session(
	tpAniSirGlobal,
	tDot11fIEfils_session *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_session(
	tpAniSirGlobal,
	tDot11fIEfils_session *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 255 (0xff) Extended EID 8 (0x08) */
typedef struct sDot11fIEfils_wrapped_data {
	uint8_t             present;
	uint8_t             num_wrapped_data;
	uint8_t             wrapped_data[255];
} tDot11fIEfils_wrapped_data;

#define DOT11F_EID_FILS_WRAPPED_DATA (255)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FILS_WRAPPED_DATA_MIN_LEN (0)

#define DOT11F_IE_FILS_WRAPPED_DATA_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fils_wrapped_data(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfils_wrapped_data*,
	bool);

uint32_t dot11f_pack_ie_fils_wrapped_data(
	tpAniSirGlobal,
	tDot11fIEfils_wrapped_data *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fils_wrapped_data(
	tpAniSirGlobal,
	tDot11fIEfils_wrapped_data *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 242 (0xf2) */
typedef struct sDot11fIEfragment_ie {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[255];
} tDot11fIEfragment_ie;

#define DOT11F_EID_FRAGMENT_IE (242)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_FRAGMENT_IE_MIN_LEN (0)

#define DOT11F_IE_FRAGMENT_IE_MAX_LEN (255)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_fragment_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEfragment_ie*,
	bool);

uint32_t dot11f_pack_ie_fragment_ie(
	tpAniSirGlobal,
	tDot11fIEfragment_ie *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_fragment_ie(
	tpAniSirGlobal,
	tDot11fIEfragment_ie *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x10} */
typedef struct sDot11fIEhs20vendor_ie {
	uint8_t             present;
	uint8_t             dgaf_dis:1;
	uint8_t        hs_id_present:2;
	uint8_t             reserved:1;
	uint8_t          release_num:4;
	union {
		struct {
			uint16_t pps_mo_id;
		} pps_mo; /* hs_id_present = 1 */
		struct {
			uint16_t anqp_domain_id;
		} anqp_domain; /* hs_id_present = 2 */
	} hs_id;
} tDot11fIEhs20vendor_ie;

#define DOT11F_EID_HS20VENDOR_IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_HS20VENDOR_IE_MIN_LEN (5)

#define DOT11F_IE_HS20VENDOR_IE_MAX_LEN (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_hs20vendor_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEhs20vendor_ie*,
	bool);

uint32_t dot11f_pack_ie_hs20vendor_ie(
	tpAniSirGlobal,
	tDot11fIEhs20vendor_ie *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_hs20vendor_ie(
	tpAniSirGlobal,
	tDot11fIEhs20vendor_ie *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 72 (0x48) */
typedef struct sDot11fIEht2040_bss_coexistence {
	uint8_t             present;
	uint8_t         info_request:1;
	uint8_t forty_mhz_intolerant:1;
	uint8_t twenty_mhz_bsswidth_req:1;
	uint8_t obss_scan_exemption_req:1;
	uint8_t obss_scan_exemption_grant:1;
	uint8_t               unused:3;
} tDot11fIEht2040_bss_coexistence;

#define DOT11F_EID_HT2040_BSS_COEXISTENCE (72)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_HT2040_BSS_COEXISTENCE_MIN_LEN (1)

#define DOT11F_IE_HT2040_BSS_COEXISTENCE_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ht2040_bss_coexistence(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEht2040_bss_coexistence*,
	bool);

uint32_t dot11f_pack_ie_ht2040_bss_coexistence(
	tpAniSirGlobal,
	tDot11fIEht2040_bss_coexistence *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ht2040_bss_coexistence(
	tpAniSirGlobal,
	tDot11fIEht2040_bss_coexistence *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 73 (0x49) */
typedef struct sDot11fIEht2040_bss_intolerant_report {
	uint8_t             present;
	uint8_t             operating_class;
	uint8_t             num_channel_list;
	uint8_t             channel_list[50];
} tDot11fIEht2040_bss_intolerant_report;

#define DOT11F_EID_HT2040_BSS_INTOLERANT_REPORT (73)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_HT2040_BSS_INTOLERANT_REPORT_MIN_LEN (1)

#define DOT11F_IE_HT2040_BSS_INTOLERANT_REPORT_MAX_LEN (51)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_ht2040_bss_intolerant_report(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEht2040_bss_intolerant_report*,
	bool);

uint32_t dot11f_pack_ie_ht2040_bss_intolerant_report(
	tpAniSirGlobal,
	tDot11fIEht2040_bss_intolerant_report *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_ht2040_bss_intolerant_report(
	tpAniSirGlobal,
	tDot11fIEht2040_bss_intolerant_report *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x50, 0x6f, 0x9a, 0x12} */
typedef struct sDot11fIEosen_ie {
	uint8_t             present;
	uint8_t             num_data;
	uint8_t             data[255];
} tDot11fIEosen_ie;

#define DOT11F_EID_OSEN_IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_OSEN_IE_MIN_LEN (4)

#define DOT11F_IE_OSEN_IE_MAX_LEN (259)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_osen_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEosen_ie*,
	bool);

uint32_t dot11f_pack_ie_osen_ie(
	tpAniSirGlobal,
	tDot11fIEosen_ie *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_osen_ie(
	tpAniSirGlobal,
	tDot11fIEosen_ie *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 62 (0x3e) */
typedef struct sDot11fIEsec_chan_offset_ele {
	uint8_t             present;
	uint8_t             secondaryChannelOffset;
} tDot11fIEsec_chan_offset_ele;

#define DOT11F_EID_SEC_CHAN_OFFSET_ELE (62)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_SEC_CHAN_OFFSET_ELE_MIN_LEN (1)

#define DOT11F_IE_SEC_CHAN_OFFSET_ELE_MAX_LEN (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_sec_chan_offset_ele(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEsec_chan_offset_ele*,
	bool);

uint32_t dot11f_pack_ie_sec_chan_offset_ele(
	tpAniSirGlobal,
	tDot11fIEsec_chan_offset_ele *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_sec_chan_offset_ele(
	tpAniSirGlobal,
	tDot11fIEsec_chan_offset_ele *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */

/* EID 221 (0xdd) {OUI 0x00, 0x90, 0x4c, 0x04} */
typedef struct sDot11fIEvendor_vht_ie {
	uint8_t                      present;
	uint8_t                      sub_type;
	tDot11fIEVHTCaps             VHTCaps;
	tDot11fIEVHTOperation        VHTOperation;
} tDot11fIEvendor_vht_ie;

#define DOT11F_EID_VENDOR_VHT_IE (221)

/* N.B. These #defines do *not* include the EID & length */
#define DOT11F_IE_VENDOR_VHT_IE_MIN_LEN (5)

#define DOT11F_IE_VENDOR_VHT_IE_MAX_LEN (26)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */
uint32_t dot11f_unpack_ie_vendor_vht_ie(
	tpAniSirGlobal,
	uint8_t *,
	uint8_t,
	tDot11fIEvendor_vht_ie*,
	bool);

uint32_t dot11f_pack_ie_vendor_vht_ie(
	tpAniSirGlobal,
	tDot11fIEvendor_vht_ie *,
	uint8_t *,
	uint32_t,
	uint32_t*);

uint32_t dot11f_get_packed_ie_vendor_vht_ie(
	tpAniSirGlobal,
	tDot11fIEvendor_vht_ie *,
	uint32_t*);

#ifdef __cplusplus
}; /* End extern "C". */
#endif /* C++ */
/************************************************************************
 * Frames
 **********************************************************************/

typedef struct sDot11fAddTSRequest{
	tDot11fFfCategory                  Category;
	tDot11fFfAction                    Action;
	tDot11fFfDialogToken               DialogToken;
	tDot11fIETSPEC                     TSPEC;
	uint16_t                           num_TCLAS;
	tDot11fIETCLAS                     TCLAS[2];
	tDot11fIETCLASSPROC                TCLASSPROC;
	tDot11fIEWMMTSPEC                  WMMTSPEC;
	uint16_t                           num_WMMTCLAS;
	tDot11fIEWMMTCLAS                  WMMTCLAS[2];
	tDot11fIEWMMTCLASPROC              WMMTCLASPROC;
	tDot11fIEESETrafStrmRateSet        ESETrafStrmRateSet;
} tDot11fAddTSRequest;

#define DOT11F_ADDTSREQUEST (1)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_add_ts_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fAddTSRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_add_ts_request(tpAniSirGlobal pCtx,
	tDot11fAddTSRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_add_ts_request_size(tpAniSirGlobal pCtx,
	tDot11fAddTSRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fAddTSResponse{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	tDot11fFfStatus                Status;
	tDot11fIETSDelay               TSDelay;
	tDot11fIETSPEC                 TSPEC;
	uint16_t                       num_TCLAS;
	tDot11fIETCLAS                 TCLAS[2];
	tDot11fIETCLASSPROC            TCLASSPROC;
	tDot11fIESchedule              Schedule;
	tDot11fIEWMMTSDelay            WMMTSDelay;
	tDot11fIEWMMSchedule           WMMSchedule;
	tDot11fIEWMMTSPEC              WMMTSPEC;
	uint16_t                       num_WMMTCLAS;
	tDot11fIEWMMTCLAS              WMMTCLAS[2];
	tDot11fIEWMMTCLASPROC          WMMTCLASPROC;
	tDot11fIEESETrafStrmMet        ESETrafStrmMet;
} tDot11fAddTSResponse;

#define DOT11F_ADDTSRESPONSE (2)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_add_ts_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fAddTSResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_add_ts_response(tpAniSirGlobal pCtx,
	tDot11fAddTSResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_add_ts_response_size(tpAniSirGlobal pCtx,
	tDot11fAddTSResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fAssocRequest{
	tDot11fFfCapabilities                 Capabilities;
	tDot11fFfListenInterval               ListenInterval;
	tDot11fIESSID                         SSID;
	tDot11fIESuppRates                    SuppRates;
	tDot11fIEOperatingMode                OperatingMode;
	tDot11fIEPowerCaps                    PowerCaps;
	tDot11fIESuppChannels                 SuppChannels;
	tDot11fIEHTCaps                       HTCaps;
	tDot11fIEQOSCapsStation               QOSCapsStation;
	tDot11fIERSNOpaque                    RSNOpaque;
	tDot11fIEExtSuppRates                 ExtSuppRates;
	tDot11fIEMobilityDomain               MobilityDomain;
	tDot11fIESuppOperatingClasses         SuppOperatingClasses;
	tDot11fIEWAPIOpaque                   WAPIOpaque;
	tDot11fIEWAPI                         WAPI;
	tDot11fIERRMEnabledCap                RRMEnabledCap;
	tDot11fIEQosMapSet                    QosMapSet;
	tDot11fIEExtCap                       ExtCap;
	tDot11fIEVHTCaps                      VHTCaps;
	tDot11fIEfils_session                 fils_session;
	tDot11fIEfils_public_key              fils_public_key;
	tDot11fIEfils_key_confirmation        fils_key_confirmation;
	tDot11fIEfils_hlp_container           fils_hlp_container;
	tDot11fIEfragment_ie                  fragment_ie;
	tDot11fIEWPAOpaque                    WPAOpaque;
	tDot11fIEWMMCaps                      WMMCaps;
	tDot11fIEWMMInfoStation               WMMInfoStation;
	tDot11fIEWscIEOpaque                  WscIEOpaque;
	tDot11fIEESERadMgmtCap                ESERadMgmtCap;
	tDot11fIEESEVersion                   ESEVersion;
	tDot11fIEP2PIEOpaque                  P2PIEOpaque;
	tDot11fIEWFDIEOpaque                  WFDIEOpaque;
	tDot11fIEvendor_vht_ie                vendor_vht_ie;
	tDot11fIEhs20vendor_ie                hs20vendor_ie;
	tDot11fIEMBO_IE                       MBO_IE;
	tDot11fIEQCN_IE                       QCN_IE;
	tDot11fIEosen_ie                      osen_ie;
} tDot11fAssocRequest;

#define DOT11F_ASSOCREQUEST (3)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_assoc_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fAssocRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_assoc_request(tpAniSirGlobal pCtx,
	tDot11fAssocRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_assoc_request_size(tpAniSirGlobal pCtx,
	tDot11fAssocRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fAssocResponse{
	tDot11fFfCapabilities                 Capabilities;
	tDot11fFfStatus                       Status;
	tDot11fFfAID                          AID;
	tDot11fIESuppRates                    SuppRates;
	tDot11fIEExtSuppRates                 ExtSuppRates;
	tDot11fIEEDCAParamSet                 EDCAParamSet;
	tDot11fIERCPIIE                       RCPIIE;
	tDot11fIERSNIIE                       RSNIIE;
	tDot11fIERRMEnabledCap                RRMEnabledCap;
	tDot11fIEMobilityDomain               MobilityDomain;
	tDot11fIEFTInfo                       FTInfo;
	uint16_t                              num_RICDataDesc;
	tDot11fIERICDataDesc                  RICDataDesc[2];
	tDot11fIEWPA                          WPA;
	tDot11fIETimeoutInterval              TimeoutInterval;
	tDot11fIEHTCaps                       HTCaps;
	tDot11fIEHTInfo                       HTInfo;
	tDot11fIEWMMParams                    WMMParams;
	tDot11fIEWMMCaps                      WMMCaps;
	tDot11fIEESERadMgmtCap                ESERadMgmtCap;
	tDot11fIEESETrafStrmMet               ESETrafStrmMet;
	tDot11fIEESETxmitPower                ESETxmitPower;
	uint16_t                              num_WMMTSPEC;
	tDot11fIEWMMTSPEC                     WMMTSPEC[4];
	tDot11fIEWscAssocRes                  WscAssocRes;
	tDot11fIEP2PAssocRes                  P2PAssocRes;
	tDot11fIEVHTCaps                      VHTCaps;
	tDot11fIEVHTOperation                 VHTOperation;
	tDot11fIEExtCap                       ExtCap;
	tDot11fIEOBSSScanParameters           OBSSScanParameters;
	tDot11fIEQosMapSet                    QosMapSet;
	tDot11fIEfils_session                 fils_session;
	tDot11fIEfils_public_key              fils_public_key;
	tDot11fIEfils_key_confirmation        fils_key_confirmation;
	tDot11fIEfils_hlp_container           fils_hlp_container;
	tDot11fIEfragment_ie                  fragment_ie;
	tDot11fIEfils_kde                     fils_kde;
	tDot11fIEvendor_vht_ie                vendor_vht_ie;
	tDot11fIEMBO_IE                       MBO_IE;
	tDot11fIEQCN_IE                       QCN_IE;
} tDot11fAssocResponse;

#define DOT11F_ASSOCRESPONSE (4)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_assoc_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fAssocResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_assoc_response(tpAniSirGlobal pCtx,
	tDot11fAssocResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_assoc_response_size(tpAniSirGlobal pCtx,
	tDot11fAssocResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fAuthentication{
	tDot11fFfAuthAlgo                     AuthAlgo;
	tDot11fFfAuthSeqNo                    AuthSeqNo;
	tDot11fFfStatus                       Status;
	tDot11fIEChallengeText                ChallengeText;
	tDot11fIERSNOpaque                    RSNOpaque;
	tDot11fIEMobilityDomain               MobilityDomain;
	tDot11fIEFTInfo                       FTInfo;
	tDot11fIETimeoutInterval              TimeoutInterval;
	uint16_t                              num_RICDataDesc;
	tDot11fIERICDataDesc                  RICDataDesc[2];
	tDot11fIEfils_nonce                   fils_nonce;
	tDot11fIEfils_session                 fils_session;
	tDot11fIEfils_wrapped_data            fils_wrapped_data;
	tDot11fIEfils_assoc_delay_info        fils_assoc_delay_info;
} tDot11fAuthentication;

#define DOT11F_AUTHENTICATION (5)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_authentication(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fAuthentication * pFrm, bool append_ie);
uint32_t dot11f_pack_authentication(tpAniSirGlobal pCtx,
	tDot11fAuthentication *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_authentication_size(tpAniSirGlobal pCtx,
	tDot11fAuthentication *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fBeacon{
	tDot11fFfTimeStamp                   TimeStamp;
	tDot11fFfBeaconInterval              BeaconInterval;
	tDot11fFfCapabilities                Capabilities;
	tDot11fIESSID                        SSID;
	tDot11fIESuppRates                   SuppRates;
	tDot11fIEFHParamSet                  FHParamSet;
	tDot11fIEDSParams                    DSParams;
	tDot11fIECFParams                    CFParams;
	tDot11fIEIBSSParams                  IBSSParams;
	tDot11fIETIM                         TIM;
	tDot11fIECountry                     Country;
	tDot11fIEFHParams                    FHParams;
	tDot11fIEFHPattTable                 FHPattTable;
	tDot11fIEPowerConstraints            PowerConstraints;
	tDot11fIEChanSwitchAnn               ChanSwitchAnn;
	tDot11fIEext_chan_switch_ann         ext_chan_switch_ann;
	tDot11fIESuppOperatingClasses        SuppOperatingClasses;
	tDot11fIEQuiet                       Quiet;
	tDot11fIETPCReport                   TPCReport;
	tDot11fIEERPInfo                     ERPInfo;
	tDot11fIEExtSuppRates                ExtSuppRates;
	tDot11fIERSN                         RSN;
	tDot11fIEQBSSLoad                    QBSSLoad;
	tDot11fIEEDCAParamSet                EDCAParamSet;
	tDot11fIEQOSCapsAp                   QOSCapsAp;
	tDot11fIEAPChannelReport             APChannelReport;
	tDot11fIERRMEnabledCap               RRMEnabledCap;
	tDot11fIEMobilityDomain              MobilityDomain;
	tDot11fIEWPA                         WPA;
	tDot11fIEHTCaps                      HTCaps;
	tDot11fIEHTInfo                      HTInfo;
	tDot11fIEsec_chan_offset_ele         sec_chan_offset_ele;
	tDot11fIEWMMInfoAp                   WMMInfoAp;
	tDot11fIEWMMParams                   WMMParams;
	tDot11fIEWMMCaps                     WMMCaps;
	tDot11fIEWAPI                        WAPI;
	tDot11fIEESERadMgmtCap               ESERadMgmtCap;
	tDot11fIEESETrafStrmMet              ESETrafStrmMet;
	tDot11fIEESETxmitPower               ESETxmitPower;
	tDot11fIEWscBeacon                   WscBeacon;
	tDot11fIEP2PBeacon                   P2PBeacon;
	tDot11fIEVHTCaps                     VHTCaps;
	tDot11fIEVHTOperation                VHTOperation;
	tDot11fIEVHTExtBssLoad               VHTExtBssLoad;
	tDot11fIEExtCap                      ExtCap;
	tDot11fIEOperatingMode               OperatingMode;
	tDot11fIEWiderBWChanSwitchAnn        WiderBWChanSwitchAnn;
	tDot11fIEOBSSScanParameters          OBSSScanParameters;
	tDot11fIEfils_indication             fils_indication;
	tDot11fIEVendor1IE                   Vendor1IE;
	tDot11fIEvendor_vht_ie               vendor_vht_ie;
	tDot11fIEVendor3IE                   Vendor3IE;
	tDot11fIEhs20vendor_ie               hs20vendor_ie;
	tDot11fIEChannelSwitchWrapper        ChannelSwitchWrapper;
	tDot11fIEQComVendorIE                QComVendorIE;
	tDot11fIEESEVersion                  ESEVersion;
	tDot11fIEMBO_IE                      MBO_IE;
	tDot11fIEQCN_IE                      QCN_IE;
	tDot11fIEESP_information             ESP_information;
} tDot11fBeacon;

#define DOT11F_BEACON (6)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_beacon(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fBeacon * pFrm, bool append_ie);
uint32_t dot11f_pack_beacon(tpAniSirGlobal pCtx,
	tDot11fBeacon *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_beacon_size(tpAniSirGlobal pCtx,
	tDot11fBeacon *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fBeacon1{
	tDot11fFfTimeStamp             TimeStamp;
	tDot11fFfBeaconInterval        BeaconInterval;
	tDot11fFfCapabilities          Capabilities;
	tDot11fIESSID                  SSID;
	tDot11fIESuppRates             SuppRates;
	tDot11fIEDSParams              DSParams;
	tDot11fIEIBSSParams            IBSSParams;
} tDot11fBeacon1;

#define DOT11F_BEACON1 (7)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_beacon1(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fBeacon1 * pFrm, bool append_ie);
uint32_t dot11f_pack_beacon1(tpAniSirGlobal pCtx,
	tDot11fBeacon1 *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_beacon1_size(tpAniSirGlobal pCtx,
	tDot11fBeacon1 *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fBeacon2{
	tDot11fIECountry                     Country;
	tDot11fIEPowerConstraints            PowerConstraints;
	tDot11fIEChanSwitchAnn               ChanSwitchAnn;
	tDot11fIEext_chan_switch_ann         ext_chan_switch_ann;
	tDot11fIESuppOperatingClasses        SuppOperatingClasses;
	tDot11fIEQuiet                       Quiet;
	tDot11fIETPCReport                   TPCReport;
	tDot11fIEERPInfo                     ERPInfo;
	tDot11fIEExtSuppRates                ExtSuppRates;
	tDot11fIERSNOpaque                   RSNOpaque;
	tDot11fIEEDCAParamSet                EDCAParamSet;
	tDot11fIEAPChannelReport             APChannelReport;
	tDot11fIERRMEnabledCap               RRMEnabledCap;
	tDot11fIEMobilityDomain              MobilityDomain;
	tDot11fIEWPA                         WPA;
	tDot11fIEHTCaps                      HTCaps;
	tDot11fIEHTInfo                      HTInfo;
	tDot11fIEsec_chan_offset_ele         sec_chan_offset_ele;
	tDot11fIEWMMInfoAp                   WMMInfoAp;
	tDot11fIEWMMParams                   WMMParams;
	tDot11fIEWMMCaps                     WMMCaps;
	tDot11fIEWscBeacon                   WscBeacon;
	tDot11fIEWAPI                        WAPI;
	tDot11fIEESERadMgmtCap               ESERadMgmtCap;
	tDot11fIEESETrafStrmMet              ESETrafStrmMet;
	tDot11fIEESETxmitPower               ESETxmitPower;
	tDot11fIEP2PBeacon                   P2PBeacon;
	tDot11fIEVHTCaps                     VHTCaps;
	tDot11fIEVHTOperation                VHTOperation;
	tDot11fIEVHTExtBssLoad               VHTExtBssLoad;
	tDot11fIEExtCap                      ExtCap;
	tDot11fIEOperatingMode               OperatingMode;
	tDot11fIEWiderBWChanSwitchAnn        WiderBWChanSwitchAnn;
	tDot11fIEOBSSScanParameters          OBSSScanParameters;
	tDot11fIEfils_indication             fils_indication;
	tDot11fIEVendor1IE                   Vendor1IE;
	tDot11fIEvendor_vht_ie               vendor_vht_ie;
	tDot11fIEVendor3IE                   Vendor3IE;
	tDot11fIEhs20vendor_ie               hs20vendor_ie;
	tDot11fIEChannelSwitchWrapper        ChannelSwitchWrapper;
	tDot11fIEQComVendorIE                QComVendorIE;
	tDot11fIEESEVersion                  ESEVersion;
	tDot11fIEQCN_IE                      QCN_IE;
	tDot11fIEESP_information             ESP_information;
} tDot11fBeacon2;

#define DOT11F_BEACON2 (8)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_beacon2(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fBeacon2 * pFrm, bool append_ie);
uint32_t dot11f_pack_beacon2(tpAniSirGlobal pCtx,
	tDot11fBeacon2 *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_beacon2_size(tpAniSirGlobal pCtx,
	tDot11fBeacon2 *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fBeaconIEs{
	tDot11fIESSID                        SSID;
	tDot11fIESuppRates                   SuppRates;
	tDot11fIEFHParamSet                  FHParamSet;
	tDot11fIEDSParams                    DSParams;
	tDot11fIECFParams                    CFParams;
	tDot11fIEIBSSParams                  IBSSParams;
	tDot11fIETIM                         TIM;
	tDot11fIECountry                     Country;
	tDot11fIEFHParams                    FHParams;
	tDot11fIEFHPattTable                 FHPattTable;
	tDot11fIEPowerConstraints            PowerConstraints;
	tDot11fIEChanSwitchAnn               ChanSwitchAnn;
	tDot11fIEext_chan_switch_ann         ext_chan_switch_ann;
	tDot11fIESuppOperatingClasses        SuppOperatingClasses;
	tDot11fIEQuiet                       Quiet;
	tDot11fIETPCReport                   TPCReport;
	tDot11fIEERPInfo                     ERPInfo;
	tDot11fIEExtSuppRates                ExtSuppRates;
	tDot11fIERSN                         RSN;
	tDot11fIEQBSSLoad                    QBSSLoad;
	tDot11fIEEDCAParamSet                EDCAParamSet;
	tDot11fIEQOSCapsAp                   QOSCapsAp;
	tDot11fIEAPChannelReport             APChannelReport;
	tDot11fIERRMEnabledCap               RRMEnabledCap;
	tDot11fIEMobilityDomain              MobilityDomain;
	tDot11fIEWPA                         WPA;
	tDot11fIEHTCaps                      HTCaps;
	tDot11fIEHTInfo                      HTInfo;
	tDot11fIEsec_chan_offset_ele         sec_chan_offset_ele;
	tDot11fIEWMMInfoAp                   WMMInfoAp;
	tDot11fIEWMMParams                   WMMParams;
	tDot11fIEWMMCaps                     WMMCaps;
	tDot11fIEWAPI                        WAPI;
	tDot11fIEESEVersion                  ESEVersion;
	tDot11fIEESERadMgmtCap               ESERadMgmtCap;
	tDot11fIEESETrafStrmMet              ESETrafStrmMet;
	tDot11fIEESETxmitPower               ESETxmitPower;
	tDot11fIEWscBeaconProbeRes           WscBeaconProbeRes;
	tDot11fIEP2PBeaconProbeRes           P2PBeaconProbeRes;
	tDot11fIEVHTCaps                     VHTCaps;
	tDot11fIEVHTOperation                VHTOperation;
	tDot11fIEVHTExtBssLoad               VHTExtBssLoad;
	tDot11fIEExtCap                      ExtCap;
	tDot11fIEOperatingMode               OperatingMode;
	tDot11fIEWiderBWChanSwitchAnn        WiderBWChanSwitchAnn;
	tDot11fIEOBSSScanParameters          OBSSScanParameters;
	tDot11fIEfils_indication             fils_indication;
	tDot11fIEVendor1IE                   Vendor1IE;
	tDot11fIEvendor_vht_ie               vendor_vht_ie;
	tDot11fIEVendor3IE                   Vendor3IE;
	tDot11fIEhs20vendor_ie               hs20vendor_ie;
	tDot11fIEChannelSwitchWrapper        ChannelSwitchWrapper;
	tDot11fIEQComVendorIE                QComVendorIE;
	tDot11fIEMBO_IE                      MBO_IE;
	tDot11fIEQCN_IE                      QCN_IE;
	tDot11fIEESP_information             ESP_information;
} tDot11fBeaconIEs;

#define DOT11F_BEACONIES (9)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_beacon_i_es(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fBeaconIEs * pFrm, bool append_ie);
uint32_t dot11f_pack_beacon_i_es(tpAniSirGlobal pCtx,
	tDot11fBeaconIEs *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_beacon_i_es_size(tpAniSirGlobal pCtx,
	tDot11fBeaconIEs *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fChannelSwitch{
	tDot11fFfCategory                    Category;
	tDot11fFfAction                      Action;
	tDot11fIEChanSwitchAnn               ChanSwitchAnn;
	tDot11fIEsec_chan_offset_ele         sec_chan_offset_ele;
	tDot11fIEWiderBWChanSwitchAnn        WiderBWChanSwitchAnn;
} tDot11fChannelSwitch;

#define DOT11F_CHANNELSWITCH (10)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_channel_switch(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fChannelSwitch * pFrm, bool append_ie);
uint32_t dot11f_pack_channel_switch(tpAniSirGlobal pCtx,
	tDot11fChannelSwitch *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_channel_switch_size(tpAniSirGlobal pCtx,
	tDot11fChannelSwitch *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fDeAuth{
	tDot11fFfReason           Reason;
	tDot11fIEP2PDeAuth        P2PDeAuth;
} tDot11fDeAuth;

#define DOT11F_DEAUTH (11)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_de_auth(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fDeAuth * pFrm, bool append_ie);
uint32_t dot11f_pack_de_auth(tpAniSirGlobal pCtx,
	tDot11fDeAuth *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_de_auth_size(tpAniSirGlobal pCtx,
	tDot11fDeAuth *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fDelTS{
	tDot11fFfCategory        Category;
	tDot11fFfAction          Action;
	tDot11fFfTSInfo          TSInfo;
	tDot11fFfReason          Reason;
} tDot11fDelTS;

#define DOT11F_DELTS (12)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_del_ts(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fDelTS * pFrm, bool append_ie);
uint32_t dot11f_pack_del_ts(tpAniSirGlobal pCtx,
	tDot11fDelTS *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_del_ts_size(tpAniSirGlobal pCtx,
	tDot11fDelTS *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fDisassociation{
	tDot11fFfReason             Reason;
	tDot11fIEP2PDisAssoc        P2PDisAssoc;
} tDot11fDisassociation;

#define DOT11F_DISASSOCIATION (13)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_disassociation(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fDisassociation * pFrm, bool append_ie);
uint32_t dot11f_pack_disassociation(tpAniSirGlobal pCtx,
	tDot11fDisassociation *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_disassociation_size(tpAniSirGlobal pCtx,
	tDot11fDisassociation *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fLinkMeasurementReport{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fFfTPCEleID           TPCEleID;
	tDot11fFfTPCEleLen          TPCEleLen;
	tDot11fFfTxPower            TxPower;
	tDot11fFfLinkMargin         LinkMargin;
	tDot11fFfRxAntennaId        RxAntennaId;
	tDot11fFfTxAntennaId        TxAntennaId;
	tDot11fFfRCPI               RCPI;
	tDot11fFfRSNI               RSNI;
} tDot11fLinkMeasurementReport;

#define DOT11F_LINKMEASUREMENTREPORT (14)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_link_measurement_report(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fLinkMeasurementReport * pFrm, bool append_ie);
uint32_t dot11f_pack_link_measurement_report(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementReport *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_link_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementReport *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fLinkMeasurementRequest{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fFfTxPower            TxPower;
	tDot11fFfMaxTxPower         MaxTxPower;
} tDot11fLinkMeasurementRequest;

#define DOT11F_LINKMEASUREMENTREQUEST (15)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_link_measurement_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fLinkMeasurementRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_link_measurement_request(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_link_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fLinkMeasurementRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fMeasurementReport{
	tDot11fFfCategory                 Category;
	tDot11fFfAction                   Action;
	tDot11fFfDialogToken              DialogToken;
	tDot11fIEMeasurementReport        MeasurementReport;
} tDot11fMeasurementReport;

#define DOT11F_MEASUREMENTREPORT (16)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_measurement_report(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fMeasurementReport * pFrm, bool append_ie);
uint32_t dot11f_pack_measurement_report(tpAniSirGlobal pCtx,
	tDot11fMeasurementReport *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fMeasurementReport *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fMeasurementRequest{
	tDot11fFfCategory                  Category;
	tDot11fFfAction                    Action;
	tDot11fFfDialogToken               DialogToken;
	uint16_t                           num_MeasurementRequest;
	tDot11fIEMeasurementRequest        MeasurementRequest[4];
} tDot11fMeasurementRequest;

#define DOT11F_MEASUREMENTREQUEST (17)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_measurement_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fMeasurementRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_measurement_request(tpAniSirGlobal pCtx,
	tDot11fMeasurementRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fMeasurementRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fNeighborReportRequest{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fIESSID               SSID;
} tDot11fNeighborReportRequest;

#define DOT11F_NEIGHBORREPORTREQUEST (18)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_neighbor_report_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fNeighborReportRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_neighbor_report_request(tpAniSirGlobal pCtx,
	tDot11fNeighborReportRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_neighbor_report_request_size(tpAniSirGlobal pCtx,
	tDot11fNeighborReportRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fNeighborReportResponse{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	uint16_t                       num_NeighborReport;
	tDot11fIENeighborReport        NeighborReport[15];
} tDot11fNeighborReportResponse;

#define DOT11F_NEIGHBORREPORTRESPONSE (19)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_neighbor_report_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fNeighborReportResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_neighbor_report_response(tpAniSirGlobal pCtx,
	tDot11fNeighborReportResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_neighbor_report_response_size(tpAniSirGlobal pCtx,
	tDot11fNeighborReportResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fOperatingMode{
	tDot11fFfCategory             Category;
	tDot11fFfAction               Action;
	tDot11fFfOperatingMode        OperatingMode;
} tDot11fOperatingMode;

#define DOT11F_OPERATINGMODE (20)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_operating_mode(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fOperatingMode * pFrm, bool append_ie);
uint32_t dot11f_pack_operating_mode(tpAniSirGlobal pCtx,
	tDot11fOperatingMode *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_operating_mode_size(tpAniSirGlobal pCtx,
	tDot11fOperatingMode *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fProbeRequest{
	tDot11fIESSID                 SSID;
	tDot11fIESuppRates            SuppRates;
	tDot11fIERequestedInfo        RequestedInfo;
	tDot11fIEExtSuppRates         ExtSuppRates;
	tDot11fIEDSParams             DSParams;
	tDot11fIEHTCaps               HTCaps;
	tDot11fIEWscProbeReq          WscProbeReq;
	tDot11fIEWFATPC               WFATPC;
	tDot11fIEP2PProbeReq          P2PProbeReq;
	tDot11fIEVHTCaps              VHTCaps;
	tDot11fIEExtCap               ExtCap;
	tDot11fIEQCN_IE               QCN_IE;
} tDot11fProbeRequest;

#define DOT11F_PROBEREQUEST (21)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_probe_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fProbeRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_probe_request(tpAniSirGlobal pCtx,
	tDot11fProbeRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_probe_request_size(tpAniSirGlobal pCtx,
	tDot11fProbeRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fProbeResponse{
	tDot11fFfTimeStamp                   TimeStamp;
	tDot11fFfBeaconInterval              BeaconInterval;
	tDot11fFfCapabilities                Capabilities;
	tDot11fIESSID                        SSID;
	tDot11fIESuppRates                   SuppRates;
	tDot11fIEFHParamSet                  FHParamSet;
	tDot11fIEDSParams                    DSParams;
	tDot11fIECFParams                    CFParams;
	tDot11fIEIBSSParams                  IBSSParams;
	tDot11fIECountry                     Country;
	tDot11fIEFHParams                    FHParams;
	tDot11fIEFHPattTable                 FHPattTable;
	tDot11fIEPowerConstraints            PowerConstraints;
	tDot11fIEChanSwitchAnn               ChanSwitchAnn;
	tDot11fIEext_chan_switch_ann         ext_chan_switch_ann;
	tDot11fIESuppOperatingClasses        SuppOperatingClasses;
	tDot11fIEQuiet                       Quiet;
	tDot11fIETPCReport                   TPCReport;
	tDot11fIEERPInfo                     ERPInfo;
	tDot11fIEExtSuppRates                ExtSuppRates;
	tDot11fIERSNOpaque                   RSNOpaque;
	tDot11fIEQBSSLoad                    QBSSLoad;
	tDot11fIEEDCAParamSet                EDCAParamSet;
	tDot11fIERRMEnabledCap               RRMEnabledCap;
	tDot11fIEAPChannelReport             APChannelReport;
	tDot11fIEMobilityDomain              MobilityDomain;
	tDot11fIEWPA                         WPA;
	tDot11fIEHTCaps                      HTCaps;
	tDot11fIEHTInfo                      HTInfo;
	tDot11fIEsec_chan_offset_ele         sec_chan_offset_ele;
	tDot11fIEWMMInfoAp                   WMMInfoAp;
	tDot11fIEWMMParams                   WMMParams;
	tDot11fIEWMMCaps                     WMMCaps;
	tDot11fIEWAPI                        WAPI;
	tDot11fIEESERadMgmtCap               ESERadMgmtCap;
	tDot11fIEESETrafStrmMet              ESETrafStrmMet;
	tDot11fIEESETxmitPower               ESETxmitPower;
	tDot11fIEWscProbeRes                 WscProbeRes;
	tDot11fIEP2PProbeRes                 P2PProbeRes;
	tDot11fIEVHTCaps                     VHTCaps;
	tDot11fIEVHTOperation                VHTOperation;
	tDot11fIEVHTExtBssLoad               VHTExtBssLoad;
	tDot11fIEExtCap                      ExtCap;
	tDot11fIEOBSSScanParameters          OBSSScanParameters;
	tDot11fIEfils_indication             fils_indication;
	tDot11fIEVendor1IE                   Vendor1IE;
	tDot11fIEvendor_vht_ie               vendor_vht_ie;
	tDot11fIEVendor3IE                   Vendor3IE;
	tDot11fIEhs20vendor_ie               hs20vendor_ie;
	tDot11fIEChannelSwitchWrapper        ChannelSwitchWrapper;
	tDot11fIEQComVendorIE                QComVendorIE;
	tDot11fIEESEVersion                  ESEVersion;
	tDot11fIEMBO_IE                      MBO_IE;
	tDot11fIEQCN_IE                      QCN_IE;
	tDot11fIEESP_information             ESP_information;
} tDot11fProbeResponse;

#define DOT11F_PROBERESPONSE (22)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_probe_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fProbeResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_probe_response(tpAniSirGlobal pCtx,
	tDot11fProbeResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_probe_response_size(tpAniSirGlobal pCtx,
	tDot11fProbeResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fQosMapConfigure{
	tDot11fFfCategory         Category;
	tDot11fFfAction           Action;
	tDot11fIEQosMapSet        QosMapSet;
} tDot11fQosMapConfigure;

#define DOT11F_QOSMAPCONFIGURE (23)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_qos_map_configure(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fQosMapConfigure * pFrm, bool append_ie);
uint32_t dot11f_pack_qos_map_configure(tpAniSirGlobal pCtx,
	tDot11fQosMapConfigure *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_qos_map_configure_size(tpAniSirGlobal pCtx,
	tDot11fQosMapConfigure *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fRadioMeasurementReport{
	tDot11fFfCategory                 Category;
	tDot11fFfAction                   Action;
	tDot11fFfDialogToken              DialogToken;
	uint16_t                          num_MeasurementReport;
	tDot11fIEMeasurementReport        MeasurementReport[4];
} tDot11fRadioMeasurementReport;

#define DOT11F_RADIOMEASUREMENTREPORT (24)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_radio_measurement_report(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fRadioMeasurementReport * pFrm, bool append_ie);
uint32_t dot11f_pack_radio_measurement_report(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementReport *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_radio_measurement_report_size(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementReport *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fRadioMeasurementRequest{
	tDot11fFfCategory                  Category;
	tDot11fFfAction                    Action;
	tDot11fFfDialogToken               DialogToken;
	tDot11fFfNumOfRepetitions          NumOfRepetitions;
	uint16_t                           num_MeasurementRequest;
	tDot11fIEMeasurementRequest        MeasurementRequest[2];
} tDot11fRadioMeasurementRequest;

#define DOT11F_RADIOMEASUREMENTREQUEST (25)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_radio_measurement_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fRadioMeasurementRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_radio_measurement_request(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_radio_measurement_request_size(tpAniSirGlobal pCtx,
	tDot11fRadioMeasurementRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fReAssocRequest{
	tDot11fFfCapabilities              Capabilities;
	tDot11fFfListenInterval            ListenInterval;
	tDot11fFfCurrentAPAddress          CurrentAPAddress;
	tDot11fIESSID                      SSID;
	tDot11fIESuppRates                 SuppRates;
	tDot11fIEExtSuppRates              ExtSuppRates;
	tDot11fIEPowerCaps                 PowerCaps;
	tDot11fIESuppChannels              SuppChannels;
	tDot11fIERSNOpaque                 RSNOpaque;
	tDot11fIEQOSCapsStation            QOSCapsStation;
	tDot11fIERRMEnabledCap             RRMEnabledCap;
	tDot11fIEMobilityDomain            MobilityDomain;
	tDot11fIEFTInfo                    FTInfo;
	uint16_t                           num_RICDataDesc;
	tDot11fIERICDataDesc               RICDataDesc[2];
	tDot11fIEWPAOpaque                 WPAOpaque;
	tDot11fIEHTCaps                    HTCaps;
	tDot11fIEWMMCaps                   WMMCaps;
	tDot11fIEWMMInfoStation            WMMInfoStation;
	tDot11fIEWscIEOpaque               WscIEOpaque;
	tDot11fIEWAPIOpaque                WAPIOpaque;
	tDot11fIEWAPI                      WAPI;
	tDot11fIEESERadMgmtCap             ESERadMgmtCap;
	tDot11fIEESEVersion                ESEVersion;
	tDot11fIEESECckmOpaque             ESECckmOpaque;
	uint16_t                           num_WMMTSPEC;
	tDot11fIEWMMTSPEC                  WMMTSPEC[4];
	tDot11fIEESETrafStrmRateSet        ESETrafStrmRateSet;
	tDot11fIEP2PIEOpaque               P2PIEOpaque;
	tDot11fIEWFDIEOpaque               WFDIEOpaque;
	tDot11fIEVHTCaps                   VHTCaps;
	tDot11fIEExtCap                    ExtCap;
	tDot11fIEOperatingMode             OperatingMode;
	tDot11fIEQosMapSet                 QosMapSet;
	tDot11fIEvendor_vht_ie             vendor_vht_ie;
	tDot11fIEhs20vendor_ie             hs20vendor_ie;
} tDot11fReAssocRequest;

#define DOT11F_REASSOCREQUEST (26)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_re_assoc_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fReAssocRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_re_assoc_request(tpAniSirGlobal pCtx,
	tDot11fReAssocRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_re_assoc_request_size(tpAniSirGlobal pCtx,
	tDot11fReAssocRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fReAssocResponse{
	tDot11fFfCapabilities              Capabilities;
	tDot11fFfStatus                    Status;
	tDot11fFfAID                       AID;
	tDot11fIESuppRates                 SuppRates;
	tDot11fIEExtSuppRates              ExtSuppRates;
	tDot11fIEEDCAParamSet              EDCAParamSet;
	tDot11fIERCPIIE                    RCPIIE;
	tDot11fIERSNIIE                    RSNIIE;
	tDot11fIERRMEnabledCap             RRMEnabledCap;
	tDot11fIERSNOpaque                 RSNOpaque;
	tDot11fIEMobilityDomain            MobilityDomain;
	tDot11fIEFTInfo                    FTInfo;
	uint16_t                           num_RICDataDesc;
	tDot11fIERICDataDesc               RICDataDesc[2];
	tDot11fIEWPA                       WPA;
	tDot11fIETimeoutInterval           TimeoutInterval;
	tDot11fIEHTCaps                    HTCaps;
	tDot11fIEHTInfo                    HTInfo;
	tDot11fIEWMMParams                 WMMParams;
	tDot11fIEESERadMgmtCap             ESERadMgmtCap;
	tDot11fIEESETrafStrmMet            ESETrafStrmMet;
	tDot11fIEESETxmitPower             ESETxmitPower;
	uint16_t                           num_WMMTSPEC;
	tDot11fIEWMMTSPEC                  WMMTSPEC[4];
	tDot11fIEESETrafStrmRateSet        ESETrafStrmRateSet;
	tDot11fIEWscReassocRes             WscReassocRes;
	tDot11fIEP2PAssocRes               P2PAssocRes;
	tDot11fIEVHTCaps                   VHTCaps;
	tDot11fIEVHTOperation              VHTOperation;
	tDot11fIEExtCap                    ExtCap;
	tDot11fIEOBSSScanParameters        OBSSScanParameters;
	tDot11fIEQosMapSet                 QosMapSet;
	tDot11fIEvendor_vht_ie             vendor_vht_ie;
	tDot11fIEMBO_IE                    MBO_IE;
} tDot11fReAssocResponse;

#define DOT11F_REASSOCRESPONSE (27)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_re_assoc_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fReAssocResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_re_assoc_response(tpAniSirGlobal pCtx,
	tDot11fReAssocResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_re_assoc_response_size(tpAniSirGlobal pCtx,
	tDot11fReAssocResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fSMPowerSave{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfSMPowerModeSet        SMPowerModeSet;
} tDot11fSMPowerSave;

#define DOT11F_SMPOWERSAVE (28)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_sm_power_save(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fSMPowerSave * pFrm, bool append_ie);
uint32_t dot11f_pack_sm_power_save(tpAniSirGlobal pCtx,
	tDot11fSMPowerSave *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_sm_power_save_size(tpAniSirGlobal pCtx,
	tDot11fSMPowerSave *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fSaQueryReq{
	tDot11fFfCategory             Category;
	tDot11fFfAction               Action;
	tDot11fFfTransactionId        TransactionId;
} tDot11fSaQueryReq;

#define DOT11F_SAQUERYREQ (29)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_sa_query_req(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fSaQueryReq * pFrm, bool append_ie);
uint32_t dot11f_pack_sa_query_req(tpAniSirGlobal pCtx,
	tDot11fSaQueryReq *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_sa_query_req_size(tpAniSirGlobal pCtx,
	tDot11fSaQueryReq *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fSaQueryRsp{
	tDot11fFfCategory             Category;
	tDot11fFfAction               Action;
	tDot11fFfTransactionId        TransactionId;
} tDot11fSaQueryRsp;

#define DOT11F_SAQUERYRSP (30)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_sa_query_rsp(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fSaQueryRsp * pFrm, bool append_ie);
uint32_t dot11f_pack_sa_query_rsp(tpAniSirGlobal pCtx,
	tDot11fSaQueryRsp *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_sa_query_rsp_size(tpAniSirGlobal pCtx,
	tDot11fSaQueryRsp *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSDisReq{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	tDot11fIELinkIdentifier        LinkIdentifier;
} tDot11fTDLSDisReq;

#define DOT11F_TDLSDISREQ (31)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_dis_req(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSDisReq * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_dis_req(tpAniSirGlobal pCtx,
	tDot11fTDLSDisReq *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_dis_req_size(tpAniSirGlobal pCtx,
	tDot11fTDLSDisReq *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSDisRsp{
	tDot11fFfCategory                      Category;
	tDot11fFfAction                        Action;
	tDot11fFfDialogToken                   DialogToken;
	tDot11fFfCapabilities                  Capabilities;
	tDot11fIESuppRates                     SuppRates;
	tDot11fIEExtSuppRates                  ExtSuppRates;
	tDot11fIESuppChannels                  SuppChannels;
	tDot11fIESuppOperatingClasses          SuppOperatingClasses;
	tDot11fIERSN                           RSN;
	tDot11fIEExtCap                        ExtCap;
	tDot11fIEFTInfo                        FTInfo;
	tDot11fIETimeoutInterval               TimeoutInterval;
	tDot11fIERICData                       RICData;
	tDot11fIEHTCaps                        HTCaps;
	tDot11fIEht2040_bss_coexistence        ht2040_bss_coexistence;
	tDot11fIELinkIdentifier                LinkIdentifier;
	tDot11fIEVHTCaps                       VHTCaps;
} tDot11fTDLSDisRsp;

#define DOT11F_TDLSDISRSP (32)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_dis_rsp(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSDisRsp * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_dis_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSDisRsp *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_dis_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSDisRsp *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSPeerTrafficInd{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	tDot11fIELinkIdentifier        LinkIdentifier;
	tDot11fIEPTIControl            PTIControl;
	tDot11fIEPUBufferStatus        PUBufferStatus;
} tDot11fTDLSPeerTrafficInd;

#define DOT11F_TDLSPEERTRAFFICIND (33)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_peer_traffic_ind(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSPeerTrafficInd * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_peer_traffic_ind(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficInd *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_peer_traffic_ind_size(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficInd *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSPeerTrafficRsp{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	tDot11fIELinkIdentifier        LinkIdentifier;
} tDot11fTDLSPeerTrafficRsp;

#define DOT11F_TDLSPEERTRAFFICRSP (34)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_peer_traffic_rsp(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSPeerTrafficRsp * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_peer_traffic_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficRsp *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_peer_traffic_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSPeerTrafficRsp *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSSetupCnf{
	tDot11fFfCategory               Category;
	tDot11fFfAction                 Action;
	tDot11fFfStatus                 Status;
	tDot11fFfDialogToken            DialogToken;
	tDot11fIERSN                    RSN;
	tDot11fIEEDCAParamSet           EDCAParamSet;
	tDot11fIEFTInfo                 FTInfo;
	tDot11fIETimeoutInterval        TimeoutInterval;
	tDot11fIEHTInfo                 HTInfo;
	tDot11fIELinkIdentifier         LinkIdentifier;
	tDot11fIEWMMParams              WMMParams;
	tDot11fIEVHTOperation           VHTOperation;
	tDot11fIEOperatingMode          OperatingMode;
} tDot11fTDLSSetupCnf;

#define DOT11F_TDLSSETUPCNF (35)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_setup_cnf(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSSetupCnf * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_setup_cnf(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupCnf *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_setup_cnf_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupCnf *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSSetupReq{
	tDot11fFfCategory                      Category;
	tDot11fFfAction                        Action;
	tDot11fFfDialogToken                   DialogToken;
	tDot11fFfCapabilities                  Capabilities;
	tDot11fIESuppRates                     SuppRates;
	tDot11fIECountry                       Country;
	tDot11fIEExtSuppRates                  ExtSuppRates;
	tDot11fIESuppChannels                  SuppChannels;
	tDot11fIERSN                           RSN;
	tDot11fIEExtCap                        ExtCap;
	tDot11fIESuppOperatingClasses          SuppOperatingClasses;
	tDot11fIEQOSCapsStation                QOSCapsStation;
	tDot11fIEFTInfo                        FTInfo;
	tDot11fIETimeoutInterval               TimeoutInterval;
	tDot11fIERICData                       RICData;
	tDot11fIEHTCaps                        HTCaps;
	tDot11fIEht2040_bss_coexistence        ht2040_bss_coexistence;
	tDot11fIELinkIdentifier                LinkIdentifier;
	tDot11fIEWMMInfoStation                WMMInfoStation;
	tDot11fIEAID                           AID;
	tDot11fIEVHTCaps                       VHTCaps;
} tDot11fTDLSSetupReq;

#define DOT11F_TDLSSETUPREQ (36)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_setup_req(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSSetupReq * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_setup_req(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupReq *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_setup_req_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupReq *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSSetupRsp{
	tDot11fFfCategory                      Category;
	tDot11fFfAction                        Action;
	tDot11fFfStatus                        Status;
	tDot11fFfDialogToken                   DialogToken;
	tDot11fFfCapabilities                  Capabilities;
	tDot11fIESuppRates                     SuppRates;
	tDot11fIECountry                       Country;
	tDot11fIEExtSuppRates                  ExtSuppRates;
	tDot11fIESuppChannels                  SuppChannels;
	tDot11fIERSN                           RSN;
	tDot11fIEExtCap                        ExtCap;
	tDot11fIESuppOperatingClasses          SuppOperatingClasses;
	tDot11fIEQOSCapsStation                QOSCapsStation;
	tDot11fIEFTInfo                        FTInfo;
	tDot11fIETimeoutInterval               TimeoutInterval;
	tDot11fIERICData                       RICData;
	tDot11fIEHTCaps                        HTCaps;
	tDot11fIEht2040_bss_coexistence        ht2040_bss_coexistence;
	tDot11fIELinkIdentifier                LinkIdentifier;
	tDot11fIEWMMInfoStation                WMMInfoStation;
	tDot11fIEAID                           AID;
	tDot11fIEVHTCaps                       VHTCaps;
	tDot11fIEOperatingMode                 OperatingMode;
} tDot11fTDLSSetupRsp;

#define DOT11F_TDLSSETUPRSP (37)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_setup_rsp(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSSetupRsp * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_setup_rsp(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupRsp *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_setup_rsp_size(tpAniSirGlobal pCtx,
	tDot11fTDLSSetupRsp *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTDLSTeardown{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfReason                Reason;
	tDot11fIEFTInfo                FTInfo;
	tDot11fIELinkIdentifier        LinkIdentifier;
} tDot11fTDLSTeardown;

#define DOT11F_TDLSTEARDOWN (38)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tdls_teardown(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTDLSTeardown * pFrm, bool append_ie);
uint32_t dot11f_pack_tdls_teardown(tpAniSirGlobal pCtx,
	tDot11fTDLSTeardown *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tdls_teardown_size(tpAniSirGlobal pCtx,
	tDot11fTDLSTeardown *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTPCReport{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fIETPCReport          TPCReport;
} tDot11fTPCReport;

#define DOT11F_TPCREPORT (39)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tpc_report(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTPCReport * pFrm, bool append_ie);
uint32_t dot11f_pack_tpc_report(tpAniSirGlobal pCtx,
	tDot11fTPCReport *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tpc_report_size(tpAniSirGlobal pCtx,
	tDot11fTPCReport *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTPCRequest{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fIETPCRequest         TPCRequest;
} tDot11fTPCRequest;

#define DOT11F_TPCREQUEST (40)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_tpc_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTPCRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_tpc_request(tpAniSirGlobal pCtx,
	tDot11fTPCRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_tpc_request_size(tpAniSirGlobal pCtx,
	tDot11fTPCRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fTimingAdvertisementFrame{
	tDot11fFfTimeStamp                TimeStamp;
	tDot11fFfCapabilities             Capabilities;
	tDot11fIECountry                  Country;
	tDot11fIEPowerConstraints         PowerConstraints;
	tDot11fIETimeAdvertisement        TimeAdvertisement;
	tDot11fIEExtCap                   ExtCap;
	tDot11fIEVendor1IE                Vendor1IE;
	tDot11fIEVendor3IE                Vendor3IE;
} tDot11fTimingAdvertisementFrame;

#define DOT11F_TIMINGADVERTISEMENTFRAME (41)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_timing_advertisement_frame(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fTimingAdvertisementFrame * pFrm, bool append_ie);
uint32_t dot11f_pack_timing_advertisement_frame(tpAniSirGlobal pCtx,
	tDot11fTimingAdvertisementFrame *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_timing_advertisement_frame_size(tpAniSirGlobal pCtx,
	tDot11fTimingAdvertisementFrame *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fVHTGidManagementActionFrame{
	tDot11fFfCategory                        Category;
	tDot11fFfAction                          Action;
	tDot11fFfVhtMembershipStatusArray        VhtMembershipStatusArray;
	tDot11fFfVhtUserPositionArray            VhtUserPositionArray;
} tDot11fVHTGidManagementActionFrame;

#define DOT11F_VHTGIDMANAGEMENTACTIONFRAME (42)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_vht_gid_management_action_frame(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fVHTGidManagementActionFrame * pFrm, bool append_ie);
uint32_t dot11f_pack_vht_gid_management_action_frame(tpAniSirGlobal pCtx,
	tDot11fVHTGidManagementActionFrame *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_vht_gid_management_action_frame_size(tpAniSirGlobal pCtx,
	tDot11fVHTGidManagementActionFrame *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fWMMAddTSRequest{
	tDot11fFfCategory                  Category;
	tDot11fFfAction                    Action;
	tDot11fFfDialogToken               DialogToken;
	tDot11fFfStatusCode                StatusCode;
	tDot11fIEWMMTSPEC                  WMMTSPEC;
	tDot11fIEESETrafStrmRateSet        ESETrafStrmRateSet;
} tDot11fWMMAddTSRequest;

#define DOT11F_WMMADDTSREQUEST (43)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_wmm_add_ts_request(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fWMMAddTSRequest * pFrm, bool append_ie);
uint32_t dot11f_pack_wmm_add_ts_request(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSRequest *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_wmm_add_ts_request_size(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSRequest *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fWMMAddTSResponse{
	tDot11fFfCategory              Category;
	tDot11fFfAction                Action;
	tDot11fFfDialogToken           DialogToken;
	tDot11fFfStatusCode            StatusCode;
	tDot11fIEWMMTSPEC              WMMTSPEC;
	tDot11fIEESETrafStrmMet        ESETrafStrmMet;
} tDot11fWMMAddTSResponse;

#define DOT11F_WMMADDTSRESPONSE (44)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_wmm_add_ts_response(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fWMMAddTSResponse * pFrm, bool append_ie);
uint32_t dot11f_pack_wmm_add_ts_response(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSResponse *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_wmm_add_ts_response_size(tpAniSirGlobal pCtx,
	tDot11fWMMAddTSResponse *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fWMMDelTS{
	tDot11fFfCategory           Category;
	tDot11fFfAction             Action;
	tDot11fFfDialogToken        DialogToken;
	tDot11fFfStatusCode         StatusCode;
	tDot11fIEWMMTSPEC           WMMTSPEC;
} tDot11fWMMDelTS;

#define DOT11F_WMMDELTS (45)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_wmm_del_ts(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fWMMDelTS * pFrm, bool append_ie);
uint32_t dot11f_pack_wmm_del_ts(tpAniSirGlobal pCtx,
	tDot11fWMMDelTS *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_wmm_del_ts_size(tpAniSirGlobal pCtx,
	tDot11fWMMDelTS *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fext_channel_switch_action_frame{
	tDot11fFfCategory                          Category;
	tDot11fFfAction                            Action;
	tDot11fFfext_chan_switch_ann_action        ext_chan_switch_ann_action;
	tDot11fIEWiderBWChanSwitchAnn              WiderBWChanSwitchAnn;
} tDot11fext_channel_switch_action_frame;

#define DOT11F_EXT_CHANNEL_SWITCH_ACTION_FRAME (46)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_ext_channel_switch_action_frame(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fext_channel_switch_action_frame * pFrm, bool append_ie);
uint32_t dot11f_pack_ext_channel_switch_action_frame(tpAniSirGlobal pCtx,
	tDot11fext_channel_switch_action_frame *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_ext_channel_switch_action_frame_size(tpAniSirGlobal pCtx,
	tDot11fext_channel_switch_action_frame *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fht2040_bss_coexistence_mgmt_action_frame{
	tDot11fFfCategory                            Category;
	tDot11fFfAction                              Action;
	tDot11fIEht2040_bss_coexistence              ht2040_bss_coexistence;
	tDot11fIEht2040_bss_intolerant_report        ht2040_bss_intolerant_report;
} tDot11fht2040_bss_coexistence_mgmt_action_frame;

#define DOT11F_HT2040_BSS_COEXISTENCE_MGMT_ACTION_FRAME (47)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_ht2040_bss_coexistence_mgmt_action_frame(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fht2040_bss_coexistence_mgmt_action_frame * pFrm, bool append_ie);
uint32_t dot11f_pack_ht2040_bss_coexistence_mgmt_action_frame(tpAniSirGlobal pCtx,
	tDot11fht2040_bss_coexistence_mgmt_action_frame *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_ht2040_bss_coexistence_mgmt_action_frameSize(tpAniSirGlobal pCtx,
	tDot11fht2040_bss_coexistence_mgmt_action_frame *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

typedef struct sDot11fp2p_oper_chan_change_confirm{
	tDot11fFfCategory                  Category;
	tDot11fFfp2p_action_oui            p2p_action_oui;
	tDot11fFfp2p_action_subtype        p2p_action_subtype;
	tDot11fFfDialogToken               DialogToken;
	tDot11fIEHTCaps                    HTCaps;
	tDot11fIEVHTCaps                   VHTCaps;
	tDot11fIEOperatingMode             OperatingMode;
} tDot11fp2p_oper_chan_change_confirm;

#define DOT11F_P2P_OPER_CHAN_CHANGE_CONFIRM (48)

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

uint32_t dot11f_unpack_p2p_oper_chan_change_confirm(tpAniSirGlobal pCtx,
	uint8_t *pBuf, uint32_t nBuf,
	tDot11fp2p_oper_chan_change_confirm * pFrm, bool append_ie);
uint32_t dot11f_pack_p2p_oper_chan_change_confirm(tpAniSirGlobal pCtx,
	tDot11fp2p_oper_chan_change_confirm *pFrm, uint8_t *pBuf,
	uint32_t nBuf, uint32_t *pnConsumed);
uint32_t dot11f_get_packed_p2p_oper_chan_change_confirmSize(tpAniSirGlobal pCtx,
	tDot11fp2p_oper_chan_change_confirm *pFrm,
	uint32_t *pnNeeded);

#ifdef __cplusplus
} /* End extern "C". */
#endif /* C++ */

#endif /* DOT11F_H */
