/*
 * Copyright (c) 2015-2017, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/regmap.h>
#include "msm-cdc-common.h"
#include "sdm660-cdc-registers.h"

/*
 * Default register reset values that are common across different versions
 * are defined here. If a register reset value is changed based on version
 * then remove it from this structure and add it in version specific
 * structures.
 */
struct reg_default
	msm89xx_cdc_core_defaults[MSM89XX_CDC_CORE_CACHE_SIZE] = {
	{MSM89XX_CDC_CORE_CLK_RX_RESET_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_RX_I2S_CTL, 0x13},
	{MSM89XX_CDC_CORE_CLK_TX_I2S_CTL, 0x13},
	{MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_OTHR_CTL, 0x04},
	{MSM89XX_CDC_CORE_CLK_RX_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_MCLK_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_PDM_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_SD_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_DMIC_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_RX_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_TX2_I2S_CTL, 0x13},
	{MSM89XX_CDC_CORE_RX1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX2_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX3_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX1_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_TOP_GAIN_UPDATE, 0x00},
	{MSM89XX_CDC_CORE_TOP_CTL, 0x01},
	{MSM89XX_CDC_CORE_COMP0_B1_CTL, 0x30},
	{MSM89XX_CDC_CORE_COMP0_B2_CTL, 0xB5},
	{MSM89XX_CDC_CORE_COMP0_B3_CTL, 0x28},
	{MSM89XX_CDC_CORE_COMP0_B4_CTL, 0x37},
	{MSM89XX_CDC_CORE_COMP0_B5_CTL, 0x7F},
	{MSM89XX_CDC_CORE_COMP0_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_COMP0_SHUT_DOWN_STATUS, 0x03},
	{MSM89XX_CDC_CORE_COMP0_FS_CFG, 0x03},
	{MSM89XX_CDC_CORE_COMP0_DELAY_BUF_CTL, 0x02},
	{MSM89XX_CDC_CORE_DEBUG_DESER1_CTL, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_DESER2_CTL, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_CTL, 0x40},
	{MSM89XX_CDC_CORE_IIR2_CTL, 0x40},
	{MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX3_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX3_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX5_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX5_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX5_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX5_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX5_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX5_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX1_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX2_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX3_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX4_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX1_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX2_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX3_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX4_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX1_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX2_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX3_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX4_DMIC_CTL, 0x00},
};

struct reg_default
	msm89xx_pmic_cdc_defaults[MSM89XX_PMIC_CDC_CACHE_SIZE] = {
	{MSM89XX_PMIC_DIGITAL_REVISION1, 0x00},
	{MSM89XX_PMIC_DIGITAL_REVISION2, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_TYPE, 0x23},
	{MSM89XX_PMIC_DIGITAL_PERPH_SUBTYPE, 0x01},
	{MSM89XX_PMIC_DIGITAL_INT_RT_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_SET_TYPE, 0xFF},
	{MSM89XX_PMIC_DIGITAL_INT_POLARITY_HIGH, 0xFF},
	{MSM89XX_PMIC_DIGITAL_INT_POLARITY_LOW, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_LATCHED_CLR, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_EN_SET, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_EN_CLR, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_LATCHED_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_PENDING_STS, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_MID_SEL, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_PRIORITY, 0x00},
	{MSM89XX_PMIC_DIGITAL_GPIO_MODE, 0x00},
	{MSM89XX_PMIC_DIGITAL_PIN_CTL_OE, 0x01},
	{MSM89XX_PMIC_DIGITAL_PIN_CTL_DATA, 0x00},
	{MSM89XX_PMIC_DIGITAL_PIN_STATUS, 0x00},
	{MSM89XX_PMIC_DIGITAL_HDRIVE_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_RST_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_TOP_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_ANA_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_DIG_CLK_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_TX1_CTL, 0x02},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_TX2_CTL, 0x02},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_HPHR_DAC_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX1_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX2_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX3_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_CONN_RX_LB_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL1, 0x7C},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL2, 0x7C},
	{MSM89XX_PMIC_DIGITAL_CDC_RX_CTL3, 0x7C},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA0, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA1, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA2, 0x00},
	{MSM89XX_PMIC_DIGITAL_DEM_BYPASS_DATA3, 0x00},
	{MSM89XX_PMIC_DIGITAL_DIG_DEBUG_CTL, 0x00},
	{MSM89XX_PMIC_DIGITAL_DIG_DEBUG_EN, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_0, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_1, 0x00},
	{MSM89XX_PMIC_DIGITAL_SPARE_2, 0x00},
	{MSM89XX_PMIC_DIGITAL_SEC_ACCESS, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL1, 0x00},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL2, 0x02},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL3, 0x05},
	{MSM89XX_PMIC_DIGITAL_PERPH_RESET_CTL4, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_TEST1, 0x00},
	{MSM89XX_PMIC_DIGITAL_INT_TEST_VAL, 0x00},
	{MSM89XX_PMIC_DIGITAL_TRIM_NUM, 0x00},
	{MSM89XX_PMIC_DIGITAL_TRIM_CTRL, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION1, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION2, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION3, 0x00},
	{MSM89XX_PMIC_ANALOG_REVISION4, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_TYPE, 0x23},
	{MSM89XX_PMIC_ANALOG_PERPH_SUBTYPE, 0x09},
	{MSM89XX_PMIC_ANALOG_INT_RT_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_SET_TYPE, 0x3F},
	{MSM89XX_PMIC_ANALOG_INT_POLARITY_HIGH, 0x3F},
	{MSM89XX_PMIC_ANALOG_INT_POLARITY_LOW, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_LATCHED_CLR, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_EN_SET, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_EN_CLR, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_LATCHED_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_PENDING_STS, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_MID_SEL, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_PRIORITY, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_EN, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_VAL, 0x20},
	{MSM89XX_PMIC_ANALOG_MICB_1_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MICB_1_INT_RBIAS, 0x49},
	{MSM89XX_PMIC_ANALOG_MICB_2_EN, 0x20},
	{MSM89XX_PMIC_ANALOG_TX_1_2_ATEST_CTL_2, 0x00},
	{MSM89XX_PMIC_ANALOG_MASTER_BIAS_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_DET_CTL_1, 0x35},
	{MSM89XX_PMIC_ANALOG_MBHC_DET_CTL_2, 0x08},
	{MSM89XX_PMIC_ANALOG_MBHC_FSM_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_DBNC_TIMER, 0x98},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN0_ZDETL_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN1_ZDETM_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN2_ZDETH_CTL, 0x40},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN3_CTL, 0x61},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN4_CTL, 0x80},
	{MSM89XX_PMIC_ANALOG_MBHC_BTN_RESULT, 0x00},
	{MSM89XX_PMIC_ANALOG_MBHC_ZDET_ELECT_RESULT, 0x00},
	{MSM89XX_PMIC_ANALOG_TX_1_EN, 0x03},
	{MSM89XX_PMIC_ANALOG_TX_2_EN, 0x03},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TEST_CTL_1, 0xBF},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TEST_CTL_2, 0x8C},
	{MSM89XX_PMIC_ANALOG_TX_1_2_ATEST_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_TX_1_2_OPAMP_BIAS, 0x6B},
	{MSM89XX_PMIC_ANALOG_TX_1_2_TXFE_CLKDIV, 0x51},
	{MSM89XX_PMIC_ANALOG_TX_3_EN, 0x02},
	{MSM89XX_PMIC_ANALOG_NCP_EN, 0x26},
	{MSM89XX_PMIC_ANALOG_NCP_CLK, 0x23},
	{MSM89XX_PMIC_ANALOG_NCP_DEGLITCH, 0x5B},
	{MSM89XX_PMIC_ANALOG_NCP_FBCTRL, 0x08},
	{MSM89XX_PMIC_ANALOG_NCP_BIAS, 0x29},
	{MSM89XX_PMIC_ANALOG_NCP_VCTRL, 0x24},
	{MSM89XX_PMIC_ANALOG_NCP_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_NCP_CLIM_ADDR, 0xD5},
	{MSM89XX_PMIC_ANALOG_RX_CLOCK_DIVIDER, 0xE8},
	{MSM89XX_PMIC_ANALOG_RX_COM_OCP_CTL, 0xCF},
	{MSM89XX_PMIC_ANALOG_RX_COM_OCP_COUNT, 0x6E},
	{MSM89XX_PMIC_ANALOG_RX_COM_BIAS_DAC, 0x18},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_PA, 0x5A},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_LDO_OCP, 0x69},
	{MSM89XX_PMIC_ANALOG_RX_HPH_BIAS_CNP, 0x29},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_EN, 0x80},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_WG_CTL, 0xDA},
	{MSM89XX_PMIC_ANALOG_RX_HPH_CNP_WG_TIME, 0x16},
	{MSM89XX_PMIC_ANALOG_RX_HPH_L_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_L_PA_DAC_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_RX_HPH_R_TEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_R_PA_DAC_CTL, 0x20},
	{MSM89XX_PMIC_ANALOG_RX_EAR_CTL, 0x12},
	{MSM89XX_PMIC_ANALOG_RX_ATEST, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_HPH_STATUS, 0x0C},
	{MSM89XX_PMIC_ANALOG_RX_EAR_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_LO_DAC_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_RX_LO_EN_CTL, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_DAC_CTL, 0x83},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_CLIP_DET, 0x91},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_CTL, 0x29},
	{MSM89XX_PMIC_ANALOG_SPKR_ANA_BIAS_SET, 0x4D},
	{MSM89XX_PMIC_ANALOG_SPKR_OCP_CTL, 0xE1},
	{MSM89XX_PMIC_ANALOG_SPKR_PWRSTG_CTL, 0x1E},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_MISC, 0xCB},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_DBG, 0x00},
	{MSM89XX_PMIC_ANALOG_CURRENT_LIMIT, 0x02},
	{MSM89XX_PMIC_ANALOG_OUTPUT_VOLTAGE, 0x14},
	{MSM89XX_PMIC_ANALOG_BYPASS_MODE, 0x00},
	{MSM89XX_PMIC_ANALOG_BOOST_EN_CTL, 0x1F},
	{MSM89XX_PMIC_ANALOG_SLOPE_COMP_IP_ZERO, 0x8C},
	{MSM89XX_PMIC_ANALOG_RDSON_MAX_DUTY_CYCLE, 0xC0},
	{MSM89XX_PMIC_ANALOG_BOOST_TEST1_1, 0x00},
	{MSM89XX_PMIC_ANALOG_BOOST_TEST_2, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_SAR_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_SPKR_DRV_STATUS, 0x00},
	{MSM89XX_PMIC_ANALOG_PBUS_ADD_CSR, 0x00},
	{MSM89XX_PMIC_ANALOG_PBUS_ADD_SEL, 0x00},
	{MSM89XX_PMIC_ANALOG_SEC_ACCESS, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL1, 0x00},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL2, 0x01},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL3, 0x05},
	{MSM89XX_PMIC_ANALOG_PERPH_RESET_CTL4, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_TEST1, 0x00},
	{MSM89XX_PMIC_ANALOG_INT_TEST_VAL, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_NUM, 0x04},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL1, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL2, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL3, 0x00},
	{MSM89XX_PMIC_ANALOG_TRIM_CTRL4, 0x00},
};

static const u8 msm89xx_cdc_core_reg_readable[MSM89XX_CDC_CORE_CACHE_SIZE] = {
		[MSM89XX_CDC_CORE_CLK_RX_RESET_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_MCLK_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_PDM_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_SD_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX2_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_TOP_GAIN_UPDATE] = 1,
		[MSM89XX_CDC_CORE_TOP_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_SHUT_DOWN_STATUS] = 1,
		[MSM89XX_CDC_CORE_COMP0_FS_CFG] = 1,
		[MSM89XX_CDC_CORE_COMP0_DELAY_BUF_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER1_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER2_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX1_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX5_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_DMIC_CTL] = 1,
};

static const u8 msm89xx_cdc_core_reg_writeable[MSM89XX_CDC_CORE_CACHE_SIZE] = {
		[MSM89XX_CDC_CORE_CLK_RX_RESET_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_MCLK_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_PDM_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_SD_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX2_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_TOP_GAIN_UPDATE] = 1,
		[MSM89XX_CDC_CORE_TOP_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_COMP0_FS_CFG] = 1,
		[MSM89XX_CDC_CORE_COMP0_DELAY_BUF_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER1_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER2_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX1_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX5_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX5_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX5_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_DMIC_CTL] = 1,
};

bool msm89xx_cdc_core_readable_reg(struct device *dev, unsigned int reg)
{
	return msm89xx_cdc_core_reg_readable[reg];
}

bool msm89xx_cdc_core_writeable_reg(struct device *dev, unsigned int reg)
{
	return msm89xx_cdc_core_reg_writeable[reg];
}

bool msm89xx_cdc_core_volatile_reg(struct device *dev, unsigned int reg)
{
	switch (reg) {
	case MSM89XX_CDC_CORE_RX1_B1_CTL:
	case MSM89XX_CDC_CORE_RX2_B1_CTL:
	case MSM89XX_CDC_CORE_RX3_B1_CTL:
	case MSM89XX_CDC_CORE_RX1_B6_CTL:
	case MSM89XX_CDC_CORE_RX2_B6_CTL:
	case MSM89XX_CDC_CORE_RX3_B6_CTL:
	case MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX5_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL:
	case MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL:
	case MSM89XX_CDC_CORE_CLK_MCLK_CTL:
	case MSM89XX_CDC_CORE_CLK_PDM_CTL:
		return true;
	default:
		return false;
	}
}
