/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.poll;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.poll.Poll;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class PollRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Poll poll = (Poll)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(poll.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)poll);
            if (poll.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            poll.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Poll poll = (Poll)component;
        String clientId = poll.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)poll);
        if (form == null) {
            throw new FacesException("Poll:" + clientId + " needs to be enclosed in a form component");
        }
        AjaxRequestBuilder builder = RequestContext.getCurrentInstance().getAjaxRequestBuilder();
        String request = builder.init().source(clientId).form(form.getClientId(context)).process(component, poll.getProcess()).update(component, poll.getUpdate()).async(poll.isAsync()).global(poll.isGlobal()).partialSubmit(poll.isPartialSubmit(), poll.isPartialSubmitSet()).resetValues(poll.isResetValues(), poll.isResetValuesSet()).ignoreAutoUpdate(poll.isIgnoreAutoUpdate()).onstart(poll.getOnstart()).onerror(poll.getOnerror()).onsuccess(poll.getOnsuccess()).oncomplete(poll.getOncomplete()).params((UIComponent)poll).build();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Poll", poll.resolveWidgetVar(), clientId).attr("frequency", poll.getInterval()).attr("autoStart", poll.isAutoStart()).callback("fn", "function()", request);
        wb.finish();
    }
}

