/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.model.SortMeta;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DataTableRenderer
extends DataRenderer {
    private static final Logger logger = Logger.getLogger(DataTableRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        for (DataTableFeature feature : DataTable.FEATURES.values()) {
            if (!feature.shouldDecode(context, table)) continue;
            feature.decode(context, table);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.shouldEncodeFeature(context)) {
            for (DataTableFeature feature : DataTable.FEATURES.values()) {
                if (!feature.shouldEncode(context, table)) continue;
                feature.encode(context, this, table);
            }
        } else {
            this.preEncode(context, table);
            this.encodeMarkup(context, table);
            this.encodeScript(context, table);
        }
    }

    protected void preEncode(FacesContext context, DataTable table) {
        Columns dynamicCols;
        if (table.isLazy()) {
            if (table.isLiveScroll()) {
                table.loadLazyScrollData(0, table.getScrollRows());
            } else {
                table.loadLazyData();
            }
        }
        if (table.getSortBy() != null && !table.isLazy()) {
            SortFeature sortFeature = (SortFeature)table.getFeature(DataTableFeatureKey.SORT);
            if (table.isMultiSort()) {
                sortFeature.multiSort(context, table);
            } else {
                sortFeature.singleSort(context, table);
            }
        }
        if (table.isPaginator()) {
            table.calculateFirst();
        }
        if ((dynamicCols = table.getDynamicColumns()) != null) {
            dynamicCols.setRowIndex(-1);
        }
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        String clientId = table.getClientId(context);
        String selectionMode = table.resolveSelectionMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("DataTable", table.resolveWidgetVar(), clientId);
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table, wb);
        }
        wb.attr("selectionMode", selectionMode, null);
        wb.attr("rowSelectMode", table.getRowSelectMode(), "new");
        if (table.isFilteringEnabled()) {
            wb.attr("filter", true).attr("filterEvent", table.getFilterEvent(), null).attr("filterDelay", table.getFilterDelay(), Integer.MAX_VALUE);
        }
        if (table.getRowExpansion() != null) {
            wb.attr("expansion", true);
        }
        if (table.isScrollable()) {
            wb.attr("scrollable", true).attr("liveScroll", table.isLiveScroll()).attr("scrollStep", table.getScrollRows()).attr("scrollLimit", table.getRowCount()).attr("scrollWidth", table.getScrollWidth(), null).attr("scrollHeight", table.getScrollHeight(), null);
        }
        wb.attr("resizableColumns", table.isResizableColumns(), false).attr("liveResize", table.isLiveResize(), false).attr("draggableColumns", table.isDraggableColumns(), false);
        if (table.isEditable()) {
            wb.attr("editable", true).attr("editMode", table.getEditMode()).attr("cellSeparator", table.getCellSeparator(), null);
        }
        if (table.isMultiSort()) {
            wb.attr("multiSort", true);
        }
        if (table.isStickyHeader()) {
            wb.attr("stickyHeader", true);
        }
        this.encodeClientBehaviors(context, table);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        boolean hasPaginator = table.isPaginator();
        String style = table.getStyle();
        String paginatorPosition = table.getPaginatorPosition();
        String containerClass = scrollable ? "ui-datatable ui-widget ui-datatable-scrollable" : "ui-datatable ui-widget";
        String string = containerClass = table.getStyleClass() != null ? containerClass + " " + table.getStyleClass() : containerClass;
        if (table.isResizableColumns()) {
            containerClass = containerClass + " " + "ui-datatable-resizable";
        }
        if (table.isStickyHeader()) {
            containerClass = containerClass + " " + "ui-datatable-sticky";
        }
        if (ComponentUtils.isRTL(context, table)) {
            containerClass = containerClass + " " + "ui-datatable-rtl";
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-top");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bottom");
        if (table.isSelectionEnabled()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_selection", table.getSelectedRowKeysAsString());
        }
        if (table.isDraggableColumns()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_columnOrder", null);
        }
        if (scrollable) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_scrollState", table.getScrollState());
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-tablewrapper", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (table.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)table.getTableStyle(), null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)table.getTableStyleClass(), null);
        }
        if (table.getSummary() != null) {
            writer.writeAttribute("summary", (Object)table.getSummary(), null);
        }
        this.encodeThead(context, table);
        this.encodeTFoot(context, table);
        this.encodeTbody(context, table, false);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        String tableStyle = table.getTableStyle();
        String tableStyleClass = table.getTableStyleClass();
        this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
        this.encodeThead(context, table);
        this.encodeScrollAreaEnd(context);
        this.encodeScrollBody(context, table, tableStyle, tableStyleClass);
        this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
        this.encodeTFoot(context, table);
        this.encodeScrollAreaEnd(context);
    }

    protected void encodeScrollAreaStart(FacesContext context, DataTable table, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScrollBody(FacesContext context, DataTable table, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = table.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        if (scrollHeight != null && scrollHeight.indexOf("%") == -1) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeColGroup(context, table);
        this.encodeTbody(context, table, false);
        writer.endElement("table");
        writer.endElement("div");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encodeColumnHeader(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getContainerClientId(context);
        Object tableSortBy = table.getSortBy();
        Object columnSortBy = column.getSortBy();
        boolean isSortable = columnSortBy != null;
        boolean hasFilter = column.getFilterBy() != null;
        String selectionMode = column.getSelectionMode();
        String sortIcon = null;
        boolean resizable = table.isResizableColumns() && column.isResizable();
        String columnClass = isSortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        columnClass = hasFilter ? columnClass + " " + "ui-filter-column" : columnClass;
        columnClass = selectionMode != null ? columnClass + " " + "ui-selection-column" : columnClass;
        columnClass = resizable ? columnClass + " " + "ui-resizable-column" : columnClass;
        String string = columnClass = column.getStyleClass() != null ? columnClass + " " + column.getStyleClass() : columnClass;
        if (isSortable) {
            if (tableSortBy != null) {
                if (table.isMultiSort()) {
                    List<SortMeta> sortMeta = table.getMultiSortMeta();
                    if (sortMeta != null) {
                        SortMeta meta;
                        Iterator<SortMeta> i$ = sortMeta.iterator();
                        while (i$.hasNext() && (sortIcon = this.resolveDefaultSortIcon(columnSortBy, (meta = i$.next()).getColumn().getSortBy(), meta.getSortOrder().name())) == null) {
                        }
                    }
                } else {
                    sortIcon = this.resolveDefaultSortIcon(columnSortBy, tableSortBy, table.getSortOrder());
                }
            }
            if (sortIcon == null) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
            } else {
                columnClass = columnClass + " ui-state-active";
            }
        }
        String style = column.getStyle();
        String width = column.getWidth();
        if (width != null) {
            String unit = width.endsWith("%") ? "" : "px";
            style = style != null ? style + ";width:" + width + unit : "width:" + width + unit;
        }
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        if (hasFilter) {
            table.enableFiltering();
            String filterPosition = column.getFilterPosition();
            if (filterPosition.equals("bottom")) {
                this.encodeColumnHeaderContent(context, column, sortIcon);
                this.encodeFilter(context, table, column);
            } else {
                if (!filterPosition.equals("top")) throw new FacesException(filterPosition + " is an invalid option for filterPosition, valid values are 'bottom' or 'top'.");
                this.encodeFilter(context, table, column);
                this.encodeColumnHeaderContent(context, column, sortIcon);
            }
        } else {
            this.encodeColumnHeaderContent(context, column, sortIcon);
        }
        if (selectionMode != null && selectionMode.equalsIgnoreCase("multiple")) {
            this.encodeCheckbox(context, table, false, false, "ui-chkbox ui-chkbox-all ui-widget");
        }
        writer.endElement("th");
    }

    protected String resolveDefaultSortIcon(Object columnSortBy, Object tableSortBy, String sortOrder) {
        String sortIcon = null;
        if (tableSortBy != null && tableSortBy.equals(columnSortBy)) {
            if (sortOrder.equalsIgnoreCase("ASCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
            } else if (sortOrder.equalsIgnoreCase("DESCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
            }
        }
        return sortIcon;
    }

    protected void encodeColumnHeaderContent(FacesContext context, UIColumn column, String sortIcon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        writer.startElement("span", null);
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (sortIcon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
        }
    }

    protected void encodeFilter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        ValueExpression filterValueVE;
        Map params = context.getExternalContext().getRequestParameterMap();
        ResponseWriter writer = context.getResponseWriter();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        String filterId = column.getContainerClientId(context) + separator + "filter";
        String filterStyleClass = column.getFilterStyleClass();
        String filterValue = null;
        filterValue = table.isReset() ? "" : (params.containsKey(filterId) ? (String)params.get(filterId) : ((filterValueVE = column.getValueExpression("filterValue")) != null ? (String)filterValueVE.getValue(context.getELContext()) : ""));
        if (column.getValueExpression("filterOptions") == null) {
            filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" : "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all " + filterStyleClass;
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("value", (Object)filterValue, null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            if (column.getFilterMaxLength() != Integer.MAX_VALUE) {
                writer.writeAttribute("maxlength", (Object)column.getFilterMaxLength(), null);
            }
            writer.endElement("input");
        } else {
            SelectItem[] itemsArray;
            filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-widget ui-state-default ui-corner-left" : "ui-column-filter ui-widget ui-state-default ui-corner-left " + filterStyleClass;
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            for (SelectItem item : itemsArray = this.getFilterOptions(column)) {
                Object itemValue = item.getValue();
                writer.startElement("option", null);
                writer.writeAttribute("value", item.getValue(), null);
                if (itemValue != null && String.valueOf(itemValue).equals(filterValue)) {
                    writer.writeAttribute("selected", (Object)"selected", null);
                }
                writer.writeText((Object)item.getLabel(), null);
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }

    protected SelectItem[] getFilterOptions(UIColumn column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }

    protected void encodeColumnFooter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        styleClass = styleClass == null ? "ui-state-default" : "ui-state-default " + styleClass;
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("td");
    }

    protected void encodeThead(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)(table.getClientId(context) + "_head"), null);
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row headerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    if (!headerRowChild.isRendered() || !(headerRowChild instanceof Column)) continue;
                    this.encodeColumnHeader(context, table, (Column)headerRowChild);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("role", (Object)"row", null);
            for (UIColumn column : table.getColumns()) {
                if (column instanceof Column) {
                    this.encodeColumnHeader(context, table, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnHeader(context, table, dynamicColumn);
            }
            writer.endElement("tr");
        }
        this.encodeFrozenRows(context, table);
        writer.endElement("thead");
    }

    public void encodeColGroup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("colgroup", null);
        for (UIColumn column : table.getColumns()) {
            if (!column.isRendered()) continue;
            writer.startElement("col", null);
            writer.endElement("col");
        }
        writer.endElement("colgroup");
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly) throws IOException {
        boolean hasData;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String emptyMessage = table.getEmptyMessage();
        UIComponent emptyFacet = table.getFacet("emptyMessage");
        SubTable subTable = table.getSubTable();
        if (table.isSelectionEnabled()) {
            table.findSelectedRowKeys();
        }
        int rows = table.getRows();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? (table.isLiveScroll() ? table.getScrollRows() : rowCount) : rows;
        boolean bl = hasData = rowCount > 0;
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
        }
        if (hasData) {
            if (subTable != null) {
                this.encodeSubTable(context, table, subTable, first, first + rowCountToRender);
            } else {
                this.encodeRows(context, table, first, first + rowCountToRender);
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-datatable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
            if (emptyFacet != null) {
                emptyFacet.encodeAll(context);
            } else {
                writer.write(emptyMessage);
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!dataOnly) {
            writer.endElement("tbody");
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    protected void encodeRows(FacesContext context, DataTable table, int first, int last) throws IOException {
        String clientId = table.getClientId(context);
        SummaryRow summaryRow = table.getSummaryRow();
        ELContext eLContext = context.getELContext();
        ValueExpression groupByVe = table.getSortBy() == null ? null : context.getApplication().getExpressionFactory().createValueExpression(eLContext, "#{" + table.getVar() + "." + table.getSortBy() + "}", Object.class);
        boolean encodeSummaryRow = summaryRow != null && groupByVe != null;
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            this.encodeRow(context, table, clientId, i);
            if (!encodeSummaryRow || this.isInSameGroup(context, table, i, groupByVe, eLContext)) continue;
            table.setRowIndex(i);
            this.encodeSummaryRow(context, table, summaryRow);
        }
    }

    protected void encodeFrozenRows(FacesContext context, DataTable table) throws IOException {
        Collection frozenRows = table.getFrozenRows();
        if (frozenRows == null || frozenRows.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String var = table.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
        int index = 0;
        Iterator it = frozenRows.iterator();
        while (it.hasNext()) {
            requestMap.put(var, it.next());
            this.encodeRow(context, table, clientId, index);
        }
        writer.endElement("tbody");
    }

    protected void encodeSummaryRow(FacesContext context, DataTable table, SummaryRow summaryRow) throws IOException {
        MethodExpression me = summaryRow.getListener();
        if (me != null) {
            me.invoke(context.getELContext(), new Object[]{table.getSortBy()});
        }
        summaryRow.encodeAll(context);
    }

    public boolean encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex) throws IOException {
        String rowStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = table.isSelectionEnabled();
        Object rowKey = null;
        if (selectionEnabled && (rowKey = table.getRowKey()) == null) {
            rowKey = table.getRowKeyFromModel(table.getRowData());
        }
        boolean selected = table.getSelectedRowKeys().contains(rowKey);
        String userRowStyleClass = table.getRowStyleClass();
        String string = rowStyleClass = rowIndex % 2 == 0 ? "ui-widget-content ui-datatable-even" : "ui-widget-content ui-datatable-odd";
        if (selectionEnabled && !table.isDisabledSelection()) {
            rowStyleClass = rowStyleClass + " " + "ui-datatable-selectable";
        }
        if (selected) {
            rowStyleClass = rowStyleClass + " ui-state-highlight";
        }
        if (table.isEditingRow()) {
            rowStyleClass = rowStyleClass + " " + "ui-row-editing";
        }
        if (userRowStyleClass != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        writer.startElement("tr", null);
        writer.writeAttribute("data-ri", (Object)rowIndex, null);
        if (rowKey != null) {
            writer.writeAttribute("data-rk", rowKey, null);
        }
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        for (UIColumn column : table.getColumns()) {
            if (column instanceof Column) {
                this.encodeCell(context, table, column, clientId, selected);
                continue;
            }
            if (!(column instanceof DynamicColumn)) continue;
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyModel();
            this.encodeCell(context, table, dynamicColumn, null, false);
        }
        writer.endElement("tr");
        if (table.isExpandedRow()) {
            ((RowExpandFeature)table.getFeature(DataTableFeatureKey.ROW_EXPAND)).encodeExpansion(context, this, table, rowIndex, false);
        }
        return true;
    }

    protected void encodeCell(FacesContext context, DataTable table, UIColumn column, String clientId, boolean selected) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = column.getSelectionMode() != null;
        String style = column.getStyle();
        String styleClass = selectionEnabled ? "ui-selection-column" : (column.getCellEditor() != null ? "ui-editable-column" : null);
        String userStyleClass = column.getStyleClass();
        styleClass = userStyleClass == null ? styleClass : (styleClass == null ? userStyleClass : styleClass + " " + userStyleClass);
        writer.startElement("td", null);
        writer.writeAttribute("role", (Object)"gridcell", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (selectionEnabled) {
            this.encodeColumnSelection(context, table, clientId, column, selected);
        } else {
            column.encodeAll(context);
        }
        writer.endElement("td");
    }

    protected void encodeTFoot(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("footer");
        writer.startElement("tfoot", null);
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent footerRowChild : footerRow.getChildren()) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    this.encodeColumnFooter(context, table, (Column)footerRowChild);
                }
                writer.endElement("tr");
            }
        } else if (table.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (UIColumn column : table.getColumns()) {
                if (column instanceof Column) {
                    this.encodeColumnFooter(context, table, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnFooter(context, table, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeStateHolder(FacesContext context, DataTable table, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeColumnSelection(FacesContext context, DataTable table, String clientId, UIColumn column, boolean selected) throws IOException {
        String selectionMode = column.getSelectionMode();
        boolean disabled = table.isDisabledSelection();
        if (selectionMode.equalsIgnoreCase("single")) {
            this.encodeRadio(context, table, selected, disabled);
        } else if (selectionMode.equalsIgnoreCase("multiple")) {
            this.encodeCheckbox(context, table, selected, disabled, "ui-chkbox ui-widget");
        } else {
            throw new FacesException("Invalid column selection mode:" + selectionMode);
        }
    }

    protected void encodeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-state-default";
        String iconClass = "ui-radiobutton-icon";
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = checked ? boxClass + " ui-state-active" : boxClass;
        iconClass = checked ? iconClass + " " + "ui-icon ui-icon-bullet" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-radiobutton ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_radio"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        String iconClass = "ui-chkbox-icon ui-c";
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = checked ? boxClass + " ui-state-active" : boxClass;
        iconClass = checked ? iconClass + " " + "ui-chkbox-icon ui-icon ui-icon-check ui-c" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_checkbox"), null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSubTable(FacesContext context, DataTable table, SubTable subTable, int first, int last) throws IOException {
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            subTable.encodeAll(context);
        }
    }

    boolean isInSameGroup(FacesContext context, DataTable table, int currentRowIndex, ValueExpression groupByVE, ELContext eLContext) {
        table.setRowIndex(currentRowIndex);
        Object currentGroupByData = groupByVE.getValue(eLContext);
        table.setRowIndex(currentRowIndex + 1);
        if (!table.isRowAvailable()) {
            return false;
        }
        Object nextGroupByData = groupByVE.getValue(eLContext);
        return currentGroupByData != null && nextGroupByData.equals(currentGroupByData);
    }
}

