<?php

 add_action( 'init', 'create_wpvideoslidepage' );
	function create_wpvideoslidepage() {
		register_post_type( 'slidepage',
			array(
				'labels' => array(
					'name' => __( 'Slide Page' ),
					'singular_name' => __( 'Slide Page' )
				),
			'public' => true,
			'has_archive' => true,
			'menu_icon' => 'http://cdn3.iconfinder.com/data/icons/uidesignicons/video.png',
			'rewrite' => true
			)
		);
		flush_rewrite_rules( );
	}

 
add_action( 'add_meta_boxes', 'settings_wpvideoslidepage' );
function settings_wpvideoslidepage()
{
	add_meta_box( 'slidepage', 'Auto-Responder:', 'create_options_wpvideoslidepage', 'slidepage', 'normal', 'low' );
}


function create_options_wpvideoslidepage( $post )
{
	$values = get_post_custom( $post->ID );
	$autoresponder = isset( $values['autoresponder'] ) ? esc_attr( $values['autoresponder'][0] ) : '';
	$videoid = isset( $values['videoid'] ) ? esc_attr( $values['videoid'][0] ) : '';

	$optinheadline = isset( $values['optinheadline'] ) ? esc_attr( $values['optinheadline'][0] ) : '';
	$optinsubheadline = isset( $values['optinsubheadline'] ) ? esc_attr( $values['optinsubheadline'][0] ) : '';
	$optinspam = isset( $values['optinspam'] ) ? esc_attr( $values['optinspam'][0] ) : '';

	$signupbutton = isset( $values['signupbutton'] ) ? esc_attr( $values['signupbutton'][0] ) : '';
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
?>
		

		<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function() {

		  		

			});
		</script>
		<style>
			@import url(http://fonts.googleapis.com/css?family=Poly);
			#siteOptions {
				width: 100%;
				overflow: hidden;
				font-family: 'Poly', serif;
				text-shadow: 0px 0px 1px transparent; 
				font-size: 21px;
				padding-top: 30px;
			}
			
			
			input[type=text] {
				display: block;
				width: 100%;
				font-size: 16px;
				padding: 6px;
				margin: 5px 0;
				color: #666;
			}
			textarea {
				display: block;
				width: 100%;
				height: 150px;
				font-size: 14px;
				padding: 6px;
				margin: 5px 0;
				color: #666;
			}
			select {
				display: block;
				width: 100%;
				font-size: 16px;
				padding: 6px;
				margin: 5px 0;
				color: #666;
			}
			#siteOptions strong {
				padding: 0 0;
				margin-bottom: -10px;
				display: block;
				font-weight:  normal;
				font-size: 14px;
			}
			#siteOptions p {
				font-size: 12px;
				line-height: 21px;
			}
			#siteOptions h4 {
				font-size: 21px;
				line-height: 21px;
				margin: 0;
			}
			
			#siteOptions hr {
				border: none;
				border-bottom: 1px solid #ddd;
				margin-bottom: 20px;
			}
		</style>

		<div id="siteOptions"> 
			<a name="tops"></a>
			<img src="http://cdn1.iconfinder.com/data/icons/CrystalClear/32x32/apps/email.png" style="float: left; margin-right: 20px; margin-bottom: 40px">
			<h4>Video &amp; Auto-Responder Settings</h4>
			<p>Add the YouTube video ID (ex. ) to auto-play the video and trigger events to happen. Paste your Auto-Responder HTML Form code for the pop-out form.</p>   
			<br clear="all" />

			<strong>YouTube Video ID: <small>(ex. 28903)</small></strong><br />
			<input type="text" name="videoid" id="videoid" value="<?php echo $videoid; ?>" /><br>
			<strong>Optin Headline</strong><br />
			<input type="text" name="optinheadline" id="optinheadline" value="<?php echo $optinheadline; ?>" /><br>

			<strong>Optin Sub Headline</strong><br />
			<input type="text" name="optinsubheadline" id="optinsubheadline" value="<?php echo $optinsubheadline; ?>" /><br>

			<strong>Optin Spam Text</strong><br />
			<input type="text" name="optinspam" id="optinspam" value="<?php echo $optinspam; ?>" /><br>

			<strong>Signup Button Text</strong><br />
			<input type="text" name="signupbutton" id="signupbutton" value="<?php echo $signupbutton; ?>" /><br>
			<strong>Your Autoresponder Form HTML Code:</strong><br />
			<textarea name="autoresponder" id="autoresponder"><?php echo $autoresponder; ?></textarea><br>
				                
			<br clear="all" />
		</div>
			

	<?php	
}


add_action( 'save_post', 'save_wpvideoslidepage' );

function save_wpvideoslidepage( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post' ) ) return;
	
	$allowed = array( 
		'a' => array(
			'href' => array() 
		)
	);
	
	
	if( isset( $_POST['autoresponder'] ) )
		update_post_meta( $post_id, 'autoresponder', esc_attr( $_POST['autoresponder'] ) );
	if( isset( $_POST['videoid'] ) )
		update_post_meta( $post_id, 'videoid', esc_attr( $_POST['videoid'] ) );

	if( isset( $_POST['optinspam'] ) )
		update_post_meta( $post_id, 'optinspam', esc_attr( $_POST['optinspam'] ) );
	if( isset( $_POST['optinsubheadline'] ) )
		update_post_meta( $post_id, 'optinsubheadline', esc_attr( $_POST['optinsubheadline'] ) );
	if( isset( $_POST['optinheadline'] ) )
		update_post_meta( $post_id, 'optinheadline', esc_attr( $_POST['optinheadline'] ) );

	if( isset( $_POST['signupbutton'] ) )
		update_post_meta( $post_id, 'signupbutton', esc_attr( $_POST['signupbutton'] ) );
	
}
?>

<!-- Main Settings -->

<?php
add_action( 'add_meta_boxes', 'settings_wpvideoslidepage_mainsettings' );
function settings_wpvideoslidepage_mainsettings()
{
	add_meta_box( 'mainsettings', 'Main Settings:', 'create_options_wpvideoslidepage_mainsettings', 'slidepage', 'normal', 'high' );
}


function create_options_wpvideoslidepage_mainsettings( $post )
{
	$values = get_post_custom( $post->ID );
	$headline = isset( $values['headline'] ) ? esc_attr( $values['headline'][0] ) : '';
	$subheadline = isset( $values['subheadline'] ) ? esc_attr( $values['subheadline'][0] ) : '';
	$footer = isset( $values['footer'] ) ? esc_attr( $values['footer'][0] ) : '';

	$css = isset( $values['css'] ) ? esc_attr( $values['css'][0] ) : '';

	
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
?>
		

		<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function() {

		  		

			});
		</script>
		<div id="siteOptions"> 
			<a name="tops"></a>
			<img src="http://cdn1.iconfinder.com/data/icons/Koloria-Icon-Set/32/File_Content.png" style="float: left; margin-right: 20px; margin-bottom: 40px">
			<h4>Headline Settings</h4>
			<p>Change the main headline and content for your slide reveal page...</p>   
			<br clear="all" />

			<strong>Headline:</strong><br />
			<input type="text" name="headline" id="headline" value="<?php echo $headline; ?>" /><br>

			<strong>Sub Headline</strong><br />
			<input type="text" name="subheadline" id="subheadline" value="<?php echo $subheadline; ?>" /><br>

			<strong>Footer Content</strong><br />
			<input type="text" name="footer" id="footer" value="<?php echo $footer; ?>" /><br>
				                
			<br clear="all" />

			<strong>Custom CSS Styles:</strong><br />
			<textarea name="css" id="css"><?php echo $css; ?></textarea><br>

			
				                
			<br clear="all" />
				                
		</div>
			

	<?php	
}


add_action( 'save_post', 'save_wpvideoslidepage_mainsettings' );

function save_wpvideoslidepage_mainsettings( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post' ) ) return;
	
	$allowed = array( 
		'a' => array(
			'href' => array() 
		)
	);
	
	
	if( isset( $_POST['headline'] ) )
		update_post_meta( $post_id, 'headline', esc_attr( $_POST['headline'] ) );
	if( isset( $_POST['subheadline'] ) )
		update_post_meta( $post_id, 'subheadline', esc_attr( $_POST['subheadline'] ) );
	if( isset( $_POST['footer'] ) )
		update_post_meta( $post_id, 'footer', esc_attr( $_POST['footer'] ) );
	if( isset( $_POST['css'] ) )
		update_post_meta( $post_id, 'css', esc_attr( $_POST['css'] ) );

	
	
}
?>

























<!-- Timer Settings -->

<?php


add_action( 'add_meta_boxes', 'settings_wpvideoslidepage_timer' );
function settings_wpvideoslidepage_timer()
{
	add_meta_box( 'side_timer', 'Timer Settings:', 'create_options_wpvideoslidepage_timer', 'slidepage', 'side', 'low' );
}


function create_options_wpvideoslidepage_timer( $post )
{
	$values = get_post_custom( $post->ID );
	$optin_timer = isset( $values['optin_timer'] ) ? esc_attr( $values['optin_timer'][0] ) : '';
	$content_timer = isset( $values['content_timer'] ) ? esc_attr( $values['content_timer'][0] ) : '';
	$headline_timer = isset( $values['headline_timer'] ) ? esc_attr( $values['headline_timer'][0] ) : '';
	$new_headline = isset( $values['new_headline'] ) ? esc_attr( $values['new_headline'][0] ) : '';
	$icon_timer = isset( $values['icon_timer'] ) ? esc_attr( $values['icon_timer'][0] ) : '';
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
?>
		

		<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function() {

		  		

			});
		</script>

		<div id="siteOptions"> 
			<a name="tops"></a>
			<img src="http://cdn5.iconfinder.com/data/icons/free-business-desktop-icons/32/Time.png" style="float: left; margin-right: 20px; margin-bottom: 40px">
			<h4>Time-Stamp Settings</h4>
			<p>Choose the timestamp for different events to fire. <small style="letter-spacing: 1px;">( minutes : seconds )</small></p>   
			<br clear="all" />

			<strong>Show Optin Form:</strong><br />
			<input type="text" placeholder="00:00" name="optin_timer" id="optin_timer" value="<?php echo $optin_timer; ?>" /><br>

			<strong>Show Content Time:</strong><br />
			<input type="text" placeholder="00:00" name="content_timer" id="content_timer" value="<?php echo $content_timer; ?>" /><br>

			<strong>Change Headline Time:</strong><br />
			<input type="text" placeholder="00:00" name="headline_timer" id="headline_timer" value="<?php echo $headline_timer; ?>" /><br>

			<strong>New Headline Text:</strong><br />
			<input type="text" placeholder="New Headline Here..." name="new_headline" id="new_headline" value="<?php echo $new_headline; ?>" /><br>

			<strong>Show Arrow Icon Time:</strong><br />
			<input type="text" placeholder="00:00" name="icon_timer" id="icon_timer" value="<?php echo $icon_timer; ?>" /><br>
				                
			<br clear="all" />
		</div>
			

	<?php	
}


add_action( 'save_post', 'save_wpvideoslidepage_timer' );

function save_wpvideoslidepage_timer( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post' ) ) return;
	
	$allowed = array( 
		'a' => array(
			'href' => array() 
		)
	);
	
	
	if( isset( $_POST['optin_timer'] ) )
		update_post_meta( $post_id, 'optin_timer', esc_attr( $_POST['optin_timer'] ) );
	if( isset( $_POST['icon_timer'] ) )
		update_post_meta( $post_id, 'icon_timer', esc_attr( $_POST['icon_timer'] ) );
	if( isset( $_POST['new_headline'] ) )
		update_post_meta( $post_id, 'new_headline', esc_attr( $_POST['new_headline'] ) );
	if( isset( $_POST['content_timer'] ) )
		update_post_meta( $post_id, 'content_timer', esc_attr( $_POST['content_timer'] ) );
	if( isset( $_POST['headline_timer'] ) )
		update_post_meta( $post_id, 'headline_timer', esc_attr( $_POST['headline_timer'] ) );
	
}
?>



<!-- Timer Settings -->

<?php


add_action( 'add_meta_boxes', 'settings_wpvideoslidepage_info' );
function settings_wpvideoslidepage_info()
{
	add_meta_box( 'side_info', 'Timer Settings:', 'create_options_wpvideoslidepage_info', 'slidepage', 'side', 'high' );
}


function create_options_wpvideoslidepage_info( $post )
{
	$values = get_post_custom( $post->ID );
	$autoresponder = isset( $values['autoresponder'] ) ? esc_attr( $values['autoresponder'][0] ) : '';
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
?>
		

		<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function() {

		  		

			});
		</script>

			<img src="<?php echo bloginfo('wpurl'); ?>/wp-content/plugins/videoslidepage/functions/images/logo.png" alt="">
		
			

	<?php	
}


add_action( 'save_post', 'save_wpvideoslidepage_info' );

function save_wpvideoslidepage_info( $post_id )
{
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post' ) ) return;
	
	$allowed = array( 
		'a' => array(
			'href' => array() 
		)
	);
	
	
	if( isset( $_POST['autoresponder'] ) )
		update_post_meta( $post_id, 'autoresponder', esc_attr( $_POST['autoresponder'] ) );
	
}
?>