(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2019 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   3.14.0-canary+9ae862a8
 */

/*globals process */
let define, require, Ember;

// Used in @ember/-internals/environment/lib/global.js
mainContext = this; // eslint-disable-line no-undef

(function() {
  let registry;
  let seen;

  function missingModule(name, referrerName) {
    if (referrerName) {
      throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
    } else {
      throw new Error('Could not find module ' + name);
    }
  }

  function internalRequire(_name, referrerName) {
    let name = _name;
    let mod = registry[name];

    if (!mod) {
      name = name + '/index';
      mod = registry[name];
    }

    let exports = seen[name];

    if (exports !== undefined) {
      return exports;
    }

    exports = seen[name] = {};

    if (!mod) {
      missingModule(_name, referrerName);
    }

    let deps = mod.deps;
    let callback = mod.callback;
    let reified = new Array(deps.length);

    for (let i = 0; i < deps.length; i++) {
      if (deps[i] === 'exports') {
        reified[i] = exports;
      } else if (deps[i] === 'require') {
        reified[i] = require;
      } else {
        reified[i] = internalRequire(deps[i], name);
      }
    }

    callback.apply(this, reified);

    return exports;
  }

  let isNode =
    typeof window === 'undefined' &&
    typeof process !== 'undefined' &&
    {}.toString.call(process) === '[object process]';

  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }

  if (typeof Ember === 'undefined') {
    Ember = {};
  }

  if (typeof Ember.__loader === 'undefined') {
    registry = Object.create(null);
    seen = Object.create(null);

    define = function(name, deps, callback) {
      let value = {};

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

      registry[name] = value;
    };

    require = function(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    require['default'] = require;

    require.has = function registryHas(moduleName) {
      return Boolean(registry[moduleName]) || Boolean(registry[moduleName + '/index']);
    };

    require._eak_seen = registry;

    Ember.__loader = {
      define: define,
      require: require,
      registry: registry,
    };
  } else {
    define = Ember.__loader.define;
    require = Ember.__loader.require;
  }
})();

define("@ember/-internals/browser-environment/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.hasDOM = _exports.isFirefox = _exports.isChrome = _exports.userAgent = _exports.history = _exports.location = _exports.window = void 0;
  // check if window exists and actually is the global
  var hasDom = typeof self === 'object' && self !== null && self.Object === Object && typeof Window !== 'undefined' && self.constructor === Window && typeof document === 'object' && document !== null && self.document === document && typeof location === 'object' && location !== null && self.location === location && typeof history === 'object' && history !== null && self.history === history && typeof navigator === 'object' && navigator !== null && self.navigator === navigator && typeof navigator.userAgent === 'string';
  _exports.hasDOM = hasDom;
  var window = hasDom ? self : null;
  _exports.window = window;
  var location$1 = hasDom ? self.location : null;
  _exports.location = location$1;
  var history$1 = hasDom ? self.history : null;
  _exports.history = history$1;
  var userAgent = hasDom ? self.navigator.userAgent : 'Lynx (textmode)';
  _exports.userAgent = userAgent;
  var isChrome = hasDom ? Boolean(window.chrome) && !window.opera : false;
  _exports.isChrome = isChrome;
  var isFirefox = hasDom ? typeof InstallTrigger !== 'undefined' : false;
  _exports.isFirefox = isFirefox;
});
define("@ember/-internals/console/index", ["exports", "@ember/debug", "@ember/deprecated-features"], function (_exports, _debug, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  // Deliver message that the function is deprecated
  var DEPRECATION_MESSAGE = 'Use of Ember.Logger is deprecated. Please use `console` for logging.';
  var DEPRECATION_ID = 'ember-console.deprecate-logger';
  var DEPRECATION_URL = 'https://emberjs.com/deprecations/v3.x#toc_use-console-rather-than-ember-logger';
  /**
     @module ember
  */

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @deprecated Use 'console' instead
  
    @namespace Ember
    @public
  */

  var DEPRECATED_LOGGER;

  if (_deprecatedFeatures.LOGGER) {
    DEPRECATED_LOGGER = {
      /**
      Logs the arguments to the console.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      log() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return console.log(...arguments); // eslint-disable-line no-console
      },

      /**
      Prints the arguments to the console with a warning icon.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      warn() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return console.warn(...arguments); // eslint-disable-line no-console
      },

      /**
      Prints the arguments to the console with an error icon, red text and a stack trace.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      error() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return console.error(...arguments); // eslint-disable-line no-console
      },

      /**
      Logs the arguments to the console.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      info() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return console.info(...arguments); // eslint-disable-line no-console
      },

      /**
      Logs the arguments to the console in blue text.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      debug() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        /* eslint-disable no-console */

        if (console.debug) {
          return console.debug(...arguments);
        }

        return console.info(...arguments);
        /* eslint-enable no-console */
      },

      /**
      If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
      @for Ember.Logger
      @param {Boolean} bool Value to test
      @param {String} message Assertion message on failed
      @public
      */
      assert() {
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return console.assert(...arguments); // eslint-disable-line no-console
      }

    };
  }

  var _default = DEPRECATED_LOGGER;
  _exports.default = _default;
});
define("@ember/-internals/container/index", ["exports", "@ember/-internals/owner", "@ember/-internals/utils", "@ember/debug", "@ember/polyfills"], function (_exports, _owner, _utils, _debug, _polyfills) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.privatize = privatize;
  _exports.FACTORY_FOR = _exports.Container = _exports.Registry = void 0;
  var leakTracking;
  var containers;

  if (true
  /* DEBUG */
  ) {
    // requires v8
    // chrome --js-flags="--allow-natives-syntax --expose-gc"
    // node --allow-natives-syntax --expose-gc
    try {
      if (typeof gc === 'function') {
        leakTracking = (() => {
          // avoid syntax errors when --allow-natives-syntax not present
          var GetWeakSetValues = new Function('weakSet', 'return %GetWeakSetValues(weakSet, 0)');
          containers = new WeakSet();
          return {
            hasContainers() {
              gc();
              return GetWeakSetValues(containers).length > 0;
            },

            reset() {
              var values = GetWeakSetValues(containers);

              for (var i = 0; i < values.length; i++) {
                containers.delete(values[i]);
              }
            }

          };
        })();
      }
    } catch (e) {// ignore
    }
  }
  /**
   A container used to instantiate and cache objects.
  
   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.
  
   The public API for `Container` is still in flux and should not be considered
   stable.
  
   @private
   @class Container
   */


  class Container {
    constructor(registry, options = {}) {
      this.registry = registry;
      this.owner = options.owner || null;
      this.cache = (0, _utils.dictionary)(options.cache || null);
      this.factoryManagerCache = (0, _utils.dictionary)(options.factoryManagerCache || null);
      this.isDestroyed = false;
      this.isDestroying = false;

      if (true
      /* DEBUG */
      ) {
        this.validationCache = (0, _utils.dictionary)(options.validationCache || null);

        if (containers !== undefined) {
          containers.add(this);
        }
      }
    }
    /**
     @private
     @property registry
     @type Registry
     @since 1.11.0
     */

    /**
     @private
     @property cache
     @type InheritingDict
     */

    /**
     @private
     @property validationCache
     @type InheritingDict
     */

    /**
     Given a fullName return a corresponding instance.
      The default behavior is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted, an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @private
     @method lookup
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */


    lookup(fullName, options) {
      (true && !(!this.isDestroyed) && (0, _debug.assert)('expected container not to be destroyed', !this.isDestroyed));
      (true && !(this.registry.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.registry.isValidFullName(fullName)));
      return lookup(this, this.registry.normalize(fullName), options);
    }
    /**
     A depth first traversal, destroying the container, its descendant containers and all
     their managed objects.
      @private
     @method destroy
     */


    destroy() {
      destroyDestroyables(this);
      this.isDestroying = true;
    }

    finalizeDestroy() {
      resetCache(this);
      this.isDestroyed = true;
    }
    /**
     Clear either the entire cache or just the cache for a particular key.
        @private
     @method reset
     @param {String} fullName optional key to reset; if missing, resets everything
    */


    reset(fullName) {
      if (this.isDestroyed) return;

      if (fullName === undefined) {
        destroyDestroyables(this);
        resetCache(this);
      } else {
        resetMember(this, this.registry.normalize(fullName));
      }
    }
    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      @private
     @method ownerInjection
     @returns { Object }
    */


    ownerInjection() {
      return {
        [_owner.OWNER]: this.owner
      };
    }
    /**
     Given a fullName, return the corresponding factory. The consumer of the factory
     is responsible for the destruction of any factory instances, as there is no
     way for the container to ensure instances are destroyed when it itself is
     destroyed.
      @public
     @method factoryFor
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */


    factoryFor(fullName, options = {}) {
      (true && !(!this.isDestroyed) && (0, _debug.assert)('expected container not to be destroyed', !this.isDestroyed));
      var normalizedName = this.registry.normalize(fullName);
      (true && !(this.registry.isValidFullName(normalizedName)) && (0, _debug.assert)('fullName must be a proper full name', this.registry.isValidFullName(normalizedName)));
      (true && !(false
      /* EMBER_MODULE_UNIFICATION */
      || !options.namespace) && (0, _debug.assert)('EMBER_MODULE_UNIFICATION must be enabled to pass a namespace option to factoryFor', false || !options.namespace));

      if (options.source || options.namespace) {
        normalizedName = this.registry.expandLocalLookup(fullName, options);

        if (!normalizedName) {
          return;
        }
      }

      return factoryFor(this, normalizedName, fullName);
    }

  }

  _exports.Container = Container;

  if (true
  /* DEBUG */
  ) {
    Container._leakTracking = leakTracking;
  }
  /*
   * Wrap a factory manager in a proxy which will not permit properties to be
   * set on the manager.
   */


  function wrapManagerInDeprecationProxy(manager) {
    if (_utils.HAS_NATIVE_PROXY) {
      var validator = {
        set(_obj, prop) {
          throw new Error("You attempted to set \"" + prop + "\" on a factory manager created by container#factoryFor. A factory manager is a read-only construct.");
        }

      }; // Note:
      // We have to proxy access to the manager here so that private property
      // access doesn't cause the above errors to occur.

      var m = manager;
      var proxiedManager = {
        class: m.class,

        create(props) {
          return m.create(props);
        }

      };
      var proxy = new Proxy(proxiedManager, validator);
      FACTORY_FOR.set(proxy, manager);
    }

    return manager;
  }

  function isSingleton(container, fullName) {
    return container.registry.getOption(fullName, 'singleton') !== false;
  }

  function isInstantiatable(container, fullName) {
    return container.registry.getOption(fullName, 'instantiate') !== false;
  }

  function lookup(container, fullName, options = {}) {
    (true && !(false
    /* EMBER_MODULE_UNIFICATION */
    || !options.namespace) && (0, _debug.assert)('EMBER_MODULE_UNIFICATION must be enabled to pass a namespace option to lookup', false || !options.namespace));
    var normalizedName = fullName;

    if (options.source || options.namespace) {
      normalizedName = container.registry.expandLocalLookup(fullName, options);

      if (!normalizedName) {
        return;
      }
    }

    if (options.singleton !== false) {
      var cached = container.cache[normalizedName];

      if (cached !== undefined) {
        return cached;
      }
    }

    return instantiateFactory(container, normalizedName, fullName, options);
  }

  function factoryFor(container, normalizedName, fullName) {
    var cached = container.factoryManagerCache[normalizedName];

    if (cached !== undefined) {
      return cached;
    }

    var factory = container.registry.resolve(normalizedName);

    if (factory === undefined) {
      return;
    }

    if (true
    /* DEBUG */
    && factory && typeof factory._onLookup === 'function') {
      factory._onLookup(fullName);
    }

    var manager = new FactoryManager(container, factory, fullName, normalizedName);

    if (true
    /* DEBUG */
    ) {
      manager = wrapManagerInDeprecationProxy(manager);
    }

    container.factoryManagerCache[normalizedName] = manager;
    return manager;
  }

  function isSingletonClass(container, fullName, {
    instantiate,
    singleton
  }) {
    return singleton !== false && !instantiate && isSingleton(container, fullName) && !isInstantiatable(container, fullName);
  }

  function isSingletonInstance(container, fullName, {
    instantiate,
    singleton
  }) {
    return singleton !== false && instantiate !== false && isSingleton(container, fullName) && isInstantiatable(container, fullName);
  }

  function isFactoryClass(container, fullname, {
    instantiate,
    singleton
  }) {
    return instantiate === false && (singleton === false || !isSingleton(container, fullname)) && !isInstantiatable(container, fullname);
  }

  function isFactoryInstance(container, fullName, {
    instantiate,
    singleton
  }) {
    return instantiate !== false && (singleton !== false || isSingleton(container, fullName)) && isInstantiatable(container, fullName);
  }

  function instantiateFactory(container, normalizedName, fullName, options) {
    var factoryManager = factoryFor(container, normalizedName, fullName);

    if (factoryManager === undefined) {
      return;
    } // SomeClass { singleton: true, instantiate: true } | { singleton: true } | { instantiate: true } | {}
    // By default majority of objects fall into this case


    if (isSingletonInstance(container, fullName, options)) {
      return container.cache[normalizedName] = factoryManager.create();
    } // SomeClass { singleton: false, instantiate: true }


    if (isFactoryInstance(container, fullName, options)) {
      return factoryManager.create();
    } // SomeClass { singleton: true, instantiate: false } | { instantiate: false } | { singleton: false, instantiation: false }


    if (isSingletonClass(container, fullName, options) || isFactoryClass(container, fullName, options)) {
      return factoryManager.class;
    }

    throw new Error('Could not create factory');
  }

  function processInjections(container, injections, result) {
    if (true
    /* DEBUG */
    ) {
      container.registry.validateInjections(injections);
    }

    var hash = result.injections;

    if (hash === undefined) {
      hash = result.injections = {};
    }

    for (var i = 0; i < injections.length; i++) {
      var {
        property,
        specifier,
        source
      } = injections[i];

      if (source) {
        hash[property] = lookup(container, specifier, {
          source
        });
      } else {
        hash[property] = lookup(container, specifier);
      }

      if (!result.isDynamic) {
        result.isDynamic = !isSingleton(container, specifier);
      }
    }
  }

  function buildInjections(container, typeInjections, injections) {
    var result = {
      injections: undefined,
      isDynamic: false
    };

    if (typeInjections !== undefined) {
      processInjections(container, typeInjections, result);
    }

    if (injections !== undefined) {
      processInjections(container, injections, result);
    }

    return result;
  }

  function injectionsFor(container, fullName) {
    var registry = container.registry;
    var [type] = fullName.split(':');
    var typeInjections = registry.getTypeInjections(type);
    var injections = registry.getInjections(fullName);
    return buildInjections(container, typeInjections, injections);
  }

  function destroyDestroyables(container) {
    var cache = container.cache;
    var keys = Object.keys(cache);

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = cache[key];

      if (value.destroy) {
        value.destroy();
      }
    }
  }

  function resetCache(container) {
    container.cache = (0, _utils.dictionary)(null);
    container.factoryManagerCache = (0, _utils.dictionary)(null);
  }

  function resetMember(container, fullName) {
    var member = container.cache[fullName];
    delete container.factoryManagerCache[fullName];

    if (member) {
      delete container.cache[fullName];

      if (member.destroy) {
        member.destroy();
      }
    }
  }

  var FACTORY_FOR = new WeakMap();
  _exports.FACTORY_FOR = FACTORY_FOR;

  class FactoryManager {
    constructor(container, factory, fullName, normalizedName) {
      this.container = container;
      this.owner = container.owner;
      this.class = factory;
      this.fullName = fullName;
      this.normalizedName = normalizedName;
      this.madeToString = undefined;
      this.injections = undefined;
      FACTORY_FOR.set(this, this);
    }

    toString() {
      if (this.madeToString === undefined) {
        this.madeToString = this.container.registry.makeToString(this.class, this.fullName);
      }

      return this.madeToString;
    }

    create(options) {
      var injectionsCache = this.injections;

      if (injectionsCache === undefined) {
        var {
          injections,
          isDynamic
        } = injectionsFor(this.container, this.normalizedName);
        injectionsCache = injections;

        if (!isDynamic) {
          this.injections = injections;
        }
      }

      var props = injectionsCache;

      if (options !== undefined) {
        props = (0, _polyfills.assign)({}, injectionsCache, options);
      }

      if (true
      /* DEBUG */
      ) {
        var lazyInjections;
        var validationCache = this.container.validationCache; // Ensure that all lazy injections are valid at instantiation time

        if (!validationCache[this.fullName] && this.class && typeof this.class._lazyInjections === 'function') {
          lazyInjections = this.class._lazyInjections();
          lazyInjections = this.container.registry.normalizeInjectionsHash(lazyInjections);
          this.container.registry.validateInjections(lazyInjections);
        }

        validationCache[this.fullName] = true;
      }

      if (!this.class.create) {
        throw new Error("Failed to create an instance of '" + this.normalizedName + "'. Most likely an improperly defined class or an invalid module export.");
      } // required to allow access to things like
      // the customized toString, _debugContainerKey,
      // owner, etc. without a double extend and without
      // modifying the objects properties


      if (typeof this.class._initFactory === 'function') {
        this.class._initFactory(this);
      } else {
        // in the non-EmberObject case we need to still setOwner
        // this is required for supporting glimmer environment and
        // template instantiation which rely heavily on
        // `options[OWNER]` being passed into `create`
        // TODO: clean this up, and remove in future versions
        if (options === undefined || props === undefined) {
          // avoid mutating `props` here since they are the cached injections
          props = (0, _polyfills.assign)({}, props);
        }

        (0, _owner.setOwner)(props, this.owner);
      }

      var instance = this.class.create(props);
      FACTORY_FOR.set(instance, this);
      return instance;
    }

  }

  var VALID_FULL_NAME_REGEXP = /^[^:]+:[^:]+$/;
  /**
   A registry used to store factory and option information keyed
   by type.
  
   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.
  
   The API for `Registry` is still in flux and should not be considered stable.
  
   @private
   @class Registry
   @since 1.11.0
  */

  class Registry {
    constructor(options = {}) {
      this.fallback = options.fallback || null;
      this.resolver = options.resolver || null;
      this.registrations = (0, _utils.dictionary)(options.registrations || null);
      this._typeInjections = (0, _utils.dictionary)(null);
      this._injections = (0, _utils.dictionary)(null);
      this._localLookupCache = Object.create(null);
      this._normalizeCache = (0, _utils.dictionary)(null);
      this._resolveCache = (0, _utils.dictionary)(null);
      this._failSet = new Set();
      this._options = (0, _utils.dictionary)(null);
      this._typeOptions = (0, _utils.dictionary)(null);
    }
    /**
     A backup registry for resolving registrations when no matches can be found.
        @private
     @property fallback
     @type Registry
     */

    /**
     An object that has a `resolve` method that resolves a name.
        @private
     @property resolver
     @type Resolver
     */

    /**
     @private
     @property registrations
     @type InheritingDict
     */

    /**
     @private
        @property _typeInjections
     @type InheritingDict
     */

    /**
     @private
        @property _injections
     @type InheritingDict
     */

    /**
     @private
        @property _normalizeCache
     @type InheritingDict
     */

    /**
     @private
        @property _resolveCache
     @type InheritingDict
     */

    /**
     @private
        @property _options
     @type InheritingDict
     */

    /**
     @private
        @property _typeOptions
     @type InheritingDict
     */

    /**
     Creates a container based on this registry.
        @private
     @method container
     @param {Object} options
     @return {Container} created container
     */


    container(options) {
      return new Container(this, options);
    }
    /**
     Registers a factory for later injection.
        Example:
        ```javascript
     let registry = new Registry();
        registry.register('model:user', Person, {singleton: false });
     registry.register('fruit:favorite', Orange);
     registry.register('communication:main', Email, {singleton: false});
     ```
        @private
     @method register
     @param {String} fullName
     @param {Function} factory
     @param {Object} options
     */


    register(fullName, factory, options = {}) {
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      (true && !(factory !== undefined) && (0, _debug.assert)("Attempting to register an unknown factory: '" + fullName + "'", factory !== undefined));
      var normalizedName = this.normalize(fullName);
      (true && !(!this._resolveCache[normalizedName]) && (0, _debug.assert)("Cannot re-register: '" + fullName + "', as it has already been resolved.", !this._resolveCache[normalizedName]));

      this._failSet.delete(normalizedName);

      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options;
    }
    /**
     Unregister a fullName
        ```javascript
     let registry = new Registry();
     registry.register('model:user', User);
        registry.resolve('model:user').create() instanceof User //=> true
        registry.unregister('model:user')
     registry.resolve('model:user') === undefined //=> true
     ```
        @private
     @method unregister
     @param {String} fullName
     */


    unregister(fullName) {
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var normalizedName = this.normalize(fullName);
      this._localLookupCache = Object.create(null);
      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._options[normalizedName];

      this._failSet.delete(normalizedName);
    }
    /**
     Given a fullName return the corresponding factory.
        By default `resolve` will retrieve the factory from
     the registry.
        ```javascript
     let registry = new Registry();
     registry.register('api:twitter', Twitter);
        registry.resolve('api:twitter') // => Twitter
     ```
        Optionally the registry can be provided with a custom resolver.
     If provided, `resolve` will first provide the custom resolver
     the opportunity to resolve the fullName, otherwise it will fallback
     to the registry.
        ```javascript
     let registry = new Registry();
     registry.resolver = function(fullName) {
        // lookup via the module system of choice
      };
        // the twitter factory is added to the module system
     registry.resolve('api:twitter') // => Twitter
     ```
        @private
     @method resolve
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Function} fullName's factory
     */


    resolve(fullName, options) {
      var factory = resolve(this, this.normalize(fullName), options);

      if (factory === undefined && this.fallback !== null) {
        factory = this.fallback.resolve(...arguments);
      }

      return factory;
    }
    /**
     A hook that can be used to describe how the resolver will
     attempt to find the factory.
        For example, the default Ember `.describe` returns the full
     class name (including namespace) where Ember's resolver expects
     to find the `fullName`.
        @private
     @method describe
     @param {String} fullName
     @return {string} described fullName
     */


    describe(fullName) {
      if (this.resolver !== null && this.resolver.lookupDescription) {
        return this.resolver.lookupDescription(fullName);
      } else if (this.fallback !== null) {
        return this.fallback.describe(fullName);
      } else {
        return fullName;
      }
    }
    /**
     A hook to enable custom fullName normalization behavior
        @private
     @method normalizeFullName
     @param {String} fullName
     @return {string} normalized fullName
     */


    normalizeFullName(fullName) {
      if (this.resolver !== null && this.resolver.normalize) {
        return this.resolver.normalize(fullName);
      } else if (this.fallback !== null) {
        return this.fallback.normalizeFullName(fullName);
      } else {
        return fullName;
      }
    }
    /**
     Normalize a fullName based on the application's conventions
        @private
     @method normalize
     @param {String} fullName
     @return {string} normalized fullName
     */


    normalize(fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    }
    /**
     @method makeToString
        @private
     @param {any} factory
     @param {string} fullName
     @return {function} toString function
     */


    makeToString(factory, fullName) {
      if (this.resolver !== null && this.resolver.makeToString) {
        return this.resolver.makeToString(factory, fullName);
      } else if (this.fallback !== null) {
        return this.fallback.makeToString(factory, fullName);
      } else {
        return factory.toString();
      }
    }
    /**
     Given a fullName check if the container is aware of its factory
     or singleton instance.
        @private
     @method has
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Boolean}
     */


    has(fullName, options) {
      if (!this.isValidFullName(fullName)) {
        return false;
      }

      var source = options && options.source && this.normalize(options.source);
      var namespace = options && options.namespace || undefined;
      return has(this, this.normalize(fullName), source, namespace);
    }
    /**
     Allow registering options for all factories of a type.
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        // if all of type `connection` must not be singletons
     registry.optionsForType('connection', { singleton: false });
        registry.register('connection:twitter', TwitterConnection);
     registry.register('connection:facebook', FacebookConnection);
        let twitter = container.lookup('connection:twitter');
     let twitter2 = container.lookup('connection:twitter');
        twitter === twitter2; // => false
        let facebook = container.lookup('connection:facebook');
     let facebook2 = container.lookup('connection:facebook');
        facebook === facebook2; // => false
     ```
        @private
     @method optionsForType
     @param {String} type
     @param {Object} options
     */


    optionsForType(type, options) {
      this._typeOptions[type] = options;
    }

    getOptionsForType(type) {
      var optionsForType = this._typeOptions[type];

      if (optionsForType === undefined && this.fallback !== null) {
        optionsForType = this.fallback.getOptionsForType(type);
      }

      return optionsForType;
    }
    /**
     @private
     @method options
     @param {String} fullName
     @param {Object} options
     */


    options(fullName, options) {
      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = options;
    }

    getOptions(fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];

      if (options === undefined && this.fallback !== null) {
        options = this.fallback.getOptions(fullName);
      }

      return options;
    }

    getOption(fullName, optionName) {
      var options = this._options[fullName];

      if (options !== undefined && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = this._typeOptions[type];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback !== null) {
        return this.fallback.getOption(fullName, optionName);
      }

      return undefined;
    }
    /**
     Used only via `injection`.
        Provides a specialized form of injection, specifically enabling
     all objects of one type to be injected with a reference to another
     object.
        For example, provided each object of type `controller` needed a `router`.
     one would do the following:
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        registry.register('router:main', Router);
     registry.register('controller:user', UserController);
     registry.register('controller:post', PostController);
        registry.typeInjection('controller', 'router', 'router:main');
        let user = container.lookup('controller:user');
     let post = container.lookup('controller:post');
        user.router instanceof Router; //=> true
     post.router instanceof Router; //=> true
        // both controllers share the same router
     user.router === post.router; //=> true
     ```
        @private
     @method typeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */


    typeInjection(type, property, fullName) {
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var fullNameType = fullName.split(':')[0];
      (true && !(fullNameType !== type) && (0, _debug.assert)("Cannot inject a '" + fullName + "' on other " + type + "(s).", fullNameType !== type));
      var injections = this._typeInjections[type] || (this._typeInjections[type] = []);
      injections.push({
        property,
        specifier: fullName
      });
    }
    /**
     Defines injection rules.
        These rules are used to inject dependencies onto objects when they
     are instantiated.
        Two forms of injections are possible:
        * Injecting one fullName on another fullName
     * Injecting one fullName on a type
        Example:
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        registry.register('source:main', Source);
     registry.register('model:user', User);
     registry.register('model:post', Post);
        // injecting one fullName on another fullName
     // eg. each user model gets a post model
     registry.injection('model:user', 'post', 'model:post');
        // injecting one fullName on another type
     registry.injection('model', 'source', 'source:main');
        let user = container.lookup('model:user');
     let post = container.lookup('model:post');
        user.source instanceof Source; //=> true
     post.source instanceof Source; //=> true
        user.post instanceof Post; //=> true
        // and both models share the same source
     user.source === post.source; //=> true
     ```
        @private
     @method injection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */


    injection(fullName, property, injectionName) {
      (true && !(this.isValidFullName(injectionName)) && (0, _debug.assert)("Invalid injectionName, expected: 'type:name' got: " + injectionName, this.isValidFullName(injectionName)));
      var normalizedInjectionName = this.normalize(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.typeInjection(fullName, property, normalizedInjectionName);
      }

      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var normalizedName = this.normalize(fullName);
      var injections = this._injections[normalizedName] || (this._injections[normalizedName] = []);
      injections.push({
        property,
        specifier: normalizedInjectionName
      });
    }
    /**
     @private
     @method knownForType
     @param {String} type the type to iterate over
    */


    knownForType(type) {
      var localKnown = (0, _utils.dictionary)(null);
      var registeredNames = Object.keys(this.registrations);

      for (var index = 0; index < registeredNames.length; index++) {
        var fullName = registeredNames[index];
        var itemType = fullName.split(':')[0];

        if (itemType === type) {
          localKnown[fullName] = true;
        }
      }

      var fallbackKnown, resolverKnown;

      if (this.fallback !== null) {
        fallbackKnown = this.fallback.knownForType(type);
      }

      if (this.resolver !== null && this.resolver.knownForType) {
        resolverKnown = this.resolver.knownForType(type);
      }

      return (0, _polyfills.assign)({}, fallbackKnown, localKnown, resolverKnown);
    }

    isValidFullName(fullName) {
      return VALID_FULL_NAME_REGEXP.test(fullName);
    }

    getInjections(fullName) {
      var injections = this._injections[fullName];

      if (this.fallback !== null) {
        var fallbackInjections = this.fallback.getInjections(fullName);

        if (fallbackInjections !== undefined) {
          injections = injections === undefined ? fallbackInjections : injections.concat(fallbackInjections);
        }
      }

      return injections;
    }

    getTypeInjections(type) {
      var injections = this._typeInjections[type];

      if (this.fallback !== null) {
        var fallbackInjections = this.fallback.getTypeInjections(type);

        if (fallbackInjections !== undefined) {
          injections = injections === undefined ? fallbackInjections : injections.concat(fallbackInjections);
        }
      }

      return injections;
    }
    /**
     Given a fullName and a source fullName returns the fully resolved
     fullName. Used to allow for local lookup.
        ```javascript
     let registry = new Registry();
        // the twitter factory is added to the module system
     registry.expandLocalLookup('component:post-title', { source: 'template:post' }) // => component:post/post-title
     ```
        @private
     @method expandLocalLookup
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {String} fullName
     */


    expandLocalLookup(fullName, options) {
      if (this.resolver !== null && this.resolver.expandLocalLookup) {
        (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
        (true && !(!options.source || this.isValidFullName(options.source)) && (0, _debug.assert)('options.source must be a proper full name', !options.source || this.isValidFullName(options.source)));
        var normalizedFullName = this.normalize(fullName);
        var normalizedSource = this.normalize(options.source);
        return expandLocalLookup(this, normalizedFullName, normalizedSource, options.namespace);
      } else if (this.fallback !== null) {
        return this.fallback.expandLocalLookup(fullName, options);
      } else {
        return null;
      }
    }

  }

  _exports.Registry = Registry;

  if (true
  /* DEBUG */
  ) {
    var proto = Registry.prototype;

    proto.normalizeInjectionsHash = function (hash) {
      var injections = [];

      for (var key in hash) {
        if (hash.hasOwnProperty(key)) {
          var {
            specifier,
            source,
            namespace
          } = hash[key];
          (true && !(this.isValidFullName(specifier)) && (0, _debug.assert)("Expected a proper full name, given '" + specifier + "'", this.isValidFullName(specifier)));
          injections.push({
            property: key,
            specifier,
            source,
            namespace
          });
        }
      }

      return injections;
    };

    proto.validateInjections = function (injections) {
      if (!injections) {
        return;
      }

      for (var i = 0; i < injections.length; i++) {
        var {
          specifier,
          source,
          namespace
        } = injections[i];
        (true && !(this.has(specifier, {
          source,
          namespace
        })) && (0, _debug.assert)("Attempting to inject an unknown injection: '" + specifier + "'", this.has(specifier, {
          source,
          namespace
        })));
      }
    };
  }

  function expandLocalLookup(registry, normalizedName, normalizedSource, namespace) {
    var cache = registry._localLookupCache;
    var normalizedNameCache = cache[normalizedName];

    if (!normalizedNameCache) {
      normalizedNameCache = cache[normalizedName] = Object.create(null);
    }

    var cacheKey = namespace || normalizedSource;
    var cached = normalizedNameCache[cacheKey];

    if (cached !== undefined) {
      return cached;
    }

    var expanded = registry.resolver.expandLocalLookup(normalizedName, normalizedSource, namespace);
    return normalizedNameCache[cacheKey] = expanded;
  }

  function resolve(registry, _normalizedName, options) {
    var normalizedName = _normalizedName; // when `source` is provided expand normalizedName
    // and source into the full normalizedName

    if (options !== undefined && (options.source || options.namespace)) {
      normalizedName = registry.expandLocalLookup(_normalizedName, options);

      if (!normalizedName) {
        return;
      }
    }

    var cached = registry._resolveCache[normalizedName];

    if (cached !== undefined) {
      return cached;
    }

    if (registry._failSet.has(normalizedName)) {
      return;
    }

    var resolved;

    if (registry.resolver) {
      resolved = registry.resolver.resolve(normalizedName);
    }

    if (resolved === undefined) {
      resolved = registry.registrations[normalizedName];
    }

    if (resolved === undefined) {
      registry._failSet.add(normalizedName);
    } else {
      registry._resolveCache[normalizedName] = resolved;
    }

    return resolved;
  }

  function has(registry, fullName, source, namespace) {
    return registry.resolve(fullName, {
      source,
      namespace
    }) !== undefined;
  }

  var privateNames = (0, _utils.dictionary)(null);
  var privateSuffix = ("" + Math.random() + Date.now()).replace('.', '');

  function privatize([fullName]) {
    var name = privateNames[fullName];

    if (name) {
      return name;
    }

    var [type, rawName] = fullName.split(':');
    return privateNames[fullName] = (0, _utils.intern)(type + ":" + rawName + "-" + privateSuffix);
  }
  /*
  Public API for the container is still in flux.
  The public API, specified on the application namespace should be considered the stable API.
  // @module container
    @private
  */

});
define("@ember/-internals/environment/index", ["exports", "@ember/deprecated-features"], function (_exports, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getLookup = getLookup;
  _exports.setLookup = setLookup;
  _exports.getENV = getENV;
  _exports.ENV = _exports.context = _exports.global = void 0;

  // from lodash to catch fake globals
  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  } // element ids can ruin global miss checks


  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  } // export real global


  var global$1 = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || typeof mainContext !== 'undefined' && mainContext || // set before strict mode in Ember loader/wrapper
  new Function('return this')(); // eval outside of strict mode

  _exports.global = global$1;

  var context = function (global, Ember) {
    return Ember === undefined ? {
      imports: global,
      exports: global,
      lookup: global
    } : {
      // import jQuery
      imports: Ember.imports || global,
      // export Ember
      exports: Ember.exports || global,
      // search for Namespaces
      lookup: Ember.lookup || global
    };
  }(global$1, global$1.Ember);

  _exports.context = context;

  function getLookup() {
    return context.lookup;
  }

  function setLookup(value) {
    context.lookup = value;
  }
  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */


  var ENV = {
    ENABLE_OPTIONAL_FEATURES: false,

    /**
      Determines whether Ember should add to `Array`, `Function`, and `String`
      native object prototypes, a few extra methods in order to provide a more
      friendly API.
         We generally recommend leaving this option set to true however, if you need
      to turn it off, you can add the configuration property
      `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
         Note, when disabled (the default configuration for Ember Addons), you will
      instead have to access all methods and functions from the Ember
      namespace.
         @property EXTEND_PROTOTYPES
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    EXTEND_PROTOTYPES: {
      Array: true,
      Function: true,
      String: true
    },

    /**
      The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
      a full stack trace during deprecation warnings.
         @property LOG_STACKTRACE_ON_DEPRECATION
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    LOG_STACKTRACE_ON_DEPRECATION: true,

    /**
      The `LOG_VERSION` property, when true, tells Ember to log versions of all
      dependent libraries in use.
         @property LOG_VERSION
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    LOG_VERSION: true,
    RAISE_ON_DEPRECATION: false,
    STRUCTURED_PROFILE: false,

    /**
      Whether to insert a `<div class="ember-view" />` wrapper around the
      application template. See RFC #280.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _APPLICATION_TEMPLATE_WRAPPER
      @for EmberENV
      @type Boolean
      @default true
      @private
    */
    _APPLICATION_TEMPLATE_WRAPPER: true,

    /**
      Whether to use Glimmer Component semantics (as opposed to the classic "Curly"
      components semantics) for template-only components. See RFC #278.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _TEMPLATE_ONLY_GLIMMER_COMPONENTS
      @for EmberENV
      @type Boolean
      @default false
      @private
    */
    _TEMPLATE_ONLY_GLIMMER_COMPONENTS: false,

    /**
      Whether the app is using jQuery. See RFC #294.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _JQUERY_INTEGRATION
      @for EmberENV
      @type Boolean
      @default true
      @private
    */
    _JQUERY_INTEGRATION: true,

    /**
      Whether the app defaults to using async observers.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _DEFAULT_ASYNC_OBSERVERS
      @for EmberENV
      @type Boolean
      @default false
      @private
    */
    _DEFAULT_ASYNC_OBSERVERS: false,

    /**
      Controls the maximum number of scheduled rerenders without "settling". In general,
      applications should not need to modify this environment variable, but please
      open an issue so that we can determine if a better default value is needed.
         @property _RERENDER_LOOP_LIMIT
      @for EmberENV
      @type number
      @default 1000
      @private
     */
    _RERENDER_LOOP_LIMIT: 1000,
    EMBER_LOAD_HOOKS: {},
    FEATURES: {}
  };
  _exports.ENV = ENV;

  (EmberENV => {
    if (typeof EmberENV !== 'object' || EmberENV === null) return;

    for (var flag in EmberENV) {
      if (!EmberENV.hasOwnProperty(flag) || flag === 'EXTEND_PROTOTYPES' || flag === 'EMBER_LOAD_HOOKS') continue;
      var defaultValue = ENV[flag];

      if (defaultValue === true) {
        ENV[flag] = EmberENV[flag] !== false;
      } else if (defaultValue === false) {
        ENV[flag] = EmberENV[flag] === true;
      }
    }

    var {
      EXTEND_PROTOTYPES
    } = EmberENV;

    if (EXTEND_PROTOTYPES !== undefined) {
      if (typeof EXTEND_PROTOTYPES === 'object' && EXTEND_PROTOTYPES !== null) {
        ENV.EXTEND_PROTOTYPES.String = EXTEND_PROTOTYPES.String !== false;

        if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS) {
          ENV.EXTEND_PROTOTYPES.Function = EXTEND_PROTOTYPES.Function !== false;
        }

        ENV.EXTEND_PROTOTYPES.Array = EXTEND_PROTOTYPES.Array !== false;
      } else {
        var isEnabled = EXTEND_PROTOTYPES !== false;
        ENV.EXTEND_PROTOTYPES.String = isEnabled;

        if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS) {
          ENV.EXTEND_PROTOTYPES.Function = isEnabled;
        }

        ENV.EXTEND_PROTOTYPES.Array = isEnabled;
      }
    } // TODO this does not seem to be used by anything,
    //      can we remove it? do we need to deprecate it?


    var {
      EMBER_LOAD_HOOKS
    } = EmberENV;

    if (typeof EMBER_LOAD_HOOKS === 'object' && EMBER_LOAD_HOOKS !== null) {
      for (var hookName in EMBER_LOAD_HOOKS) {
        if (!EMBER_LOAD_HOOKS.hasOwnProperty(hookName)) continue;
        var hooks = EMBER_LOAD_HOOKS[hookName];

        if (Array.isArray(hooks)) {
          ENV.EMBER_LOAD_HOOKS[hookName] = hooks.filter(hook => typeof hook === 'function');
        }
      }
    }

    var {
      FEATURES
    } = EmberENV;

    if (typeof FEATURES === 'object' && FEATURES !== null) {
      for (var feature in FEATURES) {
        if (!FEATURES.hasOwnProperty(feature)) continue;
        ENV.FEATURES[feature] = FEATURES[feature] === true;
      }
    }
  })(global$1.EmberENV || global$1.ENV);

  function getENV() {
    return ENV;
  }
});
define("@ember/-internals/error-handling/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getOnerror = getOnerror;
  _exports.setOnerror = setOnerror;
  _exports.getDispatchOverride = getDispatchOverride;
  _exports.setDispatchOverride = setDispatchOverride;
  _exports.onErrorTarget = void 0;
  var onerror;
  var onErrorTarget = {
    get onerror() {
      return onerror;
    }

  }; // Ember.onerror getter

  _exports.onErrorTarget = onErrorTarget;

  function getOnerror() {
    return onerror;
  } // Ember.onerror setter


  function setOnerror(handler) {
    onerror = handler;
  }

  var dispatchOverride; // allows testing adapter to override dispatch

  function getDispatchOverride() {
    return dispatchOverride;
  }

  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }
});
define("@ember/-internals/extension-support/index", ["exports", "@ember/-internals/extension-support/lib/data_adapter", "@ember/-internals/extension-support/lib/container_debug_adapter"], function (_exports, _data_adapter, _container_debug_adapter) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "DataAdapter", {
    enumerable: true,
    get: function () {
      return _data_adapter.default;
    }
  });
  Object.defineProperty(_exports, "ContainerDebugAdapter", {
    enumerable: true,
    get: function () {
      return _container_debug_adapter.default;
    }
  });
});
define("@ember/-internals/extension-support/lib/container_debug_adapter", ["exports", "@ember/string", "@ember/-internals/runtime"], function (_exports, _string, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/debug
  */

  /**
    The `ContainerDebugAdapter` helps the container and resolver interface
    with tools that debug Ember such as the
    [Ember Inspector](https://github.com/emberjs/ember-inspector)
    for Chrome and Firefox.
  
    This class can be extended by a custom resolver implementer
    to override some of the methods with library-specific code.
  
    The methods likely to be overridden are:
  
    * `canCatalogEntriesByType`
    * `catalogEntriesByType`
  
    The adapter will need to be registered
    in the application's container as `container-debug-adapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "containerDebugAdapter",
  
      initialize(application) {
        application.register('container-debug-adapter:main', require('app/container-debug-adapter'));
      }
    });
    ```
  
    @class ContainerDebugAdapter
    @extends EmberObject
    @since 1.5.0
    @public
  */
  var _default = _runtime.Object.extend({
    /**
      The resolver instance of the application
      being debugged. This property will be injected
      on creation.
       @property resolver
      @default null
      @public
    */
    resolver: null,

    /**
      Returns true if it is possible to catalog a list of available
      classes in the resolver for a given type.
       @method canCatalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {boolean} whether a list is available for this type.
      @public
    */
    canCatalogEntriesByType(type) {
      if (type === 'model' || type === 'template') {
        return false;
      }

      return true;
    },

    /**
      Returns the available classes a given type.
       @method catalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {Array} An array of strings.
      @public
    */
    catalogEntriesByType(type) {
      var namespaces = (0, _runtime.A)(_runtime.Namespace.NAMESPACES);
      var types = (0, _runtime.A)();
      var typeSuffixRegex = new RegExp((0, _string.classify)(type) + "$");
      namespaces.forEach(namespace => {
        for (var key in namespace) {
          if (!namespace.hasOwnProperty(key)) {
            continue;
          }

          if (typeSuffixRegex.test(key)) {
            var klass = namespace[key];

            if ((0, _runtime.typeOf)(klass) === 'class') {
              types.push((0, _string.dasherize)(key.replace(typeSuffixRegex, '')));
            }
          }
        }
      });
      return types;
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/extension-support/lib/data_adapter", ["exports", "@ember/-internals/owner", "@ember/runloop", "@ember/-internals/metal", "@ember/string", "@ember/-internals/runtime"], function (_exports, _owner, _runloop, _metal, _string, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/debug
  */

  /**
    The `DataAdapter` helps a data persistence library
    interface with tools that debug Ember such
    as the [Ember Inspector](https://github.com/emberjs/ember-inspector)
    for Chrome and Firefox.
  
    This class will be extended by a persistence library
    which will override some of the methods with
    library-specific code.
  
    The methods likely to be overridden are:
  
    * `getFilters`
    * `detect`
    * `columnsForType`
    * `getRecords`
    * `getRecordColumnValues`
    * `getRecordKeywords`
    * `getRecordFilterValues`
    * `getRecordColor`
    * `observeRecord`
  
    The adapter will need to be registered
    in the application's container as `dataAdapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "data-adapter",
  
      initialize: function(application) {
        application.register('data-adapter:main', DS.DataAdapter);
      }
    });
    ```
  
    @class DataAdapter
    @extends EmberObject
    @public
  */
  var _default = _runtime.Object.extend({
    init() {
      this._super(...arguments);

      this.releaseMethods = (0, _runtime.A)();
    },

    /**
      The container-debug-adapter which is used
      to list all models.
       @property containerDebugAdapter
      @default undefined
      @since 1.5.0
      @public
    **/
    containerDebugAdapter: undefined,

    /**
      The number of attributes to send
      as columns. (Enough to make the record
      identifiable).
       @private
      @property attributeLimit
      @default 3
      @since 1.3.0
    */
    attributeLimit: 3,

    /**
       Ember Data > v1.0.0-beta.18
       requires string model names to be passed
       around instead of the actual factories.
        This is a stamp for the Ember Inspector
       to differentiate between the versions
       to be able to support older versions too.
        @public
       @property acceptsModelName
     */
    acceptsModelName: true,

    /**
      Stores all methods that clear observers.
      These methods will be called on destruction.
       @private
      @property releaseMethods
      @since 1.3.0
    */
    releaseMethods: (0, _runtime.A)(),

    /**
      Specifies how records can be filtered.
      Records returned will need to have a `filterValues`
      property with a key for every name in the returned array.
       @public
      @method getFilters
      @return {Array} List of objects defining filters.
       The object should have a `name` and `desc` property.
    */
    getFilters() {
      return (0, _runtime.A)();
    },

    /**
      Fetch the model types and observe them for changes.
       @public
      @method watchModelTypes
       @param {Function} typesAdded Callback to call to add types.
      Takes an array of objects containing wrapped types (returned from `wrapModelType`).
       @param {Function} typesUpdated Callback to call when a type has changed.
      Takes an array of objects containing wrapped types.
       @return {Function} Method to call to remove all observers
    */
    watchModelTypes(typesAdded, typesUpdated) {
      var modelTypes = this.getModelTypes();
      var releaseMethods = (0, _runtime.A)();
      var typesToSend;
      typesToSend = modelTypes.map(type => {
        var klass = type.klass;
        var wrapped = this.wrapModelType(klass, type.name);
        releaseMethods.push(this.observeModelType(type.name, typesUpdated));
        return wrapped;
      });
      typesAdded(typesToSend);

      var release = () => {
        releaseMethods.forEach(fn => fn());
        this.releaseMethods.removeObject(release);
      };

      this.releaseMethods.pushObject(release);
      return release;
    },

    _nameToClass(type) {
      if (typeof type === 'string') {
        var owner = (0, _owner.getOwner)(this);
        var Factory = owner.factoryFor("model:" + type);
        type = Factory && Factory.class;
      }

      return type;
    },

    /**
      Fetch the records of a given type and observe them for changes.
       @public
      @method watchRecords
       @param {String} modelName The model name.
       @param {Function} recordsAdded Callback to call to add records.
      Takes an array of objects containing wrapped records.
      The object should have the following properties:
        columnValues: {Object} The key and value of a table cell.
        object: {Object} The actual record object.
       @param {Function} recordsUpdated Callback to call when a record has changed.
      Takes an array of objects containing wrapped records.
       @param {Function} recordsRemoved Callback to call when a record has removed.
      Takes the following parameters:
        index: The array index where the records were removed.
        count: The number of records removed.
       @return {Function} Method to call to remove all observers.
    */
    watchRecords(modelName, recordsAdded, recordsUpdated, recordsRemoved) {
      var releaseMethods = (0, _runtime.A)();

      var klass = this._nameToClass(modelName);

      var records = this.getRecords(klass, modelName);
      var release;

      function recordUpdated(updatedRecord) {
        recordsUpdated([updatedRecord]);
      }

      var recordsToSend = records.map(record => {
        releaseMethods.push(this.observeRecord(record, recordUpdated));
        return this.wrapRecord(record);
      });

      var contentDidChange = (array, idx, removedCount, addedCount) => {
        for (var i = idx; i < idx + addedCount; i++) {
          var record = (0, _metal.objectAt)(array, i);
          var wrapped = this.wrapRecord(record);
          releaseMethods.push(this.observeRecord(record, recordUpdated));
          recordsAdded([wrapped]);
        }

        if (removedCount) {
          recordsRemoved(idx, removedCount);
        }
      };

      var observer = {
        didChange: contentDidChange,

        willChange() {
          return this;
        }

      };
      (0, _metal.addArrayObserver)(records, this, observer);

      release = () => {
        releaseMethods.forEach(fn => fn());
        (0, _metal.removeArrayObserver)(records, this, observer);
        this.releaseMethods.removeObject(release);
      };

      recordsAdded(recordsToSend);
      this.releaseMethods.pushObject(release);
      return release;
    },

    /**
      Clear all observers before destruction
      @private
      @method willDestroy
    */
    willDestroy() {
      this._super(...arguments);

      this.releaseMethods.forEach(fn => fn());
    },

    /**
      Detect whether a class is a model.
       Test that against the model class
      of your persistence library.
       @public
      @method detect
      @return boolean Whether the class is a model class or not.
    */
    detect() {
      return false;
    },

    /**
      Get the columns for a given model type.
       @public
      @method columnsForType
      @return {Array} An array of columns of the following format:
       name: {String} The name of the column.
       desc: {String} Humanized description (what would show in a table column name).
    */
    columnsForType() {
      return (0, _runtime.A)();
    },

    /**
      Adds observers to a model type class.
       @private
      @method observeModelType
      @param {String} modelName The model type name.
      @param {Function} typesUpdated Called when a type is modified.
      @return {Function} The function to call to remove observers.
    */
    observeModelType(modelName, typesUpdated) {
      var klass = this._nameToClass(modelName);

      var records = this.getRecords(klass, modelName);

      function onChange() {
        typesUpdated([this.wrapModelType(klass, modelName)]);
      }

      var observer = {
        didChange(array, idx, removedCount, addedCount) {
          // Only re-fetch records if the record count changed
          // (which is all we care about as far as model types are concerned).
          if (removedCount > 0 || addedCount > 0) {
            (0, _runloop.scheduleOnce)('actions', this, onChange);
          }
        },

        willChange() {
          return this;
        }

      };
      (0, _metal.addArrayObserver)(records, this, observer);

      var release = () => (0, _metal.removeArrayObserver)(records, this, observer);

      return release;
    },

    /**
      Wraps a given model type and observes changes to it.
       @private
      @method wrapModelType
      @param {Class} klass A model class.
      @param {String} modelName Name of the class.
      @return {Object} Contains the wrapped type and the function to remove observers
      Format:
        type: {Object} The wrapped type.
          The wrapped type has the following format:
            name: {String} The name of the type.
            count: {Integer} The number of records available.
            columns: {Columns} An array of columns to describe the record.
            object: {Class} The actual Model type class.
        release: {Function} The function to remove observers.
    */
    wrapModelType(klass, name) {
      var records = this.getRecords(klass, name);
      var typeToSend;
      typeToSend = {
        name,
        count: (0, _metal.get)(records, 'length'),
        columns: this.columnsForType(klass),
        object: klass
      };
      return typeToSend;
    },

    /**
      Fetches all models defined in the application.
       @private
      @method getModelTypes
      @return {Array} Array of model types.
    */
    getModelTypes() {
      var containerDebugAdapter = this.get('containerDebugAdapter');
      var types;

      if (containerDebugAdapter.canCatalogEntriesByType('model')) {
        types = containerDebugAdapter.catalogEntriesByType('model');
      } else {
        types = this._getObjectsOnNamespaces();
      } // New adapters return strings instead of classes.


      types = (0, _runtime.A)(types).map(name => {
        return {
          klass: this._nameToClass(name),
          name
        };
      });
      types = (0, _runtime.A)(types).filter(type => this.detect(type.klass));
      return (0, _runtime.A)(types);
    },

    /**
      Loops over all namespaces and all objects
      attached to them.
       @private
      @method _getObjectsOnNamespaces
      @return {Array} Array of model type strings.
    */
    _getObjectsOnNamespaces() {
      var namespaces = (0, _runtime.A)(_runtime.Namespace.NAMESPACES);
      var types = (0, _runtime.A)();
      namespaces.forEach(namespace => {
        for (var key in namespace) {
          if (!namespace.hasOwnProperty(key)) {
            continue;
          } // Even though we will filter again in `getModelTypes`,
          // we should not call `lookupFactory` on non-models


          if (!this.detect(namespace[key])) {
            continue;
          }

          var name = (0, _string.dasherize)(key);
          types.push(name);
        }
      });
      return types;
    },

    /**
      Fetches all loaded records for a given type.
       @public
      @method getRecords
      @return {Array} An array of records.
       This array will be observed for changes,
       so it should update when new records are added/removed.
    */
    getRecords() {
      return (0, _runtime.A)();
    },

    /**
      Wraps a record and observers changes to it.
       @private
      @method wrapRecord
      @param {Object} record The record instance.
      @return {Object} The wrapped record. Format:
      columnValues: {Array}
      searchKeywords: {Array}
    */
    wrapRecord(record) {
      var recordToSend = {
        object: record
      };
      recordToSend.columnValues = this.getRecordColumnValues(record);
      recordToSend.searchKeywords = this.getRecordKeywords(record);
      recordToSend.filterValues = this.getRecordFilterValues(record);
      recordToSend.color = this.getRecordColor(record);
      return recordToSend;
    },

    /**
      Gets the values for each column.
       @public
      @method getRecordColumnValues
      @return {Object} Keys should match column names defined
      by the model type.
    */
    getRecordColumnValues() {
      return {};
    },

    /**
      Returns keywords to match when searching records.
       @public
      @method getRecordKeywords
      @return {Array} Relevant keywords for search.
    */
    getRecordKeywords() {
      return (0, _runtime.A)();
    },

    /**
      Returns the values of filters defined by `getFilters`.
       @public
      @method getRecordFilterValues
      @param {Object} record The record instance.
      @return {Object} The filter values.
    */
    getRecordFilterValues() {
      return {};
    },

    /**
      Each record can have a color that represents its state.
       @public
      @method getRecordColor
      @param {Object} record The record instance
      @return {String} The records color.
        Possible options: black, red, blue, green.
    */
    getRecordColor() {
      return null;
    },

    /**
      Observes all relevant properties and re-sends the wrapped record
      when a change occurs.
       @public
      @method observerRecord
      @return {Function} The function to call to remove all observers.
    */
    observeRecord() {
      return function () {};
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/glimmer/index", ["exports", "ember-babel", "@ember/polyfills", "@ember/-internals/container", "@glimmer/opcode-compiler", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/runloop", "@glimmer/reference", "@ember/-internals/metal", "@ember/debug", "@glimmer/runtime", "@glimmer/util", "@ember/-internals/owner", "@ember/-internals/views", "@ember/-internals/browser-environment", "@ember/instrumentation", "@ember/service", "@ember/-internals/environment", "@ember/string", "@glimmer/wire-format", "rsvp", "@glimmer/node", "@ember/-internals/routing", "@ember/component/template-only", "@ember/deprecated-features"], function (_exports, _emberBabel, _polyfills, _container, _opcodeCompiler, _runtime, _utils, _runloop, _reference, _metal, _debug, _runtime2, _util, _owner, _views, _browserEnvironment, _instrumentation, _service, _environment2, _string, _wireFormat, _rsvp, _node, _routing, _templateOnly, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.template = template;
  _exports.helper = helper;
  _exports.escapeExpression = escapeExpression;
  _exports.htmlSafe = htmlSafe;
  _exports.isHTMLSafe = isHTMLSafe;
  _exports._resetRenderers = _resetRenderers;
  _exports.renderSettled = renderSettled;
  _exports.getTemplate = getTemplate;
  _exports.setTemplate = setTemplate;
  _exports.hasTemplate = hasTemplate;
  _exports.getTemplates = getTemplates;
  _exports.setTemplates = setTemplates;
  _exports.setupEngineRegistry = setupEngineRegistry;
  _exports.setupApplicationRegistry = setupApplicationRegistry;
  _exports._registerMacros = registerMacros;
  _exports.iterableFor = iterableFor;
  _exports.capabilities = capabilities;
  _exports.setComponentManager = setComponentManager;
  _exports.getComponentManager = getComponentManager;
  _exports.setModifierManager = setModifierManager;
  _exports.getModifierManager = getModifierManager;
  _exports.modifierCapabilities = capabilities$1;
  _exports.setComponentTemplate = setComponentTemplate;
  _exports.getComponentTemplate = getComponentTemplate;
  Object.defineProperty(_exports, "DOMChanges", {
    enumerable: true,
    get: function () {
      return _runtime2.DOMChanges;
    }
  });
  Object.defineProperty(_exports, "DOMTreeConstruction", {
    enumerable: true,
    get: function () {
      return _runtime2.DOMTreeConstruction;
    }
  });
  Object.defineProperty(_exports, "isSerializationFirstNode", {
    enumerable: true,
    get: function () {
      return _runtime2.isSerializationFirstNode;
    }
  });
  Object.defineProperty(_exports, "NodeDOMTreeConstruction", {
    enumerable: true,
    get: function () {
      return _node.NodeDOMTreeConstruction;
    }
  });
  _exports.OutletView = _exports.DebugStack = _exports.INVOKE = _exports.UpdatableReference = _exports.AbstractComponentManager = _exports._experimentalMacros = _exports.InteractiveRenderer = _exports.InertRenderer = _exports.Renderer = _exports.SafeString = _exports.Environment = _exports.Helper = _exports.ROOT_REF = _exports.Component = _exports.LinkComponent = _exports.TextArea = _exports.TextField = _exports.Checkbox = _exports.templateCacheCounters = _exports.RootTemplate = void 0;

  function _templateObject10() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["component:-default"]);

    _templateObject10 = function () {
      return data;
    };

    return data;
  }

  function _templateObject9() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template-compiler:main"]);

    _templateObject9 = function () {
      return data;
    };

    return data;
  }

  function _templateObject8() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template-compiler:main"]);

    _templateObject8 = function () {
      return data;
    };

    return data;
  }

  function _templateObject7() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"]);

    _templateObject7 = function () {
      return data;
    };

    return data;
  }

  function _templateObject6() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:-root"]);

    _templateObject6 = function () {
      return data;
    };

    return data;
  }

  function _templateObject5() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:-root"]);

    _templateObject5 = function () {
      return data;
    };

    return data;
  }

  function _templateObject4() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["component:-default"]);

    _templateObject4 = function () {
      return data;
    };

    return data;
  }

  function _templateObject3() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"]);

    _templateObject3 = function () {
      return data;
    };

    return data;
  }

  function _templateObject2() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"]);

    _templateObject2 = function () {
      return data;
    };

    return data;
  }

  function _templateObject() {
    var data = (0, _emberBabel.taggedTemplateLiteralLoose)(["template-compiler:main"]);

    _templateObject = function () {
      return data;
    };

    return data;
  }

  function isTemplateFactory(template) {
    return typeof template === 'function';
  }

  var counters = {
    cacheHit: 0,
    cacheMiss: 0
  };
  _exports.templateCacheCounters = counters;
  var TEMPLATE_COMPILER_MAIN = (0, _container.privatize)(_templateObject());

  function template(json) {
    var glimmerFactory = (0, _opcodeCompiler.templateFactory)(json);
    var cache = new WeakMap();

    var factory = owner => {
      var result = cache.get(owner);

      if (result === undefined) {
        counters.cacheMiss++;
        var compiler = owner.lookup(TEMPLATE_COMPILER_MAIN);
        result = glimmerFactory.create(compiler, {
          owner
        });
        cache.set(owner, result);
      } else {
        counters.cacheHit++;
      }

      return result;
    };

    factory.__id = glimmerFactory.id;
    factory.__meta = glimmerFactory.meta;
    return factory;
  }

  var RootTemplate = template({
    "id": "hjhxUoru",
    "block": "{\"symbols\":[],\"statements\":[[1,[28,\"component\",[[23,0,[]]],null],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/root.hbs"
    }
  });
  /**
  @module @ember/component
  */

  _exports.RootTemplate = RootTemplate;
  var RECOMPUTE_TAG = (0, _utils.symbol)('RECOMPUTE_TAG');

  function isHelperFactory(helper) {
    return typeof helper === 'object' && helper !== null && helper.class && helper.class.isHelperFactory;
  }

  function isSimpleHelper(helper) {
    return helper.destroy === undefined;
  }
  /**
    Ember Helpers are functions that can compute values, and are used in templates.
    For example, this code calls a helper named `format-currency`:
  
    ```app/templates/application.hbs
    <Cost @cents={{230}} />
    ```
  
    ```app/components/cost.hbs
    <div>{{format-currency @cents currency="$"}}</div>
    ```
  
    Additionally a helper can be called as a nested helper.
    In this example, we show the formatted currency value if the `showMoney`
    named argument is truthy.
  
    ```handlebars
    {{if @showMoney (format-currency @cents currency="$")}}
    ```
  
    Helpers defined using a class must provide a `compute` function. For example:
  
    ```app/helpers/format-currency.js
    import Helper from '@ember/component/helper';
  
    export default class extends Helper {
      compute([cents], { currency }) {
        return `${currency}${cents * 0.01}`;
      }
    }
    ```
  
    Each time the input to a helper changes, the `compute` function will be
    called again.
  
    As instances, these helpers also have access to the container and will accept
    injected dependencies.
  
    Additionally, class helpers can call `recompute` to force a new computation.
  
    @class Helper
    @public
    @since 1.13.0
  */


  var Helper = _runtime.FrameworkObject.extend({
    init() {
      this._super(...arguments);

      this[RECOMPUTE_TAG] = (0, _reference.createTag)();
    },

    /**
      On a class-based helper, it may be useful to force a recomputation of that
      helpers value. This is akin to `rerender` on a component.
         For example, this component will rerender when the `currentUser` on a
      session service changes:
         ```app/helpers/current-user-email.js
      import Helper from '@ember/component/helper'
      import { inject as service } from '@ember/service'
      import { observer } from '@ember/object'
         export default Helper.extend({
        session: service(),
           onNewUser: observer('session.currentUser', function() {
          this.recompute();
        }),
           compute() {
          return this.get('session.currentUser.email');
        }
      });
      ```
         @method recompute
      @public
      @since 1.13.0
    */
    recompute() {
      (0, _runloop.join)(() => (0, _reference.dirty)(this[RECOMPUTE_TAG]));
    }

  });

  _exports.Helper = Helper;
  Helper.isHelperFactory = true;
  (0, _runtime.setFrameworkClass)(Helper);

  class Wrapper {
    constructor(compute) {
      this.compute = compute;
      this.isHelperFactory = true;
    }

    create() {
      // needs new instance or will leak containers
      return {
        compute: this.compute
      };
    }

  }
  /**
    In many cases it is not necessary to use the full `Helper` class.
    The `helper` method create pure-function helpers without instances.
    For example:
  
    ```app/helpers/format-currency.js
    import { helper } from '@ember/component/helper';
  
    export default helper(function([cents], {currency}) {
      return `${currency}${cents * 0.01}`;
    });
    ```
  
    @static
    @param {Function} helper The helper function
    @method helper
    @for @ember/component/helper
    @public
    @since 1.13.0
  */


  function helper(helperFn) {
    return new Wrapper(helperFn);
  }

  function toBool(predicate) {
    if ((0, _runtime.isArray)(predicate)) {
      return predicate.length !== 0;
    } else {
      return Boolean(predicate);
    }
  }

  var UPDATE = (0, _utils.symbol)('UPDATE');
  var INVOKE = (0, _utils.symbol)('INVOKE');
  _exports.INVOKE = INVOKE;
  var ACTION = (0, _utils.symbol)('ACTION');

  class EmberPathReference {
    get(key) {
      return PropertyReference.create(this, key);
    }

  }

  class CachedReference$1 extends EmberPathReference {
    constructor() {
      super();
      this.lastRevision = null;
      this.lastValue = null;
    }

    value() {
      var {
        tag,
        lastRevision,
        lastValue
      } = this;

      if (lastRevision === null || !(0, _reference.validate)(tag, lastRevision)) {
        lastValue = this.lastValue = this.compute();
        this.lastRevision = (0, _reference.value)(tag);
      }

      return lastValue;
    }

  }

  class RootReference extends _reference.ConstReference {
    constructor(value$$1) {
      super(value$$1);
      this.children = Object.create(null);
    }

    static create(value$$1) {
      return valueToRef(value$$1);
    }

    get(propertyKey) {
      var ref = this.children[propertyKey];

      if (ref === undefined) {
        ref = this.children[propertyKey] = new RootPropertyReference(this.inner, propertyKey);
      }

      return ref;
    }

  }

  var TwoWayFlushDetectionTag;

  if (true
  /* DEBUG */
  ) {
    TwoWayFlushDetectionTag = class TwoWayFlushDetectionTag {
      constructor(tag, key, ref) {
        this.tag = tag;
        this.key = key;
        this.ref = ref;
      }

      static create(tag, key, ref) {
        return new TwoWayFlushDetectionTag(tag, key, ref);
      }

      [_reference.COMPUTE]() {
        return this.tag[_reference.COMPUTE]();
      }

      didCompute(parent) {
        (0, _metal.didRender)(parent, this.key, this.ref);
      }

    };
  }

  class PropertyReference extends CachedReference$1 {
    static create(parentReference, propertyKey) {
      if ((0, _reference.isConst)(parentReference)) {
        return valueKeyToRef(parentReference.value(), propertyKey);
      } else {
        return new NestedPropertyReference(parentReference, propertyKey);
      }
    }

    get(key) {
      return new NestedPropertyReference(this, key);
    }

  }

  class RootPropertyReference extends PropertyReference {
    constructor(parentValue, propertyKey) {
      super();
      this.parentValue = parentValue;
      this.propertyKey = propertyKey;
      {
        this.propertyTag = (0, _reference.createUpdatableTag)();
      }

      if (true
      /* DEBUG */
      ) {
        this.tag = TwoWayFlushDetectionTag.create(this.propertyTag, propertyKey, this);
      } else {
        this.tag = this.propertyTag;
      }

      if (true
      /* DEBUG */
      && !true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          (0, _metal.watchKey)(parentValue, propertyKey);
        }
    }

    compute() {
      var {
        parentValue,
        propertyKey
      } = this;

      if (true
      /* DEBUG */
      ) {
        this.tag.didCompute(parentValue);
      }

      var ret;
      {
        var tag = (0, _metal.track)(() => {
          ret = (0, _metal.get)(parentValue, propertyKey);
        });
        (0, _metal.consume)(tag);
        (0, _reference.update)(this.propertyTag, tag);
      }
      return ret;
    }

    [UPDATE](value$$1) {
      (0, _metal.set)(this.parentValue, this.propertyKey, value$$1);
    }

  }

  if (true
  /* DEBUG */
  ) {
    RootPropertyReference.prototype['debug'] = function debug() {
      return "this." + this['propertyKey'];
    };
  }

  class NestedPropertyReference extends PropertyReference {
    constructor(parentReference, propertyKey) {
      super();
      this.parentReference = parentReference;
      this.propertyKey = propertyKey;
      var parentReferenceTag = parentReference.tag;
      var propertyTag = this.propertyTag = (0, _reference.createUpdatableTag)();

      if (true
      /* DEBUG */
      ) {
        var tag = (0, _reference.combine)([parentReferenceTag, propertyTag]);
        this.tag = TwoWayFlushDetectionTag.create(tag, propertyKey, this);
      } else {
        this.tag = (0, _reference.combine)([parentReferenceTag, propertyTag]);
      }
    }

    compute() {
      var {
        parentReference,
        propertyTag,
        propertyKey
      } = this;

      var _parentValue = parentReference.value();

      var parentValueType = typeof _parentValue;

      if (parentValueType === 'string' && propertyKey === 'length') {
        return _parentValue.length;
      }

      if (parentValueType === 'object' && _parentValue !== null || parentValueType === 'function') {
        var parentValue = _parentValue;

        if (true
        /* DEBUG */
        && !true
        /* EMBER_METAL_TRACKED_PROPERTIES */
        ) {
            (0, _metal.watchKey)(parentValue, propertyKey);
          }

        if (true
        /* DEBUG */
        ) {
          this.tag.didCompute(parentValue);
        }

        var ret;
        {
          var tag = (0, _metal.track)(() => {
            ret = (0, _metal.get)(parentValue, propertyKey);
          });
          (0, _metal.consume)(tag);
          (0, _reference.update)(propertyTag, tag);
        }
        return ret;
      } else {
        return undefined;
      }
    }

    [UPDATE](value$$1) {
      (0, _metal.set)(this.parentReference.value()
      /* let the other side handle the error */
      , this.propertyKey, value$$1);
    }

  }

  if (true
  /* DEBUG */
  ) {
    NestedPropertyReference.prototype['debug'] = function debug() {
      var parent = this['parentReference'];
      var parentKey = 'unknownObject';
      var selfKey = this['propertyKey'];

      if (typeof parent['debug'] === 'function') {
        parentKey = parent['debug']();
      }

      return parentKey + "." + selfKey;
    };
  }

  class UpdatableReference extends EmberPathReference {
    constructor(value$$1) {
      super();
      this.tag = (0, _reference.createTag)();
      this._value = value$$1;
    }

    value() {
      return this._value;
    }

    update(value$$1) {
      var {
        _value
      } = this;

      if (value$$1 !== _value) {
        (0, _reference.dirty)(this.tag);
        this._value = value$$1;
      }
    }

  }

  _exports.UpdatableReference = UpdatableReference;

  class ConditionalReference$1 extends _runtime2.ConditionalReference {
    static create(reference) {
      if ((0, _reference.isConst)(reference)) {
        var value$$1 = reference.value();

        if (!(0, _utils.isProxy)(value$$1)) {
          return _runtime2.PrimitiveReference.create(toBool(value$$1));
        }
      }

      return new ConditionalReference$1(reference);
    }

    constructor(reference) {
      super(reference);
      this.objectTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([reference.tag, this.objectTag]);
    }

    toBool(predicate) {
      if ((0, _utils.isProxy)(predicate)) {
        (0, _reference.update)(this.objectTag, (0, _metal.tagForProperty)(predicate, 'isTruthy'));
        return Boolean((0, _metal.get)(predicate, 'isTruthy'));
      } else {
        (0, _reference.update)(this.objectTag, (0, _metal.tagFor)(predicate));
        return toBool(predicate);
      }
    }

  }

  class SimpleHelperReference extends CachedReference$1 {
    constructor(helper$$1, args) {
      super();
      this.helper = helper$$1;
      this.args = args;
      var computeTag = this.computeTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([args.tag, computeTag]);
    }

    static create(helper$$1, args) {
      if ((0, _reference.isConst)(args)) {
        var {
          positional,
          named
        } = args;
        var positionalValue = positional.value();
        var namedValue = named.value();

        if (true
        /* DEBUG */
        ) {
          (0, _debug.debugFreeze)(positionalValue);
          (0, _debug.debugFreeze)(namedValue);
        }

        var result = helper$$1(positionalValue, namedValue);
        return valueToRef(result);
      } else {
        return new SimpleHelperReference(helper$$1, args);
      }
    }

    compute() {
      var {
        helper: helper$$1,
        computeTag,
        args: {
          positional,
          named
        }
      } = this;
      var positionalValue = positional.value();
      var namedValue = named.value();

      if (true
      /* DEBUG */
      ) {
        (0, _debug.debugFreeze)(positionalValue);
        (0, _debug.debugFreeze)(namedValue);
      }

      var computedValue;
      var combinedTrackingTag = (0, _metal.track)(() => computedValue = helper$$1(positionalValue, namedValue));
      (0, _reference.update)(computeTag, combinedTrackingTag);
      return computedValue;
    }

  }

  class ClassBasedHelperReference extends CachedReference$1 {
    constructor(instance, args) {
      super();
      this.instance = instance;
      this.args = args;
      var computeTag = this.computeTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([instance[RECOMPUTE_TAG], args.tag, computeTag]);
    }

    static create(instance, args) {
      return new ClassBasedHelperReference(instance, args);
    }

    compute() {
      var {
        instance,
        computeTag,
        args: {
          positional,
          named
        }
      } = this;
      var positionalValue = positional.value();
      var namedValue = named.value();

      if (true
      /* DEBUG */
      ) {
        (0, _debug.debugFreeze)(positionalValue);
        (0, _debug.debugFreeze)(namedValue);
      }

      var computedValue;
      var combinedTrackingTag = (0, _metal.track)(() => computedValue = instance.compute(positionalValue, namedValue));
      (0, _reference.update)(computeTag, combinedTrackingTag);
      return computedValue;
    }

  }

  class InternalHelperReference extends CachedReference$1 {
    constructor(helper$$1, args) {
      super();
      this.helper = helper$$1;
      this.args = args;
      this.tag = args.tag;
    }

    compute() {
      var {
        helper: helper$$1,
        args
      } = this;
      return helper$$1(args);
    }

  }

  class UnboundReference extends _reference.ConstReference {
    static create(value$$1) {
      return valueToRef(value$$1, false);
    }

    get(key) {
      return valueToRef(this.inner[key], false);
    }

  }

  class ReadonlyReference extends CachedReference$1 {
    constructor(inner) {
      super();
      this.inner = inner;
      this.tag = inner.tag;
    }

    get [INVOKE]() {
      return this.inner[INVOKE];
    }

    compute() {
      return this.inner.value();
    }

    get(key) {
      return this.inner.get(key);
    }

  }

  function referenceFromParts(root, parts) {
    var reference = root;

    for (var i = 0; i < parts.length; i++) {
      reference = reference.get(parts[i]);
    }

    return reference;
  }

  function isObject(value$$1) {
    return value$$1 !== null && typeof value$$1 === 'object';
  }

  function isFunction(value$$1) {
    return typeof value$$1 === 'function';
  }

  function isPrimitive(value$$1) {
    if (true
    /* DEBUG */
    ) {
      var label;

      try {
        label = " (was `" + String(value$$1) + "`)";
      } catch (e) {
        label = null;
      }

      (true && !(value$$1 === undefined || value$$1 === null || typeof value$$1 === 'boolean' || typeof value$$1 === 'number' || typeof value$$1 === 'string') && (0, _debug.assert)("This is a fall-through check for typing purposes only! `value` must already be a primitive at this point." + label + ")", value$$1 === undefined || value$$1 === null || typeof value$$1 === 'boolean' || typeof value$$1 === 'number' || typeof value$$1 === 'string'));
    }

    return true;
  }

  function valueToRef(value$$1, bound = true) {
    if (isObject(value$$1)) {
      // root of interop with ember objects
      return bound ? new RootReference(value$$1) : new UnboundReference(value$$1);
    } else if (isFunction(value$$1)) {
      // ember doesn't do observing with functions
      return new UnboundReference(value$$1);
    } else if (isPrimitive(value$$1)) {
      return _runtime2.PrimitiveReference.create(value$$1);
    } else if (true
    /* DEBUG */
    ) {
      var type = typeof value$$1;
      var output;

      try {
        output = String(value$$1);
      } catch (e) {
        output = null;
      }

      if (output) {
        throw (0, _util.unreachable)("[BUG] Unexpected " + type + " (" + output + ")");
      } else {
        throw (0, _util.unreachable)("[BUG] Unexpected " + type);
      }
    } else {
      throw (0, _util.unreachable)();
    }
  }

  function valueKeyToRef(value$$1, key) {
    if (isObject(value$$1)) {
      // root of interop with ember objects
      return new RootPropertyReference(value$$1, key);
    } else if (isFunction(value$$1)) {
      // ember doesn't do observing with functions
      return new UnboundReference(value$$1[key]);
    } else if (isPrimitive(value$$1)) {
      return _runtime2.UNDEFINED_REFERENCE;
    } else if (true
    /* DEBUG */
    ) {
      var type = typeof value$$1;
      var output;

      try {
        output = String(value$$1);
      } catch (e) {
        output = null;
      }

      if (output) {
        throw (0, _util.unreachable)("[BUG] Unexpected " + type + " (" + output + ")");
      } else {
        throw (0, _util.unreachable)("[BUG] Unexpected " + type);
      }
    } else {
      throw (0, _util.unreachable)();
    }
  }

  var DIRTY_TAG = (0, _utils.symbol)('DIRTY_TAG');
  var ARGS = (0, _utils.symbol)('ARGS');
  var ROOT_REF = (0, _utils.symbol)('ROOT_REF');
  _exports.ROOT_REF = ROOT_REF;
  var IS_DISPATCHING_ATTRS = (0, _utils.symbol)('IS_DISPATCHING_ATTRS');
  var HAS_BLOCK = (0, _utils.symbol)('HAS_BLOCK');
  var BOUNDS = (0, _utils.symbol)('BOUNDS');
  /**
  @module @ember/component
  */

  /**
    A component is an isolated piece of UI, represented by a template and an
    optional class. When a component has a class, its template's `this` value
    is an instance of the component class.
  
    ## Template-only Components
  
    The simplest way to create a component is to create a template file in
    `app/templates/components`. For example, if you name a template
    `app/templates/components/person-profile.hbs`:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
    <img src={{@person.avatar}}>
    <p class='signature'>{{@person.signature}}</p>
    ```
  
    You will be able to use `<PersonProfile />` to invoke this component elsewhere
    in your application:
  
    ```app/templates/application.hbs
    <PersonProfile @person={{this.currentUser}} />
    ```
  
    Note that component names are capitalized here in order to distinguish them
    from regular HTML elements, but they are dasherized in the file system.
  
    While the angle bracket invocation form is generally preferred, it is also
    possible to invoke the same component with the `{{person-profile}}` syntax:
  
    ```app/templates/application.hbs
    {{person-profile person=this.currentUser}}
    ```
  
    Note that with this syntax, you use dashes in the component name and
    arguments are passed without the `@` sign.
  
    In both cases, Ember will render the content of the component template we
    created above. The end result will be something like this:
  
    ```html
    <h1>Tomster</h1>
    <img src="https://emberjs.com/tomster.jpg">
    <p class='signature'>Out of office this week</p>
    ```
  
    ## File System Nesting
  
    Components can be nested inside sub-folders for logical groupping. For
    example, if we placed our template in
    `app/templates/components/person/short-profile.hbs`, we can invoke it as
    `<Person::ShortProfile />`:
  
    ```app/templates/application.hbs
    <Person::ShortProfile @person={{this.currentUser}} />
    ```
  
    Or equivalently, `{{person/short-profile}}`:
  
    ```app/templates/application.hbs
    {{person/short-profile person=this.currentUser}}
    ```
  
    ## Yielding Contents
  
    You can use `yield` inside a template to include the **contents** of any block
    attached to the component. The block will be executed in its original context:
  
    ```handlebars
    <PersonProfile @person={{this.currentUser}}>
      <p>Admin mode</p>
      {{! Executed in the current context. }}
    </PersonProfile>
    ```
  
    or
  
    ```handlebars
    {{#person-profile person=this.currentUser}}
      <p>Admin mode</p>
      {{! Executed in the current context. }}
    {{/person-profile}}
    ```
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
    {{yield}}
    ```
  
    ## Customizing Components With JavaScript
  
    If you want to customize the component in order to handle events, transform
    arguments or maintain internal state, you implement a subclass of `Component`.
  
    One example is to add computed properties to your component:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      displayName: computed('person.title', 'person.firstName', 'person.lastName', function() {
        let { title, firstName, lastName } = this;
  
        if (title) {
          return `${title} ${lastName}`;
        } else {
          return `${firstName} ${lastName}`;
        }
      })
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{this.displayName}}</h1>
    {{yield}}
    ```
  
    ## Customizing a Component's HTML Element in JavaScript
  
    ### HTML Tag
  
    The default HTML tag name used for a component's HTML representation is `div`.
    This can be customized by setting the `tagName` property.
  
    Consider the following component class:
  
    ```app/components/emphasized-paragraph.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'em'
    });
    ```
  
    When invoked, this component would produce output that looks something like
    this:
  
    ```html
    <em id="ember1" class="ember-view"></em>
    ```
  
    ### HTML `class` Attribute
  
    The HTML `class` attribute of a component's tag can be set by providing a
    `classNames` property that is set to an array of strings:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNames: ['my-class', 'my-other-class']
    });
    ```
  
    Invoking this component will produce output that looks like this:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class"></div>
    ```
  
    `class` attribute values can also be set by providing a `classNameBindings`
    property set to an array of properties names for the component. The return
    value of these properties will be added as part of the value for the
    components's `class` attribute. These properties can be computed properties:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      classNames: ['my-class', 'my-other-class'],
      classNameBindings: ['propertyA', 'propertyB'],
  
      propertyA: 'from-a',
      propertyB: computed(function() {
        if (someLogic) { return 'from-b'; }
      })
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class from-a from-b"></div>
    ```
  
    Note that `classNames` and `classNameBindings` is in addition to the `class`
    attribute passed with the angle bracket invocation syntax. Therefore, if this
    component was invoked like so:
  
    ```handlebars
    <MyWidget class="from-invocation" />
    ```
  
    The resulting HTML will look similar to this:
  
    ```html
    <div id="ember1" class="from-invocation ember-view my-class my-other-class from-a from-b"></div>
    ```
  
    If the value of a class name binding returns a boolean the property name
    itself will be used as the class name if the property is true. The class name
    will not be added if the value is `false` or `undefined`.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['hovered'],
  
      hovered: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view hovered"></div>
    ```
  
    ### Custom Class Names for Boolean Values
  
    When using boolean class name bindings you can supply a string value other
    than the property name for use as the `class` HTML attribute by appending the
    preferred value after a ":" character when defining the binding:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['awesome:so-very-cool'],
  
      awesome: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view so-very-cool"></div>
    ```
  
    Boolean value class name bindings whose property names are in a
    camelCase-style format will be converted to a dasherized format:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isUrgent'],
  
      isUrgent: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view is-urgent"></div>
    ```
  
    Class name bindings can also refer to object values that are found by
    traversing a path relative to the component itself:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import EmberObject from '@ember/object';
  
    export default Component.extend({
      classNameBindings: ['messages.empty'],
  
      messages: EmberObject.create({
        empty: true
      })
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view empty"></div>
    ```
  
    If you want to add a class name for a property which evaluates to true and
    and a different class name if it evaluates to false, you can pass a binding
    like this:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isEnabled:enabled:disabled'],
      isEnabled: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view enabled"></div>
    ```
  
    When isEnabled is `false`, the resulting HTML representation looks like this:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    This syntax offers the convenience to add a class if a property is `false`:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    // Applies no class when isEnabled is true and class 'disabled' when isEnabled is false
    export default Component.extend({
      classNameBindings: ['isEnabled::disabled'],
      isEnabled: true
    });
    ```
  
    Invoking this component when the `isEnabled` property is true will produce
    HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view"></div>
    ```
  
    Invoking it when the `isEnabled` property on the component is `false` will
    produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    Updates to the value of a class name binding will result in automatic update
    of the  HTML `class` attribute in the component's rendered HTML
    representation. If the value becomes `false` or `undefined` the class name
    will be removed.
  
    Both `classNames` and `classNameBindings` are concatenated properties. See
    [EmberObject](/ember/release/classes/EmberObject) documentation for more
    information about concatenated properties.
  
    ### Other HTML Attributes
  
    The HTML attribute section of a component's tag can be set by providing an
    `attributeBindings` property set to an array of property names on the component.
    The return value of these properties will be used as the value of the component's
    HTML associated attribute:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['href'],
  
      href: 'http://google.com'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    One property can be mapped on to another by placing a ":" between
    the source property and the destination property:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['url:href'],
  
      url: 'http://google.com'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    HTML attributes passed with angle bracket invocations will take precedence
    over those specified in `attributeBindings`. Therefore, if this component was
    invoked like so:
  
    ```handlebars
    <MyAnchor href="http://bing.com" @url="http://google.com" />
    ```
  
    The resulting HTML will looks like this:
  
    ```html
    <a id="ember1" class="ember-view" href="http://bing.com"></a>
    ```
  
    Note that the `href` attribute is ultimately set to `http://bing.com`,
    despite it having attribute binidng to the `url` property, which was
    set to `http://google.com`.
  
    Namespaced attributes (e.g. `xlink:href`) are supported, but have to be
    mapped, since `:` is not a valid character for properties in Javascript:
  
    ```app/components/my-use.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'use',
      attributeBindings: ['xlinkHref:xlink:href'],
  
      xlinkHref: '#triangle'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <use xlink:href="#triangle"></use>
    ```
  
    If the value of a property monitored by `attributeBindings` is a boolean, the
    attribute will be present or absent depending on the value:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: false
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <input id="ember1" class="ember-view" />
    ```
  
    `attributeBindings` can refer to computed properties:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: computed(function() {
        if (someLogic) {
          return true;
        } else {
          return false;
        }
      })
    });
    ```
  
    To prevent setting an attribute altogether, use `null` or `undefined` as the
    value of the property used in `attributeBindings`:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'form',
      attributeBindings: ['novalidate'],
      novalidate: null
    });
    ```
  
    Updates to the property of an attribute binding will result in automatic
    update of the  HTML attribute in the component's HTML output.
  
    `attributeBindings` is a concatenated property. See
    [EmberObject](/ember/release/classes/EmberObject) documentation for more
    information about concatenated properties.
  
    ## Layouts
  
    The `layout` property can be used to dynamically specify a template associated
    with a component class, instead of relying on Ember to link together a
    component class and a template based on file names.
  
    In general, applications should not use this feature, but it's commonly used
    in addons for historical reasons.
  
    The `layout` property should be set to the default export of a template
    module, which is the name of a template file without the `.hbs` extension.
  
    ```app/templates/components/person-profile.hbs
    <h1>Person's Title</h1>
    <div class='details'>{{yield}}</div>
    ```
  
    ```app/components/person-profile.js
      import Component from '@ember/component';
      import layout from '../templates/components/person-profile';
  
      export default Component.extend({
        layout
      });
    ```
  
    If you invoke the component:
  
    ```handlebars
    <PersonProfile>
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    </PersonProfile>
    ```
  
    or
  
    ```handlebars
    {{#person-profile}}
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    {{/person-profile}}
    ```
  
    It will result in the following HTML output:
  
    ```html
    <h1>Person's Title</h1>
      <div class="details">
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    </div>
    ```
  
    ## Handling Browser Events
  
    Components can respond to user-initiated events in one of three ways: passing
    actions with angle bracket invocation, adding event handler methods to the
    component's class, or adding actions to the component's template.
  
    ### Passing Actions With Angle Bracket Invoation
  
    For one-off events specific to particular instance of a component, it is possible
    to pass actions to the component's element using angle bracket invoation syntax.
  
    ```handlebars
    <MyWidget {{action 'firstWidgetClicked'}} />
  
    <MyWidget {{action 'secondWidgetClicked'}} />
    ```
  
    In this case, when the first component is clicked on, Ember will invoke the
    `firstWidgetClicked` action. When the second component is clicked on, Ember
    will invoke the `secondWidgetClicked` action instead.
  
    Besides `{{action}}`, it is also possible to pass any arbitrary element modifiers
    using the angle bracket invocation syntax.
  
    ### Event Handler Methods
  
    Components can also respond to user-initiated events by implementing a method
    that matches the event name. This approach is appropiate when the same event
    should be handled by all instances of the same component.
  
    An event object will be passed as the argument to the event handler method.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click(event) {
        // `event.target` is either the component's element or one of its children
        let tag = event.target.tagName.toLowerCase();
        console.log('clicked on a `<${tag}>` HTML element!');
      }
    });
    ```
  
    In this example, whenever the user clicked anywhere inside the component, it
    will log a message to the console.
  
    It is possible to handle event types other than `click` by implementing the
    following event handler methods. In addition, custom events can be registered
    by using `Application.customEvents`.
  
    Touch events:
  
    * `touchStart`
    * `touchMove`
    * `touchEnd`
    * `touchCancel`
  
    Keyboard events:
  
    * `keyDown`
    * `keyUp`
    * `keyPress`
  
    Mouse events:
  
    * `mouseDown`
    * `mouseUp`
    * `contextMenu`
    * `click`
    * `doubleClick`
    * `focusIn`
    * `focusOut`
  
    Form events:
  
    * `submit`
    * `change`
    * `focusIn`
    * `focusOut`
    * `input`
  
    Drag and drop events:
  
    * `dragStart`
    * `drag`
    * `dragEnter`
    * `dragLeave`
    * `dragOver`
    * `dragEnd`
    * `drop`
  
    ### `{{action}}` Helper
  
    Instead of handling all events of a particular type anywhere inside the
    component's element, you may instead want to limit it to a particular
    element in the component's template. In this case, it would be more
    convenient to implement an action instead.
  
    For example, you could implement the action `hello` for the `person-profile`
    component:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        hello(name) {
          console.log("Hello", name);
        }
      }
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
  
    <button {{action 'hello' @person.name}}>
      Say Hello to {{@person.name}}
    </button>
    ```
  
    When the user clicks the button, Ember will invoke the `hello` action,
    passing in the current value of `@person.name` as an argument.
  
    See [Ember.Templates.helpers.action](/ember/release/classes/Ember.Templates.helpers/methods/action?anchor=action).
  
    @class Component
    @extends Ember.CoreView
    @uses Ember.TargetActionSupport
    @uses Ember.ClassNamesSupport
    @uses Ember.ActionSupport
    @uses Ember.ViewMixin
    @uses Ember.ViewStateSupport
    @public
  */

  var Component = _views.CoreView.extend(_views.ChildViewsSupport, _views.ViewStateSupport, _views.ClassNamesSupport, _runtime.TargetActionSupport, _views.ActionSupport, _views.ViewMixin, {
    isComponent: true,

    init() {
      this._super(...arguments);

      this[IS_DISPATCHING_ATTRS] = false;
      this[DIRTY_TAG] = (0, _reference.createTag)();
      this[ROOT_REF] = new RootReference(this);
      this[BOUNDS] = null;

      if (true
      /* DEBUG */
      && this.renderer._destinedForDOM && this.tagName === '') {
        var eventNames = [];
        var eventDispatcher = (0, _owner.getOwner)(this).lookup('event_dispatcher:main');
        var events = eventDispatcher && eventDispatcher._finalEvents || {}; // tslint:disable-next-line:forin

        for (var key in events) {
          var methodName = events[key];

          if (typeof this[methodName] === 'function') {
            eventNames.push(methodName);
          }
        } // If in a tagless component, assert that no event handlers are defined


        (true && !(!eventNames.length) && (0, _debug.assert)( // tslint:disable-next-line:max-line-length
        "You can not define `" + eventNames + "` function(s) to handle DOM event in the `" + this + "` tagless component since it doesn't have any DOM element.", !eventNames.length));
      }

      (true && !(this.mouseEnter === undefined) && (0, _debug.deprecate)("Using `mouseEnter` event handler methods in components has been deprecated.", this.mouseEnter === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move'
      }));
      (true && !(this.mouseLeave === undefined) && (0, _debug.deprecate)("Using `mouseLeave` event handler methods in components has been deprecated.", this.mouseLeave === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move'
      }));
      (true && !(this.mouseMove === undefined) && (0, _debug.deprecate)("Using `mouseMove` event handler methods in components has been deprecated.", this.mouseMove === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move'
      }));
    },

    rerender() {
      (0, _reference.dirty)(this[DIRTY_TAG]);

      this._super();
    },

    [_metal.PROPERTY_DID_CHANGE](key) {
      if (this[IS_DISPATCHING_ATTRS]) {
        return;
      }

      var args = this[ARGS];
      var reference = args !== undefined ? args[key] : undefined;

      if (reference !== undefined && reference[UPDATE] !== undefined) {
        reference[UPDATE]((0, _metal.get)(this, key));
      }
    },

    getAttr(key) {
      // TODO Intimate API should be deprecated
      return this.get(key);
    },

    /**
      Normally, Ember's component model is "write-only". The component takes a
      bunch of attributes that it got passed in, and uses them to render its
      template.
       One nice thing about this model is that if you try to set a value to the
      same thing as last time, Ember (through HTMLBars) will avoid doing any
      work on the DOM.
       This is not just a performance optimization. If an attribute has not
      changed, it is important not to clobber the element's "hidden state".
      For example, if you set an input's `value` to the same value as before,
      it will clobber selection state and cursor position. In other words,
      setting an attribute is not **always** idempotent.
       This method provides a way to read an element's attribute and also
      update the last value Ember knows about at the same time. This makes
      setting an attribute idempotent.
       In particular, what this means is that if you get an `<input>` element's
      `value` attribute and then re-render the template with the same value,
      it will avoid clobbering the cursor and selection position.
      Since most attribute sets are idempotent in the browser, you typically
      can get away with reading attributes using jQuery, but the most reliable
      way to do so is through this method.
      @method readDOMAttr
       @param {String} name the name of the attribute
      @return String
      @public
     */
    readDOMAttr(name) {
      // TODO revisit this
      var _element = (0, _views.getViewElement)(this);

      (true && !(_element !== null) && (0, _debug.assert)("Cannot call `readDOMAttr` on " + this + " which does not have an element", _element !== null));
      var element = _element;
      var isSVG = element.namespaceURI === _runtime2.SVG_NAMESPACE;
      var {
        type,
        normalized
      } = (0, _runtime2.normalizeProperty)(element, name);

      if (isSVG || type === 'attr') {
        return element.getAttribute(normalized);
      }

      return element[normalized];
    },

    /**
     The WAI-ARIA role of the control represented by this view. For example, a
     button may have a role of type 'button', or a pane may have a role of
     type 'alertdialog'. This property is used by assistive software to help
     visually challenged users navigate rich web applications.
      The full list of valid WAI-ARIA roles is available at:
     [https://www.w3.org/TR/wai-aria/#roles_categorization](https://www.w3.org/TR/wai-aria/#roles_categorization)
      @property ariaRole
     @type String
     @default null
     @public
     */

    /**
     Enables components to take a list of parameters as arguments.
     For example, a component that takes two parameters with the names
     `name` and `age`:
      ```app/components/my-component.js
     import Component from '@ember/component';
      let MyComponent = Component.extend();
      MyComponent.reopenClass({
       positionalParams: ['name', 'age']
     });
      export default MyComponent;
     ```
      It can then be invoked like this:
      ```hbs
     {{my-component "John" 38}}
     ```
      The parameters can be referred to just like named parameters:
      ```hbs
     Name: {{name}}, Age: {{age}}.
     ```
      Using a string instead of an array allows for an arbitrary number of
     parameters:
      ```app/components/my-component.js
     import Component from '@ember/component';
      let MyComponent = Component.extend();
      MyComponent.reopenClass({
       positionalParams: 'names'
     });
      export default MyComponent;
     ```
      It can then be invoked like this:
      ```hbs
     {{my-component "John" "Michael" "Scott"}}
     ```
     The parameters can then be referred to by enumerating over the list:
      ```hbs
     {{#each names as |name|}}{{name}}{{/each}}
     ```
      @static
     @public
     @property positionalParams
     @since 1.13.0
     */

    /**
     Called when the attributes passed into the component have been updated.
     Called both during the initial render of a container and during a rerender.
     Can be used in place of an observer; code placed here will be executed
     every time any attribute updates.
     @method didReceiveAttrs
     @public
     @since 1.13.0
     */
    didReceiveAttrs() {},

    /**
     Called when the attributes passed into the component have been updated.
     Called both during the initial render of a container and during a rerender.
     Can be used in place of an observer; code placed here will be executed
     every time any attribute updates.
     @event didReceiveAttrs
     @public
     @since 1.13.0
     */

    /**
     Called after a component has been rendered, both on initial render and
     in subsequent rerenders.
     @method didRender
     @public
     @since 1.13.0
     */
    didRender() {},

    /**
     Called after a component has been rendered, both on initial render and
     in subsequent rerenders.
     @event didRender
     @public
     @since 1.13.0
     */

    /**
     Called before a component has been rendered, both on initial render and
     in subsequent rerenders.
     @method willRender
     @public
     @since 1.13.0
     */
    willRender() {},

    /**
     Called before a component has been rendered, both on initial render and
     in subsequent rerenders.
     @event willRender
     @public
     @since 1.13.0
     */

    /**
     Called when the attributes passed into the component have been changed.
     Called only during a rerender, not during an initial render.
     @method didUpdateAttrs
     @public
     @since 1.13.0
     */
    didUpdateAttrs() {},

    /**
     Called when the attributes passed into the component have been changed.
     Called only during a rerender, not during an initial render.
     @event didUpdateAttrs
     @public
     @since 1.13.0
     */

    /**
     Called when the component is about to update and rerender itself.
     Called only during a rerender, not during an initial render.
     @method willUpdate
     @public
     @since 1.13.0
     */
    willUpdate() {},

    /**
     Called when the component is about to update and rerender itself.
     Called only during a rerender, not during an initial render.
     @event willUpdate
     @public
     @since 1.13.0
     */

    /**
     Called when the component has updated and rerendered itself.
     Called only during a rerender, not during an initial render.
     @method didUpdate
     @public
     @since 1.13.0
     */
    didUpdate() {}

  });

  _exports.Component = Component;

  Component.toString = () => '@ember/component';

  Component.reopenClass({
    isComponentFactory: true,
    positionalParams: []
  });
  (0, _runtime.setFrameworkClass)(Component);
  var layout = template({
    "id": "hvtsz7RF",
    "block": "{\"symbols\":[],\"statements\":[],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/empty.hbs"
    }
  });
  /**
  @module @ember/component
  */

  /**
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `checkbox`.
  
    See [Ember.Templates.helpers.input](/ember/release/classes/Ember.Templates.helpers/methods/input?anchor=input)  for usage details.
  
    ## Direct manipulation of `checked`
  
    The `checked` attribute of an `Checkbox` object should always be set
    through the Ember object or by interacting with its rendered element
    representation via the mouse, keyboard, or touch. Updating the value of the
    checkbox via jQuery will result in the checked value of the object and its
    element losing synchronization.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied.
  
    @class Checkbox
    @extends Component
    @public
  */

  var Checkbox = Component.extend({
    layout,

    /**
      By default, this component will add the `ember-checkbox` class to the component's element.
         @property classNames
      @type Array | String
      @default ['ember-checkbox']
      @public
     */
    classNames: ['ember-checkbox'],
    tagName: 'input',

    /**
      By default this component will forward a number of arguments to attributes on the the
      component's element:
         * indeterminate
      * disabled
      * tabindex
      * name
      * autofocus
      * required
      * form
         When invoked with curly braces, this is the exhaustive list of HTML attributes you can
      customize (i.e. `{{input type="checkbox" disabled=true}}`).
         When invoked with angle bracket invocation, this list is irrelevant, because you can use HTML
      attribute syntax to customize the element (i.e.
      `<Input @type="checkbox" disabled data-custom="custom value" />`). However, `@type` and
      `@checked` must be passed as named arguments, not attributes.
         @property attributeBindings
      @type Array | String
      @default ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form']
      @public
    */
    attributeBindings: ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form'],

    /**
      Sets the `type` attribute of the `Checkbox`'s element
         @property disabled
      @default false
      @private
     */
    type: 'checkbox',

    /**
      Sets the `disabled` attribute of the `Checkbox`'s element
         @property disabled
      @default false
      @public
     */
    disabled: false,

    /**
      Corresponds to the `indeterminate` property of the `Checkbox`'s element
         @property disabled
      @default false
      @public
     */
    indeterminate: false,

    /**
      Whenever the checkbox is inserted into the DOM, perform initialization steps, which include
      setting the indeterminate property if needed.
         If this method is overridden, `super` must be called.
         @method
      @public
     */
    didInsertElement() {
      this._super(...arguments);

      this.element.indeterminate = Boolean(this.indeterminate);
    },

    /**
      Whenever the `change` event is fired on the checkbox, update its `checked` property to reflect
      whether the checkbox is checked.
         If this method is overridden, `super` must be called.
         @method
      @public
     */
    change() {
      (0, _metal.set)(this, 'checked', this.element.checked);
    }

  });
  _exports.Checkbox = Checkbox;

  if (true
  /* DEBUG */
  ) {
    var UNSET = {};
    Checkbox.reopen({
      value: UNSET,

      didReceiveAttrs() {
        this._super();

        (true && !(!(this.type === 'checkbox' && this.value !== UNSET)) && (0, _debug.assert)("`<Input @type='checkbox' @value={{...}} />` is not supported; " + "please use `<Input @type='checkbox' @checked={{...}} />` instead.", !(this.type === 'checkbox' && this.value !== UNSET)));
      }

    });
  }

  Checkbox.toString = () => '@ember/component/checkbox';
  /**
  @module @ember/component
  */


  var inputTypes = _browserEnvironment.hasDOM ? Object.create(null) : null;

  function canSetTypeOfInput(type) {
    // if running in outside of a browser always return
    // the original type
    if (!_browserEnvironment.hasDOM) {
      return Boolean(type);
    }

    if (type in inputTypes) {
      return inputTypes[type];
    }

    var inputTypeTestElement = document.createElement('input');

    try {
      inputTypeTestElement.type = type;
    } catch (e) {// ignored
    }

    return inputTypes[type] = inputTypeTestElement.type === type;
  }
  /**
    The internal class used to create text inputs when the `Input` component is used with `type` of `text`.
  
    See [Ember.Templates.components.Input](/ember/release/classes/Ember.Templates.components/methods/Input?anchor=Input) for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied.
  
    @class TextField
    @extends Component
    @uses Ember.TextSupport
    @public
  */


  var TextField = Component.extend(_views.TextSupport, {
    layout,

    /**
      By default, this component will add the `ember-text-field` class to the component's element.
         @property classNames
      @type Array | String
      @default ['ember-text-field']
      @public
     */
    classNames: ['ember-text-field'],
    tagName: 'input',

    /**
      By default this component will forward a number of arguments to attributes on the the
      component's element:
         * accept
      * autocomplete
      * autosave
      * dir
      * formaction
      * formenctype
      * formmethod
      * formnovalidate
      * formtarget
      * height
      * inputmode
      * lang
      * list
      * type
      * max
      * min
      * multiple
      * name
      * pattern
      * size
      * step
      * value
      * width
         When invoked with `{{input type="text"}}`, you can only customize these attributes. When invoked
      with `<Input @type="text" />`, you can just use HTML attributes directly.
         @property attributeBindings
      @type Array | String
      @default ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'type', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'value', 'width']
      @public
    */
    attributeBindings: ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'type', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'value', 'width'],

    /**
      As the user inputs text, this property is updated to reflect the `value` property of the HTML
      element.
         @property value
      @type String
      @default ""
      @public
    */
    value: '',

    /**
      The `type` attribute of the input element.
         @property type
      @type String
      @default "text"
      @public
    */
    type: (0, _metal.computed)({
      get() {
        return 'text';
      },

      set(_key, value$$1) {
        var type = 'text';

        if (canSetTypeOfInput(value$$1)) {
          type = value$$1;
        }

        return type;
      }

    }),

    /**
      The `size` of the text field in characters.
         @property size
      @type String
      @default null
      @public
    */
    size: null,

    /**
      The `pattern` attribute of input element.
         @property pattern
      @type String
      @default null
      @public
    */
    pattern: null,

    /**
      The `min` attribute of input element used with `type="number"` or `type="range"`.
         @property min
      @type String
      @default null
      @since 1.4.0
      @public
    */
    min: null,

    /**
      The `max` attribute of input element used with `type="number"` or `type="range"`.
         @property max
      @type String
      @default null
      @since 1.4.0
      @public
    */
    max: null
  });
  _exports.TextField = TextField;

  TextField.toString = () => '@ember/component/text-field';
  /**
  @module @ember/component
  */

  /**
    The `Textarea` component inserts a new instance of `<textarea>` tag into the template.
  
    The `@value` argument provides the content of the `<textarea>`.
  
    This template:
  
    ```handlebars
    <Textarea @value="A bunch of text" />
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      A bunch of text
    </textarea>
    ```
  
    The `@value` argument is two-way bound. If the user types text into the textarea, the `@value`
    argument is updated. If the `@value` argument is updated, the text in the textarea is updated.
  
    In the following example, the `writtenWords` property on the component will be updated as the user
    types 'Lots of text' into the text area of their browser's window.
  
    ```app/components/word-editor.js
    import Component from '@glimmer/component';
    import { tracked } from '@glimmer/tracking';
  
    export default class WordEditorComponent extends Component {
      @tracked writtenWords = "Lots of text that IS bound";
    }
    ```
  
    ```handlebars
    <Textarea @value={{writtenWords}} />
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    If you wanted a one way binding, you could use the `<textarea>` element directly, and use the
    `value` DOM property and the `input` event.
  
    ### Actions
  
    The `Textarea` component takes a number of arguments with callbacks that are invoked in
    response to user events.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
  
    These callbacks are passed to `Textarea` like this:
  
    ```handlebars
    <Textarea @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    ## Classic Invocation Syntax
  
    The `Textarea` component can also be invoked using curly braces, just like any other Ember
    component.
  
    For example, this is an invocation using angle-bracket notation:
  
    ```handlebars
    <Textarea @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    You could accomplish the same thing using classic invocation:
  
    ```handlebars
    {{textarea value=this.searchWord enter=this.query}}
    ```
  
    The main difference is that angle-bracket invocation supports any HTML attribute using HTML
    attribute syntax, because attributes and arguments have different syntax when using angle-bracket
    invocation. Curly brace invocation, on the other hand, only has a single syntax for arguments,
    and components must manually map attributes onto component arguments.
  
    When using classic invocation with `{{textarea}}`, only the following attributes are mapped onto
    arguments:
  
    * rows
    * cols
    * name
    * selectionEnd
    * selectionStart
    * autocomplete
    * wrap
    * lang
    * dir
    * value
  
    ## Classic `layout` and `layoutName` properties
  
    Because HTML `textarea` elements do not contain inner HTML the `layout` and
    `layoutName` properties will not be applied.
  
    @method Textarea
    @for Ember.Templates.components
    @see {TextArea}
    @public
  */

  /**
    See Ember.Templates.components.Textarea.
  
    @method textarea
    @for Ember.Templates.helpers
    @see {Ember.Templates.components.textarea}
    @public
  */

  /**
    The internal representation used for `Textarea` invocations.
  
    @class TextArea
    @extends Component
    @see {Ember.Templates.components.Textarea}
    @uses Ember.TextSupport
    @public
  */


  var TextArea = Component.extend(_views.TextSupport, {
    classNames: ['ember-text-area'],
    layout,
    tagName: 'textarea',
    attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'autocomplete', 'wrap', 'lang', 'dir', 'value'],
    rows: null,
    cols: null
  });
  _exports.TextArea = TextArea;

  TextArea.toString = () => '@ember/component/text-area';

  var layout$1 = template({
    "id": "giTNx+op",
    "block": "{\"symbols\":[\"&default\"],\"statements\":[[4,\"if\",[[25,1]],null,{\"statements\":[[14,1]],\"parameters\":[]},{\"statements\":[[1,[23,0,[\"linkTitle\"]],false]],\"parameters\":[]}]],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/link-to.hbs"
    }
  });
  /**
  @module ember
  */

  /**
    The `LinkTo` component renders a link to the supplied `routeName` passing an optionally
    supplied model to the route as its `model` context of the route. The block for `LinkTo`
    becomes the contents of the rendered element:
  
    ```handlebars
    <LinkTo @route='photoGallery'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    This will result in:
  
    ```html
    <a href="/hamster-photos">
      Great Hamster Photos
    </a>
    ```
  
    ### Disabling the `LinkTo` component
  
    The `LinkTo` component can be disabled by using the `disabled` argument. A disabled link
    doesn't result in a transition when activated, and adds the `disabled` class to the `<a>`
    element.
  
    (The class name to apply to the element can be overridden by using the `disabledClass`
    argument)
  
    ```handlebars
    <LinkTo @route='photoGallery' @disabled={{true}}>
      Great Hamster Photos
    </LinkTo>
    ```
  
    ### Handling `href`
  
    `<LinkTo>` will use your application's Router to fill the element's `href` property with a URL
    that matches the path to the supplied `routeName`.
  
    ### Handling current route
  
    The `LinkTo` component will apply a CSS class name of 'active' when the application's current
    route matches the supplied routeName. For example, if the application's current route is
    'photoGallery.recent', then the following invocation of `LinkTo`:
  
    ```handlebars
    <LinkTo @route='photoGallery.recent'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    will result in
  
    ```html
    <a href="/hamster-photos/this-week" class="active">
      Great Hamster Photos
    </a>
    ```
  
    The CSS class used for active classes can be customized by passing an `activeClass` argument:
  
    ```handlebars
    <LinkTo @route='photoGallery.recent' @activeClass="current-url">
      Great Hamster Photos
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/this-week" class="current-url">
      Great Hamster Photos
    </a>
    ```
  
    ### Keeping a link active for other routes
  
    If you need a link to be 'active' even when it doesn't match the current route, you can use the
    `current-when` argument.
  
    ```handlebars
    <LinkTo @route='photoGallery' @current-when='photos'>
      Photo Gallery
    </LinkTo>
    ```
  
    This may be helpful for keeping links active for:
  
    * non-nested routes that are logically related
    * some secondary menu approaches
    * 'top navigation' with 'sub navigation' scenarios
  
    A link will be active if `current-when` is `true` or the current
    route is the route this link would transition to.
  
    To match multiple routes 'space-separate' the routes:
  
    ```handlebars
    <LinkTo @route='gallery' @current-when='photos drawings paintings'>
      Art Gallery
    </LinkTo>
    ```
  
    ### Supplying a model
  
    An optional `model` argument can be used for routes whose
    paths contain dynamic segments. This argument will become
    the model context of the linked route:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", {path: "hamster-photos/:photo_id"});
    });
    ```
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{this.aPhoto}}>
      {{aPhoto.title}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    ### Supplying multiple models
  
    For deep-linking to route paths that contain multiple
    dynamic segments, the `models` argument can be used.
  
    As the router transitions through the route path, each
    supplied model argument will become the context for the
    route with the dynamic segments:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" }, function() {
        this.route("comment", {path: "comments/:comment_id"});
      });
    });
    ```
  
    This argument will become the model context of the linked route:
  
    ```handlebars
    <LinkTo @route='photoGallery.comment' @models={{array this.aPhoto this.comment}}>
      {{comment.body}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42/comments/718">
      A+++ would snuggle again.
    </a>
    ```
  
    ### Supplying an explicit dynamic segment value
  
    If you don't have a model object available to pass to `LinkTo`,
    an optional string or integer argument can be passed for routes whose
    paths contain dynamic segments. This argument will become the value
    of the dynamic segment:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" });
    });
    ```
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{aPhotoId}}>
      {{this.aPhoto.title}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    When transitioning into the linked route, the `model` hook will
    be triggered with parameters including this passed identifier.
  
    ### Allowing Default Action
  
    By default the `<LinkTo>` component prevents the default browser action by calling
    `preventDefault()` to avoid reloading the browser page.
  
    If you need to trigger a full browser reload pass `@preventDefault={{false}}`:
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{this.aPhotoId}} @preventDefault={{false}}>
      {{this.aPhotoId.title}}
    </LinkTo>
    ```
  
    ### Supplying a `tagName`
  
    By default `<LinkTo>` renders an `<a>` element. This can be overridden for a single use of
    `<LinkTo>` by supplying a `tagName` argument:
  
    ```handlebars
    <LinkTo @route='photoGallery' @tagName='li'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    This produces:
  
    ```html
    <li>
      Great Hamster Photos
    </li>
    ```
  
    In general, this is not recommended. Instead, you can use the `transition-to` helper together
    with a click event handler on the HTML tag of your choosing.
  
    @for Ember.Templates.components
    @method LinkTo
    @see {LinkComponent}
    @public
  */

  /**
    @module @ember/routing
  */

  /**
    See [Ember.Templates.components.LinkTo](/ember/release/classes/Ember.Templates.components/methods/input?anchor=LinkTo).
  
    @for Ember.Templates.helpers
    @method link-to
    @see {Ember.Templates.components.LinkTo}
    @public
  **/

  /**
    `LinkComponent` is the internal component invoked with `<LinkTo>` or `{{link-to}}`.
  
    @class LinkComponent
    @extends Component
    @see {Ember.Templates.components.LinkTo}
    @public
  **/

  var UNDEFINED = Object.freeze({
    toString() {
      return 'UNDEFINED';
    }

  });
  var EMPTY_QUERY_PARAMS = Object.freeze({});
  var LinkComponent = Component.extend({
    layout: layout$1,
    tagName: 'a',

    /**
      @property route
      @public
    */
    route: UNDEFINED,

    /**
      @property model
      @public
    */
    model: UNDEFINED,

    /**
      @property models
      @public
    */
    models: UNDEFINED,

    /**
      @property query
      @public
    */
    query: UNDEFINED,

    /**
      Used to determine when this `LinkComponent` is active.
         @property current-when
      @public
    */
    'current-when': null,

    /**
      Sets the `title` attribute of the `LinkComponent`'s HTML element.
         @property title
      @default null
      @public
    **/
    title: null,

    /**
      Sets the `rel` attribute of the `LinkComponent`'s HTML element.
         @property rel
      @default null
      @public
    **/
    rel: null,

    /**
      Sets the `tabindex` attribute of the `LinkComponent`'s HTML element.
         @property tabindex
      @default null
      @public
    **/
    tabindex: null,

    /**
      Sets the `target` attribute of the `LinkComponent`'s HTML element.
         @since 1.8.0
      @property target
      @default null
      @public
    **/
    target: null,

    /**
      The CSS class to apply to `LinkComponent`'s element when its `active`
      property is `true`.
         @property activeClass
      @type String
      @default active
      @public
    **/
    activeClass: 'active',

    /**
      The CSS class to apply to `LinkComponent`'s element when its `loading`
      property is `true`.
         @property loadingClass
      @type String
      @default loading
      @private
    **/
    loadingClass: 'loading',

    /**
      The CSS class to apply to a `LinkComponent`'s element when its `disabled`
      property is `true`.
         @property disabledClass
      @type String
      @default disabled
      @private
    **/
    disabledClass: 'disabled',

    /**
      Determines whether the `LinkComponent` will trigger routing via
      the `replaceWith` routing strategy.
         @property replace
      @type Boolean
      @default false
      @public
    **/
    replace: false,

    /**
      By default this component will forward `href`, `title`, `rel`, `tabindex`, and `target`
      arguments to attributes on the component's element. When invoked with `{{link-to}}`, you can
      only customize these attributes. When invoked with `<LinkTo>`, you can just use HTML
      attributes directly.
         @property attributeBindings
      @type Array | String
      @default ['title', 'rel', 'tabindex', 'target']
      @public
    */
    attributeBindings: ['href', 'title', 'rel', 'tabindex', 'target'],

    /**
      By default this component will set classes on its element when any of the following arguments
      are truthy:
         * active
      * loading
      * disabled
         When these arguments are truthy, a class with the same name will be set on the element. When
      falsy, the associated class will not be on the element.
         @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled', 'ember-transitioning-in', 'ember-transitioning-out']
      @public
    */
    classNameBindings: ['active', 'loading', 'disabled', 'transitioningIn', 'transitioningOut'],

    /**
      By default this component responds to the `click` event. When the component element is an
      `<a>` element, activating the link in another way, such as using the keyboard, triggers the
      click event.
         @property eventName
      @type String
      @default click
      @private
    */
    eventName: 'click',

    // this is doc'ed here so it shows up in the events
    // section of the API documentation, which is where
    // people will likely go looking for it.

    /**
      Triggers the `LinkComponent`'s routing behavior. If
      `eventName` is changed to a value other than `click`
      the routing behavior will trigger on that custom event
      instead.
         @event click
      @private
    */

    /**
      An overridable method called when `LinkComponent` objects are instantiated.
         Example:
         ```app/components/my-link.js
      import LinkComponent from '@ember/routing/link-component';
         export default LinkComponent.extend({
        init() {
          this._super(...arguments);
          console.log('Event is ' + this.get('eventName'));
        }
      });
      ```
         NOTE: If you do override `init` for a framework class like `Component`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
         @method init
      @private
    */
    init() {
      this._super(...arguments); // Map desired event name to invoke function


      var {
        eventName
      } = this;
      this.on(eventName, this, this._invoke);
    },

    _routing: (0, _service.inject)('-routing'),
    _currentRoute: (0, _metal.alias)('_routing.currentRouteName'),
    _currentRouterState: (0, _metal.alias)('_routing.currentState'),
    _targetRouterState: (0, _metal.alias)('_routing.targetState'),
    _route: (0, _metal.computed)('route', '_currentRouterState', function computeLinkToComponentRoute() {
      var {
        route
      } = this;
      return route === UNDEFINED ? this._currentRoute : route;
    }),
    _models: (0, _metal.computed)('model', 'models', function computeLinkToComponentModels() {
      var {
        model,
        models
      } = this;
      (true && !(model === UNDEFINED || models === UNDEFINED) && (0, _debug.assert)('You cannot provide both the `@model` and `@models` arguments to the <LinkTo> component.', model === UNDEFINED || models === UNDEFINED));

      if (model !== UNDEFINED) {
        return [model];
      } else if (models !== UNDEFINED) {
        (true && !(Array.isArray(models)) && (0, _debug.assert)('The `@models` argument must be an array.', Array.isArray(models)));
        return models;
      } else {
        return [];
      }
    }),
    _query: (0, _metal.computed)('query', function computeLinkToComponentQuery() {
      var {
        query
      } = this;

      if (query === UNDEFINED) {
        return EMPTY_QUERY_PARAMS;
      } else {
        return (0, _polyfills.assign)({}, query);
      }
    }),

    /**
      Accessed as a classname binding to apply the component's `disabledClass`
      CSS `class` to the element when the link is disabled.
         When `true`, interactions with the element will not trigger route changes.
      @property disabled
      @private
    */
    disabled: (0, _metal.computed)({
      get(_key) {
        // always returns false for `get` because (due to the `set` just below)
        // the cached return value from the set will prevent this getter from _ever_
        // being called after a set has occured
        return false;
      },

      set(_key, value$$1) {
        this._isDisabled = value$$1;
        return value$$1 ? this.disabledClass : false;
      }

    }),

    /**
      Accessed as a classname binding to apply the component's `activeClass`
      CSS `class` to the element when the link is active.
         This component is considered active when its `currentWhen` property is `true`
      or the application's current route is the route this component would trigger
      transitions into.
         The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
         @property active
      @private
    */
    active: (0, _metal.computed)('activeClass', '_active', function computeLinkToComponentActiveClass() {
      return this._active ? this.activeClass : false;
    }),
    _active: (0, _metal.computed)('_currentRouterState', '_route', '_models', '_query', 'loading', 'current-when', function computeLinkToComponentActive() {
      var {
        _currentRouterState: state
      } = this;

      if (state) {
        return this._isActive(state);
      } else {
        return false;
      }
    }),
    willBeActive: (0, _metal.computed)('_currentRouterState', '_targetRouterState', '_route', '_models', '_query', 'loading', 'current-when', function computeLinkToComponentWillBeActive() {
      var {
        _currentRouterState: current,
        _targetRouterState: target
      } = this;

      if (current === target) {
        return;
      }

      return this._isActive(target);
    }),

    _isActive(routerState) {
      if (this.loading) {
        return false;
      }

      var currentWhen = this['current-when'];

      if (typeof currentWhen === 'boolean') {
        return currentWhen;
      }

      var isCurrentWhenSpecified = Boolean(currentWhen);

      if (isCurrentWhenSpecified) {
        currentWhen = currentWhen.split(' ');
      } else {
        currentWhen = [this._route];
      }

      var {
        _models: models,
        _query: query,
        _routing: routing
      } = this;

      for (var i = 0; i < currentWhen.length; i++) {
        if (routing.isActiveForRoute(models, query, currentWhen[i], routerState, isCurrentWhenSpecified)) {
          return true;
        }
      }

      return false;
    },

    transitioningIn: (0, _metal.computed)('_active', 'willBeActive', function computeLinkToComponentTransitioningIn() {
      if (this.willBeActive === true && !this._active) {
        return 'ember-transitioning-in';
      } else {
        return false;
      }
    }),
    transitioningOut: (0, _metal.computed)('_active', 'willBeActive', function computeLinkToComponentTransitioningOut() {
      if (this.willBeActive === false && this._active) {
        return 'ember-transitioning-out';
      } else {
        return false;
      }
    }),

    /**
      Event handler that invokes the link, activating the associated route.
         @method _invoke
      @param {Event} event
      @private
    */
    _invoke(event) {
      if (!(0, _views.isSimpleClick)(event)) {
        return true;
      }

      var {
        bubbles,
        preventDefault
      } = this;
      var target = this.element.target;
      var isSelf = !target || target === '_self';

      if (preventDefault !== false && isSelf) {
        event.preventDefault();
      }

      if (bubbles === false) {
        event.stopPropagation();
      }

      if (this._isDisabled) {
        return false;
      }

      if (this.loading) {
        // tslint:disable-next-line:max-line-length
        (true && (0, _debug.warn)('This link is in an inactive loading state because at least one of its models ' + 'currently has a null/undefined value, or the provided route name is invalid.', false, {
          id: 'ember-glimmer.link-to.inactive-loading-state'
        }));
        return false;
      }

      if (!isSelf) {
        return false;
      }

      var {
        _route: routeName,
        _models: models,
        _query: queryParams,
        replace: shouldReplace
      } = this;
      var payload = {
        queryParams,
        routeName
      };
      (0, _instrumentation.flaggedInstrument)('interaction.link-to', payload, this._generateTransition(payload, routeName, models, queryParams, shouldReplace));
      return false;
    },

    _generateTransition(payload, qualifiedRouteName, models, queryParams, shouldReplace) {
      var {
        _routing: routing
      } = this;
      return () => {
        payload.transition = routing.transitionTo(qualifiedRouteName, models, queryParams, shouldReplace);
      };
    },

    /**
      Sets the element's `href` attribute to the url for
      the `LinkComponent`'s targeted route.
         If the `LinkComponent`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
         @property href
      @private
    */
    href: (0, _metal.computed)('_currentRouterState', '_route', '_models', '_query', 'tagName', 'loading', 'loadingHref', function computeLinkToComponentHref() {
      if (this.tagName !== 'a') {
        return;
      }

      if (this.loading) {
        return this.loadingHref;
      }

      var {
        _route: route,
        _models: models,
        _query: query,
        _routing: routing
      } = this;

      if (true
      /* DEBUG */
      ) {
        /*
         * Unfortunately, to get decent error messages, we need to do this.
         * In some future state we should be able to use a "feature flag"
         * which allows us to strip this without needing to call it twice.
         *
         * if (isDebugBuild()) {
         *   // Do the useful debug thing, probably including try/catch.
         * } else {
         *   // Do the performant thing.
         * }
         */
        try {
          return routing.generateURL(route, models, query);
        } catch (e) {
          // tslint:disable-next-line:max-line-length
          (true && !(false) && (0, _debug.assert)("You attempted to generate a link for the \"" + this.route + "\" route, but did not " + "pass the models required for generating its dynamic segments. " + e.message));
        }
      } else {
        return routing.generateURL(route, models, query);
      }
    }),
    loading: (0, _metal.computed)('_route', '_modelsAreLoaded', 'loadingClass', function computeLinkToComponentLoading() {
      var {
        _route: route,
        _modelsAreLoaded: loaded
      } = this;

      if (!loaded || route === null || route === undefined) {
        return this.loadingClass;
      }
    }),
    _modelsAreLoaded: (0, _metal.computed)('_models', function computeLinkToComponentModelsAreLoaded() {
      var {
        _models: models
      } = this;

      for (var i = 0; i < models.length; i++) {
        var model = models[i];

        if (model === null || model === undefined) {
          return false;
        }
      }

      return true;
    }),

    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
         @property loadingHref
      @type String
      @default #
      @private
    */
    loadingHref: '#',

    didReceiveAttrs() {
      var {
        disabledWhen
      } = this;

      if (disabledWhen !== undefined) {
        this.set('disabled', disabledWhen);
      }

      var {
        params
      } = this;

      if (!params || params.length === 0) {
        (true && !(!(this.route === UNDEFINED && this.model === UNDEFINED && this.models === UNDEFINED && this.query === UNDEFINED)) && (0, _debug.assert)('You must provide at least one of the `@route`, `@model`, `@models` or `@query` argument to `<LinkTo>`.', !(this.route === UNDEFINED && this.model === UNDEFINED && this.models === UNDEFINED && this.query === UNDEFINED)));

        if (true
        /* DEBUG */
        && this.query === UNDEFINED) {
          var {
            _models: models
          } = this;
          var lastModel = models.length > 0 && models[models.length - 1];
          (true && !(!(lastModel && lastModel.isQueryParams)) && (0, _debug.assert)('The `(query-params)` helper can only be used when invoking the `{{link-to}}` component.', !(lastModel && lastModel.isQueryParams)));
        }

        return;
      }

      params = params.slice(); // Process the positional arguments, in order.
      // 1. Inline link title comes first, if present.

      if (!this[HAS_BLOCK]) {
        this.set('linkTitle', params.shift());
      } // 2. The last argument is possibly the `query` object.


      var queryParams = params[params.length - 1];

      if (queryParams && queryParams.isQueryParams) {
        this.set('query', params.pop().values);
      } else {
        this.set('query', UNDEFINED);
      } // 3. If there is a `route`, it is now at index 0.


      if (params.length === 0) {
        this.set('route', UNDEFINED);
      } else {
        this.set('route', params.shift());
      } // 4. Any remaining indices (if any) are `models`.


      this.set('model', UNDEFINED);
      this.set('models', params);
    }

  });
  _exports.LinkComponent = LinkComponent;

  LinkComponent.toString = () => '@ember/routing/link-component';

  LinkComponent.reopenClass({
    positionalParams: 'params'
  }); // @ts-check

  var DebugStack;

  if (true
  /* DEBUG */
  ) {
    class Element {
      constructor(name) {
        this.name = name;
      }

    }

    class TemplateElement extends Element {}

    class EngineElement extends Element {} // tslint:disable-next-line:no-shadowed-variable


    DebugStack = class DebugStack {
      constructor() {
        this._stack = [];
      }

      push(name) {
        this._stack.push(new TemplateElement(name));
      }

      pushEngine(name) {
        this._stack.push(new EngineElement(name));
      }

      pop() {
        var element = this._stack.pop();

        if (element) {
          return element.name;
        }
      }

      peek() {
        var template = this._currentTemplate();

        var engine = this._currentEngine();

        if (engine) {
          return "\"" + template + "\" (in \"" + engine + "\")";
        } else if (template) {
          return "\"" + template + "\"";
        }
      }

      _currentTemplate() {
        return this._getCurrentByType(TemplateElement);
      }

      _currentEngine() {
        return this._getCurrentByType(EngineElement);
      }

      _getCurrentByType(type) {
        for (var i = this._stack.length; i >= 0; i--) {
          var element = this._stack[i];

          if (element instanceof type) {
            return element.name;
          }
        }
      }

    };
  }

  var DebugStack$1 = DebugStack;
  /**
  @module ember
  */

  /**
    The `{{#each}}` helper loops over elements in a collection. It is an extension
    of the base Handlebars `{{#each}}` helper.
  
    The default behavior of `{{#each}}` is to yield its inner block once for every
    item in an array passing the item as the first block parameter.
  
    Assuming the `@developers` argument contains this array:
  
    ```javascript
    [{ name: 'Yehuda' },{ name: 'Tom' }, { name: 'Paul' }];
    ```
  
    ```handlebars
    <ul>
      {{#each @developers as |person|}}
        <li>Hello, {{person.name}}!</li>
      {{/each}}
    </ul>
    ```
  
    The same rules apply to arrays of primitives.
  
    ```javascript
    ['Yehuda', 'Tom', 'Paul']
    ```
  
    ```handlebars
    <ul>
      {{#each @developerNames as |name|}}
        <li>Hello, {{name}}!</li>
      {{/each}}
    </ul>
    ```
  
    During iteration, the index of each item in the array is provided as a second block
    parameter.
  
    ```handlebars
    <ul>
      {{#each @developers as |person index|}}
        <li>Hello, {{person.name}}! You're number {{index}} in line</li>
      {{/each}}
    </ul>
    ```
  
    ### Specifying Keys
  
    In order to improve rendering speed, Ember will try to reuse the DOM elements
    where possible. Specifically, if the same item is present in the array both
    before and after the change, its DOM output will be reused.
  
    The `key` option is used to tell Ember how to determine if the items in the
    array being iterated over with `{{#each}}` has changed between renders. By
    default the item's object identity is used.
  
    This is usually sufficient, so in most cases, the `key` option is simply not
    needed. However, in some rare cases, the objects' identities may change even
    though they represent the same underlying data.
  
    For example:
  
    ```javascript
    people.map(person => {
      return { ...person, type: 'developer' };
    });
    ```
  
    In this case, each time the `people` array is `map`-ed over, it will produce
    an new array with completely different objects between renders. In these cases,
    you can help Ember determine how these objects related to each other with the
    `key` option:
  
    ```handlebars
    <ul>
      {{#each @developers key="name" as |person|}}
        <li>Hello, {{person.name}}!</li>
      {{/each}}
    </ul>
    ```
  
    By doing so, Ember will use the value of the property specified (`person.name`
    in the example) to find a "match" from the previous render. That is, if Ember
    has previously seen an object from the `@developers` array with a matching
    name, its DOM elements will be re-used.
  
    ### {{else}} condition
  
    `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
    if the collection is empty.
  
    ```handlebars
    <ul>
      {{#each @developers as |person|}}
        <li>{{person.name}} is available!</li>
      {{else}}
        <li>Sorry, nobody is available for this task.</li>
      {{/each}}
    </ul>
    ```
  
    @method each
    @for Ember.Templates.helpers
    @public
   */

  /**
    The `{{each-in}}` helper loops over properties on an object.
  
    For example, if the `@user` argument contains this object:
  
    ```javascript
    {
      "name": "Shelly Sails",
      "age": 42
    }
    ```
  
    This template would display all properties on the `@user`
    object in a list:
  
    ```handlebars
    <ul>
    {{#each-in @user as |key value|}}
      <li>{{key}}: {{value}}</li>
    {{/each-in}}
    </ul>
    ```
  
    Outputting their name and age.
  
    @method each-in
    @for Ember.Templates.helpers
    @public
    @since 2.1.0
  */

  _exports.DebugStack = DebugStack$1;
  var EACH_IN_REFERENCE = (0, _utils.symbol)('EACH_IN');

  class EachInReference {
    constructor(inner) {
      this.inner = inner;
      this.tag = inner.tag;
      this[EACH_IN_REFERENCE] = true;
    }

    value() {
      return this.inner.value();
    }

    get(key) {
      return this.inner.get(key);
    }

  }

  function isEachIn(ref) {
    return ref !== null && typeof ref === 'object' && ref[EACH_IN_REFERENCE];
  }

  function eachIn(_vm, args) {
    return new EachInReference(args.positional.at(0));
  }

  var ITERATOR_KEY_GUID = 'be277757-bbbe-4620-9fcb-213ef433cca2';

  function iterableFor(ref, keyPath) {
    if (isEachIn(ref)) {
      return new EachInIterable(ref, keyPath || '@key');
    } else {
      return new EachIterable(ref, keyPath || '@identity');
    }
  }

  class BoundedIterator {
    constructor(length, keyFor) {
      this.length = length;
      this.keyFor = keyFor;
      this.position = 0;
    }

    isEmpty() {
      return false;
    }

    memoFor(position) {
      return position;
    }

    next() {
      var {
        length,
        keyFor,
        position
      } = this;

      if (position >= length) {
        return null;
      }

      var value$$1 = this.valueFor(position);
      var memo = this.memoFor(position);
      var key = keyFor(value$$1, memo, position);
      this.position++;
      return {
        key,
        value: value$$1,
        memo
      };
    }

  }

  class ArrayIterator extends BoundedIterator {
    constructor(array, length, keyFor) {
      super(length, keyFor);
      this.array = array;
    }

    static from(array, keyFor) {
      var {
        length
      } = array;

      if (length === 0) {
        return EMPTY_ITERATOR;
      } else {
        return new this(array, length, keyFor);
      }
    }

    static fromForEachable(object, keyFor) {
      var array = [];
      object.forEach(item => array.push(item));
      return this.from(array, keyFor);
    }

    valueFor(position) {
      return this.array[position];
    }

  }

  class EmberArrayIterator extends BoundedIterator {
    constructor(array, length, keyFor) {
      super(length, keyFor);
      this.array = array;
    }

    static from(array, keyFor) {
      var {
        length
      } = array;

      if (length === 0) {
        return EMPTY_ITERATOR;
      } else {
        return new this(array, length, keyFor);
      }
    }

    valueFor(position) {
      return (0, _metal.objectAt)(this.array, position);
    }

  }

  class ObjectIterator extends BoundedIterator {
    constructor(keys, values, length, keyFor) {
      super(length, keyFor);
      this.keys = keys;
      this.values = values;
    }

    static fromIndexable(obj, keyFor) {
      var keys = Object.keys(obj);
      var {
        length
      } = keys;

      if (length === 0) {
        return EMPTY_ITERATOR;
      } else {
        var values = [];

        for (var i = 0; i < length; i++) {
          var value$$1 = void 0;
          var key = keys[i];
          value$$1 = obj[key]; // Add the tag of the returned value if it is an array, since arrays
          // should always cause updates if they are consumed and then changed

          if (true
          /* EMBER_METAL_TRACKED_PROPERTIES */
          && (0, _metal.isTracking)()) {
            (0, _metal.consume)((0, _metal.tagForProperty)(obj, key));

            if (Array.isArray(value$$1) || (0, _utils.isEmberArray)(value$$1)) {
              (0, _metal.consume)((0, _metal.tagForProperty)(value$$1, '[]'));
            }
          }

          values.push(value$$1);
        }

        return new this(keys, values, length, keyFor);
      }
    }

    static fromForEachable(obj, keyFor) {
      var keys = [];
      var values = [];
      var length = 0;
      var isMapLike = false;
      obj.forEach((value$$1, key) => {
        isMapLike = isMapLike || arguments.length >= 2;

        if (isMapLike) {
          keys.push(key);
        }

        values.push(value$$1);
        length++;
      });

      if (length === 0) {
        return EMPTY_ITERATOR;
      } else if (isMapLike) {
        return new this(keys, values, length, keyFor);
      } else {
        return new ArrayIterator(values, length, keyFor);
      }
    }

    valueFor(position) {
      return this.values[position];
    }

    memoFor(position) {
      return this.keys[position];
    }

  }

  class NativeIterator {
    constructor(iterable, result, keyFor) {
      this.iterable = iterable;
      this.result = result;
      this.keyFor = keyFor;
      this.position = 0;
    }

    static from(iterable, keyFor) {
      var iterator = iterable[Symbol.iterator]();
      var result = iterator.next();
      var {
        value: value$$1,
        done
      } = result;

      if (done) {
        return EMPTY_ITERATOR;
      } else if (Array.isArray(value$$1) && value$$1.length === 2) {
        return new this(iterator, result, keyFor);
      } else {
        return new ArrayLikeNativeIterator(iterator, result, keyFor);
      }
    }

    isEmpty() {
      return false;
    }

    next() {
      var {
        iterable,
        result,
        position,
        keyFor
      } = this;

      if (result.done) {
        return null;
      }

      var value$$1 = this.valueFor(result, position);
      var memo = this.memoFor(result, position);
      var key = keyFor(value$$1, memo, position);
      this.position++;
      this.result = iterable.next();
      return {
        key,
        value: value$$1,
        memo
      };
    }

  }

  class ArrayLikeNativeIterator extends NativeIterator {
    valueFor(result) {
      return result.value;
    }

    memoFor(_result, position) {
      return position;
    }

  }

  class MapLikeNativeIterator extends NativeIterator {
    valueFor(result) {
      return result.value[1];
    }

    memoFor(result) {
      return result.value[0];
    }

  }

  var EMPTY_ITERATOR = {
    isEmpty() {
      return true;
    },

    next() {
      (true && !(false) && (0, _debug.assert)('Cannot call next() on an empty iterator'));
      return null;
    }

  };

  class EachInIterable {
    constructor(ref, keyPath) {
      this.ref = ref;
      this.keyPath = keyPath;
      this.valueTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([ref.tag, this.valueTag]);
    }

    iterate() {
      var {
        ref,
        valueTag
      } = this;
      var iterable = ref.value();
      var tag = (0, _metal.tagFor)(iterable);

      if ((0, _utils.isProxy)(iterable)) {
        // this is because the each-in doesn't actually get(proxy, 'key') but bypasses it
        // and the proxy's tag is lazy updated on access
        iterable = (0, _runtime._contentFor)(iterable);
      }

      (0, _reference.update)(valueTag, tag);

      if (!isIndexable(iterable)) {
        return EMPTY_ITERATOR;
      }

      if (Array.isArray(iterable) || (0, _utils.isEmberArray)(iterable)) {
        return ObjectIterator.fromIndexable(iterable, this.keyFor(true));
      } else if (_utils.HAS_NATIVE_SYMBOL && isNativeIterable(iterable)) {
        return MapLikeNativeIterator.from(iterable, this.keyFor());
      } else if (hasForEach(iterable)) {
        return ObjectIterator.fromForEachable(iterable, this.keyFor());
      } else {
        return ObjectIterator.fromIndexable(iterable, this.keyFor(true));
      }
    }

    valueReferenceFor(item) {
      return new UpdatableReference(item.value);
    }

    updateValueReference(ref, item) {
      ref.update(item.value);
    }

    memoReferenceFor(item) {
      return new UpdatableReference(item.memo);
    }

    updateMemoReference(ref, item) {
      ref.update(item.memo);
    }

    keyFor(hasUniqueKeys = false) {
      var {
        keyPath
      } = this;

      switch (keyPath) {
        case '@key':
          return hasUniqueKeys ? ObjectKey : Unique(MapKey);

        case '@index':
          return Index;

        case '@identity':
          return Unique(Identity);

        default:
          (true && !(keyPath[0] !== '@') && (0, _debug.assert)("Invalid key: " + keyPath, keyPath[0] !== '@'));
          return Unique(KeyPath(keyPath));
      }
    }

  }

  class EachIterable {
    constructor(ref, keyPath) {
      this.ref = ref;
      this.keyPath = keyPath;
      this.valueTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([ref.tag, this.valueTag]);
    }

    iterate() {
      var {
        ref,
        valueTag
      } = this;
      var iterable = ref.value();
      (0, _reference.update)(valueTag, (0, _metal.tagForProperty)(iterable, '[]'));

      if (iterable === null || typeof iterable !== 'object') {
        return EMPTY_ITERATOR;
      }

      var keyFor = this.keyFor();

      if (Array.isArray(iterable)) {
        return ArrayIterator.from(iterable, keyFor);
      } else if ((0, _utils.isEmberArray)(iterable)) {
        return EmberArrayIterator.from(iterable, keyFor);
      } else if (_utils.HAS_NATIVE_SYMBOL && isNativeIterable(iterable)) {
        return ArrayLikeNativeIterator.from(iterable, keyFor);
      } else if (hasForEach(iterable)) {
        return ArrayIterator.fromForEachable(iterable, keyFor);
      } else {
        return EMPTY_ITERATOR;
      }
    }

    valueReferenceFor(item) {
      return new UpdatableReference(item.value);
    }

    updateValueReference(ref, item) {
      ref.update(item.value);
    }

    memoReferenceFor(item) {
      return new UpdatableReference(item.memo);
    }

    updateMemoReference(ref, item) {
      ref.update(item.memo);
    }

    keyFor() {
      var {
        keyPath
      } = this;

      switch (keyPath) {
        case '@index':
          return Index;

        case '@identity':
          return Unique(Identity);

        default:
          (true && !(keyPath[0] !== '@') && (0, _debug.assert)("Invalid key: " + keyPath, keyPath[0] !== '@'));
          return Unique(KeyPath(keyPath));
      }
    }

  }

  function hasForEach(value$$1) {
    return typeof value$$1['forEach'] === 'function';
  }

  function isNativeIterable(value$$1) {
    return typeof value$$1[Symbol.iterator] === 'function';
  }

  function isIndexable(value$$1) {
    return value$$1 !== null && (typeof value$$1 === 'object' || typeof value$$1 === 'function');
  } // Position in an array is guarenteed to be unique


  function Index(_value, _memo, position) {
    return String(position);
  } // Object.keys(...) is guarenteed to be strings and unique


  function ObjectKey(_value, memo) {
    return memo;
  } // Map keys can be any objects


  function MapKey(_value, memo) {
    return Identity(memo);
  }

  function Identity(value$$1) {
    switch (typeof value$$1) {
      case 'string':
        return value$$1;

      case 'number':
        return String(value$$1);

      default:
        return (0, _utils.guidFor)(value$$1);
    }
  }

  function KeyPath(keyPath) {
    return value$$1 => String((0, _metal.get)(value$$1, keyPath));
  }

  function Unique(func) {
    var seen = {};
    return (value$$1, memo, position) => {
      var key = func(value$$1, memo, position);
      var count = seen[key];

      if (count === undefined) {
        seen[key] = 0;
        return key;
      } else {
        seen[key] = ++count;
        return "" + key + ITERATOR_KEY_GUID + count;
      }
    };
  }
  /**
  @module @ember/template
  */


  class SafeString {
    constructor(string) {
      this.string = string;
    }

    toString() {
      return "" + this.string;
    }

    toHTML() {
      return this.toString();
    }

  }

  _exports.SafeString = SafeString;
  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#x27;',
    '`': '&#x60;',
    '=': '&#x3D;'
  };
  var possible = /[&<>"'`=]/;
  var badChars = /[&<>"'`=]/g;

  function escapeChar(chr) {
    return escape[chr];
  }

  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string === null || string === undefined) {
        return '';
      } else if (!string) {
        return String(string);
      } // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.


      string = String(string);
    }

    if (!possible.test(string)) {
      return string;
    }

    return string.replace(badChars, escapeChar);
  }
  /**
    Mark a string as safe for unescaped output with Ember templates. If you
    return HTML from a helper, use this function to
    ensure Ember's rendering layer does not escape the HTML.
  
    ```javascript
    import { htmlSafe } from '@ember/template';
  
    htmlSafe('<div>someString</div>')
    ```
  
    @method htmlSafe
    @for @ember/template
    @static
    @return {SafeString} A string that will not be HTML escaped by Handlebars.
    @public
  */


  function htmlSafe(str) {
    if (str === null || str === undefined) {
      str = '';
    } else if (typeof str !== 'string') {
      str = String(str);
    }

    return new SafeString(str);
  }
  /**
    Detects if a string was decorated using `htmlSafe`.
  
    ```javascript
    import { htmlSafe, isHTMLSafe } from '@ember/template';
  
    var plainString = 'plain string',
        safeString = htmlSafe('<div>someValue</div>');
  
    isHTMLSafe(plainString); // false
    isHTMLSafe(safeString);  // true
    ```
  
    @method isHTMLSafe
    @for @ember/template
    @static
    @return {Boolean} `true` if the string was decorated with `htmlSafe`, `false` otherwise.
    @public
  */


  function isHTMLSafe(str) {
    return str !== null && typeof str === 'object' && typeof str.toHTML === 'function';
  }
  /* globals module, URL */


  var nodeURL;
  var parsingNode;

  function installProtocolForURL(environment) {
    var protocol;

    if (_browserEnvironment.hasDOM) {
      protocol = browserProtocolForURL.call(environment, 'foobar:baz');
    } // Test to see if our DOM implementation parses
    // and normalizes URLs.


    if (protocol === 'foobar:') {
      // Swap in the method that doesn't do this test now that
      // we know it works.
      environment.protocolForURL = browserProtocolForURL;
    } else if (typeof URL === 'object') {
      // URL globally provided, likely from FastBoot's sandbox
      nodeURL = URL;
      environment.protocolForURL = nodeProtocolForURL;
    } else if (typeof module !== undefined && typeof module.require === 'function') {
      // Otherwise, we need to fall back to our own URL parsing.
      // Global `require` is shadowed by Ember's loader so we have to use the fully
      // qualified `module.require`.
      // tslint:disable-next-line:no-require-imports
      nodeURL = module.require('url');
      environment.protocolForURL = nodeProtocolForURL;
    } else {
      throw new Error('Could not find valid URL parsing mechanism for URL Sanitization');
    }
  }

  function browserProtocolForURL(url) {
    if (!parsingNode) {
      parsingNode = document.createElement('a');
    }

    parsingNode.href = url;
    return parsingNode.protocol;
  }

  function nodeProtocolForURL(url) {
    var protocol = null;

    if (typeof url === 'string') {
      protocol = nodeURL.parse(url).protocol;
    }

    return protocol === null ? ':' : protocol;
  }

  class Environment$1 extends _runtime2.Environment {
    constructor(injections) {
      super(injections);
      this.inTransaction = false;
      this.owner = injections[_owner.OWNER];
      this.isInteractive = this.owner.lookup('-environment:main').isInteractive; // can be removed once https://github.com/tildeio/glimmer/pull/305 lands

      this.destroyedComponents = [];
      installProtocolForURL(this);

      if (true
      /* DEBUG */
      ) {
        this.debugStack = new DebugStack$1();
      }
    }

    static create(options) {
      return new this(options);
    } // this gets clobbered by installPlatformSpecificProtocolForURL
    // it really should just delegate to a platform specific injection


    protocolForURL(s) {
      return s;
    }

    toConditionalReference(reference) {
      return ConditionalReference$1.create(reference);
    }

    iterableFor(ref, key) {
      return iterableFor(ref, key);
    }

    scheduleInstallModifier(modifier, manager) {
      if (this.isInteractive) {
        super.scheduleInstallModifier(modifier, manager);
      }
    }

    scheduleUpdateModifier(modifier, manager) {
      if (this.isInteractive) {
        super.scheduleUpdateModifier(modifier, manager);
      }
    }

    didDestroy(destroyable) {
      destroyable.destroy();
    }

    begin() {
      this.inTransaction = true;
      super.begin();
    }

    commit() {
      var destroyedComponents = this.destroyedComponents;
      this.destroyedComponents = []; // components queued for destruction must be destroyed before firing
      // `didCreate` to prevent errors when removing and adding a component
      // with the same name (would throw an error when added to view registry)

      for (var i = 0; i < destroyedComponents.length; i++) {
        destroyedComponents[i].destroy();
      }

      try {
        super.commit();
      } finally {
        this.inTransaction = false;
      }
    }

  }

  _exports.Environment = Environment$1;

  if (true
  /* DEBUG */
  ) {
    class StyleAttributeManager extends _runtime2.SimpleDynamicAttribute {
      set(dom, value$$1, env) {
        (true && (0, _debug.warn)((0, _views.constructStyleDeprecationMessage)(value$$1), (() => {
          if (value$$1 === null || value$$1 === undefined || isHTMLSafe(value$$1)) {
            return true;
          }

          return false;
        })(), {
          id: 'ember-htmlbars.style-xss-warning'
        }));
        super.set(dom, value$$1, env);
      }

      update(value$$1, env) {
        (true && (0, _debug.warn)((0, _views.constructStyleDeprecationMessage)(value$$1), (() => {
          if (value$$1 === null || value$$1 === undefined || isHTMLSafe(value$$1)) {
            return true;
          }

          return false;
        })(), {
          id: 'ember-htmlbars.style-xss-warning'
        }));
        super.update(value$$1, env);
      }

    }

    Environment$1.prototype.attributeFor = function (element, attribute, isTrusting, namespace) {
      if (attribute === 'style' && !isTrusting) {
        return new StyleAttributeManager({
          element,
          name: attribute,
          namespace
        });
      }

      return _runtime2.Environment.prototype.attributeFor.call(this, element, attribute, isTrusting, namespace);
    };
  } // tslint:disable-next-line:max-line-length
  // https://github.com/glimmerjs/glimmer-vm/blob/v0.24.0-beta.4/packages/%40glimmer/runtime/lib/component/interfaces.ts#L21


  class AbstractManager {
    constructor() {
      this.debugStack = undefined;
    }

    prepareArgs(_state, _args) {
      return null;
    }

    didCreateElement(_component, _element, _operations) {} // noop
    // inheritors should also call `this.debugStack.pop()` to
    // ensure the rerendering assertion messages are properly
    // maintained


    didRenderLayout(_component, _bounds) {// noop
    }

    didCreate(_bucket) {} // noop
    // inheritors should also call `this._pushToDebugStack`
    // to ensure the rerendering assertion messages are
    // properly maintained


    update(_bucket, _dynamicScope) {} // noop
    // inheritors should also call `this.debugStack.pop()` to
    // ensure the rerendering assertion messages are properly
    // maintained


    didUpdateLayout(_bucket, _bounds) {// noop
    }

    didUpdate(_bucket) {// noop
    }

  }

  _exports.AbstractComponentManager = AbstractManager;

  if (true
  /* DEBUG */
  ) {
    AbstractManager.prototype._pushToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.push(name);
    };

    AbstractManager.prototype._pushEngineToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.pushEngine(name);
    };
  }

  function instrumentationPayload(def) {
    return {
      object: def.name + ":" + def.outlet
    };
  }

  var CAPABILITIES = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: false,
    attributeHook: false,
    elementHook: false,
    createCaller: true,
    dynamicScope: true,
    updateHook: false,
    createInstance: true
  };

  class OutletComponentManager extends AbstractManager {
    create(environment, definition, _args, dynamicScope) {
      if (true
      /* DEBUG */
      ) {
        this._pushToDebugStack("template:" + definition.template.referrer.moduleName, environment);
      }

      dynamicScope.outletState = definition.ref;
      return {
        self: RootReference.create(definition.controller),
        finalize: (0, _instrumentation._instrumentStart)('render.outlet', instrumentationPayload, definition)
      };
    }

    getLayout({
      template
    }, _resolver) {
      // The router has already resolved the template
      var layout = template.asLayout();
      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

    getCapabilities() {
      return CAPABILITIES;
    }

    getSelf({
      self
    }) {
      return self;
    }

    getTag() {
      // an outlet has no hooks
      return _reference.CONSTANT_TAG;
    }

    didRenderLayout(state) {
      state.finalize();

      if (true
      /* DEBUG */
      ) {
        this.debugStack.pop();
      }
    }

    getDestructor() {
      return null;
    }

  }

  var OUTLET_MANAGER = new OutletComponentManager();

  class OutletComponentDefinition {
    constructor(state, manager = OUTLET_MANAGER) {
      this.state = state;
      this.manager = manager;
    }

  }

  function createRootOutlet(outletView) {
    if (_environment2.ENV._APPLICATION_TEMPLATE_WRAPPER) {
      var WRAPPED_CAPABILITIES = (0, _polyfills.assign)({}, CAPABILITIES, {
        dynamicTag: true,
        elementHook: true
      });
      var WrappedOutletComponentManager = class extends OutletComponentManager {
        getTagName(_component) {
          return 'div';
        }

        getLayout(state) {
          // The router has already resolved the template
          var template = state.template;
          var layout = template.asWrappedLayout();
          return {
            handle: layout.compile(),
            symbolTable: layout.symbolTable
          };
        }

        getCapabilities() {
          return WRAPPED_CAPABILITIES;
        }

        didCreateElement(component, element, _operations) {
          // to add GUID id and class
          element.setAttribute('class', 'ember-view');
          element.setAttribute('id', (0, _utils.guidFor)(component));
        }

      };
      var WRAPPED_OUTLET_MANAGER = new WrappedOutletComponentManager();
      return new OutletComponentDefinition(outletView.state, WRAPPED_OUTLET_MANAGER);
    } else {
      return new OutletComponentDefinition(outletView.state);
    }
  }

  function NOOP() {}
  /**
    @module ember
  */

  /**
    Represents the internal state of the component.
  
    @class ComponentStateBucket
    @private
  */


  class ComponentStateBucket {
    constructor(environment, component, args, finalizer, hasWrappedElement) {
      this.environment = environment;
      this.component = component;
      this.args = args;
      this.finalizer = finalizer;
      this.hasWrappedElement = hasWrappedElement;
      this.classRef = null;
      this.classRef = null;
      this.argsRevision = args === null ? 0 : (0, _reference.value)(args.tag);
    }

    destroy() {
      var {
        component,
        environment
      } = this;

      if (environment.isInteractive) {
        component.trigger('willDestroyElement');
        component.trigger('willClearRender');
        var element = (0, _views.getViewElement)(component);

        if (element) {
          (0, _views.clearElementView)(element);
          (0, _views.clearViewElement)(component);
        }
      }

      environment.destroyedComponents.push(component);
    }

    finalize() {
      var {
        finalizer
      } = this;
      finalizer();
      this.finalizer = NOOP;
    }

  }

  function referenceForKey(component, key) {
    return component[ROOT_REF].get(key);
  }

  function referenceForParts(component, parts) {
    var isAttrs = parts[0] === 'attrs'; // TODO deprecate this

    if (isAttrs) {
      parts.shift();

      if (parts.length === 1) {
        return referenceForKey(component, parts[0]);
      }
    }

    return referenceFromParts(component[ROOT_REF], parts);
  } // TODO we should probably do this transform at build time


  function wrapComponentClassAttribute(hash) {
    if (hash === null) {
      return;
    }

    var [keys, values] = hash;
    var index = keys === null ? -1 : keys.indexOf('class');

    if (index !== -1) {
      var value$$1 = values[index];

      if (!Array.isArray(value$$1)) {
        return;
      }

      var [type] = value$$1;

      if (type === _wireFormat.Ops.Get || type === _wireFormat.Ops.MaybeLocal) {
        var path = value$$1[value$$1.length - 1];
        var propName = path[path.length - 1];
        values[index] = [_wireFormat.Ops.Helper, '-class', [value$$1, propName], null];
      }
    }
  }

  var AttributeBinding = {
    parse(microsyntax) {
      var colonIndex = microsyntax.indexOf(':');

      if (colonIndex === -1) {
        (true && !(microsyntax !== 'class') && (0, _debug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', microsyntax !== 'class'));
        return [microsyntax, microsyntax, true];
      } else {
        var prop = microsyntax.substring(0, colonIndex);
        var attribute = microsyntax.substring(colonIndex + 1);
        (true && !(attribute !== 'class') && (0, _debug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', attribute !== 'class'));
        return [prop, attribute, false];
      }
    },

    install(_element, component, parsed, operations) {
      var [prop, attribute, isSimple] = parsed;

      if (attribute === 'id') {
        var elementId = (0, _metal.get)(component, prop);

        if (elementId === undefined || elementId === null) {
          elementId = component.elementId;
        }

        elementId = _runtime2.PrimitiveReference.create(elementId);
        operations.setAttribute('id', elementId, true, null); // operations.addStaticAttribute(element, 'id', elementId);

        return;
      }

      var isPath = prop.indexOf('.') > -1;
      var reference = isPath ? referenceForParts(component, prop.split('.')) : referenceForKey(component, prop);
      (true && !(!(isSimple && isPath)) && (0, _debug.assert)("Illegal attributeBinding: '" + prop + "' is not a valid attribute name.", !(isSimple && isPath)));

      if (attribute === 'style') {
        reference = new StyleBindingReference(reference, referenceForKey(component, 'isVisible'));
      }

      operations.setAttribute(attribute, reference, false, null); // operations.addDynamicAttribute(element, attribute, reference, false);
    }

  };
  var DISPLAY_NONE = 'display: none;';
  var SAFE_DISPLAY_NONE = htmlSafe(DISPLAY_NONE);

  class StyleBindingReference extends _reference.CachedReference {
    constructor(inner, isVisible) {
      super();
      this.inner = inner;
      this.isVisible = isVisible;
      this.tag = (0, _reference.combine)([inner.tag, isVisible.tag]);
    }

    compute() {
      var value$$1 = this.inner.value();
      var isVisible = this.isVisible.value();

      if (isVisible !== false) {
        return value$$1;
      } else if (!value$$1) {
        return SAFE_DISPLAY_NONE;
      } else {
        var style = value$$1 + ' ' + DISPLAY_NONE;
        return isHTMLSafe(value$$1) ? htmlSafe(style) : style;
      }
    }

  }

  var IsVisibleBinding = {
    install(_element, component, operations) {
      operations.setAttribute('style', (0, _reference.map)(referenceForKey(component, 'isVisible'), this.mapStyleValue), false, null); // // the upstream type for addDynamicAttribute's `value` argument
      // // appears to be incorrect. It is currently a Reference<string>, I
      // // think it should be a Reference<string|null>.
      // operations.addDynamicAttribute(element, 'style', ref as any as Reference<string>, false);
    },

    mapStyleValue(isVisible) {
      return isVisible === false ? SAFE_DISPLAY_NONE : null;
    }

  };
  var ClassNameBinding = {
    install(_element, component, microsyntax, operations) {
      var [prop, truthy, falsy] = microsyntax.split(':');
      var isStatic = prop === '';

      if (isStatic) {
        operations.setAttribute('class', _runtime2.PrimitiveReference.create(truthy), true, null);
      } else {
        var isPath = prop.indexOf('.') > -1;
        var parts = isPath ? prop.split('.') : [];
        var value$$1 = isPath ? referenceForParts(component, parts) : referenceForKey(component, prop);
        var ref;

        if (truthy === undefined) {
          ref = new SimpleClassNameBindingReference(value$$1, isPath ? parts[parts.length - 1] : prop);
        } else {
          ref = new ColonClassNameBindingReference(value$$1, truthy, falsy);
        }

        operations.setAttribute('class', ref, false, null); // // the upstream type for addDynamicAttribute's `value` argument
        // // appears to be incorrect. It is currently a Reference<string>, I
        // // think it should be a Reference<string|null>.
        // operations.addDynamicAttribute(element, 'class', ref as any as Reference<string>, false);
      }
    }

  };

  class SimpleClassNameBindingReference extends _reference.CachedReference {
    constructor(inner, path) {
      super();
      this.inner = inner;
      this.path = path;
      this.tag = inner.tag;
      this.inner = inner;
      this.path = path;
      this.dasherizedPath = null;
    }

    compute() {
      var value$$1 = this.inner.value();

      if (value$$1 === true) {
        var {
          path,
          dasherizedPath
        } = this;
        return dasherizedPath || (this.dasherizedPath = (0, _string.dasherize)(path));
      } else if (value$$1 || value$$1 === 0) {
        return String(value$$1);
      } else {
        return null;
      }
    }

  }

  class ColonClassNameBindingReference extends _reference.CachedReference {
    constructor(inner, truthy = null, falsy = null) {
      super();
      this.inner = inner;
      this.truthy = truthy;
      this.falsy = falsy;
      this.tag = inner.tag;
    }

    compute() {
      var {
        inner,
        truthy,
        falsy
      } = this;
      return inner.value() ? truthy : falsy;
    }

  } // inputs needed by CurlyComponents (attrs and props, with mutable
  // cells, etc).


  function processComponentArgs(namedArgs) {
    var keys = namedArgs.names;
    var attrs = namedArgs.value();
    var props = Object.create(null);
    var args = Object.create(null);
    props[ARGS] = args;

    for (var i = 0; i < keys.length; i++) {
      var name = keys[i];
      var ref = namedArgs.get(name);
      var value$$1 = attrs[name];

      if (typeof value$$1 === 'function' && value$$1[ACTION]) {
        attrs[name] = value$$1;
      } else if (ref[UPDATE]) {
        attrs[name] = new MutableCell(ref, value$$1);
      }

      args[name] = ref;
      props[name] = value$$1;
    }

    props.attrs = attrs;
    return props;
  }

  var REF = (0, _utils.symbol)('REF');

  class MutableCell {
    constructor(ref, value$$1) {
      this[_views.MUTABLE_CELL] = true;
      this[REF] = ref;
      this.value = value$$1;
    }

    update(val) {
      this[REF][UPDATE](val);
    }

  }

  function aliasIdToElementId(args, props) {
    if (args.named.has('id')) {
      // tslint:disable-next-line:max-line-length
      (true && !(!args.named.has('elementId')) && (0, _debug.assert)("You cannot invoke a component with both 'id' and 'elementId' at the same time.", !args.named.has('elementId')));
      props.elementId = props.id;
    }
  } // We must traverse the attributeBindings in reverse keeping track of
  // what has already been applied. This is essentially refining the concatenated
  // properties applying right to left.


  function applyAttributeBindings(element, attributeBindings, component, operations) {
    var seen = [];
    var i = attributeBindings.length - 1;

    while (i !== -1) {
      var binding = attributeBindings[i];
      var parsed = AttributeBinding.parse(binding);
      var attribute = parsed[1];

      if (seen.indexOf(attribute) === -1) {
        seen.push(attribute);
        AttributeBinding.install(element, component, parsed, operations);
      }

      i--;
    }

    if (seen.indexOf('id') === -1) {
      var id$$1 = component.elementId ? component.elementId : (0, _utils.guidFor)(component);
      operations.setAttribute('id', _runtime2.PrimitiveReference.create(id$$1), false, null);
    }

    if (seen.indexOf('style') === -1) {
      IsVisibleBinding.install(element, component, operations);
    }
  }

  var DEFAULT_LAYOUT = (0, _container.privatize)(_templateObject2());
  var EMPTY_POSITIONAL_ARGS = [];
  (0, _debug.debugFreeze)(EMPTY_POSITIONAL_ARGS);

  class CurlyComponentManager extends AbstractManager {
    getLayout(state, _resolver) {
      return {
        // TODO fix
        handle: state.handle,
        symbolTable: state.symbolTable
      };
    }

    templateFor(component) {
      var {
        layout,
        layoutName
      } = component;
      var owner = (0, _owner.getOwner)(component);
      var factory;

      if (layout === undefined) {
        if (layoutName !== undefined) {
          var _factory = owner.lookup("template:" + layoutName);

          (true && !(_factory !== undefined) && (0, _debug.assert)("Layout `" + layoutName + "` not found!", _factory !== undefined));
          factory = _factory;
        } else {
          factory = owner.lookup(DEFAULT_LAYOUT);
        }
      } else if (isTemplateFactory(layout)) {
        factory = layout;
      } else {
        // we were provided an instance already
        return layout;
      }

      return factory(owner);
    }

    getDynamicLayout({
      component
    }) {
      var template$$1 = this.templateFor(component);
      var layout = template$$1.asWrappedLayout();
      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

    getTagName(state) {
      var {
        component,
        hasWrappedElement
      } = state;

      if (!hasWrappedElement) {
        return null;
      }

      return component && component.tagName || 'div';
    }

    getCapabilities(state) {
      return state.capabilities;
    }

    prepareArgs(state, args) {
      if (args.named.has('__ARGS__')) {
        var __args__ = args.named.get('__ARGS__').value();

        var prepared = {
          positional: EMPTY_POSITIONAL_ARGS,
          named: (0, _polyfills.assign)({}, args.named.capture().map, __args__)
        };

        if (true
        /* DEBUG */
        ) {
          delete prepared.named.__ARGS__;
        }

        return prepared;
      }

      var {
        positionalParams
      } = state.ComponentClass.class; // early exits

      if (positionalParams === undefined || positionalParams === null || args.positional.length === 0) {
        return null;
      }

      var named;

      if (typeof positionalParams === 'string') {
        (true && !(!args.named.has(positionalParams)) && (0, _debug.assert)("You cannot specify positional parameters and the hash argument `" + positionalParams + "`.", !args.named.has(positionalParams)));
        named = {
          [positionalParams]: args.positional.capture()
        };
        (0, _polyfills.assign)(named, args.named.capture().map);
      } else if (Array.isArray(positionalParams) && positionalParams.length > 0) {
        var count = Math.min(positionalParams.length, args.positional.length);
        named = {};
        (0, _polyfills.assign)(named, args.named.capture().map);

        for (var i = 0; i < count; i++) {
          var name = positionalParams[i];
          (true && !(!args.named.has(name)) && (0, _debug.assert)("You cannot specify both a positional param (at position " + i + ") and the hash argument `" + name + "`.", !args.named.has(name)));
          named[name] = args.positional.at(i);
        }
      } else {
        return null;
      }

      return {
        positional: _util.EMPTY_ARRAY,
        named
      };
    }
    /*
     * This hook is responsible for actually instantiating the component instance.
     * It also is where we perform additional bookkeeping to support legacy
     * features like exposed by view mixins like ChildViewSupport, ActionSupport,
     * etc.
     */


    create(environment, state, args, dynamicScope, callerSelfRef, hasBlock) {
      if (true
      /* DEBUG */
      ) {
        this._pushToDebugStack("component:" + state.name, environment);
      } // Get the nearest concrete component instance from the scope. "Virtual"
      // components will be skipped.


      var parentView = dynamicScope.view; // Get the Ember.Component subclass to instantiate for this component.

      var factory = state.ComponentClass; // Capture the arguments, which tells Glimmer to give us our own, stable
      // copy of the Arguments object that is safe to hold on to between renders.

      var capturedArgs = args.named.capture();
      var props = processComponentArgs(capturedArgs); // Alias `id` argument to `elementId` property on the component instance.

      aliasIdToElementId(args, props); // Set component instance's parentView property to point to nearest concrete
      // component.

      props.parentView = parentView; // Set whether this component was invoked with a block
      // (`{{#my-component}}{{/my-component}}`) or without one
      // (`{{my-component}}`).

      props[HAS_BLOCK] = hasBlock; // Save the current `this` context of the template as the component's
      // `_target`, so bubbled actions are routed to the right place.

      props._target = callerSelfRef.value(); // static layout asserts CurriedDefinition

      if (state.template) {
        props.layout = state.template;
      } // Now that we've built up all of the properties to set on the component instance,
      // actually create it.


      var component = factory.create(props);
      var finalizer = (0, _instrumentation._instrumentStart)('render.component', initialRenderInstrumentDetails, component); // We become the new parentView for downstream components, so save our
      // component off on the dynamic scope.

      dynamicScope.view = component; // Unless we're the root component, we need to add ourselves to our parent
      // component's childViews array.

      if (parentView !== null && parentView !== undefined) {
        (0, _views.addChildView)(parentView, component);
      }

      component.trigger('didReceiveAttrs');
      var hasWrappedElement = component.tagName !== ''; // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components

      if (!hasWrappedElement) {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      } // Track additional lifecycle metadata about this component in a state bucket.
      // Essentially we're saving off all the state we'll need in the future.


      var bucket = new ComponentStateBucket(environment, component, capturedArgs, finalizer, hasWrappedElement);

      if (args.named.has('class')) {
        bucket.classRef = args.named.get('class');
      }

      if (true
      /* DEBUG */
      ) {
        processComponentInitializationAssertions(component, props);
      }

      if (environment.isInteractive && hasWrappedElement) {
        component.trigger('willRender');
      }

      return bucket;
    }

    getSelf({
      component
    }) {
      return component[ROOT_REF];
    }

    didCreateElement({
      component,
      classRef,
      environment
    }, element, operations) {
      (0, _views.setViewElement)(component, element);
      (0, _views.setElementView)(element, component);
      var {
        attributeBindings,
        classNames,
        classNameBindings
      } = component;

      if (attributeBindings && attributeBindings.length) {
        applyAttributeBindings(element, attributeBindings, component, operations);
      } else {
        var id$$1 = component.elementId ? component.elementId : (0, _utils.guidFor)(component);
        operations.setAttribute('id', _runtime2.PrimitiveReference.create(id$$1), false, null);
        IsVisibleBinding.install(element, component, operations);
      }

      if (classRef) {
        var ref = new SimpleClassNameBindingReference(classRef, classRef['propertyKey']);
        operations.setAttribute('class', ref, false, null);
      }

      if (classNames && classNames.length) {
        classNames.forEach(name => {
          operations.setAttribute('class', _runtime2.PrimitiveReference.create(name), false, null);
        });
      }

      if (classNameBindings && classNameBindings.length) {
        classNameBindings.forEach(binding => {
          ClassNameBinding.install(element, component, binding, operations);
        });
      }

      operations.setAttribute('class', _runtime2.PrimitiveReference.create('ember-view'), false, null);

      if ('ariaRole' in component) {
        operations.setAttribute('role', referenceForKey(component, 'ariaRole'), false, null);
      }

      component._transitionTo('hasElement');

      if (environment.isInteractive) {
        component.trigger('willInsertElement');
      }
    }

    didRenderLayout(bucket, bounds) {
      bucket.component[BOUNDS] = bounds;
      bucket.finalize();

      if (true
      /* DEBUG */
      ) {
        this.debugStack.pop();
      }
    }

    getTag({
      args,
      component
    }) {
      return args ? (0, _reference.combine)([args.tag, component[DIRTY_TAG]]) : component[DIRTY_TAG];
    }

    didCreate({
      component,
      environment
    }) {
      if (environment.isInteractive) {
        component._transitionTo('inDOM');

        component.trigger('didInsertElement');
        component.trigger('didRender');
      }
    }

    update(bucket) {
      var {
        component,
        args,
        argsRevision,
        environment
      } = bucket;

      if (true
      /* DEBUG */
      ) {
        this._pushToDebugStack(component._debugContainerKey, environment);
      }

      bucket.finalizer = (0, _instrumentation._instrumentStart)('render.component', rerenderInstrumentDetails, component);

      if (args && !(0, _reference.validate)(args.tag, argsRevision)) {
        var props = processComponentArgs(args);
        bucket.argsRevision = (0, _reference.value)(args.tag);
        component[IS_DISPATCHING_ATTRS] = true;
        component.setProperties(props);
        component[IS_DISPATCHING_ATTRS] = false;
        component.trigger('didUpdateAttrs');
        component.trigger('didReceiveAttrs');
      }

      if (environment.isInteractive) {
        component.trigger('willUpdate');
        component.trigger('willRender');
      }
    }

    didUpdateLayout(bucket) {
      bucket.finalize();

      if (true
      /* DEBUG */
      ) {
        this.debugStack.pop();
      }
    }

    didUpdate({
      component,
      environment
    }) {
      if (environment.isInteractive) {
        component.trigger('didUpdate');
        component.trigger('didRender');
      }
    }

    getDestructor(stateBucket) {
      return stateBucket;
    }

  }

  function processComponentInitializationAssertions(component, props) {
    (true && !((() => {
      var {
        classNameBindings
      } = component;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];

        if (typeof binding !== 'string' || binding.length === 0) {
          return false;
        }
      }

      return true;
    })()) && (0, _debug.assert)("classNameBindings must be non-empty strings: " + component, (() => {
      var {
        classNameBindings
      } = component;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];

        if (typeof binding !== 'string' || binding.length === 0) {
          return false;
        }
      }

      return true;
    })()));
    (true && !((() => {
      var {
        classNameBindings
      } = component;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];

        if (binding.split(' ').length > 1) {
          return false;
        }
      }

      return true;
    })()) && (0, _debug.assert)("classNameBindings must not have spaces in them: " + component, (() => {
      var {
        classNameBindings
      } = component;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];

        if (binding.split(' ').length > 1) {
          return false;
        }
      }

      return true;
    })()));
    (true && !(component.tagName !== '' || !component.classNameBindings || component.classNameBindings.length === 0) && (0, _debug.assert)("You cannot use `classNameBindings` on a tag-less component: " + component, component.tagName !== '' || !component.classNameBindings || component.classNameBindings.length === 0));
    (true && !(component.tagName !== '' || props.id === component.elementId || !component.elementId && component.elementId !== '') && (0, _debug.assert)("You cannot use `elementId` on a tag-less component: " + component, component.tagName !== '' || props.id === component.elementId || !component.elementId && component.elementId !== ''));
    (true && !(component.tagName !== '' || !component.attributeBindings || component.attributeBindings.length === 0) && (0, _debug.assert)("You cannot use `attributeBindings` on a tag-less component: " + component, component.tagName !== '' || !component.attributeBindings || component.attributeBindings.length === 0));
  }

  function initialRenderInstrumentDetails(component) {
    return component.instrumentDetails({
      initialRender: true
    });
  }

  function rerenderInstrumentDetails(component) {
    return component.instrumentDetails({
      initialRender: false
    });
  }

  var CURLY_CAPABILITIES = {
    dynamicLayout: true,
    dynamicTag: true,
    prepareArgs: true,
    createArgs: true,
    attributeHook: true,
    elementHook: true,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true
  };
  var CURLY_COMPONENT_MANAGER = new CurlyComponentManager();

  class CurlyComponentDefinition {
    // tslint:disable-next-line:no-shadowed-variable
    constructor(name, ComponentClass, handle, template$$1, args) {
      this.name = name;
      this.ComponentClass = ComponentClass;
      this.handle = handle;
      this.template = template$$1;
      this.manager = CURLY_COMPONENT_MANAGER;
      var layout = template$$1 && template$$1.asLayout();
      var symbolTable = layout ? layout.symbolTable : undefined;
      this.symbolTable = symbolTable;
      this.template = template$$1;
      this.args = args;
      this.state = {
        name,
        ComponentClass,
        handle,
        template: template$$1,
        capabilities: CURLY_CAPABILITIES,
        symbolTable
      };
    }

  }

  class RootComponentManager extends CurlyComponentManager {
    constructor(component) {
      super();
      this.component = component;
    }

    getLayout(_state) {
      var template = this.templateFor(this.component);
      var layout = template.asWrappedLayout();
      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

    create(environment, _state, _args, dynamicScope) {
      var component = this.component;

      if (true
      /* DEBUG */
      ) {
        this._pushToDebugStack(component._debugContainerKey, environment);
      }

      var finalizer = (0, _instrumentation._instrumentStart)('render.component', initialRenderInstrumentDetails, component);
      dynamicScope.view = component;
      var hasWrappedElement = component.tagName !== ''; // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components

      if (!hasWrappedElement) {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }

      if (true
      /* DEBUG */
      ) {
        processComponentInitializationAssertions(component, {});
      }

      return new ComponentStateBucket(environment, component, null, finalizer, hasWrappedElement);
    }

  } // ROOT is the top-level template it has nothing but one yield.
  // it is supposed to have a dummy element


  var ROOT_CAPABILITIES = {
    dynamicLayout: false,
    dynamicTag: true,
    prepareArgs: false,
    createArgs: false,
    attributeHook: true,
    elementHook: true,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true
  };

  class RootComponentDefinition {
    constructor(component) {
      this.component = component;
      var manager = new RootComponentManager(component);
      this.manager = manager;

      var factory = _container.FACTORY_FOR.get(component);

      this.state = {
        name: factory.fullName.slice(10),
        capabilities: ROOT_CAPABILITIES,
        ComponentClass: factory,
        handle: null
      };
    }

    getTag({
      component
    }) {
      return component[DIRTY_TAG];
    }

  }

  class DynamicScope {
    constructor(view, outletState) {
      this.view = view;
      this.outletState = outletState;
    }

    child() {
      return new DynamicScope(this.view, this.outletState);
    }

    get(key) {
      // tslint:disable-next-line:max-line-length
      (true && !(key === 'outletState') && (0, _debug.assert)("Using `-get-dynamic-scope` is only supported for `outletState` (you used `" + key + "`).", key === 'outletState'));
      return this.outletState;
    }

    set(key, value$$1) {
      // tslint:disable-next-line:max-line-length
      (true && !(key === 'outletState') && (0, _debug.assert)("Using `-with-dynamic-scope` is only supported for `outletState` (you used `" + key + "`).", key === 'outletState'));
      this.outletState = value$$1;
      return value$$1;
    }

  }

  class RootState {
    constructor(root, env, template, self, parentElement, dynamicScope, builder) {
      (true && !(template !== undefined) && (0, _debug.assert)("You cannot render `" + self.value() + "` without a template.", template !== undefined));
      this.id = (0, _views.getViewId)(root);
      this.env = env;
      this.root = root;
      this.result = undefined;
      this.shouldReflush = false;
      this.destroyed = false;
      var options = this.options = {
        alwaysRevalidate: false
      };

      this.render = () => {
        var layout = template.asLayout();
        var handle = layout.compile();
        var iterator = (0, _runtime2.renderMain)(layout['compiler'].program, env, self, dynamicScope, builder(env, {
          element: parentElement,
          nextSibling: null
        }), handle);
        var iteratorResult;

        do {
          iteratorResult = iterator.next();
        } while (!iteratorResult.done);

        var result = this.result = iteratorResult.value; // override .render function after initial render

        this.render = () => result.rerender(options);
      };
    }

    isFor(possibleRoot) {
      return this.root === possibleRoot;
    }

    destroy() {
      var {
        result,
        env
      } = this;
      this.destroyed = true;
      this.env = undefined;
      this.root = null;
      this.result = undefined;
      this.render = undefined;

      if (result) {
        /*
         Handles these scenarios:
                * When roots are removed during standard rendering process, a transaction exists already
           `.begin()` / `.commit()` are not needed.
         * When roots are being destroyed manually (`component.append(); component.destroy() case), no
           transaction exists already.
         * When roots are being destroyed during `Renderer#destroy`, no transaction exists
                */
        var needsTransaction = !env.inTransaction;

        if (needsTransaction) {
          env.begin();
        }

        try {
          result.destroy();
        } finally {
          if (needsTransaction) {
            env.commit();
          }
        }
      }
    }

  }

  var renderers = [];

  function _resetRenderers() {
    renderers.length = 0;
  }

  function register(renderer) {
    (true && !(renderers.indexOf(renderer) === -1) && (0, _debug.assert)('Cannot register the same renderer twice', renderers.indexOf(renderer) === -1));
    renderers.push(renderer);
  }

  function deregister(renderer) {
    var index = renderers.indexOf(renderer);
    (true && !(index !== -1) && (0, _debug.assert)('Cannot deregister unknown unregistered renderer', index !== -1));
    renderers.splice(index, 1);
  }

  function loopBegin() {
    for (var i = 0; i < renderers.length; i++) {
      renderers[i]._scheduleRevalidate();
    }
  }

  function K() {
    /* noop */
  }

  var renderSettledDeferred = null;
  /*
    Returns a promise which will resolve when rendering has settled. Settled in
    this context is defined as when all of the tags in use are "current" (e.g.
    `renderers.every(r => r._isValid())`). When this is checked at the _end_ of
    the run loop, this essentially guarantees that all rendering is completed.
  
    @method renderSettled
    @returns {Promise<void>} a promise which fulfills when rendering has settled
  */

  function renderSettled() {
    if (renderSettledDeferred === null) {
      renderSettledDeferred = _rsvp.default.defer(); // if there is no current runloop, the promise created above will not have
      // a chance to resolve (because its resolved in backburner's "end" event)

      if (!(0, _runloop.getCurrentRunLoop)()) {
        // ensure a runloop has been kicked off
        _runloop.backburner.schedule('actions', null, K);
      }
    }

    return renderSettledDeferred.promise;
  }

  function resolveRenderPromise() {
    if (renderSettledDeferred !== null) {
      var resolve = renderSettledDeferred.resolve;
      renderSettledDeferred = null;

      _runloop.backburner.join(null, resolve);
    }
  }

  var loops = 0;

  function loopEnd() {
    for (var i = 0; i < renderers.length; i++) {
      if (!renderers[i]._isValid()) {
        if (loops > _environment2.ENV._RERENDER_LOOP_LIMIT) {
          loops = 0; // TODO: do something better

          renderers[i].destroy();
          throw new Error('infinite rendering invalidation detected');
        }

        loops++;
        return _runloop.backburner.join(null, K);
      }
    }

    loops = 0;
    resolveRenderPromise();
  }

  _runloop.backburner.on('begin', loopBegin);

  _runloop.backburner.on('end', loopEnd);

  class Renderer {
    constructor(env, rootTemplate, viewRegistry, destinedForDOM = false, builder = _runtime2.clientBuilder) {
      this._env = env;
      this._rootTemplate = rootTemplate(env.owner);
      this._viewRegistry = viewRegistry;
      this._destinedForDOM = destinedForDOM;
      this._destroyed = false;
      this._roots = [];
      this._lastRevision = -1;
      this._isRenderingRoots = false;
      this._removedRoots = [];
      this._builder = builder;
    } // renderer HOOKS


    appendOutletView(view, target) {
      var definition = createRootOutlet(view);

      this._appendDefinition(view, (0, _runtime2.curry)(definition), target);
    }

    appendTo(view, target) {
      var definition = new RootComponentDefinition(view);

      this._appendDefinition(view, (0, _runtime2.curry)(definition), target);
    }

    _appendDefinition(root, definition, target) {
      var self = new UnboundReference(definition);
      var dynamicScope = new DynamicScope(null, _runtime2.UNDEFINED_REFERENCE);
      var rootState = new RootState(root, this._env, this._rootTemplate, self, target, dynamicScope, this._builder);

      this._renderRoot(rootState);
    }

    rerender() {
      this._scheduleRevalidate();
    }

    register(view) {
      var id = (0, _views.getViewId)(view);
      (true && !(!this._viewRegistry[id]) && (0, _debug.assert)('Attempted to register a view with an id already in use: ' + id, !this._viewRegistry[id]));
      this._viewRegistry[id] = view;
    }

    unregister(view) {
      delete this._viewRegistry[(0, _views.getViewId)(view)];
    }

    remove(view) {
      view._transitionTo('destroying');

      this.cleanupRootFor(view);

      if (this._destinedForDOM) {
        view.trigger('didDestroyElement');
      }
    }

    cleanupRootFor(view) {
      // no need to cleanup roots if we have already been destroyed
      if (this._destroyed) {
        return;
      }

      var roots = this._roots; // traverse in reverse so we can remove items
      // without mucking up the index

      var i = this._roots.length;

      while (i--) {
        var root = roots[i];

        if (root.isFor(view)) {
          root.destroy();
          roots.splice(i, 1);
        }
      }
    }

    destroy() {
      if (this._destroyed) {
        return;
      }

      this._destroyed = true;

      this._clearAllRoots();
    }

    getBounds(view) {
      var bounds = view[BOUNDS];
      (true && !(Boolean(bounds)) && (0, _debug.assert)('object passed to getBounds must have the BOUNDS symbol as a property', Boolean(bounds)));
      var parentElement = bounds.parentElement();
      var firstNode = bounds.firstNode();
      var lastNode = bounds.lastNode();
      return {
        parentElement,
        firstNode,
        lastNode
      };
    }

    createElement(tagName) {
      return this._env.getAppendOperations().createElement(tagName);
    }

    _renderRoot(root) {
      var {
        _roots: roots
      } = this;
      roots.push(root);

      if (roots.length === 1) {
        register(this);
      }

      this._renderRootsTransaction();
    }

    _renderRoots() {
      var {
        _roots: roots,
        _env: env,
        _removedRoots: removedRoots
      } = this;
      var globalShouldReflush = false;
      var initialRootsLength;

      do {
        env.begin();

        try {
          // ensure that for the first iteration of the loop
          // each root is processed
          initialRootsLength = roots.length;
          globalShouldReflush = false;

          for (var i = 0; i < roots.length; i++) {
            var root = roots[i];

            if (root.destroyed) {
              // add to the list of roots to be removed
              // they will be removed from `this._roots` later
              removedRoots.push(root); // skip over roots that have been marked as destroyed

              continue;
            }

            var {
              shouldReflush
            } = root; // when processing non-initial reflush loops,
            // do not process more roots than needed

            if (i >= initialRootsLength && !shouldReflush) {
              continue;
            }

            root.options.alwaysRevalidate = shouldReflush; // track shouldReflush based on this roots render result

            shouldReflush = root.shouldReflush = (0, _metal.runInTransaction)(root, 'render'); // globalShouldReflush should be `true` if *any* of
            // the roots need to reflush

            globalShouldReflush = globalShouldReflush || shouldReflush;
          }

          this._lastRevision = (0, _reference.value)(_reference.CURRENT_TAG);
        } finally {
          env.commit();
        }
      } while (globalShouldReflush || roots.length > initialRootsLength); // remove any roots that were destroyed during this transaction


      while (removedRoots.length) {
        var _root = removedRoots.pop();

        var rootIndex = roots.indexOf(_root);
        roots.splice(rootIndex, 1);
      }

      if (this._roots.length === 0) {
        deregister(this);
      }
    }

    _renderRootsTransaction() {
      if (this._isRenderingRoots) {
        // currently rendering roots, a new root was added and will
        // be processed by the existing _renderRoots invocation
        return;
      } // used to prevent calling _renderRoots again (see above)
      // while we are actively rendering roots


      this._isRenderingRoots = true;
      var completedWithoutError = false;

      try {
        this._renderRoots();

        completedWithoutError = true;
      } finally {
        if (!completedWithoutError) {
          this._lastRevision = (0, _reference.value)(_reference.CURRENT_TAG);

          if (this._env.inTransaction === true) {
            this._env.commit();
          }
        }

        this._isRenderingRoots = false;
      }
    }

    _clearAllRoots() {
      var roots = this._roots;

      for (var i = 0; i < roots.length; i++) {
        var root = roots[i];
        root.destroy();
      }

      this._removedRoots.length = 0;
      this._roots = []; // if roots were present before destroying
      // deregister this renderer instance

      if (roots.length) {
        deregister(this);
      }
    }

    _scheduleRevalidate() {
      _runloop.backburner.scheduleOnce('render', this, this._revalidate);
    }

    _isValid() {
      return this._destroyed || this._roots.length === 0 || (0, _reference.validate)(_reference.CURRENT_TAG, this._lastRevision);
    }

    _revalidate() {
      if (this._isValid()) {
        return;
      }

      this._renderRootsTransaction();
    }

  }

  _exports.Renderer = Renderer;

  class InertRenderer extends Renderer {
    static create({
      env,
      rootTemplate,
      _viewRegistry,
      builder
    }) {
      return new this(env, rootTemplate, _viewRegistry, false, builder);
    }

    getElement(_view) {
      throw new Error('Accessing `this.element` is not allowed in non-interactive environments (such as FastBoot).');
    }

  }

  _exports.InertRenderer = InertRenderer;

  class InteractiveRenderer extends Renderer {
    static create({
      env,
      rootTemplate,
      _viewRegistry,
      builder
    }) {
      return new this(env, rootTemplate, _viewRegistry, true, builder);
    }

    getElement(view) {
      return (0, _views.getViewElement)(view);
    }

  }

  _exports.InteractiveRenderer = InteractiveRenderer;
  var TEMPLATES = {};

  function setTemplates(templates) {
    TEMPLATES = templates;
  }

  function getTemplates() {
    return TEMPLATES;
  }

  function getTemplate(name) {
    if (TEMPLATES.hasOwnProperty(name)) {
      return TEMPLATES[name];
    }
  }

  function hasTemplate(name) {
    return TEMPLATES.hasOwnProperty(name);
  }

  function setTemplate(name, template) {
    return TEMPLATES[name] = template;
  }

  class InternalComponentDefinition {
    constructor(manager, ComponentClass, layout) {
      this.manager = manager;
      this.state = {
        ComponentClass,
        layout
      };
    }

  }

  class InternalManager extends AbstractManager {
    constructor(owner) {
      super();
      this.owner = owner;
    }

    getLayout({
      layout: _layout
    }) {
      var layout = _layout.asLayout();

      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

  }

  var CAPABILITIES$1 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: true,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: true,
    dynamicScope: false,
    updateHook: true,
    createInstance: true
  };
  var EMPTY_POSITIONAL_ARGS$1 = [];
  (0, _debug.debugFreeze)(EMPTY_POSITIONAL_ARGS$1);

  class InputComponentManager extends InternalManager {
    getCapabilities() {
      return CAPABILITIES$1;
    }

    prepareArgs(_state, args) {
      (true && !(args.positional.length === 0) && (0, _debug.assert)('The `<Input />` component does not take any positional arguments', args.positional.length === 0));
      var __ARGS__ = args.named.capture().map;
      return {
        positional: EMPTY_POSITIONAL_ARGS$1,
        named: {
          __ARGS__: new RootReference(__ARGS__),
          type: args.named.get('type')
        }
      };
    }

    create(_env, {
      ComponentClass
    }, args, _dynamicScope, caller) {
      (true && !((0, _reference.isConst)(caller)) && (0, _debug.assert)('caller must be const', (0, _reference.isConst)(caller)));
      var type = args.named.get('type');
      var instance = ComponentClass.create({
        caller: caller.value(),
        type: type.value()
      });
      return {
        type,
        instance
      };
    }

    getSelf({
      instance
    }) {
      return new RootReference(instance);
    }

    getTag() {
      return _reference.CONSTANT_TAG;
    }

    update({
      type,
      instance
    }) {
      (0, _metal.set)(instance, 'type', type.value());
    }

    getDestructor({
      instance
    }) {
      return instance;
    }

  }

  var InputComponentManagerFactory = owner => {
    return new InputComponentManager(owner);
  };

  var MANAGERS = new WeakMap();
  var getPrototypeOf = Object.getPrototypeOf;

  function setManager(wrapper, obj) {
    MANAGERS.set(obj, wrapper);
    return obj;
  }

  function getManager(obj) {
    var pointer = obj;

    while (pointer !== undefined && pointer !== null) {
      var manager = MANAGERS.get(pointer);

      if (manager !== undefined) {
        return manager;
      }

      pointer = getPrototypeOf(pointer);
    }

    return null;
  }
  /**
  @module @ember/component
  */

  /**
    See [Ember.Templates.components.Input](/ember/release/classes/Ember.Templates.components/methods/Input?anchor=Input).
  
    @method input
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
    */

  /**
    The `Input` component lets you create an HTML `<input>` element.
  
    ```handlebars
    <Input @value="987" />
    ```
  
    creates an `<input>` element with `type="text"` and value set to 987.
  
    ### Text field
  
    If no `type` argument is specified, a default of type 'text' is used.
  
    ```handlebars
    Search:
    <Input @value={{this.searchWord}}>
    ```
  
    In this example, the initial value in the `<input>` will be set to the value of
    `this.searchWord`. If the user changes the text, the value of `this.searchWord` will also be
    updated.
  
    ### Actions
  
    The `Input` component takes a number of arguments with callbacks that are invoked in response to
    user events.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
    * `key-up`
  
    These callbacks are passed to `Input` like this:
  
    ```handlebars
    <Input @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    ### `<input>` HTML Attributes to Avoid
  
    In most cases, if you want to pass an attribute to the underlying HTML `<input>` element, you
    can pass the attribute directly, just like any other Ember component.
  
    ```handlebars
    <Input @type="text" size="10" />
    ```
  
    In this example, the `size` attribute will be applied to the underlying `<input>` element in the
    outputted HTML.
  
    However, there are a few attributes where you **must** use the `@` version.
  
    * `@type`: This argument is used to control which Ember component is used under the hood
    * `@value`: The `@value` argument installs a two-way binding onto the element. If you wanted a
      one-way binding, use `<input>` with the `value` property and the `input` event instead.
    * `@checked` (for checkboxes): like `@value`, the `@checked` argument installs a two-way binding
      onto the element. If you wanted a one-way binding, use `<input type="checkbox">` with
      `checked` and the `input` event instead.
  
    ### Extending `TextField`
  
    Internally, `<Input @type="text" />` creates an instance of `TextField`, passing arguments from
    the helper to `TextField`'s `create` method. Subclassing `TextField` is supported but not
    recommended.
  
    See [TextField](/ember/release/classes/TextField)
  
    ### Checkbox
  
    To create an `<input type="checkbox">`:
  
    ```handlebars
    Emberize Everything:
    <Input @type="checkbox" @checked={{this.isEmberized}} name="isEmberized" />
    ```
  
    This will bind the checked state of this checkbox to the value of `isEmberized` -- if either one
    changes, it will be reflected in the other.
  
    ### Extending `Checkbox`
  
    Internally, `<Input @type="checkbox" />` creates an instance of `Checkbox`. Subclassing
    `TextField` is supported but not recommended.
  
    See [Checkbox](/ember/release/classes/Checkbox)
  
    @method Input
    @for Ember.Templates.components
    @see {TextField}
    @see {Checkbox}
    @param {Hash} options
    @public
  */


  var Input = _runtime.Object.extend({
    isCheckbox: (0, _metal.computed)('type', function () {
      return this.type === 'checkbox';
    })
  });

  setManager({
    factory: InputComponentManagerFactory,
    internal: true,
    type: 'component'
  }, Input);

  Input.toString = () => '@ember/component/input'; ///<reference path="./simple-dom.d.ts" />

  /**
  @module ember
  */

  /**
    Calls [String.loc](/ember/release/classes/String/methods/loc?anchor=loc) with the
    provided string. This is a convenient way to localize text within a template.
    For example:
  
    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```
  
    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```
  
    ```html
    <div class='message'>
      Bonjour
    </div>
    ```
  
    See [String.loc](/ember/release/classes/String/methods/loc?anchor=loc) for how to
    set up localized string references.
  
    @method loc
    @for Ember.Templates.helpers
    @param {String} str The string to format.
    @see {String#loc}
    @public
  */


  var loc$1 = helper(function (params) {
    return _string.loc.apply(null, params
    /* let the other side handle errors */
    );
  });

  class CompileTimeLookup {
    constructor(resolver) {
      this.resolver = resolver;
    }

    getCapabilities(handle) {
      var definition = this.resolver.resolve(handle);
      var {
        manager,
        state
      } = definition;
      return manager.getCapabilities(state);
    }

    getLayout(handle) {
      var {
        manager,
        state
      } = this.resolver.resolve(handle);
      var capabilities = manager.getCapabilities(state);

      if (capabilities.dynamicLayout) {
        return null;
      }

      var invocation = manager.getLayout(state, this.resolver);
      return {
        // TODO: this seems weird, it already is compiled
        compile() {
          return invocation.handle;
        },

        symbolTable: invocation.symbolTable
      };
    }

    lookupHelper(name, referrer) {
      return this.resolver.lookupHelper(name, referrer);
    }

    lookupModifier(name, referrer) {
      return this.resolver.lookupModifier(name, referrer);
    }

    lookupComponentDefinition(name, referrer) {
      return this.resolver.lookupComponentHandle(name, referrer);
    }

    lookupPartial(name, referrer) {
      return this.resolver.lookupPartial(name, referrer);
    }

  }

  var CAPABILITIES$2 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: false,
    dynamicScope: true,
    updateHook: true,
    createInstance: true
  };

  function capabilities(managerAPI, options = {}) {
    (true && !(managerAPI === '3.4' || managerAPI === '3.13') && (0, _debug.assert)('Invalid component manager compatibility specified', managerAPI === '3.4' || managerAPI === '3.13'));
    var updateHook = true;
    {
      updateHook = managerAPI === '3.13' ? Boolean(options.updateHook) : true;
    }
    return {
      asyncLifeCycleCallbacks: Boolean(options.asyncLifecycleCallbacks),
      destructor: Boolean(options.destructor),
      updateHook
    };
  }

  function hasAsyncLifeCycleCallbacks(delegate) {
    return delegate.capabilities.asyncLifeCycleCallbacks;
  }

  function hasUpdateHook(delegate) {
    return delegate.capabilities.updateHook;
  }

  function hasAsyncUpdateHook(delegate) {
    return hasAsyncLifeCycleCallbacks(delegate) && hasUpdateHook(delegate);
  }

  function hasDestructors(delegate) {
    return delegate.capabilities.destructor;
  }
  /**
    The CustomComponentManager allows addons to provide custom component
    implementations that integrate seamlessly into Ember. This is accomplished
    through a delegate, registered with the custom component manager, which
    implements a set of hooks that determine component behavior.
  
    To create a custom component manager, instantiate a new CustomComponentManager
    class and pass the delegate as the first argument:
  
    ```js
    let manager = new CustomComponentManager({
      // ...delegate implementation...
    });
    ```
  
    ## Delegate Hooks
  
    Throughout the lifecycle of a component, the component manager will invoke
    delegate hooks that are responsible for surfacing those lifecycle changes to
    the end developer.
  
    * `create()` - invoked when a new instance of a component should be created
    * `update()` - invoked when the arguments passed to a component change
    * `getContext()` - returns the object that should be
  */


  class CustomComponentManager extends AbstractManager {
    create(_env, definition, args) {
      var {
        delegate
      } = definition;
      var capturedArgs = args.capture();
      var value$$1;
      var namedArgsProxy = {};
      {
        if (_utils.HAS_NATIVE_PROXY) {
          var handler = {
            get(_target, prop) {
              if (capturedArgs.named.has(prop)) {
                var ref = capturedArgs.named.get(prop);
                (0, _metal.consume)(ref.tag);
                return ref.value();
              }
            },

            has(_target, prop) {
              return capturedArgs.named.has(prop);
            },

            ownKeys(_target) {
              return capturedArgs.named.names;
            },

            getOwnPropertyDescriptor(_target, prop) {
              (true && !(capturedArgs.named.has(prop)) && (0, _debug.assert)('args proxies do not have real property descriptors, so you should never need to call getOwnPropertyDescriptor yourself. This code exists for enumerability, such as in for-in loops and Object.keys()', capturedArgs.named.has(prop)));
              return {
                enumerable: true,
                configurable: true
              };
            }

          };

          if (true
          /* DEBUG */
          ) {
            handler.set = function (_target, prop) {
              (true && !(false) && (0, _debug.assert)("You attempted to set " + definition.ComponentClass.class + "#" + String(prop) + " on a components arguments. Component arguments are immutable and cannot be updated directly, they always represent the values that are passed to your component. If you want to set default values, you should use a getter instead"));
              return false;
            };
          }

          namedArgsProxy = new Proxy(namedArgsProxy, handler);
        } else {
          capturedArgs.named.names.forEach(name => {
            Object.defineProperty(namedArgsProxy, name, {
              enumerable: true,
              configurable: true,

              get() {
                var ref = capturedArgs.named.get(name);
                (0, _metal.consume)(ref.tag);
                return ref.value();
              }

            });
          });
        }

        _metal.ARGS_PROXY_TAGS.set(namedArgsProxy, capturedArgs.named);

        value$$1 = {
          named: namedArgsProxy,
          positional: capturedArgs.positional.value()
        };
      }
      var component = delegate.createComponent(definition.ComponentClass.class, value$$1);
      return new CustomComponentState(delegate, component, capturedArgs, namedArgsProxy);
    }

    update({
      delegate,
      component,
      args,
      namedArgsProxy
    }) {
      var value$$1;
      {
        value$$1 = {
          named: namedArgsProxy,
          positional: args.positional.value()
        };
      }

      if (hasUpdateHook(delegate)) {
        delegate.updateComponent(component, value$$1);
      }
    }

    didCreate({
      delegate,
      component
    }) {
      if (hasAsyncLifeCycleCallbacks(delegate)) {
        delegate.didCreateComponent(component);
      }
    }

    didUpdate({
      delegate,
      component
    }) {
      if (hasAsyncUpdateHook(delegate)) {
        delegate.didUpdateComponent(component);
      }
    }

    getContext({
      delegate,
      component
    }) {
      delegate.getContext(component);
    }

    getSelf({
      delegate,
      component
    }) {
      return RootReference.create(delegate.getContext(component));
    }

    getDestructor(state) {
      if (hasDestructors(state.delegate)) {
        return state;
      } else {
        return null;
      }
    }

    getCapabilities({
      delegate
    }) {
      return (0, _polyfills.assign)({}, CAPABILITIES$2, {
        updateHook: delegate.capabilities.updateHook
      });
    }

    getTag({
      args
    }) {
      if ((0, _reference.isConst)(args)) {
        // returning a const tag skips the update hook (VM BUG?)
        return (0, _reference.createTag)();
      } else {
        return args.tag;
      }
    }

    didRenderLayout() {}

    getLayout(state) {
      return {
        handle: state.template.asLayout().compile(),
        symbolTable: state.symbolTable
      };
    }

  }

  var CUSTOM_COMPONENT_MANAGER = new CustomComponentManager();
  /**
   * Stores internal state about a component instance after it's been created.
   */

  class CustomComponentState {
    constructor(delegate, component, args, namedArgsProxy) {
      this.delegate = delegate;
      this.component = component;
      this.args = args;
      this.namedArgsProxy = namedArgsProxy;
    }

    destroy() {
      var {
        delegate,
        component
      } = this;

      if (hasDestructors(delegate)) {
        delegate.destroyComponent(component);
      }
    }

  }

  class CustomManagerDefinition {
    constructor(name, ComponentClass, delegate, template) {
      this.name = name;
      this.ComponentClass = ComponentClass;
      this.delegate = delegate;
      this.template = template;
      this.manager = CUSTOM_COMPONENT_MANAGER;
      var layout = template.asLayout();
      var symbolTable = layout.symbolTable;
      this.symbolTable = symbolTable;
      this.state = {
        name,
        ComponentClass,
        template,
        symbolTable,
        delegate
      };
    }

  }

  var CAPABILITIES$3 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: false,
    attributeHook: false,
    elementHook: false,
    createCaller: false,
    dynamicScope: false,
    updateHook: false,
    createInstance: true
  };

  class TemplateOnlyComponentManager extends AbstractManager {
    getLayout(template) {
      var layout = template.asLayout();
      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

    getCapabilities() {
      return CAPABILITIES$3;
    }

    create() {
      return null;
    }

    getSelf() {
      return _runtime2.NULL_REFERENCE;
    }

    getTag() {
      return _reference.CONSTANT_TAG;
    }

    getDestructor() {
      return null;
    }

  }

  var MANAGER = new TemplateOnlyComponentManager();

  class TemplateOnlyComponentDefinition {
    constructor(state) {
      this.state = state;
      this.manager = MANAGER;
    }

  }

  var helper$1;

  if (true
  /* DEBUG */
  ) {
    class ComponentAssertionReference {
      constructor(component, message) {
        this.component = component;
        this.message = message;
        this.tag = component.tag;
      }

      value() {
        var value$$1 = this.component.value();
        (true && !(typeof value$$1 !== 'string') && (0, _debug.assert)(this.message, typeof value$$1 !== 'string'));
        return value$$1;
      }

      get(property) {
        return this.component.get(property);
      }

    }

    helper$1 = (_vm, args) => new ComponentAssertionReference(args.positional.at(0), args.positional.at(1).value());
  } else {
    helper$1 = (_vm, args) => args.positional.at(0);
  }

  var componentAssertionHelper = helper$1;

  function classHelper({
    positional
  }) {
    var path = positional.at(0);
    var args = positional.length;
    var value$$1 = path.value();

    if (value$$1 === true) {
      if (args > 1) {
        return (0, _string.dasherize)(positional.at(1).value());
      }

      return null;
    }

    if (value$$1 === false) {
      if (args > 2) {
        return (0, _string.dasherize)(positional.at(2).value());
      }

      return null;
    }

    return value$$1;
  }

  function classHelper$1(_vm, args) {
    return new InternalHelperReference(classHelper, args.capture());
  }

  function inputTypeHelper({
    positional
  }) {
    var type = positional.at(0).value();

    if (type === 'checkbox') {
      return '-checkbox';
    }

    return '-text-field';
  }

  function inputTypeHelper$1(_vm, args) {
    return new InternalHelperReference(inputTypeHelper, args.capture());
  }

  function normalizeClass({
    positional
  }) {
    var classNameParts = positional.at(0).value().split('.');
    var className = classNameParts[classNameParts.length - 1];
    var value$$1 = positional.at(1).value();

    if (value$$1 === true) {
      return (0, _string.dasherize)(className);
    } else if (!value$$1 && value$$1 !== 0) {
      return '';
    } else {
      return String(value$$1);
    }
  }

  function normalizeClassHelper(_vm, args) {
    return new InternalHelperReference(normalizeClass, args.capture());
  }
  /**
  @module ember
  */

  /**
    The `{{action}}` helper provides a way to pass triggers for behavior (usually
    just a function) between components, and into components from controllers.
  
    ### Passing functions with the action helper
  
    There are three contexts an action helper can be used in. The first two
    contexts to discuss are attribute context, and Handlebars value context.
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    {{! Examples of Handlebars value context }}
    {{input on-input=(action "save")}}
    {{yield (action "refreshData") andAnotherParam}}
    ```
  
    In these contexts,
    the helper is called a "closure action" helper. Its behavior is simple:
    If passed a function name, read that function off the `actions` property
    of the current context. Once that function is read, or immediately if a function was
    passed, create a closure over that function and any arguments.
    The resulting value of an action helper used this way is simply a function.
  
    For example, in the attribute context:
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    ```
  
    The resulting template render logic would be:
  
    ```js
    var div = document.createElement('div');
    var actionFunction = (function(context){
      return function() {
        return context.actions.save.apply(context, arguments);
      };
    })(context);
    div.onclick = actionFunction;
    ```
  
    Thus when the div is clicked, the action on that context is called.
    Because the `actionFunction` is just a function, closure actions can be
    passed between components and still execute in the correct context.
  
    Here is an example action handler on a component:
  
    ```app/components/my-component.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      save() {
        this.model.save();
      }
    }
    ```
  
    Actions are always looked up on the `actions` property of the current context.
    This avoids collisions in the naming of common actions, such as `destroy`.
    Two options can be passed to the `action` helper when it is used in this way.
  
    * `target=someProperty` will look to `someProperty` instead of the current
      context for the `actions` hash. This can be useful when targeting a
      service for actions.
    * `value="target.value"` will read the path `target.value` off the first
      argument to the action when it is called and rewrite the first argument
      to be that value. This is useful when attaching actions to event listeners.
  
    ### Invoking an action
  
    Closure actions curry both their scope and any arguments. When invoked, any
    additional arguments are added to the already curried list.
    Actions should be invoked using the [sendAction](/ember/release/classes/Component/methods/sendAction?anchor=sendAction)
    method. The first argument to `sendAction` is the action to be called, and
    additional arguments are passed to the action function. This has interesting
    properties combined with currying of arguments. For example:
  
    ```app/components/update-name.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      setName(model, name) {
        model.set('name', name);
      }
    }
    ```
  
    ```app/components/update-name.hbs
    {{input on-input=(action (action 'setName' @model) value="target.value")}}
    ```
  
    The first argument (`@model`) was curried over, and the run-time argument (`event`)
    becomes a second argument. Action calls can be nested this way because each simply
    returns a function. Any function can be passed to the `{{action}}` helper, including
    other actions.
  
    Actions invoked with `sendAction` have the same currying behavior as demonstrated
    with `on-input` above. For example:
  
    ```app/components/my-input.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      setName(model, name) {
        model.set('name', name);
      }
    }
    ```
  
    ```handlebars
    <MyInput @submit={{action 'setName' @model}} />
    ```
  
    or
  
    ```handlebars
    {{my-input submit=(action 'setName' @model)}}
    ```
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click() {
        // Note that model is not passed, it was curried in the template
        this.sendAction('submit', 'bob');
      }
    });
    ```
  
    ### Attaching actions to DOM elements
  
    The third context of the `{{action}}` helper can be called "element space".
    For example:
  
    ```handlebars
    {{! An example of element space }}
    <div {{action "save"}}></div>
    ```
  
    Used this way, the `{{action}}` helper provides a useful shortcut for
    registering an HTML element in a template for a single DOM event and
    forwarding that interaction to the template's context (controller or component).
    If the context of a template is a controller, actions used this way will
    bubble to routes when the controller does not implement the specified action.
    Once an action hits a route, it will bubble through the route hierarchy.
  
    ### Event Propagation
  
    `{{action}}` helpers called in element space can control event bubbling. Note
    that the closure style actions cannot.
  
    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:
  
    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```
  
    To disable bubbling, pass `bubbles=false` to the helper:
  
    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```
  
    To disable bubbling with closure style actions you must create your own
    wrapper helper that makes use of `event.stopPropagation()`:
  
    ```handlebars
    <div onclick={{disable-bubbling (action "sayHello")}}>Hello</div>
    ```
  
    ```app/helpers/disable-bubbling.js
    import { helper } from '@ember/component/helper';
  
    export function disableBubbling([action]) {
      return function(event) {
        event.stopPropagation();
        return action(event);
      };
    }
    export default helper(disableBubbling);
    ```
  
    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See
    ["Responding to Browser Events"](/ember/release/classes/Component)
    in the documentation for `Component` for more information.
  
    ### Specifying DOM event type
  
    `{{action}}` helpers called in element space can specify an event type.
    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:
  
    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```
  
    See ["Event Names"](/ember/release/classes/Component) for a list of
    acceptable DOM event names.
  
    ### Specifying whitelisted modifier keys
  
    `{{action}}` helpers called in element space can specify modifier keys.
    By default the `{{action}}` helper will ignore click events with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```
  
    This way the action will fire when clicking with the alt key pressed down.
    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```
  
    ### Specifying a Target
  
    A `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:
  
    ```app/templates/application.hbs
    <div {{action "anActionName" target=someService}}>
      click me
    </div>
    ```
  
    ```app/controllers/application.js
    import Controller from '@ember/controller';
    import { inject as service } from '@ember/service';
  
    export default class extends Controller {
      @service someService;
    }
    ```
  
    @method action
    @for Ember.Templates.helpers
    @public
  */


  function action(_vm, args) {
    var {
      named,
      positional
    } = args;
    var capturedArgs = positional.capture(); // The first two argument slots are reserved.
    // pos[0] is the context (or `this`)
    // pos[1] is the action name or function
    // Anything else is an action argument.

    var [context, action, ...restArgs] = capturedArgs.references; // TODO: Is there a better way of doing this?

    var debugKey = action.propertyKey;
    var target = named.has('target') ? named.get('target') : context;
    var processArgs = makeArgsProcessor(named.has('value') && named.get('value'), restArgs);
    var fn;

    if (typeof action[INVOKE] === 'function') {
      fn = makeClosureAction(action, action, action[INVOKE], processArgs, debugKey);
    } else if ((0, _reference.isConst)(target) && (0, _reference.isConst)(action)) {
      fn = makeClosureAction(context.value(), target.value(), action.value(), processArgs, debugKey);
    } else {
      fn = makeDynamicClosureAction(context.value(), target, action, processArgs, debugKey);
    }

    fn[ACTION] = true;
    return new UnboundReference(fn);
  }

  function NOOP$1(args) {
    return args;
  }

  function makeArgsProcessor(valuePathRef, actionArgsRef) {
    var mergeArgs;

    if (actionArgsRef.length > 0) {
      mergeArgs = args => {
        return actionArgsRef.map(ref => ref.value()).concat(args);
      };
    }

    var readValue;

    if (valuePathRef) {
      readValue = args => {
        var valuePath = valuePathRef.value();

        if (valuePath && args.length > 0) {
          args[0] = (0, _metal.get)(args[0], valuePath);
        }

        return args;
      };
    }

    if (mergeArgs && readValue) {
      return args => {
        return readValue(mergeArgs(args));
      };
    } else {
      return mergeArgs || readValue || NOOP$1;
    }
  }

  function makeDynamicClosureAction(context, targetRef, actionRef, processArgs, debugKey) {
    // We don't allow undefined/null values, so this creates a throw-away action to trigger the assertions
    if (true
    /* DEBUG */
    ) {
      makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey);
    }

    return (...args) => {
      return makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey)(...args);
    };
  }

  function makeClosureAction(context, target, action, processArgs, debugKey) {
    var self;
    var fn;
    (true && !(action !== undefined && action !== null) && (0, _debug.assert)("Action passed is null or undefined in (action) from " + target + ".", action !== undefined && action !== null));

    if (typeof action[INVOKE] === 'function') {
      self = action;
      fn = action[INVOKE];
    } else {
      var typeofAction = typeof action;

      if (typeofAction === 'string') {
        self = target;
        fn = target.actions && target.actions[action];
        (true && !(fn) && (0, _debug.assert)("An action named '" + action + "' was not found in " + target, fn));
      } else if (typeofAction === 'function') {
        self = context;
        fn = action;
      } else {
        // tslint:disable-next-line:max-line-length
        (true && !(false) && (0, _debug.assert)("An action could not be made for `" + (debugKey || action) + "` in " + target + ". Please confirm that you are using either a quoted action name (i.e. `(action '" + (debugKey || 'myAction') + "')`) or a function available in " + target + ".", false));
      }
    }

    return (...args) => {
      var payload = {
        target: self,
        args,
        label: '@glimmer/closure-action'
      };
      return (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, () => {
        return (0, _runloop.join)(self, fn, ...processArgs(args));
      });
    };
  }
  /**
  @module ember
  */

  /**
     Use the `{{array}}` helper to create an array to pass as an option to your
     components.
  
     ```handlebars
     <MyComponent @people={{array
       'Tom Dade'
       'Yehuda Katz'
       this.myOtherPerson}}
     />
     ```
      or
     ```handlebars
     {{my-component people=(array
       'Tom Dade'
       'Yehuda Katz'
       this.myOtherPerson)
     }}
     ```
  
     Would result in an object such as:
  
     ```js
     ['Tom Date', 'Yehuda Katz', this.get('myOtherPerson')]
     ```
  
     Where the 3rd item in the array is bound to updates of the `myOtherPerson` property.
  
     @method array
     @for Ember.Templates.helpers
     @param {Array} options
     @return {Array} Array
     @since 3.8.0
     @public
   */


  function array(_vm, args) {
    return args.positional.capture();
  }

  var isEmpty = value$$1 => {
    return value$$1 === null || value$$1 === undefined || typeof value$$1.toString !== 'function';
  };

  var normalizeTextValue = value$$1 => {
    if (isEmpty(value$$1)) {
      return '';
    }

    return String(value$$1);
  };
  /**
  @module ember
  */

  /**
    Concatenates the given arguments into a string.
  
    Example:
  
    ```handlebars
    {{some-component name=(concat firstName " " lastName)}}
  
    {{! would pass name="<first name value> <last name value>" to the component}}
    ```
  
    or for angle bracket invocation, you actually don't need concat at all.
  
    ```handlebars
    <SomeComponent @name="{{firstName}} {{lastName}}" />
    ```
  
    @public
    @method concat
    @for Ember.Templates.helpers
    @since 1.13.0
  */


  function concat({
    positional
  }) {
    return positional.value().map(normalizeTextValue).join('');
  }

  function concat$1(_vm, args) {
    return new InternalHelperReference(concat, args.capture());
  }

  function buildUntouchableThis(source) {
    var context = null;

    if (true
    /* DEBUG */
    && _utils.HAS_NATIVE_PROXY) {
      var assertOnProperty = property => {
        (true && !(false) && (0, _debug.assert)("You accessed `this." + String(property) + "` from a function passed to the " + source + ", but the function itself was not bound to a valid `this` context. Consider updating to usage of `@action`."));
      };

      context = new Proxy({}, {
        get(_target, property) {
          assertOnProperty(property);
        },

        set(_target, property) {
          assertOnProperty(property);
          return false;
        },

        has(_target, property) {
          assertOnProperty(property);
          return false;
        }

      });
    }

    return context;
  }

  var context = buildUntouchableThis('`fn` helper');
  /**
  @module ember
  */

  /**
    The `fn` helper allows you to ensure a function that you are passing off
    to another component, helper, or modifier has access to arguments that are
    available in the template.
  
    For example, if you have an `each` helper looping over a number of items, you
    may need to pass a function that expects to receive the item as an argument
    to a component invoked within the loop. Here's how you could use the `fn`
    helper to pass both the function and its arguments together:
  
      ```app/templates/components/items-listing.hbs
    {{#each @items as |item|}}
      <DisplayItem @item=item @select={{fn this.handleSelected item}} />
    {{/each}}
    ```
  
    ```app/components/items-list.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class ItemsList extends Component {
      @action
      handleSelected(item) {
        // ...snip...
      }
    }
    ```
  
    In this case the `display-item` component will receive a normal function
    that it can invoke. When it invokes the function, the `handleSelected`
    function will receive the `item` and any arguments passed, thanks to the
    `fn` helper.
  
    Let's take look at what that means in a couple circumstances:
  
    - When invoked as `this.args.select()` the `handleSelected` function will
      receive the `item` from the loop as its first and only argument.
    - When invoked as `this.args.select('foo')` the `handleSelected` function
      will receive the `item` from the loop as its first argument and the
      string `'foo'` as its second argument.
  
    In the example above, we used `@action` to ensure that `handleSelected` is
    properly bound to the `items-list`, but let's explore what happens if we
    left out `@action`:
  
    ```app/components/items-list.js
    import Component from '@glimmer/component';
  
    export default class ItemsList extends Component {
      handleSelected(item) {
        // ...snip...
      }
    }
    ```
  
    In this example, when `handleSelected` is invoked inside the `display-item`
    component, it will **not** have access to the component instance. In other
    words, it will have no `this` context, so please make sure your functions
    are bound (via `@action` or other means) before passing into `fn`!
  
    See also [partial application](https://en.wikipedia.org/wiki/Partial_application).
  
    @method fn
    @for Ember.Templates.helpers
    @public
    @since 3.11.0
  */

  function fnHelper({
    positional
  }) {
    var callbackRef = positional.at(0);

    if (true
    /* DEBUG */
    && typeof callbackRef[INVOKE] !== 'function') {
      var callback = callbackRef.value();
      (true && !(typeof callback === 'function') && (0, _debug.assert)("You must pass a function as the `fn` helpers first argument, you passed " + callback, typeof callback === 'function'));
    }

    return (...invocationArgs) => {
      var [fn, ...args] = positional.value();

      if (typeof callbackRef[INVOKE] === 'function') {
        // references with the INVOKE symbol expect the function behind
        // the symbol to be bound to the reference
        return callbackRef[INVOKE](...args, ...invocationArgs);
      } else {
        return fn['call'](context, ...args, ...invocationArgs);
      }
    };
  }

  function fn(_vm, args) {
    return new InternalHelperReference(fnHelper, args.capture());
  }
  /**
  @module ember
  */

  /**
    Dynamically look up a property on an object. The second argument to `{{get}}`
    should have a string value, although it can be bound.
  
    For example, these two usages are equivalent:
  
    ```handlebars
    {{person.height}}
    {{get person "height"}}
    ```
  
    If there were several facts about a person, the `{{get}}` helper can dynamically
    pick one:
  
    ```handlebars
    {{get person factName}}
    ```
  
    For a more complex example, this template would allow the user to switch
    between showing the user's height and weight with a click:
  
    ```handlebars
    {{get person factName}}
    <button {{action (fn (mut factName)) "height"}}>Show height</button>
    <button {{action (fn (mut factName)) "weight"}}>Show weight</button>
    ```
  
    The `{{get}}` helper can also respect mutable values itself. For example:
  
    ```handlebars
    {{input value=(mut (get person factName)) type="text"}}
    <button {{action (fn (mut factName)) "height"}}>Show height</button>
    <button {{action (fn (mut factName)) "weight"}}>Show weight</button>
    ```
  
    Would allow the user to swap what fact is being displayed, and also edit
    that fact via a two-way mutable binding.
  
    @public
    @method get
    @for Ember.Templates.helpers
    @since 2.1.0
   */


  function get$1(_vm, args) {
    return GetHelperReference.create(args.positional.at(0), args.positional.at(1));
  }

  function referenceFromPath(source, path) {
    var innerReference;

    if (path === undefined || path === null || path === '') {
      innerReference = _runtime2.NULL_REFERENCE;
    } else if (typeof path === 'string' && path.indexOf('.') > -1) {
      innerReference = referenceFromParts(source, path.split('.'));
    } else {
      innerReference = source.get(path);
    }

    return innerReference;
  }

  class GetHelperReference extends CachedReference$1 {
    static create(sourceReference, pathReference) {
      if ((0, _reference.isConst)(pathReference)) {
        var path = pathReference.value();
        return referenceFromPath(sourceReference, path);
      } else {
        return new GetHelperReference(sourceReference, pathReference);
      }
    }

    constructor(sourceReference, pathReference) {
      super();
      this.sourceReference = sourceReference;
      this.pathReference = pathReference;
      this.lastPath = null;
      this.innerReference = _runtime2.NULL_REFERENCE;
      var innerTag = this.innerTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([sourceReference.tag, pathReference.tag, innerTag]);
    }

    compute() {
      var {
        lastPath,
        innerReference,
        innerTag
      } = this;
      var path = this.pathReference.value();

      if (path !== lastPath) {
        innerReference = referenceFromPath(this.sourceReference, path);
        (0, _reference.update)(innerTag, innerReference.tag);
        this.innerReference = innerReference;
        this.lastPath = path;
      }

      return innerReference.value();
    }

    [UPDATE](value$$1) {
      (0, _metal.set)(this.sourceReference.value(), this.pathReference.value(), value$$1);
    }

  }
  /**
  @module ember
  */

  /**
     Use the `{{hash}}` helper to create a hash to pass as an option to your
     components. This is specially useful for contextual components where you can
     just yield a hash:
  
     ```handlebars
     {{yield (hash
        name='Sarah'
        title=office
     )}}
     ```
  
     Would result in an object such as:
  
     ```js
     { name: 'Sarah', title: this.get('office') }
     ```
  
     Where the `title` is bound to updates of the `office` property.
  
     Note that the hash is an empty object with no prototype chain, therefore
     common methods like `toString` are not available in the resulting hash.
     If you need to use such a method, you can use the `call` or `apply`
     approach:
  
     ```js
     function toString(obj) {
       return Object.prototype.toString.apply(obj);
     }
     ```
  
     @method hash
     @for Ember.Templates.helpers
     @param {Object} options
     @return {Object} Hash
     @since 2.3.0
     @public
   */


  function hash(_vm, args) {
    return args.named.capture();
  }
  /**
  @module ember
  */


  class ConditionalHelperReference extends CachedReference$1 {
    static create(_condRef, truthyRef, falsyRef) {
      var condRef = ConditionalReference$1.create(_condRef);

      if ((0, _reference.isConst)(condRef)) {
        return condRef.value() ? truthyRef : falsyRef;
      } else {
        return new ConditionalHelperReference(condRef, truthyRef, falsyRef);
      }
    }

    constructor(cond, truthy, falsy) {
      super();
      this.branchTag = (0, _reference.createUpdatableTag)();
      this.tag = (0, _reference.combine)([cond.tag, this.branchTag]);
      this.cond = cond;
      this.truthy = truthy;
      this.falsy = falsy;
    }

    compute() {
      var branch = this.cond.value() ? this.truthy : this.falsy;
      (0, _reference.update)(this.branchTag, branch.tag);
      return branch.value();
    }

  }
  /**
    The `if` helper allows you to conditionally render one of two branches,
    depending on the "truthiness" of a property.
    For example the following values are all falsey: `false`, `undefined`, `null`, `""`, `0`, `NaN` or an empty array.
  
    This helper has two forms, block and inline.
  
    ## Block form
  
    You can use the block form of `if` to conditionally render a section of the template.
  
    To use it, pass the conditional value to the `if` helper,
    using the block form to wrap the section of template you want to conditionally render.
    Like so:
  
    ```handlebars
    {{! will not render if foo is falsey}}
    {{#if foo}}
      Welcome to the {{foo.bar}}
    {{/if}}
    ```
  
    You can also specify a template to show if the property is falsey by using
    the `else` helper.
  
    ```handlebars
    {{! is it raining outside?}}
    {{#if isRaining}}
      Yes, grab an umbrella!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    You are also able to combine `else` and `if` helpers to create more complex
    conditional logic.
  
    ```handlebars
    {{#if isMorning}}
      Good morning
    {{else if isAfternoon}}
      Good afternoon
    {{else}}
      Good night
    {{/if}}
    ```
  
    ## Inline form
  
    The inline `if` helper conditionally renders a single property or string.
  
    In this form, the `if` helper receives three arguments, the conditional value,
    the value to render when truthy, and the value to render when falsey.
  
    For example, if `useLongGreeting` is truthy, the following:
  
    ```handlebars
    {{if useLongGreeting "Hello" "Hi"}} Alex
    ```
  
    Will render:
  
    ```html
    Hello Alex
    ```
  
    ### Nested `if`
  
    You can use the `if` helper inside another helper as a nested helper:
  
    ```handlebars
    <SomeComponent @height={{if isBig "100" "10"}} />
    ```
  
    or
  
    ```handlebars
    {{some-component height=(if isBig "100" "10")}}
    ```
  
    One detail to keep in mind is that both branches of the `if` helper will be evaluated,
    so if you have `{{if condition "foo" (expensive-operation "bar")`,
    `expensive-operation` will always calculate.
  
    @method if
    @for Ember.Templates.helpers
    @public
  */


  function inlineIf(_vm, {
    positional
  }) {
    (true && !(positional.length === 3 || positional.length === 2) && (0, _debug.assert)('The inline form of the `if` helper expects two or three arguments, e.g. ' + '`{{if trialExpired "Expired" expiryDate}}`.', positional.length === 3 || positional.length === 2));
    return ConditionalHelperReference.create(positional.at(0), positional.at(1), positional.at(2));
  }
  /**
    The `unless` helper is the inverse of the `if` helper. It displays if a value
    is falsey ("not true" or "is false"). Example values that will display with
    `unless`: `false`, `undefined`, `null`, `""`, `0`, `NaN` or an empty array.
  
    ## Inline form
  
    The inline `unless` helper conditionally renders a single property or string.
    This helper acts like a ternary operator. If the first property is falsy,
    the second argument will be displayed, otherwise, the third argument will be
    displayed
  
    For example, if `useLongGreeting` is false below:
  
    ```handlebars
    {{unless useLongGreeting "Hi" "Hello"}} Ben
    ```
  
    Then it will display:
  
    ```html
    Hi
    ```
  
    You can use the `unless` helper inside another helper as a subexpression.
    If isBig is not true, it will set the height to 10:
  
    ```handlebars
    {{! If isBig is not true, it will set the height to 10.}}
    <SomeComponent @height={{unless isBig "10" "100"}} />
    ```
  
    or
  
    ```handlebars
    {{some-component height=(unless isBig "10" "100")}}
    ```
  
    ## Block form
  
    Like the `if` helper, `unless` helper also has a block form.
  
    ```handlebars
    {{! If greetings are found, the text below will not render.}}
    {{#unless greetings}}
      No greetings were found. Why not set one?
    {{/unless}}
    ```
  
    You can also use an `else` helper with the `unless` block. The
    `else` will display if the value is truthy.
  
    ```handlebars
    {{! Is the user logged in?}}
    {{#unless userData}}
      Please login.
    {{else}}
      Welcome back!
    {{/unless}}
    ```
  
    If `userData` is false, undefined, null, or empty in the above example,
    then it will render:
  
    ```html
    Please login.
    ```
  
    @method unless
    @for Ember.Templates.helpers
    @public
  */


  function inlineUnless(_vm, {
    positional
  }) {
    (true && !(positional.length === 3 || positional.length === 2) && (0, _debug.assert)('The inline form of the `unless` helper expects two or three arguments, e.g. ' + '`{{unless isFirstLogin "Welcome back!"}}`.', positional.length === 3 || positional.length === 2));
    return ConditionalHelperReference.create(positional.at(0), positional.at(2), positional.at(1));
  }
  /**
  @module ember
  */

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.
  
    ```handlebars
    {{log "myVariable:" myVariable }}
    ```
  
    @method log
    @for Ember.Templates.helpers
    @param {Array} params
    @public
  */


  function log({
    positional
  }) {
    /* eslint-disable no-console */
    console.log(...positional.value());
    /* eslint-enable no-console */
  }

  function log$1(_vm, args) {
    return new InternalHelperReference(log, args.capture());
  }
  /**
  @module ember
  */

  /**
    The `mut` helper lets you __clearly specify__ that a child `Component` can update the
    (mutable) value passed to it, which will __change the value of the parent component__.
  
    To specify that a parameter is mutable, when invoking the child `Component`:
  
    ```handlebars
    <MyChild @childClickCount={{fn (mut totalClicks)}} />
    ```
  
     or
  
    ```handlebars
    {{my-child childClickCount=(mut totalClicks)}}
    ```
  
    The child `Component` can then modify the parent's value just by modifying its own
    property:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    Note that for curly components (`{{my-component}}`) the bindings are already mutable,
    making the `mut` unnecessary.
  
    Additionally, the `mut` helper can be combined with the `fn` helper to
    mutate a value. For example:
  
    ```handlebars
    <MyChild @childClickCount={{this.totalClicks}} @click-count-change={{fn (mut totalClicks))}} />
    ```
  
    or
  
    ```handlebars
    {{my-child childClickCount=totalClicks click-count-change=(fn (mut totalClicks))}}
    ```
  
    The child `Component` would invoke the function with the new click value:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('click-count-change')(this.get('childClickCount') + 1);
      }
    });
    ```
  
    The `mut` helper changes the `totalClicks` value to what was provided as the `fn` argument.
  
    The `mut` helper, when used with `fn`, will return a function that
    sets the value passed to `mut` to its first argument. As an example, we can create a
    button that increments a value passing the value directly to the `fn`:
  
    ```handlebars
    {{! inc helper is not provided by Ember }}
    <button onclick={{fn (mut count) (inc count)}}>
      Increment count
    </button>
    ```
  
    You can also use the `value` option:
  
    ```handlebars
    <input value={{name}} oninput={{fn (mut name) value="target.value"}}>
    ```
  
    @method mut
    @param {Object} [attr] the "two-way" attribute that can be modified.
    @for Ember.Templates.helpers
    @public
  */


  var MUT_REFERENCE = (0, _utils.symbol)('MUT');
  var SOURCE = (0, _utils.symbol)('SOURCE');

  function isMut(ref) {
    return ref && ref[MUT_REFERENCE];
  }

  function unMut(ref) {
    return ref[SOURCE] || ref;
  }

  function mut(_vm, args) {
    var rawRef = args.positional.at(0);

    if (isMut(rawRef)) {
      return rawRef;
    } // TODO: Improve this error message. This covers at least two distinct
    // cases:
    //
    // 1. (mut "not a path") – passing a literal, result from a helper
    //    invocation, etc
    //
    // 2. (mut receivedValue) – passing a value received from the caller
    //    that was originally derived from a literal, result from a helper
    //    invocation, etc
    //
    // This message is alright for the first case, but could be quite
    // confusing for the second case.


    (true && !(rawRef[UPDATE]) && (0, _debug.assert)('You can only pass a path to mut', rawRef[UPDATE]));
    var wrappedRef = Object.create(rawRef);
    wrappedRef[SOURCE] = rawRef;
    wrappedRef[INVOKE] = rawRef[UPDATE];
    wrappedRef[MUT_REFERENCE] = true;
    return wrappedRef;
  }
  /**
  @module ember
  */

  /**
    This is a helper to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.
  
    @example In this example we are setting the `direction` query param to the value `"asc"`
  
    ```app/templates/application.hbs
    <LinkTo
      @route="posts"
      {{query-params direction="asc"}}
    >
      Sort
    </LinkTo>
    ```
  
    @method query-params
    @for Ember.Templates.helpers
    @param {Object} hash takes a hash of query parameters
    @return {Object} A `QueryParams` object for `{{link-to}}`
    @public
  */


  function queryParams({
    positional,
    named
  }) {
    // tslint:disable-next-line:max-line-length
    (true && !(positional.value().length === 0) && (0, _debug.assert)("The `query-params` helper only accepts hash parameters, e.g. (query-params queryParamPropertyName='foo') as opposed to just (query-params 'foo')", positional.value().length === 0));
    return new _routing.QueryParams((0, _polyfills.assign)({}, named.value()));
  }

  function queryParams$1(_vm, args) {
    return new InternalHelperReference(queryParams, args.capture());
  }
  /**
    The `readonly` helper let's you specify that a binding is one-way only,
    instead of two-way.
    When you pass a `readonly` binding from an outer context (e.g. parent component),
    to to an inner context (e.g. child component), you are saying that changing that
    property in the inner context does not change the value in the outer context.
  
    To specify that a binding is read-only, when invoking the child `Component`:
  
    ```app/components/my-parent.js
    export default Component.extend({
      totalClicks: 3
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} // -> 3
    <MyChild @childClickCount={{readonly totalClicks}} />
    ```
    ```
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    Now, when you update `childClickCount`:
  
    ```app/components/my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    The value updates in the child component, but not the parent component:
  
    ```app/templates/components/my-child.hbs
    {{log childClickCount}} //-> 4
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} //-> 3
    <MyChild @childClickCount={{readonly totalClicks}} />
    ```
    or
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} //-> 3
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    ### Objects and Arrays
  
    When passing a property that is a complex object (e.g. object, array) instead of a primitive object (e.g. number, string),
    only the reference to the object is protected using the readonly helper.
    This means that you can change properties of the object both on the parent component, as well as the child component.
    The `readonly` binding behaves similar to the `const` keyword in JavaScript.
  
    Let's look at an example:
  
    First let's set up the parent component:
  
    ```app/components/my-parent.js
    import Component from '@ember/component';
  
    export default Component.extend({
      clicks: null,
  
      init() {
        this._super(...arguments);
        this.set('clicks', { total: 3 });
      }
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 3
    <MyChild @childClicks={{readonly clicks}} />
    ```
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 3
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    Now, if you update the `total` property of `childClicks`:
  
    ```app/components/my-child.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click() {
        this.get('clicks').incrementProperty('total');
      }
    });
    ```
  
    You will see the following happen:
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 4
    <MyChild @childClicks={{readonly clicks}} />
    ```
    or
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 4
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    ```app/templates/components/my-child.hbs
    {{log childClicks.total}} //-> 4
    ```
  
    @method readonly
    @param {Object} [attr] the read-only attribute.
    @for Ember.Templates.helpers
    @private
  */


  function readonly(_vm, args) {
    var ref = unMut(args.positional.at(0));
    return new ReadonlyReference(ref);
  }
  /**
  @module ember
  */

  /**
    The `{{unbound}}` helper disconnects the one-way binding of a property,
    essentially freezing its value at the moment of rendering. For example,
    in this example the display of the variable `name` will not change even
    if it is set with a new value:
  
    ```handlebars
    {{unbound name}}
    ```
  
    Like any helper, the `unbound` helper can accept a nested helper expression.
    This allows for custom helpers to be rendered unbound:
  
    ```handlebars
    {{unbound (some-custom-helper)}}
    {{unbound (capitalize name)}}
    {{! You can use any helper, including unbound, in a nested expression }}
    {{capitalize (unbound name)}}
    ```
  
    The `unbound` helper only accepts a single argument, and it return an
    unbound value.
  
    @method unbound
    @for Ember.Templates.helpers
    @public
  */


  function unbound(_vm, args) {
    (true && !(args.positional.length === 1 && args.named.length === 0) && (0, _debug.assert)('unbound helper cannot be called with multiple params or hash params', args.positional.length === 1 && args.named.length === 0));
    return UnboundReference.create(args.positional.at(0).value());
  }

  var MODIFIERS = ['alt', 'shift', 'meta', 'ctrl'];
  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;

  function isAllowedEvent(event, allowedKeys) {
    if (allowedKeys === null || allowedKeys === undefined) {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return (0, _views.isSimpleClick)(event);
      } else {
        allowedKeys = '';
      }
    }

    if (allowedKeys.indexOf('any') >= 0) {
      return true;
    }

    for (var i = 0; i < MODIFIERS.length; i++) {
      if (event[MODIFIERS[i] + 'Key'] && allowedKeys.indexOf(MODIFIERS[i]) === -1) {
        return false;
      }
    }

    return true;
  }

  var ActionHelper = {
    // registeredActions is re-exported for compatibility with older plugins
    // that were using this undocumented API.
    registeredActions: _views.ActionManager.registeredActions,

    registerAction(actionState) {
      var {
        actionId
      } = actionState;
      _views.ActionManager.registeredActions[actionId] = actionState;
      return actionId;
    },

    unregisterAction(actionState) {
      var {
        actionId
      } = actionState;
      delete _views.ActionManager.registeredActions[actionId];
    }

  };

  class ActionState {
    constructor(element, actionId, actionName, actionArgs, namedArgs, positionalArgs, implicitTarget, dom, tag) {
      this.element = element;
      this.actionId = actionId;
      this.actionName = actionName;
      this.actionArgs = actionArgs;
      this.namedArgs = namedArgs;
      this.positional = positionalArgs;
      this.implicitTarget = implicitTarget;
      this.dom = dom;
      this.eventName = this.getEventName();
      this.tag = tag;
    }

    getEventName() {
      return this.namedArgs.get('on').value() || 'click';
    }

    getActionArgs() {
      var result = new Array(this.actionArgs.length);

      for (var i = 0; i < this.actionArgs.length; i++) {
        result[i] = this.actionArgs[i].value();
      }

      return result;
    }

    getTarget() {
      var {
        implicitTarget,
        namedArgs
      } = this;
      var target;

      if (namedArgs.has('target')) {
        target = namedArgs.get('target').value();
      } else {
        target = implicitTarget.value();
      }

      return target;
    }

    handler(event) {
      var {
        actionName,
        namedArgs
      } = this;
      var bubbles = namedArgs.get('bubbles');
      var preventDefault = namedArgs.get('preventDefault');
      var allowedKeys = namedArgs.get('allowedKeys');
      var target = this.getTarget();
      var shouldBubble = bubbles.value() !== false;

      if (!isAllowedEvent(event, allowedKeys.value())) {
        return true;
      }

      if (preventDefault.value() !== false) {
        event.preventDefault();
      }

      if (!shouldBubble) {
        event.stopPropagation();
      }

      (0, _runloop.join)(() => {
        var args = this.getActionArgs();
        var payload = {
          args,
          target,
          name: null
        };

        if (typeof actionName[INVOKE] === 'function') {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, () => {
            actionName[INVOKE].apply(actionName, args);
          });
          return;
        }

        if (typeof actionName === 'function') {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, () => {
            actionName.apply(target, args);
          });
          return;
        }

        payload.name = actionName;

        if (target.send) {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, () => {
            target.send.apply(target, [actionName, ...args]);
          });
        } else {
          (true && !(typeof target[actionName] === 'function') && (0, _debug.assert)("The action '" + actionName + "' did not exist on " + target, typeof target[actionName] === 'function'));
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, () => {
            target[actionName].apply(target, args);
          });
        }
      });
      return shouldBubble;
    }

    destroy() {
      ActionHelper.unregisterAction(this);
    }

  } // implements ModifierManager<Action>


  class ActionModifierManager {
    create(element, _state, args, _dynamicScope, dom) {
      var {
        named,
        positional,
        tag
      } = args.capture();
      var implicitTarget;
      var actionName;
      var actionNameRef;

      if (positional.length > 1) {
        implicitTarget = positional.at(0);
        actionNameRef = positional.at(1);

        if (actionNameRef[INVOKE]) {
          actionName = actionNameRef;
        } else {
          var actionLabel = actionNameRef.propertyKey;
          actionName = actionNameRef.value();
          (true && !(typeof actionName === 'string' || typeof actionName === 'function') && (0, _debug.assert)('You specified a quoteless path, `' + actionLabel + '`, to the ' + '{{action}} helper which did not resolve to an action name (a ' + 'string). Perhaps you meant to use a quoted actionName? (e.g. ' + '{{action "' + actionLabel + '"}}).', typeof actionName === 'string' || typeof actionName === 'function'));
        }
      }

      var actionArgs = []; // The first two arguments are (1) `this` and (2) the action name.
      // Everything else is a param.

      for (var i = 2; i < positional.length; i++) {
        actionArgs.push(positional.at(i));
      }

      var actionId = (0, _utils.uuid)();
      var actionState = new ActionState(element, actionId, actionName, actionArgs, named, positional, implicitTarget, dom, tag);
      (true && !(actionState.eventName !== 'mouseEnter' && actionState.eventName !== 'mouseLeave' && actionState.eventName !== 'mouseMove') && (0, _debug.deprecate)("Using the `{{action}}` modifier with `" + actionState.eventName + "` events has been deprecated.", actionState.eventName !== 'mouseEnter' && actionState.eventName !== 'mouseLeave' && actionState.eventName !== 'mouseMove', {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_action-mouseenter-leave-move'
      }));
      return actionState;
    }

    install(actionState) {
      var {
        dom,
        element,
        actionId
      } = actionState;
      ActionHelper.registerAction(actionState);
      dom.setAttribute(element, 'data-ember-action', '');
      dom.setAttribute(element, "data-ember-action-" + actionId, actionId);
    }

    update(actionState) {
      var {
        positional
      } = actionState;
      var actionNameRef = positional.at(1);

      if (!actionNameRef[INVOKE]) {
        actionState.actionName = actionNameRef.value();
      }

      actionState.eventName = actionState.getEventName();
    }

    getTag(actionState) {
      return actionState.tag;
    }

    getDestructor(modifier) {
      return modifier;
    }

  }

  function capabilities$1(managerAPI, optionalFeatures = {}) {
    if (managerAPI !== '3.13') {
      managerAPI = '3.13';
      (true && !(false) && (0, _debug.deprecate)('Modifier manager capabilities now require you to pass a valid version when being generated. Valid versions include: 3.13', false, {
        until: '3.17.0',
        id: 'implicit-modifier-manager-capabilities'
      }));
    }

    (true && !(managerAPI === '3.13') && (0, _debug.assert)('Invalid modifier manager compatibility specified', managerAPI === '3.13'));
    return {
      disableAutoTracking: Boolean(optionalFeatures.disableAutoTracking)
    };
  }

  class CustomModifierDefinition {
    constructor(name, ModifierClass, delegate, isInteractive) {
      this.name = name;
      this.ModifierClass = ModifierClass;
      this.delegate = delegate;
      this.state = {
        ModifierClass,
        name,
        delegate
      };
      this.manager = isInteractive ? CUSTOM_INTERACTIVE_MODIFIER_MANAGER : CUSTOM_NON_INTERACTIVE_MODIFIER_MANAGER;
    }

  }

  class CustomModifierState {
    constructor(element, delegate, modifier, args) {
      this.element = element;
      this.delegate = delegate;
      this.modifier = modifier;
      this.args = args;
      this.tag = (0, _reference.createUpdatableTag)();
    }

    destroy() {
      var {
        delegate,
        modifier,
        args
      } = this;
      delegate.destroyModifier(modifier, args.value());
    }

  }
  /**
    The CustomModifierManager allows addons to provide custom modifier
    implementations that integrate seamlessly into Ember. This is accomplished
    through a delegate, registered with the custom modifier manager, which
    implements a set of hooks that determine modifier behavior.
    To create a custom modifier manager, instantiate a new CustomModifierManager
    class and pass the delegate as the first argument:
  
    ```js
    let manager = new CustomModifierManager({
      // ...delegate implementation...
    });
    ```
  
    ## Delegate Hooks
  
    Throughout the lifecycle of a modifier, the modifier manager will invoke
    delegate hooks that are responsible for surfacing those lifecycle changes to
    the end developer.
    * `createModifier()` - invoked when a new instance of a modifier should be created
    * `installModifier()` - invoked when the modifier is installed on the element
    * `updateModifier()` - invoked when the arguments passed to a modifier change
    * `destroyModifier()` - invoked when the modifier is about to be destroyed
  */


  class InteractiveCustomModifierManager {
    create(element, definition, args) {
      var {
        delegate,
        ModifierClass
      } = definition;
      var capturedArgs = args.capture();
      var instance = definition.delegate.createModifier(ModifierClass, capturedArgs.value());

      if (delegate.capabilities === undefined) {
        delegate.capabilities = capabilities$1('3.13');
        (true && !(false) && (0, _debug.deprecate)('Custom modifier managers must define their capabilities using the capabilities() helper function', false, {
          until: '3.17.0',
          id: 'implicit-modifier-manager-capabilities'
        }));
      }

      return new CustomModifierState(element, delegate, instance, capturedArgs);
    }

    getTag({
      args,
      tag
    }) {
      return (0, _reference.combine)([tag, args.tag]);
    }

    install(state) {
      var {
        element,
        args,
        delegate,
        modifier,
        tag
      } = state;
      var {
        capabilities
      } = delegate;

      if (capabilities.disableAutoTracking === true) {
        (0, _metal.untrack)(() => delegate.installModifier(modifier, element, args.value()));
      } else {
        var combinedTrackingTag = (0, _metal.track)(() => delegate.installModifier(modifier, element, args.value()));
        (0, _reference.update)(tag, combinedTrackingTag);
      }
    }

    update(state) {
      var {
        args,
        delegate,
        modifier,
        tag
      } = state;
      var {
        capabilities
      } = delegate;

      if (capabilities.disableAutoTracking === true) {
        (0, _metal.untrack)(() => delegate.updateModifier(modifier, args.value()));
      } else {
        var combinedTrackingTag = (0, _metal.track)(() => delegate.updateModifier(modifier, args.value()));
        (0, _reference.update)(tag, combinedTrackingTag);
      }
    }

    getDestructor(state) {
      return state;
    }

  }

  class NonInteractiveCustomModifierManager {
    create() {
      return null;
    }

    getTag() {
      return _reference.CONSTANT_TAG;
    }

    install() {}

    update() {}

    getDestructor() {
      return null;
    }

  }

  var CUSTOM_INTERACTIVE_MODIFIER_MANAGER = new InteractiveCustomModifierManager();
  var CUSTOM_NON_INTERACTIVE_MODIFIER_MANAGER = new NonInteractiveCustomModifierManager();
  var untouchableContext = buildUntouchableThis('`on` modifier');
  /**
  @module ember
  */

  /*
    Internet Explorer 11 does not support `once` and also does not support
    passing `eventOptions`. In some situations it then throws a weird script
    error, like:
  
    ```
    Could not complete the operation due to error 80020101
    ```
  
    This flag determines, whether `{ once: true }` and thus also event options in
    general are supported.
  */

  var SUPPORTS_EVENT_OPTIONS = (() => {
    try {
      var div = document.createElement('div');
      var counter = 0;
      div.addEventListener('click', () => counter++, {
        once: true
      });
      var event;

      if (typeof Event === 'function') {
        event = new Event('click');
      } else {
        event = document.createEvent('Event');
        event.initEvent('click', true, true);
      }

      div.dispatchEvent(event);
      div.dispatchEvent(event);
      return counter === 1;
    } catch (error) {
      return false;
    }
  })();

  class OnModifierState {
    constructor(element, args) {
      this.shouldUpdate = true;
      this.element = element;
      this.args = args;
      this.tag = args.tag;
    }

    updateFromArgs() {
      var {
        args
      } = this;
      var {
        once,
        passive,
        capture
      } = args.named.value();

      if (once !== this.once) {
        this.once = once;
        this.shouldUpdate = true;
      }

      if (passive !== this.passive) {
        this.passive = passive;
        this.shouldUpdate = true;
      }

      if (capture !== this.capture) {
        this.capture = capture;
        this.shouldUpdate = true;
      }

      var options;

      if (once || passive || capture) {
        options = this.options = {
          once,
          passive,
          capture
        };
      } else {
        this.options = undefined;
      }

      (true && !(args.positional.at(0) !== undefined && typeof args.positional.at(0).value() === 'string') && (0, _debug.assert)('You must pass a valid DOM event name as the first argument to the `on` modifier', args.positional.at(0) !== undefined && typeof args.positional.at(0).value() === 'string'));
      var eventName = args.positional.at(0).value();

      if (eventName !== this.eventName) {
        this.eventName = eventName;
        this.shouldUpdate = true;
      }

      (true && !(args.positional.at(1) !== undefined && typeof args.positional.at(1).value() === 'function') && (0, _debug.assert)('You must pass a function as the second argument to the `on` modifier', args.positional.at(1) !== undefined && typeof args.positional.at(1).value() === 'function'));
      var userProvidedCallback = args.positional.at(1).value();

      if (userProvidedCallback !== this.userProvidedCallback) {
        this.userProvidedCallback = userProvidedCallback;
        this.shouldUpdate = true;
      }

      (true && !(args.positional.length === 2) && (0, _debug.assert)("You can only pass two positional arguments (event name and callback) to the `on` modifier, but you provided " + args.positional.length + ". Consider using the `fn` helper to provide additional arguments to the `on` callback.", args.positional.length === 2));
      var needsCustomCallback = SUPPORTS_EVENT_OPTIONS === false && once ||
      /* needs manual once implementation */
      true
      /* DEBUG */
      && passive
      /* needs passive enforcement */
      ;

      if (this.shouldUpdate) {
        if (needsCustomCallback) {
          var callback = this.callback = function (event) {
            if (true
            /* DEBUG */
            && passive) {
              event.preventDefault = () => {
                (true && !(false) && (0, _debug.assert)("You marked this listener as 'passive', meaning that you must not call 'event.preventDefault()': \n\n" + userProvidedCallback));
              };
            }

            if (!SUPPORTS_EVENT_OPTIONS && once) {
              removeEventListener(this, eventName, callback, options);
            }

            return userProvidedCallback.call(untouchableContext, event);
          };
        } else if (true
        /* DEBUG */
        ) {
          // prevent the callback from being bound to the element
          this.callback = userProvidedCallback.bind(untouchableContext);
        } else {
          this.callback = userProvidedCallback;
        }
      }
    }

    destroy() {
      var {
        element,
        eventName,
        callback,
        options
      } = this;
      removeEventListener(element, eventName, callback, options);
    }

  }

  var adds = 0;
  var removes = 0;

  function removeEventListener(element, eventName, callback, options) {
    removes++;

    if (SUPPORTS_EVENT_OPTIONS) {
      // when options are supported, use them across the board
      element.removeEventListener(eventName, callback, options);
    } else if (options !== undefined && options.capture) {
      // used only in the following case:
      //
      // `{ once: true | false, passive: true | false, capture: true }
      //
      // `once` is handled via a custom callback that removes after first
      // invocation so we only care about capture here as a boolean
      element.removeEventListener(eventName, callback, true);
    } else {
      // used only in the following cases:
      //
      // * where there is no options
      // * `{ once: true | false, passive: true | false, capture: false }
      element.removeEventListener(eventName, callback);
    }
  }

  function addEventListener(element, eventName, callback, options) {
    adds++;

    if (SUPPORTS_EVENT_OPTIONS) {
      // when options are supported, use them across the board
      element.addEventListener(eventName, callback, options);
    } else if (options !== undefined && options.capture) {
      // used only in the following case:
      //
      // `{ once: true | false, passive: true | false, capture: true }
      //
      // `once` is handled via a custom callback that removes after first
      // invocation so we only care about capture here as a boolean
      element.addEventListener(eventName, callback, true);
    } else {
      // used only in the following cases:
      //
      // * where there is no options
      // * `{ once: true | false, passive: true | false, capture: false }
      element.addEventListener(eventName, callback);
    }
  }
  /**
    The `{{on}}` modifier lets you easily add event listeners (it uses
    [EventTarget.addEventListener](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener)
    internally).
  
    For example, if you'd like to run a function on your component when a `<button>`
    in the components template is clicked you might do something like:
  
    ```app/templates/components/like-post.hbs
    <button {{on 'click' this.saveLike}}>Like this post!</button>
    ```
  
    ```app/components/like-post.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class LikePostComponent extends Component {
      @action
      saveLike() {
        // someone likes your post!
        // better send a request off to your server...
      }
    }
    ```
  
    ### Arguments
  
    `{{on}}` accepts two positional arguments, and a few named arguments.
  
    The positional arguments are:
  
    - `event` -- the name to use when calling `addEventListener`
    - `callback` -- the function to be passed to `addEventListener`
  
    The named arguments are:
  
    - capture -- a `true` value indicates that events of this type will be dispatched
      to the registered listener before being dispatched to any EventTarget beneath it
      in the DOM tree.
    - once -- indicates that the listener should be invoked at most once after being
      added. If true, the listener would be automatically removed when invoked.
    - passive -- if `true`, indicates that the function specified by listener will never
      call preventDefault(). If a passive listener does call preventDefault(), the user
      agent will do nothing other than generate a console warning. See
      [Improving scrolling performance with passive listeners](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Improving_scrolling_performance_with_passive_listeners)
      to learn more.
  
    The callback function passed to `{{on}}` will receive any arguments that are passed
    to the event handler. Most commonly this would be the `event` itself.
  
    If you would like to pass additional arguments to the function you should use
    the `{{fn}}` helper.
  
    For example, in our example case above if you'd like to pass in the post that
    was being liked when the button is clicked you could do something like:
  
    ```app/templates/components/like-post.js
    <button {{on 'click' (fn this.saveLike @post)}}>Like this post!</button>
    ```
  
    In this case, the `saveLike` function will receive two arguments: the click event
    and the value of `@post`.
  
    ### Function Context
  
    In the example above, we used `@action` to ensure that `likePost` is
    properly bound to the `items-list`, but let's explore what happens if we
    left out `@action`:
  
    ```app/components/like-post.js
    import Component from '@glimmer/component';
  
    export default class LikePostComponent extends Component {
      saveLike() {
        // ...snip...
      }
    }
    ```
  
    In this example, when the button is clicked `saveLike` will be invoked,
    it will **not** have access to the component instance. In other
    words, it will have no `this` context, so please make sure your functions
    are bound (via `@action` or other means) before passing into `on`!
  
    @method on
    @for Ember.Templates.helpers
    @public
    @since 3.11.0
  */


  class OnModifierManager {
    constructor(isInteractive) {
      this.SUPPORTS_EVENT_OPTIONS = SUPPORTS_EVENT_OPTIONS;
      this.isInteractive = isInteractive;
    }

    get counters() {
      return {
        adds,
        removes
      };
    }

    create(element, _state, args) {
      if (!this.isInteractive) {
        return null;
      }

      var capturedArgs = args.capture();
      return new OnModifierState(element, capturedArgs);
    }

    getTag(state) {
      if (state === null) {
        return _reference.CONSTANT_TAG;
      }

      return state.tag;
    }

    install(state) {
      if (state === null) {
        return;
      }

      state.updateFromArgs();
      var {
        element,
        eventName,
        callback,
        options
      } = state;
      addEventListener(element, eventName, callback, options);
      state.shouldUpdate = false;
    }

    update(state) {
      if (state === null) {
        return;
      } // stash prior state for el.removeEventListener


      var {
        element,
        eventName,
        callback,
        options
      } = state;
      state.updateFromArgs();

      if (!state.shouldUpdate) {
        return;
      } // use prior state values for removal


      removeEventListener(element, eventName, callback, options); // read updated values from the state object

      addEventListener(state.element, state.eventName, state.callback, state.options);
      state.shouldUpdate = false;
    }

    getDestructor(state) {
      return state;
    }

  }
  /**
  @module ember
  */

  /**
      The `let` helper receives one or more positional arguments and yields
      them out as block params.
  
      This allows the developer to introduce shorter names for certain computations
      in the template.
  
      This is especially useful if you are passing properties to a component
      that receives a lot of options and you want to clean up the invocation.
  
      For the following example, the template receives a `post` object with
      `content` and `title` properties.
  
      We are going to call the `my-post` component, passing a title which is
      the title of the post suffixed with the name of the blog, the content
      of the post, and a series of options defined in-place.
  
      ```handlebars
      {{#let
          (concat post.title ' | The Ember.js Blog')
          post.content
          (hash
            theme="high-contrast"
            enableComments=true
          )
          as |title content options|
      }}
        <MyPost @title={{title}} @content={{content}} @options={{options}} />
      {{/let}}
    ```
   or
    ```handlebars
      {{#let
          (concat post.title ' | The Ember.js Blog')
          post.content
          (hash
            theme="high-contrast"
            enableComments=true
          )
          as |title content options|
      }}
        {{my-post title=title content=content options=options}}
      {{/let}}
    ```
  
    @method let
    @for Ember.Templates.helpers
    @public
  */


  function blockLetMacro(params, _hash, template, _inverse, builder) {
    if (template !== null) {
      if (params !== null) {
        builder.compileParams(params);
        builder.invokeStaticBlock(template, params.length);
      } else {
        builder.invokeStatic(template);
      }
    }

    return true;
  }

  var CAPABILITIES$4 = {
    dynamicLayout: true,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true
  }; // TODO
  // This "disables" the "@model" feature by making the arg untypable syntatically
  // Delete this when EMBER_ROUTING_MODEL_ARG has shipped

  var MODEL_ARG_NAME = 'model';

  class MountManager extends AbstractManager {
    getDynamicLayout(state, _) {
      var templateFactory$$1 = state.engine.lookup('template:application');
      var template = templateFactory$$1(state.engine);
      var layout = template.asLayout();
      return {
        handle: layout.compile(),
        symbolTable: layout.symbolTable
      };
    }

    getCapabilities() {
      return CAPABILITIES$4;
    }

    create(environment, {
      name
    }, args) {
      if (true
      /* DEBUG */
      ) {
        this._pushEngineToDebugStack("engine:" + name, environment);
      } // TODO
      // mount is a runtime helper, this shouldn't use dynamic layout
      // we should resolve the engine app template in the helper
      // it also should use the owner that looked up the mount helper.


      var engine = environment.owner.buildChildEngineInstance(name);
      engine.boot();
      var applicationFactory = engine.factoryFor("controller:application");
      var controllerFactory = applicationFactory || (0, _routing.generateControllerFactory)(engine, 'application');
      var controller;
      var self;
      var bucket;
      var modelRef;

      if (args.named.has(MODEL_ARG_NAME)) {
        modelRef = args.named.get(MODEL_ARG_NAME);
      }

      if (modelRef === undefined) {
        controller = controllerFactory.create();
        self = new RootReference(controller);
        bucket = {
          engine,
          controller,
          self
        };
      } else {
        var model = modelRef.value();
        controller = controllerFactory.create({
          model
        });
        self = new RootReference(controller);
        bucket = {
          engine,
          controller,
          self,
          modelRef
        };
      }

      return bucket;
    }

    getSelf({
      self
    }) {
      return self;
    }

    getTag(state) {
      if (state.modelRef) {
        return state.modelRef.tag;
      } else {
        return _reference.CONSTANT_TAG;
      }
    }

    getDestructor({
      engine
    }) {
      return engine;
    }

    didRenderLayout() {
      if (true
      /* DEBUG */
      ) {
        this.debugStack.pop();
      }
    }

    update({
      controller,
      modelRef
    }) {
      (true && !(modelRef !== undefined) && (0, _debug.assert)('[BUG] `update` should only be called when modelRef is present', modelRef !== undefined));
      controller.set('model', modelRef.value());
    }

  }

  var MOUNT_MANAGER = new MountManager();

  class MountDefinition {
    constructor(name) {
      this.manager = MOUNT_MANAGER;
      this.state = {
        name
      };
    }

  }

  function mountHelper(vm, args) {
    var env = vm.env;
    var nameRef = args.positional.at(0);
    var captured = null; // TODO: the functionailty to create a proper CapturedArgument should be
    // exported by glimmer, or that it should provide an overload for `curry`
    // that takes `PreparedArguments`

    if (args.named.has('model')) {
      (true && !(args.named.length === 1) && (0, _debug.assert)('[BUG] this should already be checked by the macro', args.named.length === 1));
      var named = args.named.capture();
      var {
        tag
      } = named; // TODO delete me after EMBER_ROUTING_MODEL_ARG has shipped

      if (true
      /* DEBUG */
      && MODEL_ARG_NAME !== 'model') {
        (true && !(named['_map'] === null) && (0, _debug.assert)('[BUG] named._map is not null', named['_map'] === null));
        named.names = [MODEL_ARG_NAME];
      }

      captured = {
        tag,
        positional: _runtime2.EMPTY_ARGS.positional,
        named,
        length: 1,

        value() {
          return {
            named: this.named.value(),
            positional: this.positional.value()
          };
        }

      };
    }

    return new DynamicEngineReference(nameRef, env, captured);
  }
  /**
    The `{{mount}}` helper lets you embed a routeless engine in a template.
    Mounting an engine will cause an instance to be booted and its `application`
    template to be rendered.
  
    For example, the following template mounts the `ember-chat` engine:
  
    ```handlebars
    {{! application.hbs }}
    {{mount "ember-chat"}}
    ```
  
    Additionally, you can also pass in a `model` argument that will be
    set as the engines model. This can be an existing object:
  
    ```
    <div>
      {{mount 'admin' model=userSettings}}
    </div>
    ```
  
    Or an inline `hash`, and you can even pass components:
  
    ```
    <div>
      <h1>Application template!</h1>
      {{mount 'admin' model=(hash
          title='Secret Admin'
          signInButton=(component 'sign-in-button')
      )}}
    </div>
    ```
  
    @method mount
    @param {String} name Name of the engine to mount.
    @param {Object} [model] Object that will be set as
                            the model of the engine.
    @for Ember.Templates.helpers
    @public
  */


  function mountMacro(_name, params, hash, builder) {
    (true && !(params.length === 1) && (0, _debug.assert)('You can only pass a single positional argument to the {{mount}} helper, e.g. {{mount "chat-engine"}}.', params.length === 1));

    if (true
    /* DEBUG */
    && hash) {
      var keys = hash[0];
      var extra = keys.filter(k => k !== 'model');
      (true && !(extra.length === 0) && (0, _debug.assert)('You can only pass a `model` argument to the {{mount}} helper, ' + 'e.g. {{mount "profile-engine" model=this.profile}}. ' + ("You passed " + extra.join(',') + "."), extra.length === 0));
    }

    var expr = [_wireFormat.Ops.Helper, '-mount', params || [], hash];
    builder.dynamicComponent(expr, null, [], null, false, null, null);
    return true;
  }

  class DynamicEngineReference {
    constructor(nameRef, env, args) {
      this.nameRef = nameRef;
      this.env = env;
      this.args = args;
      this._lastName = null;
      this._lastDef = null;
      this.tag = nameRef.tag;
    }

    value() {
      var {
        env,
        nameRef,
        args
      } = this;
      var name = nameRef.value();

      if (typeof name === 'string') {
        if (this._lastName === name) {
          return this._lastDef;
        }

        (true && !(env.owner.hasRegistration("engine:" + name)) && (0, _debug.assert)("You used `{{mount '" + name + "'}}`, but the engine '" + name + "' can not be found.", env.owner.hasRegistration("engine:" + name)));

        if (!env.owner.hasRegistration("engine:" + name)) {
          return null;
        }

        this._lastName = name;
        this._lastDef = (0, _runtime2.curry)(new MountDefinition(name), args);
        return this._lastDef;
      } else {
        (true && !(name === null || name === undefined) && (0, _debug.assert)("Invalid engine name '" + name + "' specified, engine name must be either a string, null or undefined.", name === null || name === undefined));
        this._lastDef = null;
        this._lastName = null;
        return null;
      }
    }

    get() {
      return _runtime2.UNDEFINED_REFERENCE;
    }

  }
  /**
   * Represents the root outlet.
   */


  class RootOutletReference {
    constructor(outletState) {
      this.outletState = outletState;
      this.tag = (0, _reference.createTag)();
    }

    get(key) {
      return new PathReference(this, key);
    }

    value() {
      return this.outletState;
    }

    update(state) {
      this.outletState.outlets.main = state;
      (0, _reference.dirty)(this.tag);
    }

  }
  /**
   * Represents the connected outlet.
   */


  class OutletReference {
    constructor(parentStateRef, outletNameRef) {
      this.parentStateRef = parentStateRef;
      this.outletNameRef = outletNameRef;
      this.tag = (0, _reference.combine)([parentStateRef.tag, outletNameRef.tag]);
    }

    value() {
      var outletState = this.parentStateRef.value();
      var outlets = outletState === undefined ? undefined : outletState.outlets;
      return outlets === undefined ? undefined : outlets[this.outletNameRef.value()];
    }

    get(key) {
      return new PathReference(this, key);
    }

  }
  /**
   * Outlet state is dirtied from root.
   * This just using the parent tag for dirtiness.
   */


  class PathReference {
    constructor(parent, key) {
      this.parent = parent;
      this.key = key;
      this.tag = parent.tag;
    }

    get(key) {
      return new PathReference(this, key);
    }

    value() {
      var parent = this.parent.value();
      return parent && parent[this.key];
    }

  }
  /**
    The `{{outlet}}` helper lets you specify where a child route will render in
    your template. An important use of the `{{outlet}}` helper is in your
    application's `application.hbs` file:
  
    ```handlebars
    {{! app/templates/application.hbs }}
    <!-- header content goes here, and will always display -->
    <MyHeader />
    <div class="my-dynamic-content">
      <!-- this content will change based on the current route, which depends on the current URL -->
      {{outlet}}
    </div>
    <!-- footer content goes here, and will always display -->
    <MyFooter />
    ```
  
    You may also specify a name for the `{{outlet}}`, which is useful when using more than one
    `{{outlet}}` in a template:
  
    ```handlebars
    {{outlet "menu"}}
    {{outlet "sidebar"}}
    {{outlet "main"}}
    ```
  
    Your routes can then render into a specific one of these `outlet`s by specifying the `outlet`
    attribute in your `renderTemplate` function:
  
    ```app/routes/menu.js
    import Route from '@ember/routing/route';
  
    export default Route.extend({
      renderTemplate() {
        this.render({ outlet: 'menu' });
      }
    });
    ```
  
    See the [routing guide](https://guides.emberjs.com/release/routing/rendering-a-template/) for more
    information on how your `route` interacts with the `{{outlet}}` helper.
    Note: Your content __will not render__ if there isn't an `{{outlet}}` for it.
  
    @method outlet
    @param {String} [name]
    @for Ember.Templates.helpers
    @public
  */


  function outletHelper(vm, args) {
    var scope = vm.dynamicScope();
    var nameRef;

    if (args.positional.length === 0) {
      nameRef = new _reference.ConstReference('main');
    } else {
      nameRef = args.positional.at(0);
    }

    return new OutletComponentReference(new OutletReference(scope.outletState, nameRef));
  }

  function outletMacro(_name, params, hash, builder) {
    var expr = [_wireFormat.Ops.Helper, '-outlet', params || [], hash];
    builder.dynamicComponent(expr, null, [], null, false, null, null);
    return true;
  }

  class OutletModelReference {
    constructor(parent) {
      this.parent = parent;
      this.tag = parent.tag;
    }

    value() {
      var state = this.parent.value();

      if (state === undefined) {
        return undefined;
      }

      var {
        render
      } = state;

      if (render === undefined) {
        return undefined;
      }

      return render.model;
    }

    get(property) {
      if (true
      /* DEBUG */
      ) {
        // This guarentees that we preserve the `debug()` output below
        return new NestedPropertyReference(this, property);
      } else {
        return PropertyReference.create(this, property);
      }
    }

  }

  if (true
  /* DEBUG */
  ) {
    OutletModelReference.prototype['debug'] = function debug() {
      return '@model';
    };
  }

  class OutletComponentReference {
    constructor(outletRef) {
      this.outletRef = outletRef;
      this.args = null;
      this.definition = null;
      this.lastState = null; // The router always dirties the root state.

      var tag = this.tag = outletRef.tag;
      {
        var modelRef = new OutletModelReference(outletRef);
        var map$$1 = (0, _util.dict)();
        map$$1.model = modelRef; // TODO: the functionailty to create a proper CapturedArgument should be
        // exported by glimmer, or that it should provide an overload for `curry`
        // that takes `PreparedArguments`

        this.args = {
          tag,
          positional: _runtime2.EMPTY_ARGS.positional,
          named: {
            tag,
            map: map$$1,
            names: ['model'],
            references: [modelRef],
            length: 1,

            has(key) {
              return key === 'model';
            },

            get(key) {
              return key === 'model' ? modelRef : _runtime2.UNDEFINED_REFERENCE;
            },

            value() {
              var model = modelRef.value();
              return {
                model
              };
            }

          },
          length: 1,

          value() {
            return {
              named: this.named.value(),
              positional: this.positional.value()
            };
          }

        };
      }
    }

    value() {
      var state = stateFor(this.outletRef);

      if (validate$1(state, this.lastState)) {
        return this.definition;
      }

      this.lastState = state;
      var definition = null;

      if (state !== null) {
        definition = (0, _runtime2.curry)(new OutletComponentDefinition(state), this.args);
      }

      return this.definition = definition;
    }

    get(_key) {
      return _runtime2.UNDEFINED_REFERENCE;
    }

  }

  function stateFor(ref) {
    var outlet = ref.value();
    if (outlet === undefined) return null;
    var render = outlet.render;
    if (render === undefined) return null;
    var template$$1 = render.template;
    if (template$$1 === undefined) return null; // this guard can be removed once @ember/test-helpers@1.6.0 has "aged out"
    // and is no longer considered supported

    if (isTemplateFactory(template$$1)) {
      template$$1 = template$$1(render.owner);
    }

    return {
      ref,
      name: render.name,
      outlet: render.outlet,
      template: template$$1,
      controller: render.controller,
      model: render.model
    };
  }

  function validate$1(state, lastState) {
    if (state === null) {
      return lastState === null;
    }

    if (lastState === null) {
      return false;
    }

    return state.template === lastState.template && state.controller === lastState.controller;
  }

  function hashToArgs(hash) {
    if (hash === null) return null;
    var names = hash[0].map(key => "@" + key);
    return [names, hash[1]];
  }

  function refineInlineSyntax(name, params, hash, builder) {
    (true && !(!(builder.compiler['resolver']['resolver']['builtInHelpers'][name] && builder.referrer.owner.hasRegistration("helper:" + name))) && (0, _debug.assert)("You attempted to overwrite the built-in helper \"" + name + "\" which is not allowed. Please rename the helper.", !(builder.compiler['resolver']['resolver']['builtInHelpers'][name] && builder.referrer.owner.hasRegistration("helper:" + name))));
    var handle = builder.compiler['resolver'].lookupComponentDefinition(name, builder.referrer);

    if (handle !== null) {
      builder.component.static(handle, [params === null ? [] : params, hashToArgs(hash), null, null]);
      return true;
    }

    return false;
  }

  function refineBlockSyntax(name, params, hash, template, inverse, builder) {
    var handle = builder.compiler['resolver'].lookupComponentDefinition(name, builder.referrer);

    if (handle !== null) {
      wrapComponentClassAttribute(hash);
      builder.component.static(handle, [params, hashToArgs(hash), template, inverse]);
      return true;
    }

    (true && !(builder.referrer.owner.hasRegistration("helper:" + name)) && (0, _debug.assert)("A component or helper named \"" + name + "\" could not be found", builder.referrer.owner.hasRegistration("helper:" + name)));
    (true && !(!(() => {
      var resolver = builder.compiler['resolver']['resolver'];
      var {
        owner,
        moduleName
      } = builder.referrer;

      if (name === 'component' || resolver['builtInHelpers'][name]) {
        return true;
      }

      var options = {
        source: "template:" + moduleName
      };
      return owner.hasRegistration("helper:" + name, options) || owner.hasRegistration("helper:" + name);
    })()) && (0, _debug.assert)("Helpers may not be used in the block form, for example {{#" + name + "}}{{/" + name + "}}. Please use a component, or alternatively use the helper in combination with a built-in Ember helper, for example {{#if (" + name + ")}}{{/if}}.", !(() => {
      var resolver = builder.compiler['resolver']['resolver'];
      var {
        owner,
        moduleName
      } = builder.referrer;

      if (name === 'component' || resolver['builtInHelpers'][name]) {
        return true;
      }

      var options = {
        source: "template:" + moduleName
      };
      return owner.hasRegistration("helper:" + name, options) || owner.hasRegistration("helper:" + name);
    })()));
    return false;
  }

  var experimentalMacros = []; // This is a private API to allow for experimental macros
  // to be created in user space. Registering a macro should
  // should be done in an initializer.

  _exports._experimentalMacros = experimentalMacros;

  function registerMacros(macro) {
    experimentalMacros.push(macro);
  }

  function populateMacros(macros) {
    var {
      inlines,
      blocks
    } = macros;
    inlines.add('outlet', outletMacro);
    inlines.add('mount', mountMacro);
    inlines.addMissing(refineInlineSyntax);
    blocks.add('let', blockLetMacro);
    blocks.addMissing(refineBlockSyntax);

    for (var i = 0; i < experimentalMacros.length; i++) {
      var macro = experimentalMacros[i];
      macro(blocks, inlines);
    }

    return {
      blocks,
      inlines
    };
  }

  var TEMPLATES$1 = new WeakMap();
  var getPrototypeOf$1 = Object.getPrototypeOf;

  function setComponentTemplate(factory, obj) {
    (true && !(obj !== null && (typeof obj === 'object' || typeof obj === 'function')) && (0, _debug.assert)("Cannot call `setComponentTemplate` on `" + (0, _utils.toString)(obj) + "`", obj !== null && (typeof obj === 'object' || typeof obj === 'function')));
    (true && !(!TEMPLATES$1.has(obj)) && (0, _debug.assert)("Cannot call `setComponentTemplate` multiple times on the same class (`" + obj + "`)", !TEMPLATES$1.has(obj)));
    TEMPLATES$1.set(obj, factory);
    return obj;
  }

  function getComponentTemplate(obj) {
    var pointer = obj;

    while (pointer !== undefined && pointer !== null) {
      var _template = TEMPLATES$1.get(pointer);

      if (_template !== undefined) {
        return _template;
      }

      pointer = getPrototypeOf$1(pointer);
    }

    return null;
  }

  function setModifierManager(factory, obj) {
    return setManager({
      factory,
      internal: false,
      type: 'modifier'
    }, obj);
  }

  function getModifierManager(obj) {
    var wrapper = getManager(obj);

    if (wrapper && !wrapper.internal && wrapper.type === 'modifier') {
      return wrapper.factory;
    } else {
      return undefined;
    }
  }

  function instrumentationPayload$1(name) {
    return {
      object: "component:" + name
    };
  }

  function makeOptions(moduleName, namespace) {
    return {
      source: moduleName !== undefined ? "template:" + moduleName : undefined,
      namespace
    };
  }

  function componentFor(name, owner, options) {
    var fullName = "component:" + name;
    return owner.factoryFor(fullName, options) || null;
  }

  function layoutFor(name, owner, options) {
    var templateFullName = "template:components/" + name;
    return owner.lookup(templateFullName, options) || null;
  }

  function lookupComponentPair(owner, name, options) {
    var component = componentFor(name, owner, options);
    {
      if (component !== null && component.class !== undefined) {
        var _layout2 = getComponentTemplate(component.class);

        if (_layout2 !== null) {
          return {
            component,
            layout: _layout2
          };
        }
      }
    }
    var layout = layoutFor(name, owner, options);

    if (component === null && layout === null) {
      return null;
    } else {
      return {
        component,
        layout
      };
    }
  }

  function lookupComponent(owner, name, options) {
    if (options.source || options.namespace) {
      var pair = lookupComponentPair(owner, name, options);

      if (pair !== null) {
        return pair;
      }
    }

    return lookupComponentPair(owner, name);
  }

  var BUILTINS_HELPERS = {
    if: inlineIf,
    action,
    array,
    concat: concat$1,
    fn,
    get: get$1,
    hash,
    log: log$1,
    mut,
    'query-params': queryParams$1,
    readonly,
    unbound,
    unless: inlineUnless,
    '-class': classHelper$1,
    '-each-in': eachIn,
    '-input-type': inputTypeHelper$1,
    '-normalize-class': normalizeClassHelper,
    '-get-dynamic-var': _runtime2.getDynamicVar,
    '-mount': mountHelper,
    '-outlet': outletHelper,
    '-assert-implicit-component-helper-argument': componentAssertionHelper
  };

  class RuntimeResolver {
    constructor(isInteractive) {
      this.handles = [undefined];
      this.objToHandle = new WeakMap();
      this.builtInHelpers = BUILTINS_HELPERS;
      this.componentDefinitionCache = new Map();
      this.componentDefinitionCount = 0;
      this.helperDefinitionCount = 0;
      var macros = new _opcodeCompiler.Macros();
      populateMacros(macros);
      this.compiler = new _opcodeCompiler.LazyCompiler(new CompileTimeLookup(this), this, macros);
      this.isInteractive = isInteractive;
      this.builtInModifiers = {
        action: {
          manager: new ActionModifierManager(),
          state: null
        },
        on: {
          manager: new OnModifierManager(isInteractive),
          state: null
        }
      };
    }
    /***  IRuntimeResolver ***/

    /**
     * public componentDefHandleCount = 0;
     * Called while executing Append Op.PushDynamicComponentManager if string
     */


    lookupComponentDefinition(name, meta) {
      var handle = this.lookupComponentHandle(name, meta);

      if (handle === null) {
        (true && !(false) && (0, _debug.assert)("Could not find component named \"" + name + "\" (no component or template with that name was found)"));
        return null;
      }

      return this.resolve(handle);
    }

    lookupComponentHandle(name, meta) {
      var nextHandle = this.handles.length;
      var handle = this.handle(this._lookupComponentDefinition(name, meta));
      (true && !(!(name === 'text-area' && handle === null)) && (0, _debug.assert)('Could not find component `<TextArea />` (did you mean `<Textarea />`?)', !(name === 'text-area' && handle === null)));

      if (nextHandle === handle) {
        this.componentDefinitionCount++;
      }

      return handle;
    }
    /**
     * Called by RuntimeConstants to lookup unresolved handles.
     */


    resolve(handle) {
      return this.handles[handle];
    } // End IRuntimeResolver

    /**
     * Called by CompileTimeLookup compiling Unknown or Helper OpCode
     */


    lookupHelper(name, meta) {
      var nextHandle = this.handles.length;

      var helper$$1 = this._lookupHelper(name, meta);

      if (helper$$1 !== null) {
        var handle = this.handle(helper$$1);

        if (nextHandle === handle) {
          this.helperDefinitionCount++;
        }

        return handle;
      }

      return null;
    }
    /**
     * Called by CompileTimeLookup compiling the
     */


    lookupModifier(name, meta) {
      return this.handle(this._lookupModifier(name, meta));
    }
    /**
     * Called by CompileTimeLookup to lookup partial
     */


    lookupPartial(name, meta) {
      var partial = this._lookupPartial(name, meta);

      return this.handle(partial);
    } // end CompileTimeLookup
    // needed for lazy compile time lookup


    handle(obj) {
      if (obj === undefined || obj === null) {
        return null;
      }

      var handle = this.objToHandle.get(obj);

      if (handle === undefined) {
        handle = this.handles.push(obj) - 1;
        this.objToHandle.set(obj, handle);
      }

      return handle;
    }

    _lookupHelper(_name, meta) {
      var helper$$1 = this.builtInHelpers[_name];

      if (helper$$1 !== undefined) {
        return helper$$1;
      }

      var {
        owner,
        moduleName
      } = meta;
      var name = _name;
      var namespace = undefined;
      var options = makeOptions(moduleName, namespace);
      var factory = owner.factoryFor("helper:" + name, options) || owner.factoryFor("helper:" + name);

      if (!isHelperFactory(factory)) {
        return null;
      }

      return (vm, args) => {
        var helper$$1 = factory.create();

        if (isSimpleHelper(helper$$1)) {
          return SimpleHelperReference.create(helper$$1.compute, args.capture());
        }

        vm.newDestroyable(helper$$1);
        return ClassBasedHelperReference.create(helper$$1, args.capture());
      };
    }

    _lookupPartial(name, meta) {
      var templateFactory$$1 = (0, _views.lookupPartial)(name, meta.owner);
      var template = templateFactory$$1(meta.owner);
      return new _opcodeCompiler.PartialDefinition(name, template);
    }

    _lookupModifier(name, meta) {
      var builtin = this.builtInModifiers[name];

      if (builtin === undefined) {
        var {
          owner
        } = meta;
        var modifier = owner.factoryFor("modifier:" + name);

        if (modifier !== undefined) {
          var managerFactory = getModifierManager(modifier.class);
          var manager = managerFactory(owner);
          return new CustomModifierDefinition(name, modifier, manager, this.isInteractive);
        }
      }

      return builtin;
    }

    _parseNameForNamespace(_name) {
      var name = _name;
      var namespace = undefined;

      var namespaceDelimiterOffset = _name.indexOf('::');

      if (namespaceDelimiterOffset !== -1) {
        name = _name.slice(namespaceDelimiterOffset + 2);
        namespace = _name.slice(0, namespaceDelimiterOffset);
      }

      return {
        name,
        namespace
      };
    }

    _lookupComponentDefinition(_name, {
      moduleName,
      owner
    }) {
      var name = _name;
      var namespace = undefined;
      var pair = lookupComponent(owner, name, makeOptions(moduleName, namespace));

      if (pair === null) {
        return null;
      }

      var layout = null;
      var key;

      if (pair.component === null) {
        key = layout = pair.layout(owner);
      } else {
        key = pair.component;
      }

      var cachedComponentDefinition = this.componentDefinitionCache.get(key);

      if (cachedComponentDefinition !== undefined) {
        return cachedComponentDefinition;
      }

      if (layout === null && pair.layout !== null) {
        layout = pair.layout(owner);
      }

      var finalizer = (0, _instrumentation._instrumentStart)('render.getComponentDefinition', instrumentationPayload$1, name);
      var definition = null;

      if (pair.component === null) {
        if (_environment2.ENV._TEMPLATE_ONLY_GLIMMER_COMPONENTS) {
          definition = new TemplateOnlyComponentDefinition(layout);
        }
      } else if (true
      /* EMBER_GLIMMER_SET_COMPONENT_TEMPLATE */
      && (0, _templateOnly.isTemplateOnlyComponent)(pair.component.class)) {
        definition = new TemplateOnlyComponentDefinition(layout);
      }

      if (pair.component !== null) {
        (true && !(pair.component.class !== undefined) && (0, _debug.assert)("missing component class " + name, pair.component.class !== undefined));
        var ComponentClass = pair.component.class;
        var wrapper = getManager(ComponentClass);

        if (wrapper !== null && wrapper.type === 'component') {
          var {
            factory
          } = wrapper;

          if (wrapper.internal) {
            (true && !(pair.layout !== null) && (0, _debug.assert)("missing layout for internal component " + name, pair.layout !== null));
            definition = new InternalComponentDefinition(factory(owner), ComponentClass, layout);
          } else {
            definition = new CustomManagerDefinition(name, pair.component, factory(owner), layout !== null ? layout : owner.lookup((0, _container.privatize)(_templateObject3()))(owner));
          }
        }
      }

      if (definition === null) {
        definition = new CurlyComponentDefinition(name, pair.component || owner.factoryFor((0, _container.privatize)(_templateObject4())), null, layout);
      }

      finalizer();
      this.componentDefinitionCache.set(key, definition);
      return definition;
    }

  }

  var TemplateCompiler = {
    create({
      environment
    }) {
      return new RuntimeResolver(environment.isInteractive).compiler;
    }

  };
  var ComponentTemplate = template({
    "id": "chfQcH83",
    "block": "{\"symbols\":[\"&default\"],\"statements\":[[14,1]],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/component.hbs"
    }
  });
  var InputTemplate = template({
    "id": "NWZzLSII",
    "block": "{\"symbols\":[\"Checkbox\",\"TextField\",\"@__ARGS__\",\"&attrs\"],\"statements\":[[4,\"let\",[[28,\"component\",[\"-checkbox\"],null],[28,\"component\",[\"-text-field\"],null]],null,{\"statements\":[[4,\"if\",[[23,0,[\"isCheckbox\"]]],null,{\"statements\":[[6,[23,1,[]],[[13,4]],[[\"@target\",\"@__ARGS__\"],[[23,0,[\"caller\"]],[23,3,[]]]]]],\"parameters\":[]},{\"statements\":[[6,[23,2,[]],[[13,4]],[[\"@target\",\"@__ARGS__\"],[[23,0,[\"caller\"]],[23,3,[]]]]]],\"parameters\":[]}]],\"parameters\":[1,2]},null]],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/input.hbs"
    }
  });
  var OutletTemplate = template({
    "id": "ffAL6HDl",
    "block": "{\"symbols\":[],\"statements\":[[1,[22,\"outlet\"],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "packages/@ember/-internals/glimmer/lib/templates/outlet.hbs"
    }
  });
  var TOP_LEVEL_NAME = '-top-level';
  var TOP_LEVEL_OUTLET = 'main';

  class OutletView {
    constructor(_environment, renderer, owner, template) {
      this._environment = _environment;
      this.renderer = renderer;
      this.owner = owner;
      this.template = template;
      var ref = this.ref = new RootOutletReference({
        outlets: {
          main: undefined
        },
        render: {
          owner: owner,
          into: undefined,
          outlet: TOP_LEVEL_OUTLET,
          name: TOP_LEVEL_NAME,
          controller: undefined,
          model: undefined,
          template
        }
      });
      this.state = {
        ref,
        name: TOP_LEVEL_NAME,
        outlet: TOP_LEVEL_OUTLET,
        template,
        controller: undefined,
        model: undefined
      };
    }

    static extend(injections) {
      return class extends OutletView {
        static create(options) {
          if (options) {
            return super.create((0, _polyfills.assign)({}, injections, options));
          } else {
            return super.create(injections);
          }
        }

      };
    }

    static reopenClass(injections) {
      (0, _polyfills.assign)(this, injections);
    }

    static create(options) {
      var {
        _environment,
        renderer,
        template: templateFactory$$1
      } = options;
      var owner = options[_owner.OWNER];
      var template = templateFactory$$1(owner);
      return new OutletView(_environment, renderer, owner, template);
    }

    appendTo(selector) {
      var target;

      if (this._environment.hasDOM) {
        target = typeof selector === 'string' ? document.querySelector(selector) : selector;
      } else {
        target = selector;
      }

      (0, _runloop.schedule)('render', this.renderer, 'appendOutletView', this, target);
    }

    rerender() {
      /**/
    }

    setOutletState(state) {
      this.ref.update(state);
    }

    destroy() {
      /**/
    }

  }

  _exports.OutletView = OutletView;

  function setupApplicationRegistry(registry) {
    registry.injection('service:-glimmer-environment', 'appendOperations', 'service:-dom-tree-construction');
    registry.injection('renderer', 'env', 'service:-glimmer-environment'); // because we are using injections we can't use instantiate false
    // we need to use bind() to copy the function so factory for
    // association won't leak

    registry.register('service:-dom-builder', {
      create({
        bootOptions
      }) {
        var {
          _renderMode
        } = bootOptions;

        switch (_renderMode) {
          case 'serialize':
            return _node.serializeBuilder.bind(null);

          case 'rehydrate':
            return _runtime2.rehydrationBuilder.bind(null);

          default:
            return _runtime2.clientBuilder.bind(null);
        }
      }

    });
    registry.injection('service:-dom-builder', 'bootOptions', '-environment:main');
    registry.injection('renderer', 'builder', 'service:-dom-builder');
    registry.register((0, _container.privatize)(_templateObject5()), RootTemplate);
    registry.injection('renderer', 'rootTemplate', (0, _container.privatize)(_templateObject6()));
    registry.register('renderer:-dom', InteractiveRenderer);
    registry.register('renderer:-inert', InertRenderer);

    if (_browserEnvironment.hasDOM) {
      registry.injection('service:-glimmer-environment', 'updateOperations', 'service:-dom-changes');
    }

    registry.register('service:-dom-changes', {
      create({
        document
      }) {
        return new _runtime2.DOMChanges(document);
      }

    });
    registry.register('service:-dom-tree-construction', {
      create({
        document
      }) {
        var Implementation = _browserEnvironment.hasDOM ? _runtime2.DOMTreeConstruction : _node.NodeDOMTreeConstruction;
        return new Implementation(document);
      }

    });
  }

  function setupEngineRegistry(registry) {
    registry.optionsForType('template', {
      instantiate: false
    });
    registry.register('view:-outlet', OutletView);
    registry.register('template:-outlet', OutletTemplate);
    registry.injection('view:-outlet', 'template', 'template:-outlet');
    registry.injection('service:-dom-changes', 'document', 'service:-document');
    registry.injection('service:-dom-tree-construction', 'document', 'service:-document');
    registry.register((0, _container.privatize)(_templateObject7()), ComponentTemplate);
    registry.register('service:-glimmer-environment', Environment$1);
    registry.register((0, _container.privatize)(_templateObject8()), TemplateCompiler);
    registry.injection((0, _container.privatize)(_templateObject9()), 'environment', '-environment:main');
    registry.optionsForType('helper', {
      instantiate: false
    });
    registry.register('helper:loc', loc$1);
    registry.register('component:-text-field', TextField);
    registry.register('component:-checkbox', Checkbox);
    registry.register('component:link-to', LinkComponent);
    registry.register('component:input', Input);
    registry.register('template:components/input', InputTemplate);
    registry.register('component:textarea', TextArea);

    if (!_environment2.ENV._TEMPLATE_ONLY_GLIMMER_COMPONENTS) {
      registry.register((0, _container.privatize)(_templateObject10()), Component);
    }
  }

  function setComponentManager(stringOrFunction, obj) {
    var factory;

    if (_deprecatedFeatures.COMPONENT_MANAGER_STRING_LOOKUP && typeof stringOrFunction === 'string') {
      (true && !(false) && (0, _debug.deprecate)('Passing the name of the component manager to "setupComponentManager" is deprecated. Please pass a function that produces an instance of the manager.', false, {
        id: 'deprecate-string-based-component-manager',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x/#toc_component-manager-string-lookup'
      }));

      factory = function (owner) {
        return owner.lookup("component-manager:" + stringOrFunction);
      };
    } else {
      factory = stringOrFunction;
    }

    return setManager({
      factory,
      internal: false,
      type: 'component'
    }, obj);
  }

  function getComponentManager(obj) {
    var wrapper = getManager(obj);

    if (wrapper && !wrapper.internal && wrapper.type === 'component') {
      return wrapper.factory;
    } else {
      return undefined;
    }
  }
  /**
    [Glimmer](https://github.com/tildeio/glimmer) is a templating engine used by Ember.js that is compatible with a subset of the [Handlebars](http://handlebarsjs.com/) syntax.
  
    ### Showing a property
  
    Templates manage the flow of an application's UI, and display state (through
    the DOM) to a user. For example, given a component with the property "name",
    that component's template can use the name in several ways:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      name: 'Jill'
    });
    ```
  
    ```app/templates/components/person-profile.hbs
    {{name}}
    <div>{{name}}</div>
    <span data-name={{name}}></span>
    ```
  
    Any time the "name" property on the component changes, the DOM will be
    updated.
  
    Properties can be chained as well:
  
    ```handlebars
    {{aUserModel.name}}
    <div>{{listOfUsers.firstObject.name}}</div>
    ```
  
    ### Using Ember helpers
  
    When content is passed in mustaches `{{}}`, Ember will first try to find a helper
    or component with that name. For example, the `if` helper:
  
    ```handlebars
    {{if name "I have a name" "I have no name"}}
    <span data-has-name={{if name true}}></span>
    ```
  
    The returned value is placed where the `{{}}` is called. The above style is
    called "inline". A second style of helper usage is called "block". For example:
  
    ```handlebars
    {{#if name}}
    I have a name
    {{else}}
    I have no name
    {{/if}}
    ```
  
    The block form of helpers allows you to control how the UI is created based
    on the values of properties.
    A third form of helper is called "nested". For example here the concat
    helper will add " Doe" to a displayed name if the person has no last name:
  
    ```handlebars
    <span data-name={{concat firstName (
    if lastName (concat " " lastName) "Doe"
    )}}></span>
    ```
  
    Ember's built-in helpers are described under the [Ember.Templates.helpers](/ember/release/classes/Ember.Templates.helpers)
    namespace. Documentation on creating custom helpers can be found under
    [helper](/ember/release/functions/@ember%2Fcomponent%2Fhelper/helper) (or
    under [Helper](/ember/release/classes/Helper) if a helper requires access to
    dependency injection).
  
    ### Invoking a Component
  
    Ember components represent state to the UI of an application. Further
    reading on components can be found under [Component](/ember/release/classes/Component).
  
    @module @ember/component
    @main @ember/component
    @public
   */

});
define("@ember/-internals/meta/index", ["exports", "@ember/-internals/meta/lib/meta"], function (_exports, _meta) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "counters", {
    enumerable: true,
    get: function () {
      return _meta.counters;
    }
  });
  Object.defineProperty(_exports, "deleteMeta", {
    enumerable: true,
    get: function () {
      return _meta.deleteMeta;
    }
  });
  Object.defineProperty(_exports, "Meta", {
    enumerable: true,
    get: function () {
      return _meta.Meta;
    }
  });
  Object.defineProperty(_exports, "meta", {
    enumerable: true,
    get: function () {
      return _meta.meta;
    }
  });
  Object.defineProperty(_exports, "peekMeta", {
    enumerable: true,
    get: function () {
      return _meta.peekMeta;
    }
  });
  Object.defineProperty(_exports, "setMeta", {
    enumerable: true,
    get: function () {
      return _meta.setMeta;
    }
  });
  Object.defineProperty(_exports, "UNDEFINED", {
    enumerable: true,
    get: function () {
      return _meta.UNDEFINED;
    }
  });
});
define("@ember/-internals/meta/lib/meta", ["exports", "@ember/-internals/utils", "@ember/debug", "@glimmer/reference"], function (_exports, _utils, _debug, _reference) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.setMeta = setMeta;
  _exports.peekMeta = peekMeta;
  _exports.deleteMeta = deleteMeta;
  _exports.counters = _exports.meta = _exports.Meta = _exports.UNDEFINED = void 0;
  var objectPrototype = Object.prototype;
  var counters;
  _exports.counters = counters;

  if (true
  /* DEBUG */
  ) {
    _exports.counters = counters = {
      peekCalls: 0,
      peekPrototypeWalks: 0,
      setCalls: 0,
      deleteCalls: 0,
      metaCalls: 0,
      metaInstantiated: 0,
      matchingListenersCalls: 0,
      observerEventsCalls: 0,
      addToListenersCalls: 0,
      removeFromListenersCalls: 0,
      removeAllListenersCalls: 0,
      listenersInherited: 0,
      listenersFlattened: 0,
      parentListenersUsed: 0,
      flattenedListenersCalls: 0,
      reopensAfterFlatten: 0,
      readableLazyChainsCalls: 0,
      writableLazyChainsCalls: 0
    };
  }
  /**
  @module ember
  */


  var UNDEFINED = (0, _utils.symbol)('undefined');
  _exports.UNDEFINED = UNDEFINED;
  var currentListenerVersion = 1;

  class Meta {
    constructor(obj) {
      this._listenersVersion = 1;
      this._inheritedEnd = -1;
      this._flattenedVersion = 0;

      if (true
      /* DEBUG */
      ) {
        counters.metaInstantiated++;
        this._values = undefined;
      }

      this._parent = undefined;
      this._descriptors = undefined;
      this._watching = undefined;
      this._mixins = undefined;
      this._deps = undefined;
      this._chainWatchers = undefined;
      this._chains = undefined;
      this._tag = undefined;
      this._tags = undefined; // initial value for all flags right now is false
      // see FLAGS const for detailed list of flags used

      this._flags = 0
      /* NONE */
      ; // used only internally

      this.source = obj;
      this.proto = obj.constructor === undefined ? undefined : obj.constructor.prototype;
      this._listeners = undefined;
    }

    get parent() {
      var parent = this._parent;

      if (parent === undefined) {
        var proto = getPrototypeOf(this.source);
        this._parent = parent = proto === null || proto === objectPrototype ? null : meta(proto);
      }

      return parent;
    }

    setInitializing() {
      this._flags |= 8
      /* INITIALIZING */
      ;
    }

    unsetInitializing() {
      this._flags ^= 8
      /* INITIALIZING */
      ;
    }

    isInitializing() {
      return this._hasFlag(8
      /* INITIALIZING */
      );
    }

    isPrototypeMeta(obj) {
      return this.proto === this.source && this.source === obj;
    }

    destroy() {
      if (this.isMetaDestroyed()) {
        return;
      }

      this.setMetaDestroyed(); // remove chainWatchers to remove circular references that would prevent GC

      var chains = this.readableChains();

      if (chains !== undefined) {
        chains.destroy();
      }
    }

    isSourceDestroying() {
      return this._hasFlag(1
      /* SOURCE_DESTROYING */
      );
    }

    setSourceDestroying() {
      this._flags |= 1
      /* SOURCE_DESTROYING */
      ;
    }

    isSourceDestroyed() {
      return this._hasFlag(2
      /* SOURCE_DESTROYED */
      );
    }

    setSourceDestroyed() {
      this._flags |= 2
      /* SOURCE_DESTROYED */
      ;
    }

    isMetaDestroyed() {
      return this._hasFlag(4
      /* META_DESTROYED */
      );
    }

    setMetaDestroyed() {
      this._flags |= 4
      /* META_DESTROYED */
      ;
    }

    _hasFlag(flag) {
      return (this._flags & flag) === flag;
    }

    _getOrCreateOwnMap(key) {
      return this[key] || (this[key] = Object.create(null));
    }

    _getOrCreateOwnSet(key) {
      return this[key] || (this[key] = new Set());
    }

    _findInherited1(key) {
      var pointer = this;

      while (pointer !== null) {
        var map = pointer[key];

        if (map !== undefined) {
          return map;
        }

        pointer = pointer.parent;
      }
    }

    _findInherited2(key, subkey) {
      var pointer = this;

      while (pointer !== null) {
        var map = pointer[key];

        if (map !== undefined) {
          var value = map[subkey];

          if (value !== undefined) {
            return value;
          }
        }

        pointer = pointer.parent;
      }
    }

    _findInherited3(key, subkey, subsubkey) {
      var pointer = this;

      while (pointer !== null) {
        var map = pointer[key];

        if (map !== undefined) {
          var submap = map[subkey];

          if (submap !== undefined) {
            var value = submap[subsubkey];

            if (value !== undefined) {
              return value;
            }
          }
        }

        pointer = pointer.parent;
      }
    }

    _findInheritedMap(key, subkey) {
      var pointer = this;

      while (pointer !== null) {
        var map = pointer[key];

        if (map !== undefined) {
          var value = map.get(subkey);

          if (value !== undefined) {
            return value;
          }
        }

        pointer = pointer.parent;
      }
    }

    _hasInInheritedSet(key, value) {
      var pointer = this;

      while (pointer !== null) {
        var set = pointer[key];

        if (set !== undefined && set.has(value)) {
          return true;
        }

        pointer = pointer.parent;
      }

      return false;
    } // Implements a member that provides a lazily created map of maps,
    // with inheritance at both levels.


    writeDeps(subkey, itemkey, count) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot modify dependent keys for `" + itemkey + "` on `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));

      var outerMap = this._getOrCreateOwnMap('_deps');

      var innerMap = outerMap[subkey];

      if (innerMap === undefined) {
        innerMap = outerMap[subkey] = Object.create(null);
      }

      innerMap[itemkey] = count;
    }

    peekDeps(subkey, itemkey) {
      var val = this._findInherited3('_deps', subkey, itemkey);

      return val === undefined ? 0 : val;
    }

    hasDeps(subkey) {
      var val = this._findInherited2('_deps', subkey);

      return val !== undefined;
    }

    forEachInDeps(subkey, fn) {
      var pointer = this;
      var seen;

      while (pointer !== null) {
        var map = pointer._deps;

        if (map !== undefined) {
          var innerMap = map[subkey];

          if (innerMap !== undefined) {
            seen = seen === undefined ? new Set() : seen;

            for (var innerKey in innerMap) {
              if (!seen.has(innerKey)) {
                seen.add(innerKey);

                if (innerMap[innerKey] > 0) {
                  fn(innerKey);
                }
              }
            }
          }
        }

        pointer = pointer.parent;
      }
    }

    writableTags() {
      return this._getOrCreateOwnMap('_tags');
    }

    readableTags() {
      return this._tags;
    }

    writableTag() {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot create a new tag for `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));
      var ret = this._tag;

      if (ret === undefined) {
        ret = this._tag = (0, _reference.createUpdatableTag)();
      }

      return ret;
    }

    readableTag() {
      return this._tag;
    }

    writableLazyChainsFor(key) {
      if (true
      /* DEBUG */
      ) {
        counters.writableLazyChainsCalls++;
      }

      var lazyChains = this._getOrCreateOwnMap('_lazyChains');

      if (!(key in lazyChains)) {
        lazyChains[key] = Object.create(null);
      }

      return lazyChains[key];
    }

    readableLazyChainsFor(key) {
      if (true
      /* DEBUG */
      ) {
        counters.readableLazyChainsCalls++;
      }

      var lazyChains = this._lazyChains;

      if (lazyChains !== undefined) {
        return lazyChains[key];
      }

      return undefined;
    }

    writableChainWatchers(create) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot create a new chain watcher for `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));
      var ret = this._chainWatchers;

      if (ret === undefined) {
        ret = this._chainWatchers = create(this.source);
      }

      return ret;
    }

    readableChainWatchers() {
      return this._chainWatchers;
    }

    writableChains(create) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot create a new chains for `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));
      var {
        _chains: ret
      } = this;

      if (ret === undefined) {
        this._chains = ret = create(this.source);
        var {
          parent
        } = this;

        if (parent !== null) {
          var parentChains = parent.writableChains(create);
          parentChains.copyTo(ret);
        }
      }

      return ret;
    }

    readableChains() {
      return this._findInherited1('_chains');
    }

    writeWatching(subkey, value) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot update watchers for `" + subkey + "` on `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));

      var map = this._getOrCreateOwnMap('_watching');

      map[subkey] = value;
    }

    peekWatching(subkey) {
      var count = this._findInherited2('_watching', subkey);

      return count === undefined ? 0 : count;
    }

    addMixin(mixin) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot add mixins of `" + (0, _utils.toString)(mixin) + "` on `" + (0, _utils.toString)(this.source) + "` call addMixin after it has been destroyed." : '', !this.isMetaDestroyed()));

      var set = this._getOrCreateOwnSet('_mixins');

      set.add(mixin);
    }

    hasMixin(mixin) {
      return this._hasInInheritedSet('_mixins', mixin);
    }

    forEachMixins(fn) {
      var pointer = this;
      var seen;

      while (pointer !== null) {
        var set = pointer._mixins;

        if (set !== undefined) {
          seen = seen === undefined ? new Set() : seen; // TODO cleanup typing here

          set.forEach(mixin => {
            if (!seen.has(mixin)) {
              seen.add(mixin);
              fn(mixin);
            }
          });
        }

        pointer = pointer.parent;
      }
    }

    writeDescriptors(subkey, value) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot update descriptors for `" + subkey + "` on `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));
      var map = this._descriptors || (this._descriptors = new Map());
      map.set(subkey, value);
    }

    peekDescriptors(subkey) {
      var possibleDesc = this._findInheritedMap('_descriptors', subkey);

      return possibleDesc === UNDEFINED ? undefined : possibleDesc;
    }

    removeDescriptors(subkey) {
      this.writeDescriptors(subkey, UNDEFINED);
    }

    forEachDescriptors(fn) {
      var pointer = this;
      var seen;

      while (pointer !== null) {
        var map = pointer._descriptors;

        if (map !== undefined) {
          seen = seen === undefined ? new Set() : seen;
          map.forEach((value, key) => {
            if (!seen.has(key)) {
              seen.add(key);

              if (value !== UNDEFINED) {
                fn(key, value);
              }
            }
          });
        }

        pointer = pointer.parent;
      }
    }

    addToListeners(eventName, target, method, once, sync) {
      if (true
      /* DEBUG */
      ) {
        counters.addToListenersCalls++;
      }

      this.pushListener(eventName, target, method, once ? 1
      /* ONCE */
      : 0
      /* ADD */
      , sync);
    }

    removeFromListeners(eventName, target, method) {
      if (true
      /* DEBUG */
      ) {
        counters.removeFromListenersCalls++;
      }

      this.pushListener(eventName, target, method, 2
      /* REMOVE */
      );
    }

    pushListener(event, target, method, kind, sync = false) {
      var listeners = this.writableListeners();
      var i = indexOfListener(listeners, event, target, method); // remove if found listener was inherited

      if (i !== -1 && i < this._inheritedEnd) {
        listeners.splice(i, 1);
        this._inheritedEnd--;
        i = -1;
      } // if not found, push. Note that we must always push if a listener is not
      // found, even in the case of a function listener remove, because we may be
      // attempting to add or remove listeners _before_ flattening has occured.


      if (i === -1) {
        (true && !(!(this.isPrototypeMeta(this.source) && typeof method === 'function')) && (0, _debug.assert)('You cannot add function listeners to prototypes. Convert the listener to a string listener, or add it to the instance instead.', !(this.isPrototypeMeta(this.source) && typeof method === 'function')));
        (true && !(!(!this.isPrototypeMeta(this.source) && typeof method === 'function' && kind === 2
        /* REMOVE */
        )) && (0, _debug.assert)('You attempted to remove a function listener which did not exist on the instance, which means you may have attempted to remove it before it was added.', !(!this.isPrototypeMeta(this.source) && typeof method === 'function' && kind === 2)));
        listeners.push({
          event,
          target,
          method,
          kind,
          sync
        });
      } else {
        var listener = listeners[i]; // If the listener is our own listener and we are trying to remove it, we
        // want to splice it out entirely so we don't hold onto a reference.

        if (kind === 2
        /* REMOVE */
        && listener.kind !== 2
        /* REMOVE */
        ) {
            listeners.splice(i, 1);
          } else {
          (true && !(!(listener.kind === 0
          /* ADD */
          && kind === 0
          /* ADD */
          && listener.sync !== sync)) && (0, _debug.assert)("You attempted to add an observer for the same method on '" + event.split(':')[0] + "' twice to " + target + " as both sync and async. Observers must be either sync or async, they cannot be both. This is likely a mistake, you should either remove the code that added the observer a second time, or update it to always be sync or async. The method was " + method + ".", !(listener.kind === 0 && kind === 0 && listener.sync !== sync))); // update own listener

          listener.kind = kind;
          listener.sync = sync;
        }
      }
    }

    writableListeners() {
      // Check if we need to invalidate and reflatten. We need to do this if we
      // have already flattened (flattened version is the current version) and
      // we are either writing to a prototype meta OR we have never inherited, and
      // may have cached the parent's listeners.
      if (this._flattenedVersion === currentListenerVersion && (this.source === this.proto || this._inheritedEnd === -1)) {
        if (true
        /* DEBUG */
        ) {
          counters.reopensAfterFlatten++;
        }

        currentListenerVersion++;
      } // Inherited end has not been set, then we have never created our own
      // listeners, but may have cached the parent's


      if (this._inheritedEnd === -1) {
        this._inheritedEnd = 0;
        this._listeners = [];
      }

      return this._listeners;
    }
    /**
      Flattening is based on a global revision counter. If the revision has
      bumped it means that somewhere in a class inheritance chain something has
      changed, so we need to reflatten everything. This can only happen if:
         1. A meta has been flattened (listener has been called)
      2. The meta is a prototype meta with children who have inherited its
         listeners
      3. A new listener is subsequently added to the meta (e.g. via `.reopen()`)
         This is a very rare occurence, so while the counter is global it shouldn't
      be updated very often in practice.
    */


    flattenedListeners() {
      if (true
      /* DEBUG */
      ) {
        counters.flattenedListenersCalls++;
      }

      if (this._flattenedVersion < currentListenerVersion) {
        if (true
        /* DEBUG */
        ) {
          counters.listenersFlattened++;
        }

        var parent = this.parent;

        if (parent !== null) {
          // compute
          var parentListeners = parent.flattenedListeners();

          if (parentListeners !== undefined) {
            if (this._listeners === undefined) {
              // If this instance doesn't have any of its own listeners (writableListeners
              // has never been called) then we don't need to do any flattening, return
              // the parent's listeners instead.
              if (true
              /* DEBUG */
              ) {
                counters.parentListenersUsed++;
              }

              this._listeners = parentListeners;
            } else {
              var listeners = this._listeners;

              if (this._inheritedEnd > 0) {
                listeners.splice(0, this._inheritedEnd);
                this._inheritedEnd = 0;
              }

              for (var i = 0; i < parentListeners.length; i++) {
                var listener = parentListeners[i];
                var index = indexOfListener(listeners, listener.event, listener.target, listener.method);

                if (index === -1) {
                  if (true
                  /* DEBUG */
                  ) {
                    counters.listenersInherited++;
                  }

                  listeners.unshift(listener);
                  this._inheritedEnd++;
                }
              }
            }
          }
        }

        this._flattenedVersion = currentListenerVersion;
      }

      return this._listeners;
    }

    matchingListeners(eventName) {
      var listeners = this.flattenedListeners();
      var result;

      if (true
      /* DEBUG */
      ) {
        counters.matchingListenersCalls++;
      }

      if (listeners !== undefined) {
        for (var index = 0; index < listeners.length; index++) {
          var listener = listeners[index]; // REMOVE listeners are placeholders that tell us not to
          // inherit, so they never match. Only ADD and ONCE can match.

          if (listener.event === eventName && (listener.kind === 0
          /* ADD */
          || listener.kind === 1
          /* ONCE */
          )) {
            if (result === undefined) {
              // we create this array only after we've found a listener that
              // matches to avoid allocations when no matches are found.
              result = [];
            }

            result.push(listener.target, listener.method, listener.kind === 1
            /* ONCE */
            );
          }
        }
      }

      return result;
    }

    observerEvents() {
      var listeners = this.flattenedListeners();
      var result;

      if (true
      /* DEBUG */
      ) {
        counters.observerEventsCalls++;
      }

      if (listeners !== undefined) {
        for (var index = 0; index < listeners.length; index++) {
          var listener = listeners[index]; // REMOVE listeners are placeholders that tell us not to
          // inherit, so they never match. Only ADD and ONCE can match.

          if ((listener.kind === 0
          /* ADD */
          || listener.kind === 1
          /* ONCE */
          ) && listener.event.indexOf(':change') !== -1) {
            if (result === undefined) {
              // we create this array only after we've found a listener that
              // matches to avoid allocations when no matches are found.
              result = [];
            }

            result.push(listener);
          }
        }
      }

      return result;
    }

  }

  _exports.Meta = Meta;

  if (true
  /* DEBUG */
  ) {
    Meta.prototype.writeValues = function (subkey, value) {
      (true && !(!this.isMetaDestroyed()) && (0, _debug.assert)(this.isMetaDestroyed() ? "Cannot set the value of `" + subkey + "` on `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !this.isMetaDestroyed()));

      var map = this._getOrCreateOwnMap('_values');

      map[subkey] = value === undefined ? UNDEFINED : value;
    };

    Meta.prototype.peekValues = function (key) {
      var val = this._findInherited2('_values', key);

      return val === UNDEFINED ? undefined : val;
    };

    Meta.prototype.deleteFromValues = function (key) {
      delete this._getOrCreateOwnMap('_values')[key];
    };

    Meta.prototype.readInheritedValue = function (key) {
      return this._findInherited2('_values', key);
    };

    Meta.prototype.writeValue = function (obj, key, value) {
      var descriptor = (0, _utils.lookupDescriptor)(obj, key);
      var isMandatorySetter = descriptor !== null && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };
  }

  var getPrototypeOf = Object.getPrototypeOf;
  var metaStore = new WeakMap();

  function setMeta(obj, meta) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `setMeta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `setMeta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `setMeta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));

    if (true
    /* DEBUG */
    ) {
      counters.setCalls++;
    }

    metaStore.set(obj, meta);
  }

  function peekMeta(obj) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `peekMeta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `peekMeta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `peekMeta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));

    if (true
    /* DEBUG */
    ) {
      counters.peekCalls++;
    }

    var meta = metaStore.get(obj);

    if (meta !== undefined) {
      return meta;
    }

    var pointer = getPrototypeOf(obj);

    while (pointer !== null) {
      if (true
      /* DEBUG */
      ) {
        counters.peekPrototypeWalks++;
      }

      meta = metaStore.get(pointer);

      if (meta !== undefined) {
        if (meta.proto !== pointer) {
          // The meta was a prototype meta which was not marked as initializing.
          // This can happen when a prototype chain was created manually via
          // Object.create() and the source object does not have a constructor.
          meta.proto = pointer;
        }

        return meta;
      }

      pointer = getPrototypeOf(pointer);
    }

    return null;
  }
  /**
    Tears down the meta on an object so that it can be garbage collected.
    Multiple calls will have no effect.
  
    @method deleteMeta
    @for Ember
    @param {Object} obj  the object to destroy
    @return {void}
    @private
  */


  function deleteMeta(obj) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `deleteMeta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `deleteMeta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `deleteMeta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));

    if (true
    /* DEBUG */
    ) {
      counters.deleteCalls++;
    }

    var meta = peekMeta(obj);

    if (meta !== null) {
      meta.destroy();
    }
  }
  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */


  var meta = function meta(obj) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `meta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `meta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `meta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));

    if (true
    /* DEBUG */
    ) {
      counters.metaCalls++;
    }

    var maybeMeta = peekMeta(obj); // remove this code, in-favor of explicit parent

    if (maybeMeta !== null && maybeMeta.source === obj) {
      return maybeMeta;
    }

    var newMeta = new Meta(obj);
    setMeta(obj, newMeta);
    return newMeta;
  };

  _exports.meta = meta;

  if (true
  /* DEBUG */
  ) {
    meta._counters = counters;
  }

  function indexOfListener(listeners, event, target, method) {
    for (var i = listeners.length - 1; i >= 0; i--) {
      var listener = listeners[i];

      if (listener.event === event && listener.target === target && listener.method === method) {
        return i;
      }
    }

    return -1;
  }
});
define("@ember/-internals/metal/index", ["exports", "@ember/polyfills", "@ember/-internals/meta", "@ember/debug", "@ember/-internals/utils", "@ember/runloop", "@glimmer/reference", "@ember/-internals/environment", "@ember/error", "@ember/canary-features", "ember/version", "@ember/deprecated-features", "@ember/-internals/owner"], function (_exports, _polyfills, _meta2, _debug, _utils, _runloop, _reference, _environment, _error, _canaryFeatures, _version, _deprecatedFeatures, _owner) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.computed = computed;
  _exports.isComputed = isComputed;
  _exports.getCacheFor = getCacheFor;
  _exports.getCachedValueFor = getCachedValueFor;
  _exports.peekCacheFor = peekCacheFor;
  _exports.alias = alias;
  _exports.deprecateProperty = deprecateProperty;
  _exports._getPath = _getPath;
  _exports.get = get;
  _exports.getWithDefault = getWithDefault;
  _exports.set = set;
  _exports.trySet = trySet;
  _exports.objectAt = objectAt;
  _exports.replace = replace;
  _exports.replaceInNativeArray = replaceInNativeArray;
  _exports.addArrayObserver = addArrayObserver;
  _exports.removeArrayObserver = removeArrayObserver;
  _exports.arrayContentWillChange = arrayContentWillChange;
  _exports.arrayContentDidChange = arrayContentDidChange;
  _exports.eachProxyFor = eachProxyFor;
  _exports.eachProxyArrayWillChange = eachProxyArrayWillChange;
  _exports.eachProxyArrayDidChange = eachProxyArrayDidChange;
  _exports.addListener = addListener;
  _exports.hasListeners = hasListeners;
  _exports.on = on;
  _exports.removeListener = removeListener;
  _exports.sendEvent = sendEvent;
  _exports.isNone = isNone;
  _exports.isEmpty = isEmpty;
  _exports.isBlank = isBlank;
  _exports.isPresent = isPresent;
  _exports.beginPropertyChanges = beginPropertyChanges;
  _exports.changeProperties = changeProperties;
  _exports.endPropertyChanges = endPropertyChanges;
  _exports.notifyPropertyChange = notifyPropertyChange;
  _exports.overrideChains = overrideChains;
  _exports.defineProperty = defineProperty;
  _exports.isElementDescriptor = isElementDescriptor;
  _exports.nativeDescDecorator = nativeDescDecorator;
  _exports.descriptorForDecorator = descriptorForDecorator;
  _exports.descriptorForProperty = descriptorForProperty;
  _exports.isClassicDecorator = isClassicDecorator;
  _exports.setClassicDecorator = setClassicDecorator;
  _exports.watchKey = watchKey;
  _exports.unwatchKey = unwatchKey;
  _exports.finishChains = finishChains;
  _exports.removeChainWatcher = removeChainWatcher;
  _exports.getChainTagsForKey = getChainTagsForKey;
  _exports.watchPath = watchPath;
  _exports.unwatchPath = unwatchPath;
  _exports.isWatching = isWatching;
  _exports.unwatch = unwatch;
  _exports.watch = watch;
  _exports.watcherCount = watcherCount;
  _exports.getProperties = getProperties;
  _exports.setProperties = setProperties;
  _exports.expandProperties = expandProperties;
  _exports.addObserver = addObserver;
  _exports.activateObserver = activateObserver;
  _exports.removeObserver = removeObserver;
  _exports.flushAsyncObservers = flushAsyncObservers;
  _exports.mixin = mixin;
  _exports.observer = observer;
  _exports.applyMixin = applyMixin;
  _exports.inject = inject;
  _exports.tagForProperty = tagForProperty;
  _exports.tagFor = tagFor;
  _exports.markObjectAsDirty = markObjectAsDirty;
  _exports.consume = consume;
  _exports.tracked = tracked;
  _exports.track = track;
  _exports.untrack = untrack;
  _exports.isTracking = isTracking;
  _exports.addNamespace = addNamespace;
  _exports.classToString = classToString;
  _exports.findNamespace = findNamespace;
  _exports.findNamespaces = findNamespaces;
  _exports.processNamespace = processNamespace;
  _exports.processAllNamespaces = processAllNamespaces;
  _exports.removeNamespace = removeNamespace;
  _exports.isNamespaceSearchDisabled = isSearchDisabled;
  _exports.setNamespaceSearchDisabled = setSearchDisabled;
  _exports.NAMESPACES_BY_ID = _exports.NAMESPACES = _exports.Tracker = _exports.assertNotRendered = _exports.didRender = _exports.runInTransaction = _exports.UNKNOWN_PROPERTY_TAG = _exports.DEBUG_INJECTION_FUNCTIONS = _exports.aliasMethod = _exports.Mixin = _exports.Libraries = _exports.libraries = _exports.ARGS_PROXY_TAGS = _exports.ChainNode = _exports.PROPERTY_DID_CHANGE = _exports.PROXY_CONTENT = _exports.ComputedProperty = _exports._globalsComputed = void 0;
  var COMPUTED_PROPERTY_CACHED_VALUES = new WeakMap();
  var COMPUTED_PROPERTY_LAST_REVISION = new WeakMap();

  function getCacheFor(obj) {
    var cache = COMPUTED_PROPERTY_CACHED_VALUES.get(obj);

    if (cache === undefined) {
      cache = new Map();
      COMPUTED_PROPERTY_CACHED_VALUES.set(obj, cache);
    }

    return cache;
  }
  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.
  
    @method cacheFor
    @static
    @for @ember/object/internals
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
    @public
  */


  function getCachedValueFor(obj, key) {
    var cache = COMPUTED_PROPERTY_CACHED_VALUES.get(obj);

    if (cache !== undefined) {
      return cache.get(key);
    }
  }

  var setLastRevisionFor;
  var getLastRevisionFor;
  {
    setLastRevisionFor = (obj, key, revision) => {
      var cache = COMPUTED_PROPERTY_LAST_REVISION.get(obj);

      if (cache === undefined) {
        cache = new Map();
        COMPUTED_PROPERTY_LAST_REVISION.set(obj, cache);
      }

      cache.set(key, revision);
    };

    getLastRevisionFor = (obj, key) => {
      var cache = COMPUTED_PROPERTY_LAST_REVISION.get(obj);

      if (cache === undefined) {
        return 0;
      } else {
        var revision = cache.get(key);
        return revision === undefined ? 0 : revision;
      }
    };
  }

  function peekCacheFor(obj) {
    return COMPUTED_PROPERTY_CACHED_VALUES.get(obj);
  }

  var DECORATOR_DESCRIPTOR_MAP = new WeakMap();
  /**
    Returns the CP descriptor assocaited with `obj` and `keyName`, if any.
  
    @method descriptorForProperty
    @param {Object} obj the object to check
    @param {String} keyName the key to check
    @return {Descriptor}
    @private
  */

  function descriptorForProperty(obj, keyName, _meta) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `descriptorForProperty` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `descriptorForProperty` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `descriptorForProperty` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));
    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;

    if (meta$$1 !== null) {
      return meta$$1.peekDescriptors(keyName);
    }
  }

  function descriptorForDecorator(dec) {
    return DECORATOR_DESCRIPTOR_MAP.get(dec);
  }
  /**
    Check whether a value is a decorator
  
    @method isClassicDecorator
    @param {any} possibleDesc the value to check
    @return {boolean}
    @private
  */


  function isClassicDecorator(dec) {
    return dec !== null && dec !== undefined && DECORATOR_DESCRIPTOR_MAP.has(dec);
  }
  /**
    Set a value as a decorator
  
    @method setClassicDecorator
    @param {function} decorator the value to mark as a decorator
    @private
  */


  function setClassicDecorator(dec, value$$1 = true) {
    DECORATOR_DESCRIPTOR_MAP.set(dec, value$$1);
  }

  var UNKNOWN_PROPERTY_TAG = (0, _utils.symbol)('UNKNOWN_PROPERTY_TAG');
  _exports.UNKNOWN_PROPERTY_TAG = UNKNOWN_PROPERTY_TAG;

  function tagForProperty(object, propertyKey, _meta) {
    var objectType = typeof object;

    if (objectType !== 'function' && (objectType !== 'object' || object === null)) {
      return _reference.CONSTANT_TAG;
    }

    var meta$$1 = _meta === undefined ? (0, _meta2.meta)(object) : _meta;
    {
      if (!(propertyKey in object) && typeof object[UNKNOWN_PROPERTY_TAG] === 'function') {
        return object[UNKNOWN_PROPERTY_TAG](propertyKey);
      }
    }
    var tags = meta$$1.writableTags();
    var tag = tags[propertyKey];

    if (tag) {
      return tag;
    }

    {
      var newTag = (0, _reference.createUpdatableTag)();

      if (true
      /* DEBUG */
      ) {
        {
          (0, _utils.setupMandatorySetter)(object, propertyKey);
        }
        newTag._propertyKey = propertyKey;
      }

      return tags[propertyKey] = newTag;
    }
  }

  function tagFor(object, _meta) {
    if (typeof object === 'object' && object !== null) {
      var meta$$1 = _meta === undefined ? (0, _meta2.meta)(object) : _meta;

      if (!meta$$1.isMetaDestroyed()) {
        return meta$$1.writableTag();
      }
    }

    return _reference.CONSTANT_TAG;
  }

  function markObjectAsDirty(obj, propertyKey, _meta) {
    var meta$$1 = _meta === undefined ? (0, _meta2.meta)(obj) : _meta;
    var objectTag = meta$$1.readableTag();

    if (objectTag !== undefined) {
      (0, _reference.dirty)(objectTag);
    }

    var tags = meta$$1.readableTags();
    var propertyTag = tags !== undefined ? tags[propertyKey] : undefined;

    if (propertyTag !== undefined) {
      (0, _reference.dirty)(propertyTag);
    }

    if (objectTag !== undefined || propertyTag !== undefined) {
      ensureRunloop();
    }
  }

  function ensureRunloop() {
    _runloop.backburner.ensureInstance();
  }

  var ARGS_PROXY_TAGS = new WeakMap();
  _exports.ARGS_PROXY_TAGS = ARGS_PROXY_TAGS;

  function finishLazyChains(obj, key, value$$1) {
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    var lazyTags = meta$$1 !== null ? meta$$1.readableLazyChainsFor(key) : undefined;

    if (lazyTags === undefined) {
      return;
    }

    if (value$$1 === null || typeof value$$1 !== 'object' && typeof value$$1 !== 'function') {
      for (var path in lazyTags) {
        delete lazyTags[path];
      }

      return;
    }

    for (var _path in lazyTags) {
      var tag = lazyTags[_path];
      (0, _reference.update)(tag, (0, _reference.combine)(getChainTagsForKey(value$$1, _path)));
      delete lazyTags[_path];
    }
  }

  function getChainTagsForKeys(obj, keys) {
    var chainTags = [];

    for (var i = 0; i < keys.length; i++) {
      chainTags.push(...getChainTagsForKey(obj, keys[i]));
    }

    return chainTags;
  }

  function getChainTagsForKey(obj, path) {
    var chainTags = [];
    var current = obj;
    var pathLength = path.length;
    var segmentEnd = -1; // prevent closures

    var segment, descriptor; // eslint-disable-next-line no-constant-condition

    while (true) {
      var currentType = typeof current;

      if (current === null || currentType !== 'object' && currentType !== 'function') {
        // we've hit the end of the chain for now, break out
        break;
      }

      var lastSegmentEnd = segmentEnd + 1;
      segmentEnd = path.indexOf('.', lastSegmentEnd);

      if (segmentEnd === -1) {
        segmentEnd = pathLength;
      }

      segment = path.slice(lastSegmentEnd, segmentEnd); // If the segment is an @each, we can process it and then opt-

      if (segment === '@each' && segmentEnd !== pathLength) {
        (true && !(Array.isArray(current) || (0, _utils.isEmberArray)(current)) && (0, _debug.assert)("When using @each, the value you are attempting to watch must be an array, was: " + current.toString(), Array.isArray(current) || (0, _utils.isEmberArray)(current)));
        lastSegmentEnd = segmentEnd + 1;
        segmentEnd = path.indexOf('.', lastSegmentEnd); // There shouldn't be any more segments after an `@each`, so break

        (true && !(segmentEnd === -1) && (0, _debug.deprecate)("When using @each, you can only chain one property level deep, but " + path + " contains a nested chain. Please create an intermediary computed property or switch to tracked properties.", segmentEnd === -1, {
          until: '3.17.0',
          id: 'ember-metal.computed-deep-each'
        }));

        if (segmentEnd === -1) {
          segmentEnd = pathLength;
        }

        segment = path.slice(lastSegmentEnd, segmentEnd);

        if (segment.indexOf('.') !== -1) {
          segment = segment.substr(0, segment.indexOf('.'));
        } // Push the tags for each item's property


        var tags = current.map(item => {
          (true && !(typeof item === 'object') && (0, _debug.assert)("When using @each to observe the array `" + current.toString() + "`, the items in the array must be objects", typeof item === 'object'));
          return tagForProperty(item, segment);
        }); // Push the tag for the array length itself

        chainTags.push(...tags, tagForProperty(current, '[]'));
        break;
      } // If the segment is linking to an args proxy, we need to manually access
      // the tags for the args, since they are direct references and don't have a
      // tagForProperty. We then continue chaining like normal after it, since
      // you could chain off an arg if it were an object, for instance.


      if (segment === 'args' && ARGS_PROXY_TAGS.has(current.args)) {
        (true && !(segmentEnd !== pathLength) && (0, _debug.assert)("When watching the 'args' on a GlimmerComponent, you must watch a value on the args. You cannot watch the object itself, as it never changes.", segmentEnd !== pathLength));
        lastSegmentEnd = segmentEnd + 1;
        segmentEnd = path.indexOf('.', lastSegmentEnd);

        if (segmentEnd === -1) {
          segmentEnd = pathLength;
        }

        segment = path.slice(lastSegmentEnd, segmentEnd);
        var namedArgs = ARGS_PROXY_TAGS.get(current.args);
        var ref = namedArgs.get(segment);
        chainTags.push(ref.tag); // We still need to break if we're at the end of the path.

        if (segmentEnd === pathLength) {
          break;
        } // Otherwise, set the current value and then continue to the next segment


        current = ref.value();
        continue;
      } // TODO: Assert that current[segment] isn't an undecorated, non-MANDATORY_SETTER/dependentKeyCompat getter


      var propertyTag = tagForProperty(current, segment);
      descriptor = descriptorForProperty(current, segment);
      chainTags.push(propertyTag); // If the key was an alias, we should always get the next value in order to
      // bootstrap the alias. This is because aliases, unlike other CPs, should
      // always be in sync with the aliased value.

      if (descriptor !== undefined && typeof descriptor.altKey === 'string') {
        current = current[segment]; // We still need to break if we're at the end of the path.

        if (segmentEnd === pathLength) {
          break;
        } // Otherwise, continue to process the next segment


        continue;
      } // If we're at the end of the path, processing the last segment, and it's
      // not an alias, we should _not_ get the last value, since we already have
      // its tag. There's no reason to access it and do more work.


      if (segmentEnd === pathLength) {
        break;
      }

      if (descriptor === undefined) {
        // If the descriptor is undefined, then its a normal property, so we should
        // lookup the value to chain off of like normal.
        if (!(segment in current) && typeof current.unknownProperty === 'function') {
          current = current.unknownProperty(segment);
        } else {
          current = current[segment];
        }
      } else {
        // If the descriptor is defined, then its a normal CP (not an alias, which
        // would have been handled earlier). We get the last revision to check if
        // the CP is still valid, and if so we use the cached value. If not, then
        // we create a lazy chain lookup, and the next time the CP is caluculated,
        // it will update that lazy chain.
        var lastRevision = getLastRevisionFor(current, segment);

        if ((0, _reference.validate)(propertyTag, lastRevision)) {
          current = peekCacheFor(current).get(segment);
        } else {
          var lazyChains = (0, _meta2.meta)(current).writableLazyChainsFor(segment);
          var rest = path.substr(segmentEnd + 1);
          var placeholderTag = lazyChains[rest];

          if (placeholderTag === undefined) {
            placeholderTag = lazyChains[rest] = (0, _reference.createUpdatableTag)();
          }

          chainTags.push(placeholderTag);
          break;
        }
      }
    }

    return chainTags;
  }

  var firstDotIndexCache = new _utils.Cache(1000, key => key.indexOf('.'));

  function isPath(path) {
    return typeof path === 'string' && firstDotIndexCache.get(path) !== -1;
  }

  var AFTER_OBSERVERS = ':change';

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }
  /**
  @module @ember/object
  */

  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:change": [ // variable name: `actions`
              target, method, once
            ]
          }
        }
  
  */

  /**
    Add an event listener
  
    @method addListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */


  function addListener(obj, eventName, target, method, once, sync = true) {
    (true && !(Boolean(obj) && Boolean(eventName)) && (0, _debug.assert)('You must pass at least an object and event name to addListener', Boolean(obj) && Boolean(eventName)));

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    (0, _meta2.meta)(obj).addToListeners(eventName, target, method, once === true, sync);
  }
  /**
    Remove an event listener
  
    Arguments should match those passed to `addListener`.
  
    @method removeListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */


  function removeListener(obj, eventName, targetOrFunction, functionOrName) {
    (true && !(Boolean(obj) && Boolean(eventName) && (typeof targetOrFunction === 'function' || typeof targetOrFunction === 'object' && Boolean(functionOrName))) && (0, _debug.assert)('You must pass at least an object, event name, and method or target and method/method name to removeListener', Boolean(obj) && Boolean(eventName) && (typeof targetOrFunction === 'function' || typeof targetOrFunction === 'object' && Boolean(functionOrName))));
    var target, method;

    if (typeof targetOrFunction === 'object') {
      target = targetOrFunction;
      method = functionOrName;
    } else {
      target = null;
      method = targetOrFunction;
    }

    var m = (0, _meta2.meta)(obj);
    m.removeFromListeners(eventName, target, method);
  }
  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @return {Boolean} if the event was delivered to one or more actions
    @public
  */


  function sendEvent(obj, eventName, params, actions, _meta) {
    if (actions === undefined) {
      var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;
      actions = typeof meta$$1 === 'object' && meta$$1 !== null ? meta$$1.matchingListeners(eventName) : undefined;
    }

    if (actions === undefined || actions.length === 0) {
      return false;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var once = actions[i + 2];

      if (!method) {
        continue;
      }

      if (once) {
        removeListener(obj, eventName, target, method);
      }

      if (!target) {
        target = obj;
      }

      if ('string' === typeof method) {
        method = target[method];
      }

      method.apply(target, params);
    }

    return true;
  }
  /**
    @private
    @method hasListeners
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @return {Boolean} if `obj` has listeners for event `eventName`
  */


  function hasListeners(obj, eventName) {
    var meta$$1 = (0, _meta2.peekMeta)(obj);

    if (meta$$1 === null) {
      return false;
    }

    var matched = meta$$1.matchingListeners(eventName);
    return matched !== undefined && matched.length > 0;
  }
  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
    ``` javascript
    import EmberObject from '@ember/object';
    import { on } from '@ember/object/evented';
    import { sendEvent } from '@ember/object/events';
  
    let Job = EmberObject.extend({
      logCompleted: on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @static
    @for @ember/object/evented
    @param {String} eventNames*
    @param {Function} func
    @return {Function} the listener function, passed as last argument to on(...)
    @public
  */


  function on(...args) {
    var func = args.pop();
    var events = args;
    (true && !(typeof func === 'function') && (0, _debug.assert)('on expects function as last argument', typeof func === 'function'));
    (true && !(events.length > 0 && events.every(p => typeof p === 'string' && p.length > 0)) && (0, _debug.assert)('on called without valid event names', events.length > 0 && events.every(p => typeof p === 'string' && p.length > 0)));
    (0, _utils.setListeners)(func, events);
    return func;
  }

  var SYNC_DEFAULT = !_environment.ENV._DEFAULT_ASYNC_OBSERVERS;
  var SYNC_OBSERVERS = new Map();
  var ASYNC_OBSERVERS = new Map();
  /**
  @module @ember/object
  */

  /**
    @method addObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function addObserver(obj, path, target, method, sync = SYNC_DEFAULT) {
    var eventName = changeEvent(path);
    addListener(obj, eventName, target, method, false, sync);
    {
      var meta$$1 = (0, _meta2.peekMeta)(obj);

      if (meta$$1 === null || !(meta$$1.isPrototypeMeta(obj) || meta$$1.isInitializing())) {
        activateObserver(obj, eventName, sync);
      }
    }
  }
  /**
    @method removeObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */


  function removeObserver(obj, path, target, method, sync = SYNC_DEFAULT) {
    var eventName = changeEvent(path);
    {
      var meta$$1 = (0, _meta2.peekMeta)(obj);

      if (meta$$1 === null || !(meta$$1.isPrototypeMeta(obj) || meta$$1.isInitializing())) {
        deactivateObserver(obj, eventName, sync);
      }
    }
    removeListener(obj, eventName, target, method);
  }

  function getOrCreateActiveObserversFor(target, sync) {
    var observerMap = sync === true ? SYNC_OBSERVERS : ASYNC_OBSERVERS;

    if (!observerMap.has(target)) {
      observerMap.set(target, new Map());
    }

    return observerMap.get(target);
  }

  function activateObserver(target, eventName, sync = false) {
    var activeObservers = getOrCreateActiveObserversFor(target, sync);

    if (activeObservers.has(eventName)) {
      activeObservers.get(eventName).count++;
    } else {
      var [path] = eventName.split(':');
      var tag = (0, _reference.combine)(getChainTagsForKey(target, path));
      activeObservers.set(eventName, {
        count: 1,
        path,
        tag,
        lastRevision: (0, _reference.value)(tag),
        suspended: false
      });
    }
  }

  function deactivateObserver(target, eventName, sync = false) {
    var observerMap = sync === true ? SYNC_OBSERVERS : ASYNC_OBSERVERS;
    var activeObservers = observerMap.get(target);

    if (activeObservers !== undefined) {
      var _observer = activeObservers.get(eventName);

      _observer.count--;

      if (_observer.count === 0) {
        activeObservers.delete(eventName);

        if (activeObservers.size === 0) {
          observerMap.delete(target);
        }
      }
    }
  }
  /**
   * Primarily used for cases where we are redefining a class, e.g. mixins/reopen
   * being applied later. Revalidates all the observers, resetting their tags.
   *
   * @private
   * @param target
   */


  function revalidateObservers(target) {
    if (ASYNC_OBSERVERS.has(target)) {
      ASYNC_OBSERVERS.get(target).forEach(observer => {
        observer.tag = (0, _reference.combine)(getChainTagsForKey(target, observer.path));
        observer.lastRevision = (0, _reference.value)(observer.tag);
      });
    }

    if (SYNC_OBSERVERS.has(target)) {
      SYNC_OBSERVERS.get(target).forEach(observer => {
        observer.tag = (0, _reference.combine)(getChainTagsForKey(target, observer.path));
        observer.lastRevision = (0, _reference.value)(observer.tag);
      });
    }
  }

  var lastKnownRevision = 0;

  function flushAsyncObservers(shouldSchedule = true) {
    if (lastKnownRevision === (0, _reference.value)(_reference.CURRENT_TAG)) {
      return;
    }

    lastKnownRevision = (0, _reference.value)(_reference.CURRENT_TAG);
    ASYNC_OBSERVERS.forEach((activeObservers, target) => {
      var meta$$1 = (0, _meta2.peekMeta)(target);

      if (meta$$1 && (meta$$1.isSourceDestroying() || meta$$1.isMetaDestroyed())) {
        ASYNC_OBSERVERS.delete(target);
        return;
      }

      activeObservers.forEach((observer, eventName) => {
        if (!(0, _reference.validate)(observer.tag, observer.lastRevision)) {
          var sendObserver = () => {
            try {
              sendEvent(target, eventName, [target, observer.path]);
            } finally {
              observer.tag = (0, _reference.combine)(getChainTagsForKey(target, observer.path));
              observer.lastRevision = (0, _reference.value)(observer.tag);
            }
          };

          if (shouldSchedule) {
            (0, _runloop.schedule)('actions', sendObserver);
          } else {
            sendObserver();
          }
        }
      });
    });
  }

  function flushSyncObservers() {
    // When flushing synchronous observers, we know that something has changed (we
    // only do this during a notifyPropertyChange), so there's no reason to check
    // a global revision.
    SYNC_OBSERVERS.forEach((activeObservers, target) => {
      var meta$$1 = (0, _meta2.peekMeta)(target);

      if (meta$$1 && (meta$$1.isSourceDestroying() || meta$$1.isMetaDestroyed())) {
        SYNC_OBSERVERS.delete(target);
        return;
      }

      activeObservers.forEach((observer, eventName) => {
        if (!observer.suspended && !(0, _reference.validate)(observer.tag, observer.lastRevision)) {
          try {
            observer.suspended = true;
            sendEvent(target, eventName, [target, observer.path]);
          } finally {
            observer.suspended = false;
            observer.tag = (0, _reference.combine)(getChainTagsForKey(target, observer.path));
            observer.lastRevision = (0, _reference.value)(observer.tag);
          }
        }
      });
    });
  }

  function setObserverSuspended(target, property, suspended) {
    var activeObservers = SYNC_OBSERVERS.get(target);

    if (!activeObservers) {
      return;
    }

    var observer = activeObservers.get(changeEvent(property));

    if (observer) {
      observer.suspended = suspended;
    }
  }

  var runInTransaction;
  _exports.runInTransaction = runInTransaction;
  var didRender;
  _exports.didRender = didRender;
  var assertNotRendered; // detect-backtracking-rerender by default is debug build only

  _exports.assertNotRendered = assertNotRendered;

  if (true
  /* DEBUG */
  ) {
    // there are 2 states
    // DEBUG
    // tracks lastRef and lastRenderedIn per rendered object and key during a transaction
    // release everything via normal weakmap semantics by just derefencing the weakmap
    // RELEASE
    // tracks transactionId per rendered object and key during a transaction
    // release everything via normal weakmap semantics by just derefencing the weakmap
    class TransactionRunner {
      constructor() {
        this.transactionId = 0;
        this.inTransaction = false;
        this.shouldReflush = false;
        this.weakMap = new WeakMap();

        if (true
        /* DEBUG */
        ) {
          // track templates
          this.debugStack = undefined;
        }
      }

      runInTransaction(context$$1, methodName) {
        this.before(context$$1);

        try {
          context$$1[methodName]();
        } finally {
          this.after();
        }

        return this.shouldReflush;
      }

      didRender(object, key, reference) {
        if (!this.inTransaction) {
          return;
        }

        if (true
        /* DEBUG */
        ) {
          this.setKey(object, key, {
            lastRef: reference,
            lastRenderedIn: this.debugStack.peek()
          });
        } else {
          this.setKey(object, key, this.transactionId);
        }
      }

      assertNotRendered(object, key) {
        if (!this.inTransaction) {
          return;
        }

        if (this.hasRendered(object, key)) {
          if (true
          /* DEBUG */
          ) {
            var {
              lastRef,
              lastRenderedIn
            } = this.getKey(object, key);
            var currentlyIn = this.debugStack.peek();
            var label = '';

            if (lastRef && typeof lastRef.debug === 'function') {
              label = "as `" + lastRef.debug() + "` in " + lastRenderedIn;
            } else {
              label = "in " + lastRenderedIn;
            }

            (true && !(false) && (0, _debug.assert)("You modified `" + object + "` twice in a single render. It was first rendered " + label + " and then modified later in " + currentlyIn + ". This was unreliable and slow in Ember 1.x and is no longer supported. See https://github.com/emberjs/ember.js/issues/13948 for more details.", false));
          }

          this.shouldReflush = true;
        }
      }

      hasRendered(object, key) {
        if (!this.inTransaction) {
          return false;
        }

        if (true
        /* DEBUG */
        ) {
          return this.getKey(object, key) !== undefined;
        }

        return this.getKey(object, key) === this.transactionId;
      }

      before(context$$1) {
        this.inTransaction = true;
        this.shouldReflush = false;

        if (true
        /* DEBUG */
        ) {
          this.debugStack = context$$1.env.debugStack;
        }
      }

      after() {
        this.transactionId++;
        this.inTransaction = false;

        if (true
        /* DEBUG */
        ) {
          this.debugStack = undefined;
        }

        this.clearObjectMap();
      }

      createMap(object) {
        var map = Object.create(null);
        this.weakMap.set(object, map);
        return map;
      }

      getOrCreateMap(object) {
        var map = this.weakMap.get(object);

        if (map === undefined) {
          map = this.createMap(object);
        }

        return map;
      }

      setKey(object, key, value$$1) {
        var map = this.getOrCreateMap(object);
        map[key] = value$$1;
      }

      getKey(object, key) {
        var map = this.weakMap.get(object);

        if (map !== undefined) {
          return map[key];
        }
      }

      clearObjectMap() {
        this.weakMap = new WeakMap();
      }

    }

    var runner = new TransactionRunner();

    _exports.runInTransaction = runInTransaction = (...args) => runner.runInTransaction(...args);

    _exports.didRender = didRender = (...args) => runner.didRender(...args);

    _exports.assertNotRendered = assertNotRendered = (...args) => runner.assertNotRendered(...args);
  } else {
    // in production do nothing to detect reflushes
    _exports.runInTransaction = runInTransaction = (context$$1, methodName) => {
      context$$1[methodName]();
      return false;
    };
  }
  /**
   @module ember
   @private
   */


  var PROPERTY_DID_CHANGE = (0, _utils.symbol)('PROPERTY_DID_CHANGE');
  _exports.PROPERTY_DID_CHANGE = PROPERTY_DID_CHANGE;
  var deferred = 0;
  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually.
  
    @method notifyPropertyChange
    @for @ember/object
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @param {Meta} meta The objects meta.
    @return {void}
    @since 3.1.0
    @public
  */

  function notifyPropertyChange(obj, keyName, _meta) {
    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;

    if (meta$$1 !== null && (meta$$1.isInitializing() || meta$$1.isPrototypeMeta(obj))) {
      return;
    }

    if (meta$$1 !== null) {
      markObjectAsDirty(obj, keyName, meta$$1);
    }

    if (true
    /* EMBER_METAL_TRACKED_PROPERTIES */
    && deferred <= 0) {
      flushSyncObservers();
    }

    if (PROPERTY_DID_CHANGE in obj) {
      obj[PROPERTY_DID_CHANGE](keyName);
    }

    if (true
    /* DEBUG */
    ) {
      assertNotRendered(obj, keyName);
    }
  }

  function overrideChains(_obj, keyName, meta$$1) {
    var chainWatchers = meta$$1.readableChainWatchers();

    if (chainWatchers !== undefined) {
      chainWatchers.revalidate(keyName);
    }
  }
  /**
    @method beginPropertyChanges
    @chainable
    @private
  */


  function beginPropertyChanges() {
    deferred++;
  }
  /**
    @method endPropertyChanges
    @private
  */


  function endPropertyChanges() {
    deferred--;

    if (deferred <= 0) {
      {
        flushSyncObservers();
      }
    }
  }
  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @private
  */


  function changeProperties(callback) {
    beginPropertyChanges();

    try {
      callback();
    } finally {
      endPropertyChanges();
    }
  }
  /**
  @module @ember/object
  */
  // DEFINING PROPERTIES API
  //


  function MANDATORY_SETTER_FUNCTION(name) {
    function SETTER_FUNCTION(value$$1) {
      var m = (0, _meta2.peekMeta)(this);

      if (m.isInitializing() || m.isPrototypeMeta(this)) {
        m.writeValues(name, value$$1);
      } else {
        (true && !(false) && (0, _debug.assert)("You must use set() to set the `" + name + "` property (of " + this + ") to `" + value$$1 + "`.", false));
      }
    }

    return (0, _polyfills.assign)(SETTER_FUNCTION, {
      isMandatorySetter: true
    });
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta$$1 = (0, _meta2.peekMeta)(this);

      if (meta$$1 !== null) {
        return meta$$1.peekValues(name);
      }
    };
  }

  function INHERITING_GETTER_FUNCTION(name) {
    function IGETTER_FUNCTION() {
      var meta$$1 = (0, _meta2.peekMeta)(this);
      var val;

      if (meta$$1 !== null) {
        val = meta$$1.readInheritedValue(name);

        if (val === undefined) {
          var proto = Object.getPrototypeOf(this);
          val = proto === null ? undefined : proto[name];
        } else {
          val = val === _meta2.UNDEFINED ? undefined : val;
        }
      }

      return val;
    }

    return (0, _polyfills.assign)(IGETTER_FUNCTION, {
      isInheritingGetter: true
    });
  }
  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    import { defineProperty, computed } from '@ember/object';
  
    // ES5 compatible mode
    defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    defineProperty(contact, 'fullName', computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @public
    @method defineProperty
    @static
    @for @ember/object
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */


  function defineProperty(obj, keyName, desc, data, meta$$1) {
    if (meta$$1 === undefined) {
      meta$$1 = (0, _meta2.meta)(obj);
    }

    var watching = meta$$1.peekWatching(keyName) > 0;
    var previousDesc = descriptorForProperty(obj, keyName, meta$$1);
    var wasDescriptor = previousDesc !== undefined;

    if (wasDescriptor) {
      previousDesc.teardown(obj, keyName, meta$$1);
    } // used to track if the the property being defined be enumerable


    var enumerable = true; // Ember.NativeArray is a normal Ember.Mixin that we mix into `Array.prototype` when prototype extensions are enabled
    // mutating a native object prototype like this should _not_ result in enumerable properties being added (or we have significant
    // issues with things like deep equality checks from test frameworks, or things like jQuery.extend(true, [], [])).
    //
    // this is a hack, and we should stop mutating the array prototype by default 😫

    if (obj === Array.prototype) {
      enumerable = false;
    }

    var value$$1;

    if (isClassicDecorator(desc)) {
      var propertyDesc;

      if (true
      /* DEBUG */
      ) {
        propertyDesc = desc(obj, keyName, undefined, meta$$1, true);
      } else {
        propertyDesc = desc(obj, keyName, undefined, meta$$1);
      }

      Object.defineProperty(obj, keyName, propertyDesc); // pass the decorator function forward for backwards compat

      value$$1 = desc;
    } else if (desc === undefined || desc === null) {
      value$$1 = data;

      if (true
      /* DEBUG */
      && watching) {
        meta$$1.writeValues(keyName, data);
        var defaultDescriptor = {
          configurable: true,
          enumerable,
          set: MANDATORY_SETTER_FUNCTION(keyName),
          get: DEFAULT_GETTER_FUNCTION(keyName)
        };
        Object.defineProperty(obj, keyName, defaultDescriptor);
      } else if (wasDescriptor || enumerable === false) {
        Object.defineProperty(obj, keyName, {
          configurable: true,
          enumerable,
          writable: true,
          value: value$$1
        });
      } else {
        if (true
        /* EMBER_METAL_TRACKED_PROPERTIES */
        && true
        /* DEBUG */
        ) {
          (0, _utils.setWithMandatorySetter)(obj, keyName, data);
        } else {
          obj[keyName] = data;
        }
      }
    } else {
      value$$1 = desc; // fallback to ES5

      Object.defineProperty(obj, keyName, desc);
    } // if key is being watched, override chains that
    // were initialized with the prototype


    {
      if (!meta$$1.isPrototypeMeta(obj)) {
        revalidateObservers(obj);
      }
    } // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.

    if (typeof obj.didDefineProperty === 'function') {
      obj.didDefineProperty(obj, keyName, value$$1);
    }
  }

  var handleMandatorySetter;

  function watchKey(obj, keyName, _meta) {
    var meta$$1 = _meta === undefined ? (0, _meta2.meta)(obj) : _meta;
    var count = meta$$1.peekWatching(keyName);
    meta$$1.writeWatching(keyName, count + 1);

    if (count === 0) {
      // activate watching first time
      var possibleDesc = descriptorForProperty(obj, keyName, meta$$1);

      if (possibleDesc !== undefined && possibleDesc.willWatch !== undefined) {
        possibleDesc.willWatch(obj, keyName, meta$$1);
      }

      if (true
      /* DEBUG */
      ) {
        // NOTE: this is dropped for prod + minified builds
        handleMandatorySetter(meta$$1, obj, keyName);
      }
    }
  }

  if (true
  /* DEBUG */
  ) {
    var _hasOwnProperty = (obj, key) => Object.prototype.hasOwnProperty.call(obj, key);

    var _propertyIsEnumerable = (obj, key) => Object.prototype.propertyIsEnumerable.call(obj, key); // Future traveler, although this code looks scary. It merely exists in
    // development to aid in development asertions. Production builds of
    // ember strip this entire block out


    handleMandatorySetter = function handleMandatorySetter(m, obj, keyName) {
      var descriptor = (0, _utils.lookupDescriptor)(obj, keyName);
      var hasDescriptor = descriptor !== null;
      var possibleDesc = hasDescriptor && descriptor.value;

      if (isClassicDecorator(possibleDesc)) {
        return;
      }

      var configurable = hasDescriptor ? descriptor.configurable : true;
      var isWritable = hasDescriptor ? descriptor.writable : true;
      var hasValue = hasDescriptor ? 'value' in descriptor : true; // this x in Y deopts, so keeping it in this function is better;

      if (configurable && isWritable && hasValue && keyName in obj) {
        var desc = {
          configurable: true,
          set: MANDATORY_SETTER_FUNCTION(keyName),
          enumerable: _propertyIsEnumerable(obj, keyName),
          get: undefined
        };

        if (_hasOwnProperty(obj, keyName)) {
          m.writeValues(keyName, obj[keyName]);
          desc.get = DEFAULT_GETTER_FUNCTION(keyName);
        } else {
          desc.get = INHERITING_GETTER_FUNCTION(keyName);
        }

        Object.defineProperty(obj, keyName, desc);
      }
    };
  }

  function unwatchKey(obj, keyName, _meta) {
    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta; // do nothing of this object has already been destroyed

    if (meta$$1 === null || meta$$1.isSourceDestroyed()) {
      return;
    }

    var count = meta$$1.peekWatching(keyName);

    if (count === 1) {
      meta$$1.writeWatching(keyName, 0);
      var possibleDesc = descriptorForProperty(obj, keyName, meta$$1);
      var isDescriptor = possibleDesc !== undefined;

      if (isDescriptor && possibleDesc.didUnwatch !== undefined) {
        possibleDesc.didUnwatch(obj, keyName, meta$$1);
      }

      if (typeof obj.didUnwatchProperty === 'function') {
        obj.didUnwatchProperty(keyName);
      }

      if (true
      /* DEBUG */
      ) {
        // It is true, the following code looks quite WAT. But have no fear, It
        // exists purely to improve development ergonomics and is removed from
        // ember.min.js and ember.prod.js builds.
        //
        // Some further context: Once a property is watched by ember, bypassing `set`
        // for mutation, will bypass observation. This code exists to assert when
        // that occurs, and attempt to provide more helpful feedback. The alternative
        // is tricky to debug partially observable properties.
        if (!isDescriptor && keyName in obj) {
          var maybeMandatoryDescriptor = (0, _utils.lookupDescriptor)(obj, keyName);

          if (maybeMandatoryDescriptor && maybeMandatoryDescriptor.set && maybeMandatoryDescriptor.set.isMandatorySetter) {
            if (maybeMandatoryDescriptor.get && maybeMandatoryDescriptor.get.isInheritingGetter) {
              var possibleValue = meta$$1.readInheritedValue(keyName);

              if (possibleValue === undefined) {
                delete obj[keyName];
                return;
              }
            }

            Object.defineProperty(obj, keyName, {
              configurable: true,
              enumerable: Object.prototype.propertyIsEnumerable.call(obj, keyName),
              writable: true,
              value: meta$$1.peekValues(keyName)
            });
            meta$$1.deleteFromValues(keyName);
          }
        }
      }
    } else if (count > 1) {
      meta$$1.writeWatching(keyName, count - 1);
    }
  }

  var EACH_PROXIES = new WeakMap();

  function eachProxyArrayWillChange(array, idx, removedCnt, addedCnt) {
    var eachProxy = EACH_PROXIES.get(array);

    if (eachProxy !== undefined) {
      eachProxy.arrayWillChange(array, idx, removedCnt, addedCnt);
    }
  }

  function eachProxyArrayDidChange(array, idx, removedCnt, addedCnt) {
    var eachProxy = EACH_PROXIES.get(array);

    if (eachProxy !== undefined) {
      eachProxy.arrayDidChange(array, idx, removedCnt, addedCnt);
    }
  }

  function arrayContentWillChange(array, startIdx, removeAmt, addAmt) {
    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }

      if (addAmt === undefined) {
        addAmt = -1;
      }
    }

    sendEvent(array, '@array:before', [array, startIdx, removeAmt, addAmt]);
    return array;
  }

  function arrayContentDidChange(array, startIdx, removeAmt, addAmt) {
    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }

      if (addAmt === undefined) {
        addAmt = -1;
      }
    }

    var meta$$1 = (0, _meta2.peekMeta)(array);

    if (addAmt < 0 || removeAmt < 0 || addAmt - removeAmt !== 0) {
      notifyPropertyChange(array, 'length', meta$$1);
    }

    notifyPropertyChange(array, '[]', meta$$1);
    sendEvent(array, '@array:change', [array, startIdx, removeAmt, addAmt]);
    var cache = peekCacheFor(array);

    if (cache !== undefined) {
      var length = array.length;
      var addedAmount = addAmt === -1 ? 0 : addAmt;
      var removedAmount = removeAmt === -1 ? 0 : removeAmt;
      var delta = addedAmount - removedAmount;
      var previousLength = length - delta;
      var normalStartIdx = startIdx < 0 ? previousLength + startIdx : startIdx;

      if (cache.has('firstObject') && normalStartIdx === 0) {
        notifyPropertyChange(array, 'firstObject', meta$$1);
      }

      if (cache.has('lastObject')) {
        var previousLastIndex = previousLength - 1;
        var lastAffectedIndex = normalStartIdx + removedAmount;

        if (previousLastIndex < lastAffectedIndex) {
          notifyPropertyChange(array, 'lastObject', meta$$1);
        }
      }
    }

    return array;
  }
  /**
    An object that that tracks @tracked properties that were consumed.
  
    @private
  */


  class Tracker {
    constructor() {
      this.tags = new Set();
      this.last = null;
    }

    add(tag) {
      this.tags.add(tag);
      this.last = tag;
    }

    get size() {
      return this.tags.size;
    }

    combine() {
      if (this.tags.size === 0) {
        return _reference.CONSTANT_TAG;
      } else if (this.tags.size === 1) {
        return this.last;
      } else {
        var tags = [];
        this.tags.forEach(tag => tags.push(tag));
        return (0, _reference.combine)(tags);
      }
    }

  }

  _exports.Tracker = Tracker;

  function tracked(...args) {
    (true && !(!(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)) && (0, _debug.assert)("@tracked can only be used directly as a native decorator. If you're using tracked in classic classes, add parenthesis to call it like a function: tracked()", !(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)));

    if (!isElementDescriptor(args)) {
      var propertyDesc = args[0];
      (true && !(args.length === 0 || typeof propertyDesc === 'object' && propertyDesc !== null) && (0, _debug.assert)("tracked() may only receive an options object containing 'value' or 'initializer', received " + propertyDesc, args.length === 0 || typeof propertyDesc === 'object' && propertyDesc !== null));

      if (true
      /* DEBUG */
      && propertyDesc) {
        var keys = Object.keys(propertyDesc);
        (true && !(keys.length <= 1 && (keys[0] === undefined || keys[0] === 'value' || keys[0] === 'initializer')) && (0, _debug.assert)("The options object passed to tracked() may only contain a 'value' or 'initializer' property, not both. Received: [" + keys + "]", keys.length <= 1 && (keys[0] === undefined || keys[0] === 'value' || keys[0] === 'initializer')));
        (true && !(!('initializer' in propertyDesc) || typeof propertyDesc.initializer === 'function') && (0, _debug.assert)("The initializer passed to tracked must be a function. Received " + propertyDesc.initializer, !('initializer' in propertyDesc) || typeof propertyDesc.initializer === 'function'));
      }

      var initializer = propertyDesc ? propertyDesc.initializer : undefined;
      var value$$1 = propertyDesc ? propertyDesc.value : undefined;

      var decorator = function (target, key, _desc, _meta, isClassicDecorator$$1) {
        (true && !(isClassicDecorator$$1) && (0, _debug.assert)("You attempted to set a default value for " + key + " with the @tracked({ value: 'default' }) syntax. You can only use this syntax with classic classes. For native classes, you can use class initializers: @tracked field = 'default';", isClassicDecorator$$1));
        var fieldDesc = {
          initializer: initializer || (() => value$$1)
        };
        return descriptorForField([target, key, fieldDesc]);
      };

      setClassicDecorator(decorator);
      return decorator;
    }

    return descriptorForField(args);
  }

  if (true
  /* DEBUG */
  ) {
    // Normally this isn't a classic decorator, but we want to throw a helpful
    // error in development so we need it to treat it like one
    setClassicDecorator(tracked);
  }

  function descriptorForField([_target, key, desc]) {
    (true && !(!desc || !desc.value && !desc.get && !desc.set) && (0, _debug.assert)("You attempted to use @tracked on " + key + ", but that element is not a class field. @tracked is only usable on class fields. Native getters and setters will autotrack add any tracked fields they encounter, so there is no need mark getters and setters with @tracked.", !desc || !desc.value && !desc.get && !desc.set));
    var initializer = desc ? desc.initializer : undefined;
    var values = new WeakMap();
    var hasInitializer = typeof initializer === 'function';
    return {
      enumerable: true,
      configurable: true,

      get() {
        var propertyTag = tagForProperty(this, key);
        if (CURRENT_TRACKER) CURRENT_TRACKER.add(propertyTag);
        var value$$1; // If the field has never been initialized, we should initialize it

        if (hasInitializer && !values.has(this)) {
          value$$1 = initializer.call(this);
          values.set(this, value$$1);
        } else {
          value$$1 = values.get(this);
        } // Add the tag of the returned value if it is an array, since arrays
        // should always cause updates if they are consumed and then changed


        if (Array.isArray(value$$1) || (0, _utils.isEmberArray)(value$$1)) {
          (0, _reference.update)(propertyTag, tagForProperty(value$$1, '[]'));
        }

        return value$$1;
      },

      set(newValue) {
        markObjectAsDirty(this, key);
        values.set(this, newValue);

        if (propertyDidChange !== null) {
          propertyDidChange();
        }
      }

    };
  }
  /**
    @private
  
    Whenever a tracked computed property is entered, the current tracker is
    saved off and a new tracker is replaced.
  
    Any tracked properties consumed are added to the current tracker.
  
    When a tracked computed property is exited, the tracker's tags are
    combined and added to the parent tracker.
  
    The consequence is that each tracked computed property has a tag
    that corresponds to the tracked properties consumed inside of
    itself, including child tracked computed properties.
  */


  var CURRENT_TRACKER = null;

  function track(callback) {
    var parent = CURRENT_TRACKER;
    var current = new Tracker();
    CURRENT_TRACKER = current;

    try {
      callback();
    } finally {
      CURRENT_TRACKER = parent;
    }

    return current.combine();
  }

  function consume(tag) {
    if (CURRENT_TRACKER !== null) {
      CURRENT_TRACKER.add(tag);
    }
  }

  function isTracking() {
    return CURRENT_TRACKER !== null;
  }

  function untrack(callback) {
    var parent = CURRENT_TRACKER;
    CURRENT_TRACKER = null;

    try {
      callback();
    } finally {
      CURRENT_TRACKER = parent;
    }
  }

  var propertyDidChange = null;
  /**
  @module @ember/object
  */

  var PROXY_CONTENT = (0, _utils.symbol)('PROXY_CONTENT');
  _exports.PROXY_CONTENT = PROXY_CONTENT;
  var getPossibleMandatoryProxyValue;

  if (true
  /* DEBUG */
  && _utils.HAS_NATIVE_PROXY) {
    getPossibleMandatoryProxyValue = function getPossibleMandatoryProxyValue(obj, keyName) {
      var content = obj[PROXY_CONTENT];

      if (content === undefined) {
        return obj[keyName];
      } else {
        /* global Reflect */
        return Reflect.get(content, keyName, obj);
      }
    };
  } // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    ```javascript
    import { get } from '@ember/object';
    get(obj, "name");
    ```
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */


  function get(obj, keyName) {
    (true && !(arguments.length === 2) && (0, _debug.assert)("Get must be called with two arguments; an object and a property key", arguments.length === 2));
    (true && !(obj !== undefined && obj !== null) && (0, _debug.assert)("Cannot call get with '" + keyName + "' on an undefined object.", obj !== undefined && obj !== null));
    (true && !(typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)) && (0, _debug.assert)("The key provided to get must be a string or number, you passed " + keyName, typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)));
    (true && !(typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0) && (0, _debug.assert)("'this' in paths is not supported", typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0));
    var type = typeof obj;
    var isObject = type === 'object';
    var isFunction = type === 'function';
    var isObjectLike = isObject || isFunction;

    if (isPath(keyName)) {
      return isObjectLike ? _getPath(obj, keyName) : undefined;
    }

    var value$$1;

    if (isObjectLike) {
      var tracking = isTracking();
      {
        if (tracking) {
          consume(tagForProperty(obj, keyName));
        }
      }

      if (true
      /* DEBUG */
      && _utils.HAS_NATIVE_PROXY) {
        value$$1 = getPossibleMandatoryProxyValue(obj, keyName);
      } else {
        value$$1 = obj[keyName];
      } // Add the tag of the returned value if it is an array, since arrays
      // should always cause updates if they are consumed and then changed


      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      && tracking && (Array.isArray(value$$1) || (0, _utils.isEmberArray)(value$$1))) {
        consume(tagForProperty(value$$1, '[]'));
      }
    } else {
      value$$1 = obj[keyName];
    }

    if (value$$1 === undefined) {
      if (isObject && !(keyName in obj) && typeof obj.unknownProperty === 'function') {
        return obj.unknownProperty(keyName);
      }
    }

    return value$$1;
  }

  function _getPath(root, path) {
    var obj = root;
    var parts = typeof path === 'string' ? path.split('.') : path;

    for (var i = 0; i < parts.length; i++) {
      if (obj === undefined || obj === null || obj.isDestroyed) {
        return undefined;
      }

      obj = get(obj, parts[i]);
    }

    return obj;
  }
  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    import { getWithDefault } from '@ember/object';
    getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
  */


  function getWithDefault(root, key, defaultValue) {
    var value$$1 = get(root, key);

    if (value$$1 === undefined) {
      return defaultValue;
    }

    return value$$1;
  }

  var EMPTY_ARRAY = Object.freeze([]);

  function objectAt(array, index) {
    if (Array.isArray(array)) {
      return array[index];
    } else {
      return array.objectAt(index);
    }
  }

  function replace(array, start, deleteCount, items = EMPTY_ARRAY) {
    if (Array.isArray(array)) {
      replaceInNativeArray(array, start, deleteCount, items);
    } else {
      array.replace(start, deleteCount, items);
    }
  }

  var CHUNK_SIZE = 60000; // To avoid overflowing the stack, we splice up to CHUNK_SIZE items at a time.
  // See https://code.google.com/p/chromium/issues/detail?id=56588 for more details.

  function replaceInNativeArray(array, start, deleteCount, items) {
    arrayContentWillChange(array, start, deleteCount, items.length);

    if (items.length <= CHUNK_SIZE) {
      array.splice(start, deleteCount, ...items);
    } else {
      array.splice(start, deleteCount);

      for (var i = 0; i < items.length; i += CHUNK_SIZE) {
        var chunk = items.slice(i, i + CHUNK_SIZE);
        array.splice(start + i, 0, ...chunk);
      }
    }

    arrayContentDidChange(array, start, deleteCount, items.length);
  }

  function arrayObserversHelper(obj, target, opts, operation, notify) {
    var willChange = opts && opts.willChange || 'arrayWillChange';
    var didChange = opts && opts.didChange || 'arrayDidChange';
    var hasObservers = get(obj, 'hasArrayObservers');
    operation(obj, '@array:before', target, willChange);
    operation(obj, '@array:change', target, didChange);

    if (hasObservers === notify) {
      notifyPropertyChange(obj, 'hasArrayObservers');
    }

    return obj;
  }

  function addArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, addListener, false);
  }

  function removeArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, removeListener, true);
  }

  function eachProxyFor(array) {
    var eachProxy = EACH_PROXIES.get(array);

    if (eachProxy === undefined) {
      eachProxy = new EachProxy(array);
      EACH_PROXIES.set(array, eachProxy);
    }

    return eachProxy;
  }

  class EachProxy {
    constructor(content) {
      this._content = content;
      this._keys = undefined;
      (0, _meta2.meta)(this);
    } // ..........................................................
    // ARRAY CHANGES
    // Invokes whenever the content array itself changes.


    arrayWillChange(content, idx, removedCnt
    /*, addedCnt */
    ) {
      // eslint-disable-line no-unused-vars
      var keys = this._keys;

      if (!keys) {
        return;
      }

      var lim = removedCnt > 0 ? idx + removedCnt : -1;

      if (lim > 0) {
        for (var key in keys) {
          removeObserverForContentKey(content, key, this, idx, lim);
        }
      }
    }

    arrayDidChange(content, idx, _removedCnt, addedCnt) {
      var keys = this._keys;

      if (!keys) {
        return;
      }

      var lim = addedCnt > 0 ? idx + addedCnt : -1;
      var meta$$1 = (0, _meta2.peekMeta)(this);

      for (var key in keys) {
        if (lim > 0) {
          addObserverForContentKey(content, key, this, idx, lim);
        }

        notifyPropertyChange(this, key, meta$$1);
      }
    } // ..........................................................
    // LISTEN FOR NEW OBSERVERS AND OTHER EVENT LISTENERS
    // Start monitoring keys based on who is listening...


    willWatchProperty(property) {
      this.beginObservingContentKey(property);
    }

    didUnwatchProperty(property) {
      this.stopObservingContentKey(property);
    } // ..........................................................
    // CONTENT KEY OBSERVING
    // Actual watch keys on the source content.


    beginObservingContentKey(keyName) {
      var keys = this._keys;

      if (keys === undefined) {
        keys = this._keys = Object.create(null);
      }

      if (!keys[keyName]) {
        keys[keyName] = 1;
        var content = this._content;
        var len = content.length;
        addObserverForContentKey(content, keyName, this, 0, len);
      } else {
        keys[keyName]++;
      }
    }

    stopObservingContentKey(keyName) {
      var keys = this._keys;

      if (keys !== undefined && keys[keyName] > 0 && --keys[keyName] <= 0) {
        var content = this._content;
        var len = content.length;
        removeObserverForContentKey(content, keyName, this, 0, len);
      }
    }

    contentKeyDidChange(_obj, keyName) {
      notifyPropertyChange(this, keyName);
    }

  }

  function addObserverForContentKey(content, keyName, proxy, idx, loc) {
    while (--loc >= idx) {
      var item = objectAt(content, loc);

      if (item) {
        (true && !(typeof item === 'object') && (0, _debug.assert)("When using @each to observe the array `" + content.toString() + "`, the array must return an object", typeof item === 'object'));
        addObserver(item, keyName, proxy, 'contentKeyDidChange');
      }
    }
  }

  function removeObserverForContentKey(content, keyName, proxy, idx, loc) {
    while (--loc >= idx) {
      var item = objectAt(content, loc);

      if (item) {
        removeObserver(item, keyName, proxy, 'contentKeyDidChange');
      }
    }
  }

  function isObject(obj) {
    return typeof obj === 'object' && obj !== null;
  }

  function isVolatile(obj, keyName, meta$$1) {
    var desc = descriptorForProperty(obj, keyName, meta$$1);
    return !(desc !== undefined && desc._volatile === false);
  }

  class ChainWatchers {
    constructor() {
      // chain nodes that reference a key in this obj by key
      // we only create ChainWatchers when we are going to add them
      // so create this upfront
      this.chains = Object.create(null);
    }

    add(key, node) {
      var nodes = this.chains[key];

      if (nodes === undefined) {
        this.chains[key] = [node];
      } else {
        nodes.push(node);
      }
    }

    remove(key, node) {
      var nodes = this.chains[key];

      if (nodes !== undefined) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
    }

    has(key, node) {
      var nodes = this.chains[key];

      if (nodes !== undefined) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            return true;
          }
        }
      }

      return false;
    }

    revalidateAll() {
      for (var key in this.chains) {
        this.notify(key, true, undefined);
      }
    }

    revalidate(key) {
      this.notify(key, true, undefined);
    } // key: the string key that is part of a path changed
    // revalidate: boolean; the chains that are watching this value should revalidate
    // callback: function that will be called with the object and path that
    //           will be/are invalidated by this key change, depending on
    //           whether the revalidate flag is passed


    notify(key, revalidate, callback) {
      var nodes = this.chains[key];

      if (nodes === undefined || nodes.length === 0) {
        return;
      }

      var affected = undefined;

      if (callback !== undefined) {
        affected = [];
      }

      for (var i = 0; i < nodes.length; i++) {
        nodes[i].notify(revalidate, affected);
      }

      if (callback === undefined) {
        return;
      } // we gather callbacks so we don't notify them during revalidation


      for (var _i = 0; _i < affected.length; _i += 2) {
        var obj = affected[_i];
        var path = affected[_i + 1];
        callback(obj, path);
      }
    }

  }

  function makeChainWatcher() {
    return new ChainWatchers();
  }

  function makeChainNode(obj) {
    return new ChainNode(null, null, obj);
  }

  function addChainWatcher(obj, keyName, node) {
    var m = (0, _meta2.meta)(obj);
    m.writableChainWatchers(makeChainWatcher).add(keyName, node);
    watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node, _meta) {
    if (!isObject(obj)) {
      return;
    }

    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;

    if (meta$$1 === null || meta$$1.isSourceDestroying() || meta$$1.isMetaDestroyed() || meta$$1.readableChainWatchers() === undefined) {
      return;
    } // make meta writable


    meta$$1 = (0, _meta2.meta)(obj);
    meta$$1.readableChainWatchers().remove(keyName, node);
    unwatchKey(obj, keyName, meta$$1);
  }

  var NODE_STACK = [];

  function destroyRoot(root) {
    pushChildren(root);

    while (NODE_STACK.length > 0) {
      var node = NODE_STACK.pop();
      pushChildren(node);
      destroyOne(node);
    }
  }

  function destroyOne(node) {
    if (node.isWatching) {
      removeChainWatcher(node.object, node.key, node);
      node.isWatching = false;
    }
  }

  function pushChildren(node) {
    var nodes = node.chains;

    if (nodes !== undefined) {
      for (var key in nodes) {
        if (nodes[key] !== undefined) {
          NODE_STACK.push(nodes[key]);
        }
      }
    }
  } // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.


  class ChainNode {
    constructor(parent, key, value$$1) {
      this.paths = undefined;
      this.isWatching = false;
      this.chains = undefined;
      this.object = undefined;
      this.count = 0;
      this.parent = parent;
      this.key = key;
      this.content = value$$1; // It is false for the root of a chain (because we have no parent)

      var isWatching = this.isWatching = parent !== null;

      if (isWatching) {
        var parentValue = parent.value();

        if (isObject(parentValue)) {
          this.object = parentValue;
          addChainWatcher(parentValue, key, this);
        }
      }
    }

    value() {
      if (this.content === undefined && this.isWatching) {
        var obj = this.parent.value();
        this.content = lazyGet(obj, this.key);
      }

      return this.content;
    }

    destroy() {
      // check if root
      if (this.parent === null) {
        destroyRoot(this);
      } else {
        destroyOne(this);
      }
    } // copies a top level object only


    copyTo(target) {
      var paths = this.paths;

      if (paths !== undefined) {
        var path;

        for (path in paths) {
          if (paths[path] > 0) {
            target.add(path);
          }
        }
      }
    } // called on the root node of a chain to setup watchers on the specified
    // path.


    add(path) {
      var paths = this.paths || (this.paths = {});
      paths[path] = (paths[path] || 0) + 1;
      var tails = path.split('.');
      this.chain(tails.shift(), tails);
    } // called on the root node of a chain to teardown watcher on the specified
    // path


    remove(path) {
      var paths = this.paths;

      if (paths === undefined) {
        return;
      }

      if (paths[path] > 0) {
        paths[path]--;
      }

      var tails = path.split('.');
      this.unchain(tails.shift(), tails);
    }

    chain(key, tails) {
      var chains = this.chains;

      if (chains === undefined) {
        chains = this.chains = Object.create(null);
      }

      var node = chains[key];

      if (node === undefined) {
        node = chains[key] = new ChainNode(this, key, undefined);
      }

      node.count++; // count chains...
      // chain rest of path if there is one

      if (tails.length > 0) {
        node.chain(tails.shift(), tails);
      }
    }

    unchain(key, tails) {
      var chains = this.chains;
      var node = chains[key]; // unchain rest of path first...

      if (tails.length > 0) {
        node.unchain(tails.shift(), tails);
      } // delete node if needed.


      node.count--;

      if (node.count <= 0) {
        chains[node.key] = undefined;
        node.destroy();
      }
    }

    notify(revalidate, affected) {
      if (revalidate && this.isWatching) {
        var parentValue = this.parent.value();

        if (parentValue !== this.object) {
          removeChainWatcher(this.object, this.key, this);

          if (isObject(parentValue)) {
            this.object = parentValue;
            addChainWatcher(parentValue, this.key, this);
          } else {
            this.object = undefined;
          }
        }

        this.content = undefined;
      } // then notify chains...


      var chains = this.chains;

      if (chains !== undefined) {
        var node;

        for (var key in chains) {
          node = chains[key];

          if (node !== undefined) {
            node.notify(revalidate, affected);
          }
        }
      }

      if (affected !== undefined && this.parent !== null) {
        this.parent.populateAffected(this.key, 1, affected);
      }
    }

    populateAffected(path, depth, affected) {
      if (this.key) {
        path = this.key + "." + path;
      }

      if (this.parent !== null) {
        this.parent.populateAffected(path, depth + 1, affected);
      } else if (depth > 1) {
        affected.push(this.value(), path);
      }
    }

  }

  _exports.ChainNode = ChainNode;

  function lazyGet(obj, key) {
    if (!isObject(obj)) {
      return;
    }

    var meta$$1 = (0, _meta2.peekMeta)(obj); // check if object meant only to be a prototype

    if (meta$$1 !== null && meta$$1.proto === obj) {
      return;
    } // Use `get` if the return value is an EachProxy or an uncacheable value.


    if (key === '@each') {
      return eachProxyFor(obj);
    } else if (isVolatile(obj, key, meta$$1)) {
      return get(obj, key); // Otherwise attempt to get the cached value of the computed property
    } else {
      return getCachedValueFor(obj, key);
    }
  }

  function finishChains(meta$$1) {
    // finish any current chains node watchers that reference obj
    var chainWatchers = meta$$1.readableChainWatchers();

    if (chainWatchers !== undefined) {
      chainWatchers.revalidateAll();
    } // ensure that if we have inherited any chains they have been
    // copied onto our own meta.


    if (meta$$1.readableChains() !== undefined) {
      meta$$1.writableChains(makeChainNode);
    }
  }

  function watchPath(obj, keyPath, meta$$1) {
    var m = meta$$1 === undefined ? (0, _meta2.meta)(obj) : meta$$1;
    var counter = m.peekWatching(keyPath);
    m.writeWatching(keyPath, counter + 1);

    if (counter === 0) {
      // activate watching first time
      m.writableChains(makeChainNode).add(keyPath);
    }
  }

  function unwatchPath(obj, keyPath, meta$$1) {
    var m = meta$$1 === undefined ? (0, _meta2.peekMeta)(obj) : meta$$1;

    if (m === null) {
      return;
    }

    var counter = m.peekWatching(keyPath);

    if (counter > 0) {
      m.writeWatching(keyPath, counter - 1);

      if (counter === 1) {
        m.writableChains(makeChainNode).remove(keyPath);
      }
    }
  }
  /**
  @module ember
  */

  /**
    Starts watching a property on an object. Whenever the property changes,
    invokes `Ember.notifyPropertyChange`. This is the primitive used by observers
    and dependent keys; usually you will never call this method directly but instead
    use higher level methods like `addObserver()`.
  
    @private
    @method watch
    @for Ember
    @param obj
    @param {String} keyPath
    @param {Object} meta
  */


  function watch(obj, keyPath, meta$$1) {
    if (isPath(keyPath)) {
      watchPath(obj, keyPath, meta$$1);
    } else {
      watchKey(obj, keyPath, meta$$1);
    }
  }

  function isWatching(obj, key) {
    return watcherCount(obj, key) > 0;
  }

  function watcherCount(obj, key) {
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    return meta$$1 !== null && meta$$1.peekWatching(key) || 0;
  }
  /**
    Stops watching a property on an object. Usually you will never call this method directly but instead
    use higher level methods like `removeObserver()`.
  
    @private
    @method unwatch
    @for Ember
    @param obj
    @param {String} keyPath
    @param {Object} meta
  */


  function unwatch(obj, keyPath, meta$$1) {
    if (isPath(keyPath)) {
      unwatchPath(obj, keyPath, meta$$1);
    } else {
      unwatchKey(obj, keyPath, meta$$1);
    }
  }

  function isElementDescriptor(args) {
    var [maybeTarget, maybeKey, maybeDesc] = args;
    return (// Ensure we have the right number of args
      args.length === 3 && ( // Make sure the target is a class or object (prototype)
      typeof maybeTarget === 'function' || typeof maybeTarget === 'object' && maybeTarget !== null) && // Make sure the key is a string
      typeof maybeKey === 'string' && ( // Make sure the descriptor is the right shape
      typeof maybeDesc === 'object' && maybeDesc !== null && 'enumerable' in maybeDesc && 'configurable' in maybeDesc || // TS compatibility
      maybeDesc === undefined)
    );
  } // ..........................................................
  // DEPENDENT KEYS
  //


  function addDependentKeys(desc, obj, keyName, meta$$1) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var depKeys = desc._dependentKeys;

    if (depKeys === null || depKeys === undefined) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx]; // Increment the number of times depKey depends on keyName.

      meta$$1.writeDeps(depKey, keyName, meta$$1.peekDeps(depKey, keyName) + 1); // Watch the depKey

      watch(obj, depKey, meta$$1);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta$$1) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;

    if (depKeys === null || depKeys === undefined) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx]; // Decrement the number of times depKey depends on keyName.

      meta$$1.writeDeps(depKey, keyName, meta$$1.peekDeps(depKey, keyName) - 1); // Unwatch the depKey

      unwatch(obj, depKey, meta$$1);
    }
  }

  function nativeDescDecorator(propertyDesc) {
    var decorator = function () {
      return propertyDesc;
    };

    setClassicDecorator(decorator);
    return decorator;
  }
  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */


  class ComputedDescriptor {
    constructor() {
      this.enumerable = true;
      this.configurable = true;
      this._dependentKeys = undefined;
      this._meta = undefined;
    }

    setup(_obj, keyName, _propertyDesc, meta$$1) {
      meta$$1.writeDescriptors(keyName, this);
    }

    teardown(_obj, keyName, meta$$1) {
      meta$$1.removeDescriptors(keyName);
    }

  }

  function DESCRIPTOR_GETTER_FUNCTION(name, descriptor) {
    return function CPGETTER_FUNCTION() {
      return descriptor.get(this, name);
    };
  }

  function DESCRIPTOR_SETTER_FUNCTION(name, descriptor) {
    var func = function CPSETTER_FUNCTION(value$$1) {
      return descriptor.set(this, name, value$$1);
    };

    CP_SETTER_FUNCS.add(func);
    return func;
  }

  var CP_SETTER_FUNCS = new _polyfills._WeakSet();

  function makeComputedDecorator(desc, DecoratorClass) {
    var decorator = function COMPUTED_DECORATOR(target, key, propertyDesc, maybeMeta, isClassicDecorator$$1) {
      (true && !(isClassicDecorator$$1 || !propertyDesc || !propertyDesc.get || propertyDesc.get.toString().indexOf('CPGETTER_FUNCTION') === -1) && (0, _debug.assert)("Only one computed property decorator can be applied to a class field or accessor, but '" + key + "' was decorated twice. You may have added the decorator to both a getter and setter, which is unecessary.", isClassicDecorator$$1 || !propertyDesc || !propertyDesc.get || propertyDesc.get.toString().indexOf('CPGETTER_FUNCTION') === -1));
      var meta$$1 = arguments.length === 3 ? (0, _meta2.meta)(target) : maybeMeta;
      desc.setup(target, key, propertyDesc, meta$$1);
      var computedDesc = {
        enumerable: desc.enumerable,
        configurable: desc.configurable,
        get: DESCRIPTOR_GETTER_FUNCTION(key, desc)
      };
      {
        computedDesc.set = DESCRIPTOR_SETTER_FUNCTION(key, desc);
      }
      return computedDesc;
    };

    setClassicDecorator(decorator, desc);
    Object.setPrototypeOf(decorator, DecoratorClass.prototype);
    return decorator;
  }
  /**
  @module @ember/object
  */


  var END_WITH_EACH_REGEX = /\.@each$/;
  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    import { expandProperties } from '@ember/object/computed';
  
    function echo(arg){ console.log(arg); }
  
    expandProperties('foo.bar', echo);              //=> 'foo.bar'
    expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @static
    @for @ember/object/computed
    @public
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */

  function expandProperties(pattern, callback) {
    (true && !(typeof pattern === 'string') && (0, _debug.assert)("A computed property key must be a string, you passed " + typeof pattern + " " + pattern, typeof pattern === 'string'));
    (true && !(pattern.indexOf(' ') === -1) && (0, _debug.assert)('Brace expanded properties cannot contain spaces, e.g. "user.{firstName, lastName}" should be "user.{firstName,lastName}"', pattern.indexOf(' ') === -1)); // regex to look for double open, double close, or unclosed braces

    (true && !(pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null) && (0, _debug.assert)("Brace expanded properties have to be balanced and cannot be nested, pattern: " + pattern, pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null));
    var start = pattern.indexOf('{');

    if (start < 0) {
      callback(pattern.replace(END_WITH_EACH_REGEX, '.[]'));
    } else {
      dive('', pattern, start, callback);
    }
  }

  function dive(prefix, pattern, start, callback) {
    var end = pattern.indexOf('}'),
        i = 0,
        newStart,
        arrayLength;
    var tempArr = pattern.substring(start + 1, end).split(',');
    var after = pattern.substring(end + 1);
    prefix = prefix + pattern.substring(0, start);
    arrayLength = tempArr.length;

    while (i < arrayLength) {
      newStart = after.indexOf('{');

      if (newStart < 0) {
        callback((prefix + tempArr[i++] + after).replace(END_WITH_EACH_REGEX, '.[]'));
      } else {
        dive(prefix + tempArr[i++], after, newStart, callback);
      }
    }
  }
  /**
   @module @ember/object
  */

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change.
    If the specified property is not defined on the object and the object
    implements the `setUnknownProperty` method, then instead of setting the
    value of the property on the object, its `setUnknownProperty` handler
    will be invoked with the two parameters `keyName` and `value`.
  
    ```javascript
    import { set } from '@ember/object';
    set(obj, "name", value);
    ```
  
    @method set
    @static
    @for @ember/object
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */


  function set(obj, keyName, value$$1, tolerant) {
    (true && !(arguments.length === 3 || arguments.length === 4) && (0, _debug.assert)("Set must be called with three or four arguments; an object, a property key, a value and tolerant true/false", arguments.length === 3 || arguments.length === 4));
    (true && !(obj && typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call set with '" + keyName + "' on an undefined object.", obj && typeof obj === 'object' || typeof obj === 'function'));
    (true && !(typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)) && (0, _debug.assert)("The key provided to set must be a string or number, you passed " + keyName, typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)));
    (true && !(typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0) && (0, _debug.assert)("'this' in paths is not supported", typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0));

    if (obj.isDestroyed) {
      (true && !(tolerant) && (0, _debug.assert)("calling set on destroyed object: " + (0, _utils.toString)(obj) + "." + keyName + " = " + (0, _utils.toString)(value$$1), tolerant));
      return;
    }

    if (isPath(keyName)) {
      return setPath(obj, keyName, value$$1, tolerant);
    }

    var meta$$1 = (0, _meta2.peekMeta)(obj);
    {
      var descriptor = (0, _utils.lookupDescriptor)(obj, keyName);
      var setter = descriptor === null ? undefined : descriptor.set;

      if (setter !== undefined && CP_SETTER_FUNCS.has(setter)) {
        obj[keyName] = value$$1;
        return value$$1;
      }
    }
    var currentValue;

    if (true
    /* DEBUG */
    && _utils.HAS_NATIVE_PROXY) {
      currentValue = getPossibleMandatoryProxyValue(obj, keyName);
    } else {
      currentValue = obj[keyName];
    }

    if (currentValue === undefined && 'object' === typeof obj && !(keyName in obj) && typeof obj.setUnknownProperty === 'function') {
      /* unknown property */
      obj.setUnknownProperty(keyName, value$$1);
    } else {
      if (true
      /* DEBUG */
      ) {
        {
          (0, _utils.setWithMandatorySetter)(obj, keyName, value$$1);
        }
      } else {
        obj[keyName] = value$$1;
      }

      if (currentValue !== value$$1) {
        notifyPropertyChange(obj, keyName, meta$$1);
      }
    }

    return value$$1;
  }

  function setPath(root, path, value$$1, tolerant) {
    var parts = path.split('.');
    var keyName = parts.pop();
    (true && !(keyName.trim().length > 0) && (0, _debug.assert)('Property set failed: You passed an empty path', keyName.trim().length > 0));

    var newRoot = _getPath(root, parts);

    if (newRoot !== null && newRoot !== undefined) {
      return set(newRoot, keyName, value$$1);
    } else if (!tolerant) {
      throw new _error.default("Property set failed: object in path \"" + parts.join('.') + "\" could not be found.");
    }
  }
  /**
    Error-tolerant form of `set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    ```javascript
    import { trySet } from '@ember/object';
  
    let obj = { name: "Zoey" };
    trySet(obj, "contacts.twitter", "@emberjs");
    ```
  
    @method trySet
    @static
    @for @ember/object
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */


  function trySet(root, path, value$$1) {
    return set(root, path, value$$1, true);
  }
  /**
  @module @ember/object
  */


  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;

  function noop() {}
  /**
    `@computed` is a decorator that turns a JavaScript getter and setter into a
    computed property, which is a _cached, trackable value_. By default the getter
    will only be called once and the result will be cached. You can specify
    various properties that your computed property depends on. This will force the
    cached result to be cleared if the dependencies are modified, and lazily recomputed the next time something asks for it.
  
    In the following example we decorate a getter - `fullName` -  by calling
    `computed` with the property dependencies (`firstName` and `lastName`) as
    arguments. The `fullName` getter will be called once (regardless of how many
    times it is accessed) as long as its dependencies do not change. Once
    `firstName` or `lastName` are updated any future calls to `fullName` will
    incorporate the new values, and any watchers of the value such as templates
    will be updated:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName')
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
    });
  
    let tom = new Person('Tom', 'Dale');
  
    tom.fullName; // 'Tom Dale'
    ```
  
    You can also provide a setter, which will be used when updating the computed
    property. Ember's `set` function must be used to update the property
    since it will also notify observers of the property:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName')
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
  
      set fullName(value) {
        let [firstName, lastName] = value.split(' ');
  
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
    });
  
    let person = new Person();
  
    set(person, 'fullName', 'Peter Wagenet');
    person.firstName; // 'Peter'
    person.lastName;  // 'Wagenet'
    ```
  
    You can also pass a getter function or object with `get` and `set` functions
    as the last argument to the computed decorator. This allows you to define
    computed property _macros_:
  
    ```js
    import { computed } from '@ember/object';
  
    function join(...keys) {
      return computed(...keys, function() {
        return keys.map(key => this[key]).join(' ');
      });
    }
  
    class Person {
      @join('firstName', 'lastName')
      fullName;
    }
    ```
  
    Note that when defined this way, getters and setters receive the _key_ of the
    property they are decorating as the first argument. Setters receive the value
    they are setting to as the second argument instead. Additionally, setters must
    _return_ the value that should be cached:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    function fullNameMacro(firstNameKey, lastNameKey) {
      return computed(firstNameKey, lastNameKey, {
        get() {
          return `${this[firstNameKey]} ${this[lastNameKey]}`;
        }
  
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          set(this, firstNameKey, firstName);
          set(this, lastNameKey, lastName);
  
          return value;
        }
      });
    }
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @fullNameMacro fullName;
    });
  
    let person = new Person();
  
    set(person, 'fullName', 'Peter Wagenet');
    person.firstName; // 'Peter'
    person.lastName;  // 'Wagenet'
    ```
  
    Computed properties can also be used in classic classes. To do this, we
    provide the getter and setter as the last argument like we would for a macro,
    and we assign it to a property on the class definition. This is an _anonymous_
    computed macro:
  
    ```javascript
    import EmberObject, { computed, set } from '@ember/object';
  
    let Person = EmberObject.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: computed('firstName', 'lastName', {
        get() {
          return `${this.firstName} ${this.lastName}`;
        }
  
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          set(this, 'firstName', firstName);
          set(this, 'lastName', lastName);
  
          return value;
        }
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can overwrite computed property without setters with a normal property (no
    longer computed) that won't change if dependencies change. You can also mark
    computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName').readOnly()
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
    });
  
    let person = new Person();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [Decorators RFC](https://github.com/emberjs/rfcs/blob/master/text/0408-decorators.md)
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](https://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @public
  */


  class ComputedProperty extends ComputedDescriptor {
    constructor(args) {
      super();
      this._volatile = false;
      this._readOnly = false;
      this._suspended = undefined;
      this._hasConfig = false;
      this._getter = undefined;
      this._setter = undefined;
      var maybeConfig = args[args.length - 1];

      if (typeof maybeConfig === 'function' || maybeConfig !== null && typeof maybeConfig === 'object') {
        this._hasConfig = true;
        var config = args.pop();

        if (typeof config === 'function') {
          (true && !(!isClassicDecorator(config)) && (0, _debug.assert)("You attempted to pass a computed property instance to computed(). Computed property instances are decorator functions, and cannot be passed to computed() because they cannot be turned into decorators twice", !isClassicDecorator(config)));
          this._getter = config;
        } else {
          var objectConfig = config;
          (true && !(typeof objectConfig === 'object' && !Array.isArray(objectConfig)) && (0, _debug.assert)('computed expects a function or an object as last argument.', typeof objectConfig === 'object' && !Array.isArray(objectConfig)));
          (true && !(Object.keys(objectConfig).every(key => key === 'get' || key === 'set')) && (0, _debug.assert)('Config object passed to computed can only contain `get` and `set` keys.', Object.keys(objectConfig).every(key => key === 'get' || key === 'set')));
          (true && !(Boolean(objectConfig.get) || Boolean(objectConfig.set)) && (0, _debug.assert)('Computed properties must receive a getter or a setter, you passed none.', Boolean(objectConfig.get) || Boolean(objectConfig.set)));
          this._getter = objectConfig.get || noop;
          this._setter = objectConfig.set;
        }
      }

      if (args.length > 0) {
        this._property(...args);
      }
    }

    setup(obj, keyName, propertyDesc, meta$$1) {
      super.setup(obj, keyName, propertyDesc, meta$$1);
      (true && !(!(propertyDesc && typeof propertyDesc.value === 'function')) && (0, _debug.assert)("@computed can only be used on accessors or fields, attempted to use it with " + keyName + " but that was a method. Try converting it to a getter (e.g. `get " + keyName + "() {}`)", !(propertyDesc && typeof propertyDesc.value === 'function')));
      (true && !(!propertyDesc || !propertyDesc.initializer) && (0, _debug.assert)("@computed can only be used on empty fields. " + keyName + " has an initial value (e.g. `" + keyName + " = someValue`)", !propertyDesc || !propertyDesc.initializer));
      (true && !(!(this._hasConfig && propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function'))) && (0, _debug.assert)("Attempted to apply a computed property that already has a getter/setter to a " + keyName + ", but it is a method or an accessor. If you passed @computed a function or getter/setter (e.g. `@computed({ get() { ... } })`), then it must be applied to a field", !(this._hasConfig && propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function'))));

      if (this._hasConfig === false) {
        (true && !(propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function')) && (0, _debug.assert)("Attempted to use @computed on " + keyName + ", but it did not have a getter or a setter. You must either pass a get a function or getter/setter to @computed directly (e.g. `@computed({ get() { ... } })`) or apply @computed directly to a getter/setter", propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function')));
        var {
          get: _get,
          set: set$$1
        } = propertyDesc;

        if (_get !== undefined) {
          this._getter = _get;
        }

        if (set$$1 !== undefined) {
          this._setter = function setterWrapper(_key, value$$1) {
            var ret = set$$1.call(this, value$$1);

            if (_get !== undefined) {
              return typeof ret === 'undefined' ? _get.call(this) : ret;
            }

            return ret;
          };
        }
      }
    }
    /**
      Call on a computed property to set it into non-cached mode. When in this
      mode the computed property will not automatically cache the return value.
      It also does not automatically fire any change events. You must manually notify
      any changes if you want to observe this property.
      Dependency keys have no effect on volatile properties as they are for cache
      invalidation and notification when cached value is invalidated.
      ```javascript
      import EmberObject, { computed } from '@ember/object';
      let outsideService = EmberObject.extend({
        value: computed(function() {
          return OutsideService.getValue();
        }).volatile()
      }).create();
      ```
      @method volatile
      @return {ComputedProperty} this
      @chainable
      @public
    */


    volatile() {
      (true && !(false) && (0, _debug.deprecate)('Setting a computed property as volatile has been deprecated. Instead, consider using a native getter with native class syntax.', false, {
        id: 'computed-property.volatile',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-volatile'
      }));
      this._volatile = true;
    }
    /**
      Call on a computed property to set it into read-only mode. When in this
      mode the computed property will throw an error when set.
      ```javascript
      import EmberObject, { computed } from '@ember/object';
      let Person = EmberObject.extend({
        guid: computed(function() {
          return 'guid-guid-guid';
        }).readOnly()
      });
      let person = Person.create();
      person.set('guid', 'new-guid'); // will throw an exception
      ```
      @method readOnly
      @return {ComputedProperty} this
      @chainable
      @public
    */


    readOnly() {
      this._readOnly = true;
      (true && !(!(this._readOnly && this._setter && this._setter !== this._getter)) && (0, _debug.assert)('Computed properties that define a setter using the new syntax cannot be read-only', !(this._readOnly && this._setter && this._setter !== this._getter)));
    }
    /**
      Sets the dependent keys on this computed property. Pass any number of
      arguments containing key paths that this computed property depends on.
      ```javascript
      import EmberObject, { computed } from '@ember/object';
      let President = EmberObject.extend({
        fullName: computed('firstName', 'lastName', function() {
          return this.get('firstName') + ' ' + this.get('lastName');
          // Tell Ember that this computed property depends on firstName
          // and lastName
        })
      });
      let president = President.create({
        firstName: 'Barack',
        lastName: 'Obama'
      });
      president.get('fullName'); // 'Barack Obama'
      ```
      @method property
      @param {String} path* zero or more property paths
      @return {ComputedProperty} this
      @chainable
      @public
    */


    property(...passedArgs) {
      (true && !(false) && (0, _debug.deprecate)('Setting dependency keys using the `.property()` modifier has been deprecated. Pass the dependency keys directly to computed as arguments instead. If you are using `.property()` on a computed property macro, consider refactoring your macro to receive additional dependent keys in its initial declaration.', false, {
        id: 'computed-property.property',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-property'
      }));

      this._property(...passedArgs);
    }

    _property(...passedArgs) {
      var args = [];

      function addArg(property) {
        (true && (0, _debug.warn)("Dependent keys containing @each only work one level deep. " + ("You used the key \"" + property + "\" which is invalid. ") + "Please create an intermediary computed property.", DEEP_EACH_REGEX.test(property) === false, {
          id: 'ember-metal.computed-deep-each'
        }));
        args.push(property);
      }

      for (var i = 0; i < passedArgs.length; i++) {
        expandProperties(passedArgs[i], addArg);
      }

      this._dependentKeys = args;
    }
    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For example,
      computed property functions may close over variables that are then no longer
      available for introspection.
      You can pass a hash of these values to a computed property like this:
      ```
      import { computed } from '@ember/object';
      import Person from 'my-app/utils/person';
      person: computed(function() {
        let personId = this.get('personId');
        return Person.create({ id: personId });
      }).meta({ type: Person })
      ```
      The hash that you pass to the `meta()` function will be saved on the
      computed property descriptor under the `_meta` key. Ember runtime
      exposes a public API for retrieving these values from classes,
      via the `metaForProperty()` function.
      @method meta
      @param {Object} meta
      @chainable
      @public
    */
    // invalidate cache when CP key changes


    didChange(obj, keyName) {
      // _suspended is set via a CP.set to ensure we don't clear
      // the cached value set by the setter
      if (this._volatile || this._suspended === obj) {
        return;
      } // don't create objects just to invalidate


      var meta$$1 = (0, _meta2.peekMeta)(obj);

      if (meta$$1 === null || meta$$1.source !== obj) {
        return;
      }

      var cache = peekCacheFor(obj);

      if (cache !== undefined && cache.delete(keyName)) {
        removeDependentKeys(this, obj, keyName, meta$$1);
      }
    }

    get(obj, keyName) {
      if (this._volatile) {
        return this._getter.call(obj, keyName);
      }

      var cache = getCacheFor(obj);
      {
        var propertyTag = tagForProperty(obj, keyName);
        var ret;

        if (cache.has(keyName) && (0, _reference.validate)(propertyTag, getLastRevisionFor(obj, keyName))) {
          ret = cache.get(keyName);
        } else {
          // For backwards compatibility, we only throw if the CP has any dependencies. CPs without dependencies
          // should be allowed, even after the object has been destroyed, which is why we check _dependentKeys.
          (true && !(this._dependentKeys === undefined || !(0, _meta2.meta)(obj).isMetaDestroyed()) && (0, _debug.assert)("Attempted to access the computed " + obj + "." + keyName + " on a destroyed object, which is not allowed", this._dependentKeys === undefined || !(0, _meta2.meta)(obj).isMetaDestroyed()));
          var upstreamTag = undefined;

          if (this._auto === true) {
            upstreamTag = track(() => {
              ret = this._getter.call(obj, keyName);
            });
          } else {
            // Create a tracker that absorbs any trackable actions inside the CP
            untrack(() => {
              ret = this._getter.call(obj, keyName);
            });
          }

          finishLazyChains(obj, keyName, ret);

          if (this._dependentKeys !== undefined) {
            var tag = (0, _reference.combine)(getChainTagsForKeys(obj, this._dependentKeys));
            upstreamTag = upstreamTag === undefined ? tag : (0, _reference.combine)([upstreamTag, tag]);
          }

          if (upstreamTag !== undefined) {
            (0, _reference.update)(propertyTag, upstreamTag);
          }

          setLastRevisionFor(obj, keyName, (0, _reference.value)(propertyTag));
        }

        consume(propertyTag); // Add the tag of the returned value if it is an array, since arrays
        // should always cause updates if they are consumed and then changed

        if (Array.isArray(ret) || (0, _utils.isEmberArray)(ret)) {
          consume(tagForProperty(ret, '[]'));
        }

        cache.set(keyName, ret);
        return ret;
      }
    }

    set(obj, keyName, value$$1) {
      if (this._readOnly) {
        this._throwReadOnlyError(obj, keyName);
      }

      if (!this._setter) {
        return this.clobberSet(obj, keyName, value$$1);
      }

      if (this._volatile) {
        return this.volatileSet(obj, keyName, value$$1);
      }

      {
        var ret;

        try {
          beginPropertyChanges();
          ret = this._set(obj, keyName, value$$1);
          finishLazyChains(obj, keyName, ret);
          var propertyTag = tagForProperty(obj, keyName);

          if (this._dependentKeys !== undefined) {
            (0, _reference.update)(propertyTag, (0, _reference.combine)(getChainTagsForKeys(obj, this._dependentKeys)));
          }

          setLastRevisionFor(obj, keyName, (0, _reference.value)(propertyTag));
        } finally {
          endPropertyChanges();
        }

        return ret;
      }
    }

    _throwReadOnlyError(obj, keyName) {
      throw new _error.default("Cannot set read-only property \"" + keyName + "\" on object: " + (0, _utils.inspect)(obj));
    }

    clobberSet(obj, keyName, value$$1) {
      (true && !(false) && (0, _debug.deprecate)("The " + (0, _utils.toString)(obj) + "#" + keyName + " computed property was just overriden. This removes the computed property and replaces it with a plain value, and has been deprecated. If you want this behavior, consider defining a setter which does it manually.", false, {
        id: 'computed-property.override',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-override'
      }));
      var cachedValue = getCachedValueFor(obj, keyName);
      defineProperty(obj, keyName, null, cachedValue);
      set(obj, keyName, value$$1);
      return value$$1;
    }

    volatileSet(obj, keyName, value$$1) {
      return this._setter.call(obj, keyName, value$$1);
    }

    setWithSuspend(obj, keyName, value$$1) {
      var oldSuspended = this._suspended;
      this._suspended = obj;

      try {
        return this._set(obj, keyName, value$$1);
      } finally {
        this._suspended = oldSuspended;
      }
    }

    _set(obj, keyName, value$$1) {
      var cache = getCacheFor(obj);
      var hadCachedValue = cache.has(keyName);
      var cachedValue = cache.get(keyName);
      var ret;
      {
        setObserverSuspended(obj, keyName, true);

        try {
          ret = this._setter.call(obj, keyName, value$$1, cachedValue);
        } finally {
          setObserverSuspended(obj, keyName, false);
        }
      } // allows setter to return the same value that is cached already

      if (hadCachedValue && cachedValue === ret) {
        return ret;
      }

      var meta$$1 = (0, _meta2.meta)(obj);
      cache.set(keyName, ret);
      notifyPropertyChange(obj, keyName, meta$$1);
      return ret;
    }
    /* called before property is overridden */


    teardown(obj, keyName, meta$$1) {
      if (!this._volatile) {
        var cache = peekCacheFor(obj);

        if (cache !== undefined && cache.delete(keyName)) {
          removeDependentKeys(this, obj, keyName, meta$$1);
        }
      }

      super.teardown(obj, keyName, meta$$1);
    }

  }

  _exports.ComputedProperty = ComputedProperty;
  {
    ComputedProperty.prototype.auto = function () {
      this._auto = true;
    };
  } // TODO: This class can be svelted once `meta` has been deprecated

  class ComputedDecoratorImpl extends Function {
    readOnly() {
      descriptorForDecorator(this).readOnly();
      return this;
    }

    volatile() {
      descriptorForDecorator(this).volatile();
      return this;
    }

    property(...keys) {
      descriptorForDecorator(this).property(...keys);
      return this;
    }

    meta(meta$$1) {
      var prop = descriptorForDecorator(this);

      if (arguments.length === 0) {
        return prop._meta || {};
      } else {
        prop._meta = meta$$1;
        return this;
      }
    } // TODO: Remove this when we can provide alternatives in the ecosystem to
    // addons such as ember-macro-helpers that use it.


    get _getter() {
      return descriptorForDecorator(this)._getter;
    } // TODO: Refactor this, this is an internal API only


    set enumerable(value$$1) {
      descriptorForDecorator(this).enumerable = value$$1;
    }

  }

  function computed(...args) {
    (true && !(!(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)) && (0, _debug.assert)("@computed can only be used directly as a native decorator. If you're using tracked in classic classes, add parenthesis to call it like a function: computed()", !(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)));

    if (isElementDescriptor(args)) {
      var decorator = makeComputedDecorator(new ComputedProperty([]), ComputedDecoratorImpl);
      return decorator(args[0], args[1], args[2]);
    }

    return makeComputedDecorator(new ComputedProperty(args), ComputedDecoratorImpl);
  }
  /**
    Allows checking if a given property on an object is a computed property. For the most part,
    this doesn't matter (you would normally just access the property directly and use its value),
    but for some tooling specific scenarios (e.g. the ember-inspector) it is important to
    differentiate if a property is a computed property or a "normal" property.
  
    This will work on either a class's prototype or an instance itself.
  
    @static
    @method isComputed
    @for @ember/debug
    @private
   */


  function isComputed(obj, key) {
    return Boolean(descriptorForProperty(obj, key));
  }

  var _globalsComputed = computed.bind(null);

  _exports._globalsComputed = _globalsComputed;
  var CONSUMED = Object.freeze({});

  function alias(altKey) {
    (true && !(!isElementDescriptor(Array.prototype.slice.call(arguments))) && (0, _debug.assert)('You attempted to use @alias as a decorator directly, but it requires a `altKey` parameter', !isElementDescriptor(Array.prototype.slice.call(arguments))));
    return makeComputedDecorator(new AliasedProperty(altKey), AliasDecoratorImpl);
  } // TODO: This class can be svelted once `meta` has been deprecated


  class AliasDecoratorImpl extends Function {
    readOnly() {
      descriptorForDecorator(this).readOnly();
      return this;
    }

    oneWay() {
      descriptorForDecorator(this).oneWay();
      return this;
    }

    meta(meta$$1) {
      var prop = descriptorForDecorator(this);

      if (arguments.length === 0) {
        return prop._meta || {};
      } else {
        prop._meta = meta$$1;
      }
    }

  }

  class AliasedProperty extends ComputedDescriptor {
    constructor(altKey) {
      super();
      this.altKey = altKey;
    }

    setup(obj, keyName, propertyDesc, meta$$1) {
      (true && !(this.altKey !== keyName) && (0, _debug.assert)("Setting alias '" + keyName + "' on self", this.altKey !== keyName));
      super.setup(obj, keyName, propertyDesc, meta$$1);
    }

    teardown(obj, keyName, meta$$1) {
      super.teardown(obj, keyName, meta$$1);
    }

    willWatch(obj, keyName, meta$$1) {}

    get(obj, keyName) {
      var ret;
      {
        var propertyTag = tagForProperty(obj, keyName); // We don't use the tag since CPs are not automatic, we just want to avoid
        // anything tracking while we get the altKey

        untrack(() => {
          ret = get(obj, this.altKey);
        });
        var lastRevision = getLastRevisionFor(obj, keyName);

        if (!(0, _reference.validate)(propertyTag, lastRevision)) {
          (0, _reference.update)(propertyTag, (0, _reference.combine)(getChainTagsForKey(obj, this.altKey)));
          setLastRevisionFor(obj, keyName, (0, _reference.value)(propertyTag));
          finishLazyChains(obj, keyName, ret);
        }

        consume(propertyTag);
      }
      return ret;
    }

    unconsume(obj, keyName, meta$$1) {
      var wasConsumed = getCachedValueFor(obj, keyName) === CONSUMED;

      if (wasConsumed || meta$$1.peekWatching(keyName) > 0) {
        removeDependentKeys(this, obj, keyName, meta$$1);
      }

      if (wasConsumed) {
        getCacheFor(obj).delete(keyName);
      }
    }

    consume(obj, keyName, meta$$1) {
      var cache = getCacheFor(obj);

      if (cache.get(keyName) !== CONSUMED) {
        cache.set(keyName, CONSUMED);
        addDependentKeys(this, obj, keyName, meta$$1);
      }
    }

    set(obj, _keyName, value$$1) {
      return set(obj, this.altKey, value$$1);
    }

    readOnly() {
      this.set = AliasedProperty_readOnlySet;
    }

    oneWay() {
      this.set = AliasedProperty_oneWaySet;
    }

  }

  function AliasedProperty_readOnlySet(obj, keyName) {
    // eslint-disable-line no-unused-vars
    throw new _error.default("Cannot set read-only property '" + keyName + "' on object: " + (0, _utils.inspect)(obj));
  }

  function AliasedProperty_oneWaySet(obj, keyName, value$$1) {
    defineProperty(obj, keyName, null);
    return set(obj, keyName, value$$1);
  }
  /**
  @module ember
  */

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */


  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {
      (true && !(false) && (0, _debug.deprecate)("Usage of `" + deprecatedKey + "` is deprecated, use `" + newKey + "` instead.", false, options));
    }

    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,

      set(value$$1) {
        _deprecate();

        set(this, newKey, value$$1);
      },

      get() {
        _deprecate();

        return get(this, newKey);
      }

    });
  }
  /**
   @module @ember/utils
  */

  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    isNone();              // true
    isNone(null);          // true
    isNone(undefined);     // true
    isNone('');            // false
    isNone([]);            // false
    isNone(function() {}); // false
    ```
  
    @method isNone
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */


  function isNone(obj) {
    return obj === null || obj === undefined;
  }
  /**
   @module @ember/utils
  */

  /**
    Verifies that a value is `null` or `undefined`, an empty string, or an empty
    array.
  
    Constrains the rules on `isNone` by returning true for empty strings and
    empty arrays.
  
    If the value is an object with a `size` property of type number, it is used
    to check emptiness.
  
    ```javascript
    isEmpty();                 // true
    isEmpty(null);             // true
    isEmpty(undefined);        // true
    isEmpty('');               // true
    isEmpty([]);               // true
    isEmpty({ size: 0});       // true
    isEmpty({});               // false
    isEmpty('Adam Hawkins');   // false
    isEmpty([0,1,2]);          // false
    isEmpty('\n\t');           // false
    isEmpty('  ');             // false
    isEmpty({ size: 1 })       // false
    isEmpty({ size: () => 0 }) // false
    ```
  
    @method isEmpty
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */


  function isEmpty(obj) {
    var none = obj === null || obj === undefined;

    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = get(obj, 'size');

      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var length = get(obj, 'length');

      if (typeof length === 'number') {
        return !length;
      }
    }

    return false;
  }
  /**
   @module @ember/utils
  */

  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    import { isBlank } from '@ember/utils';
  
    isBlank();                // true
    isBlank(null);            // true
    isBlank(undefined);       // true
    isBlank('');              // true
    isBlank([]);              // true
    isBlank('\n\t');          // true
    isBlank('  ');            // true
    isBlank({});              // false
    isBlank('\n\t Hello');    // false
    isBlank('Hello world');   // false
    isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */


  function isBlank(obj) {
    return isEmpty(obj) || typeof obj === 'string' && /\S/.test(obj) === false;
  }
  /**
   @module @ember/utils
  */

  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    isPresent();                // false
    isPresent(null);            // false
    isPresent(undefined);       // false
    isPresent('');              // false
    isPresent('  ');            // false
    isPresent('\n\t');          // false
    isPresent([]);              // false
    isPresent({ length: 0 });   // false
    isPresent(false);           // true
    isPresent(true);            // true
    isPresent('string');        // true
    isPresent(0);               // true
    isPresent(function() {});   // true
    isPresent({});              // true
    isPresent('\n\t Hello');    // true
    isPresent([1, 2, 3]);       // true
    ```
  
    @method isPresent
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */


  function isPresent(obj) {
    return !isBlank(obj);
  }
  /**
   @module ember
  */

  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */


  class Libraries {
    constructor() {
      this._registry = [];
      this._coreLibIndex = 0;
    }

    _getLibraryByName(name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }

      return undefined;
    }

    register(name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }

        this._registry.splice(index, 0, {
          name,
          version
        });
      } else {
        (true && (0, _debug.warn)("Library \"" + name + "\" is already registered with Ember.", false, {
          id: 'ember-metal.libraries-register'
        }));
      }
    }

    registerCoreLibrary(name, version) {
      this.register(name, version, true);
    }

    deRegister(name) {
      var lib = this._getLibraryByName(name);

      var index;

      if (lib) {
        index = this._registry.indexOf(lib);

        this._registry.splice(index, 1);
      }
    }

  }

  _exports.Libraries = Libraries;

  if (_canaryFeatures.EMBER_LIBRARIES_ISREGISTERED) {
    Libraries.prototype.isRegistered = function (name) {
      return Boolean(this._getLibraryByName(name));
    };
  }

  if (true
  /* DEBUG */
  ) {
    Libraries.prototype.logVersions = function () {
      var libs = this._registry;
      var nameLengths = libs.map(item => get(item, 'name.length'));
      var maxNameLength = Math.max.apply(null, nameLengths);
      (0, _debug.debug)('-------------------------------');

      for (var i = 0; i < libs.length; i++) {
        var lib = libs[i];
        var spaces = new Array(maxNameLength - lib.name.length + 1).join(' ');
        (0, _debug.debug)([lib.name, spaces, ' : ', lib.version].join(''));
      }

      (0, _debug.debug)('-------------------------------');
    };
  }

  var LIBRARIES = new Libraries();
  _exports.libraries = LIBRARIES;
  LIBRARIES.registerCoreLibrary('Ember', _version.default);
  /**
   @module @ember/object
  */

  /**
    To get multiple properties at once, call `getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @static
    @for @ember/object
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */

  function getProperties(obj, keys) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && Array.isArray(keys)) {
      i = 0;
      propertyNames = arguments[1];
    }

    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = get(obj, propertyNames[i]);
    }

    return ret;
  }
  /**
   @module @ember/object
  */

  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    import EmberObject from '@ember/object';
    let anObject = EmberObject.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @static
    @for @ember/object
    @param obj
    @param {Object} properties
    @return properties
    @public
  */


  function setProperties(obj, properties) {
    if (properties === null || typeof properties !== 'object') {
      return properties;
    }

    changeProperties(() => {
      var props = Object.keys(properties);
      var propertyName;

      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];
        set(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  } // move into its own package
  // it is needed by Mixin for classToString
  // maybe move it into environment


  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var searchDisabled = false;
  var flags = {
    _set: 0,
    _unprocessedNamespaces: false,

    get unprocessedNamespaces() {
      return this._unprocessedNamespaces;
    },

    set unprocessedNamespaces(v) {
      this._set++;
      this._unprocessedNamespaces = v;
    }

  };
  var unprocessedMixins = false;
  var NAMESPACES = [];
  _exports.NAMESPACES = NAMESPACES;
  var NAMESPACES_BY_ID = Object.create(null);
  _exports.NAMESPACES_BY_ID = NAMESPACES_BY_ID;

  function addNamespace(namespace) {
    flags.unprocessedNamespaces = true;
    NAMESPACES.push(namespace);
  }

  function removeNamespace(namespace) {
    var name = (0, _utils.getName)(namespace);
    delete NAMESPACES_BY_ID[name];
    NAMESPACES.splice(NAMESPACES.indexOf(namespace), 1);

    if (name in _environment.context.lookup && namespace === _environment.context.lookup[name]) {
      _environment.context.lookup[name] = undefined;
    }
  }

  function findNamespaces() {
    if (!flags.unprocessedNamespaces) {
      return;
    }

    var lookup = _environment.context.lookup;
    var keys = Object.keys(lookup);

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i]; // Only process entities that start with uppercase A-Z

      if (!isUppercase(key.charCodeAt(0))) {
        continue;
      }

      var obj = tryIsNamespace(lookup, key);

      if (obj) {
        (0, _utils.setName)(obj, key);
      }
    }
  }

  function findNamespace(name) {
    if (!searchDisabled) {
      processAllNamespaces();
    }

    return NAMESPACES_BY_ID[name];
  }

  function processNamespace(namespace) {
    _processNamespace([namespace.toString()], namespace, new Set());
  }

  function processAllNamespaces() {
    var unprocessedNamespaces = flags.unprocessedNamespaces;

    if (unprocessedNamespaces) {
      findNamespaces();
      flags.unprocessedNamespaces = false;
    }

    if (unprocessedNamespaces || unprocessedMixins) {
      var namespaces = NAMESPACES;

      for (var i = 0; i < namespaces.length; i++) {
        processNamespace(namespaces[i]);
      }

      unprocessedMixins = false;
    }
  }

  function classToString() {
    var name = (0, _utils.getName)(this);

    if (name !== void 0) {
      return name;
    }

    name = calculateToString(this);
    (0, _utils.setName)(this, name);
    return name;
  }

  function isSearchDisabled() {
    return searchDisabled;
  }

  function setSearchDisabled(flag) {
    searchDisabled = Boolean(flag);
  }

  function setUnprocessedMixins() {
    unprocessedMixins = true;
  }

  function _processNamespace(paths, root, seen) {
    var idx = paths.length;
    var id = paths.join('.');
    NAMESPACES_BY_ID[id] = root;
    (0, _utils.setName)(root, id); // Loop over all of the keys in the namespace, looking for classes

    for (var key in root) {
      if (!hasOwnProperty.call(root, key)) {
        continue;
      }

      var obj = root[key]; // If we are processing the `Ember` namespace, for example, the
      // `paths` will start with `["Ember"]`. Every iteration through
      // the loop will update the **second** element of this list with
      // the key, so processing `Ember.View` will make the Array
      // `['Ember', 'View']`.

      paths[idx] = key; // If we have found an unprocessed class

      if (obj && obj.toString === classToString && (0, _utils.getName)(obj) === void 0) {
        // Replace the class' `toString` with the dot-separated path
        (0, _utils.setName)(obj, paths.join('.')); // Support nested namespaces
      } else if (obj && obj.isNamespace) {
        // Skip aliased namespaces
        if (seen.has(obj)) {
          continue;
        }

        seen.add(obj); // Process the child namespace

        _processNamespace(paths, obj, seen);
      }
    }

    paths.length = idx; // cut out last item
  }

  function isUppercase(code) {
    return code >= 65 && code <= 90 // A
    ; // Z
  }

  function tryIsNamespace(lookup, prop) {
    try {
      var obj = lookup[prop];
      return (obj !== null && typeof obj === 'object' || typeof obj === 'function') && obj.isNamespace && obj;
    } catch (e) {// continue
    }
  }

  function calculateToString(target) {
    var str;

    if (!searchDisabled) {
      processAllNamespaces();
      str = (0, _utils.getName)(target);

      if (str !== void 0) {
        return str;
      }

      var superclass = target;

      do {
        superclass = Object.getPrototypeOf(superclass);

        if (superclass === Function.prototype || superclass === Object.prototype) {
          break;
        }

        str = (0, _utils.getName)(target);

        if (str !== void 0) {
          str = "(subclass of " + str + ")";
          break;
        }
      } while (str === void 0);
    }

    return str || '(unknown)';
  }
  /**
  @module @ember/object
  */


  var a_concat = Array.prototype.concat;
  var {
    isArray
  } = Array;

  function isMethod(obj) {
    return 'function' === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  function isAccessor(desc) {
    return typeof desc.get === 'function' || typeof desc.set === 'function';
  }

  function extractAccessors(properties) {
    if (properties !== undefined) {
      var descriptors = (0, _utils.getOwnPropertyDescriptors)(properties);
      var keys = Object.keys(descriptors);
      var hasAccessors = keys.some(key => isAccessor(descriptors[key]));

      if (hasAccessors) {
        var extracted = {};
        keys.forEach(key => {
          var descriptor = descriptors[key];

          if (isAccessor(descriptor)) {
            extracted[key] = nativeDescDecorator(descriptor);
          } else {
            extracted[key] = properties[key];
          }
        });
        return extracted;
      }
    }

    return properties;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    if (mixin instanceof Mixin) {
      if (mixinsMeta.hasMixin(mixin)) {
        return CONTINUE;
      }

      mixinsMeta.addMixin(mixin);
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    // reset before adding each new mixin to pickup concats from previous
    var concats = values[concatProp] || base[concatProp];

    if (props[concatProp]) {
      concats = concats ? a_concat.call(concats, props[concatProp]) : props[concatProp];
    }

    return concats;
  }

  function giveDecoratorSuper(meta$$1, key, decorator, values, descs, base) {
    var property = descriptorForDecorator(decorator);
    var superProperty;

    if (!(property instanceof ComputedProperty) || property._getter === undefined) {
      return decorator;
    } // Computed properties override methods, and do not call super to them


    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descriptorForDecorator(descs[key]);
    } // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.


    if (!superProperty) {
      superProperty = descriptorForProperty(base, key, meta$$1);
    }

    if (superProperty === undefined || !(superProperty instanceof ComputedProperty)) {
      return decorator;
    }

    var get = (0, _utils.wrap)(property._getter, superProperty._getter);
    var set;

    if (superProperty._setter) {
      if (property._setter) {
        set = (0, _utils.wrap)(property._setter, superProperty._setter);
      } else {
        // If the super property has a setter, we default to using it no matter what.
        // This is clearly very broken and weird, but it's what was here so we have
        // to keep it until the next major at least.
        //
        // TODO: Add a deprecation here.
        set = superProperty._setter;
      }
    } else {
      set = property._setter;
    } // only create a new CP if we must


    if (get !== property._getter || set !== property._setter) {
      // Since multiple mixins may inherit from the same parent, we need
      // to clone the computed property so that other mixins do not receive
      // the wrapped version.
      var newProperty = Object.create(property);
      newProperty._getter = get;
      newProperty._setter = set;
      return makeComputedDecorator(newProperty, ComputedProperty);
    }

    return decorator;
  }

  function giveMethodSuper(obj, key, method, values, descs) {
    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] !== undefined) {
      return method;
    } // Find the original method in a parent mixin


    var superMethod = values[key]; // If we didn't find the original value in a parent mixin, find it in
    // the original object

    if (superMethod === undefined && descriptorForProperty(obj, key) === undefined) {
      superMethod = obj[key];
    } // Only wrap the new method if the original method was a function


    if (typeof superMethod === 'function') {
      return (0, _utils.wrap)(method, superMethod);
    }

    return method;
  }

  function applyConcatenatedProperties(obj, key, value$$1, values) {
    var baseValue = values[key] || obj[key];
    var ret = (0, _utils.makeArray)(baseValue).concat((0, _utils.makeArray)(value$$1));

    if (true
    /* DEBUG */
    ) {
      // it is possible to use concatenatedProperties with strings (which cannot be frozen)
      // only freeze objects...
      if (typeof ret === 'object' && ret !== null) {
        // prevent mutating `concatenatedProperties` array after it is applied
        Object.freeze(ret);
      }
    }

    return ret;
  }

  function applyMergedProperties(obj, key, value$$1, values) {
    var baseValue = values[key] || obj[key];
    (true && !(!isArray(value$$1)) && (0, _debug.assert)("You passed in `" + JSON.stringify(value$$1) + "` as the value for `" + key + "` but `" + key + "` cannot be an Array", !isArray(value$$1)));

    if (!baseValue) {
      return value$$1;
    }

    var newBase = (0, _polyfills.assign)({}, baseValue);
    var hasFunction = false;

    for (var prop in value$$1) {
      if (!value$$1.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value$$1[prop];

      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = _utils.ROOT;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value$$1, meta$$1, descs, values, concats, mergings) {
    if (isClassicDecorator(value$$1)) {
      // Wrap descriptor function to implement _super() if needed
      descs[key] = giveDecoratorSuper(meta$$1, key, value$$1, values, descs, base);
      values[key] = undefined;
    } else {
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value$$1 = applyConcatenatedProperties(base, key, value$$1, values);
      } else if (mergings && mergings.indexOf(key) > -1) {
        value$$1 = applyMergedProperties(base, key, value$$1, values);
      } else if (isMethod(value$$1)) {
        value$$1 = giveMethodSuper(base, key, value$$1, values, descs);
      }

      descs[key] = undefined;
      values[key] = value$$1;
    }
  }

  function mergeMixins(mixins, meta$$1, descs, values, base, keys) {
    var currentMixin, props, key, concats, mergings;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];
      (true && !(typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]') && (0, _debug.assert)("Expected hash or Mixin instance, got " + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]'));
      props = mixinProperties(meta$$1, currentMixin);

      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        // remove willMergeMixin after 3.4 as it was used for _actions
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }

        concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
        mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }

          keys.push(key);
          addNormalizedProperty(base, key, props[key], meta$$1, descs, values, concats, mergings);
        } // manually copy toString() because some JS engines do not enumerate it


        if (props.hasOwnProperty('toString')) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, meta$$1, descs, values, base, keys);

        if (currentMixin._without) {
          currentMixin._without.forEach(removeKeys);
        }
      }
    }
  }

  var followMethodAlias;

  if (_deprecatedFeatures.ALIAS_METHOD) {
    followMethodAlias = function (obj, alias, descs, values) {
      var altKey = alias.methodName;
      var possibleDesc;
      var desc = descs[altKey];
      var value$$1 = values[altKey];

      if (desc !== undefined || value$$1 !== undefined) {// do nothing
      } else if ((possibleDesc = descriptorForProperty(obj, altKey)) !== undefined) {
        desc = possibleDesc;
        value$$1 = undefined;
      } else {
        desc = undefined;
        value$$1 = obj[altKey];
      }

      return {
        desc,
        value: value$$1
      };
    };
  }

  function updateObserversAndListeners(obj, key, fn, add) {
    var observers = (0, _utils.getObservers)(fn);
    var listeners = (0, _utils.getListeners)(fn);

    if (observers !== undefined) {
      var updateObserver = add ? addObserver : removeObserver;

      for (var i = 0; i < observers.paths.length; i++) {
        updateObserver(obj, observers.paths[i], null, key, observers.sync);
      }
    }

    if (listeners !== undefined) {
      var updateListener = add ? addListener : removeListener;

      for (var _i2 = 0; _i2 < listeners.length; _i2++) {
        updateListener(obj, listeners[_i2], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, prev, next) {
    if (typeof prev === 'function') {
      updateObserversAndListeners(obj, key, prev, false);
    }

    if (typeof next === 'function') {
      updateObserversAndListeners(obj, key, next, true);
    }
  }

  function applyMixin(obj, mixins) {
    var descs = {};
    var values = {};
    var meta$$1 = (0, _meta2.meta)(obj);
    var keys = [];
    var key, value$$1, desc;
    obj._super = _utils.ROOT; // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers

    mergeMixins(mixins, meta$$1, descs, values, obj, keys);

    for (var i = 0; i < keys.length; i++) {
      key = keys[i];

      if (key === 'constructor' || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value$$1 = values[key];

      if (_deprecatedFeatures.ALIAS_METHOD) {
        while (value$$1 && value$$1 instanceof AliasImpl) {
          var followed = followMethodAlias(obj, value$$1, descs, values);
          desc = followed.desc;
          value$$1 = followed.value;
        }
      }

      if (desc === undefined && value$$1 === undefined) {
        continue;
      }

      if (descriptorForProperty(obj, key) !== undefined) {
        replaceObserversAndListeners(obj, key, null, value$$1);
      } else {
        replaceObserversAndListeners(obj, key, obj[key], value$$1);
      }

      defineProperty(obj, key, desc, value$$1, meta$$1);
    }

    return obj;
  }
  /**
    @method mixin
    @param obj
    @param mixins*
    @return obj
    @private
  */


  function mixin(obj, ...args) {
    applyMixin(obj, args);
    return obj;
  }
  /**
    The `Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    import Mixin from '@ember/object/mixin';
  
    const EditableMixin = Mixin.create({
      edit() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
    ```
  
    ```javascript
    import EmberObject from '@ember/object';
    import EditableMixin from '../mixins/editable';
  
    // Mix mixins into classes by passing them as the first arguments to
    // `.extend.`
    const Comment = EmberObject.extend(EditableMixin, {
      post: null
    });
  
    let comment = Comment.create({
      post: somePost
    });
  
    comment.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Mixin.create`, not
    `Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    // filters array will be shared amongst any object implementing mixin
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    const FilterableMixin = Mixin.create({
      filters: A()
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
    import { computed } from '@ember/object';
  
    // filters will be a separate array for every object implementing the mixin
    const FilterableMixin = Mixin.create({
      filters: computed(function() {
        return A();
      })
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    // filters will be created as a separate array during the object's initialization
    const Filterable = Mixin.create({
      filters: null,
  
      init() {
        this._super(...arguments);
        this.set("filters", A());
      }
    });
    ```
  
    @class Mixin
    @public
  */


  class Mixin {
    constructor(mixins, properties) {
      this.properties = extractAccessors(properties);
      this.mixins = buildMixinsArray(mixins);
      this.ownerConstructor = undefined;
      this._without = undefined;

      if (true
      /* DEBUG */
      ) {
        /*
          In debug builds, we seal mixins to help avoid performance pitfalls.
                 In IE11 there is a quirk that prevents sealed objects from being added
          to a WeakMap. Unfortunately, the mixin system currently relies on
          weak maps in `guidFor`, so we need to prime the guid cache weak map.
        */
        (0, _utils.guidFor)(this);
        Object.seal(this);
      }
    }
    /**
      @method create
      @for @ember/object/mixin
      @static
      @param arguments*
      @public
    */


    static create(...args) {
      // ES6TODO: this relies on a global state?
      setUnprocessedMixins();
      var M = this;
      return new M(args, undefined);
    } // returns the mixins currently applied to the specified object
    // TODO: Make `mixin`


    static mixins(obj) {
      var meta$$1 = (0, _meta2.peekMeta)(obj);
      var ret = [];

      if (meta$$1 === null) {
        return ret;
      }

      meta$$1.forEachMixins(currentMixin => {
        // skip primitive mixins since these are always anonymous
        if (!currentMixin.properties) {
          ret.push(currentMixin);
        }
      });
      return ret;
    }
    /**
      @method reopen
      @param arguments*
      @private
    */


    reopen(...args) {
      if (args.length === 0) {
        return;
      }

      if (this.properties) {
        var currentMixin = new Mixin(undefined, this.properties);
        this.properties = undefined;
        this.mixins = [currentMixin];
      } else if (!this.mixins) {
        this.mixins = [];
      }

      this.mixins = this.mixins.concat(buildMixinsArray(args));
      return this;
    }
    /**
      @method apply
      @param obj
      @return applied object
      @private
    */


    apply(obj) {
      return applyMixin(obj, [this]);
    }

    applyPartial(obj) {
      return applyMixin(obj, [this]);
    }
    /**
      @method detect
      @param obj
      @return {Boolean}
      @private
    */


    detect(obj) {
      if (typeof obj !== 'object' || obj === null) {
        return false;
      }

      if (obj instanceof Mixin) {
        return _detect(obj, this);
      }

      var meta$$1 = (0, _meta2.peekMeta)(obj);

      if (meta$$1 === null) {
        return false;
      }

      return meta$$1.hasMixin(this);
    }

    without(...args) {
      var ret = new Mixin([this]);
      ret._without = args;
      return ret;
    }

    keys() {
      return _keys(this);
    }

    toString() {
      return '(unknown mixin)';
    }

  }

  _exports.Mixin = Mixin;

  function buildMixinsArray(mixins) {
    var length = mixins && mixins.length || 0;
    var m = undefined;

    if (length > 0) {
      m = new Array(length);

      for (var i = 0; i < length; i++) {
        var x = mixins[i];
        (true && !(typeof x === 'object' && x !== null && Object.prototype.toString.call(x) !== '[object Array]') && (0, _debug.assert)("Expected hash or Mixin instance, got " + Object.prototype.toString.call(x), typeof x === 'object' && x !== null && Object.prototype.toString.call(x) !== '[object Array]'));

        if (x instanceof Mixin) {
          m[i] = x;
        } else {
          m[i] = new Mixin(undefined, x);
        }
      }
    }

    return m;
  }

  Mixin.prototype.toString = classToString;

  if (true
  /* DEBUG */
  ) {
    Object.seal(Mixin.prototype);
  }

  function _detect(curMixin, targetMixin, seen = new Set()) {
    if (seen.has(curMixin)) {
      return false;
    }

    seen.add(curMixin);

    if (curMixin === targetMixin) {
      return true;
    }

    var mixins = curMixin.mixins;

    if (mixins) {
      return mixins.some(mixin => _detect(mixin, targetMixin, seen));
    }

    return false;
  }

  function _keys(mixin, ret = new Set(), seen = new Set()) {
    if (seen.has(mixin)) {
      return;
    }

    seen.add(mixin);

    if (mixin.properties) {
      var props = Object.keys(mixin.properties);

      for (var i = 0; i < props.length; i++) {
        ret.add(props[i]);
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(x => _keys(x, ret, seen));
    }

    return ret;
  }

  var AliasImpl;

  if (_deprecatedFeatures.ALIAS_METHOD) {
    AliasImpl = class AliasImpl {
      constructor(methodName) {
        this.methodName = methodName;
      }

    };
  }
  /**
    Makes a method available via an additional name.
  
    ```app/utils/person.js
    import EmberObject, {
      aliasMethod
    } from '@ember/object';
  
    export default EmberObject.extend({
      name() {
        return 'Tomhuda Katzdale';
      },
      moniker: aliasMethod('name')
    });
    ```
  
    ```javascript
    let goodGuy = Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @static
    @deprecated Use a shared utility method instead
    @for @ember/object
    @param {String} methodName name of the method to alias
    @public
  */


  var aliasMethod;
  _exports.aliasMethod = aliasMethod;

  if (_deprecatedFeatures.ALIAS_METHOD) {
    _exports.aliasMethod = aliasMethod = function aliasMethod(methodName) {
      (true && !(false) && (0, _debug.deprecate)("You attempted to alias '" + methodName + ", but aliasMethod has been deprecated. Consider extracting the method into a shared utility function.", false, {
        id: 'object.alias-method',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_object-alias-method'
      }));
      return new AliasImpl(methodName);
    };
  }

  function observer(...args) {
    var funcOrDef = args.pop();
    (true && !(typeof funcOrDef === 'function' || typeof funcOrDef === 'object' && funcOrDef !== null) && (0, _debug.assert)('observer must be provided a function or an observer definition', typeof funcOrDef === 'function' || typeof funcOrDef === 'object' && funcOrDef !== null));
    var func, dependentKeys, sync;

    if (typeof funcOrDef === 'function') {
      func = funcOrDef;
      dependentKeys = args;
      sync = !_environment.ENV._DEFAULT_ASYNC_OBSERVERS;
    } else {
      func = funcOrDef.fn;
      dependentKeys = funcOrDef.dependentKeys;
      sync = funcOrDef.sync;
    }

    (true && !(typeof func === 'function') && (0, _debug.assert)('observer called without a function', typeof func === 'function'));
    (true && !(Array.isArray(dependentKeys) && dependentKeys.length > 0 && dependentKeys.every(p => typeof p === 'string' && Boolean(p.length))) && (0, _debug.assert)('observer called without valid path', Array.isArray(dependentKeys) && dependentKeys.length > 0 && dependentKeys.every(p => typeof p === 'string' && Boolean(p.length))));
    (true && !(typeof sync === 'boolean') && (0, _debug.assert)('observer called without sync', typeof sync === 'boolean'));
    var paths = [];

    var addWatchedProperty = path => paths.push(path);

    for (var i = 0; i < dependentKeys.length; ++i) {
      expandProperties(dependentKeys[i], addWatchedProperty);
    }

    (0, _utils.setObservers)(func, {
      paths,
      sync
    });
    return func;
  }

  var DEBUG_INJECTION_FUNCTIONS;
  _exports.DEBUG_INJECTION_FUNCTIONS = DEBUG_INJECTION_FUNCTIONS;

  if (true
  /* DEBUG */
  ) {
    _exports.DEBUG_INJECTION_FUNCTIONS = DEBUG_INJECTION_FUNCTIONS = new WeakMap();
  }

  function inject(type, ...args) {
    (true && !(typeof type === 'string') && (0, _debug.assert)('a string type must be provided to inject', typeof type === 'string'));
    var calledAsDecorator = isElementDescriptor(args);
    var source, namespace;
    var name = calledAsDecorator ? undefined : args[0];
    var options = calledAsDecorator ? undefined : args[1];

    var getInjection = function (propertyName) {
      var owner = (0, _owner.getOwner)(this) || this.container; // fallback to `container` for backwards compat

      (true && !(Boolean(owner)) && (0, _debug.assert)("Attempting to lookup an injected property on an object without a container, ensure that the object was instantiated via a container.", Boolean(owner)));
      return owner.lookup(type + ":" + (name || propertyName), {
        source,
        namespace
      });
    };

    if (true
    /* DEBUG */
    ) {
      DEBUG_INJECTION_FUNCTIONS.set(getInjection, {
        namespace,
        source,
        type,
        name
      });
    }

    var decorator = computed({
      get: getInjection,

      set(keyName, value$$1) {
        defineProperty(this, keyName, null, value$$1);
      }

    });

    if (calledAsDecorator) {
      return decorator(args[0], args[1], args[2]);
    } else {
      return decorator;
    }
  }
});
define("@ember/-internals/owner/index", ["exports", "@ember/-internals/utils"], function (_exports, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getOwner = getOwner;
  _exports.setOwner = setOwner;
  _exports.OWNER = void 0;

  /**
  @module @ember/application
  */
  var OWNER = (0, _utils.symbol)('OWNER');
  /**
    Framework objects in an Ember application (components, services, routes, etc.)
    are created via a factory and dependency injection system. Each of these
    objects is the responsibility of an "owner", which handled its
    instantiation and manages its lifetime.
  
    `getOwner` fetches the owner object responsible for an instance. This can
    be used to lookup or resolve other class instances, or register new factories
    into the owner.
  
    For example, this component dynamically looks up a service based on the
    `audioType` passed as an attribute:
  
    ```app/components/play-audio.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
    import { getOwner } from '@ember/application';
  
    // Usage:
    //
    //   {{play-audio audioType=model.audioType audioFile=model.file}}
    //
    export default Component.extend({
      audioService: computed('audioType', function() {
        let owner = getOwner(this);
        return owner.lookup(`service:${this.get('audioType')}`);
      }),
  
      click() {
        let player = this.get('audioService');
        player.play(this.get('audioFile'));
      }
    });
    ```
  
    @method getOwner
    @static
    @for @ember/application
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */

  _exports.OWNER = OWNER;

  function getOwner(object) {
    return object[OWNER];
  }
  /**
    `setOwner` forces a new owner on a given object instance. This is primarily
    useful in some testing cases.
  
    @method setOwner
    @static
    @for @ember/application
    @param {Object} object An object instance.
    @param {Object} object The new owner object of the object instance.
    @since 2.3.0
    @public
  */


  function setOwner(object, owner) {
    object[OWNER] = owner;
  }
});
define("@ember/-internals/routing/index", ["exports", "@ember/-internals/routing/lib/ext/controller", "@ember/-internals/routing/lib/location/api", "@ember/-internals/routing/lib/location/none_location", "@ember/-internals/routing/lib/location/hash_location", "@ember/-internals/routing/lib/location/history_location", "@ember/-internals/routing/lib/location/auto_location", "@ember/-internals/routing/lib/system/generate_controller", "@ember/-internals/routing/lib/system/controller_for", "@ember/-internals/routing/lib/system/dsl", "@ember/-internals/routing/lib/system/router", "@ember/-internals/routing/lib/system/route", "@ember/-internals/routing/lib/system/query_params", "@ember/-internals/routing/lib/services/routing", "@ember/-internals/routing/lib/services/router", "@ember/-internals/routing/lib/system/cache"], function (_exports, _controller, _api, _none_location, _hash_location, _history_location, _auto_location, _generate_controller, _controller_for, _dsl, _router, _route, _query_params, _routing, _router2, _cache) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "Location", {
    enumerable: true,
    get: function () {
      return _api.default;
    }
  });
  Object.defineProperty(_exports, "NoneLocation", {
    enumerable: true,
    get: function () {
      return _none_location.default;
    }
  });
  Object.defineProperty(_exports, "HashLocation", {
    enumerable: true,
    get: function () {
      return _hash_location.default;
    }
  });
  Object.defineProperty(_exports, "HistoryLocation", {
    enumerable: true,
    get: function () {
      return _history_location.default;
    }
  });
  Object.defineProperty(_exports, "AutoLocation", {
    enumerable: true,
    get: function () {
      return _auto_location.default;
    }
  });
  Object.defineProperty(_exports, "generateController", {
    enumerable: true,
    get: function () {
      return _generate_controller.default;
    }
  });
  Object.defineProperty(_exports, "generateControllerFactory", {
    enumerable: true,
    get: function () {
      return _generate_controller.generateControllerFactory;
    }
  });
  Object.defineProperty(_exports, "controllerFor", {
    enumerable: true,
    get: function () {
      return _controller_for.default;
    }
  });
  Object.defineProperty(_exports, "RouterDSL", {
    enumerable: true,
    get: function () {
      return _dsl.default;
    }
  });
  Object.defineProperty(_exports, "Router", {
    enumerable: true,
    get: function () {
      return _router.default;
    }
  });
  Object.defineProperty(_exports, "Route", {
    enumerable: true,
    get: function () {
      return _route.default;
    }
  });
  Object.defineProperty(_exports, "QueryParams", {
    enumerable: true,
    get: function () {
      return _query_params.default;
    }
  });
  Object.defineProperty(_exports, "RoutingService", {
    enumerable: true,
    get: function () {
      return _routing.default;
    }
  });
  Object.defineProperty(_exports, "RouterService", {
    enumerable: true,
    get: function () {
      return _router2.default;
    }
  });
  Object.defineProperty(_exports, "BucketCache", {
    enumerable: true,
    get: function () {
      return _cache.default;
    }
  });
});
define("@ember/-internals/routing/lib/ext/controller", ["exports", "@ember/-internals/metal", "@ember/controller/lib/controller_mixin", "@ember/-internals/routing/lib/utils"], function (_exports, _metal, _controller_mixin, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */
  _controller_mixin.default.reopen({
    concatenatedProperties: ['queryParams'],

    /**
      Defines which query parameters the controller accepts.
      If you give the names `['category','page']` it will bind
      the values of these query parameters to the variables
      `this.category` and `this.page`.
      By default, Ember coerces query parameter values using `toggleProperty`.
      This behavior may lead to unexpected results.
      Available queryParam types: `boolean`, `number`, `array`.
      If query param type not specified, it will be `string`.
      To explicitly configure a query parameter property so it coerces as expected, you must define a type property:
         ```javascript
        queryParams: [{
          category: {
            type: 'boolean'
          }
        }]
      ```
         @for Ember.ControllerMixin
      @property queryParams
      @public
    */
    queryParams: null,

    /**
     This property is updated to various different callback functions depending on
     the current "state" of the backing route. It is used by
     `Controller.prototype._qpChanged`.
        The methods backing each state can be found in the `Route.prototype._qp` computed
     property return value (the `.states` property). The current values are listed here for
     the sanity of future travelers:
        * `inactive` - This state is used when this controller instance is not part of the active
       route hierarchy. Set in `Route.prototype._reset` (a `router.js` microlib hook) and
       `Route.prototype.actions.finalizeQueryParamChange`.
     * `active` - This state is used when this controller instance is part of the active
       route hierarchy. Set in `Route.prototype.actions.finalizeQueryParamChange`.
     * `allowOverrides` - This state is used in `Route.prototype.setup` (`route.js` microlib hook).
         @method _qpDelegate
      @private
    */
    _qpDelegate: null,

    /**
     During `Route#setup` observers are created to invoke this method
     when any of the query params declared in `Controller#queryParams` property
     are changed.
        When invoked this method uses the currently active query param update delegate
     (see `Controller.prototype._qpDelegate` for details) and invokes it with
     the QP key/value being changed.
         @method _qpChanged
      @private
    */
    _qpChanged(controller, _prop) {
      var dotIndex = _prop.indexOf('.[]');

      var prop = dotIndex === -1 ? _prop : _prop.slice(0, dotIndex);
      var delegate = controller._qpDelegate;
      var value = (0, _metal.get)(controller, prop);
      delegate(prop, value);
    },

    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         ```javascript
      aController.transitionToRoute('blogPosts');
      aController.transitionToRoute('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      aController.transitionToRoute('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      aController.transitionToRoute('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/router.js
      Router.map(function() {
        this.route('blogPost', { path: ':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId', resetNamespace: true });
        });
      });
      ```
         ```javascript
      aController.transitionToRoute('blogComment', aPost, aComment);
      aController.transitionToRoute('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      aController.transitionToRoute('/');
      aController.transitionToRoute('/blog/post/1/comment/13');
      aController.transitionToRoute('/blog/posts?sort=title');
      ```
         An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
         ```javascript
      aController.transitionToRoute('blogPost', 1, {
        queryParams: { showComments: 'true' }
      });
         // if you just want to transition the query parameters without changing the route
      aController.transitionToRoute({ queryParams: { sort: 'date' } });
      ```
         See also [replaceRoute](/ember/release/classes/Ember.ControllerMixin/methods/replaceRoute?anchor=replaceRoute).
         @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
        while transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @for Ember.ControllerMixin
      @method transitionToRoute
      @public
    */
    transitionToRoute(...args) {
      // target may be either another controller or a router
      var target = (0, _metal.get)(this, 'target');
      var method = target.transitionToRoute || target.transitionTo;
      return method.apply(target, (0, _utils.prefixRouteNameArg)(this, args));
    },

    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionToRoute` in all other respects.
         ```javascript
      aController.replaceRoute('blogPosts');
      aController.replaceRoute('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      aController.replaceRoute('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      aController.replaceRoute('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/router.js
      Router.map(function() {
        this.route('blogPost', { path: ':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId', resetNamespace: true });
        });
      });
      ```
         ```
      aController.replaceRoute('blogComment', aPost, aComment);
      aController.replaceRoute('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      aController.replaceRoute('/');
      aController.replaceRoute('/blog/post/1/comment/13');
      ```
         @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
      while transitioning to the route.
      @for Ember.ControllerMixin
      @method replaceRoute
      @public
    */
    replaceRoute(...args) {
      // target may be either another controller or a router
      var target = (0, _metal.get)(this, 'target');
      var method = target.replaceRoute || target.replaceWith;
      return method.apply(target, (0, _utils.prefixRouteNameArg)(this, args));
    }

  });

  var _default = _controller_mixin.default;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/location/api", ["exports", "@ember/debug"], function (_exports, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/routing
  */

  /**
    Location returns an instance of the correct implementation of
    the `location` API.
  
    ## Implementations
  
    You can pass an implementation name (`hash`, `history`, `none`, `auto`) to force a
    particular implementation to be used in your application.
  
    See [HashLocation](/ember/release/classes/HashLocation).
    See [HistoryLocation](/ember/release/classes/HistoryLocation).
    See [NoneLocation](/ember/release/classes/NoneLocation).
    See [AutoLocation](/ember/release/classes/AutoLocation).
  
    ## Location API
  
    Each location implementation must provide the following methods:
  
    * implementation: returns the string name used to reference the implementation.
    * getURL: returns the current URL.
    * setURL(path): sets the current URL.
    * replaceURL(path): replace the current URL (optional).
    * onUpdateURL(callback): triggers the callback when the URL changes.
    * formatURL(url): formats `url` to be placed into `href` attribute.
    * detect() (optional): instructs the location to do any feature detection
        necessary. If the location needs to redirect to a different URL, it
        can cancel routing by setting the `cancelRouterSetup` property on itself
        to `false`.
  
    Calling setURL or replaceURL will not trigger onUpdateURL callbacks.
  
    ## Custom implementation
  
    Ember scans `app/locations/*` for extending the Location API.
  
    Example:
  
    ```javascript
    import HistoryLocation from '@ember/routing/history-location';
  
    export default class MyHistory {
      implementation: 'my-custom-history',
      constructor() {
        this._history = HistoryLocation.create(...arguments);
      }
      create() {
        return new this(...arguments);
      }
      pushState(path) {
         this._history.pushState(path);
      }
    }
    ```
  
    @class Location
    @private
  */
  var _default = {
    /**
     This is deprecated in favor of using the container to lookup the location
     implementation as desired.
        For example:
        ```javascript
     // Given a location registered as follows:
     container.register('location:history-test', HistoryTestLocation);
        // You could create a new instance via:
     container.lookup('location:history-test');
     ```
         @method create
      @param {Object} options
      @return {Object} an instance of an implementation of the `location` API
      @deprecated Use the container to lookup the location implementation that you
      need.
      @private
    */
    create(options) {
      var implementation = options && options.implementation;
      (true && !(Boolean(implementation)) && (0, _debug.assert)("Location.create: you must specify a 'implementation' option", Boolean(implementation)));
      var implementationClass = this.implementations[implementation];
      (true && !(Boolean(implementationClass)) && (0, _debug.assert)("Location.create: " + implementation + " is not a valid implementation", Boolean(implementationClass)));
      return implementationClass.create(...arguments);
    },

    implementations: {}
  };
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/location/auto_location", ["exports", "@ember/-internals/browser-environment", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/debug", "@ember/-internals/routing/lib/location/util"], function (_exports, _browserEnvironment, _metal, _owner, _runtime, _utils, _debug, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getHistoryPath = getHistoryPath;
  _exports.getHashPath = getHashPath;
  _exports.default = void 0;

  /**
  @module @ember/routing
  */

  /**
    AutoLocation will select the best location option based off browser
    support with the priority order: history, hash, none.
  
    Clean pushState paths accessed by hashchange-only browsers will be redirected
    to the hash-equivalent and vice versa so future transitions are consistent.
  
    Keep in mind that since some of your users will use `HistoryLocation`, your
    server must serve the Ember app at all the routes you define.
  
    Browsers that support the `history` API will use `HistoryLocation`, those that
    do not, but still support the `hashchange` event will use `HashLocation`, and
    in the rare case neither is supported will use `NoneLocation`.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'auto'
    });
    ```
  
    This will result in a posts.new url of `/posts/new` for modern browsers that
    support the `history` api or `/#/posts/new` for older ones, like Internet
    Explorer 9 and below.
  
    When a user visits a link to your application, they will be automatically
    upgraded or downgraded to the appropriate `Location` class, with the URL
    transformed accordingly, if needed.
  
    Keep in mind that since some of your users will use `HistoryLocation`, your
    server must serve the Ember app at all the routes you define.
  
    @class AutoLocation
    @static
    @protected
  */
  class AutoLocation extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.implementation = 'auto';
    }
    /**
     Called by the router to instruct the location to do any feature detection
     necessary. In the case of AutoLocation, we detect whether to use history
     or hash concrete implementations.
        @private
    */


    detect() {
      var rootURL = this.rootURL;
      (true && !(rootURL.charAt(rootURL.length - 1) === '/') && (0, _debug.assert)('rootURL must end with a trailing forward slash e.g. "/app/"', rootURL.charAt(rootURL.length - 1) === '/'));
      var implementation = detectImplementation({
        location: this.location,
        history: this.history,
        userAgent: this.userAgent,
        rootURL,
        documentMode: this.documentMode,
        global: this.global
      });

      if (implementation === false) {
        (0, _metal.set)(this, 'cancelRouterSetup', true);
        implementation = 'none';
      }

      var concrete = (0, _owner.getOwner)(this).lookup("location:" + implementation);
      (true && !(concrete !== undefined) && (0, _debug.assert)("Could not find location '" + implementation + "'.", concrete !== undefined));
      (0, _metal.set)(concrete, 'rootURL', rootURL);
      (0, _metal.set)(this, 'concreteImplementation', concrete);
    }

    willDestroy() {
      var {
        concreteImplementation
      } = this;

      if (concreteImplementation) {
        concreteImplementation.destroy();
      }
    }

  }

  _exports.default = AutoLocation;
  AutoLocation.reopen({
    /**
      @private
         Will be pre-pended to path upon state change.
         @since 1.5.1
      @property rootURL
      @default '/'
    */
    rootURL: '/',
    initState: delegateToConcreteImplementation('initState'),
    getURL: delegateToConcreteImplementation('getURL'),
    setURL: delegateToConcreteImplementation('setURL'),
    replaceURL: delegateToConcreteImplementation('replaceURL'),
    onUpdateURL: delegateToConcreteImplementation('onUpdateURL'),
    formatURL: delegateToConcreteImplementation('formatURL'),

    /**
      @private
         The browser's `location` object. This is typically equivalent to
      `window.location`, but may be overridden for testing.
         @property location
      @default environment.location
    */
    location: _browserEnvironment.location,

    /**
      @private
         The browser's `history` object. This is typically equivalent to
      `window.history`, but may be overridden for testing.
         @since 1.5.1
      @property history
      @default environment.history
    */
    history: _browserEnvironment.history,

    /**
     @private
        The user agent's global variable. In browsers, this will be `window`.
        @since 1.11
     @property global
     @default window
    */
    global: _browserEnvironment.window,

    /**
      @private
         The browser's `userAgent`. This is typically equivalent to
      `navigator.userAgent`, but may be overridden for testing.
         @since 1.5.1
      @property userAgent
      @default environment.history
    */
    userAgent: _browserEnvironment.userAgent,

    /**
      @private
         This property is used by the router to know whether to cancel the routing
      setup process, which is needed while we redirect the browser.
         @since 1.5.1
      @property cancelRouterSetup
      @default false
    */
    cancelRouterSetup: false
  });

  function delegateToConcreteImplementation(methodName) {
    return function (...args) {
      var {
        concreteImplementation
      } = this;
      (true && !(Boolean(concreteImplementation)) && (0, _debug.assert)("AutoLocation's detect() method should be called before calling any other hooks.", Boolean(concreteImplementation)));
      return (0, _utils.tryInvoke)(concreteImplementation, methodName, args);
    };
  }

  function detectImplementation(options) {
    var {
      location,
      userAgent,
      history,
      documentMode,
      global,
      rootURL
    } = options;
    var implementation = 'none';
    var cancelRouterSetup = false;
    var currentPath = (0, _util.getFullPath)(location);

    if ((0, _util.supportsHistory)(userAgent, history)) {
      var historyPath = getHistoryPath(rootURL, location); // If the browser supports history and we have a history path, we can use
      // the history location with no redirects.

      if (currentPath === historyPath) {
        implementation = 'history';
      } else if (currentPath.substr(0, 2) === '/#') {
        history.replaceState({
          path: historyPath
        }, '', historyPath);
        implementation = 'history';
      } else {
        cancelRouterSetup = true;
        (0, _util.replacePath)(location, historyPath);
      }
    } else if ((0, _util.supportsHashChange)(documentMode, global)) {
      var hashPath = getHashPath(rootURL, location); // Be sure we're using a hashed path, otherwise let's switch over it to so
      // we start off clean and consistent. We'll count an index path with no
      // hash as "good enough" as well.

      if (currentPath === hashPath || currentPath === '/' && hashPath === '/#/') {
        implementation = 'hash';
      } else {
        // Our URL isn't in the expected hash-supported format, so we want to
        // cancel the router setup and replace the URL to start off clean
        cancelRouterSetup = true;
        (0, _util.replacePath)(location, hashPath);
      }
    }

    if (cancelRouterSetup) {
      return false;
    }

    return implementation;
  }
  /**
    @private
  
    Returns the current path as it should appear for HistoryLocation supported
    browsers. This may very well differ from the real current path (e.g. if it
    starts off as a hashed URL)
  */


  function getHistoryPath(rootURL, location) {
    var path = (0, _util.getPath)(location);
    var hash = (0, _util.getHash)(location);
    var query = (0, _util.getQuery)(location);
    var rootURLIndex = path.indexOf(rootURL);
    var routeHash, hashParts;
    (true && !(rootURLIndex === 0) && (0, _debug.assert)("Path " + path + " does not start with the provided rootURL " + rootURL, rootURLIndex === 0)); // By convention, Ember.js routes using HashLocation are required to start
    // with `#/`. Anything else should NOT be considered a route and should
    // be passed straight through, without transformation.

    if (hash.substr(0, 2) === '#/') {
      // There could be extra hash segments after the route
      hashParts = hash.substr(1).split('#'); // The first one is always the route url

      routeHash = hashParts.shift(); // If the path already has a trailing slash, remove the one
      // from the hashed route so we don't double up.

      if (path.charAt(path.length - 1) === '/') {
        routeHash = routeHash.substr(1);
      } // This is the "expected" final order


      path += routeHash + query;

      if (hashParts.length) {
        path += "#" + hashParts.join('#');
      }
    } else {
      path += query + hash;
    }

    return path;
  }
  /**
    @private
  
    Returns the current path as it should appear for HashLocation supported
    browsers. This may very well differ from the real current path.
  
    @method _getHashPath
  */


  function getHashPath(rootURL, location) {
    var path = rootURL;
    var historyPath = getHistoryPath(rootURL, location);
    var routePath = historyPath.substr(rootURL.length);

    if (routePath !== '') {
      if (routePath[0] !== '/') {
        routePath = "/" + routePath;
      }

      path += "#" + routePath;
    }

    return path;
  }
});
define("@ember/-internals/routing/lib/location/hash_location", ["exports", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/runloop", "@ember/-internals/routing/lib/location/util"], function (_exports, _metal, _runtime, _runloop, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/routing
  */

  /**
    `HashLocation` implements the location API using the browser's
    hash. At present, it relies on a `hashchange` event existing in the
    browser.
  
    Using `HashLocation` results in URLs with a `#` (hash sign) separating the
    server side URL portion of the URL from the portion that is used by Ember.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'hash'
    });
    ```
  
    This will result in a posts.new url of `/#/posts/new`.
  
    @class HashLocation
    @extends EmberObject
    @protected
  */
  class HashLocation extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.implementation = 'hash';
    }

    init() {
      (0, _metal.set)(this, 'location', this._location || window.location);
      this._hashchangeHandler = undefined;
    }
    /**
      @private
         Returns normalized location.hash
         @since 1.5.1
      @method getHash
    */


    getHash() {
      return (0, _util.getHash)(this.location);
    }
    /**
      Returns the normalized URL, constructed from `location.hash`.
         e.g. `#/foo` => `/foo` as well as `#/foo#bar` => `/foo#bar`.
         By convention, hashed paths must begin with a forward slash, otherwise they
      are not treated as a path so we can distinguish intent.
         @private
      @method getURL
    */


    getURL() {
      var originalPath = this.getHash().substr(1);
      var outPath = originalPath;

      if (outPath[0] !== '/') {
        outPath = '/'; // Only add the # if the path isn't empty.
        // We do NOT want `/#` since the ampersand
        // is only included (conventionally) when
        // the location.hash has a value

        if (originalPath) {
          outPath += "#" + originalPath;
        }
      }

      return outPath;
    }
    /**
      Set the `location.hash` and remembers what was set. This prevents
      `onUpdateURL` callbacks from triggering when the hash was set by
      `HashLocation`.
         @private
      @method setURL
      @param path {String}
    */


    setURL(path) {
      this.location.hash = path;
      (0, _metal.set)(this, 'lastSetURL', path);
    }
    /**
      Uses location.replace to update the url without a page reload
      or history modification.
         @private
      @method replaceURL
      @param path {String}
    */


    replaceURL(path) {
      this.location.replace("#" + path);
      (0, _metal.set)(this, 'lastSetURL', path);
    }
    /**
      Register a callback to be invoked when the hash changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
         @private
      @method onUpdateURL
      @param callback {Function}
    */


    onUpdateURL(callback) {
      this._removeEventListener();

      this._hashchangeHandler = (0, _runloop.bind)(this, function () {
        var path = this.getURL();

        if (this.lastSetURL === path) {
          return;
        }

        (0, _metal.set)(this, 'lastSetURL', null);
        callback(path);
      });
      window.addEventListener('hashchange', this._hashchangeHandler);
    }
    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
         This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
         @private
      @method formatURL
      @param url {String}
    */


    formatURL(url) {
      return "#" + url;
    }
    /**
      Cleans up the HashLocation event listener.
         @private
      @method willDestroy
    */


    willDestroy() {
      this._removeEventListener();
    }

    _removeEventListener() {
      if (this._hashchangeHandler) {
        window.removeEventListener('hashchange', this._hashchangeHandler);
      }
    }

  }

  _exports.default = HashLocation;
});
define("@ember/-internals/routing/lib/location/history_location", ["exports", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/-internals/routing/lib/location/util"], function (_exports, _metal, _runtime, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/routing
  */
  var popstateFired = false;

  function _uuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
      var r, v;
      r = Math.random() * 16 | 0;
      v = c === 'x' ? r : r & 3 | 8;
      return v.toString(16);
    });
  }
  /**
    HistoryLocation implements the location API using the browser's
    history.pushState API.
  
    Using `HistoryLocation` results in URLs that are indistinguishable from a
    standard URL. This relies upon the browser's `history` API.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'history'
    });
    ```
  
    This will result in a posts.new url of `/posts/new`.
  
    Keep in mind that your server must serve the Ember app at all the routes you
    define.
  
    @class HistoryLocation
    @extends EmberObject
    @protected
  */


  class HistoryLocation extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.implementation = 'history';
      /**
        Will be pre-pended to path upon state change
               @property rootURL
        @default '/'
        @private
      */

      this.rootURL = '/';
    }
    /**
      @private
         Returns normalized location.hash
         @method getHash
    */


    getHash() {
      return (0, _util.getHash)(this.location);
    }

    init() {
      this._super(...arguments);

      var base = document.querySelector('base');
      var baseURL = '';

      if (base) {
        baseURL = base.getAttribute('href');
      }

      (0, _metal.set)(this, 'baseURL', baseURL);
      (0, _metal.set)(this, 'location', this.location || window.location);
      this._popstateHandler = undefined;
    }
    /**
      Used to set state on first call to setURL
         @private
      @method initState
    */


    initState() {
      var history = this.history || window.history;
      (0, _metal.set)(this, 'history', history);

      if (history && 'state' in history) {
        this.supportsHistory = true;
      }

      var state = this.getState();
      var path = this.formatURL(this.getURL());

      if (state && state.path === path) {
        // preserve existing state
        // used for webkit workaround, since there will be no initial popstate event
        this._previousURL = this.getURL();
      } else {
        this.replaceState(path);
      }
    }
    /**
      Returns the current `location.pathname` without `rootURL` or `baseURL`
         @private
      @method getURL
      @return url {String}
    */


    getURL() {
      var {
        location,
        rootURL,
        baseURL
      } = this;
      var path = location.pathname; // remove trailing slashes if they exists

      rootURL = rootURL.replace(/\/$/, '');
      baseURL = baseURL.replace(/\/$/, ''); // remove baseURL and rootURL from start of path

      var url = path.replace(new RegExp("^" + baseURL + "(?=/|$)"), '').replace(new RegExp("^" + rootURL + "(?=/|$)"), '').replace(/\/\//g, '/'); // remove extra slashes

      var search = location.search || '';
      url += search + this.getHash();
      return url;
    }
    /**
      Uses `history.pushState` to update the url without a page reload.
         @private
      @method setURL
      @param path {String}
    */


    setURL(path) {
      var state = this.getState();
      path = this.formatURL(path);

      if (!state || state.path !== path) {
        this.pushState(path);
      }
    }
    /**
      Uses `history.replaceState` to update the url without a page reload
      or history modification.
         @private
      @method replaceURL
      @param path {String}
    */


    replaceURL(path) {
      var state = this.getState();
      path = this.formatURL(path);

      if (!state || state.path !== path) {
        this.replaceState(path);
      }
    }
    /**
      Get the current `history.state`. Checks for if a polyfill is
      required and if so fetches this._historyState. The state returned
      from getState may be null if an iframe has changed a window's
      history.
         The object returned will contain a `path` for the given state as well
      as a unique state `id`. The state index will allow the app to distinguish
      between two states with similar paths but should be unique from one another.
         @private
      @method getState
      @return state {Object}
    */


    getState() {
      if (this.supportsHistory) {
        return this.history.state;
      }

      return this._historyState;
    }
    /**
     Pushes a new state.
        @private
     @method pushState
     @param path {String}
    */


    pushState(path) {
      var state = {
        path,
        uuid: _uuid()
      };
      this.history.pushState(state, null, path);
      this._historyState = state; // used for webkit workaround

      this._previousURL = this.getURL();
    }
    /**
     Replaces the current state.
        @private
     @method replaceState
     @param path {String}
    */


    replaceState(path) {
      var state = {
        path,
        uuid: _uuid()
      };
      this.history.replaceState(state, null, path);
      this._historyState = state; // used for webkit workaround

      this._previousURL = this.getURL();
    }
    /**
      Register a callback to be invoked whenever the browser
      history changes, including using forward and back buttons.
         @private
      @method onUpdateURL
      @param callback {Function}
    */


    onUpdateURL(callback) {
      this._removeEventListener();

      this._popstateHandler = () => {
        // Ignore initial page load popstate event in Chrome
        if (!popstateFired) {
          popstateFired = true;

          if (this.getURL() === this._previousURL) {
            return;
          }
        }

        callback(this.getURL());
      };

      window.addEventListener('popstate', this._popstateHandler);
    }
    /**
      Used when using `{{action}}` helper.  The url is always appended to the rootURL.
         @private
      @method formatURL
      @param url {String}
      @return formatted url {String}
    */


    formatURL(url) {
      var {
        rootURL,
        baseURL
      } = this;

      if (url !== '') {
        // remove trailing slashes if they exists
        rootURL = rootURL.replace(/\/$/, '');
        baseURL = baseURL.replace(/\/$/, '');
      } else if (baseURL[0] === '/' && rootURL[0] === '/') {
        // if baseURL and rootURL both start with a slash
        // ... remove trailing slash from baseURL if it exists
        baseURL = baseURL.replace(/\/$/, '');
      }

      return baseURL + rootURL + url;
    }
    /**
      Cleans up the HistoryLocation event listener.
         @private
      @method willDestroy
    */


    willDestroy() {
      this._removeEventListener();
    }

    _removeEventListener() {
      if (this._popstateHandler) {
        window.removeEventListener('popstate', this._popstateHandler);
      }
    }

  }

  _exports.default = HistoryLocation;
});
define("@ember/-internals/routing/lib/location/none_location", ["exports", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/debug"], function (_exports, _metal, _runtime, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/routing
  */

  /**
    NoneLocation does not interact with the browser. It is useful for
    testing, or when you need to manage state with your Router, but temporarily
    don't want it to muck with the URL (for example when you embed your
    application in a larger page).
  
    Using `NoneLocation` causes Ember to not store the applications URL state
    in the actual URL. This is generally used for testing purposes, and is one
    of the changes made when calling `App.setupForTesting()`.
  
    @class NoneLocation
    @extends EmberObject
    @protected
  */
  class NoneLocation extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.implementation = 'none';
    }

    detect() {
      var {
        rootURL
      } = this;
      (true && !(rootURL.charAt(rootURL.length - 1) === '/') && (0, _debug.assert)('rootURL must end with a trailing forward slash e.g. "/app/"', rootURL.charAt(rootURL.length - 1) === '/'));
    }
    /**
      Returns the current path without `rootURL`.
         @private
      @method getURL
      @return {String} path
    */


    getURL() {
      var {
        path,
        rootURL
      } = this; // remove trailing slashes if they exists

      rootURL = rootURL.replace(/\/$/, ''); // remove rootURL from url

      return path.replace(new RegExp("^" + rootURL + "(?=/|$)"), '');
    }
    /**
      Set the path and remembers what was set. Using this method
      to change the path will not invoke the `updateURL` callback.
         @private
      @method setURL
      @param path {String}
    */


    setURL(path) {
      (0, _metal.set)(this, 'path', path);
    }
    /**
      Register a callback to be invoked when the path changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
         @private
      @method onUpdateURL
      @param callback {Function}
    */


    onUpdateURL(callback) {
      this.updateCallback = callback;
    }
    /**
      Sets the path and calls the `updateURL` callback.
         @private
      @method handleURL
      @param url {String}
    */


    handleURL(url) {
      (0, _metal.set)(this, 'path', url);
      this.updateCallback(url);
    }
    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
         This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
         @private
      @method formatURL
      @param url {String}
      @return {String} url
    */


    formatURL(url) {
      var {
        rootURL
      } = this;

      if (url !== '') {
        // remove trailing slashes if they exists
        rootURL = rootURL.replace(/\/$/, '');
      }

      return rootURL + url;
    }

  }

  _exports.default = NoneLocation;
  NoneLocation.reopen({
    path: '',

    /**
      Will be pre-pended to path.
         @private
      @property rootURL
      @default '/'
    */
    rootURL: '/'
  });
});
define("@ember/-internals/routing/lib/location/util", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getPath = getPath;
  _exports.getQuery = getQuery;
  _exports.getHash = getHash;
  _exports.getFullPath = getFullPath;
  _exports.getOrigin = getOrigin;
  _exports.supportsHashChange = supportsHashChange;
  _exports.supportsHistory = supportsHistory;
  _exports.replacePath = replacePath;

  /**
    @private
  
    Returns the current `location.pathname`, normalized for IE inconsistencies.
  */
  function getPath(location) {
    var pathname = location.pathname; // Various versions of IE/Opera don't always return a leading slash

    if (pathname[0] !== '/') {
      pathname = "/" + pathname;
    }

    return pathname;
  }
  /**
    @private
  
    Returns the current `location.search`.
  */


  function getQuery(location) {
    return location.search;
  }
  /**
    @private
  
    Returns the hash or empty string
  */


  function getHash(location) {
    if (location.hash !== undefined) {
      return location.hash.substr(0);
    }

    return '';
  }

  function getFullPath(location) {
    return getPath(location) + getQuery(location) + getHash(location);
  }

  function getOrigin(location) {
    var origin = location.origin; // Older browsers, especially IE, don't have origin

    if (!origin) {
      origin = location.protocol + "//" + location.hostname;

      if (location.port) {
        origin += ":" + location.port;
      }
    }

    return origin;
  }
  /*
    `documentMode` only exist in Internet Explorer, and it's tested because IE8 running in
    IE7 compatibility mode claims to support `onhashchange` but actually does not.
  
    `global` is an object that may have an `onhashchange` property.
  
    @private
    @function supportsHashChange
  */


  function supportsHashChange(documentMode, global) {
    return global && 'onhashchange' in global && (documentMode === undefined || documentMode > 7);
  }
  /*
    `userAgent` is a user agent string. We use user agent testing here, because
    the stock Android browser is known to have buggy versions of the History API,
    in some Android versions.
  
    @private
    @function supportsHistory
  */


  function supportsHistory(userAgent, history) {
    // Boosted from Modernizr: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/history.js
    // The stock browser on Android 2.2 & 2.3, and 4.0.x returns positive on history support
    // Unfortunately support is really buggy and there is no clean way to detect
    // these bugs, so we fall back to a user agent sniff :(
    // We only want Android 2 and 4.0, stock browser, and not Chrome which identifies
    // itself as 'Mobile Safari' as well, nor Windows Phone.
    if ((userAgent.indexOf('Android 2.') !== -1 || userAgent.indexOf('Android 4.0') !== -1) && userAgent.indexOf('Mobile Safari') !== -1 && userAgent.indexOf('Chrome') === -1 && userAgent.indexOf('Windows Phone') === -1) {
      return false;
    }

    return Boolean(history && 'pushState' in history);
  }
  /**
    Replaces the current location, making sure we explicitly include the origin
    to prevent redirecting to a different origin.
  
    @private
  */


  function replacePath(location, path) {
    location.replace(getOrigin(location) + path);
  }
});
define("@ember/-internals/routing/lib/services/router", ["exports", "@ember/-internals/runtime", "@ember/debug", "@ember/object/computed", "@ember/service", "@ember/-internals/routing/lib/utils"], function (_exports, _runtime, _debug, _computed, _service, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var freezeRouteInfo;

  if (true
  /* DEBUG */
  ) {
    freezeRouteInfo = transition => {
      if (transition.from !== null && !Object.isFrozen(transition.from)) {
        Object.freeze(transition.from);
      }

      if (transition.to !== null && !Object.isFrozen(transition.to)) {
        Object.freeze(transition.to);
      }
    };
  }

  function cleanURL(url, rootURL) {
    if (rootURL === '/') {
      return url;
    }

    return url.substr(rootURL.length, url.length);
  }
  /**
     The Router service is the public API that provides access to the router.
  
     The immediate benefit of the Router service is that you can inject it into components,
     giving them a friendly way to initiate transitions and ask questions about the current
     global router state.
  
     In this example, the Router service is injected into a component to initiate a transition
     to a dedicated route:
  
     ```app/components/example.js
     import Component from '@glimmer/component';
     import { action } from '@ember/object';
     import { inject as service } from '@ember/service';
  
     export default class ExampleComponent extends Component {
       @service router;
  
       @action
       next() {
         this.router.transitionTo('other.route');
       }
     }
     ```
  
     Like any service, it can also be injected into helpers, routes, etc.
  
     @public
     @extends Service
     @class RouterService
   */


  class RouterService extends _service.default {
    init() {
      super.init(...arguments);

      this._router.on('routeWillChange', transition => {
        if (true
        /* DEBUG */
        ) {
          freezeRouteInfo(transition);
        }

        this.trigger('routeWillChange', transition);
      });

      this._router.on('routeDidChange', transition => {
        if (true
        /* DEBUG */
        ) {
          freezeRouteInfo(transition);
        }

        this.trigger('routeDidChange', transition);
      });
    }
    /**
       Transition the application into another route. The route may
       be either a single route or route path:
          See [transitionTo](/ember/release/classes/Route/methods/transitionTo?anchor=transitionTo) for more info.
          Calling `transitionTo` from the Router service will cause default query parameter values to be included in the URL.
       This behavior is different from calling `transitionTo` on a route or `transitionToRoute` on a controller.
       See the [Router Service RFC](https://github.com/emberjs/rfcs/blob/master/text/0095-router-service.md#query-parameter-semantics) for more info.
          In the following example we use the Router service to navigate to a route with a
       specific model from a Component.
          ```javascript
       import Component from '@glimmer/component';
       import { action } from '@ember/object';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
            @action
         goToComments(post) {
           this.router.transitionTo('comments', post);
         }
       }
       ```
          @method transitionTo
       @param {String} routeNameOrUrl the name of the route or a URL
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {Transition} the transition object associated with this
         attempted transition
       @public
     */


    transitionTo(...args) {
      if ((0, _utils.resemblesURL)(args[0])) {
        return this._router._doURLTransition('transitionTo', args[0]);
      }

      var {
        routeName,
        models,
        queryParams
      } = (0, _utils.extractRouteArgs)(args);

      var transition = this._router._doTransition(routeName, models, queryParams, true);

      transition['_keepDefaultQueryParamValues'] = true;
      return transition;
    }
    /**
       Transition into another route while replacing the current URL, if possible.
       The route may be either a single route or route path:
          See [replaceWith](/ember/release/classes/Route/methods/replaceWith?anchor=replaceWith) for more info.
          Calling `replaceWith` from the Router service will cause default query parameter values to be included in the URL.
       This behavior is different from calling `replaceWith` on a route.
       See the [Router Service RFC](https://github.com/emberjs/rfcs/blob/master/text/0095-router-service.md#query-parameter-semantics) for more info.
          Usage example:
          ```app/routes/application.js
       import Route from '@ember/routing/route';
          export default class extends Route {
         beforeModel() {
           if (!authorized()){
             this.replaceWith('unauthorized');
           }
         }
       });
       ```
          @method replaceWith
       @param {String} routeNameOrUrl the name of the route or a URL
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {Transition} the transition object associated with this
         attempted transition
       @public
     */


    replaceWith()
    /* routeNameOrUrl, ...models, options */
    {
      return this.transitionTo(...arguments).method('replace');
    }
    /**
      Generate a URL based on the supplied route name and optionally a model. The
      URL is returned as a string that can be used for any purpose.
         In this example, the URL for the `author.books` route for a given author
      is copied to the clipboard.
         ```app/templates/application.hbs
      <CopyLink @author={{hash id="tomster" name="Tomster"}} />
      ```
         ```app/components/copy-link.js
      import Component from '@glimmer/component';
      import { inject as service } from '@ember/service';
      import { action } from '@ember/object';
         export default class CopyLinkComponent extends Component {
        @service router;
        @service clipboard;
           @action
        copyBooksURL() {
          if (this.author) {
            const url = this.router.urlFor('author.books', this.args.author);
            this.clipboard.set(url);
            // Clipboard now has /author/tomster/books
          }
        }
      }
      ```
         Just like with `transitionTo` and `replaceWith`, `urlFor` can also handle
      query parameters.
         ```app/templates/application.hbs
      <CopyLink @author={{hash id="tomster" name="Tomster"}} />
      ```
         ```app/components/copy-link.js
      import Component from '@glimmer/component';
      import { inject as service } from '@ember/service';
      import { action } from '@ember/object';
         export default class CopyLinkComponent extends Component {
        @service router;
        @service clipboard;
           @action
        copyOnlyEmberBooksURL() {
          if (this.author) {
            const url = this.router.urlFor('author.books', this.author, {
              queryParams: { filter: 'emberjs' }
            });
            this.clipboard.set(url);
            // Clipboard now has /author/tomster/books?filter=emberjs
          }
        }
      }
      ```
          @method urlFor
       @param {String} routeName the name of the route
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {String} the string representing the generated URL
       @public
     */


    urlFor(routeName, ...args) {
      return this._router.generate(routeName, ...args);
    }
    /**
       Determines whether a route is active.
          @method isActive
       @param {String} routeName the name of the route
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {boolean} true if the provided routeName/models/queryParams are active
       @public
     */


    isActive(...args) {
      var {
        routeName,
        models,
        queryParams
      } = (0, _utils.extractRouteArgs)(args);
      var routerMicrolib = this._router._routerMicrolib;

      if (!routerMicrolib.isActiveIntent(routeName, models)) {
        return false;
      }

      var hasQueryParams = Object.keys(queryParams).length > 0;

      if (hasQueryParams) {
        this._router._prepareQueryParams(routeName, models, queryParams, true
        /* fromRouterService */
        );

        return (0, _utils.shallowEqual)(queryParams, routerMicrolib.state.queryParams);
      }

      return true;
    }
    /**
       Takes a string URL and returns a `RouteInfo` for the leafmost route represented
       by the URL. Returns `null` if the URL is not recognized. This method expects to
       receive the actual URL as seen by the browser including the app's `rootURL`.
          See [RouteInfo](/ember/release/classes/RouteInfo) for more info.
          In the following example `recognize` is used to verify if a path belongs to our
       application before transitioning to it.
          ```
       import Component from '@ember/component';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
         path = '/';
            click() {
           if (this.router.recognize(this.path)) {
             this.router.transitionTo(this.path);
           }
         }
       }
       ```
           @method recognize
        @param {String} url
        @public
      */


    recognize(url) {
      (true && !(url.indexOf(this.rootURL) === 0) && (0, _debug.assert)("You must pass a url that begins with the application's rootURL \"" + this.rootURL + "\"", url.indexOf(this.rootURL) === 0));
      var internalURL = cleanURL(url, this.rootURL);
      return this._router._routerMicrolib.recognize(internalURL);
    }
    /**
      Takes a string URL and returns a promise that resolves to a
      `RouteInfoWithAttributes` for the leafmost route represented by the URL.
      The promise rejects if the URL is not recognized or an unhandled exception
      is encountered. This method expects to receive the actual URL as seen by
      the browser including the app's `rootURL`.
           @method recognizeAndLoad
        @param {String} url
        @public
     */


    recognizeAndLoad(url) {
      (true && !(url.indexOf(this.rootURL) === 0) && (0, _debug.assert)("You must pass a url that begins with the application's rootURL \"" + this.rootURL + "\"", url.indexOf(this.rootURL) === 0));
      var internalURL = cleanURL(url, this.rootURL);
      return this._router._routerMicrolib.recognizeAndLoad(internalURL);
    }

  }

  _exports.default = RouterService;
  RouterService.reopen(_runtime.Evented, {
    /**
       Name of the current route.
          This property represents the logical name of the route,
       which is comma separated.
       For the following router:
          ```app/router.js
       Router.map(function() {
         this.route('about');
         this.route('blog', function () {
           this.route('post', { path: ':post_id' });
         });
       });
       ```
          It will return:
          * `index` when you visit `/`
       * `about` when you visit `/about`
       * `blog.index` when you visit `/blog`
       * `blog.post` when you visit `/blog/some-post-id`
          @property currentRouteName
       @type String
       @public
     */
    currentRouteName: (0, _computed.readOnly)('_router.currentRouteName'),

    /**
       Current URL for the application.
         This property represents the URL path for this route.
      For the following router:
          ```app/router.js
       Router.map(function() {
         this.route('about');
         this.route('blog', function () {
           this.route('post', { path: ':post_id' });
         });
       });
       ```
          It will return:
          * `/` when you visit `/`
       * `/about` when you visit `/about`
       * `/blog` when you visit `/blog`
       * `/blog/some-post-id` when you visit `/blog/some-post-id`
          @property currentURL
       @type String
       @public
     */
    currentURL: (0, _computed.readOnly)('_router.currentURL'),

    /**
      The `location` property returns what implementation of the `location` API
      your application is using, which determines what type of URL is being used.
         See [Location](/ember/release/classes/Location) for more information.
         To force a particular `location` API implementation to be used in your
      application you can set a location type on your `config/environment`.
      For example, to set the `history` type:
         ```config/environment.js
      'use strict';
         module.exports = function(environment) {
        let ENV = {
          modulePrefix: 'router-service',
          environment,
          rootURL: '/',
          locationType: 'history',
          ...
        }
      }
      ```
         The following location types are available by default:
      `auto`, `hash`, `history`, `none`.
         See [HashLocation](/ember/release/classes/HashLocation).
      See [HistoryLocation](/ember/release/classes/HistoryLocation).
      See [NoneLocation](/ember/release/classes/NoneLocation).
      See [AutoLocation](/ember/release/classes/AutoLocation).
         @property location
      @default 'hash'
      @see {Location}
      @public
    */
    location: (0, _computed.readOnly)('_router.location'),

    /**
      The `rootURL` property represents the URL of the root of
      the application, '/' by default.
      This prefix is assumed on all routes defined on this app.
         If you change the `rootURL` in your environment configuration
      like so:
         ```config/environment.js
      'use strict';
         module.exports = function(environment) {
        let ENV = {
          modulePrefix: 'router-service',
          environment,
          rootURL: '/my-root',
        …
        }
      ]
      ```
         This property will return `/my-root`.
         @property rootURL
      @default '/'
      @public
    */
    rootURL: (0, _computed.readOnly)('_router.rootURL'),

    /**
      The `currentRoute` property contains metadata about the current leaf route.
      It returns a `RouteInfo` object that has information like the route name,
      params, query params and more.
         See [RouteInfo](/ember/release/classes/RouteInfo) for more info.
         This property is guaranteed to change whenever a route transition
      happens (even when that transition only changes parameters
      and doesn't change the active route).
         Usage example:
      ```app/components/header.js
        import Component from '@glimmer/component';
        import { inject as service } from '@ember/service';
        import { notEmpty } from '@ember/object/computed';
           export default class extends Component {
          @service router;
             @notEmpty('router.currentRoute.child') isChildRoute;
        });
      ```
          @property currentRoute
       @type RouteInfo
       @public
     */
    currentRoute: (0, _computed.readOnly)('_router.currentRoute')
  });
});
define("@ember/-internals/routing/lib/services/routing", ["exports", "@ember/object/computed", "@ember/polyfills", "@ember/service"], function (_exports, _computed, _polyfills, _service) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    The Routing service is used by LinkComponent, and provides facilities for
    the component/view layer to interact with the router.
  
    This is a private service for internal usage only. For public usage,
    refer to the `Router` service.
  
    @private
    @class RoutingService
  */
  class RoutingService extends _service.default {
    hasRoute(routeName) {
      return this.router.hasRoute(routeName);
    }

    transitionTo(routeName, models, queryParams, shouldReplace) {
      var transition = this.router._doTransition(routeName, models, queryParams);

      if (shouldReplace) {
        transition.method('replace');
      }

      return transition;
    }

    normalizeQueryParams(routeName, models, queryParams) {
      this.router._prepareQueryParams(routeName, models, queryParams);
    }

    generateURL(routeName, models, queryParams) {
      var router = this.router; // return early when the router microlib is not present, which is the case for {{link-to}} in integration tests

      if (!router._routerMicrolib) {
        return;
      }

      var visibleQueryParams = {};

      if (queryParams) {
        (0, _polyfills.assign)(visibleQueryParams, queryParams);
        this.normalizeQueryParams(routeName, models, visibleQueryParams);
      }

      return router.generate(routeName, ...models, {
        queryParams: visibleQueryParams
      });
    }

    isActiveForRoute(contexts, queryParams, routeName, routerState, isCurrentWhenSpecified) {
      var handlers = this.router._routerMicrolib.recognizer.handlersFor(routeName);

      var leafName = handlers[handlers.length - 1].handler;
      var maximumContexts = numberOfContextsAcceptedByHandler(routeName, handlers); // NOTE: any ugliness in the calculation of activeness is largely
      // due to the fact that we support automatic normalizing of
      // `resource` -> `resource.index`, even though there might be
      // dynamic segments / query params defined on `resource.index`
      // which complicates (and makes somewhat ambiguous) the calculation
      // of activeness for links that link to `resource` instead of
      // directly to `resource.index`.
      // if we don't have enough contexts revert back to full route name
      // this is because the leaf route will use one of the contexts

      if (contexts.length > maximumContexts) {
        routeName = leafName;
      }

      return routerState.isActiveIntent(routeName, contexts, queryParams, !isCurrentWhenSpecified);
    }

  }

  _exports.default = RoutingService;
  RoutingService.reopen({
    targetState: (0, _computed.readOnly)('router.targetState'),
    currentState: (0, _computed.readOnly)('router.currentState'),
    currentRouteName: (0, _computed.readOnly)('router.currentRouteName'),
    currentPath: (0, _computed.readOnly)('router.currentPath')
  });

  function numberOfContextsAcceptedByHandler(handlerName, handlerInfos) {
    var req = 0;

    for (var i = 0; i < handlerInfos.length; i++) {
      req += handlerInfos[i].names.length;

      if (handlerInfos[i].handler === handlerName) {
        break;
      }
    }

    return req;
  }
});
define("@ember/-internals/routing/lib/system/cache", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
    A two-tiered cache with support for fallback values when doing lookups.
    Uses "buckets" and then "keys" to cache values.
  
    @private
    @class BucketCache
  */
  class BucketCache {
    constructor() {
      this.cache = new Map();
    }

    has(bucketKey) {
      return this.cache.has(bucketKey);
    }

    stash(bucketKey, key, value) {
      var bucket = this.cache.get(bucketKey);

      if (bucket === undefined) {
        bucket = new Map();
        this.cache.set(bucketKey, bucket);
      }

      bucket.set(key, value);
    }

    lookup(bucketKey, prop, defaultValue) {
      if (!this.has(bucketKey)) {
        return defaultValue;
      }

      var bucket = this.cache.get(bucketKey);

      if (bucket.has(prop)) {
        return bucket.get(prop);
      } else {
        return defaultValue;
      }
    }

  }

  _exports.default = BucketCache;
});
define("@ember/-internals/routing/lib/system/controller_for", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = controllerFor;

  /**
  @module ember
  */

  /**
    Finds a controller instance.
  
    @for Ember
    @method controllerFor
    @private
  */
  function controllerFor(container, controllerName, lookupOptions) {
    return container.lookup("controller:" + controllerName, lookupOptions);
  }
});
define("@ember/-internals/routing/lib/system/dsl", ["exports", "@ember/debug", "@ember/polyfills"], function (_exports, _debug, _polyfills) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var uuid = 0;

  function isCallback(value) {
    return typeof value === 'function';
  }

  function isOptions(value) {
    return value !== null && typeof value === 'object';
  }

  class DSLImpl {
    constructor(name = null, options) {
      this.explicitIndex = false;
      this.parent = name;
      this.enableLoadingSubstates = Boolean(options && options.enableLoadingSubstates);
      this.matches = [];
      this.options = options;
    }

    route(name, _options, _callback) {
      var options;
      var callback = null;
      var dummyErrorRoute = "/_unused_dummy_error_path_route_" + name + "/:error";

      if (isCallback(_options)) {
        (true && !(arguments.length === 2) && (0, _debug.assert)('Unexpected arguments', arguments.length === 2));
        options = {};
        callback = _options;
      } else if (isCallback(_callback)) {
        (true && !(arguments.length === 3) && (0, _debug.assert)('Unexpected arguments', arguments.length === 3));
        (true && !(isOptions(_options)) && (0, _debug.assert)('Unexpected arguments', isOptions(_options)));
        options = _options;
        callback = _callback;
      } else {
        options = _options || {};
      }

      (true && !((() => {
        if (options.overrideNameAssertion === true) {
          return true;
        }

        return ['basic', 'application'].indexOf(name) === -1;
      })()) && (0, _debug.assert)("'" + name + "' cannot be used as a route name.", (() => {
        if (options.overrideNameAssertion === true) {
          return true;
        }

        return ['basic', 'application'].indexOf(name) === -1;
      })()));
      (true && !(name.indexOf(':') === -1) && (0, _debug.assert)("'" + name + "' is not a valid route name. It cannot contain a ':'. You may want to use the 'path' option instead.", name.indexOf(':') === -1));

      if (this.enableLoadingSubstates) {
        createRoute(this, name + "_loading", {
          resetNamespace: options.resetNamespace
        });
        createRoute(this, name + "_error", {
          resetNamespace: options.resetNamespace,
          path: dummyErrorRoute
        });
      }

      if (callback) {
        var fullName = getFullName(this, name, options.resetNamespace);
        var dsl = new DSLImpl(fullName, this.options);
        createRoute(dsl, 'loading');
        createRoute(dsl, 'error', {
          path: dummyErrorRoute
        });
        callback.call(dsl);
        createRoute(this, name, options, dsl.generate());
      } else {
        createRoute(this, name, options);
      }
    }
    /* eslint-enable no-dupe-class-members */


    push(url, name, callback, serialize) {
      var parts = name.split('.');

      if (this.options.engineInfo) {
        var localFullName = name.slice(this.options.engineInfo.fullName.length + 1);
        var routeInfo = (0, _polyfills.assign)({
          localFullName
        }, this.options.engineInfo);

        if (serialize) {
          routeInfo.serializeMethod = serialize;
        }

        this.options.addRouteForEngine(name, routeInfo);
      } else if (serialize) {
        throw new Error("Defining a route serializer on route '" + name + "' outside an Engine is not allowed.");
      }

      if (url === '' || url === '/' || parts[parts.length - 1] === 'index') {
        this.explicitIndex = true;
      }

      this.matches.push(url, name, callback);
    }

    generate() {
      var dslMatches = this.matches;

      if (!this.explicitIndex) {
        this.route('index', {
          path: '/'
        });
      }

      return match => {
        for (var i = 0; i < dslMatches.length; i += 3) {
          match(dslMatches[i]).to(dslMatches[i + 1], dslMatches[i + 2]);
        }
      };
    }

    mount(_name, options = {}) {
      var engineRouteMap = this.options.resolveRouteMap(_name);
      var name = _name;

      if (options.as) {
        name = options.as;
      }

      var fullName = getFullName(this, name, options.resetNamespace);
      var engineInfo = {
        name: _name,
        instanceId: uuid++,
        mountPoint: fullName,
        fullName
      };
      var path = options.path;

      if (typeof path !== 'string') {
        path = "/" + name;
      }

      var callback;
      var dummyErrorRoute = "/_unused_dummy_error_path_route_" + name + "/:error";

      if (engineRouteMap) {
        var shouldResetEngineInfo = false;
        var oldEngineInfo = this.options.engineInfo;

        if (oldEngineInfo) {
          shouldResetEngineInfo = true;
          this.options.engineInfo = engineInfo;
        }

        var optionsForChild = (0, _polyfills.assign)({
          engineInfo
        }, this.options);
        var childDSL = new DSLImpl(fullName, optionsForChild);
        createRoute(childDSL, 'loading');
        createRoute(childDSL, 'error', {
          path: dummyErrorRoute
        });
        engineRouteMap.class.call(childDSL);
        callback = childDSL.generate();

        if (shouldResetEngineInfo) {
          this.options.engineInfo = oldEngineInfo;
        }
      }

      var localFullName = 'application';
      var routeInfo = (0, _polyfills.assign)({
        localFullName
      }, engineInfo);

      if (this.enableLoadingSubstates) {
        // These values are important to register the loading routes under their
        // proper names for the Router and within the Engine's registry.
        var substateName = name + "_loading";
        var _localFullName = "application_loading";

        var _routeInfo = (0, _polyfills.assign)({
          localFullName: _localFullName
        }, engineInfo);

        createRoute(this, substateName, {
          resetNamespace: options.resetNamespace
        });
        this.options.addRouteForEngine(substateName, _routeInfo);
        substateName = name + "_error";
        _localFullName = "application_error";
        _routeInfo = (0, _polyfills.assign)({
          localFullName: _localFullName
        }, engineInfo);
        createRoute(this, substateName, {
          resetNamespace: options.resetNamespace,
          path: dummyErrorRoute
        });
        this.options.addRouteForEngine(substateName, _routeInfo);
      }

      this.options.addRouteForEngine(fullName, routeInfo);
      this.push(path, fullName, callback);
    }

  }

  _exports.default = DSLImpl;

  function canNest(dsl) {
    return dsl.parent !== 'application';
  }

  function getFullName(dsl, name, resetNamespace) {
    if (canNest(dsl) && resetNamespace !== true) {
      return dsl.parent + "." + name;
    } else {
      return name;
    }
  }

  function createRoute(dsl, name, options = {}, callback) {
    var fullName = getFullName(dsl, name, options.resetNamespace);

    if (typeof options.path !== 'string') {
      options.path = "/" + name;
    }

    dsl.push(options.path, fullName, callback, options.serialize);
  }
});
define("@ember/-internals/routing/lib/system/engines", [], function () {
  "use strict";
});
define("@ember/-internals/routing/lib/system/generate_controller", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.generateControllerFactory = generateControllerFactory;
  _exports.default = generateController;

  /**
  @module ember
  */

  /**
    Generates a controller factory
  
    @for Ember
    @method generateControllerFactory
    @private
  */
  function generateControllerFactory(owner, controllerName) {
    var Factory = owner.factoryFor('controller:basic').class;
    Factory = Factory.extend({
      toString() {
        return "(generated " + controllerName + " controller)";
      }

    });
    var fullName = "controller:" + controllerName;
    owner.register(fullName, Factory);
    return owner.factoryFor(fullName);
  }
  /**
    Generates and instantiates a controller extending from `controller:basic`
    if present, or `Controller` if not.
  
    @for Ember
    @method generateController
    @private
    @since 1.3.0
  */


  function generateController(owner, controllerName) {
    generateControllerFactory(owner, controllerName);
    var fullName = "controller:" + controllerName;
    var instance = owner.lookup(fullName);

    if (true
    /* DEBUG */
    ) {
      if ((0, _metal.get)(instance, 'namespace.LOG_ACTIVE_GENERATION')) {
        (0, _debug.info)("generated -> " + fullName, {
          fullName
        });
      }
    }

    return instance;
  }
});
define("@ember/-internals/routing/lib/system/query_params", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QueryParams {
    constructor(values = null) {
      this.isQueryParams = true;
      this.values = values;
    }

  }

  _exports.default = QueryParams;
});
define("@ember/-internals/routing/lib/system/route-info", [], function () {
  "use strict";
  /**
    A `RouteInfoWithAttributes` is an object that contains
    metadata, including the resolved value from the routes
    `model` hook. Like `RouteInfo`, a `RouteInfoWithAttributes`
    represents a specific route within a Transition.
    It is read-only and internally immutable. It is also not
    observable, because a Transition instance is never
    changed after creation.
  
    @class RouteInfoWithAttributes
    @public
  */

  /**
    The dot-separated, fully-qualified name of the
    route, like "people.index".
    @property {String} name
    @public
  */

  /**
    The final segment of the fully-qualified name of
    the route, like "index"
    @property {String} localName
    @public
  */

  /**
    The values of the route's parameters. These are the
    same params that are received as arguments to the
    route's model hook. Contains only the parameters
    valid for this route, if any (params for parent or
    child routes are not merged).
    @property {Object} params
    @public
  */

  /**
    The ordered list of the names of the params
    required for this route. It will contain the same
    strings as `Object.keys(params)`, but here the order
    is significant. This allows users to correctly pass
    params into routes programmatically.
    @property {Array} paramNames
    @public
  */

  /**
    The values of any queryParams on this route.
    @property {Object} queryParams
    @public
  */

  /**
    This is the resolved return value from the
    route's model hook.
    @property {Object|Array|String} attributes
    @public
  */

  /**
    Will contain the result `Route#buildRouteInfoMetadata`
    for the corresponding Route.
    @property {Any} metadata
    @public
  */

  /**
    A reference to the parent route's RouteInfo.
    This can be used to traverse upward to the topmost
    `RouteInfo`.
    @property {RouteInfo|null} parent
    @public
  */

  /**
    A reference to the child route's RouteInfo.
    This can be used to traverse downward to the
    leafmost `RouteInfo`.
    @property {RouteInfo|null} child
    @public
  */

  /**
    Allows you to traverse through the linked list
    of `RouteInfo`s from the topmost to leafmost.
    Returns the first `RouteInfo` in the linked list
    for which the callback returns true.
  
      This method is similar to the `find()` method
      defined in ECMAScript 2015.
  
      The callback method you provide should have the
      following signature (all parameters are optional):
  
      ```javascript
      function(item, index, array);
      ```
  
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
  
      It should return the `true` to include the item in
      the results, `false` otherwise.
  
      Note that in addition to a callback, you can also
      pass an optional target object that will be set as
      `this` on the context.
  
    @method find
    @param {Function} callback the callback to execute
    @param {Object} [target*] optional target to use
    @returns {Object} Found item or undefined
    @public
  */

  /**
    A RouteInfo is an object that contains metadata
    about a specific route within a Transition. It is
    read-only and internally immutable. It is also not
    observable, because a Transition instance is never
    changed after creation.
  
    @class RouteInfo
    @public
  */

  /**
    The dot-separated, fully-qualified name of the
    route, like "people.index".
    @property {String} name
    @public
  */

  /**
    The final segment of the fully-qualified name of
    the route, like "index"
    @property {String} localName
    @public
  */

  /**
    The values of the route's parameters. These are the
    same params that are received as arguments to the
    route's `model` hook. Contains only the parameters
    valid for this route, if any (params for parent or
    child routes are not merged).
    @property {Object} params
    @public
  */

  /**
    The ordered list of the names of the params
    required for this route. It will contain the same
    strings as Object.keys(params), but here the order
    is significant. This allows users to correctly pass
    params into routes programmatically.
    @property {Array} paramNames
    @public
  */

  /**
    The values of any queryParams on this route.
    @property {Object} queryParams
    @public
  */

  /**
    A reference to the parent route's `RouteInfo`.
    This can be used to traverse upward to the topmost
    `RouteInfo`.
    @property {RouteInfo|null} parent
    @public
  */

  /**
    A reference to the child route's `RouteInfo`.
    This can be used to traverse downward to the
    leafmost `RouteInfo`.
    @property {RouteInfo|null} child
    @public
  */

  /**
    Allows you to traverse through the linked list
    of `RouteInfo`s from the topmost to leafmost.
    Returns the first `RouteInfo` in the linked list
    for which the callback returns true.
  
      This method is similar to the `find()` method
      defined in ECMAScript 2015.
  
      The callback method you provide should have the
      following signature (all parameters are optional):
  
      ```javascript
      function(item, index, array);
      ```
  
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
  
      It should return the `true` to include the item in
      the results, `false` otherwise.
  
      Note that in addition to a callback, you can also
      pass an optional target object that will be set as
      `this` on the context.
  
    @method find
    @param {Function} callback the callback to execute
    @param {Object} [target*] optional target to use
    @returns {Object} Found item or undefined
    @public
  */
});
define("@ember/-internals/routing/lib/system/route", ["exports", "@ember/polyfills", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/debug", "@ember/deprecated-features", "@ember/object/compat", "@ember/runloop", "@ember/string", "router_js", "@ember/-internals/routing/lib/utils", "@ember/-internals/routing/lib/system/generate_controller"], function (_exports, _polyfills, _metal, _owner, _runtime, _utils, _debug, _deprecatedFeatures, _compat, _runloop, _string, _router_js, _utils2, _generate_controller) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.defaultSerialize = defaultSerialize;
  _exports.hasDefaultSerialize = hasDefaultSerialize;
  _exports.default = _exports.ROUTER_EVENT_DEPRECATIONS = _exports.ROUTE_CONNECTIONS = void 0;
  var ROUTE_CONNECTIONS = new WeakMap();
  _exports.ROUTE_CONNECTIONS = ROUTE_CONNECTIONS;

  function defaultSerialize(model, params) {
    if (params.length < 1 || !model) {
      return;
    }

    var object = {};

    if (params.length === 1) {
      var [name] = params;

      if (name in model) {
        object[name] = (0, _metal.get)(model, name);
      } else if (/_id$/.test(name)) {
        object[name] = (0, _metal.get)(model, 'id');
      }
    } else {
      object = (0, _metal.getProperties)(model, params);
    }

    return object;
  }

  function hasDefaultSerialize(route) {
    return route.serialize === defaultSerialize;
  }
  /**
  @module @ember/routing
  */

  /**
    The `Route` class is used to define individual routes. Refer to
    the [routing guide](https://guides.emberjs.com/release/routing/) for documentation.
  
    @class Route
    @extends EmberObject
    @uses ActionHandler
    @uses Evented
    @since 1.0.0
    @public
  */


  class Route extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.context = {};
    }
    /**
      The name of the route, dot-delimited.
         For example, a route found at `app/routes/posts/post.js` will have
      a `routeName` of `posts.post`.
         @property routeName
      @for Route
      @type String
      @since 1.0.0
      @public
    */

    /**
      The name of the route, dot-delimited, including the engine prefix
      if applicable.
         For example, a route found at `addon/routes/posts/post.js` within an
      engine named `admin` will have a `fullRouteName` of `admin.posts.post`.
         @property fullRouteName
      @for Route
      @type String
      @since 2.10.0
      @public
    */

    /**
      Sets the name for this route, including a fully resolved name for routes
      inside engines.
         @private
      @method _setRouteName
      @param {String} name
    */


    _setRouteName(name) {
      this.routeName = name;
      this.fullRouteName = getEngineRouteName((0, _owner.getOwner)(this), name);
    }
    /**
      @private
         @method _stashNames
    */


    _stashNames(routeInfo, dynamicParent) {
      if (this._names) {
        return;
      }

      var names = this._names = routeInfo['_names'];

      if (!names.length) {
        routeInfo = dynamicParent;
        names = routeInfo && routeInfo['_names'] || [];
      }

      var qps = (0, _metal.get)(this, '_qp.qps');
      var namePaths = new Array(names.length);

      for (var a = 0; a < names.length; ++a) {
        namePaths[a] = routeInfo.name + "." + names[a];
      }

      for (var i = 0; i < qps.length; ++i) {
        var qp = qps[i];

        if (qp.scope === 'model') {
          qp.parts = namePaths;
        }
      }
    }
    /**
      @private
         @property _activeQPChanged
    */


    _activeQPChanged(qp, value) {
      this._router._activeQPChanged(qp.scopedPropertyName, value);
    }
    /**
      @private
      @method _updatingQPChanged
    */


    _updatingQPChanged(qp) {
      this._router._updatingQPChanged(qp.urlKey);
    }
    /**
      Returns a hash containing the parameters of an ancestor route.
         You may notice that `this.paramsFor` sometimes works when referring to a
      child route, but this behavior should not be relied upon as only ancestor
      routes are certain to be loaded in time.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('member', { path: ':name' }, function() {
          this.route('interest', { path: ':interest' });
        });
      });
      ```
         ```app/routes/member.js
      import Route from '@ember/routing/route';
         export default class MemberRoute extends Route {
        queryParams = {
          memberQp: { refreshModel: true }
        }
      }
      ```
         ```app/routes/member/interest.js
      import Route from '@ember/routing/route';
         export default class MemberInterestRoute Route {
        queryParams = {
          interestQp: { refreshModel: true }
        }
           model() {
          return this.paramsFor('member');
        }
      }
      ```
         If we visit `/turing/maths?memberQp=member&interestQp=interest` the model for
      the `member.interest` route is a hash with:
         * `name`: `turing`
      * `memberQp`: `member`
         @method paramsFor
      @param {String} name
      @return {Object} hash containing the parameters of the route `name`
      @since 1.4.0
      @public
    */


    paramsFor(name) {
      var route = (0, _owner.getOwner)(this).lookup("route:" + name);

      if (route === undefined) {
        return {};
      }

      var transition = this._router._routerMicrolib.activeTransition;
      var state = transition ? transition[_router_js.STATE_SYMBOL] : this._router._routerMicrolib.state;
      var fullName = route.fullRouteName;
      var params = (0, _polyfills.assign)({}, state.params[fullName]);
      var queryParams = getQueryParamsFor(route, state);
      return Object.keys(queryParams).reduce((params, key) => {
        (true && !(!params[key]) && (0, _debug.assert)("The route '" + this.routeName + "' has both a dynamic segment and query param with name '" + key + "'. Please rename one to avoid collisions.", !params[key]));
        params[key] = queryParams[key];
        return params;
      }, params);
    }
    /**
      Serializes the query parameter key
         @method serializeQueryParamKey
      @param {String} controllerPropertyName
      @private
    */


    serializeQueryParamKey(controllerPropertyName) {
      return controllerPropertyName;
    }
    /**
      Serializes value of the query parameter based on defaultValueType
         @method serializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */


    serializeQueryParam(value, _urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide serialization specific
      // to a certain query param.
      return this._router._serializeQueryParam(value, defaultValueType);
    }
    /**
      Deserializes value of the query parameter based on defaultValueType
         @method deserializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */


    deserializeQueryParam(value, _urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide deserialization specific
      // to a certain query param.
      return this._router._deserializeQueryParam(value, defaultValueType);
    }
    /**
      @private
         @property _optionsForQueryParam
    */


    _optionsForQueryParam(qp) {
      return (0, _metal.get)(this, "queryParams." + qp.urlKey) || (0, _metal.get)(this, "queryParams." + qp.prop) || {};
    }
    /**
      A hook you can use to reset controller values either when the model
      changes or the route is exiting.
         ```app/routes/articles.js
      import Route from '@ember/routing/route';
         export default class ArticlesRoute extends Route {
        resetController(controller, isExiting, transition) {
          if (isExiting && transition.targetName !== 'error') {
            controller.set('page', 1);
          }
        }
      }
      ```
         @method resetController
      @param {Controller} controller instance
      @param {Boolean} isExiting
      @param {Object} transition
      @since 1.7.0
      @public
    */


    resetController(_controller, _isExiting, _transition) {
      return this;
    }
    /**
      @private
         @method exit
    */


    exit() {
      this.deactivate();
      this.trigger('deactivate');
      this.teardownViews();
    }
    /**
      @private
         @method _internalReset
      @since 3.6.0
    */


    _internalReset(isExiting, transition) {
      var controller = this.controller;
      controller._qpDelegate = (0, _metal.get)(this, '_qp.states.inactive');
      this.resetController(controller, isExiting, transition);
    }
    /**
      @private
         @method enter
    */


    enter() {
      ROUTE_CONNECTIONS.set(this, []);
      this.activate();
      this.trigger('activate');
    }
    /**
      The `willTransition` action is fired at the beginning of any
      attempted transition with a `Transition` object as the sole
      argument. This action can be used for aborting, redirecting,
      or decorating the transition from the currently active routes.
         A good example is preventing navigation when a form is
      half-filled out:
         ```app/routes/contact-form.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ContactFormRoute extends Route {
        @action
        willTransition(transition) {
          if (this.controller.get('userHasEnteredData')) {
            this.controller.displayNavigationConfirm();
            transition.abort();
          }
        }
      }
      ```
         You can also redirect elsewhere by calling
      `this.transitionTo('elsewhere')` from within `willTransition`.
      Note that `willTransition` will not be fired for the
      redirecting `transitionTo`, since `willTransition` doesn't
      fire when there is already a transition underway. If you want
      subsequent `willTransition` actions to fire for the redirecting
      transition, you must first explicitly call
      `transition.abort()`.
         To allow the `willTransition` event to continue bubbling to the parent
      route, use `return true;`. When the `willTransition` method has a
      return value of `true` then the parent route's `willTransition` method
      will be fired, enabling "bubbling" behavior for the event.
         @event willTransition
      @param {Transition} transition
      @since 1.0.0
      @public
    */

    /**
      The `didTransition` action is fired after a transition has
      successfully been completed. This occurs after the normal model
      hooks (`beforeModel`, `model`, `afterModel`, `setupController`)
      have resolved. The `didTransition` action has no arguments,
      however, it can be useful for tracking page views or resetting
      state on the controller.
         ```app/routes/login.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class LoginRoute extends Route {
        @action
        didTransition() {
          this.controller.get('errors.base').clear();
          return true; // Bubble the didTransition event
        }
      }
      ```
         @event didTransition
      @since 1.2.0
      @public
    */

    /**
      The `loading` action is fired on the route when a route's `model`
      hook returns a promise that is not already resolved. The current
      `Transition` object is the first parameter and the route that
      triggered the loading event is the second parameter.
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        loading(transition, route) {
          let controller = this.controllerFor('foo');
          controller.set('currentlyLoading', true);
             transition.finally(function() {
            controller.set('currentlyLoading', false);
          });
        }
      }
      ```
         @event loading
      @param {Transition} transition
      @param {Route} route The route that triggered the loading event
      @since 1.2.0
      @public
    */

    /**
      When attempting to transition into a route, any of the hooks
      may return a promise that rejects, at which point an `error`
      action will be fired on the partially-entered routes, allowing
      for per-route error handling logic, or shared error handling
      logic defined on a parent route.
         Here is an example of an error handler that will be invoked
      for rejected promises from the various hooks on the route,
      as well as any unhandled errors from child routes:
         ```app/routes/admin.js
      import { reject } from 'rsvp';
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class AdminRoute extends Route {
        beforeModel() {
          return reject('bad things!');
        }
           @action
        error(error, transition) {
          // Assuming we got here due to the error in `beforeModel`,
          // we can expect that error === "bad things!",
          // but a promise model rejecting would also
          // call this hook, as would any errors encountered
          // in `afterModel`.
             // The `error` hook is also provided the failed
          // `transition`, which can be stored and later
          // `.retry()`d if desired.
             this.transitionTo('login');
        }
      }
      ```
         `error` actions that bubble up all the way to `ApplicationRoute`
      will fire a default error handler that logs the error. You can
      specify your own global default error handler by overriding the
      `error` handler on `ApplicationRoute`:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        error(error, transition) {
          this.controllerFor('banner').displayError(error.message);
        }
      }
      ```
      @event error
      @param {Error} error
      @param {Transition} transition
      @since 1.0.0
      @public
    */

    /**
      This event is triggered when the router enters the route. It is
      not executed when the model for the route changes.
         ```app/routes/application.js
      import { on } from '@ember/object/evented';
      import Route from '@ember/routing/route';
         export default Route.extend({
        collectAnalytics: on('activate', function(){
          collectAnalytics();
        })
      });
      ```
         @event activate
      @since 1.9.0
      @public
    */

    /**
      This event is triggered when the router completely exits this
      route. It is not executed when the model for the route changes.
         ```app/routes/index.js
      import { on } from '@ember/object/evented';
      import Route from '@ember/routing/route';
         export default Route.extend({
        trackPageLeaveAnalytics: on('deactivate', function(){
          trackPageLeaveAnalytics();
        })
      });
      ```
         @event deactivate
      @since 1.9.0
      @public
    */

    /**
      This hook is executed when the router completely exits this route. It is
      not executed when the model for the route changes.
         @method deactivate
      @since 1.0.0
      @public
    */


    deactivate() {}
    /**
      This hook is executed when the router enters the route. It is not executed
      when the model for the route changes.
         @method activate
      @since 1.0.0
      @public
    */


    activate() {}
    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         ```javascript
      this.transitionTo('blogPosts');
      this.transitionTo('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      this.transitionTo('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      this.transitionTo('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('blogPost', { path:':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId' });
        });
      });
         export default Router;
      ```
         ```javascript
      this.transitionTo('blogComment', aPost, aComment);
      this.transitionTo('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      this.transitionTo('/');
      this.transitionTo('/blog/post/1/comment/13');
      this.transitionTo('/blog/posts?sort=title');
      ```
         An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
         ```javascript
      this.transitionTo('blogPost', 1, {
        queryParams: { showComments: 'true' }
      });
         // if you just want to transition the query parameters without changing the route
      this.transitionTo({ queryParams: { sort: 'date' } });
      ```
         See also [replaceWith](#method_replaceWith).
         Simple Transition Example
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('secret');
        this.route('fourOhFour', { path: '*:' });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        moveToSecret(context) {
          if (authorized()) {
            this.transitionTo('secret', context);
          } else {
            this.transitionTo('fourOhFour');
          }
        }
      }
      ```
         Transition to a nested route
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('articles', { path: '/articles' }, function() {
          this.route('new');
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        transitionToNewArticle() {
          this.transitionTo('articles.new');
        }
      }
      ```
         Multiple Models Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
           this.route('breakfast', { path: ':breakfastId' }, function() {
          this.route('cereal', { path: ':cerealId' });
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        moveToChocolateCereal() {
          let cereal = { cerealId: 'ChocolateYumminess' };
          let breakfast = { breakfastId: 'CerealAndMilk' };
             this.transitionTo('breakfast.cereal', breakfast, cereal);
        }
      }
      ```
         Nested Route with Query String Example
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('fruits', function() {
          this.route('apples');
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
         export default class IndexRoute extends Route {
        @action
        transitionToApples() {
          this.transitionTo('fruits.apples', { queryParams: { color: 'red' } });
        }
      }
      ```
         @method transitionTo
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.0.0
      @public
    */


    transitionTo(...args) {
      // eslint-disable-line no-unused-vars
      return this._router.transitionTo(...(0, _utils2.prefixRouteNameArg)(this, args));
    }
    /**
      Perform a synchronous transition into another route without attempting
      to resolve promises, update the URL, or abort any currently active
      asynchronous transitions (i.e. regular transitions caused by
      `transitionTo` or URL changes).
         This method is handy for performing intermediate transitions on the
      way to a final destination route, and is called internally by the
      default implementations of the `error` and `loading` handlers.
         @method intermediateTransitionTo
      @param {String} name the name of the route
      @param {...Object} models the model(s) to be used while transitioning
      to the route.
      @since 1.2.0
      @public
     */


    intermediateTransitionTo(...args) {
      var [name, ...preparedArgs] = (0, _utils2.prefixRouteNameArg)(this, args);

      this._router.intermediateTransitionTo(name, ...preparedArgs);
    }
    /**
      Refresh the model on this route and any child routes, firing the
      `beforeModel`, `model`, and `afterModel` hooks in a similar fashion
      to how routes are entered when transitioning in from other route.
      The current route params (e.g. `article_id`) will be passed in
      to the respective model hooks, and if a different model is returned,
      `setupController` and associated route hooks will re-fire as well.
         An example usage of this method is re-querying the server for the
      latest information using the same parameters as when the route
      was first entered.
         Note that this will cause `model` hooks to fire even on routes
      that were provided a model object when the route was initially
      entered.
         @method refresh
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.4.0
      @public
     */


    refresh() {
      return this._router._routerMicrolib.refresh(this);
    }
    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionTo` in all other respects. See
      'transitionTo' for additional information regarding multiple models.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('secret');
      });
         export default Router;
      ```
         ```app/routes/secret.js
      import Route from '@ember/routing/route';
         export default class SecretRoute Route {
        afterModel() {
          if (!authorized()){
            this.replaceWith('index');
          }
        }
      }
      ```
         @method replaceWith
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.0.0
      @public
    */


    replaceWith(...args) {
      return this._router.replaceWith(...(0, _utils2.prefixRouteNameArg)(this, args));
    }
    /**
      This hook is the entry point for router.js
         @private
      @method setup
    */


    setup(context, transition) {
      var controllerName = this.controllerName || this.routeName;
      var definedController = this.controllerFor(controllerName, true);
      var controller;

      if (definedController) {
        controller = definedController;
      } else {
        controller = this.generateController(controllerName);
      } // Assign the route's controller so that it can more easily be
      // referenced in action handlers. Side effects. Side effects everywhere.


      if (!this.controller) {
        var qp = (0, _metal.get)(this, '_qp');
        var propNames = qp !== undefined ? (0, _metal.get)(qp, 'propertyNames') : [];
        addQueryParamsObservers(controller, propNames);
        this.controller = controller;
      }

      var queryParams = (0, _metal.get)(this, '_qp');
      var states = queryParams.states;
      controller._qpDelegate = states.allowOverrides;

      if (transition) {
        // Update the model dep values used to calculate cache keys.
        (0, _utils2.stashParamNames)(this._router, transition[_router_js.STATE_SYMBOL].routeInfos);
        var cache = this._bucketCache;
        var params = transition[_router_js.PARAMS_SYMBOL];
        var allParams = queryParams.propertyNames;
        allParams.forEach(prop => {
          var aQp = queryParams.map[prop];
          aQp.values = params;
          var cacheKey = (0, _utils2.calculateCacheKey)(aQp.route.fullRouteName, aQp.parts, aQp.values);
          var value = cache.lookup(cacheKey, prop, aQp.undecoratedDefaultValue);
          (0, _metal.set)(controller, prop, value);
        });
        var qpValues = getQueryParamsFor(this, transition[_router_js.STATE_SYMBOL]);
        (0, _metal.setProperties)(controller, qpValues);
      }

      this.setupController(controller, context, transition);

      if (this._environment.options.shouldRender) {
        this.renderTemplate(controller, context);
      } // Setup can cause changes to QPs which need to be propogated immediately in
      // some situations. Eventually, we should work on making these async somehow.


      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          (0, _metal.flushAsyncObservers)(false);
        }
    }
    /*
      Called when a query parameter for this route changes, regardless of whether the route
      is currently part of the active route hierarchy. This will update the query parameter's
      value in the cache so if this route becomes active, the cache value has been updated.
    */


    _qpChanged(prop, value, qp) {
      if (!qp) {
        return;
      } // Update model-dep cache


      var cache = this._bucketCache;
      var cacheKey = (0, _utils2.calculateCacheKey)(qp.route.fullRouteName, qp.parts, qp.values);
      cache.stash(cacheKey, prop, value);
    }
    /**
      This hook is the first of the route entry validation hooks
      called when an attempt is made to transition into a route
      or one of its children. It is called before `model` and
      `afterModel`, and is appropriate for cases when:
         1) A decision can be made to redirect elsewhere without
         needing to resolve the model first.
      2) Any async operations need to occur first before the
         model is attempted to be resolved.
         This hook is provided the current `transition` attempt
      as a parameter, which can be used to `.abort()` the transition,
      save it for a later `.retry()`, or retrieve values set
      on it from a previous hook. You can also just call
      `this.transitionTo` to another route to implicitly
      abort the `transition`.
         You can return a promise from this hook to pause the
      transition until the promise resolves (or rejects). This could
      be useful, for instance, for retrieving async code from
      the server that is required to enter a route.
         @method beforeModel
      @param {Transition} transition
      @return {any | Promise<any>} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
      @since 1.0.0
      @public
    */


    beforeModel() {}
    /**
      This hook is called after this route's model has resolved.
      It follows identical async/promise semantics to `beforeModel`
      but is provided the route's resolved model in addition to
      the `transition`, and is therefore suited to performing
      logic that can only take place after the model has already
      resolved.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        afterModel(posts, transition) {
          if (posts.get('length') === 1) {
            this.transitionTo('post.show', posts.get('firstObject'));
          }
        }
      }
      ```
         Refer to documentation for `beforeModel` for a description
      of transition-pausing semantics when a promise is returned
      from this hook.
         @method afterModel
      @param {Object} resolvedModel the value returned from `model`,
        or its resolved value if it was a promise
      @param {Transition} transition
      @return {any | Promise<any>} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
      @since 1.0.0
      @public
     */


    afterModel() {}
    /**
      A hook you can implement to optionally redirect to another route.
         If you call `this.transitionTo` from inside of this hook, this route
      will not be entered in favor of the other hook.
         `redirect` and `afterModel` behave very similarly and are
      called almost at the same time, but they have an important
      distinction in the case that, from one of these hooks, a
      redirect into a child route of this route occurs: redirects
      from `afterModel` essentially invalidate the current attempt
      to enter this route, and will result in this route's `beforeModel`,
      `model`, and `afterModel` hooks being fired again within
      the new, redirecting transition. Redirects that occur within
      the `redirect` hook, on the other hand, will _not_ cause
      these hooks to be fired again the second time around; in
      other words, by the time the `redirect` hook has been called,
      both the resolved model and attempted entry into this route
      are considered to be fully validated.
         @method redirect
      @param {Object} model the model for this route
      @param {Transition} transition the transition object associated with the current transition
      @since 1.0.0
      @public
    */


    redirect() {}
    /**
      Called when the context is changed by router.js.
         @private
      @method contextDidChange
    */


    contextDidChange() {
      this.currentModel = this.context;
    }
    /**
      A hook you can implement to convert the URL into the model for
      this route.
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         The model for the `post` route is `store.findRecord('post', params.post_id)`.
         By default, if your route has a dynamic segment ending in `_id`:
         * The model class is determined from the segment (`post_id`'s
        class is `App.Post`)
      * The find method is called on the model class with the value of
        the dynamic segment.
         Note that for routes with dynamic segments, this hook is not always
      executed. If the route is entered through a transition (e.g. when
      using the `link-to` Handlebars helper or the `transitionTo` method
      of routes), and a model context is already provided this hook
      is not called.
         A model context does not include a primitive string or number,
      which does cause the model hook to be called.
         Routes without dynamic segments will always execute the model hook.
         ```javascript
      // no dynamic segment, model hook always called
      this.transitionTo('posts');
         // model passed in, so model hook not called
      thePost = store.findRecord('post', 1);
      this.transitionTo('post', thePost);
         // integer passed in, model hook is called
      this.transitionTo('post', 1);
         // model id passed in, model hook is called
      // useful for forcing the hook to execute
      thePost = store.findRecord('post', 1);
      this.transitionTo('post', thePost.id);
      ```
         This hook follows the asynchronous/promise semantics
      described in the documentation for `beforeModel`. In particular,
      if a promise returned from `model` fails, the error will be
      handled by the `error` hook on `Route`.
         Example
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        model(params) {
          return this.store.findRecord('post', params.post_id);
        }
      }
      ```
         @method model
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {any | Promise<any>} the model for this route. If
        a promise is returned, the transition will pause until
        the promise resolves, and the resolved value of the promise
        will be used as the model for this route.
      @since 1.0.0
      @public
    */


    model(params, transition) {
      var name, sawParams, value;
      var queryParams = (0, _metal.get)(this, '_qp.map');

      for (var prop in params) {
        if (prop === 'queryParams' || queryParams && prop in queryParams) {
          continue;
        }

        var match = prop.match(/^(.*)_id$/);

        if (match !== null) {
          name = match[1];
          value = params[prop];
        }

        sawParams = true;
      }

      if (!name) {
        if (sawParams) {
          return (0, _polyfills.assign)({}, params);
        } else {
          if (transition.resolveIndex < 1) {
            return;
          }

          return transition[_router_js.STATE_SYMBOL].routeInfos[transition.resolveIndex - 1].context;
        }
      }

      return this.findModel(name, value);
    }
    /**
      @private
      @method deserialize
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {any | Promise<any>} the model for this route.
         Router.js hook.
     */


    deserialize(_params, transition) {
      return this.model(this._paramsFor(this.routeName, _params), transition);
    }
    /**
         @method findModel
      @param {String} type the model type
      @param {Object} value the value passed to find
      @private
    */


    findModel(...args) {
      return (0, _metal.get)(this, 'store').find(...args);
    }
    /**
      A hook you can use to setup the controller for the current route.
         This method is called with the controller for the current route and the
      model supplied by the `model` hook.
         By default, the `setupController` hook sets the `model` property of
      the controller to the specified `model` when it is not `undefined`.
         If you implement the `setupController` hook in your Route, it will
      prevent this default behavior. If you want to preserve that behavior
      when implementing your `setupController` function, make sure to call
      `super`:
         ```app/routes/photos.js
      import Route from '@ember/routing/route';
         export default class PhotosRoute extendes Route {
        model() {
          return this.store.findAll('photo');
        }
           setupController(controller, model) {
          super.setupController(controller, model);
             this.controllerFor('application').set('showingPhotos', true);
        }
      }
      ```
         The provided controller will be one resolved based on the name
      of this route.
         If no explicit controller is defined, Ember will automatically create one.
         As an example, consider the router:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         If you have defined a file for the post controller,
      the framework will use it.
      If it is not defined, a basic `Controller` instance would be used.
         @example Behavior of a basic Controller
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        setupController(controller, model) {
          controller.set('model', model);
        }
      });
      ```
         @method setupController
      @param {Controller} controller instance
      @param {Object} model
      @since 1.0.0
      @public
    */


    setupController(controller, context, _transition) {
      // eslint-disable-line no-unused-vars
      if (controller && context !== undefined) {
        (0, _metal.set)(controller, 'model', context);
      }
    }
    /**
      Returns the controller of the current route, or a parent (or any ancestor)
      route in a route hierarchy.
         The controller instance must already have been created, either through entering the
      associated route or using `generateController`.
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        setupController(controller, post) {
          super.setupController(controller, post);
             this.controllerFor('posts').set('currentPost', post);
        }
      }
      ```
         @method controllerFor
      @param {String} name the name of the route or controller
      @return {Controller}
      @since 1.0.0
      @public
    */


    controllerFor(name, _skipAssert) {
      var owner = (0, _owner.getOwner)(this);
      var route = owner.lookup("route:" + name);

      if (route && route.controllerName) {
        name = route.controllerName;
      }

      var controller = owner.lookup("controller:" + name); // NOTE: We're specifically checking that skipAssert is true, because according
      //   to the old API the second parameter was model. We do not want people who
      //   passed a model to skip the assertion.

      (true && !(controller !== undefined || _skipAssert === true) && (0, _debug.assert)("The controller named '" + name + "' could not be found. Make sure that this route exists and has already been entered at least once. If you are accessing a controller not associated with a route, make sure the controller class is explicitly defined.", controller !== undefined || _skipAssert === true));
      return controller;
    }
    /**
      Generates a controller for a route.
         Example
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class Post extends Route {
        setupController(controller, post) {
          super.setupController(controller, post);
             this.generateController('posts');
        }
      }
      ```
         @method generateController
      @param {String} name the name of the controller
      @private
    */


    generateController(name) {
      var owner = (0, _owner.getOwner)(this);
      return (0, _generate_controller.default)(owner, name);
    }
    /**
      Returns the resolved model of a parent (or any ancestor) route
      in a route hierarchy.  During a transition, all routes
      must resolve a model object, and if a route
      needs access to a parent route's model in order to
      resolve a model (or just reuse the model from a parent),
      it can call `this.modelFor(theNameOfParentRoute)` to
      retrieve it. If the ancestor route's model was a promise,
      its resolved result is returned.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' }, function() {
          this.route('comments');
        });
      });
         export default Router;
      ```
         ```app/routes/post/comments.js
      import Route from '@ember/routing/route';
         export default class PostCommentsRoute extends Route {
        model() {
          let post = this.modelFor('post');
             return post.comments;
        }
      }
      ```
         @method modelFor
      @param {String} name the name of the route
      @return {Object} the model object
      @since 1.0.0
      @public
    */


    modelFor(_name) {
      var name;
      var owner = (0, _owner.getOwner)(this);
      var transition = this._router && this._router._routerMicrolib ? this._router._routerMicrolib.activeTransition : undefined; // Only change the route name when there is an active transition.
      // Otherwise, use the passed in route name.

      if (owner.routable && transition !== undefined) {
        name = getEngineRouteName(owner, _name);
      } else {
        name = _name;
      }

      var route = owner.lookup("route:" + name); // If we are mid-transition, we want to try and look up
      // resolved parent contexts on the current transitionEvent.

      if (transition !== undefined && transition !== null) {
        var modelLookupName = route && route.routeName || name;

        if (transition.resolvedModels.hasOwnProperty(modelLookupName)) {
          return transition.resolvedModels[modelLookupName];
        }
      }

      return route && route.currentModel;
    }
    /**
      A hook you can use to render the template for the current route.
         This method is called with the controller for the current route and the
      model supplied by the `model` hook. By default, it renders the route's
      template, configured with the controller for the route.
         This method can be overridden to set up and render additional or
      alternative templates.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        renderTemplate(controller, model) {
          let favController = this.controllerFor('favoritePost');
             // Render the `favoritePost` template into
          // the outlet `posts`, and display the `favoritePost`
          // controller.
          this.render('favoritePost', {
            outlet: 'posts',
            controller: favController
          });
        }
      }
      ```
         @method renderTemplate
      @param {Object} controller the route's controller
      @param {Object} model the route's model
      @since 1.0.0
      @public
    */


    renderTemplate(_controller, _model) {
      // eslint-disable-line no-unused-vars
      this.render();
    }
    /**
      `render` is used to render a template into a region of another template
      (indicated by an `{{outlet}}`). `render` is used both during the entry
      phase of routing (via the `renderTemplate` hook) and later in response to
      user interaction.
         For example, given the following minimal router and templates:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('photos');
      });
         export default Router;
      ```
         ```handlebars
      <!-- application.hbs -->
      <div class='something-in-the-app-hbs'>
        {{outlet "anOutletName"}}
      </div>
      ```
         ```handlebars
      <!-- photos.hbs -->
      <h1>Photos</h1>
      ```
         You can render `photos.hbs` into the `"anOutletName"` outlet of
      `application.hbs` by calling `render`:
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        renderTemplate() {
          this.render('photos', {
            into: 'application',
            outlet: 'anOutletName'
          })
        }
      }
      ```
         `render` additionally allows you to supply which `controller` and
      `model` objects should be loaded and associated with the rendered template.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        renderTemplate(controller, model){
          this.render('posts', {    // the template to render, referenced by name
            into: 'application',    // the template to render into, referenced by name
            outlet: 'anOutletName', // the outlet inside `options.into` to render into.
            controller: 'someControllerName', // the controller to use for this template, referenced by name
            model: model            // the model to set on `options.controller`.
          })
        }
      }
      ```
         The string values provided for the template name, and controller
      will eventually pass through to the resolver for lookup. See
      Resolver for how these are mapped to JavaScript objects in your
      application. The template to render into needs to be related to  either the
      current route or one of its ancestors.
         Not all options need to be passed to `render`. Default values will be used
      based on the name of the route specified in the router or the Route's
      `controllerName` and `templateName` properties.
         For example:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        renderTemplate() {
          this.render(); // all defaults apply
        }
      }
      ```
         The name of the route, defined by the router, is `post`.
         The following equivalent default options will be applied when
      the Route calls `render`:
         ```javascript
      this.render('post', {  // the template name associated with 'post' Route
        into: 'application', // the parent route to 'post' Route
        outlet: 'main',      // {{outlet}} and {{outlet 'main'}} are synonymous,
        controller: 'post',  // the controller associated with the 'post' Route
      })
      ```
         By default the controller's `model` will be the route's model, so it does not
      need to be passed unless you wish to change which model is being used.
         @method render
      @param {String} name the name of the template to render
      @param {Object} [options] the options
      @param {String} [options.into] the template to render into,
                      referenced by name. Defaults to the parent template
      @param {String} [options.outlet] the outlet inside `options.into` to render into.
                      Defaults to 'main'
      @param {String|Object} [options.controller] the controller to use for this template,
                      referenced by name or as a controller instance. Defaults to the Route's paired controller
      @param {Object} [options.model] the model object to set on `options.controller`.
                      Defaults to the return value of the Route's model hook
      @since 1.0.0
      @public
    */


    render(_name, options) {
      var name;
      var isDefaultRender = arguments.length === 0;

      if (!isDefaultRender) {
        if (typeof _name === 'object' && !options) {
          name = this.templateName || this.routeName;
          options = _name;
        } else {
          (true && !(!(0, _metal.isEmpty)(_name)) && (0, _debug.assert)('The name in the given arguments is undefined or empty string', !(0, _metal.isEmpty)(_name)));
          name = _name;
        }
      }

      var renderOptions = buildRenderOptions(this, isDefaultRender, name, options);
      ROUTE_CONNECTIONS.get(this).push(renderOptions);
      (0, _runloop.once)(this._router, '_setOutlets');
    }
    /**
      Disconnects a view that has been rendered into an outlet.
         You may pass any or all of the following options to `disconnectOutlet`:
         * `outlet`: the name of the outlet to clear (default: 'main')
      * `parentView`: the name of the view containing the outlet to clear
         (default: the view rendered by the parent route)
         Example:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        showModal(evt) {
          this.render(evt.modalName, {
            outlet: 'modal',
            into: 'application'
          });
        }
           @action
        hideModal() {
          this.disconnectOutlet({
            outlet: 'modal',
            parentView: 'application'
          });
        }
      }
      ```
         Alternatively, you can pass the `outlet` name directly as a string.
         Example:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        showModal(evt) {
          // ...
        }
           @action
        hideModal(evt) {
          this.disconnectOutlet('modal');
        }
      }
      ```
         @method disconnectOutlet
      @param {Object|String} options the options hash or outlet name
      @since 1.0.0
      @public
    */


    disconnectOutlet(options) {
      var outletName;
      var parentView;

      if (options) {
        if (typeof options === 'string') {
          outletName = options;
        } else {
          outletName = options.outlet;
          parentView = options.parentView ? options.parentView.replace(/\//g, '.') : undefined;
          (true && !(!('outlet' in options && options.outlet === undefined)) && (0, _debug.assert)('You passed undefined as the outlet name.', !('outlet' in options && options.outlet === undefined)));
        }
      }

      outletName = outletName || 'main';

      this._disconnectOutlet(outletName, parentView);

      var routeInfos = this._router._routerMicrolib.currentRouteInfos;

      for (var i = 0; i < routeInfos.length; i++) {
        // This non-local state munging is sadly necessary to maintain
        // backward compatibility with our existing semantics, which allow
        // any route to disconnectOutlet things originally rendered by any
        // other route. This should all get cut in 2.0.
        routeInfos[i].route._disconnectOutlet(outletName, parentView);
      }
    }

    _disconnectOutlet(outletName, parentView) {
      var parent = parentRoute(this);

      if (parent && parentView === parent.routeName) {
        parentView = undefined;
      }

      var connections = ROUTE_CONNECTIONS.get(this);

      for (var i = 0; i < connections.length; i++) {
        var connection = connections[i];

        if (connection.outlet === outletName && connection.into === parentView) {
          // This neuters the disconnected outlet such that it doesn't
          // render anything, but it leaves an entry in the outlet
          // hierarchy so that any existing other renders that target it
          // don't suddenly blow up. They will still stick themselves
          // into its outlets, which won't render anywhere. All of this
          // statefulness should get the machete in 2.0.
          connections[i] = {
            owner: connection.owner,
            into: connection.into,
            outlet: connection.outlet,
            name: connection.name,
            controller: undefined,
            template: undefined,
            model: undefined
          };
          (0, _runloop.once)(this._router, '_setOutlets');
        }
      }

      ROUTE_CONNECTIONS.set(this, connections);
    }

    willDestroy() {
      this.teardownViews();
    }
    /**
      @private
         @method teardownViews
    */


    teardownViews() {
      var connections = ROUTE_CONNECTIONS.get(this);

      if (connections !== undefined && connections.length > 0) {
        ROUTE_CONNECTIONS.set(this, []);
        (0, _runloop.once)(this._router, '_setOutlets');
      }
    }
    /**
      Allows you to produce custom metadata for the route.
      The return value of this method will be attatched to
      its corresponding RouteInfoWithAttributes obejct.
         Example
         ```app/routes/posts/index.js
      import Route from '@ember/routing/route';
         export default class PostsIndexRoute extends Route {
        buildRouteInfoMetadata() {
          return { title: 'Posts Page' }
        }
      }
      ```
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { inject as service } from '@ember/service';
         export default class ApplicationRoute extends Route {
        @service router
           constructor() {
          super(...arguments);
             this.router.on('routeDidChange', transition => {
            document.title = transition.to.metadata.title;
            // would update document's title to "Posts Page"
          });
        }
      }
      ```
         @return any
     */


    buildRouteInfoMetadata() {}

  }

  Route.reopenClass({
    isRouteFactory: true
  });

  function parentRoute(route) {
    var routeInfo = routeInfoFor(route, route._router._routerMicrolib.state.routeInfos, -1);
    return routeInfo && routeInfo.route;
  }

  function routeInfoFor(route, routeInfos, offset = 0) {
    if (!routeInfos) {
      return;
    }

    var current;

    for (var i = 0; i < routeInfos.length; i++) {
      current = routeInfos[i].route;

      if (current === route) {
        return routeInfos[i + offset];
      }
    }

    return;
  }

  function buildRenderOptions(route, isDefaultRender, _name, options) {
    (true && !(isDefaultRender || !(options && 'outlet' in options && options.outlet === undefined)) && (0, _debug.assert)('You passed undefined as the outlet name.', isDefaultRender || !(options && 'outlet' in options && options.outlet === undefined)));
    var owner = (0, _owner.getOwner)(route);
    var name, templateName, into, outlet, model;
    var controller = undefined;

    if (options) {
      into = options.into && options.into.replace(/\//g, '.');
      outlet = options.outlet;
      controller = options.controller;
      model = options.model;
    }

    outlet = outlet || 'main';

    if (isDefaultRender) {
      name = route.routeName;
      templateName = route.templateName || name;
    } else {
      name = _name.replace(/\//g, '.');
      templateName = name;
    }

    if (controller === undefined) {
      if (isDefaultRender) {
        controller = route.controllerName || owner.lookup("controller:" + name);
      } else {
        controller = owner.lookup("controller:" + name) || route.controllerName || route.routeName;
      }
    }

    if (typeof controller === 'string') {
      var controllerName = controller;
      controller = owner.lookup("controller:" + controllerName);
      (true && !(isDefaultRender || controller !== undefined) && (0, _debug.assert)("You passed `controller: '" + controllerName + "'` into the `render` method, but no such controller could be found.", isDefaultRender || controller !== undefined));
    }

    if (model === undefined) {
      model = route.currentModel;
    } else {
      controller.set('model', model);
    }

    var template = owner.lookup("template:" + templateName);
    (true && !(isDefaultRender || template !== undefined) && (0, _debug.assert)("Could not find \"" + templateName + "\" template, view, or component.", isDefaultRender || template !== undefined));
    var parent;

    if (into && (parent = parentRoute(route)) && into === parent.routeName) {
      into = undefined;
    }

    var renderOptions = {
      owner,
      into,
      outlet,
      name,
      controller,
      model,
      template: template !== undefined ? template(owner) : route._topLevelViewTemplate(owner)
    };

    if (true
    /* DEBUG */
    ) {
      var LOG_VIEW_LOOKUPS = (0, _metal.get)(route._router, 'namespace.LOG_VIEW_LOOKUPS');

      if (LOG_VIEW_LOOKUPS && !template) {
        (0, _debug.info)("Could not find \"" + name + "\" template. Nothing will be rendered", {
          fullName: "template:" + name
        });
      }
    }

    return renderOptions;
  }

  function getFullQueryParams(router, state) {
    if (state['fullQueryParams']) {
      return state['fullQueryParams'];
    }

    state['fullQueryParams'] = {};
    (0, _polyfills.assign)(state['fullQueryParams'], state.queryParams);

    router._deserializeQueryParams(state.routeInfos, state['fullQueryParams']);

    return state['fullQueryParams'];
  }

  function getQueryParamsFor(route, state) {
    state['queryParamsFor'] = state['queryParamsFor'] || {};
    var name = route.fullRouteName;

    if (state['queryParamsFor'][name]) {
      return state['queryParamsFor'][name];
    }

    var fullQueryParams = getFullQueryParams(route._router, state);
    var params = state['queryParamsFor'][name] = {}; // Copy over all the query params for this route/controller into params hash.

    var qps = (0, _metal.get)(route, '_qp.qps');

    for (var i = 0; i < qps.length; ++i) {
      // Put deserialized qp on params hash.
      var qp = qps[i];
      var qpValueWasPassedIn = qp.prop in fullQueryParams;
      params[qp.prop] = qpValueWasPassedIn ? fullQueryParams[qp.prop] : copyDefaultValue(qp.defaultValue);
    }

    return params;
  }

  function copyDefaultValue(value) {
    if (Array.isArray(value)) {
      return (0, _runtime.A)(value.slice());
    }

    return value;
  }
  /*
    Merges all query parameters from a controller with those from
    a route, returning a new object and avoiding any mutations to
    the existing objects.
  */


  function mergeEachQueryParams(controllerQP, routeQP) {
    var qps = {};
    var keysAlreadyMergedOrSkippable = {
      defaultValue: true,
      type: true,
      scope: true,
      as: true
    }; // first loop over all controller qps, merging them with any matching route qps
    // into a new empty object to avoid mutating.

    for (var cqpName in controllerQP) {
      if (!controllerQP.hasOwnProperty(cqpName)) {
        continue;
      }

      var newControllerParameterConfiguration = {};
      (0, _polyfills.assign)(newControllerParameterConfiguration, controllerQP[cqpName], routeQP[cqpName]);
      qps[cqpName] = newControllerParameterConfiguration; // allows us to skip this QP when we check route QPs.

      keysAlreadyMergedOrSkippable[cqpName] = true;
    } // loop over all route qps, skipping those that were merged in the first pass
    // because they also appear in controller qps


    for (var rqpName in routeQP) {
      if (!routeQP.hasOwnProperty(rqpName) || keysAlreadyMergedOrSkippable[rqpName]) {
        continue;
      }

      var newRouteParameterConfiguration = {};
      (0, _polyfills.assign)(newRouteParameterConfiguration, routeQP[rqpName], controllerQP[rqpName]);
      qps[rqpName] = newRouteParameterConfiguration;
    }

    return qps;
  }

  function addQueryParamsObservers(controller, propNames) {
    propNames.forEach(prop => {
      if ((0, _metal.descriptorForProperty)(controller, prop) === undefined) {
        var desc = (0, _utils.lookupDescriptor)(controller, prop);

        if (desc !== null && (typeof desc.get === 'function' || typeof desc.set === 'function')) {
          (0, _metal.defineProperty)(controller, prop, (0, _compat.dependentKeyCompat)({
            get: desc.get,
            set: desc.set
          }));
        }
      }

      (0, _metal.addObserver)(controller, prop + ".[]", controller, controller._qpChanged, false);
    });
  }

  function getEngineRouteName(engine, routeName) {
    if (engine.routable) {
      var prefix = engine.mountPoint;

      if (routeName === 'application') {
        return prefix;
      } else {
        return prefix + "." + routeName;
      }
    }

    return routeName;
  }
  /**
      A hook you can implement to convert the route's model into parameters
      for the URL.
  
      ```app/router.js
      // ...
  
      Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
  
      ```
  
      ```app/routes/post.js
      import Route from '@ember/routing/route';
  
      export default class PostRoute extends Route {
        model({ post_id }) {
          // the server returns `{ id: 12 }`
          return fetch(`/posts/${post_id}`;
        }
  
        serialize(model) {
          // this will make the URL `/posts/12`
          return { post_id: model.id };
        }
      }
      ```
  
      The default `serialize` method will insert the model's `id` into the
      route's dynamic segment (in this case, `:post_id`) if the segment contains '_id'.
      If the route has multiple dynamic segments or does not contain '_id', `serialize`
      will return `getProperties(model, params)`
  
      This method is called when `transitionTo` is called with a context
      in order to populate the URL.
  
      @method serialize
      @param {Object} model the routes model
      @param {Array} params an Array of parameter names for the current
        route (in the example, `['post_id']`.
      @return {Object} the serialized parameters
      @since 1.0.0
      @public
    */


  Route.prototype.serialize = defaultSerialize;
  Route.reopen(_runtime.ActionHandler, _runtime.Evented, {
    mergedProperties: ['queryParams'],

    /**
      Configuration hash for this route's queryParams. The possible
      configuration options and their defaults are as follows
      (assuming a query param whose controller property is `page`):
         ```javascript
      queryParams: {
        page: {
          // By default, controller query param properties don't
          // cause a full transition when they are changed, but
          // rather only cause the URL to update. Setting
          // `refreshModel` to true will cause an "in-place"
          // transition to occur, whereby the model hooks for
          // this route (and any child routes) will re-fire, allowing
          // you to reload models (e.g., from the server) using the
          // updated query param values.
          refreshModel: false,
             // By default, changes to controller query param properties
          // cause the URL to update via `pushState`, which means an
          // item will be added to the browser's history, allowing
          // you to use the back button to restore the app to the
          // previous state before the query param property was changed.
          // Setting `replace` to true will use `replaceState` (or its
          // hash location equivalent), which causes no browser history
          // item to be added. This options name and default value are
          // the same as the `link-to` helper's `replace` option.
          replace: false,
             // By default, the query param URL key is the same name as
          // the controller property name. Use `as` to specify a
          // different URL key.
          as: 'page'
        }
      }
      ```
         @property queryParams
      @for Route
      @type Object
      @since 1.6.0
      @public
    */
    queryParams: {},

    /**
      The name of the template to use by default when rendering this routes
      template.
         ```app/routes/posts/list.js
      import Route from '@ember/routing/route';
         export default class extends Route {
        templateName = 'posts/list'
      });
      ```
         ```app/routes/posts/index.js
      import PostsList from '../posts/list';
         export default class extends PostsList {};
      ```
         ```app/routes/posts/archived.js
      import PostsList from '../posts/list';
         export default class extends PostsList {};
      ```
         @property templateName
      @type String
      @default null
      @since 1.4.0
      @public
    */
    templateName: null,

    /**
      @private
         @property _names
    */
    _names: null,

    /**
      The name of the controller to associate with this route.
         By default, Ember will lookup a route's controller that matches the name
      of the route (i.e. `posts.new`). However,
      if you would like to define a specific controller to use, you can do so
      using this property.
         This is useful in many ways, as the controller specified will be:
         * passed to the `setupController` method.
      * used as the controller for the template being rendered by the route.
      * returned from a call to `controllerFor` for the route.
         @property controllerName
      @type String
      @default null
      @since 1.4.0
      @public
    */
    controllerName: null,

    /**
      Store property provides a hook for data persistence libraries to inject themselves.
         By default, this store property provides the exact same functionality previously
      in the model hook.
         Currently, the required interface is:
         `store.find(modelName, findArguments)`
         @property store
      @type {Object}
      @private
    */
    store: (0, _metal.computed)({
      get() {
        var owner = (0, _owner.getOwner)(this);
        var routeName = this.routeName;
        var namespace = (0, _metal.get)(this, '_router.namespace');
        return {
          find(name, value) {
            var modelClass = owner.factoryFor("model:" + name);
            (true && !(Boolean(modelClass)) && (0, _debug.assert)("You used the dynamic segment " + name + "_id in your route " + routeName + ", but " + namespace + "." + (0, _string.classify)(name) + " did not exist and you did not override your route's `model` hook.", Boolean(modelClass)));

            if (!modelClass) {
              return;
            }

            modelClass = modelClass.class;
            (true && !(typeof modelClass.find === 'function') && (0, _debug.assert)((0, _string.classify)(name) + " has no method `find`.", typeof modelClass.find === 'function'));
            return modelClass.find(value);
          }

        };
      },

      set(key, value) {
        (0, _metal.defineProperty)(this, key, null, value);
      }

    }),

    /**
        @private
           @property _qp
      */
    _qp: (0, _metal.computed)(function () {
      var combinedQueryParameterConfiguration;
      var controllerName = this.controllerName || this.routeName;
      var owner = (0, _owner.getOwner)(this);
      var controller = owner.lookup("controller:" + controllerName);
      var queryParameterConfiguraton = (0, _metal.get)(this, 'queryParams');
      var hasRouterDefinedQueryParams = Object.keys(queryParameterConfiguraton).length > 0;

      if (controller) {
        // the developer has authored a controller class in their application for
        // this route find its query params and normalize their object shape them
        // merge in the query params for the route. As a mergedProperty,
        // Route#queryParams is always at least `{}`
        var controllerDefinedQueryParameterConfiguration = (0, _metal.get)(controller, 'queryParams') || {};
        var normalizedControllerQueryParameterConfiguration = (0, _utils2.normalizeControllerQueryParams)(controllerDefinedQueryParameterConfiguration);
        combinedQueryParameterConfiguration = mergeEachQueryParams(normalizedControllerQueryParameterConfiguration, queryParameterConfiguraton);
      } else if (hasRouterDefinedQueryParams) {
        // the developer has not defined a controller but *has* supplied route query params.
        // Generate a class for them so we can later insert default values
        controller = (0, _generate_controller.default)(owner, controllerName);
        combinedQueryParameterConfiguration = queryParameterConfiguraton;
      }

      var qps = [];
      var map = {};
      var propertyNames = [];

      for (var propName in combinedQueryParameterConfiguration) {
        if (!combinedQueryParameterConfiguration.hasOwnProperty(propName)) {
          continue;
        } // to support the dubious feature of using unknownProperty
        // on queryParams configuration


        if (propName === 'unknownProperty' || propName === '_super') {
          // possible todo: issue deprecation warning?
          continue;
        }

        var desc = combinedQueryParameterConfiguration[propName];
        var scope = desc.scope || 'model';
        var parts = void 0;

        if (scope === 'controller') {
          parts = [];
        }

        var urlKey = desc.as || this.serializeQueryParamKey(propName);
        var defaultValue = (0, _metal.get)(controller, propName);
        defaultValue = copyDefaultValue(defaultValue);
        var type = desc.type || (0, _runtime.typeOf)(defaultValue);
        var defaultValueSerialized = this.serializeQueryParam(defaultValue, urlKey, type);
        var scopedPropertyName = controllerName + ":" + propName;
        var qp = {
          undecoratedDefaultValue: (0, _metal.get)(controller, propName),
          defaultValue,
          serializedDefaultValue: defaultValueSerialized,
          serializedValue: defaultValueSerialized,
          type,
          urlKey,
          prop: propName,
          scopedPropertyName,
          controllerName,
          route: this,
          parts,
          values: null,
          scope
        };
        map[propName] = map[urlKey] = map[scopedPropertyName] = qp;
        qps.push(qp);
        propertyNames.push(propName);
      }

      return {
        qps,
        map,
        propertyNames,
        states: {
          /*
            Called when a query parameter changes in the URL, this route cares
            about that query parameter, but the route is not currently
            in the active route hierarchy.
          */
          inactive: (prop, value) => {
            var qp = map[prop];

            this._qpChanged(prop, value, qp);
          },

          /*
            Called when a query parameter changes in the URL, this route cares
            about that query parameter, and the route is currently
            in the active route hierarchy.
          */
          active: (prop, value) => {
            var qp = map[prop];

            this._qpChanged(prop, value, qp);

            return this._activeQPChanged(qp, value);
          },

          /*
            Called when a value of a query parameter this route handles changes in a controller
            and the route is currently in the active route hierarchy.
          */
          allowOverrides: (prop, value) => {
            var qp = map[prop];

            this._qpChanged(prop, value, qp);

            return this._updatingQPChanged(qp);
          }
        }
      };
    }),

    /**
      Sends an action to the router, which will delegate it to the currently
      active route hierarchy per the bubbling rules explained under `actions`.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
      });
         export default Router;
      ```
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        track(arg) {
          console.log(arg, 'was clicked');
        }
      }
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@glimmer/tracking';
         export default class IndexRoute extends Route {
        @action
        trackIfDebug(arg) {
          if (debug) {
            this.send('track', arg);
          }
        }
      }
      ```
         @method send
      @param {String} name the name of the action to trigger
      @param {...*} args
      @since 1.0.0
      @public
    */
    send(...args) {
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .send() with the action '" + args[0] + "' on the destroyed route '" + this.routeName + "'.", !this.isDestroying && !this.isDestroyed));

      if (this._router && this._router._routerMicrolib || !(0, _debug.isTesting)()) {
        this._router.send(...args);
      } else {
        var name = args.shift();
        var action = this.actions[name];

        if (action) {
          return action.apply(this, args);
        }
      }
    },

    /**
      The controller associated with this route.
         Example
         ```app/routes/form.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class FormRoute extends Route {
        @action
        willTransition(transition) {
          if (this.controller.get('userHasEnteredData') &&
              !confirm('Are you sure you want to abandon progress?')) {
            transition.abort();
          } else {
            // Bubble the `willTransition` action so that
            // parent routes can decide whether or not to abort.
            return true;
          }
        }
      }
      ```
         @property controller
      @type Controller
      @since 1.6.0
      @public
    */
    actions: {
      /**
      This action is called when one or more query params have changed. Bubbles.
           @method queryParamsDidChange
      @param changed {Object} Keys are names of query params that have changed.
      @param totalPresent {Object} Keys are names of query params that are currently set.
      @param removed {Object} Keys are names of query params that have been removed.
      @returns {boolean}
      @private
      */
      queryParamsDidChange(changed, _totalPresent, removed) {
        var qpMap = (0, _metal.get)(this, '_qp').map;
        var totalChanged = Object.keys(changed).concat(Object.keys(removed));

        for (var i = 0; i < totalChanged.length; ++i) {
          var qp = qpMap[totalChanged[i]];

          if (qp && (0, _metal.get)(this._optionsForQueryParam(qp), 'refreshModel') && this._router.currentState) {
            this.refresh();
            break;
          }
        }

        return true;
      },

      finalizeQueryParamChange(params, finalParams, transition) {
        if (this.fullRouteName !== 'application') {
          return true;
        } // Transition object is absent for intermediate transitions.


        if (!transition) {
          return;
        }

        var routeInfos = transition[_router_js.STATE_SYMBOL].routeInfos;
        var router = this._router;

        var qpMeta = router._queryParamsFor(routeInfos);

        var changes = router._qpUpdates;
        var qpUpdated = false;
        var replaceUrl;
        (0, _utils2.stashParamNames)(router, routeInfos);

        for (var i = 0; i < qpMeta.qps.length; ++i) {
          var qp = qpMeta.qps[i];
          var route = qp.route;
          var controller = route.controller;
          var presentKey = qp.urlKey in params && qp.urlKey; // Do a reverse lookup to see if the changed query
          // param URL key corresponds to a QP property on
          // this controller.

          var value = void 0,
              svalue = void 0;

          if (changes.has(qp.urlKey)) {
            // Value updated in/before setupController
            value = (0, _metal.get)(controller, qp.prop);
            svalue = route.serializeQueryParam(value, qp.urlKey, qp.type);
          } else {
            if (presentKey) {
              svalue = params[presentKey];

              if (svalue !== undefined) {
                value = route.deserializeQueryParam(svalue, qp.urlKey, qp.type);
              }
            } else {
              // No QP provided; use default value.
              svalue = qp.serializedDefaultValue;
              value = copyDefaultValue(qp.defaultValue);
            }
          }

          controller._qpDelegate = (0, _metal.get)(route, '_qp.states.inactive');
          var thisQueryParamChanged = svalue !== qp.serializedValue;

          if (thisQueryParamChanged) {
            if (transition.queryParamsOnly && replaceUrl !== false) {
              var options = route._optionsForQueryParam(qp);

              var replaceConfigValue = (0, _metal.get)(options, 'replace');

              if (replaceConfigValue) {
                replaceUrl = true;
              } else if (replaceConfigValue === false) {
                // Explicit pushState wins over any other replaceStates.
                replaceUrl = false;
              }
            }

            (0, _metal.set)(controller, qp.prop, value);
            qpUpdated = true;
          } // Stash current serialized value of controller.


          qp.serializedValue = svalue;
          var thisQueryParamHasDefaultValue = qp.serializedDefaultValue === svalue;

          if (!thisQueryParamHasDefaultValue || transition._keepDefaultQueryParamValues) {
            finalParams.push({
              value: svalue,
              visible: true,
              key: presentKey || qp.urlKey
            });
          }
        } // Some QPs have been updated, and those changes need to be propogated
        // immediately. Eventually, we should work on making this async somehow.


        if (true
        /* EMBER_METAL_TRACKED_PROPERTIES */
        && qpUpdated === true) {
          (0, _metal.flushAsyncObservers)(false);
        }

        if (replaceUrl) {
          transition.method('replace');
        }

        qpMeta.qps.forEach(qp => {
          var routeQpMeta = (0, _metal.get)(qp.route, '_qp');
          var finalizedController = qp.route.controller;
          finalizedController._qpDelegate = (0, _metal.get)(routeQpMeta, 'states.active');
        });

        router._qpUpdates.clear();

        return;
      }

    }
  });
  var ROUTER_EVENT_DEPRECATIONS;
  _exports.ROUTER_EVENT_DEPRECATIONS = ROUTER_EVENT_DEPRECATIONS;

  if (_deprecatedFeatures.ROUTER_EVENTS) {
    _exports.ROUTER_EVENT_DEPRECATIONS = ROUTER_EVENT_DEPRECATIONS = {
      on(name) {
        this._super(...arguments);

        var hasDidTransition = name === 'didTransition';
        var hasWillTransition = name === 'willTransition';

        if (hasDidTransition) {
          (true && !(false) && (0, _debug.deprecate)('You attempted to listen to the "didTransition" event which is deprecated. Please inject the router service and listen to the "routeDidChange" event.', false, {
            id: 'deprecate-router-events',
            until: '4.0.0',
            url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events'
          }));
        }

        if (hasWillTransition) {
          (true && !(false) && (0, _debug.deprecate)('You attempted to listen to the "willTransition" event which is deprecated. Please inject the router service and listen to the "routeWillChange" event.', false, {
            id: 'deprecate-router-events',
            until: '4.0.0',
            url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events'
          }));
        }
      }

    };
    Route.reopen(ROUTER_EVENT_DEPRECATIONS, {
      _paramsFor(routeName, params) {
        var transition = this._router._routerMicrolib.activeTransition;

        if (transition !== undefined) {
          return this.paramsFor(routeName);
        }

        return params;
      }

    });
  }

  (0, _runtime.setFrameworkClass)(Route);
  var _default = Route;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/system/router", ["exports", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/debug", "@ember/deprecated-features", "@ember/error", "@ember/polyfills", "@ember/runloop", "@ember/-internals/routing/lib/location/api", "@ember/-internals/routing/lib/utils", "@ember/-internals/routing/lib/system/dsl", "@ember/-internals/routing/lib/system/route", "@ember/-internals/routing/lib/system/router_state", "router_js"], function (_exports, _metal, _owner, _runtime, _debug, _deprecatedFeatures, _error2, _polyfills, _runloop, _api, _utils, _dsl, _route, _router_state, _router_js) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.triggerEvent = triggerEvent;
  _exports.default = void 0;

  function defaultDidTransition(infos) {
    updatePaths(this);

    this._cancelSlowTransitionTimer();

    this.notifyPropertyChange('url');
    this.set('currentState', this.targetState); // Put this in the runloop so url will be accurate. Seems
    // less surprising than didTransition being out of sync.

    (0, _runloop.once)(this, this.trigger, 'didTransition');

    if (true
    /* DEBUG */
    ) {
      if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
        // eslint-disable-next-line no-console
        console.log("Transitioned into '" + EmberRouter._routePath(infos) + "'");
      }
    }
  }

  function defaultWillTransition(oldInfos, newInfos, transition) {
    (0, _runloop.once)(this, this.trigger, 'willTransition', transition);

    if (true
    /* DEBUG */
    ) {
      if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
        // eslint-disable-next-line no-console
        console.log("Preparing to transition from '" + EmberRouter._routePath(oldInfos) + "' to '" + EmberRouter._routePath(newInfos) + "'");
      }
    }
  }

  function K() {
    return this;
  }

  var {
    slice
  } = Array.prototype;
  /**
    The `EmberRouter` class manages the application state and URLs. Refer to
    the [routing guide](https://guides.emberjs.com/release/routing/) for documentation.
  
    @class EmberRouter
    @extends EmberObject
    @uses Evented
    @public
  */

  class EmberRouter extends _runtime.Object {
    constructor() {
      super(...arguments);
      this.currentURL = null;
      this.currentRouteName = null;
      this.currentPath = null;
      this.currentRoute = null;
      this._qpCache = Object.create(null);
      this._qpUpdates = new Set();
      this._handledErrors = new Set();
      this._engineInstances = Object.create(null);
      this._engineInfoByRoute = Object.create(null);
      this.currentState = null;
      this.targetState = null;

      this._resetQueuedQueryParameterChanges();
    }

    _initRouterJs() {
      var location = (0, _metal.get)(this, 'location');
      var router = this;
      var owner = (0, _owner.getOwner)(this);
      var seen = Object.create(null);

      class PrivateRouter extends _router_js.default {
        getRoute(name) {
          var routeName = name;
          var routeOwner = owner;
          var engineInfo = router._engineInfoByRoute[routeName];

          if (engineInfo) {
            var engineInstance = router._getEngineInstance(engineInfo);

            routeOwner = engineInstance;
            routeName = engineInfo.localFullName;
          }

          var fullRouteName = "route:" + routeName;
          var route = routeOwner.lookup(fullRouteName);

          if (seen[name]) {
            return route;
          }

          seen[name] = true;

          if (!route) {
            var DefaultRoute = routeOwner.factoryFor('route:basic').class;
            routeOwner.register(fullRouteName, DefaultRoute.extend());
            route = routeOwner.lookup(fullRouteName);

            if (true
            /* DEBUG */
            ) {
              if ((0, _metal.get)(router, 'namespace.LOG_ACTIVE_GENERATION')) {
                (0, _debug.info)("generated -> " + fullRouteName, {
                  fullName: fullRouteName
                });
              }
            }
          }

          route._setRouteName(routeName);

          if (engineInfo && !(0, _route.hasDefaultSerialize)(route)) {
            throw new Error('Defining a custom serialize method on an Engine route is not supported.');
          }

          return route;
        }

        getSerializer(name) {
          var engineInfo = router._engineInfoByRoute[name]; // If this is not an Engine route, we fall back to the handler for serialization

          if (!engineInfo) {
            return;
          }

          return engineInfo.serializeMethod || _route.defaultSerialize;
        }

        updateURL(path) {
          (0, _runloop.once)(() => {
            location.setURL(path);
            (0, _metal.set)(router, 'currentURL', path);
          });
        }

        didTransition(infos) {
          if (_deprecatedFeatures.ROUTER_EVENTS) {
            if (router.didTransition !== defaultDidTransition) {
              (true && !(false) && (0, _debug.deprecate)('You attempted to override the "didTransition" method which is deprecated. Please inject the router service and listen to the "routeDidChange" event.', false, {
                id: 'deprecate-router-events',
                until: '4.0.0',
                url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events'
              }));
            }
          }

          router.didTransition(infos);
        }

        willTransition(oldInfos, newInfos, transition) {
          if (_deprecatedFeatures.ROUTER_EVENTS) {
            if (router.willTransition !== defaultWillTransition) {
              (true && !(false) && (0, _debug.deprecate)('You attempted to override the "willTransition" method which is deprecated. Please inject the router service and listen to the "routeWillChange" event.', false, {
                id: 'deprecate-router-events',
                until: '4.0.0',
                url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events'
              }));
            }
          }

          router.willTransition(oldInfos, newInfos, transition);
        }

        triggerEvent(routeInfos, ignoreFailure, name, args) {
          return triggerEvent.bind(router)(routeInfos, ignoreFailure, name, args);
        }

        routeWillChange(transition) {
          router.trigger('routeWillChange', transition);
        }

        routeDidChange(transition) {
          router.set('currentRoute', transition.to);
          (0, _runloop.once)(() => {
            router.trigger('routeDidChange', transition);
          });
        }

        transitionDidError(error, transition) {
          if (error.wasAborted || transition.isAborted) {
            // If the error was a transition erorr or the transition aborted
            // log the abort.
            return (0, _router_js.logAbort)(transition);
          } else {
            // Otherwise trigger the "error" event to attempt an intermediate
            // transition into an error substate
            transition.trigger(false, 'error', error.error, transition, error.route);

            if (router._isErrorHandled(error.error)) {
              // If we handled the error with a substate just roll the state back on
              // the transition and send the "routeDidChange" event for landing on
              // the error substate and return the error.
              transition.rollback();
              this.routeDidChange(transition);
              return error.error;
            } else {
              // If it was not handled, abort the transition completely and return
              // the error.
              transition.abort();
              return error.error;
            }
          }
        }

        _triggerWillChangeContext() {
          return router;
        }

        _triggerWillLeave() {
          return router;
        }

        replaceURL(url) {
          if (location.replaceURL) {
            var doReplaceURL = () => {
              location.replaceURL(url);
              (0, _metal.set)(router, 'currentURL', url);
            };

            (0, _runloop.once)(doReplaceURL);
          } else {
            this.updateURL(url);
          }
        }

      }

      var routerMicrolib = this._routerMicrolib = new PrivateRouter();
      var dslCallbacks = this.constructor.dslCallbacks || [K];

      var dsl = this._buildDSL();

      dsl.route('application', {
        path: '/',
        resetNamespace: true,
        overrideNameAssertion: true
      }, function () {
        for (var i = 0; i < dslCallbacks.length; i++) {
          dslCallbacks[i].call(this);
        }
      });

      if (true
      /* DEBUG */
      ) {
        if ((0, _metal.get)(this, 'namespace.LOG_TRANSITIONS_INTERNAL')) {
          routerMicrolib.log = console.log.bind(console); // eslint-disable-line no-console
        }
      }

      routerMicrolib.map(dsl.generate());
    }

    _buildDSL() {
      var enableLoadingSubstates = this._hasModuleBasedResolver();

      var router = this;
      var owner = (0, _owner.getOwner)(this);
      var options = {
        enableLoadingSubstates,

        resolveRouteMap(name) {
          return owner.factoryFor("route-map:" + name);
        },

        addRouteForEngine(name, engineInfo) {
          if (!router._engineInfoByRoute[name]) {
            router._engineInfoByRoute[name] = engineInfo;
          }
        }

      };
      return new _dsl.default(null, options);
    }
    /*
      Resets all pending query parameter changes.
      Called after transitioning to a new route
      based on query parameter changes.
    */


    _resetQueuedQueryParameterChanges() {
      this._queuedQPChanges = {};
    }

    _hasModuleBasedResolver() {
      var owner = (0, _owner.getOwner)(this);

      if (!owner) {
        return false;
      }

      var resolver = (0, _metal.get)(owner, 'application.__registry__.resolver.moduleBasedResolver');
      return Boolean(resolver);
    }
    /**
      Initializes the current router instance and sets up the change handling
      event listeners used by the instances `location` implementation.
         A property named `initialURL` will be used to determine the initial URL.
      If no value is found `/` will be used.
         @method startRouting
      @private
    */


    startRouting() {
      var initialURL = (0, _metal.get)(this, 'initialURL');

      if (this.setupRouter()) {
        if (initialURL === undefined) {
          initialURL = (0, _metal.get)(this, 'location').getURL();
        }

        var initialTransition = this.handleURL(initialURL);

        if (initialTransition && initialTransition.error) {
          throw initialTransition.error;
        }
      }
    }

    setupRouter() {
      this._setupLocation();

      var location = (0, _metal.get)(this, 'location'); // Allow the Location class to cancel the router setup while it refreshes
      // the page

      if ((0, _metal.get)(location, 'cancelRouterSetup')) {
        return false;
      }

      this._initRouterJs();

      location.onUpdateURL(url => {
        this.handleURL(url);
      });
      return true;
    }

    _setOutlets() {
      // This is triggered async during Route#willDestroy.
      // If the router is also being destroyed we do not want to
      // to create another this._toplevelView (and leak the renderer)
      if (this.isDestroying || this.isDestroyed) {
        return;
      }

      var routeInfos = this._routerMicrolib.currentRouteInfos;
      var route;
      var defaultParentState;
      var liveRoutes = null;

      if (!routeInfos) {
        return;
      }

      for (var i = 0; i < routeInfos.length; i++) {
        route = routeInfos[i].route;

        var connections = _route.ROUTE_CONNECTIONS.get(route);

        var ownState = void 0;

        for (var j = 0; j < connections.length; j++) {
          var appended = appendLiveRoute(liveRoutes, defaultParentState, connections[j]);
          liveRoutes = appended.liveRoutes;

          if (appended.ownState.render.name === route.routeName || appended.ownState.render.outlet === 'main') {
            ownState = appended.ownState;
          }
        }

        if (connections.length === 0) {
          ownState = representEmptyRoute(liveRoutes, defaultParentState, route);
        }

        defaultParentState = ownState;
      } // when a transitionTo happens after the validation phase
      // during the initial transition _setOutlets is called
      // when no routes are active. However, it will get called
      // again with the correct values during the next turn of
      // the runloop


      if (!liveRoutes) {
        return;
      }

      if (!this._toplevelView) {
        var owner = (0, _owner.getOwner)(this);
        var OutletView = owner.factoryFor('view:-outlet');
        this._toplevelView = OutletView.create();

        this._toplevelView.setOutletState(liveRoutes);

        var instance = owner.lookup('-application-instance:main');
        instance.didCreateRootView(this._toplevelView);
      } else {
        this._toplevelView.setOutletState(liveRoutes);
      }
    }

    handleURL(url) {
      // Until we have an ember-idiomatic way of accessing #hashes, we need to
      // remove it because router.js doesn't know how to handle it.
      var _url = url.split(/#(.+)?/)[0];
      return this._doURLTransition('handleURL', _url);
    }

    _doURLTransition(routerJsMethod, url) {
      var transition = this._routerMicrolib[routerJsMethod](url || '/');

      didBeginTransition(transition, this);
      return transition;
    }
    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         See [transitionTo](/ember/release/classes/Route/methods/transitionTo?anchor=transitionTo) for more info.
         @method transitionTo
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
      @public
    */


    transitionTo(...args) {
      if ((0, _utils.resemblesURL)(args[0])) {
        (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("A transition was attempted from '" + this.currentRouteName + "' to '" + args[0] + "' but the application instance has already been destroyed.", !this.isDestroying && !this.isDestroyed));
        return this._doURLTransition('transitionTo', args[0]);
      }

      var {
        routeName,
        models,
        queryParams
      } = (0, _utils.extractRouteArgs)(args);
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("A transition was attempted from '" + this.currentRouteName + "' to '" + routeName + "' but the application instance has already been destroyed.", !this.isDestroying && !this.isDestroyed));
      return this._doTransition(routeName, models, queryParams);
    }

    intermediateTransitionTo(name, ...args) {
      this._routerMicrolib.intermediateTransitionTo(name, ...args);

      updatePaths(this);

      if (true
      /* DEBUG */
      ) {
        var infos = this._routerMicrolib.currentRouteInfos;

        if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
          // eslint-disable-next-line no-console
          console.log("Intermediate-transitioned into '" + EmberRouter._routePath(infos) + "'");
        }
      }
    }

    replaceWith(...args) {
      return this.transitionTo(...args).method('replace');
    }

    generate(name, ...args) {
      var url = this._routerMicrolib.generate(name, ...args);

      return this.location.formatURL(url);
    }
    /**
      Determines if the supplied route is currently active.
         @method isActive
      @param routeName
      @return {Boolean}
      @private
    */


    isActive(routeName) {
      return this._routerMicrolib.isActive(routeName);
    }
    /**
      An alternative form of `isActive` that doesn't require
      manual concatenation of the arguments into a single
      array.
         @method isActiveIntent
      @param routeName
      @param models
      @param queryParams
      @return {Boolean}
      @private
      @since 1.7.0
    */


    isActiveIntent(routeName, models, queryParams) {
      return this.currentState.isActiveIntent(routeName, models, queryParams);
    }

    send(name, ...args) {
      /*name, context*/
      this._routerMicrolib.trigger(name, ...args);
    }
    /**
      Does this router instance have the given route.
         @method hasRoute
      @return {Boolean}
      @private
    */


    hasRoute(route) {
      return this._routerMicrolib.hasRoute(route);
    }
    /**
      Resets the state of the router by clearing the current route
      handlers and deactivating them.
         @private
      @method reset
     */


    reset() {
      if (this._routerMicrolib) {
        this._routerMicrolib.reset();
      }
    }

    willDestroy() {
      if (this._toplevelView) {
        this._toplevelView.destroy();

        this._toplevelView = null;
      }

      this._super(...arguments);

      this.reset();
      var instances = this._engineInstances;

      for (var name in instances) {
        for (var id in instances[name]) {
          (0, _runloop.run)(instances[name][id], 'destroy');
        }
      }
    }
    /*
      Called when an active route's query parameter has changed.
      These changes are batched into a runloop run and trigger
      a single transition.
    */


    _activeQPChanged(queryParameterName, newValue) {
      this._queuedQPChanges[queryParameterName] = newValue;
      (0, _runloop.once)(this, this._fireQueryParamTransition);
    }

    _updatingQPChanged(queryParameterName) {
      this._qpUpdates.add(queryParameterName);
    }
    /*
      Triggers a transition to a route based on query parameter changes.
      This is called once per runloop, to batch changes.
         e.g.
         if these methods are called in succession:
      this._activeQPChanged('foo', '10');
        // results in _queuedQPChanges = { foo: '10' }
      this._activeQPChanged('bar', false);
        // results in _queuedQPChanges = { foo: '10', bar: false }
         _queuedQPChanges will represent both of these changes
      and the transition using `transitionTo` will be triggered
      once.
    */


    _fireQueryParamTransition() {
      this.transitionTo({
        queryParams: this._queuedQPChanges
      });

      this._resetQueuedQueryParameterChanges();
    }

    _setupLocation() {
      var location = this.location;
      var rootURL = this.rootURL;
      var owner = (0, _owner.getOwner)(this);

      if ('string' === typeof location && owner) {
        var resolvedLocation = owner.lookup("location:" + location);

        if (resolvedLocation !== undefined) {
          location = (0, _metal.set)(this, 'location', resolvedLocation);
        } else {
          // Allow for deprecated registration of custom location API's
          var options = {
            implementation: location
          };
          location = (0, _metal.set)(this, 'location', _api.default.create(options));
        }
      }

      if (location !== null && typeof location === 'object') {
        if (rootURL) {
          (0, _metal.set)(location, 'rootURL', rootURL);
        } // Allow the location to do any feature detection, such as AutoLocation
        // detecting history support. This gives it a chance to set its
        // `cancelRouterSetup` property which aborts routing.


        if (typeof location.detect === 'function') {
          location.detect();
        } // ensure that initState is called AFTER the rootURL is set on
        // the location instance


        if (typeof location.initState === 'function') {
          location.initState();
        }
      }
    }
    /**
      Serializes the given query params according to their QP meta information.
         @private
      @method _serializeQueryParams
      @param {Arrray<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */


    _serializeQueryParams(routeInfos, queryParams) {
      forEachQueryParam(this, routeInfos, queryParams, (key, value, qp) => {
        if (qp) {
          delete queryParams[key];
          queryParams[qp.urlKey] = qp.route.serializeQueryParam(value, qp.urlKey, qp.type);
        } else if (value === undefined) {
          return; // We don't serialize undefined values
        } else {
          queryParams[key] = this._serializeQueryParam(value, (0, _runtime.typeOf)(value));
        }
      });
    }
    /**
      Serializes the value of a query parameter based on a type
         @private
      @method _serializeQueryParam
      @param {Object} value
      @param {String} type
    */


    _serializeQueryParam(value, type) {
      if (value === null || value === undefined) {
        return value;
      } else if (type === 'array') {
        return JSON.stringify(value);
      }

      return "" + value;
    }
    /**
      Deserializes the given query params according to their QP meta information.
         @private
      @method _deserializeQueryParams
      @param {Array<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */


    _deserializeQueryParams(routeInfos, queryParams) {
      forEachQueryParam(this, routeInfos, queryParams, (key, value, qp) => {
        // If we don't have QP meta info for a given key, then we do nothing
        // because all values will be treated as strings
        if (qp) {
          delete queryParams[key];
          queryParams[qp.prop] = qp.route.deserializeQueryParam(value, qp.urlKey, qp.type);
        }
      });
    }
    /**
      Deserializes the value of a query parameter based on a default type
         @private
      @method _deserializeQueryParam
      @param {Object} value
      @param {String} defaultType
    */


    _deserializeQueryParam(value, defaultType) {
      if (value === null || value === undefined) {
        return value;
      } else if (defaultType === 'boolean') {
        return value === 'true';
      } else if (defaultType === 'number') {
        return Number(value).valueOf();
      } else if (defaultType === 'array') {
        return (0, _runtime.A)(JSON.parse(value));
      }

      return value;
    }
    /**
      Removes (prunes) any query params with default values from the given QP
      object. Default values are determined from the QP meta information per key.
         @private
      @method _pruneDefaultQueryParamValues
      @param {Array<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */


    _pruneDefaultQueryParamValues(routeInfos, queryParams) {
      var qps = this._queryParamsFor(routeInfos);

      for (var key in queryParams) {
        var qp = qps.map[key];

        if (qp && qp.serializedDefaultValue === queryParams[key]) {
          delete queryParams[key];
        }
      }
    }

    _doTransition(_targetRouteName, models, _queryParams, _keepDefaultQueryParamValues) {
      var targetRouteName = _targetRouteName || (0, _utils.getActiveTargetName)(this._routerMicrolib);

      (true && !(Boolean(targetRouteName) && this._routerMicrolib.hasRoute(targetRouteName)) && (0, _debug.assert)("The route " + targetRouteName + " was not found", Boolean(targetRouteName) && this._routerMicrolib.hasRoute(targetRouteName)));
      var queryParams = {};

      this._processActiveTransitionQueryParams(targetRouteName, models, queryParams, _queryParams);

      (0, _polyfills.assign)(queryParams, _queryParams);

      this._prepareQueryParams(targetRouteName, models, queryParams, Boolean(_keepDefaultQueryParamValues));

      var transition = this._routerMicrolib.transitionTo(targetRouteName, ...models, {
        queryParams
      });

      didBeginTransition(transition, this);
      return transition;
    }

    _processActiveTransitionQueryParams(targetRouteName, models, queryParams, _queryParams) {
      // merge in any queryParams from the active transition which could include
      // queryParams from the url on initial load.
      if (!this._routerMicrolib.activeTransition) {
        return;
      }

      var unchangedQPs = {};
      var qpUpdates = this._qpUpdates;
      var params = this._routerMicrolib.activeTransition[_router_js.QUERY_PARAMS_SYMBOL];

      for (var key in params) {
        if (!qpUpdates.has(key)) {
          unchangedQPs[key] = params[key];
        }
      } // We need to fully scope queryParams so that we can create one object
      // that represents both passed-in queryParams and ones that aren't changed
      // from the active transition.


      this._fullyScopeQueryParams(targetRouteName, models, _queryParams);

      this._fullyScopeQueryParams(targetRouteName, models, unchangedQPs);

      (0, _polyfills.assign)(queryParams, unchangedQPs);
    }
    /**
      Prepares the query params for a URL or Transition. Restores any undefined QP
      keys/values, serializes all values, and then prunes any default values.
         @private
      @method _prepareQueryParams
      @param {String} targetRouteName
      @param {Array<Object>} models
      @param {Object} queryParams
      @param {boolean} keepDefaultQueryParamValues
      @return {Void}
    */


    _prepareQueryParams(targetRouteName, models, queryParams, _fromRouterService) {
      var state = calculatePostTransitionState(this, targetRouteName, models);

      this._hydrateUnsuppliedQueryParams(state, queryParams, Boolean(_fromRouterService));

      this._serializeQueryParams(state.routeInfos, queryParams);

      if (!_fromRouterService) {
        this._pruneDefaultQueryParamValues(state.routeInfos, queryParams);
      }
    }
    /**
      Returns the meta information for the query params of a given route. This
      will be overridden to allow support for lazy routes.
         @private
      @method _getQPMeta
      @param {RouteInfo} routeInfo
      @return {Object}
    */


    _getQPMeta(routeInfo) {
      var route = routeInfo.route;
      return route && (0, _metal.get)(route, '_qp');
    }
    /**
      Returns a merged query params meta object for a given set of routeInfos.
      Useful for knowing what query params are available for a given route hierarchy.
         @private
      @method _queryParamsFor
      @param {Array<RouteInfo>} routeInfos
      @return {Object}
     */


    _queryParamsFor(routeInfos) {
      var routeInfoLength = routeInfos.length;
      var leafRouteName = routeInfos[routeInfoLength - 1].name;
      var cached = this._qpCache[leafRouteName];

      if (cached !== undefined) {
        return cached;
      }

      var shouldCache = true;
      var map = {};
      var qps = [];
      var qpsByUrlKey = true
      /* DEBUG */
      ? {} : null;
      var qpMeta;
      var qp;
      var urlKey;
      var qpOther;

      for (var i = 0; i < routeInfoLength; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);

        if (!qpMeta) {
          shouldCache = false;
          continue;
        } // Loop over each QP to make sure we don't have any collisions by urlKey


        for (var _i = 0; _i < qpMeta.qps.length; _i++) {
          qp = qpMeta.qps[_i];

          if (true
          /* DEBUG */
          ) {
            urlKey = qp.urlKey;
            qpOther = qpsByUrlKey[urlKey];

            if (qpOther && qpOther.controllerName !== qp.controllerName) {
              (true && !(false) && (0, _debug.assert)("You're not allowed to have more than one controller property map to the same query param key, but both `" + qpOther.scopedPropertyName + "` and `" + qp.scopedPropertyName + "` map to `" + urlKey + "`. You can fix this by mapping one of the controller properties to a different query param key via the `as` config option, e.g. `" + qpOther.prop + ": { as: 'other-" + qpOther.prop + "' }`", false));
            }

            qpsByUrlKey[urlKey] = qp;
          }

          qps.push(qp);
        }

        (0, _polyfills.assign)(map, qpMeta.map);
      }

      var finalQPMeta = {
        qps,
        map
      };

      if (shouldCache) {
        this._qpCache[leafRouteName] = finalQPMeta;
      }

      return finalQPMeta;
    }
    /**
      Maps all query param keys to their fully scoped property name of the form
      `controllerName:propName`.
         @private
      @method _fullyScopeQueryParams
      @param {String} leafRouteName
      @param {Array<Object>} contexts
      @param {Object} queryParams
      @return {Void}
    */


    _fullyScopeQueryParams(leafRouteName, contexts, queryParams) {
      var state = calculatePostTransitionState(this, leafRouteName, contexts);
      var routeInfos = state.routeInfos;
      var qpMeta;

      for (var i = 0, len = routeInfos.length; i < len; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);

        if (!qpMeta) {
          continue;
        }

        var qp = void 0;
        var presentProp = void 0;

        for (var j = 0, qpLen = qpMeta.qps.length; j < qpLen; ++j) {
          qp = qpMeta.qps[j];
          presentProp = qp.prop in queryParams && qp.prop || qp.scopedPropertyName in queryParams && qp.scopedPropertyName || qp.urlKey in queryParams && qp.urlKey;

          if (presentProp) {
            if (presentProp !== qp.scopedPropertyName) {
              queryParams[qp.scopedPropertyName] = queryParams[presentProp];
              delete queryParams[presentProp];
            }
          }
        }
      }
    }
    /**
      Hydrates (adds/restores) any query params that have pre-existing values into
      the given queryParams hash. This is what allows query params to be "sticky"
      and restore their last known values for their scope.
         @private
      @method _hydrateUnsuppliedQueryParams
      @param {TransitionState} state
      @param {Object} queryParams
      @return {Void}
    */


    _hydrateUnsuppliedQueryParams(state, queryParams, _fromRouterService) {
      var routeInfos = state.routeInfos;
      var appCache = this._bucketCache;
      var qpMeta;
      var qp;
      var presentProp;

      for (var i = 0; i < routeInfos.length; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);

        if (!qpMeta) {
          continue;
        }

        for (var j = 0, qpLen = qpMeta.qps.length; j < qpLen; ++j) {
          qp = qpMeta.qps[j];
          presentProp = qp.prop in queryParams && qp.prop || qp.scopedPropertyName in queryParams && qp.scopedPropertyName || qp.urlKey in queryParams && qp.urlKey;
          (true && !(function () {
            if (qp.urlKey === presentProp) {
              return true;
            }

            if (_fromRouterService && presentProp !== false) {
              return false;
            }

            return true;
          }()) && (0, _debug.assert)("You passed the `" + presentProp + "` query parameter during a transition into " + qp.route.routeName + ", please update to " + qp.urlKey, function () {
            if (qp.urlKey === presentProp) {
              return true;
            }

            if (_fromRouterService && presentProp !== false) {
              return false;
            }

            return true;
          }()));

          if (presentProp) {
            if (presentProp !== qp.scopedPropertyName) {
              queryParams[qp.scopedPropertyName] = queryParams[presentProp];
              delete queryParams[presentProp];
            }
          } else {
            var cacheKey = (0, _utils.calculateCacheKey)(qp.route.fullRouteName, qp.parts, state.params);
            queryParams[qp.scopedPropertyName] = appCache.lookup(cacheKey, qp.prop, qp.defaultValue);
          }
        }
      }
    }

    _scheduleLoadingEvent(transition, originRoute) {
      this._cancelSlowTransitionTimer();

      this._slowTransitionTimer = (0, _runloop.scheduleOnce)('routerTransitions', this, '_handleSlowTransition', transition, originRoute);
    }

    _handleSlowTransition(transition, originRoute) {
      if (!this._routerMicrolib.activeTransition) {
        // Don't fire an event if we've since moved on from
        // the transition that put us in a loading state.
        return;
      }

      var targetState = new _router_state.default(this, this._routerMicrolib, this._routerMicrolib.activeTransition[_router_js.STATE_SYMBOL]);
      this.set('targetState', targetState);
      transition.trigger(true, 'loading', transition, originRoute);
    }

    _cancelSlowTransitionTimer() {
      if (this._slowTransitionTimer) {
        (0, _runloop.cancel)(this._slowTransitionTimer);
      }

      this._slowTransitionTimer = null;
    } // These three helper functions are used to ensure errors aren't
    // re-raised if they're handled in a route's error action.


    _markErrorAsHandled(error) {
      this._handledErrors.add(error);
    }

    _isErrorHandled(error) {
      return this._handledErrors.has(error);
    }

    _clearHandledError(error) {
      this._handledErrors.delete(error);
    }

    _getEngineInstance({
      name,
      instanceId,
      mountPoint
    }) {
      var engineInstances = this._engineInstances;

      if (!engineInstances[name]) {
        engineInstances[name] = Object.create(null);
      }

      var engineInstance = engineInstances[name][instanceId];

      if (!engineInstance) {
        var owner = (0, _owner.getOwner)(this);
        (true && !(owner.hasRegistration("engine:" + name)) && (0, _debug.assert)("You attempted to mount the engine '" + name + "' in your router map, but the engine can not be found.", owner.hasRegistration("engine:" + name)));
        engineInstance = owner.buildChildEngineInstance(name, {
          routable: true,
          mountPoint
        });
        engineInstance.boot();
        engineInstances[name][instanceId] = engineInstance;
      }

      return engineInstance;
    }

  }
  /*
    Helper function for iterating over routes in a set of routeInfos that are
    at or above the given origin route. Example: if `originRoute` === 'foo.bar'
    and the routeInfos given were for 'foo.bar.baz', then the given callback
    will be invoked with the routes for 'foo.bar', 'foo', and 'application'
    individually.
  
    If the callback returns anything other than `true`, then iteration will stop.
  
    @private
    @param {Route} originRoute
    @param {Array<RouteInfo>} routeInfos
    @param {Function} callback
    @return {Void}
   */


  function forEachRouteAbove(routeInfos, callback) {
    for (var i = routeInfos.length - 1; i >= 0; --i) {
      var routeInfo = routeInfos[i];
      var route = routeInfo.route; // routeInfo.handler being `undefined` generally means either:
      //
      // 1. an error occurred during creation of the route in question
      // 2. the route is across an async boundary (e.g. within an engine)
      //
      // In both of these cases, we cannot invoke the callback on that specific
      // route, because it just doesn't exist...

      if (route === undefined) {
        continue;
      }

      if (callback(route, routeInfo) !== true) {
        return;
      }
    }
  } // These get invoked when an action bubbles above ApplicationRoute
  // and are not meant to be overridable.


  var defaultActionHandlers = {
    willResolveModel(_routeInfos, transition, originRoute) {
      this._scheduleLoadingEvent(transition, originRoute);
    },

    // Attempt to find an appropriate error route or substate to enter.
    error(routeInfos, error, transition) {
      var router = this;
      var routeInfoWithError = routeInfos[routeInfos.length - 1];
      forEachRouteAbove(routeInfos, (route, routeInfo) => {
        // We don't check the leaf most routeInfo since that would
        // technically be below where we're at in the route hierarchy.
        if (routeInfo !== routeInfoWithError) {
          // Check for the existence of an 'error' route.
          var errorRouteName = findRouteStateName(route, 'error');

          if (errorRouteName) {
            router._markErrorAsHandled(error);

            router.intermediateTransitionTo(errorRouteName, error);
            return false;
          }
        } // Check for an 'error' substate route


        var errorSubstateName = findRouteSubstateName(route, 'error');

        if (errorSubstateName) {
          router._markErrorAsHandled(error);

          router.intermediateTransitionTo(errorSubstateName, error);
          return false;
        }

        return true;
      });
      logError(error, "Error while processing route: " + transition.targetName);
    },

    // Attempt to find an appropriate loading route or substate to enter.
    loading(routeInfos, transition) {
      var router = this;
      var routeInfoWithSlowLoading = routeInfos[routeInfos.length - 1];
      forEachRouteAbove(routeInfos, (route, routeInfo) => {
        // We don't check the leaf most routeInfos since that would
        // technically be below where we're at in the route hierarchy.
        if (routeInfo !== routeInfoWithSlowLoading) {
          // Check for the existence of a 'loading' route.
          var loadingRouteName = findRouteStateName(route, 'loading');

          if (loadingRouteName) {
            router.intermediateTransitionTo(loadingRouteName);
            return false;
          }
        } // Check for loading substate


        var loadingSubstateName = findRouteSubstateName(route, 'loading');

        if (loadingSubstateName) {
          router.intermediateTransitionTo(loadingSubstateName);
          return false;
        } // Don't bubble above pivot route.


        return transition.pivotHandler !== route;
      });
    }

  };

  function logError(_error, initialMessage) {
    var errorArgs = [];
    var error;

    if (_error && typeof _error === 'object' && typeof _error.errorThrown === 'object') {
      error = _error.errorThrown;
    } else {
      error = _error;
    }

    if (initialMessage) {
      errorArgs.push(initialMessage);
    }

    if (error) {
      if (error.message) {
        errorArgs.push(error.message);
      }

      if (error.stack) {
        errorArgs.push(error.stack);
      }

      if (typeof error === 'string') {
        errorArgs.push(error);
      }
    }

    console.error(...errorArgs); //eslint-disable-line no-console
  }
  /**
    Finds the name of the substate route if it exists for the given route. A
    substate route is of the form `route_state`, such as `foo_loading`.
  
    @private
    @param {Route} route
    @param {String} state
    @return {String}
  */


  function findRouteSubstateName(route, state) {
    var owner = (0, _owner.getOwner)(route);
    var {
      routeName,
      fullRouteName,
      _router: router
    } = route;
    var substateName = routeName + "_" + state;
    var substateNameFull = fullRouteName + "_" + state;
    return routeHasBeenDefined(owner, router, substateName, substateNameFull) ? substateNameFull : '';
  }
  /**
    Finds the name of the state route if it exists for the given route. A state
    route is of the form `route.state`, such as `foo.loading`. Properly Handles
    `application` named routes.
  
    @private
    @param {Route} route
    @param {String} state
    @return {String}
  */


  function findRouteStateName(route, state) {
    var owner = (0, _owner.getOwner)(route);
    var {
      routeName,
      fullRouteName,
      _router: router
    } = route;
    var stateName = routeName === 'application' ? state : routeName + "." + state;
    var stateNameFull = fullRouteName === 'application' ? state : fullRouteName + "." + state;
    return routeHasBeenDefined(owner, router, stateName, stateNameFull) ? stateNameFull : '';
  }
  /**
    Determines whether or not a route has been defined by checking that the route
    is in the Router's map and the owner has a registration for that route.
  
    @private
    @param {Owner} owner
    @param {Router} router
    @param {String} localName
    @param {String} fullName
    @return {Boolean}
  */


  function routeHasBeenDefined(owner, router, localName, fullName) {
    var routerHasRoute = router.hasRoute(fullName);
    var ownerHasRoute = owner.hasRegistration("template:" + localName) || owner.hasRegistration("route:" + localName);
    return routerHasRoute && ownerHasRoute;
  }

  function triggerEvent(routeInfos, ignoreFailure, name, args) {
    if (!routeInfos) {
      if (ignoreFailure) {
        return;
      }

      throw new _error2.default("Can't trigger action '" + name + "' because your app hasn't finished transitioning into its first route. To trigger an action on destination routes during a transition, you can call `.send()` on the `Transition` object passed to the `model/beforeModel/afterModel` hooks.");
    }

    var eventWasHandled = false;
    var routeInfo, handler, actionHandler;

    for (var i = routeInfos.length - 1; i >= 0; i--) {
      routeInfo = routeInfos[i];
      handler = routeInfo.route;
      actionHandler = handler && handler.actions && handler.actions[name];

      if (actionHandler) {
        if (actionHandler.apply(handler, args) === true) {
          eventWasHandled = true;
        } else {
          // Should only hit here if a non-bubbling error action is triggered on a route.
          if (name === 'error') {
            handler._router._markErrorAsHandled(args[0]);
          }

          return;
        }
      }
    }

    var defaultHandler = defaultActionHandlers[name];

    if (defaultHandler) {
      defaultHandler.apply(this, [routeInfos, ...args]);
      return;
    }

    if (!eventWasHandled && !ignoreFailure) {
      throw new _error2.default("Nothing handled the action '" + name + "'. If you did handle the action, this error can be caused by returning true from an action handler in a controller, causing the action to bubble.");
    }
  }

  function calculatePostTransitionState(emberRouter, leafRouteName, contexts) {
    var state = emberRouter._routerMicrolib.applyIntent(leafRouteName, contexts);

    var {
      routeInfos,
      params
    } = state;

    for (var i = 0; i < routeInfos.length; ++i) {
      var routeInfo = routeInfos[i]; // If the routeInfo is not resolved, we serialize the context into params

      if (!routeInfo.isResolved) {
        params[routeInfo.name] = routeInfo.serialize(routeInfo.context);
      } else {
        params[routeInfo.name] = routeInfo.params;
      }
    }

    return state;
  }

  function updatePaths(router) {
    var infos = router._routerMicrolib.currentRouteInfos;

    if (infos.length === 0) {
      return;
    }

    var path = EmberRouter._routePath(infos);

    var currentRouteName = infos[infos.length - 1].name;
    var currentURL = router.get('location').getURL();
    (0, _metal.set)(router, 'currentPath', path);
    (0, _metal.set)(router, 'currentRouteName', currentRouteName);
    (0, _metal.set)(router, 'currentURL', currentURL);
    var appController = (0, _owner.getOwner)(router).lookup('controller:application');

    if (!appController) {
      // appController might not exist when top-level loading/error
      // substates have been entered since ApplicationRoute hasn't
      // actually been entered at that point.
      return;
    }

    if (_deprecatedFeatures.APP_CTRL_ROUTER_PROPS) {
      if (!('currentPath' in appController)) {
        Object.defineProperty(appController, 'currentPath', {
          get() {
            (true && !(false) && (0, _debug.deprecate)('Accessing `currentPath` on `controller:application` is deprecated, use the `currentPath` property on `service:router` instead.', false, {
              id: 'application-controller.router-properties',
              until: '4.0.0',
              url: 'https://emberjs.com/deprecations/v3.x#toc_application-controller-router-properties'
            }));
            return (0, _metal.get)(router, 'currentPath');
          }

        });
      }

      (0, _metal.notifyPropertyChange)(appController, 'currentPath');

      if (!('currentRouteName' in appController)) {
        Object.defineProperty(appController, 'currentRouteName', {
          get() {
            (true && !(false) && (0, _debug.deprecate)('Accessing `currentRouteName` on `controller:application` is deprecated, use the `currentRouteName` property on `service:router` instead.', false, {
              id: 'application-controller.router-properties',
              until: '4.0.0',
              url: 'https://emberjs.com/deprecations/v3.x#toc_application-controller-router-properties'
            }));
            return (0, _metal.get)(router, 'currentRouteName');
          }

        });
      }

      (0, _metal.notifyPropertyChange)(appController, 'currentRouteName');
    }
  }

  EmberRouter.reopenClass({
    /**
      The `Router.map` function allows you to define mappings from URLs to routes
      in your application. These mappings are defined within the
      supplied callback function using `this.route`.
         The first parameter is the name of the route which is used by default as the
      path name as well.
         The second parameter is the optional options hash. Available options are:
           * `path`: allows you to provide your own path as well as mark dynamic
          segments.
        * `resetNamespace`: false by default; when nesting routes, ember will
          combine the route names to form the fully-qualified route name, which is
          used with `{{link-to}}` or manually transitioning to routes. Setting
          `resetNamespace: true` will cause the route not to inherit from its
          parent route's names. This is handy for preventing extremely long route names.
          Keep in mind that the actual URL path behavior is still retained.
         The third parameter is a function, which can be used to nest routes.
      Nested routes, by default, will have the parent route tree's route name and
      path prepended to it's own.
         ```app/router.js
      Router.map(function(){
        this.route('post', { path: '/post/:post_id' }, function() {
          this.route('edit');
          this.route('comments', { resetNamespace: true }, function() {
            this.route('new');
          });
        });
      });
      ```
         @method map
      @param callback
      @public
    */
    map(callback) {
      if (!this.dslCallbacks) {
        this.dslCallbacks = [];
        this.reopenClass({
          dslCallbacks: this.dslCallbacks
        });
      }

      this.dslCallbacks.push(callback);
      return this;
    },

    _routePath(routeInfos) {
      var path = []; // We have to handle coalescing resource names that
      // are prefixed with their parent's names, e.g.
      // ['foo', 'foo.bar.baz'] => 'foo.bar.baz', not 'foo.foo.bar.baz'

      function intersectionMatches(a1, a2) {
        for (var i = 0; i < a1.length; ++i) {
          if (a1[i] !== a2[i]) {
            return false;
          }
        }

        return true;
      }

      var name, nameParts, oldNameParts;

      for (var i = 1; i < routeInfos.length; i++) {
        name = routeInfos[i].name;
        nameParts = name.split('.');
        oldNameParts = slice.call(path);

        while (oldNameParts.length) {
          if (intersectionMatches(oldNameParts, nameParts)) {
            break;
          }

          oldNameParts.shift();
        }

        path.push(...nameParts.slice(oldNameParts.length));
      }

      return path.join('.');
    }

  });

  function didBeginTransition(transition, router) {
    var routerState = new _router_state.default(router, router._routerMicrolib, transition[_router_js.STATE_SYMBOL]);

    if (!router.currentState) {
      router.set('currentState', routerState);
    }

    router.set('targetState', routerState);
    transition.promise = transition.catch(error => {
      if (router._isErrorHandled(error)) {
        router._clearHandledError(error);
      } else {
        throw error;
      }
    }, 'Transition Error');
  }

  function forEachQueryParam(router, routeInfos, queryParams, callback) {
    var qpCache = router._queryParamsFor(routeInfos);

    for (var key in queryParams) {
      if (!queryParams.hasOwnProperty(key)) {
        continue;
      }

      var value = queryParams[key];
      var qp = qpCache.map[key];
      callback(key, value, qp);
    }
  }

  function findLiveRoute(liveRoutes, name) {
    if (!liveRoutes) {
      return;
    }

    var stack = [liveRoutes];

    while (stack.length > 0) {
      var test = stack.shift();

      if (test.render.name === name) {
        return test;
      }

      var outlets = test.outlets;

      for (var outletName in outlets) {
        stack.push(outlets[outletName]);
      }
    }

    return;
  }

  function appendLiveRoute(liveRoutes, defaultParentState, renderOptions) {
    var target;
    var myState = {
      render: renderOptions,
      outlets: Object.create(null),
      wasUsed: false
    };

    if (renderOptions.into) {
      target = findLiveRoute(liveRoutes, renderOptions.into);
    } else {
      target = defaultParentState;
    }

    if (target) {
      (0, _metal.set)(target.outlets, renderOptions.outlet, myState);
    } else {
      liveRoutes = myState;
    }

    return {
      liveRoutes,
      ownState: myState
    };
  }

  function representEmptyRoute(liveRoutes, defaultParentState, route) {
    // the route didn't render anything
    var alreadyAppended = findLiveRoute(liveRoutes, route.routeName);

    if (alreadyAppended) {
      // But some other route has already rendered our default
      // template, so that becomes the default target for any
      // children we may have.
      return alreadyAppended;
    } else {
      // Create an entry to represent our default template name,
      // just so other routes can target it and inherit its place
      // in the outlet hierarchy.
      defaultParentState.outlets.main = {
        render: {
          name: route.routeName,
          outlet: 'main'
        },
        outlets: {}
      };
      return defaultParentState;
    }
  }

  EmberRouter.reopen(_runtime.Evented, {
    /**
      Handles updating the paths and notifying any listeners of the URL
      change.
         Triggers the router level `didTransition` hook.
         For example, to notify google analytics when the route changes,
      you could use this hook.  (Note: requires also including GA scripts, etc.)
         ```javascript
      import config from './config/environment';
      import EmberRouter from '@ember/routing/router';
      import { inject as service } from '@ember/service';
         let Router = EmberRouter.extend({
        location: config.locationType,
           router: service(),
           didTransition: function() {
          this._super(...arguments);
             ga('send', 'pageview', {
            page: this.router.currentURL,
            title: this.router.currentRouteName,
          });
        }
      });
      ```
         @method didTransition
      @public
      @since 1.2.0
    */
    didTransition: defaultDidTransition,

    /**
      Handles notifying any listeners of an impending URL
      change.
         Triggers the router level `willTransition` hook.
         @method willTransition
      @public
      @since 1.11.0
    */
    willTransition: defaultWillTransition,

    /**
     Represents the URL of the root of the application, often '/'. This prefix is
     assumed on all routes defined on this router.
        @property rootURL
     @default '/'
     @public
    */
    rootURL: '/',

    /**
     The `location` property determines the type of URL's that your
     application will use.
        The following location types are currently available:
        * `history` - use the browser's history API to make the URLs look just like any standard URL
     * `hash` - use `#` to separate the server part of the URL from the Ember part: `/blog/#/posts/new`
     * `none` - do not store the Ember URL in the actual browser URL (mainly used for testing)
     * `auto` - use the best option based on browser capabilities: `history` if possible, then `hash` if possible, otherwise `none`
        This value is defaulted to `auto` by the `locationType` setting of `/config/environment.js`
        @property location
     @default 'hash'
     @see {Location}
     @public
    */
    location: 'hash',

    /**
     Represents the current URL.
        @property url
     @type {String}
     @private
    */
    url: (0, _metal.computed)(function () {
      var location = (0, _metal.get)(this, 'location');

      if (typeof location === 'string') {
        return undefined;
      }

      return location.getURL();
    })
  });

  if (_deprecatedFeatures.ROUTER_EVENTS) {
    EmberRouter.reopen(_route.ROUTER_EVENT_DEPRECATIONS);
  }

  var _default = EmberRouter;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/system/router_state", ["exports", "@ember/polyfills", "@ember/-internals/routing/lib/utils"], function (_exports, _polyfills, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class RouterState {
    constructor(emberRouter, router, routerJsState) {
      this.emberRouter = emberRouter;
      this.router = router;
      this.routerJsState = routerJsState;
    }

    isActiveIntent(routeName, models, queryParams, queryParamsMustMatch) {
      var state = this.routerJsState;

      if (!this.router.isActiveIntent(routeName, models, undefined, state)) {
        return false;
      }

      if (queryParamsMustMatch && Object.keys(queryParams).length > 0) {
        var visibleQueryParams = (0, _polyfills.assign)({}, queryParams);

        this.emberRouter._prepareQueryParams(routeName, models, visibleQueryParams);

        return (0, _utils.shallowEqual)(visibleQueryParams, state.queryParams);
      }

      return true;
    }

  }

  _exports.default = RouterState;
});
define("@ember/-internals/routing/lib/system/transition", [], function () {
  "use strict";
  /**
    A Transition is a thennable (a promise-like object) that represents
    an attempt to transition to another route. It can be aborted, either
    explicitly via `abort` or by attempting another transition while a
    previous one is still underway. An aborted transition can also
    be `retry()`d later.
  
    @class Transition
    @public
  */

  /**
    The Transition's internal promise. Calling `.then` on this property
    is that same as calling `.then` on the Transition object itself, but
    this property is exposed for when you want to pass around a
    Transition's promise, but not the Transition object itself, since
    Transition object can be externally `abort`ed, while the promise
    cannot.
  
    @property promise
    @type {Object}
    @public
    */

  /**
    Custom state can be stored on a Transition's `data` object.
    This can be useful for decorating a Transition within an earlier
    hook and shared with a later hook. Properties set on `data` will
    be copied to new transitions generated by calling `retry` on this
    transition.
  
    @property data
    @type {Object}
    @public
  */

  /**
    A standard promise hook that resolves if the transition
    succeeds and rejects if it fails/redirects/aborts.
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method then
    @param {Function} onFulfilled
    @param {Function} onRejected
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method catch
    @param {Function} onRejection
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method finally
    @param {Function} callback
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
    Aborts the Transition. Note you can also implicitly abort a transition
    by initiating another transition while a previous one is underway.
  
    @method abort
    @return {Transition} this transition
    @public
  */

  /**
  
    Retries a previously-aborted transition (making sure to abort the
    transition if it's still active). Returns a new transition that
    represents the new attempt to transition.
  
    @method retry
    @return {Transition} new transition
    @public
    */

  /**
  
    Sets the URL-changing method to be employed at the end of a
    successful transition. By default, a new Transition will just
    use `updateURL`, but passing 'replace' to this method will
    cause the URL to update using 'replaceWith' instead. Omitting
    a parameter will disable the URL change, allowing for transitions
    that don't update the URL at completion (this is also used for
    handleURL, since the URL has already changed before the
    transition took place).
  
    @method method
    @param {String} method the type of URL-changing method to use
      at the end of a transition. Accepted values are 'replace',
      falsy values, or any other non-falsy value (which is
      interpreted as an updateURL transition).
  
    @return {Transition} this transition
    @public
  */

  /**
  
    Fires an event on the current list of resolved/resolving
    handlers within this transition. Useful for firing events
    on route hierarchies that haven't fully been entered yet.
  
    Note: This method is also aliased as `send`
  
    @method trigger
    @param {Boolean} [ignoreFailure=false] a boolean specifying whether unhandled events throw an error
    @param {String} name the name of the event to fire
    @public
  */

  /**
   * This property is a `RouteInfo` object that represents
   * where the router is transitioning to. It's important
   * to note that a `RouteInfo` is a linked list and this
   * property represents the leafmost route.
   * @property {RouteInfo|RouteInfoWithAttributes} to
   * @public
   */

  /**
   * This property is a `RouteInfo` object that represents
   * where transition originated from. It's important
   * to note that a `RouteInfo` is a linked list and this
   * property represents the head node of the list.
   * In the case of an initial render, `from` will be set to
   * `null`.
   * @property {RouteInfoWithAttributes} from
   * @public
   */

  /**
    Transitions are aborted and their promises rejected
    when redirects occur; this method returns a promise
    that will follow any redirects that occur and fulfill
    with the value fulfilled by any redirecting transitions
    that occur.
  
    @method followRedirects
    @return {Promise} a promise that fulfills with the same
      value that the final redirecting transition fulfills with
    @public
  */
});
define("@ember/-internals/routing/lib/utils", ["exports", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/error", "@ember/polyfills", "router_js"], function (_exports, _metal, _owner, _error, _polyfills, _router_js) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.extractRouteArgs = extractRouteArgs;
  _exports.getActiveTargetName = getActiveTargetName;
  _exports.stashParamNames = stashParamNames;
  _exports.calculateCacheKey = calculateCacheKey;
  _exports.normalizeControllerQueryParams = normalizeControllerQueryParams;
  _exports.resemblesURL = resemblesURL;
  _exports.prefixRouteNameArg = prefixRouteNameArg;
  _exports.shallowEqual = shallowEqual;
  var ALL_PERIODS_REGEX = /\./g;

  function extractRouteArgs(args) {
    args = args.slice();
    var possibleQueryParams = args[args.length - 1];
    var queryParams;

    if (possibleQueryParams && possibleQueryParams.hasOwnProperty('queryParams')) {
      queryParams = args.pop().queryParams;
    } else {
      queryParams = {};
    }

    var routeName = args.shift();
    return {
      routeName,
      models: args,
      queryParams
    };
  }

  function getActiveTargetName(router) {
    var routeInfos = router.activeTransition ? router.activeTransition[_router_js.STATE_SYMBOL].routeInfos : router.state.routeInfos;
    return routeInfos[routeInfos.length - 1].name;
  }

  function stashParamNames(router, routeInfos) {
    if (routeInfos['_namesStashed']) {
      return;
    } // This helper exists because router.js/route-recognizer.js awkwardly
    // keeps separate a routeInfo's list of parameter names depending
    // on whether a URL transition or named transition is happening.
    // Hopefully we can remove this in the future.


    var targetRouteName = routeInfos[routeInfos.length - 1].name;

    var recogHandlers = router._routerMicrolib.recognizer.handlersFor(targetRouteName);

    var dynamicParent;

    for (var i = 0; i < routeInfos.length; ++i) {
      var routeInfo = routeInfos[i];
      var names = recogHandlers[i].names;

      if (names.length) {
        dynamicParent = routeInfo;
      }

      routeInfo['_names'] = names;
      var route = routeInfo.route;

      route._stashNames(routeInfo, dynamicParent);
    }

    routeInfos['_namesStashed'] = true;
  }

  function _calculateCacheValuePrefix(prefix, part) {
    // calculates the dot separated sections from prefix that are also
    // at the start of part - which gives us the route name
    // given : prefix = site.article.comments, part = site.article.id
    //      - returns: site.article (use get(values[site.article], 'id') to get the dynamic part - used below)
    // given : prefix = site.article, part = site.article.id
    //      - returns: site.article. (use get(values[site.article], 'id') to get the dynamic part - used below)
    var prefixParts = prefix.split('.');
    var currPrefix = '';

    for (var i = 0; i < prefixParts.length; i++) {
      var currPart = prefixParts.slice(0, i + 1).join('.');

      if (part.indexOf(currPart) !== 0) {
        break;
      }

      currPrefix = currPart;
    }

    return currPrefix;
  }
  /*
    Stolen from Controller
  */


  function calculateCacheKey(prefix, parts = [], values) {
    var suffixes = '';

    for (var i = 0; i < parts.length; ++i) {
      var part = parts[i];

      var cacheValuePrefix = _calculateCacheValuePrefix(prefix, part);

      var value = void 0;

      if (values) {
        if (cacheValuePrefix && cacheValuePrefix in values) {
          var partRemovedPrefix = part.indexOf(cacheValuePrefix) === 0 ? part.substr(cacheValuePrefix.length + 1) : part;
          value = (0, _metal.get)(values[cacheValuePrefix], partRemovedPrefix);
        } else {
          value = (0, _metal.get)(values, part);
        }
      }

      suffixes += "::" + part + ":" + value;
    }

    return prefix + suffixes.replace(ALL_PERIODS_REGEX, '-');
  }
  /*
    Controller-defined query parameters can come in three shapes:
  
    Array
      queryParams: ['foo', 'bar']
    Array of simple objects where value is an alias
      queryParams: [
        {
          'foo': 'rename_foo_to_this'
        },
        {
          'bar': 'call_bar_this_instead'
        }
      ]
    Array of fully defined objects
      queryParams: [
        {
          'foo': {
            as: 'rename_foo_to_this'
          },
        }
        {
          'bar': {
            as: 'call_bar_this_instead',
            scope: 'controller'
          }
        }
      ]
  
    This helper normalizes all three possible styles into the
    'Array of fully defined objects' style.
  */


  function normalizeControllerQueryParams(queryParams) {
    var qpMap = {};

    for (var i = 0; i < queryParams.length; ++i) {
      accumulateQueryParamDescriptors(queryParams[i], qpMap);
    }

    return qpMap;
  }

  function accumulateQueryParamDescriptors(_desc, accum) {
    var desc = _desc;
    var tmp;

    if (typeof desc === 'string') {
      tmp = {};
      tmp[desc] = {
        as: null
      };
      desc = tmp;
    }

    for (var key in desc) {
      if (!desc.hasOwnProperty(key)) {
        return;
      }

      var singleDesc = desc[key];

      if (typeof singleDesc === 'string') {
        singleDesc = {
          as: singleDesc
        };
      }

      tmp = accum[key] || {
        as: null,
        scope: 'model'
      };
      (0, _polyfills.assign)(tmp, singleDesc);
      accum[key] = tmp;
    }
  }
  /*
    Check if a routeName resembles a url instead
  
    @private
  */


  function resemblesURL(str) {
    return typeof str === 'string' && (str === '' || str[0] === '/');
  }
  /*
    Returns an arguments array where the route name arg is prefixed based on the mount point
  
    @private
  */


  function prefixRouteNameArg(route, args) {
    var routeName = args[0];
    var owner = (0, _owner.getOwner)(route);
    var prefix = owner.mountPoint; // only alter the routeName if it's actually referencing a route.

    if (owner.routable && typeof routeName === 'string') {
      if (resemblesURL(routeName)) {
        throw new _error.default('Programmatic transitions by URL cannot be used within an Engine. Please use the route name instead.');
      } else {
        routeName = prefix + "." + routeName;
        args[0] = routeName;
      }
    }

    return args;
  }

  function shallowEqual(a, b) {
    var k;
    var aCount = 0;
    var bCount = 0;

    for (k in a) {
      if (a.hasOwnProperty(k)) {
        if (a[k] !== b[k]) {
          return false;
        }

        aCount++;
      }
    }

    for (k in b) {
      if (b.hasOwnProperty(k)) {
        bCount++;
      }
    }

    return aCount === bCount;
  }
});
define("@ember/-internals/runtime/index", ["exports", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/registry_proxy", "@ember/-internals/runtime/lib/mixins/container_proxy", "@ember/-internals/runtime/lib/copy", "@ember/-internals/runtime/lib/compare", "@ember/-internals/runtime/lib/is-equal", "@ember/-internals/runtime/lib/mixins/array", "@ember/-internals/runtime/lib/mixins/comparable", "@ember/-internals/runtime/lib/system/namespace", "@ember/-internals/runtime/lib/system/array_proxy", "@ember/-internals/runtime/lib/system/object_proxy", "@ember/-internals/runtime/lib/system/core_object", "@ember/-internals/runtime/lib/mixins/action_handler", "@ember/-internals/runtime/lib/mixins/copyable", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/runtime/lib/mixins/-proxy", "@ember/-internals/runtime/lib/mixins/observable", "@ember/-internals/runtime/lib/mixins/mutable_enumerable", "@ember/-internals/runtime/lib/mixins/target_action_support", "@ember/-internals/runtime/lib/mixins/evented", "@ember/-internals/runtime/lib/mixins/promise_proxy", "@ember/-internals/runtime/lib/ext/rsvp", "@ember/-internals/runtime/lib/type-of", "@ember/-internals/runtime/lib/ext/function"], function (_exports, _object, _registry_proxy, _container_proxy, _copy, _compare, _isEqual, _array, _comparable, _namespace, _array_proxy, _object_proxy, _core_object, _action_handler, _copyable, _enumerable, _proxy, _observable, _mutable_enumerable, _target_action_support, _evented, _promise_proxy, _rsvp, _typeOf, _function) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "Object", {
    enumerable: true,
    get: function () {
      return _object.default;
    }
  });
  Object.defineProperty(_exports, "FrameworkObject", {
    enumerable: true,
    get: function () {
      return _object.FrameworkObject;
    }
  });
  Object.defineProperty(_exports, "RegistryProxyMixin", {
    enumerable: true,
    get: function () {
      return _registry_proxy.default;
    }
  });
  Object.defineProperty(_exports, "ContainerProxyMixin", {
    enumerable: true,
    get: function () {
      return _container_proxy.default;
    }
  });
  Object.defineProperty(_exports, "copy", {
    enumerable: true,
    get: function () {
      return _copy.default;
    }
  });
  Object.defineProperty(_exports, "compare", {
    enumerable: true,
    get: function () {
      return _compare.default;
    }
  });
  Object.defineProperty(_exports, "isEqual", {
    enumerable: true,
    get: function () {
      return _isEqual.default;
    }
  });
  Object.defineProperty(_exports, "Array", {
    enumerable: true,
    get: function () {
      return _array.default;
    }
  });
  Object.defineProperty(_exports, "NativeArray", {
    enumerable: true,
    get: function () {
      return _array.NativeArray;
    }
  });
  Object.defineProperty(_exports, "A", {
    enumerable: true,
    get: function () {
      return _array.A;
    }
  });
  Object.defineProperty(_exports, "MutableArray", {
    enumerable: true,
    get: function () {
      return _array.MutableArray;
    }
  });
  Object.defineProperty(_exports, "removeAt", {
    enumerable: true,
    get: function () {
      return _array.removeAt;
    }
  });
  Object.defineProperty(_exports, "uniqBy", {
    enumerable: true,
    get: function () {
      return _array.uniqBy;
    }
  });
  Object.defineProperty(_exports, "isArray", {
    enumerable: true,
    get: function () {
      return _array.isArray;
    }
  });
  Object.defineProperty(_exports, "Comparable", {
    enumerable: true,
    get: function () {
      return _comparable.default;
    }
  });
  Object.defineProperty(_exports, "Namespace", {
    enumerable: true,
    get: function () {
      return _namespace.default;
    }
  });
  Object.defineProperty(_exports, "ArrayProxy", {
    enumerable: true,
    get: function () {
      return _array_proxy.default;
    }
  });
  Object.defineProperty(_exports, "ObjectProxy", {
    enumerable: true,
    get: function () {
      return _object_proxy.default;
    }
  });
  Object.defineProperty(_exports, "CoreObject", {
    enumerable: true,
    get: function () {
      return _core_object.default;
    }
  });
  Object.defineProperty(_exports, "setFrameworkClass", {
    enumerable: true,
    get: function () {
      return _core_object.setFrameworkClass;
    }
  });
  Object.defineProperty(_exports, "ActionHandler", {
    enumerable: true,
    get: function () {
      return _action_handler.default;
    }
  });
  Object.defineProperty(_exports, "Copyable", {
    enumerable: true,
    get: function () {
      return _copyable.default;
    }
  });
  Object.defineProperty(_exports, "Enumerable", {
    enumerable: true,
    get: function () {
      return _enumerable.default;
    }
  });
  Object.defineProperty(_exports, "_ProxyMixin", {
    enumerable: true,
    get: function () {
      return _proxy.default;
    }
  });
  Object.defineProperty(_exports, "_contentFor", {
    enumerable: true,
    get: function () {
      return _proxy.contentFor;
    }
  });
  Object.defineProperty(_exports, "Observable", {
    enumerable: true,
    get: function () {
      return _observable.default;
    }
  });
  Object.defineProperty(_exports, "MutableEnumerable", {
    enumerable: true,
    get: function () {
      return _mutable_enumerable.default;
    }
  });
  Object.defineProperty(_exports, "TargetActionSupport", {
    enumerable: true,
    get: function () {
      return _target_action_support.default;
    }
  });
  Object.defineProperty(_exports, "Evented", {
    enumerable: true,
    get: function () {
      return _evented.default;
    }
  });
  Object.defineProperty(_exports, "PromiseProxyMixin", {
    enumerable: true,
    get: function () {
      return _promise_proxy.default;
    }
  });
  Object.defineProperty(_exports, "RSVP", {
    enumerable: true,
    get: function () {
      return _rsvp.default;
    }
  });
  Object.defineProperty(_exports, "onerrorDefault", {
    enumerable: true,
    get: function () {
      return _rsvp.onerrorDefault;
    }
  });
  Object.defineProperty(_exports, "typeOf", {
    enumerable: true,
    get: function () {
      return _typeOf.typeOf;
    }
  });
});
define("@ember/-internals/runtime/lib/compare", ["exports", "@ember/-internals/runtime/lib/type-of", "@ember/-internals/runtime/lib/mixins/comparable"], function (_exports, _typeOf, _comparable) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = compare;
  var TYPE_ORDER = {
    undefined: 0,
    null: 1,
    boolean: 2,
    number: 3,
    string: 4,
    array: 5,
    object: 6,
    instance: 7,
    function: 8,
    class: 9,
    date: 10
  }; //
  // the spaceship operator
  //
  //                      `. ___
  //                     __,' __`.                _..----....____
  //         __...--.'``;.   ,.   ;``--..__     .'    ,-._    _.-'
  //   _..-''-------'   `'   `'   `'     O ``-''._   (,;') _,'
  // ,'________________                          \`-._`-','
  //  `._              ```````````------...___   '-.._'-:
  //     ```--.._      ,.                     ````--...__\-.
  //             `.--. `-` "INFINITY IS LESS     ____    |  |`
  //               `. `.   THAN BEYOND"        ,'`````.  ;  ;`
  //                 `._`.        __________   `.      \'__/`
  //                    `-:._____/______/___/____`.     \  `
  //                                |       `._    `.    \
  //                                `._________`-.   `.   `.___
  //                                              SSt  `------'`

  function spaceship(a, b) {
    var diff = a - b;
    return (diff > 0) - (diff < 0);
  }
  /**
   @module @ember/utils
  */

  /**
   Compares two javascript values and returns:
  
    - -1 if the first is smaller than the second,
    - 0 if both are equal,
    - 1 if the first is greater than the second.
  
    ```javascript
    import { compare } from '@ember/utils';
  
    compare('hello', 'hello');  // 0
    compare('abc', 'dfg');      // -1
    compare(2, 1);              // 1
    ```
  
   If the types of the two objects are different precedence occurs in the
   following order, with types earlier in the list considered `<` types
   later in the list:
  
    - undefined
    - null
    - boolean
    - number
    - string
    - array
    - object
    - instance
    - function
    - class
    - date
  
    ```javascript
    import { compare } from '@ember/utils';
  
    compare('hello', 50);       // 1
    compare(50, 'hello');       // -1
    ```
  
   @method compare
   @for @ember/utils
   @static
   @param {Object} v First value to compare
   @param {Object} w Second value to compare
   @return {Number} -1 if v < w, 0 if v = w and 1 if v > w.
   @public
  */


  function compare(v, w) {
    if (v === w) {
      return 0;
    }

    var type1 = (0, _typeOf.typeOf)(v);
    var type2 = (0, _typeOf.typeOf)(w);

    if (type1 === 'instance' && _comparable.default.detect(v) && v.constructor.compare) {
      return v.constructor.compare(v, w);
    }

    if (type2 === 'instance' && _comparable.default.detect(w) && w.constructor.compare) {
      return w.constructor.compare(w, v) * -1;
    }

    var res = spaceship(TYPE_ORDER[type1], TYPE_ORDER[type2]);

    if (res !== 0) {
      return res;
    } // types are equal - so we have to check values now


    switch (type1) {
      case 'boolean':
      case 'number':
        return spaceship(v, w);

      case 'string':
        return spaceship(v.localeCompare(w), 0);

      case 'array':
        {
          var vLen = v.length;
          var wLen = w.length;
          var len = Math.min(vLen, wLen);

          for (var i = 0; i < len; i++) {
            var r = compare(v[i], w[i]);

            if (r !== 0) {
              return r;
            }
          } // all elements are equal now
          // shorter array should be ordered first


          return spaceship(vLen, wLen);
        }

      case 'instance':
        if (_comparable.default.detect(v)) {
          return v.compare(v, w);
        }

        return 0;

      case 'date':
        return spaceship(v.getTime(), w.getTime());

      default:
        return 0;
    }
  }
});
define("@ember/-internals/runtime/lib/copy", ["exports", "@ember/debug", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/copyable"], function (_exports, _debug, _object, _copyable) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = copy;

  /**
   @module @ember/object
  */
  function _copy(obj, deep, seen, copies) {
    // primitive data types are immutable, just return them.
    if (typeof obj !== 'object' || obj === null) {
      return obj;
    }

    var ret, loc; // avoid cyclical loops

    if (deep && (loc = seen.indexOf(obj)) >= 0) {
      return copies[loc];
    }

    if (deep) {
      seen.push(obj);
    } // IMPORTANT: this specific test will detect a native array only. Any other
    // object will need to implement Copyable.


    if (Array.isArray(obj)) {
      ret = obj.slice();

      if (deep) {
        copies.push(ret);
        loc = ret.length;

        while (--loc >= 0) {
          ret[loc] = _copy(ret[loc], deep, seen, copies);
        }
      }
    } else if (_copyable.default.detect(obj)) {
      ret = obj.copy(deep, seen, copies);

      if (deep) {
        copies.push(ret);
      }
    } else if (obj instanceof Date) {
      ret = new Date(obj.getTime());

      if (deep) {
        copies.push(ret);
      }
    } else {
      (true && !(!(obj instanceof _object.default) || _copyable.default.detect(obj)) && (0, _debug.assert)('Cannot clone an EmberObject that does not implement Copyable', !(obj instanceof _object.default) || _copyable.default.detect(obj)));
      ret = {};

      if (deep) {
        copies.push(ret);
      }

      var key;

      for (key in obj) {
        // support Null prototype
        if (!Object.prototype.hasOwnProperty.call(obj, key)) {
          continue;
        } // Prevents browsers that don't respect non-enumerability from
        // copying internal Ember properties


        if (key.substring(0, 2) === '__') {
          continue;
        }

        ret[key] = deep ? _copy(obj[key], deep, seen, copies) : obj[key];
      }
    }

    return ret;
  }
  /**
    Creates a shallow copy of the passed object. A deep copy of the object is
    returned if the optional `deep` argument is `true`.
  
    If the passed object implements the `Copyable` interface, then this
    function will delegate to the object's `copy()` method and return the
    result. See `Copyable` for further details.
  
    For primitive values (which are immutable in JavaScript), the passed object
    is simply returned.
  
    @method copy
    @deprecated Use 'ember-copy' addon instead
    @static
    @for @ember/object/internals
    @param {Object} obj The object to clone
    @param {Boolean} [deep=false] If true, a deep copy of the object is made.
    @return {Object} The copied object
    @public
  */


  function copy(obj, deep) {
    (true && !(false) && (0, _debug.deprecate)('Use ember-copy addon instead of copy method and Copyable mixin.', false, {
      id: 'ember-runtime.deprecate-copy-copyable',
      until: '4.0.0',
      url: 'https://emberjs.com/deprecations/v3.x/#toc_ember-runtime-deprecate-copy-copyable'
    })); // fast paths

    if ('object' !== typeof obj || obj === null) {
      return obj; // can't copy primitives
    }

    if (!Array.isArray(obj) && _copyable.default.detect(obj)) {
      return obj.copy(deep);
    }

    return _copy(obj, deep, deep ? [] : null, deep ? [] : null);
  }
});
define("@ember/-internals/runtime/lib/ext/function", ["@ember/-internals/environment", "@ember/-internals/metal", "@ember/debug", "@ember/deprecated-features"], function (_environment, _metal, _debug, _deprecatedFeatures) {
  "use strict";

  /**
  @module ember
  */
  if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS && _environment.ENV.EXTEND_PROTOTYPES.Function) {
    Object.defineProperties(Function.prototype, {
      /**
        The `property` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        `true`, which is the default.
         Computed properties allow you to treat a function like a property:
         ```app/utils/president.js
        import EmberObject from '@ember/object';
         export default EmberObject.extend({
          firstName: '',
          lastName:  '',
           fullName: function() {
            return this.get('firstName') + ' ' + this.get('lastName');
          }.property() // Call this flag to mark the function as a property
        });
        ```
         ```javascript
        let president = President.create({
          firstName: 'Barack',
          lastName: 'Obama'
        });
         president.get('fullName'); // 'Barack Obama'
        ```
         Treating a function like a property is useful because they can work with
        bindings, just like any other property.
         Many computed properties have dependencies on other properties. For
        example, in the above example, the `fullName` property depends on
        `firstName` and `lastName` to determine its value. You can tell Ember
        about these dependencies like this:
         ```app/utils/president.js
        import EmberObject from '@ember/object';
         export default EmberObject.extend({
          firstName: '',
          lastName:  '',
           fullName: function() {
            return this.get('firstName') + ' ' + this.get('lastName');
             // Tell Ember.js that this computed property depends on firstName
            // and lastName
          }.property('firstName', 'lastName')
        });
        ```
         Make sure you list these dependencies so Ember knows when to update
        bindings that connect to a computed property. Changing a dependency
        will not immediately trigger an update of the computed property, but
        will instead clear the cache so that it is updated when the next `get`
        is called on the property.
         See [ComputedProperty](/ember/release/classes/ComputedProperty), [@ember/object/computed](/ember/release/classes/@ember%2Fobject%2Fcomputed).
         @method property
        @for Function
        @public
      */
      property: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function () {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.property('bar') to computed('bar', function() {}).", false, {
            id: 'function-prototype-extensions.property',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-property'
          }));
          return (0, _metal.computed)(...arguments, this);
        }
      },

      /**
        The `observes` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        true, which is the default.
         You can observe property changes simply by adding the `observes`
        call to the end of your method declarations in classes that you write.
        For example:
         ```javascript
        import EmberObject from '@ember/object';
         EmberObject.extend({
          valueObserver: function() {
            // Executes whenever the "value" property changes
          }.observes('value')
        });
        ```
         In the future this method may become asynchronous.
         See `observer`.
         @method observes
        @for Function
        @public
      */
      observes: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function () {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.observes('foo') to observer('foo', function() {}).", false, {
            id: 'function-prototype-extensions.observes',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-observes'
          }));
          return (0, _metal.observer)(...arguments, this);
        }
      },

      /**
        The `on` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        true, which is the default.
         You can listen for events simply by adding the `on` call to the end of
        your method declarations in classes or mixins that you write. For example:
         ```javascript
        import Mixin from '@ember/mixin';
         Mixin.create({
          doSomethingWithElement: function() {
            // Executes whenever the "didInsertElement" event fires
          }.on('didInsertElement')
        });
        ```
         See `@ember/object/evented/on`.
         @method on
        @for Function
        @public
      */
      on: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function () {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.on('foo') to on('foo', function() {}).", false, {
            id: 'function-prototype-extensions.on',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-on'
          }));
          return (0, _metal.on)(...arguments, this);
        }
      }
    });
  }
});
define("@ember/-internals/runtime/lib/ext/rsvp", ["exports", "rsvp", "@ember/runloop", "@ember/-internals/error-handling", "@ember/debug"], function (_exports, RSVP, _runloop, _errorHandling, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.onerrorDefault = onerrorDefault;
  _exports.default = void 0;
  RSVP.configure('async', (callback, promise) => {
    _runloop.backburner.schedule('actions', null, callback, promise);
  });
  RSVP.configure('after', cb => {
    _runloop.backburner.schedule(_runloop._rsvpErrorQueue, null, cb);
  });
  RSVP.on('error', onerrorDefault);

  function onerrorDefault(reason) {
    var error = errorFor(reason);

    if (error) {
      var overrideDispatch = (0, _errorHandling.getDispatchOverride)();

      if (overrideDispatch) {
        overrideDispatch(error);
      } else {
        throw error;
      }
    }
  }

  function errorFor(reason) {
    if (!reason) return;

    if (reason.errorThrown) {
      return unwrapErrorThrown(reason);
    }

    if (reason.name === 'UnrecognizedURLError') {
      (true && !(false) && (0, _debug.assert)("The URL '" + reason.message + "' did not match any routes in your application", false));
      return;
    }

    if (reason.name === 'TransitionAborted') {
      return;
    }

    return reason;
  }

  function unwrapErrorThrown(reason) {
    var error = reason.errorThrown;

    if (typeof error === 'string') {
      error = new Error(error);
    }

    Object.defineProperty(error, '__reason_with_error_thrown__', {
      value: reason,
      enumerable: false
    });
    return error;
  }

  var _default = RSVP;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/is-equal", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = isEqual;

  /**
   @module @ember/utils
  */

  /**
    Compares two objects, returning true if they are equal.
  
    ```javascript
    import { isEqual } from '@ember/utils';
  
    isEqual('hello', 'hello');                   // true
    isEqual(1, 2);                               // false
    ```
  
    `isEqual` is a more specific comparison than a triple equal comparison.
    It will call the `isEqual` instance method on the objects being
    compared, allowing finer control over when objects should be considered
    equal to each other.
  
    ```javascript
    import { isEqual } from '@ember/utils';
    import EmberObject from '@ember/object';
  
    let Person = EmberObject.extend({
      isEqual(other) { return this.ssn == other.ssn; }
    });
  
    let personA = Person.create({name: 'Muhammad Ali', ssn: '123-45-6789'});
    let personB = Person.create({name: 'Cassius Clay', ssn: '123-45-6789'});
  
    isEqual(personA, personB); // true
    ```
  
    Due to the expense of array comparisons, collections will never be equal to
    each other even if each of their items are equal to each other.
  
    ```javascript
    import { isEqual } from '@ember/utils';
  
    isEqual([4, 2], [4, 2]);                     // false
    ```
  
    @method isEqual
    @for @ember/utils
    @static
    @param {Object} a first object to compare
    @param {Object} b second object to compare
    @return {Boolean}
    @public
  */
  function isEqual(a, b) {
    if (a && typeof a.isEqual === 'function') {
      return a.isEqual(b);
    }

    if (a instanceof Date && b instanceof Date) {
      return a.getTime() === b.getTime();
    }

    return a === b;
  }
});
define("@ember/-internals/runtime/lib/mixins/-proxy", ["exports", "@ember/-internals/meta", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/debug", "@glimmer/reference"], function (_exports, _meta, _metal, _utils, _debug, _reference) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.contentFor = contentFor;
  _exports.default = void 0;

  /**
  @module ember
  */
  function contentFor(proxy, m) {
    var content = (0, _metal.get)(proxy, 'content');
    var tag = (m === undefined ? (0, _meta.meta)(proxy) : m).readableTag();

    if (tag !== undefined) {
      (0, _reference.update)(tag, (0, _metal.tagFor)(content));
    }

    return content;
  }
  /**
    `Ember.ProxyMixin` forwards all properties not defined by the proxy itself
    to a proxied `content` object.  See ObjectProxy for more details.
  
    @class ProxyMixin
    @namespace Ember
    @private
  */


  var _default = _metal.Mixin.create({
    /**
      The object whose properties will be forwarded.
       @property content
      @type {unknown}
      @default null
      @public
    */
    content: null,

    init() {
      this._super(...arguments);

      (0, _utils.setProxy)(this);
      var m = (0, _meta.meta)(this);
      m.writableTag();
    },

    willDestroy() {
      this.set('content', null);

      this._super(...arguments);
    },

    isTruthy: (0, _metal.computed)('content', function () {
      return Boolean((0, _metal.get)(this, 'content'));
    }),

    willWatchProperty(key) {
      if (!true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          var contentKey = "content." + key;
          (0, _metal.addObserver)(this, contentKey, null, '_contentPropertyDidChange');
        }
    },

    didUnwatchProperty(key) {
      if (!true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          var contentKey = "content." + key;
          (0, _metal.removeObserver)(this, contentKey, null, '_contentPropertyDidChange');
        }
    },

    _contentPropertyDidChange(content, contentKey) {
      var key = contentKey.slice(8); // remove "content."

      if (key in this) {
        return;
      } // if shadowed in proxy


      (0, _metal.notifyPropertyChange)(this, key);
    },

    [_metal.UNKNOWN_PROPERTY_TAG](key) {
      return (0, _reference.combine)((0, _metal.getChainTagsForKey)(this, "content." + key));
    },

    unknownProperty(key) {
      var content = contentFor(this);

      if (content) {
        return (0, _metal.get)(content, key);
      }
    },

    setUnknownProperty(key, value) {
      var m = (0, _meta.meta)(this);

      if (m.isInitializing() || m.isPrototypeMeta(this)) {
        // if marked as prototype or object is initializing then just
        // defineProperty rather than delegate
        (0, _metal.defineProperty)(this, key, null, value);
        return value;
      }

      var content = contentFor(this, m);
      (true && !(content) && (0, _debug.assert)("Cannot delegate set('" + key + "', " + value + ") to the 'content' property of object proxy " + this + ": its 'content' is undefined.", content));
      return (0, _metal.set)(content, key, value);
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/action_handler", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    `Ember.ActionHandler` is available on some familiar classes including
    `Route`, `Component`, and `Controller`.
    (Internally the mixin is used by `Ember.CoreView`, `Ember.ControllerMixin`,
    and `Route` and available to the above classes through
    inheritance.)
  
    @class ActionHandler
    @namespace Ember
    @private
  */
  var ActionHandler = _metal.Mixin.create({
    mergedProperties: ['actions'],

    /**
      The collection of functions, keyed by name, available on this
      `ActionHandler` as action targets.
       These functions will be invoked when a matching `{{action}}` is triggered
      from within a template and the application's current route is this route.
       Actions can also be invoked from other parts of your application
      via `ActionHandler#send`.
       The `actions` hash will inherit action handlers from
      the `actions` hash defined on extended parent classes
      or mixins rather than just replace the entire hash, e.g.:
       ```app/mixins/can-display-banner.js
      import Mixin from '@ember/mixin';
       export default Mixin.create({
        actions: {
          displayBanner(msg) {
            // ...
          }
        }
      });
      ```
       ```app/routes/welcome.js
      import Route from '@ember/routing/route';
      import CanDisplayBanner from '../mixins/can-display-banner';
       export default Route.extend(CanDisplayBanner, {
        actions: {
          playMusic() {
            // ...
          }
        }
      });
       // `WelcomeRoute`, when active, will be able to respond
      // to both actions, since the actions hash is merged rather
      // then replaced when extending mixins / parent classes.
      this.send('displayBanner');
      this.send('playMusic');
      ```
       Within a Controller, Route or Component's action handler,
      the value of the `this` context is the Controller, Route or
      Component object:
       ```app/routes/song.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          myAction() {
            this.controllerFor("song");
            this.transitionTo("other.route");
            ...
          }
        }
      });
      ```
       It is also possible to call `this._super(...arguments)` from within an
      action handler if it overrides a handler defined on a parent
      class or mixin:
       Take for example the following routes:
       ```app/mixins/debug-route.js
      import Mixin from '@ember/mixin';
       export default Mixin.create({
        actions: {
          debugRouteInformation() {
            console.debug("It's a-me, console.debug!");
          }
        }
      });
      ```
       ```app/routes/annoying-debug.js
      import Route from '@ember/routing/route';
      import DebugRoute from '../mixins/debug-route';
       export default Route.extend(DebugRoute, {
        actions: {
          debugRouteInformation() {
            // also call the debugRouteInformation of mixed in DebugRoute
            this._super(...arguments);
             // show additional annoyance
            window.alert(...);
          }
        }
      });
      ```
       ## Bubbling
       By default, an action will stop bubbling once a handler defined
      on the `actions` hash handles it. To continue bubbling the action,
      you must return `true` from the handler:
       ```app/router.js
      Router.map(function() {
        this.route("album", function() {
          this.route("song");
        });
      });
      ```
       ```app/routes/album.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          startPlaying: function() {
          }
        }
      });
      ```
       ```app/routes/album-song.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          startPlaying() {
            // ...
             if (actionShouldAlsoBeTriggeredOnParentRoute) {
              return true;
            }
          }
        }
      });
      ```
       @property actions
      @type Object
      @default null
      @public
    */

    /**
      Triggers a named action on the `ActionHandler`. Any parameters
      supplied after the `actionName` string will be passed as arguments
      to the action target function.
       If the `ActionHandler` has its `target` property set, actions may
      bubble to the `target`. Bubbling happens when an `actionName` can
      not be found in the `ActionHandler`'s `actions` hash or if the
      action target function returns `true`.
       Example
       ```app/routes/welcome.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          playTheme() {
            this.send('playMusic', 'theme.mp3');
          },
          playMusic(track) {
            // ...
          }
        }
      });
      ```
       @method send
      @param {String} actionName The action to trigger
      @param {*} context a context to send with the action
      @public
    */
    send(actionName, ...args) {
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .send() with the action '" + actionName + "' on the destroyed object '" + this + "'.", !this.isDestroying && !this.isDestroyed));

      if (this.actions && this.actions[actionName]) {
        var shouldBubble = this.actions[actionName].apply(this, args) === true;

        if (!shouldBubble) {
          return;
        }
      }

      var target = (0, _metal.get)(this, 'target');

      if (target) {
        (true && !(typeof target.send === 'function') && (0, _debug.assert)("The `target` for " + this + " (" + target + ") does not have a `send` method", typeof target.send === 'function'));
        target.send(...arguments);
      }
    }

  });

  var _default = ActionHandler;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/array", ["exports", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/debug", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/runtime/lib/compare", "@ember/-internals/environment", "@ember/-internals/runtime/lib/mixins/observable", "@ember/-internals/runtime/lib/mixins/mutable_enumerable", "@ember/-internals/runtime/lib/type-of"], function (_exports, _metal, _utils, _debug, _enumerable, _compare, _environment, _observable, _mutable_enumerable, _typeOf) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.uniqBy = uniqBy;
  _exports.removeAt = removeAt;
  _exports.isArray = isArray;
  _exports.default = _exports.MutableArray = _exports.NativeArray = _exports.A = void 0;

  /**
  @module @ember/array
  */
  var EMPTY_ARRAY = Object.freeze([]);

  var identityFunction = item => item;

  function uniqBy(array, key = identityFunction) {
    (true && !(isArray(array)) && (0, _debug.assert)("first argument passed to `uniqBy` should be array", isArray(array)));
    var ret = A();
    var seen = new Set();
    var getter = typeof key === 'function' ? key : item => (0, _metal.get)(item, key);
    array.forEach(item => {
      var val = getter(item);

      if (!seen.has(val)) {
        seen.add(val);
        ret.push(item);
      }
    });
    return ret;
  }

  function iter(key, value) {
    var valueProvided = arguments.length === 2;
    return valueProvided ? item => value === (0, _metal.get)(item, key) : item => Boolean((0, _metal.get)(item, key));
  }

  function findIndex(array, predicate, startAt) {
    var len = array.length;

    for (var index = startAt; index < len; index++) {
      var item = (0, _metal.objectAt)(array, index);

      if (predicate(item, index, array)) {
        return index;
      }
    }

    return -1;
  }

  function find(array, callback, target) {
    var predicate = callback.bind(target);
    var index = findIndex(array, predicate, 0);
    return index === -1 ? undefined : (0, _metal.objectAt)(array, index);
  }

  function any(array, callback, target) {
    var predicate = callback.bind(target);
    return findIndex(array, predicate, 0) !== -1;
  }

  function every(array, callback, target) {
    var cb = callback.bind(target);

    var predicate = (item, index, array) => !cb(item, index, array);

    return findIndex(array, predicate, 0) === -1;
  }

  function indexOf(array, val, startAt = 0, withNaNCheck) {
    var len = array.length;

    if (startAt < 0) {
      startAt += len;
    } // SameValueZero comparison (NaN !== NaN)


    var predicate = withNaNCheck && val !== val ? item => item !== item : item => item === val;
    return findIndex(array, predicate, startAt);
  }

  function removeAt(array, index, len = 1) {
    (true && !(index > -1 && index < array.length) && (0, _debug.assert)("`removeAt` index provided is out of range", index > -1 && index < array.length));
    (0, _metal.replace)(array, index, len, EMPTY_ARRAY);
    return array;
  }

  function insertAt(array, index, item) {
    (true && !(index > -1 && index <= array.length) && (0, _debug.assert)("`insertAt` index provided is out of range", index > -1 && index <= array.length));
    (0, _metal.replace)(array, index, 0, [item]);
    return item;
  }
  /**
    Returns true if the passed object is an array or Array-like.
  
    Objects are considered Array-like if any of the following are true:
  
      - the object is a native Array
      - the object has an objectAt property
      - the object is an Object, and has a length property
  
    Unlike `typeOf` this method returns true even if the passed object is
    not formally an array but appears to be array-like (i.e. implements `Array`)
  
    ```javascript
    import { isArray } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    isArray();                                      // false
    isArray([]);                                    // true
    isArray(ArrayProxy.create({ content: [] }));    // true
    ```
  
    @method isArray
    @static
    @for @ember/array
    @param {Object} obj The object to test
    @return {Boolean} true if the passed object is an array or Array-like
    @public
  */


  function isArray(_obj) {
    var obj = _obj;

    if (true
    /* DEBUG */
    && _utils.HAS_NATIVE_PROXY && typeof _obj === 'object' && _obj !== null) {
      var possibleProxyContent = _obj[_metal.PROXY_CONTENT];

      if (possibleProxyContent !== undefined) {
        obj = possibleProxyContent;
      }
    }

    if (!obj || obj.setInterval) {
      return false;
    }

    if (Array.isArray(obj) || ArrayMixin.detect(obj)) {
      return true;
    }

    var type = (0, _typeOf.typeOf)(obj);

    if ('array' === type) {
      return true;
    }

    var length = obj.length;

    if (typeof length === 'number' && length === length && 'object' === type) {
      return true;
    }

    return false;
  }
  /*
    This allows us to define computed properties that are not enumerable.
    The primary reason this is important is that when `NativeArray` is
    applied to `Array.prototype` we need to ensure that we do not add _any_
    new enumerable properties.
  */


  function nonEnumerableComputed() {
    var property = (0, _metal.computed)(...arguments);
    property.enumerable = false;
    return property;
  }

  function mapBy(key) {
    return this.map(next => (0, _metal.get)(next, key));
  } // ..........................................................
  // ARRAY
  //

  /**
    This mixin implements Observer-friendly Array-like behavior. It is not a
    concrete implementation, but it can be used up by other classes that want
    to appear like arrays.
  
    For example, ArrayProxy is a concrete class that can be instantiated to
    implement array-like behavior. This class uses the Array Mixin by way of
    the MutableArray mixin, which allows observable changes to be made to the
    underlying array.
  
    This mixin defines methods specifically for collections that provide
    index-ordered access to their contents. When you are designing code that
    needs to accept any kind of Array-like object, you should use these methods
    instead of Array primitives because these will properly notify observers of
    changes to the array.
  
    Although these methods are efficient, they do add a layer of indirection to
    your application so it is a good idea to use them only when you need the
    flexibility of using both true JavaScript arrays and "virtual" arrays such
    as controllers and collections.
  
    You can use the methods defined in this module to access and modify array
    contents in an observable-friendly way. You can also be notified whenever
    the membership of an array changes by using `.observes('myArray.[]')`.
  
    To support `EmberArray` in your own class, you must override two
    primitives to use it: `length()` and `objectAt()`.
  
    @class EmberArray
    @uses Enumerable
    @since Ember 0.9.0
    @public
  */


  var ArrayMixin = _metal.Mixin.create(_enumerable.default, {
    [_utils.EMBER_ARRAY]: true,

    /**
      __Required.__ You must implement this method to apply this mixin.
       Your array must support the `length` property. Your replace methods should
      set this property whenever it changes.
       @property {Number} length
      @public
    */

    /**
      Returns the object at the given `index`. If the given `index` is negative
      or is greater or equal than the array length, returns `undefined`.
       This is one of the primitives you must implement to support `EmberArray`.
      If your object supports retrieving the value of an array item using `get()`
      (i.e. `myArray.get(0)`), then you do not need to implement this method
      yourself.
       ```javascript
      let arr = ['a', 'b', 'c', 'd'];
       arr.objectAt(0);   // 'a'
      arr.objectAt(3);   // 'd'
      arr.objectAt(-1);  // undefined
      arr.objectAt(4);   // undefined
      arr.objectAt(5);   // undefined
      ```
       @method objectAt
      @param {Number} idx The index of the item to return.
      @return {*} item at index or undefined
      @public
    */

    /**
      This returns the objects at the specified indexes, using `objectAt`.
       ```javascript
      let arr = ['a', 'b', 'c', 'd'];
       arr.objectsAt([0, 1, 2]);  // ['a', 'b', 'c']
      arr.objectsAt([2, 3, 4]);  // ['c', 'd', undefined]
      ```
       @method objectsAt
      @param {Array} indexes An array of indexes of items to return.
      @return {Array}
      @public
     */
    objectsAt(indexes) {
      return indexes.map(idx => (0, _metal.objectAt)(this, idx));
    },

    /**
      This is the handler for the special array content property. If you get
      this property, it will return this. If you set this property to a new
      array, it will replace the current content.
       ```javascript
      let peopleToMoon = ['Armstrong', 'Aldrin'];
      
      peopleToMoon.get('[]'); // ['Armstrong', 'Aldrin']
       peopleToMoon.set('[]', ['Collins']); // ['Collins']
      peopleToMoon.get('[]'); // ['Collins']
      ```
       @property []
      @return this
      @public
    */
    '[]': nonEnumerableComputed({
      get() {
        return this;
      },

      set(key, value) {
        this.replace(0, this.length, value);
        return this;
      }

    }),

    /**
      The first object in the array, or `undefined` if the array is empty.
       @property firstObject
      @return {Object | undefined} The first object in the array
      @public
    */
    firstObject: nonEnumerableComputed(function () {
      return (0, _metal.objectAt)(this, 0);
    }).readOnly(),

    /**
      The last object in the array, or `undefined` if the array is empty.
       @property lastObject
      @return {Object | undefined} The last object in the array
      @public
    */
    lastObject: nonEnumerableComputed(function () {
      return (0, _metal.objectAt)(this, this.length - 1);
    }).readOnly(),

    // Add any extra methods to EmberArray that are native to the built-in Array.

    /**
      Returns a new array that is a slice of the receiver. This implementation
      uses the observable array methods to retrieve the objects for the new
      slice.
       ```javascript
      let arr = ['red', 'green', 'blue'];
       arr.slice(0);       // ['red', 'green', 'blue']
      arr.slice(0, 2);    // ['red', 'green']
      arr.slice(1, 100);  // ['green', 'blue']
      ```
       @method slice
      @param {Number} beginIndex (Optional) index to begin slicing from.
      @param {Number} endIndex (Optional) index to end the slice at (but not included).
      @return {Array} New array with specified slice
      @public
    */
    slice(beginIndex = 0, endIndex) {
      var ret = A();
      var length = this.length;

      if (beginIndex < 0) {
        beginIndex = length + beginIndex;
      }

      if (endIndex === undefined || endIndex > length) {
        endIndex = length;
      } else if (endIndex < 0) {
        endIndex = length + endIndex;
      }

      while (beginIndex < endIndex) {
        ret[ret.length] = (0, _metal.objectAt)(this, beginIndex++);
      }

      return ret;
    },

    /**
      Returns the index of the given object's first occurrence.
      If no `startAt` argument is given, the starting location to
      search is 0. If it's negative, will count backward from
      the end of the array. Returns -1 if no match is found.
       ```javascript
      let arr = ['a', 'b', 'c', 'd', 'a'];
       arr.indexOf('a');       //  0
      arr.indexOf('z');       // -1
      arr.indexOf('a', 2);    //  4
      arr.indexOf('a', -1);   //  4
      arr.indexOf('b', 3);    // -1
      arr.indexOf('a', 100);  // -1
      ```
       @method indexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search, default 0
      @return {Number} index or -1 if not found
      @public
    */
    indexOf(object, startAt) {
      return indexOf(this, object, startAt, false);
    },

    /**
      Returns the index of the given object's last occurrence.
      If no `startAt` argument is given, the search starts from
      the last position. If it's negative, will count backward
      from the end of the array. Returns -1 if no match is found.
       ```javascript
      let arr = ['a', 'b', 'c', 'd', 'a'];
       arr.lastIndexOf('a');       //  4
      arr.lastIndexOf('z');       // -1
      arr.lastIndexOf('a', 2);    //  0
      arr.lastIndexOf('a', -1);   //  4
      arr.lastIndexOf('b', 3);    //  1
      arr.lastIndexOf('a', 100);  //  4
      ```
       @method lastIndexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search, default 0
      @return {Number} index or -1 if not found
      @public
    */
    lastIndexOf(object, startAt) {
      var len = this.length;

      if (startAt === undefined || startAt >= len) {
        startAt = len - 1;
      }

      if (startAt < 0) {
        startAt += len;
      }

      for (var idx = startAt; idx >= 0; idx--) {
        if ((0, _metal.objectAt)(this, idx) === object) {
          return idx;
        }
      }

      return -1;
    },

    // ..........................................................
    // ARRAY OBSERVERS
    //

    /**
      Adds an array observer to the receiving array. The array observer object
      normally must implement two methods:
       * `willChange(observedObj, start, removeCount, addCount)` - This method will be
        called just before the array is modified.
      * `didChange(observedObj, start, removeCount, addCount)` - This method will be
        called just after the array is modified.
       Both callbacks will be passed the observed object, starting index of the
      change as well as a count of the items to be removed and added. You can use
      these callbacks to optionally inspect the array during the change, clear
      caches, or do any other bookkeeping necessary.
       In addition to passing a target, you can also include an options hash
      which you can use to override the method names that will be invoked on the
      target.
       @method addArrayObserver
      @param {Object} target The observer object.
      @param {Object} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {EmberArray} receiver
      @public
      @example
          import Service from '@ember/service';
           export default Service.extend({
            data: Ember.A(),
             init() {
              this._super(...arguments);
               this.data.addArrayObserver(this, {
                willChange: 'dataWillChange',
                didChange: 'dataDidChange'
              });
            },
             dataWillChange(array, start, removeCount, addCount) {
              console.log('array will change', array, start, removeCount, addCount);
            },
             dataDidChange(array, start, removeCount, addCount) {
              console.log('array did change', array, start, removeCount, addCount);
            }
          });
    */
    addArrayObserver(target, opts) {
      return (0, _metal.addArrayObserver)(this, target, opts);
    },

    /**
      Removes an array observer from the object if the observer is current
      registered. Calling this method multiple times with the same object will
      have no effect.
       @method removeArrayObserver
      @param {Object} target The object observing the array.
      @param {Object} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {EmberArray} receiver
      @public
    */
    removeArrayObserver(target, opts) {
      return (0, _metal.removeArrayObserver)(this, target, opts);
    },

    /**
      Becomes true whenever the array currently has observers watching changes
      on the array.
       @property {Boolean} hasArrayObservers
      @public
    */
    hasArrayObservers: nonEnumerableComputed(function () {
      return (0, _metal.hasListeners)(this, '@array:change') || (0, _metal.hasListeners)(this, '@array:before');
    }),

    /**
      If you are implementing an object that supports `EmberArray`, call this
      method just before the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       ```app/components/show-post.js
      import Component from '@ember/component';
      import EmberObject from '@ember/object';
       const Post = EmberObject.extend({
        body: '',
        save() {}
      })
       export default Component.extend({
        attemptsToModify: 0,
        successfulModifications: 0,
        posts: null,
         init() {
          this._super(...arguments);
           this.posts = [1, 2, 3].map(i => Post.create({ body: i }));
          this.posts.addArrayObserver(this, {
            willChange() {
              this.incrementProperty('attemptsToModify');
            },
            didChange() {
              this.incrementProperty('successfulModifications');
            }
          });
        },
         actions: {
          editPost(post, newContent) {
            let oldContent = post.body,
                postIndex = this.posts.indexOf(post);
                
            this.posts.arrayContentWillChange(postIndex, 0, 0); // attemptsToModify = 1
            post.set('body', newContent);
             post.save()
              .then(response => {
                this.posts.arrayContentDidChange(postIndex, 0, 0); // successfulModifications = 1
              })
              .catch(error => {
                post.set('body', oldContent);
              })
          }
        }
      });
      ```
       @method arrayContentWillChange
      @param {Number} startIdx The starting index in the array that will change.
      @param {Number} removeAmt The number of items that will be removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that will be added. If you
        pass `null` assumes 0.
      @return {EmberArray} receiver
      @public
    */
    arrayContentWillChange(startIdx, removeAmt, addAmt) {
      return (0, _metal.arrayContentWillChange)(this, startIdx, removeAmt, addAmt);
    },

    /**
      If you are implementing an object that supports `EmberArray`, call this
      method just after the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       ```javascript
      let arr = [1, 2, 3, 4, 5];
       arr.copyWithin(-2); // [1, 2, 3, 1, 2]
      // arr.lastObject = 5
      arr.arrayContentDidChange(3, 2, 2);
      // arr.lastObject = 2
      ```
       @method arrayContentDidChange
      @param {Number} startIdx The starting index in the array that did change.
      @param {Number} removeAmt The number of items that were removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that were added. If you
        pass `null` assumes 0.
      @return {EmberArray} receiver
      @public
    */
    arrayContentDidChange(startIdx, removeAmt, addAmt) {
      return (0, _metal.arrayContentDidChange)(this, startIdx, removeAmt, addAmt);
    },

    /**
      Iterates through the array, calling the passed function on each
      item. This method corresponds to the `forEach()` method defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method forEach
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} receiver
      @public
    */
    forEach(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`forEach` expects a function as first argument.', typeof callback === 'function'));
      var length = this.length;

      for (var index = 0; index < length; index++) {
        var item = this.objectAt(index);
        callback.call(target, item, index, this);
      }

      return this;
    },

    /**
      Alias for `mapBy`
       @method getEach
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    getEach: mapBy,

    /**
      Sets the value on the named property for each member. This is more
      ergonomic than using other methods defined on this helper. If the object
      implements Observable, the value will be changed to `set(),` otherwise
      it will be set directly. `null` objects are skipped.
       ```javascript
      let people = [{name: 'Joe'}, {name: 'Matt'}];
      
      people.setEach('zipCode', '10011);
      // [{name: 'Joe', zipCode: '10011'}, {name: 'Matt', zipCode: '10011'}];
      ```
       @method setEach
      @param {String} key The key to set
      @param {Object} value The object to set
      @return {Object} receiver
      @public
    */
    setEach(key, value) {
      return this.forEach(item => (0, _metal.set)(item, key, value));
    },

    /**
      Maps all of the items in the enumeration to another value, returning
      a new array. This method corresponds to `map()` defined in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      let arr = [1, 2, 3, 4, 5, 6];
       arr.map(element => element * element);
      // [1, 4, 9, 16, 25, 36];
       arr.map((element, index) => element + index);
      // [1, 3, 5, 7, 9, 11];
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return the mapped value.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method map
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} The mapped array.
      @public
    */
    map(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`map` expects a function as first argument.', typeof callback === 'function'));
      var ret = A();
      this.forEach((x, idx, i) => ret[idx] = callback.call(target, x, idx, i));
      return ret;
    },

    /**
      Similar to map, this specialized function returns the value of the named
      property on all items in the enumeration.
       ```javascript
      let people = [{name: 'Joe'}, {name: 'Matt'}];
       people.mapBy('name');
      // ['Joe', 'Matt'];
       people.mapBy('unknownProperty');
      // [undefined, undefined];
      ```
       @method mapBy
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    mapBy,

    /**
      Returns an array with all of the items in the enumeration that the passed
      function returns true for. This method corresponds to `filter()` defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method filter
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A filtered array.
      @public
    */
    filter(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`filter` expects a function as first argument.', typeof callback === 'function'));
      var ret = A();
      this.forEach((x, idx, i) => {
        if (callback.call(target, x, idx, i)) {
          ret.push(x);
        }
      });
      return ret;
    },

    /**
      Returns an array with all of the items in the enumeration where the passed
      function returns false. This method is the inverse of filter().
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - *item* is the current item in the iteration.
      - *index* is the current index in the iteration
      - *array* is the array itself.
       It should return a falsey value to include the item in the results.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as "this" on the context. This is a good way
      to give your iterator function access to the current object.
       @method reject
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A rejected array.
      @public
    */
    reject(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`reject` expects a function as first argument.', typeof callback === 'function'));
      return this.filter(function () {
        return !callback.apply(target, arguments);
      });
    },

    /**
      Returns an array with just the items with the matched property. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       Example Usage:
       ```javascript
      const things = Ember.A().addObjects([{food: 'apple'}, {food: 'beans'}]);
      things.filterBy('food', 'beans'); // [{food: 'beans'}]
      ```
       @method filterBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} filtered array
      @public
    */
    filterBy() {
      return this.filter(iter(...arguments));
    },

    /**
      Returns an array with the items that do not have truthy values for
      key.  You can pass an optional second argument with the target value.  Otherwise
      this will match any property that evaluates to false.
       @method rejectBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} rejected array
      @public
    */
    rejectBy() {
      return this.reject(iter(...arguments));
    },

    /**
      Returns the first item in the array for which the callback returns true.
      This method is similar to the `find()` method defined in ECMAScript 2015.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
      
      Example Usage:
       ```javascript
      let users = [
        { id: 1, name: 'Yehuda' },
        { id: 2, name: 'Tom' },
        { id: 3, name: 'Melanie' },
        { id: 4, name: 'Leah' }
      ];
       users.find((user) => user.name == 'Tom'); // [{ id: 2, name: 'Tom' }]
      users.find(({ id }) => id == 3); // [{ id: 3, name: 'Melanie' }]
      ```
       @method find
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} Found item or `undefined`.
      @public
    */
    find(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`find` expects a function as first argument.', typeof callback === 'function'));
      return find(this, callback, target);
    },

    /**
      Returns the first item with a property matching the passed value. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       This method works much like the more generic `find()` method.
       Usage Example:
       ```javascript
      let users = [
        { id: 1, name: 'Yehuda', isTom: false },
        { id: 2, name: 'Tom', isTom: true },
        { id: 3, name: 'Melanie', isTom: false },
        { id: 4, name: 'Leah', isTom: false }
      ];
       users.findBy('id', 4); // { id: 4, name: 'Leah', isTom: false }
      users.findBy('name', 'Melanie'); // { id: 3, name: 'Melanie', isTom: false }
      users.findBy('isTom'); // { id: 2, name: 'Tom', isTom: true }
      ```
       @method findBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Object} found item or `undefined`
      @public
    */
    findBy() {
      return find(this, iter(...arguments));
    },

    /**
      Returns `true` if the passed function returns true for every item in the
      enumeration. This corresponds with the `every()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return the `true` or `false`.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      if (people.every(isEngineer)) {
        Paychecks.addBigBonus();
      }
      ```
       @method every
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean}
      @public
    */
    every(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`every` expects a function as first argument.', typeof callback === 'function'));
      return every(this, callback, target);
    },

    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for all items in the array. This method is often simpler/faster
      than using a callback.
       Note that like the native `Array.every`, `isEvery` will return true when called
      on any empty array.
       @method isEvery
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isEvery() {
      return every(this, iter(...arguments));
    },

    /**
      Returns `true` if the passed function returns true for any item in the
      enumeration.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array object itself.
       It must return a truthy value (i.e. `true`) to include an item in the
      results. Any non-truthy return value will discard the item from the
      results.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Usage Example:
       ```javascript
      if (people.any(isManager)) {
        Paychecks.addBiggerBonus();
      }
      ```
       @method any
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean} `true` if the passed function returns `true` for any item
      @public
    */
    any(callback, target = null) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`any` expects a function as first argument.', typeof callback === 'function'));
      return any(this, callback, target);
    },

    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for any item in the array. This method is often simpler/faster
      than using a callback.
       @method isAny
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isAny() {
      return any(this, iter(...arguments));
    },

    /**
      This will combine the values of the enumerator into a single value. It
      is a useful way to collect a summary value from an enumeration. This
      corresponds to the `reduce()` method defined in JavaScript 1.8.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(previousValue, item, index, array);
      ```
       - `previousValue` is the value returned by the last call to the iterator.
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       Return the new cumulative value.
       In addition to the callback you can also pass an `initialValue`. An error
      will be raised if you do not pass an initial value and the enumerator is
      empty.
       Note that unlike the other methods, this method does not allow you to
      pass a target object to set as this for the callback. It's part of the
      spec. Sorry.
       @method reduce
      @param {Function} callback The callback to execute
      @param {Object} initialValue Initial value for the reduce
      @return {Object} The reduced value.
      @public
    */
    reduce(callback, initialValue) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`reduce` expects a function as first argument.', typeof callback === 'function'));
      var ret = initialValue;
      this.forEach(function (item, i) {
        ret = callback(ret, item, i, this);
      }, this);
      return ret;
    },

    /**
      Invokes the named method on every object in the receiver that
      implements it. This method corresponds to the implementation in
      Prototype 1.6.
       ```javascript
      const Person = EmberObject.extend({
        name: null,
        greet(prefix='Hello') {
          return `${prefix} ${this.name}`;
        },
        
      });
      let people = [Person.create('Joe'), Person.create('Matt')];
       people.invoke('greet'); // ['Hello Joe', 'Hello Matt']
      people.invoke('greet', 'Bonjour'); // ['Bonjour Joe', 'Bonjour Matt']
      ```
       @method invoke
      @param {String} methodName the name of the method
      @param {Object...} args optional arguments to pass as well.
      @return {Array} return values from calling invoke.
      @public
    */
    invoke(methodName, ...args) {
      var ret = A();
      this.forEach(item => ret.push((0, _utils.tryInvoke)(item, methodName, args)));
      return ret;
    },

    /**
      Simply converts the object into a genuine array. The order is not
      guaranteed. Corresponds to the method implemented by Prototype.
       @method toArray
      @return {Array} the object as an array.
      @public
    */
    toArray() {
      return this.map(item => item);
    },

    /**
      Returns a copy of the array with all `null` and `undefined` elements removed.
       ```javascript
      let arr = ['a', null, 'c', undefined];
      arr.compact();  // ['a', 'c']
      ```
       @method compact
      @return {Array} the array without null and undefined elements.
      @public
    */
    compact() {
      return this.filter(value => value != null);
    },

    /**
      Returns `true` if the passed object can be found in the array.
      This method is a Polyfill for ES 2016 Array.includes.
      If no `startAt` argument is given, the starting location to
      search is 0. If it's negative, searches from the index of
      `this.length + startAt` by asc.
       ```javascript
      [1, 2, 3].includes(2);     // true
      [1, 2, 3].includes(4);     // false
      [1, 2, 3].includes(3, 2);  // true
      [1, 2, 3].includes(3, 3);  // false
      [1, 2, 3].includes(3, -1); // true
      [1, 2, 3].includes(1, -1); // false
      [1, 2, 3].includes(1, -4); // true
      [1, 2, NaN].includes(NaN); // true
      ```
       @method includes
      @param {Object} object The object to search for.
      @param {Number} startAt optional starting location to search, default 0
      @return {Boolean} `true` if object is found in the array.
      @public
    */
    includes(object, startAt) {
      return indexOf(this, object, startAt, true) !== -1;
    },

    /**
      Sorts the array by the keys specified in the argument.
       You may provide multiple arguments to sort by multiple properties.
       ```javascript
     let colors = [
       { name: 'red', weight: 500 },
       { name: 'green', weight: 600 },
       { name: 'blue', weight: 500 }
      ];
     
     colors.sortBy('name');
     // [{name: 'blue', weight: 500}, {name: 'green', weight: 600}, {name: 'red', weight: 500}]
     
     colors.sortBy('weight', 'name');
     // [{name: 'blue', weight: 500}, {name: 'red', weight: 500}, {name: 'green', weight: 600}]
     ```
       @method sortBy
      @param {String} property name(s) to sort on
      @return {Array} The sorted array.
      @since 1.2.0
      @public
    */
    sortBy() {
      var sortKeys = arguments;
      return this.toArray().sort((a, b) => {
        for (var i = 0; i < sortKeys.length; i++) {
          var key = sortKeys[i];
          var propA = (0, _metal.get)(a, key);
          var propB = (0, _metal.get)(b, key); // return 1 or -1 else continue to the next sortKey

          var compareValue = (0, _compare.default)(propA, propB);

          if (compareValue) {
            return compareValue;
          }
        }

        return 0;
      });
    },

    /**
      Returns a new array that contains only unique values. The default
      implementation returns an array regardless of the receiver type.
       ```javascript
      let arr = ['a', 'a', 'b', 'b'];
      arr.uniq();  // ['a', 'b']
      ```
       This only works on primitive data types, e.g. Strings, Numbers, etc.
       @method uniq
      @return {EmberArray}
      @public
    */
    uniq() {
      return uniqBy(this);
    },

    /**
      Returns a new array that contains only items containing a unique property value.
      The default implementation returns an array regardless of the receiver type.
       ```javascript
      let arr = [{ value: 'a' }, { value: 'a' }, { value: 'b' }, { value: 'b' }];
      arr.uniqBy('value');  // [{ value: 'a' }, { value: 'b' }]
       let arr = [2.2, 2.1, 3.2, 3.3];
      arr.uniqBy(Math.floor);  // [2.2, 3.2];
      ```
       @method uniqBy
      @param {String,Function} key
      @return {EmberArray}
      @public
    */
    uniqBy(key) {
      return uniqBy(this, key);
    },

    /**
      Returns a new array that excludes the passed value. The default
      implementation returns an array regardless of the receiver type.
      If the receiver does not contain the value it returns the original array.
       ```javascript
      let arr = ['a', 'b', 'a', 'c'];
      arr.without('a');  // ['b', 'c']
      ```
       @method without
      @param {Object} value
      @return {EmberArray}
      @public
    */
    without(value) {
      if (!this.includes(value)) {
        return this; // nothing to do
      } // SameValueZero comparison (NaN !== NaN)


      var predicate = value === value ? item => item !== value : item => item === item;
      return this.filter(predicate);
    }

  });
  /**
    This mixin defines the API for modifying array-like objects. These methods
    can be applied only to a collection that keeps its items in an ordered set.
    It builds upon the Array mixin and adds methods to modify the array.
    One concrete implementations of this class include ArrayProxy.
  
    It is important to use the methods in this class to modify arrays so that
    changes are observable. This allows the binding system in Ember to function
    correctly.
  
  
    Note that an Array can change even if it does not implement this mixin.
    For example, one might implement a SparseArray that cannot be directly
    modified, but if its underlying enumerable changes, it will change also.
  
    @class MutableArray
    @uses EmberArray
    @uses MutableEnumerable
    @public
  */


  var MutableArray = _metal.Mixin.create(ArrayMixin, _mutable_enumerable.default, {
    /**
      __Required.__ You must implement this method to apply this mixin.
       This is one of the primitives you must implement to support `Array`.
      You should replace amt objects started at idx with the objects in the
      passed array. You should also call `this.arrayContentDidChange()`
       Note that this method is expected to validate the type(s) of objects that it expects.
       @method replace
      @param {Number} idx Starting index in the array to replace. If
        idx >= length, then append to the end of the array.
      @param {Number} amt Number of elements that should be removed from
        the array, starting at *idx*.
      @param {EmberArray} objects An array of zero or more objects that should be
        inserted into the array at *idx*
      @public
    */

    /**
      Remove all elements from the array. This is useful if you
      want to reuse an existing array without having to recreate it.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.length;  // 3
      colors.clear(); // []
      colors.length;  // 0
      ```
       @method clear
      @return {Array} An empty Array.
      @public
    */
    clear() {
      var len = this.length;

      if (len === 0) {
        return this;
      }

      this.replace(0, len, EMPTY_ARRAY);
      return this;
    },

    /**
      This will use the primitive `replace()` method to insert an object at the
      specified index.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.insertAt(2, 'yellow');  // ['red', 'green', 'yellow', 'blue']
      colors.insertAt(5, 'orange');  // Error: Index out of range
      ```
       @method insertAt
      @param {Number} idx index of insert the object at.
      @param {Object} object object to insert
      @return {EmberArray} receiver
      @public
    */
    insertAt(idx, object) {
      insertAt(this, idx, object);
      return this;
    },

    /**
      Remove an object at the specified index using the `replace()` primitive
      method. You can pass either a single index, or a start and a length.
       If you pass a start and length that is beyond the
      length this method will throw an assertion.
       ```javascript
      let colors = ['red', 'green', 'blue', 'yellow', 'orange'];
       colors.removeAt(0);     // ['green', 'blue', 'yellow', 'orange']
      colors.removeAt(2, 2);  // ['green', 'blue']
      colors.removeAt(4, 2);  // Error: Index out of range
      ```
       @method removeAt
      @param {Number} start index, start of range
      @param {Number} len length of passing range
      @return {EmberArray} receiver
      @public
    */
    removeAt(start, len) {
      return removeAt(this, start, len);
    },

    /**
      Push the object onto the end of the array. Works just like `push()` but it
      is KVO-compliant.
       ```javascript
      let colors = ['red', 'green'];
       colors.pushObject('black');     // ['red', 'green', 'black']
      colors.pushObject(['yellow']);  // ['red', 'green', ['yellow']]
      ```
       @method pushObject
      @param {*} obj object to push
      @return object same object passed as a param
      @public
    */
    pushObject(obj) {
      return insertAt(this, this.length, obj);
    },

    /**
      Add the objects in the passed array to the end of the array. Defers
      notifying observers of the change until all objects are added.
       ```javascript
      let colors = ['red'];
       colors.pushObjects(['yellow', 'orange']);  // ['red', 'yellow', 'orange']
      ```
       @method pushObjects
      @param {EmberArray} objects the objects to add
      @return {EmberArray} receiver
      @public
    */
    pushObjects(objects) {
      this.replace(this.length, 0, objects);
      return this;
    },

    /**
      Pop object from array or nil if none are left. Works just like `pop()` but
      it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.popObject();   // 'blue'
      console.log(colors);  // ['red', 'green']
      ```
       @method popObject
      @return object
      @public
    */
    popObject() {
      var len = this.length;

      if (len === 0) {
        return null;
      }

      var ret = (0, _metal.objectAt)(this, len - 1);
      this.removeAt(len - 1, 1);
      return ret;
    },

    /**
      Shift an object from start of array or nil if none are left. Works just
      like `shift()` but it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.shiftObject();  // 'red'
      console.log(colors);   // ['green', 'blue']
      ```
       @method shiftObject
      @return object
      @public
    */
    shiftObject() {
      if (this.length === 0) {
        return null;
      }

      var ret = (0, _metal.objectAt)(this, 0);
      this.removeAt(0);
      return ret;
    },

    /**
      Unshift an object to start of array. Works just like `unshift()` but it is
      KVO-compliant.
       ```javascript
      let colors = ['red'];
       colors.unshiftObject('yellow');    // ['yellow', 'red']
      colors.unshiftObject(['black']);   // [['black'], 'yellow', 'red']
      ```
       @method unshiftObject
      @param {*} obj object to unshift
      @return object same object passed as a param
      @public
    */
    unshiftObject(obj) {
      return insertAt(this, 0, obj);
    },

    /**
      Adds the named objects to the beginning of the array. Defers notifying
      observers until all objects have been added.
       ```javascript
      let colors = ['red'];
       colors.unshiftObjects(['black', 'white']);   // ['black', 'white', 'red']
      colors.unshiftObjects('yellow'); // Type Error: 'undefined' is not a function
      ```
       @method unshiftObjects
      @param {Enumberable} objects the objects to add
      @return {EmberArray} receiver
      @public
    */
    unshiftObjects(objects) {
      this.replace(0, 0, objects);
      return this;
    },

    /**
      Reverse objects in the array. Works just like `reverse()` but it is
      KVO-compliant.
       @method reverseObjects
      @return {EmberArray} receiver
       @public
    */
    reverseObjects() {
      var len = this.length;

      if (len === 0) {
        return this;
      }

      var objects = this.toArray().reverse();
      this.replace(0, len, objects);
      return this;
    },

    /**
      Replace all the receiver's content with content of the argument.
      If argument is an empty array receiver will be cleared.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.setObjects(['black', 'white']);  // ['black', 'white']
      colors.setObjects([]);                  // []
      ```
       @method setObjects
      @param {EmberArray} objects array whose content will be used for replacing
          the content of the receiver
      @return {EmberArray} receiver with the new content
      @public
    */
    setObjects(objects) {
      if (objects.length === 0) {
        return this.clear();
      }

      var len = this.length;
      this.replace(0, len, objects);
      return this;
    },

    /**
      Remove all occurrences of an object in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin', 'Lima', 'Chicago'];
       cities.removeObject('Chicago');  // ['Berlin', 'Lima']
      cities.removeObject('Lima');     // ['Berlin']
      cities.removeObject('Tokyo')     // ['Berlin']
      ```
       @method removeObject
      @param {*} obj object to remove
      @return {EmberArray} receiver
      @public
    */
    removeObject(obj) {
      var loc = this.length || 0;

      while (--loc >= 0) {
        var curObject = (0, _metal.objectAt)(this, loc);

        if (curObject === obj) {
          this.removeAt(loc);
        }
      }

      return this;
    },

    /**
      Removes each object in the passed array from the receiver.
       @method removeObjects
      @param {EmberArray} objects the objects to remove
      @return {EmberArray} receiver
      @public
    */
    removeObjects(objects) {
      (0, _metal.beginPropertyChanges)();

      for (var i = objects.length - 1; i >= 0; i--) {
        this.removeObject(objects[i]);
      }

      (0, _metal.endPropertyChanges)();
      return this;
    },

    /**
      Push the object onto the end of the array if it is not already
      present in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin'];
       cities.addObject('Lima');    // ['Chicago', 'Berlin', 'Lima']
      cities.addObject('Berlin');  // ['Chicago', 'Berlin', 'Lima']
      ```
       @method addObject
      @param {*} obj object to add, if not already present
      @return {EmberArray} receiver
      @public
    */
    addObject(obj) {
      var included = this.includes(obj);

      if (!included) {
        this.pushObject(obj);
      }

      return this;
    },

    /**
      Adds each object in the passed array to the receiver.
       @method addObjects
      @param {EmberArray} objects the objects to add.
      @return {EmberArray} receiver
      @public
    */
    addObjects(objects) {
      (0, _metal.beginPropertyChanges)();
      objects.forEach(obj => this.addObject(obj));
      (0, _metal.endPropertyChanges)();
      return this;
    }

  });
  /**
    Creates an `Ember.NativeArray` from an Array-like object.
    Does not modify the original object's contents. `A()` is not needed if
    `EmberENV.EXTEND_PROTOTYPES` is `true` (the default value). However,
    it is recommended that you use `A()` when creating addons for
    ember or when you can not guarantee that `EmberENV.EXTEND_PROTOTYPES`
    will be `true`.
  
    Example
  
    ```app/components/my-component.js
    import Component from '@ember/component';
    import { A } from '@ember/array';
  
    export default Component.extend({
      tagName: 'ul',
      classNames: ['pagination'],
  
      init() {
        this._super(...arguments);
  
        if (!this.get('content')) {
          this.set('content', A());
          this.set('otherContent', A([1,2,3]));
        }
      }
    });
    ```
  
    @method A
    @static
    @for @ember/array
    @return {Ember.NativeArray}
    @public
  */
  // Add Ember.Array to Array.prototype. Remove methods with native
  // implementations and supply some more optimized versions of generic methods
  // because they are so common.

  /**
  @module ember
  */

  /**
    The NativeArray mixin contains the properties needed to make the native
    Array support MutableArray and all of its dependent APIs. Unless you
    have `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Array` set to
    false, this will be applied automatically. Otherwise you can apply the mixin
    at anytime by calling `Ember.NativeArray.apply(Array.prototype)`.
  
    @class Ember.NativeArray
    @uses MutableArray
    @uses Observable
    @public
  */


  _exports.MutableArray = MutableArray;

  var NativeArray = _metal.Mixin.create(MutableArray, _observable.default, {
    objectAt(idx) {
      return this[idx];
    },

    // primitive for array support.
    replace(start, deleteCount, items = EMPTY_ARRAY) {
      (true && !(Array.isArray(items)) && (0, _debug.assert)('The third argument to replace needs to be an array.', Array.isArray(items)));
      (0, _metal.replaceInNativeArray)(this, start, deleteCount, items);
      return this;
    }

  }); // Remove any methods implemented natively so we don't override them


  _exports.NativeArray = NativeArray;
  var ignore = ['length'];
  NativeArray.keys().forEach(methodName => {
    if (Array.prototype[methodName]) {
      ignore.push(methodName);
    }
  });
  _exports.NativeArray = NativeArray = NativeArray.without(...ignore);
  var A;
  _exports.A = A;

  if (_environment.ENV.EXTEND_PROTOTYPES.Array) {
    NativeArray.apply(Array.prototype);

    _exports.A = A = function (arr) {
      (true && !(!(this instanceof A)) && (0, _debug.assert)('You cannot create an Ember Array with `new A()`, please update to calling A as a function: `A()`', !(this instanceof A)));
      return arr || [];
    };
  } else {
    _exports.A = A = function (arr) {
      (true && !(!(this instanceof A)) && (0, _debug.assert)('You cannot create an Ember Array with `new A()`, please update to calling A as a function: `A()`', !(this instanceof A)));

      if (!arr) {
        arr = [];
      }

      return ArrayMixin.detect(arr) ? arr : NativeArray.apply(arr);
    };
  }

  var _default = ArrayMixin;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/comparable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    Implements some standard methods for comparing objects. Add this mixin to
    any class you create that can compare its instances.
  
    You should implement the `compare()` method.
  
    @class Comparable
    @namespace Ember
    @since Ember 0.9
    @private
  */
  var _default = _metal.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return the result of the comparison of the two parameters. The
      compare method should return:
       - `-1` if `a < b`
      - `0` if `a == b`
      - `1` if `a > b`
       Default implementation raises an exception.
       @method compare
      @param a {Object} the first object to compare
      @param b {Object} the second object to compare
      @return {Number} the result of the comparison
      @private
    */
    compare: null
  });

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/container_proxy", ["exports", "@ember/runloop", "@ember/-internals/metal"], function (_exports, _runloop, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    ContainerProxyMixin is used to provide public access to specific
    container functionality.
  
    @class ContainerProxyMixin
    @private
  */
  var containerProxyMixin = {
    /**
     The container stores state.
      @private
     @property {Ember.Container} __container__
     */
    __container__: null,

    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      Example:
      ```
     import { getOwner } from '@ember/application';
      let owner = getOwner(this);
      User.create(
       owner.ownerInjection(),
       { username: 'rwjblue' }
     )
     ```
      @public
     @method ownerInjection
     @since 2.3.0
     @return {Object}
    */
    ownerInjection() {
      return this.__container__.ownerInjection();
    },

    /**
     Given a fullName return a corresponding instance.
      The default behavior is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @public
     @method lookup
     @param {String} fullName
     @param {Object} options
     @return {any}
     */
    lookup(fullName, options) {
      return this.__container__.lookup(fullName, options);
    },

    destroy() {
      var container = this.__container__;

      if (container) {
        (0, _runloop.join)(() => {
          container.destroy();
          (0, _runloop.schedule)('destroy', container, 'finalizeDestroy');
        });
      }

      this._super();
    },

    /**
    Given a fullName return a factory manager.
     This method returns a manager which can be used for introspection of the
    factory's class or for the creation of factory instances with initial
    properties. The manager is an object with the following properties:
     * `class` - The registered or resolved class.
    * `create` - A function that will create an instance of the class with
      any dependencies injected.
     For example:
     ```javascript
    import { getOwner } from '@ember/application';
     let owner = getOwner(otherInstance);
    // the owner is commonly the `applicationInstance`, and can be accessed via
    // an instance initializer.
     let factory = owner.factoryFor('service:bespoke');
     factory.class;
    // The registered or resolved class. For example when used with an Ember-CLI
    // app, this would be the default export from `app/services/bespoke.js`.
     let instance = factory.create({
      someProperty: 'an initial property value'
    });
    // Create an instance with any injections and the passed options as
    // initial properties.
    ```
     Any instances created via the factory's `.create()` method *must* be destroyed
    manually by the caller of `.create()`. Typically, this is done during the creating
    objects own `destroy` or `willDestroy` methods.
     @public
    @method factoryFor
    @param {String} fullName
    @param {Object} options
    @return {FactoryManager}
    */
    factoryFor(fullName, options = {}) {
      return this.__container__.factoryFor(fullName, options);
    }

  };

  var _default = _metal.Mixin.create(containerProxyMixin);

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/copyable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    Implements some standard methods for copying an object. Add this mixin to
    any object you create that can create a copy of itself. This mixin is
    added automatically to the built-in array.
  
    You should generally implement the `copy()` method to return a copy of the
    receiver.
  
    @class Copyable
    @namespace Ember
    @since Ember 0.9
    @deprecated Use 'ember-copy' addon instead
    @private
  */
  var _default = _metal.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return a copy of the receiver. Default implementation raises
      an exception.
       @method copy
      @param {Boolean} deep if `true`, a deep copy of the object should be made
      @return {Object} copy of receiver
      @private
    */
    copy: null
  });

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/enumerable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/enumerable
  @private
  */

  /**
    The methods in this mixin have been moved to [MutableArray](/ember/release/classes/MutableArray). This mixin has
    been intentionally preserved to avoid breaking Enumerable.detect checks
    until the community migrates away from them.
  
    @class Enumerable
    @private
  */
  var _default = _metal.Mixin.create();

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/evented", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/object
  */

  /**
    This mixin allows for Ember objects to subscribe to and emit events.
  
    ```app/utils/person.js
    import EmberObject from '@ember/object';
    import Evented from '@ember/object/evented';
  
    export default EmberObject.extend(Evented, {
      greet() {
        // ...
        this.trigger('greet');
      }
    });
    ```
  
    ```javascript
    var person = Person.create();
  
    person.on('greet', function() {
      console.log('Our person has greeted');
    });
  
    person.greet();
  
    // outputs: 'Our person has greeted'
    ```
  
    You can also chain multiple event subscriptions:
  
    ```javascript
    person.on('greet', function() {
      console.log('Our person has greeted');
    }).one('greet', function() {
      console.log('Offer one-time special');
    }).off('event', this, forgetThis);
    ```
  
    @class Evented
    @public
   */
  var _default = _metal.Mixin.create({
    /**
      Subscribes to a named event with given function.
       ```javascript
      person.on('didLoad', function() {
        // fired once the person has loaded
      });
      ```
       An optional target can be passed in as the 2nd argument that will
      be set as the "this" for the callback. This is a good way to give your
      function access to the object triggering the event. When the target
      parameter is used the callback method becomes the third argument.
       @method on
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function|String} method A function or the name of a function to be called on `target`
      @return this
      @public
    */
    on(name, target, method) {
      (0, _metal.addListener)(this, name, target, method);
      return this;
    },

    /**
      Subscribes a function to a named event and then cancels the subscription
      after the first time the event is triggered. It is good to use ``one`` when
      you only care about the first time an event has taken place.
       This function takes an optional 2nd argument that will become the "this"
      value for the callback. When the target parameter is used the callback method
      becomes the third argument.
       @method one
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function|String} method A function or the name of a function to be called on `target`
      @return this
      @public
    */
    one(name, target, method) {
      (0, _metal.addListener)(this, name, target, method, true);
      return this;
    },

    /**
      Triggers a named event for the object. Any additional arguments
      will be passed as parameters to the functions that are subscribed to the
      event.
       ```javascript
      person.on('didEat', function(food) {
        console.log('person ate some ' + food);
      });
       person.trigger('didEat', 'broccoli');
       // outputs: person ate some broccoli
      ```
      @method trigger
      @param {String} name The name of the event
      @param {Object...} args Optional arguments to pass on
      @public
    */
    trigger(name, ...args) {
      (0, _metal.sendEvent)(this, name, args);
    },

    /**
      Cancels subscription for given name, target, and method.
       @method off
      @param {String} name The name of the event
      @param {Object} target The target of the subscription
      @param {Function|String} method The function or the name of a function of the subscription
      @return this
      @public
    */
    off(name, target, method) {
      (0, _metal.removeListener)(this, name, target, method);
      return this;
    },

    /**
      Checks to see if object has any subscriptions for named event.
       @method has
      @param {String} name The name of the event
      @return {Boolean} does the object have a subscription for event
      @public
     */
    has(name) {
      return (0, _metal.hasListeners)(this, name);
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/mutable_enumerable", ["exports", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/metal"], function (_exports, _enumerable, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    The methods in this mixin have been moved to MutableArray. This mixin has
    been intentionally preserved to avoid breaking MutableEnumerable.detect
    checks until the community migrates away from them.
  
    @class MutableEnumerable
    @namespace Ember
    @uses Enumerable
    @private
  */
  var _default = _metal.Mixin.create(_enumerable.default);

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/observable", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/object
  */

  /**
    ## Overview
  
    This mixin provides properties and property observing functionality, core
    features of the Ember object model.
  
    Properties and observers allow one object to observe changes to a
    property on another object. This is one of the fundamental ways that
    models, controllers and views communicate with each other in an Ember
    application.
  
    Any object that has this mixin applied can be used in observer
    operations. That includes `EmberObject` and most objects you will
    interact with as you write your Ember application.
  
    Note that you will not generally apply this mixin to classes yourself,
    but you will use the features provided by this module frequently, so it
    is important to understand how to use it.
  
    ## Using `get()` and `set()`
  
    Because of Ember's support for bindings and observers, you will always
    access properties using the get method, and set properties using the
    set method. This allows the observing objects to be notified and
    computed properties to be handled properly.
  
    More documentation about `get` and `set` are below.
  
    ## Observing Property Changes
  
    You typically observe property changes simply by using the `observer`
    function in classes that you write.
  
    For example:
  
    ```javascript
    import { observer } from '@ember/object';
    import EmberObject from '@ember/object';
  
    EmberObject.extend({
      valueObserver: observer('value', function(sender, key, value, rev) {
        // Executes whenever the "value" property changes
        // See the addObserver method for more information about the callback arguments
      })
    });
    ```
  
    Although this is the most common way to add an observer, this capability
    is actually built into the `EmberObject` class on top of two methods
    defined in this mixin: `addObserver` and `removeObserver`. You can use
    these two methods to add and remove observers yourself if you need to
    do so at runtime.
  
    To add an observer for a property, call:
  
    ```javascript
    object.addObserver('propertyKey', targetObject, targetAction)
    ```
  
    This will call the `targetAction` method on the `targetObject` whenever
    the value of the `propertyKey` changes.
  
    Note that if `propertyKey` is a computed property, the observer will be
    called when any of the property dependencies are changed, even if the
    resulting value of the computed property is unchanged. This is necessary
    because computed properties are not computed until `get` is called.
  
    @class Observable
    @public
  */
  var _default = _metal.Mixin.create({
    /**
      Retrieves the value of a property from the object.
       This method is usually similar to using `object[keyName]` or `object.keyName`,
      however it supports both computed properties and the unknownProperty
      handler.
       Because `get` unifies the syntax for accessing all these kinds
      of properties, it can make many refactorings easier, such as replacing a
      simple property with a computed property, or vice versa.
       ### Computed Properties
       Computed properties are methods defined with the `property` modifier
      declared at the end, such as:
       ```javascript
      import { computed } from '@ember/object';
       fullName: computed('firstName', 'lastName', function() {
        return this.get('firstName') + ' ' + this.get('lastName');
      })
      ```
       When you call `get` on a computed property, the function will be
      called and the return value will be returned instead of the function
      itself.
       ### Unknown Properties
       Likewise, if you try to call `get` on a property whose value is
      `undefined`, the `unknownProperty()` method will be called on the object.
      If this method returns any value other than `undefined`, it will be returned
      instead. This allows you to implement "virtual" properties that are
      not defined upfront.
       @method get
      @param {String} keyName The property to retrieve
      @return {Object} The property value or undefined.
      @public
    */
    get(keyName) {
      return (0, _metal.get)(this, keyName);
    },

    /**
      To get the values of multiple properties at once, call `getProperties`
      with a list of strings or an array:
       ```javascript
      record.getProperties('firstName', 'lastName', 'zipCode');
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       is equivalent to:
       ```javascript
      record.getProperties(['firstName', 'lastName', 'zipCode']);
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       @method getProperties
      @param {String...|Array} list of keys to get
      @return {Object}
      @public
    */
    getProperties(...args) {
      return (0, _metal.getProperties)(...[this].concat(args));
    },

    /**
      Sets the provided key or path to the value.
       ```javascript
      record.set("key", value);
      ```
       This method is generally very similar to calling `object["key"] = value` or
      `object.key = value`, except that it provides support for computed
      properties, the `setUnknownProperty()` method and property observers.
       ### Computed Properties
       If you try to set a value on a key that has a computed property handler
      defined (see the `get()` method for an example), then `set()` will call
      that method, passing both the value and key instead of simply changing
      the value itself. This is useful for those times when you need to
      implement a property that is composed of one or more member
      properties.
       ### Unknown Properties
       If you try to set a value on a key that is undefined in the target
      object, then the `setUnknownProperty()` handler will be called instead. This
      gives you an opportunity to implement complex "virtual" properties that
      are not predefined on the object. If `setUnknownProperty()` returns
      undefined, then `set()` will simply set the value on the object.
       ### Property Observers
       In addition to changing the property, `set()` will also register a property
      change with the object. Unless you have placed this call inside of a
      `beginPropertyChanges()` and `endPropertyChanges(),` any "local" observers
      (i.e. observer methods declared on the same object), will be called
      immediately. Any "remote" observers (i.e. observer methods declared on
      another object) will be placed in a queue and called at a later time in a
      coalesced manner.
       @method set
      @param {String} keyName The property to set
      @param {Object} value The value to set or `null`.
      @return {Object} The passed value
      @public
    */
    set(keyName, value) {
      return (0, _metal.set)(this, keyName, value);
    },

    /**
      Sets a list of properties at once. These properties are set inside
      a single `beginPropertyChanges` and `endPropertyChanges` batch, so
      observers will be buffered.
       ```javascript
      record.setProperties({ firstName: 'Charles', lastName: 'Jolley' });
      ```
       @method setProperties
      @param {Object} hash the hash of keys and values to set
      @return {Object} The passed in hash
      @public
    */
    setProperties(hash) {
      return (0, _metal.setProperties)(this, hash);
    },

    /**
      Begins a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call this
      method at the beginning of the changes to begin deferring change
      notifications. When you are done making changes, call
      `endPropertyChanges()` to deliver the deferred change notifications and end
      deferring.
       @method beginPropertyChanges
      @return {Observable}
      @private
    */
    beginPropertyChanges() {
      (0, _metal.beginPropertyChanges)();
      return this;
    },

    /**
      Ends a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call
      `beginPropertyChanges()` at the beginning of the changes to defer change
      notifications. When you are done making changes, call this method to
      deliver the deferred change notifications and end deferring.
       @method endPropertyChanges
      @return {Observable}
      @private
    */
    endPropertyChanges() {
      (0, _metal.endPropertyChanges)();
      return this;
    },

    /**
      Notify the observer system that a property has just changed.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method instead. Calling this method will notify all observers that the
      property has potentially changed value.
       @method notifyPropertyChange
      @param {String} keyName The property key to be notified about.
      @return {Observable}
      @public
    */
    notifyPropertyChange(keyName) {
      (0, _metal.notifyPropertyChange)(this, keyName);
      return this;
    },

    /**
      Adds an observer on a property.
       This is the core method used to register an observer for a property.
       Once you call this method, any time the key's value is set, your observer
      will be notified. Note that the observers are triggered any time the
      value is set, regardless of whether it has actually changed. Your
      observer should be prepared to handle that.
       There are two common invocation patterns for `.addObserver()`:
       - Passing two arguments:
        - the name of the property to observe (as a string)
        - the function to invoke (an actual function)
      - Passing three arguments:
        - the name of the property to observe (as a string)
        - the target object (will be used to look up and invoke a
          function on)
        - the name of the function to invoke on the target object
          (as a string).
       ```app/components/my-component.js
      import Component from '@ember/component';
       export default Component.extend({
        init() {
          this._super(...arguments);
           // the following are equivalent:
           // using three arguments
          this.addObserver('foo', this, 'fooDidChange');
           // using two arguments
          this.addObserver('foo', (...args) => {
            this.fooDidChange(...args);
          });
        },
         fooDidChange() {
          // your custom logic code
        }
      });
      ```
       ### Observer Methods
       Observer methods have the following signature:
       ```app/components/my-component.js
      import Component from '@ember/component';
       export default Component.extend({
        init() {
          this._super(...arguments);
          this.addObserver('foo', this, 'fooDidChange');
        },
         fooDidChange(sender, key, value, rev) {
          // your code
        }
      });
      ```
       The `sender` is the object that changed. The `key` is the property that
      changes. The `value` property is currently reserved and unused. The `rev`
      is the last property revision of the object when it changed, which you can
      use to detect if the key value has really changed or not.
       Usually you will not need the value or revision parameters at
      the end. In this case, it is common to write observer methods that take
      only a sender and key value as parameters or, if you aren't interested in
      any of these values, to write an observer that has no parameters at all.
       @method addObserver
      @param {String} key The key to observe
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke
      @param {Boolean} async Whether the observer is async or not
      @return {Observable}
      @public
    */
    addObserver(key, target, method, async) {
      (0, _metal.addObserver)(this, key, target, method, async);
      return this;
    },

    /**
      Remove an observer you have previously registered on this object. Pass
      the same key, target, and method you passed to `addObserver()` and your
      target will no longer receive notifications.
       @method removeObserver
      @param {String} key The key to observe
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke
      @param {Boolean} async Whether the observer is async or not
      @return {Observable}
      @public
    */
    removeObserver(key, target, method, async) {
      (0, _metal.removeObserver)(this, key, target, method, async);
      return this;
    },

    /**
      Returns `true` if the object currently has observers registered for a
      particular key. You can use this method to potentially defer performing
      an expensive action until someone begins observing a particular property
      on the object.
       @method hasObserverFor
      @param {String} key Key to check
      @return {Boolean}
      @private
    */
    hasObserverFor(key) {
      return (0, _metal.hasListeners)(this, key + ":change");
    },

    /**
      Retrieves the value of a property, or a default value in the case that the
      property returns `undefined`.
       ```javascript
      person.getWithDefault('lastName', 'Doe');
      ```
       @method getWithDefault
      @param {String} keyName The name of the property to retrieve
      @param {Object} defaultValue The value to return if the property value is undefined
      @return {Object} The property value or the defaultValue.
      @public
    */
    getWithDefault(keyName, defaultValue) {
      return (0, _metal.getWithDefault)(this, keyName, defaultValue);
    },

    /**
      Set the value of a property to the current value plus some amount.
       ```javascript
      person.incrementProperty('age');
      team.incrementProperty('score', 2);
      ```
       @method incrementProperty
      @param {String} keyName The name of the property to increment
      @param {Number} increment The amount to increment by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    incrementProperty(keyName, increment = 1) {
      (true && !(!isNaN(parseFloat(increment)) && isFinite(increment)) && (0, _debug.assert)('Must pass a numeric value to incrementProperty', !isNaN(parseFloat(increment)) && isFinite(increment)));
      return (0, _metal.set)(this, keyName, (parseFloat((0, _metal.get)(this, keyName)) || 0) + increment);
    },

    /**
      Set the value of a property to the current value minus some amount.
       ```javascript
      player.decrementProperty('lives');
      orc.decrementProperty('health', 5);
      ```
       @method decrementProperty
      @param {String} keyName The name of the property to decrement
      @param {Number} decrement The amount to decrement by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    decrementProperty(keyName, decrement = 1) {
      (true && !(!isNaN(parseFloat(decrement)) && isFinite(decrement)) && (0, _debug.assert)('Must pass a numeric value to decrementProperty', !isNaN(parseFloat(decrement)) && isFinite(decrement)));
      return (0, _metal.set)(this, keyName, ((0, _metal.get)(this, keyName) || 0) - decrement);
    },

    /**
      Set the value of a boolean property to the opposite of its
      current value.
       ```javascript
      starship.toggleProperty('warpDriveEngaged');
      ```
       @method toggleProperty
      @param {String} keyName The name of the property to toggle
      @return {Boolean} The new property value
      @public
    */
    toggleProperty(keyName) {
      return (0, _metal.set)(this, keyName, !(0, _metal.get)(this, keyName));
    },

    /**
      Returns the cached value of a computed property, if it exists.
      This allows you to inspect the value of a computed property
      without accidentally invoking it if it is intended to be
      generated lazily.
       @method cacheFor
      @param {String} keyName
      @return {Object} The cached value of the computed property, if any
      @public
    */
    cacheFor(keyName) {
      return (0, _metal.getCachedValueFor)(this, keyName);
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/promise_proxy", ["exports", "@ember/-internals/metal", "@ember/error"], function (_exports, _metal, _error) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
    @module @ember/object
  */
  function tap(proxy, promise) {
    (0, _metal.setProperties)(proxy, {
      isFulfilled: false,
      isRejected: false
    });
    return promise.then(value => {
      if (!proxy.isDestroyed && !proxy.isDestroying) {
        (0, _metal.setProperties)(proxy, {
          content: value,
          isFulfilled: true
        });
      }

      return value;
    }, reason => {
      if (!proxy.isDestroyed && !proxy.isDestroying) {
        (0, _metal.setProperties)(proxy, {
          reason,
          isRejected: true
        });
      }

      throw reason;
    }, 'Ember: PromiseProxy');
  }
  /**
    A low level mixin making ObjectProxy promise-aware.
  
    ```javascript
    import { resolve } from 'rsvp';
    import $ from 'jquery';
    import ObjectProxy from '@ember/object/proxy';
    import PromiseProxyMixin from '@ember/object/promise-proxy-mixin';
  
    let ObjectPromiseProxy = ObjectProxy.extend(PromiseProxyMixin);
  
    let proxy = ObjectPromiseProxy.create({
      promise: resolve($.getJSON('/some/remote/data.json'))
    });
  
    proxy.then(function(json){
       // the json
    }, function(reason) {
       // the reason why you have no json
    });
    ```
  
    the proxy has bindable attributes which
    track the promises life cycle
  
    ```javascript
    proxy.get('isPending')   //=> true
    proxy.get('isSettled')  //=> false
    proxy.get('isRejected')  //=> false
    proxy.get('isFulfilled') //=> false
    ```
  
    When the $.getJSON completes, and the promise is fulfilled
    with json, the life cycle attributes will update accordingly.
    Note that $.getJSON doesn't return an ECMA specified promise,
    it is useful to wrap this with an `RSVP.resolve` so that it behaves
    as a spec compliant promise.
  
    ```javascript
    proxy.get('isPending')   //=> false
    proxy.get('isSettled')   //=> true
    proxy.get('isRejected')  //=> false
    proxy.get('isFulfilled') //=> true
    ```
  
    As the proxy is an ObjectProxy, and the json now its content,
    all the json properties will be available directly from the proxy.
  
    ```javascript
    // Assuming the following json:
    {
      firstName: 'Stefan',
      lastName: 'Penner'
    }
  
    // both properties will accessible on the proxy
    proxy.get('firstName') //=> 'Stefan'
    proxy.get('lastName')  //=> 'Penner'
    ```
  
    @class PromiseProxyMixin
    @public
  */


  var _default = _metal.Mixin.create({
    /**
      If the proxied promise is rejected this will contain the reason
      provided.
       @property reason
      @default null
      @public
    */
    reason: null,

    /**
      Once the proxied promise has settled this will become `false`.
       @property isPending
      @default true
      @public
    */
    isPending: (0, _metal.computed)('isSettled', function () {
      return !(0, _metal.get)(this, 'isSettled');
    }).readOnly(),

    /**
      Once the proxied promise has settled this will become `true`.
       @property isSettled
      @default false
      @public
    */
    isSettled: (0, _metal.computed)('isRejected', 'isFulfilled', function () {
      return (0, _metal.get)(this, 'isRejected') || (0, _metal.get)(this, 'isFulfilled');
    }).readOnly(),

    /**
      Will become `true` if the proxied promise is rejected.
       @property isRejected
      @default false
      @public
    */
    isRejected: false,

    /**
      Will become `true` if the proxied promise is fulfilled.
       @property isFulfilled
      @default false
      @public
    */
    isFulfilled: false,

    /**
      The promise whose fulfillment value is being proxied by this object.
       This property must be specified upon creation, and should not be
      changed once created.
       Example:
       ```javascript
      import ObjectProxy from '@ember/object/proxy';
      import PromiseProxyMixin from '@ember/object/promise-proxy-mixin';
       ObjectProxy.extend(PromiseProxyMixin).create({
        promise: <thenable>
      });
      ```
       @property promise
      @public
    */
    promise: (0, _metal.computed)({
      get() {
        throw new _error.default("PromiseProxy's promise must be set");
      },

      set(key, promise) {
        return tap(this, promise);
      }

    }),

    /**
      An alias to the proxied promise's `then`.
       See RSVP.Promise.then.
       @method then
      @param {Function} callback
      @return {RSVP.Promise}
      @public
    */
    then: promiseAlias('then'),

    /**
      An alias to the proxied promise's `catch`.
       See RSVP.Promise.catch.
       @method catch
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
      @public
    */
    catch: promiseAlias('catch'),

    /**
      An alias to the proxied promise's `finally`.
       See RSVP.Promise.finally.
       @method finally
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
      @public
    */
    finally: promiseAlias('finally')
  });

  _exports.default = _default;

  function promiseAlias(name) {
    return function () {
      var promise = (0, _metal.get)(this, 'promise');
      return promise[name](...arguments);
    };
  }
});
define("@ember/-internals/runtime/lib/mixins/registry_proxy", ["exports", "@ember/debug", "@ember/-internals/metal"], function (_exports, _debug, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
    RegistryProxyMixin is used to provide public access to specific
    registry functionality.
  
    @class RegistryProxyMixin
    @private
  */
  var _default = _metal.Mixin.create({
    __registry__: null,

    /**
     Given a fullName return the corresponding factory.
      @public
     @method resolveRegistration
     @param {String} fullName
     @return {Function} fullName's factory
     */
    resolveRegistration(fullName, options) {
      (true && !(this.__registry__.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.__registry__.isValidFullName(fullName)));
      return this.__registry__.resolve(fullName, options);
    },

    /**
      Registers a factory that can be used for dependency injection (with
      `inject`) or for service lookup. Each factory is registered with
      a full name including two parts: `type:name`.
       A simple example:
       ```javascript
      import Application from '@ember/application';
      import EmberObject from '@ember/object';
       let App = Application.create();
       App.Orange = EmberObject.extend();
      App.register('fruit:favorite', App.Orange);
      ```
       Ember will resolve factories from the `App` namespace automatically.
      For example `App.CarsController` will be discovered and returned if
      an application requests `controller:cars`.
       An example of registering a controller with a non-standard name:
       ```javascript
      import Application from '@ember/application';
      import Controller from '@ember/controller';
       let App = Application.create();
      let Session = Controller.extend();
       App.register('controller:session', Session);
       // The Session controller can now be treated like a normal controller,
      // despite its non-standard name.
      App.ApplicationController = Controller.extend({
        needs: ['session']
      });
      ```
       Registered factories are **instantiated** by having `create`
      called on them. Additionally they are **singletons**, each time
      they are looked up they return the same instance.
       Some examples modifying that default behavior:
       ```javascript
      import Application from '@ember/application';
      import EmberObject from '@ember/object';
       let App = Application.create();
       App.Person = EmberObject.extend();
      App.Orange = EmberObject.extend();
      App.Email = EmberObject.extend();
      App.session = EmberObject.create();
       App.register('model:user', App.Person, { singleton: false });
      App.register('fruit:favorite', App.Orange);
      App.register('communication:main', App.Email, { singleton: false });
      App.register('session', App.session, { instantiate: false });
      ```
       @method register
      @param  fullName {String} type:name (e.g., 'model:user')
      @param  factory {any} (e.g., App.Person)
      @param  options {Object} (optional) disable instantiation or singleton usage
      @public
     */
    register: registryAlias('register'),

    /**
     Unregister a factory.
      ```javascript
     import Application from '@ember/application';
     import EmberObject from '@ember/object';
      let App = Application.create();
     let User = EmberObject.extend();
     App.register('model:user', User);
      App.resolveRegistration('model:user').create() instanceof User //=> true
      App.unregister('model:user')
     App.resolveRegistration('model:user') === undefined //=> true
     ```
      @public
     @method unregister
     @param {String} fullName
     */
    unregister: registryAlias('unregister'),

    /**
     Check if a factory is registered.
      @public
     @method hasRegistration
     @param {String} fullName
     @return {Boolean}
     */
    hasRegistration: registryAlias('has'),

    /**
     Return a specific registered option for a particular factory.
      @public
     @method registeredOption
     @param  {String} fullName
     @param  {String} optionName
     @return {Object} options
     */
    registeredOption: registryAlias('getOption'),

    /**
     Register options for a particular factory.
      @public
     @method registerOptions
     @param {String} fullName
     @param {Object} options
     */
    registerOptions: registryAlias('options'),

    /**
     Return registered options for a particular factory.
      @public
     @method registeredOptions
     @param  {String} fullName
     @return {Object} options
     */
    registeredOptions: registryAlias('getOptions'),

    /**
     Allow registering options for all factories of a type.
      ```javascript
     import Application from '@ember/application';
      let App = Application.create();
     let appInstance = App.buildInstance();
      // if all of type `connection` must not be singletons
     appInstance.registerOptionsForType('connection', { singleton: false });
      appInstance.register('connection:twitter', TwitterConnection);
     appInstance.register('connection:facebook', FacebookConnection);
      let twitter = appInstance.lookup('connection:twitter');
     let twitter2 = appInstance.lookup('connection:twitter');
      twitter === twitter2; // => false
      let facebook = appInstance.lookup('connection:facebook');
     let facebook2 = appInstance.lookup('connection:facebook');
      facebook === facebook2; // => false
     ```
      @public
     @method registerOptionsForType
     @param {String} type
     @param {Object} options
     */
    registerOptionsForType: registryAlias('optionsForType'),

    /**
     Return the registered options for all factories of a type.
      @public
     @method registeredOptionsForType
     @param {String} type
     @return {Object} options
     */
    registeredOptionsForType: registryAlias('getOptionsForType'),

    /**
      Define a dependency injection onto a specific factory or all factories
      of a type.
       When Ember instantiates a controller, view, or other framework component
      it can attach a dependency to that component. This is often used to
      provide services to a set of framework components.
       An example of providing a session object to all controllers:
       ```javascript
      import { alias } from '@ember/object/computed';
      import Application from '@ember/application';
      import Controller from '@ember/controller';
      import EmberObject from '@ember/object';
       let App = Application.create();
      let Session = EmberObject.extend({ isAuthenticated: false });
       // A factory must be registered before it can be injected
      App.register('session:main', Session);
       // Inject 'session:main' onto all factories of the type 'controller'
      // with the name 'session'
      App.inject('controller', 'session', 'session:main');
       App.IndexController = Controller.extend({
        isLoggedIn: alias('session.isAuthenticated')
      });
      ```
       Injections can also be performed on specific factories.
       ```javascript
      App.inject(<full_name or type>, <property name>, <full_name>)
      App.inject('route', 'source', 'source:main')
      App.inject('route:application', 'email', 'model:email')
      ```
       It is important to note that injections can only be performed on
      classes that are instantiated by Ember itself. Instantiating a class
      directly (via `create` or `new`) bypasses the dependency injection
      system.
       @public
      @method inject
      @param  factoryNameOrType {String}
      @param  property {String}
      @param  injectionName {String}
    **/
    inject: registryAlias('injection')
  });

  _exports.default = _default;

  function registryAlias(name) {
    return function () {
      return this.__registry__[name](...arguments);
    };
  }
});
define("@ember/-internals/runtime/lib/mixins/target_action_support", ["exports", "@ember/-internals/environment", "@ember/-internals/metal", "@ember/debug"], function (_exports, _environment, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */

  /**
  `Ember.TargetActionSupport` is a mixin that can be included in a class
  to add a `triggerAction` method with semantics similar to the Handlebars
  `{{action}}` helper. In normal Ember usage, the `{{action}}` helper is
  usually the best choice. This mixin is most often useful when you are
  doing more complex event handling in Components.
  
  @class TargetActionSupport
  @namespace Ember
  @extends Mixin
  @private
  */
  var _default = _metal.Mixin.create({
    target: null,
    action: null,
    actionContext: null,
    actionContextObject: (0, _metal.computed)('actionContext', function () {
      var actionContext = (0, _metal.get)(this, 'actionContext');

      if (typeof actionContext === 'string') {
        var value = (0, _metal.get)(this, actionContext);

        if (value === undefined) {
          value = (0, _metal.get)(_environment.context.lookup, actionContext);
        }

        return value;
      } else {
        return actionContext;
      }
    }),

    /**
    Send an `action` with an `actionContext` to a `target`. The action, actionContext
    and target will be retrieved from properties of the object. For example:
     ```javascript
    import { alias } from '@ember/object/computed';
     App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: alias('controller'),
      action: 'save',
      actionContext: alias('context'),
      click() {
        this.triggerAction(); // Sends the `save` action, along with the current context
                              // to the current controller
      }
    });
    ```
     The `target`, `action`, and `actionContext` can be provided as properties of
    an optional object argument to `triggerAction` as well.
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      click() {
        this.triggerAction({
          action: 'save',
          target: this.get('controller'),
          actionContext: this.get('context')
        }); // Sends the `save` action, along with the current context
            // to the current controller
      }
    });
    ```
     The `actionContext` defaults to the object you are mixing `TargetActionSupport` into.
    But `target` and `action` must be specified either as properties or with the argument
    to `triggerAction`, or a combination:
     ```javascript
    import { alias } from '@ember/object/computed';
     App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: alias('controller'),
      click() {
        this.triggerAction({
          action: 'save'
        }); // Sends the `save` action, along with a reference to `this`,
            // to the current controller
      }
    });
    ```
     @method triggerAction
    @param opts {Object} (optional, with the optional keys action, target and/or actionContext)
    @return {Boolean} true if the action was sent successfully and did not return false
    @private
    */
    triggerAction(opts = {}) {
      var {
        action,
        target,
        actionContext
      } = opts;
      action = action || (0, _metal.get)(this, 'action');
      target = target || getTarget(this);

      if (actionContext === undefined) {
        actionContext = (0, _metal.get)(this, 'actionContextObject') || this;
      }

      if (target && action) {
        var ret;

        if (target.send) {
          ret = target.send(...[action].concat(actionContext));
        } else {
          (true && !(typeof target[action] === 'function') && (0, _debug.assert)("The action '" + action + "' did not exist on " + target, typeof target[action] === 'function'));
          ret = target[action](...[].concat(actionContext));
        }

        if (ret !== false) {
          return true;
        }
      }

      return false;
    }

  });

  _exports.default = _default;

  function getTarget(instance) {
    var target = (0, _metal.get)(instance, 'target');

    if (target) {
      if (typeof target === 'string') {
        var value = (0, _metal.get)(instance, target);

        if (value === undefined) {
          value = (0, _metal.get)(_environment.context.lookup, target);
        }

        return value;
      } else {
        return target;
      }
    }

    if (instance._target) {
      return instance._target;
    }

    return null;
  }
});
define("@ember/-internals/runtime/lib/system/array_proxy", ["exports", "@ember/-internals/metal", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/array", "@ember/debug", "@glimmer/reference"], function (_exports, _metal, _object, _array, _debug, _reference) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module @ember/array
  */
  var ARRAY_OBSERVER_MAPPING = {
    willChange: '_arrangedContentArrayWillChange',
    didChange: '_arrangedContentArrayDidChange'
  };
  /**
    An ArrayProxy wraps any other object that implements `Array` and/or
    `MutableArray,` forwarding all requests. This makes it very useful for
    a number of binding use cases or other cases where being able to swap
    out the underlying array is useful.
  
    A simple example of usage:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    let pets = ['dog', 'cat', 'fish'];
    let ap = ArrayProxy.create({ content: A(pets) });
  
    ap.get('firstObject');                        // 'dog'
    ap.set('content', ['amoeba', 'paramecium']);
    ap.get('firstObject');                        // 'amoeba'
    ```
  
    This class can also be useful as a layer to transform the contents of
    an array, as they are accessed. This can be done by overriding
    `objectAtContent`:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    let pets = ['dog', 'cat', 'fish'];
    let ap = ArrayProxy.create({
        content: A(pets),
        objectAtContent: function(idx) {
            return this.get('content').objectAt(idx).toUpperCase();
        }
    });
  
    ap.get('firstObject'); // . 'DOG'
    ```
  
    When overriding this class, it is important to place the call to
    `_super` *after* setting `content` so the internal observers have
    a chance to fire properly:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    export default ArrayProxy.extend({
      init() {
        this.set('content', A(['dog', 'cat', 'fish']));
        this._super(...arguments);
      }
    });
    ```
  
    @class ArrayProxy
    @extends EmberObject
    @uses MutableArray
    @public
  */

  class ArrayProxy extends _object.default {
    init() {
      super.init(...arguments);
      /*
        `this._objectsDirtyIndex` determines which indexes in the `this._objects`
        cache are dirty.
         If `this._objectsDirtyIndex === -1` then no indexes are dirty.
        Otherwise, an index `i` is dirty if `i >= this._objectsDirtyIndex`.
         Calling `objectAt` with a dirty index will cause the `this._objects`
        cache to be recomputed.
      */

      this._objectsDirtyIndex = 0;
      this._objects = null;
      this._lengthDirty = true;
      this._length = 0;
      this._arrangedContent = null;

      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          this._arrangedContentIsUpdating = false;
          this._arrangedContentTag = (0, _reference.combine)((0, _metal.getChainTagsForKey)(this, 'arrangedContent'));
          this._arrangedContentRevision = (0, _reference.value)(this._arrangedContentTag);
        }

      this._addArrangedContentArrayObsever();
    }

    willDestroy() {
      this._removeArrangedContentArrayObsever();
    }
    /**
      The content array. Must be an object that implements `Array` and/or
      `MutableArray.`
       @property content
      @type EmberArray
      @public
    */

    /**
      Should actually retrieve the object at the specified index from the
      content. You can override this method in subclasses to transform the
      content item to something new.
       This method will only be called if content is non-`null`.
       @method objectAtContent
      @param {Number} idx The index to retrieve.
      @return {Object} the value or undefined if none found
      @public
    */


    objectAtContent(idx) {
      return (0, _metal.objectAt)((0, _metal.get)(this, 'arrangedContent'), idx);
    } // See additional docs for `replace` from `MutableArray`:
    // https://api.emberjs.com/ember/release/classes/MutableArray/methods/replace?anchor=replace


    replace(idx, amt, objects) {
      (true && !((0, _metal.get)(this, 'arrangedContent') === (0, _metal.get)(this, 'content')) && (0, _debug.assert)('Mutating an arranged ArrayProxy is not allowed', (0, _metal.get)(this, 'arrangedContent') === (0, _metal.get)(this, 'content')));
      this.replaceContent(idx, amt, objects);
    }
    /**
      Should actually replace the specified objects on the content array.
      You can override this method in subclasses to transform the content item
      into something new.
       This method will only be called if content is non-`null`.
       @method replaceContent
      @param {Number} idx The starting index
      @param {Number} amt The number of items to remove from the content.
      @param {EmberArray} objects Optional array of objects to insert or null if no
        objects.
      @return {void}
      @public
    */


    replaceContent(idx, amt, objects) {
      (0, _metal.get)(this, 'content').replace(idx, amt, objects);
    } // Overriding objectAt is not supported.


    objectAt(idx) {
      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          this._revalidate();
        }

      if (this._objects === null) {
        this._objects = [];
      }

      if (this._objectsDirtyIndex !== -1 && idx >= this._objectsDirtyIndex) {
        var arrangedContent = (0, _metal.get)(this, 'arrangedContent');

        if (arrangedContent) {
          var length = this._objects.length = (0, _metal.get)(arrangedContent, 'length');

          for (var i = this._objectsDirtyIndex; i < length; i++) {
            this._objects[i] = this.objectAtContent(i);
          }
        } else {
          this._objects.length = 0;
        }

        this._objectsDirtyIndex = -1;
      }

      return this._objects[idx];
    } // Overriding length is not supported.


    get length() {
      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          this._revalidate();
        }

      if (this._lengthDirty) {
        var arrangedContent = (0, _metal.get)(this, 'arrangedContent');
        this._length = arrangedContent ? (0, _metal.get)(arrangedContent, 'length') : 0;
        this._lengthDirty = false;
      }

      return this._length;
    }

    set length(value) {
      var length = this.length;
      var removedCount = length - value;
      var added;

      if (removedCount === 0) {
        return;
      } else if (removedCount < 0) {
        added = new Array(-removedCount);
        removedCount = 0;
      }

      var content = (0, _metal.get)(this, 'content');

      if (content) {
        (0, _metal.replace)(content, value, removedCount, added);

        this._invalidate();
      }
    }

    [_metal.PROPERTY_DID_CHANGE](key) {
      if (true
      /* EMBER_METAL_TRACKED_PROPERTIES */
      ) {
          this._revalidate();
        } else {
        if (key === 'arrangedContent') {
          this._updateArrangedContentArray();
        } else if (key === 'content') {
          this._invalidate();
        }
      }
    }

    _updateArrangedContentArray() {
      var oldLength = this._objects === null ? 0 : this._objects.length;
      var arrangedContent = (0, _metal.get)(this, 'arrangedContent');
      var newLength = arrangedContent ? (0, _metal.get)(arrangedContent, 'length') : 0;

      this._removeArrangedContentArrayObsever();

      this.arrayContentWillChange(0, oldLength, newLength);

      this._invalidate();

      this.arrayContentDidChange(0, oldLength, newLength);

      this._addArrangedContentArrayObsever();
    }

    _addArrangedContentArrayObsever() {
      var arrangedContent = (0, _metal.get)(this, 'arrangedContent');

      if (arrangedContent && !arrangedContent.isDestroyed) {
        (true && !(arrangedContent !== this) && (0, _debug.assert)("Can't set ArrayProxy's content to itself", arrangedContent !== this));
        (true && !((0, _array.isArray)(arrangedContent) || arrangedContent.isDestroyed) && (0, _debug.assert)("ArrayProxy expects an Array or ArrayProxy, but you passed " + typeof arrangedContent, (0, _array.isArray)(arrangedContent) || arrangedContent.isDestroyed));
        (0, _metal.addArrayObserver)(arrangedContent, this, ARRAY_OBSERVER_MAPPING);
        this._arrangedContent = arrangedContent;
      }
    }

    _removeArrangedContentArrayObsever() {
      if (this._arrangedContent) {
        (0, _metal.removeArrayObserver)(this._arrangedContent, this, ARRAY_OBSERVER_MAPPING);
      }
    }

    _arrangedContentArrayWillChange() {}

    _arrangedContentArrayDidChange(proxy, idx, removedCnt, addedCnt) {
      this.arrayContentWillChange(idx, removedCnt, addedCnt);
      var dirtyIndex = idx;

      if (dirtyIndex < 0) {
        var length = (0, _metal.get)(this._arrangedContent, 'length');
        dirtyIndex += length + removedCnt - addedCnt;
      }

      if (this._objectsDirtyIndex === -1 || this._objectsDirtyIndex > dirtyIndex) {
        this._objectsDirtyIndex = dirtyIndex;
      }

      this._lengthDirty = true;
      this.arrayContentDidChange(idx, removedCnt, addedCnt);
    }

    _invalidate() {
      this._objectsDirtyIndex = 0;
      this._lengthDirty = true;
    }

  }

  _exports.default = ArrayProxy;

  var _revalidate;

  if (true
  /* EMBER_METAL_TRACKED_PROPERTIES */
  ) {
      _revalidate = function () {
        if (!this._arrangedContentIsUpdating && !(0, _reference.validate)(this._arrangedContentTag, this._arrangedContentRevision)) {
          this._arrangedContentIsUpdating = true;

          this._updateArrangedContentArray();

          this._arrangedContentIsUpdating = false;
          this._arrangedContentTag = (0, _reference.combine)((0, _metal.getChainTagsForKey)(this, 'arrangedContent'));
          this._arrangedContentRevision = (0, _reference.value)(this._arrangedContentTag);
        }
      };
    }

  ArrayProxy.reopen(_array.MutableArray, {
    /**
      The array that the proxy pretends to be. In the default `ArrayProxy`
      implementation, this and `content` are the same. Subclasses of `ArrayProxy`
      can override this property to provide things like sorting and filtering.
       @property arrangedContent
      @public
    */
    arrangedContent: (0, _metal.alias)('content'),
    _revalidate
  });
});
define("@ember/-internals/runtime/lib/system/core_object", ["exports", "@ember/-internals/container", "@ember/-internals/owner", "@ember/polyfills", "@ember/-internals/utils", "@ember/runloop", "@ember/-internals/meta", "@ember/-internals/metal", "@ember/-internals/runtime/lib/mixins/action_handler", "@ember/debug"], function (_exports, _container, _owner, _polyfills, _utils, _runloop, _meta2, _metal, _action_handler, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.setFrameworkClass = setFrameworkClass;
  _exports.default = void 0;

  /**
    @module @ember/object
  */
  var reopen = _metal.Mixin.prototype.reopen;
  var wasApplied = new _polyfills._WeakSet();
  var factoryMap = new WeakMap();
  var prototypeMixinMap = new WeakMap();
  var initCalled = true
  /* DEBUG */
  ? new _polyfills._WeakSet() : undefined; // only used in debug builds to enable the proxy trap

  var PASSED_FROM_CREATE = true
  /* DEBUG */
  ? (0, _utils.symbol)('PASSED_FROM_CREATE') : undefined;
  var FRAMEWORK_CLASSES = (0, _utils.symbol)('FRAMEWORK_CLASS');

  function setFrameworkClass(klass) {
    klass[FRAMEWORK_CLASSES] = true;
  }

  function initialize(obj, properties) {
    var m = (0, _meta2.meta)(obj);

    if (properties !== undefined) {
      (true && !(typeof properties === 'object' && properties !== null) && (0, _debug.assert)('EmberObject.create only accepts objects.', typeof properties === 'object' && properties !== null));
      (true && !(!(properties instanceof _metal.Mixin)) && (0, _debug.assert)('EmberObject.create no longer supports mixing in other ' + 'definitions, use .extend & .create separately instead.', !(properties instanceof _metal.Mixin)));
      var concatenatedProperties = obj.concatenatedProperties;
      var mergedProperties = obj.mergedProperties;
      var hasConcatenatedProps = concatenatedProperties !== undefined && concatenatedProperties.length > 0;
      var hasMergedProps = mergedProperties !== undefined && mergedProperties.length > 0;
      var keyNames = Object.keys(properties);

      for (var i = 0; i < keyNames.length; i++) {
        var keyName = keyNames[i];
        var value = properties[keyName];
        (true && !(!(0, _metal.isClassicDecorator)(value)) && (0, _debug.assert)('EmberObject.create no longer supports defining computed ' + 'properties. Define computed properties using extend() or reopen() ' + 'before calling create().', !(0, _metal.isClassicDecorator)(value)));
        (true && !(!(typeof value === 'function' && value.toString().indexOf('._super') !== -1)) && (0, _debug.assert)('EmberObject.create no longer supports defining methods that call _super.', !(typeof value === 'function' && value.toString().indexOf('._super') !== -1)));
        (true && !(!(keyName === 'actions' && _action_handler.default.detect(obj))) && (0, _debug.assert)('`actions` must be provided at extend time, not at create time, ' + 'when Ember.ActionHandler is used (i.e. views, controllers & routes).', !(keyName === 'actions' && _action_handler.default.detect(obj))));
        var possibleDesc = (0, _metal.descriptorForProperty)(obj, keyName, m);
        var isDescriptor = possibleDesc !== undefined;

        if (!isDescriptor) {
          var baseValue = obj[keyName];

          if (hasConcatenatedProps && concatenatedProperties.indexOf(keyName) > -1) {
            if (baseValue) {
              value = (0, _utils.makeArray)(baseValue).concat(value);
            } else {
              value = (0, _utils.makeArray)(value);
            }
          }

          if (hasMergedProps && mergedProperties.indexOf(keyName) > -1) {
            value = (0, _polyfills.assign)({}, baseValue, value);
          }
        }

        if (isDescriptor) {
          possibleDesc.set(obj, keyName, value);
        } else if (typeof obj.setUnknownProperty === 'function' && !(keyName in obj)) {
          obj.setUnknownProperty(keyName, value);
        } else {
          if (true
          /* DEBUG */
          ) {
            (0, _metal.defineProperty)(obj, keyName, null, value, m); // setup mandatory setter
          } else {
            obj[keyName] = value;
          }
        }
      }
    } // using DEBUG here to avoid the extraneous variable when not needed


    if (true
    /* DEBUG */
    ) {
      initCalled.add(obj);
    }

    obj.init(properties);
    m.unsetInitializing();

    if (true
    /* EMBER_METAL_TRACKED_PROPERTIES */
    ) {
        var observerEvents = m.observerEvents();

        if (observerEvents !== undefined) {
          for (var _i = 0; _i < observerEvents.length; _i++) {
            (0, _metal.activateObserver)(obj, observerEvents[_i].event, observerEvents[_i].sync);
          }
        }
      } else {
      // re-enable chains
      (0, _metal.finishChains)(m);
    }

    (0, _metal.sendEvent)(obj, 'init', undefined, undefined, undefined, m);
  }
  /**
    `CoreObject` is the base class for all Ember constructs. It establishes a
    class system based on Ember's Mixin system, and provides the basis for the
    Ember Object Model. `CoreObject` should generally not be used directly,
    instead you should use `EmberObject`.
  
    ## Usage
  
    You can define a class by extending from `CoreObject` using the `extend`
    method:
  
    ```js
    const Person = CoreObject.extend({
      name: 'Tomster',
    });
    ```
  
    For detailed usage, see the [Object Model](https://guides.emberjs.com/release/object-model/)
    section of the guides.
  
    ## Usage with Native Classes
  
    Native JavaScript `class` syntax can be used to extend from any `CoreObject`
    based class:
  
    ```js
    class Person extends CoreObject {
      init() {
        super.init(...arguments);
        this.name = 'Tomster';
      }
    }
    ```
  
    Some notes about `class` usage:
  
    * `new` syntax is not currently supported with classes that extend from
      `EmberObject` or `CoreObject`. You must continue to use the `create` method
      when making new instances of classes, even if they are defined using native
      class syntax. If you want to use `new` syntax, consider creating classes
      which do _not_ extend from `EmberObject` or `CoreObject`. Ember features,
      such as computed properties and decorators, will still work with base-less
      classes.
    * Instead of using `this._super()`, you must use standard `super` syntax in
      native classes. See the [MDN docs on classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes#Super_class_calls_with_super)
      for more details.
    * Native classes support using [constructors](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes#Constructor)
      to set up newly-created instances. Ember uses these to, among other things,
      support features that need to retrieve other entities by name, like Service
      injection and `getOwner`. To ensure your custom instance setup logic takes
      place after this important work is done, avoid using the `constructor` in
      favor of `init`.
    * Properties passed to `create` will be available on the instance by the time
      `init` runs, so any code that requires these values should work at that
      time.
    * Using native classes, and switching back to the old Ember Object model is
      fully supported.
  
    @class CoreObject
    @public
  */


  class CoreObject {
    static _initFactory(factory) {
      factoryMap.set(this, factory);
    }

    constructor(passedFromCreate) {
      // pluck off factory
      var initFactory = factoryMap.get(this.constructor);

      if (initFactory !== undefined) {
        factoryMap.delete(this.constructor);

        _container.FACTORY_FOR.set(this, initFactory);
      } // prepare prototype...


      this.constructor.proto();
      var self = this;

      if (true
      /* DEBUG */
      && _utils.HAS_NATIVE_PROXY && typeof self.unknownProperty === 'function') {
        var messageFor = (obj, property) => {
          return "You attempted to access the `" + String(property) + "` property (of " + obj + ").\n" + "Since Ember 3.1, this is usually fine as you no longer need to use `.get()`\n" + "to access computed properties. However, in this case, the object in question\n" + "is a special kind of Ember object (a proxy). Therefore, it is still necessary\n" + ("to use `.get('" + String(property) + "')` in this case.\n\n") + "If you encountered this error because of third-party code that you don't control,\n" + "there is more information at https://github.com/emberjs/ember.js/issues/16148, and\n" + "you can help us improve this error message by telling us more about what happened in\n" + "this situation.";
        };
        /* globals Proxy Reflect */


        self = new Proxy(this, {
          get(target, property, receiver) {
            if (property === _metal.PROXY_CONTENT) {
              return target;
            } else if ( // init called will be set on the proxy, not the target, so get with the receiver
            !initCalled.has(receiver) || typeof property === 'symbol' || (0, _utils.isInternalSymbol)(property) || property === 'toJSON' || property === 'toString' || property === 'toStringExtension' || property === 'didDefineProperty' || property === 'willWatchProperty' || property === 'didUnwatchProperty' || property === 'didAddListener' || property === 'didRemoveListener' || property === 'isDescriptor' || property === '_onLookup' || property in target) {
              return Reflect.get(target, property, receiver);
            }

            var value = target.unknownProperty.call(receiver, property);

            if (typeof value !== 'function') {
              (true && !(value === undefined || value === null) && (0, _debug.assert)(messageFor(receiver, property), value === undefined || value === null));
            }
          }

        });

        _container.FACTORY_FOR.set(self, initFactory);
      } // disable chains


      var m = (0, _meta2.meta)(self);
      m.setInitializing();
      (true && !((() => {
        if (passedFromCreate === PASSED_FROM_CREATE) {
          return true;
        }

        if (initFactory === undefined) {
          return false;
        }

        if (passedFromCreate === initFactory.owner) {
          return true;
        }

        return false;
      })()) && (0, _debug.assert)("An EmberObject based class, " + this.constructor + ", was not instantiated correctly. You may have either used `new` instead of `.create()`, or not passed arguments to your call to super in the constructor: `super(...arguments)`. If you are trying to use `new`, consider using native classes without extending from EmberObject.", (() => {
        if (passedFromCreate === PASSED_FROM_CREATE) {
          return true;
        }

        if (initFactory === undefined) {
          return false;
        }

        if (passedFromCreate === initFactory.owner) {
          return true;
        }

        return false;
      })())); // only return when in debug builds and `self` is the proxy created above

      if (true
      /* DEBUG */
      && self !== this) {
        return self;
      }
    }

    reopen(...args) {
      (0, _metal.applyMixin)(this, args);
      return this;
    }
    /**
      An overridable method called when objects are instantiated. By default,
      does nothing unless it is overridden during class definition.
       Example:
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        init() {
          alert(`Name is ${this.get('name')}`);
        }
      });
       let steve = Person.create({
        name: 'Steve'
      });
       // alerts 'Name is Steve'.
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
      @public
    */


    init() {}
    /**
      Defines the properties that will be concatenated from the superclass
      (instead of overridden).
       By default, when you extend an Ember class a property defined in
      the subclass overrides a property with the same name that is defined
      in the superclass. However, there are some cases where it is preferable
      to build up a property's value by combining the superclass' property
      value with the subclass' value. An example of this in use within Ember
      is the `classNames` property of `Ember.View`.
       Here is some sample code showing the difference between a concatenated
      property and a normal one:
       ```javascript
      import EmberObject from '@ember/object';
       const Bar = EmberObject.extend({
        // Configure which properties to concatenate
        concatenatedProperties: ['concatenatedProperty'],
         someNonConcatenatedProperty: ['bar'],
        concatenatedProperty: ['bar']
      });
       const FooBar = Bar.extend({
        someNonConcatenatedProperty: ['foo'],
        concatenatedProperty: ['foo']
      });
       let fooBar = FooBar.create();
      fooBar.get('someNonConcatenatedProperty'); // ['foo']
      fooBar.get('concatenatedProperty'); // ['bar', 'foo']
      ```
       This behavior extends to object creation as well. Continuing the
      above example:
       ```javascript
      let fooBar = FooBar.create({
        someNonConcatenatedProperty: ['baz'],
        concatenatedProperty: ['baz']
      })
      fooBar.get('someNonConcatenatedProperty'); // ['baz']
      fooBar.get('concatenatedProperty'); // ['bar', 'foo', 'baz']
      ```
       Adding a single property that is not an array will just add it in the array:
       ```javascript
      let fooBar = FooBar.create({
        concatenatedProperty: 'baz'
      })
      view.get('concatenatedProperty'); // ['bar', 'foo', 'baz']
      ```
       Using the `concatenatedProperties` property, we can tell Ember to mix the
      content of the properties.
       In `Component` the `classNames`, `classNameBindings` and
      `attributeBindings` properties are concatenated.
       This feature is available for you to use throughout the Ember object model,
      although typical app developers are likely to use it infrequently. Since
      it changes expectations about behavior of properties, you should properly
      document its usage in each individual concatenated property (to not
      mislead your users to think they can override the property in a subclass).
       @property concatenatedProperties
      @type Array
      @default null
      @public
    */

    /**
      Defines the properties that will be merged from the superclass
      (instead of overridden).
       By default, when you extend an Ember class a property defined in
      the subclass overrides a property with the same name that is defined
      in the superclass. However, there are some cases where it is preferable
      to build up a property's value by merging the superclass property value
      with the subclass property's value. An example of this in use within Ember
      is the `queryParams` property of routes.
       Here is some sample code showing the difference between a merged
      property and a normal one:
       ```javascript
      import EmberObject from '@ember/object';
       const Bar = EmberObject.extend({
        // Configure which properties are to be merged
        mergedProperties: ['mergedProperty'],
         someNonMergedProperty: {
          nonMerged: 'superclass value of nonMerged'
        },
        mergedProperty: {
          page: { replace: false },
          limit: { replace: true }
        }
      });
       const FooBar = Bar.extend({
        someNonMergedProperty: {
          completelyNonMerged: 'subclass value of nonMerged'
        },
        mergedProperty: {
          limit: { replace: false }
        }
      });
       let fooBar = FooBar.create();
       fooBar.get('someNonMergedProperty');
      // => { completelyNonMerged: 'subclass value of nonMerged' }
      //
      // Note the entire object, including the nonMerged property of
      // the superclass object, has been replaced
       fooBar.get('mergedProperty');
      // => {
      //   page: {replace: false},
      //   limit: {replace: false}
      // }
      //
      // Note the page remains from the superclass, and the
      // `limit` property's value of `false` has been merged from
      // the subclass.
      ```
       This behavior is not available during object `create` calls. It is only
      available at `extend` time.
       In `Route` the `queryParams` property is merged.
       This feature is available for you to use throughout the Ember object model,
      although typical app developers are likely to use it infrequently. Since
      it changes expectations about behavior of properties, you should properly
      document its usage in each individual merged property (to not
      mislead your users to think they can override the property in a subclass).
       @property mergedProperties
      @type Array
      @default null
      @public
    */

    /**
      Destroyed object property flag.
       if this property is `true` the observers and bindings were already
      removed by the effect of calling the `destroy()` method.
       @property isDestroyed
      @default false
      @public
    */


    get isDestroyed() {
      return (0, _meta2.peekMeta)(this).isSourceDestroyed();
    }

    set isDestroyed(value) {
      (true && !(false) && (0, _debug.assert)("You cannot set `" + this + ".isDestroyed` directly, please use `.destroy()`.", false));
    }
    /**
      Destruction scheduled flag. The `destroy()` method has been called.
       The object stays intact until the end of the run loop at which point
      the `isDestroyed` flag is set.
       @property isDestroying
      @default false
      @public
    */


    get isDestroying() {
      return (0, _meta2.peekMeta)(this).isSourceDestroying();
    }

    set isDestroying(value) {
      (true && !(false) && (0, _debug.assert)("You cannot set `" + this + ".isDestroying` directly, please use `.destroy()`.", false));
    }
    /**
      Destroys an object by setting the `isDestroyed` flag and removing its
      metadata, which effectively destroys observers and bindings.
       If you try to set a property on a destroyed object, an exception will be
      raised.
       Note that destruction is scheduled for the end of the run loop and does not
      happen immediately.  It will set an isDestroying flag immediately.
       @method destroy
      @return {EmberObject} receiver
      @public
    */


    destroy() {
      var m = (0, _meta2.peekMeta)(this);

      if (m.isSourceDestroying()) {
        return;
      }

      m.setSourceDestroying();
      (0, _runloop.schedule)('actions', this, this.willDestroy);
      (0, _runloop.schedule)('destroy', this, this._scheduledDestroy, m);
      return this;
    }
    /**
      Override to implement teardown.
       @method willDestroy
      @public
    */


    willDestroy() {}
    /**
      Invoked by the run loop to actually destroy the object. This is
      scheduled for execution by the `destroy` method.
       @private
      @method _scheduledDestroy
    */


    _scheduledDestroy(m) {
      if (m.isSourceDestroyed()) {
        return;
      }

      (0, _meta2.deleteMeta)(this);
      m.setSourceDestroyed();
    }
    /**
      Returns a string representation which attempts to provide more information
      than Javascript's `toString` typically does, in a generic way for all Ember
      objects.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend();
      person = Person.create();
      person.toString(); //=> "<Person:ember1024>"
      ```
       If the object's class is not defined on an Ember namespace, it will
      indicate it is a subclass of the registered superclass:
       ```javascript
      const Student = Person.extend();
      let student = Student.create();
      student.toString(); //=> "<(subclass of Person):ember1025>"
      ```
       If the method `toStringExtension` is defined, its return value will be
      included in the output.
       ```javascript
      const Teacher = Person.extend({
        toStringExtension() {
          return this.get('fullName');
        }
      });
      teacher = Teacher.create();
      teacher.toString(); //=> "<Teacher:ember1026:Tom Dale>"
      ```
       @method toString
      @return {String} string representation
      @public
    */


    toString() {
      var hasToStringExtension = typeof this.toStringExtension === 'function';
      var extension = hasToStringExtension ? ":" + this.toStringExtension() : '';
      var ret = "<" + ((0, _utils.getName)(this) || _container.FACTORY_FOR.get(this) || this.constructor.toString()) + ":" + (0, _utils.guidFor)(this) + extension + ">";
      return ret;
    }
    /**
      Creates a new subclass.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        say(thing) {
          alert(thing);
         }
      });
      ```
       This defines a new subclass of EmberObject: `Person`. It contains one method: `say()`.
       You can also create a subclass from any existing class by calling its `extend()` method.
      For example, you might want to create a subclass of Ember's built-in `Component` class:
       ```javascript
      import Component from '@ember/component';
       const PersonComponent = Component.extend({
        tagName: 'li',
        classNameBindings: ['isAdministrator']
      });
      ```
       When defining a subclass, you can override methods but still access the
      implementation of your parent class by calling the special `_super()` method:
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        say(thing) {
          let name = this.get('name');
          alert(`${name} says: ${thing}`);
        }
      });
       const Soldier = Person.extend({
        say(thing) {
          this._super(`${thing}, sir!`);
        },
        march(numberOfHours) {
          alert(`${this.get('name')} marches for ${numberOfHours} hours.`);
        }
      });
       let yehuda = Soldier.create({
        name: 'Yehuda Katz'
      });
       yehuda.say('Yes');  // alerts "Yehuda Katz says: Yes, sir!"
      ```
       The `create()` on line #17 creates an *instance* of the `Soldier` class.
      The `extend()` on line #8 creates a *subclass* of `Person`. Any instance
      of the `Person` class will *not* have the `march()` method.
       You can also pass `Mixin` classes to add additional properties to the subclass.
       ```javascript
      import EmberObject from '@ember/object';
      import Mixin from '@ember/object/mixin';
       const Person = EmberObject.extend({
        say(thing) {
          alert(`${this.get('name')} says: ${thing}`);
        }
      });
       const SingingMixin = Mixin.create({
        sing(thing) {
          alert(`${this.get('name')} sings: la la la ${thing}`);
        }
      });
       const BroadwayStar = Person.extend(SingingMixin, {
        dance() {
          alert(`${this.get('name')} dances: tap tap tap tap `);
        }
      });
      ```
       The `BroadwayStar` class contains three methods: `say()`, `sing()`, and `dance()`.
       @method extend
      @static
      @for @ember/object
      @param {Mixin} [mixins]* One or more Mixin classes
      @param {Object} [arguments]* Object containing values to use within the new class
      @public
    */


    static extend() {
      var Class = class extends this {};
      reopen.apply(Class.PrototypeMixin, arguments);
      return Class;
    }
    /**
      Creates an instance of a class. Accepts either no arguments, or an object
      containing values to initialize the newly instantiated object with.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        helloWorld() {
          alert(`Hi, my name is ${this.get('name')}`);
        }
      });
       let tom = Person.create({
        name: 'Tom Dale'
      });
       tom.helloWorld(); // alerts "Hi, my name is Tom Dale".
      ```
       `create` will call the `init` function if defined during
      `AnyObject.extend`
       If no arguments are passed to `create`, it will not set values to the new
      instance during initialization:
       ```javascript
      let noName = Person.create();
      noName.helloWorld(); // alerts undefined
      ```
       NOTE: For performance reasons, you cannot declare methods or computed
      properties during `create`. You should instead declare methods and computed
      properties when using `extend`.
       @method create
      @for @ember/object
      @static
      @param [arguments]*
      @public
    */


    static create(props, extra) {
      var C = this;
      var instance;

      if (this[FRAMEWORK_CLASSES]) {
        var initFactory = factoryMap.get(this);
        var owner;

        if (initFactory !== undefined) {
          owner = initFactory.owner;
        } else if (props !== undefined) {
          owner = (0, _owner.getOwner)(props);
        }

        if (owner === undefined) {
          // fallback to passing the special PASSED_FROM_CREATE symbol
          // to avoid an error when folks call things like Controller.extend().create()
          // we should do a subsequent deprecation pass to ensure this isn't allowed
          owner = PASSED_FROM_CREATE;
        }

        instance = new C(owner);
      } else {
        instance = true
        /* DEBUG */
        ? new C(PASSED_FROM_CREATE) : new C();
      }

      if (extra === undefined) {
        initialize(instance, props);
      } else {
        initialize(instance, flattenProps.apply(this, arguments));
      }

      return instance;
    }
    /**
      Augments a constructor's prototype with additional
      properties and functions:
       ```javascript
      import EmberObject from '@ember/object';
       const MyObject = EmberObject.extend({
        name: 'an object'
      });
       o = MyObject.create();
      o.get('name'); // 'an object'
       MyObject.reopen({
        say(msg) {
          console.log(msg);
        }
      });
       o2 = MyObject.create();
      o2.say('hello'); // logs "hello"
       o.say('goodbye'); // logs "goodbye"
      ```
       To add functions and properties to the constructor itself,
      see `reopenClass`
       @method reopen
      @for @ember/object
      @static
      @public
    */


    static reopen() {
      this.willReopen();
      reopen.apply(this.PrototypeMixin, arguments);
      return this;
    }

    static willReopen() {
      var p = this.prototype;

      if (wasApplied.has(p)) {
        wasApplied.delete(p); // If the base mixin already exists and was applied, create a new mixin to
        // make sure that it gets properly applied. Reusing the same mixin after
        // the first `proto` call will cause it to get skipped.

        if (prototypeMixinMap.has(this)) {
          prototypeMixinMap.set(this, _metal.Mixin.create(this.PrototypeMixin));
        }
      }
    }
    /**
      Augments a constructor's own properties and functions:
       ```javascript
      import EmberObject from '@ember/object';
       const MyObject = EmberObject.extend({
        name: 'an object'
      });
       MyObject.reopenClass({
        canBuild: false
      });
       MyObject.canBuild; // false
      o = MyObject.create();
      ```
       In other words, this creates static properties and functions for the class.
      These are only available on the class and not on any instance of that class.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        name: '',
        sayHello() {
          alert(`Hello. My name is ${this.get('name')}`);
        }
      });
       Person.reopenClass({
        species: 'Homo sapiens',
         createPerson(name) {
          return Person.create({ name });
        }
      });
       let tom = Person.create({
        name: 'Tom Dale'
      });
      let yehuda = Person.createPerson('Yehuda Katz');
       tom.sayHello(); // "Hello. My name is Tom Dale"
      yehuda.sayHello(); // "Hello. My name is Yehuda Katz"
      alert(Person.species); // "Homo sapiens"
      ```
       Note that `species` and `createPerson` are *not* valid on the `tom` and `yehuda`
      variables. They are only valid on `Person`.
       To add functions and properties to instances of
      a constructor by extending the constructor's prototype
      see `reopen`
       @method reopenClass
      @for @ember/object
      @static
      @public
    */


    static reopenClass() {
      (0, _metal.applyMixin)(this, arguments);
      return this;
    }

    static detect(obj) {
      if ('function' !== typeof obj) {
        return false;
      }

      while (obj) {
        if (obj === this) {
          return true;
        }

        obj = obj.superclass;
      }

      return false;
    }

    static detectInstance(obj) {
      return obj instanceof this;
    }
    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For
      example, computed property functions may close over variables that are then
      no longer available for introspection.
       You can pass a hash of these values to a computed property like this:
       ```javascript
      import { computed } from '@ember/object';
       person: computed(function() {
        let personId = this.get('personId');
        return Person.create({ id: personId });
      }).meta({ type: Person })
      ```
       Once you've done this, you can retrieve the values saved to the computed
      property from your class like this:
       ```javascript
      MyClass.metaForProperty('person');
      ```
       This will return the original hash that was passed to `meta()`.
       @static
      @method metaForProperty
      @param key {String} property name
      @private
    */


    static metaForProperty(key) {
      var proto = this.proto(); // ensure prototype is initialized

      var possibleDesc = (0, _metal.descriptorForProperty)(proto, key);
      (true && !(possibleDesc !== undefined) && (0, _debug.assert)("metaForProperty() could not find a computed property with key '" + key + "'.", possibleDesc !== undefined));
      return possibleDesc._meta || {};
    }
    /**
      Iterate over each computed property for the class, passing its name
      and any associated metadata (see `metaForProperty`) to the callback.
       @static
      @method eachComputedProperty
      @param {Function} callback
      @param {Object} binding
      @private
    */


    static eachComputedProperty(callback, binding = this) {
      this.proto(); // ensure prototype is initialized

      var empty = {};
      (0, _meta2.meta)(this.prototype).forEachDescriptors((name, descriptor) => {
        if (descriptor.enumerable) {
          var _meta = descriptor._meta || empty;

          callback.call(binding, name, _meta);
        }
      });
    }

    static get PrototypeMixin() {
      var prototypeMixin = prototypeMixinMap.get(this);

      if (prototypeMixin === undefined) {
        prototypeMixin = _metal.Mixin.create();
        prototypeMixin.ownerConstructor = this;
        prototypeMixinMap.set(this, prototypeMixin);
      }

      return prototypeMixin;
    }

    static get superclass() {
      var c = Object.getPrototypeOf(this);
      return c !== Function.prototype ? c : undefined;
    }

    static proto() {
      var p = this.prototype;

      if (!wasApplied.has(p)) {
        wasApplied.add(p);
        var parent = this.superclass;

        if (parent) {
          parent.proto();
        } // If the prototype mixin exists, apply it. In the case of native classes,
        // it will not exist (unless the class has been reopened).


        if (prototypeMixinMap.has(this)) {
          this.PrototypeMixin.apply(p);
        }
      }

      return p;
    }

  }

  CoreObject.toString = _metal.classToString;
  (0, _utils.setName)(CoreObject, 'Ember.CoreObject');
  CoreObject.isClass = true;
  CoreObject.isMethod = false;

  function flattenProps(...props) {
    var {
      concatenatedProperties,
      mergedProperties
    } = this;
    var hasConcatenatedProps = concatenatedProperties !== undefined && concatenatedProperties.length > 0;
    var hasMergedProps = mergedProperties !== undefined && mergedProperties.length > 0;
    var initProperties = {};

    for (var i = 0; i < props.length; i++) {
      var properties = props[i];
      (true && !(!(properties instanceof _metal.Mixin)) && (0, _debug.assert)('EmberObject.create no longer supports mixing in other ' + 'definitions, use .extend & .create separately instead.', !(properties instanceof _metal.Mixin)));
      var keyNames = Object.keys(properties);

      for (var j = 0, k = keyNames.length; j < k; j++) {
        var keyName = keyNames[j];
        var value = properties[keyName];

        if (hasConcatenatedProps && concatenatedProperties.indexOf(keyName) > -1) {
          var baseValue = initProperties[keyName];

          if (baseValue) {
            value = (0, _utils.makeArray)(baseValue).concat(value);
          } else {
            value = (0, _utils.makeArray)(value);
          }
        }

        if (hasMergedProps && mergedProperties.indexOf(keyName) > -1) {
          var _baseValue = initProperties[keyName];
          value = (0, _polyfills.assign)({}, _baseValue, value);
        }

        initProperties[keyName] = value;
      }
    }

    return initProperties;
  }

  if (true
  /* DEBUG */
  ) {
    /**
      Provides lookup-time type validation for injected properties.
       @private
      @method _onLookup
    */
    CoreObject._onLookup = function injectedPropertyAssertion(debugContainerKey) {
      var [type] = debugContainerKey.split(':');
      var proto = this.proto();

      for (var key in proto) {
        var desc = (0, _metal.descriptorForProperty)(proto, key);

        if (desc && _metal.DEBUG_INJECTION_FUNCTIONS.has(desc._getter)) {
          (true && !(type === 'controller' || _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter).type !== 'controller') && (0, _debug.assert)("Defining `" + key + "` as an injected controller property on a non-controller (`" + debugContainerKey + "`) is not allowed.", type === 'controller' || _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter).type !== 'controller'));
        }
      }
    };
    /**
      Returns a hash of property names and container names that injected
      properties will lookup on the container lazily.
       @method _lazyInjections
      @return {Object} Hash of all lazy injected property keys to container names
      @private
    */


    CoreObject._lazyInjections = function () {
      var injections = {};
      var proto = this.proto();
      var key;
      var desc;

      for (key in proto) {
        desc = (0, _metal.descriptorForProperty)(proto, key);

        if (desc && _metal.DEBUG_INJECTION_FUNCTIONS.has(desc._getter)) {
          var {
            namespace,
            source,
            type,
            name
          } = _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter);

          injections[key] = {
            namespace,
            source,
            specifier: type + ":" + (name || key)
          };
        }
      }

      return injections;
    };
  }

  var _default = CoreObject;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/system/namespace", ["exports", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/-internals/runtime/lib/system/object"], function (_exports, _metal, _utils, _object) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */
  // Preloaded into namespaces

  /**
    A Namespace is an object usually used to contain other objects or methods
    such as an application or framework. Create a namespace anytime you want
    to define one of these new containers.
  
    # Example Usage
  
    ```javascript
    MyFramework = Ember.Namespace.create({
      VERSION: '1.0.0'
    });
    ```
  
    @class Namespace
    @namespace Ember
    @extends EmberObject
    @public
  */
  class Namespace extends _object.default {
    init() {
      (0, _metal.addNamespace)(this);
    }

    toString() {
      var name = (0, _metal.get)(this, 'name') || (0, _metal.get)(this, 'modulePrefix');

      if (name) {
        return name;
      }

      (0, _metal.findNamespaces)();
      name = (0, _utils.getName)(this);

      if (name === undefined) {
        name = (0, _utils.guidFor)(this);
        (0, _utils.setName)(this, name);
      }

      return name;
    }

    nameClasses() {
      (0, _metal.processNamespace)(this);
    }

    destroy() {
      (0, _metal.removeNamespace)(this);
      super.destroy();
    }

  }

  _exports.default = Namespace;
  Namespace.prototype.isNamespace = true;
  Namespace.NAMESPACES = _metal.NAMESPACES;
  Namespace.NAMESPACES_BY_ID = _metal.NAMESPACES_BY_ID;
  Namespace.processAll = _metal.processAllNamespaces;
  Namespace.byName = _metal.findNamespace;
});
define("@ember/-internals/runtime/lib/system/object", ["exports", "@ember/-internals/container", "@ember/-internals/owner", "@ember/-internals/utils", "@ember/-internals/metal", "@ember/-internals/runtime/lib/system/core_object", "@ember/-internals/runtime/lib/mixins/observable", "@ember/debug"], function (_exports, _container, _owner, _utils, _metal, _core_object, _observable, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.FrameworkObject = _exports.default = void 0;

  /**
  @module @ember/object
  */
  var instanceOwner = new WeakMap();
  /**
    `EmberObject` is the main base class for all Ember objects. It is a subclass
    of `CoreObject` with the `Observable` mixin applied. For details,
    see the documentation for each of these.
  
    @class EmberObject
    @extends CoreObject
    @uses Observable
    @public
  */

  class EmberObject extends _core_object.default {
    get _debugContainerKey() {
      var factory = _container.FACTORY_FOR.get(this);

      return factory !== undefined && factory.fullName;
    }

    get [_owner.OWNER]() {
      var owner = instanceOwner.get(this);

      if (owner !== undefined) {
        return owner;
      }

      var factory = _container.FACTORY_FOR.get(this);

      return factory !== undefined && factory.owner;
    } // we need a setter here largely to support
    // folks calling `owner.ownerInjection()` API


    set [_owner.OWNER](value) {
      instanceOwner.set(this, value);
    }

  }

  _exports.default = EmberObject;
  (0, _utils.setName)(EmberObject, 'Ember.Object');

  _observable.default.apply(EmberObject.prototype);

  var FrameworkObject;
  _exports.FrameworkObject = FrameworkObject;
  _exports.FrameworkObject = FrameworkObject = class FrameworkObject extends _core_object.default {
    get _debugContainerKey() {
      var factory = _container.FACTORY_FOR.get(this);

      return factory !== undefined && factory.fullName;
    }

    constructor(owner) {
      super();
      (0, _owner.setOwner)(this, owner);
    }

  };

  _observable.default.apply(FrameworkObject.prototype);

  if (true
  /* DEBUG */
  ) {
    var INIT_WAS_CALLED = (0, _utils.symbol)('INIT_WAS_CALLED');
    var ASSERT_INIT_WAS_CALLED = (0, _utils.symbol)('ASSERT_INIT_WAS_CALLED');
    _exports.FrameworkObject = FrameworkObject = class DebugFrameworkObject extends EmberObject {
      init() {
        super.init(...arguments);
        this[INIT_WAS_CALLED] = true;
      }

      [ASSERT_INIT_WAS_CALLED]() {
        (true && !(this[INIT_WAS_CALLED]) && (0, _debug.assert)("You must call `this._super(...arguments);` when overriding `init` on a framework object. Please update " + this + " to call `this._super(...arguments);` from `init`.", this[INIT_WAS_CALLED]));
      }

    };
    (0, _metal.addListener)(FrameworkObject.prototype, 'init', null, ASSERT_INIT_WAS_CALLED);
  }
});
define("@ember/-internals/runtime/lib/system/object_proxy", ["exports", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/-proxy"], function (_exports, _object, _proxy) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
    `ObjectProxy` forwards all properties not defined by the proxy itself
    to a proxied `content` object.
  
    ```javascript
    import EmberObject from '@ember/object';
    import ObjectProxy from '@ember/object/proxy';
  
    object = EmberObject.create({
      name: 'Foo'
    });
  
    proxy = ObjectProxy.create({
      content: object
    });
  
    // Access and change existing properties
    proxy.get('name')          // 'Foo'
    proxy.set('name', 'Bar');
    object.get('name')         // 'Bar'
  
    // Create new 'description' property on `object`
    proxy.set('description', 'Foo is a whizboo baz');
    object.get('description')  // 'Foo is a whizboo baz'
    ```
  
    While `content` is unset, setting a property to be delegated will throw an
    Error.
  
    ```javascript
    import ObjectProxy from '@ember/object/proxy';
  
    proxy = ObjectProxy.create({
      content: null,
      flag: null
    });
    proxy.set('flag', true);
    proxy.get('flag');         // true
    proxy.get('foo');          // undefined
    proxy.set('foo', 'data');  // throws Error
    ```
  
    Delegated properties can be bound to and will change when content is updated.
  
    Computed properties on the proxy itself can depend on delegated properties.
  
    ```javascript
    import { computed } from '@ember/object';
    import ObjectProxy from '@ember/object/proxy';
  
    ProxyWithComputedProperty = ObjectProxy.extend({
      fullName: computed('firstName', 'lastName', function() {
        var firstName = this.get('firstName'),
            lastName = this.get('lastName');
        if (firstName && lastName) {
          return firstName + ' ' + lastName;
        }
        return firstName || lastName;
      })
    });
  
    proxy = ProxyWithComputedProperty.create();
  
    proxy.get('fullName');  // undefined
    proxy.set('content', {
      firstName: 'Tom', lastName: 'Dale'
    }); // triggers property change for fullName on proxy
  
    proxy.get('fullName');  // 'Tom Dale'
    ```
  
    @class ObjectProxy
    @extends EmberObject
    @uses Ember.ProxyMixin
    @public
  */
  class ObjectProxy extends _object.default {}

  _exports.default = ObjectProxy;
  ObjectProxy.PrototypeMixin.reopen(_proxy.default);
});
define("@ember/-internals/runtime/lib/type-of", ["exports", "@ember/-internals/runtime/lib/system/core_object"], function (_exports, _core_object) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.typeOf = typeOf;
  // ........................................
  // TYPING & ARRAY MESSAGING
  //
  var TYPE_MAP = {
    '[object Boolean]': 'boolean',
    '[object Number]': 'number',
    '[object String]': 'string',
    '[object Function]': 'function',
    '[object Array]': 'array',
    '[object Date]': 'date',
    '[object RegExp]': 'regexp',
    '[object Object]': 'object',
    '[object FileList]': 'filelist'
  };
  var {
    toString
  } = Object.prototype;
  /**
   @module @ember/utils
  */

  /**
    Returns a consistent type for the passed object.
  
    Use this instead of the built-in `typeof` to get the type of an item.
    It will return the same result across all browsers and includes a bit
    more detail. Here is what will be returned:
  
        | Return Value  | Meaning                                              |
        |---------------|------------------------------------------------------|
        | 'string'      | String primitive or String object.                   |
        | 'number'      | Number primitive or Number object.                   |
        | 'boolean'     | Boolean primitive or Boolean object.                 |
        | 'null'        | Null value                                           |
        | 'undefined'   | Undefined value                                      |
        | 'function'    | A function                                           |
        | 'array'       | An instance of Array                                 |
        | 'regexp'      | An instance of RegExp                                |
        | 'date'        | An instance of Date                                  |
        | 'filelist'    | An instance of FileList                              |
        | 'class'       | An Ember class (created using EmberObject.extend())  |
        | 'instance'    | An Ember object instance                             |
        | 'error'       | An instance of the Error object                      |
        | 'object'      | A JavaScript object not inheriting from EmberObject  |
  
    Examples:
  
    ```javascript
    import { A } from '@ember/array';
    import { typeOf } from '@ember/utils';
    import EmberObject from '@ember/object';
  
    typeOf();                       // 'undefined'
    typeOf(null);                   // 'null'
    typeOf(undefined);              // 'undefined'
    typeOf('michael');              // 'string'
    typeOf(new String('michael'));  // 'string'
    typeOf(101);                    // 'number'
    typeOf(new Number(101));        // 'number'
    typeOf(true);                   // 'boolean'
    typeOf(new Boolean(true));      // 'boolean'
    typeOf(A);                      // 'function'
    typeOf([1, 2, 90]);             // 'array'
    typeOf(/abc/);                  // 'regexp'
    typeOf(new Date());             // 'date'
    typeOf(event.target.files);     // 'filelist'
    typeOf(EmberObject.extend());   // 'class'
    typeOf(EmberObject.create());   // 'instance'
    typeOf(new Error('teamocil'));  // 'error'
  
    // 'normal' JavaScript object
    typeOf({ a: 'b' });             // 'object'
    ```
  
    @method typeOf
    @for @ember/utils
    @param {Object} item the item to check
    @return {String} the type
    @public
    @static
  */

  function typeOf(item) {
    if (item === null) {
      return 'null';
    }

    if (item === undefined) {
      return 'undefined';
    }

    var ret = TYPE_MAP[toString.call(item)] || 'object';

    if (ret === 'function') {
      if (_core_object.default.detect(item)) {
        ret = 'class';
      }
    } else if (ret === 'object') {
      if (item instanceof Error) {
        ret = 'error';
      } else if (item instanceof _core_object.default) {
        ret = 'instance';
      } else if (item instanceof Date) {
        ret = 'date';
      }
    }

    return ret;
  }
});
define("@ember/-internals/utils/index", ["exports", "@ember/polyfills", "@ember/debug"], function (_exports, _polyfills, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.symbol = symbol;
  _exports.isInternalSymbol = isInternalSymbol;
  _exports.dictionary = makeDictionary;
  _exports.uuid = uuid;
  _exports.generateGuid = generateGuid;
  _exports.guidFor = guidFor;
  _exports.intern = intern;
  _exports.wrap = wrap;
  _exports.getObservers = getObservers;
  _exports.getListeners = getListeners;
  _exports.setObservers = setObservers;
  _exports.setListeners = setListeners;
  _exports.inspect = inspect;
  _exports.lookupDescriptor = lookupDescriptor;
  _exports.canInvoke = canInvoke;
  _exports.tryInvoke = tryInvoke;
  _exports.makeArray = makeArray;
  _exports.getName = getName;
  _exports.setName = setName;
  _exports.toString = toString;
  _exports.isProxy = isProxy;
  _exports.setProxy = setProxy;
  _exports.isEmberArray = isEmberArray;
  _exports.setWithMandatorySetter = _exports.teardownMandatorySetter = _exports.setupMandatorySetter = _exports.EMBER_ARRAY = _exports.Cache = _exports.HAS_NATIVE_PROXY = _exports.HAS_NATIVE_SYMBOL = _exports.ROOT = _exports.checkHasSuper = _exports.GUID_KEY = _exports.getOwnPropertyDescriptors = void 0;

  /**
    Strongly hint runtimes to intern the provided string.
  
    When do I need to use this function?
  
    For the most part, never. Pre-mature optimization is bad, and often the
    runtime does exactly what you need it to, and more often the trade-off isn't
    worth it.
  
    Why?
  
    Runtimes store strings in at least 2 different representations:
    Ropes and Symbols (interned strings). The Rope provides a memory efficient
    data-structure for strings created from concatenation or some other string
    manipulation like splitting.
  
    Unfortunately checking equality of different ropes can be quite costly as
    runtimes must resort to clever string comparison algorithms. These
    algorithms typically cost in proportion to the length of the string.
    Luckily, this is where the Symbols (interned strings) shine. As Symbols are
    unique by their string content, equality checks can be done by pointer
    comparison.
  
    How do I know if my string is a rope or symbol?
  
    Typically (warning general sweeping statement, but truthy in runtimes at
    present) static strings created as part of the JS source are interned.
    Strings often used for comparisons can be interned at runtime if some
    criteria are met.  One of these criteria can be the size of the entire rope.
    For example, in chrome 38 a rope longer then 12 characters will not
    intern, nor will segments of that rope.
  
    Some numbers: http://jsperf.com/eval-vs-keys/8
  
    Known Trick™
  
    @private
    @return {String} interned version of the provided string
  */
  function intern(str) {
    var obj = {};
    obj[str] = 1;

    for (var key in obj) {
      if (key === str) {
        return key;
      }
    }

    return str;
  }
  /**
    Returns whether Type(value) is Object.
  
    Useful for checking whether a value is a valid WeakMap key.
  
    Refs: https://tc39.github.io/ecma262/#sec-typeof-operator-runtime-semantics-evaluation
          https://tc39.github.io/ecma262/#sec-weakmap.prototype.set
  
    @private
    @function isObject
  */


  function isObject(value) {
    return value !== null && (typeof value === 'object' || typeof value === 'function');
  }
  /**
   @module @ember/object
  */

  /**
   Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
   jQuery master. We'll just bootstrap our own uuid now.
  
   @private
   @return {Number} the uuid
   */


  var _uuid = 0;
  /**
   Generates a universally unique identifier. This method
   is used internally by Ember for assisting with
   the generation of GUID's and other unique identifiers.
  
   @public
   @return {Number} [description]
   */

  function uuid() {
    return ++_uuid;
  }
  /**
   Prefix used for guids through out Ember.
   @private
   @property GUID_PREFIX
   @for Ember
   @type String
   @final
   */


  var GUID_PREFIX = 'ember'; // Used for guid generation...

  var OBJECT_GUIDS = new WeakMap();
  var NON_OBJECT_GUIDS = new Map();
  /**
    A unique key used to assign guids and other private metadata to objects.
    If you inspect an object in your browser debugger you will often see these.
    They can be safely ignored.
  
    On browsers that support it, these properties are added with enumeration
    disabled so they won't show up when you iterate over your properties.
  
    @private
    @property GUID_KEY
    @for Ember
    @type String
    @final
  */

  var GUID_KEY = intern("__ember" + Date.now());
  /**
    Generates a new guid, optionally saving the guid to the object that you
    pass in. You will rarely need to use this method. Instead you should
    call `guidFor(obj)`, which return an existing guid if available.
  
    @private
    @method generateGuid
    @static
    @for @ember/object/internals
    @param {Object} [obj] Object the guid will be used for. If passed in, the guid will
      be saved on the object and reused whenever you pass the same object
      again.
  
      If no object is passed, just generate a new guid.
    @param {String} [prefix] Prefix to place in front of the guid. Useful when you want to
      separate the guid into separate namespaces.
    @return {String} the guid
  */

  _exports.GUID_KEY = GUID_KEY;

  function generateGuid(obj, prefix = GUID_PREFIX) {
    var guid = prefix + uuid();

    if (isObject(obj)) {
      OBJECT_GUIDS.set(obj, guid);
    }

    return guid;
  }
  /**
    Returns a unique id for the object. If the object does not yet have a guid,
    one will be assigned to it. You can call this on any object,
    `EmberObject`-based or not.
  
    You can also use this method on DOM Element objects.
  
    @public
    @static
    @method guidFor
    @for @ember/object/internals
    @param {Object} obj any object, string, number, Element, or primitive
    @return {String} the unique guid for this instance.
  */


  function guidFor(value) {
    var guid;

    if (isObject(value)) {
      guid = OBJECT_GUIDS.get(value);

      if (guid === undefined) {
        guid = GUID_PREFIX + uuid();
        OBJECT_GUIDS.set(value, guid);
      }
    } else {
      guid = NON_OBJECT_GUIDS.get(value);

      if (guid === undefined) {
        var type = typeof value;

        if (type === 'string') {
          guid = 'st' + uuid();
        } else if (type === 'number') {
          guid = 'nu' + uuid();
        } else if (type === 'symbol') {
          guid = 'sy' + uuid();
        } else {
          guid = '(' + value + ')';
        }

        NON_OBJECT_GUIDS.set(value, guid);
      }
    }

    return guid;
  }

  var GENERATED_SYMBOLS = [];

  function isInternalSymbol(possibleSymbol) {
    return GENERATED_SYMBOLS.indexOf(possibleSymbol) !== -1;
  }

  function symbol(debugName) {
    // TODO: Investigate using platform symbols, but we do not
    // want to require non-enumerability for this API, which
    // would introduce a large cost.
    var id = GUID_KEY + Math.floor(Math.random() * Date.now());
    var symbol = intern("__" + debugName + id + "__");
    GENERATED_SYMBOLS.push(symbol);
    return symbol;
  } // the delete is meant to hint at runtimes that this object should remain in
  // dictionary mode. This is clearly a runtime specific hack, but currently it
  // appears worthwhile in some usecases. Please note, these deletes do increase
  // the cost of creation dramatically over a plain Object.create. And as this
  // only makes sense for long-lived dictionaries that aren't instantiated often.


  function makeDictionary(parent) {
    var dict = Object.create(parent);
    dict['_dict'] = null;
    delete dict['_dict'];
    return dict;
  }

  var getOwnPropertyDescriptors;

  if (Object.getOwnPropertyDescriptors !== undefined) {
    getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors;
  } else {
    getOwnPropertyDescriptors = function (obj) {
      var descriptors = {};
      Object.keys(obj).forEach(key => {
        descriptors[key] = Object.getOwnPropertyDescriptor(obj, key);
      });
      return descriptors;
    };
  }

  var getOwnPropertyDescriptors$1 = getOwnPropertyDescriptors;
  _exports.getOwnPropertyDescriptors = getOwnPropertyDescriptors$1;
  var HAS_SUPER_PATTERN = /\.(_super|call\(this|apply\(this)/;
  var fnToString = Function.prototype.toString;

  var checkHasSuper = (() => {
    var sourceAvailable = fnToString.call(function () {
      return this;
    }).indexOf('return this') > -1;

    if (sourceAvailable) {
      return function checkHasSuper(func) {
        return HAS_SUPER_PATTERN.test(fnToString.call(func));
      };
    }

    return function checkHasSuper() {
      return true;
    };
  })();

  _exports.checkHasSuper = checkHasSuper;
  var HAS_SUPER_MAP = new WeakMap();
  var ROOT = Object.freeze(function () {});
  _exports.ROOT = ROOT;
  HAS_SUPER_MAP.set(ROOT, false);

  function hasSuper(func) {
    var hasSuper = HAS_SUPER_MAP.get(func);

    if (hasSuper === undefined) {
      hasSuper = checkHasSuper(func);
      HAS_SUPER_MAP.set(func, hasSuper);
    }

    return hasSuper;
  }

  var OBSERVERS_MAP = new WeakMap();

  function setObservers(func, observers) {
    OBSERVERS_MAP.set(func, observers);
  }

  function getObservers(func) {
    return OBSERVERS_MAP.get(func);
  }

  var LISTENERS_MAP = new WeakMap();

  function setListeners(func, listeners) {
    if (listeners) {
      LISTENERS_MAP.set(func, listeners);
    }
  }

  function getListeners(func) {
    return LISTENERS_MAP.get(func);
  }

  var IS_WRAPPED_FUNCTION_SET = new _polyfills._WeakSet();
  /**
    Wraps the passed function so that `this._super` will point to the superFunc
    when the function is invoked. This is the primitive we use to implement
    calls to super.
  
    @private
    @method wrap
    @for Ember
    @param {Function} func The function to call
    @param {Function} superFunc The super function.
    @return {Function} wrapped function.
  */

  function wrap(func, superFunc) {
    if (!hasSuper(func)) {
      return func;
    } // ensure an unwrapped super that calls _super is wrapped with a terminal _super


    if (!IS_WRAPPED_FUNCTION_SET.has(superFunc) && hasSuper(superFunc)) {
      return _wrap(func, _wrap(superFunc, ROOT));
    }

    return _wrap(func, superFunc);
  }

  function _wrap(func, superFunc) {
    function superWrapper() {
      var orig = this._super;
      this._super = superFunc;
      var ret = func.apply(this, arguments);
      this._super = orig;
      return ret;
    }

    IS_WRAPPED_FUNCTION_SET.add(superWrapper);
    setObservers(superWrapper, getObservers(func));
    setListeners(superWrapper, getListeners(func));
    return superWrapper;
  }

  var {
    toString: objectToString
  } = Object.prototype;
  var {
    toString: functionToString
  } = Function.prototype;
  var {
    isArray
  } = Array;
  var {
    keys: objectKeys
  } = Object;
  var {
    stringify
  } = JSON;
  var LIST_LIMIT = 100;
  var DEPTH_LIMIT = 4;
  var SAFE_KEY = /^[\w$]+$/;
  /**
   @module @ember/debug
  */

  /**
    Convenience method to inspect an object. This method will attempt to
    convert the object into a useful string description.
  
    It is a pretty simple implementation. If you want something more robust,
    use something like JSDump: https://github.com/NV/jsDump
  
    @method inspect
    @static
    @param {Object} obj The object you want to inspect.
    @return {String} A description of the object
    @since 1.4.0
    @private
  */

  function inspect(obj) {
    // detect Node util.inspect call inspect(depth: number, opts: object)
    if (typeof obj === 'number' && arguments.length === 2) {
      return this;
    }

    return inspectValue(obj, 0);
  }

  function inspectValue(value, depth, seen) {
    var valueIsArray = false;

    switch (typeof value) {
      case 'undefined':
        return 'undefined';

      case 'object':
        if (value === null) return 'null';

        if (isArray(value)) {
          valueIsArray = true;
          break;
        } // is toString Object.prototype.toString or undefined then traverse


        if (value.toString === objectToString || value.toString === undefined) {
          break;
        } // custom toString


        return value.toString();

      case 'function':
        return value.toString === functionToString ? value.name ? "[Function:" + value.name + "]" : "[Function]" : value.toString();

      case 'string':
        return stringify(value);

      case 'symbol':
      case 'boolean':
      case 'number':
      default:
        return value.toString();
    }

    if (seen === undefined) {
      seen = new _polyfills._WeakSet();
    } else {
      if (seen.has(value)) return "[Circular]";
    }

    seen.add(value);
    return valueIsArray ? inspectArray(value, depth + 1, seen) : inspectObject(value, depth + 1, seen);
  }

  function inspectKey(key) {
    return SAFE_KEY.test(key) ? key : stringify(key);
  }

  function inspectObject(obj, depth, seen) {
    if (depth > DEPTH_LIMIT) {
      return '[Object]';
    }

    var s = '{';
    var keys = objectKeys(obj);

    for (var i = 0; i < keys.length; i++) {
      s += i === 0 ? ' ' : ', ';

      if (i >= LIST_LIMIT) {
        s += "... " + (keys.length - LIST_LIMIT) + " more keys";
        break;
      }

      var key = keys[i];
      s += inspectKey(key) + ': ' + inspectValue(obj[key], depth, seen);
    }

    s += ' }';
    return s;
  }

  function inspectArray(arr, depth, seen) {
    if (depth > DEPTH_LIMIT) {
      return '[Array]';
    }

    var s = '[';

    for (var i = 0; i < arr.length; i++) {
      s += i === 0 ? ' ' : ', ';

      if (i >= LIST_LIMIT) {
        s += "... " + (arr.length - LIST_LIMIT) + " more items";
        break;
      }

      s += inspectValue(arr[i], depth, seen);
    }

    s += ' ]';
    return s;
  }

  function lookupDescriptor(obj, keyName) {
    var current = obj;

    do {
      var descriptor = Object.getOwnPropertyDescriptor(current, keyName);

      if (descriptor !== undefined) {
        return descriptor;
      }

      current = Object.getPrototypeOf(current);
    } while (current !== null);

    return null;
  }
  /**
    Checks to see if the `methodName` exists on the `obj`.
  
    ```javascript
    let foo = { bar: function() { return 'bar'; }, baz: null };
  
    Ember.canInvoke(foo, 'bar'); // true
    Ember.canInvoke(foo, 'baz'); // false
    Ember.canInvoke(foo, 'bat'); // false
    ```
  
    @method canInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @return {Boolean}
    @private
  */


  function canInvoke(obj, methodName) {
    return obj !== null && obj !== undefined && typeof obj[methodName] === 'function';
  }
  /**
    @module @ember/utils
  */

  /**
    Checks to see if the `methodName` exists on the `obj`,
    and if it does, invokes it with the arguments passed.
  
    ```javascript
    import { tryInvoke } from '@ember/utils';
  
    let d = new Date('03/15/2013');
  
    tryInvoke(d, 'getTime');              // 1363320000000
    tryInvoke(d, 'setFullYear', [2014]);  // 1394856000000
    tryInvoke(d, 'noSuchMethod', [2014]); // undefined
    ```
  
    @method tryInvoke
    @for @ember/utils
    @static
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @param {Array} [args] The arguments to pass to the method
    @return {*} the return value of the invoked method or undefined if it cannot be invoked
    @public
  */


  function tryInvoke(obj, methodName, args) {
    if (canInvoke(obj, methodName)) {
      var method = obj[methodName];
      return method.apply(obj, args);
    }
  }

  var {
    isArray: isArray$1
  } = Array;

  function makeArray(obj) {
    if (obj === null || obj === undefined) {
      return [];
    }

    return isArray$1(obj) ? obj : [obj];
  }

  var NAMES = new WeakMap();

  function setName(obj, name) {
    if (isObject(obj)) NAMES.set(obj, name);
  }

  function getName(obj) {
    return NAMES.get(obj);
  }

  var objectToString$1 = Object.prototype.toString;

  function isNone(obj) {
    return obj === null || obj === undefined;
  }
  /*
   A `toString` util function that supports objects without a `toString`
   method, e.g. an object created with `Object.create(null)`.
  */


  function toString(obj) {
    if (typeof obj === 'string') {
      return obj;
    }

    if (null === obj) return 'null';
    if (undefined === obj) return 'undefined';

    if (Array.isArray(obj)) {
      // Reimplement Array.prototype.join according to spec (22.1.3.13)
      // Changing ToString(element) with this safe version of ToString.
      var r = '';

      for (var k = 0; k < obj.length; k++) {
        if (k > 0) {
          r += ',';
        }

        if (!isNone(obj[k])) {
          r += toString(obj[k]);
        }
      }

      return r;
    }

    if (typeof obj.toString === 'function') {
      return obj.toString();
    }

    return objectToString$1.call(obj);
  }

  var HAS_NATIVE_SYMBOL = function () {
    if (typeof Symbol !== 'function') {
      return false;
    }

    return typeof Symbol() === 'symbol';
  }();

  _exports.HAS_NATIVE_SYMBOL = HAS_NATIVE_SYMBOL;
  var HAS_NATIVE_PROXY = typeof Proxy === 'function';
  _exports.HAS_NATIVE_PROXY = HAS_NATIVE_PROXY;
  var PROXIES = new _polyfills._WeakSet();

  function isProxy(value) {
    if (isObject(value)) {
      return PROXIES.has(value);
    }

    return false;
  }

  function setProxy(object) {
    if (isObject(object)) {
      PROXIES.add(object);
    }
  }

  class Cache {
    constructor(limit, func, store) {
      this.limit = limit;
      this.func = func;
      this.store = store;
      this.size = 0;
      this.misses = 0;
      this.hits = 0;
      this.store = store || new Map();
    }

    get(key) {
      if (this.store.has(key)) {
        this.hits++;
        return this.store.get(key);
      } else {
        this.misses++;
        return this.set(key, this.func(key));
      }
    }

    set(key, value) {
      if (this.limit > this.size) {
        this.size++;
        this.store.set(key, value);
      }

      return value;
    }

    purge() {
      this.store.clear();
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    }

  }

  _exports.Cache = Cache;
  var EMBER_ARRAY = symbol('EMBER_ARRAY');
  _exports.EMBER_ARRAY = EMBER_ARRAY;

  function isEmberArray(obj) {
    return obj && obj[EMBER_ARRAY];
  }

  var setupMandatorySetter;
  _exports.setupMandatorySetter = setupMandatorySetter;
  var teardownMandatorySetter;
  _exports.teardownMandatorySetter = teardownMandatorySetter;
  var setWithMandatorySetter;
  _exports.setWithMandatorySetter = setWithMandatorySetter;

  if (true
  /* DEBUG */
  && true
  /* EMBER_METAL_TRACKED_PROPERTIES */
  ) {
      var MANDATORY_SETTERS = new WeakMap();

      var _propertyIsEnumerable = function (obj, key) {
        return Object.prototype.propertyIsEnumerable.call(obj, key);
      };

      _exports.setupMandatorySetter = setupMandatorySetter = function (obj, keyName) {
        var desc = lookupDescriptor(obj, keyName) || {};

        if (desc.get || desc.set) {
          // if it has a getter or setter, we can't install the mandatory setter.
          // native setters are allowed, we have to assume that they will resolve
          // to tracked properties.
          return;
        }

        if (desc && (!desc.configurable || !desc.writable)) {
          // if it isn't writable anyways, so we shouldn't provide the setter.
          // if it isn't configurable, we can't overwrite it anyways.
          return;
        }

        var setters = MANDATORY_SETTERS.get(obj);

        if (setters === undefined) {
          setters = {};
          MANDATORY_SETTERS.set(obj, setters);
        }

        desc.hadOwnProperty = Object.hasOwnProperty.call(obj, keyName);
        setters[keyName] = desc;
        Object.defineProperty(obj, keyName, {
          configurable: true,
          enumerable: _propertyIsEnumerable(obj, keyName),

          get() {
            if (desc.get) {
              return desc.get.call(this);
            } else {
              return desc.value;
            }
          },

          set(value) {
            (true && !(false) && (0, _debug.assert)("You attempted to update " + this + "." + String(keyName) + " to \"" + String(value) + "\", but it is being tracked by a tracking context, such as a template, computed property, or observer. In order to make sure the context updates properly, you must invalidate the property when updating it. You can mark the property as `@tracked`, or use `@ember/object#set` to do this."));
          }

        });
      };

      _exports.teardownMandatorySetter = teardownMandatorySetter = function (obj, keyName) {
        var setters = MANDATORY_SETTERS.get(obj);

        if (setters !== undefined && setters[keyName] !== undefined) {
          Object.defineProperty(obj, keyName, setters[keyName]);
          setters[keyName] = undefined;
        }
      };

      _exports.setWithMandatorySetter = setWithMandatorySetter = function (obj, keyName, value) {
        var setters = MANDATORY_SETTERS.get(obj);

        if (setters !== undefined && setters[keyName] !== undefined) {
          var setter = setters[keyName];

          if (setter.set) {
            setter.set.call(obj, value);
          } else {
            setter.value = value; // If the object didn't have own property before, it would have changed
            // the enumerability after setting the value the first time.

            if (!setter.hadOwnProperty) {
              var desc = lookupDescriptor(obj, keyName);
              desc.enumerable = true;
              Object.defineProperty(obj, keyName, desc);
            }
          }
        } else {
          obj[keyName] = value;
        }
      };
    }
  /*
   This package will be eagerly parsed and should have no dependencies on external
   packages.
  
   It is intended to be used to share utility methods that will be needed
   by every Ember application (and is **not** a dumping ground of useful utilities).
  
   Utility methods that are needed in < 80% of cases should be placed
   elsewhere (so they can be lazily evaluated / parsed).
  */

});
define("@ember/-internals/views/index", ["exports", "@ember/-internals/views/lib/system/jquery", "@ember/-internals/views/lib/system/utils", "@ember/-internals/views/lib/system/event_dispatcher", "@ember/-internals/views/lib/component_lookup", "@ember/-internals/views/lib/mixins/text_support", "@ember/-internals/views/lib/views/core_view", "@ember/-internals/views/lib/mixins/class_names_support", "@ember/-internals/views/lib/mixins/child_views_support", "@ember/-internals/views/lib/mixins/view_state_support", "@ember/-internals/views/lib/mixins/view_support", "@ember/-internals/views/lib/mixins/action_support", "@ember/-internals/views/lib/compat/attrs", "@ember/-internals/views/lib/system/lookup_partial", "@ember/-internals/views/lib/system/action_manager"], function (_exports, _jquery, _utils, _event_dispatcher, _component_lookup, _text_support, _core_view, _class_names_support, _child_views_support, _view_state_support, _view_support, _action_support, _attrs, _lookup_partial, _action_manager) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "jQuery", {
    enumerable: true,
    get: function () {
      return _jquery.jQuery;
    }
  });
  Object.defineProperty(_exports, "jQueryDisabled", {
    enumerable: true,
    get: function () {
      return _jquery.jQueryDisabled;
    }
  });
  Object.defineProperty(_exports, "addChildView", {
    enumerable: true,
    get: function () {
      return _utils.addChildView;
    }
  });
  Object.defineProperty(_exports, "isSimpleClick", {
    enumerable: true,
    get: function () {
      return _utils.isSimpleClick;
    }
  });
  Object.defineProperty(_exports, "getViewBounds", {
    enumerable: true,
    get: function () {
      return _utils.getViewBounds;
    }
  });
  Object.defineProperty(_exports, "getViewClientRects", {
    enumerable: true,
    get: function () {
      return _utils.getViewClientRects;
    }
  });
  Object.defineProperty(_exports, "getViewBoundingClientRect", {
    enumerable: true,
    get: function () {
      return _utils.getViewBoundingClientRect;
    }
  });
  Object.defineProperty(_exports, "getRootViews", {
    enumerable: true,
    get: function () {
      return _utils.getRootViews;
    }
  });
  Object.defineProperty(_exports, "getChildViews", {
    enumerable: true,
    get: function () {
      return _utils.getChildViews;
    }
  });
  Object.defineProperty(_exports, "getViewId", {
    enumerable: true,
    get: function () {
      return _utils.getViewId;
    }
  });
  Object.defineProperty(_exports, "getElementView", {
    enumerable: true,
    get: function () {
      return _utils.getElementView;
    }
  });
  Object.defineProperty(_exports, "getViewElement", {
    enumerable: true,
    get: function () {
      return _utils.getViewElement;
    }
  });
  Object.defineProperty(_exports, "setElementView", {
    enumerable: true,
    get: function () {
      return _utils.setElementView;
    }
  });
  Object.defineProperty(_exports, "setViewElement", {
    enumerable: true,
    get: function () {
      return _utils.setViewElement;
    }
  });
  Object.defineProperty(_exports, "clearElementView", {
    enumerable: true,
    get: function () {
      return _utils.clearElementView;
    }
  });
  Object.defineProperty(_exports, "clearViewElement", {
    enumerable: true,
    get: function () {
      return _utils.clearViewElement;
    }
  });
  Object.defineProperty(_exports, "constructStyleDeprecationMessage", {
    enumerable: true,
    get: function () {
      return _utils.constructStyleDeprecationMessage;
    }
  });
  Object.defineProperty(_exports, "EventDispatcher", {
    enumerable: true,
    get: function () {
      return _event_dispatcher.default;
    }
  });
  Object.defineProperty(_exports, "ComponentLookup", {
    enumerable: true,
    get: function () {
      return _component_lookup.default;
    }
  });
  Object.defineProperty(_exports, "TextSupport", {
    enumerable: true,
    get: function () {
      return _text_support.default;
    }
  });
  Object.defineProperty(_exports, "CoreView", {
    enumerable: true,
    get: function () {
      return _core_view.default;
    }
  });
  Object.defineProperty(_exports, "ClassNamesSupport", {
    enumerable: true,
    get: function () {
      return _class_names_support.default;
    }
  });
  Object.defineProperty(_exports, "ChildViewsSupport", {
    enumerable: true,
    get: function () {
      return _child_views_support.default;
    }
  });
  Object.defineProperty(_exports, "ViewStateSupport", {
    enumerable: true,
    get: function () {
      return _view_state_support.default;
    }
  });
  Object.defineProperty(_exports, "ViewMixin", {
    enumerable: true,
    get: function () {
      return _view_support.default;
    }
  });
  Object.defineProperty(_exports, "ActionSupport", {
    enumerable: true,
    get: function () {
      return _action_support.default;
    }
  });
  Object.defineProperty(_exports, "MUTABLE_CELL", {
    enumerable: true,
    get: function () {
      return _attrs.MUTABLE_CELL;
    }
  });
  Object.defineProperty(_exports, "lookupPartial", {
    enumerable: true,
    get: function () {
      return _lookup_partial.default;
    }
  });
  Object.defineProperty(_exports, "hasPartial", {
    enumerable: true,
    get: function () {
      return _lookup_partial.hasPartial;
    }
  });
  Object.defineProperty(_exports, "ActionManager", {
    enumerable: true,
    get: function () {
      return _action_manager.default;
    }
  });
});
define("@ember/-internals/views/lib/compat/attrs", ["exports", "@ember/-internals/utils"], function (_exports, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.MUTABLE_CELL = void 0;
  var MUTABLE_CELL = (0, _utils.symbol)('MUTABLE_CELL');
  _exports.MUTABLE_CELL = MUTABLE_CELL;
});
define("@ember/-internals/views/lib/compat/fallback-view-registry", ["exports", "@ember/-internals/utils"], function (_exports, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = (0, _utils.dictionary)(null);

  _exports.default = _default;
});
define("@ember/-internals/views/lib/component_lookup", ["exports", "@ember/-internals/runtime"], function (_exports, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = _runtime.Object.extend({
    componentFor(name, owner, options) {
      var fullName = "component:" + name;
      return owner.factoryFor(fullName, options);
    },

    layoutFor(name, owner, options) {
      var templateFullName = "template:components/" + name;
      return owner.lookup(templateFullName, options);
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/views/lib/mixins/action_support", ["exports", "@ember/-internals/utils", "@ember/-internals/metal", "@ember/debug", "@ember/-internals/views/lib/compat/attrs", "@ember/deprecated-features"], function (_exports, _utils, _metal, _debug, _attrs, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
   @module ember
  */
  var mixinObj = {
    send(actionName, ...args) {
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .send() with the action '" + actionName + "' on the destroyed object '" + this + "'.", !this.isDestroying && !this.isDestroyed));
      var action = this.actions && this.actions[actionName];

      if (action) {
        var shouldBubble = action.apply(this, args) === true;

        if (!shouldBubble) {
          return;
        }
      }

      var target = (0, _metal.get)(this, 'target');

      if (target) {
        (true && !(typeof target.send === 'function') && (0, _debug.assert)("The `target` for " + this + " (" + target + ") does not have a `send` method", typeof target.send === 'function'));
        target.send(...arguments);
      } else {
        (true && !(action) && (0, _debug.assert)((0, _utils.inspect)(this) + " had no action handler for: " + actionName, action));
      }
    }

  };

  if (_deprecatedFeatures.SEND_ACTION) {
    /**
      Calls an action passed to a component.
       For example a component for playing or pausing music may translate click events
      into action notifications of "play" or "stop" depending on some internal state
      of the component:
       ```app/components/play-button.js
      import Component from '@ember/component';
       export default Component.extend({
        click() {
          if (this.get('isPlaying')) {
            this.sendAction('play');
          } else {
            this.sendAction('stop');
          }
        }
      });
      ```
       The actions "play" and "stop" must be passed to this `play-button` component:
       ```handlebars
      {{! app/templates/application.hbs }}
      {{play-button play=(action "musicStarted") stop=(action "musicStopped")}}
      ```
       When the component receives a browser `click` event it translate this
      interaction into application-specific semantics ("play" or "stop") and
      calls the specified action.
       ```app/controller/application.js
      import Controller from '@ember/controller';
       export default Controller.extend({
        actions: {
          musicStarted() {
            // called when the play button is clicked
            // and the music started playing
          },
          musicStopped() {
            // called when the play button is clicked
            // and the music stopped playing
          }
        }
      });
      ```
       If no action is passed to `sendAction` a default name of "action"
      is assumed.
       ```app/components/next-button.js
      import Component from '@ember/component';
       export default Component.extend({
        click() {
          this.sendAction();
        }
      });
      ```
       ```handlebars
      {{! app/templates/application.hbs }}
      {{next-button action=(action "playNextSongInAlbum")}}
      ```
       ```app/controllers/application.js
      import Controller from '@ember/controller';
       export default Controller.extend({
        actions: {
          playNextSongInAlbum() {
            ...
          }
        }
      });
      ```
       @method sendAction
      @param [action] {String} the action to call
      @param [params] {*} arguments for the action
      @public
      @deprecated
    */
    var sendAction = function sendAction(action, ...contexts) {
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .sendAction() with the action '" + action + "' on the destroyed object '" + this + "'.", !this.isDestroying && !this.isDestroyed));
      (true && !(false) && (0, _debug.deprecate)("You called " + (0, _utils.inspect)(this) + ".sendAction(" + (typeof action === 'string' ? "\"" + action + "\"" : '') + ") but Component#sendAction is deprecated. Please use closure actions instead.", false, {
        id: 'ember-component.send-action',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_ember-component-send-action'
      }));
      var actionName; // Send the default action

      if (action === undefined) {
        action = 'action';
      }

      actionName = (0, _metal.get)(this, "attrs." + action) || (0, _metal.get)(this, action);
      actionName = validateAction(this, actionName); // If no action name for that action could be found, just abort.

      if (actionName === undefined) {
        return;
      }

      if (typeof actionName === 'function') {
        actionName(...contexts);
      } else {
        this.triggerAction({
          action: actionName,
          actionContext: contexts
        });
      }
    };

    var validateAction = function validateAction(component, actionName) {
      if (actionName && actionName[_attrs.MUTABLE_CELL]) {
        actionName = actionName.value;
      }

      (true && !(actionName === null || actionName === undefined || typeof actionName === 'string' || typeof actionName === 'function') && (0, _debug.assert)("The default action was triggered on the component " + component.toString() + ", but the action name (" + actionName + ") was not a string.", actionName === null || actionName === undefined || typeof actionName === 'string' || typeof actionName === 'function'));
      return actionName;
    };

    mixinObj.sendAction = sendAction;
  }
  /**
   @class ActionSupport
   @namespace Ember
   @private
  */


  var _default = _metal.Mixin.create(mixinObj);

  _exports.default = _default;
});
define("@ember/-internals/views/lib/mixins/child_views_support", ["exports", "@ember/-internals/metal", "@ember/-internals/views/lib/system/utils"], function (_exports, _metal, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */
  var _default = _metal.Mixin.create({
    /**
      Array of child views. You should never edit this array directly.
       @property childViews
      @type Array
      @default []
      @private
    */
    childViews: (0, _metal.nativeDescDecorator)({
      configurable: false,
      enumerable: false,

      get() {
        return (0, _utils.getChildViews)(this);
      }

    }),

    appendChild(view) {
      (0, _utils.addChildView)(this, view);
    }

  });

  _exports.default = _default;
});
define("@ember/-internals/views/lib/mixins/class_names_support", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */
  var EMPTY_ARRAY = Object.freeze([]);
  /**
    @class ClassNamesSupport
    @namespace Ember
    @private
  */

  var _default = _metal.Mixin.create({
    concatenatedProperties: ['classNames', 'classNameBindings'],

    init() {
      this._super(...arguments);

      (true && !((0, _metal.descriptorForProperty)(this, 'classNameBindings') === undefined && Array.isArray(this.classNameBindings)) && (0, _debug.assert)("Only arrays are allowed for 'classNameBindings'", (0, _metal.descriptorForProperty)(this, 'classNameBindings') === undefined && Array.isArray(this.classNameBindings)));
      (true && !((0, _metal.descriptorForProperty)(this, 'classNames') === undefined && Array.isArray(this.classNames)) && (0, _debug.assert)("Only arrays of static class strings are allowed for 'classNames'. For dynamic classes, use 'classNameBindings'.", (0, _metal.descriptorForProperty)(this, 'classNames') === undefined && Array.isArray(this.classNames)));
    },

    /**
      Standard CSS class names to apply to the view's outer element. This
      property automatically inherits any class names defined by the view's
      superclasses as well.
       @property classNames
      @type Array
      @default ['ember-view']
      @public
    */
    classNames: EMPTY_ARRAY,

    /**
      A list of properties of the view to apply as class names. If the property
      is a string value, the value of that string will be applied as a class
      name.
       ```javascript
      // Applies the 'high' class to the view element
      import Component from '@ember/component';
      Component.extend({
        classNameBindings: ['priority'],
        priority: 'high'
      });
      ```
       If the value of the property is a Boolean, the name of that property is
      added as a dasherized class name.
       ```javascript
      // Applies the 'is-urgent' class to the view element
      import Component from '@ember/component';
      Component.extend({
        classNameBindings: ['isUrgent'],
        isUrgent: true
      });
      ```
       If you would prefer to use a custom value instead of the dasherized
      property name, you can pass a binding like this:
       ```javascript
      // Applies the 'urgent' class to the view element
      import Component from '@ember/component';
      Component.extend({
        classNameBindings: ['isUrgent:urgent'],
        isUrgent: true
      });
      ```
       If you would like to specify a class that should only be added when the
      property is false, you can declare a binding like this:
       ```javascript
      // Applies the 'disabled' class to the view element
      import Component from '@ember/component';
      Component.extend({
        classNameBindings: ['isEnabled::disabled'],
        isEnabled: false
      });
      ```
       This list of properties is inherited from the component's superclasses as well.
       @property classNameBindings
      @type Array
      @default []
      @public
    */
    classNameBindings: EMPTY_ARRAY
  });

  _exports.default = _default;
});
define("@ember/-internals/views/lib/mixins/text_support", ["exports", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/debug", "@ember/deprecated-features"], function (_exports, _metal, _runtime, _debug, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /**
  @module ember
  */
  var KEY_EVENTS = {
    13: 'insertNewline',
    27: 'cancel'
  };
  /**
    `TextSupport` is a shared mixin used by both `TextField` and
    `TextArea`. `TextSupport` adds a number of methods that allow you to
    specify a controller action to invoke when a certain event is fired on your
    text field or textarea. The specified controller action would get the current
    value of the field passed in as the only argument unless the value of
    the field is empty. In that case, the instance of the field itself is passed
    in as the only argument.
  
    Let's use the pressing of the escape key as an example. If you wanted to
    invoke a controller action when a user presses the escape key while on your
    field, you would use the `escape-press` attribute on your field like so:
  
    ```handlebars
      {{! application.hbs}}
  
      {{input escape-press='alertUser'}}
    ```
  
    ```javascript
        import Application from '@ember/application';
        import Controller from '@ember/controller';
        App = Application.create();
  
        App.ApplicationController = Controller.extend({
          actions: {
            alertUser: function ( currentValue ) {
              alert( 'escape pressed, current value: ' + currentValue );
            }
          }
        });
    ```
  
    The following chart is a visual representation of what takes place when the
    escape key is pressed in this scenario:
  
    ```
    The Template
    +---------------------------+
    |                           |
    | escape-press='alertUser'  |
    |                           |          TextSupport Mixin
    +----+----------------------+          +-------------------------------+
         |                                 | cancel method                 |
         |      escape button pressed      |                               |
         +-------------------------------> | checks for the `escape-press` |
                                           | attribute and pulls out the   |
         +-------------------------------+ | `alertUser` value             |
         |     action name 'alertUser'     +-------------------------------+
         |     sent to controller
         v
    Controller
    +------------------------------------------ +
    |           