/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.utils;

import java.util.HashSet;
import java.util.Set;

public class DSCatalogStripUtil {
    private static final char STRING_LITERAL_QUOTE = '\'';
    private static final char IDENT_BACK_TICK = '`';
    private static final char IDENT_QUOTE = '\"';
    private static final char IDENT_OPEN_BRACKET = '[';
    private static final char IDENT_CLOSE_BRACKET = ']';
    private static final char EMPTY_SPACE = ' ';
    private static final char SEPARATOR = '.';
    private static final int NUM_CST_DOT = 2;
    private static final Set<Character> s_eonTagSets = new HashSet<Character>();

    public static String generateCatalogPattern(String string) {
        if (null == string) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(" (");
        stringBuilder2.append(DSCatalogStripUtil.generatePartialRegex(stringBuilder, string));
        stringBuilder2.append(")");
        return stringBuilder2.toString();
    }

    public static String generateCatalogsPattern(String[] stringArray) {
        if (null == stringArray || 0 == stringArray.length) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : stringArray) {
            if (!bl) {
                bl = true;
                stringBuilder2.append(" (");
            } else {
                stringBuilder2.append("|");
            }
            stringBuilder2.append(DSCatalogStripUtil.generatePartialRegex(stringBuilder, string));
        }
        stringBuilder2.append(")");
        return stringBuilder2.toString();
    }

    public static String stripCatalog(String string, String string2) {
        try {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            char c = '`';
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (bl2 && c == c2) {
                    bl2 = false;
                    stringBuilder2.append(c2);
                    continue;
                }
                if (!bl2 && '\'' == c2) {
                    stringBuilder2.append(c2);
                    if (bl) {
                        stringBuilder.append(stringBuilder2.toString());
                        stringBuilder2.setLength(0);
                        n = 0;
                        bl = false;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (!(bl || bl2 || '`' != c2 && '\"' != c2 && '[' != c2)) {
                    bl2 = true;
                    c = '[' == c2 ? (char)']' : (char)c2;
                    stringBuilder2.append(c2);
                    continue;
                }
                if (!bl && !bl2 && s_eonTagSets.contains(Character.valueOf(c2))) {
                    stringBuilder2.append(c2);
                    stringBuilder.append(DSCatalogStripUtil.stripCatalogNameInSegment(stringBuilder2.toString(), string2, n));
                    stringBuilder2.setLength(0);
                    n = 0;
                    continue;
                }
                if (!bl && !bl2 && '.' == c2) {
                    stringBuilder2.append(c2);
                    ++n;
                    continue;
                }
                stringBuilder2.append(c2);
            }
            if (!bl && !bl2) {
                stringBuilder.append(DSCatalogStripUtil.stripCatalogNameInSegment(stringBuilder2.toString(), string2, n));
            } else {
                stringBuilder.append(stringBuilder2.toString());
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String generatePartialRegex(StringBuilder stringBuilder, String string) {
        if (null == stringBuilder || null == string || string.isEmpty()) {
            return "";
        }
        String string2 = string.toUpperCase();
        String string3 = string.toLowerCase();
        stringBuilder.setLength(0);
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append("[");
            stringBuilder.append(string2.charAt(i));
            stringBuilder.append(string3.charAt(i));
            stringBuilder.append("]");
        }
        String string4 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append(string4 + "\\.|");
        stringBuilder.append("\"" + string4 + "\"\\.|");
        stringBuilder.append("`" + string4 + "`\\.|");
        stringBuilder.append("\\[" + string4 + "\\]\\.");
        return stringBuilder.toString();
    }

    private static String stripCatalogNameInSegment(String string, String string2, int n) {
        String string3 = ' ' + string;
        if (2 == n) {
            return string3.replaceFirst(string2, "");
        }
        return string;
    }

    static {
        s_eonTagSets.add(Character.valueOf(' '));
        s_eonTagSets.add(Character.valueOf('('));
        s_eonTagSets.add(Character.valueOf('\n'));
        s_eonTagSets.add(Character.valueOf('\t'));
        s_eonTagSets.add(Character.valueOf('='));
        s_eonTagSets.add(Character.valueOf('<'));
        s_eonTagSets.add(Character.valueOf('>'));
        s_eonTagSets.add(Character.valueOf(','));
        s_eonTagSets.add(Character.valueOf('\r'));
        s_eonTagSets.add(Character.valueOf('\f'));
    }
}

