/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.core;

import com.simba.athena.dsi.core.impl.DSIConnection;
import com.simba.athena.dsi.core.impl.DSIDriver;
import com.simba.athena.dsi.core.interfaces.IEnvironment;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.exceptions.BadAttrValException;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.NumericOverflowException;
import com.simba.athena.dsi.utilities.DSIMessageKey;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;

public abstract class DSCommonConnection
extends DSIConnection {
    protected boolean m_ignoreTransactions = false;

    protected DSCommonConnection(IEnvironment iEnvironment) throws NumericOverflowException, ErrorException {
        super(iEnvironment);
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void rollback() throws ErrorException {
        if (!this.m_ignoreTransactions) {
            LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_ignoreTransactions) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
    }

    public void fakeTransactionSupport(char c) throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        this.m_ignoreTransactions = true;
        this.setProperty(136, new Variant(2, Character.valueOf(c)));
    }
}

