/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.dataengine.metadata.AJTableMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJMetadataHelperUtilities;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class AJTablesMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private AJClient m_client;
    private List<AJTableMetadata> m_tableMetadataList = new ArrayList<AJTableMetadata>();
    private ListIterator<AJTableMetadata> m_tableMetadataIterator;
    private AJTableMetadata m_currentTableMetadata;

    public AJTablesMetadataSource(ILogger iLogger, AJClient aJClient, ArrayList<IFilter> arrayList, String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient);
        this.m_client = aJClient;
        this.m_logger = iLogger;
        StringWrapperFilter stringWrapperFilter = null;
        StringWrapperFilter stringWrapperFilter2 = null;
        for (IFilter iFilter : arrayList) {
            switch (iFilter.getColumnTag()) {
                case SCHEMA_NAME: {
                    stringWrapperFilter = new StringWrapperFilter(iFilter);
                    break;
                }
                case TABLE_NAME: {
                    stringWrapperFilter2 = new StringWrapperFilter(iFilter);
                    break;
                }
            }
        }
        this.initMetadata(string, stringWrapperFilter, stringWrapperFilter2, string2);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_schemaName, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableName, dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableType, dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_remarks, dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_tableMetadataIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentTableMetadata = this.m_tableMetadataIterator.next();
            return true;
        }
        return false;
    }

    private void initMetadata(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, String string2) throws ErrorException {
        Iterator iterator;
        Object object;
        Object object22;
        Iterator iterator2;
        LogUtilities.logFunctionEntrance(this.m_logger, string, stringWrapperFilter, stringWrapperFilter2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null == string2 || string2.isEmpty()) {
            iterator2 = new ArrayList<AJSchemaMetadata>();
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                object22 = new ArrayList();
                object22 = this.m_client.getCatalogsWtihProxyApi();
                object = object22.iterator();
                while (object.hasNext()) {
                    iterator = (DataCatalogSummary)object.next();
                    AJMetadataHelperUtilities.getSchemasWithCatalogCheck(((DataCatalogSummary)((Object)iterator)).getCatalogName(), string, this.m_client, iterator2);
                }
            } else {
                AJMetadataHelperUtilities.getSchemasWithCatalogCheck("AwsDataCatalog", string, this.m_client, iterator2);
            }
            object22 = iterator2.iterator();
            while (object22.hasNext()) {
                object = (AJSchemaMetadata)object22.next();
                if (!stringWrapperFilter.filter(((AJSchemaMetadata)object).m_schemaName)) continue;
                arrayList.add(object);
            }
        } else if (null == string || string.isEmpty()) {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_client.getMetadataRetrievalMethod()) {
                iterator2 = new ArrayList();
                object22 = new ArrayList();
                object22 = this.m_client.getCatalogsWtihProxyApi();
                object = object22.iterator();
                while (object.hasNext()) {
                    iterator = (DataCatalogSummary)object.next();
                    AJMetadataHelperUtilities.getSchemasWithCatalogCheck(((DataCatalogSummary)((Object)iterator)).getCatalogName(), string, this.m_client, iterator2);
                }
                object = iterator2.iterator();
                while (object.hasNext()) {
                    iterator = (AJSchemaMetadata)object.next();
                    if (!stringWrapperFilter.filter(((AJSchemaMetadata)((Object)iterator)).m_schemaName)) continue;
                    arrayList.add(iterator);
                }
            } else {
                iterator2 = new AJSchemaMetadata("AwsDataCatalog", string2);
                arrayList.add(iterator2);
            }
        } else {
            iterator2 = new AJSchemaMetadata(string, string2);
            arrayList.add(iterator2);
        }
        for (Object object22 : arrayList) {
            object = new ArrayList();
            this.m_client.getTablesMetadata(((AJSchemaMetadata)object22).m_catalogName, ((AJSchemaMetadata)object22).m_schemaName, (List<AJTableMetadata>)object);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                AJTableMetadata aJTableMetadata = (AJTableMetadata)iterator.next();
                if (!stringWrapperFilter2.filter(aJTableMetadata.m_tableName)) continue;
                this.m_tableMetadataList.add(aJTableMetadata);
            }
        }
        this.m_tableMetadataIterator = this.m_tableMetadataList.listIterator(0);
    }
}

