/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.jdbc.utils.AbstractDoubleBufferManager;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.List;

public class AJDoubleBufferManager
extends AbstractDoubleBufferManager {
    private ILogger m_logger;
    private AJClient m_client;
    private AJExecutionContext m_execContext;

    protected AJDoubleBufferManager(ILogger iLogger, int n, AJClient aJClient, AJExecutionContext aJExecutionContext) {
        super(iLogger, n);
        LogUtilities.logFunctionEntrance(iLogger, n, aJClient, aJExecutionContext);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        this.m_execContext = aJExecutionContext;
    }

    public List<Row> getDataFromBuffer() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        AbstractDoubleBufferManager.BufferHolder bufferHolder = this.getFetchBuffer();
        return ((AJResultSetBuffer)bufferHolder.m_buffer).getResultRows();
    }

    @Override
    protected void fetchData(AbstractDoubleBufferManager.BufferHolder bufferHolder) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        AbstractDoubleBufferManager.BufferHolder bufferHolder2 = bufferHolder;
        if (this.m_execContext.m_hasMoreRows) {
            this.m_client.fetchRows(this.m_execContext, (AJResultSetBuffer)bufferHolder2.m_buffer);
            bufferHolder2.m_serverHasMoreRows = true;
        } else {
            bufferHolder2.m_serverHasMoreRows = false;
        }
    }

    @Override
    protected AbstractDoubleBufferManager.BufferHolder<AJResultSetBuffer> makeBuffer() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        AbstractDoubleBufferManager.BufferHolder<AJResultSetBuffer> bufferHolder = new AbstractDoubleBufferManager.BufferHolder<AJResultSetBuffer>();
        bufferHolder.m_buffer = new AJResultSetBuffer();
        return bufferHolder;
    }
}

