/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.lakeformation.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.lakeformation.model.DatabaseResource;

@SdkInternalApi
public class DatabaseResourceMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final DatabaseResourceMarshaller instance = new DatabaseResourceMarshaller();

    public static DatabaseResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatabaseResource databaseResource, ProtocolMarshaller protocolMarshaller) {
        if (databaseResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(databaseResource.getCatalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall(databaseResource.getName(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

