/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.WorkflowGraph;
import java.util.List;

@SdkInternalApi
public class WorkflowGraphMarshaller {
    private static final MarshallingInfo<List> NODES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nodes").build();
    private static final MarshallingInfo<List> EDGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Edges").build();
    private static final WorkflowGraphMarshaller instance = new WorkflowGraphMarshaller();

    public static WorkflowGraphMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkflowGraph workflowGraph, ProtocolMarshaller protocolMarshaller) {
        if (workflowGraph == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(workflowGraph.getNodes(), NODES_BINDING);
            protocolMarshaller.marshall(workflowGraph.getEdges(), EDGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

