/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.SessionCredentialsHolder;
import com.simba.athena.amazonaws.internal.SdkPredicate;
import java.util.Date;

@SdkInternalApi
@ThreadSafe
class ShouldDoBlockingSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final int EXPIRY_TIME_MILLIS = 60000;

    ShouldDoBlockingSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        return sessionCredentialsHolder == null || ShouldDoBlockingSessionRefresh.expiring(sessionCredentialsHolder.getSessionCredentialsExpiration());
    }

    private static boolean expiring(Date expiry) {
        long timeRemaining = expiry.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }
}

