/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceInfo;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiInputPort;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiTransmitter;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiSource
implements MidiDevice {
    private CoreMidiDeviceInfo info;
    private final AtomicBoolean isOpen;
    private final AtomicReference<CoreMidiInputPort> input;
    private final Set<CoreMidiTransmitter> transmitters;
    private int currentMessage = 0;
    private boolean currentDataIsSingleByte;
    private byte firstDataByte;
    private boolean wasFirstByteReceived = false;
    private Vector<byte[]> sysexMessageData;
    private int sysexMessageLength = 0;
    private long startTime;

    CoreMidiSource(CoreMidiDeviceInfo info) {
        this.info = info;
        this.input = new AtomicReference();
        this.isOpen = new AtomicBoolean(false);
        this.transmitters = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    void updateDeviceInfo(CoreMidiDeviceInfo info) {
        this.info = info;
    }

    @Override
    public void open() throws MidiUnavailableException {
        if (this.isOpen.compareAndSet(false, true)) {
            try {
                if (this.input.get() == null) {
                    this.input.set(CoreMidiDeviceProvider.getMIDIClient().inputPortCreate("Core Midi Provider Input"));
                }
                this.input.get().connectSource(this);
                this.startTime = this.getMicroSecondTime();
            }
            catch (CoreMidiException e) {
                e.printStackTrace();
                throw new MidiUnavailableException(e.getMessage());
            }
        }
    }

    @Override
    public void close() {
        if (this.isOpen.compareAndSet(true, false)) {
            try {
                if (this.input.get() != null) {
                    try {
                        this.input.get().disconnectSource(this);
                    }
                    finally {
                        this.input.set(null);
                    }
                }
                for (Transmitter transmitter : this.getTransmitters()) {
                    transmitter.close();
                }
            }
            catch (CoreMidiException e) {
                e.printStackTrace();
            }
        }
    }

    void deviceDisappeared() {
        this.input.set(null);
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.getMicroSecondTime() - this.startTime;
    }

    @Override
    public int getMaxReceivers() {
        return 0;
    }

    @Override
    public int getMaxTransmitters() {
        return -1;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        throw new MidiUnavailableException("CoreMidiSource has no receivers");
    }

    @Override
    public List<Receiver> getReceivers() {
        return Collections.emptyList();
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        CoreMidiTransmitter transmitter = new CoreMidiTransmitter(this);
        this.transmitters.add(transmitter);
        return transmitter;
    }

    void transmitterClosed(CoreMidiTransmitter transmitter) {
        this.transmitters.remove(transmitter);
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return Collections.unmodifiableList(new ArrayList<CoreMidiTransmitter>(this.transmitters));
    }

    private boolean isRealTimeMessage(byte status) {
        switch (status) {
            case -8: 
            case -6: 
            case -5: 
            case -4: 
            case -2: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    private boolean isRunningStatusMessage(int status) {
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 192: 
            case 208: 
            case 224: {
                return true;
            }
        }
        return false;
    }

    private int expectedDataLength(byte status) throws InvalidMidiDataException {
        switch (status & 0xFF) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return 0;
            }
            case 241: 
            case 243: {
                return 1;
            }
            case 242: {
                return 2;
            }
        }
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + status);
    }

    public void messageCallback(long coreTimestamp, int packetlength, byte[] data) throws InvalidMidiDataException {
        long timestamp;
        int offset = 0;
        long l = timestamp = coreTimestamp == 0L ? -1L : coreTimestamp - this.startTime;
        block5: while (offset < packetlength) {
            if (data[offset] >= 0) {
                if (this.currentMessage == 0) {
                    throw new InvalidMidiDataException("Data received outside of a message.");
                }
                if (this.currentMessage == 240) {
                    offset += this.processSysexData(packetlength, data, offset, timestamp);
                    continue;
                }
                if (this.currentDataIsSingleByte) {
                    this.transmitMessage(new ShortMessage(this.currentMessage, data[offset++], 0), timestamp);
                    if (this.isRunningStatusMessage(this.currentMessage)) continue;
                    this.currentMessage = 0;
                    continue;
                }
                if (this.wasFirstByteReceived) {
                    this.transmitMessage(new ShortMessage(this.currentMessage, this.firstDataByte, data[offset++]), timestamp);
                    this.wasFirstByteReceived = false;
                    if (this.isRunningStatusMessage(this.currentMessage)) continue;
                    this.currentMessage = 0;
                    continue;
                }
                this.firstDataByte = data[offset++];
                this.wasFirstByteReceived = true;
                continue;
            }
            if (this.isRealTimeMessage(data[offset])) {
                this.transmitMessage(new ShortMessage(data[offset++] & 0xFF), timestamp);
                continue;
            }
            if (data[offset] == -9) {
                if (this.currentMessage == 240) {
                    offset += this.processSysexData(packetlength, data, offset, timestamp);
                    continue;
                }
                throw new InvalidMidiDataException("Received End of Exclusive marker outside SYSEX message");
            }
            if (data[offset] == -16) {
                this.currentMessage = 240;
                this.sysexMessageLength = 0;
                this.sysexMessageData = new Vector();
                offset += this.processSysexData(packetlength, data, offset, timestamp);
                continue;
            }
            switch (this.expectedDataLength(data[offset])) {
                case 0: {
                    this.transmitMessage(new ShortMessage(data[offset++] & 0xFF), timestamp);
                    this.currentMessage = 0;
                    continue block5;
                }
                case 1: {
                    this.currentMessage = data[offset++] & 0xFF;
                    this.currentDataIsSingleByte = true;
                    continue block5;
                }
                case 2: {
                    this.currentMessage = data[offset++] & 0xFF;
                    this.currentDataIsSingleByte = false;
                    this.wasFirstByteReceived = false;
                    continue block5;
                }
            }
            throw new InvalidMidiDataException("Unexpected data length: " + this.expectedDataLength(data[offset]));
        }
    }

    private SysexMessage constructSysexMessage() throws InvalidMidiDataException {
        byte[] data = new byte[this.sysexMessageLength];
        int index = 0;
        for (byte[] sourceData : this.sysexMessageData) {
            System.arraycopy(sourceData, 0, data, index, sourceData.length);
            index += sourceData.length;
        }
        this.sysexMessageData = null;
        return new SysexMessage(data, this.sysexMessageLength);
    }

    private int processSysexData(int packetLength, byte[] sourceData, int startOffset, long timestamp) throws InvalidMidiDataException {
        int messageLength = 0;
        boolean foundEnd = false;
        while (startOffset + messageLength < packetLength) {
            byte latest;
            if ((latest = sourceData[startOffset + messageLength++]) >= 0 || messageLength + this.sysexMessageLength <= 1) continue;
            if (latest == -9) {
                this.currentMessage = 0;
                foundEnd = true;
                break;
            }
            if (this.isRealTimeMessage(latest)) {
                --messageLength;
                break;
            }
            --messageLength;
            foundEnd = true;
            break;
        }
        if (messageLength > 0) {
            byte[] data = new byte[messageLength];
            try {
                System.arraycopy(sourceData, startOffset, data, 0, messageLength);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                throw e;
            }
            this.sysexMessageData.add(data);
        }
        this.sysexMessageLength += messageLength;
        if (foundEnd) {
            this.transmitMessage(this.constructSysexMessage(), timestamp);
        }
        return messageLength;
    }

    private void transmitMessage(MidiMessage message, long timestamp) {
        for (Transmitter transmitter : this.getTransmitters()) {
            Receiver receiver = transmitter.getReceiver();
            if (receiver == null) continue;
            receiver.send(message, timestamp);
        }
    }

    private String getHexString(byte[] aByteArray) {
        StringBuffer sbuf = new StringBuffer(aByteArray.length * 3 + 2);
        for (byte aByte : aByteArray) {
            sbuf.append(' ');
            byte bhigh = (byte)((aByte & 0xF0) >> 4);
            sbuf.append((char)(bhigh > 9 ? bhigh + 65 - 10 : bhigh + 48));
            byte blow = (byte)(aByte & 0xF);
            sbuf.append((char)(blow > 9 ? blow + 65 - 10 : blow + 48));
        }
        return new String(sbuf).trim();
    }

    private native long getMicroSecondTime();

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }
}

