/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiInputPort;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiNotification;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiOutputPort;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiClient {
    private final int midiClientReference;
    private final Set<CoreMidiNotification> notificationListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private CoreMidiNotification mostRecentDeviceProvider = null;
    private final AtomicBoolean runningCallbacks = new AtomicBoolean(false);
    private final AtomicInteger callbackCount = new AtomicInteger(0);

    public CoreMidiClient(String name) throws CoreMidiException {
        this.midiClientReference = this.createClient(name);
    }

    public CoreMidiInputPort inputPortCreate(String name) throws CoreMidiException {
        return new CoreMidiInputPort(this.midiClientReference, name);
    }

    public CoreMidiOutputPort outputPortCreate(String name) throws CoreMidiException {
        return new CoreMidiOutputPort(this.midiClientReference, name);
    }

    private void deliverCallbackToListeners() {
        final int initialCallbackCount = this.callbackCount.get();
        if (this.runningCallbacks.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        int currentCallbackCount = initialCallbackCount;
                        while (currentCallbackCount > 0) {
                            Set<CoreMidiNotification> listeners = Collections.unmodifiableSet(new HashSet(CoreMidiClient.this.notificationListeners));
                            if (CoreMidiClient.this.mostRecentDeviceProvider != null) {
                                try {
                                    CoreMidiClient.this.mostRecentDeviceProvider.midiSystemUpdated();
                                }
                                catch (CoreMidiException e) {
                                    throw new RuntimeException("Problem delivering MIDI environment change notification to CoreMidiDeviceProvider", e);
                                }
                            }
                            for (CoreMidiNotification listener : listeners) {
                                try {
                                    listener.midiSystemUpdated();
                                }
                                catch (CoreMidiException e) {
                                    throw new RuntimeException("Problem delivering MIDI environment change notification", e);
                                }
                            }
                            CoreMidiClient coreMidiClient = CoreMidiClient.this;
                            synchronized (coreMidiClient) {
                                currentCallbackCount = CoreMidiClient.this.callbackCount.addAndGet(-currentCallbackCount);
                                if (currentCallbackCount < 1) {
                                    CoreMidiClient.this.runningCallbacks.set(false);
                                }
                            }
                        }
                        return;
                    }
                    finally {
                        CoreMidiClient.this.runningCallbacks.set(false);
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCallback() throws CoreMidiException {
        CoreMidiClient coreMidiClient = this;
        synchronized (coreMidiClient) {
            this.callbackCount.incrementAndGet();
            this.deliverCallbackToListeners();
        }
    }

    public void addNotificationListener(CoreMidiNotification listener) {
        if (listener != null) {
            if (listener instanceof CoreMidiDeviceProvider) {
                this.mostRecentDeviceProvider = listener;
            } else {
                this.notificationListeners.add(listener);
            }
        }
    }

    public void removeNotificationListener(CoreMidiNotification listener) {
        this.notificationListeners.remove(listener);
    }

    private native int createClient(String var1) throws CoreMidiException;

    private native void disposeClient(int var1) throws CoreMidiException;

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }
}

