/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.util;

import java.util.regex.Pattern;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextInputControl;

public class TextInputValidator
implements ChangeListener<String> {
    private final Pattern pattern;

    public TextInputValidator(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (!"".equals(newValue) && !this.pattern.matcher(newValue).matches()) {
            ((StringProperty)observable).setValue(oldValue);
        }
    }

    public static void limit(TextInputControl control, String regex) {
        control.textProperty().addListener((ChangeListener)new TextInputValidator(regex));
    }

    public static void limitToNumbers(TextInputControl control) {
        control.textProperty().addListener((ChangeListener)new TextInputValidator("\\d*"));
    }
}

