/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.util;

import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;

public class LogModel {
    private final SimpleStringProperty logMessage = new SimpleStringProperty();
    private final SimpleBooleanProperty shutdownSignal = new SimpleBooleanProperty();

    public void addShutdownListener(ChangeListener<? super Boolean> listener) {
        this.shutdownSignal.addListener(listener);
    }

    public SimpleStringProperty getLogMessageProperty() {
        return this.logMessage;
    }

    public synchronized void addLogMessage(String message) {
        Platform.runLater(() -> {
            String string = this.logMessage.get();
            StringBuilder sb = new StringBuilder();
            if (string != null) {
                sb.append(string);
            }
            this.logMessage.set(sb.append(message).append('\n').toString());
            System.out.println(message);
        });
    }

    public synchronized void clearLogMessage() {
        this.logMessage.set("");
    }

    public void shutdown() {
        this.shutdownSignal.set(true);
    }
}

