/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.util;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class FontCache {
    private Font baseFont;
    private Map<Double, Font> scaledFonts = new HashMap<Double, Font>();

    public FontCache() {
        this("monospace");
    }

    public FontCache(String baseName) {
        this(baseName, 0, 16);
    }

    public FontCache(String baseName, int baseStyle, int baseSize) {
        this.baseFont = new Font(baseName, baseStyle, baseSize);
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int size) {
        Font font = null;
        double scale = (double)size / (double)this.baseFont.getSize();
        Double s = scale;
        Map<Double, Font> map = this.scaledFonts;
        synchronized (map) {
            font = this.scaledFonts.get(s);
            if (font == null) {
                font = this.baseFont.deriveFont(AffineTransform.getScaleInstance(scale, scale));
                this.scaledFonts.put(s, font);
            }
        }
        return font;
    }
}

