/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.midi;

import de.mossgrabers.transformator.midi.MidiMessageHandler;
import de.mossgrabers.transformator.util.LogModel;
import java.util.HashSet;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public class MidiConnection {
    private static final Set<MidiDevice> USED_DEVICES = new HashSet<MidiDevice>(1);
    private MidiDevice midiInputDevice;
    private MidiDevice midiOutputDevice;
    private Receiver receiver;
    private Transmitter transmitter;
    private LogModel model;

    public MidiConnection(LogModel model) {
        this.model = model;
    }

    public void setOutput(MidiDevice device) {
        if (this.receiver != null) {
            this.receiver.close();
            this.receiver = null;
        }
        if (device == null) {
            return;
        }
        USED_DEVICES.add(device);
        try {
            this.midiOutputDevice = device;
            if (!this.midiOutputDevice.isOpen()) {
                this.midiOutputDevice.open();
            }
            this.receiver = this.midiOutputDevice.getReceiver();
        }
        catch (MidiUnavailableException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void setInput(MidiDevice device, MidiMessageHandler callback) {
        if (this.transmitter != null) {
            this.transmitter.close();
            this.transmitter = null;
        }
        if (device == null) {
            return;
        }
        USED_DEVICES.add(device);
        try {
            this.midiInputDevice = device;
            if (!this.midiInputDevice.isOpen()) {
                this.midiInputDevice.open();
            }
            this.transmitter = this.midiInputDevice.getTransmitter();
            this.transmitter.setReceiver(new InternalMidiReceiver(callback));
        }
        catch (MidiUnavailableException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void sendSysex(String data) {
        String[] parts = data.split(" ");
        byte[] bytes = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(parts[i], 16);
        }
        this.sendSysex(bytes);
    }

    public void sendSysex(byte[] data) {
        if (!this.isOutputOpen()) {
            return;
        }
        try {
            this.receiver.send(new SysexMessage(data, data.length), -1L);
        }
        catch (InvalidMidiDataException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void sendCC(int cc, int value) {
        if (!this.isOutputOpen()) {
            return;
        }
        try {
            this.receiver.send(new ShortMessage(176, cc, value), 0L);
        }
        catch (InvalidMidiDataException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void sendNote(int channel, int note, int velocity) {
        if (!this.isOutputOpen()) {
            return;
        }
        try {
            this.receiver.send(new ShortMessage(144 + channel, note, velocity), 0L);
        }
        catch (InvalidMidiDataException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void sendPitchbend(int value) {
        if (!this.isOutputOpen()) {
            return;
        }
        try {
            this.receiver.send(new ShortMessage(224, 0, value), 0L);
        }
        catch (InvalidMidiDataException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public void sendRaw(int status, int data1, int data2) {
        if (!this.isOutputOpen()) {
            return;
        }
        try {
            this.receiver.send(new ShortMessage(status, data1, data2), 0L);
        }
        catch (InvalidMidiDataException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }

    public boolean isOutputOpen() {
        return this.receiver != null && this.midiOutputDevice.isOpen();
    }

    public boolean isInputOpen() {
        return this.transmitter != null && this.midiInputDevice.isOpen();
    }

    public void cleanup() {
        if (this.receiver != null) {
            this.receiver.close();
        }
        if (this.transmitter != null) {
            Receiver r = this.transmitter.getReceiver();
            if (r != null) {
                r.close();
            }
            this.transmitter.setReceiver(null);
            this.transmitter.close();
        }
        if (this.midiInputDevice != null) {
            this.midiInputDevice.close();
            USED_DEVICES.remove(this.midiInputDevice);
        }
        if (this.midiOutputDevice != null) {
            this.midiOutputDevice.close();
            USED_DEVICES.remove(this.midiOutputDevice);
        }
    }

    public static void cleanupUnusedDevices() {
        for (MidiDevice device : USED_DEVICES) {
            device.close();
        }
    }

    private final class InternalMidiReceiver
    implements Receiver {
        private MidiMessageHandler callback;

        InternalMidiReceiver(MidiMessageHandler callback) {
            this.callback = callback;
        }

        @Override
        public void close() {
            this.callback = null;
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (this.callback != null) {
                this.callback.handleMidiMessage(message, timeStamp);
            }
        }
    }
}

