/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.midi;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;

public class Midi {
    private static final ObservableList<MidiDevice> INPUTS = FXCollections.observableArrayList();
    private static final ObservableList<MidiDevice> OUTPUTS = FXCollections.observableArrayList();

    public static void readDeviceMetadata() throws MidiUnavailableException {
        INPUTS.clear();
        OUTPUTS.clear();
        for (MidiDevice.Info info : CoreMidiDeviceProvider.getMidiDeviceInfo()) {
            MidiDevice device = MidiSystem.getMidiDevice(info);
            if (device.getMaxReceivers() != 0) {
                OUTPUTS.add((Object)device);
            }
            if (device.getMaxTransmitters() == 0) continue;
            INPUTS.add((Object)device);
        }
    }

    public static List<MidiDevice> getOutputDevices() {
        return OUTPUTS;
    }

    public static List<MidiDevice> getInputDevices() {
        return INPUTS;
    }

    public static MidiDevice getOutputDevice(String name) {
        for (MidiDevice device : OUTPUTS) {
            if (!device.getDeviceInfo().getName().equals(name)) continue;
            return device;
        }
        return null;
    }

    public static MidiDevice getInputDevice(String name) {
        for (MidiDevice device : INPUTS) {
            if (!device.getDeviceInfo().getName().equals(name)) continue;
            return device;
        }
        return null;
    }
}

