/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.communication;

import de.mossgrabers.transformator.communication.MessageServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketServer
extends Thread {
    private static SocketServer socketServer = null;
    private Socket socket = null;
    private ServerSocket serverSocket = null;
    private MessageServer tcpServer;
    private BufferedInputStream in;
    private boolean disonnected = false;
    private boolean stop = false;

    private SocketServer(MessageServer tcpServer, ServerSocket socket) {
        super("SocketServer");
        this.tcpServer = tcpServer;
        this.serverSocket = socket;
        this.setStop(false);
        this.setDisconnected(false);
        this.start();
    }

    public synchronized void setDisconnected(boolean doDisconnect) {
        if (this.socket != null && doDisconnect) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.tcpServer.log("Error closing client: " + ex.getLocalizedMessage());
            }
        }
        this.disonnected = doDisconnect;
    }

    public synchronized void setStop(boolean doStop) {
        this.stop = doStop;
        if (this.serverSocket != null && doStop) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                this.tcpServer.log("Error closing server: " + ex.getLocalizedMessage());
            }
        }
    }

    public static synchronized SocketServer handle(MessageServer tcpServer, ServerSocket serverSocket) {
        if (socketServer == null) {
            socketServer = new SocketServer(tcpServer, serverSocket);
        } else {
            if (SocketServer.socketServer.serverSocket != null) {
                try {
                    socketServer.setDisconnected(true);
                    socketServer.setStop(true);
                    if (SocketServer.socketServer.socket != null) {
                        SocketServer.socketServer.socket.close();
                    }
                    if (SocketServer.socketServer.serverSocket != null) {
                        SocketServer.socketServer.serverSocket.close();
                    }
                }
                catch (IOException ex) {
                    tcpServer.log(ex.getLocalizedMessage());
                }
            }
            SocketServer.socketServer.serverSocket = null;
            SocketServer.socketServer.socket = null;
            socketServer = new SocketServer(tcpServer, serverSocket);
        }
        return socketServer;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.socket = this.serverSocket.accept();
            }
            catch (Exception ex) {
                if (this.stop) continue;
                this.tcpServer.log("Error acception connection: " + ex.getLocalizedMessage());
                this.stop = true;
                continue;
            }
            this.startServer();
            if (this.socket == null) continue;
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.tcpServer.log("Error closing client socket: " + ex.getLocalizedMessage());
            }
            this.socket = null;
            this.tcpServer.setClientSocket(this.socket);
        }
    }

    private void startServer() {
        this.tcpServer.setClientSocket(this.socket);
        InputStream is = null;
        try {
            is = this.socket.getInputStream();
            this.in = new BufferedInputStream(is);
        }
        catch (IOException ex) {
            this.tcpServer.log("Cound't open input stream on client " + ex.getLocalizedMessage());
            this.setDisconnected(true);
            return;
        }
        while (true) {
            String rec;
            try {
                rec = SocketServer.readInputStream(this.in);
            }
            catch (IOException ex) {
                this.setDisconnected(true);
                if (this.disonnected) {
                    this.tcpServer.log("Server closed client connection: " + ex.getLocalizedMessage());
                    break;
                }
                this.tcpServer.log("Lost client connection: " + ex.getLocalizedMessage());
                break;
            }
            if (rec == null) {
                this.setDisconnected(true);
                break;
            }
            this.tcpServer.handleCommand(rec);
        }
    }

    private static String readInputStream(BufferedInputStream inputStream) throws IOException {
        int s = inputStream.read();
        if (s == -1) {
            return null;
        }
        int len = inputStream.available();
        StringBuilder data = new StringBuilder(len + 1).append((char)s);
        if (len > 0) {
            byte[] byteData = new byte[len];
            inputStream.read(byteData);
            data.append(new String(byteData));
        }
        return data.toString();
    }
}

