/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.communication;

import com.illposed.osc.OSCMessage;
import de.mossgrabers.transformator.communication.MessageHandler;
import de.mossgrabers.transformator.communication.SocketServer;
import de.mossgrabers.transformator.util.LogModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.SimpleBooleanProperty;

public class MessageServer {
    private static final int SEND_QUEUE_LIMIT = 1000;
    private final LogModel model;
    private final String name;
    private final MessageHandler oscHandler;
    private Socket socket;
    private ServerSocket server;
    private SocketServer socketServer;
    private PrintWriter out;
    private final Object socketLock = new Object();
    private final AtomicBoolean stopSenderSignal = new AtomicBoolean(false);
    private final SimpleBooleanProperty isClientConnected = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isServerRunning = new SimpleBooleanProperty(false);
    final List<String> sendQueue = Collections.synchronizedList(new LinkedList<String>(){
        private static final long serialVersionUID = -474936912885881812L;

        @Override
        public boolean add(String message) {
            if (this.size() > 1000) {
                this.remove(0);
            }
            return super.add(message);
        }
    });

    public MessageServer(String name, LogModel model, MessageHandler oscHandler) {
        this.name = name;
        this.model = model;
        this.oscHandler = oscHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String ip, int port) {
        this.stop();
        try {
            InetAddress bindAddr = ip.equals("0.0.0.0") ? InetAddress.getByName(ip) : null;
            this.model.addLogMessage("Starting " + this.name + " at port: " + port);
            Object object = this.socketLock;
            synchronized (object) {
                this.server = new ServerSocket(port, 1, bindAddr);
                this.socketServer = SocketServer.handle(this, this.server);
                this.isServerRunning.set(true);
            }
            this.startSender();
        }
        catch (IOException ex) {
            this.model.addLogMessage("Could not start " + this.name + ": " + ex.getLocalizedMessage());
            this.isServerRunning.set(false);
            return;
        }
    }

    private void startSender() {
        this.stopSenderSignal.set(false);
        new Thread(() -> {
            while (true) {
                this.internalSendMessages();
                if (this.stopSenderSignal.get()) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
        }).start();
    }

    private void stopSender() {
        this.stopSenderSignal.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.server == null) {
                return;
            }
            this.stopSender();
            this.socketServer.setDisconnected(true);
            this.socketServer.setStop(true);
            this.server = null;
            this.isServerRunning.set(false);
        }
        this.model.addLogMessage("Stopped " + this.name + '.');
    }

    public void sendMessage(String message) {
        this.sendQueue.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalSendMessages() {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket == null) {
                return;
            }
            if (this.sendQueue.isEmpty()) {
                return;
            }
            try {
                if (this.out == null) {
                    this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
                }
                while (!this.sendQueue.isEmpty()) {
                    String message = this.sendQueue.remove(0);
                    this.out.print(message + '\n');
                }
                this.out.flush();
            }
            catch (IOException ex) {
                this.model.addLogMessage("Could not send message via " + this.name + ": " + ex.getLocalizedMessage());
                this.socketServer.setDisconnected(true);
            }
        }
    }

    public void log(String message) {
        this.model.addLogMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientSocket(Socket socket) {
        Object object = this.socketLock;
        synchronized (object) {
            if (socket == null) {
                this.out = null;
                this.socket = null;
            } else {
                this.socket = socket;
            }
            this.isClientConnected.set(this.socket != null);
        }
    }

    public void handleCommand(String line) {
        for (String command : line.split("\n")) {
            String[] split = command.split(" ");
            String params = split.length == 1 ? null : command.substring(split[0].length() + 1);
            try {
                this.oscHandler.handle(new OSCMessage(split[0], Collections.singleton(params)));
            }
            catch (IllegalArgumentException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.log(sw.toString());
            }
        }
    }

    public SimpleBooleanProperty getIsClientConnectedProperty() {
        return this.isClientConnected;
    }

    public SimpleBooleanProperty getIsServerRunningProperty() {
        return this.isServerRunning;
    }
}

