/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator.communication;

import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.reaper.framework.daw.AbstractTrackBankImpl;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.BrowserImpl;
import de.mossgrabers.reaper.framework.daw.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.GrooveImpl;
import de.mossgrabers.reaper.framework.daw.ProjectImpl;
import de.mossgrabers.reaper.framework.daw.TransportImpl;
import de.mossgrabers.reaper.framework.daw.data.ChannelImpl;
import de.mossgrabers.reaper.framework.daw.data.ParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.SendImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class MessageParser {
    private final IControllerSetup controllerSetup;
    private final IHost host;
    private final IProject project;
    private final ApplicationImpl application;
    private final IMasterTrack masterTrack;
    private final TransportImpl transport;
    private final IValueChanger valueChanger;
    private final CursorDeviceImpl cursorDevice;
    private final IBrowser browser;
    private final GrooveImpl groove;
    private IModel model;

    public MessageParser(IControllerSetup controllerSetup) {
        this.controllerSetup = controllerSetup;
        this.model = controllerSetup.getModel();
        this.host = this.model.getHost();
        this.project = this.model.getProject();
        this.application = (ApplicationImpl)this.model.getApplication();
        this.transport = (TransportImpl)this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        this.valueChanger = this.model.getValueChanger();
        this.cursorDevice = (CursorDeviceImpl)this.model.getCursorDevice();
        this.browser = this.model.getBrowser();
        this.groove = (GrooveImpl)this.model.getGroove();
    }

    public void parseOSC(String osc, String value) {
        Queue<String> parts = MessageParser.parsePath(osc);
        if (parts == null) {
            return;
        }
        String command = parts.poll();
        if (this.parseTransport(command, parts, value)) {
            return;
        }
        block10 : switch (command) {
            case "project": {
                String projectCmd;
                switch (projectCmd = parts.poll()) {
                    case "name": {
                        ((ProjectImpl)this.project).setName(value);
                        break block10;
                    }
                    case "engine": {
                        this.application.setInternalEngineActive(Integer.parseInt(value) > 0);
                        break block10;
                    }
                }
                this.host.error("Unhandled Project parameter: " + projectCmd);
                break;
            }
            case "track": {
                this.parseTrack(parts, value);
                break;
            }
            case "master": {
                this.parseTrackValue(this.masterTrack, parts, value);
                break;
            }
            case "device": {
                this.parseDevice(value, parts);
                break;
            }
            case "clip": {
                this.parseClipValue(parts, value);
                break;
            }
            case "browser": {
                this.parseBrowserValue(parts, value);
                break;
            }
            case "groove": {
                this.parseGrooveValue(parts, value);
                break;
            }
            case "quantize": {
                if (!"strength".equals(parts.poll())) break;
                this.controllerSetup.getConfiguration().setQuantizeAmount(Integer.parseInt(value));
                break;
            }
            default: {
                this.host.error("Unhandled OSC address: " + osc + " " + value);
                return;
            }
        }
    }

    private boolean parseTransport(String command, Queue<String> parts, String value) {
        switch (command) {
            case "click": {
                this.transport.setMetronome(Double.parseDouble(value) > 0.0);
                break;
            }
            case "preroll": {
                this.transport.setInternalPreroll((int)Double.parseDouble(value));
                break;
            }
            case "prerollClick": {
                this.transport.setPrerollClick(Integer.parseInt(value) > 0);
                break;
            }
            case "play": {
                this.transport.setPlayState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "stop": {
                this.transport.setPlayState(Double.parseDouble(value) == 0.0);
                break;
            }
            case "repeat": {
                this.transport.setLoopingState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "record": {
                this.transport.setRecordState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "tempo": {
                this.transport.setTempo(Double.parseDouble(value));
                break;
            }
            case "time": {
                if (parts.isEmpty()) {
                    this.transport.setPosition(Double.parseDouble(value));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                this.transport.setPositionText(value);
                break;
            }
            case "beat": {
                this.transport.setBeats(value);
                break;
            }
            case "numerator": {
                int numerator = (int)Double.parseDouble(value);
                if (numerator <= 0) break;
                this.transport.setNumerator(numerator);
                break;
            }
            case "denominator": {
                int denominator = (int)Double.parseDouble(value);
                if (denominator <= 0) break;
                this.transport.setDenominator(denominator);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void parseTrack(Queue<String> parts, String value) {
        ITrackBank tb = this.model.getTrackBank();
        String part = parts.poll();
        try {
            this.parseTrackValue(tb.getTrack(Integer.parseInt(part) - 1), parts, value);
        }
        catch (NumberFormatException ex) {
            switch (part) {
                case "count": {
                    ((AbstractTrackBankImpl)((Object)tb)).setTrackCount(Integer.parseInt(value));
                    break;
                }
                default: {
                    this.host.error("Unhandled Track command: " + part);
                    return;
                }
            }
        }
    }

    private void parseTrackValue(ITrack track, Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "exists": {
                ((TrackImpl)track).setExists(Double.parseDouble(value) > 0.0);
                break;
            }
            case "active": {
                ((TrackImpl)track).setInternalIsActivated(Double.parseDouble(value) > 0.0);
                break;
            }
            case "type": {
                ((TrackImpl)track).setType(ChannelType.valueOf(value));
                break;
            }
            case "select": {
                int index = track.getIndex();
                if (index == -1) {
                    track.setSelected(Double.parseDouble(value) > 0.0);
                    break;
                }
                ((AbstractTrackBankImpl)this.model.getCurrentTrackBank()).handleBankTrackSelection(index, Double.parseDouble(value) > 0.0);
                break;
            }
            case "number": {
                ((TrackImpl)track).setPosition(Integer.parseInt(value));
                break;
            }
            case "name": {
                ((ChannelImpl)((Object)track)).setName(value);
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    ((ChannelImpl)((Object)track)).setInternalVolume(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                ((ChannelImpl)((Object)track)).setVolumeStr(value);
                break;
            }
            case "pan": {
                if (parts.isEmpty()) {
                    ((ChannelImpl)((Object)track)).setInternalPan(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                ((ChannelImpl)((Object)track)).setPanStr(value);
                break;
            }
            case "vuleft": {
                ((ChannelImpl)((Object)track)).setVuLeft(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                break;
            }
            case "vuright": {
                ((ChannelImpl)((Object)track)).setVuRight(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                break;
            }
            case "mute": {
                ((ChannelImpl)((Object)track)).setMuteState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "solo": {
                ((ChannelImpl)((Object)track)).setSoloState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "recarm": {
                ((TrackImpl)track).setRecArmState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "monitor": {
                ((TrackImpl)track).setMonitorState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "autoMonitor": {
                ((TrackImpl)track).setAutoMonitorState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "automode": {
                switch ((int)Double.parseDouble(value)) {
                    case 0: {
                        ((TrackImpl)track).setAutomation("trim");
                        break;
                    }
                    case 1: {
                        ((TrackImpl)track).setAutomation("read");
                        break;
                    }
                    case 2: {
                        ((TrackImpl)track).setAutomation("touch");
                        break;
                    }
                    case 3: {
                        ((TrackImpl)track).setAutomation("write");
                        break;
                    }
                    case 4: {
                        ((TrackImpl)track).setAutomation("latch");
                    }
                }
                break;
            }
            case "color": {
                String[] values = value.split(" ");
                if (values.length != 3) {
                    this.host.error("Color: Wrong number of arguments: " + values.length);
                    StringBuilder str = new StringBuilder();
                    for (String value2 : values) {
                        str.append(value2).append(':');
                    }
                    this.host.error(str.toString());
                    return;
                }
                ((TrackImpl)track).setColorState(new double[]{Double.parseDouble(values[0]) / 255.0, Double.parseDouble(values[1]) / 255.0, Double.parseDouble(values[2]) / 255.0});
                break;
            }
            case "send": {
                int sendIndex;
                if (parts.isEmpty() || (sendIndex = Integer.parseInt(parts.poll()) - 1) >= this.model.getTrackBank().getNumSends()) break;
                this.parseSendValue(track.getSend(sendIndex), parts, value);
                break;
            }
            case "repeatActive": {
                ((TrackImpl)track).setInternalRepeat(Double.parseDouble(value) > 0.0);
                break;
            }
            case "noterepeatlength": {
                ((TrackImpl)track).setInternalRepeatNoteLength(Integer.parseInt(value));
                break;
            }
            default: {
                this.host.error("Unhandled Track Parameter: " + command);
            }
        }
    }

    private void parseSendValue(ISend send, Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "name": {
                ((SendImpl)send).setName(value);
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    ((SendImpl)send).setInternalValue(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                ((SendImpl)send).setValueStr(value);
                break;
            }
            default: {
                this.host.error("Unhandled Send command: " + command);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseDevice(String value, Queue<String> parts) {
        String command;
        switch (command = parts.poll()) {
            case "count": {
                this.cursorDevice.setDeviceCount(Integer.parseInt(value));
                return;
            }
            case "exists": {
                this.cursorDevice.setExists(Integer.parseInt(value) > 0);
                return;
            }
            case "position": {
                this.cursorDevice.setPosition(Integer.parseInt(value));
                return;
            }
            case "bypass": {
                this.cursorDevice.setEnabled(Integer.parseInt(value) == 0);
                return;
            }
            case "name": {
                this.cursorDevice.setName(value);
                return;
            }
            case "window": {
                this.cursorDevice.setWindowOpen(Double.parseDouble(value) > 0.0);
                return;
            }
            case "expand": {
                this.cursorDevice.setExpanded(Double.parseDouble(value) > 0.0);
                return;
            }
            case "sibling": {
                try {
                    int siblingNo = Integer.parseInt(parts.poll()) - 1;
                    switch (parts.poll()) {
                        case "name": {
                            this.cursorDevice.setSiblingDeviceName(siblingNo, value);
                            return;
                        }
                    }
                    this.host.error("Unhandled device sibling parameter: " + command);
                    return;
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
            case "param": {
                String cmd = parts.poll();
                try {
                    int paramNo = Integer.parseInt(cmd) - 1;
                    this.parseDeviceParamValue(this.cursorDevice.getFXParam(paramNo), parts, value);
                    return;
                }
                catch (NumberFormatException ex) {
                    switch (cmd) {
                        case "count": {
                            this.cursorDevice.setParameterCount(Integer.parseInt(value));
                            return;
                        }
                        case "bank": {
                            if (parts.isEmpty()) {
                                this.host.error("Missing Device Param Bank parameter.");
                                return;
                            }
                            String bankCmd = parts.poll();
                            if ("selected".equals(bankCmd)) {
                                this.cursorDevice.setSelectedParameterPage(Integer.parseInt(value) - 1);
                                return;
                            }
                            this.host.error("Unhandled Device Param Bank parameter: " + cmd);
                            return;
                        }
                        default: {
                            this.host.error("Unhandled Device Param parameter: " + cmd);
                            return;
                        }
                    }
                }
            }
            default: {
                this.host.error("Unhandled device parameter: " + command);
                return;
            }
        }
    }

    private void parseDeviceParamValue(IParameter param, Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "name": {
                ((ParameterImpl)param).setName(value);
                break;
            }
            case "value": {
                if (parts.isEmpty()) {
                    ((ParameterImpl)param).setInternalValue(this.valueChanger.fromNormalizedValue(Double.parseDouble(value)));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                ((ParameterImpl)param).setValueStr(value);
                break;
            }
            default: {
                this.host.error("Unhandled FX Param Value: " + command);
            }
        }
    }

    private void parseBrowserValue(Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "result": {
                int resultNo = Integer.parseInt(parts.poll()) - 1;
                switch (parts.poll()) {
                    case "name": {
                        ((BrowserImpl)this.browser).setPreset(resultNo, value == null || value.isEmpty() ? null : value);
                    }
                }
                break;
            }
            case "selected": {
                switch (parts.poll()) {
                    case "name": {
                        break;
                    }
                    case "index": {
                        ((BrowserImpl)this.browser).setPresetSelected(Integer.parseInt(value));
                    }
                }
                break;
            }
            default: {
                this.host.error("Unhandled Browser Parameter: " + command);
            }
        }
    }

    private void parseClipValue(Queue<String> parts, String value) {
        String command;
        ICursorClip clip = this.model.getCursorClip();
        switch (command = parts.poll()) {
            case "start": {
                clip.setPlayStart(Double.parseDouble(value));
                break;
            }
            case "end": {
                clip.setPlayEnd(Double.parseDouble(value));
                break;
            }
            case "loopStart": {
                break;
            }
            case "loopEnd": {
                break;
            }
            default: {
                this.host.error("Unhandled Clip Parameter: " + command);
            }
        }
    }

    private void parseGrooveValue(Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "strength": {
                this.groove.setParameter(0, Integer.parseInt(value));
                break;
            }
            case "velocity": {
                this.groove.setParameter(1, Integer.parseInt(value));
                break;
            }
            case "target": {
                this.groove.setParameter(2, Integer.parseInt(value));
                break;
            }
            case "tolerance": {
                this.groove.setParameter(3, Integer.parseInt(value));
                break;
            }
            default: {
                this.host.error("Unhandled Groove Parameter: " + command);
            }
        }
    }

    private static Queue<String> parsePath(String osc) {
        String[] parts = osc.split("/");
        ArrayBlockingQueue<String> oscParts = new ArrayBlockingQueue<String>(parts.length);
        Collections.addAll(oscParts, parts);
        if (oscParts.size() < 2) {
            return null;
        }
        oscParts.poll();
        return oscParts;
    }
}

