/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator;

import com.illposed.osc.OSCMessage;
import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.reaper.controller.ControllerInstanceManager;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.transformator.MainConfiguration;
import de.mossgrabers.transformator.communication.MessageHandler;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.communication.MessageServer;
import de.mossgrabers.transformator.midi.Midi;
import de.mossgrabers.transformator.midi.MidiConnection;
import de.mossgrabers.transformator.util.LogModel;
import de.mossgrabers.transformator.util.TextInputValidator;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiUnavailableException;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class TransformatorApplication
extends Application
implements MessageHandler,
MessageSender {
    protected final SimpleStringProperty title = new SimpleStringProperty();
    protected final LogModel logModel = new LogModel();
    protected final MainConfiguration mainConfiguration = new MainConfiguration();
    protected Stage stage;
    private final TextField applicationCommand = new TextField();
    private final CheckBox runAutomatically = new CheckBox("Auto-run");
    private final CheckBox enablePreviewBox = new CheckBox();
    private final TextField tcpPortField = new TextField();
    private final ListView<IControllerInstance> controllerList = new ListView();
    private ControllerInstanceManager instanceManager;
    private TrayIcon trayIcon;
    private SystemTray tray;
    private AnimationTimer animationTimer;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final MessageServer oscServer = new MessageServer("Reaper communication server", this.logModel, this);

    public void start(Stage stage) {
        this.stage = stage;
        this.instanceManager = new ControllerInstanceManager(this.logModel, (Window)stage, this);
        if (SystemTray.isSupported()) {
            this.stage.initStyle(StageStyle.UTILITY);
            Platform.setImplicitExit((boolean)false);
            Platform.runLater(this::addAppToTray);
        }
        this.setTitle();
        this.loadConfig();
        Scene scene = this.createUI();
        this.logModel.addShutdownListener((ChangeListener<? super Boolean>)((ChangeListener)(observable, oldValue, newValue) -> this.exit()));
        this.showStage(stage, scene);
        this.startup();
        Platform.runLater(this::startupInfrastructure);
    }

    protected void startup() {
        this.initUSB();
    }

    protected void initUSB() {
        try {
            int result = LibUsb.init(null);
            if (result != 0) {
                throw new LibUsbException("Unable to initialize libusb.", result);
            }
        }
        catch (LibUsbException ex) {
            this.logModel.addLogMessage(ex.getLocalizedMessage());
        }
    }

    protected Scene createUI() {
        GridPane topPane = new GridPane();
        topPane.getStyleClass().addAll((Object[])new String[]{"grid", "padding"});
        Label dawPathLabel = new Label("DAW Path:");
        dawPathLabel.setAlignment(Pos.CENTER_RIGHT);
        dawPathLabel.setLabelFor((Node)this.applicationCommand);
        GridPane.setHgrow((Node)this.applicationCommand, (Priority)Priority.ALWAYS);
        this.runAutomatically.setTooltip(new Tooltip("If the DAW path is configured correctly Reaper is automatically started. Furthermore, the app starts minimized."));
        this.runAutomatically.setOnAction(e -> this.mainConfiguration.setRunAutomatically(this.runAutomatically.isSelected()));
        Button selectFileButton = new Button("...");
        selectFileButton.setMaxWidth(Double.MAX_VALUE);
        selectFileButton.setOnAction(e -> this.selectDAWExecutable());
        Button runButton = new Button("Run");
        runButton.setMaxWidth(Double.MAX_VALUE);
        runButton.setOnAction(e -> this.runDAW());
        topPane.add((Node)dawPathLabel, 0, 0);
        topPane.add((Node)this.applicationCommand, 1, 0);
        topPane.add((Node)selectFileButton, 2, 0);
        topPane.add((Node)runButton, 3, 0);
        topPane.add((Node)this.runAutomatically, 4, 0);
        Label displayPortLabel = new Label("Communication Port:");
        displayPortLabel.setAlignment(Pos.CENTER_RIGHT);
        displayPortLabel.setLabelFor((Node)this.tcpPortField);
        GridPane.setHgrow((Node)this.tcpPortField, (Priority)Priority.ALWAYS);
        TextInputValidator.limitToNumbers((TextInputControl)this.tcpPortField);
        Button applyButton = new Button("Apply");
        applyButton.setMaxWidth(Double.MAX_VALUE);
        applyButton.setOnAction(e -> this.applyTCPPort());
        Button refreshButton = new Button("Refresh");
        refreshButton.setMaxWidth(Double.MAX_VALUE);
        refreshButton.setOnAction(event -> this.sendRefreshCommand());
        CheckBox tcpConnectionBox = new CheckBox("TCP connected");
        tcpConnectionBox.setDisable(true);
        tcpConnectionBox.selectedProperty().bind((ObservableValue)this.oscServer.getIsClientConnectedProperty());
        topPane.add((Node)displayPortLabel, 0, 1);
        topPane.add((Node)this.tcpPortField, 1, 1);
        topPane.add((Node)applyButton, 2, 1);
        topPane.add((Node)refreshButton, 3, 1);
        topPane.add((Node)tcpConnectionBox, 4, 1);
        Button configButton = new Button("Configuration");
        configButton.setOnAction(event -> this.editController());
        configButton.setMaxWidth(Double.MAX_VALUE);
        MenuButton addButton = new MenuButton("Add");
        this.configureAddButton(addButton);
        addButton.setMaxWidth(Double.MAX_VALUE);
        Button removeButton = new Button("Remove");
        removeButton.setOnAction(event -> this.removeController());
        removeButton.setMaxWidth(Double.MAX_VALUE);
        VBox deviceButtonContainer = new VBox(new Node[]{addButton, removeButton, configButton});
        deviceButtonContainer.getStyleClass().add((Object)"configurationButtons");
        this.controllerList.setMinWidth(300.0);
        BorderPane controllerConfigurationPane = new BorderPane(this.controllerList, (Node)new Label("Controller:"), (Node)deviceButtonContainer, null, null);
        controllerConfigurationPane.getStyleClass().add((Object)"configuration");
        TextArea loggingTextArea = new TextArea();
        loggingTextArea.textProperty().bind((ObservableValue)this.logModel.getLogMessageProperty());
        Label loggingAreaLabel = new Label("Logging:");
        this.createDefaultMenuItems((TextInputControl)loggingTextArea);
        BorderPane loggingPane = new BorderPane((Node)loggingTextArea, (Node)loggingAreaLabel, null, null, null);
        loggingPane.getStyleClass().add((Object)"logging");
        BorderPane centerPane = new BorderPane((Node)loggingPane, null, null, null, (Node)controllerConfigurationPane);
        BorderPane root = new BorderPane((Node)centerPane, (Node)topPane, null, null, null);
        Scene scene = new Scene((Parent)root, (Paint)Color.TRANSPARENT);
        scene.getStylesheets().add((Object)"css/DefaultStyles.css");
        return scene;
    }

    public void stop() throws Exception {
        this.logModel.addLogMessage("Shutting down...");
        if (this.animationTimer != null) {
            this.logModel.addLogMessage("Stopping flush timer...");
            this.animationTimer.stop();
        }
        this.executor.shutdown();
        this.instanceManager.stopAll();
        SVGImage.clearCache();
        this.logModel.addLogMessage("Storing configuration...");
        this.instanceManager.save(this.mainConfiguration);
        this.saveConfig();
        this.logModel.addLogMessage("Stopping OSC...");
        this.oscServer.stop();
        MidiConnection.cleanupUnusedDevices();
        this.logModel.addLogMessage("Shutting down USB...");
        LibUsb.exit(null);
        System.exit(0);
    }

    public void exit() {
        this.logModel.addLogMessage("Exiting platform...");
        Platform.exit();
        if (this.tray != null && this.trayIcon != null) {
            this.tray.remove(this.trayIcon);
        }
    }

    protected void setTitle() {
        String implementationVersion;
        StringBuilder sb = new StringBuilder("DrivenByMoss 4 Reaper");
        Package p = Package.getPackage("transformator");
        if (p != null && (implementationVersion = p.getImplementationVersion()) != null) {
            sb.append(" v").append(implementationVersion);
        }
        this.title.set(sb.toString());
    }

    protected void showStage(Stage stage, Scene scene) {
        stage.minWidthProperty().set(820.0);
        stage.minHeightProperty().set(300.0);
        stage.titleProperty().bind((ObservableValue)this.title);
        InputStream rs = ClassLoader.getSystemResourceAsStream("images/AppIcon.gif");
        if (rs != null) {
            stage.getIcons().add((Object)new Image(rs));
        }
        stage.setScene(scene);
        if (!SystemTray.isSupported() || !this.mainConfiguration.isRunAutomatically()) {
            stage.show();
        }
    }

    protected void loadConfig() {
        try {
            this.mainConfiguration.load();
        }
        catch (IOException ex) {
            this.logModel.addLogMessage("Could not load main configuration: " + ex.getLocalizedMessage());
        }
        this.mainConfiguration.restoreStagePlacement(this.stage);
        this.enablePreviewBox.setSelected(this.mainConfiguration.isPreviewEnabled());
        this.applicationCommand.setText(this.mainConfiguration.getApplicationCommand());
        this.runAutomatically.setSelected(this.mainConfiguration.isRunAutomatically());
        this.tcpPortField.setText(Integer.toString(this.mainConfiguration.getTcpPort()));
        SVGImage.clearCache();
        if (this.runAutomatically.isSelected()) {
            this.runDAW();
        }
    }

    protected void saveConfig() {
        try {
            this.mainConfiguration.setApplicationCommand(this.applicationCommand.getText());
            this.mainConfiguration.storeStagePlacement(this.stage);
            this.mainConfiguration.save();
        }
        catch (IOException ex) {
            String message = "Could not store configuration file: " + ex.getLocalizedMessage();
            this.logModel.addLogMessage(message);
            this.message(message);
        }
    }

    private void selectDAWExecutable() {
        File file;
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Select the DAW executable file");
        if (OperatingSystem.get() == OperatingSystem.WINDOWS) {
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Executable", new String[]{"*.exe"});
            chooser.getExtensionFilters().add((Object)filter);
        }
        if ((file = chooser.showOpenDialog((Window)this.stage)) != null) {
            this.applicationCommand.setText(file.getAbsolutePath());
        }
    }

    private void runDAW() {
        Platform.runLater(() -> {
            try {
                String text = this.applicationCommand.getText();
                if (OperatingSystem.get() == OperatingSystem.MAC) {
                    String[] cmd = new String[]{"open", text};
                    new ProcessBuilder(cmd).start();
                } else {
                    new ProcessBuilder(text).start();
                }
            }
            catch (IOException ex) {
                this.logModel.addLogMessage(ex.getLocalizedMessage());
            }
        });
    }

    private void message(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(null);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.initOwner((Window)this.stage);
        alert.showAndWait();
    }

    private void startupInfrastructure() {
        this.startOSCCommunication();
        this.startFlushTimer();
        try {
            Midi.readDeviceMetadata();
        }
        catch (MidiUnavailableException ex) {
            this.logModel.addLogMessage(ex.getLocalizedMessage());
        }
        this.instanceManager.load(this.mainConfiguration);
        ObservableList items = this.controllerList.getItems();
        items.setAll(this.instanceManager.getInstances());
        if (!items.isEmpty()) {
            this.controllerList.getSelectionModel().select(0);
        }
        if (this.oscServer.getIsServerRunningProperty().get()) {
            this.startControllers();
        }
    }

    private void startControllers() {
        this.instanceManager.startAll();
        this.sendRefreshCommand();
    }

    private void restartControllers() {
        this.instanceManager.stopAll();
        this.startControllers();
    }

    void flushToController() {
        this.instanceManager.flushAll();
    }

    private void startFlushTimer() {
        this.animationTimer = new AnimationTimer(){

            public void handle(long now) {
                TransformatorApplication.this.flushToController();
            }
        };
        this.animationTimer.start();
    }

    private void startOSCCommunication() {
        this.oscServer.connect("0.0.0.0", this.mainConfiguration.getTcpPort());
    }

    public void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ex) {
            this.logModel.addLogMessage("Could not close socket: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public void handle(OSCMessage message) {
        Object val;
        String address = message.getAddress();
        List arguments = message.getArguments();
        String argument = null;
        if (arguments != null && !arguments.isEmpty() && (val = arguments.get(0)) != null) {
            argument = val.toString();
        }
        if (address.contains("inipath")) {
            this.loadINIFiles(argument);
        } else {
            this.instanceManager.parseAll(address, argument);
        }
    }

    @Override
    public void sendOSC(String command, Object value) {
        OSCMessage message = this.createOSCMessage(command, value);
        StringBuilder msg = new StringBuilder();
        msg.append(message.getAddress());
        for (Object arg : message.getArguments()) {
            msg.append(' ').append(arg.toString());
        }
        this.oscServer.sendMessage(msg.toString());
    }

    @Override
    public void invokeAction(String id) {
        if ("slice_to_multi_sampler_track".equals(id) || "slice_to_drum_track".equals(id)) {
            this.invokeAction(40760);
        } else {
            this.sendOSC("/action_ex", id);
        }
    }

    @Override
    public void invokeAction(int id) {
        this.sendOSC("/action", id);
    }

    @Override
    public boolean isConnected() {
        return this.oscServer.getIsClientConnectedProperty().get();
    }

    private OSCMessage createOSCMessage(String command, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (value != null) {
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                if (value.toString().endsWith(".0")) {
                    values.add(doubleValue.intValue());
                } else {
                    values.add(Float.valueOf(doubleValue.floatValue()));
                }
            } else if (value instanceof Integer) {
                values.add(value);
            } else if (value instanceof Boolean) {
                values.add((Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0));
            } else if (value instanceof String) {
                values.add(value);
            } else {
                this.logModel.addLogMessage("Unsupported OSC type: " + value.getClass().toString());
            }
        }
        return new OSCMessage(command, values);
    }

    private void applyTCPPort() {
        int newPort = Integer.parseInt(this.tcpPortField.getText());
        this.mainConfiguration.setTcpPort(newPort);
        this.startOSCCommunication();
        if (this.oscServer.getIsServerRunningProperty().get()) {
            this.restartControllers();
        }
    }

    private void removeController() {
        int selectedIndex = this.controllerList.getSelectionModel().getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.controllerList.getItems().remove(selectedIndex);
        this.instanceManager.remove(selectedIndex);
    }

    private void editController() {
        int selectedIndex = this.controllerList.getSelectionModel().getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.instanceManager.edit(selectedIndex);
        this.restartControllers();
    }

    private void sendRefreshCommand() {
        if (this.isConnected()) {
            this.sendOSC("/refresh", null);
        } else {
            this.executor.schedule(this::sendRefreshCommand, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void configureAddButton(MenuButton addButton) {
        ObservableList items = addButton.getItems();
        IControllerDefinition[] definitions = this.instanceManager.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            MenuItem item = new MenuItem(definitions[i].toString());
            int index = i++;
            item.setOnAction(event -> {
                if (this.instanceManager.isInstantiated(index)) {
                    this.logModel.addLogMessage("Only one instance of a controller type is supported!");
                    return;
                }
                IControllerInstance inst = this.instanceManager.instantiate(index);
                this.controllerList.getItems().add((Object)inst);
                this.controllerList.getSelectionModel().select((Object)inst);
                inst.start();
                this.sendRefreshCommand();
            });
            items.add((Object)item);
        }
    }

    private void createDefaultMenuItems(TextInputControl t) {
        MenuItem selectAll = new MenuItem("Select All");
        selectAll.setOnAction(e -> t.selectAll());
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(e -> t.copy());
        MenuItem clear = new MenuItem("Clear");
        clear.setOnAction(e -> this.logModel.clearLogMessage());
        BooleanBinding emptySelection = Bindings.createBooleanBinding(() -> t.getSelection().getLength() == 0, (Observable[])new Observable[]{t.selectionProperty()});
        copy.disableProperty().bind((ObservableValue)emptySelection);
        t.setContextMenu(new ContextMenu(new MenuItem[]{copy, clear, new SeparatorMenuItem(), selectAll}));
    }

    private final void loadINIFiles(String path) {
        this.logModel.addLogMessage("Loading device INI files from " + path + " ...");
        DeviceManager.get().loadINIFiles(path, this.logModel);
    }

    private void addAppToTray() {
        this.tray = SystemTray.getSystemTray();
        InputStream rs = ClassLoader.getSystemResourceAsStream("images/AppIcon.gif");
        if (rs == null) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(rs);
            this.trayIcon = new TrayIcon(image);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(event -> Platform.runLater(this::showStage));
            java.awt.MenuItem openItem = new java.awt.MenuItem("Open");
            openItem.addActionListener(event -> Platform.runLater(this::showStage));
            Font defaultFont = Font.decode(null);
            openItem.setFont(defaultFont.deriveFont(1));
            java.awt.MenuItem exitItem = new java.awt.MenuItem("Exit");
            exitItem.addActionListener(event -> this.exit());
            PopupMenu popup = new PopupMenu();
            popup.add(openItem);
            popup.addSeparator();
            popup.add(exitItem);
            this.trayIcon.setPopupMenu(popup);
            this.tray.add(this.trayIcon);
        }
        catch (AWTException | IOException ex) {
            this.logModel.addLogMessage("Unable to init system tray");
        }
    }

    private void showStage() {
        if (this.stage == null) {
            return;
        }
        this.stage.show();
        this.stage.toFront();
    }
}

