/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator;

import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.transformator.util.PropertiesEx;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class MainConfiguration
extends PropertiesEx {
    private static final long serialVersionUID = 2863435764890303358L;
    private static final String CONFIG_FILENAME = "DrivenByMoss4Reaper.config";
    private static final String TAG_PREVIEW = "PREVIEW";
    private static final String TAG_DAW_COMMAND = "DAW_COMMAND";
    private static final String TAG_RUN_AUTOMATICALLY = "RUN_AUTOMATICALLY";
    private static final String TAG_TCP_PORT = "TCP_PORT";
    private static final String DEFAULT_REAPER_PATH_WINDOWS = "C:\\Program Files\\REAPER (x64)\\reaper.exe";
    private static final String DEFAULT_REAPER_PATH_MAC = "/Applications/REAPER64.app";

    public void load() throws IOException {
        File configFile = new File(CONFIG_FILENAME);
        if (!configFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            this.load(reader);
        }
    }

    public void save() throws IOException {
        File configFile = new File(CONFIG_FILENAME);
        try (FileWriter writer = new FileWriter(configFile);){
            this.store(writer, "");
        }
    }

    public boolean isPreviewEnabled() {
        return this.getBoolean(TAG_PREVIEW, true);
    }

    public void setEnablePreview(boolean enablePreview) {
        this.putBoolean(TAG_PREVIEW, enablePreview);
    }

    public String getApplicationCommand() {
        return this.getString(TAG_DAW_COMMAND, this.getDefaultApplicationPath());
    }

    public void setApplicationCommand(String applicationCommand) {
        this.putString(TAG_DAW_COMMAND, applicationCommand);
    }

    public boolean isRunAutomatically() {
        return this.getBoolean(TAG_RUN_AUTOMATICALLY, true);
    }

    public void setRunAutomatically(boolean runAutomatically) {
        this.putBoolean(TAG_RUN_AUTOMATICALLY, runAutomatically);
    }

    public int getTcpPort() {
        return this.getInt(TAG_TCP_PORT, 1200);
    }

    public void setTcpPort(int tcpPort) {
        this.putInt(TAG_TCP_PORT, tcpPort);
    }

    protected String getDefaultApplicationPath() {
        switch (OperatingSystem.get()) {
            case WINDOWS: {
                return DEFAULT_REAPER_PATH_WINDOWS;
            }
            case MAC: {
                return DEFAULT_REAPER_PATH_MAC;
            }
        }
        return "";
    }
}

