/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.transformator;

import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.configuration.SettingsUI;
import de.mossgrabers.reaper.framework.configuration.TitledSeparator;
import de.mossgrabers.transformator.midi.Midi;
import de.mossgrabers.transformator.util.LogModel;
import java.awt.Toolkit;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;

public class ConfigurationDialog
extends Dialog<Void> {
    private List<ComboBox<MidiDevice>> midiInputs;
    private List<ComboBox<MidiDevice>> midiOutputs;
    private final LogModel model;

    /*
     * WARNING - void declaration
     */
    public ConfigurationDialog(LogModel model, Window owner, ISettingsUI settings) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle("Configuration");
        this.initOwner(owner);
        this.model = model;
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getButtonTypes().add((Object)new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE));
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        ScrollPane scrollPane = new ScrollPane((Node)grid);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setMaxHeight(Math.min(800.0, Toolkit.getDefaultToolkit().getScreenSize().getHeight()));
        dialogPane.setContent((Node)new BorderPane((Node)scrollPane));
        int count = 2;
        grid.add((Node)new TitledSeparator("Midi Ports"), 1, 1, 2, 1);
        SettingsUI settingsImpl = (SettingsUI)settings;
        int index = 1;
        List<MidiDevice> inputDevices = Midi.getInputDevices();
        this.midiInputs = settingsImpl.createMidiInputWidgets();
        for (ComboBox<MidiDevice> comboBox : this.midiInputs) {
            grid.add((Node)new Label("Midi Input " + index), 1, count);
            grid.add(comboBox, 2, count);
            comboBox.getItems().setAll(inputDevices);
            MidiDevice midiDevice = settingsImpl.getSelectedMidiInput(index - 1);
            if (midiDevice != null) {
                comboBox.getSelectionModel().select((Object)midiDevice);
            }
            ++index;
            ++count;
        }
        index = 1;
        List<MidiDevice> outputDevices = Midi.getOutputDevices();
        this.midiOutputs = settingsImpl.createMidiOutputWidgets();
        for (ComboBox<MidiDevice> comboBox : this.midiOutputs) {
            grid.add((Node)new Label("Midi Output " + index), 1, count);
            grid.add(comboBox, 2, count);
            comboBox.getItems().setAll(outputDevices);
            MidiDevice selectedDevice = settingsImpl.getSelectedMidiOutput(index - 1);
            if (selectedDevice != null) {
                comboBox.getSelectionModel().select((Object)selectedDevice);
            }
            ++index;
            ++count;
        }
        this.updateMidiDevices();
        Button button = new Button("Rescan Midi Devices");
        button.setOnAction(event -> this.updateMidiDevices());
        button.setMaxWidth(Double.MAX_VALUE);
        grid.add((Node)button, 2, count);
        ++count;
        Object var13_18 = null;
        for (IfxSetting<?> s : settingsImpl.getSettings()) {
            void var13_19;
            if (var13_19 != s.getCategory()) {
                String string = s.getCategory();
                grid.add((Node)new TitledSeparator(string), 1, count, 2, 1);
                ++count;
            }
            Label label = s.getLabelWidget();
            Control widget = s.getWidget();
            label.setLabelFor((Node)widget);
            grid.add((Node)label, 1, count);
            grid.add((Node)widget, 2, count);
            ++count;
        }
    }

    void updateMidiDevices() {
        new Thread(this::delayedUpdateMidiDevices).start();
    }

    void delayedUpdateMidiDevices() {
        try {
            Midi.readDeviceMetadata();
            List<MidiDevice> inputDevices = Midi.getInputDevices();
            List<MidiDevice> outputDevices = Midi.getOutputDevices();
            for (ComboBox<MidiDevice> in : this.midiInputs) {
                in.getItems().setAll(inputDevices);
            }
            for (ComboBox<MidiDevice> out : this.midiOutputs) {
                out.getItems().setAll(outputDevices);
            }
        }
        catch (MidiUnavailableException ex) {
            this.model.addLogMessage(ex.getLocalizedMessage());
        }
    }
}

