/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.usb;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.usb.IUSBAsyncCallback;
import de.mossgrabers.framework.usb.IUSBEndpoint;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.Transfer;

public class USBEndpointImpl
implements IUSBEndpoint {
    private IHost host;
    private DeviceHandle handle;
    private byte endpointAddress;

    public USBEndpointImpl(IHost host, DeviceHandle handle, byte endpointAddress) {
        this.host = host;
        this.handle = handle;
        this.endpointAddress = endpointAddress;
    }

    @Override
    public void send(IMemoryBlock memoryBlock, int timeout) {
        IntBuffer transfered = IntBuffer.allocate(1);
        int result = LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)memoryBlock.createByteBuffer(), (IntBuffer)transfered, (long)timeout);
        if (result != 0 && (result = LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)memoryBlock.createByteBuffer(), (IntBuffer)transfered, (long)timeout)) != 0) {
            this.host.error("USB transmission error: " + result);
        }
    }

    @Override
    public void sendAsync(IMemoryBlock memoryBlock, IUSBAsyncCallback callback, int timeout) {
        Transfer transfer = LibUsb.allocTransfer();
        LibUsb.fillBulkTransfer((Transfer)transfer, (DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)memoryBlock.createByteBuffer(), result -> {
            int status = result.status();
            if (status != 0) {
                this.host.error("USB receive error: " + status);
            }
            callback.process(status == 0 ? result.actualLength() : -1);
            LibUsb.freeTransfer((Transfer)result);
        }, null, (long)timeout);
        int result2 = LibUsb.submitTransfer((Transfer)transfer);
        if (result2 != 0) {
            this.host.error("Unable to submit USB async transfer: " + result2);
        }
    }
}

