/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.usb;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.usb.IUSBDevice;
import de.mossgrabers.framework.usb.IUSBEndpoint;
import de.mossgrabers.framework.usb.USBMatcher;
import de.mossgrabers.reaper.framework.usb.USBEndpointImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class USBDeviceImpl
implements IUSBDevice {
    private IHost host;
    private DeviceHandle handle;
    private USBMatcher usbMatcher;
    private List<Byte> interfaces = new ArrayList<Byte>();

    public USBDeviceImpl(IHost host, USBMatcher usbMatcher) {
        this.host = host;
        this.usbMatcher = usbMatcher;
        this.handle = USBDeviceImpl.openDeviceWithVidPid(usbMatcher.getVendor(), usbMatcher.getProductID());
        if (this.handle == null) {
            host.error("USB Device not found.", (Exception)new LibUsbException(-4));
        }
    }

    @Override
    public void release() {
        if (this.handle == null) {
            return;
        }
        DeviceHandle h = this.handle;
        this.handle = null;
        for (Byte interf : this.interfaces) {
            int result = LibUsb.releaseInterface((DeviceHandle)h, (int)interf.byteValue());
            if (result == 0) continue;
            this.host.error("Unable to release interface", (Exception)new LibUsbException(result));
        }
        LibUsb.close((DeviceHandle)h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeviceHandle openDeviceWithVidPid(short vendorId, short productId) {
        DeviceList list = new DeviceList();
        int result = LibUsb.getDeviceList(null, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list.", result);
        }
        try {
            Iterator iterator = list.iterator();
            LibUsbException ex = null;
            while (iterator.hasNext()) {
                DeviceDescriptor descriptor;
                Device device = (Device)iterator.next();
                result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) {
                    ex = new LibUsbException("Unable to read device descriptor.", result);
                    continue;
                }
                if (descriptor.idVendor() != vendorId || descriptor.idProduct() != productId) continue;
                DeviceHandle handle = new DeviceHandle();
                result = LibUsb.open((Device)device, (DeviceHandle)handle);
                if (result != 0) {
                    ex = new LibUsbException("Unable to read device descriptor.", result);
                    continue;
                }
                DeviceHandle deviceHandle = handle;
                return deviceHandle;
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        return null;
    }

    @Override
    public IUSBEndpoint getEndpoint(int interfaceIndex, int endpointIndex) {
        if (this.handle == null) {
            return null;
        }
        List<USBMatcher.EndpointMatcher> endpoints = this.usbMatcher.getEndpoints();
        USBMatcher.EndpointMatcher endpointMatcher = endpoints.get(interfaceIndex);
        byte interfaceNumber = endpointMatcher.getInterfaceNumber();
        int result = LibUsb.claimInterface((DeviceHandle)this.handle, (int)interfaceNumber);
        if (result != 0) {
            this.host.error("Unable to claim interface.", (Exception)new LibUsbException(result));
            return null;
        }
        this.interfaces.add(interfaceNumber);
        return new USBEndpointImpl(this.host, this.handle, endpointMatcher.getEndpointAddresses()[endpointIndex]);
    }
}

