/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.osc;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPortOut;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class OpenSoundControlServerImpl
implements IOpenSoundControlServer {
    private OSCPortOut connection;

    public OpenSoundControlServerImpl(OSCPortOut connection) {
        this.connection = connection;
    }

    @Override
    public void sendMessage(IOpenSoundControlMessage message) throws IOException {
        if (this.connection == null) {
            return;
        }
        String address = message.getAddress();
        Object[] values = message.getValues();
        this.connection.send((OSCPacket)new OSCMessage(address, Arrays.asList(values)));
    }

    @Override
    public void sendBundle(List<IOpenSoundControlMessage> messages) throws IOException {
        int pos = 0;
        OSCBundle oscBundle = new OSCBundle();
        for (IOpenSoundControlMessage message : messages) {
            String address = message.getAddress();
            Object[] values = message.getValues();
            oscBundle.addPacket((OSCPacket)new OSCMessage(address, Arrays.asList(values)));
            if (++pos <= 1000) continue;
            pos = 0;
            this.connection.send((OSCPacket)oscBundle);
            oscBundle = new OSCBundle();
        }
        if (!oscBundle.getPackets().isEmpty()) {
            this.connection.send((OSCPacket)oscBundle);
        }
    }
}

