/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.transformator.midi.MidiConnection;

class MidiOutputImpl
implements IMidiOutput {
    private MidiConnection midiConnection;

    public MidiOutputImpl(MidiConnection midiConnection) {
        this.midiConnection = midiConnection;
    }

    @Override
    public void sendCC(int cc, int value) {
        this.midiConnection.sendCC(cc, value);
    }

    @Override
    public void sendCCEx(int channel, int cc, int value) {
        this.midiConnection.sendRaw(176 + channel, cc, value);
    }

    @Override
    public void sendNote(int note, int velocity) {
        this.midiConnection.sendNote(0, note, velocity);
    }

    @Override
    public void sendNoteEx(int channel, int note, int velocity) {
        this.midiConnection.sendNote(channel, note, velocity);
    }

    @Override
    public void sendChannelAftertouch(int data1, int data2) {
        this.midiConnection.sendRaw(208, data1, data2);
    }

    @Override
    public void sendChannelAftertouch(int channel, int data1, int data2) {
        this.midiConnection.sendRaw(208 + channel, data1, data2);
    }

    @Override
    public void sendPitchbend(int data1, int data2) {
        this.midiConnection.sendRaw(224, data1, data2);
    }

    @Override
    public void sendPitchbend(int channel, int data1, int data2) {
        this.midiConnection.sendRaw(224 + channel, data1, data2);
    }

    @Override
    public void sendSysex(byte[] data) {
        this.midiConnection.sendSysex(data);
    }

    @Override
    public void sendSysex(String data) {
        this.midiConnection.sendSysex(data);
    }

    @Override
    public void sendIdentityRequest() {
        this.sendSysex("F0 7E 7F 06 01 F7");
    }
}

