/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.MidiShortCallback;
import de.mossgrabers.framework.daw.midi.MidiSysExCallback;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.midi.MidiConnection;
import java.util.HashSet;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

class MidiInputImpl
implements IMidiInput {
    private final IHost host;
    private final MessageSender sender;
    private final MidiConnection midiConnection;
    private final MidiDevice device;
    private MidiShortCallback shortCallback;
    private MidiSysExCallback sysexCallback;
    private Integer[] keyTranslationTable;
    private Integer[] velocityTranslationTable;
    private Set<String> filters = new HashSet<String>();

    public MidiInputImpl(IHost host, MessageSender sender, MidiConnection midiConnection, MidiDevice device) {
        this.host = host;
        this.sender = sender;
        this.midiConnection = midiConnection;
        this.device = device;
        this.midiConnection.setInput(this.device, (message, timeStamp) -> this.handleMidiMessage(message));
    }

    @Override
    public void createNoteInput(String name, String ... filters) {
        if (filters.length == 0) {
            this.filters.add("90");
            this.filters.add("80");
            return;
        }
        for (String filter : filters) {
            this.filters.add(filter.replace('?', ' ').trim());
        }
    }

    @Override
    public void setMidiCallback(MidiShortCallback callback) {
        this.shortCallback = callback;
    }

    @Override
    public void setSysexCallback(MidiSysExCallback callback) {
        this.sysexCallback = callback;
    }

    @Override
    public void setKeyTranslationTable(Integer[] table) {
        this.keyTranslationTable = table;
    }

    @Override
    public void setVelocityTranslationTable(Integer[] table) {
        this.velocityTranslationTable = table;
    }

    @Override
    public void toggleRepeat() {
        this.sender.sendOSC("/track/1/noterepeat", 1);
    }

    @Override
    public void sendRawMidiEvent(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 160: 
            case 208: {
                this.sender.sendOSC("/vkb_midi/" + channel + "/aftertouch/" + data1, data2);
                break;
            }
            case 176: {
                this.sender.sendOSC("/vkb_midi/" + channel + "/cc/" + data1, data2);
                break;
            }
            case 192: {
                this.sender.sendOSC("/vkb_midi/" + channel + "/program", data1);
                break;
            }
            case 224: {
                this.sender.sendOSC("/vkb_midi/" + channel + "/pitch", data2 * 128 + data1);
                break;
            }
            case 128: 
            case 144: {
                this.sender.sendOSC("/vkb_midi/" + channel + "/note/" + data1, data2);
                break;
            }
            default: {
                this.host.println("sendRawMidiEvent not implemented for status: " + status);
            }
        }
    }

    private void handleMidiMessage(MidiMessage message) {
        if (message instanceof SysexMessage) {
            this.handleSysexMessage((SysexMessage)message);
            return;
        }
        byte[] msg = message.getMessage();
        if (msg.length != 3) {
            return;
        }
        byte status = msg[0];
        byte data1 = msg[1];
        byte data2 = msg[2];
        String statusHex = StringUtils.toHexStr(Byte.toUnsignedInt(status));
        boolean sendThru = this.filters.contains(statusHex);
        if (!sendThru) {
            sendThru = this.filters.contains(statusHex + StringUtils.toHexStr(data1));
        }
        if (sendThru) {
            int code = status & 0xF0;
            switch (code) {
                case 128: 
                case 144: {
                    int key = this.translateKey(data1);
                    if (key < 0) break;
                    this.sendRawMidiEvent(status, key, code == 128 ? 0 : this.translateVelocity(data2));
                    break;
                }
                default: {
                    this.sendRawMidiEvent(status, data1, data2);
                }
            }
        }
        if (this.shortCallback != null) {
            this.shortCallback.handleMidi(status, data1, data2);
        }
    }

    private void handleSysexMessage(SysexMessage sysexMessage) {
        if (this.sysexCallback == null) {
            return;
        }
        StringBuilder dataString = new StringBuilder("F0");
        for (byte data : sysexMessage.getData()) {
            dataString.append(String.format("%02x", data & 0xFF));
        }
        this.sysexCallback.handleMidi(dataString.toString().toUpperCase());
    }

    private int translateKey(int key) {
        return this.keyTranslationTable == null ? key : this.keyTranslationTable[key];
    }

    private int translateVelocity(int velocity) {
        return this.velocityTranslationTable == null ? velocity : this.velocityTranslationTable[velocity];
    }
}

