/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import de.mossgrabers.framework.graphics.IImage;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.xml.sax.SAXException;

public class SVGImage
implements IImage {
    private static final Map<String, Map<Color, SVGImage>> CACHE = new HashMap<String, Map<Color, SVGImage>>();
    private static final Object CACHE_LOCK = new Object();
    private final BufferedImage bufferedImage;
    private final String imageName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVGImage getSVGImage(String imageName, Color color) throws IOException {
        SVGImage svgImage;
        Object object = CACHE_LOCK;
        synchronized (object) {
            Map<Color, SVGImage> images = CACHE.get(imageName);
            if (images == null) {
                images = new HashMap<Color, SVGImage>();
                CACHE.put(imageName, images);
            }
            if ((svgImage = images.get(color)) == null) {
                svgImage = new SVGImage(imageName, color);
                images.put(color, svgImage);
            }
        }
        return svgImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            CACHE.clear();
        }
    }

    public SVGImage(String imageName, Color color) throws IOException {
        this.imageName = imageName;
        BufferedImageTranscoder trans = new BufferedImageTranscoder();
        try (InputStream file = this.getClass().getResourceAsStream(imageName);){
            Document doc = this.loadDocument(file, color);
            trans.transcode(new TranscoderInput(doc), null);
            this.bufferedImage = trans.getBufferedImage();
        }
        catch (ParserConfigurationException | TranscoderException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }

    public String getImageName() {
        return this.imageName;
    }

    public Document loadDocument(InputStream inputStream, Color color) throws SAXException, IOException, ParserConfigurationException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGDocument document = f.createSVGDocument("xxx", inputStream);
        SVGImage.changeColorOfElement(color, document, "polygon");
        SVGImage.changeColorOfElement(color, document, "circle");
        SVGImage.changeColorOfElement(color, document, "path");
        SVGImage.changeColorOfElement(color, document, "rect");
        return document;
    }

    private static void changeColorOfElement(Color color, SVGDocument document, String elementName) {
        NodeList nodes = document.getElementsByTagName(elementName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof SVGElement)) continue;
            SVGElement element = (SVGElement)nodes.item(i);
            element.setAttribute("fill", SVGImage.toText(color));
        }
    }

    private static final String toText(Color color) {
        return new StringBuilder(20).append("rgb(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(')').toString();
    }

    @Override
    public double getWidth() {
        return this.getImage().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getImage().getHeight();
    }

    public class BufferedImageTranscoder
    extends ImageTranscoder {
        private BufferedImage img;

        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput to) throws TranscoderException {
            this.img = img;
        }

        public BufferedImage getBufferedImage() {
            return this.img;
        }
    }
}

