/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.transformator.util.FontCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class GraphicsContextImpl
implements IGraphicsContext {
    private static final FontCache FONT_CACHE = new FontCache();
    private Graphics2D gc;

    public GraphicsContextImpl(Graphics2D gc) {
        GraphicsContextImpl.configureGraphics(gc);
        this.gc = gc;
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, ColorEx color) {
        this.setColor(color);
        this.gc.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    @Override
    public void fillRectangle(double x, double y, double width, double height, ColorEx color) {
        this.setColor(color);
        this.gc.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void strokeRectangle(double x, double y, double width, double height, ColorEx color) {
        this.setColor(color);
        this.gc.drawRect((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void fillRoundedRectangle(double left, double top, double width, double height, double radius, ColorEx fillColor) {
        this.setColor(fillColor);
        int arcHeight = (int)(radius * 2.5);
        this.gc.fillRoundRect((int)left, (int)top, (int)width, (int)height, arcHeight, arcHeight);
    }

    @Override
    public void fillGradientRoundedRectangle(double left, double top, double width, double height, double radius, ColorEx color1, ColorEx color2) {
        Paint oldPaint = this.gc.getPaint();
        this.gc.setPaint(new GradientPaint((int)left, (int)(top + 1.0), GraphicsContextImpl.convertColor(color1), (int)left, (int)(top + height), GraphicsContextImpl.convertColor(color2)));
        int arcHeight = (int)(radius * 2.5);
        this.gc.fillRoundRect((int)left, (int)top, (int)width, (int)height, arcHeight, arcHeight);
        this.gc.setPaint(oldPaint);
    }

    @Override
    public void fillTriangle(double x1, double y1, double x2, double y2, double x3, double y3, ColorEx lineColor) {
        this.setColor(lineColor);
        this.gc.fillPolygon(new int[]{(int)x1, (int)x2, (int)x3}, new int[]{(int)y1, (int)y2, (int)y3}, 3);
    }

    @Override
    public void drawTextInBounds(String text, double x, double y, double width, double height, Align alignment, ColorEx color, double fontSize) {
        int pos;
        if (text == null || text.length() == 0) {
            return;
        }
        this.setColor(color);
        this.gc.setFont(FONT_CACHE.getFont((int)fontSize));
        Dimension dim = this.getTextDims(text);
        this.gc.clipRect((int)x, (int)y, (int)width, (int)height);
        switch (alignment) {
            case LEFT: {
                pos = (int)x;
                break;
            }
            default: {
                pos = (int)(x + (width - (double)dim.width) / 2.0);
            }
        }
        double textDescent = this.getTextDescent(text);
        this.gc.drawString(text, pos, (int)(y + height - (height - (double)dim.height) / 2.0 - textDescent));
        this.gc.setClip(null);
    }

    @Override
    public void drawTextInHeight(String text, double x, double y, double height, ColorEx color, double fontSize) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.setColor(color);
        this.gc.setFont(FONT_CACHE.getFont((int)fontSize));
        Dimension dim = this.getTextDims(text);
        this.gc.drawString(text, (int)x, (int)(y + height - (height - (double)dim.height) / 2.0 - (double)this.getTextDescent("Hg")));
    }

    @Override
    public void drawImage(IImage image, double x, double y) {
        this.gc.drawImage((Image)((SVGImage)image).getImage(), (int)x, (int)y, null);
    }

    @Override
    public void maskImage(IImage image, double x, double y, ColorEx maskColor) {
        SVGImage svgImage = (SVGImage)image;
        try {
            svgImage = SVGImage.getSVGImage(svgImage.getImageName(), GraphicsContextImpl.convertColor(maskColor));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gc.drawImage((Image)svgImage.getImage(), (int)x, (int)y, null);
    }

    @Override
    public double calculateFontSize(double maxHeight, double maxWidth) {
        String maxString = "G#5";
        double minSize = 12.0;
        double fittingSize = -1.0;
        for (double size = 12.0; size < maxHeight; size += 1.0) {
            this.gc.setFont(FONT_CACHE.getFont((int)size));
            double width = this.getTextDims("G#5").getWidth();
            if (width > maxWidth) break;
            fittingSize = size;
        }
        return fittingSize;
    }

    private static void configureGraphics(Graphics2D gc) {
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gc.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public Dimension getTextDims(String text) {
        FontMetrics fm = this.gc.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, this.gc);
        LineMetrics lm = fm.getFont().getLineMetrics(text, this.gc.getFontRenderContext());
        double width = bounds.getWidth();
        bounds.setRect(bounds.getX(), bounds.getY(), width, lm.getHeight());
        return new Dimension((int)Math.round(width), (int)Math.round(bounds.getHeight()));
    }

    public int getTextDescent(String text) {
        return Math.round(this.gc.getFont().getLineMetrics(text, this.gc.getFontRenderContext()).getDescent());
    }

    protected void setColor(ColorEx color) {
        this.gc.setColor(GraphicsContextImpl.convertColor(color));
    }

    private static Color convertColor(ColorEx color) {
        return new Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
    }
}

