/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IRenderer;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import javafx.animation.AnimationTimer;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Window;

public class BitmapImpl
extends Dialog<Void>
implements IBitmap {
    private final BufferedImage bufferedImage;
    private final Canvas canvas = new Canvas();
    private final AnimationTimer animationTimer;
    private WritableImage fxImage = null;

    public BitmapImpl(Window owner, int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.initModality(Modality.NONE);
        this.initOwner(owner);
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getButtonTypes().add((Object)new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE));
        this.canvas.widthProperty().set((double)width);
        this.canvas.heightProperty().set((double)height);
        StackPane canvasContainer = new StackPane(new Node[]{this.canvas});
        canvasContainer.getStyleClass().add((Object)"display");
        dialogPane.setContent((Node)canvasContainer);
        this.animationTimer = new AnimationTimer(){

            public void handle(long now) {
                BitmapImpl.this.updateDisplay();
            }
        };
        this.setOnHidden(event -> this.animationTimer.stop());
    }

    @Override
    public void fillTransferBuffer(ByteBuffer buffer) {
        int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        int height = this.bufferedImage.getHeight();
        int width = this.bufferedImage.getWidth();
        for (int y = 0; y < height; ++y) {
            int x;
            for (x = 0; x < width; ++x) {
                int pixel = pixels[x + y * width];
                int red = ((pixel & 0xFF0000) >> 16) * 31 / 255;
                int green = ((pixel & 0xFF00) >> 8) * 63 / 255;
                int blue = (pixel & 0xFF) * 31 / 255;
                buffer.put((byte)((green & 7) << 5 | red & 0x1F));
                buffer.put((byte)((blue & 0x1F) << 3 | (green & 0x38) >> 3));
            }
            for (x = 0; x < 128; ++x) {
                buffer.put((byte)0);
            }
        }
        buffer.rewind();
    }

    @Override
    public void setDisplayWindowTitle(String title) {
        this.setTitle(title);
    }

    @Override
    public void showDisplayWindow() {
        if (this.isShowing()) {
            return;
        }
        this.show();
        this.animationTimer.start();
    }

    @Override
    public void render(IRenderer renderer) {
        renderer.render(new GraphicsContextImpl(this.bufferedImage.createGraphics()));
    }

    void updateDisplay() {
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        this.fxImage = SwingFXUtils.toFXImage((BufferedImage)this.bufferedImage, (WritableImage)this.fxImage);
        gc.drawImage((Image)this.fxImage, 0.0, 0.0, this.canvas.getWidth(), this.canvas.getWidth() / 6.0);
    }
}

