/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;

public class DeviceTypeFilterColumn
extends BaseColumn {
    public DeviceTypeFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Device Type", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTypeBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceType.values().length;
    }

    private class DeviceTypeBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTypeBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            DeviceType[] values = DeviceType.values();
            return this.index < values.length ? values[this.index].getName() : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceTypeFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            if (this.index < 0) {
                return DeviceManager.get().getNumDevices();
            }
            DeviceType[] values = DeviceType.values();
            return this.index < values.length ? DeviceManager.get().filterByType(values[this.index]).size() : 0;
        }
    }
}

