/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;

public class DeviceTagsFilterColumn
extends BaseColumn {
    public DeviceTagsFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Tags", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTagsBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return 0;
    }

    private class DeviceTagsBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTagsBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            return "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceTagsFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            if (this.index < 0) {
                return DeviceManager.get().getNumDevices();
            }
            return 0;
        }
    }
}

