/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceLocation;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;

public class DeviceLocationFilterColumn
extends BaseColumn {
    public DeviceLocationFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Location", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceLocationBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceLocation.values().length;
    }

    private class DeviceLocationBrowserColumnItem
    extends BaseColumnItem {
        public DeviceLocationBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            DeviceLocation[] values = DeviceLocation.values();
            return this.index < values.length ? values[this.index].getName() : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceLocationFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            if (this.index < 0) {
                return DeviceManager.get().getNumDevices();
            }
            DeviceLocation[] values = DeviceLocation.values();
            return this.index < values.length ? DeviceManager.get().filterByLocation(values[this.index]).size() : 0;
        }
    }
}

