/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;

public class DeviceFileTypeFilterColumn
extends BaseColumn {
    public DeviceFileTypeFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "File Type", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTypeBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceFileType.values().length;
    }

    private class DeviceTypeBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTypeBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            DeviceFileType[] values = DeviceFileType.values();
            return this.index < values.length ? values[this.index].getName() : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceFileTypeFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            if (this.index < 0) {
                return DeviceManager.get().getNumDevices();
            }
            DeviceFileType[] values = DeviceFileType.values();
            return this.index < values.length ? DeviceManager.get().filterByFileType(values[this.index]).size() : 0;
        }
    }
}

