/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.ArrayList;

public class DeviceCreatorFilterColumn
extends BaseColumn {
    public DeviceCreatorFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Creator", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceVendorBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceManager.get().getVendors().size();
    }

    private class DeviceVendorBrowserColumnItem
    extends BaseColumnItem {
        public DeviceVendorBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            return this.index < DeviceCreatorFilterColumn.this.getMaxNumItems() ? new ArrayList<String>(DeviceManager.get().getVendors()).get(this.index) : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceCreatorFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.index < 0) {
                return deviceManager.getNumDevices();
            }
            return this.index < DeviceCreatorFilterColumn.this.getMaxNumItems() ? deviceManager.filterByVendor(new ArrayList<String>(deviceManager.getVendors()).get(this.index)).size() : 0;
        }
    }
}

