/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;

public class DeviceCollectionFilterColumn
extends BaseColumn {
    public DeviceCollectionFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Collection", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceFolderBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceManager.get().getCollections().size();
    }

    private class DeviceFolderBrowserColumnItem
    extends BaseColumnItem {
        public DeviceFolderBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            return this.index < DeviceCollectionFilterColumn.this.getMaxNumItems() ? DeviceManager.get().getCollections().get(this.index).getName() : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceCollectionFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.index < 0) {
                return deviceManager.getNumDevices();
            }
            return this.index < DeviceCollectionFilterColumn.this.getMaxNumItems() ? deviceManager.filterByCollection(deviceManager.getCollections().get(this.index)).size() : 0;
        }
    }
}

