/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.ArrayList;

public class DeviceCategoryFilterColumn
extends BaseColumn {
    public DeviceCategoryFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Category", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceVendorBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return DeviceManager.get().getCategories().size();
    }

    private class DeviceVendorBrowserColumnItem
    extends BaseColumnItem {
        public DeviceVendorBrowserColumnItem(int index) {
            super(index - 1);
        }

        @Override
        public String getName() {
            if (this.index < 0) {
                return "All";
            }
            return this.index < DeviceCategoryFilterColumn.this.getMaxNumItems() ? new ArrayList<String>(DeviceManager.get().getCategories()).get(this.index) : "";
        }

        @Override
        public boolean isSelected() {
            return this.index + 1 == DeviceCategoryFilterColumn.this.selectedRow;
        }

        @Override
        public int getHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.index < 0) {
                return deviceManager.getNumDevices();
            }
            return this.index < DeviceCategoryFilterColumn.this.getMaxNumItems() ? deviceManager.filterByCategory(new ArrayList<String>(deviceManager.getCategories()).get(this.index)).size() : 0;
        }
    }
}

