/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.StringUtils;

public abstract class BaseColumn
implements IBrowserColumn {
    protected static final String WILDCARD = "All";
    protected final IBrowserColumnItem[] items;
    private final int columnIndex;
    private final String name;
    private final int numItemsPerPage;
    int selectedRow = 0;

    protected BaseColumn(int columnIndex, String name, int numItemsPerPage) {
        this.columnIndex = columnIndex;
        this.name = name;
        this.numItemsPerPage = numItemsPerPage;
        this.items = new IBrowserColumnItem[numItemsPerPage];
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public int getIndex() {
        return this.columnIndex;
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getWildcard() {
        return WILDCARD;
    }

    @Override
    public boolean doesCursorExist() {
        return true;
    }

    @Override
    public String getCursorName() {
        return this.items[this.selectedRow].getName();
    }

    @Override
    public String getCursorName(int limit) {
        return StringUtils.optimizeName(this.getCursorName(), limit);
    }

    @Override
    public IBrowserColumnItem[] getItems() {
        return this.items;
    }

    @Override
    public void scrollItemPageUp() {
        this.setCursorIndex(this.selectedRow - this.numItemsPerPage);
    }

    @Override
    public void scrollItemPageDown() {
        this.setCursorIndex(this.selectedRow + this.numItemsPerPage);
    }

    @Override
    public void resetFilter() {
        this.setCursorIndex(0);
    }

    @Override
    public void selectPreviousItem() {
        this.setCursorIndex(this.selectedRow - 1);
    }

    @Override
    public void selectNextItem() {
        this.setCursorIndex(this.selectedRow + 1);
    }

    @Override
    public int getCursorIndex() {
        return this.selectedRow;
    }

    @Override
    public void setCursorIndex(int index) {
        this.selectedRow = Math.max(0, Math.min(index, this.getMaxNumItems()));
    }

    protected abstract int getMaxNumItems();
}

